import { fromRef } from '../observable/fromRef';
import { snapshotChanges } from './snapshot-changes';
import 'rxjs/add/operator/skipWhile';
import 'rxjs/add/operator/withLatestFrom';
import 'rxjs/add/operator/map';
export function createLoadedChanges(query) {
    return function (events) { return loadedSnapshotChanges(query, events); };
}
export function loadedData(query) {
    return fromRef(query, 'value')
        .map(function (data) {
        var lastKeyToLoad;
        data.payload.forEach(function (child) {
            lastKeyToLoad = child.key;
            return false;
        });
        return { data: data, lastKeyToLoad: lastKeyToLoad };
    });
}
export function waitForLoaded(query, action$) {
    var loaded$ = loadedData(query);
    return loaded$
        .withLatestFrom(action$)
        .map(function (_a) {
        var loaded = _a[0], actions = _a[1];
        var lastKeyToLoad = loaded.lastKeyToLoad;
        var loadedKeys = actions.map(function (snap) { return snap.key; });
        return { actions: actions, lastKeyToLoad: lastKeyToLoad, loadedKeys: loadedKeys };
    })
        .skipWhile(function (meta) { return meta.loadedKeys.indexOf(meta.lastKeyToLoad) === -1; })
        .map(function (meta) { return meta.actions; });
}
export function loadedSnapshotChanges(query, events) {
    var snapChanges$ = snapshotChanges(query, events);
    return waitForLoaded(query, snapChanges$);
}
//# sourceMappingURL=loaded.js.map