import { fromRef } from '../observable/fromRef';
import { Observable } from 'rxjs/Observable';
import { positionFor, positionAfter } from './utils';
import 'rxjs/add/operator/scan';
import 'rxjs/add/observable/merge';
export function listChanges(ref, events) {
    const childEvent$ = events.map(event => fromRef(ref, event));
    return Observable.merge(...childEvent$)
        .scan((current, action) => {
        const { payload, type, prevKey, key } = action;
        switch (action.type) {
            case 'child_added':
                return [...current, action];
            case 'child_removed':
                return current.filter(x => x.payload.key !== payload.key);
            case 'child_changed':
                return current.map(x => x.payload.key === key ? action : x);
            case 'child_moved':
                const curPos = positionFor(current, payload.key);
                if (curPos > -1) {
                    const data = current.splice(curPos, 1)[0];
                    const newPost = positionAfter(current, prevKey);
                    current.splice(newPost, 0, data);
                    return current;
                }
                return current;
            default:
                return current;
        }
    }, []);
}
//# sourceMappingURL=changes.js.map