import { DatabaseQuery, ChildEvent, AngularFireAction, SnapshotAction } from '../interfaces';
import { database } from 'firebase/app';
import { Observable } from 'rxjs/Observable';
import 'rxjs/add/operator/skipWhile';
import 'rxjs/add/operator/withLatestFrom';
import 'rxjs/add/operator/map';
export declare function createLoadedChanges(query: DatabaseQuery): (events?: ChildEvent[]) => Observable<SnapshotAction[]>;
export interface LoadedMetadata {
    data: AngularFireAction<database.DataSnapshot | null>;
    lastKeyToLoad: any;
}
export declare function loadedData(query: DatabaseQuery): Observable<LoadedMetadata>;
export declare function waitForLoaded(query: DatabaseQuery, action$: Observable<SnapshotAction[]>): Observable<AngularFireAction<database.DataSnapshot | null>[]>;
export declare function loadedSnapshotChanges(query: DatabaseQuery, events?: ChildEvent[]): Observable<SnapshotAction[]>;
