import { Observable } from 'rxjs/Observable';
import { observeOn } from 'rxjs/operator/observeOn';
import { ZoneScheduler } from 'angularfire2';
import 'rxjs/add/operator/map';
import 'rxjs/add/operator/delay';
export function fromRef(ref, event, listenType) {
    if (listenType === void 0) { listenType = 'on'; }
    var ref$ = new Observable(function (subscriber) {
        var fn = ref[listenType](event, function (snapshot, prevKey) {
            subscriber.next({ snapshot: snapshot, prevKey: prevKey });
        }, subscriber.error.bind(subscriber));
        return { unsubscribe: function () { ref.off(event, fn); } };
    })
        .map(function (payload) {
        var snapshot = payload.snapshot, prevKey = payload.prevKey;
        var key = null;
        if (snapshot) {
            key = snapshot.key;
        }
        return { type: event, payload: snapshot, prevKey: prevKey, key: key };
    })
        .delay(0);
    return observeOn.call(ref$, new ZoneScheduler(Zone.current));
}
//# sourceMappingURL=fromRef.js.map