import { CloudFunction, Event } from '../cloud-functions';
export declare function database(database?: string): DatabaseBuilder;
export declare function namespace(namespace: string): NamespaceBuilder;
export declare function document(path: string): DocumentBuilder;
export declare class DatabaseBuilder {
    private resource;
    namespace(namespace: string): NamespaceBuilder;
    document(path: string): DocumentBuilder;
}
export declare class NamespaceBuilder {
    private resource;
    document(path: string): DocumentBuilder;
}
export interface DeltaDocumentSnapshot {
    exists: Boolean;
    ref: any;
    id: string;
    createTime: string;
    updateTime: string;
    readTime: string;
    previous: any;
    data: () => any;
    get: (key: string) => any;
}
export declare class DocumentBuilder {
    private resource;
    /** Respond to all document writes (creates, updates, or deletes). */
    onWrite(handler: (event: Event<DeltaDocumentSnapshot>) => PromiseLike<any> | any): CloudFunction<DeltaDocumentSnapshot>;
    /** Respond only to document creations. */
    onCreate(handler: (event: Event<DeltaDocumentSnapshot>) => PromiseLike<any> | any): CloudFunction<DeltaDocumentSnapshot>;
    /** Respond only to document updates. */
    onUpdate(handler: (event: Event<DeltaDocumentSnapshot>) => PromiseLike<any> | any): CloudFunction<DeltaDocumentSnapshot>;
    /** Respond only to document deletions. */
    onDelete(handler: (event: Event<DeltaDocumentSnapshot>) => PromiseLike<any> | any): CloudFunction<DeltaDocumentSnapshot>;
    private onOperation(handler, eventType);
}
