"use strict";
/**
 * Copyright 2015 Google Inc. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/* jshint maxlen: false */
const apirequest_1 = require("../../lib/apirequest");
/**
 * Resource Views API
 *
 * The Resource View API allows users to create and manage logical sets of Google Compute Engine instances.
 *
 * @example
 * const google = require('googleapis');
 * const resourceviews = google.resourceviews('v1beta1');
 *
 * @namespace resourceviews
 * @type {Function}
 * @version v1beta1
 * @variation v1beta1
 * @param {object=} options Options for Resourceviews
 */
function Resourceviews(options) {
    const self = this;
    self._options = options || {};
    self.regionViews = {
        /**
         * resourceviews.regionViews.addresources
         *
         * @desc Add resources to the view.
         *
         * @alias resourceviews.regionViews.addresources
         * @memberOf! resourceviews(v1beta1)
         *
         * @param {object} params Parameters for request
         * @param {string} params.projectName The project name of the resource view.
         * @param {string} params.region The region name of the resource view.
         * @param {string} params.resourceViewName The name of the resource view.
         * @param {resourceviews(v1beta1).RegionViewsAddResourcesRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        addresources: function (params, options, callback) {
            if (typeof options === 'function') {
                callback = options;
                options = {};
            }
            options || (options = {});
            const rootUrl = options.rootUrl || 'https://www.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/resourceviews/v1beta1/projects/{projectName}/regions/{region}/resourceViews/{resourceViewName}/addResources').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST'
                }, options),
                params: params,
                requiredParams: ['projectName', 'region', 'resourceViewName'],
                pathParams: ['projectName', 'region', 'resourceViewName'],
                context: self
            };
            return apirequest_1.default(parameters, callback);
        },
        /**
         * resourceviews.regionViews.delete
         *
         * @desc Delete a resource view.
         *
         * @alias resourceviews.regionViews.delete
         * @memberOf! resourceviews(v1beta1)
         *
         * @param {object} params Parameters for request
         * @param {string} params.projectName The project name of the resource view.
         * @param {string} params.region The region name of the resource view.
         * @param {string} params.resourceViewName The name of the resource view.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete: function (params, options, callback) {
            if (typeof options === 'function') {
                callback = options;
                options = {};
            }
            options || (options = {});
            const rootUrl = options.rootUrl || 'https://www.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/resourceviews/v1beta1/projects/{projectName}/regions/{region}/resourceViews/{resourceViewName}').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'DELETE'
                }, options),
                params: params,
                requiredParams: ['projectName', 'region', 'resourceViewName'],
                pathParams: ['projectName', 'region', 'resourceViewName'],
                context: self
            };
            return apirequest_1.default(parameters, callback);
        },
        /**
         * resourceviews.regionViews.get
         *
         * @desc Get the information of a resource view.
         *
         * @alias resourceviews.regionViews.get
         * @memberOf! resourceviews(v1beta1)
         *
         * @param {object} params Parameters for request
         * @param {string} params.projectName The project name of the resource view.
         * @param {string} params.region The region name of the resource view.
         * @param {string} params.resourceViewName The name of the resource view.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get: function (params, options, callback) {
            if (typeof options === 'function') {
                callback = options;
                options = {};
            }
            options || (options = {});
            const rootUrl = options.rootUrl || 'https://www.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/resourceviews/v1beta1/projects/{projectName}/regions/{region}/resourceViews/{resourceViewName}').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'GET'
                }, options),
                params: params,
                requiredParams: ['projectName', 'region', 'resourceViewName'],
                pathParams: ['projectName', 'region', 'resourceViewName'],
                context: self
            };
            return apirequest_1.default(parameters, callback);
        },
        /**
         * resourceviews.regionViews.insert
         *
         * @desc Create a resource view.
         *
         * @alias resourceviews.regionViews.insert
         * @memberOf! resourceviews(v1beta1)
         *
         * @param {object} params Parameters for request
         * @param {string} params.projectName The project name of the resource view.
         * @param {string} params.region The region name of the resource view.
         * @param {resourceviews(v1beta1).ResourceView} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        insert: function (params, options, callback) {
            if (typeof options === 'function') {
                callback = options;
                options = {};
            }
            options || (options = {});
            const rootUrl = options.rootUrl || 'https://www.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/resourceviews/v1beta1/projects/{projectName}/regions/{region}/resourceViews').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST'
                }, options),
                params: params,
                requiredParams: ['projectName', 'region'],
                pathParams: ['projectName', 'region'],
                context: self
            };
            return apirequest_1.default(parameters, callback);
        },
        /**
         * resourceviews.regionViews.list
         *
         * @desc List resource views.
         *
         * @alias resourceviews.regionViews.list
         * @memberOf! resourceviews(v1beta1)
         *
         * @param {object} params Parameters for request
         * @param {integer=} params.maxResults Maximum count of results to be returned. Acceptable values are 0 to 5000, inclusive. (Default: 5000)
         * @param {string=} params.pageToken Specifies a nextPageToken returned by a previous list request. This token can be used to request the next page of results from a previous list request.
         * @param {string} params.projectName The project name of the resource view.
         * @param {string} params.region The region name of the resource view.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list: function (params, options, callback) {
            if (typeof options === 'function') {
                callback = options;
                options = {};
            }
            options || (options = {});
            const rootUrl = options.rootUrl || 'https://www.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/resourceviews/v1beta1/projects/{projectName}/regions/{region}/resourceViews').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'GET'
                }, options),
                params: params,
                requiredParams: ['projectName', 'region'],
                pathParams: ['projectName', 'region'],
                context: self
            };
            return apirequest_1.default(parameters, callback);
        },
        /**
         * resourceviews.regionViews.listresources
         *
         * @desc List the resources in the view.
         *
         * @alias resourceviews.regionViews.listresources
         * @memberOf! resourceviews(v1beta1)
         *
         * @param {object} params Parameters for request
         * @param {integer=} params.maxResults Maximum count of results to be returned. Acceptable values are 0 to 5000, inclusive. (Default: 5000)
         * @param {string=} params.pageToken Specifies a nextPageToken returned by a previous list request. This token can be used to request the next page of results from a previous list request.
         * @param {string} params.projectName The project name of the resource view.
         * @param {string} params.region The region name of the resource view.
         * @param {string} params.resourceViewName The name of the resource view.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        listresources: function (params, options, callback) {
            if (typeof options === 'function') {
                callback = options;
                options = {};
            }
            options || (options = {});
            const rootUrl = options.rootUrl || 'https://www.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/resourceviews/v1beta1/projects/{projectName}/regions/{region}/resourceViews/{resourceViewName}/resources').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST'
                }, options),
                params: params,
                requiredParams: ['projectName', 'region', 'resourceViewName'],
                pathParams: ['projectName', 'region', 'resourceViewName'],
                context: self
            };
            return apirequest_1.default(parameters, callback);
        },
        /**
         * resourceviews.regionViews.removeresources
         *
         * @desc Remove resources from the view.
         *
         * @alias resourceviews.regionViews.removeresources
         * @memberOf! resourceviews(v1beta1)
         *
         * @param {object} params Parameters for request
         * @param {string} params.projectName The project name of the resource view.
         * @param {string} params.region The region name of the resource view.
         * @param {string} params.resourceViewName The name of the resource view.
         * @param {resourceviews(v1beta1).RegionViewsRemoveResourcesRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        removeresources: function (params, options, callback) {
            if (typeof options === 'function') {
                callback = options;
                options = {};
            }
            options || (options = {});
            const rootUrl = options.rootUrl || 'https://www.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/resourceviews/v1beta1/projects/{projectName}/regions/{region}/resourceViews/{resourceViewName}/removeResources').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST'
                }, options),
                params: params,
                requiredParams: ['projectName', 'region', 'resourceViewName'],
                pathParams: ['projectName', 'region', 'resourceViewName'],
                context: self
            };
            return apirequest_1.default(parameters, callback);
        }
    };
    self.zoneViews = {
        /**
         * resourceviews.zoneViews.addresources
         *
         * @desc Add resources to the view.
         *
         * @alias resourceviews.zoneViews.addresources
         * @memberOf! resourceviews(v1beta1)
         *
         * @param {object} params Parameters for request
         * @param {string} params.projectName The project name of the resource view.
         * @param {string} params.resourceViewName The name of the resource view.
         * @param {string} params.zone The zone name of the resource view.
         * @param {resourceviews(v1beta1).ZoneViewsAddResourcesRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        addresources: function (params, options, callback) {
            if (typeof options === 'function') {
                callback = options;
                options = {};
            }
            options || (options = {});
            const rootUrl = options.rootUrl || 'https://www.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/resourceviews/v1beta1/projects/{projectName}/zones/{zone}/resourceViews/{resourceViewName}/addResources').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST'
                }, options),
                params: params,
                requiredParams: ['projectName', 'zone', 'resourceViewName'],
                pathParams: ['projectName', 'resourceViewName', 'zone'],
                context: self
            };
            return apirequest_1.default(parameters, callback);
        },
        /**
         * resourceviews.zoneViews.delete
         *
         * @desc Delete a resource view.
         *
         * @alias resourceviews.zoneViews.delete
         * @memberOf! resourceviews(v1beta1)
         *
         * @param {object} params Parameters for request
         * @param {string} params.projectName The project name of the resource view.
         * @param {string} params.resourceViewName The name of the resource view.
         * @param {string} params.zone The zone name of the resource view.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        delete: function (params, options, callback) {
            if (typeof options === 'function') {
                callback = options;
                options = {};
            }
            options || (options = {});
            const rootUrl = options.rootUrl || 'https://www.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/resourceviews/v1beta1/projects/{projectName}/zones/{zone}/resourceViews/{resourceViewName}').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'DELETE'
                }, options),
                params: params,
                requiredParams: ['projectName', 'zone', 'resourceViewName'],
                pathParams: ['projectName', 'resourceViewName', 'zone'],
                context: self
            };
            return apirequest_1.default(parameters, callback);
        },
        /**
         * resourceviews.zoneViews.get
         *
         * @desc Get the information of a zonal resource view.
         *
         * @alias resourceviews.zoneViews.get
         * @memberOf! resourceviews(v1beta1)
         *
         * @param {object} params Parameters for request
         * @param {string} params.projectName The project name of the resource view.
         * @param {string} params.resourceViewName The name of the resource view.
         * @param {string} params.zone The zone name of the resource view.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        get: function (params, options, callback) {
            if (typeof options === 'function') {
                callback = options;
                options = {};
            }
            options || (options = {});
            const rootUrl = options.rootUrl || 'https://www.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/resourceviews/v1beta1/projects/{projectName}/zones/{zone}/resourceViews/{resourceViewName}').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'GET'
                }, options),
                params: params,
                requiredParams: ['projectName', 'zone', 'resourceViewName'],
                pathParams: ['projectName', 'resourceViewName', 'zone'],
                context: self
            };
            return apirequest_1.default(parameters, callback);
        },
        /**
         * resourceviews.zoneViews.insert
         *
         * @desc Create a resource view.
         *
         * @alias resourceviews.zoneViews.insert
         * @memberOf! resourceviews(v1beta1)
         *
         * @param {object} params Parameters for request
         * @param {string} params.projectName The project name of the resource view.
         * @param {string} params.zone The zone name of the resource view.
         * @param {resourceviews(v1beta1).ResourceView} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        insert: function (params, options, callback) {
            if (typeof options === 'function') {
                callback = options;
                options = {};
            }
            options || (options = {});
            const rootUrl = options.rootUrl || 'https://www.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/resourceviews/v1beta1/projects/{projectName}/zones/{zone}/resourceViews').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST'
                }, options),
                params: params,
                requiredParams: ['projectName', 'zone'],
                pathParams: ['projectName', 'zone'],
                context: self
            };
            return apirequest_1.default(parameters, callback);
        },
        /**
         * resourceviews.zoneViews.list
         *
         * @desc List resource views.
         *
         * @alias resourceviews.zoneViews.list
         * @memberOf! resourceviews(v1beta1)
         *
         * @param {object} params Parameters for request
         * @param {integer=} params.maxResults Maximum count of results to be returned. Acceptable values are 0 to 5000, inclusive. (Default: 5000)
         * @param {string=} params.pageToken Specifies a nextPageToken returned by a previous list request. This token can be used to request the next page of results from a previous list request.
         * @param {string} params.projectName The project name of the resource view.
         * @param {string} params.zone The zone name of the resource view.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        list: function (params, options, callback) {
            if (typeof options === 'function') {
                callback = options;
                options = {};
            }
            options || (options = {});
            const rootUrl = options.rootUrl || 'https://www.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/resourceviews/v1beta1/projects/{projectName}/zones/{zone}/resourceViews').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'GET'
                }, options),
                params: params,
                requiredParams: ['projectName', 'zone'],
                pathParams: ['projectName', 'zone'],
                context: self
            };
            return apirequest_1.default(parameters, callback);
        },
        /**
         * resourceviews.zoneViews.listresources
         *
         * @desc List the resources of the resource view.
         *
         * @alias resourceviews.zoneViews.listresources
         * @memberOf! resourceviews(v1beta1)
         *
         * @param {object} params Parameters for request
         * @param {integer=} params.maxResults Maximum count of results to be returned. Acceptable values are 0 to 5000, inclusive. (Default: 5000)
         * @param {string=} params.pageToken Specifies a nextPageToken returned by a previous list request. This token can be used to request the next page of results from a previous list request.
         * @param {string} params.projectName The project name of the resource view.
         * @param {string} params.resourceViewName The name of the resource view.
         * @param {string} params.zone The zone name of the resource view.
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        listresources: function (params, options, callback) {
            if (typeof options === 'function') {
                callback = options;
                options = {};
            }
            options || (options = {});
            const rootUrl = options.rootUrl || 'https://www.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/resourceviews/v1beta1/projects/{projectName}/zones/{zone}/resourceViews/{resourceViewName}/resources').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST'
                }, options),
                params: params,
                requiredParams: ['projectName', 'zone', 'resourceViewName'],
                pathParams: ['projectName', 'resourceViewName', 'zone'],
                context: self
            };
            return apirequest_1.default(parameters, callback);
        },
        /**
         * resourceviews.zoneViews.removeresources
         *
         * @desc Remove resources from the view.
         *
         * @alias resourceviews.zoneViews.removeresources
         * @memberOf! resourceviews(v1beta1)
         *
         * @param {object} params Parameters for request
         * @param {string} params.projectName The project name of the resource view.
         * @param {string} params.resourceViewName The name of the resource view.
         * @param {string} params.zone The zone name of the resource view.
         * @param {resourceviews(v1beta1).ZoneViewsRemoveResourcesRequest} params.resource Request body data
         * @param {object} [options] Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param {callback} callback The callback that handles the response.
         * @return {object} Request object
         */
        removeresources: function (params, options, callback) {
            if (typeof options === 'function') {
                callback = options;
                options = {};
            }
            options || (options = {});
            const rootUrl = options.rootUrl || 'https://www.googleapis.com/';
            const parameters = {
                options: Object.assign({
                    url: (rootUrl + '/resourceviews/v1beta1/projects/{projectName}/zones/{zone}/resourceViews/{resourceViewName}/removeResources').replace(/([^:]\/)\/+/g, '$1'),
                    method: 'POST'
                }, options),
                params: params,
                requiredParams: ['projectName', 'zone', 'resourceViewName'],
                pathParams: ['projectName', 'resourceViewName', 'zone'],
                context: self
            };
            return apirequest_1.default(parameters, callback);
        }
    };
}
module.exports = Resourceviews;
//# sourceMappingURL=v1beta1.js.map