"use strict";
// The MIT License (MIT)
//
// Copyright (c) 2017 Firebase
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
Object.defineProperty(exports, "__esModule", { value: true });
const cloud_functions_1 = require("../cloud-functions");
/** @internal */
exports.provider = 'firebase.crashlytics';
/**
 * Handle events related to Crashlytics issues. An issue in Crashlytics is an
 * aggregation of crashes which have a shared root cause.
 */
function issue() {
    return new IssueBuilder('projects/' + process.env.GCLOUD_PROJECT);
}
exports.issue = issue;
/** Builder used to create Cloud Functions for Crashlytics issue events. */
class IssueBuilder {
    /** @internal */
    constructor(resource) {
        this.resource = resource;
    }
    /** Handle Crashlytics New Issue events. */
    onNewDetected(handler) {
        return cloud_functions_1.makeCloudFunction({
            provider: exports.provider, handler,
            resource: this.resource,
            eventType: 'issue.new',
        });
    }
    /** Handle Crashlytics Regressed Issue events. */
    onRegressed(handler) {
        return cloud_functions_1.makeCloudFunction({
            provider: exports.provider, handler,
            resource: this.resource,
            eventType: 'issue.regressed',
        });
    }
    /** Handle Crashlytics Velocity Alert events. */
    onVelocityAlert(handler) {
        return cloud_functions_1.makeCloudFunction({
            provider: exports.provider, handler,
            resource: this.resource,
            eventType: 'issue.velocityAlert',
        });
    }
}
exports.IssueBuilder = IssueBuilder;
/**
 * Interface representing a Crashlytics issue event that was logged for a specific issue.
 */
class Issue {
}
exports.Issue = Issue;
class VelocityAlert {
}
exports.VelocityAlert = VelocityAlert;
