# regex-not [![NPM version](https://img.shields.io/npm/v/regex-not.svg?style=flat)](https://www.npmjs.com/package/regex-not) [![NPM downloads](https://img.shields.io/npm/dm/regex-not.svg?style=flat)](https://npmjs.org/package/regex-not) [![Build Status](https://img.shields.io/travis/jonschlinkert/regex-not.svg?style=flat)](https://travis-ci.org/jonschlinkert/regex-not)

> Create a javascript regular expression for matching everything except for the given string.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save regex-not
```

## Usage

```js
var not = require('regex-not');
```

The main export is a function that takes a string an options object.

```js
not(string[, options]);
```

**Example**

```js
var not = require('regex-not');
console.log(not('foo'));
//=> /^(?:(?!^(?:foo)$).)*$/
```

**Strict matching**

By default, the returned regex is for strictly (not) matching the exact given pattern (in other words, "match this string if it does NOT _exactly equal_ `foo`"):

```js
var re = not('foo');
console.log(re.test('foo'));     //=> false
console.log(re.test('bar'));     //=> true
console.log(re.test('foobar'));  //=> true
console.log(re.test('barfoo'));  //=> true
```

### .create

Returns a string to allow you to create your own regex:

```js
console.log(not.create('foo'));
//=> '(?:(?!^(?:foo)$).)*'
```

### Options

**options.contains**

You can relax strict matching by setting `options.contains` to true (in other words, "match this string if it does NOT _contain_ `foo`"):

```js
var re = not('foo');
console.log(re.test('foo', {contains: true}));     //=> false
console.log(re.test('bar', {contains: true}));     //=> true
console.log(re.test('foobar', {contains: true}));  //=> false
console.log(re.test('barfoo', {contains: true}));  //=> false
```

## About

### Related projects

* [regex-cache](https://www.npmjs.com/package/regex-cache): Memoize the results of a call to the RegExp constructor, avoiding repetitious runtime compilation of… [more](https://github.com/jonschlinkert/regex-cache) | [homepage](https://github.com/jonschlinkert/regex-cache "Memoize the results of a call to the RegExp constructor, avoiding repetitious runtime compilation of the same string and options, resulting in suprising performance improvements.")
* [to-regex](https://www.npmjs.com/package/to-regex): Generate a regex from a string or array of strings. | [homepage](https://github.com/jonschlinkert/to-regex "Generate a regex from a string or array of strings.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Building docs

_(This document was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme) (a [verb](https://github.com/verbose/verb) generator), please don't edit the readme directly. Any changes to the readme must be made in [.verb.md](.verb.md).)_

To generate the readme and API documentation with [verb](https://github.com/verbose/verb):

```sh
$ npm install -g verb verb-generate-readme && verb
```

### Running tests

Install dev dependencies:

```sh
$ npm install -d && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

### License

Copyright © 2016, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT license](https://github.com/jonschlinkert/regex-not/blob/master/LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.1.31, on October 07, 2016._