/**
 * @file emulate AtomEngine ssr server
 * input query
 *  request odp
 * output result
 */

var connect = require('connect');
var request = require('request');
var ssr = require('@baidu/atom-engine');
var getLocalIp = require('./getLocalIp');
var host = getLocalIp() || '$ip';

/**
 * 启动ssr-server
 *
 * @param {Object} conf - 配置对象
 * @param {string} conf.url - server url
 * @param {number} [conf.port=8099] - 监听的端口号
 * @param {Function} [conf.onStarted] - 开启成功之后的回调
 * @param {boolean} [conf.disableSSRRender=false] - 为true时不开启SSR，直接将js代码给到端上运行
 *      todo: 需要端的playground支持不接收commands只运行js
 *      todo: 或者更应该这种需求直接不启动本server，直接对接url中的server（端上兼容其输出的js code形式）
 */
module.exports = function (conf) {
    conf.port = conf.port || 8099;
    connect().use(function(req, res){
        console.log('receive request');

        request(conf.url, {}, function (err, odpRes, odpBody) {
            var code = odpBody;
            console.log('got code from odp:\n    ', code.slice(0, 50).replace(/\n/g, ' ') + '...');

            if (!conf.disableSSRRender) {
                // todo: 运行异常时的捕获与展示
                ssr.run(code).then(function (ssrResult) {
                    console.log('ssr run done');

                    res.setHeader("Content-Type", "application/json; charset=utf-8");
                    res.end(JSON.stringify({
                        command: ssrResult.commands,
                        content: ssrResult.code,
                        query: ''
                    }));
                });
            } else {
                res.end(JSON.stringify({
                    command: null,
                    content: code,
                    query: ''
                }));
            }
        });
    }).listen(conf.port, function () {
        conf.onStarted && conf.onStarted('http://' + host + ':' + conf.port);
    });
};

