#!/usr/bin/env node
'use strict';

const commander = require('commander');
const debug = require('atom-debugger');
const create = require('../src/create.js');
const build = require('../src/webpack/pack.js');
const server = require('../src/server.js');
const ssrServer = require('../src/ssr-server.js');
const testSsr = require('../src/testSsr.js');
var qrcode = require('qrcode-terminal-alpha');

var startDebug = function(port,cb) {
    	var config = {
        	enableHeadless: true,
			port: port
    	};
    	debug.startServer(null, config, function(url){
			cb && cb(url);
			console.log('[debug]', 'Websocket: ' + url);
		});
}

var showSmallQrcode = function(string) {
	qrcode.generate(entryWs, {small: true});
}

commander
	.command('build')
	.description('build project and run a server')
	.option('-d, --debug', 'run a debug server at the same time')
	.option('--debug_port <debug_port>', 'debug server port')
	.action(function(options){
		var buildUrl = build();
		if(buildUrl) {
			if(options.debug) {
				startDebug(options.debug_port, function(url){
					var entryWs = '{"build":"' + buildUrl + '","debug":"' + url + '"}';
					showSmallQrcode(entryWs);
				});
			}else {
				var entryWs = '{"build":"' + buildUrl + '"}';
				showSmallQrcode(entryWs);
			}
		}else {
			process.exit();
		}
	});

commander
	.command('create')
	.description('Create an Atom project')
	//.option('-n, --name <name>', 'project name')
	//.option('-a, --author <author>', 'project author')
	.action(function(options){
		create();
	});

commander
	.command('debug')
	.description('start to debug')
	.option('-p, --port <port>', 'debug server port')
	.action(function(options){
		startDebug(options.port, function(url){
			var entryWs = '{"debug":"' + url + '"}';
			showSmallQrcode(entryWs);
		});
	});

commander
	.command('ssr <url>')
	.description('run ssr server')
	.option('-d, --debug', 'run a debug server at the same time')
	.option('-p, --port <port>', 'ssr server port')
	.option('--disable_ssr', 'disable ssr')
	.option('--debug_port <debug_port>', 'debug server port')
	.action(function(url, options){
		var config = {
        	url: url,
			port: options.port,
			disableSSRRender: options.disable_ssr,
			onStarted: function(ssrUrl) {
				if(ssrUrl) {
					if(options.debug) {
						startDebug(options.debug_port, function(url){
							var entryWs = '{"ssr":"' + ssrUrl + '","debug":"' + url + '"}';
							showSmallQrcode(entryWs);
							console.log('[ssr]','server started, listening on ' + ssrUrl);
						});
					}else {
						var entryWs = '{"ssr":"' + ssrUrl + '"}';
						showSmallQrcode(entryWs);
						console.log('[ssr]','server started, listening on ' + ssrUrl);
					}
				}else {
					process.exit();
				}
			}
    	};
		ssrServer(config);
	});

commander
	.command('testSsr <url>')
	.description('Test if Server SSR commands is same as App commands')
	.action(function(url){
    		testSsr(url);
	});

commander.parse(process.argv);
