/**
 * @file simple node server
 */

var connect = require('connect');
var serveStatic = require('serve-static');
var getLocalIp = require('./getLocalIp');
var port = 8079;
var host = getLocalIp() || '$ip';
var qrcode = require('qrcode-terminal-alpha');


module.exports = function () {
connect().use(serveStatic(process.cwd())).listen(port, function(){
    // todo: get ip
    var enterJs = 'http://' + host + ':' + port + '/output/index.js';
    var command = JSON.stringify({
        type: 'load',
        url: enterJs
    });
    console.log('本地开发mock服务器已启动 localhost:' + port + '...\n\n' 
        + ('入口js:\n  ' + enterJs).green + '\n');
    console.log('可扫描下方二维码')
    qrcode.generate(enterJs);

    console.log(('Native入口命令:\n  ' + command) + '\n'
        + 'web模拟调试地址:\n  ' + 'http://' + host + ':' + port + '/emulator/emulator.html#' + encodeURI(command) + '\n'
        + '  (请用chrome浏览器打开)'
    );

});
};