const colors = require('colors');
var os = require('os');
var ifaces = os.networkInterfaces();

module.exports = function () {
    var localIp;

    Object.keys(ifaces).forEach(function (ifname) {
        ifaces[ifname].forEach(function (iface) {
            if ('IPv4' !== iface.family || iface.internal !== false) {
                // skip over internal (i.e. 127.0.0.1) and non-ipv4 addresses
                return;
            }

            if (localIp) {
                console.warn(('multi ip address found ' + localIp).yellow);
            } else {
                localIp = iface.address;
            }
        });
    });

    if (!localIp) {
        console.warn('no ip address found, please replace $ip with your ip address\n'.yellow);
    }
    return localIp;
};
