/**
 * @file testSSR
 */
var jsdiff = require('diff');
var WebSocketServer = require('ws').Server;
var getLocalIp = require('./getLocalIp');
var qrcode = require('qrcode-terminal-alpha');
var host = getLocalIp() || '$ip';
var port = 8096;
var defaultUrl = 'http://nj03-rp-m22nlp156.nj03.baidu.com:8000/swan/list';

module.exports = function (url) {

    if (!url) {
        console.log('Didn\'t get input url, use defult urlListUrl!');
        url = defaultUrl;
    }

    var clientWs;
    var wss;

    wss = new WebSocketServer({port: 8096});

    wss.on('connection', function (ws) {
        clientWs = ws;
        clientWs.send(url);
        clientWs.on('message', function incoming(message) {
            var resultJson = JSON.parse(message);
            var query = resultJson.query;
            var result = resultJson.result;
            if (result === 'correct') {
                console.log(query, ': correct');
            } else if (result === 'incorrect') {
                console.log(query, ': wrong！！！！！');
                var serverCommands = resultJson.serverCommands;
                var appCommands = resultJson.appCommands;
                var diff = jsdiff.diffChars(serverCommands, appCommands);
                diff.forEach(function (part) {
                  // green for additions, red for deletions
                  // grey for common parts
                    var color = part.added ? 'green'
                    : part.removed ? 'red' : 'grey';
                    process.stderr.write(part.value[color]);
                });
                console.log();
            }
        });
    });

    var entryWs = 'ws://' + host + ':' + port;
    var json = '{ "type":"SsrTestListWs" , "data":"' + entryWs + '" }';

    qrcode.generate(json, {small: true});

    console.log('若出现不符合的情况:',
        '\n绿色字符为App端相对Server端添加的部分',
        '\n红色字符为App端相对Server端删除的部分',
        '\n灰色字符为App端相对Server端一致的部分');
};