/**
 * @file 根据模块名与模块入口js产出webpack配置
 */
const path = require('path');

module.exports = function (moduleName, moduleEntry) {
    return {
        entry: moduleEntry,
        output: {
            path: path.resolve('./output'),
            libraryTarget: 'amd',
            filename: moduleName + '.js',
            library: moduleName
        },
        externals: {
            'swan/swan': true
        },
        module: {
            rules: [{
                test: /\.atom$/,
                use: [{loader: 'atom-loader'}]
            }]
        },
        resolveLoader: {
            modules: ['node_modules', __dirname]
        }
    };
};
