const readline = require('readline');
const fs = require('fs-extra');
const path = require('path');

var proj_name;
var proj_desc;
var author;

const rl = readline.createInterface({
    input: process.stdin,
    output: process.stdout
});

function deal_info(){
    var proj_path = './' + proj_name;

    fs.ensureDirSync(proj_path);
    fs.copySync(path.resolve(__dirname, './model/modelindex.js') , proj_path + '/src/index.js', 0);
    fs.copySync(path.resolve(__dirname , './model/launcher.atom'), proj_path + '/src/launcher.atom', 0);
    fs.copySync(path.resolve(__dirname , './model/modelentry.js'), proj_path + '/src/entry.js', 0);
    fs.ensureFileSync( proj_path + '/package.json');
    fs.outputFileSync(proj_path + '/package.json', 
        JSON.stringify({
            name: proj_name, 
            version: "1.0.0", 
            description: proj_desc, 
            author:author,
            scripts: {
                build:"atom-engine build",
                server:"atom-engine server"
            }   
        },null,2));
    console.log('Init end>>>>>>>>>>>>>>>>>>>');
}


module.exports = function () {
   rl.question('Project name: ', (answer) => {
        proj_name = answer;
        rl.question('Descripe your project:', (answer) => {
            proj_desc = answer
            rl.question('Author:', (answer) => {
                author = answer
                deal_info()
                rl.close()
            });
        });
    });
};




