/**
 * @file 使用webpack打包一个业务
 */
var webpack = require("webpack");
var genConfig = require('./gen-config');
var shell = require('shelljs');
var fs = require('fs');
var path = require('path');
var colors = require('colors');
var watchChange = require('../watchChange');
var WebSocketServer = require('ws').Server;
var getLocalIp = require('../getLocalIp');
var port = 8080;
var host = getLocalIp() || '$ip';
var qrcode = require('qrcode-terminal-alpha');


function writeFile(path, content) {
    shell.mkdir('-p', getDir(path));
    fs.writeFileSync(path, content);
}

function getDir(path) {
    return path.replace(/\/?[^/]+$/, '');
}

function getOneResult() {
    const fs = require('fs-extra');
    fs.readFile(path.resolve(process.cwd(), './output/index.js'), function (err, data) {
        if (err) {
            return console.error(err);
        }
        console.log("异步读取: " + data.toString());
    });
}

module.exports = function () { 
    var moduleName = 'launcher';
    var entryFile = './src/entry.js';
    var clients = [];

    function sendJs(ws) {
        const fs = require('fs-extra');
        fs.readFile(path.resolve(process.cwd(), './output/index.js'), function (err, data) {
            if (err) {
                return console.error(err);
            }
            var index = data.toString();
            fs.readFile(path.resolve(process.cwd(), './output/launcher.js'), function (err, data) {
                if (err) {
                    return console.error(err);
                }
                ws.send(data.toString() + index);
            });
        });
    }

    if (!shell.test('-f', entryFile)) {
       console.error(("入口文件不存在，请确认: " + entryFile).red);
       return;
    }
    
    wss = new WebSocketServer({port: 8080});

    wss.on('connection', function(ws) {
        clients.push(ws);
        sendJs(ws);
        ws.on('close', function(message) {
        // 连接关闭时，将其移出连接池
            clients = clients.filter(function(ws1){
                return ws1 !== ws
            })
        });
    });

    var compiler = webpack(genConfig(moduleName, entryFile));
    compiler.watch({
        aggregateTimeout: 300, // wait so long for more changes
        poll: true // use polling instead of native watchers
        // pass a number to set the polling interval
    }, function(err, stats) {
        if (err) { throw new Error('webpack:build', err); }
        console.log('[webpack:build]', stats.toString({
            chunks: false, // Makes the build much quieter
            colors: true
        }));

        const fs = require('fs-extra');
        fs.copySync(path.resolve(process.cwd(), './src/index.js') , path.resolve(process.cwd(), './output/index.js'), 0);

        clients.forEach(function(ws1){
            sendJs(ws1);            
        });    
    });

    var entryWs = 'ws://' + host + ':' + port;
    qrcode.generate(entryWs);

};