#!/usr/bin/env node
'use strict';

const create = require('../src/create.js');
const build = require('../src/webpack/pack.js');
const server = require('../src/server.js');
const testSsr = require('../src/testSsr.js');

var arg = process.argv[2];

var help = ' compile  :    Compile atom file; '
           + '\n create   :    Create an Atom project; '
           + '\n server   :    Run a server; '
           + '\n testSsr  :    Test if Server SSR commands is the same as App commands;';


if (!arg || arg === 'help') {
    console.log(help);
    process.exit();
} else if (arg === 'create') {
	create();
} else if (arg === 'server') {
	server();
} else if (arg === 'build') {
	build();
} else if (arg === 'testSsr') {
    var url = process.argv[3];
    testSsr(url);
} else {
    console.log(help);
    process.exit();
}

