var watchman = require('fb-watchman');

/**
 * 目录下文件发生变化时回调
 *
 * @param {string} dir - watch的目录
 * @param {Function} cb - 目录中有文件发生变化时的回调
 */
module.exports = function watchChange(dir, cb) {
    var mySubscriptionName = 'build-' + +new Date;
    var client = new watchman.Client();

    client.capabilityCheck({optional: [], required: ['relative_root']}, function (error, resp) {
        if (error) {
            console.log(error);
            client.end();
            return;
        }

        // Initiate the watch
        client.command(['watch-project', dir], function (error, resp) {
            if (error) {
                console.error('Error initiating watch:', error);
                return;
            }

            if ('warning' in resp) {
                console.log('warning: ', resp.warning);
            }

            console.log('watch established on ', resp.watch, ' relative_path', resp.relative_path);
            makeSubscription(client, resp.watch, resp.relative_path);
        });
    });

    function makeSubscription(client, watch, relativePath) {
        var sub = {
            expression: ['pcre', '.*'],
            fields: ['name', 'size', 'mtime_ms', 'exists', 'type'] // Which fields we're interested in
        };
        if (relativePath) {
            sub['relative_root'] = relativePath;
        }

        client.command(['subscribe', watch, mySubscriptionName, sub], function (error, resp) {
            if (error) {
                console.error('failed to subscribe: ', error);
                return;
            }

            console.log('subscription ' + resp.subscribe + ' established');
        });

        // { root: '/private/tmp/foo',
        //   subscription: mySubscriptionName,
        //   files: [ { name: 'node_modules/fb-watchman/index.js',
        //       size: 4768,
        //       exists: true,
        //       type: 'f' } ] }
        client.on('subscription', function (resp) {
            if (resp.subscription !== mySubscriptionName) {
                return;
            }

            cb(resp);
        });
    }
};
