"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ffi = require("ffi");
var ref = require("ref");
var fs = require("fs");
var FILE_ATTRIBUTE_REPARSE_POINT = 0x400;
function TEXT(str) {
    var ret = Buffer.alloc((str.length + 1) * 4);
    Buffer.from(str, 'ucs2').copy(ret);
    return ret;
}
var SYMBOLIC_LINK_FLAG_FILE = 0x0;
var SYMBOLIC_LINK_FLAG_DIRECTORY = 0x1;
var SYMBOLIC_LINK_FLAG_ALLOW_UNPRIVILEGED_CREATE = 0x2;
var kernel32 = ffi.Library('kernel32', {
    CreateSymbolicLinkW: [ref.types.int32, ['string', 'string', ref.types.int32]],
    GetFileAttributesW: [ref.types.int32, ['string']],
    GetLastError: [ref.types.int32, []]
});
function isPathSymbolicLink(filePath) {
    var ret = kernel32.GetFileAttributesW(TEXT(filePath));
    if (ret === -1) {
        // TODO: This sucks
        var gle = kernel32.GetLastError();
        throw new Error("isFileSymlink failed: " + gle);
    }
    return (ret & FILE_ATTRIBUTE_REPARSE_POINT) !== 0;
}
exports.isPathSymbolicLink = isPathSymbolicLink;
function createSymbolicLink(target, link) {
    var stat = fs.statSync(target);
    var flags;
    if (stat.isDirectory()) {
        flags = SYMBOLIC_LINK_FLAG_DIRECTORY | SYMBOLIC_LINK_FLAG_ALLOW_UNPRIVILEGED_CREATE;
    }
    else {
        flags = SYMBOLIC_LINK_FLAG_FILE | SYMBOLIC_LINK_FLAG_ALLOW_UNPRIVILEGED_CREATE;
    }
    var ret = kernel32.CreateSymbolicLinkW(TEXT(link), TEXT(target), flags);
    if (ret === 0) {
        // TODO: This sucks
        var gle = kernel32.GetLastError();
        throw new Error("createSymbolicLink failed: " + gle);
    }
}
exports.createSymbolicLink = createSymbolicLink;
//# sourceMappingURL=win32-symlink.js.map