"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var fs = require("graceful-fs");
var path = require("path");
var rimraf = require("rimraf");
var semver = require("semver");
var Observable_1 = require("rxjs/Observable");
require("rxjs/add/observable/defer");
require("rxjs/add/observable/timer");
require("rxjs/add/operator/retry");
require("rxjs/add/operator/take");
require("rxjs/add/operator/toPromise");
var win32_symlink_1 = require("./win32-symlink");
var spawn_rx_1 = require("spawn-rx");
var zip_utils_1 = require("./zip-utils");
var AtomVersionKind;
(function (AtomVersionKind) {
    AtomVersionKind[AtomVersionKind["NotInstalled"] = 0] = "NotInstalled";
    AtomVersionKind[AtomVersionKind["Unknown"] = 1] = "Unknown";
    AtomVersionKind[AtomVersionKind["Stable"] = 2] = "Stable";
    AtomVersionKind[AtomVersionKind["Beta"] = 3] = "Beta";
    AtomVersionKind[AtomVersionKind["Daily"] = 4] = "Daily";
})(AtomVersionKind = exports.AtomVersionKind || (exports.AtomVersionKind = {}));
function versionKindToString(kind) {
    switch (kind) {
        case AtomVersionKind.NotInstalled:
            return 'not installed';
        case AtomVersionKind.Unknown:
            return 'unknown';
        case AtomVersionKind.Stable:
            return 'stable';
        case AtomVersionKind.Beta:
            return 'beta';
        case AtomVersionKind.Daily:
            return 'canary';
    }
}
exports.versionKindToString = versionKindToString;
function stringToVersionKind(kind) {
    switch (kind) {
        case 'stable':
            return AtomVersionKind.Stable;
        case 'beta':
            return AtomVersionKind.Beta;
        case 'canary':
            return AtomVersionKind.Daily;
        default:
            throw new Error('Not a valid version kind');
    }
}
exports.stringToVersionKind = stringToVersionKind;
function getInstalledAtomVersionKind(baseDir) {
    var atomDir = path.join(baseDir || process.env['LOCALAPPDATA'], 'atom');
    if (!fs.existsSync(atomDir)) {
        return AtomVersionKind.NotInstalled;
    }
    if (!win32_symlink_1.isPathSymbolicLink(atomDir)) {
        return AtomVersionKind.Unknown;
    }
    return directoryNameToAtomVersionKind(atomDir);
}
exports.getInstalledAtomVersionKind = getInstalledAtomVersionKind;
function getAllInstalledAtomVersions(baseDir) {
    var dir = baseDir || process.env['LOCALAPPDATA'];
    return fs.readdirSync(dir).reduce(function (acc, x) {
        var fullPath = path.join(dir, x);
        var kind = directoryNameToAtomVersionKind(fullPath);
        if (kind === AtomVersionKind.Unknown) {
            return acc;
        }
        acc.set(kind, fullPath);
        return acc;
    }, new Map());
}
exports.getAllInstalledAtomVersions = getAllInstalledAtomVersions;
function getVersionFromInstalledAtom(atomDir) {
    var entries = fs.readdirSync(atomDir);
    return entries.reduce(function (acc, x) {
        var m = x.match(/^app-(.*)$/i);
        if (!m) {
            return acc;
        }
        return semver.gte(acc, m[1]) ? acc : m[1];
    }, '0.0.0');
}
exports.getVersionFromInstalledAtom = getVersionFromInstalledAtom;
function uninstallCurrentAtom(baseDir, forceUninstall) {
    return __awaiter(this, void 0, void 0, function () {
        var atomDir;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    atomDir = path.join(baseDir || process.env['LOCALAPPDATA'], 'atom');
                    if (!fs.existsSync(atomDir)) {
                        return [2 /*return*/];
                    }
                    return [4 /*yield*/, runInstallHookOnCurrentAtom('uninstall', baseDir)];
                case 1:
                    _a.sent();
                    if (win32_symlink_1.isPathSymbolicLink(atomDir)) {
                        fs.rmdirSync(atomDir);
                    }
                    else {
                        if (!forceUninstall) {
                            return [2 /*return*/];
                        }
                        rimraf.sync(atomDir);
                    }
                    return [2 /*return*/];
            }
        });
    });
}
exports.uninstallCurrentAtom = uninstallCurrentAtom;
function switchToInstalledAtom(kind, baseDir) {
    return __awaiter(this, void 0, void 0, function () {
        var newAtom, linkedAtom;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    newAtom = getInstalledAtomPath(kind, baseDir);
                    if (!fs.existsSync(newAtom)) {
                        throw new Error(newAtom + " doesn't exist, so can't switch to it");
                    }
                    return [4 /*yield*/, uninstallCurrentAtom()];
                case 1:
                    _a.sent();
                    linkedAtom = path.join(baseDir || process.env['LOCALAPPDATA'], 'atom');
                    win32_symlink_1.createSymbolicLink(newAtom, linkedAtom);
                    runInstallHookOnCurrentAtom('install', baseDir);
                    return [2 /*return*/];
            }
        });
    });
}
exports.switchToInstalledAtom = switchToInstalledAtom;
function cleanInstallAtomVersion(kind, baseDir) {
    return __awaiter(this, void 0, void 0, function () {
        var newAtom, squirrelTemp, nugetPackage, tempDir, squirrel, atomDir;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    newAtom = getInstalledAtomPath(kind, baseDir);
                    squirrelTemp = path.join(process.env.LOCALAPPDATA, 'SquirrelTemp');
                    if (fs.existsSync(squirrelTemp)) {
                        rimraf.sync(squirrelTemp);
                        fs.mkdirSync(squirrelTemp);
                    }
                    return [4 /*yield*/, downloadAtomFromRelease(kind, squirrelTemp)];
                case 1:
                    nugetPackage = _a.sent();
                    tempDir = path.dirname(nugetPackage);
                    squirrel = path.join(tempDir, 'Update.exe');
                    return [4 /*yield*/, zip_utils_1.extractSingleFile(nugetPackage, 'lib/net45/squirrel.exe', squirrel)];
                case 2:
                    _a.sent();
                    if (fs.existsSync(newAtom)) {
                        rimraf.sync(newAtom);
                    }
                    return [4 /*yield*/, uninstallCurrentAtom()];
                case 3:
                    _a.sent();
                    // NB: Fuck Antivirus
                    return [4 /*yield*/, Observable_1.Observable.timer(5 * 1000).take(1).toPromise()];
                case 4:
                    // NB: Fuck Antivirus
                    _a.sent();
                    // NB: Antivirus scanners will be busy with this file since we basically
                    // just wrote it
                    return [4 /*yield*/, Observable_1.Observable.defer(function () { return spawn_rx_1.spawnPromise(squirrel, ['--install', '.', '--silent'], { cwd: tempDir }); })
                            .retry(10)
                            .toPromise()];
                case 5:
                    // NB: Antivirus scanners will be busy with this file since we basically
                    // just wrote it
                    _a.sent();
                    // NB: Fuck Antivirus More
                    return [4 /*yield*/, Observable_1.Observable.timer(5 * 1000).take(1).toPromise()];
                case 6:
                    // NB: Fuck Antivirus More
                    _a.sent();
                    return [4 /*yield*/, uninstallCurrentAtom()];
                case 7:
                    _a.sent();
                    atomDir = path.join(process.env['LOCALAPPDATA'], 'atom');
                    fs.renameSync(atomDir, newAtom);
                    return [2 /*return*/];
            }
        });
    });
}
exports.cleanInstallAtomVersion = cleanInstallAtomVersion;
function findLatestFullNugetFromReleasesFile(filePath) {
    var lines = fs.readFileSync(filePath, 'utf8').split('\n');
    var ret = lines.reduce(function (acc, x) {
        var m = x.match(/[a-zA-Z]+-(.*)-full\.nupkg/);
        if (!m) {
            return acc;
        }
        return semver.gte(m[1], acc.version) ? { name: m[0], version: m[1] } : acc;
    }, { name: '', version: '0.0.0' });
    return ret.name;
}
exports.findLatestFullNugetFromReleasesFile = findLatestFullNugetFromReleasesFile;
function directoryNameToAtomVersionKind(atomDir) {
    var actualAtomDir = fs.realpathSync(atomDir);
    var m = actualAtomDir.match(/\\avm-atom-(stable|beta|daily)/i);
    if (!m) {
        return AtomVersionKind.Unknown;
    }
    switch (m[1]) {
        case 'stable':
            return AtomVersionKind.Stable;
        case 'beta':
            return AtomVersionKind.Beta;
        case 'daily':
            return AtomVersionKind.Daily;
        default:
            return AtomVersionKind.Unknown;
    }
}
function getCurrentPackageVersion(appDir) {
    var apps = fs.readdirSync(appDir).filter(function (x) { return !!x.match(/app-/); });
    if (!apps || apps.length < 1) {
        throw new Error(appDir + " isn't a Squirrel.Windows package");
    }
    return apps.reduce(function (acc, x) {
        var ver = x.replace(/^app-/, '');
        return semver.gte(ver, acc) ? ver : acc;
    }, '0.0.0');
}
function getInstalledAtomPath(kind, baseDir) {
    var dirName;
    switch (kind) {
        case AtomVersionKind.Stable:
            dirName = "avm-atom-stable";
            break;
        case AtomVersionKind.Beta:
            dirName = "avm-atom-beta";
            break;
        case AtomVersionKind.Daily:
            dirName = "avm-atom-daily";
            break;
        default:
            throw new Error("Can't get installed Atom path for kind: " + kind);
    }
    return path.join(baseDir || process.env['LOCALAPPDATA'], dirName);
}
exports.getInstalledAtomPath = getInstalledAtomPath;
function downloadAtomFromRelease(kind, targetDir) {
    return __awaiter(this, void 0, void 0, function () {
        var url, releasesFile, fileToDownload, urlToDownload;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    url = 'https://atom.io/api/updates-x64/RELEASES';
                    switch (kind) {
                        case AtomVersionKind.Stable:
                            break;
                        case AtomVersionKind.Beta:
                            url += '?channel=beta';
                            break;
                        default:
                            throw new Error('Channel not supported');
                    }
                    return [4 /*yield*/, zip_utils_1.downloadFileToTempDir(url, targetDir)];
                case 1:
                    releasesFile = _a.sent();
                    fileToDownload = findLatestFullNugetFromReleasesFile(releasesFile);
                    urlToDownload = url.replace(/\/RELEASES/, '/' + fileToDownload);
                    return [4 /*yield*/, zip_utils_1.downloadFileToTempDir(urlToDownload, targetDir)];
                case 2:
                    _a.sent();
                    return [2 /*return*/, path.join(targetDir, fileToDownload)];
            }
        });
    });
}
exports.downloadAtomFromRelease = downloadAtomFromRelease;
function runInstallHookOnCurrentAtom(type, baseDir) {
    return __awaiter(this, void 0, void 0, function () {
        var atomDir, version, atomDotExe;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    atomDir = path.join(baseDir || process.env['LOCALAPPDATA'], 'atom');
                    if (!fs.existsSync(atomDir)) {
                        return [2 /*return*/];
                    }
                    version = getCurrentPackageVersion(atomDir);
                    atomDotExe = path.join(atomDir, "app-" + version, 'atom.exe');
                    return [4 /*yield*/, spawn_rx_1.spawnPromise(atomDotExe, ["--squirrel-" + type, version])];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
//# sourceMappingURL=api.js.map