import 'rxjs/add/observable/defer';
import 'rxjs/add/observable/timer';
import 'rxjs/add/operator/retry';
import 'rxjs/add/operator/take';
import 'rxjs/add/operator/toPromise';
export declare enum AtomVersionKind {
    NotInstalled = 0,
    Unknown = 1,
    Stable = 2,
    Beta = 3,
    Daily = 4,
}
export declare function versionKindToString(kind: AtomVersionKind): "unknown" | "stable" | "not installed" | "beta" | "canary";
export declare function stringToVersionKind(kind: string): AtomVersionKind.Stable | AtomVersionKind.Beta | AtomVersionKind.Daily;
export declare function getInstalledAtomVersionKind(baseDir?: string): AtomVersionKind;
export declare function getAllInstalledAtomVersions(baseDir?: string): Map<AtomVersionKind, string>;
export declare function getVersionFromInstalledAtom(atomDir: string): string;
export declare function uninstallCurrentAtom(baseDir?: string, forceUninstall?: boolean): Promise<void>;
export declare function switchToInstalledAtom(kind: AtomVersionKind, baseDir?: string): Promise<void>;
export declare function cleanInstallAtomVersion(kind: AtomVersionKind, baseDir?: string): Promise<void>;
export declare function findLatestFullNugetFromReleasesFile(filePath: string): string;
export declare function getInstalledAtomPath(kind: AtomVersionKind, baseDir?: string): string;
export declare function downloadAtomFromRelease(kind: AtomVersionKind, targetDir: string): Promise<string>;
