#!/usr/bin/env node
"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = y[op[0] & 2 ? "return" : op[0] ? "throw" : "next"]) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [0, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var fs = require("fs");
var rimraf = require("rimraf");
var commander = require("commander");
var inquirer = require("inquirer");
var api_1 = require("./api");
var hasRunCommand = false;
function switchVersion(channel) {
    return __awaiter(this, void 0, void 0, function () {
        var kind, currentAtom, shouldUninstall, atomVersions;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    hasRunCommand = true;
                    kind = validatedStringToVersionKind(channel);
                    currentAtom = api_1.getInstalledAtomVersionKind();
                    if (!(currentAtom === api_1.AtomVersionKind.Unknown)) return [3 /*break*/, 3];
                    console.log('\n*** Currently installed Atom is unknown or not managed by atom-version-manager ***');
                    return [4 /*yield*/, inquirer.prompt([{
                                type: 'confirm',
                                name: 'uninstall',
                                message: 'Uninstall it?',
                                default: false
                            }])];
                case 1:
                    shouldUninstall = _a.sent();
                    if (!shouldUninstall.uninstall) {
                        console.log('Not uninstalling. Exiting.');
                        process.exit(-1);
                    }
                    console.log('Uninstalling...');
                    return [4 /*yield*/, api_1.uninstallCurrentAtom(undefined, true)];
                case 2:
                    _a.sent();
                    _a.label = 3;
                case 3:
                    atomVersions = api_1.getAllInstalledAtomVersions();
                    if (!!atomVersions.has(kind)) return [3 /*break*/, 5];
                    console.log('Channel not currently installed - installing...');
                    return [4 /*yield*/, api_1.cleanInstallAtomVersion(kind)];
                case 4:
                    _a.sent();
                    _a.label = 5;
                case 5:
                    console.log("Switching channels: " + channel);
                    return [4 /*yield*/, api_1.switchToInstalledAtom(kind)];
                case 6:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.switchVersion = switchVersion;
function displayVersion() {
    hasRunCommand = true;
    var versions = api_1.getAllInstalledAtomVersions();
    var current = api_1.getInstalledAtomVersionKind();
    console.log('\nInstalled Atom Versions:\n');
    versions.forEach(function (dir, ver) {
        var currentSym = (ver === current) ? '*' : ' ';
        var version = api_1.getVersionFromInstalledAtom(dir);
        var name = api_1.versionKindToString(ver);
        console.log(currentSym + " " + name + " - " + version);
    });
    if (current === api_1.AtomVersionKind.Unknown || api_1.AtomVersionKind.NotInstalled) {
        console.log('\n*** Currently installed Atom is unknown or not managed by atom-version-manager');
    }
}
exports.displayVersion = displayVersion;
function removeVersion(channel) {
    hasRunCommand = true;
    var kind = validatedStringToVersionKind(channel);
    var fullDir = api_1.getInstalledAtomPath(kind);
    var current = api_1.getInstalledAtomVersionKind();
    if (current === kind) {
        console.error("\nCan't remove current channel, switch to another channel first.");
        process.exit(-1);
    }
    if (!fs.existsSync(fullDir)) {
        console.error("\nChannel " + channel + " isn't installed");
        process.exit(-1);
    }
    rimraf.sync(fullDir);
}
exports.removeVersion = removeVersion;
function validatedStringToVersionKind(channel) {
    var kind;
    try {
        kind = api_1.stringToVersionKind(channel);
    }
    catch (e) {
        console.error("\nUnrecognized channel name " + channel + " - valid names are 'stable', 'beta'");
        process.exit(-1);
    }
    return kind;
}
// tslint:disable-next-line:no-var-requires
var pkgJson = fs.existsSync(require.resolve('../package.json')) ?
    require('../package.json') :
    require('../../package.json');
commander.version(pkgJson.version);
commander
    .command('switch [channel]').alias('s')
    .description('Switch between installed versions of Atom')
    .action(switchVersion);
commander
    .command('info').alias('i')
    .description('List the installed channels and your current channel')
    .action(displayVersion);
commander
    .command('remove [channel]').alias('r')
    .description('Remove an installed channel to save disk space')
    .action(removeVersion);
commander.parse(process.argv);
if (!hasRunCommand) {
    displayVersion();
    process.exit(0);
}
//# sourceMappingURL=cli.js.map