
describe("files", function() {
	describe("#Saving base64", function(){
		it("should be saved", function(done){
			var base64 = "V29ya2luZyBhdCBQYXJzZSBpcyBncmVhdCE=";
			var file = new AV.File("myfile.txt", { base64: base64 });
			file.save().then(function(){
				console.log(file.url());
				console.log(file.id);
				expect(file.size()).to.be(26);
				expect(file.ownerId()).to.be.ok();
				expect(file.id).to.be.ok();
				file.destroy().then(function(){
					done();
				}, function(error){
					throw error;
				});
			}, function(error){
				throw error;
			});
		});
	});
	describe("#Saving array", function(){
		it("should be saved", function(done){
			var bytes = [ 0xBE, 0xEF, 0xCA, 0xFE ];
			var file = new AV.File("myfile.txt", bytes);
			file.save().then(function(){
				console.log(file.url());
				console.log(file.id);
				console.log(file.metaData());
				expect(file.size()).to.be(4);
				expect(file.ownerId()).to.be.ok();
				expect(file.id).to.be.ok();
				file.destroy().then(function(){
					done();
				}, function(error){
					throw error;
				});
			}, function(error){
				throw error;
			});
		});
	});
	describe("#Saving file with object", function(){
		it("should be saved", function(done){
			var bytes = [ 0xBE, 0xEF, 0xCA, 0xFE ];
			var file = new AV.File("myfile.txt", bytes);
			file.save().then(function(){
				console.log(file.url());
				console.log(file.id);
				var jobApplication = new AV.Object("JobApplication");
				jobApplication.set("applicantName", "Joe Smith");
				jobApplication.set("applicantResumeFile", file);
				jobApplication.save().then(function(result){
					expect(result.id).to.be.ok();
					var query = new AV.Query("JobApplication");
					query.get(result.id, {
						success: function(ja) {
		  					expect(ja.id).to.be.ok();
							var arf = ja.get("applicantResumeFile");
							console.log(arf.metaData());
							expect(arf).to.be.ok();
							expect(arf.size()).to.be(4);
							expect(arf.ownerId()).to.be.ok();
							console.log(ja.get("applicantResumeFile"));
							file.destroy().then(function(){
								done();
							}, function(error){
								throw error;
							});
						},
						error: function(object, error) {
							throw error;
						}
					});

				}, function(obj, error){
					throw error;
				});
			}, function(error){
				throw error;
			});
		});
	});
});

