// Generated by CoffeeScript 1.7.1
var Cookie, crc32, debug, signature, url;

signature = require('cookie-signature');

crc32 = require('buffer-crc32');

url = require('url');

debug = require('debug')('avos:cookieSession');

Cookie = require('connect').middleware.session.Cookie;

module.exports = function(options) {
  var key, trustProxy;
  if (options == null) {
    options = {};
  }
  key = options.key || 'avos.sess';
  if (options.fetchUser == null) {
    options.fetchUser = false;
  }
  if (options.cookie == null) {
    options.cookie = {};
  }
  options.cookie.httpOnly = true;
  options.cookie.signed = true;
  trustProxy = true;
  return function(req, res, next) {
    var av, cookie, originalPath, secret, session, sessionToken, uid;
    av = req._AV;
    secret = options.secret || req.secret;
    if (secret == null) {
      throw new Error('`secret` option required for avos cookie sessions');
    }
    req._avos_session = {};
    cookie = req._avos_session.cookie = new Cookie(options.cookie);
    originalPath = url.parse(req.originalUrl).pathname;
    if (0 !== originalPath.indexOf(cookie.path)) {
      return next();
    }
    req._avos_session = req.signedCookies[key] || {};
    req._avos_session.cookie = cookie;
    session = req._avos_session;
    uid = session._uid;
    sessionToken = session._sessionToken;
    res.on('header', function() {
      var user, val;
      var session = null;
      user = av.User.current();
      if (user != null) {
        session = {
          _uid: user.id,
          _sessionToken: user._sessionToken
        }
      }
      if (session == null) {
        debug('clear session');
        cookie.expire = new Date(0);
        debug('set-cookie %j', cookie);
        return res.setHeader('Set-Cookie', cookie.serialize(key, ''));
      }
      debug('serializing %j', session);
      val = 'j:' + JSON.stringify(session);
      val = 's:' + signature.sign(val, secret);
      val = cookie.serialize(key, val);
      debug('set-cookie %j', cookie);
      return res.setHeader('Set-Cookie', val);
    });
    if (req.AV == null) {
      req.AV = {};
    }
    if ((uid != null) && (sessionToken != null)) {
      return av.User.logInByIdAndSessionToken(uid, sessionToken, options.fetchUser, function(err, user) {
        req.AV.user = user;
        return next(err);
      });
    } else {
      av.User.logOut();
      delete req.AV.user;
      return next();
    }
  };
};
