<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

### Table of Contents

-   [DOM Interaction Helpers](#dom-interaction-helpers)
    -   [click](#click)
    -   [tap](#tap)
    -   [focus](#focus)
    -   [blur](#blur)
    -   [triggerEvent](#triggerevent)
    -   [triggerKeyEvent](#triggerkeyevent)
    -   [fillIn](#fillin)
-   [DOM Query Helpers](#dom-query-helpers)
    -   [find](#find)
    -   [findAll](#findall)
    -   [getRootElement](#getrootelement)
-   [Routing Helpers](#routing-helpers)
    -   [visit](#visit)
    -   [currentRouteName](#currentroutename)
    -   [currentURL](#currenturl)
-   [Rendering Helpers](#rendering-helpers)
    -   [render](#render)
    -   [clearRender](#clearrender)
-   [Wait Helpers](#wait-helpers)
    -   [waitFor](#waitfor)
    -   [waitUntil](#waituntil)
    -   [settled](#settled)
    -   [isSettled](#issettled)
    -   [getSettledState](#getsettledstate)
-   [Pause Helpers](#pause-helpers)
    -   [pauseTest](#pausetest)
    -   [resumeTest](#resumetest)
-   [Test Framework APIs](#test-framework-apis)
    -   [setResolver](#setresolver)
    -   [getResolver](#getresolver)
    -   [setupContext](#setupcontext)
    -   [getContext](#getcontext)
    -   [setContext](#setcontext)
    -   [unsetContext](#unsetcontext)
    -   [teardownContext](#teardowncontext)
    -   [setupRenderingContext](#setuprenderingcontext)
    -   [teardownRenderingContext](#teardownrenderingcontext)
    -   [setApplication](#setapplication)
    -   [getApplication](#getapplication)
    -   [setupApplicationContext](#setupapplicationcontext)
    -   [teardownApplicationContext](#teardownapplicationcontext)
    -   [validateErrorHandler](#validateerrorhandler)

## DOM Interaction Helpers




### click

Clicks on the specified target.

Sends a number of events intending to simulate a "real" user clicking on an
element.

For non-focusable elements the following events are triggered (in order):

-   `mousedown`
-   `mouseup`
-   `click`

For focusable (e.g. form control) elements the following events are triggered
(in order):

-   `mousedown`
-   `focus`
-   `focusin`
-   `mouseup`
-   `click`

The exact listing of events that are triggered may change over time as needed
to continue to emulate how actual browsers handle clicking a given element.

**Parameters**

-   `target` **([string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String) \| [Element](https://developer.mozilla.org/docs/Web/API/Element))** the element or selector to click on

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;void>** resolves when settled

### tap

Taps on the specified target.

Sends a number of events intending to simulate a "real" user tapping on an
element.

For non-focusable elements the following events are triggered (in order):

-   `touchstart`
-   `touchend`
-   `mousedown`
-   `mouseup`
-   `click`

For focusable (e.g. form control) elements the following events are triggered
(in order):

-   `touchstart`
-   `touchend`
-   `mousedown`
-   `focus`
-   `focusin`
-   `mouseup`
-   `click`

The exact listing of events that are triggered may change over time as needed
to continue to emulate how actual browsers handle tapping on a given element.

**Parameters**

-   `target` **([string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String) \| [Element](https://developer.mozilla.org/docs/Web/API/Element))** the element or selector to tap on
-   `options` **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** the options to be provided to the touch events (optional, default `{}`)

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;void>** resolves when settled

### focus

Focus the specified target.

Sends a number of events intending to simulate a "real" user focusing an
element.

The following events are triggered (in order):

-   `focus`
-   `focusin`

The exact listing of events that are triggered may change over time as needed
to continue to emulate how actual browsers handle focusing a given element.

**Parameters**

-   `target` **([string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String) \| [Element](https://developer.mozilla.org/docs/Web/API/Element))** the element or selector to focus

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;void>** resolves when the application is settled

### blur

Unfocus the specified target.

Sends a number of events intending to simulate a "real" user unfocusing an
element.

The following events are triggered (in order):

-   `blur`
-   `focusout`

The exact listing of events that are triggered may change over time as needed
to continue to emulate how actual browsers handle unfocusing a given element.

**Parameters**

-   `target` **([string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String) \| [Element](https://developer.mozilla.org/docs/Web/API/Element))** the element or selector to unfocus (optional, default `document.activeElement`)

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;void>** resolves when settled

### triggerEvent

Triggers an event on the specified target.

**Parameters**

-   `target` **([string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String) \| [Element](https://developer.mozilla.org/docs/Web/API/Element))** the element or selector to trigger the event on
-   `eventType` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** the type of event to trigger
-   `options` **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** additional properties to be set on the event

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;void>** resolves when the application is settled

### triggerKeyEvent

Triggers a keyboard event on the specified target.

**Parameters**

-   `target` **([string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String) \| [Element](https://developer.mozilla.org/docs/Web/API/Element))** the element or selector to trigger the event on
-   `eventType` **(`"keydown"` \| `"keyup"` \| `"keypress"`)** the type of event to trigger
-   `keyCode` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** the keyCode of the event being triggered
-   `modifiers` **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)?** the state of various modifier keys (optional, default `DEFAULT_MODIFIERS`)
    -   `modifiers.ctrlKey` **[boolean](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** if true the generated event will indicate the control key was pressed during the key event (optional, default `false`)
    -   `modifiers.altKey` **[boolean](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** if true the generated event will indicate the alt key was pressed during the key event (optional, default `false`)
    -   `modifiers.shiftKey` **[boolean](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** if true the generated event will indicate the shift key was pressed during the key event (optional, default `false`)
    -   `modifiers.metaKey` **[boolean](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** if true the generated event will indicate the meta key was pressed during the key event (optional, default `false`)

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;void>** resolves when the application is settled

### fillIn

Fill the provided text into the `value` property (or set `.innerHTML` when
the target is a content editable element) then trigger `change` and `input`
events on the specified target.

**Parameters**

-   `target` **([string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String) \| [Element](https://developer.mozilla.org/docs/Web/API/Element))** the element or selector to enter text into
-   `text` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** the text to fill into the target element

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;void>** resolves when the application is settled

## DOM Query Helpers




### find

Find the first element matched by the given selector. Equivalent to calling
`querySelector()` on the test root element.

**Parameters**

-   `selector` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** the selector to search for

Returns **[Element](https://developer.mozilla.org/docs/Web/API/Element)** matched element or null

### findAll

Find all elements matched by the given selector. Equivalent to calling
`querySelectorAll()` on the test root element.

**Parameters**

-   `selector` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** the selector to search for

Returns **[Array](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array)** array of matched elements

### getRootElement

Get the root element of the application under test (usually `#ember-testing`)

Returns **[Element](https://developer.mozilla.org/docs/Web/API/Element)** the root element

## Routing Helpers




### visit

Navigate the application to the provided URL.

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;void>** resolves when settled

### currentRouteName

Returns **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** the currently active route name

### currentURL

Returns **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** the applications current url

## Rendering Helpers




### render

Renders the provided template and appends it to the DOM.

**Parameters**

-   `template` **CompiledTemplate** the template to render

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;void>** resolves when settled

### clearRender

Clears any templates previously rendered. This is commonly used for
confirming behavior that is triggered by teardown (e.g.
`willDestroyElement`).

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;void>** resolves when settled

## Wait Helpers




### waitFor

Used to wait for a particular selector to appear in the DOM. Due to the fact
that it does not wait for general settledness, this is quite useful for testing
interim DOM states (e.g. loading states, pending promises, etc).

**Parameters**

-   `selector` **[string](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String)** the selector to wait for
-   `options` **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)?** the options to be used (optional, default `{}`)
    -   `options.timeout` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** the time to wait (in ms) for a match (optional, default `1000`)
    -   `options.count` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** the number of elements that should match the provided selector (optional, default `1`)

Returns **([Element](https://developer.mozilla.org/docs/Web/API/Element) \| [Array](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array)&lt;[Element](https://developer.mozilla.org/docs/Web/API/Element)>)** the element (or array of elements) that were being waited upon

### waitUntil

Wait for the provided callback to return a truthy value.

This does not leverage `settled()`, and as such can be used to manage async
while _not_ settled (e.g. "loading" or "pending" states).

**Parameters**

-   `callback` **[Function](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Statements/function)** the callback to use for testing when waiting should stop
-   `options` **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)?** options used to override defaults (optional, default `{}`)
    -   `options.timeout` **[number](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number)** the maximum amount of time to wait (optional, default `1000`)

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)** resolves with the callback value when it returns a truthy value

### settled

Returns a promise that resolves when in a settled state (see `isSettled` for
a definition of "settled state").

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;void>** resolves when settled

### isSettled

Checks various settledness metrics (via `getSettledState()`) to determine if things are settled or not.

Settled generally means that there are no pending timers, no pending waiters,
no pending AJAX requests, and no current run loop. However, new settledness
metrics may be added and used as they become available.

Returns **[boolean](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean)** `true` if settled, `false` otherwise

### getSettledState

Check various settledness metrics, and return an object with the following properties:

`hasRunLoop` - Checks if a run-loop has been started. If it has, this will
be `true` otherwise it will be `false`.
`hasPendingTimers` - Checks if there are scheduled timers in the run-loop.
These pending timers are primarily registered by `Ember.run.schedule`. If
there are pending timers, this will be `true`, otherwise `false`.
`hasPendingWaiters` - Checks if any registered test waiters are still
pending (e.g. the waiter returns `true`). If there are pending waiters,
this will be `true`, otherwise `false`.
`hasPendingRequests` - Checks if there are pending AJAX requests (based on
`ajaxSend` / `ajaxComplete` events triggered by `jQuery.ajax`). If there
are pending requests, this will be `true`, otherwise `false`.
`pendingRequestCount` - The count of pending AJAX requests.

Returns **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** object with properties for each of the metrics used to determine settledness

## Pause Helpers




### pauseTest

Returns a promise to be used to pauses the current test (due to being
returned from the test itself).  This is useful for debugging while testing
or for test-driving.  It allows you to inspect the state of your application
at any point.

The test framework wrapper (e.g. `ember-qunit` or `ember-mocha`) should
ensure that when `pauseTest()` is used, any framework specific test timeouts
are disabled.

**Examples**

_Usage via ember-qunit_

```javascript
import { setupRenderingTest } from 'ember-qunit';
import { render, click, pauseTest } from '@ember/test-helpers';


module('awesome-sauce', function(hooks) {
  setupRenderingTest(hooks);

  test('does something awesome', async function(assert) {
    await render(hbs`{{awesome-sauce}}`);

    // added here to visualize / interact with the DOM prior
    // to the interaction below
    await pauseTest();

    click('.some-selector');

    assert.equal(this.element.textContent, 'this sauce is awesome!');
  });
});
```

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;void>** resolves _only_ when `resumeTest()` is invoked

### resumeTest

Resumes a test previously paused by `await pauseTest()`.

## Test Framework APIs




### setResolver

Stores the provided resolver instance so that tests being ran can resolve
objects in the same way as a normal application.

Used by `setupContext` and `setupRenderingContext` as a fallback when `setApplication` was _not_ used.

**Parameters**

-   `resolver` **Ember.Resolver** the resolver to be used for testing

### getResolver

Retrieve the resolver instance stored by `setResolver`.

Returns **Ember.Resolver** the previously stored resolver

### setupContext

Used by test framework addons to setup the provided context for testing.

Responsible for:

-   sets the "global testing context" to the provided context (`setContext`)
-   create an owner object and set it on the provided context (e.g. `this.owner`)
-   setup `this.set`, `this.setProperties`, `this.get`, and `this.getProperties` to the provided context
-   setting up AJAX listeners
-   setting up `pauseTest` (also available as `this.pauseTest()`) and `resumeTest` helpers

**Parameters**

-   `context` **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** the context to setup
-   `options` **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)?** options used to override defaults (optional, default `{}`)
    -   `options.resolver` **Resolver?** a resolver to use for customizing normal resolution

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)>** resolves with the context that was setup

### getContext

Retrive the "global testing context" as stored by `setContext`.

Returns **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** the previously stored testing context

### setContext

Stores the provided context as the "global testing context".

Generally setup automatically by `setupContext`.

**Parameters**

-   `context` **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** the context to use

### unsetContext

Clear the "global testing context".

Generally invoked from `teardownContext`.

### teardownContext

Used by test framework addons to tear down the provided context after testing is completed.

Responsible for:

-   un-setting the "global testing context" (`unsetContext`)
-   destroy the contexts owner object
-   remove AJAX listeners

**Parameters**

-   `context` **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** the context to setup

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;void>** resolves when settled

### setupRenderingContext

Used by test framework addons to setup the provided context for rendering.

`setupContext` must have been ran on the provided context
prior to calling `setupRenderingContext`.

Responsible for:

-   Setup the basic framework used for rendering by the
    `render` helper.
-   Ensuring the event dispatcher is properly setup.
-   Setting `this.element` to the root element of the testing
    container (things rendered via `render` will go _into_ this
    element).

**Parameters**

-   `context` **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** the context to setup for rendering

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)>** resolves with the context that was setup

### teardownRenderingContext

Used by test framework addons to tear down the provided context after testing is completed.

Responsible for:

-   resetting the `ember-testing-container` to its original state (the value
    when `setupRenderingContext` was called).

**Parameters**

-   `context` **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** the context to setup

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;void>** resolves when settled

### getApplication

Retrieves the application instance stored by setApplication.

-   Used by `setupContext`.

### setApplication

Stores the provided application instance so that tests being ran will be aware of the application under test.

-   Required by `setupApplicationContext` method.
-   Used by `setupContext` and `setupRenderingContext` when present.

**Parameters**

-   `application` **Ember.Application** the application that will be tested

### setupApplicationContext

Used by test framework addons to setup the provided context for working with
an application (e.g. routing).

`setupContext` must have been ran on the provided context prior to calling
`setupApplicatinContext`.

Sets up the basic framework used by application tests.

**Parameters**

-   `context` **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** the context to setup

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)>** resolves with the context that was setup

### teardownApplicationContext

Used by test framework addons to tear down the provided context after testing is completed.

**Parameters**

-   `context` **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** the context to setup

Returns **[Promise](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Promise)&lt;void>** resolves when settled

### validateErrorHandler

Validate the provided error handler to confirm that it properly re-throws
errors when `Ember.testing` is true.

This is intended to be used by test framework hosts (or other libraries) to
ensure that `Ember.onerror` is properly configured. Without a check like
this, `Ember.onerror` could _easily_ swallow all errors and make it _seem_
like everything is just fine (and have green tests) when in reality
everything is on fire...

**Parameters**

-   `callback` **[Function](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Statements/function)** the callback to validate (optional, default `Ember.onerror`)

**Examples**

_Example implementation for `ember-qunit`_

```javascript
import { validateErrorHandler } from '@ember/test-helpers';

test('Ember.onerror is functioning properly', function(assert) {
  let result = validateErrorHandler();
  assert.ok(result.isValid, result.message);
});
```

Returns **[Object](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object)** object with `isValid` and `message`
