'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
    }
}

var Container = function () {
    function Container(registry) {
        var resolver = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

        _classCallCheck(this, Container);

        this._registry = registry;
        this._resolver = resolver;
        this._lookups = {};
        this._factoryDefinitionLookups = {};
    }

    Container.prototype.factoryFor = function factoryFor(specifier) {
        var factoryDefinition = this._factoryDefinitionLookups[specifier];
        if (!factoryDefinition) {
            if (this._resolver) {
                factoryDefinition = this._resolver.retrieve(specifier);
            }
            if (!factoryDefinition) {
                factoryDefinition = this._registry.registration(specifier);
            }
            if (factoryDefinition) {
                this._factoryDefinitionLookups[specifier] = factoryDefinition;
            }
        }
        if (!factoryDefinition) {
            return;
        }
        return this.buildFactory(specifier, factoryDefinition);
    };

    Container.prototype.lookup = function lookup(specifier) {
        var singleton = this._registry.registeredOption(specifier, 'singleton') !== false;
        if (singleton) {
            var lookup = this._lookups[specifier];
            if (lookup) {
                return lookup.instance;
            }
        }
        var factory = this.factoryFor(specifier);
        if (!factory) {
            return;
        }
        if (this._registry.registeredOption(specifier, 'instantiate') === false) {
            return factory.class;
        }
        var instance = factory.create();
        if (singleton && instance) {
            this._lookups[specifier] = { factory: factory, instance: instance };
        }
        return instance;
    };

    Container.prototype.defaultInjections = function defaultInjections(specifier) {
        return {};
    };

    Container.prototype.teardown = function teardown() {
        var specifiers = Object.keys(this._lookups);
        for (var i = 0; i < specifiers.length; i++) {
            var specifier = specifiers[i];
            var _lookups$specifier = this._lookups[specifier],
                factory = _lookups$specifier.factory,
                instance = _lookups$specifier.instance;

            factory.teardown(instance);
        }
    };

    Container.prototype.defaultTeardown = function defaultTeardown(instance) {};

    Container.prototype.buildInjections = function buildInjections(specifier) {
        var hash = this.defaultInjections(specifier);
        var injections = this._registry.registeredInjections(specifier);
        var injection = void 0;
        for (var i = 0; i < injections.length; i++) {
            injection = injections[i];
            hash[injection.property] = this.lookup(injection.source);
        }
        return hash;
    };

    Container.prototype.buildFactory = function buildFactory(specifier, factoryDefinition) {
        var _this = this;

        var injections = this.buildInjections(specifier);
        return {
            class: factoryDefinition,
            teardown: function (instance) {
                if (factoryDefinition.teardown) {
                    factoryDefinition.teardown(instance);
                } else {
                    _this.defaultTeardown(instance);
                }
            },
            create: function (options) {
                var mergedOptions = Object.assign({}, injections, options);
                return factoryDefinition.create(mergedOptions);
            }
        };
    };

    return Container;
}();

exports.default = Container;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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