export default class Registry {
    constructor(options) {
        this._registrations = {};
        this._registeredOptions = {};
        this._registeredInjections = {};
        if (options && options.fallback) {
            this._fallback = options.fallback;
        }
    }
    register(specifier, factoryDefinition, options) {
        this._registrations[specifier] = factoryDefinition;
        if (options) {
            this._registeredOptions[specifier] = options;
        }
    }
    registration(specifier) {
        let registration = this._registrations[specifier];
        if (registration === undefined && this._fallback) {
            registration = this._fallback.registration(specifier);
        }
        return registration;
    }
    unregister(specifier) {
        delete this._registrations[specifier];
        delete this._registeredOptions[specifier];
        delete this._registeredInjections[specifier];
    }
    registerOption(specifier, option, value) {
        let options = this._registeredOptions[specifier];
        if (!options) {
            options = {};
            this._registeredOptions[specifier] = options;
        }
        options[option] = value;
    }
    registeredOption(specifier, option) {
        let result;
        let options = this.registeredOptions(specifier);
        if (options) {
            result = options[option];
        }
        if (result === undefined && this._fallback !== undefined) {
            result = this._fallback.registeredOption(specifier, option);
        }
        return result;
    }
    registeredOptions(specifier) {
        let options = this._registeredOptions[specifier];
        if (options === undefined) {
            let [type] = specifier.split(':');
            options = this._registeredOptions[type];
        }
        return options;
    }
    unregisterOption(specifier, option) {
        let options = this._registeredOptions[specifier];
        if (options) {
            delete options[option];
        }
    }
    registerInjection(specifier, property, source) {
        let injections = this._registeredInjections[specifier];
        if (injections === undefined) {
            this._registeredInjections[specifier] = injections = [];
        }
        injections.push({
            property,
            source
        });
    }
    registeredInjections(specifier) {
        let [type] = specifier.split(':');
        let injections = this._fallback ? this._fallback.registeredInjections(specifier) : [];
        Array.prototype.push.apply(injections, this._registeredInjections[type]);
        Array.prototype.push.apply(injections, this._registeredInjections[specifier]);
        return injections;
    }
}
//# sourceMappingURL=data:application/json;base64,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