export function isSpecifierStringAbsolute(specifier) {
    let [type, path] = specifier.split(':');
    return !!(type && path && path.indexOf('/') === 0 && path.split('/').length > 3);
}
export function isSpecifierObjectAbsolute(specifier) {
    return specifier.rootName !== undefined &&
        specifier.collection !== undefined &&
        specifier.name !== undefined &&
        specifier.type !== undefined;
}
export function serializeSpecifier(specifier) {
    let type = specifier.type;
    let path = serializeSpecifierPath(specifier);
    if (path) {
        return type + ':' + path;
    }
    else {
        return type;
    }
}
export function serializeSpecifierPath(specifier) {
    let path = [];
    if (specifier.rootName) {
        path.push(specifier.rootName);
    }
    if (specifier.collection) {
        path.push(specifier.collection);
    }
    if (specifier.namespace) {
        path.push(specifier.namespace);
    }
    if (specifier.name) {
        path.push(specifier.name);
    }
    if (path.length > 0) {
        let fullPath = path.join('/');
        if (isSpecifierObjectAbsolute(specifier)) {
            fullPath = '/' + fullPath;
        }
        return fullPath;
    }
}
export function deserializeSpecifier(specifier) {
    let obj = {};
    if (specifier.indexOf(':') > -1) {
        let [type, path] = specifier.split(':');
        obj.type = type;
        let pathSegments;
        if (path.indexOf('/') === 0) {
            pathSegments = path.substr(1).split('/');
            obj.rootName = pathSegments.shift();
            obj.collection = pathSegments.shift();
        }
        else {
            pathSegments = path.split('/');
        }
        if (pathSegments.length > 0) {
            obj.name = pathSegments.pop();
            if (pathSegments.length > 0) {
                obj.namespace = pathSegments.join('/');
            }
        }
    }
    else {
        obj.type = specifier;
    }
    return obj;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3BlY2lmaWVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic3JjL3NwZWNpZmllci50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFRQSxNQUFNLG9DQUFvQyxTQUFpQjtJQUN6RCxJQUFJLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxHQUFHLFNBQVMsQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDeEMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksSUFBSSxJQUFJLElBQUksSUFBSSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsS0FBSyxDQUFDLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFDLENBQUM7QUFDbkYsQ0FBQztBQUVELE1BQU0sb0NBQW9DLFNBQW9CO0lBQzVELE1BQU0sQ0FBQyxTQUFTLENBQUMsUUFBUSxLQUFLLFNBQVM7UUFDaEMsU0FBUyxDQUFDLFVBQVUsS0FBSyxTQUFTO1FBQ2xDLFNBQVMsQ0FBQyxJQUFJLEtBQUssU0FBUztRQUM1QixTQUFTLENBQUMsSUFBSSxLQUFLLFNBQVMsQ0FBQztBQUN0QyxDQUFDO0FBRUQsTUFBTSw2QkFBNkIsU0FBb0I7SUFDckQsSUFBSSxJQUFJLEdBQUcsU0FBUyxDQUFDLElBQUksQ0FBQztJQUMxQixJQUFJLElBQUksR0FBRyxzQkFBc0IsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUU3QyxFQUFFLENBQUMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO1FBQ1QsTUFBTSxDQUFDLElBQUksR0FBRyxHQUFHLEdBQUcsSUFBSSxDQUFDO0lBQzNCLENBQUM7SUFBQyxJQUFJLENBQUMsQ0FBQztRQUNOLE1BQU0sQ0FBQyxJQUFJLENBQUM7SUFDZCxDQUFDO0FBQ0gsQ0FBQztBQUVELE1BQU0saUNBQWlDLFNBQW9CO0lBQ3pELElBQUksSUFBSSxHQUFHLEVBQUUsQ0FBQztJQUNkLEVBQUUsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO1FBQ3ZCLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLFFBQVEsQ0FBQyxDQUFDO0lBQ2hDLENBQUM7SUFDRCxFQUFFLENBQUMsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztRQUN6QixJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUNsQyxDQUFDO0lBQ0QsRUFBRSxDQUFDLENBQUMsU0FBUyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7UUFDeEIsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDakMsQ0FBQztJQUNELEVBQUUsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO1FBQ25CLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxDQUFDO0lBQzVCLENBQUM7SUFFRCxFQUFFLENBQUMsQ0FBQyxJQUFJLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDcEIsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztRQUM5QixFQUFFLENBQUMsQ0FBQyx5QkFBeUIsQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDekMsUUFBUSxHQUFHLEdBQUcsR0FBRyxRQUFRLENBQUM7UUFDNUIsQ0FBQztRQUNELE1BQU0sQ0FBQyxRQUFRLENBQUM7SUFDbEIsQ0FBQztBQUNILENBQUM7QUFFRCxNQUFNLCtCQUErQixTQUFpQjtJQUNwRCxJQUFJLEdBQUcsR0FBYyxFQUFFLENBQUM7SUFFeEIsRUFBRSxDQUFDLENBQUMsU0FBUyxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDaEMsSUFBSSxDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsR0FBRyxTQUFTLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ3hDLEdBQUcsQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDO1FBRWhCLElBQUksWUFBWSxDQUFDO1FBRWpCLEVBQUUsQ0FBQyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUM1QixZQUFZLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7WUFDekMsR0FBRyxDQUFDLFFBQVEsR0FBRyxZQUFZLENBQUMsS0FBSyxFQUFFLENBQUM7WUFDcEMsR0FBRyxDQUFDLFVBQVUsR0FBRyxZQUFZLENBQUMsS0FBSyxFQUFFLENBQUM7UUFDeEMsQ0FBQztRQUFDLElBQUksQ0FBQyxDQUFDO1lBQ04sWUFBWSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7UUFDakMsQ0FBQztRQUVELEVBQUUsQ0FBQyxDQUFDLFlBQVksQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUM1QixHQUFHLENBQUMsSUFBSSxHQUFHLFlBQVksQ0FBQyxHQUFHLEVBQUUsQ0FBQztZQUU5QixFQUFFLENBQUMsQ0FBQyxZQUFZLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUM7Z0JBQzVCLEdBQUcsQ0FBQyxTQUFTLEdBQUcsWUFBWSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQztZQUN6QyxDQUFDO1FBQ0gsQ0FBQztJQUVILENBQUM7SUFBQyxJQUFJLENBQUMsQ0FBQztRQUNOLEdBQUcsQ0FBQyxJQUFJLEdBQUcsU0FBUyxDQUFDO0lBQ3ZCLENBQUM7SUFFRCxNQUFNLENBQUMsR0FBRyxDQUFDO0FBQ2IsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBpbnRlcmZhY2UgU3BlY2lmaWVyIHtcbiAgcm9vdE5hbWU/OiBzdHJpbmc7XG4gIGNvbGxlY3Rpb24/OiBzdHJpbmc7XG4gIG5hbWVzcGFjZT86IHN0cmluZztcbiAgbmFtZT86IHN0cmluZztcbiAgdHlwZT86IHN0cmluZztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGlzU3BlY2lmaWVyU3RyaW5nQWJzb2x1dGUoc3BlY2lmaWVyOiBzdHJpbmcpOiBib29sZWFuIHtcbiAgbGV0IFt0eXBlLCBwYXRoXSA9IHNwZWNpZmllci5zcGxpdCgnOicpO1xuICByZXR1cm4gISEodHlwZSAmJiBwYXRoICYmIHBhdGguaW5kZXhPZignLycpID09PSAwICYmIHBhdGguc3BsaXQoJy8nKS5sZW5ndGggPiAzKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGlzU3BlY2lmaWVyT2JqZWN0QWJzb2x1dGUoc3BlY2lmaWVyOiBTcGVjaWZpZXIpOiBib29sZWFuIHtcbiAgcmV0dXJuIHNwZWNpZmllci5yb290TmFtZSAhPT0gdW5kZWZpbmVkICYmXG4gICAgICAgICBzcGVjaWZpZXIuY29sbGVjdGlvbiAhPT0gdW5kZWZpbmVkICYmXG4gICAgICAgICBzcGVjaWZpZXIubmFtZSAhPT0gdW5kZWZpbmVkICYmXG4gICAgICAgICBzcGVjaWZpZXIudHlwZSAhPT0gdW5kZWZpbmVkO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gc2VyaWFsaXplU3BlY2lmaWVyKHNwZWNpZmllcjogU3BlY2lmaWVyKTogc3RyaW5nIHtcbiAgbGV0IHR5cGUgPSBzcGVjaWZpZXIudHlwZTtcbiAgbGV0IHBhdGggPSBzZXJpYWxpemVTcGVjaWZpZXJQYXRoKHNwZWNpZmllcik7XG5cbiAgaWYgKHBhdGgpIHtcbiAgICByZXR1cm4gdHlwZSArICc6JyArIHBhdGg7XG4gIH0gZWxzZSB7XG4gICAgcmV0dXJuIHR5cGU7XG4gIH1cbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHNlcmlhbGl6ZVNwZWNpZmllclBhdGgoc3BlY2lmaWVyOiBTcGVjaWZpZXIpOiBzdHJpbmcge1xuICBsZXQgcGF0aCA9IFtdO1xuICBpZiAoc3BlY2lmaWVyLnJvb3ROYW1lKSB7XG4gICAgcGF0aC5wdXNoKHNwZWNpZmllci5yb290TmFtZSk7XG4gIH1cbiAgaWYgKHNwZWNpZmllci5jb2xsZWN0aW9uKSB7XG4gICAgcGF0aC5wdXNoKHNwZWNpZmllci5jb2xsZWN0aW9uKTtcbiAgfVxuICBpZiAoc3BlY2lmaWVyLm5hbWVzcGFjZSkge1xuICAgIHBhdGgucHVzaChzcGVjaWZpZXIubmFtZXNwYWNlKTtcbiAgfVxuICBpZiAoc3BlY2lmaWVyLm5hbWUpIHtcbiAgICBwYXRoLnB1c2goc3BlY2lmaWVyLm5hbWUpO1xuICB9XG5cbiAgaWYgKHBhdGgubGVuZ3RoID4gMCkge1xuICAgIGxldCBmdWxsUGF0aCA9IHBhdGguam9pbignLycpO1xuICAgIGlmIChpc1NwZWNpZmllck9iamVjdEFic29sdXRlKHNwZWNpZmllcikpIHtcbiAgICAgIGZ1bGxQYXRoID0gJy8nICsgZnVsbFBhdGg7XG4gICAgfVxuICAgIHJldHVybiBmdWxsUGF0aDtcbiAgfVxufVxuXG5leHBvcnQgZnVuY3Rpb24gZGVzZXJpYWxpemVTcGVjaWZpZXIoc3BlY2lmaWVyOiBzdHJpbmcpOiBTcGVjaWZpZXIge1xuICBsZXQgb2JqOiBTcGVjaWZpZXIgPSB7fTtcblxuICBpZiAoc3BlY2lmaWVyLmluZGV4T2YoJzonKSA+IC0xKSB7XG4gICAgbGV0IFt0eXBlLCBwYXRoXSA9IHNwZWNpZmllci5zcGxpdCgnOicpO1xuICAgIG9iai50eXBlID0gdHlwZTtcblxuICAgIGxldCBwYXRoU2VnbWVudHM7XG5cbiAgICBpZiAocGF0aC5pbmRleE9mKCcvJykgPT09IDApIHtcbiAgICAgIHBhdGhTZWdtZW50cyA9IHBhdGguc3Vic3RyKDEpLnNwbGl0KCcvJyk7XG4gICAgICBvYmoucm9vdE5hbWUgPSBwYXRoU2VnbWVudHMuc2hpZnQoKTtcbiAgICAgIG9iai5jb2xsZWN0aW9uID0gcGF0aFNlZ21lbnRzLnNoaWZ0KCk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHBhdGhTZWdtZW50cyA9IHBhdGguc3BsaXQoJy8nKTtcbiAgICB9XG5cbiAgICBpZiAocGF0aFNlZ21lbnRzLmxlbmd0aCA+IDApIHtcbiAgICAgIG9iai5uYW1lID0gcGF0aFNlZ21lbnRzLnBvcCgpO1xuXG4gICAgICBpZiAocGF0aFNlZ21lbnRzLmxlbmd0aCA+IDApIHtcbiAgICAgICAgb2JqLm5hbWVzcGFjZSA9IHBhdGhTZWdtZW50cy5qb2luKCcvJyk7XG4gICAgICB9XG4gICAgfVxuXG4gIH0gZWxzZSB7XG4gICAgb2JqLnR5cGUgPSBzcGVjaWZpZXI7XG4gIH1cblxuICByZXR1cm4gb2JqO1xufVxuIl19