'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.detectLocalResolutionCollection = detectLocalResolutionCollection;
function detectLocalResolutionCollection(specifier) {
    let { namespace, collection } = specifier;
    // Look for the local-most private collection contained in the namespace
    // (which will appear closest to the end of the string)
    let startPos = namespace.lastIndexOf('/-');
    if (startPos > -1) {
        startPos += 2;
        let endPos = namespace.indexOf('/', startPos);
        collection = namespace.slice(startPos, endPos > -1 ? endPos : undefined);
    }
    return collection;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3BlY2lmaWVycy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy91dGlscy9zcGVjaWZpZXJzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozt5Q0FFZ0QsQUFBb0I7QUFDbEUsUUFBSSxFQUFFLEFBQVMsV0FBRSxBQUFVLEFBQUUsZUFBRyxBQUFTLEFBQUM7QUFFMUMsQUFBd0U7QUFDeEUsQUFBdUQ7QUFDdkQsUUFBSSxBQUFRLFdBQUcsQUFBUyxVQUFDLEFBQVcsWUFBQyxBQUFJLEFBQUMsQUFBQztBQUMzQyxBQUFFLEFBQUMsUUFBQyxBQUFRLFdBQUcsQ0FBQyxBQUFDLEFBQUMsR0FBQyxBQUFDO0FBQ2xCLEFBQVEsb0JBQUksQUFBQyxBQUFDO0FBQ2QsWUFBSSxBQUFNLFNBQUcsQUFBUyxVQUFDLEFBQU8sUUFBQyxBQUFHLEtBQUUsQUFBUSxBQUFDLEFBQUM7QUFDOUMsQUFBVSxxQkFBRyxBQUFTLFVBQUMsQUFBSyxNQUFDLEFBQVEsVUFBRSxBQUFNLFNBQUcsQ0FBQyxBQUFDLElBQUcsQUFBTSxTQUFHLEFBQVMsQUFBQyxBQUFDLEFBQzNFO0FBQUM7QUFFRCxBQUFNLFdBQUMsQUFBVSxBQUFDLEFBQ3BCO0FBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBTcGVjaWZpZXIgfSBmcm9tICdAZ2xpbW1lci9kaSc7XG5cbmV4cG9ydCBmdW5jdGlvbiBkZXRlY3RMb2NhbFJlc29sdXRpb25Db2xsZWN0aW9uKHNwZWNpZmllcjogU3BlY2lmaWVyKTogc3RyaW5nIHtcbiAgbGV0IHsgbmFtZXNwYWNlLCBjb2xsZWN0aW9uIH0gPSBzcGVjaWZpZXI7XG5cbiAgLy8gTG9vayBmb3IgdGhlIGxvY2FsLW1vc3QgcHJpdmF0ZSBjb2xsZWN0aW9uIGNvbnRhaW5lZCBpbiB0aGUgbmFtZXNwYWNlXG4gIC8vICh3aGljaCB3aWxsIGFwcGVhciBjbG9zZXN0IHRvIHRoZSBlbmQgb2YgdGhlIHN0cmluZylcbiAgbGV0IHN0YXJ0UG9zID0gbmFtZXNwYWNlLmxhc3RJbmRleE9mKCcvLScpO1xuICBpZiAoc3RhcnRQb3MgPiAtMSkge1xuICAgIHN0YXJ0UG9zICs9IDI7XG4gICAgbGV0IGVuZFBvcyA9IG5hbWVzcGFjZS5pbmRleE9mKCcvJywgc3RhcnRQb3MpO1xuICAgIGNvbGxlY3Rpb24gPSBuYW1lc3BhY2Uuc2xpY2Uoc3RhcnRQb3MsIGVuZFBvcyA+IC0xID8gZW5kUG9zIDogdW5kZWZpbmVkKTtcbiAgfVxuXG4gIHJldHVybiBjb2xsZWN0aW9uO1xufVxuIl19