"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var escape_1 = require("./utils/escape");
var MochaTestGenerator = (function () {
    function MochaTestGenerator() {
    }
    MochaTestGenerator.prototype.suiteHeader = function (suiteName) {
        return "describe(" + escape_1.default(suiteName) + ", function() {\n";
    };
    MochaTestGenerator.prototype.suiteFooter = function () {
        return '});\n';
    };
    MochaTestGenerator.prototype.test = function (testName, passed, assertionMessage) {
        return ("  it(" + escape_1.default(testName) + ", function() {\n" +
            this.assertion(passed, assertionMessage || testName) +
            "  });\n");
    };
    MochaTestGenerator.prototype.assertion = function (passed, assertionMessage) {
        if (passed) {
            return "    // test passed\n";
        }
        return ("    // test failed\n" +
            ("    var error = new chai.AssertionError(" + escape_1.default(assertionMessage) + ");\n") +
            "    error.stack = undefined;\n" +
            "    throw error;\n");
    };
    return MochaTestGenerator;
}());
exports.default = MochaTestGenerator;
