"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var escape_1 = require("./utils/escape");
var QUnitTestGenerator = (function () {
    function QUnitTestGenerator() {
    }
    QUnitTestGenerator.prototype.suiteHeader = function (suiteName) {
        return "QUnit.module(" + escape_1.default(suiteName) + ");\n";
    };
    QUnitTestGenerator.prototype.suiteFooter = function () {
        return '';
    };
    QUnitTestGenerator.prototype.test = function (testName, passed, assertionMessage) {
        return ("QUnit.test(" + escape_1.default(testName) + ", function(assert) {\n" +
            "  assert.expect(1);\n" +
            ("  assert.ok(" + passed + ", " + escape_1.default(assertionMessage || testName) + ");\n") +
            "});\n");
    };
    return QUnitTestGenerator;
}());
exports.default = QUnitTestGenerator;
