'use strict';

const Command = require('../models/command');
const Promise = require('rsvp').Promise;
const mergeBlueprintOptions = require('../utilities/merge-blueprint-options');
const merge = require('ember-cli-lodash-subset').merge;
const SilentError = require('silent-error');

module.exports = Command.extend({
  name: 'destroy',
  description: 'Destroys code generated by `generate` command.',
  aliases: ['d'],
  works: 'insideProject',

  availableOptions: [
    { name: 'dry-run',       type: Boolean, default: false, aliases: ['d'] },
    { name: 'verbose',       type: Boolean, default: false, aliases: ['v'] },
    { name: 'pod',           type: Boolean, default: false, aliases: ['p'] },
    { name: 'classic',       type: Boolean, default: false, aliases: ['c'] },
    { name: 'dummy',         type: Boolean, default: false, aliases: ['dum', 'id'] },
    { name: 'in-repo-addon', type: String,  default: null,  aliases: ['in-repo', 'ir'] },
  ],

  anonymousOptions: [
    '<blueprint>',
  ],

  beforeRun: mergeBlueprintOptions,

  run(commandOptions, rawArgs) {
    let blueprintName = rawArgs[0];
    let entityName = rawArgs[1];

    if (!blueprintName) {
      return Promise.reject(new SilentError('The `ember destroy` command requires a ' +
                                            'blueprint name to be specified. ' +
                                            'For more details, use `ember help`.'));
    }

    if (!entityName) {
      return Promise.reject(new SilentError('The `ember destroy` command requires an ' +
                                            'entity name to be specified. ' +
                                            'For more details, use `ember help`.'));
    }

    let taskArgs = {
      args: rawArgs,
    };

    if (this.settings && this.settings.usePods && !commandOptions.classic) {
      commandOptions.pod = !commandOptions.pod;
    }

    let taskOptions = merge(taskArgs, commandOptions || {});

    if (this.project.initializeAddons) {
      this.project.initializeAddons();
    }

    return this.runTask('DestroyFromBlueprint', taskOptions);
  },

  printDetailedHelp() {
    let ui = this.ui;

    ui.writeLine('');
    ui.writeLine('  Run `ember help generate` to view a list of available blueprints.');
  },
});
