import { IHTTPClient } from "./http-client-factory";
export interface IAPIClientFactory {
    create(httpClient: IHTTPClient): IAPIClient;
}
export interface IAPIClient {
    version(): Promise<VersionInfo>;
    listTabs(): Promise<Tab[]>;
    newTab(url?: string): Promise<Tab>;
    activateTab(tabId: string): Promise<void>;
    closeTab(tabId: string): Promise<void>;
}
export interface Tab {
    id: string;
    webSocketDebuggerUrl?: string;
    description?: string;
    devtoolsFrontendUrl?: string;
    faviconUrl?: string;
    title?: string;
    type?: string;
    url?: string;
}
export interface VersionInfo {
    "Browser": string;
    "Protocol-Version": string;
    "User-Agent": string;
    "WebKit-Version": string;
}
export default class APIClientFactory implements IAPIClientFactory {
    create(httpClient: IHTTPClient): IAPIClient;
}
