"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
class APIClientFactory {
    create(httpClient) {
        return new APIClient(httpClient);
    }
}
exports.default = APIClientFactory;
class APIClient {
    constructor(httpClient) {
        this.httpClient = httpClient;
    }
    version() {
        return __awaiter(this, void 0, void 0, function* () {
            let body = yield this.httpClient.get("/json/version");
            return JSON.parse(body);
        });
    }
    listTabs() {
        return __awaiter(this, void 0, void 0, function* () {
            let body = yield this.httpClient.get("/json/list");
            return JSON.parse(body);
        });
    }
    newTab(url) {
        return __awaiter(this, void 0, void 0, function* () {
            let path = "/json/new";
            if (url) {
                path += "?" + encodeURIComponent(url);
            }
            let body = yield this.httpClient.get(path);
            return JSON.parse(body);
        });
    }
    activateTab(tabId) {
        return __awaiter(this, void 0, void 0, function* () {
            let path = "/json/activate/" + tabId;
            let body = yield this.httpClient.get(path);
            return;
        });
    }
    closeTab(tabId) {
        return __awaiter(this, void 0, void 0, function* () {
            let path = "/json/close/" + tabId;
            let body = yield this.httpClient.get(path);
            return;
        });
    }
}
//# sourceMappingURL=api-client-factory.js.map