export interface IBrowserResolver {
    resolve(browserType: string, options?: ResolveOptions): ExecutableInfo;
}
export declare type ResolveOptions = {
    executablePath?: string;
    chromiumSrcDir?: string;
};
export interface ExecutableInfo {
    executablePath: string;
    isContentShell: boolean;
}
export default class BrowserResolver implements IBrowserResolver {
    readonly platform: string;
    readonly chromiumAppName: string;
    readonly contentShellAppName: string;
    resolve(browserType: string, options?: ResolveOptions): ExecutableInfo;
    resolveChromiumBuild(browserType: string, options: ResolveOptions): string;
    resolveChromeApplication(browserType: string): string;
}
