import { Disposable } from "./common";
export declare type SpawnOptions = {
    windowSize?: {
        width: number;
        height: number;
    };
    additionalArguments?: string[];
};
export interface IBrowserSpawner {
    spawn(executablePath: string, dataDir: string, isContentShell: boolean, options?: SpawnOptions): Promise<IBrowserProcess>;
}
export interface IBrowserProcess extends Disposable {
    remoteDebuggingPort: number;
    dataDir: string;
    /** throws if process has exited or there has been an error */
    validate(): any;
}
export default class BrowserSpawner implements IBrowserSpawner {
    spawn(executablePath: string, dataDir: string, isContentShell: boolean, options?: SpawnOptions): Promise<IBrowserProcess>;
    getArguments(dataDir: string, isContentShell: boolean, options?: SpawnOptions): string[];
}
