import * as Protocol from "./protocol";
export interface ProtocolCodegenOptions {
    clientModuleName?: string;
    indent?: string;
    typescript?: boolean;
}
/**
 * Generate Typescript interface to use with the DebuggingProtocol#domains(protocol) method.
 */
export default class ProtocolCodegen {
    indent: string;
    typescript: boolean;
    clientModuleName: string;
    indentStack: string[];
    code: string;
    constructor(options: ProtocolCodegenOptions);
    readonly currentIndent: string;
    generate(protocol: Protocol.Protocol): string;
    appendProtocolVersionComment(version: Protocol.Version): void;
    appendClientImport(): void;
    appendDomainClass(domainName: string, cb: () => void): void;
    generateDomainTypeNamespace(domainName: string, cb: () => void): void;
    appendEventMember(event: Protocol.Event, domainName: string): void;
    appendClientMember(): void;
    appendDomainConstructor(): void;
    appendCommandMethod(command: Protocol.Command, domainName: string): void;
    appendEventAccessors(event: Protocol.Event, domainName: string): void;
    appendType(type: Protocol.Type): void;
    appendEventParametersType(event: Protocol.Event): void;
    appendEventHandlerType(event: Protocol.Event): void;
    block(cb: () => void): void;
    append(line: any): void;
    generateProperty(desc: Protocol.NamedDescriptor): void;
    appendComment(obj: {
        description?: string;
    }): void;
    appendCommandTypes(command: Protocol.Command): void;
    generateObjectTypeAlias(name: string, props: Protocol.NamedDescriptor[]): void;
    namedTypeString(desc: Protocol.NamedDescriptor): string;
    typeString(desc: Protocol.Descriptor): string;
}
