"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function eventPromise(emitter, resolveEvent, rejectEvent) {
    return new Promise((resolve, reject) => {
        let resolveHandler = evt => {
            resolve(evt);
            emitter.removeListener(resolveEvent, resolveHandler);
            emitter.removeListener(rejectEvent, rejectHandler);
        };
        let rejectHandler = evt => {
            reject(evt);
            emitter.removeListener(resolveEvent, resolveHandler);
            emitter.removeListener(rejectEvent, rejectHandler);
        };
        emitter.on(resolveEvent, resolveHandler);
        emitter.on(rejectEvent, rejectHandler);
    });
}
exports.eventPromise = eventPromise;
function delay(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
}
exports.delay = delay;
//# sourceMappingURL=common.js.map