"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const common_1 = require("./common");
const http_1 = require("http");
class HTTPClientFactory {
    create(host, port) {
        return new HTTPClient(host, port);
    }
}
exports.default = HTTPClientFactory;
class HTTPClient {
    constructor(host, port) {
        this.host = host;
        this.port = port;
    }
    get(path) {
        return __awaiter(this, void 0, void 0, function* () {
            let request = http_1.get({ host: this.host, port: this.port, path: path });
            let response = yield getResponse(request);
            let statusCode = response.statusCode;
            let body = yield readResponseBody(response);
            if (statusCode !== 200) {
                throw new ResponseError(body, statusCode);
            }
            return body;
        });
    }
}
function getResponse(request) {
    return __awaiter(this, void 0, void 0, function* () {
        return common_1.eventPromise(request, "response", "error");
    });
}
function readResponseBody(response) {
    return __awaiter(this, void 0, void 0, function* () {
        let body = "";
        response.setEncoding("utf8");
        response.on("data", chunk => {
            body += chunk;
        });
        yield common_1.eventPromise(response, "end", "error");
        return body;
    });
}
class ResponseError extends Error {
    constructor(message, statusCode) {
        super(message);
        this.statusCode = statusCode;
    }
}
//# sourceMappingURL=http-client-factory.js.map