import { ResolveOptions } from "./browser-resolver";
import { SpawnOptions, IBrowserProcess } from "./browser-spawner";
import { IAPIClient } from "./api-client-factory";
import { IDebuggingProtocolClient } from "./debugging-protocol-client-factory";
import { Disposable } from "./common";
/**
 * The session is a factory for the various debugging tools/clients that disposes them at the end.
 */
export interface ISession extends Disposable {
    spawnBrowser(browserType: string, options?: ResolveOptions & SpawnOptions): Promise<IBrowserProcess>;
    createAPIClient(host: any, port: any): IAPIClient;
    openDebuggingProtocol(webSocketDebuggerUrl: string): Promise<IDebuggingProtocolClient>;
}
export default function createSession<T>(cb: (session: ISession) => T | PromiseLike<T>): Promise<T>;
