"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const browser_resolver_1 = require("./browser-resolver");
const browser_spawner_1 = require("./browser-spawner");
const tmpdir_creator_1 = require("./tmpdir-creator");
const http_client_factory_1 = require("./http-client-factory");
const api_client_factory_1 = require("./api-client-factory");
const web_socket_opener_1 = require("./web-socket-opener");
const debugging_protocol_client_factory_1 = require("./debugging-protocol-client-factory");
function createSession(cb) {
    return __awaiter(this, void 0, void 0, function* () {
        let session = new Session(new browser_resolver_1.default(), new tmpdir_creator_1.default(), new browser_spawner_1.default(), new http_client_factory_1.default(), new api_client_factory_1.default(), new web_socket_opener_1.default(), new debugging_protocol_client_factory_1.default());
        try {
            return yield cb(session);
        }
        finally {
            yield session.dispose();
        }
    });
}
exports.default = createSession;
class Session {
    constructor(browserResolver, tmpDirCreator, browserSpawner, httpClientFactory, apiClientFactory, webSocketOpener, debuggingProtocolFactory) {
        this.disposables = [];
        this.browserResolver = browserResolver;
        this.tmpDirCreator = tmpDirCreator;
        this.browserSpawner = browserSpawner;
        this.httpClientFactory = httpClientFactory;
        this.apiClientFactory = apiClientFactory;
        this.webSocketOpener = webSocketOpener;
        this.debuggingProtocolFactory = debuggingProtocolFactory;
    }
    spawnBrowser(browserType, options) {
        return __awaiter(this, void 0, void 0, function* () {
            let browser = this.browserResolver.resolve(browserType, options);
            let tmpDir = yield this.tmpDirCreator.create();
            this.disposables.push(tmpDir);
            let process = yield this.browserSpawner.spawn(browser.executablePath, tmpDir.path, browser.isContentShell, options);
            this.disposables.push(process);
            return process;
        });
    }
    createAPIClient(host, port) {
        return this.apiClientFactory.create(this.httpClientFactory.create(host, port));
    }
    openDebuggingProtocol(webSocketDebuggerUrl) {
        return __awaiter(this, void 0, void 0, function* () {
            let debuggingProtocol = this.debuggingProtocolFactory.create();
            let connection = yield this.webSocketOpener.open(webSocketDebuggerUrl, debuggingProtocol);
            this.disposables.push(connection);
            return debuggingProtocol;
        });
    }
    dispose() {
        return __awaiter(this, void 0, void 0, function* () {
            let disposable;
            while (disposable = this.disposables.pop()) {
                yield disposable.dispose();
            }
        });
    }
}
//# sourceMappingURL=session.js.map