"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const os_1 = require("os");
const path = require("path");
const rimraf = require("rimraf");
const mktemp = require("mktemp");
class TmpDirCreator {
    create() {
        return __awaiter(this, void 0, void 0, function* () {
            let templatePath = path.join(os_1.tmpdir(), "tmpXXXXXX");
            let tmpDirPath = yield new Promise((resolve, reject) => {
                mktemp.createDir(templatePath, (err, path) => err ? reject(err) : resolve(path));
            });
            return new TmpDir(tmpDirPath);
        });
    }
}
exports.default = TmpDirCreator;
class TmpDir {
    constructor(path) {
        this.path = path;
    }
    dispose() {
        return new Promise((resolve, reject) => {
            rimraf(this.path, err => err ? reject(err) : resolve());
        }).catch(err => console.error(err));
    }
}
//# sourceMappingURL=tmpdir-creator.js.map