import { Disposable } from "./common";
export interface IWebSocketOpener {
    open(url: string, delegate: IWebSocketDelegate): Promise<IWebSocketConnection>;
}
export interface IWebSocketConnection extends Disposable {
}
export interface IWebSocketDelegate {
    socket: {
        send(data: string);
        close();
    };
    onMessage(data: string): any;
    onError(err: Error): any;
    onClose(): any;
}
export default class WebSocketOpener implements IWebSocketOpener {
    open(url: string, delegate: IWebSocketDelegate): Promise<IWebSocketConnection>;
}
