"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const common_1 = require("./common");
const WebSocket = require("ws");
class WebSocketOpener {
    open(url, delegate) {
        return new Promise(resolve => {
            let ws = new WebSocket(url);
            resolve(common_1.eventPromise(ws, "open", "error").then(() => {
                delegate.socket = ws;
                ws.on("message", data => delegate.onMessage(data));
                ws.on("error", err => delegate.onError(err));
                ws.on("close", () => delegate.onClose());
                return new WebSocketConnection(ws);
            }));
        });
    }
}
exports.default = WebSocketOpener;
class WebSocketConnection {
    constructor(ws) {
        this.ws = ws;
    }
    dispose() {
        return new Promise(resolve => {
            let ws = this.ws;
            if (ws.readyState === WebSocket.CLOSED) {
                resolve();
            }
            else {
                ws.close();
                resolve(common_1.eventPromise(ws, "close", "error"));
            }
        }).catch(err => console.error(err));
    }
}
//# sourceMappingURL=web-socket-opener.js.map