;(function() {
/*!
 * @overview  Ember - JavaScript Application Framework
 * @copyright Copyright 2011-2017 Tilde Inc. and contributors
 *            Portions Copyright 2006-2011 Strobe Inc.
 *            Portions Copyright 2008-2011 Apple Inc. All rights reserved.
 * @license   Licensed under MIT license
 *            See https://raw.github.com/emberjs/ember.js/master/LICENSE
 * @version   2.11.3
 */

var enifed, requireModule, Ember;
var mainContext = this; // Used in ember-environment/lib/global.js

(function() {
  var isNode = typeof window === 'undefined' &&
    typeof process !== 'undefined' && {}.toString.call(process) === '[object process]';

  if (!isNode) {
    Ember = this.Ember = this.Ember || {};
  }

  if (typeof Ember === 'undefined') { Ember = {}; }

  if (typeof Ember.__loader === 'undefined') {
    var registry = {};
    var seen = {};

    enifed = function(name, deps, callback) {
      var value = { };

      if (!callback) {
        value.deps = [];
        value.callback = deps;
      } else {
        value.deps = deps;
        value.callback = callback;
      }

      registry[name] = value;
    };

    requireModule = function(name) {
      return internalRequire(name, null);
    };

    // setup `require` module
    requireModule['default'] = requireModule;

    requireModule.has = function registryHas(moduleName) {
      return !!registry[moduleName] || !!registry[moduleName + '/index'];
    };

    function missingModule(name, referrerName) {
      if (referrerName) {
        throw new Error('Could not find module ' + name + ' required by: ' + referrerName);
      } else {
        throw new Error('Could not find module ' + name);
      }
    }

    function internalRequire(_name, referrerName) {
      var name = _name;
      var mod = registry[name];

      if (!mod) {
        name = name + '/index';
        mod = registry[name];
      }

      var exports = seen[name];

      if (exports !== undefined) {
        return exports;
      }

      exports = seen[name] = {};

      if (!mod) {
        missingModule(_name, referrerName);
      }

      var deps = mod.deps;
      var callback = mod.callback;
      var reified = new Array(deps.length);

      for (var i = 0; i < deps.length; i++) {
        if (deps[i] === 'exports') {
          reified[i] = exports;
        } else if (deps[i] === 'require') {
          reified[i] = requireModule;
        } else {
          reified[i] = internalRequire(deps[i], name);
        }
      }

      callback.apply(this, reified);

      return exports;
    }

    requireModule._eak_seen = registry;

    Ember.__loader = {
      define: enifed,
      require: requireModule,
      registry: registry
    };
  } else {
    enifed = Ember.__loader.define;
    requireModule = Ember.__loader.require;
  }
})();

function inherits(subClass, superClass) {
  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });

  if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : defaults(subClass, superClass);
}

function taggedTemplateLiteralLoose(strings, raw) {
  strings.raw = raw;
  return strings;
}

function defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ('value' in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}

function createClass(Constructor, protoProps, staticProps) {
  if (protoProps) defineProperties(Constructor.prototype, protoProps);
  if (staticProps) defineProperties(Constructor, staticProps);
  return Constructor;
}

function interopExportWildcard(obj, defaults) {
  var newObj = defaults({}, obj);
  delete newObj['default'];
  return newObj;
}

function defaults(obj, defaults) {
  var keys = Object.getOwnPropertyNames(defaults);
  for (var i = 0; i < keys.length; i++) {
    var key = keys[i];
    var value = Object.getOwnPropertyDescriptor(defaults, key);
    if (value && value.configurable && obj[key] === undefined) {
      Object.defineProperty(obj, key, value);
    }
  }
  return obj;
}

var babelHelpers = {
  inherits: inherits,
  taggedTemplateLiteralLoose: taggedTemplateLiteralLoose,
  slice: Array.prototype.slice,
  createClass: createClass,
  interopExportWildcard: interopExportWildcard,
  defaults: defaults
};

enifed('container/tests/container_test', ['exports', 'ember-utils', 'ember-environment', 'ember-metal', 'container/index', 'internal-test-helpers'], function (exports, _emberUtils, _emberEnvironment, _emberMetal, _containerIndex, _internalTestHelpers) {
  'use strict';

  var originalModelInjections = undefined;

  QUnit.module('Container', {
    setup: function () {
      originalModelInjections = _emberEnvironment.ENV.MODEL_FACTORY_INJECTIONS;
    },
    teardown: function () {
      _emberEnvironment.ENV.MODEL_FACTORY_INJECTIONS = originalModelInjections;
    }
  });

  QUnit.test('A registered factory returns the same instance each time', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var PostController = _internalTestHelpers.factory();

    registry.register('controller:post', PostController);

    var postController = container.lookup('controller:post');

    ok(postController instanceof PostController, 'The lookup is an instance of the factory');

    equal(postController, container.lookup('controller:post'));
  });

  QUnit.test('A registered factory is returned from lookupFactory', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var PostController = _internalTestHelpers.factory();

    registry.register('controller:post', PostController);

    var PostControllerFactory = container.lookupFactory('controller:post');

    ok(PostControllerFactory, 'factory is returned');
    ok(PostControllerFactory.create() instanceof PostController, 'The return of factory.create is an instance of PostController');
  });

  QUnit.test('A registered factory is returned from lookupFactory is the same factory each time', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var PostController = _internalTestHelpers.factory();

    registry.register('controller:post', PostController);

    deepEqual(container.lookupFactory('controller:post'), container.lookupFactory('controller:post'), 'The return of lookupFactory is always the same');
  });

  QUnit.test('A factory returned from lookupFactory has a debugkey', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var PostController = _internalTestHelpers.factory();

    registry.register('controller:post', PostController);
    var PostFactory = container.lookupFactory('controller:post');
    equal(PostFactory._debugContainerKey, 'controller:post', 'factory instance receives _debugContainerKey');
  });

  QUnit.test('fallback for to create time injections if factory has no extend', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var AppleController = _internalTestHelpers.factory();
    var PostController = _internalTestHelpers.factory();

    PostController.extend = undefined; // remove extend

    registry.register('controller:apple', AppleController);
    registry.register('controller:post', PostController);
    registry.injection('controller:post', 'apple', 'controller:apple');

    var postController = container.lookup('controller:post');

    equal(postController._debugContainerKey, 'controller:post', 'instance receives _debugContainerKey');
    ok(postController.apple instanceof AppleController, 'instance receives an apple of instance AppleController');
  });

  QUnit.test('The descendants of a factory returned from lookupFactory have a container and debugkey', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var PostController = _internalTestHelpers.factory();
    var instance = undefined;

    registry.register('controller:post', PostController);
    instance = container.lookupFactory('controller:post').create();

    equal(instance._debugContainerKey, 'controller:post', 'factory instance receives _debugContainerKey');

    ok(instance instanceof PostController, 'factory instance is instance of factory');
  });

  QUnit.test('A registered factory returns a fresh instance if singleton: false is passed as an option', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var PostController = _internalTestHelpers.factory();

    registry.register('controller:post', PostController);

    var postController1 = container.lookup('controller:post');
    var postController2 = container.lookup('controller:post', { singleton: false });
    var postController3 = container.lookup('controller:post', { singleton: false });
    var postController4 = container.lookup('controller:post');

    equal(postController1.toString(), postController4.toString(), 'Singleton factories looked up normally return the same value');
    notEqual(postController1.toString(), postController2.toString(), 'Singleton factories are not equal to factories looked up with singleton: false');
    notEqual(postController2.toString(), postController3.toString(), 'Two factories looked up with singleton: false are not equal');
    notEqual(postController3.toString(), postController4.toString(), 'A singleton factory looked up after a factory called with singleton: false is not equal');

    ok(postController1 instanceof PostController, 'All instances are instances of the registered factory');
    ok(postController2 instanceof PostController, 'All instances are instances of the registered factory');
    ok(postController3 instanceof PostController, 'All instances are instances of the registered factory');
    ok(postController4 instanceof PostController, 'All instances are instances of the registered factory');
  });

  QUnit.test('A factory type with a registered injection\'s instances receive that injection', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var PostController = _internalTestHelpers.factory();
    var Store = _internalTestHelpers.factory();

    registry.register('controller:post', PostController);
    registry.register('store:main', Store);

    registry.typeInjection('controller', 'store', 'store:main');

    var postController = container.lookup('controller:post');
    var store = container.lookup('store:main');

    equal(postController.store, store);
  });

  QUnit.test('An individual factory with a registered injection receives the injection', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var PostController = _internalTestHelpers.factory();
    var Store = _internalTestHelpers.factory();

    registry.register('controller:post', PostController);
    registry.register('store:main', Store);

    registry.injection('controller:post', 'store', 'store:main');

    var postController = container.lookup('controller:post');
    var store = container.lookup('store:main');

    equal(store._debugContainerKey, 'store:main');

    equal(postController._debugContainerKey, 'controller:post');
    equal(postController.store, store, 'has the correct store injected');
  });

  QUnit.test('A factory with both type and individual injections', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var PostController = _internalTestHelpers.factory();
    var Store = _internalTestHelpers.factory();
    var Router = _internalTestHelpers.factory();

    registry.register('controller:post', PostController);
    registry.register('store:main', Store);
    registry.register('router:main', Router);

    registry.injection('controller:post', 'store', 'store:main');
    registry.typeInjection('controller', 'router', 'router:main');

    var postController = container.lookup('controller:post');
    var store = container.lookup('store:main');
    var router = container.lookup('router:main');

    equal(postController.store, store);
    equal(postController.router, router);
  });

  QUnit.test('A factory with both type and individual factoryInjections', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var PostController = _internalTestHelpers.factory();
    var Store = _internalTestHelpers.factory();
    var Router = _internalTestHelpers.factory();

    registry.register('controller:post', PostController);
    registry.register('store:main', Store);
    registry.register('router:main', Router);

    registry.factoryInjection('controller:post', 'store', 'store:main');
    registry.factoryTypeInjection('controller', 'router', 'router:main');

    var PostControllerFactory = container.lookupFactory('controller:post');
    var store = container.lookup('store:main');
    var router = container.lookup('router:main');

    equal(PostControllerFactory.store, store, 'PostControllerFactory has the instance of store');
    equal(PostControllerFactory.router, router, 'PostControllerFactory has the route instance');
  });

  QUnit.test('A non-singleton instance is never cached', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var PostView = _internalTestHelpers.factory();

    registry.register('view:post', PostView, { singleton: false });

    var postView1 = container.lookup('view:post');
    var postView2 = container.lookup('view:post');

    ok(postView1 !== postView2, 'Non-singletons are not cached');
  });

  QUnit.test('A non-instantiated property is not instantiated', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();

    var template = function () {};
    registry.register('template:foo', template, { instantiate: false });
    equal(container.lookup('template:foo'), template);
  });

  QUnit.test('A failed lookup returns undefined', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();

    equal(container.lookup('doesnot:exist'), undefined);
  });

  QUnit.test('An invalid factory throws an error', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();

    registry.register('controller:foo', {});

    throws(function () {
      container.lookup('controller:foo');
    }, /Failed to create an instance of \'controller:foo\'/);
  });

  QUnit.test('Injecting a failed lookup raises an error', function () {
    _emberEnvironment.ENV.MODEL_FACTORY_INJECTIONS = true;

    var registry = new _containerIndex.Registry();
    var container = registry.container();

    var fooInstance = {};
    var fooFactory = {};

    var Foo = {
      create: function (args) {
        return fooInstance;
      },
      extend: function (args) {
        return fooFactory;
      }
    };

    registry.register('model:foo', Foo);
    registry.injection('model:foo', 'store', 'store:main');

    throws(function () {
      container.lookup('model:foo');
    });
  });

  QUnit.test('Injecting a falsy value does not raise an error', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var ApplicationController = _internalTestHelpers.factory();

    registry.register('controller:application', ApplicationController);
    registry.register('user:current', null, { instantiate: false });
    registry.injection('controller:application', 'currentUser', 'user:current');

    strictEqual(container.lookup('controller:application').currentUser, null);
  });

  QUnit.test('The container returns same value each time even if the value is falsy', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();

    registry.register('falsy:value', null, { instantiate: false });

    strictEqual(container.lookup('falsy:value'), container.lookup('falsy:value'));
  });

  QUnit.test('Destroying the container destroys any cached singletons', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var PostController = _internalTestHelpers.factory();
    var PostView = _internalTestHelpers.factory();
    var template = function () {};

    registry.register('controller:post', PostController);
    registry.register('view:post', PostView, { singleton: false });
    registry.register('template:post', template, { instantiate: false });

    registry.injection('controller:post', 'postView', 'view:post');

    var postController = container.lookup('controller:post');
    var postView = postController.postView;

    ok(postView instanceof PostView, 'The non-singleton was injected');

    container.destroy();

    ok(postController.isDestroyed, 'Singletons are destroyed');
    ok(!postView.isDestroyed, 'Non-singletons are not destroyed');
  });

  QUnit.test('The container can use a registry hook to resolve factories lazily', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var PostController = _internalTestHelpers.factory();

    registry.resolver = {
      resolve: function (fullName) {
        if (fullName === 'controller:post') {
          return PostController;
        }
      }
    };

    var postController = container.lookup('controller:post');

    ok(postController instanceof PostController, 'The correct factory was provided');
  });

  QUnit.test('The container normalizes names before resolving', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var PostController = _internalTestHelpers.factory();

    registry.normalizeFullName = function (fullName) {
      return 'controller:post';
    };

    registry.register('controller:post', PostController);
    var postController = container.lookup('controller:normalized');

    ok(postController instanceof PostController, 'Normalizes the name before resolving');
  });

  QUnit.test('The container normalizes names when looking factory up', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var PostController = _internalTestHelpers.factory();

    registry.normalizeFullName = function (fullName) {
      return 'controller:post';
    };

    registry.register('controller:post', PostController);
    var fact = container.lookupFactory('controller:normalized');

    equal(fact.toString() === PostController.extend().toString(), true, 'Normalizes the name when looking factory up');
  });

  QUnit.test('Options can be registered that should be applied to a given factory', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var PostView = _internalTestHelpers.factory();

    registry.resolver = {
      resolve: function (fullName) {
        if (fullName === 'view:post') {
          return PostView;
        }
      }
    };

    registry.options('view:post', { instantiate: true, singleton: false });

    var postView1 = container.lookup('view:post');
    var postView2 = container.lookup('view:post');

    ok(postView1 instanceof PostView, 'The correct factory was provided');
    ok(postView2 instanceof PostView, 'The correct factory was provided');

    ok(postView1 !== postView2, 'The two lookups are different');
  });

  QUnit.test('Options can be registered that should be applied to all factories for a given type', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var PostView = _internalTestHelpers.factory();

    registry.resolver = {
      resolve: function (fullName) {
        if (fullName === 'view:post') {
          return PostView;
        }
      }
    };

    registry.optionsForType('view', { singleton: false });

    var postView1 = container.lookup('view:post');
    var postView2 = container.lookup('view:post');

    ok(postView1 instanceof PostView, 'The correct factory was provided');
    ok(postView2 instanceof PostView, 'The correct factory was provided');

    ok(postView1 !== postView2, 'The two lookups are different');
  });

  QUnit.test('An injected non-singleton instance is never cached', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var PostView = _internalTestHelpers.factory();
    var PostViewHelper = _internalTestHelpers.factory();

    registry.register('view:post', PostView, { singleton: false });
    registry.register('view_helper:post', PostViewHelper, { singleton: false });
    registry.injection('view:post', 'viewHelper', 'view_helper:post');

    var postView1 = container.lookup('view:post');
    var postView2 = container.lookup('view:post');

    ok(postView1.viewHelper !== postView2.viewHelper, 'Injected non-singletons are not cached');
  });

  QUnit.test('Factory resolves are cached', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var PostController = _internalTestHelpers.factory();
    var resolveWasCalled = [];
    registry.resolve = function (fullName) {
      resolveWasCalled.push(fullName);
      return PostController;
    };

    deepEqual(resolveWasCalled, []);
    container.lookupFactory('controller:post');
    deepEqual(resolveWasCalled, ['controller:post']);

    container.lookupFactory('controller:post');
    deepEqual(resolveWasCalled, ['controller:post']);
  });

  QUnit.test('factory for non extendables (MODEL) resolves are cached', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var PostController = _internalTestHelpers.factory();
    var resolveWasCalled = [];
    registry.resolve = function (fullName) {
      resolveWasCalled.push(fullName);
      return PostController;
    };

    deepEqual(resolveWasCalled, []);
    container.lookupFactory('model:post');
    deepEqual(resolveWasCalled, ['model:post']);

    container.lookupFactory('model:post');
    deepEqual(resolveWasCalled, ['model:post']);
  });

  QUnit.test('factory for non extendables resolves are cached', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var PostController = {};
    var resolveWasCalled = [];

    registry.resolve = function (fullName) {
      resolveWasCalled.push(fullName);
      return PostController;
    };

    deepEqual(resolveWasCalled, []);
    container.lookupFactory('foo:post');
    deepEqual(resolveWasCalled, ['foo:post']);

    container.lookupFactory('foo:post');
    deepEqual(resolveWasCalled, ['foo:post']);
  });

  QUnit.test('The `_onLookup` hook is called on factories when looked up the first time', function () {
    expect(2);

    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var Apple = _internalTestHelpers.factory();

    Apple.reopenClass({
      _onLookup: function (fullName) {
        equal(fullName, 'apple:main', 'calls lazy injection method with the lookup full name');
        equal(this, Apple, 'calls lazy injection method in the factory context');
      }
    });

    registry.register('apple:main', Apple);

    container.lookupFactory('apple:main');
    container.lookupFactory('apple:main');
  });

  QUnit.test('A factory\'s lazy injections are validated when first instantiated', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var Apple = _internalTestHelpers.factory();
    var Orange = _internalTestHelpers.factory();

    Apple.reopenClass({
      _lazyInjections: function () {
        return ['orange:main', 'banana:main'];
      }
    });

    registry.register('apple:main', Apple);
    registry.register('orange:main', Orange);

    throws(function () {
      container.lookup('apple:main');
    }, /Attempting to inject an unknown injection: 'banana:main'/);
  });

  QUnit.test('Lazy injection validations are cached', function () {
    expect(1);

    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var Apple = _internalTestHelpers.factory();
    var Orange = _internalTestHelpers.factory();

    Apple.reopenClass({
      _lazyInjections: function () {
        ok(true, 'should call lazy injection method');
        return ['orange:main'];
      }
    });

    registry.register('apple:main', Apple);
    registry.register('orange:main', Orange);

    container.lookup('apple:main');
    container.lookup('apple:main');
  });

  QUnit.test('An object with its owner pre-set should be returned from ownerInjection', function () {
    var owner = {};
    var registry = new _containerIndex.Registry();
    var container = registry.container({ owner: owner });

    var result = container.ownerInjection();

    equal(result[_emberUtils.OWNER], owner, 'owner is properly included');
  });

  QUnit.test('A deprecated `container` property is appended to every object instantiated from an extendable factory', function () {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var PostController = _internalTestHelpers.factory();
    registry.register('controller:post', PostController);
    var postController = container.lookup('controller:post');

    expectDeprecation(function () {
      _emberMetal.get(postController, 'container');
    }, 'Using the injected `container` is deprecated. Please use the `getOwner` helper instead to access the owner of this object.');

    expectDeprecation(function () {
      var c = postController.container;
      strictEqual(c, container);
    }, 'Using the injected `container` is deprecated. Please use the `getOwner` helper instead to access the owner of this object.');
  });

  QUnit.test('A deprecated `container` property is appended to every object instantiated from a non-extendable factory, and a fake container is available during instantiation.', function () {
    expect(8);

    var owner = {};
    var registry = new _containerIndex.Registry();
    var container = registry.container({ owner: owner });

    // Define a simple non-extendable factory
    function PostController(options) {
      this.container = options.container;
    }

    PostController.create = function (options) {
      ok(options.container, 'fake container has been injected and is available during `create`.');

      expectDeprecation(function () {
        options.container.lookup('abc:one');
      }, 'Using the injected `container` is deprecated. Please use the `getOwner` helper to access the owner of this object and then call `lookup` instead.');

      expectDeprecation(function () {
        options.container.lookupFactory('abc:two');
      }, 'Using the injected `container` is deprecated. Please use the `getOwner` helper to access the owner of this object and then call `_lookupFactory` instead.');

      // non-deprecated usage of `lookup` and `_lookupFactory`
      owner.lookup = function (fullName) {
        equal(fullName, 'abc:one', 'lookup on owner called properly');
      };
      owner._lookupFactory = function (fullName) {
        equal(fullName, 'abc:two', '_lookupFactory on owner called properly');
      };
      var foundOwner = _emberUtils.getOwner(options);
      foundOwner.lookup('abc:one');
      foundOwner._lookupFactory('abc:two');

      return new PostController(options);
    };

    registry.register('controller:post', PostController);
    var postController = container.lookup('controller:post');

    expectDeprecation(function () {
      _emberMetal.get(postController, 'container');
    }, 'Using the injected `container` is deprecated. Please use the `getOwner` helper instead to access the owner of this object.');

    expectDeprecation(function () {
      var c = postController.container;
      strictEqual(c, container, 'Injected container is now regular (not fake) container, but access is still deprecated.');
    }, 'Using the injected `container` is deprecated. Please use the `getOwner` helper instead to access the owner of this object.');
  });

  QUnit.test('A deprecated `container` property is only set on a non-extendable factory instance if `container` is present and writable.', function () {
    expect(2);

    var owner = {};
    var registry = new _containerIndex.Registry();
    var container = registry.container({ owner: owner });

    // Define a non-extendable factory that is frozen after `create`
    var PostController = function () {};
    PostController.create = function () {
      var instance = new PostController();

      Object.seal(instance);

      return instance;
    };

    registry.register('controller:post', PostController);
    var postController = container.lookup('controller:post');

    equal(postController.container, undefined, 'container was not added');

    var OtherController = function () {
      this.container = 'foo';
    };

    OtherController.create = function () {
      var instance = new OtherController();

      Object.freeze(instance);

      return instance;
    };

    registry.register('controller:other', OtherController);
    var otherController = container.lookup('controller:other');

    equal(otherController.container, 'foo', 'container was not added');
  });

  QUnit.test('An extendable factory can provide `container` upon create, with a deprecation', function (assert) {
    var registry = new _containerIndex.Registry();
    var container = registry.container();

    registry.register('controller:post', _internalTestHelpers.factory());

    var PostController = container.lookupFactory('controller:post');

    var postController = undefined;

    expectDeprecation(function () {
      postController = PostController.create({
        container: 'foo'
      });
    }, /Providing the \`container\` property to .+ is deprecated. Please use \`Ember.setOwner\` or \`owner.ownerInjection\(\)\` instead to provide an owner to the instance being created/);

    expectDeprecation(function () {
      var c = postController.container;
      assert.equal(c, 'foo', 'the `container` provided to `.create`was used');
    }, 'Using the injected `container` is deprecated. Please use the `getOwner` helper instead to access the owner of this object.');
  });

  QUnit.test('lookupFactory passes options through to expandlocallookup', function (assert) {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var PostController = _internalTestHelpers.factory();

    registry.register('controller:post', PostController);

    registry.expandLocalLookup = function (fullName, options) {
      assert.ok(true, 'expandLocalLookup was called');
      assert.equal(fullName, 'foo:bar');
      assert.deepEqual(options, { source: 'baz:qux' });

      return 'controller:post';
    };

    var PostControllerFactory = container.lookupFactory('foo:bar', { source: 'baz:qux' });

    assert.ok(PostControllerFactory.create() instanceof PostController, 'The return of factory.create is an instance of PostController');
  });

  QUnit.test('lookup passes options through to expandlocallookup', function (assert) {
    var registry = new _containerIndex.Registry();
    var container = registry.container();
    var PostController = _internalTestHelpers.factory();

    registry.register('controller:post', PostController);

    registry.expandLocalLookup = function (fullName, options) {
      assert.ok(true, 'expandLocalLookup was called');
      assert.equal(fullName, 'foo:bar');
      assert.deepEqual(options, { source: 'baz:qux' });

      return 'controller:post';
    };

    var PostControllerLookupResult = container.lookup('foo:bar', { source: 'baz:qux' });

    assert.ok(PostControllerLookupResult instanceof PostController);
  });
});
enifed('container/tests/owner_test', ['exports', 'ember-utils'], function (exports, _emberUtils) {
  'use strict';

  QUnit.module('Owner', {});

  QUnit.test('An owner can be set with `setOwner` and retrieved with `getOwner`', function () {
    var owner = {};
    var obj = {};

    strictEqual(_emberUtils.getOwner(obj), undefined, 'owner has not been set');

    _emberUtils.setOwner(obj, owner);

    strictEqual(_emberUtils.getOwner(obj), owner, 'owner has been set');

    strictEqual(obj[_emberUtils.OWNER], owner, 'owner has been set to the OWNER symbol');
  });
});
enifed('container/tests/registry_test', ['exports', 'container/index', 'internal-test-helpers'], function (exports, _containerIndex, _internalTestHelpers) {
  'use strict';

  QUnit.module('Registry');

  QUnit.test('A registered factory is returned from resolve', function () {
    var registry = new _containerIndex.Registry();
    var PostController = _internalTestHelpers.factory();

    registry.register('controller:post', PostController);

    var PostControllerFactory = registry.resolve('controller:post');

    ok(PostControllerFactory, 'factory is returned');
    ok(PostControllerFactory.create() instanceof PostController, 'The return of factory.create is an instance of PostController');
  });

  QUnit.test('The registered factory returned from resolve is the same factory each time', function () {
    var registry = new _containerIndex.Registry();
    var PostController = _internalTestHelpers.factory();

    registry.register('controller:post', PostController);

    deepEqual(registry.resolve('controller:post'), registry.resolve('controller:post'), 'The return of resolve is always the same');
  });

  QUnit.test('The registered value returned from resolve is the same value each time even if the value is falsy', function () {
    var registry = new _containerIndex.Registry();

    registry.register('falsy:value', null, { instantiate: false });

    strictEqual(registry.resolve('falsy:value'), registry.resolve('falsy:value'), 'The return of resolve is always the same');
  });

  QUnit.test('The value returned from resolver is the same value as the original value even if the value is falsy', function () {
    var resolver = {
      resolve: function (fullName) {
        if (fullName === 'falsy:value') {
          return null;
        }
      }
    };
    var registry = new _containerIndex.Registry({ resolver: resolver });

    strictEqual(registry.resolve('falsy:value'), null);
  });

  QUnit.test('A registered factory returns true for `has` if an item is registered', function () {
    var registry = new _containerIndex.Registry();
    var PostController = _internalTestHelpers.factory();

    registry.register('controller:post', PostController);

    equal(registry.has('controller:post'), true, 'The `has` method returned true for registered factories');
    equal(registry.has('controller:posts'), false, 'The `has` method returned false for unregistered factories');
  });

  QUnit.test('Throw exception when trying to inject `type:thing` on all type(s)', function () {
    var registry = new _containerIndex.Registry();
    var PostController = _internalTestHelpers.factory();

    registry.register('controller:post', PostController);

    throws(function () {
      registry.typeInjection('controller', 'injected', 'controller:post');
    }, /Cannot inject a 'controller:post' on other controller\(s\)\./);
  });

  QUnit.test('The registry can take a hook to resolve factories lazily', function () {
    var PostController = _internalTestHelpers.factory();
    var resolver = {
      resolve: function (fullName) {
        if (fullName === 'controller:post') {
          return PostController;
        }
      }
    };
    var registry = new _containerIndex.Registry({ resolver: resolver });

    strictEqual(registry.resolve('controller:post'), PostController, 'The correct factory was provided');
  });

  QUnit.test('The registry respects the resolver hook for `has`', function () {
    var PostController = _internalTestHelpers.factory();
    var resolver = {
      resolve: function (fullName) {
        if (fullName === 'controller:post') {
          return PostController;
        }
      }
    };
    var registry = new _containerIndex.Registry({ resolver: resolver });

    ok(registry.has('controller:post'), 'the `has` method uses the resolver hook');
  });

  QUnit.test('The registry normalizes names when resolving', function () {
    var registry = new _containerIndex.Registry();
    var PostController = _internalTestHelpers.factory();

    registry.normalizeFullName = function (fullName) {
      return 'controller:post';
    };

    registry.register('controller:post', PostController);
    var type = registry.resolve('controller:normalized');

    strictEqual(type, PostController, 'Normalizes the name when resolving');
  });

  QUnit.test('The registry normalizes names when checking if the factory is registered', function () {
    var registry = new _containerIndex.Registry();
    var PostController = _internalTestHelpers.factory();

    registry.normalizeFullName = function (fullName) {
      return fullName === 'controller:normalized' ? 'controller:post' : fullName;
    };

    registry.register('controller:post', PostController);
    var isPresent = registry.has('controller:normalized');

    equal(isPresent, true, 'Normalizes the name when checking if the factory or instance is present');
  });

  QUnit.test('validateFullName throws an error if name is incorrect', function () {
    expect(2);

    var registry = new _containerIndex.Registry();
    var PostController = _internalTestHelpers.factory();

    registry.normalize = function (fullName) {
      return 'controller:post';
    };

    registry.register('controller:post', PostController);
    throws(function () {
      registry.validateFullName('post');
    }, /TypeError: Invalid Fullname, expected: 'type:name' got: post/);

    throws(function () {
      registry.validateFullName('route:http://foo.bar.com/baz');
    }, /TypeError: Invalid Fullname, expected: 'type:name' got: route:http:\/\/foo.bar.com\/baz/);
  });

  QUnit.test('The registry normalizes names when injecting', function () {
    var registry = new _containerIndex.Registry();
    var PostController = _internalTestHelpers.factory();
    var user = { name: 'Stef' };

    registry.normalize = function (fullName) {
      return 'controller:post';
    };

    registry.register('controller:post', PostController);
    registry.register('user:post', user, { instantiate: false });
    registry.injection('controller:post', 'user', 'controller:normalized');

    deepEqual(registry.resolve('controller:post'), user, 'Normalizes the name when injecting');
  });

  QUnit.test('cannot register an `undefined` factory', function () {
    var registry = new _containerIndex.Registry();

    throws(function () {
      registry.register('controller:apple', undefined);
    }, '');
  });

  QUnit.test('can re-register a factory', function () {
    var registry = new _containerIndex.Registry();
    var FirstApple = _internalTestHelpers.factory('first');
    var SecondApple = _internalTestHelpers.factory('second');

    registry.register('controller:apple', FirstApple);
    registry.register('controller:apple', SecondApple);

    ok(registry.resolve('controller:apple').create() instanceof SecondApple);
  });

  QUnit.test('cannot re-register a factory if it has been resolved', function () {
    var registry = new _containerIndex.Registry();
    var FirstApple = _internalTestHelpers.factory('first');
    var SecondApple = _internalTestHelpers.factory('second');

    registry.register('controller:apple', FirstApple);
    strictEqual(registry.resolve('controller:apple'), FirstApple);

    throws(function () {
      registry.register('controller:apple', SecondApple);
    }, /Cannot re-register: 'controller:apple', as it has already been resolved\./);

    strictEqual(registry.resolve('controller:apple'), FirstApple);
  });

  QUnit.test('registry.has should not accidentally cause injections on that factory to be run. (Mitigate merely on observing)', function () {
    expect(1);

    var registry = new _containerIndex.Registry();
    var FirstApple = _internalTestHelpers.factory('first');
    var SecondApple = _internalTestHelpers.factory('second');

    SecondApple.extend = function (a, b, c) {
      ok(false, 'should not extend or touch the injected model, merely to inspect existence of another');
    };

    registry.register('controller:apple', FirstApple);
    registry.register('controller:second-apple', SecondApple);
    registry.injection('controller:apple', 'badApple', 'controller:second-apple');

    ok(registry.has('controller:apple'));
  });

  QUnit.test('registry.has should not error for invalid fullNames)', function () {
    expect(1);

    var registry = new _containerIndex.Registry();

    ok(!registry.has('foo:bar:baz'));
  });

  QUnit.test('once resolved, always return the same result', function () {
    expect(1);

    var registry = new _containerIndex.Registry();

    registry.resolver = {
      resolve: function () {
        return 'bar';
      }
    };

    var Bar = registry.resolve('models:bar');

    registry.resolver = {
      resolve: function () {
        return 'not bar';
      }
    };

    equal(registry.resolve('models:bar'), Bar);
  });

  QUnit.test('factory resolves are cached', function () {
    var registry = new _containerIndex.Registry();
    var PostController = _internalTestHelpers.factory();
    var resolveWasCalled = [];

    registry.resolver = {
      resolve: function (fullName) {
        resolveWasCalled.push(fullName);
        return PostController;
      }
    };

    deepEqual(resolveWasCalled, []);
    registry.resolve('controller:post');
    deepEqual(resolveWasCalled, ['controller:post']);

    registry.resolve('controller:post');
    deepEqual(resolveWasCalled, ['controller:post']);
  });

  QUnit.test('factory for non extendables (MODEL) resolves are cached', function () {
    var registry = new _containerIndex.Registry();
    var PostController = _internalTestHelpers.factory();
    var resolveWasCalled = [];

    registry.resolver = {
      resolve: function (fullName) {
        resolveWasCalled.push(fullName);
        return PostController;
      }
    };

    deepEqual(resolveWasCalled, []);
    registry.resolve('model:post');
    deepEqual(resolveWasCalled, ['model:post']);

    registry.resolve('model:post');
    deepEqual(resolveWasCalled, ['model:post']);
  });

  QUnit.test('factory for non extendables resolves are cached', function () {
    var registry = new _containerIndex.Registry();
    var PostController = {};
    var resolveWasCalled = [];

    registry.resolver = {
      resolve: function (fullName) {
        resolveWasCalled.push(fullName);
        return PostController;
      }
    };

    deepEqual(resolveWasCalled, []);
    registry.resolve('foo:post');
    deepEqual(resolveWasCalled, ['foo:post']);

    registry.resolve('foo:post');
    deepEqual(resolveWasCalled, ['foo:post']);
  });

  QUnit.test('registry.container creates a container', function () {
    var registry = new _containerIndex.Registry();
    var PostController = _internalTestHelpers.factory();
    registry.register('controller:post', PostController);

    var container = registry.container();
    var postController = container.lookup('controller:post');

    ok(postController instanceof PostController, 'The lookup is an instance of the registered factory');
  });

  QUnit.test('`describe` will be handled by the resolver, then by the fallback registry, if available', function () {
    var fallback = {
      describe: function (fullName) {
        return fullName + '-fallback';
      }
    };

    var resolver = {
      lookupDescription: function (fullName) {
        return fullName + '-resolver';
      }
    };

    var registry = new _containerIndex.Registry({ fallback: fallback, resolver: resolver });

    equal(registry.describe('controller:post'), 'controller:post-resolver', '`describe` handled by the resolver first.');

    registry.resolver = null;

    equal(registry.describe('controller:post'), 'controller:post-fallback', '`describe` handled by fallback registry next.');

    registry.fallback = null;

    equal(registry.describe('controller:post'), 'controller:post', '`describe` by default returns argument.');
  });

  QUnit.test('`normalizeFullName` will be handled by the resolver, then by the fallback registry, if available', function () {
    var fallback = {
      normalizeFullName: function (fullName) {
        return fullName + '-fallback';
      }
    };

    var resolver = {
      normalize: function (fullName) {
        return fullName + '-resolver';
      }
    };

    var registry = new _containerIndex.Registry({ fallback: fallback, resolver: resolver });

    equal(registry.normalizeFullName('controller:post'), 'controller:post-resolver', '`normalizeFullName` handled by the resolver first.');

    registry.resolver = null;

    equal(registry.normalizeFullName('controller:post'), 'controller:post-fallback', '`normalizeFullName` handled by fallback registry next.');

    registry.fallback = null;

    equal(registry.normalizeFullName('controller:post'), 'controller:post', '`normalizeFullName` by default returns argument.');
  });

  QUnit.test('`makeToString` will be handled by the resolver, then by the fallback registry, if available', function () {
    var fallback = {
      makeToString: function (fullName) {
        return fullName + '-fallback';
      }
    };

    var resolver = {
      makeToString: function (fullName) {
        return fullName + '-resolver';
      }
    };

    var registry = new _containerIndex.Registry({ fallback: fallback, resolver: resolver });

    equal(registry.makeToString('controller:post'), 'controller:post-resolver', '`makeToString` handled by the resolver first.');

    registry.resolver = null;

    equal(registry.makeToString('controller:post'), 'controller:post-fallback', '`makeToString` handled by fallback registry next.');

    registry.fallback = null;

    equal(registry.makeToString('controller:post'), 'controller:post', '`makeToString` by default returns argument.');
  });

  QUnit.test('`resolve` can be handled by a fallback registry', function () {
    var fallback = new _containerIndex.Registry();

    var registry = new _containerIndex.Registry({ fallback: fallback });
    var PostController = _internalTestHelpers.factory();

    fallback.register('controller:post', PostController);

    var PostControllerFactory = registry.resolve('controller:post');

    ok(PostControllerFactory, 'factory is returned');
    ok(PostControllerFactory.create() instanceof PostController, 'The return of factory.create is an instance of PostController');
  });

  QUnit.test('`has` can be handled by a fallback registry', function () {
    var fallback = new _containerIndex.Registry();

    var registry = new _containerIndex.Registry({ fallback: fallback });
    var PostController = _internalTestHelpers.factory();

    fallback.register('controller:post', PostController);

    equal(registry.has('controller:post'), true, 'Fallback registry is checked for registration');
  });

  QUnit.test('`getInjections` includes injections from a fallback registry', function () {
    var fallback = new _containerIndex.Registry();
    var registry = new _containerIndex.Registry({ fallback: fallback });

    equal(registry.getInjections('model:user').length, 0, 'No injections in the primary registry');

    fallback.injection('model:user', 'post', 'model:post');

    equal(registry.getInjections('model:user').length, 1, 'Injections from the fallback registry are merged');
  });

  QUnit.test('`getTypeInjections` includes type injections from a fallback registry', function () {
    var fallback = new _containerIndex.Registry();
    var registry = new _containerIndex.Registry({ fallback: fallback });

    equal(registry.getTypeInjections('model').length, 0, 'No injections in the primary registry');

    fallback.injection('model', 'source', 'source:main');

    equal(registry.getTypeInjections('model').length, 1, 'Injections from the fallback registry are merged');
  });

  QUnit.test('`getFactoryInjections` includes factory injections from a fallback registry', function () {
    var fallback = new _containerIndex.Registry();
    var registry = new _containerIndex.Registry({ fallback: fallback });

    equal(registry.getFactoryInjections('model:user').length, 0, 'No factory injections in the primary registry');

    fallback.factoryInjection('model:user', 'store', 'store:main');

    equal(registry.getFactoryInjections('model:user').length, 1, 'Factory injections from the fallback registry are merged');
  });

  QUnit.test('`getFactoryTypeInjections` includes factory type injections from a fallback registry', function () {
    var fallback = new _containerIndex.Registry();
    var registry = new _containerIndex.Registry({ fallback: fallback });

    equal(registry.getFactoryTypeInjections('model').length, 0, 'No factory type injections in the primary registry');

    fallback.factoryInjection('model', 'store', 'store:main');

    equal(registry.getFactoryTypeInjections('model').length, 1, 'Factory type injections from the fallback registry are merged');
  });

  QUnit.test('`knownForType` contains keys for each item of a given type', function () {
    var registry = new _containerIndex.Registry();

    registry.register('foo:bar-baz', 'baz');
    registry.register('foo:qux-fez', 'fez');

    var found = registry.knownForType('foo');

    deepEqual(found, {
      'foo:bar-baz': true,
      'foo:qux-fez': true
    });
  });

  QUnit.test('`knownForType` includes fallback registry results', function () {
    var fallback = new _containerIndex.Registry();
    var registry = new _containerIndex.Registry({ fallback: fallback });

    registry.register('foo:bar-baz', 'baz');
    registry.register('foo:qux-fez', 'fez');
    fallback.register('foo:zurp-zorp', 'zorp');

    var found = registry.knownForType('foo');

    deepEqual(found, {
      'foo:bar-baz': true,
      'foo:qux-fez': true,
      'foo:zurp-zorp': true
    });
  });

  QUnit.test('`knownForType` is called on the resolver if present', function () {
    expect(3);

    var resolver = {
      knownForType: function (type) {
        ok(true, 'knownForType called on the resolver');
        equal(type, 'foo', 'the type was passed through');

        return { 'foo:yorp': true };
      }
    };

    var registry = new _containerIndex.Registry({
      resolver: resolver
    });
    registry.register('foo:bar-baz', 'baz');

    var found = registry.knownForType('foo');

    deepEqual(found, {
      'foo:yorp': true,
      'foo:bar-baz': true
    });
  });

  QUnit.test('A registry can be created with a deprecated `resolver` function instead of an object', function () {
    expect(2);

    var registry = undefined;

    expectDeprecation(function () {
      registry = new _containerIndex.Registry({
        resolver: function (fullName) {
          return fullName + '-resolved';
        }
      });
    }, 'Passing a `resolver` function into a Registry is deprecated. Please pass in a Resolver object with a `resolve` method.');

    equal(registry.resolve('foo:bar'), 'foo:bar-resolved', '`resolve` still calls the deprecated function');
  });

  QUnit.test('resolver.expandLocalLookup is not required', function (assert) {
    assert.expect(1);

    var registry = new _containerIndex.Registry({
      resolver: {}
    });

    var result = registry.expandLocalLookup('foo:bar', {
      source: 'baz:qux'
    });

    assert.equal(result, null);
  });

  QUnit.test('expandLocalLookup is called on the resolver if present', function (assert) {
    assert.expect(4);

    var resolver = {
      expandLocalLookup: function (targetFullName, sourceFullName) {
        assert.ok(true, 'expandLocalLookup is called on the resolver');
        assert.equal(targetFullName, 'foo:bar', 'the targetFullName was passed through');
        assert.equal(sourceFullName, 'baz:qux', 'the sourceFullName was passed through');

        return 'foo:qux/bar';
      }
    };

    var registry = new _containerIndex.Registry({
      resolver: resolver
    });

    var result = registry.expandLocalLookup('foo:bar', {
      source: 'baz:qux'
    });

    assert.equal(result, 'foo:qux/bar');
  });

  QUnit.test('`expandLocalLookup` is handled by the resolver, then by the fallback registry, if available', function (assert) {
    assert.expect(9);

    var fallbackResolver = {
      expandLocalLookup: function (targetFullName, sourceFullName) {
        assert.ok(true, 'expandLocalLookup is called on the fallback resolver');
        assert.equal(targetFullName, 'foo:bar', 'the targetFullName was passed through');
        assert.equal(sourceFullName, 'baz:qux', 'the sourceFullName was passed through');

        return 'foo:qux/bar-fallback';
      }
    };

    var resolver = {
      expandLocalLookup: function (targetFullName, sourceFullName) {
        assert.ok(true, 'expandLocalLookup is called on the resolver');
        assert.equal(targetFullName, 'foo:bar', 'the targetFullName was passed through');
        assert.equal(sourceFullName, 'baz:qux', 'the sourceFullName was passed through');

        return 'foo:qux/bar-resolver';
      }
    };

    var fallbackRegistry = new _containerIndex.Registry({
      resolver: fallbackResolver
    });

    var registry = new _containerIndex.Registry({
      fallback: fallbackRegistry,
      resolver: resolver
    });

    var result = registry.expandLocalLookup('foo:bar', {
      source: 'baz:qux'
    });

    assert.equal(result, 'foo:qux/bar-resolver', 'handled by the resolver');

    registry.resolver = null;

    result = registry.expandLocalLookup('foo:bar', {
      source: 'baz:qux'
    });

    assert.equal(result, 'foo:qux/bar-fallback', 'handled by the fallback registry');

    registry.fallback = null;

    result = registry.expandLocalLookup('foo:bar', {
      source: 'baz:qux'
    });

    assert.equal(result, null, 'null is returned by default when no resolver or fallback registry is present');
  });

  QUnit.test('resolver.expandLocalLookup result is cached', function (assert) {
    assert.expect(3);
    var result = undefined;

    var resolver = {
      expandLocalLookup: function (targetFullName, sourceFullName) {
        assert.ok(true, 'expandLocalLookup is called on the resolver');

        return 'foo:qux/bar';
      }
    };

    var registry = new _containerIndex.Registry({
      resolver: resolver
    });

    result = registry.expandLocalLookup('foo:bar', {
      source: 'baz:qux'
    });

    assert.equal(result, 'foo:qux/bar');

    result = registry.expandLocalLookup('foo:bar', {
      source: 'baz:qux'
    });

    assert.equal(result, 'foo:qux/bar');
  });

  QUnit.test('resolver.expandLocalLookup cache is busted when any unregister is called', function (assert) {
    assert.expect(4);
    var result = undefined;

    var resolver = {
      expandLocalLookup: function (targetFullName, sourceFullName) {
        assert.ok(true, 'expandLocalLookup is called on the resolver');

        return 'foo:qux/bar';
      }
    };

    var registry = new _containerIndex.Registry({
      resolver: resolver
    });

    result = registry.expandLocalLookup('foo:bar', {
      source: 'baz:qux'
    });

    assert.equal(result, 'foo:qux/bar');

    registry.unregister('foo:bar');

    result = registry.expandLocalLookup('foo:bar', {
      source: 'baz:qux'
    });

    assert.equal(result, 'foo:qux/bar');
  });

  QUnit.test('resolve calls expandLocallookup when it receives options.source', function (assert) {
    assert.expect(3);

    var resolver = {
      resolve: function () {},
      expandLocalLookup: function (targetFullName, sourceFullName) {
        assert.ok(true, 'expandLocalLookup is called on the resolver');
        assert.equal(targetFullName, 'foo:bar', 'the targetFullName was passed through');
        assert.equal(sourceFullName, 'baz:qux', 'the sourceFullName was passed through');

        return 'foo:qux/bar';
      }
    };

    var registry = new _containerIndex.Registry({
      resolver: resolver
    });

    registry.resolve('foo:bar', {
      source: 'baz:qux'
    });
  });

  QUnit.test('has uses expandLocalLookup', function (assert) {
    assert.expect(5);
    var resolvedFullNames = [];
    var result = undefined;

    var resolver = {
      resolve: function (name) {
        resolvedFullNames.push(name);

        return 'yippie!';
      },

      expandLocalLookup: function (targetFullName, sourceFullName) {
        assert.ok(true, 'expandLocalLookup is called on the resolver');

        if (targetFullName === 'foo:bar') {
          return 'foo:qux/bar';
        } else {
          return null;
        }
      }
    };

    var registry = new _containerIndex.Registry({
      resolver: resolver
    });

    result = registry.has('foo:bar', {
      source: 'baz:qux'
    });

    assert.ok(result, 'found foo:bar/qux');

    result = registry.has('foo:baz', {
      source: 'baz:qux'
    });

    assert.ok(!result, 'foo:baz/qux not found');

    assert.deepEqual(['foo:qux/bar'], resolvedFullNames);
  });
});
enifed('ember-application/tests/system/application_instance_test', ['exports', 'ember-application/system/engine', 'ember-application/system/application', 'ember-application/system/application-instance', 'ember-metal', 'ember-views', 'container', 'internal-test-helpers', 'ember-runtime'], function (exports, _emberApplicationSystemEngine, _emberApplicationSystemApplication, _emberApplicationSystemApplicationInstance, _emberMetal, _emberViews, _container, _internalTestHelpers, _emberRuntime) {
  'use strict';

  var _templateObject = babelHelpers.taggedTemplateLiteralLoose(['-bucket-cache:main'], ['-bucket-cache:main']);

  var application = undefined,
      appInstance = undefined;

  QUnit.module('Ember.ApplicationInstance', {
    setup: function () {
      _emberViews.jQuery('#qunit-fixture').html('<div id=\'one\'><div id=\'one-child\'>HI</div></div><div id=\'two\'>HI</div>');
      application = _emberMetal.run(function () {
        return _emberApplicationSystemApplication.default.create({ rootElement: '#one', router: null });
      });
    },

    teardown: function () {
      _emberViews.jQuery('#qunit-fixture').empty();

      if (appInstance) {
        _emberMetal.run(appInstance, 'destroy');
      }

      if (application) {
        _emberMetal.run(application, 'destroy');
      }
    }
  });

  QUnit.test('an application instance can be created based upon an application', function () {
    appInstance = _emberMetal.run(function () {
      return appInstance = _emberApplicationSystemApplicationInstance.default.create({ application: application });
    });

    ok(appInstance, 'instance should be created');
    equal(appInstance.application, application, 'application should be set to parent');
  });

  QUnit.test('properties (and aliases) are correctly assigned for accessing the container and registry', function () {
    expect(9);

    appInstance = _emberMetal.run(function () {
      return _emberApplicationSystemApplicationInstance.default.create({ application: application });
    });

    ok(appInstance, 'instance should be created');
    ok(appInstance.__container__, '#__container__ is accessible');
    ok(appInstance.__registry__, '#__registry__ is accessible');

    ok(typeof appInstance.container.lookup === 'function', '#container.lookup is available as a function');

    // stub with a no-op to keep deprecation test simple
    appInstance.__container__.lookup = function () {
      ok(true, '#loookup alias is called correctly');
    };

    expectDeprecation(function () {
      appInstance.container.lookup();
    }, /Using `ApplicationInstance.container.lookup` is deprecated. Please use `ApplicationInstance.lookup` instead./);

    ok(typeof appInstance.registry.register === 'function', '#registry.register is available as a function');
    appInstance.__registry__.register = function () {
      ok(true, '#register alias is called correctly');
    };

    expectDeprecation(function () {
      appInstance.registry.register();
    }, /Using `ApplicationInstance.registry.register` is deprecated. Please use `ApplicationInstance.register` instead./);
  });

  QUnit.test('customEvents added to the application before setupEventDispatcher', function (assert) {
    assert.expect(1);

    appInstance = _emberMetal.run(function () {
      return _emberApplicationSystemApplicationInstance.default.create({ application: application });
    });

    application.customEvents = {
      awesome: 'sauce'
    };

    var eventDispatcher = appInstance.lookup('event_dispatcher:main');
    eventDispatcher.setup = function (events) {
      assert.equal(events.awesome, 'sauce');
    };

    appInstance.setupEventDispatcher();
  });

  QUnit.test('customEvents added to the application before setupEventDispatcher', function (assert) {
    assert.expect(1);

    _emberMetal.run(function () {
      return appInstance = _emberApplicationSystemApplicationInstance.default.create({ application: application });
    });

    application.customEvents = {
      awesome: 'sauce'
    };

    var eventDispatcher = appInstance.lookup('event_dispatcher:main');
    eventDispatcher.setup = function (events) {
      assert.equal(events.awesome, 'sauce');
    };

    appInstance.setupEventDispatcher();
  });

  QUnit.test('customEvents added to the application instance before setupEventDispatcher', function (assert) {
    assert.expect(1);

    appInstance = _emberMetal.run(function () {
      return _emberApplicationSystemApplicationInstance.default.create({ application: application });
    });

    appInstance.customEvents = {
      awesome: 'sauce'
    };

    var eventDispatcher = appInstance.lookup('event_dispatcher:main');
    eventDispatcher.setup = function (events) {
      assert.equal(events.awesome, 'sauce');
    };

    appInstance.setupEventDispatcher();
  });

  QUnit.test('unregistering a factory clears all cached instances of that factory', function (assert) {
    assert.expect(3);

    appInstance = _emberMetal.run(function () {
      return _emberApplicationSystemApplicationInstance.default.create({ application: application });
    });

    var PostController = _internalTestHelpers.factory();

    appInstance.register('controller:post', PostController);

    var postController1 = appInstance.lookup('controller:post');
    assert.ok(postController1, 'lookup creates instance');

    appInstance.unregister('controller:post');
    appInstance.register('controller:post', PostController);

    var postController2 = appInstance.lookup('controller:post');
    assert.ok(postController2, 'lookup creates instance');

    assert.notStrictEqual(postController1, postController2, 'lookup creates a brand new instance, because the previous one was reset');
  });

  QUnit.test('can build and boot a registered engine', function (assert) {
    assert.expect(10);

    var ChatEngine = _emberApplicationSystemEngine.default.extend();
    var chatEngineInstance = undefined;

    application.register('engine:chat', ChatEngine);

    _emberMetal.run(function () {
      appInstance = _emberApplicationSystemApplicationInstance.default.create({ application: application });
      appInstance.setupRegistry();
      chatEngineInstance = appInstance.buildChildEngineInstance('chat');
    });

    return chatEngineInstance.boot().then(function () {
      assert.ok(true, 'boot successful');

      var registrations = ['route:basic', 'event_dispatcher:main', 'service:-routing', 'service:-glimmer-environment'];

      registrations.forEach(function (key) {
        assert.strictEqual(chatEngineInstance.resolveRegistration(key), appInstance.resolveRegistration(key), 'Engine and parent app share registrations for \'' + key + '\'');
      });

      var singletons = ['router:main', _container.privatize(_templateObject), '-view-registry:main', '-environment:main'];

      var env = appInstance.lookup('-environment:main');
      singletons.push(env.isInteractive ? 'renderer:-dom' : 'renderer:-inert');

      singletons.forEach(function (key) {
        assert.strictEqual(chatEngineInstance.lookup(key), appInstance.lookup(key), 'Engine and parent app share singleton \'' + key + '\'');
      });
    });
  });

  QUnit.test('can build a registry via Ember.ApplicationInstance.setupRegistry() -- simulates ember-test-helpers', function (assert) {
    var namespace = _emberRuntime.Object.create({
      Resolver: { create: function () {} }
    });

    var registry = _emberApplicationSystemApplication.default.buildRegistry(namespace);

    _emberApplicationSystemApplicationInstance.default.setupRegistry(registry);

    assert.equal(registry.resolve('service:-document'), document);
  });
});
enifed('ember-application/tests/system/application_test', ['exports', 'ember', 'ember-environment', 'ember-metal', 'ember-application/system/application', 'ember-application/system/resolver', 'ember-routing', 'ember-views', 'ember-runtime', 'ember-template-compiler', 'ember-glimmer', 'container', 'ember-application/tests/test-helpers/registry-check'], function (exports, _ember, _emberEnvironment, _emberMetal, _emberApplicationSystemApplication, _emberApplicationSystemResolver, _emberRouting, _emberViews, _emberRuntime, _emberTemplateCompiler, _emberGlimmer, _container, _emberApplicationTestsTestHelpersRegistryCheck) {
  /*globals EmberDev */
  'use strict';

  var _templateObject = babelHelpers.taggedTemplateLiteralLoose(['-bucket-cache:main'], ['-bucket-cache:main']),
      _templateObject2 = babelHelpers.taggedTemplateLiteralLoose(['template:components/-default'], ['template:components/-default']);

  var trim = _emberViews.jQuery.trim;

  var app = undefined,
      application = undefined,
      originalLookup = undefined,
      originalDebug = undefined,
      originalWarn = undefined;

  QUnit.module('Ember.Application', {
    setup: function () {
      originalLookup = _emberEnvironment.context.lookup;
      originalDebug = _emberMetal.getDebugFunction('debug');
      originalWarn = _emberMetal.getDebugFunction('warn');

      _emberViews.jQuery('#qunit-fixture').html('<div id=\'one\'><div id=\'one-child\'>HI</div></div><div id=\'two\'>HI</div>');
      application = _emberMetal.run(function () {
        return _emberApplicationSystemApplication.default.create({ rootElement: '#one', router: null });
      });
    },

    teardown: function () {
      _emberViews.jQuery('#qunit-fixture').empty();
      _emberMetal.setDebugFunction('debug', originalDebug);
      _emberMetal.setDebugFunction('warn', originalWarn);

      _emberEnvironment.context.lookup = originalLookup;

      if (application) {
        _emberMetal.run(application, 'destroy');
      }

      if (app) {
        _emberMetal.run(app, 'destroy');
      }
    }
  });

  QUnit.test('you can make a new application in a non-overlapping element', function () {
    app = _emberMetal.run(function () {
      return _emberApplicationSystemApplication.default.create({ rootElement: '#two', router: null });
    });

    _emberMetal.run(app, 'destroy');
    ok(true, 'should not raise');
  });

  QUnit.test('you cannot make a new application that is a parent of an existing application', function () {
    expectAssertion(function () {
      _emberMetal.run(function () {
        return _emberApplicationSystemApplication.default.create({ rootElement: '#qunit-fixture' });
      });
    });
  });

  QUnit.test('you cannot make a new application that is a descendant of an existing application', function () {
    expectAssertion(function () {
      _emberMetal.run(function () {
        return _emberApplicationSystemApplication.default.create({ rootElement: '#one-child' });
      });
    });
  });

  QUnit.test('you cannot make a new application that is a duplicate of an existing application', function () {
    expectAssertion(function () {
      _emberMetal.run(function () {
        return _emberApplicationSystemApplication.default.create({ rootElement: '#one' });
      });
    });
  });

  QUnit.test('you cannot make two default applications without a rootElement error', function () {
    expectAssertion(function () {
      _emberMetal.run(function () {
        return _emberApplicationSystemApplication.default.create({ router: false });
      });
    });
  });

  QUnit.test('acts like a namespace', function () {
    var lookup = _emberEnvironment.context.lookup = {};

    app = _emberMetal.run(function () {
      return lookup.TestApp = _emberApplicationSystemApplication.default.create({ rootElement: '#two', router: false });
    });

    _emberRuntime.setNamespaceSearchDisabled(false);
    app.Foo = _emberRuntime.Object.extend();
    equal(app.Foo.toString(), 'TestApp.Foo', 'Classes pick up their parent namespace');
  });

  QUnit.test('includes deprecated access to `application.registry`', function () {
    expect(3);

    ok(typeof application.registry.register === 'function', '#registry.register is available as a function');

    application.__registry__.register = function () {
      ok(true, '#register alias is called correctly');
    };

    expectDeprecation(function () {
      application.registry.register();
    }, /Using `Application.registry.register` is deprecated. Please use `Application.register` instead./);
  });

  QUnit.test('builds a registry', function () {
    strictEqual(application.resolveRegistration('application:main'), application, 'application:main is registered');
    deepEqual(application.registeredOptionsForType('component'), { singleton: false }, 'optionsForType \'component\'');
    deepEqual(application.registeredOptionsForType('view'), { singleton: false }, 'optionsForType \'view\'');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(application, 'controller:basic');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(application, '-view-registry:main');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(application, 'view', '_viewRegistry', '-view-registry:main');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(application, 'route', '_topLevelViewTemplate', 'template:-outlet');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(application, 'route:basic');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(application, 'event_dispatcher:main');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(application, 'router:main', 'namespace', 'application:main');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(application, 'view:-outlet', 'namespace', 'application:main');

    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(application, 'location:auto');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(application, 'location:hash');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(application, 'location:history');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(application, 'location:none');

    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(application, 'controller', 'target', 'router:main');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(application, 'controller', 'namespace', 'application:main');

    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(application, _container.privatize(_templateObject));
    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(application, 'router', '_bucketCache', _container.privatize(_templateObject));
    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(application, 'route', '_bucketCache', _container.privatize(_templateObject));

    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(application, 'route', 'router', 'router:main');

    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(application, 'component:-text-field');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(application, 'component:-text-area');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(application, 'component:-checkbox');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(application, 'component:link-to');

    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(application, 'service:-routing');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(application, 'service:-routing', 'router', 'router:main');

    // DEBUGGING
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(application, 'resolver-for-debugging:main');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(application, 'container-debug-adapter:main', 'resolver', 'resolver-for-debugging:main');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(application, 'data-adapter:main', 'containerDebugAdapter', 'container-debug-adapter:main');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(application, 'container-debug-adapter:main');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(application, 'component-lookup:main');

    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(application, 'service:-glimmer-environment');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(application, 'service:-dom-changes');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(application, 'service:-dom-tree-construction');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(application, 'service:-glimmer-environment', 'appendOperations', 'service:-dom-tree-construction');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(application, 'service:-glimmer-environment', 'updateOperations', 'service:-dom-changes');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(application, 'renderer', 'env', 'service:-glimmer-environment');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(application, 'view:-outlet');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(application, 'renderer:-dom');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(application, 'renderer:-inert');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(application, _container.privatize(_templateObject2));
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(application, 'template:-outlet');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(application, 'view:-outlet', 'template', 'template:-outlet');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(application, 'template', 'env', 'service:-glimmer-environment');
    deepEqual(application.registeredOptionsForType('helper'), { instantiate: false }, 'optionsForType \'helper\'');
  });

  var originalLogVersion = _emberEnvironment.ENV.LOG_VERSION;

  QUnit.module('Ember.Application initialization', {
    teardown: function () {
      if (app) {
        _emberMetal.run(app, 'destroy');
      }
      _emberGlimmer.setTemplates({});
      _emberEnvironment.ENV.LOG_VERSION = originalLogVersion;
    }
  });

  QUnit.test('initialized application goes to initial route', function () {
    _emberMetal.run(function () {
      app = _emberApplicationSystemApplication.default.create({
        rootElement: '#qunit-fixture'
      });

      app.Router.reopen({
        location: 'none'
      });

      app.register('template:application', _emberTemplateCompiler.compile('{{outlet}}'));

      _emberGlimmer.setTemplate('index', _emberTemplateCompiler.compile('<h1>Hi from index</h1>'));
    });

    equal(_emberViews.jQuery('#qunit-fixture h1').text(), 'Hi from index');
  });

  QUnit.test('ready hook is called before routing begins', function () {
    expect(2);

    _emberMetal.run(function () {
      function registerRoute(application, name, callback) {
        var route = _emberRouting.Route.extend({
          activate: callback
        });

        application.register('route:' + name, route);
      }

      var MyApplication = _emberApplicationSystemApplication.default.extend({
        ready: function () {
          registerRoute(this, 'index', function () {
            ok(true, 'last-minute route is activated');
          });
        }
      });

      app = MyApplication.create({
        rootElement: '#qunit-fixture'
      });

      app.Router.reopen({
        location: 'none'
      });

      registerRoute(app, 'application', function () {
        return ok(true, 'normal route is activated');
      });
    });
  });

  QUnit.test('initialize application via initialize call', function () {
    _emberMetal.run(function () {
      app = _emberApplicationSystemApplication.default.create({
        rootElement: '#qunit-fixture'
      });

      app.Router.reopen({
        location: 'none'
      });

      _emberGlimmer.setTemplate('application', _emberTemplateCompiler.compile('<h1>Hello!</h1>'));
    });

    // This is not a public way to access the container; we just
    // need to make some assertions about the created router
    var router = app.__container__.lookup('router:main');
    equal(router instanceof _emberRouting.Router, true, 'Router was set from initialize call');
    equal(router.location instanceof _emberRouting.NoneLocation, true, 'Location was set from location implementation name');
  });

  QUnit.test('initialize application with stateManager via initialize call from Router class', function () {
    _emberMetal.run(function () {
      app = _emberApplicationSystemApplication.default.create({
        rootElement: '#qunit-fixture'
      });

      app.Router.reopen({
        location: 'none'
      });

      app.register('template:application', _emberTemplateCompiler.compile('<h1>Hello!</h1>'));
    });

    var router = app.__container__.lookup('router:main');
    equal(router instanceof _emberRouting.Router, true, 'Router was set from initialize call');
    equal(_emberViews.jQuery('#qunit-fixture h1').text(), 'Hello!');
  });

  QUnit.test('ApplicationView is inserted into the page', function () {
    _emberMetal.run(function () {
      app = _emberApplicationSystemApplication.default.create({
        rootElement: '#qunit-fixture'
      });

      _emberGlimmer.setTemplate('application', _emberTemplateCompiler.compile('<h1>Hello!</h1>'));

      app.ApplicationController = _emberRuntime.Controller.extend();

      app.Router.reopen({
        location: 'none'
      });
    });

    equal(_emberViews.jQuery('#qunit-fixture h1').text(), 'Hello!');
  });

  QUnit.test('Minimal Application initialized with just an application template', function () {
    _emberViews.jQuery('#qunit-fixture').html('<script type="text/x-handlebars">Hello World</script>');
    app = _emberMetal.run(function () {
      return _emberApplicationSystemApplication.default.create({
        rootElement: '#qunit-fixture'
      });
    });

    equal(trim(_emberViews.jQuery('#qunit-fixture').text()), 'Hello World');
  });

  QUnit.test('enable log of libraries with an ENV var', function () {
    if (EmberDev && EmberDev.runningProdBuild) {
      ok(true, 'Logging does not occur in production builds');
      return;
    }

    var messages = [];

    _emberEnvironment.ENV.LOG_VERSION = true;

    _emberMetal.setDebugFunction('debug', function (message) {
      return messages.push(message);
    });

    _emberMetal.libraries.register('my-lib', '2.0.0a');

    app = _emberMetal.run(function () {
      return _emberApplicationSystemApplication.default.create({
        rootElement: '#qunit-fixture'
      });
    });

    equal(messages[1], 'Ember  : ' + _ember.VERSION);
    equal(messages[2], 'jQuery : ' + _emberViews.jQuery().jquery);
    equal(messages[3], 'my-lib : ' + '2.0.0a');

    _emberMetal.libraries.deRegister('my-lib');
  });

  QUnit.test('disable log version of libraries with an ENV var', function () {
    var logged = false;

    _emberEnvironment.ENV.LOG_VERSION = false;

    _emberMetal.setDebugFunction('debug', function () {
      return logged = true;
    });

    _emberViews.jQuery('#qunit-fixture').empty();

    _emberMetal.run(function () {
      app = _emberApplicationSystemApplication.default.create({
        rootElement: '#qunit-fixture'
      });

      app.Router.reopen({
        location: 'none'
      });
    });

    ok(!logged, 'library version logging skipped');
  });

  QUnit.test('can resolve custom router', function () {
    var CustomRouter = _emberRouting.Router.extend();

    var Resolver = _emberApplicationSystemResolver.default.extend({
      resolveMain: function (parsedName) {
        if (parsedName.type === 'router') {
          return CustomRouter;
        } else {
          return this._super(parsedName);
        }
      }
    });

    app = _emberMetal.run(function () {
      return _emberApplicationSystemApplication.default.create({
        Resolver: Resolver
      });
    });

    ok(app.__container__.lookup('router:main') instanceof CustomRouter, 'application resolved the correct router');
  });

  QUnit.test('can specify custom router', function () {
    app = _emberMetal.run(function () {
      return _emberApplicationSystemApplication.default.create({
        Router: _emberRouting.Router.extend()
      });
    });

    ok(app.__container__.lookup('router:main') instanceof _emberRouting.Router, 'application resolved the correct router');
  });

  QUnit.test('does not leak itself in onLoad._loaded', function () {
    equal(_emberRuntime._loaded.application, undefined);
    var app = _emberMetal.run(_emberApplicationSystemApplication.default, 'create');
    equal(_emberRuntime._loaded.application, app);
    _emberMetal.run(app, 'destroy');
    equal(_emberRuntime._loaded.application, undefined);
  });

  QUnit.test('can build a registry via Ember.Application.buildRegistry() --- simulates ember-test-helpers', function (assert) {
    var namespace = _emberRuntime.Object.create({
      Resolver: { create: function () {} }
    });

    var registry = _emberApplicationSystemApplication.default.buildRegistry(namespace);

    assert.equal(registry.resolve('application:main'), namespace);
  });
});
enifed('ember-application/tests/system/bootstrap-test', ['exports', 'ember-metal', 'ember-application/system/application', 'ember-routing', 'ember-views', 'ember-glimmer'], function (exports, _emberMetal, _emberApplicationSystemApplication, _emberRouting, _emberViews, _emberGlimmer) {
  'use strict';

  var app = undefined;

  QUnit.module('Ember.Application', {
    teardown: function () {
      if (app) {
        _emberMetal.run(app, 'destroy');
      }

      _emberGlimmer.setTemplates({});
    }
  });

  QUnit.test('templates in script tags are extracted at application creation', function (assert) {
    _emberViews.jQuery('#qunit-fixture').html('\n    <div id="app"></div>\n\n    <script type="text/x-handlebars">Hello {{outlet}}</script>\n    <script type="text/x-handlebars" id="index">World!</script>\n  ');

    var application = _emberApplicationSystemApplication.default.extend();
    application.Router = _emberRouting.Router.extend({
      location: 'none'
    });

    app = _emberMetal.run(function () {
      return application.create({ rootElement: '#app' });
    });

    assert.equal(_emberViews.jQuery('#app').text(), 'Hello World!');
  });
});
enifed('ember-application/tests/system/dependency_injection/custom_resolver_test', ['exports', 'ember-views', 'ember-metal', 'ember-application/system/application', 'ember-application/system/resolver', 'ember-template-compiler'], function (exports, _emberViews, _emberMetal, _emberApplicationSystemApplication, _emberApplicationSystemResolver, _emberTemplateCompiler) {
  'use strict';

  var application = undefined;

  QUnit.module('Ember.Application Dependency Injection – customResolver', {
    setup: function () {
      var fallbackTemplate = _emberTemplateCompiler.compile('<h1>Fallback</h1>');

      var Resolver = _emberApplicationSystemResolver.default.extend({
        resolveTemplate: function (resolvable) {
          var resolvedTemplate = this._super(resolvable);
          if (resolvedTemplate) {
            return resolvedTemplate;
          }
          if (resolvable.fullNameWithoutType === 'application') {
            return fallbackTemplate;
          } else {
            return;
          }
        }
      });

      application = _emberMetal.run(function () {
        return _emberApplicationSystemApplication.default.create({
          Resolver: Resolver,
          rootElement: '#qunit-fixture'
        });
      });
    },

    teardown: function () {
      _emberMetal.run(application, 'destroy');
    }
  });

  QUnit.test('a resolver can be supplied to application', function () {
    equal(_emberViews.jQuery('h1', application.rootElement).text(), 'Fallback');
  });
});
enifed('ember-application/tests/system/dependency_injection/default_resolver_test', ['exports', 'ember-environment', 'ember-metal', 'ember-runtime', 'ember-routing', 'ember-application/system/application', 'ember-glimmer', 'ember-template-compiler'], function (exports, _emberEnvironment, _emberMetal, _emberRuntime, _emberRouting, _emberApplicationSystemApplication, _emberGlimmer, _emberTemplateCompiler) {
  /* globals EmberDev */
  'use strict';

  var registry = undefined,
      locator = undefined,
      application = undefined,
      originalLookup = undefined,
      originalInfo = undefined;

  QUnit.module('Ember.Application Dependency Injection - default resolver', {
    setup: function () {
      originalLookup = _emberEnvironment.context.lookup;
      application = _emberMetal.run(_emberApplicationSystemApplication.default, 'create');

      registry = application.__registry__;
      locator = application.__container__;
      originalInfo = _emberMetal.getDebugFunction('info');
    },

    teardown: function () {
      _emberGlimmer.setTemplates({});
      _emberEnvironment.context.lookup = originalLookup;
      _emberMetal.run(application, 'destroy');
      var UserInterfaceNamespace = _emberRuntime.Namespace.NAMESPACES_BY_ID['UserInterface'];
      if (UserInterfaceNamespace) {
        _emberMetal.run(UserInterfaceNamespace, 'destroy');
      }

      _emberMetal.setDebugFunction('info', originalInfo);
    }
  });

  QUnit.test('the default resolver can look things up in other namespaces', function () {
    var UserInterface = _emberEnvironment.context.lookup.UserInterface = _emberRuntime.Namespace.create();
    UserInterface.NavigationController = _emberRuntime.Controller.extend();

    var nav = locator.lookup('controller:userInterface/navigation');

    ok(nav instanceof UserInterface.NavigationController, 'the result should be an instance of the specified class');
  });

  QUnit.test('the default resolver looks up templates in Ember.TEMPLATES', function () {
    var fooTemplate = _emberTemplateCompiler.compile('foo template');
    var fooBarTemplate = _emberTemplateCompiler.compile('fooBar template');
    var fooBarBazTemplate = _emberTemplateCompiler.compile('fooBar/baz template');

    _emberGlimmer.setTemplate('foo', fooTemplate);
    _emberGlimmer.setTemplate('fooBar', fooBarTemplate);
    _emberGlimmer.setTemplate('fooBar/baz', fooBarBazTemplate);

    equal(locator.lookupFactory('template:foo'), fooTemplate, 'resolves template:foo');
    equal(locator.lookupFactory('template:fooBar'), fooBarTemplate, 'resolves template:foo_bar');
    equal(locator.lookupFactory('template:fooBar.baz'), fooBarBazTemplate, 'resolves template:foo_bar.baz');
  });

  QUnit.test('the default resolver looks up basic name as no prefix', function () {
    ok(_emberRuntime.Controller.detect(locator.lookup('controller:basic')), 'locator looks up correct controller');
  });

  function detectEqual(first, second, message) {
    ok(first.detect(second), message);
  }

  QUnit.test('the default resolver looks up arbitrary types on the namespace', function () {
    application.FooManager = _emberRuntime.Object.extend({});

    detectEqual(application.FooManager, registry.resolve('manager:foo'), 'looks up FooManager on application');
  });

  QUnit.test('the default resolver resolves models on the namespace', function () {
    application.Post = _emberRuntime.Object.extend({});

    detectEqual(application.Post, locator.lookupFactory('model:post'), 'looks up Post model on application');
  });

  QUnit.test('the default resolver resolves *:main on the namespace', function () {
    application.FooBar = _emberRuntime.Object.extend({});

    detectEqual(application.FooBar, locator.lookupFactory('foo-bar:main'), 'looks up FooBar type without name on application');
  });

  QUnit.test('the default resolver resolves container-registered helpers', function () {
    var shorthandHelper = _emberGlimmer.helper(function () {});
    var helper = _emberGlimmer.Helper.extend();

    application.register('helper:shorthand', shorthandHelper);
    application.register('helper:complete', helper);

    var lookedUpShorthandHelper = locator.lookupFactory('helper:shorthand');
    ok(lookedUpShorthandHelper.isHelperInstance, 'shorthand helper isHelper');

    var lookedUpHelper = locator.lookupFactory('helper:complete');
    ok(lookedUpHelper.isHelperFactory, 'complete helper is factory');
    ok(helper.detect(lookedUpHelper), 'looked up complete helper');
  });

  QUnit.test('the default resolver resolves helpers on the namespace', function () {
    var ShorthandHelper = _emberGlimmer.helper(function () {});
    var CompleteHelper = _emberGlimmer.Helper.extend();
    var LegacyHTMLBarsBoundHelper = undefined;

    expectDeprecation(function () {
      LegacyHTMLBarsBoundHelper = _emberGlimmer.makeBoundHelper(function () {});
    }, 'Using `Ember.HTMLBars.makeBoundHelper` is deprecated. Please refactor to use `Ember.Helper` or `Ember.Helper.helper`.');

    application.ShorthandHelper = ShorthandHelper;
    application.CompleteHelper = CompleteHelper;
    application.LegacyHtmlBarsBoundHelper = LegacyHTMLBarsBoundHelper; // Must use lowered "tml" in "HTMLBars" for resolver to find this

    var resolvedShorthand = registry.resolve('helper:shorthand');
    var resolvedComplete = registry.resolve('helper:complete');
    var resolvedLegacyHTMLBars = registry.resolve('helper:legacy-html-bars-bound');

    equal(resolvedShorthand, ShorthandHelper, 'resolve fetches the shorthand helper factory');
    equal(resolvedComplete, CompleteHelper, 'resolve fetches the complete helper factory');
    equal(resolvedLegacyHTMLBars, LegacyHTMLBarsBoundHelper, 'resolves legacy HTMLBars bound helper');
  });

  QUnit.test('the default resolver resolves to the same instance, no matter the notation ', function () {
    application.NestedPostController = _emberRuntime.Controller.extend({});

    equal(locator.lookup('controller:nested-post'), locator.lookup('controller:nested_post'), 'looks up NestedPost controller on application');
  });

  QUnit.test('the default resolver throws an error if the fullName to resolve is invalid', function () {
    throws(function () {
      registry.resolve(undefined);
    }, TypeError, /Invalid fullName/);
    throws(function () {
      registry.resolve(null);
    }, TypeError, /Invalid fullName/);
    throws(function () {
      registry.resolve('');
    }, TypeError, /Invalid fullName/);
    throws(function () {
      registry.resolve('');
    }, TypeError, /Invalid fullName/);
    throws(function () {
      registry.resolve(':');
    }, TypeError, /Invalid fullName/);
    throws(function () {
      registry.resolve('model');
    }, TypeError, /Invalid fullName/);
    throws(function () {
      registry.resolve('model:');
    }, TypeError, /Invalid fullName/);
    throws(function () {
      registry.resolve(':type');
    }, TypeError, /Invalid fullName/);
  });

  QUnit.test('the default resolver logs hits if `LOG_RESOLVER` is set', function () {
    if (EmberDev && EmberDev.runningProdBuild) {
      ok(true, 'Logging does not occur in production builds');
      return;
    }

    expect(3);

    application.LOG_RESOLVER = true;
    application.ScoobyDoo = _emberRuntime.Object.extend();
    application.toString = function () {
      return 'App';
    };

    _emberMetal.setDebugFunction('info', function (symbol, name, padding, lookupDescription) {
      equal(symbol, '[✓]', 'proper symbol is printed when a module is found');
      equal(name, 'doo:scooby', 'proper lookup value is logged');
      equal(lookupDescription, 'App.ScoobyDoo');
    });

    registry.resolve('doo:scooby');
  });

  QUnit.test('the default resolver logs misses if `LOG_RESOLVER` is set', function () {
    if (EmberDev && EmberDev.runningProdBuild) {
      ok(true, 'Logging does not occur in production builds');
      return;
    }

    expect(3);

    application.LOG_RESOLVER = true;
    application.toString = function () {
      return 'App';
    };

    _emberMetal.setDebugFunction('info', function (symbol, name, padding, lookupDescription) {
      equal(symbol, '[ ]', 'proper symbol is printed when a module is not found');
      equal(name, 'doo:scooby', 'proper lookup value is logged');
      equal(lookupDescription, 'App.ScoobyDoo');
    });

    registry.resolve('doo:scooby');
  });

  QUnit.test('doesn\'t log without LOG_RESOLVER', function () {
    if (EmberDev && EmberDev.runningProdBuild) {
      ok(true, 'Logging does not occur in production builds');
      return;
    }

    var infoCount = 0;

    application.ScoobyDoo = _emberRuntime.Object.extend();

    _emberMetal.setDebugFunction('info', function (symbol, name) {
      return infoCount = infoCount + 1;
    });

    registry.resolve('doo:scooby');
    registry.resolve('doo:scrappy');
    equal(infoCount, 0, 'Logger.info should not be called if LOG_RESOLVER is not set');
  });

  QUnit.test('lookup description', function () {
    application.toString = function () {
      return 'App';
    };

    equal(registry.describe('controller:foo'), 'App.FooController', 'Type gets appended at the end');
    equal(registry.describe('controller:foo.bar'), 'App.FooBarController', 'dots are removed');
    equal(registry.describe('model:foo'), 'App.Foo', 'models don\'t get appended at the end');
  });

  QUnit.test('assertion for routes without isRouteFactory property', function () {
    application.FooRoute = _emberGlimmer.Component.extend();

    expectAssertion(function () {
      return registry.resolve('route:foo');
    }, /to resolve to an Ember.Route/, 'Should assert');
  });

  QUnit.test('no assertion for routes that extend from Ember.Route', function () {
    expect(0);
    application.FooRoute = _emberRouting.Route.extend();
    registry.resolve('route:foo');
  });

  QUnit.test('deprecation warning for service factories without isServiceFactory property', function () {
    expectDeprecation(/service factories must have an `isServiceFactory` property/);
    application.FooService = _emberRuntime.Object.extend();
    registry.resolve('service:foo');
  });

  QUnit.test('no deprecation warning for service factories that extend from Ember.Service', function () {
    expectNoDeprecation();
    application.FooService = _emberRuntime.Service.extend();
    registry.resolve('service:foo');
  });

  QUnit.test('deprecation warning for component factories without isComponentFactory property', function () {
    expectDeprecation(/component factories must have an `isComponentFactory` property/);
    application.FooComponent = _emberRuntime.Object.extend();
    registry.resolve('component:foo');
  });

  QUnit.test('no deprecation warning for component factories that extend from Ember.Component', function () {
    expectNoDeprecation();
    application.FooView = _emberGlimmer.Component.extend();
    registry.resolve('component:foo');
  });

  QUnit.test('knownForType returns each item for a given type found', function () {
    application.FooBarHelper = 'foo';
    application.BazQuxHelper = 'bar';

    var found = registry.resolver.knownForType('helper');

    // using `Object.keys` and manually confirming values over using `deepEqual`
    // due to an issue in QUnit (through at least 1.20.0) that are unable to properly compare
    // objects with an `undefined` constructor (like ember-metal/empty_object)
    var foundKeys = Object.keys(found);

    deepEqual(foundKeys, ['helper:foo-bar', 'helper:baz-qux']);
    ok(found['helper:foo-bar']);
    ok(found['helper:baz-qux']);
  });

  QUnit.test('knownForType is not required to be present on the resolver', function () {
    delete registry.resolver.knownForType;

    registry.resolver.knownForType('helper', function () {});

    ok(true, 'does not error');
  });
});
enifed('ember-application/tests/system/dependency_injection/normalization_test', ['exports', 'ember-metal', 'ember-application/system/application'], function (exports, _emberMetal, _emberApplicationSystemApplication) {
  'use strict';

  var application = undefined,
      registry = undefined;

  QUnit.module('Ember.Application Dependency Injection – normalization', {
    setup: function () {
      application = _emberMetal.run(_emberApplicationSystemApplication.default, 'create');
      registry = application.__registry__;
    },

    teardown: function () {
      _emberMetal.run(application, 'destroy');
    }
  });

  QUnit.test('normalization', function () {
    ok(registry.normalize, 'registry#normalize is present');

    equal(registry.normalize('foo:bar'), 'foo:bar');

    equal(registry.normalize('controller:posts'), 'controller:posts');
    equal(registry.normalize('controller:posts_index'), 'controller:postsIndex');
    equal(registry.normalize('controller:posts.index'), 'controller:postsIndex');
    equal(registry.normalize('controller:posts-index'), 'controller:postsIndex');
    equal(registry.normalize('controller:posts.post.index'), 'controller:postsPostIndex');
    equal(registry.normalize('controller:posts_post.index'), 'controller:postsPostIndex');
    equal(registry.normalize('controller:posts.post_index'), 'controller:postsPostIndex');
    equal(registry.normalize('controller:posts.post-index'), 'controller:postsPostIndex');
    equal(registry.normalize('controller:postsIndex'), 'controller:postsIndex');
    equal(registry.normalize('controller:blogPosts.index'), 'controller:blogPostsIndex');
    equal(registry.normalize('controller:blog/posts.index'), 'controller:blog/postsIndex');
    equal(registry.normalize('controller:blog/posts-index'), 'controller:blog/postsIndex');
    equal(registry.normalize('controller:blog/posts.post.index'), 'controller:blog/postsPostIndex');
    equal(registry.normalize('controller:blog/posts_post.index'), 'controller:blog/postsPostIndex');
    equal(registry.normalize('controller:blog/posts_post-index'), 'controller:blog/postsPostIndex');

    equal(registry.normalize('template:blog/posts_index'), 'template:blog/posts_index');
  });

  QUnit.test('normalization is indempotent', function () {
    var examples = ['controller:posts', 'controller:posts.post.index', 'controller:blog/posts.post_index', 'template:foo_bar'];

    examples.forEach(function (example) {
      equal(registry.normalize(registry.normalize(example)), registry.normalize(example));
    });
  });
});
enifed('ember-application/tests/system/dependency_injection/to_string_test', ['exports', 'ember-utils', 'ember-environment', 'ember-metal', 'ember-application/system/application', 'ember-runtime', 'ember-application/system/resolver'], function (exports, _emberUtils, _emberEnvironment, _emberMetal, _emberApplicationSystemApplication, _emberRuntime, _emberApplicationSystemResolver) {
  'use strict';

  var originalLookup = undefined,
      App = undefined,
      originalModelInjections = undefined;

  QUnit.module('Ember.Application Dependency Injection – toString', {
    setup: function () {
      originalModelInjections = _emberEnvironment.ENV.MODEL_FACTORY_INJECTIONS;
      _emberEnvironment.ENV.MODEL_FACTORY_INJECTIONS = true;

      originalLookup = _emberEnvironment.context.lookup;

      _emberMetal.run(function () {
        App = _emberApplicationSystemApplication.default.create();
        _emberEnvironment.context.lookup = {
          App: App
        };
      });

      App.Post = _emberRuntime.Object.extend();
    },

    teardown: function () {
      _emberEnvironment.context.lookup = originalLookup;
      _emberMetal.run(App, 'destroy');
      _emberEnvironment.ENV.MODEL_FACTORY_INJECTIONS = originalModelInjections;
    }
  });

  QUnit.test('factories', function () {
    var PostFactory = App.__container__.lookupFactory('model:post');
    equal(PostFactory.toString(), 'App.Post', 'expecting the model to be post');
  });

  QUnit.test('instances', function () {
    var post = App.__container__.lookup('model:post');
    var guid = _emberUtils.guidFor(post);

    equal(post.toString(), '<App.Post:' + guid + '>', 'expecting the model to be post');
  });

  QUnit.test('with a custom resolver', function () {
    _emberMetal.run(App, 'destroy');

    _emberMetal.run(function () {
      App = _emberApplicationSystemApplication.default.create({
        Resolver: _emberApplicationSystemResolver.default.extend({
          makeToString: function (factory, fullName) {
            return fullName;
          }
        })
      });
    });

    App.register('model:peter', _emberRuntime.Object.extend());

    var peter = App.__container__.lookup('model:peter');
    var guid = _emberUtils.guidFor(peter);

    equal(peter.toString(), '<model:peter:' + guid + '>', 'expecting the supermodel to be peter');
  });
});
// lookup, etc
enifed('ember-application/tests/system/dependency_injection_test', ['exports', 'ember-environment', 'ember-metal', 'ember-runtime', 'ember-application/system/application'], function (exports, _emberEnvironment, _emberMetal, _emberRuntime, _emberApplicationSystemApplication) {
  'use strict';

  var EmberApplication = _emberApplicationSystemApplication.default;

  var originalLookup = _emberEnvironment.context.lookup;
  var registry = undefined,
      locator = undefined,
      application = undefined,
      originalModelInjections = undefined;

  QUnit.module('Ember.Application Dependency Injection', {
    setup: function () {
      originalModelInjections = _emberEnvironment.ENV.MODEL_FACTORY_INJECTIONS;
      _emberEnvironment.ENV.MODEL_FACTORY_INJECTIONS = true;

      application = _emberMetal.run(EmberApplication, 'create');

      application.Person = _emberRuntime.Object.extend({});
      application.Orange = _emberRuntime.Object.extend({});
      application.Email = _emberRuntime.Object.extend({});
      application.User = _emberRuntime.Object.extend({});
      application.PostIndexController = _emberRuntime.Object.extend({});

      application.register('model:person', application.Person, { singleton: false });
      application.register('model:user', application.User, { singleton: false });
      application.register('fruit:favorite', application.Orange);
      application.register('communication:main', application.Email, { singleton: false });
      application.register('controller:postIndex', application.PostIndexController, { singleton: true });

      registry = application.__registry__;
      locator = application.__container__;

      _emberEnvironment.context.lookup = {};
    },
    teardown: function () {
      _emberMetal.run(application, 'destroy');
      application = locator = null;
      _emberEnvironment.context.lookup = originalLookup;
      _emberEnvironment.ENV.MODEL_FACTORY_INJECTIONS = originalModelInjections;
    }
  });

  QUnit.test('container lookup is normalized', function () {
    var dotNotationController = locator.lookup('controller:post.index');
    var camelCaseController = locator.lookup('controller:postIndex');

    ok(dotNotationController instanceof application.PostIndexController);
    ok(camelCaseController instanceof application.PostIndexController);

    equal(dotNotationController, camelCaseController);
  });

  QUnit.test('registered entities can be looked up later', function () {
    equal(registry.resolve('model:person'), application.Person);
    equal(registry.resolve('model:user'), application.User);
    equal(registry.resolve('fruit:favorite'), application.Orange);
    equal(registry.resolve('communication:main'), application.Email);
    equal(registry.resolve('controller:postIndex'), application.PostIndexController);

    equal(locator.lookup('fruit:favorite'), locator.lookup('fruit:favorite'), 'singleton lookup worked');
    ok(locator.lookup('model:user') !== locator.lookup('model:user'), 'non-singleton lookup worked');
  });

  QUnit.test('injections', function () {
    application.inject('model', 'fruit', 'fruit:favorite');
    application.inject('model:user', 'communication', 'communication:main');

    var user = locator.lookup('model:user');
    var person = locator.lookup('model:person');
    var fruit = locator.lookup('fruit:favorite');

    equal(user.get('fruit'), fruit);
    equal(person.get('fruit'), fruit);

    ok(application.Email.detectInstance(user.get('communication')));
  });
});
enifed('ember-application/tests/system/engine_initializers_test', ['exports', 'ember-metal', 'ember-application/system/engine'], function (exports, _emberMetal, _emberApplicationSystemEngine) {
  'use strict';

  var MyEngine = undefined,
      myEngine = undefined,
      myEngineInstance = undefined;

  QUnit.module('Ember.Engine initializers', {
    setup: function () {},

    teardown: function () {
      _emberMetal.run(function () {
        if (myEngineInstance) {
          myEngineInstance.destroy();
        }

        if (myEngine) {
          myEngine.destroy();
        }
      });
    }
  });

  QUnit.test('initializers require proper \'name\' and \'initialize\' properties', function () {
    MyEngine = _emberApplicationSystemEngine.default.extend();

    expectAssertion(function () {
      _emberMetal.run(function () {
        MyEngine.initializer({ name: 'initializer' });
      });
    });

    expectAssertion(function () {
      _emberMetal.run(function () {
        MyEngine.initializer({ initialize: function () {} });
      });
    });
  });

  QUnit.test('initializers are passed an Engine', function () {
    MyEngine = _emberApplicationSystemEngine.default.extend();

    MyEngine.initializer({
      name: 'initializer',
      initialize: function (engine) {
        ok(engine instanceof _emberApplicationSystemEngine.default, 'initialize is passed an Engine');
      }
    });

    myEngine = MyEngine.create();
    myEngineInstance = myEngine.buildInstance();
  });

  QUnit.test('initializers can be registered in a specified order', function () {
    var order = [];

    MyEngine = _emberApplicationSystemEngine.default.extend();
    MyEngine.initializer({
      name: 'fourth',
      after: 'third',
      initialize: function (engine) {
        order.push('fourth');
      }
    });

    MyEngine.initializer({
      name: 'second',
      after: 'first',
      before: 'third',
      initialize: function (engine) {
        order.push('second');
      }
    });

    MyEngine.initializer({
      name: 'fifth',
      after: 'fourth',
      before: 'sixth',
      initialize: function (engine) {
        order.push('fifth');
      }
    });

    MyEngine.initializer({
      name: 'first',
      before: 'second',
      initialize: function (engine) {
        order.push('first');
      }
    });

    MyEngine.initializer({
      name: 'third',
      initialize: function (engine) {
        order.push('third');
      }
    });

    MyEngine.initializer({
      name: 'sixth',
      initialize: function (engine) {
        order.push('sixth');
      }
    });

    myEngine = MyEngine.create();
    myEngineInstance = myEngine.buildInstance();

    deepEqual(order, ['first', 'second', 'third', 'fourth', 'fifth', 'sixth']);
  });

  QUnit.test('initializers can be registered in a specified order as an array', function () {
    var order = [];

    MyEngine = _emberApplicationSystemEngine.default.extend();

    MyEngine.initializer({
      name: 'third',
      initialize: function (engine) {
        order.push('third');
      }
    });

    MyEngine.initializer({
      name: 'second',
      after: 'first',
      before: ['third', 'fourth'],
      initialize: function (engine) {
        order.push('second');
      }
    });

    MyEngine.initializer({
      name: 'fourth',
      after: ['second', 'third'],
      initialize: function (engine) {
        order.push('fourth');
      }
    });

    MyEngine.initializer({
      name: 'fifth',
      after: 'fourth',
      before: 'sixth',
      initialize: function (engine) {
        order.push('fifth');
      }
    });

    MyEngine.initializer({
      name: 'first',
      before: ['second'],
      initialize: function (engine) {
        order.push('first');
      }
    });

    MyEngine.initializer({
      name: 'sixth',
      initialize: function (engine) {
        order.push('sixth');
      }
    });

    myEngine = MyEngine.create();
    myEngineInstance = myEngine.buildInstance();

    deepEqual(order, ['first', 'second', 'third', 'fourth', 'fifth', 'sixth']);
  });

  QUnit.test('initializers can have multiple dependencies', function () {
    var order = [];

    MyEngine = _emberApplicationSystemEngine.default.extend();

    var a = {
      name: 'a',
      before: 'b',
      initialize: function (engine) {
        order.push('a');
      }
    };
    var b = {
      name: 'b',
      initialize: function (engine) {
        order.push('b');
      }
    };
    var c = {
      name: 'c',
      after: 'b',
      initialize: function (engine) {
        order.push('c');
      }
    };
    var afterB = {
      name: 'after b',
      after: 'b',
      initialize: function (engine) {
        order.push('after b');
      }
    };
    var afterC = {
      name: 'after c',
      after: 'c',
      initialize: function (engine) {
        order.push('after c');
      }
    };

    MyEngine.initializer(b);
    MyEngine.initializer(a);
    MyEngine.initializer(afterC);
    MyEngine.initializer(afterB);
    MyEngine.initializer(c);

    myEngine = MyEngine.create();
    myEngineInstance = myEngine.buildInstance();

    ok(order.indexOf(a.name) < order.indexOf(b.name), 'a < b');
    ok(order.indexOf(b.name) < order.indexOf(c.name), 'b < c');
    ok(order.indexOf(b.name) < order.indexOf(afterB.name), 'b < afterB');
    ok(order.indexOf(c.name) < order.indexOf(afterC.name), 'c < afterC');
  });

  QUnit.test('initializers set on Engine subclasses are not shared between engines', function () {
    var firstInitializerRunCount = 0;
    var secondInitializerRunCount = 0;
    var FirstEngine = _emberApplicationSystemEngine.default.extend();

    FirstEngine.initializer({
      name: 'first',
      initialize: function (engine) {
        firstInitializerRunCount++;
      }
    });

    var SecondEngine = _emberApplicationSystemEngine.default.extend();

    SecondEngine.initializer({
      name: 'second',
      initialize: function (engine) {
        secondInitializerRunCount++;
      }
    });

    var firstEngine = FirstEngine.create();
    var firstEngineInstance = firstEngine.buildInstance();

    equal(firstInitializerRunCount, 1, 'first initializer only was run');
    equal(secondInitializerRunCount, 0, 'first initializer only was run');

    var secondEngine = SecondEngine.create();
    var secondEngineInstance = secondEngine.buildInstance();

    equal(firstInitializerRunCount, 1, 'second initializer only was run');
    equal(secondInitializerRunCount, 1, 'second initializer only was run');

    _emberMetal.run(function () {
      firstEngineInstance.destroy();
      secondEngineInstance.destroy();

      firstEngine.destroy();
      secondEngine.destroy();
    });
  });

  QUnit.test('initializers are concatenated', function () {
    var firstInitializerRunCount = 0;
    var secondInitializerRunCount = 0;
    var FirstEngine = _emberApplicationSystemEngine.default.extend();

    FirstEngine.initializer({
      name: 'first',
      initialize: function (engine) {
        firstInitializerRunCount++;
      }
    });

    var SecondEngine = FirstEngine.extend();

    SecondEngine.initializer({
      name: 'second',
      initialize: function (engine) {
        secondInitializerRunCount++;
      }
    });

    var firstEngine = FirstEngine.create();
    var firstEngineInstance = firstEngine.buildInstance();

    equal(firstInitializerRunCount, 1, 'first initializer only was run when base class created');
    equal(secondInitializerRunCount, 0, 'second initializer was not run when first base class created');
    firstInitializerRunCount = 0;

    var secondEngine = SecondEngine.create();
    var secondEngineInstance = secondEngine.buildInstance();

    equal(firstInitializerRunCount, 1, 'first initializer was run when subclass created');
    equal(secondInitializerRunCount, 1, 'second initializers was run when subclass created');

    _emberMetal.run(function () {
      firstEngineInstance.destroy();
      secondEngineInstance.destroy();

      firstEngine.destroy();
      secondEngine.destroy();
    });
  });

  QUnit.test('initializers are per-engine', function () {
    expect(2);

    var FirstEngine = _emberApplicationSystemEngine.default.extend();

    FirstEngine.initializer({
      name: 'abc',
      initialize: function (engine) {}
    });

    expectAssertion(function () {
      FirstEngine.initializer({
        name: 'abc',
        initialize: function (engine) {}
      });
    });

    var SecondEngine = _emberApplicationSystemEngine.default.extend();
    SecondEngine.instanceInitializer({
      name: 'abc',
      initialize: function (engine) {}
    });

    ok(true, 'Two engines can have initializers named the same.');
  });

  QUnit.test('initializers are executed in their own context', function () {
    expect(1);

    MyEngine = _emberApplicationSystemEngine.default.extend();

    MyEngine.initializer({
      name: 'coolInitializer',
      myProperty: 'cool',
      initialize: function (engine) {
        equal(this.myProperty, 'cool', 'should have access to its own context');
      }
    });

    myEngine = MyEngine.create();
    myEngineInstance = myEngine.buildInstance();
  });
});
enifed('ember-application/tests/system/engine_instance_initializers_test', ['exports', 'ember-metal', 'ember-application/system/engine', 'ember-application/system/engine-instance', 'ember-application/system/engine-parent'], function (exports, _emberMetal, _emberApplicationSystemEngine, _emberApplicationSystemEngineInstance, _emberApplicationSystemEngineParent) {
  'use strict';

  var MyEngine = undefined,
      myEngine = undefined,
      myEngineInstance = undefined;

  function buildEngineInstance(EngineClass) {
    var engineInstance = EngineClass.buildInstance();
    _emberApplicationSystemEngineParent.setEngineParent(engineInstance, {
      lookup: function () {
        return {};
      },
      resolveRegistration: function () {
        return {};
      }
    });
    return engineInstance;
  }

  QUnit.module('Ember.Engine instance initializers', {
    setup: function () {},

    teardown: function () {
      _emberMetal.run(function () {
        if (myEngineInstance) {
          myEngineInstance.destroy();
        }

        if (myEngine) {
          myEngine.destroy();
        }
      });
    }
  });

  QUnit.test('initializers require proper \'name\' and \'initialize\' properties', function () {
    MyEngine = _emberApplicationSystemEngine.default.extend();

    expectAssertion(function () {
      _emberMetal.run(function () {
        MyEngine.instanceInitializer({ name: 'initializer' });
      });
    });

    expectAssertion(function () {
      _emberMetal.run(function () {
        MyEngine.instanceInitializer({ initialize: function () {} });
      });
    });
  });

  QUnit.test('initializers are passed an engine instance', function () {
    MyEngine = _emberApplicationSystemEngine.default.extend();

    MyEngine.instanceInitializer({
      name: 'initializer',
      initialize: function (instance) {
        ok(instance instanceof _emberApplicationSystemEngineInstance.default, 'initialize is passed an engine instance');
      }
    });

    myEngine = MyEngine.create();
    myEngineInstance = buildEngineInstance(myEngine);
    return myEngineInstance.boot();
  });

  QUnit.test('initializers can be registered in a specified order', function () {
    var order = [];

    MyEngine = _emberApplicationSystemEngine.default.extend();

    MyEngine.instanceInitializer({
      name: 'fourth',
      after: 'third',
      initialize: function (engine) {
        order.push('fourth');
      }
    });

    MyEngine.instanceInitializer({
      name: 'second',
      after: 'first',
      before: 'third',
      initialize: function (engine) {
        order.push('second');
      }
    });

    MyEngine.instanceInitializer({
      name: 'fifth',
      after: 'fourth',
      before: 'sixth',
      initialize: function (engine) {
        order.push('fifth');
      }
    });

    MyEngine.instanceInitializer({
      name: 'first',
      before: 'second',
      initialize: function (engine) {
        order.push('first');
      }
    });

    MyEngine.instanceInitializer({
      name: 'third',
      initialize: function (engine) {
        order.push('third');
      }
    });

    MyEngine.instanceInitializer({
      name: 'sixth',
      initialize: function (engine) {
        order.push('sixth');
      }
    });

    myEngine = MyEngine.create();
    myEngineInstance = buildEngineInstance(myEngine);

    return myEngineInstance.boot().then(function () {
      deepEqual(order, ['first', 'second', 'third', 'fourth', 'fifth', 'sixth']);
    });
  });

  QUnit.test('initializers can be registered in a specified order as an array', function () {
    var order = [];
    MyEngine = _emberApplicationSystemEngine.default.extend();

    MyEngine.instanceInitializer({
      name: 'third',
      initialize: function (engine) {
        order.push('third');
      }
    });

    MyEngine.instanceInitializer({
      name: 'second',
      after: 'first',
      before: ['third', 'fourth'],
      initialize: function (engine) {
        order.push('second');
      }
    });

    MyEngine.instanceInitializer({
      name: 'fourth',
      after: ['second', 'third'],
      initialize: function (engine) {
        order.push('fourth');
      }
    });

    MyEngine.instanceInitializer({
      name: 'fifth',
      after: 'fourth',
      before: 'sixth',
      initialize: function (engine) {
        order.push('fifth');
      }
    });

    MyEngine.instanceInitializer({
      name: 'first',
      before: ['second'],
      initialize: function (engine) {
        order.push('first');
      }
    });

    MyEngine.instanceInitializer({
      name: 'sixth',
      initialize: function (engine) {
        order.push('sixth');
      }
    });

    myEngine = MyEngine.create();
    myEngineInstance = buildEngineInstance(myEngine);

    return myEngineInstance.boot().then(function () {
      deepEqual(order, ['first', 'second', 'third', 'fourth', 'fifth', 'sixth']);
    });
  });

  QUnit.test('initializers can have multiple dependencies', function () {
    var order = [];

    MyEngine = _emberApplicationSystemEngine.default.extend();

    var a = {
      name: 'a',
      before: 'b',
      initialize: function (engine) {
        order.push('a');
      }
    };
    var b = {
      name: 'b',
      initialize: function (engine) {
        order.push('b');
      }
    };
    var c = {
      name: 'c',
      after: 'b',
      initialize: function (engine) {
        order.push('c');
      }
    };
    var afterB = {
      name: 'after b',
      after: 'b',
      initialize: function (engine) {
        order.push('after b');
      }
    };
    var afterC = {
      name: 'after c',
      after: 'c',
      initialize: function (engine) {
        order.push('after c');
      }
    };

    MyEngine.instanceInitializer(b);
    MyEngine.instanceInitializer(a);
    MyEngine.instanceInitializer(afterC);
    MyEngine.instanceInitializer(afterB);
    MyEngine.instanceInitializer(c);

    myEngine = MyEngine.create();
    myEngineInstance = buildEngineInstance(myEngine);

    return myEngineInstance.boot().then(function () {
      ok(order.indexOf(a.name) < order.indexOf(b.name), 'a < b');
      ok(order.indexOf(b.name) < order.indexOf(c.name), 'b < c');
      ok(order.indexOf(b.name) < order.indexOf(afterB.name), 'b < afterB');
      ok(order.indexOf(c.name) < order.indexOf(afterC.name), 'c < afterC');
    });
  });

  QUnit.test('initializers set on Engine subclasses should not be shared between engines', function () {
    var firstInitializerRunCount = 0;
    var secondInitializerRunCount = 0;
    var FirstEngine = _emberApplicationSystemEngine.default.extend();
    var firstEngine = undefined,
        firstEngineInstance = undefined;

    FirstEngine.instanceInitializer({
      name: 'first',
      initialize: function (engine) {
        firstInitializerRunCount++;
      }
    });

    var SecondEngine = _emberApplicationSystemEngine.default.extend();
    var secondEngine = undefined,
        secondEngineInstance = undefined;

    SecondEngine.instanceInitializer({
      name: 'second',
      initialize: function (engine) {
        secondInitializerRunCount++;
      }
    });

    firstEngine = FirstEngine.create();
    firstEngineInstance = buildEngineInstance(firstEngine);

    return firstEngineInstance.boot().then(function () {
      equal(firstInitializerRunCount, 1, 'first initializer only was run');
      equal(secondInitializerRunCount, 0, 'first initializer only was run');

      secondEngine = SecondEngine.create();
      secondEngineInstance = buildEngineInstance(secondEngine);
      return secondEngineInstance.boot();
    }).then(function () {
      equal(firstInitializerRunCount, 1, 'second initializer only was run');
      equal(secondInitializerRunCount, 1, 'second initializer only was run');

      _emberMetal.run(function () {
        firstEngineInstance.destroy();
        secondEngineInstance.destroy();

        firstEngine.destroy();
        secondEngine.destroy();
      });
    });
  });

  QUnit.test('initializers are concatenated', function () {
    var firstInitializerRunCount = 0;
    var secondInitializerRunCount = 0;
    var FirstEngine = _emberApplicationSystemEngine.default.extend();

    FirstEngine.instanceInitializer({
      name: 'first',
      initialize: function (engine) {
        firstInitializerRunCount++;
      }
    });

    var SecondEngine = FirstEngine.extend();

    SecondEngine.instanceInitializer({
      name: 'second',
      initialize: function (engine) {
        secondInitializerRunCount++;
      }
    });

    var firstEngine = FirstEngine.create();
    var firstEngineInstance = buildEngineInstance(firstEngine);

    var secondEngine = undefined,
        secondEngineInstance = undefined;

    return firstEngineInstance.boot().then(function () {
      equal(firstInitializerRunCount, 1, 'first initializer only was run when base class created');
      equal(secondInitializerRunCount, 0, 'second initializer was not run when first base class created');
      firstInitializerRunCount = 0;

      secondEngine = SecondEngine.create();
      secondEngineInstance = buildEngineInstance(secondEngine);
      return secondEngineInstance.boot();
    }).then(function () {
      equal(firstInitializerRunCount, 1, 'first initializer was run when subclass created');
      equal(secondInitializerRunCount, 1, 'second initializers was run when subclass created');

      _emberMetal.run(function () {
        firstEngineInstance.destroy();
        secondEngineInstance.destroy();

        firstEngine.destroy();
        secondEngine.destroy();
      });
    });
  });

  QUnit.test('initializers are per-engine', function () {
    expect(2);

    var FirstEngine = _emberApplicationSystemEngine.default.extend();

    FirstEngine.instanceInitializer({
      name: 'abc',
      initialize: function (engine) {}
    });

    expectAssertion(function () {
      FirstEngine.instanceInitializer({
        name: 'abc',
        initialize: function (engine) {}
      });
    });

    var SecondEngine = _emberApplicationSystemEngine.default.extend();
    SecondEngine.instanceInitializer({
      name: 'abc',
      initialize: function (engine) {}
    });

    ok(true, 'Two engines can have initializers named the same.');
  });

  QUnit.test('initializers are executed in their own context', function () {
    expect(1);

    var MyEngine = _emberApplicationSystemEngine.default.extend();

    MyEngine.instanceInitializer({
      name: 'coolInitializer',
      myProperty: 'cool',
      initialize: function (engine) {
        equal(this.myProperty, 'cool', 'should have access to its own context');
      }
    });

    myEngine = MyEngine.create();
    myEngineInstance = buildEngineInstance(myEngine);

    return myEngineInstance.boot();
  });
});
enifed('ember-application/tests/system/engine_instance_test', ['exports', 'ember-application/system/engine', 'ember-application/system/engine-instance', 'ember-application/system/engine-parent', 'ember-metal', 'internal-test-helpers'], function (exports, _emberApplicationSystemEngine, _emberApplicationSystemEngineInstance, _emberApplicationSystemEngineParent, _emberMetal, _internalTestHelpers) {
  'use strict';

  var engine = undefined,
      engineInstance = undefined;

  QUnit.module('Ember.EngineInstance', {
    setup: function () {
      _emberMetal.run(function () {
        engine = _emberApplicationSystemEngine.default.create({ router: null });
      });
    },

    teardown: function () {
      if (engineInstance) {
        _emberMetal.run(engineInstance, 'destroy');
      }

      if (engine) {
        _emberMetal.run(engine, 'destroy');
      }
    }
  });

  QUnit.test('an engine instance can be created based upon a base engine', function () {
    _emberMetal.run(function () {
      engineInstance = _emberApplicationSystemEngineInstance.default.create({ base: engine });
    });

    ok(engineInstance, 'instance should be created');
    equal(engineInstance.base, engine, 'base should be set to engine');
  });

  QUnit.test('unregistering a factory clears all cached instances of that factory', function (assert) {
    assert.expect(3);

    engineInstance = _emberMetal.run(function () {
      return _emberApplicationSystemEngineInstance.default.create({ base: engine });
    });

    var PostComponent = _internalTestHelpers.factory();

    engineInstance.register('component:post', PostComponent);

    var postComponent1 = engineInstance.lookup('component:post');
    assert.ok(postComponent1, 'lookup creates instance');

    engineInstance.unregister('component:post');
    engineInstance.register('component:post', PostComponent);

    var postComponent2 = engineInstance.lookup('component:post');
    assert.ok(postComponent2, 'lookup creates instance');

    assert.notStrictEqual(postComponent1, postComponent2, 'lookup creates a brand new instance because previous one was reset');
  });

  QUnit.test('can be booted when its parent has been set', function (assert) {
    assert.expect(3);

    engineInstance = _emberMetal.run(function () {
      return _emberApplicationSystemEngineInstance.default.create({ base: engine });
    });

    expectAssertion(function () {
      engineInstance._bootSync();
    }, 'An engine instance\'s parent must be set via `setEngineParent(engine, parent)` prior to calling `engine.boot()`.');

    _emberApplicationSystemEngineParent.setEngineParent(engineInstance, {});

    // Stub `cloneParentDependencies`, the internals of which are tested along
    // with application instances.
    engineInstance.cloneParentDependencies = function () {
      assert.ok(true, 'parent dependencies are cloned');
    };

    return engineInstance.boot().then(function () {
      assert.ok(true, 'boot successful');
    });
  });

  QUnit.test('can build a child instance of a registered engine', function (assert) {
    var ChatEngine = _emberApplicationSystemEngine.default.extend();
    var chatEngineInstance = undefined;

    engine.register('engine:chat', ChatEngine);

    _emberMetal.run(function () {
      engineInstance = _emberApplicationSystemEngineInstance.default.create({ base: engine });

      // Try to build an unregistered engine.
      throws(function () {
        engineInstance.buildChildEngineInstance('fake');
      }, 'You attempted to mount the engine \'fake\', but it is not registered with its parent.');

      // Build the `chat` engine, registered above.
      chatEngineInstance = engineInstance.buildChildEngineInstance('chat');
    });

    assert.ok(chatEngineInstance, 'child engine instance successfully created');

    assert.strictEqual(_emberApplicationSystemEngineParent.getEngineParent(chatEngineInstance), engineInstance, 'child engine instance is assigned the correct parent');
  });
});
enifed('ember-application/tests/system/engine_parent_test', ['exports', 'ember-application/system/engine-parent'], function (exports, _emberApplicationSystemEngineParent) {
  'use strict';

  QUnit.module('EngineParent', {});

  QUnit.test('An engine\'s parent can be set with `setEngineParent` and retrieved with `getEngineParent`', function () {
    var engine = {};
    var parent = {};

    strictEqual(_emberApplicationSystemEngineParent.getEngineParent(engine), undefined, 'parent has not been set');

    _emberApplicationSystemEngineParent.setEngineParent(engine, parent);

    strictEqual(_emberApplicationSystemEngineParent.getEngineParent(engine), parent, 'parent has been set');

    strictEqual(engine[_emberApplicationSystemEngineParent.ENGINE_PARENT], parent, 'parent has been set to the ENGINE_PARENT symbol');
  });
});
enifed('ember-application/tests/system/engine_test', ['exports', 'ember-environment', 'ember-metal', 'ember-application/system/engine', 'ember-runtime', 'container', 'ember-application/tests/test-helpers/registry-check'], function (exports, _emberEnvironment, _emberMetal, _emberApplicationSystemEngine, _emberRuntime, _container, _emberApplicationTestsTestHelpersRegistryCheck) {
  'use strict';

  var _templateObject = babelHelpers.taggedTemplateLiteralLoose(['-bucket-cache:main'], ['-bucket-cache:main']),
      _templateObject2 = babelHelpers.taggedTemplateLiteralLoose(['template:components/-default'], ['template:components/-default']);

  var engine = undefined;
  var originalLookup = _emberEnvironment.context.lookup;
  var lookup = undefined;

  QUnit.module('Ember.Engine', {
    setup: function () {
      lookup = _emberEnvironment.context.lookup = {};
      engine = _emberMetal.run(function () {
        return _emberApplicationSystemEngine.default.create();
      });
    },

    teardown: function () {
      _emberEnvironment.context.lookup = originalLookup;
      if (engine) {
        _emberMetal.run(engine, 'destroy');
      }
    }
  });

  QUnit.test('acts like a namespace', function () {
    engine = _emberMetal.run(function () {
      return lookup.TestEngine = _emberApplicationSystemEngine.default.create();
    });

    engine.Foo = _emberRuntime.Object.extend();
    equal(engine.Foo.toString(), 'TestEngine.Foo', 'Classes pick up their parent namespace');
  });

  QUnit.test('builds a registry', function () {
    strictEqual(engine.resolveRegistration('application:main'), engine, 'application:main is registered');
    deepEqual(engine.registeredOptionsForType('component'), { singleton: false }, 'optionsForType \'component\'');
    deepEqual(engine.registeredOptionsForType('view'), { singleton: false }, 'optionsForType \'view\'');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(engine, 'controller:basic');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(engine, 'view', '_viewRegistry', '-view-registry:main');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(engine, 'route', '_topLevelViewTemplate', 'template:-outlet');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(engine, 'view:-outlet', 'namespace', 'application:main');

    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(engine, 'controller', 'target', 'router:main');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(engine, 'controller', 'namespace', 'application:main');

    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(engine, 'router', '_bucketCache', _container.privatize(_templateObject));
    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(engine, 'route', '_bucketCache', _container.privatize(_templateObject));

    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(engine, 'route', 'router', 'router:main');

    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(engine, 'component:-text-field');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(engine, 'component:-text-area');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(engine, 'component:-checkbox');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(engine, 'component:link-to');

    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(engine, 'service:-routing');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(engine, 'service:-routing', 'router', 'router:main');

    // DEBUGGING
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(engine, 'resolver-for-debugging:main');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(engine, 'container-debug-adapter:main', 'resolver', 'resolver-for-debugging:main');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(engine, 'data-adapter:main', 'containerDebugAdapter', 'container-debug-adapter:main');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(engine, 'container-debug-adapter:main');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(engine, 'component-lookup:main');

    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(engine, 'service:-dom-changes', 'document', 'service:-document');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(engine, 'service:-dom-tree-construction', 'document', 'service:-document');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(engine, 'view:-outlet');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(engine, _container.privatize(_templateObject2));
    _emberApplicationTestsTestHelpersRegistryCheck.verifyRegistration(engine, 'template:-outlet');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(engine, 'view:-outlet', 'template', 'template:-outlet');
    _emberApplicationTestsTestHelpersRegistryCheck.verifyInjection(engine, 'template', 'env', 'service:-glimmer-environment');
    deepEqual(engine.registeredOptionsForType('helper'), { instantiate: false }, 'optionsForType \'helper\'');
  });
});
enifed('ember-application/tests/system/initializers_test', ['exports', 'ember-metal', 'ember-application/system/application', 'ember-views'], function (exports, _emberMetal, _emberApplicationSystemApplication, _emberViews) {
  'use strict';

  var app = undefined;

  QUnit.module('Ember.Application initializers', {
    teardown: function () {
      if (app) {
        _emberMetal.run(function () {
          return app.destroy();
        });
      }
    }
  });

  QUnit.test('initializers require proper \'name\' and \'initialize\' properties', function () {
    var MyApplication = _emberApplicationSystemApplication.default.extend();

    expectAssertion(function () {
      _emberMetal.run(function () {
        MyApplication.initializer({ name: 'initializer' });
      });
    });

    expectAssertion(function () {
      _emberMetal.run(function () {
        MyApplication.initializer({ initialize: function () {} });
      });
    });
  });

  QUnit.test('initializers that throw errors cause the boot promise to reject with the error', function () {
    QUnit.expect(2);
    QUnit.stop();

    var MyApplication = _emberApplicationSystemApplication.default.extend();

    MyApplication.initializer({
      name: 'initializer',
      initialize: function () {
        throw new Error('boot failure');
      }
    });

    app = MyApplication.create({
      autoboot: false
    });

    try {
      app.boot().then(function (app) {
        QUnit.start();
        ok(false, 'The boot promise should not resolve when there is a boot error');
      }, function (err) {
        QUnit.start();
        ok(err instanceof Error, 'The boot promise should reject with an error');
        equal(err.message, 'boot failure');
      });
    } catch (e) {
      QUnit.start();
      ok(false, 'The boot method should not throw');
      throw e;
    }
  });

  QUnit.test('initializers are passed an App', function () {
    var MyApplication = _emberApplicationSystemApplication.default.extend();

    MyApplication.initializer({
      name: 'initializer',
      initialize: function (App) {
        ok(App instanceof _emberApplicationSystemApplication.default, 'initialize is passed an Application');
      }
    });

    _emberMetal.run(function () {
      app = MyApplication.create({
        router: false,
        rootElement: '#qunit-fixture'
      });
    });
  });

  QUnit.test('initializers can be registered in a specified order', function () {
    var order = [];
    var MyApplication = _emberApplicationSystemApplication.default.extend();
    MyApplication.initializer({
      name: 'fourth',
      after: 'third',
      initialize: function (registry) {
        order.push('fourth');
      }
    });

    MyApplication.initializer({
      name: 'second',
      after: 'first',
      before: 'third',
      initialize: function (registry) {
        order.push('second');
      }
    });

    MyApplication.initializer({
      name: 'fifth',
      after: 'fourth',
      before: 'sixth',
      initialize: function (registry) {
        order.push('fifth');
      }
    });

    MyApplication.initializer({
      name: 'first',
      before: 'second',
      initialize: function (registry) {
        order.push('first');
      }
    });

    MyApplication.initializer({
      name: 'third',
      initialize: function (registry) {
        order.push('third');
      }
    });

    MyApplication.initializer({
      name: 'sixth',
      initialize: function (registry) {
        order.push('sixth');
      }
    });

    _emberMetal.run(function () {
      app = MyApplication.create({
        router: false,
        rootElement: '#qunit-fixture'
      });
    });

    deepEqual(order, ['first', 'second', 'third', 'fourth', 'fifth', 'sixth']);
  });

  QUnit.test('initializers can be registered in a specified order as an array', function () {
    var order = [];
    var MyApplication = _emberApplicationSystemApplication.default.extend();

    MyApplication.initializer({
      name: 'third',
      initialize: function (registry) {
        order.push('third');
      }
    });

    MyApplication.initializer({
      name: 'second',
      after: 'first',
      before: ['third', 'fourth'],
      initialize: function (registry) {
        order.push('second');
      }
    });

    MyApplication.initializer({
      name: 'fourth',
      after: ['second', 'third'],
      initialize: function (registry) {
        order.push('fourth');
      }
    });

    MyApplication.initializer({
      name: 'fifth',
      after: 'fourth',
      before: 'sixth',
      initialize: function (registry) {
        order.push('fifth');
      }
    });

    MyApplication.initializer({
      name: 'first',
      before: ['second'],
      initialize: function (registry) {
        order.push('first');
      }
    });

    MyApplication.initializer({
      name: 'sixth',
      initialize: function (registry) {
        order.push('sixth');
      }
    });

    _emberMetal.run(function () {
      app = MyApplication.create({
        router: false,
        rootElement: '#qunit-fixture'
      });
    });

    deepEqual(order, ['first', 'second', 'third', 'fourth', 'fifth', 'sixth']);
  });

  QUnit.test('initializers can have multiple dependencies', function () {
    var order = [];
    var a = {
      name: 'a',
      before: 'b',
      initialize: function (registry) {
        order.push('a');
      }
    };
    var b = {
      name: 'b',
      initialize: function (registry) {
        order.push('b');
      }
    };
    var c = {
      name: 'c',
      after: 'b',
      initialize: function (registry) {
        order.push('c');
      }
    };
    var afterB = {
      name: 'after b',
      after: 'b',
      initialize: function (registry) {
        order.push('after b');
      }
    };
    var afterC = {
      name: 'after c',
      after: 'c',
      initialize: function (registry) {
        order.push('after c');
      }
    };

    _emberApplicationSystemApplication.default.initializer(b);
    _emberApplicationSystemApplication.default.initializer(a);
    _emberApplicationSystemApplication.default.initializer(afterC);
    _emberApplicationSystemApplication.default.initializer(afterB);
    _emberApplicationSystemApplication.default.initializer(c);

    _emberMetal.run(function () {
      app = _emberApplicationSystemApplication.default.create({
        router: false,
        rootElement: '#qunit-fixture'
      });
    });

    ok(order.indexOf(a.name) < order.indexOf(b.name), 'a < b');
    ok(order.indexOf(b.name) < order.indexOf(c.name), 'b < c');
    ok(order.indexOf(b.name) < order.indexOf(afterB.name), 'b < afterB');
    ok(order.indexOf(c.name) < order.indexOf(afterC.name), 'c < afterC');
  });

  QUnit.test('initializers set on Application subclasses are not shared between apps', function () {
    var firstInitializerRunCount = 0;
    var secondInitializerRunCount = 0;
    var FirstApp = _emberApplicationSystemApplication.default.extend();

    FirstApp.initializer({
      name: 'first',
      initialize: function (registry) {
        firstInitializerRunCount++;
      }
    });

    var SecondApp = _emberApplicationSystemApplication.default.extend();

    SecondApp.initializer({
      name: 'second',
      initialize: function (registry) {
        secondInitializerRunCount++;
      }
    });

    _emberViews.jQuery('#qunit-fixture').html('<div id="first"></div><div id="second"></div>');

    var firstApp = _emberMetal.run(function () {
      return FirstApp.create({
        router: false,
        rootElement: '#qunit-fixture #first'
      });
    });

    equal(firstInitializerRunCount, 1, 'first initializer only was run');
    equal(secondInitializerRunCount, 0, 'first initializer only was run');

    var secondApp = _emberMetal.run(function () {
      return SecondApp.create({
        router: false,
        rootElement: '#qunit-fixture #second'
      });
    });

    equal(firstInitializerRunCount, 1, 'second initializer only was run');
    equal(secondInitializerRunCount, 1, 'second initializer only was run');

    _emberMetal.run(function () {
      firstApp.destroy();
      secondApp.destroy();
    });
  });

  QUnit.test('initializers are concatenated', function () {
    var firstInitializerRunCount = 0;
    var secondInitializerRunCount = 0;
    var FirstApp = _emberApplicationSystemApplication.default.extend();

    FirstApp.initializer({
      name: 'first',
      initialize: function (registry) {
        firstInitializerRunCount++;
      }
    });

    var SecondApp = FirstApp.extend();
    SecondApp.initializer({
      name: 'second',
      initialize: function (registry) {
        secondInitializerRunCount++;
      }
    });

    _emberViews.jQuery('#qunit-fixture').html('<div id="first"></div><div id="second"></div>');
    var firstApp = _emberMetal.run(function () {
      return FirstApp.create({
        router: false,
        rootElement: '#qunit-fixture #first'
      });
    });
    equal(firstInitializerRunCount, 1, 'first initializer only was run when base class created');
    equal(secondInitializerRunCount, 0, 'first initializer only was run when base class created');
    firstInitializerRunCount = 0;

    var secondApp = _emberMetal.run(function () {
      return SecondApp.create({
        router: false,
        rootElement: '#qunit-fixture #second'
      });
    });

    equal(firstInitializerRunCount, 1, 'first initializer was run when subclass created');
    equal(secondInitializerRunCount, 1, 'second initializers was run when subclass created');
    _emberMetal.run(function () {
      firstApp.destroy();
      secondApp.destroy();
    });
  });

  QUnit.test('initializers are per-app', function () {
    expect(2);

    var FirstApp = _emberApplicationSystemApplication.default.extend();

    FirstApp.initializer({
      name: 'abc',
      initialize: function (app) {}
    });

    expectAssertion(function () {
      FirstApp.initializer({
        name: 'abc',
        initialize: function (app) {}
      });
    });

    var SecondApp = _emberApplicationSystemApplication.default.extend();
    SecondApp.instanceInitializer({
      name: 'abc',
      initialize: function (app) {}
    });

    ok(true, 'Two apps can have initializers named the same.');
  });

  QUnit.test('initializers are executed in their own context', function () {
    expect(1);
    var MyApplication = _emberApplicationSystemApplication.default.extend();

    MyApplication.initializer({
      name: 'coolInitializer',
      myProperty: 'cool',
      initialize: function (application) {
        equal(this.myProperty, 'cool', 'should have access to its own context');
      }
    });

    _emberMetal.run(function () {
      app = MyApplication.create({
        router: false,
        rootElement: '#qunit-fixture'
      });
    });
  });

  QUnit.test('initializers throw a deprecation warning when receiving a second argument', function () {
    expect(1);

    var MyApplication = _emberApplicationSystemApplication.default.extend();

    MyApplication.initializer({
      name: 'deprecated',
      initialize: function (registry, application) {}
    });

    expectDeprecation(function () {
      _emberMetal.run(function () {
        app = MyApplication.create({
          router: false,
          rootElement: '#qunit-fixture'
        });
      });
    }, /The `initialize` method for Application initializer 'deprecated' should take only one argument - `App`, an instance of an `Application`./);
  });
});
enifed('ember-application/tests/system/instance_initializers_test', ['exports', 'ember-metal', 'ember-application/system/application', 'ember-application/system/application-instance', 'ember-views'], function (exports, _emberMetal, _emberApplicationSystemApplication, _emberApplicationSystemApplicationInstance, _emberViews) {
  'use strict';

  var app = undefined;

  QUnit.module('Ember.Application instance initializers', {
    teardown: function () {
      if (app) {
        _emberMetal.run(function () {
          return app.destroy();
        });
      }
    }
  });

  QUnit.test('initializers require proper \'name\' and \'initialize\' properties', function () {
    var MyApplication = _emberApplicationSystemApplication.default.extend();

    expectAssertion(function () {
      _emberMetal.run(function () {
        MyApplication.instanceInitializer({ name: 'initializer' });
      });
    });

    expectAssertion(function () {
      _emberMetal.run(function () {
        MyApplication.instanceInitializer({ initialize: function () {} });
      });
    });
  });

  QUnit.test('initializers are passed an app instance', function () {
    var MyApplication = _emberApplicationSystemApplication.default.extend();

    MyApplication.instanceInitializer({
      name: 'initializer',
      initialize: function (instance) {
        ok(instance instanceof _emberApplicationSystemApplicationInstance.default, 'initialize is passed an application instance');
      }
    });

    _emberMetal.run(function () {
      app = MyApplication.create({
        router: false,
        rootElement: '#qunit-fixture'
      });
    });
  });

  QUnit.test('initializers can be registered in a specified order', function () {
    var order = [];
    var MyApplication = _emberApplicationSystemApplication.default.extend();
    MyApplication.instanceInitializer({
      name: 'fourth',
      after: 'third',
      initialize: function (registry) {
        order.push('fourth');
      }
    });

    MyApplication.instanceInitializer({
      name: 'second',
      after: 'first',
      before: 'third',
      initialize: function (registry) {
        order.push('second');
      }
    });

    MyApplication.instanceInitializer({
      name: 'fifth',
      after: 'fourth',
      before: 'sixth',
      initialize: function (registry) {
        order.push('fifth');
      }
    });

    MyApplication.instanceInitializer({
      name: 'first',
      before: 'second',
      initialize: function (registry) {
        order.push('first');
      }
    });

    MyApplication.instanceInitializer({
      name: 'third',
      initialize: function (registry) {
        order.push('third');
      }
    });

    MyApplication.instanceInitializer({
      name: 'sixth',
      initialize: function (registry) {
        order.push('sixth');
      }
    });

    _emberMetal.run(function () {
      app = MyApplication.create({
        router: false,
        rootElement: '#qunit-fixture'
      });
    });

    deepEqual(order, ['first', 'second', 'third', 'fourth', 'fifth', 'sixth']);
  });

  QUnit.test('initializers can be registered in a specified order as an array', function () {
    var order = [];
    var MyApplication = _emberApplicationSystemApplication.default.extend();

    MyApplication.instanceInitializer({
      name: 'third',
      initialize: function (registry) {
        order.push('third');
      }
    });

    MyApplication.instanceInitializer({
      name: 'second',
      after: 'first',
      before: ['third', 'fourth'],
      initialize: function (registry) {
        order.push('second');
      }
    });

    MyApplication.instanceInitializer({
      name: 'fourth',
      after: ['second', 'third'],
      initialize: function (registry) {
        order.push('fourth');
      }
    });

    MyApplication.instanceInitializer({
      name: 'fifth',
      after: 'fourth',
      before: 'sixth',
      initialize: function (registry) {
        order.push('fifth');
      }
    });

    MyApplication.instanceInitializer({
      name: 'first',
      before: ['second'],
      initialize: function (registry) {
        order.push('first');
      }
    });

    MyApplication.instanceInitializer({
      name: 'sixth',
      initialize: function (registry) {
        order.push('sixth');
      }
    });

    _emberMetal.run(function () {
      app = MyApplication.create({
        router: false,
        rootElement: '#qunit-fixture'
      });
    });

    deepEqual(order, ['first', 'second', 'third', 'fourth', 'fifth', 'sixth']);
  });

  QUnit.test('initializers can have multiple dependencies', function () {
    var order = [];
    var a = {
      name: 'a',
      before: 'b',
      initialize: function (registry) {
        order.push('a');
      }
    };
    var b = {
      name: 'b',
      initialize: function (registry) {
        order.push('b');
      }
    };
    var c = {
      name: 'c',
      after: 'b',
      initialize: function (registry) {
        order.push('c');
      }
    };
    var afterB = {
      name: 'after b',
      after: 'b',
      initialize: function (registry) {
        order.push('after b');
      }
    };
    var afterC = {
      name: 'after c',
      after: 'c',
      initialize: function (registry) {
        order.push('after c');
      }
    };

    _emberApplicationSystemApplication.default.instanceInitializer(b);
    _emberApplicationSystemApplication.default.instanceInitializer(a);
    _emberApplicationSystemApplication.default.instanceInitializer(afterC);
    _emberApplicationSystemApplication.default.instanceInitializer(afterB);
    _emberApplicationSystemApplication.default.instanceInitializer(c);

    _emberMetal.run(function () {
      app = _emberApplicationSystemApplication.default.create({
        router: false,
        rootElement: '#qunit-fixture'
      });
    });

    ok(order.indexOf(a.name) < order.indexOf(b.name), 'a < b');
    ok(order.indexOf(b.name) < order.indexOf(c.name), 'b < c');
    ok(order.indexOf(b.name) < order.indexOf(afterB.name), 'b < afterB');
    ok(order.indexOf(c.name) < order.indexOf(afterC.name), 'c < afterC');
  });

  QUnit.test('initializers set on Application subclasses should not be shared between apps', function () {
    var firstInitializerRunCount = 0;
    var secondInitializerRunCount = 0;
    var FirstApp = _emberApplicationSystemApplication.default.extend();
    var firstApp = undefined,
        secondApp = undefined;

    FirstApp.instanceInitializer({
      name: 'first',
      initialize: function (registry) {
        firstInitializerRunCount++;
      }
    });
    var SecondApp = _emberApplicationSystemApplication.default.extend();
    SecondApp.instanceInitializer({
      name: 'second',
      initialize: function (registry) {
        secondInitializerRunCount++;
      }
    });
    _emberViews.jQuery('#qunit-fixture').html('<div id="first"></div><div id="second"></div>');
    _emberMetal.run(function () {
      firstApp = FirstApp.create({
        router: false,
        rootElement: '#qunit-fixture #first'
      });
    });
    equal(firstInitializerRunCount, 1, 'first initializer only was run');
    equal(secondInitializerRunCount, 0, 'first initializer only was run');
    _emberMetal.run(function () {
      secondApp = SecondApp.create({
        router: false,
        rootElement: '#qunit-fixture #second'
      });
    });
    equal(firstInitializerRunCount, 1, 'second initializer only was run');
    equal(secondInitializerRunCount, 1, 'second initializer only was run');
    _emberMetal.run(function () {
      firstApp.destroy();
      secondApp.destroy();
    });
  });

  QUnit.test('initializers are concatenated', function () {
    var firstInitializerRunCount = 0;
    var secondInitializerRunCount = 0;
    var FirstApp = _emberApplicationSystemApplication.default.extend();
    var firstApp = undefined,
        secondApp = undefined;

    FirstApp.instanceInitializer({
      name: 'first',
      initialize: function (registry) {
        firstInitializerRunCount++;
      }
    });

    var SecondApp = FirstApp.extend();
    SecondApp.instanceInitializer({
      name: 'second',
      initialize: function (registry) {
        secondInitializerRunCount++;
      }
    });

    _emberViews.jQuery('#qunit-fixture').html('<div id="first"></div><div id="second"></div>');
    _emberMetal.run(function () {
      firstApp = FirstApp.create({
        router: false,
        rootElement: '#qunit-fixture #first'
      });
    });
    equal(firstInitializerRunCount, 1, 'first initializer only was run when base class created');
    equal(secondInitializerRunCount, 0, 'first initializer only was run when base class created');
    firstInitializerRunCount = 0;
    _emberMetal.run(function () {
      secondApp = SecondApp.create({
        router: false,
        rootElement: '#qunit-fixture #second'
      });
    });
    equal(firstInitializerRunCount, 1, 'first initializer was run when subclass created');
    equal(secondInitializerRunCount, 1, 'second initializers was run when subclass created');
    _emberMetal.run(function () {
      firstApp.destroy();
      secondApp.destroy();
    });
  });

  QUnit.test('initializers are per-app', function () {
    expect(2);

    var FirstApp = _emberApplicationSystemApplication.default.extend();

    FirstApp.instanceInitializer({
      name: 'abc',
      initialize: function (app) {}
    });

    expectAssertion(function () {
      FirstApp.instanceInitializer({
        name: 'abc',
        initialize: function (app) {}
      });
    });

    var SecondApp = _emberApplicationSystemApplication.default.extend();
    SecondApp.instanceInitializer({
      name: 'abc',
      initialize: function (app) {}
    });

    ok(true, 'Two apps can have initializers named the same.');
  });

  QUnit.test('initializers are run before ready hook', function () {
    expect(2);

    var readyWasCalled = false;

    var MyApplication = _emberApplicationSystemApplication.default.extend({
      ready: function () {
        ok(true, 'ready is called');
        readyWasCalled = true;
      }
    });

    MyApplication.instanceInitializer({
      name: 'initializer',
      initialize: function () {
        ok(!readyWasCalled, 'ready is not yet called');
      }
    });

    _emberMetal.run(function () {
      app = MyApplication.create({
        router: false,
        rootElement: '#qunit-fixture'
      });
    });
  });

  QUnit.test('initializers are executed in their own context', function () {
    expect(1);

    var MyApplication = _emberApplicationSystemApplication.default.extend();

    MyApplication.instanceInitializer({
      name: 'coolInitializer',
      myProperty: 'cool',
      initialize: function (registry, application) {
        equal(this.myProperty, 'cool', 'should have access to its own context');
      }
    });

    _emberMetal.run(function () {
      app = MyApplication.create({
        router: false,
        rootElement: '#qunit-fixture'
      });
    });
  });

  QUnit.test('initializers get an instance on app reset', function () {
    expect(2);

    var MyApplication = _emberApplicationSystemApplication.default.extend();

    MyApplication.instanceInitializer({
      name: 'giveMeAnInstance',
      initialize: function (instance) {
        ok(!!instance, 'Initializer got an instance');
      }
    });

    _emberMetal.run(function () {
      app = MyApplication.create({
        router: false,
        rootElement: '#qunit-fixture'
      });
    });

    _emberMetal.run(app, 'reset');
  });
});
enifed('ember-application/tests/system/logging_test', ['exports', 'ember-console', 'ember-metal', 'ember-application/system/application', 'ember-runtime', 'ember-routing', 'ember-template-compiler'], function (exports, _emberConsole, _emberMetal, _emberApplicationSystemApplication, _emberRuntime, _emberRouting, _emberTemplateCompiler) {
  /*globals EmberDev */

  'use strict';

  var App = undefined,
      logs = undefined,
      originalLogger = undefined;

  QUnit.module('Ember.Application – logging of generated classes', {
    setup: function () {
      logs = {};

      originalLogger = _emberConsole.default.info;

      _emberConsole.default.info = function () {
        var fullName = arguments[1].fullName;

        logs[fullName] = logs[fullName] || 0;
        logs[fullName]++;
      };

      _emberMetal.run(function () {
        App = _emberApplicationSystemApplication.default.create({
          LOG_ACTIVE_GENERATION: true
        });

        App.Router.reopen({
          location: 'none'
        });

        App.Router.map(function () {
          this.route('posts', { resetNamespace: true });
        });

        App.deferReadiness();
      });
    },

    teardown: function () {
      _emberConsole.default.info = originalLogger;

      _emberMetal.run(App, 'destroy');

      logs = App = null;
    }
  });

  function visit(path) {
    QUnit.stop();

    var promise = _emberMetal.run(function () {
      return new _emberRuntime.RSVP.Promise(function (resolve, reject) {
        var router = App.__container__.lookup('router:main');

        resolve(router.handleURL(path).then(function (value) {
          QUnit.start();
          ok(true, 'visited: `' + path + '`');
          return value;
        }, function (reason) {
          QUnit.start();
          ok(false, 'failed to visit:`' + path + '` reason: `' + QUnit.jsDump.parse(reason));
          throw reason;
        }));
      });
    });

    return {
      then: function (resolve, reject) {
        _emberMetal.run(promise, 'then', resolve, reject);
      }
    };
  }

  QUnit.test('log class generation if logging enabled', function () {
    if (EmberDev && EmberDev.runningProdBuild) {
      ok(true, 'Logging does not occur in production builds');
      return;
    }

    _emberMetal.run(App, 'advanceReadiness');

    visit('/posts').then(function () {
      equal(Object.keys(logs).length, 6, 'expected logs');
    });
  });

  QUnit.test('do NOT log class generation if logging disabled', function () {
    App.reopen({
      LOG_ACTIVE_GENERATION: false
    });

    _emberMetal.run(App, 'advanceReadiness');

    visit('/posts').then(function () {
      equal(Object.keys(logs).length, 0, 'expected no logs');
    });
  });

  QUnit.test('actively generated classes get logged', function () {
    if (EmberDev && EmberDev.runningProdBuild) {
      ok(true, 'Logging does not occur in production builds');
      return;
    }

    _emberMetal.run(App, 'advanceReadiness');

    visit('/posts').then(function () {
      equal(logs['controller:application'], 1, 'expected: ApplicationController was generated');
      equal(logs['controller:posts'], 1, 'expected: PostsController was generated');

      equal(logs['route:application'], 1, 'expected: ApplicationRoute was generated');
      equal(logs['route:posts'], 1, 'expected: PostsRoute was generated');
    });
  });

  QUnit.test('predefined classes do not get logged', function () {
    App.ApplicationController = _emberRuntime.Controller.extend();
    App.PostsController = _emberRuntime.Controller.extend();

    App.ApplicationRoute = _emberRouting.Route.extend();
    App.PostsRoute = _emberRouting.Route.extend();

    _emberMetal.run(App, 'advanceReadiness');

    visit('/posts').then(function () {
      ok(!logs['controller:application'], 'did not expect: ApplicationController was generated');
      ok(!logs['controller:posts'], 'did not expect: PostsController was generated');

      ok(!logs['route:application'], 'did not expect: ApplicationRoute was generated');
      ok(!logs['route:posts'], 'did not expect: PostsRoute was generated');
    });
  });

  QUnit.module('Ember.Application – logging of view lookups', {
    setup: function () {
      logs = {};

      originalLogger = _emberConsole.default.info;

      _emberConsole.default.info = function () {
        var fullName = arguments[1].fullName;

        logs[fullName] = logs[fullName] || 0;
        logs[fullName]++;
      };

      _emberMetal.run(function () {
        App = _emberApplicationSystemApplication.default.create({
          LOG_VIEW_LOOKUPS: true
        });

        App.Router.reopen({
          location: 'none'
        });

        App.Router.map(function () {
          this.route('posts', { resetNamespace: true });
        });

        App.deferReadiness();
      });
    },

    teardown: function () {
      _emberConsole.default.info = originalLogger;

      _emberMetal.run(App, 'destroy');

      logs = App = null;
    }
  });

  QUnit.test('log when template and view are missing when flag is active', function () {
    if (EmberDev && EmberDev.runningProdBuild) {
      ok(true, 'Logging does not occur in production builds');
      return;
    }

    App.register('template:application', _emberTemplateCompiler.compile('{{outlet}}'));
    _emberMetal.run(App, 'advanceReadiness');

    visit('/posts').then(function () {
      equal(logs['template:application'], undefined, 'expected: Should not log template:application since it exists.');
      equal(logs['template:index'], 1, 'expected: Could not find "index" template or view.');
      equal(logs['template:posts'], 1, 'expected: Could not find "posts" template or view.');
    });
  });

  QUnit.test('do not log when template and view are missing when flag is not true', function () {
    App.reopen({
      LOG_VIEW_LOOKUPS: false
    });

    _emberMetal.run(App, 'advanceReadiness');

    visit('/posts').then(function () {
      equal(Object.keys(logs).length, 0, 'expected no logs');
    });
  });

  QUnit.test('do not log which views are used with templates when flag is not true', function () {
    App.reopen({
      LOG_VIEW_LOOKUPS: false
    });

    _emberMetal.run(App, 'advanceReadiness');

    visit('/posts').then(function () {
      equal(Object.keys(logs).length, 0, 'expected no logs');
    });
  });
});
enifed('ember-application/tests/system/readiness_test', ['exports', 'ember-metal', 'ember-application/system/application'], function (exports, _emberMetal, _emberApplicationSystemApplication) {
  'use strict';

  var jQuery = undefined,
      application = undefined,
      Application = undefined;
  var readyWasCalled = undefined,
      domReady = undefined,
      readyCallbacks = undefined;

  // We are using a small mock of jQuery because jQuery is third-party code with
  // very well-defined semantics, and we want to confirm that a jQuery stub run
  // in a more minimal server environment that implements this behavior will be
  // sufficient for Ember's requirements.

  QUnit.module('Application readiness', {
    setup: function () {
      readyWasCalled = 0;
      readyCallbacks = [];

      var jQueryInstance = {
        ready: function (callback) {
          readyCallbacks.push(callback);
          if (jQuery.isReady) {
            domReady();
          }
        }
      };

      jQuery = function () {
        return jQueryInstance;
      };
      jQuery.isReady = false;

      var domReadyCalled = 0;
      domReady = function () {
        if (domReadyCalled !== 0) {
          return;
        }
        domReadyCalled++;
        for (var i = 0; i < readyCallbacks.length; i++) {
          readyCallbacks[i]();
        }
      };

      Application = _emberApplicationSystemApplication.default.extend({
        $: jQuery,

        ready: function () {
          readyWasCalled++;
        }
      });
    },

    teardown: function () {
      if (application) {
        _emberMetal.run(function () {
          return application.destroy();
        });
      }
    }
  });

  // These tests are confirming that if the callbacks passed into jQuery's ready hook is called
  // synchronously during the application's initialization, we get the same behavior as if
  // it was triggered after initialization.

  QUnit.test('Ember.Application\'s ready event is called right away if jQuery is already ready', function () {
    jQuery.isReady = true;

    _emberMetal.run(function () {
      application = Application.create({ router: false });

      equal(readyWasCalled, 0, 'ready is not called until later');
    });

    equal(readyWasCalled, 1, 'ready was called');

    domReady();

    equal(readyWasCalled, 1, 'application\'s ready was not called again');
  });

  QUnit.test('Ember.Application\'s ready event is called after the document becomes ready', function () {
    _emberMetal.run(function () {
      application = Application.create({ router: false });
    });

    equal(readyWasCalled, 0, 'ready wasn\'t called yet');

    domReady();

    equal(readyWasCalled, 1, 'ready was called now that DOM is ready');
  });

  QUnit.test('Ember.Application\'s ready event can be deferred by other components', function () {
    _emberMetal.run(function () {
      application = Application.create({ router: false });
      application.deferReadiness();
    });

    equal(readyWasCalled, 0, 'ready wasn\'t called yet');

    domReady();

    equal(readyWasCalled, 0, 'ready wasn\'t called yet');

    _emberMetal.run(function () {
      application.advanceReadiness();
      equal(readyWasCalled, 0);
    });

    equal(readyWasCalled, 1, 'ready was called now all readiness deferrals are advanced');
  });

  QUnit.test('Ember.Application\'s ready event can be deferred by other components', function () {
    jQuery.isReady = false;

    _emberMetal.run(function () {
      application = Application.create({ router: false });
      application.deferReadiness();
      equal(readyWasCalled, 0, 'ready wasn\'t called yet');
    });

    domReady();

    equal(readyWasCalled, 0, 'ready wasn\'t called yet');

    _emberMetal.run(function () {
      application.advanceReadiness();
    });

    equal(readyWasCalled, 1, 'ready was called now all readiness deferrals are advanced');

    expectAssertion(function () {
      application.deferReadiness();
    });
  });
});
enifed('ember-application/tests/system/reset_test', ['exports', 'ember-metal', 'ember-application/system/application', 'ember-runtime', 'ember-routing', 'container'], function (exports, _emberMetal, _emberApplicationSystemApplication, _emberRuntime, _emberRouting, _container) {
  'use strict';

  var application = undefined,
      Application = undefined;

  QUnit.module('Ember.Application - resetting', {
    setup: function () {
      Application = _emberApplicationSystemApplication.default.extend({
        name: 'App',
        rootElement: '#qunit-fixture'
      });
    },
    teardown: function () {
      Application = null;
      if (application) {
        _emberMetal.run(application, 'destroy');
      }
    }
  });

  QUnit.test('Brings its own run-loop if not provided', function () {
    application = _emberMetal.run(Application, 'create');
    application.ready = function () {
      QUnit.start();
      ok(true, 'app booted');
    };

    QUnit.stop();
    application.reset();
  });

  QUnit.test('Does not bring its own run loop if one is already provided', function () {
    expect(3);

    var didBecomeReady = false;

    application = _emberMetal.run(Application, 'create');

    _emberMetal.run(function () {
      application.ready = function () {
        didBecomeReady = true;
      };

      application.reset();

      application.deferReadiness();
      ok(!didBecomeReady, 'app is not ready');
    });

    ok(!didBecomeReady, 'app is not ready');
    _emberMetal.run(application, 'advanceReadiness');
    ok(didBecomeReady, 'app is ready');
  });

  QUnit.test('When an application is reset, new instances of controllers are generated', function () {
    _emberMetal.run(function () {
      application = Application.create();
      application.AcademicController = _emberRuntime.Controller.extend();
    });

    var firstController = application.__container__.lookup('controller:academic');
    var secondController = application.__container__.lookup('controller:academic');

    application.reset();

    var thirdController = application.__container__.lookup('controller:academic');

    strictEqual(firstController, secondController, 'controllers looked up in succession should be the same instance');

    ok(firstController.isDestroying, 'controllers are destroyed when their application is reset');

    notStrictEqual(firstController, thirdController, 'controllers looked up after the application is reset should not be the same instance');
  });

  QUnit.test('When an application is reset, the eventDispatcher is destroyed and recreated', function () {
    var eventDispatcherWasSetup = undefined,
        eventDispatcherWasDestroyed = undefined;

    eventDispatcherWasSetup = 0;
    eventDispatcherWasDestroyed = 0;

    var mock_event_dispatcher = {
      create: function () {
        return {
          setup: function () {
            eventDispatcherWasSetup++;
          },
          destroy: function () {
            eventDispatcherWasDestroyed++;
          }
        };
      }
    };

    // this is pretty awful. We should make this less Global-ly.
    var originalRegister = _container.Registry.prototype.register;
    _container.Registry.prototype.register = function (name, type, options) {
      if (name === 'event_dispatcher:main') {
        return mock_event_dispatcher;
      } else {
        return originalRegister.call(this, name, type, options);
      }
    };

    try {
      _emberMetal.run(function () {
        application = Application.create();

        equal(eventDispatcherWasSetup, 0);
        equal(eventDispatcherWasDestroyed, 0);
      });

      equal(eventDispatcherWasSetup, 1);
      equal(eventDispatcherWasDestroyed, 0);

      application.reset();

      equal(eventDispatcherWasDestroyed, 1);
      equal(eventDispatcherWasSetup, 2, 'setup called after reset');
    } catch (error) {
      _container.Registry.prototype.register = originalRegister;
    }

    _container.Registry.prototype.register = originalRegister;
  });

  QUnit.test('When an application is reset, the router URL is reset to `/`', function () {
    var location = undefined,
        router = undefined;

    _emberMetal.run(function () {
      application = Application.create();
      application.Router = _emberRouting.Router.extend({
        location: 'none'
      });

      application.Router.map(function () {
        this.route('one');
        this.route('two');
      });
    });

    router = application.__container__.lookup('router:main');

    location = router.get('location');

    _emberMetal.run(function () {
      location.handleURL('/one');
    });

    application.reset();

    var applicationController = application.__container__.lookup('controller:application');
    router = application.__container__.lookup('router:main');
    location = router.get('location');

    equal(location.getURL(), '');

    equal(_emberMetal.get(applicationController, 'currentPath'), 'index');

    location = application.__container__.lookup('router:main').get('location');
    _emberMetal.run(function () {
      location.handleURL('/one');
    });

    equal(_emberMetal.get(applicationController, 'currentPath'), 'one');
  });

  QUnit.test('When an application with advance/deferReadiness is reset, the app does correctly become ready after reset', function () {
    var readyCallCount;

    readyCallCount = 0;

    _emberMetal.run(function () {
      application = Application.create({
        ready: function () {
          readyCallCount++;
        }
      });

      application.deferReadiness();
      equal(readyCallCount, 0, 'ready has not yet been called');
    });

    _emberMetal.run(function () {
      application.advanceReadiness();
    });

    equal(readyCallCount, 1, 'ready was called once');

    application.reset();

    equal(readyCallCount, 2, 'ready was called twice');
  });

  QUnit.test('With ember-data like initializer and constant', function () {
    var DS = {
      Store: _emberRuntime.Object.extend({
        init: function () {
          if (!_emberMetal.get(DS, 'defaultStore')) {
            _emberMetal.set(DS, 'defaultStore', this);
          }

          this._super.apply(this, arguments);
        },
        willDestroy: function () {
          if (_emberMetal.get(DS, 'defaultStore') === this) {
            _emberMetal.set(DS, 'defaultStore', null);
          }
        }
      })
    };

    Application.initializer({
      name: 'store',
      initialize: function (application) {
        application.unregister('store:main');
        application.register('store:main', application.Store);

        application.__container__.lookup('store:main');
      }
    });

    _emberMetal.run(function () {
      application = Application.create();
      application.Store = DS.Store;
    });

    ok(DS.defaultStore, 'has defaultStore');

    application.reset();

    ok(DS.defaultStore, 'still has defaultStore');
    ok(application.__container__.lookup('store:main'), 'store is still present');
  });
});
enifed('ember-application/tests/system/visit_test', ['exports', 'ember-runtime', 'ember-metal', 'ember-application/system/application', 'ember-application/system/application-instance', 'ember-application/system/engine', 'ember-routing', 'ember-glimmer', 'ember-template-compiler', 'ember-views'], function (exports, _emberRuntime, _emberMetal, _emberApplicationSystemApplication, _emberApplicationSystemApplicationInstance, _emberApplicationSystemEngine, _emberRouting, _emberGlimmer, _emberTemplateCompiler, _emberViews) {
  'use strict';

  var App = null;
  var instance = null;
  var instances = [];

  function createApplication(integration) {
    App = _emberApplicationSystemApplication.default.extend().create({
      autoboot: false,
      rootElement: '#qunit-fixture',
      LOG_TRANSITIONS: true,
      LOG_TRANSITIONS_INTERNAL: true,
      LOG_ACTIVE_GENERATION: true
    });

    App.Router = _emberRouting.Router.extend({
      location: 'none'
    });

    if (integration) {
      App.instanceInitializer({
        name: 'auto-cleanup',
        initialize: function (_instance) {
          instances.push(_instance);
        }
      });
    } else {
      App.instanceInitializer({
        name: 'auto-cleanup',
        initialize: function (_instance) {
          if (instance) {
            _emberMetal.run(instance, 'destroy');
          }

          instance = _instance;
        }
      });
    }

    return App;
  }

  function expectAsyncError() {
    _emberRuntime.RSVP.off('error');
  }

  QUnit.module('Ember.Application - visit()', {
    teardown: function () {
      _emberRuntime.RSVP.on('error', _emberRuntime.onerrorDefault);

      if (instance) {
        _emberMetal.run(instance, 'destroy');
        instance = null;
      }

      if (App) {
        _emberMetal.run(App, 'destroy');
        App = null;
      }
    }
  });

  // This tests whether the application is "autobooted" by registering an
  // instance initializer and asserting it never gets run. Since this is
  // inherently testing that async behavior *doesn't* happen, we set a
  // 500ms timeout to verify that when autoboot is set to false, the
  // instance initializer that would normally get called on DOM ready
  // does not fire.
  QUnit.test('Applications with autoboot set to false do not autoboot', function (assert) {
    function delay(time) {
      return new _emberRuntime.RSVP.Promise(function (resolve) {
        return _emberMetal.run.later(resolve, time);
      });
    }

    var appBooted = 0;
    var instanceBooted = 0;

    _emberMetal.run(function () {
      createApplication();

      App.initializer({
        name: 'assert-no-autoboot',
        initialize: function () {
          appBooted++;
        }
      });

      App.instanceInitializer({
        name: 'assert-no-autoboot',
        initialize: function () {
          instanceBooted++;
        }
      });
    });

    // Continue after 500ms
    return delay(500).then(function () {
      assert.ok(appBooted === 0, '500ms elapsed without app being booted');
      assert.ok(instanceBooted === 0, '500ms elapsed without instances being booted');

      return _emberMetal.run(App, 'boot');
    }).then(function () {
      assert.ok(appBooted === 1, 'app should boot when manually calling `app.boot()`');
      assert.ok(instanceBooted === 0, 'no instances should be booted automatically when manually calling `app.boot()');
    });
  });

  QUnit.test('calling visit() on an app without first calling boot() should boot the app', function (assert) {
    var appBooted = 0;
    var instanceBooted = 0;

    _emberMetal.run(function () {
      createApplication();

      App.initializer({
        name: 'assert-no-autoboot',
        initialize: function () {
          appBooted++;
        }
      });

      App.instanceInitializer({
        name: 'assert-no-autoboot',
        initialize: function () {
          instanceBooted++;
        }
      });
    });

    return _emberMetal.run(App, 'visit', '/').then(function () {
      assert.ok(appBooted === 1, 'the app should be booted`');
      assert.ok(instanceBooted === 1, 'an instances should be booted');
    });
  });

  QUnit.test('calling visit() on an already booted app should not boot it again', function (assert) {
    var appBooted = 0;
    var instanceBooted = 0;

    _emberMetal.run(function () {
      createApplication();

      App.initializer({
        name: 'assert-no-autoboot',
        initialize: function () {
          appBooted++;
        }
      });

      App.instanceInitializer({
        name: 'assert-no-autoboot',
        initialize: function () {
          instanceBooted++;
        }
      });
    });

    return _emberMetal.run(App, 'boot').then(function () {
      assert.ok(appBooted === 1, 'the app should be booted');
      assert.ok(instanceBooted === 0, 'no instances should be booted');

      return _emberMetal.run(App, 'visit', '/');
    }).then(function () {
      assert.ok(appBooted === 1, 'the app should not be booted again');
      assert.ok(instanceBooted === 1, 'an instance should be booted');

      return _emberMetal.run(App, 'visit', '/');
    }).then(function () {
      assert.ok(appBooted === 1, 'the app should not be booted again');
      assert.ok(instanceBooted === 2, 'another instance should be booted');
    });
  });

  QUnit.test('visit() rejects on application boot failure', function (assert) {
    _emberMetal.run(function () {
      createApplication();

      App.initializer({
        name: 'error',
        initialize: function () {
          throw new Error('boot failure');
        }
      });
    });

    expectAsyncError();

    return _emberMetal.run(App, 'visit', '/').then(function () {
      assert.ok(false, 'It should not resolve the promise');
    }, function (error) {
      assert.ok(error instanceof Error, 'It should reject the promise with the boot error');
      assert.equal(error.message, 'boot failure');
    });
  });

  QUnit.test('visit() rejects on instance boot failure', function (assert) {
    _emberMetal.run(function () {
      createApplication();

      App.instanceInitializer({
        name: 'error',
        initialize: function () {
          throw new Error('boot failure');
        }
      });
    });

    expectAsyncError();

    return _emberMetal.run(App, 'visit', '/').then(function () {
      assert.ok(false, 'It should not resolve the promise');
    }, function (error) {
      assert.ok(error instanceof Error, 'It should reject the promise with the boot error');
      assert.equal(error.message, 'boot failure');
    });
  });

  QUnit.test('visit() follows redirects', function (assert) {
    _emberMetal.run(function () {
      createApplication();

      App.Router.map(function () {
        this.route('a');
        this.route('b', { path: '/b/:b' });
        this.route('c', { path: '/c/:c' });
      });

      App.register('route:a', _emberRouting.Route.extend({
        afterModel: function () {
          this.replaceWith('b', 'zomg');
        }
      }));

      App.register('route:b', _emberRouting.Route.extend({
        afterModel: function (params) {
          this.transitionTo('c', params.b);
        }
      }));
    });

    return _emberMetal.run(App, 'visit', '/a').then(function (instance) {
      assert.ok(instance instanceof _emberApplicationSystemApplicationInstance.default, 'promise is resolved with an ApplicationInstance');
      assert.equal(instance.getURL(), '/c/zomg', 'It should follow all redirects');
    });
  });

  QUnit.test('visit() rejects if an error occured during a transition', function (assert) {
    _emberMetal.run(function () {
      createApplication();

      App.Router.map(function () {
        this.route('a');
        this.route('b', { path: '/b/:b' });
        this.route('c', { path: '/c/:c' });
      });

      App.register('route:a', _emberRouting.Route.extend({
        afterModel: function () {
          this.replaceWith('b', 'zomg');
        }
      }));

      App.register('route:b', _emberRouting.Route.extend({
        afterModel: function (params) {
          this.transitionTo('c', params.b);
        }
      }));

      App.register('route:c', _emberRouting.Route.extend({
        afterModel: function (params) {
          throw new Error('transition failure');
        }
      }));
    });

    expectAsyncError();

    return _emberMetal.run(App, 'visit', '/a').then(function () {
      assert.ok(false, 'It should not resolve the promise');
    }, function (error) {
      assert.ok(error instanceof Error, 'It should reject the promise with the boot error');
      assert.equal(error.message, 'transition failure');
    });
  });

  QUnit.test('visit() chain', function (assert) {
    _emberMetal.run(function () {
      createApplication();

      App.Router.map(function () {
        this.route('a');
        this.route('b');
        this.route('c');
      });
    });

    return _emberMetal.run(App, 'visit', '/').then(function (instance) {
      assert.ok(instance instanceof _emberApplicationSystemApplicationInstance.default, 'promise is resolved with an ApplicationInstance');
      assert.equal(instance.getURL(), '/');

      return instance.visit('/a');
    }).then(function (instance) {
      assert.ok(instance instanceof _emberApplicationSystemApplicationInstance.default, 'promise is resolved with an ApplicationInstance');
      assert.equal(instance.getURL(), '/a');

      return instance.visit('/b');
    }).then(function (instance) {
      assert.ok(instance instanceof _emberApplicationSystemApplicationInstance.default, 'promise is resolved with an ApplicationInstance');
      assert.equal(instance.getURL(), '/b');

      return instance.visit('/c');
    }).then(function (instance) {
      assert.ok(instance instanceof _emberApplicationSystemApplicationInstance.default, 'promise is resolved with an ApplicationInstance');
      assert.equal(instance.getURL(), '/c');
    });
  });

  QUnit.test('visit() returns a promise that resolves when the view has rendered', function (assert) {
    _emberMetal.run(function () {
      createApplication();

      App.register('template:application', _emberTemplateCompiler.compile('<h1>Hello world</h1>'));
    });

    assert.strictEqual(_emberViews.jQuery('#qunit-fixture').children().length, 0, 'there are no elements in the fixture element');

    return _emberMetal.run(App, 'visit', '/').then(function (instance) {
      assert.ok(instance instanceof _emberApplicationSystemApplicationInstance.default, 'promise is resolved with an ApplicationInstance');
      assert.equal(_emberViews.jQuery('#qunit-fixture > .ember-view h1').text(), 'Hello world', 'the application was rendered once the promise resolves');
    });
  });

  QUnit.test('visit() returns a promise that resolves without rendering when shouldRender is set to false', function (assert) {
    assert.expect(3);

    _emberMetal.run(function () {
      createApplication();

      App.register('template:application', _emberTemplateCompiler.compile('<h1>Hello world</h1>'));
    });

    assert.strictEqual(_emberViews.jQuery('#qunit-fixture').children().length, 0, 'there are no elements in the fixture element');

    return _emberMetal.run(App, 'visit', '/', { shouldRender: false }).then(function (instance) {
      assert.ok(instance instanceof _emberApplicationSystemApplicationInstance.default, 'promise is resolved with an ApplicationInstance');
      assert.strictEqual(_emberViews.jQuery('#qunit-fixture').children().length, 0, 'there are still no elements in the fixture element after visit');
    });
  });

  QUnit.test('visit() renders a template when shouldRender is set to true', function (assert) {
    assert.expect(3);

    _emberMetal.run(function () {
      createApplication();

      App.register('template:application', _emberTemplateCompiler.compile('<h1>Hello world</h1>'));
    });

    assert.strictEqual(_emberViews.jQuery('#qunit-fixture').children().length, 0, 'there are no elements in the fixture element');

    return _emberMetal.run(App, 'visit', '/', { shouldRender: true }).then(function (instance) {
      assert.ok(instance instanceof _emberApplicationSystemApplicationInstance.default, 'promise is resolved with an ApplicationInstance');
      assert.strictEqual(_emberViews.jQuery('#qunit-fixture').children().length, 1, 'there is 1 element in the fixture element after visit');
    });
  });

  QUnit.test('visit() returns a promise that resolves without rendering when shouldRender is set to false with Engines', function (assert) {
    assert.expect(3);

    _emberMetal.run(function () {
      createApplication();

      App.register('template:application', _emberTemplateCompiler.compile('<h1>Hello world</h1>'));

      // Register engine
      var BlogEngine = _emberApplicationSystemEngine.default.extend();
      App.register('engine:blog', BlogEngine);

      // Register engine route map
      var BlogMap = function () {};
      App.register('route-map:blog', BlogMap);

      App.Router.map(function () {
        this.mount('blog');
      });
    });

    assert.strictEqual(_emberViews.jQuery('#qunit-fixture').children().length, 0, 'there are no elements in the fixture element');

    return _emberMetal.run(App, 'visit', '/blog', { shouldRender: false }).then(function (instance) {
      assert.ok(instance instanceof _emberApplicationSystemApplicationInstance.default, 'promise is resolved with an ApplicationInstance');
      assert.strictEqual(_emberViews.jQuery('#qunit-fixture').children().length, 0, 'there are still no elements in the fixture element after visit');
    });
  });

  QUnit.test('visit() on engine resolves engine component', function (assert) {
    assert.expect(2);

    _emberMetal.run(function () {
      createApplication();

      // Register engine
      var BlogEngine = _emberApplicationSystemEngine.default.extend({
        init: function () {
          for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
          }

          this._super.apply(this, args);
          this.register('template:application', _emberTemplateCompiler.compile('{{cache-money}}'));
          this.register('template:components/cache-money', _emberTemplateCompiler.compile('\n          <p>Dis cache money</p>\n        '));
          this.register('component:cache-money', _emberGlimmer.Component.extend({}));
        }
      });
      App.register('engine:blog', BlogEngine);

      // Register engine route map
      var BlogMap = function () {};
      App.register('route-map:blog', BlogMap);

      App.Router.map(function () {
        this.mount('blog');
      });
    });

    assert.strictEqual(_emberViews.jQuery('#qunit-fixture').children().length, 0, 'there are no elements in the fixture element');

    return _emberMetal.run(App, 'visit', '/blog', { shouldRender: true }).then(function (instance) {
      assert.strictEqual(_emberViews.jQuery('#qunit-fixture').find('p').text(), 'Dis cache money', 'Engine component is resolved');
    });
  });

  QUnit.test('visit() on engine resolves engine helper', function (assert) {
    assert.expect(2);

    _emberMetal.run(function () {
      createApplication();

      // Register engine
      var BlogEngine = _emberApplicationSystemEngine.default.extend({
        init: function () {
          for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
            args[_key2] = arguments[_key2];
          }

          this._super.apply(this, args);
          this.register('template:application', _emberTemplateCompiler.compile('{{swag}}'));
          this.register('helper:swag', _emberGlimmer.helper(function () {
            return 'turnt up';
          }));
        }
      });
      App.register('engine:blog', BlogEngine);

      // Register engine route map
      var BlogMap = function () {};
      App.register('route-map:blog', BlogMap);

      App.Router.map(function () {
        this.mount('blog');
      });
    });

    assert.strictEqual(_emberViews.jQuery('#qunit-fixture').children().length, 0, 'there are no elements in the fixture element');

    return _emberMetal.run(App, 'visit', '/blog', { shouldRender: true }).then(function (instance) {
      assert.strictEqual(_emberViews.jQuery('#qunit-fixture').text(), 'turnt up', 'Engine component is resolved');
    });
  });

  QUnit.module('Ember.Application - visit() Integration Tests', {
    teardown: function () {
      if (instances) {
        _emberMetal.run(instances, 'forEach', function (i) {
          return i.destroy();
        });
        instances = [];
      }

      if (App) {
        _emberMetal.run(App, 'destroy');
        App = null;
      }
    }
  });

  QUnit.test('Ember Islands-style setup', function (assert) {
    var xFooInitCalled = false;
    var xFooDidInsertElementCalled = false;

    var xBarInitCalled = false;
    var xBarDidInsertElementCalled = false;

    _emberMetal.run(function () {
      createApplication(true);

      App.Router.map(function () {
        this.route('show', { path: '/:component_name' });
      });

      App.register('route:show', _emberRouting.Route.extend({
        queryParams: {
          data: { refreshModel: true }
        },

        model: function (params) {
          return {
            componentName: params.component_name,
            componentData: params.data ? JSON.parse(params.data) : undefined
          };
        }
      }));

      var Counter = _emberRuntime.Object.extend({
        value: 0,

        increment: function () {
          this.incrementProperty('value');
        }
      });

      App.register('service:isolated-counter', Counter);
      App.register('service:shared-counter', Counter.create(), { instantiate: false });

      App.register('template:show', _emberTemplateCompiler.compile('{{component model.componentName model=model.componentData}}'));

      App.register('template:components/x-foo', _emberTemplateCompiler.compile('\n      <h1>X-Foo</h1>\n      <p>Hello {{model.name}}, I have been clicked {{isolatedCounter.value}} times ({{sharedCounter.value}} times combined)!</p>\n    '));

      App.register('component:x-foo', _emberGlimmer.Component.extend({
        tagName: 'x-foo',

        isolatedCounter: _emberRuntime.inject.service(),
        sharedCounter: _emberRuntime.inject.service(),

        init: function () {
          this._super();
          xFooInitCalled = true;
        },

        didInsertElement: function () {
          xFooDidInsertElementCalled = true;
        },

        click: function () {
          this.get('isolatedCounter').increment();
          this.get('sharedCounter').increment();
        }
      }));

      App.register('template:components/x-bar', _emberTemplateCompiler.compile('\n      <h1>X-Bar</h1>\n      <button {{action "incrementCounter"}}>Join {{counter.value}} others in clicking me!</button>\n    '));

      App.register('component:x-bar', _emberGlimmer.Component.extend({
        counter: _emberRuntime.inject.service('shared-counter'),

        actions: {
          incrementCounter: function () {
            this.get('counter').increment();
          }
        },

        init: function () {
          this._super();
          xBarInitCalled = true;
        },

        didInsertElement: function () {
          xBarDidInsertElementCalled = true;
        }
      }));
    });

    var $foo = _emberViews.jQuery('<div />').appendTo('#qunit-fixture');
    var $bar = _emberViews.jQuery('<div />').appendTo('#qunit-fixture');

    var data = encodeURIComponent(JSON.stringify({ name: 'Godfrey' }));

    return _emberRuntime.RSVP.all([_emberMetal.run(App, 'visit', '/x-foo?data=' + data, { rootElement: $foo[0] }), _emberMetal.run(App, 'visit', '/x-bar', { rootElement: $bar[0] })]).then(function () {
      assert.ok(xFooInitCalled);
      assert.ok(xFooDidInsertElementCalled);

      assert.ok(xBarInitCalled);
      assert.ok(xBarDidInsertElementCalled);

      assert.equal($foo.find('h1').text(), 'X-Foo');
      assert.equal($foo.find('p').text(), 'Hello Godfrey, I have been clicked 0 times (0 times combined)!');
      assert.ok($foo.text().indexOf('X-Bar') === -1);

      assert.equal($bar.find('h1').text(), 'X-Bar');
      assert.equal($bar.find('button').text(), 'Join 0 others in clicking me!');
      assert.ok($bar.text().indexOf('X-Foo') === -1);

      _emberMetal.run(function () {
        return $foo.find('x-foo').click();
      });

      assert.equal($foo.find('p').text(), 'Hello Godfrey, I have been clicked 1 times (1 times combined)!');
      assert.equal($bar.find('button').text(), 'Join 1 others in clicking me!');

      _emberMetal.run(function () {
        $bar.find('button').click();
        $bar.find('button').click();
      });

      assert.equal($foo.find('p').text(), 'Hello Godfrey, I have been clicked 1 times (3 times combined)!');
      assert.equal($bar.find('button').text(), 'Join 3 others in clicking me!');
    });
  });

  QUnit.skip('Test setup', function (assert) {});

  QUnit.skip('iframe setup', function (assert) {});
});
enifed('ember-application/tests/test-helpers/registry-check', ['exports'], function (exports) {
  'use strict';

  exports.verifyRegistration = verifyRegistration;
  exports.verifyInjection = verifyInjection;

  function verifyRegistration(owner, fullName) {
    ok(owner.resolveRegistration(fullName), 'has registration: ' + fullName);
  }

  function verifyInjection(owner, fullName, property, injectionName) {
    var registry = owner.__registry__;
    var injections = undefined;

    if (fullName.indexOf(':') === -1) {
      injections = registry.getTypeInjections(fullName);
    } else {
      injections = registry.getInjections(registry.normalize(fullName));
    }

    var normalizedName = registry.normalize(injectionName);
    var hasInjection = false;
    var injection = undefined;

    for (var i = 0, l = injections.length; i < l; i++) {
      injection = injections[i];
      if (injection.property === property && injection.fullName === normalizedName) {
        hasInjection = true;
        break;
      }
    }

    ok(hasInjection, 'has injection: ' + fullName + '.' + property + ' = ' + injectionName);
  }
});
enifed('ember-debug/tests/handlers-test', ['exports', 'ember-debug/handlers'], function (exports, _emberDebugHandlers) {
  'use strict';

  QUnit.module('ember-debug/handlers', {
    teardown: function () {
      delete _emberDebugHandlers.HANDLERS.blarz;
    }
  });

  QUnit.test('calls handler on `invoke` when `falsey`', function (assert) {
    assert.expect(2);

    function handler(message) {
      assert.ok(true, 'called handler');
      assert.equal(message, 'Foo bar');
    }

    _emberDebugHandlers.registerHandler('blarz', handler);

    _emberDebugHandlers.invoke('blarz', 'Foo bar', false);
  });

  QUnit.test('does not call handler on `invoke` when `truthy`', function (assert) {
    assert.expect(0);

    function handler() {
      assert.ok(false, 'called handler');
    }

    _emberDebugHandlers.registerHandler('blarz', handler);

    _emberDebugHandlers.invoke('blarz', 'Foo bar', true);
  });

  QUnit.test('calling `invoke` without handlers does not throw an error', function (assert) {
    assert.expect(0);

    _emberDebugHandlers.invoke('blarz', 'Foo bar', false);
  });

  QUnit.test('invoking `next` argument calls the next handler', function (assert) {
    assert.expect(2);

    function handler1(message, options, next) {
      assert.ok(true, 'called handler1');
    }

    function handler2(message, options, next) {
      assert.ok(true, 'called handler2');
      next(message, options);
    }

    _emberDebugHandlers.registerHandler('blarz', handler1);
    _emberDebugHandlers.registerHandler('blarz', handler2);

    _emberDebugHandlers.invoke('blarz', 'Foo', false);
  });

  QUnit.test('invoking `next` when no other handlers exists does not error', function (assert) {
    assert.expect(1);

    function handler(message, options, next) {
      assert.ok(true, 'called handler1');

      next(message, options);
    }

    _emberDebugHandlers.registerHandler('blarz', handler);

    _emberDebugHandlers.invoke('blarz', 'Foo', false);
  });

  QUnit.test('handlers are called in the proper order', function (assert) {
    assert.expect(11);

    var expectedMessage = 'This is the message';
    var expectedOptions = { id: 'foo-bar' };
    var expected = ['first', 'second', 'third', 'fourth', 'fifth'];
    var actualCalls = [];

    function generateHandler(item) {
      return function (message, options, next) {
        assert.equal(message, expectedMessage, 'message supplied to ' + item + ' handler is correct');
        assert.equal(options, expectedOptions, 'options supplied to ' + item + ' handler is correct');

        actualCalls.push(item);

        next(message, options);
      };
    }

    expected.forEach(function (item) {
      return _emberDebugHandlers.registerHandler('blarz', generateHandler(item));
    });

    _emberDebugHandlers.invoke('blarz', expectedMessage, false, expectedOptions);

    assert.deepEqual(actualCalls, expected.reverse(), 'handlers were called in proper order');
  });

  QUnit.test('not invoking `next` prevents further handlers from being called', function (assert) {
    assert.expect(1);

    function handler1(message, options, next) {
      assert.ok(false, 'called handler1');
    }

    function handler2(message, options, next) {
      assert.ok(true, 'called handler2');
    }

    _emberDebugHandlers.registerHandler('blarz', handler1);
    _emberDebugHandlers.registerHandler('blarz', handler2);

    _emberDebugHandlers.invoke('blarz', 'Foo', false);
  });

  QUnit.test('handlers can call `next` with custom message and/or options', function (assert) {
    assert.expect(4);

    var initialMessage = 'initial message';
    var initialOptions = { id: 'initial-options' };

    var handler2Message = 'Handler2 Message';
    var handler2Options = { id: 'handler-2' };

    function handler1(message, options, next) {
      assert.equal(message, handler2Message, 'handler2 message provided to handler1');
      assert.equal(options, handler2Options, 'handler2 options provided to handler1');
    }

    function handler2(message, options, next) {
      assert.equal(message, initialMessage, 'initial message provided to handler2');
      assert.equal(options, initialOptions, 'initial options proivided to handler2');

      next(handler2Message, handler2Options);
    }

    _emberDebugHandlers.registerHandler('blarz', handler1);
    _emberDebugHandlers.registerHandler('blarz', handler2);

    _emberDebugHandlers.invoke('blarz', initialMessage, false, initialOptions);
  });
});
enifed('ember-debug/tests/main_test', ['exports', 'ember-environment', 'ember-runtime', 'ember-debug/handlers', 'ember-debug/deprecate', 'ember-debug/warn', 'ember-metal'], function (exports, _emberEnvironment, _emberRuntime, _emberDebugHandlers, _emberDebugDeprecate, _emberDebugWarn, _emberMetal) {
  'use strict';

  var originalEnvValue = undefined;
  var originalDeprecateHandler = undefined;

  QUnit.module('ember-debug', {
    setup: function () {
      originalEnvValue = _emberEnvironment.ENV.RAISE_ON_DEPRECATION;
      originalDeprecateHandler = _emberDebugHandlers.HANDLERS.deprecate;

      _emberEnvironment.ENV.RAISE_ON_DEPRECATION = true;
    },

    teardown: function () {
      _emberDebugHandlers.HANDLERS.deprecate = originalDeprecateHandler;

      _emberEnvironment.ENV.RAISE_ON_DEPRECATION = originalEnvValue;
    }
  });

  QUnit.test('Ember.deprecate does not throw if RAISE_ON_DEPRECATION is false', function (assert) {
    assert.expect(1);

    _emberEnvironment.ENV.RAISE_ON_DEPRECATION = false;

    try {
      assert.ok(true, 'Ember.deprecate did not throw');
    } catch (e) {
      assert.ok(false, 'Expected deprecate not to throw but it did: ' + e.message);
    }
  });

  QUnit.test('Ember.deprecate resets deprecation level to RAISE if ENV.RAISE_ON_DEPRECATION is set', function (assert) {
    assert.expect(2);

    _emberEnvironment.ENV.RAISE_ON_DEPRECATION = false;

    try {
      assert.ok(true, 'Ember.deprecate did not throw');
    } catch (e) {
      assert.ok(false, 'Expected deprecate not to throw but it did: ' + e.message);
    }

    _emberEnvironment.ENV.RAISE_ON_DEPRECATION = true;

    assert.throws(function () {}, /Should throw/);
  });

  QUnit.test('When ENV.RAISE_ON_DEPRECATION is true, it is still possible to silence a deprecation by id', function (assert) {
    assert.expect(3);

    _emberEnvironment.ENV.RAISE_ON_DEPRECATION = true;
    _emberDebugDeprecate.registerHandler(function (message, options, next) {
      if (!options || options.id !== 'my-deprecation') {
        next.apply(undefined, arguments);
      }
    });

    try {
      assert.ok(true, 'Did not throw when level is set by id');
    } catch (e) {
      assert.ok(false, 'Expected deprecate not to throw but it did: ' + e.message);
    }

    assert.throws(function () {}, /Should throw with no matching id/);

    assert.throws(function () {}, /Should throw with non-matching id/);
  });

  QUnit.test('Ember.deprecate throws deprecation if second argument is falsy', function () {
    expect(3);
  });

  QUnit.test('Ember.deprecate does not invoke a function as the second argument', function () {
    expect(1);

    ok(true, 'deprecations were not thrown');
  });

  QUnit.test('Ember.deprecate does not throw deprecations if second argument is truthy', function () {
    expect(1);

    ok(true, 'deprecations were not thrown');
  });

  QUnit.test('Ember.assert throws if second argument is falsy', function () {
    expect(3);
  });

  QUnit.test('Ember.assert does not throw if second argument is a function', function (assert) {
    assert.expect(1);

    ok(true, 'assertions were not thrown');
  });

  QUnit.test('Ember.assert does not throw if second argument is truthy', function () {
    expect(1);

    ok(true, 'assertions were not thrown');
  });

  QUnit.test('Ember.assert does not throw if second argument is an object', function () {
    expect(1);
    var Igor = _emberRuntime.Object.extend();

    ok(true, 'assertions were not thrown');
  });

  QUnit.test('Ember.deprecate does not throw a deprecation at log and silence levels', function () {
    expect(4);
    var id = 'ABC';
    var until = 'forever';
    var shouldThrow = false;

    _emberDebugDeprecate.registerHandler(function (message, options, next) {
      if (options && options.id === id) {
        if (shouldThrow) {
          throw new Error(message);
        }
      }
    });

    try {
      ok(true, 'Deprecation did not throw');
    } catch (e) {
      ok(false, 'Deprecation was thrown despite being added to blacklist');
    }

    try {
      ok(true, 'Deprecation did not throw');
    } catch (e) {
      ok(false, 'Deprecation was thrown despite being added to blacklist');
    }

    shouldThrow = true;

    throws(function () {});

    throws(function () {});
  });

  QUnit.test('Ember.deprecate without options triggers a deprecation', function (assert) {
    assert.expect(4);

    _emberDebugDeprecate.registerHandler(function (message) {
      if (message === _emberDebugDeprecate.missingOptionsDeprecation) {
        assert.ok(true, 'proper deprecation is triggered when options is missing');
      } else if (message === 'foo') {
        assert.ok(true, 'original deprecation is still triggered');
      }
    });
  });

  QUnit.test('Ember.deprecate without options.id triggers a deprecation', function (assert) {
    assert.expect(2);

    _emberDebugDeprecate.registerHandler(function (message) {
      if (message === _emberDebugDeprecate.missingOptionsIdDeprecation) {
        assert.ok(true, 'proper deprecation is triggered when options.id is missing');
      } else if (message === 'foo') {
        assert.ok(true, 'original deprecation is still triggered');
      }
    });
  });

  QUnit.test('Ember.deprecate without options.until triggers a deprecation', function (assert) {
    assert.expect(2);

    _emberDebugDeprecate.registerHandler(function (message) {
      if (message === _emberDebugDeprecate.missingOptionsUntilDeprecation) {
        assert.ok(true, 'proper deprecation is triggered when options.until is missing');
      } else if (message === 'foo') {
        assert.ok(true, 'original deprecation is still triggered');
      }
    });
  });

  QUnit.test('warn without options triggers a deprecation', function (assert) {
    assert.expect(2);

    _emberDebugDeprecate.registerHandler(function (message) {
      assert.equal(message, _emberDebugWarn.missingOptionsDeprecation, 'deprecation is triggered when options is missing');
    });

    _emberDebugWarn.registerHandler(function (message) {
      assert.equal(message, 'foo', 'original warning is triggered');
    });
  });

  QUnit.test('warn without options.id triggers a deprecation', function (assert) {
    assert.expect(2);

    _emberDebugDeprecate.registerHandler(function (message) {
      assert.equal(message, _emberDebugWarn.missingOptionsIdDeprecation, 'deprecation is triggered when options is missing');
    });

    _emberDebugWarn.registerHandler(function (message) {
      assert.equal(message, 'foo', 'original warning is triggered');
    });
  });
});
enifed('ember-debug/tests/warn_if_using_stripped_feature_flags_test', ['exports', 'ember-environment', 'ember-metal', 'ember-debug/index'], function (exports, _emberEnvironment, _emberMetal, _emberDebugIndex) {
  'use strict';

  var oldWarn = undefined,
      oldRunInDebug = undefined,
      origEnvFeatures = undefined,
      origEnableOptional = undefined,
      features = undefined,
      knownFeatures = undefined;

  function confirmWarns(expectedMsg) {
    var featuresWereStripped = true;

    _emberMetal.setDebugFunction('warn', function (msg, test) {
      if (!test) {
        equal(msg, expectedMsg);
      }
    });

    _emberMetal.setDebugFunction('runInDebug', function (func) {
      func();
    });

    // Should trigger our 1 warning
    _emberDebugIndex._warnIfUsingStrippedFeatureFlags(features, knownFeatures, featuresWereStripped);

    // Shouldn't trigger any warnings now that we're "in canary"
    featuresWereStripped = false;
    _emberDebugIndex._warnIfUsingStrippedFeatureFlags(features, knownFeatures, featuresWereStripped);
  }

  QUnit.module('ember-debug - _warnIfUsingStrippedFeatureFlags', {
    setup: function () {
      oldWarn = _emberMetal.getDebugFunction('warn');
      oldRunInDebug = _emberMetal.getDebugFunction('runInDebug');
      origEnvFeatures = _emberEnvironment.ENV.FEATURES;
      origEnableOptional = _emberEnvironment.ENV.ENABLE_OPTIONAL_FEATURES;

      knownFeatures = {
        'fred': null,
        'barney': null,
        'wilma': null
      };
    },

    teardown: function () {
      _emberMetal.setDebugFunction('warn', oldWarn);
      _emberMetal.setDebugFunction('runInDebug', oldRunInDebug);
      _emberEnvironment.ENV.FEATURES = origEnvFeatures;
      _emberEnvironment.ENV.ENABLE_OPTIONAL_FEATURES = origEnableOptional;
    }
  });

  QUnit.test('Setting Ember.ENV.ENABLE_OPTIONAL_FEATURES truthy in non-canary, debug build causes a warning', function () {
    expect(1);

    _emberEnvironment.ENV.ENABLE_OPTIONAL_FEATURES = true;
    features = {};

    confirmWarns('Ember.ENV.ENABLE_OPTIONAL_FEATURES is only available in canary builds.');
  });

  QUnit.test('Enabling a known FEATURE flag in non-canary, debug build causes a warning', function () {
    expect(1);

    _emberEnvironment.ENV.ENABLE_OPTIONAL_FEATURES = false;
    features = {
      'fred': true,
      'barney': false,
      'wilma': null
    };

    confirmWarns('FEATURE["fred"] is set as enabled, but FEATURE flags are only available in canary builds.');
  });

  QUnit.test('Enabling an unknown FEATURE flag in non-canary debug build does not cause a warning', function () {
    expect(0);

    _emberEnvironment.ENV.ENABLE_OPTIONAL_FEATURES = false;
    features = {
      'some-ember-data-feature-flag': true
    };

    confirmWarns('FEATURE["fred"] is set as enabled, but FEATURE flags are only available in canary builds.');
  });

  QUnit.test('`ENV.FEATURES` being undefined does not cause an error', function () {
    expect(0);

    _emberEnvironment.ENV.ENABLE_OPTIONAL_FEATURES = false;
    features = undefined;

    confirmWarns();
  });
});
enifed('ember-dev/test-helper/assertion', ['exports', 'ember-dev/test-helper/utils'], function (exports, _emberDevTestHelperUtils) {
  /* globals QUnit */

  'use strict';

  exports.default = AssertionAssert;

  var BREAK = {};

  /**
    This assertion class is used to test assertions made using Ember.assert.
    It injects two helpers onto `window`:
  
    - expectAssertion(func: Function, [expectedMessage: String | RegExp])
  
    This function calls `func` and asserts that `Ember.assert` is invoked during
    the execution. Moreover, it takes a String or a RegExp as a second optional
    argument that can be used to test if a specific assertion message was
    generated.
  
    - ignoreAssertion(func: Function)
  
    This function calls `func` and disables `Ember.assert` during the execution.
    In particular, this prevents `Ember.assert` from throw errors that would
    disrupt the control flow.
  */

  function AssertionAssert(env) {
    this.env = env;
  }

  AssertionAssert.prototype = {
    reset: function () {},
    assert: function () {},

    inject: function () {
      var _this = this;

      var expectAssertion = function (func, expectedMessage) {
        if (_this.env.runningProdBuild) {
          QUnit.ok(true, 'Assertions disabled in production builds.');
          return;
        }

        var sawCall = undefined;
        var actualMessage = undefined;

        // The try-catch statement is used to "exit" `func` as soon as
        // the first useful assertion has been produced.
        try {
          _emberDevTestHelperUtils.callWithStub(_this.env, 'assert', func, function (message, test) {
            sawCall = true;
            if (_emberDevTestHelperUtils.checkTest(test)) {
              return;
            }
            actualMessage = message;
            throw BREAK;
          });
        } catch (e) {
          if (e !== BREAK) {
            throw e;
          }
        }

        assert(sawCall, actualMessage, expectedMessage);
      };

      var ignoreAssertion = function (func) {
        _emberDevTestHelperUtils.callWithStub(_this.env, 'assert', func);
      };

      window.expectAssertion = expectAssertion;
      window.ignoreAssertion = ignoreAssertion;
    },

    restore: function () {
      window.expectAssertion = null;
      window.ignoreAssertion = null;
    }
  };

  function assert(sawCall, actualMessage, expectedMessage) {
    // Run assertions in an order that is useful when debugging a test failure.
    if (!sawCall) {
      QUnit.ok(false, 'Expected Ember.assert to be called (Not called with any value).');
    } else if (!actualMessage) {
      QUnit.ok(false, 'Expected a failing Ember.assert (Ember.assert called, but without a failing test).');
    } else {
      if (expectedMessage) {
        if (expectedMessage instanceof RegExp) {
          QUnit.ok(expectedMessage.test(actualMessage), 'Expected failing Ember.assert: \'' + expectedMessage + '\', but got \'' + actualMessage + '\'.');
        } else {
          QUnit.equal(actualMessage, expectedMessage, 'Expected failing Ember.assert: \'' + expectedMessage + '\', but got \'' + actualMessage + '\'.');
        }
      } else {
        // Positive assertion that assert was called
        QUnit.ok(true, 'Expected a failing Ember.assert.');
      }
    }
  }
});
enifed('ember-dev/test-helper/debug', ['exports', 'ember-dev/test-helper/method-call-tracker'], function (exports, _emberDevTestHelperMethodCallTracker) {
  'use strict';

  var DebugAssert = (function () {
    function DebugAssert(methodName, env) {
      this.methodName = methodName;
      this.env = env;
    }

    DebugAssert.prototype.inject = function inject() {};

    DebugAssert.prototype.restore = function restore() {
      this.reset();
    };

    DebugAssert.prototype.reset = function reset() {
      if (this.tracker) {
        this.tracker.restoreMethod();
      }

      this.tracker = null;
    };

    DebugAssert.prototype.assert = function assert() {
      if (this.tracker) {
        this.tracker.assert();
      }
    };

    // Run an expectation callback within the context of a new tracker, optionally
    // accepting a function to run, which asserts immediately

    DebugAssert.prototype.runExpectation = function runExpectation(func, callback) {
      var originalTracker = undefined;

      // When helpers are passed a callback, they get a new tracker context
      if (func) {
        originalTracker = this.tracker;
        this.tracker = null;
      }

      if (!this.tracker) {
        this.tracker = new _emberDevTestHelperMethodCallTracker.default(this.env, this.methodName);
      }

      // Yield to caller with tracker instance
      callback(this.tracker);

      // Once the given callback is invoked, the pending assertions should be
      // flushed immediately
      if (func) {
        func();
        this.assert();
        this.reset();

        this.tracker = originalTracker;
      }
    };

    return DebugAssert;
  })();

  exports.default = DebugAssert;
});
enifed('ember-dev/test-helper/deprecation', ['exports', 'ember-dev/test-helper/debug', 'ember-dev/test-helper/utils'], function (exports, _emberDevTestHelperDebug, _emberDevTestHelperUtils) {
  'use strict';

  var DeprecationAssert = (function (_DebugAssert) {
    babelHelpers.inherits(DeprecationAssert, _DebugAssert);

    function DeprecationAssert(env) {
      _DebugAssert.call(this, 'deprecate', env);
    }

    DeprecationAssert.prototype.inject = function inject() {
      var _this = this;

      // Expects no deprecation to happen within a function, or if no function is
      // passed, from the time of calling until the end of the test.
      //
      // expectNoDeprecation(function() {
      //   fancyNewThing();
      // });
      //
      // expectNoDeprecation();
      // Ember.deprecate("Old And Busted");
      //
      var expectNoDeprecation = function (func) {
        if (typeof func !== 'function') {
          func = null;
        }

        _this.runExpectation(func, function (tracker) {
          if (tracker.isExpectingCalls()) {
            throw new Error("expectNoDeprecation was called after expectDeprecation was called!");
          }

          tracker.expectNoCalls();
        });
      };

      // Expect a deprecation to happen within a function, or if no function
      // is pass, from the time of calling until the end of the test. Can be called
      // multiple times to assert deprecations with different specific messages
      // were fired.
      //
      // expectDeprecation(function() {
      //   Ember.deprecate("Old And Busted");
      // }, /* optionalStringOrRegex */);
      //
      // expectDeprecation(/* optionalStringOrRegex */);
      // Ember.deprecate("Old And Busted");
      //
      var expectDeprecation = function (func, message) {
        if (typeof func !== 'function') {
          message = func;
          func = null;
        }

        _this.runExpectation(func, function (tracker) {
          if (tracker.isExpectingNoCalls()) {
            throw new Error("expectDeprecation was called after expectNoDeprecation was called!");
          }

          tracker.expectCall(message);
        });
      };

      var ignoreDeprecation = function (func) {
        _emberDevTestHelperUtils.callWithStub(_this.env, 'deprecate', func);
      };

      window.expectNoDeprecation = expectNoDeprecation;
      window.expectDeprecation = expectDeprecation;
      window.ignoreDeprecation = ignoreDeprecation;
    };

    DeprecationAssert.prototype.restore = function restore() {
      _DebugAssert.prototype.restore.call(this);
      window.expectDeprecation = null;
      window.expectNoDeprecation = null;
      window.ignoreDeprecation = null;
    };

    return DeprecationAssert;
  })(_emberDevTestHelperDebug.default);

  exports.default = DeprecationAssert;
});
enifed("ember-dev/test-helper/index", ["exports", "ember-dev/test-helper/deprecation", "ember-dev/test-helper/warning", "ember-dev/test-helper/remaining-view", "ember-dev/test-helper/remaining-template", "ember-dev/test-helper/assertion", "ember-dev/test-helper/run-loop", "ember-dev/test-helper/utils"], function (exports, _emberDevTestHelperDeprecation, _emberDevTestHelperWarning, _emberDevTestHelperRemainingView, _emberDevTestHelperRemainingTemplate, _emberDevTestHelperAssertion, _emberDevTestHelperRunLoop, _emberDevTestHelperUtils) {
  "use strict";

  var EmberDevTestHelperAssert = _emberDevTestHelperUtils.buildCompositeAssert([_emberDevTestHelperDeprecation.default, _emberDevTestHelperWarning.default, _emberDevTestHelperRemainingView.default, _emberDevTestHelperRemainingTemplate.default, _emberDevTestHelperAssertion.default, _emberDevTestHelperRunLoop.default]);

  exports.default = EmberDevTestHelperAssert;
});
enifed('ember-dev/test-helper/method-call-tracker', ['exports', 'ember-dev/test-helper/utils'], function (exports, _emberDevTestHelperUtils) {
  /* globals QUnit */

  'use strict';

  var MethodCallTracker = function (env, methodName) {
    this._env = env;
    this._methodName = methodName;
    this._isExpectingNoCalls = false;
    this._expecteds = [];
    this._actuals = [];
  };

  MethodCallTracker.prototype = {
    stubMethod: function () {
      var _this = this;

      if (this._originalMethod) {
        // Method is already stubbed
        return;
      }

      var env = this._env;
      var methodName = this._methodName;

      this._originalMethod = env.getDebugFunction(methodName);

      env.setDebugFunction(methodName, function (message, test) {
        var resultOfTest = _emberDevTestHelperUtils.checkTest(test);

        _this._actuals.push([message, resultOfTest]);
      });
    },

    restoreMethod: function () {
      if (this._originalMethod) {
        this._env.setDebugFunction(this._methodName, this._originalMethod);
      }
    },

    expectCall: function (message) {
      this.stubMethod();
      this._expecteds.push(message || /.*/);
    },

    expectNoCalls: function () {
      this.stubMethod();
      this._isExpectingNoCalls = true;
    },

    isExpectingNoCalls: function () {
      return this._isExpectingNoCalls;
    },

    isExpectingCalls: function () {
      return !this._isExpectingNoCalls && this._expecteds.length;
    },

    assert: function () {
      var env = this._env;
      var methodName = this._methodName;
      var isExpectingNoCalls = this._isExpectingNoCalls;
      var expecteds = this._expecteds;
      var actuals = this._actuals;
      var o = undefined,
          i = undefined;

      if (!isExpectingNoCalls && expecteds.length === 0 && actuals.length === 0) {
        return;
      }

      if (env.runningProdBuild) {
        QUnit.ok(true, 'calls to Ember.' + methodName + ' disabled in production builds.');
        return;
      }

      if (isExpectingNoCalls) {
        var actualMessages = [];
        for (i = 0; i < actuals.length; i++) {
          if (!actuals[i][1]) {
            actualMessages.push(actuals[i][0]);
          }
        }
        QUnit.ok(actualMessages.length === 0, 'Expected no Ember.' + methodName + ' calls, got ' + actuals.length + ': ' + actualMessages.join(', '));
        return;
      }

      var expected = undefined,
          actual = undefined,
          match = undefined;

      for (o = 0; o < expecteds.length; o++) {
        expected = expecteds[o];
        for (i = 0; i < actuals.length; i++) {
          actual = actuals[i];
          if (!actual[1]) {
            if (expected instanceof RegExp) {
              if (expected.test(actual[0])) {
                match = actual;
                break;
              }
            } else {
              if (expected === actual[0]) {
                match = actual;
                break;
              }
            }
          }
        }

        if (!actual) {
          QUnit.ok(false, 'Recieved no Ember.' + methodName + ' calls at all, expecting: ' + expected);
        } else if (match && !match[1]) {
          QUnit.ok(true, 'Recieved failing Ember.' + methodName + ' call with message: ' + match[0]);
        } else if (match && match[1]) {
          QUnit.ok(false, 'Expected failing Ember.' + methodName + ' call, got succeeding with message: ' + match[0]);
        } else if (actual[1]) {
          QUnit.ok(false, 'Did not receive failing Ember.' + methodName + ' call matching \'' + expected + '\', last was success with \'' + actual[0] + '\'');
        } else if (!actual[1]) {
          QUnit.ok(false, 'Did not receive failing Ember.' + methodName + ' call matching \'' + expected + '\', last was failure with \'' + actual[0] + '\'');
        }
      }
    }
  };

  exports.default = MethodCallTracker;
});
enifed("ember-dev/test-helper/remaining-template", ["exports"], function (exports) {
  /* globals QUnit */

  "use strict";

  var RemainingTemplateAssert = function (env) {
    this.env = env;
  };

  RemainingTemplateAssert.prototype = {
    reset: function () {},
    inject: function () {},
    assert: function () {
      if (this.env.Ember && this.env.Ember.TEMPLATES) {
        var templateNames = [],
            name;
        for (name in this.env.Ember.TEMPLATES) {
          if (this.env.Ember.TEMPLATES[name] != null) {
            templateNames.push(name);
          }
        }

        if (templateNames.length > 0) {
          QUnit.deepEqual(templateNames, [], "Ember.TEMPLATES should be empty");
          this.env.Ember.TEMPLATES = {};
        }
      }
    },
    restore: function () {}
  };

  exports.default = RemainingTemplateAssert;
});
enifed("ember-dev/test-helper/remaining-view", ["exports"], function (exports) {
  /* globals QUnit */

  "use strict";

  var RemainingViewAssert = function (env) {
    this.env = env;
  };

  RemainingViewAssert.prototype = {
    reset: function () {},
    inject: function () {},
    assert: function () {
      if (this.env.Ember && this.env.Ember.View) {
        var viewIds = [],
            id;
        for (id in this.env.Ember.View.views) {
          if (this.env.Ember.View.views[id] != null) {
            viewIds.push(id);
          }
        }

        if (viewIds.length > 0) {
          QUnit.deepEqual(viewIds, [], "Ember.View.views should be empty");
          this.env.Ember.View.views = [];
        }
      }
    },
    restore: function () {}
  };

  exports.default = RemainingViewAssert;
});
enifed("ember-dev/test-helper/run-loop", ["exports"], function (exports) {
  /* globals QUnit */

  "use strict";

  function RunLoopAssertion(env) {
    this.env = env;
  }

  RunLoopAssertion.prototype = {
    reset: function () {},
    inject: function () {},
    assert: function () {
      var run = this.env.Ember.run;

      if (run.currentRunLoop) {
        QUnit.ok(false, "Should not be in a run loop at end of test");
        while (run.currentRunLoop) {
          run.end();
        }
      }

      if (run.hasScheduledTimers()) {
        QUnit.ok(false, "Ember run should not have scheduled timers at end of test");
        run.cancelTimers();
      }
    },
    restore: function () {}
  };

  exports.default = RunLoopAssertion;
});
enifed("ember-dev/test-helper/setup-qunit", ["exports"], function (exports) {
  /* globals QUnit */

  "use strict";

  exports.default = setupQUnit;

  function setupQUnit(assertion, _qunitGlobal) {
    var qunitGlobal = QUnit;

    if (_qunitGlobal) {
      qunitGlobal = _qunitGlobal;
    }

    var originalModule = qunitGlobal.module;

    qunitGlobal.module = function (name, _options) {
      var options = _options || {};
      var originalSetup = options.setup || function () {};
      var originalTeardown = options.teardown || function () {};

      options.setup = function () {
        assertion.reset();
        assertion.inject();

        originalSetup.call(this);
      };

      options.teardown = function () {
        originalTeardown.call(this);

        assertion.assert();
        assertion.restore();
      };

      return originalModule(name, options);
    };
  }
});
enifed('ember-dev/test-helper/utils', ['exports'], function (exports) {
  'use strict';

  exports.buildCompositeAssert = buildCompositeAssert;
  exports.callWithStub = callWithStub;
  exports.checkTest = checkTest;
  function callForEach(prop, func) {
    return function () {
      for (var i = 0, l = this[prop].length; i < l; i++) {
        this[prop][i][func]();
      }
    };
  }

  function buildCompositeAssert(assertClasses) {
    function Composite(env) {
      this.asserts = assertClasses.map(function (Assert) {
        return new Assert(env);
      });
    }

    Composite.prototype = {
      reset: callForEach('asserts', 'reset'),
      inject: callForEach('asserts', 'inject'),
      assert: callForEach('asserts', 'assert'),
      restore: callForEach('asserts', 'restore')
    };

    return Composite;
  }

  function noop() {}

  function callWithStub(env, name, func) {
    var debugStub = arguments.length <= 3 || arguments[3] === undefined ? noop : arguments[3];

    var originalFunc = env.getDebugFunction(name);
    try {
      env.setDebugFunction(name, debugStub);
      func();
    } finally {
      env.setDebugFunction(name, originalFunc);
    }
  }

  function checkTest(test) {
    return typeof test === 'function' ? test() : test;
  }
});
enifed('ember-dev/test-helper/warning', ['exports', 'ember-dev/test-helper/debug', 'ember-dev/test-helper/utils'], function (exports, _emberDevTestHelperDebug, _emberDevTestHelperUtils) {
  'use strict';

  var WarningAssert = (function (_DebugAssert) {
    babelHelpers.inherits(WarningAssert, _DebugAssert);

    function WarningAssert(env) {
      _DebugAssert.call(this, 'warn', env);
    }

    WarningAssert.prototype.inject = function inject() {
      var _this = this;

      // Expects no warning to happen within a function, or if no function is
      // passed, from the time of calling until the end of the test.
      //
      // expectNoWarning(function() {
      //   fancyNewThing();
      // });
      //
      // expectNoWarning();
      // Ember.warn("Oh snap, didn't expect that");
      //
      var expectNoWarning = function (func) {
        if (typeof func !== 'function') {
          func = null;
        }

        _this.runExpectation(func, function (tracker) {
          if (tracker.isExpectingCalls()) {
            throw new Error("expectNoWarning was called after expectWarning was called!");
          }

          tracker.expectNoCalls();
        });
      };

      // Expect a warning to happen within a function, or if no function is
      // passed, from the time of calling until the end of the test. Can be called
      // multiple times to assert warnings with different specific messages
      // happened.
      //
      // expectWarning(function() {
      //   Ember.warn("Times they are a-changin'");
      // }, /* optionalStringOrRegex */);
      //
      // expectWarning(/* optionalStringOrRegex */);
      // Ember.warn("Times definitely be changin'");
      //
      var expectWarning = function (fn, message) {
        if (typeof fn !== 'function') {
          message = fn;
          fn = null;
        }

        _this.runExpectation(fn, function (tracker) {
          if (tracker.isExpectingNoCalls()) {
            throw new Error("expectWarning was called after expectNoWarning was called!");
          }

          tracker.expectCall(message);
        });
      };

      var ignoreWarning = function (func) {
        _emberDevTestHelperUtils.callWithStub(_this.env, 'warn', func);
      };

      window.expectNoWarning = expectNoWarning;
      window.expectWarning = expectWarning;
      window.ignoreWarning = ignoreWarning;
    };

    WarningAssert.prototype.restore = function restore() {
      _DebugAssert.prototype.restore.call(this);
      window.expectWarning = null;
      window.expectNoWarning = null;
      window.ignoreWarning = null;
    };

    return WarningAssert;
  })(_emberDevTestHelperDebug.default);

  exports.default = WarningAssert;
});
enifed('ember-extension-support/tests/container_debug_adapter_test', ['exports', 'ember-metal', 'ember-runtime', 'ember-extension-support/index', 'ember-application'], function (exports, _emberMetal, _emberRuntime, _emberExtensionSupportIndex, _emberApplication) {
  'use strict';

  var adapter = undefined,
      App = undefined,
      appInstance = undefined;

  function boot() {
    _emberMetal.run(App, 'advanceReadiness');
  }

  QUnit.module('Container Debug Adapter', {
    setup: function () {
      _emberMetal.run(function () {
        App = _emberApplication.Application.create(); // ES6TODO: this comes from the ember-application package NOT ember-runtime.
        App.toString = function () {
          return 'App';
        };
        App.deferReadiness();
      });
      boot();
      _emberMetal.run(function () {
        appInstance = App.__deprecatedInstance__;
        adapter = appInstance.lookup('container-debug-adapter:main');
      });
    },
    teardown: function () {
      _emberMetal.run(function () {
        adapter.destroy();
        appInstance.destroy();
        App.destroy();
        App = appInstance = adapter = null;
      });
    }
  });

  QUnit.test('the default ContainerDebugAdapter cannot catalog certain entries by type', function () {
    equal(adapter.canCatalogEntriesByType('model'), false, 'canCatalogEntriesByType should return false for model');
    equal(adapter.canCatalogEntriesByType('template'), false, 'canCatalogEntriesByType should return false for template');
  });

  QUnit.test('the default ContainerDebugAdapter can catalog typical entries by type', function () {
    equal(adapter.canCatalogEntriesByType('controller'), true, 'canCatalogEntriesByType should return true for controller');
    equal(adapter.canCatalogEntriesByType('route'), true, 'canCatalogEntriesByType should return true for route');
    equal(adapter.canCatalogEntriesByType('view'), true, 'canCatalogEntriesByType should return true for view');
  });

  QUnit.test('the default ContainerDebugAdapter catalogs controller entries', function () {
    App.PostController = _emberRuntime.Controller.extend();
    var controllerClasses = adapter.catalogEntriesByType('controller');

    equal(controllerClasses.length, 1, 'found 1 class');
    equal(controllerClasses[0], 'post', 'found the right class');
  });
});
// Must be required to export Ember.ContainerDebugAdapter.
enifed('ember-extension-support/tests/data_adapter_test', ['exports', 'ember-metal', 'ember-runtime', 'ember-extension-support/data_adapter', 'ember-application'], function (exports, _emberMetal, _emberRuntime, _emberExtensionSupportData_adapter, _emberApplication) {
  'use strict';

  var adapter = undefined,
      App = undefined;
  var Model = _emberRuntime.Object.extend();

  var DataAdapter = _emberExtensionSupportData_adapter.default.extend({
    detect: function (klass) {
      return klass !== Model && Model.detect(klass);
    }
  });

  QUnit.module('Data Adapter', {
    setup: function () {
      _emberMetal.run(function () {
        App = _emberApplication.Application.create();
        App.toString = function () {
          return 'App';
        };
        App.deferReadiness();
        App.register('data-adapter:main', DataAdapter);
      });
    },
    teardown: function () {
      _emberMetal.run(function () {
        adapter.destroy();
        App.destroy();
      });
    }
  });

  QUnit.test('Model types added with DefaultResolver', function () {
    App.Post = Model.extend();

    adapter = App.__container__.lookup('data-adapter:main');
    adapter.reopen({
      getRecords: function () {
        return _emberRuntime.A([1, 2, 3]);
      },
      columnsForType: function () {
        return [{ name: 'title', desc: 'Title' }];
      }
    });

    _emberMetal.run(App, 'advanceReadiness');

    function modelTypesAdded(types) {
      equal(types.length, 1);
      var postType = types[0];
      equal(postType.name, 'post', 'Correctly sets the name');
      equal(postType.count, 3, 'Correctly sets the record count');
      strictEqual(postType.object, App.Post, 'Correctly sets the object');
      deepEqual(postType.columns, [{ name: 'title', desc: 'Title' }], 'Correctly sets the columns');
    }

    _emberMetal.run(adapter, 'watchModelTypes', modelTypesAdded);
  });

  QUnit.test('getRecords gets a model name as second argument', function () {
    App.Post = Model.extend();

    adapter = App.__container__.lookup('data-adapter:main');
    adapter.reopen({
      getRecords: function (klass, name) {
        equal(name, 'post');
        return _emberRuntime.A();
      }
    });

    adapter.watchModelTypes(function () {});
  });

  QUnit.test('Model types added with custom container-debug-adapter', function () {
    var PostClass = Model.extend();
    var StubContainerDebugAdapter = _emberApplication.Resolver.extend({
      canCatalogEntriesByType: function (type) {
        return true;
      },
      catalogEntriesByType: function (type) {
        return [PostClass];
      }
    });
    App.register('container-debug-adapter:main', StubContainerDebugAdapter);

    adapter = App.__container__.lookup('data-adapter:main');
    adapter.reopen({
      getRecords: function () {
        return _emberRuntime.A([1, 2, 3]);
      },
      columnsForType: function () {
        return [{ name: 'title', desc: 'Title' }];
      }
    });

    _emberMetal.run(App, 'advanceReadiness');

    function modelTypesAdded(types) {
      equal(types.length, 1);
      var postType = types[0];

      equal(postType.name, PostClass.toString(), 'Correctly sets the name');
      equal(postType.count, 3, 'Correctly sets the record count');
      strictEqual(postType.object, PostClass, 'Correctly sets the object');
      deepEqual(postType.columns, [{ name: 'title', desc: 'Title' }], 'Correctly sets the columns');
    }

    _emberMetal.run(adapter, 'watchModelTypes', modelTypesAdded);
  });

  QUnit.test('Model Types Updated', function () {
    App.Post = Model.extend();

    adapter = App.__container__.lookup('data-adapter:main');
    var records = _emberRuntime.A([1, 2, 3]);
    adapter.reopen({
      getRecords: function () {
        return records;
      }
    });

    _emberMetal.run(App, 'advanceReadiness');

    function modelTypesAdded() {
      _emberMetal.run(function () {
        records.pushObject(4);
      });
    }

    function modelTypesUpdated(types) {
      var postType = types[0];
      equal(postType.count, 4, 'Correctly updates the count');
    }

    _emberMetal.run(adapter, 'watchModelTypes', modelTypesAdded, modelTypesUpdated);
  });

  QUnit.test('Records Added', function () {
    expect(8);
    var countAdded = 1;

    App.Post = Model.extend();

    var post = App.Post.create();
    var recordList = _emberRuntime.A([post]);

    adapter = App.__container__.lookup('data-adapter:main');
    adapter.reopen({
      getRecords: function () {
        return recordList;
      },
      getRecordColor: function () {
        return 'blue';
      },
      getRecordColumnValues: function () {
        return { title: 'Post ' + countAdded };
      },
      getRecordKeywords: function () {
        return ['Post ' + countAdded];
      }
    });

    function recordsAdded(records) {
      var record = records[0];
      equal(record.color, 'blue', 'Sets the color correctly');
      deepEqual(record.columnValues, { title: 'Post ' + countAdded }, 'Sets the column values correctly');
      deepEqual(record.searchKeywords, ['Post ' + countAdded], 'Sets search keywords correctly');
      strictEqual(record.object, post, 'Sets the object to the record instance');
    }

    adapter.watchRecords(App.Post, recordsAdded);
    countAdded++;
    post = App.Post.create();
    recordList.pushObject(post);
  });

  QUnit.test('Observes and releases a record correctly', function () {
    var updatesCalled = 0;
    App.Post = Model.extend();

    var post = App.Post.create({ title: 'Post' });
    var recordList = _emberRuntime.A([post]);

    adapter = App.__container__.lookup('data-adapter:main');
    adapter.reopen({
      getRecords: function () {
        return recordList;
      },
      observeRecord: function (record, recordUpdated) {
        var self = this;
        function callback() {
          recordUpdated(self.wrapRecord(record));
        }
        _emberMetal.addObserver(record, 'title', callback);
        return function () {
          _emberMetal.removeObserver(record, 'title', callback);
        };
      },
      getRecordColumnValues: function (record) {
        return { title: _emberMetal.get(record, 'title') };
      }
    });

    function recordsAdded() {
      _emberMetal.set(post, 'title', 'Post Modified');
    }

    function recordsUpdated(records) {
      updatesCalled++;
      equal(records[0].columnValues.title, 'Post Modified');
    }

    var release = adapter.watchRecords(App.Post, recordsAdded, recordsUpdated);
    release();
    _emberMetal.set(post, 'title', 'New Title');
    equal(updatesCalled, 1, 'Release function removes observers');
  });
});
enifed('ember-glimmer/tests/integration/application/actions-test', ['exports', 'ember-runtime', 'ember-glimmer/tests/utils/test-case', 'ember-glimmer/tests/utils/helpers'], function (exports, _emberRuntime, _emberGlimmerTestsUtilsTestCase, _emberGlimmerTestsUtilsHelpers) {
  'use strict';

  _emberGlimmerTestsUtilsTestCase.moduleFor('Application test: actions', (function (_ApplicationTest) {
    babelHelpers.inherits(_class, _ApplicationTest);

    function _class() {
      _ApplicationTest.apply(this, arguments);
    }

    _class.prototype['@test actions in top level template application template target application controller'] = function testActionsInTopLevelTemplateApplicationTemplateTargetApplicationController(assert) {
      var _this = this;

      assert.expect(1);

      this.registerController('application', _emberRuntime.Controller.extend({
        actions: {
          handleIt: function (arg) {
            assert.ok(true, 'controller received action properly');
          }
        }
      }));

      this.registerTemplate('application', '<button id="handle-it" {{action "handleIt"}}>Click!</button>');

      return this.visit('/').then(function () {
        _this.runTask(function () {
          return _this.$('#handle-it').click();
        });
      });
    };

    _class.prototype['@test actions in nested outlet template target their controller'] = function testActionsInNestedOutletTemplateTargetTheirController(assert) {
      var _this2 = this;

      assert.expect(1);

      this.registerController('application', _emberRuntime.Controller.extend({
        actions: {
          handleIt: function (arg) {
            assert.ok(false, 'application controller should not have received action!');
          }
        }
      }));

      this.registerController('index', _emberRuntime.Controller.extend({
        actions: {
          handleIt: function (arg) {
            assert.ok(true, 'controller received action properly');
          }
        }
      }));

      this.registerTemplate('index', '<button id="handle-it" {{action "handleIt"}}>Click!</button>');

      return this.visit('/').then(function () {
        _this2.runTask(function () {
          return _this2.$('#handle-it').click();
        });
      });
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.ApplicationTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Rendering test: non-interactive actions', (function (_RenderingTest) {
    babelHelpers.inherits(_class2, _RenderingTest);

    function _class2() {
      _RenderingTest.apply(this, arguments);
    }

    _class2.prototype.getBootOptions = function getBootOptions() {
      return { isInteractive: false };
    };

    _class2.prototype['@test doesn\'t attatch actions'] = function testDoesnTAttatchActions(assert) {
      this.registerComponent('foo-bar', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          actions: {
            fire: function () {
              assert.ok(false);
            }
          }
        }),
        template: '<button {{action \'fire\'}}>Fire!</button>'
      });

      this.render('{{foo-bar tagName=""}}');

      this.assertHTML('<button>Fire!</button>');

      this.$('button').click();
    };

    return _class2;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
});
enifed('ember-glimmer/tests/integration/application/engine-test', ['exports', 'ember-glimmer/tests/utils/test-case', 'ember-glimmer/tests/utils/abstract-test-case', 'ember-glimmer/tests/utils/helpers', 'ember-runtime', 'ember-glimmer', 'ember-application', 'ember-routing'], function (exports, _emberGlimmerTestsUtilsTestCase, _emberGlimmerTestsUtilsAbstractTestCase, _emberGlimmerTestsUtilsHelpers, _emberRuntime, _emberGlimmer, _emberApplication, _emberRouting) {
  'use strict';

  var _templateObject = babelHelpers.taggedTemplateLiteralLoose(['\n      <h1>{{contextType}}</h1>\n      {{ambiguous-curlies}}\n\n      {{outlet}}\n    '], ['\n      <h1>{{contextType}}</h1>\n      {{ambiguous-curlies}}\n\n      {{outlet}}\n    ']),
      _templateObject2 = babelHelpers.taggedTemplateLiteralLoose(['\n        <p>Component!</p>\n      '], ['\n        <p>Component!</p>\n      ']),
      _templateObject3 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{ambiguous-curlies}}\n    '], ['\n      {{ambiguous-curlies}}\n    ']),
      _templateObject4 = babelHelpers.taggedTemplateLiteralLoose(['\n      <h1>Application</h1>\n      {{my-component ambiguous-curlies="Local Data!"}}\n      {{outlet}}\n    '], ['\n      <h1>Application</h1>\n      {{my-component ambiguous-curlies="Local Data!"}}\n      {{outlet}}\n    ']),
      _templateObject5 = babelHelpers.taggedTemplateLiteralLoose(['\n          <h1>Engine</h1>\n          {{my-component}}\n          {{outlet}}\n        '], ['\n          <h1>Engine</h1>\n          {{my-component}}\n          {{outlet}}\n        ']),
      _templateObject6 = babelHelpers.taggedTemplateLiteralLoose(['\n          <p>Component!</p>\n        '], ['\n          <p>Component!</p>\n        ']);

  _emberGlimmerTestsUtilsTestCase.moduleFor('Application test: engine rendering', (function (_ApplicationTest) {
babelHelpers.inherits(_class, _ApplicationTest);

    function _class() {
      _ApplicationTest.apply(this, arguments);
    }

    _class.prototype.setupAppAndRoutableEngine = function setupAppAndRoutableEngine() {
      var hooks = arguments.length <= 0 || arguments[0] === undefined ? [] : arguments[0];

      var self = this;

      this.application.register('template:application', _emberGlimmerTestsUtilsHelpers.compile('Application{{outlet}}'));

      this.router.map(function () {
        this.mount('blog');
      });
      this.application.register('route-map:blog', function () {
        this.route('post', function () {
          this.route('comments');
          this.route('likes');
        });
      });
      this.registerRoute('application', _emberRouting.Route.extend({
        model: function () {
          hooks.push('application - application');
        }
      }));

      this.registerEngine('blog', _emberApplication.Engine.extend({
        init: function () {
          this._super.apply(this, arguments);
          this.register('controller:application', _emberRuntime.Controller.extend({
            queryParams: ['lang'],
            lang: ''
          }));
          this.register('template:application', _emberGlimmerTestsUtilsHelpers.compile('Engine{{lang}}{{outlet}}'));
          this.register('route:application', _emberRouting.Route.extend({
            model: function () {
              hooks.push('engine - application');
            }
          }));

          if (self._additionalEngineRegistrations) {
            self._additionalEngineRegistrations.call(this);
          }
        }
      }));
    };

    _class.prototype.setupAppAndRoutelessEngine = function setupAppAndRoutelessEngine(hooks) {
      this.setupRoutelessEngine(hooks);

      this.registerEngine('chat-engine', _emberApplication.Engine.extend({
        init: function () {
          this._super.apply(this, arguments);
          this.register('template:application', _emberGlimmerTestsUtilsHelpers.compile('Engine'));
          this.register('controller:application', _emberRuntime.Controller.extend({
            init: function () {
              this._super.apply(this, arguments);
              hooks.push('engine - application');
            }
          }));
        }
      }));
    };

    _class.prototype.setupAppAndRoutableEngineWithPartial = function setupAppAndRoutableEngineWithPartial(hooks) {
      this.application.register('template:application', _emberGlimmerTestsUtilsHelpers.compile('Application{{outlet}}'));

      this.router.map(function () {
        this.mount('blog');
      });
      this.application.register('route-map:blog', function () {});
      this.registerRoute('application', _emberRouting.Route.extend({
        model: function () {
          hooks.push('application - application');
        }
      }));

      this.registerEngine('blog', _emberApplication.Engine.extend({
        init: function () {
          this._super.apply(this, arguments);
          this.register('template:foo', _emberGlimmerTestsUtilsHelpers.compile('foo partial'));
          this.register('template:application', _emberGlimmerTestsUtilsHelpers.compile('Engine{{outlet}} {{partial "foo"}}'));
          this.register('route:application', _emberRouting.Route.extend({
            model: function () {
              hooks.push('engine - application');
            }
          }));
        }
      }));
    };

    _class.prototype.setupRoutelessEngine = function setupRoutelessEngine(hooks) {
      this.application.register('template:application', _emberGlimmerTestsUtilsHelpers.compile('Application{{mount "chat-engine"}}'));
      this.registerRoute('application', _emberRouting.Route.extend({
        model: function () {
          hooks.push('application - application');
        }
      }));
    };

    _class.prototype.setupAppAndRoutlessEngineWithPartial = function setupAppAndRoutlessEngineWithPartial(hooks) {
      this.setupRoutelessEngine(hooks);

      this.registerEngine('chat-engine', _emberApplication.Engine.extend({
        init: function () {
          this._super.apply(this, arguments);
          this.register('template:foo', _emberGlimmerTestsUtilsHelpers.compile('foo partial'));
          this.register('template:application', _emberGlimmerTestsUtilsHelpers.compile('Engine {{partial "foo"}}'));
          this.register('controller:application', _emberRuntime.Controller.extend({
            init: function () {
              this._super.apply(this, arguments);
              hooks.push('engine - application');
            }
          }));
        }
      }));
    };

    _class.prototype.additionalEngineRegistrations = function additionalEngineRegistrations(callback) {
      this._additionalEngineRegistrations = callback;
    };

    _class.prototype.setupEngineWithAttrs = function setupEngineWithAttrs(hooks) {
      this.application.register('template:application', _emberGlimmerTestsUtilsHelpers.compile('Application{{mount "chat-engine"}}'));

      this.registerEngine('chat-engine', _emberApplication.Engine.extend({
        init: function () {
          this._super.apply(this, arguments);
          this.register('template:components/foo-bar', _emberGlimmerTestsUtilsHelpers.compile('{{partial "troll"}}'));
          this.register('template:troll', _emberGlimmerTestsUtilsHelpers.compile('{{attrs.wat}}'));
          this.register('controller:application', _emberRuntime.Controller.extend({
            contextType: 'Engine'
          }));
          this.register('template:application', _emberGlimmerTestsUtilsHelpers.compile('Engine {{foo-bar wat=contextType}}'));
        }
      }));
    };

    _class.prototype['@test attrs in an engine'] = function testAttrsInAnEngine() {
      var _this = this;

      this.setupEngineWithAttrs([]);

      return this.visit('/').then(function () {
        _this.assertText('ApplicationEngine Engine');
      });
    };

    _class.prototype['@test sharing a template between engine and application has separate refinements'] = function testSharingATemplateBetweenEngineAndApplicationHasSeparateRefinements() {
      var _this2 = this;

      this.assert.expect(1);

      var sharedTemplate = _emberGlimmerTestsUtilsHelpers.compile(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject));

      this.application.register('template:application', sharedTemplate);
      this.registerController('application', _emberRuntime.Controller.extend({
        contextType: 'Application',
        'ambiguous-curlies': 'Controller Data!'
      }));

      this.router.map(function () {
        this.mount('blog');
      });
      this.application.register('route-map:blog', function () {});

      this.registerEngine('blog', _emberApplication.Engine.extend({
        init: function () {
          this._super.apply(this, arguments);

          this.register('controller:application', _emberRuntime.Controller.extend({
            contextType: 'Engine'
          }));
          this.register('template:application', sharedTemplate);
          this.register('template:components/ambiguous-curlies', _emberGlimmerTestsUtilsHelpers.compile(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject2)));
        }
      }));

      return this.visit('/blog').then(function () {
        _this2.assertText('ApplicationController Data!EngineComponent!');
      });
    };

    _class.prototype['@test sharing a layout between engine and application has separate refinements'] = function testSharingALayoutBetweenEngineAndApplicationHasSeparateRefinements() {
      var _this3 = this;

      this.assert.expect(1);

      var sharedLayout = _emberGlimmerTestsUtilsHelpers.compile(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject3));

      var sharedComponent = _emberGlimmer.Component.extend({
        layout: sharedLayout
      });

      this.application.register('template:application', _emberGlimmerTestsUtilsHelpers.compile(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject4)));

      this.application.register('component:my-component', sharedComponent);

      this.router.map(function () {
        this.mount('blog');
      });
      this.application.register('route-map:blog', function () {});

      this.registerEngine('blog', _emberApplication.Engine.extend({
        init: function () {
          this._super.apply(this, arguments);
          this.register('template:application', _emberGlimmerTestsUtilsHelpers.compile(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject5)));
          this.register('component:my-component', sharedComponent);
          this.register('template:components/ambiguous-curlies', _emberGlimmerTestsUtilsHelpers.compile(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject6)));
        }
      }));

      return this.visit('/blog').then(function () {
        _this3.assertText('ApplicationLocal Data!EngineComponent!');
      });
    };

    _class.prototype['@test visit() with `shouldRender: true` returns a promise that resolves when application and engine templates have rendered'] = function testVisitWithShouldRenderTrueReturnsAPromiseThatResolvesWhenApplicationAndEngineTemplatesHaveRendered(assert) {
      var _this4 = this;

      assert.expect(2);

      var hooks = [];

      this.setupAppAndRoutableEngine(hooks);

      return this.visit('/blog', { shouldRender: true }).then(function () {
        _this4.assertText('ApplicationEngine');

        _this4.assert.deepEqual(hooks, ['application - application', 'engine - application'], 'the expected model hooks were fired');
      });
    };

    _class.prototype['@test visit() with `shouldRender: false` returns a promise that resolves without rendering'] = function testVisitWithShouldRenderFalseReturnsAPromiseThatResolvesWithoutRendering(assert) {
      var _this5 = this;

      assert.expect(2);

      var hooks = [];

      this.setupAppAndRoutableEngine(hooks);

      return this.visit('/blog', { shouldRender: false }).then(function () {
        _this5.assertText('');

        _this5.assert.deepEqual(hooks, ['application - application', 'engine - application'], 'the expected model hooks were fired');
      });
    };

    _class.prototype['@test visit() with `shouldRender: true` returns a promise that resolves when application and routeless engine templates have rendered'] = function testVisitWithShouldRenderTrueReturnsAPromiseThatResolvesWhenApplicationAndRoutelessEngineTemplatesHaveRendered(assert) {
      var _this6 = this;

      assert.expect(2);

      var hooks = [];

      this.setupAppAndRoutelessEngine(hooks);

      return this.visit('/', { shouldRender: true }).then(function () {
        _this6.assertText('ApplicationEngine');

        _this6.assert.deepEqual(hooks, ['application - application', 'engine - application'], 'the expected hooks were fired');
      });
    };

    _class.prototype['@test visit() with partials in routable engine'] = function testVisitWithPartialsInRoutableEngine(assert) {
      var _this7 = this;

      assert.expect(2);

      var hooks = [];

      this.setupAppAndRoutableEngineWithPartial(hooks);

      return this.visit('/blog', { shouldRender: true }).then(function () {
        _this7.assertText('ApplicationEngine foo partial');

        _this7.assert.deepEqual(hooks, ['application - application', 'engine - application'], 'the expected hooks were fired');
      });
    };

    _class.prototype['@test visit() with partials in non-routable engine'] = function testVisitWithPartialsInNonRoutableEngine(assert) {
      var _this8 = this;

      assert.expect(2);

      var hooks = [];

      this.setupAppAndRoutlessEngineWithPartial(hooks);

      return this.visit('/', { shouldRender: true }).then(function () {
        _this8.assertText('ApplicationEngine foo partial');

        _this8.assert.deepEqual(hooks, ['application - application', 'engine - application'], 'the expected hooks were fired');
      });
    };

    _class.prototype['@test deactivate should be called on Engine Routes before destruction'] = function testDeactivateShouldBeCalledOnEngineRoutesBeforeDestruction(assert) {
      var _this9 = this;

      assert.expect(3);

      this.setupAppAndRoutableEngine();

      this.registerEngine('blog', _emberApplication.Engine.extend({
        init: function () {
          this._super.apply(this, arguments);
          this.register('template:application', _emberGlimmerTestsUtilsHelpers.compile('Engine{{outlet}}'));
          this.register('route:application', _emberRouting.Route.extend({
            deactivate: function () {
              assert.notOk(this.isDestroyed, 'Route is not destroyed');
              assert.notOk(this.isDestroying, 'Route is not being destroyed');
            }
          }));
        }
      }));

      return this.visit('/blog').then(function () {
        _this9.assertText('ApplicationEngine');
      });
    };

    _class.prototype['@test engine should lookup and use correct controller'] = function testEngineShouldLookupAndUseCorrectController(assert) {
      var _this10 = this;

      this.setupAppAndRoutableEngine();

      return this.visit('/blog?lang=English').then(function () {
        _this10.assertText('ApplicationEngineEnglish');
      });
    };

    _class.prototype['@test error substate route works for the application route of an Engine'] = function testErrorSubstateRouteWorksForTheApplicationRouteOfAnEngine(assert) {
      var _this11 = this;

      assert.expect(2);

      this.setupAppAndRoutableEngine();
      this.application.__registry__.resolver.moduleBasedResolver = true;
      this.additionalEngineRegistrations(function () {
        this.register('template:application_error', _emberGlimmerTestsUtilsHelpers.compile('Error! {{model.message}}'));
        this.register('route:post', _emberRouting.Route.extend({
          model: function () {
            return _emberRuntime.RSVP.reject(new Error('Oh, noes!'));
          }
        }));
      });

      return this.visit('/').then(function () {
        _this11.assertText('Application');
        return _this11.transitionTo('blog.post');
      }).catch(function () {
        _this11.assertText('ApplicationError! Oh, noes!');
      });
    };

    _class.prototype['@test error route works for the application route of an Engine'] = function testErrorRouteWorksForTheApplicationRouteOfAnEngine(assert) {
      var _this12 = this;

      assert.expect(2);

      this.setupAppAndRoutableEngine();
      this.application.__registry__.resolver.moduleBasedResolver = true;
      this.additionalEngineRegistrations(function () {
        this.register('template:error', _emberGlimmerTestsUtilsHelpers.compile('Error! {{model.message}}'));
        this.register('route:post', _emberRouting.Route.extend({
          model: function () {
            return _emberRuntime.RSVP.reject(new Error('Oh, noes!'));
          }
        }));
      });

      return this.visit('/').then(function () {
        _this12.assertText('Application');
        return _this12.transitionTo('blog.post');
      }).catch(function () {
        _this12.assertText('ApplicationEngineError! Oh, noes!');
      });
    };

    _class.prototype['@test error substate route works for a child route of an Engine'] = function testErrorSubstateRouteWorksForAChildRouteOfAnEngine(assert) {
      var _this13 = this;

      assert.expect(2);

      this.setupAppAndRoutableEngine();
      this.application.__registry__.resolver.moduleBasedResolver = true;
      this.additionalEngineRegistrations(function () {
        this.register('template:post_error', _emberGlimmerTestsUtilsHelpers.compile('Error! {{model.message}}'));
        this.register('route:post', _emberRouting.Route.extend({
          model: function () {
            return _emberRuntime.RSVP.reject(new Error('Oh, noes!'));
          }
        }));
      });

      return this.visit('/').then(function () {
        _this13.assertText('Application');
        return _this13.transitionTo('blog.post');
      }).catch(function () {
        _this13.assertText('ApplicationEngineError! Oh, noes!');
      });
    };

    _class.prototype['@test error route works for a child route of an Engine'] = function testErrorRouteWorksForAChildRouteOfAnEngine(assert) {
      var _this14 = this;

      assert.expect(2);

      this.setupAppAndRoutableEngine();
      this.application.__registry__.resolver.moduleBasedResolver = true;
      this.additionalEngineRegistrations(function () {
        this.register('template:post.error', _emberGlimmerTestsUtilsHelpers.compile('Error! {{model.message}}'));
        this.register('route:post.comments', _emberRouting.Route.extend({
          model: function () {
            return _emberRuntime.RSVP.reject(new Error('Oh, noes!'));
          }
        }));
      });

      return this.visit('/').then(function () {
        _this14.assertText('Application');
        return _this14.transitionTo('blog.post.comments');
      }).catch(function () {
        _this14.assertText('ApplicationEngineError! Oh, noes!');
      });
    };

    _class.prototype['@test loading substate route works for the application route of an Engine'] = function testLoadingSubstateRouteWorksForTheApplicationRouteOfAnEngine(assert) {
      var _this15 = this;

      assert.expect(3);

      var resolveLoading = undefined;

      this.setupAppAndRoutableEngine();
      this.application.__registry__.resolver.moduleBasedResolver = true;
      this.additionalEngineRegistrations(function () {
        this.register('template:application_loading', _emberGlimmerTestsUtilsHelpers.compile('Loading'));
        this.register('template:post', _emberGlimmerTestsUtilsHelpers.compile('Post'));
        this.register('route:post', _emberRouting.Route.extend({
          model: function () {
            return new _emberRuntime.RSVP.Promise(function (resolve) {
              resolveLoading = resolve;
            });
          }
        }));
      });

      return this.visit('/').then(function () {
        _this15.assertText('Application');
        var transition = _this15.transitionTo('blog.post');

        _this15.runTaskNext(function () {
          _this15.assertText('ApplicationLoading');
          resolveLoading();
        });

        return transition.then(function () {
          _this15.runTaskNext(function () {
            return _this15.assertText('ApplicationEnginePost');
          });
        });
      });
    };

    _class.prototype['@test loading route works for the application route of an Engine'] = function testLoadingRouteWorksForTheApplicationRouteOfAnEngine(assert) {
      var _this16 = this;

      assert.expect(3);

      var resolveLoading = undefined;

      this.setupAppAndRoutableEngine();
      this.additionalEngineRegistrations(function () {
        this.register('template:loading', _emberGlimmerTestsUtilsHelpers.compile('Loading'));
        this.register('template:post', _emberGlimmerTestsUtilsHelpers.compile('Post'));
        this.register('route:post', _emberRouting.Route.extend({
          model: function () {
            return new _emberRuntime.RSVP.Promise(function (resolve) {
              resolveLoading = resolve;
            });
          }
        }));
      });

      return this.visit('/').then(function () {
        _this16.assertText('Application');
        var transition = _this16.transitionTo('blog.post');

        _this16.runTaskNext(function () {
          _this16.assertText('ApplicationEngineLoading');
          resolveLoading();
        });

        return transition.then(function () {
          _this16.runTaskNext(function () {
            return _this16.assertText('ApplicationEnginePost');
          });
        });
      });
    };

    _class.prototype['@test loading substate route works for a child route of an Engine'] = function testLoadingSubstateRouteWorksForAChildRouteOfAnEngine(assert) {
      var _this17 = this;

      assert.expect(3);

      var resolveLoading = undefined;

      this.setupAppAndRoutableEngine();
      this.application.__registry__.resolver.moduleBasedResolver = true;
      this.additionalEngineRegistrations(function () {
        this.register('template:post', _emberGlimmerTestsUtilsHelpers.compile('{{outlet}}'));
        this.register('template:post.comments', _emberGlimmerTestsUtilsHelpers.compile('Comments'));
        this.register('template:post.likes_loading', _emberGlimmerTestsUtilsHelpers.compile('Loading'));
        this.register('template:post.likes', _emberGlimmerTestsUtilsHelpers.compile('Likes'));
        this.register('route:post.likes', _emberRouting.Route.extend({
          model: function () {
            return new _emberRuntime.RSVP.Promise(function (resolve) {
              resolveLoading = resolve;
            });
          }
        }));
      });

      return this.visit('/blog/post/comments').then(function () {
        _this17.assertText('ApplicationEngineComments');
        var transition = _this17.transitionTo('blog.post.likes');

        _this17.runTaskNext(function () {
          _this17.assertText('ApplicationEngineLoading');
          resolveLoading();
        });

        return transition.then(function () {
          _this17.runTaskNext(function () {
            return _this17.assertText('ApplicationEngineLikes');
          });
        });
      });
    };

    _class.prototype['@test loading route works for a child route of an Engine'] = function testLoadingRouteWorksForAChildRouteOfAnEngine(assert) {
      var _this18 = this;

      assert.expect(3);

      var resolveLoading = undefined;

      this.setupAppAndRoutableEngine();
      this.additionalEngineRegistrations(function () {
        this.register('template:post', _emberGlimmerTestsUtilsHelpers.compile('{{outlet}}'));
        this.register('template:post.comments', _emberGlimmerTestsUtilsHelpers.compile('Comments'));
        this.register('template:post.loading', _emberGlimmerTestsUtilsHelpers.compile('Loading'));
        this.register('template:post.likes', _emberGlimmerTestsUtilsHelpers.compile('Likes'));
        this.register('route:post.likes', _emberRouting.Route.extend({
          model: function () {
            return new _emberRuntime.RSVP.Promise(function (resolve) {
              resolveLoading = resolve;
            });
          }
        }));
      });

      return this.visit('/blog/post/comments').then(function () {
        _this18.assertText('ApplicationEngineComments');
        var transition = _this18.transitionTo('blog.post.likes');

        _this18.runTaskNext(function () {
          _this18.assertText('ApplicationEngineLoading');
          resolveLoading();
        });

        return transition.then(function () {
          _this18.runTaskNext(function () {
            return _this18.assertText('ApplicationEngineLikes');
          });
        });
      });
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.ApplicationTest));
});
enifed('ember-glimmer/tests/integration/application/rendering-test', ['exports', 'ember-runtime', 'ember-glimmer/tests/utils/test-case', 'ember-glimmer/tests/utils/abstract-test-case', 'ember-routing', 'ember-metal', 'ember-glimmer'], function (exports, _emberRuntime, _emberGlimmerTestsUtilsTestCase, _emberGlimmerTestsUtilsAbstractTestCase, _emberRouting, _emberMetal, _emberGlimmer) {
  'use strict';

  var _templateObject = babelHelpers.taggedTemplateLiteralLoose(['\n      <ul>\n        {{#each model as |item|}}\n          <li>{{item}}</li>\n        {{/each}}\n      </ul>\n    '], ['\n      <ul>\n        {{#each model as |item|}}\n          <li>{{item}}</li>\n        {{/each}}\n      </ul>\n    ']),
      _templateObject2 = babelHelpers.taggedTemplateLiteralLoose(['\n          <ul>\n            <li>red</li>\n            <li>yellow</li>\n            <li>blue</li>\n          </ul>\n        '], ['\n          <ul>\n            <li>red</li>\n            <li>yellow</li>\n            <li>blue</li>\n          </ul>\n        ']),
      _templateObject3 = babelHelpers.taggedTemplateLiteralLoose(['\n      <nav>{{outlet "nav"}}</nav>\n      <main>{{outlet}}</main>\n    '], ['\n      <nav>{{outlet "nav"}}</nav>\n      <main>{{outlet}}</main>\n    ']),
      _templateObject4 = babelHelpers.taggedTemplateLiteralLoose(['\n      <a href="http://emberjs.com/">Ember</a>\n    '], ['\n      <a href="http://emberjs.com/">Ember</a>\n    ']),
      _templateObject5 = babelHelpers.taggedTemplateLiteralLoose(['\n          <nav>\n            <a href="http://emberjs.com/">Ember</a>\n          </nav>\n          <main>\n            <ul>\n              <li>red</li>\n              <li>yellow</li>\n              <li>blue</li>\n            </ul>\n          </main>\n        '], ['\n          <nav>\n            <a href="http://emberjs.com/">Ember</a>\n          </nav>\n          <main>\n            <ul>\n              <li>red</li>\n              <li>yellow</li>\n              <li>blue</li>\n            </ul>\n          </main>\n        ']);

  _emberGlimmerTestsUtilsTestCase.moduleFor('Application test: rendering', (function (_ApplicationTest) {
babelHelpers.inherits(_class, _ApplicationTest);

    function _class() {
      _ApplicationTest.apply(this, arguments);
    }

    _class.prototype['@test it can render the application template'] = function testItCanRenderTheApplicationTemplate(assert) {
      var _this = this;

      this.registerTemplate('application', 'Hello world!');

      return this.visit('/').then(function () {
        _this.assertText('Hello world!');
      });
    };

    _class.prototype['@test it can access the model provided by the route'] = function testItCanAccessTheModelProvidedByTheRoute(assert) {
      var _this2 = this;

      this.registerRoute('application', _emberRouting.Route.extend({
        model: function () {
          return ['red', 'yellow', 'blue'];
        }
      }));

      this.registerTemplate('application', _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject));

      return this.visit('/').then(function () {
        _this2.assertComponentElement(_this2.firstChild, {
          content: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject2)
        });
      });
    };

    _class.prototype['@test it can render a nested route'] = function testItCanRenderANestedRoute(assert) {
      var _this3 = this;

      this.router.map(function () {
        this.route('lists', function () {
          this.route('colors', function () {
            this.route('favorite');
          });
        });
      });

      // The "favorite" route will inherit the model
      this.registerRoute('lists.colors', _emberRouting.Route.extend({
        model: function () {
          return ['red', 'yellow', 'blue'];
        }
      }));

      this.registerTemplate('lists.colors.favorite', _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject));

      return this.visit('/lists/colors/favorite').then(function () {
        _this3.assertComponentElement(_this3.firstChild, {
          content: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject2)
        });
      });
    };

    _class.prototype['@test it can render into named outlets'] = function testItCanRenderIntoNamedOutlets(assert) {
      var _this4 = this;

      this.router.map(function () {
        this.route('colors');
      });

      this.registerTemplate('application', _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject3));

      this.registerTemplate('nav', _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject4));

      this.registerRoute('application', _emberRouting.Route.extend({
        renderTemplate: function () {
          this.render();
          this.render('nav', {
            into: 'application',
            outlet: 'nav'
          });
        }
      }));

      this.registerRoute('colors', _emberRouting.Route.extend({
        model: function () {
          return ['red', 'yellow', 'blue'];
        }
      }));

      this.registerTemplate('colors', _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject));

      return this.visit('/colors').then(function () {
        _this4.assertComponentElement(_this4.firstChild, {
          content: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject5)
        });
      });
    };

    _class.prototype['@test it can render into named outlets'] = function testItCanRenderIntoNamedOutlets(assert) {
      var _this5 = this;

      this.router.map(function () {
        this.route('colors');
      });

      this.registerTemplate('application', _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject3));

      this.registerTemplate('nav', _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject4));

      this.registerRoute('application', _emberRouting.Route.extend({
        renderTemplate: function () {
          this.render();
          this.render('nav', {
            into: 'application',
            outlet: 'nav'
          });
        }
      }));

      this.registerRoute('colors', _emberRouting.Route.extend({
        model: function () {
          return ['red', 'yellow', 'blue'];
        }
      }));

      this.registerTemplate('colors', _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject));

      return this.visit('/colors').then(function () {
        _this5.assertComponentElement(_this5.firstChild, {
          content: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject5)
        });
      });
    };

    _class.prototype['@test it should update the outlets when switching between routes'] = function testItShouldUpdateTheOutletsWhenSwitchingBetweenRoutes(assert) {
      var _this6 = this;

      this.router.map(function () {
        this.route('a');
        this.route('b', function () {
          this.route('c');
          this.route('d');
        });
      });

      this.registerTemplate('a', 'A{{outlet}}');
      this.registerTemplate('b', 'B{{outlet}}');
      this.registerTemplate('b.c', 'C');
      this.registerTemplate('b.d', 'D');

      return this.visit('/b/c').then(function () {
        // this.assertComponentElement(this.firstChild, { content: 'BC' });
        _this6.assertText('BC');
        return _this6.visit('/a');
      }).then(function () {
        // this.assertComponentElement(this.firstChild, { content: 'A' });
        _this6.assertText('A');
        return _this6.visit('/b/d');
      }).then(function () {
        _this6.assertText('BD');
        // this.assertComponentElement(this.firstChild, { content: 'BD' });
      });
    };

    _class.prototype['@test it should produce a stable DOM when the model changes'] = function testItShouldProduceAStableDOMWhenTheModelChanges(assert) {
      var _this7 = this;

      this.router.map(function () {
        this.route('color', { path: '/colors/:color' });
      });

      this.registerRoute('color', _emberRouting.Route.extend({
        model: function (params) {
          return params.color;
        }
      }));

      this.registerTemplate('color', 'color: {{model}}');

      return this.visit('/colors/red').then(function () {
        _this7.assertComponentElement(_this7.firstChild, { content: 'color: red' });
        _this7.takeSnapshot();
        return _this7.visit('/colors/green');
      }).then(function () {
        _this7.assertComponentElement(_this7.firstChild, { content: 'color: green' });
        _this7.assertInvariants();
      });
    };

    _class.prototype['@test it should have the right controller in scope for the route template'] = function testItShouldHaveTheRightControllerInScopeForTheRouteTemplate() {
      var _this8 = this;

      this.router.map(function () {
        this.route('a');
        this.route('b');
      });

      this.registerController('a', _emberRuntime.Controller.extend({
        value: 'a'
      }));

      this.registerController('b', _emberRuntime.Controller.extend({
        value: 'b'
      }));

      this.registerTemplate('a', '{{value}}');
      this.registerTemplate('b', '{{value}}');

      return this.visit('/a').then(function () {
        _this8.assertText('a');
        return _this8.visit('/b');
      }).then(function () {
        return _this8.assertText('b');
      });
    };

    _class.prototype['@test it should update correctly when the controller changes'] = function testItShouldUpdateCorrectlyWhenTheControllerChanges(assert) {
      var _this9 = this;

      this.router.map(function () {
        this.route('color', { path: '/colors/:color' });
      });

      this.registerRoute('color', _emberRouting.Route.extend({
        model: function (params) {
          return { color: params.color };
        },

        renderTemplate: function (controller, model) {
          this.render({ controller: model.color, model: model });
        }
      }));

      this.registerController('red', _emberRuntime.Controller.extend({
        color: 'red'
      }));

      this.registerController('green', _emberRuntime.Controller.extend({
        color: 'green'
      }));

      this.registerTemplate('color', 'model color: {{model.color}}, controller color: {{color}}');

      return this.visit('/colors/red').then(function () {
        _this9.assertComponentElement(_this9.firstChild, { content: 'model color: red, controller color: red' });
        _this9.takeSnapshot();
        return _this9.visit('/colors/green');
      }).then(function () {
        _this9.assertComponentElement(_this9.firstChild, { content: 'model color: green, controller color: green' });
        _this9.assertInvariants();
      });
    };

    _class.prototype['@test it should produce a stable DOM when two routes render the same template'] = function testItShouldProduceAStableDOMWhenTwoRoutesRenderTheSameTemplate(assert) {
      var _this10 = this;

      this.router.map(function () {
        this.route('a');
        this.route('b');
      });

      this.registerRoute('a', _emberRouting.Route.extend({
        model: function () {
          return 'A';
        },

        renderTemplate: function (controller, model) {
          this.render('common', { controller: 'common', model: model });
        }
      }));

      this.registerRoute('b', _emberRouting.Route.extend({
        model: function () {
          return 'B';
        },

        renderTemplate: function (controller, model) {
          this.render('common', { controller: 'common', model: model });
        }
      }));

      this.registerController('common', _emberRuntime.Controller.extend({
        prefix: 'common'
      }));

      this.registerTemplate('common', '{{prefix}} {{model}}');

      return this.visit('/a').then(function () {
        _this10.assertComponentElement(_this10.firstChild, { content: 'common A' });
        _this10.takeSnapshot();
        return _this10.visit('/b');
      }).then(function () {
        _this10.assertComponentElement(_this10.firstChild, { content: 'common B' });
        _this10.assertInvariants();
      });
    };

    // Regression test, glimmer child outlets tried to assume the first element.
    // but the if put-args clobbered the args used by did-create-element.
    // I wish there was a way to assert that the OutletComponentManager did not
    // receive a didCreateElement.

    _class.prototype['@test a child outlet is always a fragment'] = function testAChildOutletIsAlwaysAFragment() {
      var _this11 = this;

      this.registerTemplate('application', '{{outlet}}');
      this.registerTemplate('index', '{{#if true}}1{{/if}}<div>2</div>');
      return this.visit('/').then(function () {
        _this11.assertComponentElement(_this11.firstChild, { content: '1<div>2</div>' });
      });
    };

    _class.prototype['@test it allows a transition during route activate'] = function testItAllowsATransitionDuringRouteActivate(assert) {
      var _this12 = this;

      this.router.map(function () {
        this.route('a');
      });

      this.registerRoute('index', _emberRouting.Route.extend({
        activate: function () {
          this.transitionTo('a');
        }
      }));

      this.registerTemplate('a', 'Hello from A!');

      return this.visit('/').then(function () {
        _this12.assertComponentElement(_this12.firstChild, {
          content: 'Hello from A!'
        });
      });
    };

    _class.prototype['@test it emits a useful backtracking re-render assertion message'] = function testItEmitsAUsefulBacktrackingReRenderAssertionMessage(assert) {
      var _this13 = this;

      this.router.map(function () {
        this.route('routeWithError');
      });

      this.registerRoute('routeWithError', _emberRouting.Route.extend({
        model: function () {
          return { name: 'Alex' };
        }
      }));

      this.registerTemplate('routeWithError', 'Hi {{model.name}} {{x-foo person=model}}');

      this.registerComponent('x-foo', {
        ComponentClass: _emberGlimmer.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            this.set('person.name', 'Ben');
          }
        }),
        template: 'Hi {{person.name}} from component'
      });

      var expectedBacktrackingMessage = /modified "model\.name" twice on \[object Object\] in a single render\. It was rendered in "template:routeWithError" and modified in "component:x-foo"/;

      if (false) {
        expectDeprecation(expectedBacktrackingMessage);
        return this.visit('/routeWithError');
      } else {
        return this.visit('/').then(function () {
          expectAssertion(function () {
            _this13.visit('/routeWithError');
          }, expectedBacktrackingMessage);
        });
      }
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.ApplicationTest));
});
enifed('ember-glimmer/tests/integration/binding_integration_test', ['exports', 'ember-glimmer/tests/utils/test-case', 'ember-glimmer/tests/utils/helpers', 'ember-metal'], function (exports, _emberGlimmerTestsUtilsTestCase, _emberGlimmerTestsUtilsHelpers, _emberMetal) {
  'use strict';

  _emberGlimmerTestsUtilsTestCase.moduleFor('Binding integration tests', (function (_RenderingTest) {
    babelHelpers.inherits(_class, _RenderingTest);

    function _class() {
      _RenderingTest.apply(this, arguments);
    }

    _class.prototype['@test should accept bindings as a string or an Ember.binding'] = function testShouldAcceptBindingsAsAStringOrAnEmberBinding() {
      var _this = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        twoWayTestBinding: _emberMetal.Binding.from('direction'),
        stringTestBinding: 'direction',
        twoWayObjectTestBinding: _emberMetal.Binding.from('displacement.distance'),
        stringObjectTestBinding: 'displacement.distance'
      });

      this.registerComponent('foo-bar', {
        ComponentClass: FooBarComponent,
        template: 'two way: {{twoWayTest}}, string: {{stringTest}}, object: {{twoWayObjectTest}}, string object: {{stringObjectTest}}'
      });

      expectDeprecation(function () {
        _this.render('{{foo-bar direction=direction displacement=displacement}}', {
          direction: 'down',
          displacement: {
            distance: 10
          }
        });
      }, /`Ember\.Binding` is deprecated/);

      this.assertText('two way: down, string: down, object: 10, string object: 10');

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(_this.context, 'direction', 'up');
      });

      this.assertText('two way: up, string: up, object: 10, string object: 10');

      this.runTask(function () {
        return _emberMetal.set(_this.context, 'displacement.distance', 20);
      });

      this.assertText('two way: up, string: up, object: 20, string object: 20');

      this.runTask(function () {
        _emberMetal.set(_this.context, 'direction', 'right');
        _emberMetal.set(_this.context, 'displacement.distance', 30);
      });

      this.assertText('two way: right, string: right, object: 30, string object: 30');

      this.runTask(function () {
        _emberMetal.set(_this.context, 'direction', 'down');
        _emberMetal.set(_this.context, 'displacement', { distance: 10 });
      });

      this.assertText('two way: down, string: down, object: 10, string object: 10');
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
});
enifed('ember-glimmer/tests/integration/components/append-test', ['exports', 'ember-metal', 'ember-views', 'ember-glimmer/tests/utils/test-case', 'ember-glimmer/tests/utils/helpers', 'ember-glimmer/tests/utils/abstract-test-case'], function (exports, _emberMetal, _emberViews, _emberGlimmerTestsUtilsTestCase, _emberGlimmerTestsUtilsHelpers, _emberGlimmerTestsUtilsAbstractTestCase) {
  'use strict';

  var _templateObject = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#if showFooBar}}\n        {{foo-bar}}\n      {{else}}\n        {{baz-qux}}\n      {{/if}}\n    '], ['\n      {{#if showFooBar}}\n        {{foo-bar}}\n      {{else}}\n        {{baz-qux}}\n      {{/if}}\n    ']);

  var AbstractAppendTest = (function (_RenderingTest) {
babelHelpers.inherits(AbstractAppendTest, _RenderingTest);

    function AbstractAppendTest() {
      _RenderingTest.call(this);

      this.components = [];
      this.ids = [];
    }

    AbstractAppendTest.prototype.teardown = function teardown() {
      var _this = this;

      this.component = null;

      this.components.forEach(function (component) {
        _this.runTask(function () {
          return component.destroy();
        });
      });

      this.ids.forEach(function (id) {
        var $element = _emberViews.jQuery(id).remove();
        _this.assert.strictEqual($element.length, 0, 'Should not leak element: #' + id);
      });

      _RenderingTest.prototype.teardown.call(this);
    };

    /* abstract append(component): Element; */

    AbstractAppendTest.prototype.didAppend = function didAppend(component) {
      this.components.push(component);
      this.ids.push(component.elementId);
    };

    AbstractAppendTest.prototype['@test lifecycle hooks during component append'] = function testLifecycleHooksDuringComponentAppend(assert) {
      var _this3 = this;

      var hooks = [];

      var oldRegisterComponent = this.registerComponent;
      var componentsByName = {};

      // TODO: refactor/combine with other life-cycle tests
      this.registerComponent = function (name, _options) {
        function pushHook(hookName) {
          hooks.push([name, hookName]);
        }

        var options = {
          ComponentClass: _options.ComponentClass.extend({
            init: function () {
              var _this2 = this,
                  _arguments = arguments;

              expectDeprecation(function () {
                _this2._super.apply(_this2, _arguments);
              }, /didInitAttrs called/);
              if (name in componentsByName) {
                throw new TypeError('Component named: ` ' + name + ' ` already registered');
              }
              componentsByName[name] = this;
              pushHook('init');
              this.on('init', function () {
                return pushHook('on(init)');
              });
            },

            didInitAttrs: function (options) {
              pushHook('didInitAttrs', options);
            },

            didReceiveAttrs: function () {
              pushHook('didReceiveAttrs');
            },

            willInsertElement: function () {
              pushHook('willInsertElement');
            },

            willRender: function () {
              pushHook('willRender');
            },

            didInsertElement: function () {
              pushHook('didInsertElement');
            },

            didRender: function () {
              pushHook('didRender');
            },

            didUpdateAttrs: function () {
              pushHook('didUpdateAttrs');
            },

            willUpdate: function () {
              pushHook('willUpdate');
            },

            didUpdate: function () {
              pushHook('didUpdate');
            },

            willDestroyElement: function () {
              pushHook('willDestroyElement');
            },

            willClearRender: function () {
              pushHook('willClearRender');
            },

            didDestroyElement: function () {
              pushHook('didDestroyElement');
            },

            willDestroy: function () {
              pushHook('willDestroy');
              this._super.apply(this, arguments);
            }
          }),
          template: _options.template
        };

        oldRegisterComponent.call(this, name, options);
      };

      this.registerComponent('x-parent', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          layoutName: 'components/x-parent'
        }),

        template: '[parent: {{foo}}]{{#x-child bar=foo}}[yielded: {{foo}}]{{/x-child}}'
      });

      this.registerComponent('x-child', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          tagName: ''
        }),

        template: '[child: {{bar}}]{{yield}}'
      });

      var XParent = this.owner._lookupFactory('component:x-parent');

      this.component = XParent.create({ foo: 'zomg' });

      assert.deepEqual(hooks, [['x-parent', 'init'], ['x-parent', 'didInitAttrs'], ['x-parent', 'didReceiveAttrs'], ['x-parent', 'on(init)']], 'creation of x-parent');

      hooks.length = 0;

      this.element = this.append(this.component);

      assert.deepEqual(hooks, [['x-parent', 'willInsertElement'], ['x-child', 'init'], ['x-child', 'didInitAttrs'], ['x-child', 'didReceiveAttrs'], ['x-child', 'on(init)'], ['x-child', 'willRender'], ['x-child', 'willInsertElement'], ['x-child', 'didInsertElement'], ['x-child', 'didRender'], ['x-parent', 'didInsertElement'], ['x-parent', 'didRender']], 'appending of x-parent');

      hooks.length = 0;

      this.runTask(function () {
        return componentsByName['x-parent'].rerender();
      });

      assert.deepEqual(hooks, [['x-parent', 'willUpdate'], ['x-parent', 'willRender'], ['x-parent', 'didUpdate'], ['x-parent', 'didRender']], 'rerender x-parent');

      hooks.length = 0;

      this.runTask(function () {
        return componentsByName['x-child'].rerender();
      });

      assert.deepEqual(hooks, [['x-parent', 'willUpdate'], ['x-parent', 'willRender'], ['x-child', 'willUpdate'], ['x-child', 'willRender'], ['x-child', 'didUpdate'], ['x-child', 'didRender'], ['x-parent', 'didUpdate'], ['x-parent', 'didRender']], 'rerender x-child');

      hooks.length = 0;

      this.runTask(function () {
        return _emberMetal.set(_this3.component, 'foo', 'wow');
      });

      assert.deepEqual(hooks, [['x-parent', 'willUpdate'], ['x-parent', 'willRender'], ['x-child', 'didUpdateAttrs'], ['x-child', 'didReceiveAttrs'], ['x-child', 'willUpdate'], ['x-child', 'willRender'], ['x-child', 'didUpdate'], ['x-child', 'didRender'], ['x-parent', 'didUpdate'], ['x-parent', 'didRender']], 'set foo = wow');

      hooks.length = 0;

      this.runTask(function () {
        return _emberMetal.set(_this3.component, 'foo', 'zomg');
      });

      assert.deepEqual(hooks, [['x-parent', 'willUpdate'], ['x-parent', 'willRender'], ['x-child', 'didUpdateAttrs'], ['x-child', 'didReceiveAttrs'], ['x-child', 'willUpdate'], ['x-child', 'willRender'], ['x-child', 'didUpdate'], ['x-child', 'didRender'], ['x-parent', 'didUpdate'], ['x-parent', 'didRender']], 'set foo = zomg');

      hooks.length = 0;

      this.runTask(function () {
        return _this3.component.destroy();
      });

      assert.deepEqual(hooks, [['x-parent', 'willDestroyElement'], ['x-parent', 'willClearRender'], ['x-child', 'willDestroyElement'], ['x-child', 'willClearRender'], ['x-child', 'didDestroyElement'], ['x-parent', 'didDestroyElement'], ['x-parent', 'willDestroy'], ['x-child', 'willDestroy']], 'destroy');
    };

    AbstractAppendTest.prototype['@test appending, updating and destroying a single component'] = function testAppendingUpdatingAndDestroyingASingleComponent(assert) {
      var _this4 = this;

      var willDestroyCalled = 0;

      this.registerComponent('x-parent', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          layoutName: 'components/x-parent',
          willDestroyElement: function () {
            willDestroyCalled++;
          }
        }),

        template: '[parent: {{foo}}]{{#x-child bar=foo}}[yielded: {{foo}}]{{/x-child}}'
      });

      this.registerComponent('x-child', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          tagName: ''
        }),

        template: '[child: {{bar}}]{{yield}}'
      });

      var XParent = this.owner._lookupFactory('component:x-parent');

      this.component = XParent.create({ foo: 'zomg' });

      assert.ok(!this.component.element, 'precond - should not have an element');

      this.element = this.append(this.component);

      var componentElement = this.component.element;

      this.assertComponentElement(componentElement, { content: '[parent: zomg][child: zomg][yielded: zomg]' });

      assert.equal(componentElement.parentElement, this.element, 'It should be attached to the target');

      this.runTask(function () {
        return _this4.rerender();
      });

      this.assertComponentElement(componentElement, { content: '[parent: zomg][child: zomg][yielded: zomg]' });

      assert.equal(componentElement.parentElement, this.element, 'It should be attached to the target');

      this.runTask(function () {
        return _emberMetal.set(_this4.component, 'foo', 'wow');
      });

      this.assertComponentElement(componentElement, { content: '[parent: wow][child: wow][yielded: wow]' });

      assert.equal(componentElement.parentElement, this.element, 'It should be attached to the target');

      this.runTask(function () {
        return _emberMetal.set(_this4.component, 'foo', 'zomg');
      });

      this.assertComponentElement(componentElement, { content: '[parent: zomg][child: zomg][yielded: zomg]' });

      assert.equal(componentElement.parentElement, this.element, 'It should be attached to the target');

      this.runTask(function () {
        return _this4.component.destroy();
      });

      if (this.isHTMLBars) {
        // Bug in Glimmer – component should not have .element at this point
        assert.ok(!this.component.element, 'It should not have an element');
      }

      assert.ok(!componentElement.parentElement, 'The component element should be detached');

      this.assert.equal(willDestroyCalled, 1);
    };

    AbstractAppendTest.prototype['@test appending, updating and destroying multiple components'] = function testAppendingUpdatingAndDestroyingMultipleComponents(assert) {
      var _this5 = this;

      var willDestroyCalled = 0;

      this.registerComponent('x-first', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          layoutName: 'components/x-first',

          willDestroyElement: function () {
            willDestroyCalled++;
          }
        }),

        template: 'x-first {{foo}}!'
      });

      this.registerComponent('x-second', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          layoutName: 'components/x-second',

          willDestroyElement: function () {
            willDestroyCalled++;
          }
        }),

        template: 'x-second {{bar}}!'
      });

      var First = this.owner._lookupFactory('component:x-first');
      var Second = this.owner._lookupFactory('component:x-second');

      var first = First.create({ foo: 'foo' });
      var second = Second.create({ bar: 'bar' });

      this.assert.ok(!first.element, 'precond - should not have an element');
      this.assert.ok(!second.element, 'precond - should not have an element');

      var wrapper1 = undefined,
          wrapper2 = undefined;

      this.runTask(function () {
        return wrapper1 = _this5.append(first);
      });
      this.runTask(function () {
        return wrapper2 = _this5.append(second);
      });

      var componentElement1 = first.element;
      var componentElement2 = second.element;

      this.assertComponentElement(componentElement1, { content: 'x-first foo!' });
      this.assertComponentElement(componentElement2, { content: 'x-second bar!' });

      assert.equal(componentElement1.parentElement, wrapper1, 'The first component should be attached to the target');
      assert.equal(componentElement2.parentElement, wrapper2, 'The second component should be attached to the target');

      this.runTask(function () {
        return _emberMetal.set(first, 'foo', 'FOO');
      });

      this.assertComponentElement(componentElement1, { content: 'x-first FOO!' });
      this.assertComponentElement(componentElement2, { content: 'x-second bar!' });

      assert.equal(componentElement1.parentElement, wrapper1, 'The first component should be attached to the target');
      assert.equal(componentElement2.parentElement, wrapper2, 'The second component should be attached to the target');

      this.runTask(function () {
        return _emberMetal.set(second, 'bar', 'BAR');
      });

      this.assertComponentElement(componentElement1, { content: 'x-first FOO!' });
      this.assertComponentElement(componentElement2, { content: 'x-second BAR!' });

      assert.equal(componentElement1.parentElement, wrapper1, 'The first component should be attached to the target');
      assert.equal(componentElement2.parentElement, wrapper2, 'The second component should be attached to the target');

      this.runTask(function () {
        _emberMetal.set(first, 'foo', 'foo');
        _emberMetal.set(second, 'bar', 'bar');
      });

      this.assertComponentElement(componentElement1, { content: 'x-first foo!' });
      this.assertComponentElement(componentElement2, { content: 'x-second bar!' });

      assert.equal(componentElement1.parentElement, wrapper1, 'The first component should be attached to the target');
      assert.equal(componentElement2.parentElement, wrapper2, 'The second component should be attached to the target');

      this.runTask(function () {
        first.destroy();
        second.destroy();
      });

      if (this.isHTMLBars) {
        // Bug in Glimmer – component should not have .element at this point
        assert.ok(!first.element, 'The first component should not have an element');
        assert.ok(!second.element, 'The second component should not have an element');
      }

      assert.ok(!componentElement1.parentElement, 'The first component element should be detached');
      assert.ok(!componentElement2.parentElement, 'The second component element should be detached');

      this.assert.equal(willDestroyCalled, 2);
    };

    AbstractAppendTest.prototype['@test can appendTo while rendering'] = function testCanAppendToWhileRendering(assert) {
      var _this6 = this;

      var owner = this.owner;

      var append = function (component) {
        return _this6.append(component);
      };

      var element1 = undefined,
          element2 = undefined;
      this.registerComponent('first-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          layout: _emberGlimmerTestsUtilsHelpers.compile('component-one'),

          didInsertElement: function () {
            element1 = this.element;
            var SecondComponent = owner._lookupFactory('component:second-component');

            append(SecondComponent.create());
          }
        })
      });

      this.registerComponent('second-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          layout: _emberGlimmerTestsUtilsHelpers.compile('component-two'),

          didInsertElement: function () {
            element2 = this.element;
          }
        })
      });

      var FirstComponent = this.owner._lookupFactory('component:first-component');

      this.runTask(function () {
        return append(FirstComponent.create());
      });

      this.assertComponentElement(element1, { content: 'component-one' });
      this.assertComponentElement(element2, { content: 'component-two' });
    };

    AbstractAppendTest.prototype['@test can appendTo and remove while rendering'] = function testCanAppendToAndRemoveWhileRendering(assert) {
      var _this7 = this;

      var owner = this.owner;

      var append = function (component) {
        return _this7.append(component);
      };

      var element1 = undefined,
          element2 = undefined,
          element3 = undefined,
          element4 = undefined,
          component1 = undefined,
          component2 = undefined;
      this.registerComponent('foo-bar', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          layout: _emberGlimmerTestsUtilsHelpers.compile('foo-bar'),

          init: function () {
            this._super.apply(this, arguments);
            component1 = this;
          },

          didInsertElement: function () {
            element1 = this.element;
            var OtherRoot = owner._lookupFactory('component:other-root');

            this._instance = OtherRoot.create({
              didInsertElement: function () {
                element2 = this.element;
              }
            });

            append(this._instance);
          },

          willDestroy: function () {
            this._instance.destroy();
          }
        })
      });

      this.registerComponent('baz-qux', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          layout: _emberGlimmerTestsUtilsHelpers.compile('baz-qux'),

          init: function () {
            this._super.apply(this, arguments);
            component2 = this;
          },

          didInsertElement: function () {
            element3 = this.element;
            var OtherRoot = owner._lookupFactory('component:other-root');

            this._instance = OtherRoot.create({
              didInsertElement: function () {
                element4 = this.element;
              }
            });

            append(this._instance);
          },

          willDestroy: function () {
            this._instance.destroy();
          }
        })
      });

      var instantiatedRoots = 0;
      var destroyedRoots = 0;
      this.registerComponent('other-root', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          layout: _emberGlimmerTestsUtilsHelpers.compile('fake-thing: {{counter}}'),
          init: function () {
            this._super.apply(this, arguments);
            this.counter = instantiatedRoots++;
          },
          willDestroy: function () {
            destroyedRoots++;
            this._super.apply(this, arguments);
          }
        })
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject), { showFooBar: true });

      this.assertComponentElement(element1, {});
      this.assertComponentElement(element2, { content: 'fake-thing: 0' });
      assert.equal(instantiatedRoots, 1);

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(_this7.context, 'showFooBar', false);
      });

      assert.equal(instantiatedRoots, 2);
      assert.equal(destroyedRoots, 1);

      this.assertComponentElement(element3, {});
      this.assertComponentElement(element4, { content: 'fake-thing: 1' });

      this.runTask(function () {
        component1.destroy();
        component2.destroy();
      });

      assert.equal(instantiatedRoots, 2);
      assert.equal(destroyedRoots, 2);
    };

    return AbstractAppendTest;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest);

  _emberGlimmerTestsUtilsTestCase.moduleFor('append: no arguments (attaching to document.body)', (function (_AbstractAppendTest) {
babelHelpers.inherits(_class, _AbstractAppendTest);

    function _class() {
      _AbstractAppendTest.apply(this, arguments);
    }

    _class.prototype.append = function append(component) {
      this.runTask(function () {
        return component.append();
      });
      this.didAppend(component);
      return document.body;
    };

    return _class;
  })(AbstractAppendTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('appendTo: a selector', (function (_AbstractAppendTest2) {
babelHelpers.inherits(_class2, _AbstractAppendTest2);

    function _class2() {
      _AbstractAppendTest2.apply(this, arguments);
    }

    _class2.prototype.append = function append(component) {
      this.runTask(function () {
        return component.appendTo('#qunit-fixture');
      });
      this.didAppend(component);
      return _emberViews.jQuery('#qunit-fixture')[0];
    };

    _class2.prototype['@test raises an assertion when the target does not exist in the DOM'] = function testRaisesAnAssertionWhenTheTargetDoesNotExistInTheDOM(assert) {
      var _this8 = this;

      this.registerComponent('foo-bar', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          layoutName: 'components/foo-bar'
        }),
        template: 'FOO BAR!'
      });

      var FooBar = this.owner._lookupFactory('component:foo-bar');

      this.component = FooBar.create();

      assert.ok(!this.component.element, 'precond - should not have an element');

      this.runTask(function () {
        expectAssertion(function () {
          _this8.component.appendTo('#does-not-exist-in-dom');
        }, /You tried to append to \(#does-not-exist-in-dom\) but that isn't in the DOM/);
      });

      assert.ok(!this.component.element, 'component should not have an element');
    };

    return _class2;
  })(AbstractAppendTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('appendTo: an element', (function (_AbstractAppendTest3) {
babelHelpers.inherits(_class3, _AbstractAppendTest3);

    function _class3() {
      _AbstractAppendTest3.apply(this, arguments);
    }

    _class3.prototype.append = function append(component) {
      var element = _emberViews.jQuery('#qunit-fixture')[0];
      this.runTask(function () {
        return component.appendTo(element);
      });
      this.didAppend(component);
      return element;
    };

    return _class3;
  })(AbstractAppendTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('appendTo: with multiple components', (function (_AbstractAppendTest4) {
babelHelpers.inherits(_class4, _AbstractAppendTest4);

    function _class4() {
      _AbstractAppendTest4.apply(this, arguments);
    }

    _class4.prototype.append = function append(component) {
      this.runTask(function () {
        return component.appendTo('#qunit-fixture');
      });
      this.didAppend(component);
      return _emberViews.jQuery('#qunit-fixture')[0];
    };

    return _class4;
  })(AbstractAppendTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('renderToElement: no arguments (defaults to a body context)', (function (_AbstractAppendTest5) {
babelHelpers.inherits(_class5, _AbstractAppendTest5);

    function _class5() {
      _AbstractAppendTest5.apply(this, arguments);
    }

    _class5.prototype.append = function append(component) {
      expectDeprecation(/Using the `renderToElement` is deprecated in favor of `appendTo`. Called in/);
      var wrapper = undefined;

      this.runTask(function () {
        return wrapper = component.renderToElement();
      });
      this.didAppend(component);

      this.assert.equal(wrapper.tagName, 'BODY', 'wrapper is a body element');
      this.assert.notEqual(wrapper, document.body, 'wrapper is not document.body');
      this.assert.ok(!wrapper.parentNode, 'wrapper is detached');

      return wrapper;
    };

    return _class5;
  })(AbstractAppendTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('renderToElement: a div', (function (_AbstractAppendTest6) {
babelHelpers.inherits(_class6, _AbstractAppendTest6);

    function _class6() {
      _AbstractAppendTest6.apply(this, arguments);
    }

    _class6.prototype.append = function append(component) {
      expectDeprecation(/Using the `renderToElement` is deprecated in favor of `appendTo`. Called in/);
      var wrapper = undefined;

      this.runTask(function () {
        return wrapper = component.renderToElement('div');
      });
      this.didAppend(component);

      this.assert.equal(wrapper.tagName, 'DIV', 'wrapper is a body element');
      this.assert.ok(!wrapper.parentNode, 'wrapper is detached');

      return wrapper;
    };

    return _class6;
  })(AbstractAppendTest));
});
enifed('ember-glimmer/tests/integration/components/attribute-bindings-test', ['exports', 'ember-glimmer/tests/utils/test-case', 'ember-glimmer/tests/utils/helpers', 'ember-glimmer/tests/utils/abstract-test-case', 'ember-metal'], function (exports, _emberGlimmerTestsUtilsTestCase, _emberGlimmerTestsUtilsHelpers, _emberGlimmerTestsUtilsAbstractTestCase, _emberMetal) {
  'use strict';

  var _templateObject = babelHelpers.taggedTemplateLiteralLoose(['\n      {{foo-bar hasFoo=true foo=foo hasBar=false bar=bar}}\n      {{foo-bar hasFoo=false foo=foo hasBar=true bar=bar}}\n      {{foo-bar hasFoo=true foo=foo hasBar=true bar=bar}}\n      {{foo-bar hasFoo=false foo=foo hasBar=false bar=bar}}\n    '], ['\n      {{foo-bar hasFoo=true foo=foo hasBar=false bar=bar}}\n      {{foo-bar hasFoo=false foo=foo hasBar=true bar=bar}}\n      {{foo-bar hasFoo=true foo=foo hasBar=true bar=bar}}\n      {{foo-bar hasFoo=false foo=foo hasBar=false bar=bar}}\n    ']);

  _emberGlimmerTestsUtilsTestCase.moduleFor('Attribute bindings integration', (function (_RenderingTest) {
babelHelpers.inherits(_class, _RenderingTest);

    function _class() {
      _RenderingTest.apply(this, arguments);
    }

    _class.prototype['@test it can have attribute bindings'] = function testItCanHaveAttributeBindings() {
      var _this = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        attributeBindings: ['foo:data-foo', 'bar:data-bar']
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{foo-bar foo=foo bar=bar}}', { foo: 'foo', bar: 'bar' });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'data-foo': 'foo', 'data-bar': 'bar' }, content: 'hello' });

      this.runTask(function () {
        return _this.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'data-foo': 'foo', 'data-bar': 'bar' }, content: 'hello' });

      this.runTask(function () {
        _emberMetal.set(_this.context, 'foo', 'FOO');
        _emberMetal.set(_this.context, 'bar', undefined);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'data-foo': 'FOO' }, content: 'hello' });

      this.runTask(function () {
        _emberMetal.set(_this.context, 'foo', 'foo');
        _emberMetal.set(_this.context, 'bar', 'bar');
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'data-foo': 'foo', 'data-bar': 'bar' }, content: 'hello' });
    };

    _class.prototype['@test it can have attribute bindings with attrs'] = function testItCanHaveAttributeBindingsWithAttrs() {
      var _this2 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        attributeBindings: ['attrs.foo:data-foo', 'attrs.baz.bar:data-bar']
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{foo-bar foo=model.foo baz=model.baz}}', {
        model: { foo: undefined, baz: { bar: 'bar' } }
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'data-bar': 'bar' } });

      this.runTask(function () {
        return _this2.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'data-bar': 'bar' } });

      this.runTask(function () {
        _emberMetal.set(_this2.context, 'model.foo', 'foo');
        _emberMetal.set(_this2.context, 'model.baz.bar', undefined);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'data-foo': 'foo' }, content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this2.context, 'model', {
          foo: undefined, baz: { bar: 'bar' }
        });
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'data-bar': 'bar' } });
    };

    _class.prototype['@test it can have attribute bindings with a nested path'] = function testItCanHaveAttributeBindingsWithANestedPath() {
      var _this3 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        attributeBindings: ['foo.bar:data-foo-bar']
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{foo-bar foo=foo}}', { foo: { bar: 'foo-bar' } });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'data-foo-bar': 'foo-bar' }, content: 'hello' });

      this.runTask(function () {
        return _this3.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'data-foo-bar': 'foo-bar' }, content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this3.context, 'foo.bar', 'FOO-BAR');
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'data-foo-bar': 'FOO-BAR' }, content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this3.context, 'foo.bar', undefined);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: {}, content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this3.context, 'foo', undefined);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: {}, content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this3.context, 'foo', { bar: 'foo-bar' });
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'data-foo-bar': 'foo-bar' }, content: 'hello' });
    };

    _class.prototype['@test handles non-microsyntax attributeBindings'] = function testHandlesNonMicrosyntaxAttributeBindings() {
      var _this4 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        attributeBindings: ['type']
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{foo-bar type=submit}}', {
        submit: 'submit'
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { type: 'submit' }, content: 'hello' });

      this.runTask(function () {
        return _this4.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { type: 'submit' }, content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this4.context, 'submit', 'password');
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { type: 'password' }, content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this4.context, 'submit', null);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: {}, content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this4.context, 'submit', 'submit');
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { type: 'submit' }, content: 'hello' });
    };

    _class.prototype['@test non-microsyntax attributeBindings cannot contain nested paths'] = function testNonMicrosyntaxAttributeBindingsCannotContainNestedPaths() {
      var _this5 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        attributeBindings: ['foo.bar']
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      expectAssertion(function () {
        _this5.render('{{foo-bar foo=foo}}', { foo: { bar: 'foo-bar' } });
      }, /Illegal attributeBinding: 'foo.bar' is not a valid attribute name./);
    };

    _class.prototype['@test normalizes attributeBindings for property names'] = function testNormalizesAttributeBindingsForPropertyNames() {
      var _this6 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        attributeBindings: ['tiTLe']
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{foo-bar tiTLe=name}}', {
        name: 'qux'
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { title: 'qux' }, content: 'hello' });

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(_this6.context, 'name', null);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: {}, content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this6.context, 'name', 'qux');
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { title: 'qux' }, content: 'hello' });
    };

    _class.prototype['@test normalizes attributeBindings for attribute names'] = function testNormalizesAttributeBindingsForAttributeNames() {
      var _this7 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        attributeBindings: ['foo:data-FOO']
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{foo-bar foo=foo}}', {
        foo: 'qux'
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'data-foo': 'qux' }, content: 'hello' });

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(_this7.context, 'foo', null);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: {}, content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this7.context, 'foo', 'qux');
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'data-foo': 'qux' }, content: 'hello' });
    };

    _class.prototype['@test attributeBindings handles null/undefined'] = function testAttributeBindingsHandlesNullUndefined() {
      var _this8 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        attributeBindings: ['fizz', 'bar']
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{foo-bar fizz=fizz bar=bar}}', {
        fizz: null,
        bar: undefined
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: {}, content: 'hello' });

      this.runTask(function () {
        return _this8.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: {}, content: 'hello' });

      this.runTask(function () {
        _emberMetal.set(_this8.context, 'fizz', 'fizz');
        _emberMetal.set(_this8.context, 'bar', 'bar');
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { fizz: 'fizz', bar: 'bar' }, content: 'hello' });

      this.runTask(function () {
        _emberMetal.set(_this8.context, 'fizz', null);
        _emberMetal.set(_this8.context, 'bar', undefined);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: {}, content: 'hello' });
    };

    _class.prototype['@test attributeBindings handles number value'] = function testAttributeBindingsHandlesNumberValue() {
      var _this9 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        attributeBindings: ['size']
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{foo-bar size=size}}', {
        size: 21
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { size: '21' }, content: 'hello' });

      this.runTask(function () {
        return _this9.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { size: '21' }, content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this9.context, 'size', 0);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { size: '0' }, content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this9.context, 'size', 21);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { size: '21' }, content: 'hello' });
    };

    _class.prototype['@test handles internal and external changes'] = function testHandlesInternalAndExternalChanges() {
      var _this10 = this;

      var component = undefined;
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        attributeBindings: ['type'],
        type: 'password',
        init: function () {
          this._super.apply(this, arguments);
          component = this;
        }
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{foo-bar}}');

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { type: 'password' }, content: 'hello' });

      this.runTask(function () {
        return _this10.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { type: 'password' }, content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(component, 'type', 'checkbox');
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { type: 'checkbox' }, content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(component, 'type', 'password');
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { type: 'password' }, content: 'hello' });
    };

    _class.prototype['@test can set attributeBindings on component with a different tagName'] = function testCanSetAttributeBindingsOnComponentWithADifferentTagName() {
      var _this11 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        tagName: 'input',
        attributeBindings: ['type', 'isDisabled:disabled']
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent });

      this.render('{{foo-bar type=type isDisabled=disabled}}', {
        type: 'password',
        disabled: false
      });

      this.assertComponentElement(this.firstChild, { tagName: 'input', attrs: { type: 'password' } });

      this.runTask(function () {
        return _this11.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'input', attrs: { type: 'password' } });

      this.runTask(function () {
        _emberMetal.set(_this11.context, 'type', 'checkbox');
        _emberMetal.set(_this11.context, 'disabled', true);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'input', attrs: { type: 'checkbox', disabled: '' } });

      this.runTask(function () {
        _emberMetal.set(_this11.context, 'type', 'password');
        _emberMetal.set(_this11.context, 'disabled', false);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'input', attrs: { type: 'password' } });
    };

    _class.prototype['@test should allow namespaced attributes in micro syntax'] = function testShouldAllowNamespacedAttributesInMicroSyntax() {
      var _this12 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        attributeBindings: ['xlinkHref:xlink:href']
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent });

      this.render('{{foo-bar type=type xlinkHref=xlinkHref}}', {
        xlinkHref: '/foo.png'
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'xlink:href': '/foo.png' } });

      this.runTask(function () {
        return _this12.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'xlink:href': '/foo.png' } });

      this.runTask(function () {
        return _emberMetal.set(_this12.context, 'xlinkHref', '/lol.png');
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'xlink:href': '/lol.png' } });

      this.runTask(function () {
        return _emberMetal.set(_this12.context, 'xlinkHref', '/foo.png');
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'xlink:href': '/foo.png' } });
    };

    // This comes into play when using the {{#each}} helper. If the
    // passed array item is a String, it will be converted into a
    // String object instead of a normal string.

    _class.prototype['@test should allow for String objects'] = function testShouldAllowForStringObjects() {
      var _this13 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        attributeBindings: ['foo']
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent });

      this.render('{{foo-bar foo=foo}}', {
        foo: (function () {
          return this;
        }).call('bar')
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'foo': 'bar' } });

      this.runTask(function () {
        return _this13.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'foo': 'bar' } });

      this.runTask(function () {
        return _emberMetal.set(_this13.context, 'foo', (function () {
          return this;
        }).call('baz'));
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'foo': 'baz' } });

      this.runTask(function () {
        return _emberMetal.set(_this13.context, 'foo', (function () {
          return this;
        }).call('bar'));
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'foo': 'bar' } });
    };

    _class.prototype['@test can set id initially via attributeBindings '] = function testCanSetIdInitiallyViaAttributeBindings() {
      var _this14 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        attributeBindings: ['specialSauce:id']
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent });

      this.render('{{foo-bar specialSauce=sauce}}', {
        sauce: 'special-sauce'
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'id': 'special-sauce' } });

      this.runTask(function () {
        return _this14.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'id': 'special-sauce' } });

      this.runTask(function () {
        return _emberMetal.set(_this14.context, 'sauce', 'foo');
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'id': 'special-sauce' } });

      this.runTask(function () {
        return _emberMetal.set(_this14.context, 'sauce', 'special-sauce');
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'id': 'special-sauce' } });
    };

    _class.prototype['@test attributeBindings are overwritten'] = function testAttributeBindingsAreOverwritten() {
      var _this15 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        attributeBindings: ['href'],
        href: 'a href'
      });

      var FizzBarComponent = FooBarComponent.extend({
        attributeBindings: ['newHref:href']
      });

      this.registerComponent('fizz-bar', { ComponentClass: FizzBarComponent });

      this.render('{{fizz-bar newHref=href}}', {
        href: 'dog.html'
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { href: 'dog.html' } });

      this.runTask(function () {
        return _this15.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { href: 'dog.html' } });

      this.runTask(function () {
        return _emberMetal.set(_this15.context, 'href', 'cat.html');
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { href: 'cat.html' } });
    };

    _class.prototype['@test it can set attribute bindings in the constructor'] = function testItCanSetAttributeBindingsInTheConstructor() {
      var _this16 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super();

          var bindings = [];

          if (this.get('hasFoo')) {
            bindings.push('foo:data-foo');
          }

          if (this.get('hasBar')) {
            bindings.push('bar:data-bar');
          }

          this.attributeBindings = bindings;
        }
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject), { foo: 'foo', bar: 'bar' });

      this.assertComponentElement(this.nthChild(0), { tagName: 'div', attrs: { 'data-foo': 'foo' }, content: 'hello' });
      this.assertComponentElement(this.nthChild(1), { tagName: 'div', attrs: { 'data-bar': 'bar' }, content: 'hello' });
      this.assertComponentElement(this.nthChild(2), { tagName: 'div', attrs: { 'data-foo': 'foo', 'data-bar': 'bar' }, content: 'hello' });
      this.assertComponentElement(this.nthChild(3), { tagName: 'div', attrs: {}, content: 'hello' });

      this.runTask(function () {
        return _this16.rerender();
      });

      this.assertComponentElement(this.nthChild(0), { tagName: 'div', attrs: { 'data-foo': 'foo' }, content: 'hello' });
      this.assertComponentElement(this.nthChild(1), { tagName: 'div', attrs: { 'data-bar': 'bar' }, content: 'hello' });
      this.assertComponentElement(this.nthChild(2), { tagName: 'div', attrs: { 'data-foo': 'foo', 'data-bar': 'bar' }, content: 'hello' });
      this.assertComponentElement(this.nthChild(3), { tagName: 'div', attrs: {}, content: 'hello' });

      this.runTask(function () {
        _emberMetal.set(_this16.context, 'foo', 'FOO');
        _emberMetal.set(_this16.context, 'bar', undefined);
      });

      this.assertComponentElement(this.nthChild(0), { tagName: 'div', attrs: { 'data-foo': 'FOO' }, content: 'hello' });
      this.assertComponentElement(this.nthChild(1), { tagName: 'div', attrs: {}, content: 'hello' });
      this.assertComponentElement(this.nthChild(2), { tagName: 'div', attrs: { 'data-foo': 'FOO' }, content: 'hello' });
      this.assertComponentElement(this.nthChild(3), { tagName: 'div', attrs: {}, content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this16.context, 'bar', 'BAR');
      });

      this.assertComponentElement(this.nthChild(0), { tagName: 'div', attrs: { 'data-foo': 'FOO' }, content: 'hello' });
      this.assertComponentElement(this.nthChild(1), { tagName: 'div', attrs: { 'data-bar': 'BAR' }, content: 'hello' });
      this.assertComponentElement(this.nthChild(2), { tagName: 'div', attrs: { 'data-foo': 'FOO', 'data-bar': 'BAR' }, content: 'hello' });
      this.assertComponentElement(this.nthChild(3), { tagName: 'div', attrs: {}, content: 'hello' });

      this.runTask(function () {
        _emberMetal.set(_this16.context, 'foo', 'foo');
        _emberMetal.set(_this16.context, 'bar', 'bar');
      });

      this.assertComponentElement(this.nthChild(0), { tagName: 'div', attrs: { 'data-foo': 'foo' }, content: 'hello' });
      this.assertComponentElement(this.nthChild(1), { tagName: 'div', attrs: { 'data-bar': 'bar' }, content: 'hello' });
      this.assertComponentElement(this.nthChild(2), { tagName: 'div', attrs: { 'data-foo': 'foo', 'data-bar': 'bar' }, content: 'hello' });
      this.assertComponentElement(this.nthChild(3), { tagName: 'div', attrs: {}, content: 'hello' });
    };

    _class.prototype['@test it should not allow attributeBindings to be set'] = function testItShouldNotAllowAttributeBindingsToBeSet() {
      var _this17 = this;

      this.registerComponent('foo-bar', { template: 'hello' });

      expectAssertion(function () {
        _this17.render('{{foo-bar attributeBindings="one two"}}');
      }, /Setting 'attributeBindings' via template helpers is not allowed/);
    };

    _class.prototype['@test asserts if an attributeBinding is setup on class'] = function testAssertsIfAnAttributeBindingIsSetupOnClass() {
      var _this18 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        attributeBindings: ['class']
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      expectAssertion(function () {
        _this18.render('{{foo-bar}}');
      }, /You cannot use class as an attributeBinding, use classNameBindings instead./i);
    };

    _class.prototype['@test blacklists href bindings based on protocol'] = function testBlacklistsHrefBindingsBasedOnProtocol() {
      /* jshint scripturl:true */

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        tagName: 'a',
        attributeBindings: ['href']
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{foo-bar href=xss}}', {
        xss: 'javascript:alert(\'foo\')'
      });

      this.assertComponentElement(this.firstChild, { tagName: 'a', attrs: { href: 'unsafe:javascript:alert(\'foo\')' } });
    };

    _class.prototype['@test it can bind the role attribute (issue #14007)'] = function testItCanBindTheRoleAttributeIssue14007() {
      var _this19 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({ attributeBindings: ['role'] });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{foo-bar role=role}}', { role: 'button' });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { role: 'button' } });

      this.runTask(function () {
        return _this19.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { role: 'button' } });

      this.runTask(function () {
        return _emberMetal.set(_this19.context, 'role', 'combobox');
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { role: 'combobox' } });

      this.runTask(function () {
        return _emberMetal.set(_this19.context, 'role', null);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div' });
    };

    _class.prototype['@test component with an `id` attribute binding of undefined'] = function testComponentWithAnIdAttributeBindingOfUndefined() {
      this.registerComponent('foo-bar', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          attributeBindings: ['id'],

          id: undefined
        })
      });

      this.registerComponent('baz-qux', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          attributeBindings: ['somethingUndefined:id'],

          somethingUndefined: undefined
        })
      });
      this.render('{{foo-bar}}{{baz-qux}}');

      this.assertComponentElement(this.nthChild(0), { content: '' });
      this.assertComponentElement(this.nthChild(1), { content: '' });

      this.assert.ok(this.nthChild(0).id.match(/ember\d+/), 'a valid `id` was used');
      this.assert.ok(this.nthChild(1).id.match(/ember\d+/), 'a valid `id` was used');
    };

    _class.prototype['@test component with an `id` attribute binding of null'] = function testComponentWithAnIdAttributeBindingOfNull() {
      this.registerComponent('foo-bar', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          attributeBindings: ['id'],

          id: null
        })
      });

      this.registerComponent('baz-qux', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          attributeBindings: ['somethingNull:id'],

          somethingNull: null
        })
      });
      this.render('{{foo-bar}}{{baz-qux}}');

      this.assertComponentElement(this.nthChild(0), { content: '' });
      this.assertComponentElement(this.nthChild(1), { content: '' });

      this.assert.ok(this.nthChild(0).id.match(/ember\d+/), 'a valid `id` was used');
      this.assert.ok(this.nthChild(1).id.match(/ember\d+/), 'a valid `id` was used');
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
});
enifed('ember-glimmer/tests/integration/components/attrs-lookup-test', ['exports', 'ember-glimmer/tests/utils/test-case', 'ember-glimmer/tests/utils/helpers', 'ember-metal', 'ember-glimmer/tests/utils/test-helpers'], function (exports, _emberGlimmerTestsUtilsTestCase, _emberGlimmerTestsUtilsHelpers, _emberMetal, _emberGlimmerTestsUtilsTestHelpers) {
  'use strict';

  _emberGlimmerTestsUtilsTestCase.moduleFor('Components test: attrs lookup', (function (_RenderingTest) {
    babelHelpers.inherits(_class, _RenderingTest);

    function _class() {
      _RenderingTest.apply(this, arguments);
    }

    _class.prototype['@test it should be able to lookup attrs without `attrs.` - template access'] = function testItShouldBeAbleToLookupAttrsWithoutAttrsTemplateAccess() {
      var _this = this;

      this.registerComponent('foo-bar', { template: '{{first}}' });

      this.render('{{foo-bar first=firstAttr}}', {
        firstAttr: 'first attr'
      });

      this.assertText('first attr');

      this.runTask(function () {
        return _this.rerender();
      });

      this.assertText('first attr');

      this.runTask(function () {
        return _emberMetal.set(_this.context, 'firstAttr', 'second attr');
      });

      this.assertText('second attr');

      this.runTask(function () {
        return _emberMetal.set(_this.context, 'firstAttr', 'first attr');
      });

      this.assertText('first attr');
    };

    _class.prototype['@test it should be able to lookup attrs without `attrs.` - component access'] = function testItShouldBeAbleToLookupAttrsWithoutAttrsComponentAccess(assert) {
      var _this2 = this;

      var instance = undefined;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          instance = this;
        }
      });
      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: '{{first}}' });

      this.render('{{foo-bar first=firstAttr}}', {
        firstAttr: 'first attr'
      });

      assert.equal(instance.get('first'), 'first attr');

      this.runTask(function () {
        return _this2.rerender();
      });

      assert.equal(instance.get('first'), 'first attr');

      this.runTask(function () {
        return _emberMetal.set(_this2.context, 'firstAttr', 'second attr');
      });

      assert.equal(instance.get('first'), 'second attr');

      this.runTask(function () {
        return _emberMetal.set(_this2.context, 'firstAttr', 'first attr');
      });

      this.assertText('first attr');
    };

    _class.prototype['@test should be able to modify a provided attr into local state #11571 / #11559'] = function testShouldBeAbleToModifyAProvidedAttrIntoLocalState1157111559(assert) {
      var _this3 = this;

      var instance = undefined;
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          instance = this;
        },

        didReceiveAttrs: function () {
          this.set('first', this.get('first').toUpperCase());
        }
      });
      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: '{{first}}' });

      this.render('{{foo-bar first="first attr"}}');

      assert.equal(instance.get('first'), 'FIRST ATTR', 'component lookup uses local state');
      this.assertText('FIRST ATTR');

      this.runTask(function () {
        return _this3.rerender();
      });

      assert.equal(instance.get('first'), 'FIRST ATTR', 'component lookup uses local state during rerender');
      this.assertText('FIRST ATTR');

      // This is testing that passing string literals for use as initial values,
      // so there is no update step
    };

    _class.prototype['@test should be able to access unspecified attr #12035'] = function testShouldBeAbleToAccessUnspecifiedAttr12035(assert) {
      var _this4 = this;

      var instance = undefined;
      var wootVal = 'yes';

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          instance = this;
        },

        didReceiveAttrs: function () {
          assert.equal(this.get('woot'), wootVal, 'found attr in didReceiveAttrs');
        }
      });
      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent });

      this.render('{{foo-bar woot=woot}}', {
        woot: wootVal
      });

      assert.equal(instance.get('woot'), 'yes', 'component found attr');

      this.runTask(function () {
        return _this4.rerender();
      });

      assert.equal(instance.get('woot'), 'yes', 'component found attr after rerender');

      this.runTask(function () {
        wootVal = 'nope';
        _emberMetal.set(_this4.context, 'woot', wootVal);
      });

      assert.equal(instance.get('woot'), 'nope', 'component found attr after attr change');

      this.runTask(function () {
        wootVal = 'yes';
        _emberMetal.set(_this4.context, 'woot', wootVal);
      });

      assert.equal(instance.get('woot'), 'yes', 'component found attr after reset');
    };

    _class.prototype['@test getAttr() should return the same value as get()'] = function testGetAttrShouldReturnTheSameValueAsGet(assert) {
      var _this5 = this;

      assert.expect(33);

      var instance = undefined;
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          instance = this;
        },

        didReceiveAttrs: function () {
          var rootFirstPositional = this.get('firstPositional');
          var rootFirst = this.get('first');
          var rootSecond = this.get('second');
          var attrFirstPositional = this.getAttr('firstPositional');
          var attrFirst = this.getAttr('first');
          var attrSecond = this.getAttr('second');

          equal(rootFirstPositional, attrFirstPositional, 'root property matches attrs value');
          equal(rootFirst, attrFirst, 'root property matches attrs value');
          equal(rootSecond, attrSecond, 'root property matches attrs value');
        }
      });

      FooBarComponent.reopenClass({
        positionalParams: ['firstPositional']
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent });

      this.render('{{foo-bar firstPositional first=first second=second}}', {
        firstPositional: 'firstPositional',
        first: 'first',
        second: 'second'
      });

      assert.equal(instance.get('firstPositional'), 'firstPositional', 'matches known value');
      assert.equal(instance.get('first'), 'first', 'matches known value');
      assert.equal(instance.get('second'), 'second', 'matches known value');

      this.runTask(function () {
        return _this5.rerender();
      });

      assert.equal(instance.get('firstPositional'), 'firstPositional', 'matches known value');
      assert.equal(instance.get('first'), 'first', 'matches known value');
      assert.equal(instance.get('second'), 'second', 'matches known value');

      this.runTask(function () {
        _emberMetal.set(_this5.context, 'first', 'third');
      });

      assert.equal(instance.get('firstPositional'), 'firstPositional', 'matches known value');
      assert.equal(instance.get('first'), 'third', 'matches known value');
      assert.equal(instance.get('second'), 'second', 'matches known value');

      this.runTask(function () {
        _emberMetal.set(_this5.context, 'second', 'fourth');
      });

      assert.equal(instance.get('firstPositional'), 'firstPositional', 'matches known value');
      assert.equal(instance.get('first'), 'third', 'matches known value');
      assert.equal(instance.get('second'), 'fourth', 'matches known value');

      this.runTask(function () {
        _emberMetal.set(_this5.context, 'firstPositional', 'fifth');
      });

      assert.equal(instance.get('firstPositional'), 'fifth', 'matches known value');
      assert.equal(instance.get('first'), 'third', 'matches known value');
      assert.equal(instance.get('second'), 'fourth', 'matches known value');

      this.runTask(function () {
        _emberMetal.set(_this5.context, 'firstPositional', 'firstPositional');
        _emberMetal.set(_this5.context, 'first', 'first');
        _emberMetal.set(_this5.context, 'second', 'second');
      });

      assert.equal(instance.get('firstPositional'), 'firstPositional', 'matches known value');
      assert.equal(instance.get('first'), 'first', 'matches known value');
      assert.equal(instance.get('second'), 'second', 'matches known value');
    };

    _class.prototype['@test bound computed properties can be overriden in extensions, set during init, and passed in as attrs'] = function testBoundComputedPropertiesCanBeOverridenInExtensionsSetDuringInitAndPassedInAsAttrs() {
      var FooClass = _emberGlimmerTestsUtilsHelpers.Component.extend({
        attributeBindings: ['style'],
        style: _emberMetal.computed('height', 'color', function () {
          var height = this.get('height');
          var color = this.get('color');
          return 'height: ' + height + 'px; background-color: ' + color + ';';
        }),
        color: 'red',
        height: 20
      });

      var BarClass = FooClass.extend({
        init: function () {
          this._super.apply(this, arguments);
          this.height = 150;
        },
        color: 'yellow'
      });

      this.registerComponent('x-foo', { ComponentClass: FooClass });
      this.registerComponent('x-bar', { ComponentClass: BarClass });

      this.render('{{x-foo}}{{x-bar}}{{x-bar color="green"}}');

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { style: _emberGlimmerTestsUtilsTestHelpers.styles('height: 20px; background-color: red;') } });
      this.assertComponentElement(this.nthChild(1), { tagName: 'div', attrs: { style: _emberGlimmerTestsUtilsTestHelpers.styles('height: 150px; background-color: yellow;') } });
      this.assertComponentElement(this.nthChild(2), { tagName: 'div', attrs: { style: _emberGlimmerTestsUtilsTestHelpers.styles('height: 150px; background-color: green;') } });

      this.assertStableRerender();

      // No U-R
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
});
enifed('ember-glimmer/tests/integration/components/class-bindings-test', ['exports', 'ember-glimmer/tests/utils/test-case', 'ember-glimmer/tests/utils/helpers', 'ember-glimmer/tests/utils/test-helpers', 'ember-metal', 'ember-glimmer/tests/utils/abstract-test-case'], function (exports, _emberGlimmerTestsUtilsTestCase, _emberGlimmerTestsUtilsHelpers, _emberGlimmerTestsUtilsTestHelpers, _emberMetal, _emberGlimmerTestsUtilsAbstractTestCase) {
  'use strict';

  var _templateObject = babelHelpers.taggedTemplateLiteralLoose(['\n      {{foo-bar foo=foo bindIsEnabled=true isEnabled=isEnabled bindIsHappy=false isHappy=isHappy}}\n      {{foo-bar foo=foo bindIsEnabled=false isEnabled=isEnabled bindIsHappy=true isHappy=isHappy}}\n      {{foo-bar foo=foo bindIsEnabled=true isEnabled=isEnabled bindIsHappy=true isHappy=isHappy}}\n      {{foo-bar foo=foo bindIsEnabled=false isEnabled=isEnabled bindIsHappy=false isHappy=isHappy}}\n    '], ['\n      {{foo-bar foo=foo bindIsEnabled=true isEnabled=isEnabled bindIsHappy=false isHappy=isHappy}}\n      {{foo-bar foo=foo bindIsEnabled=false isEnabled=isEnabled bindIsHappy=true isHappy=isHappy}}\n      {{foo-bar foo=foo bindIsEnabled=true isEnabled=isEnabled bindIsHappy=true isHappy=isHappy}}\n      {{foo-bar foo=foo bindIsEnabled=false isEnabled=isEnabled bindIsHappy=false isHappy=isHappy}}\n    ']);

  _emberGlimmerTestsUtilsTestCase.moduleFor('ClassNameBindings integration', (function (_RenderingTest) {
babelHelpers.inherits(_class, _RenderingTest);

    function _class() {
      _RenderingTest.apply(this, arguments);
    }

    _class.prototype['@test it can have class name bindings on the class definition'] = function testItCanHaveClassNameBindingsOnTheClassDefinition() {
      var _this = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        classNameBindings: ['foo', 'isEnabled:enabled', 'isHappy:happy:sad']
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{foo-bar foo=foo isEnabled=isEnabled isHappy=isHappy}}', { foo: 'foo', isEnabled: true, isHappy: false });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo enabled sad') }, content: 'hello' });

      this.runTask(function () {
        return _this.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo enabled sad') }, content: 'hello' });

      this.runTask(function () {
        _emberMetal.set(_this.context, 'foo', 'FOO');
        _emberMetal.set(_this.context, 'isEnabled', false);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view FOO sad') }, content: 'hello' });

      this.runTask(function () {
        _emberMetal.set(_this.context, 'foo', undefined);
        _emberMetal.set(_this.context, 'isHappy', true);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view happy') }, content: 'hello' });

      this.runTask(function () {
        _emberMetal.set(_this.context, 'foo', 'foo');
        _emberMetal.set(_this.context, 'isEnabled', true);
        _emberMetal.set(_this.context, 'isHappy', false);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo enabled sad') }, content: 'hello' });
    };

    _class.prototype['@test attrs in classNameBindings'] = function testAttrsInClassNameBindings() {
      var _this2 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        classNameBindings: ['attrs.joker:purple:green', 'attrs.batman.robin:black:red']
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{foo-bar joker=model.wat batman=model.super}}', {
        model: { wat: false, super: { robin: true } }
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view green black') }, content: 'hello' });

      this.runTask(function () {
        return _this2.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view green black') }, content: 'hello' });

      this.runTask(function () {
        _emberMetal.set(_this2.context, 'model.wat', true);
        _emberMetal.set(_this2.context, 'model.super.robin', false);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view purple red') }, content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this2.context, 'model', {
          wat: false, super: { robin: true }
        });
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view green black') }, content: 'hello' });
    };

    _class.prototype['@test it can have class name bindings in the template'] = function testItCanHaveClassNameBindingsInTheTemplate() {
      var _this3 = this;

      this.registerComponent('foo-bar', { template: 'hello' });

      this.render('{{foo-bar classNameBindings="model.someInitiallyTrueProperty model.someInitiallyFalseProperty model.someInitiallyUndefinedProperty :static model.isBig:big model.isOpen:open:closed model.isUp::down model.bar:isTruthy:isFalsy"}}', {
        model: {
          someInitiallyTrueProperty: true,
          someInitiallyFalseProperty: false,
          isBig: true,
          isOpen: false,
          isUp: true,
          bar: true
        }
      });

      this.assertComponentElement(this.firstChild, {
        attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view some-initially-true-property static big closed isTruthy') },
        content: 'hello'
      });

      this.runTask(function () {
        return _this3.rerender();
      });

      this.assertComponentElement(this.firstChild, {
        attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view some-initially-true-property static big closed isTruthy') },
        content: 'hello'
      });

      this.runTask(function () {
        _emberMetal.set(_this3.context, 'model.someInitiallyTrueProperty', false);
        _emberMetal.set(_this3.context, 'model.someInitiallyFalseProperty', true);
        _emberMetal.set(_this3.context, 'model.someInitiallyUndefinedProperty', true);
        _emberMetal.set(_this3.context, 'model.isBig', false);
        _emberMetal.set(_this3.context, 'model.isOpen', true);
        _emberMetal.set(_this3.context, 'model.isUp', false);
        _emberMetal.set(_this3.context, 'model.bar', false);
      });

      this.assertComponentElement(this.firstChild, {
        attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view some-initially-false-property some-initially-undefined-property static open down isFalsy') },
        content: 'hello'
      });

      this.runTask(function () {
        _emberMetal.set(_this3.context, 'model', {
          someInitiallyTrueProperty: true,
          someInitiallyFalseProperty: false,
          someInitiallyUndefinedProperty: undefined,
          isBig: true,
          isOpen: false,
          isUp: true,
          bar: true
        });
      });

      this.assertComponentElement(this.firstChild, {
        attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view some-initially-true-property static big closed isTruthy') },
        content: 'hello'
      });
    };

    _class.prototype['@test it can have class name bindings with nested paths'] = function testItCanHaveClassNameBindingsWithNestedPaths() {
      var _this4 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        classNameBindings: ['foo.bar', 'is.enabled:enabled', 'is.happy:happy:sad']
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{foo-bar foo=foo is=is}}', { foo: { bar: 'foo-bar' }, is: { enabled: true, happy: false } });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo-bar enabled sad') }, content: 'hello' });

      this.runTask(function () {
        return _this4.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo-bar enabled sad') }, content: 'hello' });

      this.runTask(function () {
        _emberMetal.set(_this4.context, 'foo.bar', 'FOO-BAR');
        _emberMetal.set(_this4.context, 'is.enabled', false);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view FOO-BAR sad') }, content: 'hello' });

      this.runTask(function () {
        _emberMetal.set(_this4.context, 'foo.bar', null);
        _emberMetal.set(_this4.context, 'is.happy', true);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view happy') }, content: 'hello' });

      this.runTask(function () {
        _emberMetal.set(_this4.context, 'foo', null);
        _emberMetal.set(_this4.context, 'is', null);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view sad') }, content: 'hello' });

      this.runTask(function () {
        _emberMetal.set(_this4.context, 'foo', { bar: 'foo-bar' });
        _emberMetal.set(_this4.context, 'is', { enabled: true, happy: false });
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo-bar enabled sad') }, content: 'hello' });
    };

    _class.prototype['@test it should dasherize the path when the it resolves to true'] = function testItShouldDasherizeThePathWhenTheItResolvesToTrue() {
      var _this5 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        classNameBindings: ['fooBar', 'nested.fooBarBaz']
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{foo-bar fooBar=fooBar nested=nested}}', { fooBar: true, nested: { fooBarBaz: false } });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo-bar') }, content: 'hello' });

      this.runTask(function () {
        return _this5.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo-bar') }, content: 'hello' });

      this.runTask(function () {
        _emberMetal.set(_this5.context, 'fooBar', false);
        _emberMetal.set(_this5.context, 'nested.fooBarBaz', true);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo-bar-baz') }, content: 'hello' });

      this.runTask(function () {
        _emberMetal.set(_this5.context, 'fooBar', 'FOO-BAR');
        _emberMetal.set(_this5.context, 'nested.fooBarBaz', null);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view FOO-BAR') }, content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this5.context, 'nested', null);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view FOO-BAR') }, content: 'hello' });

      this.runTask(function () {
        _emberMetal.set(_this5.context, 'fooBar', true);
        _emberMetal.set(_this5.context, 'nested', { fooBarBaz: false });
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo-bar') }, content: 'hello' });
    };

    _class.prototype['@test const bindings can be set as attrs'] = function testConstBindingsCanBeSetAsAttrs() {
      var _this6 = this;

      this.registerComponent('foo-bar', { template: 'hello' });
      this.render('{{foo-bar classNameBindings="foo:enabled:disabled"}}', {
        foo: true
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view enabled') }, content: 'hello' });

      this.runTask(function () {
        return _this6.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view enabled') }, content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this6.context, 'foo', false);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view disabled') }, content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this6.context, 'foo', true);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view enabled') }, content: 'hello' });
    };

    _class.prototype['@test :: class name syntax works with an empty true class'] = function testClassNameSyntaxWorksWithAnEmptyTrueClass() {
      var _this7 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        classNameBindings: ['isEnabled::not-enabled']
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{foo-bar isEnabled=enabled}}', {
        enabled: false
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view not-enabled') }, content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this7.context, 'enabled', true);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view') }, content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this7.context, 'enabled', false);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view not-enabled') }, content: 'hello' });
    };

    _class.prototype['@test uses all provided static class names (issue #11193)'] = function testUsesAllProvidedStaticClassNamesIssue11193() {
      var _this8 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        classNameBindings: [':class-one', ':class-two']
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{foo-bar}}', {
        enabled: false
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view class-one class-two') }, content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this8.context, 'enabled', true);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view class-one class-two') }, content: 'hello' });
    };

    _class.prototype['@test Providing a binding with a space in it asserts'] = function testProvidingABindingWithASpaceInItAsserts() {
      var _this9 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        classNameBindings: 'i:think:i am:so:clever'
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      expectAssertion(function () {
        _this9.render('{{foo-bar}}');
      }, /classNameBindings must not have spaces in them/i);
    };

    _class.prototype['@test it can set class name bindings in the constructor'] = function testItCanSetClassNameBindingsInTheConstructor() {
      var _this10 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        classNameBindings: ['foo'],

        init: function () {
          this._super();

          var bindings = this.classNameBindings = this.classNameBindings.slice();

          if (this.get('bindIsEnabled')) {
            bindings.push('isEnabled:enabled');
          }

          if (this.get('bindIsHappy')) {
            bindings.push('isHappy:happy:sad');
          }
        }
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject), { foo: 'foo', isEnabled: true, isHappy: false });

      this.assertComponentElement(this.nthChild(0), { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo enabled') }, content: 'hello' });
      this.assertComponentElement(this.nthChild(1), { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo sad') }, content: 'hello' });
      this.assertComponentElement(this.nthChild(2), { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo enabled sad') }, content: 'hello' });
      this.assertComponentElement(this.nthChild(3), { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo') }, content: 'hello' });

      this.runTask(function () {
        return _this10.rerender();
      });

      this.assertComponentElement(this.nthChild(0), { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo enabled') }, content: 'hello' });
      this.assertComponentElement(this.nthChild(1), { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo sad') }, content: 'hello' });
      this.assertComponentElement(this.nthChild(2), { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo enabled sad') }, content: 'hello' });
      this.assertComponentElement(this.nthChild(3), { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo') }, content: 'hello' });

      this.runTask(function () {
        _emberMetal.set(_this10.context, 'foo', 'FOO');
        _emberMetal.set(_this10.context, 'isEnabled', false);
      });

      this.assertComponentElement(this.nthChild(0), { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view FOO') }, content: 'hello' });
      this.assertComponentElement(this.nthChild(1), { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view FOO sad') }, content: 'hello' });
      this.assertComponentElement(this.nthChild(2), { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view FOO sad') }, content: 'hello' });
      this.assertComponentElement(this.nthChild(3), { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view FOO') }, content: 'hello' });

      this.runTask(function () {
        _emberMetal.set(_this10.context, 'foo', undefined);
        _emberMetal.set(_this10.context, 'isHappy', true);
      });

      this.assertComponentElement(this.nthChild(0), { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view') }, content: 'hello' });
      this.assertComponentElement(this.nthChild(1), { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view happy') }, content: 'hello' });
      this.assertComponentElement(this.nthChild(2), { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view happy') }, content: 'hello' });
      this.assertComponentElement(this.nthChild(3), { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view') }, content: 'hello' });

      this.runTask(function () {
        _emberMetal.set(_this10.context, 'foo', 'foo');
        _emberMetal.set(_this10.context, 'isEnabled', true);
        _emberMetal.set(_this10.context, 'isHappy', false);
      });

      this.assertComponentElement(this.nthChild(0), { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo enabled') }, content: 'hello' });
      this.assertComponentElement(this.nthChild(1), { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo sad') }, content: 'hello' });
      this.assertComponentElement(this.nthChild(2), { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo enabled sad') }, content: 'hello' });
      this.assertComponentElement(this.nthChild(3), { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo') }, content: 'hello' });
    };

    _class.prototype['@test using a computed property for classNameBindings triggers an assertion'] = function testUsingAComputedPropertyForClassNameBindingsTriggersAnAssertion() {
      var _this11 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        classNameBindings: _emberMetal.computed(function () {
          return ['isHappy:happy:sad'];
        })
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      expectAssertion(function () {
        _this11.render('{{foo-bar}}');
      }, /Only arrays are allowed/);
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('ClassBinding integration', (function (_RenderingTest2) {
babelHelpers.inherits(_class2, _RenderingTest2);

    function _class2() {
      _RenderingTest2.apply(this, arguments);
    }

    _class2.prototype['@test it should apply classBinding without condition always'] = function testItShouldApplyClassBindingWithoutConditionAlways() {
      var _this12 = this;

      this.registerComponent('foo-bar', { template: 'hello' });

      this.render('{{foo-bar classBinding=":foo"}}');

      this.assertComponentElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('foo  ember-view') } });

      this.runTask(function () {
        return _this12.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('foo  ember-view') } });
    };

    _class2.prototype['@test it should merge classBinding with class'] = function testItShouldMergeClassBindingWithClass() {
      var _this13 = this;

      this.registerComponent('foo-bar', { template: 'hello' });

      this.render('{{foo-bar classBinding="birdman:respeck" class="myName"}}', { birdman: true });

      this.assertComponentElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('respeck myName ember-view') } });

      this.runTask(function () {
        return _this13.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('respeck myName ember-view') } });
    };

    _class2.prototype['@test it should apply classBinding with only truthy condition'] = function testItShouldApplyClassBindingWithOnlyTruthyCondition() {
      var _this14 = this;

      this.registerComponent('foo-bar', { template: 'hello' });

      this.render('{{foo-bar classBinding="myName:respeck"}}', { myName: true });

      this.assertComponentElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('respeck  ember-view') } });

      this.runTask(function () {
        return _this14.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('respeck  ember-view') } });
    };

    _class2.prototype['@test it should apply classBinding with only falsy condition'] = function testItShouldApplyClassBindingWithOnlyFalsyCondition() {
      var _this15 = this;

      this.registerComponent('foo-bar', { template: 'hello' });

      this.render('{{foo-bar classBinding="myName::shade"}}', { myName: false });

      this.assertComponentElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('shade  ember-view') } });

      this.runTask(function () {
        return _this15.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('shade  ember-view') } });
    };

    _class2.prototype['@test it should apply nothing when classBinding is falsy but only supplies truthy class'] = function testItShouldApplyNothingWhenClassBindingIsFalsyButOnlySuppliesTruthyClass() {
      var _this16 = this;

      this.registerComponent('foo-bar', { template: 'hello' });

      this.render('{{foo-bar classBinding="myName:respeck"}}', { myName: false });

      this.assertComponentElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view') } });

      this.runTask(function () {
        return _this16.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view') } });
    };

    _class2.prototype['@test it should apply nothing when classBinding is truthy but only supplies falsy class'] = function testItShouldApplyNothingWhenClassBindingIsTruthyButOnlySuppliesFalsyClass() {
      var _this17 = this;

      this.registerComponent('foo-bar', { template: 'hello' });

      this.render('{{foo-bar classBinding="myName::shade"}}', { myName: true });

      this.assertComponentElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view') } });

      this.runTask(function () {
        return _this17.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view') } });
    };

    _class2.prototype['@test it should apply classBinding with falsy condition'] = function testItShouldApplyClassBindingWithFalsyCondition() {
      var _this18 = this;

      this.registerComponent('foo-bar', { template: 'hello' });

      this.render('{{foo-bar classBinding="swag:fresh:scrub"}}', { swag: false });

      this.assertComponentElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('scrub  ember-view') } });

      this.runTask(function () {
        return _this18.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('scrub  ember-view') } });
    };

    _class2.prototype['@test it should apply classBinding with truthy condition'] = function testItShouldApplyClassBindingWithTruthyCondition() {
      var _this19 = this;

      this.registerComponent('foo-bar', { template: 'hello' });

      this.render('{{foo-bar classBinding="swag:fresh:scrub"}}', { swag: true });

      this.assertComponentElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('fresh  ember-view') } });

      this.runTask(function () {
        return _this19.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('fresh  ember-view') } });
    };

    return _class2;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
});
enifed('ember-glimmer/tests/integration/components/closure-components-test', ['exports', 'ember-utils', 'ember-glimmer/tests/utils/helpers', 'ember-glimmer/tests/utils/abstract-test-case', 'ember-glimmer/tests/utils/test-case', 'ember-metal', 'ember-runtime/system/native_array'], function (exports, _emberUtils, _emberGlimmerTestsUtilsHelpers, _emberGlimmerTestsUtilsAbstractTestCase, _emberGlimmerTestsUtilsTestCase, _emberMetal, _emberRuntimeSystemNative_array) {
  'use strict';

  var _templateObject = babelHelpers.taggedTemplateLiteralLoose(['\n      {{component (component "-looked-up") "Hodari" greeting="Hodi"}}'], ['\n      {{component (component "-looked-up") "Hodari" greeting="Hodi"}}']),
      _templateObject2 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{component (component "-looked-up" "Hodari" greeting="Hodi")\n                  greeting="Hola"}}'], ['\n      {{component (component "-looked-up" "Hodari" greeting="Hodi")\n                  greeting="Hola"}}']),
      _templateObject3 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#with (hash comp=(component "-looked-up" greeting=model.greeting)) as |my|}}\n        {{#my.comp}}{{/my.comp}}\n      {{/with}}'], ['\n      {{#with (hash comp=(component "-looked-up" greeting=model.greeting)) as |my|}}\n        {{#my.comp}}{{/my.comp}}\n      {{/with}}']),
      _templateObject4 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#with (component "-looked-up" greeting="Hola" name="Dolores" age=33) as |first|}}\n        {{#with (component first greeting="Hej" name="Sigmundur") as |second|}}\n          {{component second greeting=model.greeting}}\n        {{/with}}\n      {{/with}}'], ['\n      {{#with (component "-looked-up" greeting="Hola" name="Dolores" age=33) as |first|}}\n        {{#with (component first greeting="Hej" name="Sigmundur") as |second|}}\n          {{component second greeting=model.greeting}}\n        {{/with}}\n      {{/with}}']),
      _templateObject5 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#with (hash lookedup=(component "-looked-up")) as |object|}}\n        {{object.lookedup}}\n      {{/with}}'], ['\n      {{#with (hash lookedup=(component "-looked-up")) as |object|}}\n        {{object.lookedup}}\n      {{/with}}']),
      _templateObject6 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#with (hash lookedup=(component "-looked-up")) as |object|}}\n        {{object.lookedup expectedText=model.expectedText}}\n      {{/with}}'], ['\n      {{#with (hash lookedup=(component "-looked-up")) as |object|}}\n        {{object.lookedup expectedText=model.expectedText}}\n      {{/with}}']),
      _templateObject7 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#with (hash lookedup=(component "-looked-up" expectedText=model.expectedText)) as |object|}}\n        {{object.lookedup}}\n      {{/with}}'], ['\n      {{#with (hash lookedup=(component "-looked-up" expectedText=model.expectedText)) as |object|}}\n        {{object.lookedup}}\n      {{/with}}']),
      _templateObject8 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#with (hash lookedup=(component "-looked-up")) as |object|}}\n        {{object.lookedup model.expectedText "Hola"}}\n      {{/with}}'], ['\n      {{#with (hash lookedup=(component "-looked-up")) as |object|}}\n        {{object.lookedup model.expectedText "Hola"}}\n      {{/with}}']),
      _templateObject9 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#with (hash my-component=(component \'my-component\' first)) as |c|}}\n        {{c.my-component}}\n      {{/with}}'], ['\n      {{#with (hash my-component=(component \'my-component\' first)) as |c|}}\n        {{c.my-component}}\n      {{/with}}']),
      _templateObject10 = babelHelpers.taggedTemplateLiteralLoose(['\n        {{#my-component my-attr=myProp as |api|}}\n          {{api.my-nested-component}}\n        {{/my-component}}\n        <br>\n        <button onclick={{action \'changeValue\'}}>Change value</button>'], ['\n        {{#my-component my-attr=myProp as |api|}}\n          {{api.my-nested-component}}\n        {{/my-component}}\n        <br>\n        <button onclick={{action \'changeValue\'}}>Change value</button>']),
      _templateObject11 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#select-box as |sb|}}\n        {{sb.option label="Foo"}}\n        {{sb.option}}\n      {{/select-box}}'], ['\n      {{#select-box as |sb|}}\n        {{sb.option label="Foo"}}\n        {{sb.option}}\n      {{/select-box}}']),
      _templateObject12 = babelHelpers.taggedTemplateLiteralLoose(['\n        <button {{action (action (mut val) 10)}} class="my-button">\n          Change to 10\n        </button>'], ['\n        <button {{action (action (mut val) 10)}} class="my-button">\n          Change to 10\n        </button>']),
      _templateObject13 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{component (component "change-button" model.val2)}}\n      <span class="value">{{model.val2}}</span>'], ['\n      {{component (component "change-button" model.val2)}}\n      <span class="value">{{model.val2}}</span>']),
      _templateObject14 = babelHelpers.taggedTemplateLiteralLoose(['\n        message: {{message}}{{inner-component message=message}}\n        <button onclick={{action "change"}} />'], ['\n        message: {{message}}{{inner-component message=message}}\n        <button onclick={{action "change"}} />']),
      _templateObject15 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#with (hash ctxCmp=(component "my-comp" isOpen=isOpen)) as |thing|}}\n        {{#thing.ctxCmp}}This is a contextual component{{/thing.ctxCmp}}\n      {{/with}}\n    '], ['\n      {{#with (hash ctxCmp=(component "my-comp" isOpen=isOpen)) as |thing|}}\n        {{#thing.ctxCmp}}This is a contextual component{{/thing.ctxCmp}}\n      {{/with}}\n    ']),
      _templateObject16 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#with (hash ctxCmp=(component compName isOpen=isOpen)) as |thing|}}\n        {{#thing.ctxCmp}}This is a contextual component{{/thing.ctxCmp}}\n      {{/with}}\n    '], ['\n      {{#with (hash ctxCmp=(component compName isOpen=isOpen)) as |thing|}}\n        {{#thing.ctxCmp}}This is a contextual component{{/thing.ctxCmp}}\n      {{/with}}\n    ']),
      _templateObject17 = babelHelpers.taggedTemplateLiteralLoose(['\n          <button {{action (action (mut val) 10)}} class="my-button">\n            Change to 10\n          </button>'], ['\n          <button {{action (action (mut val) 10)}} class="my-button">\n            Change to 10\n          </button>']);

  _emberGlimmerTestsUtilsTestCase.moduleFor('Components test: closure components', (function (_RenderingTest) {
babelHelpers.inherits(_class, _RenderingTest);

    function _class() {
      _RenderingTest.apply(this, arguments);
    }

    _class.prototype['@test renders with component helper'] = function testRendersWithComponentHelper() {
      var _this = this;

      var expectedText = 'Hodi';

      this.registerComponent('-looked-up', {
        template: expectedText
      });

      this.render('{{component (component "-looked-up")}}');

      this.assertText(expectedText);

      this.runTask(function () {
        return _this.rerender();
      });

      this.assertText(expectedText);
    };

    _class.prototype['@test renders with component helper with invocation params, hash'] = function testRendersWithComponentHelperWithInvocationParamsHash() {
      var _this2 = this;

      this.registerComponent('-looked-up', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: ['name']
        }),
        template: '{{greeting}} {{name}}'
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject));

      this.assertText('Hodi Hodari');

      this.runTask(function () {
        return _this2.rerender();
      });

      this.assertText('Hodi Hodari');
    };

    _class.prototype['@test GH#13742 keeps nested rest positional parameters if rendered with no positional parameters'] = function testGH13742KeepsNestedRestPositionalParametersIfRenderedWithNoPositionalParameters() {
      var _this3 = this;

      this.registerComponent('-looked-up', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: 'params'
        }),
        template: '{{#each params as |p|}}{{p}}{{/each}}'
      });

      this.render('{{component (component "-looked-up" model.greeting model.name)}}', {
        model: {
          greeting: 'Gabon ',
          name: 'Zack'
        }
      });

      this.assertText('Gabon Zack');

      this.runTask(function () {
        return _this3.rerender();
      });

      this.assertText('Gabon Zack');

      this.runTask(function () {
        return _this3.context.set('model.greeting', 'Good morning ');
      });

      this.assertText('Good morning Zack');

      this.runTask(function () {
        return _this3.context.set('model.name', 'Matthew');
      });

      this.assertText('Good morning Matthew');

      this.runTask(function () {
        return _this3.context.set('model', { greeting: 'Gabon ', name: 'Zack' });
      });

      this.assertText('Gabon Zack');
    };

    // Take a look at this one. Seems to pass even when currying isn't implemented.

    _class.prototype['@test overwrites nested rest positional parameters if rendered with positional parameters'] = function testOverwritesNestedRestPositionalParametersIfRenderedWithPositionalParameters() {
      var _this4 = this;

      this.registerComponent('-looked-up', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: 'params'
        }),
        template: '{{#each params as |p|}}{{p}}{{/each}}'
      });

      this.render('{{component (component "-looked-up" model.greeting model.name) model.name model.greeting}}', {
        model: {
          greeting: 'Gabon ',
          name: 'Zack'
        }
      });

      this.assertText('ZackGabon ');

      this.runTask(function () {
        return _this4.rerender();
      });

      this.assertText('ZackGabon ');

      this.runTask(function () {
        return _this4.context.set('model.greeting', 'Good morning ');
      });

      this.assertText('ZackGood morning ');

      this.runTask(function () {
        return _this4.context.set('model.name', 'Matthew');
      });

      this.assertText('MatthewGood morning ');

      this.runTask(function () {
        return _this4.context.set('model', { greeting: 'Gabon ', name: 'Zack' });
      });

      this.assertText('ZackGabon ');
    };

    _class.prototype['@test GH#13742  keeps nested rest positional parameters if nested and rendered with no positional parameters'] = function testGH13742KeepsNestedRestPositionalParametersIfNestedAndRenderedWithNoPositionalParameters() {
      var _this5 = this;

      this.registerComponent('-looked-up', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: 'params'
        }),
        template: '{{#each params as |p|}}{{p}}{{/each}}'
      });

      this.render('{{component (component (component "-looked-up" model.greeting model.name))}}', {
        model: {
          greeting: 'Gabon ',
          name: 'Zack'
        }
      });

      this.assertText('Gabon Zack');

      this.runTask(function () {
        return _this5.rerender();
      });

      this.assertText('Gabon Zack');

      this.runTask(function () {
        return _this5.context.set('model.greeting', 'Good morning ');
      });

      this.assertText('Good morning Zack');

      this.runTask(function () {
        return _this5.context.set('model.name', 'Matthew');
      });

      this.assertText('Good morning Matthew');

      this.runTask(function () {
        return _this5.context.set('model', { greeting: 'Gabon ', name: 'Zack' });
      });

      this.assertText('Gabon Zack');
    };

    _class.prototype['@test overwrites nested rest positional parameters if nested with new pos params and rendered with no positional parameters'] = function testOverwritesNestedRestPositionalParametersIfNestedWithNewPosParamsAndRenderedWithNoPositionalParameters() {
      var _this6 = this;

      this.registerComponent('-looked-up', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: 'params'
        }),
        template: '{{#each params as |p|}}{{p}}{{/each}}'
      });

      this.render('{{component (component (component "-looked-up" model.greeting model.name) model.name model.greeting)}}', {
        model: {
          greeting: 'Gabon ',
          name: 'Zack'
        }
      });

      this.assertText('ZackGabon ');

      this.runTask(function () {
        return _this6.rerender();
      });

      this.assertText('ZackGabon ');

      this.runTask(function () {
        return _this6.context.set('model.greeting', 'Good morning ');
      });

      this.assertText('ZackGood morning ');

      this.runTask(function () {
        return _this6.context.set('model.name', 'Matthew');
      });

      this.assertText('MatthewGood morning ');

      this.runTask(function () {
        return _this6.context.set('model', { greeting: 'Gabon ', name: 'Zack' });
      });

      this.assertText('ZackGabon ');
    };

    _class.prototype['@test renders with component helper with curried params, hash'] = function testRendersWithComponentHelperWithCurriedParamsHash() {
      var _this7 = this;

      this.registerComponent('-looked-up', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: ['name']
        }),
        template: '{{greeting}} {{name}}'
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject2));

      this.assertText('Hola Hodari');

      this.runTask(function () {
        return _this7.rerender();
      });

      this.assertText('Hola Hodari');
    };

    _class.prototype['@test updates when component path is bound'] = function testUpdatesWhenComponentPathIsBound() {
      var _this8 = this;

      this.registerComponent('-mandarin', {
        template: 'ni hao'
      });

      this.registerComponent('-hindi', {
        template: 'Namaste'
      });

      this.render('{{component (component model.lookupComponent)}}', {
        model: {
          lookupComponent: '-mandarin'
        }
      });

      this.assertText('ni hao');

      this.runTask(function () {
        return _this8.rerender();
      });

      this.assertText('ni hao');

      this.runTask(function () {
        return _this8.context.set('model.lookupComponent', '-hindi');
      });

      this.assertText('Namaste');

      this.runTask(function () {
        return _this8.context.set('model', { lookupComponent: '-mandarin' });
      });

      this.assertText('ni hao');
    };

    _class.prototype['@test updates when curried hash argument is bound'] = function testUpdatesWhenCurriedHashArgumentIsBound() {
      var _this9 = this;

      this.registerComponent('-looked-up', {
        template: '{{greeting}}'
      });

      this.render('{{component (component "-looked-up" greeting=model.greeting)}}', {
        model: {
          greeting: 'Hodi'
        }
      });

      this.assertText('Hodi');

      this.runTask(function () {
        return _this9.rerender();
      });

      this.assertText('Hodi');

      this.runTask(function () {
        return _this9.context.set('model.greeting', 'Hola');
      });

      this.assertText('Hola');

      this.runTask(function () {
        return _this9.context.set('model', { greeting: 'Hodi' });
      });

      this.assertText('Hodi');
    };

    _class.prototype['@test updates when curried hash arguments is bound in block form'] = function testUpdatesWhenCurriedHashArgumentsIsBoundInBlockForm() {
      var _this10 = this;

      this.registerComponent('-looked-up', {
        template: '{{greeting}}'
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject3), {
        model: {
          greeting: 'Hodi'
        }
      });

      this.assertText('Hodi');

      this.runTask(function () {
        return _this10.rerender();
      });

      this.assertText('Hodi');

      this.runTask(function () {
        return _this10.context.set('model.greeting', 'Hola');
      });

      this.assertText('Hola');

      this.runTask(function () {
        return _this10.context.set('model', { greeting: 'Hodi' });
      });

      this.assertText('Hodi');
    };

    _class.prototype['@test nested components overwrite named positional parameters'] = function testNestedComponentsOverwriteNamedPositionalParameters() {
      var _this11 = this;

      this.registerComponent('-looked-up', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: ['name', 'age']
        }),
        template: '{{name}} {{age}}'
      });

      this.render('{{component (component (component "-looked-up" "Sergio" 29) "Marvin" 21) "Hodari"}}');

      this.assertText('Hodari 21');

      this.runTask(function () {
        return _this11.rerender();
      });

      this.assertText('Hodari 21');
    };

    _class.prototype['@test nested components overwrite hash parameters'] = function testNestedComponentsOverwriteHashParameters() {
      var _this12 = this;

      this.registerComponent('-looked-up', {
        template: '{{greeting}} {{name}} {{age}}'
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject4), {
        model: {
          greeting: 'Hodi'
        }
      });

      this.assertText('Hodi Sigmundur 33');

      this.runTask(function () {
        return _this12.rerender();
      });

      this.assertText('Hodi Sigmundur 33');

      this.runTask(function () {
        return _this12.context.set('model.greeting', 'Kaixo');
      });

      this.assertText('Kaixo Sigmundur 33');

      this.runTask(function () {
        return _this12.context.set('model', { greeting: 'Hodi' });
      });

      this.assertText('Hodi Sigmundur 33');
    };

    _class.prototype['@test bound outer named parameters get updated in the right scope'] = function testBoundOuterNamedParametersGetUpdatedInTheRightScope() {
      var _this13 = this;

      this.registerComponent('-inner-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: ['comp']
        }),
        template: '{{component comp "Inner"}}'
      });

      this.registerComponent('-looked-up', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: ['name', 'age']
        }),
        template: '{{name}} {{age}}'
      });

      this.render('{{component "-inner-component" (component "-looked-up" model.outerName model.outerAge)}}', {
        model: {
          outerName: 'Outer',
          outerAge: 28
        }
      });

      this.assertText('Inner 28');

      this.runTask(function () {
        return _this13.rerender();
      });

      this.assertText('Inner 28');

      this.runTask(function () {
        return _this13.context.set('model.outerAge', 29);
      });

      this.assertText('Inner 29');

      this.runTask(function () {
        return _this13.context.set('model.outerName', 'Not outer');
      });

      this.assertText('Inner 29');

      this.runTask(function () {
        _this13.context.set('model', {
          outerName: 'Outer',
          outerAge: 28
        });
      });

      this.assertText('Inner 28');
    };

    _class.prototype['@test bound outer hash parameters get updated in the right scope'] = function testBoundOuterHashParametersGetUpdatedInTheRightScope() {
      var _this14 = this;

      this.registerComponent('-inner-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: ['comp']
        }),
        template: '{{component comp name="Inner"}}'
      });

      this.registerComponent('-looked-up', {
        template: '{{name}} {{age}}'
      });

      this.render('{{component "-inner-component" (component "-looked-up" name=model.outerName age=model.outerAge)}}', {
        model: {
          outerName: 'Outer',
          outerAge: 28
        }
      });

      this.assertText('Inner 28');

      this.runTask(function () {
        return _this14.rerender();
      });

      this.assertText('Inner 28');

      this.runTask(function () {
        return _this14.context.set('model.outerAge', 29);
      });

      this.assertText('Inner 29');

      this.runTask(function () {
        return _this14.context.set('model.outerName', 'Not outer');
      });

      this.assertText('Inner 29');

      this.runTask(function () {
        _this14.context.set('model', {
          outerName: 'Outer',
          outerAge: 28
        });
      });

      this.assertText('Inner 28');
    };

    _class.prototype['@test conflicting positional and hash parameters raise and assertion if in the same closure'] = function testConflictingPositionalAndHashParametersRaiseAndAssertionIfInTheSameClosure() {
      var _this15 = this;

      this.registerComponent('-looked-up', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: ['name']
        }),
        template: '{{greeting}} {{name}}'
      });

      expectAssertion(function () {
        _this15.render('{{component (component "-looked-up" "Hodari" name="Sergio") "Hodari" greeting="Hodi"}}');
      }, 'You cannot specify both a positional param (at position 0) and the hash argument `name`.');
    };

    _class.prototype['@test conflicting positional and hash parameters does not raise an assertion if rerendered'] = function testConflictingPositionalAndHashParametersDoesNotRaiseAnAssertionIfRerendered() {
      var _this16 = this;

      // In some cases, rerendering with a positional param used to cause an
      // assertion. This test checks it does not.
      this.registerComponent('-looked-up', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: ['name']
        }),
        template: '{{greeting}} {{name}}'
      });

      this.render('{{component (component "-looked-up" model.name greeting="Hodi")}}', {
        model: {
          name: 'Hodari'
        }
      });

      this.assertText('Hodi Hodari');

      this.runTask(function () {
        return _this16.rerender();
      });

      this.assertText('Hodi Hodari');

      this.runTask(function () {
        return _this16.context.set('model.name', 'Sergio');
      });

      this.assertText('Hodi Sergio');

      this.runTask(function () {
        return _this16.context.set('model', { name: 'Hodari' });
      });

      this.assertText('Hodi Hodari');
    };

    _class.prototype['@test conflicting positional and hash parameters does not raise an assertion if in different closure'] = function testConflictingPositionalAndHashParametersDoesNotRaiseAnAssertionIfInDifferentClosure() {
      var _this17 = this;

      this.registerComponent('-looked-up', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: ['name']
        }),
        template: '{{greeting}} {{name}}'
      });

      this.render('{{component (component "-looked-up" "Hodari") name="Sergio" greeting="Hodi"}}');

      this.assertText('Hodi Sergio');

      this.runTask(function () {
        return _this17.rerender();
      });

      this.assertText('Hodi Sergio');
    };

    _class.prototype['@test raises an asserton when component path is null'] = function testRaisesAnAssertonWhenComponentPathIsNull() {
      var _this18 = this;

      expectAssertion(function () {
        _this18.render('{{component (component lookupComponent)}}');
      });
    };

    _class.prototype['@test raises an assertion when component path is not a component name (static)'] = function testRaisesAnAssertionWhenComponentPathIsNotAComponentNameStatic() {
      var _this19 = this;

      expectAssertion(function () {
        _this19.render('{{component (component "not-a-component")}}');
      }, 'The component helper cannot be used without a valid component name. You used "not-a-component" via (component "not-a-component")');
    };

    _class.prototype['@test raises an assertion when component path is not a component name (dynamic)'] = function testRaisesAnAssertionWhenComponentPathIsNotAComponentNameDynamic() {
      var _this20 = this;

      expectAssertion(function () {
        _this20.render('{{component (component compName)}}', {
          compName: 'not-a-component'
        });
      }, /The component helper cannot be used without a valid component name. You used "not-a-component" via \(component .*\)/);
    };

    _class.prototype['@test renders with dot path'] = function testRendersWithDotPath() {
      var _this21 = this;

      var expectedText = 'Hodi';
      this.registerComponent('-looked-up', {
        template: expectedText
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject5));

      this.assertText(expectedText);

      this.runTask(function () {
        return _this21.rerender();
      });

      this.assertText(expectedText);
    };

    _class.prototype['@test renders with dot path and attr'] = function testRendersWithDotPathAndAttr() {
      var _this22 = this;

      var expectedText = 'Hodi';
      this.registerComponent('-looked-up', {
        template: '{{expectedText}}'
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject6), {
        model: {
          expectedText: expectedText
        }
      });

      this.assertText(expectedText);

      this.runTask(function () {
        return _this22.rerender();
      });

      this.assertText(expectedText);

      this.runTask(function () {
        return _this22.context.set('model.expectedText', 'Hola');
      });

      this.assertText('Hola');

      this.runTask(function () {
        return _this22.context.set('model', { expectedText: expectedText });
      });

      this.assertText(expectedText);
    };

    _class.prototype['@test renders with dot path and curried over attr'] = function testRendersWithDotPathAndCurriedOverAttr() {
      var _this23 = this;

      var expectedText = 'Hodi';
      this.registerComponent('-looked-up', {
        template: '{{expectedText}}'
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject7), {
        model: {
          expectedText: expectedText
        }
      });

      this.assertText(expectedText);

      this.runTask(function () {
        return _this23.rerender();
      });

      this.assertText(expectedText);

      this.runTask(function () {
        return _this23.context.set('model.expectedText', 'Hola');
      });

      this.assertText('Hola');

      this.runTask(function () {
        return _this23.context.set('model', { expectedText: expectedText });
      });

      this.assertText(expectedText);
    };

    _class.prototype['@test renders with dot path and with rest positional parameters'] = function testRendersWithDotPathAndWithRestPositionalParameters() {
      var _this24 = this;

      this.registerComponent('-looked-up', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: 'params'
        }),
        template: '{{params}}'
      });

      var expectedText = 'Hodi';

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject8), {
        model: {
          expectedText: expectedText
        }
      });

      this.assertText(expectedText + ',Hola');

      this.runTask(function () {
        return _this24.rerender();
      });

      this.assertText(expectedText + ',Hola');

      this.runTask(function () {
        return _this24.context.set('model.expectedText', 'Kaixo');
      });

      this.assertText('Kaixo,Hola');

      this.runTask(function () {
        return _this24.context.set('model', { expectedText: expectedText });
      });

      this.assertText(expectedText + ',Hola');
    };

    _class.prototype['@test renders with dot path and rest parameter does not leak'] = function testRendersWithDotPathAndRestParameterDoesNotLeak(assert) {
      // In the original implementation, positional parameters were not handled
      // correctly causing the first positional parameter to be the closure
      // component itself.
      var value = false;

      this.registerComponent('my-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          didReceiveAttrs: function () {
            value = this.getAttr('value');
          }
        }).reopenClass({
          positionalParams: ['value']
        })
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject9), { first: 'first' });

      assert.equal(value, 'first', 'value is the expected parameter');
    };

    _class.prototype['@test renders with dot path and updates attributes'] = function testRendersWithDotPathAndUpdatesAttributes(assert) {
      var _this25 = this;

      this.registerComponent('my-nested-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          didReceiveAttrs: function () {
            this.set('myProp', this.getAttr('my-parent-attr'));
          }
        }),
        template: '<span id="nested-prop">{{myProp}}</span>'
      });

      this.registerComponent('my-component', {
        template: '{{yield (hash my-nested-component=(component "my-nested-component" my-parent-attr=my-attr))}}'
      });

      this.registerComponent('my-action-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          actions: {
            changeValue: function () {
              this.incrementProperty('myProp');
            }
          }
        }),
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject10)
      });

      this.render('{{my-action-component myProp=model.myProp}}', {
        model: {
          myProp: 1
        }
      });

      assert.equal(this.$('#nested-prop').text(), '1');

      this.runTask(function () {
        return _this25.rerender();
      });

      assert.equal(this.$('#nested-prop').text(), '1');

      this.runTask(function () {
        return _this25.$('button').click();
      });

      assert.equal(this.$('#nested-prop').text(), '2');

      this.runTask(function () {
        return _this25.$('button').click();
      });

      assert.equal(this.$('#nested-prop').text(), '3');

      this.runTask(function () {
        return _this25.context.set('model', { myProp: 1 });
      });

      assert.equal(this.$('#nested-prop').text(), '1');
    };

    _class.prototype['@test adding parameters to a closure component\'s instance does not add it to other instances'] = function testAddingParametersToAClosureComponentSInstanceDoesNotAddItToOtherInstances() {
      var _this26 = this;

      // If parameters and attributes are not handled correctly, setting a value
      // in an invokation can leak to others invocation.
      this.registerComponent('select-box', {
        template: '{{yield (hash option=(component "select-box-option"))}}'
      });

      this.registerComponent('select-box-option', {
        template: '{{label}}'
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject11));

      this.assertText('Foo');

      this.runTask(function () {
        return _this26.rerender();
      });

      this.assertText('Foo');
    };

    _class.prototype['@test parameters in a closure are mutable when closure is a param'] = function testParametersInAClosureAreMutableWhenClosureIsAParam(assert) {
      var _this27 = this;

      // This checks that a `(mut)` is added to parameters and attributes to
      // contextual components when it is a param.

      this.registerComponent('change-button', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: ['val']
        }),
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject12)
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject13), {
        model: {
          val2: 8
        }
      });

      assert.equal(this.$('.value').text(), '8');

      this.runTask(function () {
        return _this27.rerender();
      });

      assert.equal(this.$('.value').text(), '8');

      this.runTask(function () {
        return _this27.$('.my-button').click();
      });

      assert.equal(this.$('.value').text(), '10');

      this.runTask(function () {
        return _this27.context.set('model', { val2: 8 });
      });

      assert.equal(this.$('.value').text(), '8');
    };

    _class.prototype['@test tagless blockless components render'] = function testTaglessBlocklessComponentsRender(assert) {
      var _this28 = this;

      this.registerComponent('my-comp', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({ tagName: '' })
      });

      this.render('{{my-comp}}');

      this.runTask(function () {
        return _this28.rerender();
      });

      assert.equal(this.$().text(), '');
    };

    _class.prototype['@test GH#13494 tagless blockless component with property binding'] = function testGH13494TaglessBlocklessComponentWithPropertyBinding(assert) {
      var _this29 = this;

      this.registerComponent('outer-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          message: 'hello',
          actions: {
            change: function () {
              this.set('message', 'goodbye');
            }
          }
        }),
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject14)
      });

      this.registerComponent('inner-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          tagName: ''
        })
      });

      this.render('{{outer-component}}');

      assert.equal(this.$().text(), 'message: hello');

      this.runTask(function () {
        return _this29.rerender();
      });

      assert.equal(this.$().text(), 'message: hello');

      this.runTask(function () {
        return _this29.$('button').click();
      });

      assert.equal(this.$().text(), 'message: goodbye');

      this.runTask(function () {
        return _this29.rerender();
      });

      assert.equal(this.$().text(), 'message: goodbye');
    };

    _class.prototype['@test GH#13982 contextual component ref is stable even when bound params change'] = function testGH13982ContextualComponentRefIsStableEvenWhenBoundParamsChange(assert) {
      var _this30 = this;

      var instance = undefined,
          previousInstance = undefined;
      var initCount = 0;

      this.registerComponent('my-comp', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super();
            previousInstance = instance;
            instance = this;
            initCount++;
          },
          isOpen: undefined
        }),
        template: '{{if isOpen "open" "closed"}}'
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject15), {
        isOpen: true
      });

      assert.ok(!_emberMetal.isEmpty(instance), 'a instance was created');
      assert.equal(previousInstance, undefined, 'no previous component exists');
      assert.equal(initCount, 1, 'the component was constructed exactly 1 time');
      assert.equal(this.$().text(), 'open', 'the componet text is "open"');

      this.runTask(function () {
        return _this30.rerender();
      });

      assert.ok(!_emberMetal.isEmpty(instance), 'the component instance exists');
      assert.equal(previousInstance, undefined, 'no previous component exists');
      assert.equal(initCount, 1, 'the component was constructed exactly 1 time');
      assert.equal(this.$().text(), 'open', 'the componet text is "open"');

      this.runTask(function () {
        return _this30.context.set('isOpen', false);
      });

      assert.ok(!_emberMetal.isEmpty(instance), 'the component instance exists');
      assert.equal(previousInstance, undefined, 'no previous component exists');
      assert.equal(initCount, 1, 'the component was constructed exactly 1 time');
      assert.equal(this.$().text(), 'closed', 'the component text is "closed"');

      this.runTask(function () {
        return _this30.rerender();
      });

      assert.ok(!_emberMetal.isEmpty(instance), 'the component instance exists');
      assert.equal(previousInstance, undefined, 'no previous component exists');
      assert.equal(initCount, 1, 'the component was constructed exactly 1 time');
      assert.equal(this.$().text(), 'closed', 'the component text is "closed"');

      this.runTask(function () {
        return _this30.context.set('isOpen', true);
      });

      assert.ok(!_emberMetal.isEmpty(instance), 'the component instance exists');
      assert.equal(previousInstance, undefined, 'no previous component exists');
      assert.equal(initCount, 1, 'the component was constructed exactly 1 time');
      assert.equal(this.$().text(), 'open', 'the componet text is "open"');
    };

    _class.prototype['@test GH#13982 contextual component ref is stable even when bound params change (bound name param)'] = function testGH13982ContextualComponentRefIsStableEvenWhenBoundParamsChangeBoundNameParam(assert) {
      var _this31 = this;

      var instance = undefined,
          previousInstance = undefined;
      var initCount = 0;

      this.registerComponent('my-comp', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super();
            previousInstance = instance;
            instance = this;
            initCount++;
          },
          isOpen: undefined
        }),
        template: '{{if isOpen "open" "closed"}}'
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject16), {
        compName: 'my-comp',
        isOpen: true
      });

      assert.ok(!_emberMetal.isEmpty(instance), 'a instance was created');
      assert.equal(previousInstance, undefined, 'no previous component exists');
      assert.equal(initCount, 1, 'the component was constructed exactly 1 time');
      assert.equal(this.$().text(), 'open', 'the componet text is "open"');

      this.runTask(function () {
        return _this31.rerender();
      });

      assert.ok(!_emberMetal.isEmpty(instance), 'the component instance exists');
      assert.equal(previousInstance, undefined, 'no previous component exists');
      assert.equal(initCount, 1, 'the component was constructed exactly 1 time');
      assert.equal(this.$().text(), 'open', 'the componet text is "open"');

      this.runTask(function () {
        return _this31.context.set('isOpen', false);
      });

      assert.ok(!_emberMetal.isEmpty(instance), 'the component instance exists');
      assert.equal(previousInstance, undefined, 'no previous component exists');
      assert.equal(initCount, 1, 'the component was constructed exactly 1 time');
      assert.equal(this.$().text(), 'closed', 'the component text is "closed"');

      this.runTask(function () {
        return _this31.rerender();
      });

      assert.ok(!_emberMetal.isEmpty(instance), 'the component instance exists');
      assert.equal(previousInstance, undefined, 'no previous component exists');
      assert.equal(initCount, 1, 'the component was constructed exactly 1 time');
      assert.equal(this.$().text(), 'closed', 'the component text is "closed"');

      this.runTask(function () {
        return _this31.context.set('isOpen', true);
      });

      assert.ok(!_emberMetal.isEmpty(instance), 'the component instance exists');
      assert.equal(previousInstance, undefined, 'no previous component exists');
      assert.equal(initCount, 1, 'the component was constructed exactly 1 time');
      assert.equal(this.$().text(), 'open', 'the componet text is "open"');
    };

    _class.prototype['@test GH#13982 contextual component ref is recomputed when component name param changes'] = function testGH13982ContextualComponentRefIsRecomputedWhenComponentNameParamChanges(assert) {
      var _this32 = this;

      var instance = undefined,
          previousInstance = undefined;
      var initCount = 0;

      this.registerComponent('my-comp', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super();
            previousInstance = instance;
            instance = this;
            initCount++;
          },
          isOpen: undefined
        }),
        template: 'my-comp: {{if isOpen "open" "closed"}}'
      });

      this.registerComponent('your-comp', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super();
            previousInstance = instance;
            instance = this;
            initCount++;
          },
          isOpen: undefined
        }),
        template: 'your-comp: {{if isOpen "open" "closed"}}'
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject16), {
        compName: 'my-comp',
        isOpen: true
      });

      assert.ok(!_emberMetal.isEmpty(instance), 'a instance was created');
      assert.equal(previousInstance, undefined, 'there is no previous instance');
      assert.equal(initCount, 1, 'the component was constructed exactly 1 time');
      assert.equal(this.$().text(), 'my-comp: open');

      this.runTask(function () {
        return _this32.rerender();
      });

      assert.ok(!_emberMetal.isEmpty(instance), 'a instance exists after rerender');
      assert.equal(previousInstance, undefined, 'there is no previous instance after rerender');
      assert.equal(initCount, 1, 'the component was constructed exactly 1 time');
      assert.equal(this.$().text(), 'my-comp: open');

      this.runTask(function () {
        return _this32.context.set('compName', 'your-comp');
      });

      assert.ok(!_emberMetal.isEmpty(instance), 'an instance was created after component name changed');
      assert.ok(!_emberMetal.isEmpty(previousInstance), 'a previous instance now exists');
      assert.notEqual(instance, previousInstance, 'the instance and previous instance are not the same object');
      assert.equal(initCount, 2, 'the component was constructed exactly 2 times');
      assert.equal(this.$().text(), 'your-comp: open');

      this.runTask(function () {
        return _this32.rerender();
      });

      assert.ok(!_emberMetal.isEmpty(instance), 'an instance was created after component name changed (rerender)');
      assert.ok(!_emberMetal.isEmpty(previousInstance), 'a previous instance now exists (rerender)');
      assert.notEqual(instance, previousInstance, 'the instance and previous instance are not the same object (rerender)');
      assert.equal(initCount, 2, 'the component was constructed exactly 2 times (rerender)');
      assert.equal(this.$().text(), 'your-comp: open');

      this.runTask(function () {
        return _this32.context.set('compName', 'my-comp');
      });

      assert.ok(!_emberMetal.isEmpty(instance), 'an instance was created after component name changed');
      assert.ok(!_emberMetal.isEmpty(previousInstance), 'a previous instance still exists');
      assert.notEqual(instance, previousInstance, 'the instance and previous instance are not the same object');
      assert.equal(initCount, 3, 'the component was constructed exactly 3 times (rerender)');
      assert.equal(this.$().text(), 'my-comp: open');
    };

    _class.prototype['@test GH#14508 rest positional params are received when passed as named parameter'] = function testGH14508RestPositionalParamsAreReceivedWhenPassedAsNamedParameter() {
      var _this33 = this;

      this.registerComponent('my-link', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: 'params'
        }),
        template: '{{#each params as |p|}}{{p}}{{/each}}'
      });

      this.render('{{component (component "my-link") params=allParams}}', {
        allParams: _emberRuntimeSystemNative_array.A(['a', 'b'])
      });

      this.assertText('ab');

      this.runTask(function () {
        return _this33.rerender();
      });

      this.assertText('ab');

      this.runTask(function () {
        return _this33.context.get('allParams').pushObject('c');
      });

      this.assertText('abc');

      this.runTask(function () {
        return _this33.context.get('allParams').popObject();
      });

      this.assertText('ab');

      this.runTask(function () {
        return _this33.context.get('allParams').clear();
      });

      this.assertText('');

      this.runTask(function () {
        return _this33.context.set('allParams', _emberRuntimeSystemNative_array.A(['1', '2']));
      });

      this.assertText('12');

      this.runTask(function () {
        return _this33.context.set('allParams', _emberRuntimeSystemNative_array.A(['a', 'b']));
      });

      this.assertText('ab');
    };

    _class.prototype['@test GH#14508 rest positional params are received when passed as named parameter with dot notation'] = function testGH14508RestPositionalParamsAreReceivedWhenPassedAsNamedParameterWithDotNotation() {
      var _this34 = this;

      this.registerComponent('my-link', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: 'params'
        }),
        template: '{{#each params as |p|}}{{p}}{{/each}}'
      });

      this.render('{{#with (hash link=(component "my-link")) as |c|}}{{c.link params=allParams}}{{/with}}', {
        allParams: _emberRuntimeSystemNative_array.A(['a', 'b'])
      });

      this.assertText('ab');

      this.runTask(function () {
        return _this34.rerender();
      });

      this.assertText('ab');

      this.runTask(function () {
        return _this34.context.get('allParams').pushObject('c');
      });

      this.assertText('abc');

      this.runTask(function () {
        return _this34.context.get('allParams').popObject();
      });

      this.assertText('ab');

      this.runTask(function () {
        return _this34.context.get('allParams').clear();
      });

      this.assertText('');

      this.runTask(function () {
        return _this34.context.set('allParams', _emberRuntimeSystemNative_array.A(['1', '2']));
      });

      this.assertText('12');

      this.runTask(function () {
        return _this34.context.set('allParams', _emberRuntimeSystemNative_array.A(['a', 'b']));
      });

      this.assertText('ab');
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));

  var ClosureComponentMutableParamsTest = (function (_RenderingTest2) {
babelHelpers.inherits(ClosureComponentMutableParamsTest, _RenderingTest2);

    function ClosureComponentMutableParamsTest() {
      _RenderingTest2.apply(this, arguments);
    }

    ClosureComponentMutableParamsTest.prototype.render = function render(templateStr) {
      var context = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      _RenderingTest2.prototype.render.call(this, templateStr + '<span class="value">{{model.val2}}</span>', _emberUtils.assign(context, { model: { val2: 8 } }));
    };

    return ClosureComponentMutableParamsTest;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest);

  var MutableParamTestGenerator = (function () {
    function MutableParamTestGenerator(cases) {
      this.cases = cases;
    }

    MutableParamTestGenerator.prototype.generate = function generate(_ref2) {
      var _ref;

      var title = _ref2.title;
      var setup = _ref2.setup;

      return _ref = {}, _ref['@test parameters in a closure are mutable when closure is a ' + title] = function (assert) {
        var _this35 = this;

        this.registerComponent('change-button', {
          ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
            positionalParams: ['val']
          }),
          template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject17)
        });

        setup.call(this, assert);

        assert.equal(this.$('.value').text(), '8');

        this.runTask(function () {
          return _this35.rerender();
        });

        assert.equal(this.$('.value').text(), '8');

        this.runTask(function () {
          return _this35.$('.my-button').click();
        });

        assert.equal(this.$('.value').text(), '10');

        this.runTask(function () {
          return _this35.context.set('model', { val2: 8 });
        });

        assert.equal(this.$('.value').text(), '8');
      }, _ref;
    };

    return MutableParamTestGenerator;
  })();

  _emberGlimmerTestsUtilsAbstractTestCase.applyMixins(ClosureComponentMutableParamsTest, new MutableParamTestGenerator([{
    title: 'param',
    setup: function () {
      this.render('{{component (component "change-button" model.val2)}}');
    }
  }, {
    title: 'nested param',
    setup: function () {
      this.registerComponent('my-comp', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: ['components']
        }),
        template: '{{component components.comp}}'
      });

      this.render('{{my-comp (hash comp=(component "change-button" model.val2))}}');
    }
  }, {
    title: 'hash value',
    setup: function () {
      this.registerComponent('my-comp', {
        template: '{{component component}}'
      });

      this.render('{{my-comp component=(component "change-button" val=model.val2)}}');
    }
  }, {
    title: 'nested hash value',
    setup: function () {
      this.registerComponent('my-comp', {
        template: '{{component components.button}}'
      });

      this.render('{{my-comp components=(hash button=(component "change-button" val=model.val2))}}');
    }
  }]));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Components test: closure components -- mutable params', ClosureComponentMutableParamsTest);
});
enifed('ember-glimmer/tests/integration/components/curly-components-test', ['exports', 'ember-metal', 'ember-runtime', 'ember-glimmer/tests/utils/helpers', 'ember-glimmer/tests/utils/abstract-test-case', 'ember-glimmer/tests/utils/test-case', 'ember-glimmer/tests/utils/test-helpers'], function (exports, _emberMetal, _emberRuntime, _emberGlimmerTestsUtilsHelpers, _emberGlimmerTestsUtilsAbstractTestCase, _emberGlimmerTestsUtilsTestCase, _emberGlimmerTestsUtilsTestHelpers) {
  /* globals EmberDev */
  'use strict';

  var _templateObject = babelHelpers.taggedTemplateLiteralLoose(['\n      {{foo-bar class="bar baz"}}\n      {{foo-bar classNames="bar baz"}}\n      {{foo-bar}}\n    '], ['\n      {{foo-bar class="bar baz"}}\n      {{foo-bar classNames="bar baz"}}\n      {{foo-bar}}\n    ']),
      _templateObject2 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#if cond1}}\n        {{#foo-bar id=1}}\n          {{#if cond2}}\n            {{#foo-bar id=2}}{{/foo-bar}}\n            {{#if cond3}}\n              {{#foo-bar id=3}}\n                {{#if cond4}}\n                  {{#foo-bar id=4}}\n                    {{#if cond5}}\n                      {{#foo-bar id=5}}{{/foo-bar}}\n                      {{#foo-bar id=6}}{{/foo-bar}}\n                      {{#foo-bar id=7}}{{/foo-bar}}\n                    {{/if}}\n                    {{#foo-bar id=8}}{{/foo-bar}}\n                  {{/foo-bar}}\n                {{/if}}\n              {{/foo-bar}}\n            {{/if}}\n          {{/if}}\n        {{/foo-bar}}\n      {{/if}}'], ['\n      {{#if cond1}}\n        {{#foo-bar id=1}}\n          {{#if cond2}}\n            {{#foo-bar id=2}}{{/foo-bar}}\n            {{#if cond3}}\n              {{#foo-bar id=3}}\n                {{#if cond4}}\n                  {{#foo-bar id=4}}\n                    {{#if cond5}}\n                      {{#foo-bar id=5}}{{/foo-bar}}\n                      {{#foo-bar id=6}}{{/foo-bar}}\n                      {{#foo-bar id=7}}{{/foo-bar}}\n                    {{/if}}\n                    {{#foo-bar id=8}}{{/foo-bar}}\n                  {{/foo-bar}}\n                {{/if}}\n              {{/foo-bar}}\n            {{/if}}\n          {{/if}}\n        {{/foo-bar}}\n      {{/if}}']),
      _templateObject3 = babelHelpers.taggedTemplateLiteralLoose(['\n        {{#if isStream}}\n          true\n        {{else}}\n          false\n        {{/if}}\n      '], ['\n        {{#if isStream}}\n          true\n        {{else}}\n          false\n        {{/if}}\n      ']),
      _templateObject4 = babelHelpers.taggedTemplateLiteralLoose(['\n        Args: {{this.attrs.value}} | {{attrs.value}} | {{value}}\n        {{#each this.attrs.items as |item|}}\n          {{item}}\n        {{/each}}\n        {{#each attrs.items as |item|}}\n          {{item}}\n        {{/each}}\n        {{#each items as |item|}}\n          {{item}}\n        {{/each}}\n      '], ['\n        Args: {{this.attrs.value}} | {{attrs.value}} | {{value}}\n        {{#each this.attrs.items as |item|}}\n          {{item}}\n        {{/each}}\n        {{#each attrs.items as |item|}}\n          {{item}}\n        {{/each}}\n        {{#each items as |item|}}\n          {{item}}\n        {{/each}}\n      ']),
      _templateObject5 = babelHelpers.taggedTemplateLiteralLoose(['Args: lul | lul | lul111'], ['Args: lul | lul | lul111']),
      _templateObject6 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#with-block someProp=prop}}\n        In template\n      {{/with-block}}'], ['\n      {{#with-block someProp=prop}}\n        In template\n      {{/with-block}}']),
      _templateObject7 = babelHelpers.taggedTemplateLiteralLoose(['\n        {{#each names as |name|}}\n          {{name}}\n        {{/each}}'], ['\n        {{#each names as |name|}}\n          {{name}}\n        {{/each}}']),
      _templateObject8 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{sample-component "Foo" 4 "Bar" elementId="args-3"}}\n      {{sample-component "Foo" 4 "Bar" 5 "Baz" elementId="args-5"}}'], ['\n      {{sample-component "Foo" 4 "Bar" elementId="args-3"}}\n      {{sample-component "Foo" 4 "Bar" 5 "Baz" elementId="args-5"}}']),
      _templateObject9 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{sample-component "one" "two" elementId="two-positional"}}\n      {{sample-component "one" second="two" elementId="one-positional"}}\n      {{sample-component first="one" second="two" elementId="no-positional"}}'], ['\n      {{sample-component "one" "two" elementId="two-positional"}}\n      {{sample-component "one" second="two" elementId="one-positional"}}\n      {{sample-component first="one" second="two" elementId="no-positional"}}']),
      _templateObject10 = babelHelpers.taggedTemplateLiteralLoose(['\n        {{#each n as |name|}}\n          {{name}}\n        {{/each}}'], ['\n        {{#each n as |name|}}\n          {{name}}\n        {{/each}}']),
      _templateObject11 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#with-template name="with-block"}}\n        [In block - {{name}}]\n      {{/with-template}}\n      {{with-template name="without-block"}}'], ['\n      {{#with-template name="with-block"}}\n        [In block - {{name}}]\n      {{/with-template}}\n      {{with-template name="without-block"}}']),
      _templateObject12 = babelHelpers.taggedTemplateLiteralLoose(['\n        {{#if hasBlock}}\n          {{yield}}\n        {{else}}\n          No Block!\n        {{/if}}'], ['\n        {{#if hasBlock}}\n          {{yield}}\n        {{else}}\n          No Block!\n        {{/if}}']),
      _templateObject13 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#with-block}}\n        In template\n      {{/with-block}}'], ['\n      {{#with-block}}\n        In template\n      {{/with-block}}']),
      _templateObject14 = babelHelpers.taggedTemplateLiteralLoose(['\n        {{#if hasBlockParams}}\n          {{yield this}} - In Component\n        {{else}}\n          {{yield}} No Block!\n        {{/if}}'], ['\n        {{#if hasBlockParams}}\n          {{yield this}} - In Component\n        {{else}}\n          {{yield}} No Block!\n        {{/if}}']),
      _templateObject15 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#with-block as |something|}}\n        In template\n      {{/with-block}}'], ['\n      {{#with-block as |something|}}\n        In template\n      {{/with-block}}']),
      _templateObject16 = babelHelpers.taggedTemplateLiteralLoose(['\n        {{#if hasBlockParams}}\n          {{yield this}}\n        {{else}}\n          {{yield}} No Block Param!\n        {{/if}}'], ['\n        {{#if hasBlockParams}}\n          {{yield this}}\n        {{else}}\n          {{yield}} No Block Param!\n        {{/if}}']),
      _templateObject17 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#with-block}}\n        In block\n      {{/with-block}}'], ['\n      {{#with-block}}\n        In block\n      {{/with-block}}']),
      _templateObject18 = babelHelpers.taggedTemplateLiteralLoose(['\n        {{#if predicate}}\n          Yes:{{yield someValue}}\n        {{else}}\n          No:{{yield to="inverse"}}\n        {{/if}}'], ['\n        {{#if predicate}}\n          Yes:{{yield someValue}}\n        {{else}}\n          No:{{yield to="inverse"}}\n        {{/if}}']),
      _templateObject19 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#my-if predicate=activated someValue=42 as |result|}}\n        Hello{{result}}\n      {{else}}\n        Goodbye\n      {{/my-if}}'], ['\n      {{#my-if predicate=activated someValue=42 as |result|}}\n        Hello{{result}}\n      {{else}}\n        Goodbye\n      {{/my-if}}']),
      _templateObject20 = babelHelpers.taggedTemplateLiteralLoose(['\n        {{#if (hasBlock "inverse")}}\n          Yes\n        {{else}}\n          No\n        {{/if}}'], ['\n        {{#if (hasBlock "inverse")}}\n          Yes\n        {{else}}\n          No\n        {{/if}}']),
      _templateObject21 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#check-inverse}}{{/check-inverse}}\n      {{#check-inverse}}{{else}}{{/check-inverse}}'], ['\n      {{#check-inverse}}{{/check-inverse}}\n      {{#check-inverse}}{{else}}{{/check-inverse}}']),
      _templateObject22 = babelHelpers.taggedTemplateLiteralLoose(['\n        {{#if (hasBlock)}}\n          Yes\n        {{else}}\n          No\n        {{/if}}'], ['\n        {{#if (hasBlock)}}\n          Yes\n        {{else}}\n          No\n        {{/if}}']),
      _templateObject23 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{check-block}}\n      {{#check-block}}{{/check-block}}'], ['\n      {{check-block}}\n      {{#check-block}}{{/check-block}}']),
      _templateObject24 = babelHelpers.taggedTemplateLiteralLoose(['\n        {{#if (hasBlockParams "inverse")}}\n          Yes\n        {{else}}\n          No\n        {{/if}}'], ['\n        {{#if (hasBlockParams "inverse")}}\n          Yes\n        {{else}}\n          No\n        {{/if}}']),
      _templateObject25 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#check-inverse}}{{/check-inverse}}\n      {{#check-inverse as |something|}}{{/check-inverse}}'], ['\n      {{#check-inverse}}{{/check-inverse}}\n      {{#check-inverse as |something|}}{{/check-inverse}}']),
      _templateObject26 = babelHelpers.taggedTemplateLiteralLoose(['\n        {{#if (hasBlockParams)}}\n          Yes\n        {{else}}\n          No\n        {{/if}}'], ['\n        {{#if (hasBlockParams)}}\n          Yes\n        {{else}}\n          No\n        {{/if}}']),
      _templateObject27 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#check-block}}{{/check-block}}\n      {{#check-block as |something|}}{{/check-block}}'], ['\n      {{#check-block}}{{/check-block}}\n      {{#check-block as |something|}}{{/check-block}}']),
      _templateObject28 = babelHelpers.taggedTemplateLiteralLoose(['\n        {{#if hasBlock}}\n          Yes\n        {{else}}\n          No\n        {{/if}}'], ['\n        {{#if hasBlock}}\n          Yes\n        {{else}}\n          No\n        {{/if}}']),
      _templateObject29 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#check-params}}{{/check-params}}\n      {{#check-params as |foo|}}{{/check-params}}'], ['\n      {{#check-params}}{{/check-params}}\n      {{#check-params as |foo|}}{{/check-params}}']),
      _templateObject30 = babelHelpers.taggedTemplateLiteralLoose(['\n        {{#if hasBlockParams}}\n          Yes\n        {{else}}\n          No\n        {{/if}}'], ['\n        {{#if hasBlockParams}}\n          Yes\n        {{else}}\n          No\n        {{/if}}']),
      _templateObject31 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{check-attr}}\n      {{#check-attr}}{{/check-attr}}'], ['\n      {{check-attr}}\n      {{#check-attr}}{{/check-attr}}']),
      _templateObject32 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#check-attr}}{{/check-attr}}\n      {{#check-attr}}{{else}}{{/check-attr}}'], ['\n      {{#check-attr}}{{/check-attr}}\n      {{#check-attr}}{{else}}{{/check-attr}}']),
      _templateObject33 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#check-attr}}{{/check-attr}}\n      {{#check-attr as |something|}}{{/check-attr}}'], ['\n      {{#check-attr}}{{/check-attr}}\n      {{#check-attr as |something|}}{{/check-attr}}']),
      _templateObject34 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{check-helper}}\n      {{#check-helper}}{{/check-helper}}'], ['\n      {{check-helper}}\n      {{#check-helper}}{{/check-helper}}']),
      _templateObject35 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#check-helper}}{{/check-helper}}\n      {{#check-helper}}{{else}}{{/check-helper}}'], ['\n      {{#check-helper}}{{/check-helper}}\n      {{#check-helper}}{{else}}{{/check-helper}}']),
      _templateObject36 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#check-helper}}{{/check-helper}}\n      {{#check-helper as |something|}}{{/check-helper}}'], ['\n      {{#check-helper}}{{/check-helper}}\n      {{#check-helper as |something|}}{{/check-helper}}']),
      _templateObject37 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#x-outer}}\n        {{#if showInner}}\n          {{x-inner}}\n        {{/if}}\n      {{/x-outer}}'], ['\n      {{#x-outer}}\n        {{#if showInner}}\n          {{x-inner}}\n        {{/if}}\n      {{/x-outer}}']),
      _templateObject38 = babelHelpers.taggedTemplateLiteralLoose(['\n        In layout. {{#each items as |item|}}\n          [{{child-non-block item=item}}]\n        {{/each}}'], ['\n        In layout. {{#each items as |item|}}\n          [{{child-non-block item=item}}]\n        {{/each}}']),
      _templateObject39 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#some-clicky-thing classNames="baz"}}\n        Click Me\n      {{/some-clicky-thing}}'], ['\n      {{#some-clicky-thing classNames="baz"}}\n        Click Me\n      {{/some-clicky-thing}}']),
      _templateObject40 = babelHelpers.taggedTemplateLiteralLoose(['\n        {{#each blahzz as |p|}}\n          {{p}}\n        {{/each}}\n        - {{yield}}'], ['\n        {{#each blahzz as |p|}}\n          {{p}}\n        {{/each}}\n        - {{yield}}']),
      _templateObject41 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#some-clicky-thing blahzz="baz"}}\n        Click Me\n      {{/some-clicky-thing}}'], ['\n      {{#some-clicky-thing blahzz="baz"}}\n        Click Me\n      {{/some-clicky-thing}}']),
      _templateObject42 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#x-select value=value as |select|}}\n        {{#x-option value="1" select=select}}1{{/x-option}}\n        {{#x-option value="2" select=select}}2{{/x-option}}\n      {{/x-select}}\n    '], ['\n      {{#x-select value=value as |select|}}\n        {{#x-option value="1" select=select}}1{{/x-option}}\n        {{#x-option value="2" select=select}}2{{/x-option}}\n      {{/x-select}}\n    ']),
      _templateObject43 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#list-items items=items as |thing|}}\n        |{{thing}}|\n\n        {{#if editMode}}\n          Remove {{thing}}\n        {{/if}}\n      {{/list-items}}\n    '], ['\n      {{#list-items items=items as |thing|}}\n        |{{thing}}|\n\n        {{#if editMode}}\n          Remove {{thing}}\n        {{/if}}\n      {{/list-items}}\n    ']);

  _emberGlimmerTestsUtilsTestCase.moduleFor('Components test: curly components', (function (_RenderingTest) {
babelHelpers.inherits(_class, _RenderingTest);

    function _class() {
      _RenderingTest.apply(this, arguments);
    }

    _class.prototype['@test it can render a basic component'] = function testItCanRenderABasicComponent() {
      var _this = this;

      this.registerComponent('foo-bar', { template: 'hello' });

      this.render('{{foo-bar}}');

      this.assertComponentElement(this.firstChild, { content: 'hello' });

      this.runTask(function () {
        return _this.rerender();
      });

      this.assertComponentElement(this.firstChild, { content: 'hello' });
    };

    _class.prototype['@test it can render a template only component'] = function testItCanRenderATemplateOnlyComponent() {
      var _this2 = this;

      this.registerComponent('foo-bar', { template: 'hello' });

      this.render('{{foo-bar}}');

      this.assertComponentElement(this.firstChild, { content: 'hello' });

      this.runTask(function () {
        return _this2.rerender();
      });

      this.assertComponentElement(this.firstChild, { content: 'hello' });
    };

    _class.prototype['@test it can have a custom id and it is not bound'] = function testItCanHaveACustomIdAndItIsNotBound() {
      var _this3 = this;

      this.registerComponent('foo-bar', { template: '{{id}} {{elementId}}' });

      this.render('{{foo-bar id=customId}}', {
        customId: 'bizz'
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { id: 'bizz' }, content: 'bizz bizz' });

      this.runTask(function () {
        return _this3.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { id: 'bizz' }, content: 'bizz bizz' });

      this.runTask(function () {
        return _emberMetal.set(_this3.context, 'customId', 'bar');
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { id: 'bizz' }, content: 'bar bizz' });

      this.runTask(function () {
        return _emberMetal.set(_this3.context, 'customId', 'bizz');
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { id: 'bizz' }, content: 'bizz bizz' });
    };

    _class.prototype['@test elementId cannot change'] = function testElementIdCannotChange(assert) {
      var component = undefined;
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        elementId: 'blahzorz',
        init: function () {
          this._super.apply(this, arguments);
          component = this;
        }
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: '{{elementId}}' });

      this.render('{{foo-bar}}');

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { id: 'blahzorz' }, content: 'blahzorz' });

      if (EmberDev && !EmberDev.runningProdBuild) {
        var willThrow = function () {
          return _emberMetal.run(null, _emberMetal.set, component, 'elementId', 'herpyderpy');
        };

        assert.throws(willThrow, /Changing a view's elementId after creation is not allowed/);

        this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { id: 'blahzorz' }, content: 'blahzorz' });
      }
    };

    _class.prototype['@test can specify template with `layoutName` property'] = function testCanSpecifyTemplateWithLayoutNameProperty() {
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        elementId: 'blahzorz',
        layoutName: 'fizz-bar',
        init: function () {
          this._super.apply(this, arguments);
          this.local = 'hey';
        }
      });

      this.registerTemplate('fizz-bar', 'FIZZ BAR {{local}}');

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent });

      this.render('{{foo-bar}}');

      this.assertText('FIZZ BAR hey');
    };

    _class.prototype['@test can specify template with `defaultLayout` property [DEPRECATED]'] = function testCanSpecifyTemplateWithDefaultLayoutPropertyDEPRECATED() {
      expectDeprecation(/Specifying `defaultLayout` to .* is deprecated. Please use `layout` instead/);
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        elementId: 'blahzorz',
        defaultLayout: _emberGlimmerTestsUtilsHelpers.compile('much wat {{lulz}}'),
        init: function () {
          this._super.apply(this, arguments);
          this.lulz = 'hey';
        }
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent });

      this.render('{{foo-bar}}');

      this.assertText('much wat hey');
    };

    _class.prototype['@test layout takes precedence over defaultLayout'] = function testLayoutTakesPrecedenceOverDefaultLayout() {
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        elementId: 'blahzorz',
        layout: _emberGlimmerTestsUtilsHelpers.compile('so much layout wat {{lulz}}'),
        defaultLayout: _emberGlimmerTestsUtilsHelpers.compile('much wat {{lulz}}'),
        init: function () {
          this._super.apply(this, arguments);
          this.lulz = 'hey';
        }
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent });

      this.render('{{foo-bar}}');

      this.assertText('so much layout wat hey');
    };

    _class.prototype['@test layout supports computed property'] = function testLayoutSupportsComputedProperty() {
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        elementId: 'blahzorz',
        layout: _emberMetal.computed(function () {
          return _emberGlimmerTestsUtilsHelpers.compile('so much layout wat {{lulz}}');
        }),
        init: function () {
          this._super.apply(this, arguments);
          this.lulz = 'heyo';
        }
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent });

      this.render('{{foo-bar}}');

      this.assertText('so much layout wat heyo');
    };

    _class.prototype['@test passing undefined elementId results in a default elementId'] = function testPassingUndefinedElementIdResultsInADefaultElementId(assert) {
      var _this4 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        tagName: 'h1'
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'something' });

      this.render('{{foo-bar id=somethingUndefined}}');

      var foundId = this.$('h1').attr('id');
      assert.ok(/^ember/.test(foundId), 'Has a reasonable id attribute (found id=' + foundId + ').');

      this.runTask(function () {
        return _this4.rerender();
      });

      var newFoundId = this.$('h1').attr('id');
      assert.ok(/^ember/.test(newFoundId), 'Has a reasonable id attribute (found id=' + newFoundId + ').');

      assert.equal(foundId, newFoundId);
    };

    _class.prototype['@test id is an alias for elementId'] = function testIdIsAnAliasForElementId(assert) {
      var _this5 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        tagName: 'h1'
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'something' });

      this.render('{{foo-bar id="custom-id"}}');

      var foundId = this.$('h1').attr('id');
      assert.equal(foundId, 'custom-id');

      this.runTask(function () {
        return _this5.rerender();
      });

      var newFoundId = this.$('h1').attr('id');
      assert.equal(newFoundId, 'custom-id');

      assert.equal(foundId, newFoundId);
    };

    _class.prototype['@test cannot pass both id and elementId at the same time'] = function testCannotPassBothIdAndElementIdAtTheSameTime(assert) {
      var _this6 = this;

      this.registerComponent('foo-bar', { template: '' });

      expectAssertion(function () {
        _this6.render('{{foo-bar id="zomg" elementId="lol"}}');
      }, /You cannot invoke a component with both 'id' and 'elementId' at the same time./);
    };

    _class.prototype['@test it can have a custom tagName'] = function testItCanHaveACustomTagName() {
      var _this7 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        tagName: 'foo-bar'
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{foo-bar}}');

      this.assertComponentElement(this.firstChild, { tagName: 'foo-bar', content: 'hello' });

      this.runTask(function () {
        return _this7.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'foo-bar', content: 'hello' });
    };

    _class.prototype['@test it can have a custom tagName set in the constructor'] = function testItCanHaveACustomTagNameSetInTheConstructor() {
      var _this8 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super();
          this.tagName = 'foo-bar';
        }
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{foo-bar}}');

      this.assertComponentElement(this.firstChild, { tagName: 'foo-bar', content: 'hello' });

      this.runTask(function () {
        return _this8.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'foo-bar', content: 'hello' });
    };

    _class.prototype['@test it can have a custom tagName from the invocation'] = function testItCanHaveACustomTagNameFromTheInvocation() {
      var _this9 = this;

      this.registerComponent('foo-bar', { template: 'hello' });

      this.render('{{foo-bar tagName="foo-bar"}}');

      this.assertComponentElement(this.firstChild, { tagName: 'foo-bar', content: 'hello' });

      this.runTask(function () {
        return _this9.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'foo-bar', content: 'hello' });
    };

    _class.prototype['@test tagName can not be a computed property'] = function testTagNameCanNotBeAComputedProperty(assert) {
      var _this10 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        tagName: _emberMetal.computed(function () {
          return 'foo-bar';
        })
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      expectAssertion(function () {
        _this10.render('{{foo-bar}}');
      }, /You cannot use a computed property for the component's `tagName` \(<\(.+>\)\./);
    };

    _class.prototype['@test class is applied before didInsertElement'] = function testClassIsAppliedBeforeDidInsertElement(assert) {
      var componentClass = undefined;
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        didInsertElement: function () {
          componentClass = this.element.className;
        }
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{foo-bar class="foo-bar"}}');

      assert.equal(componentClass, 'foo-bar ember-view');
    };

    _class.prototype['@test it can have custom classNames'] = function testItCanHaveCustomClassNames() {
      var _this11 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        classNames: ['foo', 'bar']
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{foo-bar}}');

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo bar') }, content: 'hello' });

      this.runTask(function () {
        return _this11.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo bar') }, content: 'hello' });
    };

    _class.prototype['@test should not apply falsy class name'] = function testShouldNotApplyFalsyClassName() {
      var _this12 = this;

      this.registerComponent('foo-bar', { template: 'hello' });

      this.render('{{foo-bar class=somethingFalsy}}', {
        somethingFalsy: false
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { class: 'ember-view' }, content: 'hello' });

      this.runTask(function () {
        return _this12.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { class: 'ember-view' }, content: 'hello' });
    };

    _class.prototype['@test should apply classes of the dasherized property name when bound property specified is true'] = function testShouldApplyClassesOfTheDasherizedPropertyNameWhenBoundPropertySpecifiedIsTrue() {
      var _this13 = this;

      this.registerComponent('foo-bar', { template: 'hello' });

      this.render('{{foo-bar class=model.someTruth}}', {
        model: { someTruth: true }
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { class: _emberGlimmerTestsUtilsTestHelpers.classes('ember-view some-truth') }, content: 'hello' });

      this.runTask(function () {
        return _this13.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { class: _emberGlimmerTestsUtilsTestHelpers.classes('ember-view some-truth') }, content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this13.context, 'model.someTruth', false);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { class: _emberGlimmerTestsUtilsTestHelpers.classes('ember-view') }, content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this13.context, 'model', { someTruth: true });
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { class: _emberGlimmerTestsUtilsTestHelpers.classes('ember-view some-truth') }, content: 'hello' });
    };

    _class.prototype['@test class property on components can be dynamic'] = function testClassPropertyOnComponentsCanBeDynamic() {
      var _this14 = this;

      this.registerComponent('foo-bar', { template: 'hello' });

      this.render('{{foo-bar class=(if fooBar "foo-bar")}}', {
        fooBar: true
      });

      this.assertComponentElement(this.firstChild, { content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo-bar') } });

      this.runTask(function () {
        return _this14.rerender();
      });

      this.assertComponentElement(this.firstChild, { content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo-bar') } });

      this.runTask(function () {
        return _emberMetal.set(_this14.context, 'fooBar', false);
      });

      this.assertComponentElement(this.firstChild, { content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view') } });

      this.runTask(function () {
        return _emberMetal.set(_this14.context, 'fooBar', true);
      });

      this.assertComponentElement(this.firstChild, { content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo-bar') } });
    };

    _class.prototype['@test it can have custom classNames from constructor'] = function testItCanHaveCustomClassNamesFromConstructor() {
      var _this15 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super();
          this.classNames = this.classNames.slice();
          this.classNames.push('foo', 'bar', 'outside-' + this.get('extraClass'));
        }
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{foo-bar extraClass="baz"}}');

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo bar outside-baz') }, content: 'hello' });

      this.runTask(function () {
        return _this15.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo bar outside-baz') }, content: 'hello' });
    };

    _class.prototype['@test it can set custom classNames from the invocation'] = function testItCanSetCustomClassNamesFromTheInvocation() {
      var _this16 = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        classNames: ['foo']
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject));

      this.assertComponentElement(this.nthChild(0), { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo bar baz') }, content: 'hello' });
      this.assertComponentElement(this.nthChild(1), { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo bar baz') }, content: 'hello' });
      this.assertComponentElement(this.nthChild(2), { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo') }, content: 'hello' });

      this.runTask(function () {
        return _this16.rerender();
      });

      this.assertComponentElement(this.nthChild(0), { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo bar baz') }, content: 'hello' });
      this.assertComponentElement(this.nthChild(1), { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo bar baz') }, content: 'hello' });
      this.assertComponentElement(this.nthChild(2), { tagName: 'div', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('ember-view foo') }, content: 'hello' });
    };

    _class.prototype['@test it has an element'] = function testItHasAnElement() {
      var _this17 = this;

      var instance = undefined;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super();
          instance = this;
        }
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{foo-bar}}');

      var element1 = instance.element;

      this.assertComponentElement(element1, { content: 'hello' });

      this.runTask(function () {
        return _this17.rerender();
      });

      var element2 = instance.element;

      this.assertComponentElement(element2, { content: 'hello' });

      this.assertSameNode(element2, element1);
    };

    _class.prototype['@test it has a jQuery proxy to the element'] = function testItHasAJQueryProxyToTheElement(assert) {
      var _this18 = this;

      var instance = undefined;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super();
          instance = this;
        }
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{foo-bar}}');

      var element1 = instance.$()[0];

      this.assertComponentElement(element1, { content: 'hello' });

      this.runTask(function () {
        return _this18.rerender();
      });

      var element2 = instance.$()[0];

      this.assertComponentElement(element2, { content: 'hello' });

      this.assertSameNode(element2, element1);
    };

    _class.prototype['@test it scopes the jQuery proxy to the component element'] = function testItScopesTheJQueryProxyToTheComponentElement(assert) {
      var _this19 = this;

      var instance = undefined;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super();
          instance = this;
        }
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: '<span class="inner">inner</span>' });

      this.render('<span class="outer">outer</span>{{foo-bar}}');

      var $span = instance.$('span');

      assert.equal($span.length, 1);
      assert.equal($span.attr('class'), 'inner');

      this.runTask(function () {
        return _this19.rerender();
      });

      $span = instance.$('span');

      assert.equal($span.length, 1);
      assert.equal($span.attr('class'), 'inner');
    };

    _class.prototype['@test an empty component does not have childNodes'] = function testAnEmptyComponentDoesNotHaveChildNodes(assert) {
      var _this20 = this;

      var fooBarInstance = undefined;
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        tagName: 'input',
        init: function () {
          this._super();
          fooBarInstance = this;
        }
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: '' });

      this.render('{{foo-bar}}');

      this.assertComponentElement(this.firstChild, { tagName: 'input' });

      assert.strictEqual(fooBarInstance.element.childNodes.length, 0);

      this.runTask(function () {
        return _this20.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'input' });

      assert.strictEqual(fooBarInstance.element.childNodes.length, 0);
    };

    _class.prototype['@test it has the right parentView and childViews'] = function testItHasTheRightParentViewAndChildViews(assert) {
      var _this21 = this;

      var fooBarInstance = undefined,
          fooBarBazInstance = undefined;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super();
          fooBarInstance = this;
        }
      });

      var FooBarBazComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super();
          fooBarBazInstance = this;
        }
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'foo-bar {{foo-bar-baz}}' });
      this.registerComponent('foo-bar-baz', { ComponentClass: FooBarBazComponent, template: 'foo-bar-baz' });

      this.render('{{foo-bar}}');
      this.assertText('foo-bar foo-bar-baz');

      assert.equal(fooBarInstance.parentView, this.component);
      assert.equal(fooBarBazInstance.parentView, fooBarInstance);

      assert.deepEqual(this.component.childViews, [fooBarInstance]);
      assert.deepEqual(fooBarInstance.childViews, [fooBarBazInstance]);

      this.runTask(function () {
        return _this21.rerender();
      });
      this.assertText('foo-bar foo-bar-baz');

      assert.equal(fooBarInstance.parentView, this.component);
      assert.equal(fooBarBazInstance.parentView, fooBarInstance);

      assert.deepEqual(this.component.childViews, [fooBarInstance]);
      assert.deepEqual(fooBarInstance.childViews, [fooBarBazInstance]);
    };

    _class.prototype['@test it renders passed named arguments'] = function testItRendersPassedNamedArguments() {
      var _this22 = this;

      this.registerComponent('foo-bar', {
        template: '{{foo}}'
      });

      this.render('{{foo-bar foo=model.bar}}', {
        model: {
          bar: 'Hola'
        }
      });

      this.assertText('Hola');

      this.runTask(function () {
        return _this22.rerender();
      });

      this.assertText('Hola');

      this.runTask(function () {
        return _this22.context.set('model.bar', 'Hello');
      });

      this.assertText('Hello');

      this.runTask(function () {
        return _this22.context.set('model', { bar: 'Hola' });
      });

      this.assertText('Hola');
    };

    _class.prototype['@test it can render a basic component with a block'] = function testItCanRenderABasicComponentWithABlock() {
      var _this23 = this;

      this.registerComponent('foo-bar', { template: '{{yield}} - In component' });

      this.render('{{#foo-bar}}hello{{/foo-bar}}');

      this.assertComponentElement(this.firstChild, { content: 'hello - In component' });

      this.runTask(function () {
        return _this23.rerender();
      });

      this.assertComponentElement(this.firstChild, { content: 'hello - In component' });
    };

    _class.prototype['@test it can render a basic component with a block when the yield is in a partial'] = function testItCanRenderABasicComponentWithABlockWhenTheYieldIsInAPartial() {
      var _this24 = this;

      this.registerPartial('_partialWithYield', 'yielded: [{{yield}}]');

      this.registerComponent('foo-bar', { template: '{{partial "partialWithYield"}} - In component' });

      this.render('{{#foo-bar}}hello{{/foo-bar}}');

      this.assertComponentElement(this.firstChild, { content: 'yielded: [hello] - In component' });

      this.runTask(function () {
        return _this24.rerender();
      });

      this.assertComponentElement(this.firstChild, { content: 'yielded: [hello] - In component' });
    };

    _class.prototype['@test it can render a basic component with a block param when the yield is in a partial'] = function testItCanRenderABasicComponentWithABlockParamWhenTheYieldIsInAPartial() {
      var _this25 = this;

      this.registerPartial('_partialWithYield', 'yielded: [{{yield "hello"}}]');

      this.registerComponent('foo-bar', { template: '{{partial "partialWithYield"}} - In component' });

      this.render('{{#foo-bar as |value|}}{{value}}{{/foo-bar}}');

      this.assertComponentElement(this.firstChild, { content: 'yielded: [hello] - In component' });

      this.runTask(function () {
        return _this25.rerender();
      });

      this.assertComponentElement(this.firstChild, { content: 'yielded: [hello] - In component' });
    };

    _class.prototype['@test it renders the layout with the component instance as the context'] = function testItRendersTheLayoutWithTheComponentInstanceAsTheContext() {
      var _this26 = this;

      var instance = undefined;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super();
          instance = this;
          this.set('message', 'hello');
        }
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: '{{message}}' });

      this.render('{{foo-bar}}');

      this.assertComponentElement(this.firstChild, { content: 'hello' });

      this.runTask(function () {
        return _this26.rerender();
      });

      this.assertComponentElement(this.firstChild, { content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(instance, 'message', 'goodbye');
      });

      this.assertComponentElement(this.firstChild, { content: 'goodbye' });

      this.runTask(function () {
        return _emberMetal.set(instance, 'message', 'hello');
      });

      this.assertComponentElement(this.firstChild, { content: 'hello' });
    };

    _class.prototype['@test it preserves the outer context when yielding'] = function testItPreservesTheOuterContextWhenYielding() {
      var _this27 = this;

      this.registerComponent('foo-bar', { template: '{{yield}}' });

      this.render('{{#foo-bar}}{{message}}{{/foo-bar}}', { message: 'hello' });

      this.assertComponentElement(this.firstChild, { content: 'hello' });

      this.runTask(function () {
        return _this27.rerender();
      });

      this.assertComponentElement(this.firstChild, { content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this27.context, 'message', 'goodbye');
      });

      this.assertComponentElement(this.firstChild, { content: 'goodbye' });

      this.runTask(function () {
        return _emberMetal.set(_this27.context, 'message', 'hello');
      });

      this.assertComponentElement(this.firstChild, { content: 'hello' });
    };

    _class.prototype['@test it can yield a block param named for reserved words [GH#14096]'] = function testItCanYieldABlockParamNamedForReservedWordsGH14096() {
      var instance = undefined;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          instance = this;
        },

        name: 'foo-bar'
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: '{{yield this}}' });

      this.render('{{#foo-bar as |component|}}{{component.name}}{{/foo-bar}}');

      this.assertComponentElement(this.firstChild, { content: 'foo-bar' });

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(instance, 'name', 'derp-qux');
      });

      this.assertComponentElement(this.firstChild, { content: 'derp-qux' });

      this.runTask(function () {
        return _emberMetal.set(instance, 'name', 'foo-bar');
      });

      this.assertComponentElement(this.firstChild, { content: 'foo-bar' });
    };

    _class.prototype['@test it can yield internal and external properties positionally'] = function testItCanYieldInternalAndExternalPropertiesPositionally() {
      var _this28 = this;

      var instance = undefined;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          instance = this;
        },
        greeting: 'hello'
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: '{{yield greeting greetee.firstName}}' });

      this.render('{{#foo-bar greetee=person as |greeting name|}}{{name}} {{person.lastName}}, {{greeting}}{{/foo-bar}}', {
        person: {
          firstName: 'Joel',
          lastName: 'Kang'
        }
      });

      this.assertComponentElement(this.firstChild, { content: 'Joel Kang, hello' });

      this.runTask(function () {
        return _this28.rerender();
      });

      this.assertComponentElement(this.firstChild, { content: 'Joel Kang, hello' });

      this.runTask(function () {
        return _emberMetal.set(_this28.context, 'person', { firstName: 'Dora', lastName: 'the Explorer' });
      });

      this.assertComponentElement(this.firstChild, { content: 'Dora the Explorer, hello' });

      this.runTask(function () {
        return _emberMetal.set(instance, 'greeting', 'hola');
      });

      this.assertComponentElement(this.firstChild, { content: 'Dora the Explorer, hola' });

      this.runTask(function () {
        _emberMetal.set(instance, 'greeting', 'hello');
        _emberMetal.set(_this28.context, 'person', {
          firstName: 'Joel',
          lastName: 'Kang'
        });
      });

      this.assertComponentElement(this.firstChild, { content: 'Joel Kang, hello' });
    };

    _class.prototype['@test #11519 - block param infinite loop'] = function test11519BlockParamInfiniteLoop() {
      var _this29 = this;

      var instance = undefined;
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          instance = this;
        },
        danger: 0
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: '{{danger}}{{yield danger}}' });

      // On initial render, create streams. The bug will not have manifested yet, but at this point
      // we have created streams that create a circular invalidation.
      this.render('{{#foo-bar as |dangerBlockParam|}}{{/foo-bar}}');

      this.assertText('0');

      // Trigger a non-revalidating re-render. The yielded block will not be dirtied
      // nor will block param streams, and thus no infinite loop will occur.
      this.runTask(function () {
        return _this29.rerender();
      });

      this.assertText('0');

      // Trigger a revalidation, which will cause an infinite loop without the fix
      // in place.  Note that we do not see the infinite loop is in testing mode,
      // because a deprecation warning about re-renders is issued, which Ember
      // treats as an exception.
      this.runTask(function () {
        return _emberMetal.set(instance, 'danger', 1);
      });

      this.assertText('1');

      this.runTask(function () {
        return _emberMetal.set(instance, 'danger', 0);
      });

      this.assertText('0');
    };

    _class.prototype['@test the component and its child components are destroyed'] = function testTheComponentAndItsChildComponentsAreDestroyed(assert) {
      var _this30 = this;

      var destroyed = { 1: 0, 2: 0, 3: 0, 4: 0, 5: 0, 6: 0, 7: 0, 8: 0 };

      this.registerComponent('foo-bar', {
        template: '{{id}} {{yield}}',
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          willDestroy: function () {
            this._super();
            destroyed[this.get('id')]++;
          }
        })
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject2), {
        cond1: true,
        cond2: true,
        cond3: true,
        cond4: true,
        cond5: true
      });

      this.assertText('1 2 3 4 5 6 7 8 ');

      this.runTask(function () {
        return _this30.rerender();
      });

      assert.deepEqual(destroyed, { 1: 0, 2: 0, 3: 0, 4: 0, 5: 0, 6: 0, 7: 0, 8: 0 });

      this.runTask(function () {
        return _emberMetal.set(_this30.context, 'cond5', false);
      });

      this.assertText('1 2 3 4 8 ');

      assert.deepEqual(destroyed, { 1: 0, 2: 0, 3: 0, 4: 0, 5: 1, 6: 1, 7: 1, 8: 0 });

      this.runTask(function () {
        _emberMetal.set(_this30.context, 'cond3', false);
        _emberMetal.set(_this30.context, 'cond5', true);
        _emberMetal.set(_this30.context, 'cond4', false);
      });

      assert.deepEqual(destroyed, { 1: 0, 2: 0, 3: 1, 4: 1, 5: 1, 6: 1, 7: 1, 8: 1 });

      this.runTask(function () {
        _emberMetal.set(_this30.context, 'cond2', false);
        _emberMetal.set(_this30.context, 'cond1', false);
      });

      assert.deepEqual(destroyed, { 1: 1, 2: 1, 3: 1, 4: 1, 5: 1, 6: 1, 7: 1, 8: 1 });
    };

    _class.prototype['@test should escape HTML in normal mustaches'] = function testShouldEscapeHTMLInNormalMustaches() {
      var _this31 = this;

      var component = undefined;
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          component = this;
        },
        output: 'you need to be more <b>bold</b>'
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: '{{output}}' });

      this.render('{{foo-bar}}');

      this.assertText('you need to be more <b>bold</b>');

      this.runTask(function () {
        return _this31.rerender();
      });

      this.assertText('you need to be more <b>bold</b>');

      this.runTask(function () {
        return _emberMetal.set(component, 'output', 'you are so <i>super</i>');
      });

      this.assertText('you are so <i>super</i>');

      this.runTask(function () {
        return _emberMetal.set(component, 'output', 'you need to be more <b>bold</b>');
      });
    };

    _class.prototype['@test should not escape HTML in triple mustaches'] = function testShouldNotEscapeHTMLInTripleMustaches(assert) {
      var _this32 = this;

      var expectedHtmlBold = 'you need to be more <b>bold</b>';
      var expectedHtmlItalic = 'you are so <i>super</i>';
      var component = undefined;
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          component = this;
        },
        output: expectedHtmlBold
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: '{{{output}}}' });

      this.render('{{foo-bar}}');

      _emberGlimmerTestsUtilsTestHelpers.equalTokens(this.firstChild, expectedHtmlBold);

      this.runTask(function () {
        return _this32.rerender();
      });

      _emberGlimmerTestsUtilsTestHelpers.equalTokens(this.firstChild, expectedHtmlBold);

      this.runTask(function () {
        return _emberMetal.set(component, 'output', expectedHtmlItalic);
      });

      _emberGlimmerTestsUtilsTestHelpers.equalTokens(this.firstChild, expectedHtmlItalic);

      this.runTask(function () {
        return _emberMetal.set(component, 'output', expectedHtmlBold);
      });

      _emberGlimmerTestsUtilsTestHelpers.equalTokens(this.firstChild, expectedHtmlBold);
    };

    _class.prototype['@test should not escape HTML if string is a htmlSafe'] = function testShouldNotEscapeHTMLIfStringIsAHtmlSafe(assert) {
      var _this33 = this;

      var expectedHtmlBold = 'you need to be more <b>bold</b>';
      var expectedHtmlItalic = 'you are so <i>super</i>';
      var component = undefined;
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          component = this;
        },
        output: _emberGlimmerTestsUtilsHelpers.htmlSafe(expectedHtmlBold)
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: '{{output}}' });

      this.render('{{foo-bar}}');

      _emberGlimmerTestsUtilsTestHelpers.equalTokens(this.firstChild, expectedHtmlBold);

      this.runTask(function () {
        return _this33.rerender();
      });

      _emberGlimmerTestsUtilsTestHelpers.equalTokens(this.firstChild, expectedHtmlBold);

      this.runTask(function () {
        return _emberMetal.set(component, 'output', _emberGlimmerTestsUtilsHelpers.htmlSafe(expectedHtmlItalic));
      });

      _emberGlimmerTestsUtilsTestHelpers.equalTokens(this.firstChild, expectedHtmlItalic);

      this.runTask(function () {
        return _emberMetal.set(component, 'output', _emberGlimmerTestsUtilsHelpers.htmlSafe(expectedHtmlBold));
      });

      _emberGlimmerTestsUtilsTestHelpers.equalTokens(this.firstChild, expectedHtmlBold);
    };

    _class.prototype['@test late bound layouts return the same definition'] = function testLateBoundLayoutsReturnTheSameDefinition(assert) {
      var templateIds = [];

      // This is testing the scenario where you import a template and
      // set it to the layout property:
      //
      // import layout from './template';
      //
      // export default Ember.Component.extend({
      //   layout
      // });
      var hello = _emberGlimmerTestsUtilsHelpers.compile('Hello');
      var bye = _emberGlimmerTestsUtilsHelpers.compile('Bye');

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          this.layout = this.cond ? hello : bye;
          templateIds.push(this.layout.id);
        }
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent });

      this.render('{{foo-bar cond=true}}{{foo-bar cond=false}}{{foo-bar cond=true}}{{foo-bar cond=false}}');

      var t1 = templateIds[0];
      var t2 = templateIds[1];
      var t3 = templateIds[2];
      var t4 = templateIds[3];

      assert.equal(t1, t3);
      assert.equal(t2, t4);
    };

    _class.prototype['@test can use isStream property without conflict (#13271)'] = function testCanUseIsStreamPropertyWithoutConflict13271() {
      var _this34 = this;

      var component = undefined;
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        isStream: true,

        init: function () {
          this._super.apply(this, arguments);
          component = this;
        }
      });

      this.registerComponent('foo-bar', {
        ComponentClass: FooBarComponent,

        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject3)
      });

      this.render('{{foo-bar}}');

      this.assertComponentElement(this.firstChild, { content: 'true' });

      this.runTask(function () {
        return _this34.rerender();
      });

      this.assertComponentElement(this.firstChild, { content: 'true' });

      this.runTask(function () {
        return _emberMetal.set(component, 'isStream', false);
      });

      this.assertComponentElement(this.firstChild, { content: 'false' });

      this.runTask(function () {
        return _emberMetal.set(component, 'isStream', true);
      });

      this.assertComponentElement(this.firstChild, { content: 'true' });
    };

    _class.prototype['@test lookup of component takes priority over property'] = function testLookupOfComponentTakesPriorityOverProperty() {
      var _this35 = this;

      this.registerComponent('some-component', {
        template: 'some-component'
      });

      this.render('{{some-prop}} {{some-component}}', {
        'some-component': 'not-some-component',
        'some-prop': 'some-prop'
      });

      this.assertText('some-prop some-component');

      this.runTask(function () {
        return _this35.rerender();
      });

      this.assertText('some-prop some-component');
    };

    _class.prototype['@test component without dash is not looked up'] = function testComponentWithoutDashIsNotLookedUp() {
      var _this36 = this;

      this.registerComponent('somecomponent', {
        template: 'somecomponent'
      });

      this.render('{{somecomponent}}', {
        'somecomponent': 'notsomecomponent'
      });

      this.assertText('notsomecomponent');

      this.runTask(function () {
        return _this36.rerender();
      });

      this.assertText('notsomecomponent');

      this.runTask(function () {
        return _this36.context.set('somecomponent', 'not not notsomecomponent');
      });

      this.assertText('not not notsomecomponent');

      this.runTask(function () {
        return _this36.context.set('somecomponent', 'notsomecomponent');
      });

      this.assertText('notsomecomponent');
    };

    _class.prototype['@test non-block with properties on attrs'] = function testNonBlockWithPropertiesOnAttrs() {
      var _this37 = this;

      this.registerComponent('non-block', {
        template: 'In layout - someProp: {{attrs.someProp}}'
      });

      this.render('{{non-block someProp=prop}}', {
        prop: 'something here'
      });

      this.assertText('In layout - someProp: something here');

      this.runTask(function () {
        return _this37.rerender();
      });

      this.assertText('In layout - someProp: something here');

      this.runTask(function () {
        return _this37.context.set('prop', 'other thing there');
      });

      this.assertText('In layout - someProp: other thing there');

      this.runTask(function () {
        return _this37.context.set('prop', 'something here');
      });

      this.assertText('In layout - someProp: something here');
    };

    _class.prototype['@test non-block with properties overridden in init'] = function testNonBlockWithPropertiesOverriddenInInit() {
      var _this38 = this;

      var instance = undefined;
      this.registerComponent('non-block', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            instance = this;
            this.someProp = 'value set in instance';
          }
        }),
        template: 'In layout - someProp: {{someProp}}'
      });

      this.render('{{non-block someProp=prop}}', {
        prop: 'something passed when invoked'
      });

      this.assertText('In layout - someProp: value set in instance');

      this.runTask(function () {
        return _this38.rerender();
      });

      this.assertText('In layout - someProp: value set in instance');

      this.runTask(function () {
        return _this38.context.set('prop', 'updated something passed when invoked');
      });

      this.assertText('In layout - someProp: updated something passed when invoked');

      this.runTask(function () {
        return instance.set('someProp', 'update value set in instance');
      });

      this.assertText('In layout - someProp: update value set in instance');

      this.runTask(function () {
        return _this38.context.set('prop', 'something passed when invoked');
      });
      this.runTask(function () {
        return instance.set('someProp', 'value set in instance');
      });

      this.assertText('In layout - someProp: value set in instance');
    };

    _class.prototype['@test rerendering component with attrs from parent'] = function testRerenderingComponentWithAttrsFromParent(assert) {
      var _this39 = this;

      var willUpdateCount = 0;
      var didReceiveAttrsCount = 0;

      function expectHooks(_ref, callback) {
        var willUpdate = _ref.willUpdate;
        var didReceiveAttrs = _ref.didReceiveAttrs;

        willUpdateCount = 0;
        didReceiveAttrsCount = 0;

        callback();

        if (willUpdate) {
          assert.strictEqual(willUpdateCount, 1, 'The willUpdate hook was fired');
        } else {
          assert.strictEqual(willUpdateCount, 0, 'The willUpdate hook was not fired');
        }

        if (didReceiveAttrs) {
          assert.strictEqual(didReceiveAttrsCount, 1, 'The didReceiveAttrs hook was fired');
        } else {
          assert.strictEqual(didReceiveAttrsCount, 0, 'The didReceiveAttrs hook was not fired');
        }
      }

      this.registerComponent('non-block', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          didReceiveAttrs: function () {
            didReceiveAttrsCount++;
          },

          willUpdate: function () {
            willUpdateCount++;
          }
        }),
        template: 'In layout - someProp: {{someProp}}'
      });

      expectHooks({ willUpdate: false, didReceiveAttrs: true }, function () {
        _this39.render('{{non-block someProp=someProp}}', {
          someProp: 'wycats'
        });
      });

      this.assertText('In layout - someProp: wycats');

      // Note: Hooks are not fired in Glimmer for idempotent re-renders
      expectHooks({ willUpdate: false, didReceiveAttrs: false }, function () {
        _this39.runTask(function () {
          return _this39.rerender();
        });
      });

      this.assertText('In layout - someProp: wycats');

      expectHooks({ willUpdate: true, didReceiveAttrs: true }, function () {
        _this39.runTask(function () {
          return _this39.context.set('someProp', 'tomdale');
        });
      });

      this.assertText('In layout - someProp: tomdale');

      // Note: Hooks are not fired in Glimmer for idempotent re-renders
      expectHooks({ willUpdate: false, didReceiveAttrs: false }, function () {
        _this39.runTask(function () {
          return _this39.rerender();
        });
      });

      this.assertText('In layout - someProp: tomdale');

      expectHooks({ willUpdate: true, didReceiveAttrs: true }, function () {
        _this39.runTask(function () {
          return _this39.context.set('someProp', 'wycats');
        });
      });

      this.assertText('In layout - someProp: wycats');
    };

    _class.prototype['@test this.attrs.foo === attrs.foo === foo'] = function testThisAttrsFooAttrsFooFoo() {
      var _this40 = this;

      this.registerComponent('foo-bar', {
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject4)
      });

      this.render('{{foo-bar value=model.value items=model.items}}', {
        model: {
          value: 'wat',
          items: [1, 2, 3]
        }
      });

      this.assertStableRerender();

      this.runTask(function () {
        _this40.context.set('model.value', 'lul');
        _this40.context.set('model.items', [1]);
      });

      this.assertText(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject5));

      this.runTask(function () {
        return _this40.context.set('model', { value: 'wat', items: [1, 2, 3] });
      });

      this.assertText('Args: wat | wat | wat123123123');
    };

    _class.prototype['@test non-block with properties on self'] = function testNonBlockWithPropertiesOnSelf() {
      var _this41 = this;

      this.registerComponent('non-block', {
        template: 'In layout - someProp: {{someProp}}'
      });

      this.render('{{non-block someProp=prop}}', {
        prop: 'something here'
      });

      this.assertText('In layout - someProp: something here');

      this.runTask(function () {
        return _this41.rerender();
      });

      this.assertText('In layout - someProp: something here');

      this.runTask(function () {
        return _this41.context.set('prop', 'something else');
      });

      this.assertText('In layout - someProp: something else');

      this.runTask(function () {
        return _this41.context.set('prop', 'something here');
      });

      this.assertText('In layout - someProp: something here');
    };

    _class.prototype['@test block with properties on self'] = function testBlockWithPropertiesOnSelf() {
      var _this42 = this;

      this.registerComponent('with-block', {
        template: 'In layout - someProp: {{someProp}} - {{yield}}'
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject6), {
        prop: 'something here'
      });

      this.assertText('In layout - someProp: something here - In template');

      this.runTask(function () {
        return _this42.rerender();
      });

      this.assertText('In layout - someProp: something here - In template');

      this.runTask(function () {
        return _this42.context.set('prop', 'something else');
      });

      this.assertText('In layout - someProp: something else - In template');

      this.runTask(function () {
        return _this42.context.set('prop', 'something here');
      });

      this.assertText('In layout - someProp: something here - In template');
    };

    _class.prototype['@test block with properties on attrs'] = function testBlockWithPropertiesOnAttrs() {
      var _this43 = this;

      this.registerComponent('with-block', {
        template: 'In layout - someProp: {{attrs.someProp}} - {{yield}}'
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject6), {
        prop: 'something here'
      });

      this.assertText('In layout - someProp: something here - In template');

      this.runTask(function () {
        return _this43.rerender();
      });

      this.assertText('In layout - someProp: something here - In template');

      this.runTask(function () {
        return _this43.context.set('prop', 'something else');
      });

      this.assertText('In layout - someProp: something else - In template');

      this.runTask(function () {
        return _this43.context.set('prop', 'something here');
      });

      this.assertText('In layout - someProp: something here - In template');
    };

    _class.prototype['@test static arbitrary number of positional parameters'] = function testStaticArbitraryNumberOfPositionalParameters(assert) {
      var _this44 = this;

      this.registerComponent('sample-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: 'names'
        }),
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject7)
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject8));

      assert.equal(this.$('#args-3').text(), 'Foo4Bar');
      assert.equal(this.$('#args-5').text(), 'Foo4Bar5Baz');

      this.runTask(function () {
        return _this44.rerender();
      });

      assert.equal(this.$('#args-3').text(), 'Foo4Bar');
      assert.equal(this.$('#args-5').text(), 'Foo4Bar5Baz');
    };

    _class.prototype['@test arbitrary positional parameter conflict with hash parameter is reported'] = function testArbitraryPositionalParameterConflictWithHashParameterIsReported() {
      var _this45 = this;

      this.registerComponent('sample-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: 'names'
        }),
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject7)
      });

      expectAssertion(function () {
        _this45.render('{{sample-component "Foo" 4 "Bar" names=numbers id="args-3"}}', {
          numbers: [1, 2, 3]
        });
      }, 'You cannot specify positional parameters and the hash argument `names`.');
    };

    _class.prototype['@test can use hash parameter instead of arbitrary positional param [GH #12444]'] = function testCanUseHashParameterInsteadOfArbitraryPositionalParamGH12444(assert) {
      var _this46 = this;

      this.registerComponent('sample-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: 'names'
        }),
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject7)
      });

      this.render('{{sample-component names=things}}', {
        things: _emberRuntime.A(['Foo', 4, 'Bar'])
      });

      this.assertText('Foo4Bar');

      this.runTask(function () {
        return _this46.rerender();
      });

      this.assertText('Foo4Bar');

      this.runTask(function () {
        return _this46.context.get('things').pushObject(5);
      });

      this.assertText('Foo4Bar5');

      this.runTask(function () {
        return _this46.context.get('things').shiftObject();
      });

      this.assertText('4Bar5');

      this.runTask(function () {
        return _this46.context.get('things').clear();
      });

      this.assertText('');

      this.runTask(function () {
        return _this46.context.set('things', _emberRuntime.A(['Foo', 4, 'Bar']));
      });

      this.assertText('Foo4Bar');
    };

    _class.prototype['@test can use hash parameter instead of positional param'] = function testCanUseHashParameterInsteadOfPositionalParam(assert) {
      var _this47 = this;

      this.registerComponent('sample-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: ['first', 'second']
        }),
        template: '{{first}} - {{second}}'
      });

      // TODO: Fix when id is implemented
      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject9));

      assert.equal(this.$('#two-positional').text(), 'one - two');
      assert.equal(this.$('#one-positional').text(), 'one - two');
      assert.equal(this.$('#no-positional').text(), 'one - two');

      this.runTask(function () {
        return _this47.rerender();
      });

      assert.equal(this.$('#two-positional').text(), 'one - two');
      assert.equal(this.$('#one-positional').text(), 'one - two');
      assert.equal(this.$('#no-positional').text(), 'one - two');
    };

    _class.prototype['@test dynamic arbitrary number of positional parameters'] = function testDynamicArbitraryNumberOfPositionalParameters(assert) {
      var _this48 = this;

      this.registerComponent('sample-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: 'n'
        }),
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject10)
      });

      this.render('{{sample-component user1 user2}}', {
        user1: 'Foo',
        user2: 4
      });

      this.assertText('Foo4');

      this.runTask(function () {
        return _this48.rerender();
      });

      this.assertText('Foo4');

      this.runTask(function () {
        return _this48.context.set('user1', 'Bar');
      });

      this.assertText('Bar4');

      this.runTask(function () {
        return _this48.context.set('user2', '5');
      });

      this.assertText('Bar5');

      this.runTask(function () {
        _this48.context.set('user1', 'Foo');
        _this48.context.set('user2', 4);
      });

      this.assertText('Foo4');
    };

    _class.prototype['@test with ariaRole specified'] = function testWithAriaRoleSpecified() {
      var _this49 = this;

      this.registerComponent('aria-test', {
        template: 'Here!'
      });

      this.render('{{aria-test ariaRole=role}}', {
        role: 'main'
      });

      this.assertComponentElement(this.firstChild, { attrs: { role: 'main' } });

      this.runTask(function () {
        return _this49.rerender();
      });

      this.assertComponentElement(this.firstChild, { attrs: { role: 'main' } });

      this.runTask(function () {
        return _this49.context.set('role', 'input');
      });

      this.assertComponentElement(this.firstChild, { attrs: { role: 'input' } });

      this.runTask(function () {
        return _this49.context.set('role', 'main');
      });

      this.assertComponentElement(this.firstChild, { attrs: { role: 'main' } });
    };

    _class.prototype['@test `template` specified in component is overriden by block'] = function testTemplateSpecifiedInComponentIsOverridenByBlock() {
      var _this50 = this;

      this.registerComponent('with-template', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          template: _emberGlimmerTestsUtilsHelpers.compile('Should not be used')
        }),
        template: '[In layout - {{name}}] {{yield}}'
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject11), {
        name: 'Whoop, whoop!'
      });

      this.assertText('[In layout - with-block] [In block - Whoop, whoop!][In layout - without-block] ');

      this.runTask(function () {
        return _this50.rerender();
      });

      this.assertText('[In layout - with-block] [In block - Whoop, whoop!][In layout - without-block] ');

      this.runTask(function () {
        return _this50.context.set('name', 'Ole, ole');
      });

      this.assertText('[In layout - with-block] [In block - Ole, ole][In layout - without-block] ');

      this.runTask(function () {
        return _this50.context.set('name', 'Whoop, whoop!');
      });

      this.assertText('[In layout - with-block] [In block - Whoop, whoop!][In layout - without-block] ');
    };

    _class.prototype['@test hasBlock is true when block supplied'] = function testHasBlockIsTrueWhenBlockSupplied() {
      var _this51 = this;

      this.registerComponent('with-block', {
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject12)
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject13));

      this.assertText('In template');

      this.runTask(function () {
        return _this51.rerender();
      });

      this.assertText('In template');
    };

    _class.prototype['@test hasBlock is false when no block supplied'] = function testHasBlockIsFalseWhenNoBlockSupplied() {
      var _this52 = this;

      this.registerComponent('with-block', {
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject12)
      });

      this.render('{{with-block}}');

      this.assertText('No Block!');

      this.runTask(function () {
        return _this52.rerender();
      });

      this.assertText('No Block!');
    };

    _class.prototype['@test hasBlockParams is true when block param supplied'] = function testHasBlockParamsIsTrueWhenBlockParamSupplied() {
      var _this53 = this;

      this.registerComponent('with-block', {
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject14)
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject15));

      this.assertText('In template - In Component');

      this.runTask(function () {
        return _this53.rerender();
      });

      this.assertText('In template - In Component');
    };

    _class.prototype['@test hasBlockParams is false when no block param supplied'] = function testHasBlockParamsIsFalseWhenNoBlockParamSupplied() {
      var _this54 = this;

      this.registerComponent('with-block', {
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject16)
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject17));

      this.assertText('In block No Block Param!');

      this.runTask(function () {
        return _this54.rerender();
      });

      this.assertText('In block No Block Param!');
    };

    _class.prototype['@test static named positional parameters'] = function testStaticNamedPositionalParameters() {
      var _this55 = this;

      this.registerComponent('sample-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: ['name', 'age']
        }),
        template: '{{name}}{{age}}'
      });

      this.render('{{sample-component "Quint" 4}}');

      this.assertText('Quint4');

      this.runTask(function () {
        return _this55.rerender();
      });

      this.assertText('Quint4');
    };

    _class.prototype['@test dynamic named positional parameters'] = function testDynamicNamedPositionalParameters() {
      var _this56 = this;

      this.registerComponent('sample-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: ['name', 'age']
        }),
        template: '{{name}}{{age}}'
      });

      this.render('{{sample-component myName myAge}}', {
        myName: 'Quint',
        myAge: 4
      });

      this.assertText('Quint4');

      this.runTask(function () {
        return _this56.rerender();
      });

      this.assertText('Quint4');

      this.runTask(function () {
        return _this56.context.set('myName', 'Sergio');
      });

      this.assertText('Sergio4');

      this.runTask(function () {
        return _this56.context.set('myAge', 2);
      });

      this.assertText('Sergio2');

      this.runTask(function () {
        _this56.context.set('myName', 'Quint');
        _this56.context.set('myAge', 4);
      });

      this.assertText('Quint4');
    };

    _class.prototype['@test if a value is passed as a non-positional parameter, it raises an assertion'] = function testIfAValueIsPassedAsANonPositionalParameterItRaisesAnAssertion() {
      var _this57 = this;

      this.registerComponent('sample-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: ['name']
        }),
        template: '{{name}}'
      });

      expectAssertion(function () {
        _this57.render('{{sample-component notMyName name=myName}}', {
          myName: 'Quint',
          notMyName: 'Sergio'
        });
      }, 'You cannot specify both a positional param (at position 0) and the hash argument `name`.');
    };

    _class.prototype['@test yield to inverse'] = function testYieldToInverse() {
      var _this58 = this;

      this.registerComponent('my-if', {
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject18)
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject19), {
        activated: true
      });

      this.assertText('Yes:Hello42');

      this.runTask(function () {
        return _this58.rerender();
      });

      this.assertText('Yes:Hello42');

      this.runTask(function () {
        return _this58.context.set('activated', false);
      });

      this.assertText('No:Goodbye');

      this.runTask(function () {
        return _this58.context.set('activated', true);
      });

      this.assertText('Yes:Hello42');
    };

    _class.prototype['@test expression hasBlock inverse'] = function testExpressionHasBlockInverse(assert) {
      this.registerComponent('check-inverse', {
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject20)
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject21));

      this.assertComponentElement(this.firstChild, { content: 'No' });
      this.assertComponentElement(this.nthChild(1), { content: 'Yes' });

      this.assertStableRerender();
    };

    _class.prototype['@test expression hasBlock default'] = function testExpressionHasBlockDefault(assert) {
      this.registerComponent('check-block', {
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject22)
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject23));

      this.assertComponentElement(this.firstChild, { content: 'No' });
      this.assertComponentElement(this.nthChild(1), { content: 'Yes' });

      this.assertStableRerender();
    };

    _class.prototype['@test expression hasBlockParams inverse'] = function testExpressionHasBlockParamsInverse(assert) {
      this.registerComponent('check-inverse', {
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject24)
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject25));

      this.assertComponentElement(this.firstChild, { content: 'No' });
      this.assertComponentElement(this.nthChild(1), { content: 'No' });

      this.assertStableRerender();
    };

    _class.prototype['@test expression hasBlockParams default'] = function testExpressionHasBlockParamsDefault(assert) {
      this.registerComponent('check-block', {
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject26)
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject27));

      this.assertComponentElement(this.firstChild, { content: 'No' });
      this.assertComponentElement(this.nthChild(1), { content: 'Yes' });

      this.assertStableRerender();
    };

    _class.prototype['@test non-expression hasBlock'] = function testNonExpressionHasBlock(assert) {
      this.registerComponent('check-block', {
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject28)
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject23));

      this.assertComponentElement(this.firstChild, { content: 'No' });
      this.assertComponentElement(this.nthChild(1), { content: 'Yes' });

      this.assertStableRerender();
    };

    _class.prototype['@test expression hasBlockParams'] = function testExpressionHasBlockParams(assert) {
      this.registerComponent('check-params', {
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject26)
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject29));

      this.assertComponentElement(this.firstChild, { content: 'No' });
      this.assertComponentElement(this.nthChild(1), { content: 'Yes' });

      this.assertStableRerender();
    };

    _class.prototype['@test non-expression hasBlockParams'] = function testNonExpressionHasBlockParams(assert) {
      this.registerComponent('check-params', {
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject30)
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject29));

      this.assertComponentElement(this.firstChild, { content: 'No' });
      this.assertComponentElement(this.nthChild(1), { content: 'Yes' });

      this.assertStableRerender();
    };

    _class.prototype['@test hasBlock expression in an attribute'] = function testHasBlockExpressionInAnAttribute(assert) {
      this.registerComponent('check-attr', {
        template: '<button name={{hasBlock}}></button>'
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject31));

      _emberGlimmerTestsUtilsTestHelpers.equalsElement(this.$('button')[0], 'button', { name: 'false' }, '');
      _emberGlimmerTestsUtilsTestHelpers.equalsElement(this.$('button')[1], 'button', { name: 'true' }, '');

      this.assertStableRerender();
    };

    _class.prototype['@test hasBlock inverse expression in an attribute'] = function testHasBlockInverseExpressionInAnAttribute(assert) {
      this.registerComponent('check-attr', {
        template: '<button name={{hasBlock "inverse"}}></button>'
      }, '');

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject32));

      _emberGlimmerTestsUtilsTestHelpers.equalsElement(this.$('button')[0], 'button', { name: 'false' }, '');
      _emberGlimmerTestsUtilsTestHelpers.equalsElement(this.$('button')[1], 'button', { name: 'true' }, '');

      this.assertStableRerender();
    };

    _class.prototype['@test hasBlockParams expression in an attribute'] = function testHasBlockParamsExpressionInAnAttribute(assert) {
      this.registerComponent('check-attr', {
        template: '<button name={{hasBlockParams}}></button>'
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject33));

      _emberGlimmerTestsUtilsTestHelpers.equalsElement(this.$('button')[0], 'button', { name: 'false' }, '');
      _emberGlimmerTestsUtilsTestHelpers.equalsElement(this.$('button')[1], 'button', { name: 'true' }, '');

      this.assertStableRerender();
    };

    _class.prototype['@test hasBlockParams inverse expression in an attribute'] = function testHasBlockParamsInverseExpressionInAnAttribute(assert) {
      this.registerComponent('check-attr', {
        template: '<button name={{hasBlockParams "inverse"}}></button>'
      }, '');

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject33));

      _emberGlimmerTestsUtilsTestHelpers.equalsElement(this.$('button')[0], 'button', { name: 'false' }, '');
      _emberGlimmerTestsUtilsTestHelpers.equalsElement(this.$('button')[1], 'button', { name: 'false' }, '');

      this.assertStableRerender();
    };

    _class.prototype['@test hasBlock as a param to a helper'] = function testHasBlockAsAParamToAHelper(assert) {
      this.registerComponent('check-helper', {
        template: '{{if hasBlock "true" "false"}}'
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject34));

      this.assertComponentElement(this.firstChild, { content: 'false' });
      this.assertComponentElement(this.nthChild(1), { content: 'true' });

      this.assertStableRerender();
    };

    _class.prototype['@test hasBlock as an expression param to a helper'] = function testHasBlockAsAnExpressionParamToAHelper(assert) {
      this.registerComponent('check-helper', {
        template: '{{if (hasBlock) "true" "false"}}'
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject34));

      this.assertComponentElement(this.firstChild, { content: 'false' });
      this.assertComponentElement(this.nthChild(1), { content: 'true' });

      this.assertStableRerender();
    };

    _class.prototype['@test hasBlock inverse as a param to a helper'] = function testHasBlockInverseAsAParamToAHelper(assert) {
      this.registerComponent('check-helper', {
        template: '{{if (hasBlock "inverse") "true" "false"}}'
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject35));

      this.assertComponentElement(this.firstChild, { content: 'false' });
      this.assertComponentElement(this.nthChild(1), { content: 'true' });

      this.assertStableRerender();
    };

    _class.prototype['@test hasBlockParams as a param to a helper'] = function testHasBlockParamsAsAParamToAHelper(assert) {
      this.registerComponent('check-helper', {
        template: '{{if hasBlockParams "true" "false"}}'
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject36));

      this.assertComponentElement(this.firstChild, { content: 'false' });
      this.assertComponentElement(this.nthChild(1), { content: 'true' });

      this.assertStableRerender();
    };

    _class.prototype['@test hasBlockParams as an expression param to a helper'] = function testHasBlockParamsAsAnExpressionParamToAHelper(assert) {
      this.registerComponent('check-helper', {
        template: '{{if (hasBlockParams) "true" "false"}}'
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject36));

      this.assertComponentElement(this.firstChild, { content: 'false' });
      this.assertComponentElement(this.nthChild(1), { content: 'true' });

      this.assertStableRerender();
    };

    _class.prototype['@test hasBlockParams inverse as a param to a helper'] = function testHasBlockParamsInverseAsAParamToAHelper(assert) {
      this.registerComponent('check-helper', {
        template: '{{if (hasBlockParams "inverse") "true" "false"}}'
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject36));

      this.assertComponentElement(this.firstChild, { content: 'false' });
      this.assertComponentElement(this.nthChild(1), { content: 'false' });

      this.assertStableRerender();
    };

    _class.prototype['@test component in template of a yielding component should have the proper parentView'] = function testComponentInTemplateOfAYieldingComponentShouldHaveTheProperParentView(assert) {
      var _this59 = this;

      var outer = undefined,
          innerTemplate = undefined,
          innerLayout = undefined;

      this.registerComponent('x-outer', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            outer = this;
          }
        }),
        template: '{{x-inner-in-layout}}{{yield}}'
      });

      this.registerComponent('x-inner-in-template', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            innerTemplate = this;
          }
        })
      });

      this.registerComponent('x-inner-in-layout', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            innerLayout = this;
          }
        })
      });

      this.render('{{#x-outer}}{{x-inner-in-template}}{{/x-outer}}');

      assert.equal(innerTemplate.parentView, outer, 'receives the wrapping component as its parentView in template blocks');
      assert.equal(innerLayout.parentView, outer, 'receives the wrapping component as its parentView in layout');
      assert.equal(outer.parentView, this.context, 'x-outer receives the ambient scope as its parentView');

      this.runTask(function () {
        return _this59.rerender();
      });

      assert.equal(innerTemplate.parentView, outer, 'receives the wrapping component as its parentView in template blocks');
      assert.equal(innerLayout.parentView, outer, 'receives the wrapping component as its parentView in layout');
      assert.equal(outer.parentView, this.context, 'x-outer receives the ambient scope as its parentView');
    };

    _class.prototype['@test newly-added sub-components get correct parentView'] = function testNewlyAddedSubComponentsGetCorrectParentView(assert) {
      var _this60 = this;

      var outer = undefined,
          inner = undefined;

      this.registerComponent('x-outer', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            outer = this;
          }
        })
      });

      this.registerComponent('x-inner', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            inner = this;
          }
        })
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject37), {
        showInner: false
      });

      assert.equal(outer.parentView, this.context, 'x-outer receives the ambient scope as its parentView');

      this.runTask(function () {
        return _this60.rerender();
      });

      assert.equal(outer.parentView, this.context, 'x-outer receives the ambient scope as its parentView (after rerender)');

      this.runTask(function () {
        return _this60.context.set('showInner', true);
      });

      assert.equal(outer.parentView, this.context, 'x-outer receives the ambient scope as its parentView');
      assert.equal(inner.parentView, outer, 'receives the wrapping component as its parentView in template blocks');

      this.runTask(function () {
        return _this60.context.set('showInner', false);
      });

      assert.equal(outer.parentView, this.context, 'x-outer receives the ambient scope as its parentView');
    };

    _class.prototype['@test when a property is changed during children\'s rendering'] = function testWhenAPropertyIsChangedDuringChildrenSRendering(assert) {
      var _this61 = this;

      var outer = undefined,
          middle = undefined;

      this.registerComponent('x-outer', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            outer = this;
          },
          value: 1
        }),
        template: '{{#x-middle}}{{x-inner value=value}}{{/x-middle}}'
      });

      this.registerComponent('x-middle', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            middle = this;
          },
          value: null
        }),
        template: '<div id="middle-value">{{value}}</div>{{yield}}'
      });

      this.registerComponent('x-inner', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          value: null,
          pushDataUp: _emberMetal.observer('value', function () {
            middle.set('value', this.get('value'));
          })
        }),
        template: '<div id="inner-value">{{value}}</div>'
      });

      this.render('{{x-outer}}');

      assert.equal(this.$('#inner-value').text(), '1', 'initial render of inner');
      assert.equal(this.$('#middle-value').text(), '', 'initial render of middle (observers do not run during init)');

      this.runTask(function () {
        return _this61.rerender();
      });

      assert.equal(this.$('#inner-value').text(), '1', 'initial render of inner');
      assert.equal(this.$('#middle-value').text(), '', 'initial render of middle (observers do not run during init)');

      var expectedBacktrackingMessage = /modified "value" twice on <\(.+> in a single render\. It was rendered in "component:x-middle" and modified in "component:x-inner"/;

      if (false) {
        expectDeprecation(expectedBacktrackingMessage);
        this.runTask(function () {
          return outer.set('value', 2);
        });
      } else {
        expectAssertion(function () {
          _this61.runTask(function () {
            return outer.set('value', 2);
          });
        }, expectedBacktrackingMessage);

        return;
      }

      assert.equal(this.$('#inner-value').text(), '2', 'second render of inner');
      assert.equal(this.$('#middle-value').text(), '2', 'second render of middle');

      this.runTask(function () {
        return outer.set('value', 3);
      });

      assert.equal(this.$('#inner-value').text(), '3', 'third render of inner');
      assert.equal(this.$('#middle-value').text(), '3', 'third render of middle');

      this.runTask(function () {
        return outer.set('value', 1);
      });

      assert.equal(this.$('#inner-value').text(), '1', 'reset render of inner');
      assert.equal(this.$('#middle-value').text(), '1', 'reset render of middle');
    };

    _class.prototype['@test when a shared dependency is changed during children\'s rendering'] = function testWhenASharedDependencyIsChangedDuringChildrenSRendering(assert) {
      var _this62 = this;

      var outer = undefined;

      this.registerComponent('x-outer', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            outer = this;
          },
          value: 1,
          wrapper: _emberRuntime.Object.create({ content: null })
        }),
        template: '<div id="outer-value">{{wrapper.content}}</div> {{x-inner value=value wrapper=wrapper}}'
      });

      this.registerComponent('x-inner', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          didReceiveAttrs: function () {
            this.get('wrapper').set('content', this.get('value'));
          },
          value: null
        }),
        template: '<div id="inner-value">{{wrapper.content}}</div>'
      });

      var expectedBacktrackingMessage = /modified "wrapper\.content" twice on <Ember\.Object.+> in a single render\. It was rendered in "component:x-outer" and modified in "component:x-inner"/;

      if (false) {
        expectDeprecation(expectedBacktrackingMessage);
        this.render('{{x-outer}}');
      } else {
        expectAssertion(function () {
          _this62.render('{{x-outer}}');
        }, expectedBacktrackingMessage);

        return;
      }

      assert.equal(this.$('#inner-value').text(), '1', 'initial render of inner');
      assert.equal(this.$('#outer-value').text(), '1', 'initial render of outer');

      this.runTask(function () {
        return _this62.rerender();
      });

      assert.equal(this.$('#inner-value').text(), '1', 're-render of inner');
      assert.equal(this.$('#outer-value').text(), '1', 're-render of outer');

      this.runTask(function () {
        return outer.set('value', 2);
      });

      assert.equal(this.$('#inner-value').text(), '2', 'second render of inner');
      assert.equal(this.$('#outer-value').text(), '2', 'second render of outer');

      this.runTask(function () {
        return outer.set('value', 3);
      });

      assert.equal(this.$('#inner-value').text(), '3', 'third render of inner');
      assert.equal(this.$('#outer-value').text(), '3', 'third render of outer');

      this.runTask(function () {
        return outer.set('value', 1);
      });

      assert.equal(this.$('#inner-value').text(), '1', 'reset render of inner');
      assert.equal(this.$('#outer-value').text(), '1', 'reset render of outer');
    };

    _class.prototype['@test non-block with each rendering child components'] = function testNonBlockWithEachRenderingChildComponents() {
      var _this63 = this;

      this.registerComponent('non-block', {
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject38)
      });

      this.registerComponent('child-non-block', {
        template: 'Child: {{item}}.'
      });

      var items = _emberRuntime.A(['Tom', 'Dick', 'Harry']);

      this.render('{{non-block items=items}}', { items: items });

      this.assertText('In layout. [Child: Tom.][Child: Dick.][Child: Harry.]');

      this.runTask(function () {
        return _this63.rerender();
      });

      this.assertText('In layout. [Child: Tom.][Child: Dick.][Child: Harry.]');

      this.runTask(function () {
        return _this63.context.get('items').pushObject('Sergio');
      });

      this.assertText('In layout. [Child: Tom.][Child: Dick.][Child: Harry.][Child: Sergio.]');

      this.runTask(function () {
        return _this63.context.get('items').shiftObject();
      });

      this.assertText('In layout. [Child: Dick.][Child: Harry.][Child: Sergio.]');

      this.runTask(function () {
        return _this63.context.set('items', _emberRuntime.A(['Tom', 'Dick', 'Harry']));
      });

      this.assertText('In layout. [Child: Tom.][Child: Dick.][Child: Harry.]');
    };

    _class.prototype['@test specifying classNames results in correct class'] = function testSpecifyingClassNamesResultsInCorrectClass(assert) {
      var _this64 = this;

      this.registerComponent('some-clicky-thing', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          tagName: 'button',
          classNames: ['foo', 'bar']
        })
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject39));

      // TODO: ember-view is no longer viewable in the classNames array. Bug or
      // feature?
      var expectedClassNames = ['ember-view', 'foo', 'bar', 'baz'];

      assert.ok(this.$('button').is('.foo.bar.baz.ember-view'), 'the element has the correct classes: ' + this.$('button').attr('class'));
      // `ember-view` is no longer in classNames.
      // assert.deepEqual(clickyThing.get('classNames'), expectedClassNames, 'classNames are properly combined');
      this.assertComponentElement(this.firstChild, { tagName: 'button', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes(expectedClassNames.join(' ')) } });

      this.runTask(function () {
        return _this64.rerender();
      });

      assert.ok(this.$('button').is('.foo.bar.baz.ember-view'), 'the element has the correct classes: ' + this.$('button').attr('class') + ' (rerender)');
      // `ember-view` is no longer in classNames.
      // assert.deepEqual(clickyThing.get('classNames'), expectedClassNames, 'classNames are properly combined (rerender)');
      this.assertComponentElement(this.firstChild, { tagName: 'button', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes(expectedClassNames.join(' ')) } });
    };

    _class.prototype['@test specifying custom concatenatedProperties avoids clobbering'] = function testSpecifyingCustomConcatenatedPropertiesAvoidsClobbering(assert) {
      var _this65 = this;

      this.registerComponent('some-clicky-thing', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          concatenatedProperties: ['blahzz'],
          blahzz: ['blark', 'pory']
        }),
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject40)
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject41));

      this.assertText('blarkporybaz- Click Me');

      this.runTask(function () {
        return _this65.rerender();
      });

      this.assertText('blarkporybaz- Click Me');
    };

    _class.prototype['@test a two way binding flows upstream when consumed in the template'] = function testATwoWayBindingFlowsUpstreamWhenConsumedInTheTemplate() {
      var _this66 = this;

      var component = undefined;
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          component = this;
        }
      });

      this.registerComponent('foo-bar', {
        ComponentClass: FooBarComponent,

        template: '{{bar}}'
      });

      this.render('{{localBar}} - {{foo-bar bar=localBar}}', {
        localBar: 'initial value'
      });

      this.assertText('initial value - initial value');

      this.runTask(function () {
        return _this66.rerender();
      });

      this.assertText('initial value - initial value');

      if (false) {
        expectAssertion(function () {
          component.bar = 'foo-bar';
        }, /You must use Ember\.set\(\) to set the `bar` property \(of .+\) to `foo-bar`\./);

        this.assertText('initial value - initial value');
      }

      this.runTask(function () {
        component.set('bar', 'updated value');
      });

      this.assertText('updated value - updated value');

      this.runTask(function () {
        component.set('bar', undefined);
      });

      this.assertText(' - ');

      this.runTask(function () {
        _this66.component.set('localBar', 'initial value');
      });

      this.assertText('initial value - initial value');
    };

    _class.prototype['@test a two way binding flows upstream through a CP when consumed in the template'] = function testATwoWayBindingFlowsUpstreamThroughACPWhenConsumedInTheTemplate() {
      var _this67 = this;

      var component = undefined;
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          component = this;
        },

        bar: _emberMetal.computed({
          get: function () {
            return this._bar;
          },

          set: function (key, value) {
            this._bar = value;
            return this._bar;
          }
        })
      });

      this.registerComponent('foo-bar', {
        ComponentClass: FooBarComponent,

        template: '{{bar}}'
      });

      this.render('{{localBar}} - {{foo-bar bar=localBar}}', {
        localBar: 'initial value'
      });

      this.assertText('initial value - initial value');

      this.runTask(function () {
        return _this67.rerender();
      });

      this.assertText('initial value - initial value');

      this.runTask(function () {
        component.set('bar', 'updated value');
      });

      this.assertText('updated value - updated value');

      this.runTask(function () {
        _this67.component.set('localBar', 'initial value');
      });

      this.assertText('initial value - initial value');
    };

    _class.prototype['@test a two way binding flows upstream through a CP without template consumption'] = function testATwoWayBindingFlowsUpstreamThroughACPWithoutTemplateConsumption() {
      var _this68 = this;

      var component = undefined;
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          component = this;
        },

        bar: _emberMetal.computed({
          get: function () {
            return this._bar;
          },

          set: function (key, value) {
            this._bar = value;
            return this._bar;
          }
        })
      });

      this.registerComponent('foo-bar', {
        ComponentClass: FooBarComponent,
        template: ''
      });

      this.render('{{localBar}}{{foo-bar bar=localBar}}', {
        localBar: 'initial value'
      });

      this.assertText('initial value');

      this.runTask(function () {
        return _this68.rerender();
      });

      this.assertText('initial value');

      this.runTask(function () {
        component.set('bar', 'updated value');
      });

      this.assertText('updated value');

      this.runTask(function () {
        _this68.component.set('localBar', 'initial value');
      });

      this.assertText('initial value');
    };

    _class.prototype['@test services can be injected into components'] = function testServicesCanBeInjectedIntoComponents() {
      var _this69 = this;

      var service = undefined;
      this.registerService('name', _emberRuntime.Service.extend({
        init: function () {
          this._super.apply(this, arguments);
          service = this;
        },
        last: 'Jackson'
      }));

      this.registerComponent('foo-bar', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          name: _emberRuntime.inject.service()
        }),
        template: '{{name.last}}'
      });

      this.render('{{foo-bar}}');

      this.assertText('Jackson');

      this.runTask(function () {
        return _this69.rerender();
      });

      this.assertText('Jackson');

      this.runTask(function () {
        service.set('last', 'McGuffey');
      });

      this.assertText('McGuffey');

      this.runTask(function () {
        service.set('last', 'Jackson');
      });

      this.assertText('Jackson');
    };

    _class.prototype['@test can access `actions` hash via `_actions` [DEPRECATED]'] = function testCanAccessActionsHashVia_actionsDEPRECATED() {
      var _this70 = this;

      var component = undefined;

      function derp() {}

      this.registerComponent('foo-bar', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            component = this;
          },

          actions: {
            derp: derp
          }
        })
      });

      this.render('{{foo-bar}}');

      this.assert.strictEqual(component.actions.derp, derp);

      expectDeprecation(function () {
        _this70.assert.strictEqual(component._actions.derp, derp);
      }, 'Usage of `_actions` is deprecated, use `actions` instead.');
    };

    _class.prototype['@test throws if `this._super` is not called from `init`'] = function testThrowsIfThis_superIsNotCalledFromInit() {
      var _this71 = this;

      this.registerComponent('foo-bar', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {}
        })
      });

      expectAssertion(function () {
        _this71.render('{{foo-bar}}');
      }, /You must call `this._super\(...arguments\);` when overriding `init` on a framework object. Please update .* to call `this._super\(...arguments\);` from `init`./);
    };

    _class.prototype['@test should toggle visibility with isVisible'] = function testShouldToggleVisibilityWithIsVisible(assert) {
      var _this72 = this;

      var assertStyle = function (expected) {
        var matcher = _emberGlimmerTestsUtilsTestHelpers.styles(expected);
        var actual = _this72.firstChild.getAttribute('style');

        assert.pushResult({
          result: matcher.match(actual),
          message: matcher.message(),
          actual: actual,
          expected: expected
        });
      };

      this.registerComponent('foo-bar', {
        template: '<p>foo</p>'
      });

      this.render('{{foo-bar id="foo-bar" isVisible=visible}}', {
        visible: false
      });

      assertStyle('display: none;');

      this.assertStableRerender();

      this.runTask(function () {
        _emberMetal.set(_this72.context, 'visible', true);
      });
      assertStyle('');

      this.runTask(function () {
        _emberMetal.set(_this72.context, 'visible', false);
      });
      assertStyle('display: none;');
    };

    _class.prototype['@test isVisible does not overwrite component style'] = function testIsVisibleDoesNotOverwriteComponentStyle(assert) {
      var _this73 = this;

      this.registerComponent('foo-bar', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          attributeBindings: ['style'],
          style: _emberGlimmerTestsUtilsHelpers.htmlSafe('color: blue;')
        }),

        template: '<p>foo</p>'
      });

      this.render('{{foo-bar id="foo-bar" isVisible=visible}}', {
        visible: false
      });

      this.assertComponentElement(this.firstChild, {
        tagName: 'div',
        attrs: { id: 'foo-bar', style: _emberGlimmerTestsUtilsTestHelpers.styles('color: blue; display: none;') }
      });

      this.assertStableRerender();

      this.runTask(function () {
        _emberMetal.set(_this73.context, 'visible', true);
      });

      this.assertComponentElement(this.firstChild, {
        tagName: 'div',
        attrs: { id: 'foo-bar', style: _emberGlimmerTestsUtilsTestHelpers.styles('color: blue;') }
      });

      this.runTask(function () {
        _emberMetal.set(_this73.context, 'visible', false);
      });

      this.assertComponentElement(this.firstChild, {
        tagName: 'div',
        attrs: { id: 'foo-bar', style: _emberGlimmerTestsUtilsTestHelpers.styles('color: blue; display: none;') }
      });
    };

    _class.prototype['@test adds isVisible binding when style binding is missing and other bindings exist'] = function testAddsIsVisibleBindingWhenStyleBindingIsMissingAndOtherBindingsExist(assert) {
      var _this74 = this;

      var assertStyle = function (expected) {
        var matcher = _emberGlimmerTestsUtilsTestHelpers.styles(expected);
        var actual = _this74.firstChild.getAttribute('style');

        assert.pushResult({
          result: matcher.match(actual),
          message: matcher.message(),
          actual: actual,
          expected: expected
        });
      };

      this.registerComponent('foo-bar', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          attributeBindings: ['foo'],
          foo: 'bar'
        }),
        template: '<p>foo</p>'
      });

      this.render('{{foo-bar id="foo-bar" foo=foo isVisible=visible}}', {
        visible: false,
        foo: 'baz'
      });

      assertStyle('display: none;');

      this.assertStableRerender();

      this.runTask(function () {
        _emberMetal.set(_this74.context, 'visible', true);
      });

      assertStyle('');

      this.runTask(function () {
        _emberMetal.set(_this74.context, 'visible', false);
        _emberMetal.set(_this74.context, 'foo', 'woo');
      });

      assertStyle('display: none;');
      assert.equal(this.firstChild.getAttribute('foo'), 'woo');
    };

    _class.prototype['@test it can use readDOMAttr to read input value'] = function testItCanUseReadDOMAttrToReadInputValue() {
      var _this75 = this;

      var component = undefined;
      var assertElement = function (expectedValue) {
        // value is a property, not an attribute
        _this75.assertHTML('<input class="ember-view" id="' + component.elementId + '">');
        _this75.assert.equal(_this75.firstChild.value, expectedValue, 'value property is correct');
        _this75.assert.equal(_emberMetal.get(component, 'value'), expectedValue, 'component.get("value") is correct');
      };

      this.registerComponent('one-way-input', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          tagName: 'input',
          attributeBindings: ['value'],

          init: function () {
            this._super.apply(this, arguments);
            component = this;
          },

          change: function () {
            var value = this.readDOMAttr('value');
            this.set('value', value);
          }
        })
      });

      this.render('{{one-way-input value=value}}', {
        value: 'foo'
      });

      assertElement('foo');

      this.assertStableRerender();

      this.runTask(function () {
        _this75.firstChild.value = 'bar';
        _this75.$('input').trigger('change');
      });

      assertElement('bar');

      this.runTask(function () {
        _this75.firstChild.value = 'foo';
        _this75.$('input').trigger('change');
      });

      assertElement('foo');

      this.runTask(function () {
        _emberMetal.set(component, 'value', 'bar');
      });

      assertElement('bar');

      this.runTask(function () {
        _this75.firstChild.value = 'foo';
        _this75.$('input').trigger('change');
      });

      assertElement('foo');
    };

    _class.prototype['@test child triggers revalidate during parent destruction (GH#13846)'] = function testChildTriggersRevalidateDuringParentDestructionGH13846() {
      this.registerComponent('x-select', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          tagName: 'select',

          init: function () {
            this._super();
            this.options = _emberRuntime.A([]);
            this.value = null;
          },

          updateValue: function () {
            var newValue = this.get('options.lastObject.value');

            this.set('value', newValue);
          },

          registerOption: function (option) {
            this.get('options').addObject(option);
          },

          unregisterOption: function (option) {
            this.get('options').removeObject(option);

            this.updateValue();
          }
        }),

        template: '{{yield this}}'
      });

      this.registerComponent('x-option', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          tagName: 'option',
          attributeBindings: ['selected'],

          didInsertElement: function () {
            this._super.apply(this, arguments);

            this.get('select').registerOption(this);
          },

          selected: _emberMetal.computed('select.value', function () {
            return this.get('value') === this.get('select.value');
          }),

          willDestroyElement: function () {
            this._super.apply(this, arguments);
            this.get('select').unregisterOption(this);
          }
        })
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject42));

      this.teardown();

      this.assert.ok(true, 'no errors during teardown');
    };

    _class.prototype['@test setting a property in willDestroyElement does not assert (GH#14273)'] = function testSettingAPropertyInWillDestroyElementDoesNotAssertGH14273(assert) {
      assert.expect(2);

      this.registerComponent('foo-bar', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            this.showFoo = true;
          },

          willDestroyElement: function () {
            this.set('showFoo', false);
            assert.ok(true, 'willDestroyElement was fired');
            this._super.apply(this, arguments);
          }
        }),

        template: '{{#if showFoo}}things{{/if}}'
      });

      this.render('{{foo-bar}}');

      this.assertText('things');
    };

    _class.prototype['@test using didInitAttrs as an event is deprecated'] = function testUsingDidInitAttrsAsAnEventIsDeprecated(assert) {
      var _this76 = this;

      this.registerComponent('foo-bar', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          foo: _emberMetal.on('didInitAttrs', function () {
            assert.ok(true, 'should fire `didInitAttrs` event');
          })
        })
      });

      expectDeprecation(function () {
        _this76.render('{{foo-bar}}');
      }, /didInitAttrs called/);
    };

    // This test is a replication of the "component unit tests" scenario. When we deprecate
    // and remove them, this test could be removed as well. This is not fully/intentionally
    // supported, and it is unclear that this particular behavior is actually relied on.
    // Since there is no real "invocation" here, it has other issues and inconsistencies,
    // like there is no real "attrs" here, and there is no "update" pass.

    _class.prototype['@test did{Init,Receive}Attrs fires even if component is not rendered'] = function testDidInitReceiveAttrsFiresEvenIfComponentIsNotRendered(assert) {
      var _this77 = this;

      expectDeprecation(/didInitAttrs called/);

      var didInitAttrsCount = 0;
      var didReceiveAttrsCount = 0;

      this.registerComponent('foo-bar', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            this.didInit = true;
          },

          didInitAttrs: function () {
            assert.ok(this.didInit, 'expected init to have run before didInitAttrs');
            didInitAttrsCount++;
          },

          didReceiveAttrs: function () {
            assert.ok(this.didInit, 'expected init to have run before didReceiveAttrs');
            didReceiveAttrsCount++;
          },

          willRender: function () {
            throw new Error('Unexpected render!');
          }
        })
      });

      assert.strictEqual(didInitAttrsCount, 0, 'precond: didInitAttrs is not fired');
      assert.strictEqual(didReceiveAttrsCount, 0, 'precond: didReceiveAttrs is not fired');

      this.runTask(function () {
        return _this77.component = _this77.owner.lookup('component:foo-bar');
      });

      assert.strictEqual(didInitAttrsCount, 1, 'precond: didInitAttrs is fired');
      assert.strictEqual(didReceiveAttrsCount, 1, 'precond: didReceiveAttrs is fired');
    };

    _class.prototype['@test did{Init,Receive}Attrs fires after .init() but before observers become active'] = function testDidInitReceiveAttrsFiresAfterInitButBeforeObserversBecomeActive(assert) {
      var _this78 = this;

      expectDeprecation(/didInitAttrs called/);

      var fooCopyDidChangeCount = 0;
      var barCopyDidChangeCount = 0;

      this.registerComponent('foo-bar', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            this.didInit = true;
          },

          didInitAttrs: function (_ref2) {
            var attrs = _ref2.attrs;

            assert.ok(this.didInit, 'expected init to have run before didInitAttrs');
            this.set('fooCopy', attrs.foo.value + 1);
          },

          didReceiveAttrs: function (_ref3) {
            var newAttrs = _ref3.newAttrs;

            assert.ok(this.didInit, 'expected init to have run before didReceiveAttrs');
            this.set('barCopy', newAttrs.bar.value + 1);
          },

          fooCopyDidChange: _emberMetal.observer('fooCopy', function () {
            fooCopyDidChangeCount++;
          }),
          barCopyDidChange: _emberMetal.observer('barCopy', function () {
            barCopyDidChangeCount++;
          })
        }),

        template: '{{foo}}-{{fooCopy}}-{{bar}}-{{barCopy}}'
      });

      this.render('{{foo-bar foo=foo bar=bar}}', { foo: 1, bar: 3 });

      this.assertText('1-2-3-4');

      assert.strictEqual(fooCopyDidChangeCount, 0, 'expected NO observer firing for: fooCopy');
      assert.strictEqual(barCopyDidChangeCount, 0, 'expected NO observer firing for: barCopy');

      this.runTask(function () {
        return _emberMetal.set(_this78.context, 'foo', 5);
      });

      this.assertText('5-2-3-4');

      assert.strictEqual(fooCopyDidChangeCount, 0, 'expected observer firing for: fooCopy');
      assert.strictEqual(barCopyDidChangeCount, 0, 'expected NO observer firing for: barCopy');

      this.runTask(function () {
        return _emberMetal.set(_this78.context, 'bar', 7);
      });

      this.assertText('5-2-7-8');

      assert.strictEqual(fooCopyDidChangeCount, 0, 'expected observer firing for: fooCopy');
      assert.strictEqual(barCopyDidChangeCount, 1, 'expected observer firing for: barCopy');
    };

    _class.prototype['@test returning `true` from an action does not bubble if `target` is not specified (GH#14275)'] = function testReturningTrueFromAnActionDoesNotBubbleIfTargetIsNotSpecifiedGH14275(assert) {
      var _this79 = this;

      this.registerComponent('display-toggle', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          actions: {
            show: function () {
              assert.ok(true, 'display-toggle show action was called');
              return true;
            }
          }
        }),

        template: '<button {{action \'show\'}}>Show</button>'
      });

      this.render('{{display-toggle}}', {
        send: function () {
          assert.notOk(true, 'send should not be called when action is not "subscribed" to');
        }
      });

      this.assertText('Show');

      this.runTask(function () {
        return _this79.$('button').click();
      });
    };

    _class.prototype['@test returning `true` from an action bubbles to the `target` if specified'] = function testReturningTrueFromAnActionBubblesToTheTargetIfSpecified(assert) {
      var _this80 = this;

      assert.expect(4);

      this.registerComponent('display-toggle', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          actions: {
            show: function () {
              assert.ok(true, 'display-toggle show action was called');
              return true;
            }
          }
        }),

        template: '<button {{action \'show\'}}>Show</button>'
      });

      this.render('{{display-toggle target=this}}', {
        send: function (actionName) {
          assert.ok(true, 'send should be called when action is "subscribed" to');
          assert.equal(actionName, 'show');
        }
      });

      this.assertText('Show');

      this.runTask(function () {
        return _this80.$('button').click();
      });
    };

    _class.prototype['@test component yielding in an {{#each}} has correct block values after rerendering (GH#14284)'] = function testComponentYieldingInAnEachHasCorrectBlockValuesAfterRerenderingGH14284() {
      var _this81 = this;

      this.registerComponent('list-items', {
        template: '{{#each items as |item|}}{{yield item}}{{/each}}'
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject43), {
        editMode: false,
        items: ['foo', 'bar', 'qux', 'baz']
      });

      this.assertText('|foo||bar||qux||baz|');

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(_this81.context, 'editMode', true);
      });

      this.assertText('|foo|Remove foo|bar|Remove bar|qux|Remove qux|baz|Remove baz');

      this.runTask(function () {
        return _emberMetal.set(_this81.context, 'editMode', false);
      });

      this.assertText('|foo||bar||qux||baz|');
    };

    _class.prototype['@test unimplimented positionalParams do not cause an error GH#14416'] = function testUnimplimentedPositionalParamsDoNotCauseAnErrorGH14416(assert) {
      this.registerComponent('foo-bar', {
        template: 'hello'
      });

      this.render('{{foo-bar wat}}');
      this.assertText('hello');
    };

    _class.prototype['@test using attrs for positional params'] = function testUsingAttrsForPositionalParams(assert) {
      var MyComponent = _emberGlimmerTestsUtilsHelpers.Component.extend();

      this.registerComponent('foo-bar', {
        ComponentClass: MyComponent.reopenClass({
          positionalParams: ['myVar']
        }),
        template: 'MyVar1: {{attrs.myVar}} {{myVar}} MyVar2: {{myVar2}} {{attrs.myVar2}}'
      });

      this.render('{{foo-bar 1 myVar2=2}}');

      this.assertText('MyVar1: 1 1 MyVar2: 2 2');
    };

    _class.prototype['@test can use `{{this}}` to emit the component\'s toString value [GH#14581]'] = function testCanUseThisToEmitTheComponentSToStringValueGH14581(assert) {
      this.registerComponent('foo-bar', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          toString: function () {
            return 'special sauce goes here!';
          }
        }),
        template: '{{this}}'
      });

      this.render('{{foo-bar}}');

      this.assertText('special sauce goes here!');
    };

    _class.prototype['@test can use `{{this` to access paths on current context [GH#14581]'] = function testCanUseThisToAccessPathsOnCurrentContextGH14581(assert) {
      var instance = undefined;
      this.registerComponent('foo-bar', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);

            instance = this;
          },

          foo: {
            bar: {
              baz: 'huzzah!'
            }
          }
        }),
        template: '{{this.foo.bar.baz}}'
      });

      this.render('{{foo-bar}}');

      this.assertText('huzzah!');

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(instance, 'foo.bar.baz', 'yippie!');
      });

      this.assertText('yippie!');

      this.runTask(function () {
        return _emberMetal.set(instance, 'foo.bar.baz', 'huzzah!');
      });

      this.assertText('huzzah!');
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
});
enifed('ember-glimmer/tests/integration/components/destroy-test', ['exports', 'ember-metal', 'ember-glimmer/tests/utils/helpers', 'ember-glimmer/tests/utils/test-case'], function (exports, _emberMetal, _emberGlimmerTestsUtilsHelpers, _emberGlimmerTestsUtilsTestCase) {
  'use strict';

  _emberGlimmerTestsUtilsTestCase.moduleFor('Component destroy', (function (_RenderingTest) {
    babelHelpers.inherits(_class, _RenderingTest);

    function _class() {
      _RenderingTest.apply(this, arguments);
    }

    _class.prototype['@test it correctly releases the destroyed components'] = function testItCorrectlyReleasesTheDestroyedComponents(assert) {
      var _this = this;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({});

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{#if switch}}{{#foo-bar}}{{foo-bar}}{{/foo-bar}}{{/if}}', { switch: true });

      this.assertComponentElement(this.firstChild, { content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this.context, 'switch', false);
      });

      this.assertText('');

      assert.equal(this.env.destroyedComponents.length, 0, 'enviroment.destroyedComponents should be empty');
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
});
enifed('ember-glimmer/tests/integration/components/dynamic-components-test', ['exports', 'ember-metal', 'ember-glimmer/tests/utils/helpers', 'ember-glimmer/tests/utils/abstract-test-case', 'ember-glimmer/tests/utils/test-case'], function (exports, _emberMetal, _emberGlimmerTestsUtilsHelpers, _emberGlimmerTestsUtilsAbstractTestCase, _emberGlimmerTestsUtilsTestCase) {
  'use strict';

  var _templateObject = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#if cond1}}\n        {{#component "foo-bar" id=1}}\n          {{#if cond2}}\n            {{#component "foo-bar" id=2}}{{/component}}\n            {{#if cond3}}\n              {{#component "foo-bar" id=3}}\n                {{#if cond4}}\n                  {{#component "foo-bar" id=4}}\n                    {{#if cond5}}\n                      {{#component "foo-bar" id=5}}{{/component}}\n                      {{#component "foo-bar" id=6}}{{/component}}\n                      {{#component "foo-bar" id=7}}{{/component}}\n                    {{/if}}\n                    {{#component "foo-bar" id=8}}{{/component}}\n                  {{/component}}\n                {{/if}}\n              {{/component}}\n            {{/if}}\n          {{/if}}\n        {{/component}}\n      {{/if}}'], ['\n      {{#if cond1}}\n        {{#component "foo-bar" id=1}}\n          {{#if cond2}}\n            {{#component "foo-bar" id=2}}{{/component}}\n            {{#if cond3}}\n              {{#component "foo-bar" id=3}}\n                {{#if cond4}}\n                  {{#component "foo-bar" id=4}}\n                    {{#if cond5}}\n                      {{#component "foo-bar" id=5}}{{/component}}\n                      {{#component "foo-bar" id=6}}{{/component}}\n                      {{#component "foo-bar" id=7}}{{/component}}\n                    {{/if}}\n                    {{#component "foo-bar" id=8}}{{/component}}\n                  {{/component}}\n                {{/if}}\n              {{/component}}\n            {{/if}}\n          {{/if}}\n        {{/component}}\n      {{/if}}']),
      _templateObject2 = babelHelpers.taggedTemplateLiteralLoose(['\n        {{#each names as |name|}}\n          {{name}}\n        {{/each}}'], ['\n        {{#each names as |name|}}\n          {{name}}\n        {{/each}}']),
      _templateObject3 = babelHelpers.taggedTemplateLiteralLoose(['\n        {{#each n as |name|}}\n          {{name}}\n        {{/each}}'], ['\n        {{#each n as |name|}}\n          {{name}}\n        {{/each}}']);

  _emberGlimmerTestsUtilsTestCase.moduleFor('Components test: dynamic components', (function (_RenderingTest) {
babelHelpers.inherits(_class, _RenderingTest);

    function _class() {
      _RenderingTest.apply(this, arguments);
    }

    _class.prototype['@test it can render a basic component with a static component name argument'] = function testItCanRenderABasicComponentWithAStaticComponentNameArgument() {
      var _this = this;

      this.registerComponent('foo-bar', { template: 'hello {{name}}' });

      this.render('{{component "foo-bar" name=name}}', { name: 'Sarah' });

      this.assertComponentElement(this.firstChild, { content: 'hello Sarah' });

      this.runTask(function () {
        return _this.rerender();
      });

      this.assertComponentElement(this.firstChild, { content: 'hello Sarah' });

      this.runTask(function () {
        return _emberMetal.set(_this.context, 'name', 'Gavin');
      });

      this.assertComponentElement(this.firstChild, { content: 'hello Gavin' });

      this.runTask(function () {
        return _emberMetal.set(_this.context, 'name', 'Sarah');
      });

      this.assertComponentElement(this.firstChild, { content: 'hello Sarah' });
    };

    _class.prototype['@test it can render a basic component with a dynamic component name argument'] = function testItCanRenderABasicComponentWithADynamicComponentNameArgument() {
      var _this2 = this;

      this.registerComponent('foo-bar', { template: 'hello {{name}} from foo-bar' });
      this.registerComponent('foo-bar-baz', { template: 'hello {{name}} from foo-bar-baz' });

      this.render('{{component componentName name=name}}', { componentName: 'foo-bar', name: 'Alex' });

      this.assertComponentElement(this.firstChild, { content: 'hello Alex from foo-bar' });

      this.runTask(function () {
        return _this2.rerender();
      });

      this.assertComponentElement(this.firstChild, { content: 'hello Alex from foo-bar' });

      this.runTask(function () {
        return _emberMetal.set(_this2.context, 'name', 'Ben');
      });

      this.assertComponentElement(this.firstChild, { content: 'hello Ben from foo-bar' });

      this.runTask(function () {
        return _emberMetal.set(_this2.context, 'componentName', 'foo-bar-baz');
      });

      this.assertComponentElement(this.firstChild, { content: 'hello Ben from foo-bar-baz' });

      this.runTask(function () {
        _emberMetal.set(_this2.context, 'componentName', 'foo-bar');
        _emberMetal.set(_this2.context, 'name', 'Alex');
      });

      this.assertComponentElement(this.firstChild, { content: 'hello Alex from foo-bar' });
    };

    _class.prototype['@test it has an element'] = function testItHasAnElement() {
      var _this3 = this;

      var instance = undefined;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super();
          instance = this;
        }
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{component "foo-bar"}}');

      var element1 = instance.element;

      this.assertComponentElement(element1, { content: 'hello' });

      this.runTask(function () {
        return _this3.rerender();
      });

      var element2 = instance.element;

      this.assertComponentElement(element2, { content: 'hello' });

      this.assertSameNode(element2, element1);
    };

    _class.prototype['@test it has a jQuery proxy to the element'] = function testItHasAJQueryProxyToTheElement(assert) {
      var _this4 = this;

      var instance = undefined;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super();
          instance = this;
        }
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{component "foo-bar"}}');

      var element1 = instance.$()[0];

      this.assertComponentElement(element1, { content: 'hello' });

      this.runTask(function () {
        return _this4.rerender();
      });

      var element2 = instance.$()[0];

      this.assertComponentElement(element2, { content: 'hello' });

      this.assertSameNode(element2, element1);
    };

    _class.prototype['@test it scopes the jQuery proxy to the component element'] = function testItScopesTheJQueryProxyToTheComponentElement(assert) {
      var _this5 = this;

      var instance = undefined;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super();
          instance = this;
        }
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: '<span class="inner">inner</span>' });

      this.render('<span class="outer">outer</span>{{component "foo-bar"}}');

      var $span = instance.$('span');

      assert.equal($span.length, 1);
      assert.equal($span.attr('class'), 'inner');

      this.runTask(function () {
        return _this5.rerender();
      });

      $span = instance.$('span');

      assert.equal($span.length, 1);
      assert.equal($span.attr('class'), 'inner');
    };

    _class.prototype['@test it has the right parentView and childViews'] = function testItHasTheRightParentViewAndChildViews(assert) {
      var _this6 = this;

      var fooBarInstance = undefined,
          fooBarBazInstance = undefined;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super();
          fooBarInstance = this;
        }
      });

      var FooBarBazComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super();
          fooBarBazInstance = this;
        }
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'foo-bar {{foo-bar-baz}}' });
      this.registerComponent('foo-bar-baz', { ComponentClass: FooBarBazComponent, template: 'foo-bar-baz' });

      this.render('{{component "foo-bar"}}');
      this.assertText('foo-bar foo-bar-baz');

      assert.equal(fooBarInstance.parentView, this.component);
      assert.equal(fooBarBazInstance.parentView, fooBarInstance);

      assert.deepEqual(this.component.childViews, [fooBarInstance]);
      assert.deepEqual(fooBarInstance.childViews, [fooBarBazInstance]);

      this.runTask(function () {
        return _this6.rerender();
      });
      this.assertText('foo-bar foo-bar-baz');

      assert.equal(fooBarInstance.parentView, this.component);
      assert.equal(fooBarBazInstance.parentView, fooBarInstance);

      assert.deepEqual(this.component.childViews, [fooBarInstance]);
      assert.deepEqual(fooBarInstance.childViews, [fooBarBazInstance]);
    };

    _class.prototype['@test it can render a basic component with a block'] = function testItCanRenderABasicComponentWithABlock() {
      var _this7 = this;

      this.registerComponent('foo-bar', { template: '{{yield}}' });

      this.render('{{#component "foo-bar"}}hello{{/component}}');

      this.assertComponentElement(this.firstChild, { content: 'hello' });

      this.runTask(function () {
        return _this7.rerender();
      });

      this.assertComponentElement(this.firstChild, { content: 'hello' });
    };

    _class.prototype['@test it renders the layout with the component instance as the context'] = function testItRendersTheLayoutWithTheComponentInstanceAsTheContext() {
      var _this8 = this;

      var instance = undefined;

      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super();
          instance = this;
          this.set('message', 'hello');
        }
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: '{{message}}' });

      this.render('{{component "foo-bar"}}');

      this.assertComponentElement(this.firstChild, { content: 'hello' });

      this.runTask(function () {
        return _this8.rerender();
      });

      this.assertComponentElement(this.firstChild, { content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(instance, 'message', 'goodbye');
      });

      this.assertComponentElement(this.firstChild, { content: 'goodbye' });

      this.runTask(function () {
        return _emberMetal.set(instance, 'message', 'hello');
      });

      this.assertComponentElement(this.firstChild, { content: 'hello' });
    };

    _class.prototype['@test it preserves the outer context when yielding'] = function testItPreservesTheOuterContextWhenYielding() {
      var _this9 = this;

      this.registerComponent('foo-bar', { template: '{{yield}}' });

      this.render('{{#component "foo-bar"}}{{message}}{{/component}}', { message: 'hello' });

      this.assertComponentElement(this.firstChild, { content: 'hello' });

      this.runTask(function () {
        return _this9.rerender();
      });

      this.assertComponentElement(this.firstChild, { content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this9.context, 'message', 'goodbye');
      });

      this.assertComponentElement(this.firstChild, { content: 'goodbye' });

      this.runTask(function () {
        return _emberMetal.set(_this9.context, 'message', 'hello');
      });

      this.assertComponentElement(this.firstChild, { content: 'hello' });
    };

    _class.prototype['@test the component and its child components are destroyed'] = function testTheComponentAndItsChildComponentsAreDestroyed(assert) {
      var _this10 = this;

      var destroyed = { 1: 0, 2: 0, 3: 0, 4: 0, 5: 0, 6: 0, 7: 0, 8: 0 };

      this.registerComponent('foo-bar', {
        template: '{{id}} {{yield}}',
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          willDestroy: function () {
            this._super();
            destroyed[this.get('id')]++;
          }
        })
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject), {
        cond1: true,
        cond2: true,
        cond3: true,
        cond4: true,
        cond5: true
      });

      this.assertText('1 2 3 4 5 6 7 8 ');

      this.runTask(function () {
        return _this10.rerender();
      });

      assert.deepEqual(destroyed, { 1: 0, 2: 0, 3: 0, 4: 0, 5: 0, 6: 0, 7: 0, 8: 0 });

      this.runTask(function () {
        return _emberMetal.set(_this10.context, 'cond5', false);
      });

      this.assertText('1 2 3 4 8 ');

      assert.deepEqual(destroyed, { 1: 0, 2: 0, 3: 0, 4: 0, 5: 1, 6: 1, 7: 1, 8: 0 });

      this.runTask(function () {
        _emberMetal.set(_this10.context, 'cond3', false);
        _emberMetal.set(_this10.context, 'cond5', true);
        _emberMetal.set(_this10.context, 'cond4', false);
      });

      assert.deepEqual(destroyed, { 1: 0, 2: 0, 3: 1, 4: 1, 5: 1, 6: 1, 7: 1, 8: 1 });

      this.runTask(function () {
        _emberMetal.set(_this10.context, 'cond2', false);
        _emberMetal.set(_this10.context, 'cond1', false);
      });

      assert.deepEqual(destroyed, { 1: 1, 2: 1, 3: 1, 4: 1, 5: 1, 6: 1, 7: 1, 8: 1 });
    };

    _class.prototype['@test component helper destroys underlying component when it is swapped out'] = function testComponentHelperDestroysUnderlyingComponentWhenItIsSwappedOut(assert) {
      var _this11 = this;

      var destroyed = { 'foo-bar': 0, 'foo-bar-baz': 0 };
      var testContext = this;

      this.registerComponent('foo-bar', {
        template: 'hello from foo-bar',
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          willDestroyElement: function () {
            assert.equal(testContext.$('#' + this.elementId).length, 1, 'element is still attached to the document');
          },

          willDestroy: function () {
            this._super();
            destroyed['foo-bar']++;
          }
        })
      });

      this.registerComponent('foo-bar-baz', {
        template: 'hello from foo-bar-baz',
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          willDestroy: function () {
            this._super();
            destroyed['foo-bar-baz']++;
          }
        })
      });

      this.render('{{component componentName name=name}}', { componentName: 'foo-bar' });

      assert.deepEqual(destroyed, { 'foo-bar': 0, 'foo-bar-baz': 0 });

      this.runTask(function () {
        return _this11.rerender();
      });

      assert.deepEqual(destroyed, { 'foo-bar': 0, 'foo-bar-baz': 0 });

      this.runTask(function () {
        return _emberMetal.set(_this11.context, 'componentName', 'foo-bar-baz');
      });

      assert.deepEqual(destroyed, { 'foo-bar': 1, 'foo-bar-baz': 0 });

      this.runTask(function () {
        return _emberMetal.set(_this11.context, 'componentName', 'foo-bar');
      });

      assert.deepEqual(destroyed, { 'foo-bar': 1, 'foo-bar-baz': 1 });
    };

    _class.prototype['@test component helper with bound properties are updating correctly in init of component'] = function testComponentHelperWithBoundPropertiesAreUpdatingCorrectlyInInitOfComponent(assert) {
      var _this12 = this;

      this.registerComponent('foo-bar', {
        template: 'foo-bar {{location}} {{locationCopy}} {{yield}}',
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            this.set('locationCopy', this.get('location'));
          }
        })
      });

      this.registerComponent('foo-bar-baz', {
        template: 'foo-bar-baz {{location}} {{locationCopy}} {{yield}}',
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            this.set('locationCopy', this.get('location'));
          }
        })
      });

      this.registerComponent('outer-component', {
        template: '{{#component componentName location=location}}arepas!{{/component}}',
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          componentName: _emberMetal.computed('location', function () {
            if (this.get('location') === 'Caracas') {
              return 'foo-bar';
            } else {
              return 'foo-bar-baz';
            }
          })
        })
      });

      this.render('{{outer-component location=location}}', { location: 'Caracas' });

      this.assertText('foo-bar Caracas Caracas arepas!');

      this.runTask(function () {
        return _this12.rerender();
      });

      this.assertText('foo-bar Caracas Caracas arepas!');

      this.runTask(function () {
        return _emberMetal.set(_this12.context, 'location', 'Loisaida');
      });

      this.assertText('foo-bar-baz Loisaida Loisaida arepas!');

      this.runTask(function () {
        return _emberMetal.set(_this12.context, 'location', 'Caracas');
      });

      this.assertText('foo-bar Caracas Caracas arepas!');
    };

    _class.prototype['@test component helper with actions'] = function testComponentHelperWithActions(assert) {
      var _this14 = this;

      this.registerComponent('inner-component', {
        template: 'inner-component {{yield}}',
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          classNames: 'inner-component',
          didInsertElement: function () {
            var _this13 = this;

            // trigger action on click in absence of app's EventDispatcher
            this.$().on('click', function () {
              _this13.sendAction('somethingClicked');
            });
          },
          willDestroyElement: function () {
            this.$().off('click');
          }
        })
      });

      var actionTriggered = 0;
      this.registerComponent('outer-component', {
        template: '{{#component componentName somethingClicked="mappedAction"}}arepas!{{/component}}',
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          classNames: 'outer-component',
          componentName: 'inner-component',
          actions: {
            mappedAction: function () {
              actionTriggered++;
            }
          }
        })
      });

      this.render('{{outer-component}}');

      assert.equal(actionTriggered, 0, 'action was not triggered');

      this.runTask(function () {
        _this14.$('.inner-component').trigger('click');
      });

      assert.equal(actionTriggered, 1, 'action was triggered');
    };

    _class.prototype['@test nested component helpers'] = function testNestedComponentHelpers(assert) {
      var _this15 = this;

      this.registerComponent('foo-bar', { template: 'yippie! {{attrs.location}} {{yield}}' });
      this.registerComponent('baz-qux', { template: 'yummy {{attrs.location}} {{yield}}' });
      this.registerComponent('corge-grault', { template: 'delicious {{attrs.location}} {{yield}}' });

      this.render('{{#component componentName1 location=location}}{{#component componentName2 location=location}}arepas!{{/component}}{{/component}}', {
        componentName1: 'foo-bar',
        componentName2: 'baz-qux',
        location: 'Caracas'
      });

      this.assertText('yippie! Caracas yummy Caracas arepas!');

      this.runTask(function () {
        return _this15.rerender();
      });

      this.assertText('yippie! Caracas yummy Caracas arepas!');

      this.runTask(function () {
        return _emberMetal.set(_this15.context, 'location', 'Loisaida');
      });

      this.assertText('yippie! Loisaida yummy Loisaida arepas!');

      this.runTask(function () {
        return _emberMetal.set(_this15.context, 'componentName1', 'corge-grault');
      });

      this.assertText('delicious Loisaida yummy Loisaida arepas!');

      this.runTask(function () {
        _emberMetal.set(_this15.context, 'componentName1', 'foo-bar');
        _emberMetal.set(_this15.context, 'location', 'Caracas');
      });

      this.assertText('yippie! Caracas yummy Caracas arepas!');
    };

    _class.prototype['@test component with dynamic name argument resolving to non-existent component'] = function testComponentWithDynamicNameArgumentResolvingToNonExistentComponent(assert) {
      var _this16 = this;

      expectAssertion(function () {
        _this16.render('{{component componentName}}', { componentName: 'does-not-exist' });
      }, /Could not find component named "does-not-exist"/);
    };

    _class.prototype['@test component with static name argument for non-existent component'] = function testComponentWithStaticNameArgumentForNonExistentComponent(assert) {
      var _this17 = this;

      expectAssertion(function () {
        _this17.render('{{component "does-not-exist"}}');
      }, /Could not find component named "does-not-exist"/);
    };

    _class.prototype['@test component with dynamic component name resolving to a component, then non-existent component'] = function testComponentWithDynamicComponentNameResolvingToAComponentThenNonExistentComponent(assert) {
      var _this18 = this;

      this.registerComponent('foo-bar', { template: 'hello {{name}}' });

      this.render('{{component componentName name=name}}', { componentName: 'foo-bar', name: 'Alex' });

      this.assertText('hello Alex');

      this.runTask(function () {
        return _this18.rerender();
      });

      this.assertText('hello Alex');

      this.runTask(function () {
        return _emberMetal.set(_this18.context, 'componentName', undefined);
      });

      this.assertText('');

      this.runTask(function () {
        return _emberMetal.set(_this18.context, 'componentName', 'foo-bar');
      });

      this.assertText('hello Alex');
    };

    _class.prototype['@test component helper properly invalidates hash params inside an {{each}} invocation #11044'] = function testComponentHelperProperlyInvalidatesHashParamsInsideAnEachInvocation11044(assert) {
      var _this19 = this;

      this.registerComponent('foo-bar', {
        template: '[{{internalName}} - {{name}}]',
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          willRender: function () {
            // store internally available name to ensure that the name available in `this.attrs.name`
            // matches the template lookup name
            _emberMetal.set(this, 'internalName', this.get('name'));
          }
        })
      });

      this.render('{{#each items as |item|}}{{component "foo-bar" name=item.name}}{{/each}}', {
        items: [{ name: 'Robert' }, { name: 'Jacquie' }]
      });

      this.assertText('[Robert - Robert][Jacquie - Jacquie]');

      this.runTask(function () {
        return _this19.rerender();
      });

      this.assertText('[Robert - Robert][Jacquie - Jacquie]');

      this.runTask(function () {
        return _emberMetal.set(_this19.context, 'items', [{ name: 'Max' }, { name: 'James' }]);
      });

      this.assertText('[Max - Max][James - James]');

      this.runTask(function () {
        return _emberMetal.set(_this19.context, 'items', [{ name: 'Robert' }, { name: 'Jacquie' }]);
      });

      this.assertText('[Robert - Robert][Jacquie - Jacquie]');
    };

    _class.prototype['@test dashless components should not be found'] = function testDashlessComponentsShouldNotBeFound(assert) {
      var _this20 = this;

      this.registerComponent('dashless2', { template: 'Do not render me!' });

      expectAssertion(function () {
        _this20.render('{{component "dashless"}}');
      }, /You cannot use 'dashless' as a component name. Component names must contain a hyphen./);
    };

    _class.prototype['@test positional parameters does not clash when rendering different components'] = function testPositionalParametersDoesNotClashWhenRenderingDifferentComponents(assert) {
      var _this21 = this;

      this.registerComponent('foo-bar', {
        template: 'hello {{name}} ({{age}}) from foo-bar',
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: ['name', 'age']
        })
      });

      this.registerComponent('foo-bar-baz', {
        template: 'hello {{name}} ({{age}}) from foo-bar-baz',
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: ['name', 'age']
        })
      });

      this.render('{{component componentName name age}}', {
        componentName: 'foo-bar',
        name: 'Alex',
        age: 29
      });

      this.assertComponentElement(this.firstChild, { content: 'hello Alex (29) from foo-bar' });

      this.runTask(function () {
        return _this21.rerender();
      });

      this.assertComponentElement(this.firstChild, { content: 'hello Alex (29) from foo-bar' });

      this.runTask(function () {
        return _emberMetal.set(_this21.context, 'name', 'Ben');
      });

      this.assertComponentElement(this.firstChild, { content: 'hello Ben (29) from foo-bar' });

      this.runTask(function () {
        return _emberMetal.set(_this21.context, 'age', 22);
      });

      this.assertComponentElement(this.firstChild, { content: 'hello Ben (22) from foo-bar' });

      this.runTask(function () {
        return _emberMetal.set(_this21.context, 'componentName', 'foo-bar-baz');
      });

      this.assertComponentElement(this.firstChild, { content: 'hello Ben (22) from foo-bar-baz' });

      this.runTask(function () {
        _emberMetal.set(_this21.context, 'componentName', 'foo-bar');
        _emberMetal.set(_this21.context, 'name', 'Alex');
        _emberMetal.set(_this21.context, 'age', 29);
      });

      this.assertComponentElement(this.firstChild, { content: 'hello Alex (29) from foo-bar' });
    };

    _class.prototype['@test positional parameters does not pollute the attributes when changing components'] = function testPositionalParametersDoesNotPolluteTheAttributesWhenChangingComponents(assert) {
      var _this22 = this;

      this.registerComponent('normal-message', {
        template: 'Normal: {{something}}!',
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: ['something']
        })
      });

      this.registerComponent('alternative-message', {
        template: 'Alternative: {{something}} {{somethingElse}}!',
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          something: 'Another'
        }).reopenClass({
          positionalParams: ['somethingElse']
        })
      });

      this.render('{{component componentName message}}', { componentName: 'normal-message', message: 'Hello' });

      this.assertComponentElement(this.firstChild, { content: 'Normal: Hello!' });

      this.runTask(function () {
        return _this22.rerender();
      });

      this.assertComponentElement(this.firstChild, { content: 'Normal: Hello!' });

      this.runTask(function () {
        return _emberMetal.set(_this22.context, 'componentName', 'alternative-message');
      });

      this.assertComponentElement(this.firstChild, { content: 'Alternative: Another Hello!' });

      this.runTask(function () {
        return _emberMetal.set(_this22.context, 'message', 'Hi');
      });

      this.assertComponentElement(this.firstChild, { content: 'Alternative: Another Hi!' });

      this.runTask(function () {
        _emberMetal.set(_this22.context, 'componentName', 'normal-message');
        _emberMetal.set(_this22.context, 'message', 'Hello');
      });

      this.assertComponentElement(this.firstChild, { content: 'Normal: Hello!' });
    };

    _class.prototype['@test static arbitrary number of positional parameters'] = function testStaticArbitraryNumberOfPositionalParameters(assert) {
      var _this23 = this;

      this.registerComponent('sample-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: 'names'
        }),
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject2)
      });

      this.render('{{component "sample-component" "Foo" 4 "Bar" 5 "Baz" elementId="helper"}}');

      this.assertText('Foo4Bar5Baz');

      this.runTask(function () {
        return _this23.rerender();
      });

      this.assertText('Foo4Bar5Baz');
    };

    _class.prototype['@test dynamic arbitrary number of positional parameters'] = function testDynamicArbitraryNumberOfPositionalParameters(assert) {
      var _this24 = this;

      this.registerComponent('sample-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend().reopenClass({
          positionalParams: 'n'
        }),
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject3)
      });

      this.render('{{component "sample-component" user1 user2}}', {
        user1: 'Foo',
        user2: 4
      });

      this.assertText('Foo4');

      this.runTask(function () {
        return _this24.rerender();
      });

      this.assertText('Foo4');

      this.runTask(function () {
        return _this24.context.set('user1', 'Bar');
      });

      this.assertText('Bar4');

      this.runTask(function () {
        return _this24.context.set('user2', '5');
      });

      this.assertText('Bar5');

      this.runTask(function () {
        _this24.context.set('user1', 'Foo');
        _this24.context.set('user2', 4);
      });

      this.assertText('Foo4');
    };

    _class.prototype['@test component helper emits useful backtracking re-render assertion message'] = function testComponentHelperEmitsUsefulBacktrackingReRenderAssertionMessage(assert) {
      var _this25 = this;

      this.registerComponent('outer-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            this.set('person', { name: 'Alex' });
          }
        }),
        template: 'Hi {{person.name}}! {{component "error-component" person=person}}'
      });

      this.registerComponent('error-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            this.set('person.name', { name: 'Ben' });
          }
        }),
        template: '{{person.name}}'
      });

      var expectedBacktrackingMessage = /modified "person\.name" twice on \[object Object\] in a single render\. It was rendered in "component:outer-component" and modified in "component:error-component"/;

      if (false) {
        expectDeprecation(expectedBacktrackingMessage);
        this.render('{{component componentName}}', { componentName: 'outer-component' });
      } else {
        expectAssertion(function () {
          _this25.render('{{component componentName}}', { componentName: 'outer-component' });
        }, expectedBacktrackingMessage);
      }
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
});
enifed('ember-glimmer/tests/integration/components/fragment-components-test', ['exports', 'ember-glimmer/tests/utils/test-case', 'ember-glimmer/tests/utils/abstract-test-case', 'ember-glimmer/tests/utils/helpers', 'ember-metal'], function (exports, _emberGlimmerTestsUtilsTestCase, _emberGlimmerTestsUtilsAbstractTestCase, _emberGlimmerTestsUtilsHelpers, _emberMetal) {
  'use strict';

  var _templateObject = babelHelpers.taggedTemplateLiteralLoose(['<div>Hey</div>bar'], ['<div>Hey</div>bar']),
      _templateObject2 = babelHelpers.taggedTemplateLiteralLoose(['<!---->bar'], ['<!---->bar']),
      _templateObject3 = babelHelpers.taggedTemplateLiteralLoose(['<!---->bizz'], ['<!---->bizz']);

  _emberGlimmerTestsUtilsTestCase.moduleFor('Components test: fragment components', (function (_RenderingTest) {
babelHelpers.inherits(_class, _RenderingTest);

    function _class() {
      _RenderingTest.apply(this, arguments);
    }

    _class.prototype.getCustomDispatcherEvents = function getCustomDispatcherEvents() {
      return {
        hitDem: 'folks'
      };
    };

    _class.prototype['@test fragments do not render an outer tag'] = function testFragmentsDoNotRenderAnOuterTag() {
      var instance = undefined;
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        tagName: '',
        init: function () {
          this._super();
          instance = this;
          this.foo = true;
          this.bar = 'bar';
        }
      });

      var template = '{{#if foo}}<div>Hey</div>{{/if}}{{yield bar}}';

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: template });

      this.render('{{#foo-bar as |bar|}}{{bar}}{{/foo-bar}}');

      this.assertHTML(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject));

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(instance, 'foo', false);
      });

      this.assertHTML(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject2));

      this.runTask(function () {
        return _emberMetal.set(instance, 'bar', 'bizz');
      });

      this.assertHTML(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject3));

      this.runTask(function () {
        _emberMetal.set(instance, 'bar', 'bar');
        _emberMetal.set(instance, 'foo', true);
      });
    };

    _class.prototype['@test throws an error if an event function is defined in a tagless component'] = function testThrowsAnErrorIfAnEventFunctionIsDefinedInATaglessComponent() {
      var _this = this;

      var template = 'hit dem folks';
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        tagName: '',
        click: function () {}
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: template });

      expectAssertion(function () {
        _this.render('{{#foo-bar}}{{/foo-bar}}');
      }, /You can not define a function that handles DOM events in the .* tagless component since it doesn't have any DOM element./);
    };

    _class.prototype['@test throws an error if a custom defined event function is defined in a tagless component'] = function testThrowsAnErrorIfACustomDefinedEventFunctionIsDefinedInATaglessComponent() {
      var _this2 = this;

      var template = 'hit dem folks';
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        tagName: '',
        folks: function () {}
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: template });

      expectAssertion(function () {
        _this2.render('{{#foo-bar}}{{/foo-bar}}');
      }, /You can not define a function that handles DOM events in the .* tagless component since it doesn't have any DOM element./);
    };

    _class.prototype['@test throws an error if `tagName` is an empty string and `classNameBindings` are specified'] = function testThrowsAnErrorIfTagNameIsAnEmptyStringAndClassNameBindingsAreSpecified() {
      var _this3 = this;

      var template = 'hit dem folks';
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        tagName: '',
        foo: true,
        classNameBindings: ['foo:is-foo:is-bar']
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: template });

      expectAssertion(function () {
        _this3.render('{{#foo-bar}}{{/foo-bar}}');
      }, /You cannot use `classNameBindings` on a tag-less component/);
    };

    _class.prototype['@test throws an error if `tagName` is an empty string and `attributeBindings` are specified'] = function testThrowsAnErrorIfTagNameIsAnEmptyStringAndAttributeBindingsAreSpecified() {
      var _this4 = this;

      var template = 'hit dem folks';
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        tagName: '',
        attributeBindings: ['href']
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: template });
      expectAssertion(function () {
        _this4.render('{{#foo-bar}}{{/foo-bar}}');
      }, /You cannot use `attributeBindings` on a tag-less component/);
    };

    _class.prototype['@test throws an error if `tagName` is an empty string and `elementId` is specified via JS'] = function testThrowsAnErrorIfTagNameIsAnEmptyStringAndElementIdIsSpecifiedViaJS() {
      var _this5 = this;

      var template = 'hit dem folks';
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        tagName: '',
        elementId: 'turntUp'
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: template });
      expectAssertion(function () {
        _this5.render('{{#foo-bar}}{{/foo-bar}}');
      }, /You cannot use `elementId` on a tag-less component/);
    };

    _class.prototype['@test throws an error if `tagName` is an empty string and `elementId` is specified via template'] = function testThrowsAnErrorIfTagNameIsAnEmptyStringAndElementIdIsSpecifiedViaTemplate() {
      var _this6 = this;

      var template = 'hit dem folks';
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        tagName: ''
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: template });
      expectAssertion(function () {
        _this6.render('{{#foo-bar elementId=\'turntUp\'}}{{/foo-bar}}');
      }, /You cannot use `elementId` on a tag-less component/);
    };

    _class.prototype['@test does not throw an error if `tagName` is an empty string and `id` is specified via JS'] = function testDoesNotThrowAnErrorIfTagNameIsAnEmptyStringAndIdIsSpecifiedViaJS() {
      var template = '{{id}}';
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        tagName: '',
        id: 'baz'
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: template });
      this.render('{{#foo-bar}}{{/foo-bar}}');
      this.assertText('baz');
    };

    _class.prototype['@test does not throw an error if `tagName` is an empty string and `id` is specified via template'] = function testDoesNotThrowAnErrorIfTagNameIsAnEmptyStringAndIdIsSpecifiedViaTemplate() {
      var template = '{{id}}';
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        tagName: ''
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: template });
      this.render('{{#foo-bar id=\'baz\'}}{{/foo-bar}}');
      this.assertText('baz');
    };

    _class.prototype['@test does not throw an error if `tagName` is an empty string and `id` is bound property specified via template'] = function testDoesNotThrowAnErrorIfTagNameIsAnEmptyStringAndIdIsBoundPropertySpecifiedViaTemplate() {
      var _this7 = this;

      var template = '{{id}}';
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        tagName: ''
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: template });

      this.render('{{#foo-bar id=fooBarId}}{{/foo-bar}}', { fooBarId: 'baz' });

      this.assertText('baz');

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(_this7.context, 'fooBarId', 'qux');
      });

      this.assertText('qux');

      this.runTask(function () {
        return _emberMetal.set(_this7.context, 'fooBarId', 'baz');
      });

      this.assertText('baz');
    };

    _class.prototype['@test does not throw an error if `tagName` is an empty string and `id` is specified via template and passed to child component'] = function testDoesNotThrowAnErrorIfTagNameIsAnEmptyStringAndIdIsSpecifiedViaTemplateAndPassedToChildComponent() {
      var fooBarTemplate = '{{#baz-child id=id}}{{/baz-child}}';
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        tagName: ''
      });
      var BazChildComponent = _emberGlimmerTestsUtilsHelpers.Component.extend();
      var bazChildTemplate = '{{id}}';

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: fooBarTemplate });
      this.registerComponent('baz-child', { ComponentClass: BazChildComponent, template: bazChildTemplate });
      this.render('{{#foo-bar id=\'baz\'}}{{/foo-bar}}');
      this.assertText('baz');
    };

    _class.prototype['@test throws an error if when $() is accessed on component where `tagName` is an empty string'] = function testThrowsAnErrorIfWhen$IsAccessedOnComponentWhereTagNameIsAnEmptyString() {
      var _this8 = this;

      var template = 'hit dem folks';
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        tagName: '',
        init: function () {
          this._super();
          this.$();
        }
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: template });

      expectAssertion(function () {
        _this8.render('{{#foo-bar}}{{/foo-bar}}');
      }, /You cannot access this.\$\(\) on a component with `tagName: \'\'` specified/);
    };

    _class.prototype['@test renders a contained view with omitted start tag and tagless parent view context'] = function testRendersAContainedViewWithOmittedStartTagAndTaglessParentViewContext() {
      var _this9 = this;

      this.registerComponent('root-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          tagName: 'section'
        }),
        template: '{{frag-ment}}'
      });

      this.registerComponent('frag-ment', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          tagName: ''
        }),
        template: '{{my-span}}'
      });

      this.registerComponent('my-span', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          tagName: 'span'
        }),
        template: 'dab'
      });

      this.render('{{root-component}}');

      this.assertElement(this.firstChild, { tagName: 'section' });
      this.assertElement(this.firstChild.firstElementChild, { tagName: 'span' });

      this.runTask(function () {
        return _this9.rerender();
      });

      this.assertElement(this.firstChild, { tagName: 'section' });
      this.assertElement(this.firstChild.firstElementChild, { tagName: 'span' });
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
});
enifed('ember-glimmer/tests/integration/components/instrumentation-test', ['exports', 'ember-glimmer/tests/utils/test-case', 'ember-glimmer/tests/utils/helpers', 'ember-metal'], function (exports, _emberGlimmerTestsUtilsTestCase, _emberGlimmerTestsUtilsHelpers, _emberMetal) {
  'use strict';

  _emberGlimmerTestsUtilsTestCase.moduleFor('Components instrumentation', (function (_RenderingTest) {
    babelHelpers.inherits(_class, _RenderingTest);

    function _class() {
      var _this = this;

      _RenderingTest.call(this);

      this.resetEvents();

      _emberMetal.instrumentationSubscribe('render.component', {
        before: function (name, timestamp, payload) {
          if (payload.view !== _this.component) {
            _this.actual.before.push(payload);
          }
        },
        after: function (name, timestamp, payload) {
          if (payload.view !== _this.component) {
            _this.actual.after.push(payload);
          }
        }
      });
    }

    _class.prototype.resetEvents = function resetEvents() {
      this.expected = {
        before: [],
        after: []
      };

      this.actual = {
        before: [],
        after: []
      };
    };

    _class.prototype.teardown = function teardown() {
      this.assert.deepEqual(this.actual.before, [], 'No unexpected events (before)');
      this.assert.deepEqual(this.actual.after, [], 'No unexpected events (after)');
      _RenderingTest.prototype.teardown.call(this);
      _emberMetal.instrumentationReset();
    };

    _class.prototype['@test zomg'] = function testZomg(assert) {
      assert.ok(true);
    };

    _class.prototype['@test it should receive an instrumentation event for both initial render and updates'] = function testItShouldReceiveAnInstrumentationEventForBothInitialRenderAndUpdates(assert) {
      var _this2 = this;

      var testCase = this;

      var BaseClass = _emberGlimmerTestsUtilsHelpers.Component.extend({
        tagName: '',

        willRender: function () {
          testCase.expected.before.push(this);
          testCase.expected.after.unshift(this);
        }
      });

      this.registerComponent('x-bar', {
        template: '[x-bar: {{bar}}] {{yield}}',
        ComponentClass: BaseClass.extend()
      });

      this.registerComponent('x-baz', {
        template: '[x-baz: {{baz}}]',
        ComponentClass: BaseClass.extend()
      });

      this.registerComponent('x-bat', {
        template: '[x-bat: {{bat}}]',
        ComponentClass: BaseClass.extend()
      });

      this.render('[-top-level: {{foo}}] {{#x-bar bar=bar}}{{x-baz baz=baz}}{{/x-bar}} {{x-bat bat=bat}}', {
        foo: 'foo', bar: 'bar', baz: 'baz', bat: 'bat'
      });

      this.assertText('[-top-level: foo] [x-bar: bar] [x-baz: baz] [x-bat: bat]');

      this.assertEvents('after initial render', true);

      this.runTask(function () {
        return _this2.rerender();
      });

      this.assertEvents('after no-op rerender');

      this.runTask(function () {
        return _emberMetal.set(_this2.context, 'foo', 'FOO');
      });

      this.assertEvents('after updating top-level');

      this.runTask(function () {
        return _emberMetal.set(_this2.context, 'baz', 'BAZ');
      });

      this.assertEvents('after updating inner-most');

      this.runTask(function () {
        _emberMetal.set(_this2.context, 'bar', 'BAR');
        _emberMetal.set(_this2.context, 'bat', 'BAT');
      });

      this.assertEvents('after updating the rest');

      this.runTask(function () {
        _emberMetal.set(_this2.context, 'foo', 'FOO');
        _emberMetal.set(_this2.context, 'bar', 'BAR');
        _emberMetal.set(_this2.context, 'baz', 'BAZ');
        _emberMetal.set(_this2.context, 'bat', 'BAT');
      });

      this.assertEvents('after reset');
    };

    _class.prototype.assertEvents = function assertEvents(label) {
      var initialRender = arguments.length <= 1 || arguments[1] === undefined ? false : arguments[1];
      var actual = this.actual;
      var expected = this.expected;

      this.assert.strictEqual(actual.before.length, actual.after.length, label + ': before and after callbacks should be balanced');

      this._assertEvents(label + ' (before):', actual.before, expected.before, initialRender);
      this._assertEvents(label + ' (after):', actual.before, expected.before, initialRender);

      this.resetEvents();
    };

    _class.prototype._assertEvents = function _assertEvents(label, actual, expected, initialRender) {
      var _this3 = this;

      this.assert.equal(actual.length, expected.length, label + ': expected ' + expected.length + ' and got ' + actual.length);

      actual.forEach(function (payload, i) {
        return _this3.assertPayload(payload, expected[i], initialRender);
      });
    };

    _class.prototype.assertPayload = function assertPayload(payload, component, initialRender) {
      this.assert.equal(payload.object, component.toString(), 'payload.object');
      this.assert.equal(payload.containerKey, component._debugContainerKey, 'payload.containerKey');
      this.assert.equal(payload.view, component, 'payload.view');
      this.assert.strictEqual(payload.initialRender, initialRender, 'payload.initialRender');
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
});
enifed('ember-glimmer/tests/integration/components/life-cycle-test', ['exports', 'ember-metal', 'ember-runtime', 'ember-glimmer/tests/utils/helpers', 'ember-glimmer/tests/utils/abstract-test-case', 'ember-glimmer/tests/utils/test-case', 'ember-views', 'ember-glimmer/tests/utils/test-helpers', 'ember-utils', 'internal-test-helpers'], function (exports, _emberMetal, _emberRuntime, _emberGlimmerTestsUtilsHelpers, _emberGlimmerTestsUtilsAbstractTestCase, _emberGlimmerTestsUtilsTestCase, _emberViews, _emberGlimmerTestsUtilsTestHelpers, _emberUtils, _internalTestHelpers) {
  'use strict';

  var _templateObject = babelHelpers.taggedTemplateLiteralLoose(['\n      <div>\n        Twitter: {{', '}}|\n        ', '\n      </div>'], ['\n      <div>\n        Twitter: {{', '}}|\n        ', '\n      </div>']),
      _templateObject2 = babelHelpers.taggedTemplateLiteralLoose(['\n      <div>\n        Name: {{', '}}|\n        ', '\n      </div>'], ['\n      <div>\n        Name: {{', '}}|\n        ', '\n      </div>']),
      _templateObject3 = babelHelpers.taggedTemplateLiteralLoose(['\n      <div>\n        Website: {{', '}}\n      </div>'], ['\n      <div>\n        Website: {{', '}}\n      </div>']),
      _templateObject4 = babelHelpers.taggedTemplateLiteralLoose(['\n      <div>\n        ', '|\n        ', '|\n        ', '\n      </div>'], ['\n      <div>\n        ', '|\n        ', '|\n        ', '\n      </div>']),
      _templateObject5 = babelHelpers.taggedTemplateLiteralLoose(['\n      <div>\n        Top: ', '\n      </div>'], ['\n      <div>\n        Top: ', '\n      </div>']),
      _templateObject6 = babelHelpers.taggedTemplateLiteralLoose(['\n      <div>\n        Middle: ', '\n      </div>'], ['\n      <div>\n        Middle: ', '\n      </div>']),
      _templateObject7 = babelHelpers.taggedTemplateLiteralLoose(['\n      <div>\n        Bottom: {{', '}}\n      </div>'], ['\n      <div>\n        Bottom: {{', '}}\n      </div>']),
      _templateObject8 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#nested-item}}Item: {{count}}{{/nested-item}}\n    '], ['\n      {{#nested-item}}Item: {{count}}{{/nested-item}}\n    ']),
      _templateObject9 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#nested-item}}Nothing to see here{{/nested-item}}\n    '], ['\n      {{#nested-item}}Nothing to see here{{/nested-item}}\n    ']),
      _templateObject10 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#each items as |item|}}\n        ', '\n      {{else}}\n        ', '\n      {{/each}}\n    '], ['\n      {{#each items as |item|}}\n        ', '\n      {{else}}\n        ', '\n      {{/each}}\n    ']),
      _templateObject11 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{yield}}\n      <ul>\n        {{#nested-component nestedId=(concat itemId \'-A\')}}A{{/nested-component}}\n        {{#nested-component nestedId=(concat itemId \'-B\')}}B{{/nested-component}}\n      </ul>\n    '], ['\n      {{yield}}\n      <ul>\n        {{#nested-component nestedId=(concat itemId \'-A\')}}A{{/nested-component}}\n        {{#nested-component nestedId=(concat itemId \'-B\')}}B{{/nested-component}}\n      </ul>\n    ']),
      _templateObject12 = babelHelpers.taggedTemplateLiteralLoose(['\n      {{#each items as |item|}}\n        {{#parent-component itemId=item.id}}{{item.id}}{{/parent-component}}\n      {{/each}}\n      {{#if model.shouldShow}}\n        {{#parent-component itemId=6}}6{{/parent-component}}\n      {{/if}}\n      {{#if model.shouldShow}}\n        {{#parent-component itemId=7}}7{{/parent-component}}\n      {{/if}}\n    '], ['\n      {{#each items as |item|}}\n        {{#parent-component itemId=item.id}}{{item.id}}{{/parent-component}}\n      {{/each}}\n      {{#if model.shouldShow}}\n        {{#parent-component itemId=6}}6{{/parent-component}}\n      {{/if}}\n      {{#if model.shouldShow}}\n        {{#parent-component itemId=7}}7{{/parent-component}}\n      {{/if}}\n    ']);

  var LifeCycleHooksTest = (function (_RenderingTest) {
babelHelpers.inherits(LifeCycleHooksTest, _RenderingTest);

    function LifeCycleHooksTest() {
      _RenderingTest.call(this);
      this.hooks = [];
      this.components = {};
      this.componentRegistry = [];
      this.teardownAssertions = [];
    }

    LifeCycleHooksTest.prototype.teardown = function teardown() {
      _RenderingTest.prototype.teardown.call(this);

      for (var i = 0; i < this.teardownAssertions.length; i++) {
        this.teardownAssertions[i]();
      }
    };

    LifeCycleHooksTest.prototype.getBootOptions = function getBootOptions() {
      return {
        isInteractive: this.isInteractive
      };
    };

    /* abstract */

    /* abstract */

    LifeCycleHooksTest.prototype.invocationFor = function invocationFor(name) {
      var namedArgs = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      throw new Error('Not implemented: `invocationFor`');
    };

    /* abstract */

    LifeCycleHooksTest.prototype.attrFor = function attrFor(name) {
      throw new Error('Not implemented: `attrFor`');
    };

    LifeCycleHooksTest.prototype.assertRegisteredViews = function assertRegisteredViews(label) {
      var viewRegistry = this.owner.lookup('-view-registry:main');
      var topLevelId = _emberViews.getViewId(this.component);
      var actual = Object.keys(viewRegistry).sort().filter(function (id) {
        return id !== topLevelId;
      });

      if (this.isInteractive) {
        var expected = this.componentRegistry.sort();

        this.assert.deepEqual(actual, expected, 'registered views - ' + label);
      } else {
        this.assert.deepEqual(actual, [], 'no views should be registered for non-interactive mode');
      }
    };

    LifeCycleHooksTest.prototype.registerComponent = function registerComponent(name, _ref) {
      var _this = this;

      var _ref$template = _ref.template;
      var template = _ref$template === undefined ? null : _ref$template;

      var pushComponent = function (instance) {
        _this.components[name] = instance;
        _this.componentRegistry.push(_emberViews.getViewId(instance));
      };

      var removeComponent = function (instance) {
        var index = _this.componentRegistry.indexOf(instance);
        _this.componentRegistry.splice(index, 1);

        delete _this.components[name];
      };

      var pushHook = function (hookName, args) {
        _this.hooks.push(hook(name, hookName, args));
      };

      var assertParentView = function (hookName, instance) {
        _this.assert.ok(instance.parentView, 'parentView should be present in ' + hookName);

        if (hookName === 'willDestroyElement') {
          _this.assert.ok(instance.parentView.childViews.indexOf(instance) !== -1, 'view is still connected to parentView in ' + hookName);
        }
      };

      var assertElement = function (hookName, instance) {
        var inDOM = arguments.length <= 2 || arguments[2] === undefined ? true : arguments[2];

        if (instance.tagName === '') {
          return;
        }

        _this.assert.ok(_emberViews.getViewElement(instance), 'element should be present on ' + instance + ' during ' + hookName);

        if (_this.isInteractive) {
          _this.assert.ok(instance.element, 'this.element should be present on ' + instance + ' during ' + hookName);
          _this.assert.equal(document.body.contains(instance.element), inDOM, 'element for ' + instance + ' ' + (inDOM ? 'should' : 'should not') + ' be in the DOM during ' + hookName);
        } else {
          _this.assert.throws(function () {
            return instance.element;
          }, /Accessing `this.element` is not allowed in non-interactive environments/);
        }
      };

      var assertNoElement = function (hookName, instance) {
        _this.assert.strictEqual(_emberViews.getViewElement(instance), null, 'element should not be present in ' + hookName);

        if (_this.isInteractive) {
          _this.assert.strictEqual(instance.element, null, 'this.element should not be present in ' + hookName);
        } else {
          _this.assert.throws(function () {
            return instance.element;
          }, /Accessing `this.element` is not allowed in non-interactive environments/);
        }
      };

      var assertState = function (hookName, expectedState, instance) {
        _this.assert.equal(instance._state, expectedState, 'within ' + hookName + ' the expected _state is ' + expectedState);
      };

      var isInteractive = this.isInteractive;

      var ComponentClass = this.ComponentClass.extend({
        init: function () {
          var _this2 = this,
              _arguments = arguments;

          expectDeprecation(function () {
            _this2._super.apply(_this2, _arguments);
          }, /didInitAttrs called/);

          this.isInitialRender = true;
          this.componentName = name;
          pushHook('init');
          pushComponent(this);
          assertParentView('init', this);
          assertNoElement('init', this);
          assertState('init', 'preRender', this);

          this.on('init', function () {
            return pushHook('on(init)');
          });

          _emberMetal.run.scheduleOnce('afterRender', function () {
            _this2.isInitialRender = false;
          });
        },

        didInitAttrs: function (options) {
          pushHook('didInitAttrs', options);
          assertParentView('didInitAttrs', this);
          assertNoElement('didInitAttrs', this);
          assertState('didInitAttrs', 'preRender', this);
        },

        didReceiveAttrs: function (options) {
          pushHook('didReceiveAttrs', options);
          assertParentView('didReceiveAttrs', this);

          if (this.isInitialRender) {
            assertNoElement('didReceiveAttrs', this);
            assertState('didReceiveAttrs', 'preRender', this);
          } else {
            assertElement('didReceiveAttrs', this);

            if (isInteractive) {
              assertState('didReceiveAttrs', 'inDOM', this);
            } else {
              assertState('didReceiveAttrs', 'hasElement', this);
            }
          }
        },

        willInsertElement: function () {
          pushHook('willInsertElement');
          assertParentView('willInsertElement', this);
          assertElement('willInsertElement', this, false);
          assertState('willInsertElement', 'hasElement', this);
        },

        willRender: function () {
          pushHook('willRender');
          assertParentView('willRender', this);

          if (this.isInitialRender) {
            assertNoElement('willRender', this, false);
            assertState('willRender', 'preRender', this);
          } else {
            assertElement('willRender', this);
            assertState('willRender', 'inDOM', this);
          }
        },

        didInsertElement: function () {
          pushHook('didInsertElement');
          assertParentView('didInsertElement', this);
          assertElement('didInsertElement', this);
          assertState('didInsertElement', 'inDOM', this);
        },

        didRender: function () {
          pushHook('didRender');
          assertParentView('didRender', this);
          assertElement('didRender', this);
          assertState('didRender', 'inDOM', this);
        },

        didUpdateAttrs: function (options) {
          pushHook('didUpdateAttrs', options);
          assertParentView('didUpdateAttrs', this);

          if (isInteractive) {
            assertState('didUpdateAttrs', 'inDOM', this);
          } else {
            assertState('didUpdateAttrs', 'hasElement', this);
          }
        },

        willUpdate: function (options) {
          pushHook('willUpdate', options);
          assertParentView('willUpdate', this);
          assertElement('willUpdate', this);
          assertState('willUpdate', 'inDOM', this);
        },

        didUpdate: function (options) {
          pushHook('didUpdate', options);
          assertParentView('didUpdate', this);
          assertElement('didUpdate', this);
          assertState('didUpdate', 'inDOM', this);
        },

        willDestroyElement: function () {
          pushHook('willDestroyElement');
          assertParentView('willDestroyElement', this);
          assertElement('willDestroyElement', this);
          assertState('willDestroyElement', 'inDOM', this);
        },

        willClearRender: function () {
          pushHook('willClearRender');
          assertParentView('willClearRender', this);
          assertElement('willClearRender', this);
          assertState('willClearRender', 'inDOM', this);
        },

        didDestroyElement: function () {
          pushHook('didDestroyElement');
          assertNoElement('didDestroyElement', this);
          assertState('didDestroyElement', 'destroying', this);
        },

        willDestroy: function () {
          pushHook('willDestroy');
          removeComponent(this);

          this._super.apply(this, arguments);
        }
      });

      _RenderingTest.prototype.registerComponent.call(this, name, { ComponentClass: ComponentClass, template: template });
    };

    LifeCycleHooksTest.prototype.assertHooks = function assertHooks(_ref2) {
      var label = _ref2.label;
      var interactive = _ref2.interactive;
      var nonInteractive = _ref2.nonInteractive;

      var rawHooks = this.isInteractive ? interactive : nonInteractive;
      var hooks = rawHooks.map(function (raw) {
        return hook.apply(undefined, raw);
      });
      this.assert.deepEqual(json(this.hooks), json(hooks), label);
      this.hooks = [];
    };

    LifeCycleHooksTest.prototype['@test lifecycle hooks are invoked in a predictable order'] = function testLifecycleHooksAreInvokedInAPredictableOrder() {
      var _this3 = this;

      var _boundHelpers = this.boundHelpers;
      var attr = _boundHelpers.attr;
      var invoke = _boundHelpers.invoke;

      this.registerComponent('the-top', { template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject, attr('twitter'), invoke('the-middle', { name: string('Tom Dale') }))
      });

      this.registerComponent('the-middle', { template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject2, attr('name'), invoke('the-bottom', { website: string('tomdale.net') }))
      });

      this.registerComponent('the-bottom', { template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject3, attr('website'))
      });

      this.render(invoke('the-top', { twitter: expr('twitter') }), { twitter: '@tomdale' });

      this.assertText('Twitter: @tomdale|Name: Tom Dale|Website: tomdale.net');
      this.assertRegisteredViews('intial render');

      var topAttrs = { twitter: '@tomdale' };
      var middleAttrs = { name: 'Tom Dale' };
      var bottomAttrs = { website: 'tomdale.net' };

      this.assertHooks({
        label: 'after initial render',

        interactive: [
        // Sync hooks

        ['the-top', 'init'], ['the-top', 'didInitAttrs', { attrs: topAttrs }], ['the-top', 'didReceiveAttrs', { newAttrs: topAttrs }], ['the-top', 'on(init)'], ['the-top', 'willRender'], ['the-top', 'willInsertElement'], ['the-middle', 'init'], ['the-middle', 'didInitAttrs', { attrs: middleAttrs }], ['the-middle', 'didReceiveAttrs', { newAttrs: middleAttrs }], ['the-middle', 'on(init)'], ['the-middle', 'willRender'], ['the-middle', 'willInsertElement'], ['the-bottom', 'init'], ['the-bottom', 'didInitAttrs', { attrs: bottomAttrs }], ['the-bottom', 'didReceiveAttrs', { newAttrs: bottomAttrs }], ['the-bottom', 'on(init)'], ['the-bottom', 'willRender'], ['the-bottom', 'willInsertElement'],

        // Async hooks

        ['the-bottom', 'didInsertElement'], ['the-bottom', 'didRender'], ['the-middle', 'didInsertElement'], ['the-middle', 'didRender'], ['the-top', 'didInsertElement'], ['the-top', 'didRender']],

        nonInteractive: [
        // Sync hooks
        ['the-top', 'init'], ['the-top', 'didInitAttrs', { attrs: topAttrs }], ['the-top', 'didReceiveAttrs', { newAttrs: topAttrs }], ['the-top', 'on(init)'], ['the-middle', 'init'], ['the-middle', 'didInitAttrs', { attrs: middleAttrs }], ['the-middle', 'didReceiveAttrs', { newAttrs: middleAttrs }], ['the-middle', 'on(init)'], ['the-bottom', 'init'], ['the-bottom', 'didInitAttrs', { attrs: bottomAttrs }], ['the-bottom', 'didReceiveAttrs', { newAttrs: bottomAttrs }], ['the-bottom', 'on(init)']]
      });

      this.runTask(function () {
        return _this3.components['the-bottom'].rerender();
      });

      this.assertText('Twitter: @tomdale|Name: Tom Dale|Website: tomdale.net');

      this.assertHooks({
        label: 'after no-op rerender (bottom)',

        interactive: [
        // Sync hooks
        ['the-top', 'willUpdate'], ['the-top', 'willRender'], ['the-middle', 'willUpdate'], ['the-middle', 'willRender'], ['the-bottom', 'willUpdate'], ['the-bottom', 'willRender'],

        // Async hooks

        ['the-bottom', 'didUpdate'], ['the-bottom', 'didRender'], ['the-middle', 'didUpdate'], ['the-middle', 'didRender'], ['the-top', 'didUpdate'], ['the-top', 'didRender']],

        nonInteractive: []
      });

      this.runTask(function () {
        return _this3.components['the-middle'].rerender();
      });

      this.assertText('Twitter: @tomdale|Name: Tom Dale|Website: tomdale.net');

      this.assertHooks({
        label: 'after no-op rerender (middle)',

        interactive: [
        // Sync hooks

        ['the-top', 'willUpdate'], ['the-top', 'willRender'], ['the-middle', 'willUpdate'], ['the-middle', 'willRender'],

        // Async hooks

        ['the-middle', 'didUpdate'], ['the-middle', 'didRender'], ['the-top', 'didUpdate'], ['the-top', 'didRender']],

        nonInteractive: []
      });

      this.runTask(function () {
        return _this3.components['the-top'].rerender();
      });

      this.assertText('Twitter: @tomdale|Name: Tom Dale|Website: tomdale.net');

      this.assertHooks({
        label: 'after no-op rerender (top)',

        interactive: [
        // Sync hooks

        ['the-top', 'willUpdate'], ['the-top', 'willRender'],

        // Async hooks

        ['the-top', 'didUpdate'], ['the-top', 'didRender']],

        nonInteractive: []
      });

      this.runTask(function () {
        return _emberMetal.set(_this3.context, 'twitter', '@horsetomdale');
      });

      this.assertText('Twitter: @horsetomdale|Name: Tom Dale|Website: tomdale.net');

      // Because the `twitter` attr is only used by the topmost component,
      // and not passed down, we do not expect to see lifecycle hooks
      // called for child components. If the `didReceiveAttrs` hook used
      // the new attribute to rerender itself imperatively, that would result
      // in lifecycle hooks being invoked for the child.

      topAttrs = { oldAttrs: { twitter: '@tomdale' }, newAttrs: { twitter: '@horsetomdale' } };

      this.assertHooks({
        label: 'after update',

        interactive: [
        // Sync hooks

        ['the-top', 'didUpdateAttrs', topAttrs], ['the-top', 'didReceiveAttrs', topAttrs], ['the-top', 'willUpdate'], ['the-top', 'willRender'],

        // Async hooks

        ['the-top', 'didUpdate'], ['the-top', 'didRender']],

        nonInteractive: [
        // Sync hooks
        ['the-top', 'didUpdateAttrs', topAttrs], ['the-top', 'didReceiveAttrs', topAttrs]]
      });

      this.teardownAssertions.push(function () {
        _this3.assertHooks({
          label: 'destroy',

          interactive: [['the-top', 'willDestroyElement'], ['the-top', 'willClearRender'], ['the-middle', 'willDestroyElement'], ['the-middle', 'willClearRender'], ['the-bottom', 'willDestroyElement'], ['the-bottom', 'willClearRender'], ['the-top', 'didDestroyElement'], ['the-middle', 'didDestroyElement'], ['the-bottom', 'didDestroyElement'], ['the-top', 'willDestroy'], ['the-middle', 'willDestroy'], ['the-bottom', 'willDestroy']],

          nonInteractive: [['the-top', 'willDestroy'], ['the-middle', 'willDestroy'], ['the-bottom', 'willDestroy']]
        });

        _this3.assertRegisteredViews('after destroy');
      });
    };

    LifeCycleHooksTest.prototype['@test lifecycle hooks are invoked in a correct sibling order'] = function testLifecycleHooksAreInvokedInACorrectSiblingOrder() {
      var _this4 = this;

      var _boundHelpers2 = this.boundHelpers;
      var attr = _boundHelpers2.attr;
      var invoke = _boundHelpers2.invoke;

      this.registerComponent('the-parent', { template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject4, invoke('the-first-child', { twitter: expr(attr('twitter')) }), invoke('the-second-child', { name: expr(attr('name')) }), invoke('the-last-child', { website: expr(attr('website')) }))
      });

      this.registerComponent('the-first-child', { template: 'Twitter: {{' + attr('twitter') + '}}' });

      this.registerComponent('the-second-child', { template: 'Name: {{' + attr('name') + '}}' });

      this.registerComponent('the-last-child', { template: 'Website: {{' + attr('website') + '}}' });

      this.render(invoke('the-parent', {
        twitter: expr('twitter'),
        name: expr('name'),
        website: expr('website')
      }), {
        twitter: '@tomdale',
        name: 'Tom Dale',
        website: 'tomdale.net'
      });

      this.assertText('Twitter: @tomdale|Name: Tom Dale|Website: tomdale.net');
      this.assertRegisteredViews('intial render');

      var parentAttrs = { twitter: '@tomdale', name: 'Tom Dale', website: 'tomdale.net' };
      var firstAttrs = { twitter: '@tomdale' };
      var secondAttrs = { name: 'Tom Dale' };
      var lastAttrs = { website: 'tomdale.net' };

      this.assertHooks({
        label: 'after initial render',

        interactive: [
        // Sync hooks

        ['the-parent', 'init'], ['the-parent', 'didInitAttrs', { attrs: parentAttrs }], ['the-parent', 'didReceiveAttrs', { newAttrs: parentAttrs }], ['the-parent', 'on(init)'], ['the-parent', 'willRender'], ['the-parent', 'willInsertElement'], ['the-first-child', 'init'], ['the-first-child', 'didInitAttrs', { attrs: firstAttrs }], ['the-first-child', 'didReceiveAttrs', { newAttrs: firstAttrs }], ['the-first-child', 'on(init)'], ['the-first-child', 'willRender'], ['the-first-child', 'willInsertElement'], ['the-second-child', 'init'], ['the-second-child', 'didInitAttrs', { attrs: secondAttrs }], ['the-second-child', 'didReceiveAttrs', { newAttrs: secondAttrs }], ['the-second-child', 'on(init)'], ['the-second-child', 'willRender'], ['the-second-child', 'willInsertElement'], ['the-last-child', 'init'], ['the-last-child', 'didInitAttrs', { attrs: lastAttrs }], ['the-last-child', 'didReceiveAttrs', { newAttrs: lastAttrs }], ['the-last-child', 'on(init)'], ['the-last-child', 'willRender'], ['the-last-child', 'willInsertElement'],

        // Async hooks

        ['the-first-child', 'didInsertElement'], ['the-first-child', 'didRender'], ['the-second-child', 'didInsertElement'], ['the-second-child', 'didRender'], ['the-last-child', 'didInsertElement'], ['the-last-child', 'didRender'], ['the-parent', 'didInsertElement'], ['the-parent', 'didRender']],

        nonInteractive: [
        // Sync hooks

        ['the-parent', 'init'], ['the-parent', 'didInitAttrs', { attrs: parentAttrs }], ['the-parent', 'didReceiveAttrs', { newAttrs: parentAttrs }], ['the-parent', 'on(init)'], ['the-first-child', 'init'], ['the-first-child', 'didInitAttrs', { attrs: firstAttrs }], ['the-first-child', 'didReceiveAttrs', { newAttrs: firstAttrs }], ['the-first-child', 'on(init)'], ['the-second-child', 'init'], ['the-second-child', 'didInitAttrs', { attrs: secondAttrs }], ['the-second-child', 'didReceiveAttrs', { newAttrs: secondAttrs }], ['the-second-child', 'on(init)'], ['the-last-child', 'init'], ['the-last-child', 'didInitAttrs', { attrs: lastAttrs }], ['the-last-child', 'didReceiveAttrs', { newAttrs: lastAttrs }], ['the-last-child', 'on(init)']]
      });

      this.runTask(function () {
        return _this4.components['the-first-child'].rerender();
      });

      this.assertText('Twitter: @tomdale|Name: Tom Dale|Website: tomdale.net');

      this.assertHooks({
        label: 'after no-op rerender (first child)',

        interactive: [
        // Sync hooks

        ['the-parent', 'willUpdate'], ['the-parent', 'willRender'], ['the-first-child', 'willUpdate'], ['the-first-child', 'willRender'],

        // Async hooks

        ['the-first-child', 'didUpdate'], ['the-first-child', 'didRender'], ['the-parent', 'didUpdate'], ['the-parent', 'didRender']],

        nonInteractive: []
      });

      this.runTask(function () {
        return _this4.components['the-second-child'].rerender();
      });

      this.assertText('Twitter: @tomdale|Name: Tom Dale|Website: tomdale.net');

      this.assertHooks({
        label: 'after no-op rerender (second child)',

        interactive: [
        // Sync hooks

        ['the-parent', 'willUpdate'], ['the-parent', 'willRender'], ['the-second-child', 'willUpdate'], ['the-second-child', 'willRender'],

        // Async hooks

        ['the-second-child', 'didUpdate'], ['the-second-child', 'didRender'], ['the-parent', 'didUpdate'], ['the-parent', 'didRender']],

        nonInteractive: []
      });

      this.runTask(function () {
        return _this4.components['the-last-child'].rerender();
      });

      this.assertText('Twitter: @tomdale|Name: Tom Dale|Website: tomdale.net');

      this.assertHooks({
        label: 'after no-op rerender (last child)',

        interactive: [
        // Sync hooks

        ['the-parent', 'willUpdate'], ['the-parent', 'willRender'], ['the-last-child', 'willUpdate'], ['the-last-child', 'willRender'],

        // Async hooks

        ['the-last-child', 'didUpdate'], ['the-last-child', 'didRender'], ['the-parent', 'didUpdate'], ['the-parent', 'didRender']],

        nonInteractive: []
      });

      this.runTask(function () {
        return _this4.components['the-parent'].rerender();
      });

      this.assertText('Twitter: @tomdale|Name: Tom Dale|Website: tomdale.net');

      this.assertHooks({
        label: 'after no-op rerender (parent)',

        interactive: [
        // Sync hooks

        ['the-parent', 'willUpdate'], ['the-parent', 'willRender'],

        // Async hooks

        ['the-parent', 'didUpdate'], ['the-parent', 'didRender']],

        nonInteractive: []
      });

      this.runTask(function () {
        return _emberMetal.setProperties(_this4.context, {
          twitter: '@horsetomdale',
          name: 'Horse Tom Dale',
          website: 'horsetomdale.net'
        });
      });

      this.assertText('Twitter: @horsetomdale|Name: Horse Tom Dale|Website: horsetomdale.net');

      parentAttrs = {
        oldAttrs: { twitter: '@tomdale', name: 'Tom Dale', website: 'tomdale.net' },
        newAttrs: { twitter: '@horsetomdale', name: 'Horse Tom Dale', website: 'horsetomdale.net' }
      };
      firstAttrs = { oldAttrs: { twitter: '@tomdale' }, newAttrs: { twitter: '@horsetomdale' } };
      secondAttrs = { oldAttrs: { name: 'Tom Dale' }, newAttrs: { name: 'Horse Tom Dale' } };
      lastAttrs = { oldAttrs: { website: 'tomdale.net' }, newAttrs: { website: 'horsetomdale.net' } };

      this.assertHooks({
        label: 'after update',

        interactive: [
        // Sync hooks

        ['the-parent', 'didUpdateAttrs', parentAttrs], ['the-parent', 'didReceiveAttrs', parentAttrs], ['the-parent', 'willUpdate'], ['the-parent', 'willRender'], ['the-first-child', 'didUpdateAttrs', firstAttrs], ['the-first-child', 'didReceiveAttrs', firstAttrs], ['the-first-child', 'willUpdate'], ['the-first-child', 'willRender'], ['the-second-child', 'didUpdateAttrs', secondAttrs], ['the-second-child', 'didReceiveAttrs', secondAttrs], ['the-second-child', 'willUpdate'], ['the-second-child', 'willRender'], ['the-last-child', 'didUpdateAttrs', lastAttrs], ['the-last-child', 'didReceiveAttrs', lastAttrs], ['the-last-child', 'willUpdate'], ['the-last-child', 'willRender'],

        // Async hooks

        ['the-first-child', 'didUpdate'], ['the-first-child', 'didRender'], ['the-second-child', 'didUpdate'], ['the-second-child', 'didRender'], ['the-last-child', 'didUpdate'], ['the-last-child', 'didRender'], ['the-parent', 'didUpdate'], ['the-parent', 'didRender']],

        nonInteractive: [
        // Sync hooks

        ['the-parent', 'didUpdateAttrs', parentAttrs], ['the-parent', 'didReceiveAttrs', parentAttrs], ['the-first-child', 'didUpdateAttrs', firstAttrs], ['the-first-child', 'didReceiveAttrs', firstAttrs], ['the-second-child', 'didUpdateAttrs', secondAttrs], ['the-second-child', 'didReceiveAttrs', secondAttrs], ['the-last-child', 'didUpdateAttrs', lastAttrs], ['the-last-child', 'didReceiveAttrs', lastAttrs]]
      });

      this.teardownAssertions.push(function () {
        _this4.assertHooks({
          label: 'destroy',

          interactive: [['the-parent', 'willDestroyElement'], ['the-parent', 'willClearRender'], ['the-first-child', 'willDestroyElement'], ['the-first-child', 'willClearRender'], ['the-second-child', 'willDestroyElement'], ['the-second-child', 'willClearRender'], ['the-last-child', 'willDestroyElement'], ['the-last-child', 'willClearRender'], ['the-parent', 'didDestroyElement'], ['the-first-child', 'didDestroyElement'], ['the-second-child', 'didDestroyElement'], ['the-last-child', 'didDestroyElement'], ['the-parent', 'willDestroy'], ['the-first-child', 'willDestroy'], ['the-second-child', 'willDestroy'], ['the-last-child', 'willDestroy']],

          nonInteractive: [['the-parent', 'willDestroy'], ['the-first-child', 'willDestroy'], ['the-second-child', 'willDestroy'], ['the-last-child', 'willDestroy']]
        });

        _this4.assertRegisteredViews('after destroy');
      });
    };

    LifeCycleHooksTest.prototype['@test passing values through attrs causes lifecycle hooks to fire if the attribute values have changed'] = function testPassingValuesThroughAttrsCausesLifecycleHooksToFireIfTheAttributeValuesHaveChanged() {
      var _this5 = this;

      var _boundHelpers3 = this.boundHelpers;
      var attr = _boundHelpers3.attr;
      var invoke = _boundHelpers3.invoke;

      this.registerComponent('the-top', { template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject5, invoke('the-middle', { twitterTop: expr(attr('twitter')) }))
      });

      this.registerComponent('the-middle', { template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject6, invoke('the-bottom', { twitterMiddle: expr(attr('twitterTop')) }))
      });

      this.registerComponent('the-bottom', { template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject7, attr('twitterMiddle'))
      });

      this.render(invoke('the-top', { twitter: expr('twitter') }), { twitter: '@tomdale' });

      this.assertText('Top: Middle: Bottom: @tomdale');
      this.assertRegisteredViews('intial render');

      var topAttrs = { twitter: '@tomdale' };
      var middleAttrs = { twitterTop: '@tomdale' };
      var bottomAttrs = { twitterMiddle: '@tomdale' };

      this.assertHooks({
        label: 'after initial render',

        interactive: [
        // Sync hooks

        ['the-top', 'init'], ['the-top', 'didInitAttrs', { attrs: topAttrs }], ['the-top', 'didReceiveAttrs', { newAttrs: topAttrs }], ['the-top', 'on(init)'], ['the-top', 'willRender'], ['the-top', 'willInsertElement'], ['the-middle', 'init'], ['the-middle', 'didInitAttrs', { attrs: middleAttrs }], ['the-middle', 'didReceiveAttrs', { newAttrs: middleAttrs }], ['the-middle', 'on(init)'], ['the-middle', 'willRender'], ['the-middle', 'willInsertElement'], ['the-bottom', 'init'], ['the-bottom', 'didInitAttrs', { attrs: bottomAttrs }], ['the-bottom', 'didReceiveAttrs', { newAttrs: bottomAttrs }], ['the-bottom', 'on(init)'], ['the-bottom', 'willRender'], ['the-bottom', 'willInsertElement'],

        // Async hooks

        ['the-bottom', 'didInsertElement'], ['the-bottom', 'didRender'], ['the-middle', 'didInsertElement'], ['the-middle', 'didRender'], ['the-top', 'didInsertElement'], ['the-top', 'didRender']],

        nonInteractive: [
        // Sync hooks

        ['the-top', 'init'], ['the-top', 'didInitAttrs', { attrs: topAttrs }], ['the-top', 'didReceiveAttrs', { newAttrs: topAttrs }], ['the-top', 'on(init)'], ['the-middle', 'init'], ['the-middle', 'didInitAttrs', { attrs: middleAttrs }], ['the-middle', 'didReceiveAttrs', { newAttrs: middleAttrs }], ['the-middle', 'on(init)'], ['the-bottom', 'init'], ['the-bottom', 'didInitAttrs', { attrs: bottomAttrs }], ['the-bottom', 'didReceiveAttrs', { newAttrs: bottomAttrs }], ['the-bottom', 'on(init)']]
      });

      this.runTask(function () {
        return _emberMetal.set(_this5.context, 'twitter', '@horsetomdale');
      });

      this.assertText('Top: Middle: Bottom: @horsetomdale');

      // Because the `twitter` attr is used by the all of the components,
      // the lifecycle hooks are invoked for all components.

      topAttrs = { oldAttrs: { twitter: '@tomdale' }, newAttrs: { twitter: '@horsetomdale' } };
      middleAttrs = { oldAttrs: { twitterTop: '@tomdale' }, newAttrs: { twitterTop: '@horsetomdale' } };
      bottomAttrs = { oldAttrs: { twitterMiddle: '@tomdale' }, newAttrs: { twitterMiddle: '@horsetomdale' } };

      this.assertHooks({
        label: 'after updating (root)',

        interactive: [
        // Sync hooks

        ['the-top', 'didUpdateAttrs', topAttrs], ['the-top', 'didReceiveAttrs', topAttrs], ['the-top', 'willUpdate'], ['the-top', 'willRender'], ['the-middle', 'didUpdateAttrs', middleAttrs], ['the-middle', 'didReceiveAttrs', middleAttrs], ['the-middle', 'willUpdate'], ['the-middle', 'willRender'], ['the-bottom', 'didUpdateAttrs', bottomAttrs], ['the-bottom', 'didReceiveAttrs', bottomAttrs], ['the-bottom', 'willUpdate'], ['the-bottom', 'willRender'],

        // Async hooks

        ['the-bottom', 'didUpdate'], ['the-bottom', 'didRender'], ['the-middle', 'didUpdate'], ['the-middle', 'didRender'], ['the-top', 'didUpdate'], ['the-top', 'didRender']],

        nonInteractive: [
        // Sync hooks

        ['the-top', 'didUpdateAttrs', topAttrs], ['the-top', 'didReceiveAttrs', topAttrs], ['the-middle', 'didUpdateAttrs', middleAttrs], ['the-middle', 'didReceiveAttrs', middleAttrs], ['the-bottom', 'didUpdateAttrs', bottomAttrs], ['the-bottom', 'didReceiveAttrs', bottomAttrs]]
      });

      this.runTask(function () {
        return _this5.rerender();
      });

      this.assertText('Top: Middle: Bottom: @horsetomdale');

      // In this case, because the attrs are passed down, all child components are invoked.

      topAttrs = { oldAttrs: { twitter: '@horsetomdale' }, newAttrs: { twitter: '@horsetomdale' } };
      middleAttrs = { oldAttrs: { twitterTop: '@horsetomdale' }, newAttrs: { twitterTop: '@horsetomdale' } };
      bottomAttrs = { oldAttrs: { twitterMiddle: '@horsetomdale' }, newAttrs: { twitterMiddle: '@horsetomdale' } };

      this.assertHooks({
        label: 'after no-op rernder (root)',
        interactive: [],
        nonInteractive: []
      });

      this.teardownAssertions.push(function () {
        _this5.assertHooks({
          label: 'destroy',

          interactive: [['the-top', 'willDestroyElement'], ['the-top', 'willClearRender'], ['the-middle', 'willDestroyElement'], ['the-middle', 'willClearRender'], ['the-bottom', 'willDestroyElement'], ['the-bottom', 'willClearRender'], ['the-top', 'didDestroyElement'], ['the-middle', 'didDestroyElement'], ['the-bottom', 'didDestroyElement'], ['the-top', 'willDestroy'], ['the-middle', 'willDestroy'], ['the-bottom', 'willDestroy']],

          nonInteractive: [['the-top', 'willDestroy'], ['the-middle', 'willDestroy'], ['the-bottom', 'willDestroy']]
        });

        _this5.assertRegisteredViews('after destroy');
      });
    };

    LifeCycleHooksTest.prototype['@test components rendered from `{{each}}` have correct life-cycle hooks to be called'] = function testComponentsRenderedFromEachHaveCorrectLifeCycleHooksToBeCalled() {
      var _this6 = this;

      var invoke = this.boundHelpers.invoke;

      this.registerComponent('nested-item', { template: '{{yield}}' });

      this.registerComponent('an-item', { template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject8) });

      this.registerComponent('no-items', { template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject9) });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject10, invoke('an-item', { count: expr('item') }), invoke('no-items')), {
        items: [1, 2, 3, 4, 5]
      });

      this.assertText('Item: 1Item: 2Item: 3Item: 4Item: 5');
      this.assertRegisteredViews('intial render');

      var initialHooks = function (count) {
        var ret = [['an-item', 'init'], ['an-item', 'didInitAttrs', { attrs: { count: count } }], ['an-item', 'didReceiveAttrs', { newAttrs: { count: count } }], ['an-item', 'on(init)']];
        if (_this6.isInteractive) {
          ret.push(['an-item', 'willRender'], ['an-item', 'willInsertElement']);
        }
        ret.push(['nested-item', 'init'], ['nested-item', 'didInitAttrs', { attrs: {} }], ['nested-item', 'didReceiveAttrs', { newAttrs: {} }], ['nested-item', 'on(init)']);
        if (_this6.isInteractive) {
          ret.push(['nested-item', 'willRender'], ['nested-item', 'willInsertElement']);
        }
        return ret;
      };

      var initialAfterRenderHooks = function (count) {
        if (_this6.isInteractive) {
          return [['nested-item', 'didInsertElement'], ['nested-item', 'didRender'], ['an-item', 'didInsertElement'], ['an-item', 'didRender']];
        } else {
          return [];
        }
      };

      this.assertHooks({
        label: 'after initial render',

        interactive: [].concat(initialHooks(1), initialHooks(2), initialHooks(3), initialHooks(4), initialHooks(5), initialAfterRenderHooks(5), initialAfterRenderHooks(4), initialAfterRenderHooks(3), initialAfterRenderHooks(2), initialAfterRenderHooks(1)),

        nonInteractive: [].concat(initialHooks(1), initialHooks(2), initialHooks(3), initialHooks(4), initialHooks(5), initialAfterRenderHooks(5), initialAfterRenderHooks(4), initialAfterRenderHooks(3), initialAfterRenderHooks(2), initialAfterRenderHooks(1))
      });

      // TODO: Is this correct? Should childViews be populated in non-interactive mode?
      if (this.isInteractive) {
        this.assert.equal(this.component.childViews.length, 5, 'childViews precond');
      }

      this.runTask(function () {
        return _emberMetal.set(_this6.context, 'items', []);
      });

      // TODO: Is this correct? Should childViews be populated in non-interactive mode?
      if (this.isInteractive) {
        this.assert.equal(this.component.childViews.length, 1, 'childViews updated');
      }

      this.assertText('Nothing to see here');

      this.assertHooks({
        label: 'reset to empty array',

        interactive: [['an-item', 'willDestroyElement'], ['an-item', 'willClearRender'], ['nested-item', 'willDestroyElement'], ['nested-item', 'willClearRender'], ['an-item', 'willDestroyElement'], ['an-item', 'willClearRender'], ['nested-item', 'willDestroyElement'], ['nested-item', 'willClearRender'], ['an-item', 'willDestroyElement'], ['an-item', 'willClearRender'], ['nested-item', 'willDestroyElement'], ['nested-item', 'willClearRender'], ['an-item', 'willDestroyElement'], ['an-item', 'willClearRender'], ['nested-item', 'willDestroyElement'], ['nested-item', 'willClearRender'], ['an-item', 'willDestroyElement'], ['an-item', 'willClearRender'], ['nested-item', 'willDestroyElement'], ['nested-item', 'willClearRender'], ['no-items', 'init'], ['no-items', 'didInitAttrs', { attrs: {} }], ['no-items', 'didReceiveAttrs', { newAttrs: {} }], ['no-items', 'on(init)'], ['no-items', 'willRender'], ['no-items', 'willInsertElement'], ['nested-item', 'init'], ['nested-item', 'didInitAttrs', { attrs: {} }], ['nested-item', 'didReceiveAttrs', { newAttrs: {} }], ['nested-item', 'on(init)'], ['nested-item', 'willRender'], ['nested-item', 'willInsertElement'], ['an-item', 'didDestroyElement'], ['nested-item', 'didDestroyElement'], ['an-item', 'didDestroyElement'], ['nested-item', 'didDestroyElement'], ['an-item', 'didDestroyElement'], ['nested-item', 'didDestroyElement'], ['an-item', 'didDestroyElement'], ['nested-item', 'didDestroyElement'], ['an-item', 'didDestroyElement'], ['nested-item', 'didDestroyElement'], ['nested-item', 'didInsertElement'], ['nested-item', 'didRender'], ['no-items', 'didInsertElement'], ['no-items', 'didRender'], ['an-item', 'willDestroy'], ['nested-item', 'willDestroy'], ['an-item', 'willDestroy'], ['nested-item', 'willDestroy'], ['an-item', 'willDestroy'], ['nested-item', 'willDestroy'], ['an-item', 'willDestroy'], ['nested-item', 'willDestroy'], ['an-item', 'willDestroy'], ['nested-item', 'willDestroy']],

        nonInteractive: [['no-items', 'init'], ['no-items', 'didInitAttrs', { attrs: {} }], ['no-items', 'didReceiveAttrs', { newAttrs: {} }], ['no-items', 'on(init)'], ['nested-item', 'init'], ['nested-item', 'didInitAttrs', { attrs: {} }], ['nested-item', 'didReceiveAttrs', { newAttrs: {} }], ['nested-item', 'on(init)'], ['an-item', 'willDestroy'], ['nested-item', 'willDestroy'], ['an-item', 'willDestroy'], ['nested-item', 'willDestroy'], ['an-item', 'willDestroy'], ['nested-item', 'willDestroy'], ['an-item', 'willDestroy'], ['nested-item', 'willDestroy'], ['an-item', 'willDestroy'], ['nested-item', 'willDestroy']]
      });

      this.teardownAssertions.push(function () {
        _this6.assertHooks({
          label: 'destroy',

          interactive: [['no-items', 'willDestroyElement'], ['no-items', 'willClearRender'], ['nested-item', 'willDestroyElement'], ['nested-item', 'willClearRender'], ['no-items', 'didDestroyElement'], ['nested-item', 'didDestroyElement'], ['no-items', 'willDestroy'], ['nested-item', 'willDestroy']],

          nonInteractive: [['no-items', 'willDestroy'], ['nested-item', 'willDestroy']]
        });

        _this6.assertRegisteredViews('after destroy');
      });
    };

babelHelpers.createClass(LifeCycleHooksTest, [{
      key: 'isInteractive',
      get: function () {
        return true;
      }
    }, {
      key: 'ComponentClass',
      get: function () {
        throw new Error('Not implemented: `ComponentClass`');
      }
    }, {
      key: 'boundHelpers',
      get: function () {
        return {
          invoke: bind(this.invocationFor, this),
          attr: bind(this.attrFor, this)
        };
      }
    }]);
    return LifeCycleHooksTest;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest);

  var CurlyComponentsTest = (function (_LifeCycleHooksTest) {
babelHelpers.inherits(CurlyComponentsTest, _LifeCycleHooksTest);

    function CurlyComponentsTest() {
      _LifeCycleHooksTest.apply(this, arguments);
    }

    CurlyComponentsTest.prototype.invocationFor = function invocationFor(name) {
      var _this7 = this;

      var namedArgs = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      var attrs = Object.keys(namedArgs).map(function (k) {
        return k + '=' + _this7.val(namedArgs[k]);
      }).join(' ');
      return '{{' + name + ' ' + attrs + '}}';
    };

    CurlyComponentsTest.prototype.attrFor = function attrFor(name) {
      return '' + name;
    };

    /* private */

    CurlyComponentsTest.prototype.val = function val(value) {
      if (value.isString) {
        return JSON.stringify(value.value);
      } else if (value.isExpr) {
        return '(readonly ' + value.value + ')';
      } else {
        throw new Error('Unknown value: ' + value);
      }
    };

babelHelpers.createClass(CurlyComponentsTest, [{
      key: 'ComponentClass',
      get: function () {
        return _emberGlimmerTestsUtilsHelpers.Component;
      }
    }]);
    return CurlyComponentsTest;
  })(LifeCycleHooksTest);

  _emberGlimmerTestsUtilsTestCase.moduleFor('Components test: interactive lifecycle hooks (curly components)', (function (_CurlyComponentsTest) {
babelHelpers.inherits(_class, _CurlyComponentsTest);

    function _class() {
      _CurlyComponentsTest.apply(this, arguments);
    }

babelHelpers.createClass(_class, [{
      key: 'isInteractive',
      get: function () {
        return true;
      }
    }]);
    return _class;
  })(CurlyComponentsTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Components test: non-interactive lifecycle hooks (curly components)', (function (_CurlyComponentsTest2) {
babelHelpers.inherits(_class2, _CurlyComponentsTest2);

    function _class2() {
      _CurlyComponentsTest2.apply(this, arguments);
    }

babelHelpers.createClass(_class2, [{
      key: 'isInteractive',
      get: function () {
        return false;
      }
    }]);
    return _class2;
  })(CurlyComponentsTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Components test: interactive lifecycle hooks (tagless curly components)', (function (_CurlyComponentsTest3) {
babelHelpers.inherits(_class3, _CurlyComponentsTest3);

    function _class3() {
      _CurlyComponentsTest3.apply(this, arguments);
    }

babelHelpers.createClass(_class3, [{
      key: 'ComponentClass',
      get: function () {
        return _emberGlimmerTestsUtilsHelpers.Component.extend({ tagName: '' });
      }
    }, {
      key: 'isInteractive',
      get: function () {
        return true;
      }
    }]);
    return _class3;
  })(CurlyComponentsTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Components test: non-interactive lifecycle hooks (tagless curly components)', (function (_CurlyComponentsTest4) {
babelHelpers.inherits(_class4, _CurlyComponentsTest4);

    function _class4() {
      _CurlyComponentsTest4.apply(this, arguments);
    }

babelHelpers.createClass(_class4, [{
      key: 'ComponentClass',
      get: function () {
        return _emberGlimmerTestsUtilsHelpers.Component.extend({ tagName: '' });
      }
    }, {
      key: 'isInteractive',
      get: function () {
        return false;
      }
    }]);
    return _class4;
  })(CurlyComponentsTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Run loop and lifecycle hooks', (function (_RenderingTest2) {
babelHelpers.inherits(_class5, _RenderingTest2);

    function _class5() {
      _RenderingTest2.apply(this, arguments);
    }

    _class5.prototype['@test afterRender set'] = function testAfterRenderSet() {
      var _this9 = this;

      var ComponentClass = _emberGlimmerTestsUtilsHelpers.Component.extend({
        width: '5',
        didInsertElement: function () {
          var _this8 = this;

          _emberMetal.run.scheduleOnce('afterRender', function () {
            _this8.set('width', '10');
          });
        }
      });

      var template = '{{width}}';
      this.registerComponent('foo-bar', { ComponentClass: ComponentClass, template: template });

      this.render('{{foo-bar}}');

      this.assertText('10');

      this.runTask(function () {
        return _this9.rerender();
      });

      this.assertText('10');
    };

    _class5.prototype['@test afterRender set on parent'] = function testAfterRenderSetOnParent() {
      var _this11 = this;

      var ComponentClass = _emberGlimmerTestsUtilsHelpers.Component.extend({
        didInsertElement: function () {
          var _this10 = this;

          _emberMetal.run.scheduleOnce('afterRender', function () {
            var parent = _this10.get('parent');
            parent.set('foo', 'wat');
          });
        }
      });

      var template = '{{foo}}';

      this.registerComponent('foo-bar', { ComponentClass: ComponentClass, template: template });

      this.render('{{foo-bar parent=this foo=foo}}');

      this.assertText('wat');

      this.runTask(function () {
        return _this11.rerender();
      });

      this.assertText('wat');
    };

    _class5.prototype['@test `willRender` can set before render (GH#14458)'] = function testWillRenderCanSetBeforeRenderGH14458(assert) {
      var ComponentClass = _emberGlimmerTestsUtilsHelpers.Component.extend({
        tagName: 'a',
        customHref: 'http://google.com',
        attributeBindings: ['customHref:href'],
        willRender: function () {
          this.set('customHref', 'http://willRender.com');
        }
      });

      var template = 'Hello World';

      this.registerComponent('foo-bar', { ComponentClass: ComponentClass, template: template });

      this.render('{{foo-bar id="foo"}}');

      this.assertElement(this.firstChild, {
        tagName: 'a',
        attrs: {
          id: 'foo',
          href: 'http://willRender.com',
          class: _emberGlimmerTestsUtilsTestHelpers.classes('ember-view')
        }
      });
    };

    _class5.prototype['@test that thing about destroying'] = function testThatThingAboutDestroying(assert) {
      var _this12 = this;

      var ParentDestroyedElements = [];
      var ChildDestroyedElements = [];

      var ParentComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        willDestroyElement: function () {
          ParentDestroyedElements.push({
            id: this.itemId,
            name: 'parent-component',
            hasParent: !!this.element.parentNode,
            nextSibling: !!this.element.nextSibling,
            previousSibling: !!this.element.previousSibling
          });
        }
      });

      var PartentTemplate = _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject11);

      var NestedComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        willDestroyElement: function () {
          ChildDestroyedElements.push({
            id: this.nestedId,
            name: 'nested-component',
            hasParent: !!this.element.parentNode,
            nextSibling: !!this.element.nextSibling,
            previousSibling: !!this.element.previousSibling
          });
        }
      });

      var NestedTemplate = '{{yield}}';

      this.registerComponent('parent-component', {
        ComponentClass: ParentComponent,
        template: PartentTemplate
      });

      this.registerComponent('nested-component', {
        ComponentClass: NestedComponent,
        template: NestedTemplate
      });

      var array = _emberRuntime.A([{ id: 1 }, { id: 2 }, { id: 3 }, { id: 4 }, { id: 5 }]);

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject12), {
        items: array,
        model: { shouldShow: true }
      });

      this.assertText('1AB2AB3AB4AB5AB6AB7AB');

      this.runTask(function () {
        array.removeAt(2);
        array.removeAt(2);
        _emberMetal.set(_this12.context, 'model.shouldShow', false);
      });

      this.assertText('1AB2AB5AB');

      assertDestroyHooks(assert, [].concat(ParentDestroyedElements), [{
        id: 3,
        hasParent: true,
        nextSibling: true,
        previousSibling: true
      }, {
        id: 4,
        hasParent: true,
        nextSibling: true,
        previousSibling: true
      }, {
        id: 6,
        hasParent: true,
        nextSibling: true,
        previousSibling: true
      }, {
        id: 7,
        hasParent: true,
        nextSibling: false,
        previousSibling: true
      }]);

      assertDestroyHooks(assert, [].concat(ChildDestroyedElements), [{
        id: '3-A',
        hasParent: true,
        nextSibling: true,
        previousSibling: false
      }, {
        id: '3-B',
        hasParent: true,
        nextSibling: false,
        previousSibling: true
      }, {
        id: '4-A',
        hasParent: true,
        nextSibling: true,
        previousSibling: false
      }, {
        id: '4-B',
        hasParent: true,
        nextSibling: false,
        previousSibling: true
      }, {
        id: '6-A',
        hasParent: true,
        nextSibling: true,
        previousSibling: false
      }, {
        id: '6-B',
        hasParent: true,
        nextSibling: false,
        previousSibling: true
      }, {
        id: '7-A',
        hasParent: true,
        nextSibling: true,
        previousSibling: false
      }, {
        id: '7-B',
        hasParent: true,
        nextSibling: false,
        previousSibling: true
      }]);
    };

    _class5.prototype['@test lifecycle hooks have proper access to this.$()'] = function testLifecycleHooksHaveProperAccessToThis$(assert) {
      assert.expect(6);
      var component = undefined;
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        tagName: 'div',
        init: function () {
          assert.notOk(this.$(), 'no access to element via this.$() on init() enter');
          this._super.apply(this, arguments);
          assert.notOk(this.$(), 'no access to element via this.$() after init() finished');
        },
        willInsertElement: function () {
          component = this;
          assert.ok(this.$(), 'willInsertElement has access to element via this.$()');
        },
        didInsertElement: function () {
          assert.ok(this.$(), 'didInsertElement has access to element via this.$()');
        },
        willDestroyElement: function () {
          assert.ok(this.$(), 'willDestroyElement has access to element via this.$()');
        },
        didDestroyElement: function () {
          assert.notOk(this.$(), 'didDestroyElement does not have access to element via this.$()');
        }
      });
      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });
      var owner = this.owner;

      var comp = owner.lookup('component:foo-bar');
      _internalTestHelpers.runAppend(comp);
      this.runTask(function () {
        return _emberUtils.tryInvoke(component, 'destroy');
      });
    };

    return _class5;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));

  function assertDestroyHooks(assert, _actual, _expected) {
    _expected.forEach(function (expected, i) {
      var name = expected.name;
      assert.equal(expected.id, _actual[i].id, name + ' id is the same');
      assert.equal(expected.hasParent, _actual[i].hasParent, name + ' has parent node');
      assert.equal(expected.nextSibling, _actual[i].nextSibling, name + ' has next sibling node');
      assert.equal(expected.previousSibling, _actual[i].previousSibling, name + ' has previous sibling node');
    });
  }

  function bind(func, thisArg) {
    return function () {
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      return func.apply(thisArg, args);
    };
  }

  function string(value) {
    return { isString: true, value: value };
  }

  function expr(value) {
    return { isExpr: true, value: value };
  }

  function hook(name, hook, args) {
    return { name: name, hook: hook, args: args };
  }

  function json(serializable) {
    return JSON.parse(JSON.stringify(serializable));
  }
});

// Sync hooks

// Async hooks

// Sync hooks

// Async hooks
enifed('ember-glimmer/tests/integration/components/link-to-test', ['exports', 'ember-glimmer/tests/utils/test-case', 'ember-runtime', 'ember-metal', 'ember-glimmer/tests/utils/helpers', 'ember-glimmer/tests/utils/test-helpers'], function (exports, _emberGlimmerTestsUtilsTestCase, _emberRuntime, _emberMetal, _emberGlimmerTestsUtilsHelpers, _emberGlimmerTestsUtilsTestHelpers) {
  'use strict';

  _emberGlimmerTestsUtilsTestCase.moduleFor('Link-to component', (function (_ApplicationTest) {
    babelHelpers.inherits(_class, _ApplicationTest);

    function _class() {
      _ApplicationTest.apply(this, arguments);
    }

    _class.prototype.visitWithDeprecation = function visitWithDeprecation(path, deprecation) {
      var _this = this;

      var p = undefined;

      expectDeprecation(function () {
        p = _this.visit(path);
      }, deprecation);

      return p;
    };

    _class.prototype['@test accessing `currentWhen` triggers a deprecation'] = function testAccessingCurrentWhenTriggersADeprecation(assert) {
      var component = undefined;
      this.registerComponent('link-to', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.LinkComponent.extend({
          init: function () {
            this._super.apply(this, arguments);
            component = this;
          }
        })
      });

      this.registerTemplate('application', '{{link-to \'Index\' \'index\'}}');

      return this.visit('/').then(function () {
        expectDeprecation(function () {
          component.get('currentWhen');
        }, /Usage of `currentWhen` is deprecated, use `current-when` instead/);
      });
    };

    _class.prototype['@test should be able to be inserted in DOM when the router is not present'] = function testShouldBeAbleToBeInsertedInDOMWhenTheRouterIsNotPresent() {
      var _this2 = this;

      this.registerTemplate('application', '{{#link-to \'index\'}}Go to Index{{/link-to}}');

      return this.visit('/').then(function () {
        _this2.assertText('Go to Index');
      });
    };

    _class.prototype['@test re-renders when title changes'] = function testReRendersWhenTitleChanges() {
      var _this3 = this;

      var controller = undefined;

      this.registerTemplate('application', '{{link-to title routeName}}');
      this.registerController('application', _emberRuntime.Controller.extend({
        init: function () {
          this._super.apply(this, arguments);
          controller = this;
        },
        title: 'foo',
        routeName: 'index'
      }));

      return this.visit('/').then(function () {
        _this3.assertText('foo');
        _this3.runTask(function () {
          return _emberMetal.set(controller, 'title', 'bar');
        });
        _this3.assertText('bar');
      });
    };

    _class.prototype['@test escaped inline form (double curlies) escapes link title'] = function testEscapedInlineFormDoubleCurliesEscapesLinkTitle() {
      var _this4 = this;

      this.registerTemplate('application', '{{link-to title \'index\'}}');
      this.registerController('application', _emberRuntime.Controller.extend({
        title: '<b>blah</b>'
      }));

      return this.visit('/').then(function () {
        _this4.assertText('<b>blah</b>');
      });
    };

    _class.prototype['@test escaped inline form with (-html-safe) does not escape link title'] = function testEscapedInlineFormWithHtmlSafeDoesNotEscapeLinkTitle(assert) {
      var _this5 = this;

      this.registerTemplate('application', '{{link-to (-html-safe title) \'index\'}}');
      this.registerController('application', _emberRuntime.Controller.extend({
        title: '<b>blah</b>'
      }));

      return this.visit('/').then(function () {
        _this5.assertText('blah');
        assert.equal(_this5.$('b').length, 1);
      });
    };

    _class.prototype['@test unescaped inline form (triple curlies) does not escape link title'] = function testUnescapedInlineFormTripleCurliesDoesNotEscapeLinkTitle(assert) {
      var _this6 = this;

      this.registerTemplate('application', '{{{link-to title \'index\'}}}');
      this.registerController('application', _emberRuntime.Controller.extend({
        title: '<b>blah</b>'
      }));

      return this.visit('/').then(function () {
        _this6.assertText('blah');
        assert.equal(_this6.$('b').length, 1);
      });
    };

    _class.prototype['@test unwraps controllers'] = function testUnwrapsControllers() {
      var _this7 = this;

      this.router.map(function () {
        this.route('profile', { path: '/profile/:id' });
      });
      this.registerTemplate('application', '{{#link-to \'profile\' otherController}}Text{{/link-to}}');
      this.registerController('application', _emberRuntime.Controller.extend({
        otherController: _emberRuntime.Controller.create({
          model: 'foo'
        })
      }));

      var deprecation = /Providing `{{link-to}}` with a param that is wrapped in a controller is deprecated./;

      return this.visitWithDeprecation('/', deprecation).then(function () {
        _this7.assertText('Text');
      });
    };

    _class.prototype['@test able to safely extend the built-in component and use the normal path'] = function testAbleToSafelyExtendTheBuiltInComponentAndUseTheNormalPath() {
      var _this8 = this;

      this.registerComponent('custom-link-to', { ComponentClass: _emberGlimmerTestsUtilsHelpers.LinkComponent.extend() });
      this.registerTemplate('application', '{{#custom-link-to \'index\'}}{{title}}{{/custom-link-to}}');
      this.registerController('application', _emberRuntime.Controller.extend({
        title: 'Hello'
      }));

      return this.visit('/').then(function () {
        _this8.assertText('Hello');
      });
    };

    _class.prototype['@test [GH#13432] able to safely extend the built-in component and invoke it inline'] = function testGH13432AbleToSafelyExtendTheBuiltInComponentAndInvokeItInline() {
      var _this9 = this;

      this.registerComponent('custom-link-to', { ComponentClass: _emberGlimmerTestsUtilsHelpers.LinkComponent.extend() });
      this.registerTemplate('application', '{{custom-link-to title \'index\'}}');
      this.registerController('application', _emberRuntime.Controller.extend({
        title: 'Hello'
      }));

      return this.visit('/').then(function () {
        _this9.assertText('Hello');
      });
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.ApplicationTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Link-to component with query-params', (function (_ApplicationTest2) {
    babelHelpers.inherits(_class2, _ApplicationTest2);

    function _class2() {
      _ApplicationTest2.apply(this, arguments);

      this.registerController('index', _emberRuntime.Controller.extend({
        queryParams: ['foo'],
        foo: '123',
        bar: 'yes'
      }));
    }

    _class2.prototype['@test populates href with fully supplied query param values'] = function testPopulatesHrefWithFullySuppliedQueryParamValues(assert) {
      var _this10 = this;

      this.registerTemplate('index', '{{#link-to \'index\' (query-params foo=\'456\' bar=\'NAW\')}}Index{{/link-to}}');

      return this.visit('/').then(function () {
        _this10.assertComponentElement(_this10.firstChild.firstElementChild, {
          tagName: 'a',
          attrs: { href: '/?bar=NAW&foo=456' },
          content: 'Index'
        });
      });
    };

    _class2.prototype['@test populates href with partially supplied query param values, but omits if value is default value'] = function testPopulatesHrefWithPartiallySuppliedQueryParamValuesButOmitsIfValueIsDefaultValue() {
      var _this11 = this;

      this.registerTemplate('index', '{{#link-to \'index\' (query-params foo=\'123\')}}Index{{/link-to}}');

      return this.visit('/').then(function () {
        _this11.assertComponentElement(_this11.firstChild.firstElementChild, {
          tagName: 'a',
          attrs: { href: '/', class: _emberGlimmerTestsUtilsTestHelpers.classes('ember-view active') },
          content: 'Index'
        });
      });
    };

    return _class2;
  })(_emberGlimmerTestsUtilsTestCase.ApplicationTest));
});
enifed('ember-glimmer/tests/integration/components/local-lookup-test', ['exports', 'ember-glimmer/tests/utils/test-case', 'ember-glimmer/tests/utils/helpers'], function (exports, _emberGlimmerTestsUtilsTestCase, _emberGlimmerTestsUtilsHelpers) {
  'use strict';

  function buildResolver() {
    var resolver = {
      resolve: function () {},
      expandLocalLookup: function (fullName, sourceFullName) {
        var _sourceFullName$split = sourceFullName.split(':');

        var sourceType = _sourceFullName$split[0];
        var sourceName = _sourceFullName$split[1];

        var _fullName$split = fullName.split(':');

        var type = _fullName$split[0];
        var name = _fullName$split[1];

        if (type !== 'template' && sourceType === 'template' && sourceName.slice(0, 11) === 'components/') {
          sourceName = sourceName.slice(11);
        }

        if (type === 'template' && sourceType === 'template' && name.slice(0, 11) === 'components/') {
          name = name.slice(11);
        }

        var result = type + ':' + sourceName + '/' + name;

        return result;
      }
    };

    return resolver;
  }

  _emberGlimmerTestsUtilsTestCase.moduleFor('Components test: local lookup', (function (_RenderingTest) {
    babelHelpers.inherits(_class, _RenderingTest);

    function _class() {
      _RenderingTest.apply(this, arguments);
    }

    _class.prototype.getResolver = function getResolver() {
      return buildResolver();
    };

    _class.prototype['@test it can lookup a local template'] = function testItCanLookupALocalTemplate() {
      var _this = this;

      this.registerComponent('x-outer/x-inner', { template: 'Nested template says: {{yield}}' });
      this.registerComponent('x-outer', { template: '{{#x-inner}}Hi!{{/x-inner}}' });

      this.render('{{x-outer}}');

      this.assertText('Nested template says: Hi!', 'Initial render works');

      this.runTask(function () {
        return _this.rerender();
      });

      this.assertText('Nested template says: Hi!', 'Re-render works');
    };

    _class.prototype['@test tagless blockless component can lookup local template'] = function testTaglessBlocklessComponentCanLookupLocalTemplate() {
      var _this2 = this;

      this.registerComponent('x-outer/x-inner', { template: 'Nested template says: {{yield}}' });
      this.registerTemplate('components/x-outer', '{{#x-inner}}Hi!{{/x-inner}}');
      this.registerComponent('x-outer', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({ tagName: '' })
      });

      this.render('{{x-outer}}');

      this.assertText('Nested template says: Hi!', 'Re-render works');

      this.runTask(function () {
        return _this2.rerender();
      });

      this.assertText('Nested template says: Hi!', 'Re-render works');
    };

    _class.prototype['@test it can lookup a local component template'] = function testItCanLookupALocalComponentTemplate() {
      var _this3 = this;

      this.registerTemplate('components/x-outer/x-inner', 'Nested template says: {{yield}}');
      this.registerTemplate('components/x-outer', '{{#x-inner}}Hi!{{/x-inner}}');

      this.render('{{x-outer}}');

      this.assertText('Nested template says: Hi!', 'Initial render works');

      this.runTask(function () {
        return _this3.rerender();
      });

      this.assertText('Nested template says: Hi!', 'Re-render works');
    };

    _class.prototype['@test it can local lookup a dynamic component'] = function testItCanLocalLookupADynamicComponent() {
      var _this4 = this;

      this.registerComponent('foo-bar', { template: 'yall finished {{component child}}' });
      this.registerComponent('foo-bar/biz-baz', { template: 'or yall done?' });

      this.render('{{foo-bar child=child}}', { child: 'biz-baz' });

      this.assertText('yall finished or yall done?');

      this.runTask(function () {
        return _this4.rerender();
      });

      this.assertText('yall finished or yall done?');
    };

    _class.prototype['@test it can local lookup a dynamic component from a dynamic component'] = function testItCanLocalLookupADynamicComponentFromADynamicComponent() {
      var _this5 = this;

      this.registerComponent('foo-bar', { template: 'yall finished {{component child}}' });
      this.registerComponent('foo-bar/biz-baz', { template: 'or yall done?' });

      this.render('{{component componentName child=child}}', { componentName: 'foo-bar', child: 'biz-baz' });

      this.assertText('yall finished or yall done?');

      this.runTask(function () {
        return _this5.rerender();
      });

      this.assertText('yall finished or yall done?');
    };

    _class.prototype['@test it can local lookup a dynamic component from a passed named argument'] = function testItCanLocalLookupADynamicComponentFromAPassedNamedArgument() {
      var _this6 = this;

      this.registerComponent('parent-foo', { template: 'yall finished {{global-biz baz=(component \'local-bar\')}}' });
      this.registerComponent('global-biz', { template: 'or {{component baz}}' });
      this.registerComponent('parent-foo/local-bar', { template: 'yall done?' });

      this.render('{{parent-foo}}');

      this.assertText('yall finished or yall done?');

      this.runTask(function () {
        return _this6.rerender();
      });

      this.assertText('yall finished or yall done?');
    };

    _class.prototype['@test it can local lookup a re-wrapped dynamic component from a passed named argument'] = function testItCanLocalLookupAReWrappedDynamicComponentFromAPassedNamedArgument() {
      var _this7 = this;

      this.registerComponent('parent-foo', { template: 'yall finished {{global-x comp=(component \'local-bar\')}}' });
      this.registerComponent('global-x', { template: 'or {{global-y comp=(component comp phrase=\'done\')}}' });
      this.registerComponent('global-y', { template: '{{component comp}}?' });
      this.registerComponent('parent-foo/local-bar', { template: 'yall {{phrase}}' });

      this.render('{{parent-foo}}');

      this.assertText('yall finished or yall done?');

      this.runTask(function () {
        return _this7.rerender();
      });

      this.assertText('yall finished or yall done?');
    };

    _class.prototype['@test it can nest local lookups of dynamic components from a passed named argument'] = function testItCanNestLocalLookupsOfDynamicComponentsFromAPassedNamedArgument() {
      var _this8 = this;

      this.registerComponent('parent-foo', { template: 'yall finished {{global-x comp=(component \'local-bar\')}}' });
      this.registerComponent('global-x', { template: 'or {{global-y comp=(component comp phrase=\'done\')}}' });
      this.registerComponent('global-y', { template: '{{component comp}}{{component \'local-bar\'}}' });
      this.registerComponent('parent-foo/local-bar', { template: 'yall {{phrase}}' });
      this.registerComponent('global-y/local-bar', { template: '?' });

      this.render('{{parent-foo}}');

      this.assertText('yall finished or yall done?');

      this.runTask(function () {
        return _this8.rerender();
      });

      this.assertText('yall finished or yall done?');
    };

    _class.prototype['@test it can switch from local to global lookups of dynamic components from a passed named argument'] = function testItCanSwitchFromLocalToGlobalLookupsOfDynamicComponentsFromAPassedNamedArgument() {
      var _this9 = this;

      this.registerComponent('parent-foo', { template: 'yall finished {{global-x comp=(component bar)}}' });
      this.registerComponent('global-x', { template: 'or yall {{component comp}}' });
      this.registerComponent('parent-foo/local-bar', { template: 'done?' });
      this.registerComponent('global-bar', { template: 'ready?' });

      this.render('{{parent-foo bar=bar}}', { bar: 'local-bar' });

      this.assertText('yall finished or yall done?');

      this.runTask(function () {
        return _this9.context.set('bar', 'global-bar');
      });

      this.runTask(function () {
        return _this9.rerender();
      });

      this.assertText('yall finished or yall ready?');
    };

    _class.prototype['@test it can lookup a local helper'] = function testItCanLookupALocalHelper() {
      var _this10 = this;

      this.registerHelper('x-outer/x-helper', function () {
        return 'Who dis?';
      });
      this.registerComponent('x-outer', { template: 'Who dat? {{x-helper}}' });

      this.render('{{x-outer}}');

      this.assertText('Who dat? Who dis?', 'Initial render works');

      this.runTask(function () {
        return _this10.rerender();
      });

      this.assertText('Who dat? Who dis?', 'Re-render works');
    };

    _class.prototype['@test it overrides global helper lookup'] = function testItOverridesGlobalHelperLookup() {
      var _this11 = this;

      this.registerHelper('x-outer/x-helper', function () {
        return 'Who dis?';
      });

      this.registerHelper('x-helper', function () {
        return 'I dunno';
      });

      this.registerComponent('x-outer', { template: 'Who dat? {{x-helper}}' });

      this.render('{{x-outer}} {{x-helper}}');

      this.assertText('Who dat? Who dis? I dunno', 'Initial render works');

      this.runTask(function () {
        return _this11.rerender();
      });

      this.assertText('Who dat? Who dis? I dunno', 'Re-render works');
    };

    _class.prototype['@test lookup without match issues standard assertion (with local helper name)'] = function testLookupWithoutMatchIssuesStandardAssertionWithLocalHelperName() {
      var _this12 = this;

      this.registerComponent('x-outer', { template: '{{#x-inner}}Hi!{{/x-inner}}' });

      expectAssertion(function () {
        _this12.render('{{x-outer}}');
      }, /A component or helper named "x-inner" could not be found/);
    };

    _class.prototype['@test overrides global lookup'] = function testOverridesGlobalLookup() {
      var _this13 = this;

      this.registerComponent('x-outer', { template: '{{#x-inner}}Hi!{{/x-inner}}' });
      this.registerComponent('x-outer/x-inner', { template: 'Nested template says (from local): {{yield}}' });
      this.registerComponent('x-inner', { template: 'Nested template says (from global): {{yield}}' });

      this.render('{{#x-inner}}Hi!{{/x-inner}} {{x-outer}} {{#x-outer/x-inner}}Hi!{{/x-outer/x-inner}}');

      this.assertText('Nested template says (from global): Hi! Nested template says (from local): Hi! Nested template says (from local): Hi!');

      this.runTask(function () {
        return _this13.rerender();
      });

      this.assertText('Nested template says (from global): Hi! Nested template says (from local): Hi! Nested template says (from local): Hi!');
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
});
enifed("ember-glimmer/tests/integration/components/render-to-element-test", ["exports"], function (exports) {
  "use strict";
});
enifed('ember-glimmer/tests/integration/components/target-action-test', ['exports', 'ember-utils', 'ember-glimmer/tests/utils/test-case', 'ember-glimmer/tests/utils/abstract-test-case', 'ember-metal', 'ember-glimmer/tests/utils/helpers', 'ember-runtime', 'ember-routing'], function (exports, _emberUtils, _emberGlimmerTestsUtilsTestCase, _emberGlimmerTestsUtilsAbstractTestCase, _emberMetal, _emberGlimmerTestsUtilsHelpers, _emberRuntime, _emberRouting) {
  'use strict';

  var _templateObject = babelHelpers.taggedTemplateLiteralLoose(['\n        {{#component-a}}\n          {{component-b bar="derp"}}\n        {{/component-a}}\n      '], ['\n        {{#component-a}}\n          {{component-b bar="derp"}}\n        {{/component-a}}\n      ']);

  _emberGlimmerTestsUtilsTestCase.moduleFor('Components test: sendAction', (function (_RenderingTest) {
babelHelpers.inherits(_class, _RenderingTest);

    function _class() {
      _RenderingTest.call(this);
      this.actionCounts = {};
      this.sendCount = 0;
      this.actionArguments = null;

      var self = this;

      this.registerComponent('action-delegate', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super();
            self.delegate = this;
            this.name = 'action-delegate';
          }
        })
      });
    }

    _class.prototype.renderDelegate = function renderDelegate() {
      var template = arguments.length <= 0 || arguments[0] === undefined ? '{{action-delegate}}' : arguments[0];
      var context = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      var root = this;
      context = _emberUtils.assign(context, {
        send: function (actionName) {
          root.sendCount++;
          root.actionCounts[actionName] = root.actionCounts[actionName] || 0;
          root.actionCounts[actionName]++;

          for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
            args[_key - 1] = arguments[_key];
          }

          root.actionArguments = args;
        }
      });
      this.render(template, context);
    };

    _class.prototype.assertSendCount = function assertSendCount(count) {
      this.assert.equal(this.sendCount, count, 'Send was called ' + count + ' time(s)');
    };

    _class.prototype.assertNamedSendCount = function assertNamedSendCount(actionName, count) {
      this.assert.equal(this.actionCounts[actionName], count, 'An action named \'' + actionName + '\' was sent ' + count + ' times');
    };

    _class.prototype.assertSentWithArgs = function assertSentWithArgs(expected) {
      var message = arguments.length <= 1 || arguments[1] === undefined ? 'arguments were sent with the action' : arguments[1];

      this.assert.deepEqual(this.actionArguments, expected, message);
    };

    _class.prototype['@test Calling sendAction on a component without an action defined does nothing'] = function testCallingSendActionOnAComponentWithoutAnActionDefinedDoesNothing() {
      var _this = this;

      this.renderDelegate();

      this.runTask(function () {
        return _this.delegate.sendAction();
      });

      this.assertSendCount(0);
    };

    _class.prototype['@test Calling sendAction on a component with an action defined calls send on the controller'] = function testCallingSendActionOnAComponentWithAnActionDefinedCallsSendOnTheController() {
      var _this2 = this;

      this.renderDelegate();

      this.runTask(function () {
        _emberMetal.set(_this2.delegate, 'action', 'addItem');
        _this2.delegate.sendAction();
      });

      this.assertSendCount(1);
      this.assertNamedSendCount('addItem', 1);
    };

    _class.prototype['@test Calling sendAction on a component with a function calls the function'] = function testCallingSendActionOnAComponentWithAFunctionCallsTheFunction() {
      var _this3 = this;

      this.assert.expect(1);

      this.renderDelegate();

      this.runTask(function () {
        _emberMetal.set(_this3.delegate, 'action', function () {
          return _this3.assert.ok(true, 'function is called');
        });
        _this3.delegate.sendAction();
      });
    };

    _class.prototype['@test Calling sendAction on a component with a function calls the function with arguments'] = function testCallingSendActionOnAComponentWithAFunctionCallsTheFunctionWithArguments() {
      var _this4 = this;

      this.assert.expect(1);
      var argument = {};

      this.renderDelegate();

      this.runTask(function () {
        _emberMetal.set(_this4.delegate, 'action', function (actualArgument) {
          _this4.assert.deepEqual(argument, actualArgument, 'argument is passed');
        });
        _this4.delegate.sendAction('action', argument);
      });
    };

    // TODO consolidate these next 2 tests

    _class.prototype['@test Calling sendAction on a component with a reference attr calls the function with arguments'] = function testCallingSendActionOnAComponentWithAReferenceAttrCallsTheFunctionWithArguments() {
      var _this5 = this;

      this.renderDelegate('{{action-delegate playing=playing}}', {
        playing: null
      });

      this.runTask(function () {
        return _this5.delegate.sendAction();
      });

      this.assertSendCount(0);

      this.runTask(function () {
        _emberMetal.set(_this5.context, 'playing', 'didStartPlaying');
      });

      this.runTask(function () {
        _this5.delegate.sendAction('playing');
      });

      this.assertSendCount(1);
      this.assertNamedSendCount('didStartPlaying', 1);
    };

    _class.prototype['@test Calling sendAction on a component with a {{mut}} attr calls the function with arguments'] = function testCallingSendActionOnAComponentWithAMutAttrCallsTheFunctionWithArguments() {
      var _this6 = this;

      this.renderDelegate('{{action-delegate playing=(mut playing)}}', {
        playing: null
      });

      this.runTask(function () {
        return _this6.delegate.sendAction('playing');
      });

      this.assertSendCount(0);

      this.runTask(function () {
        return _this6.delegate.attrs.playing.update('didStartPlaying');
      });
      this.runTask(function () {
        return _this6.delegate.sendAction('playing');
      });

      this.assertSendCount(1);
      this.assertNamedSendCount('didStartPlaying', 1);
    };

    _class.prototype['@test Calling sendAction with a named action uses the component\'s property as the action name'] = function testCallingSendActionWithANamedActionUsesTheComponentSPropertyAsTheActionName() {
      var _this7 = this;

      this.renderDelegate();

      var component = this.delegate;

      this.runTask(function () {
        _emberMetal.set(_this7.delegate, 'playing', 'didStartPlaying');
        component.sendAction('playing');
      });

      this.assertSendCount(1);
      this.assertNamedSendCount('didStartPlaying', 1);

      this.runTask(function () {
        return component.sendAction('playing');
      });

      this.assertSendCount(2);
      this.assertNamedSendCount('didStartPlaying', 2);

      this.runTask(function () {
        _emberMetal.set(component, 'action', 'didDoSomeBusiness');
        component.sendAction();
      });

      this.assertSendCount(3);
      this.assertNamedSendCount('didDoSomeBusiness', 1);
    };

    _class.prototype['@test Calling sendAction when the action name is not a string raises an exception'] = function testCallingSendActionWhenTheActionNameIsNotAStringRaisesAnException() {
      var _this8 = this;

      this.renderDelegate();

      this.runTask(function () {
        _emberMetal.set(_this8.delegate, 'action', {});
        _emberMetal.set(_this8.delegate, 'playing', {});
      });

      expectAssertion(function () {
        return _this8.delegate.sendAction();
      });
      expectAssertion(function () {
        return _this8.delegate.sendAction('playing');
      });
    };

    _class.prototype['@test Calling sendAction on a component with contexts'] = function testCallingSendActionOnAComponentWithContexts() {
      var _this9 = this;

      this.renderDelegate();

      var testContext = { song: 'She Broke My Ember' };
      var firstContext = { song: 'She Broke My Ember' };
      var secondContext = { song: 'My Achey Breaky Ember' };

      this.runTask(function () {
        _emberMetal.set(_this9.delegate, 'playing', 'didStartPlaying');
        _this9.delegate.sendAction('playing', testContext);
      });

      this.assertSendCount(1);
      this.assertNamedSendCount('didStartPlaying', 1);
      this.assertSentWithArgs([testContext], 'context was sent with the action');

      this.runTask(function () {
        _this9.delegate.sendAction('playing', firstContext, secondContext);
      });

      this.assertSendCount(2);
      this.assertNamedSendCount('didStartPlaying', 2);
      this.assertSentWithArgs([firstContext, secondContext], 'multiple contexts were sent to the action');
    };

    _class.prototype['@test calling sendAction on a component within a block sends to the outer scope GH#14216'] = function testCallingSendActionOnAComponentWithinABlockSendsToTheOuterScopeGH14216(assert) {
      var testContext = this;
      // overrides default action-delegate so actions can be added
      this.registerComponent('action-delegate', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super();
            testContext.delegate = this;
            this.name = 'action-delegate';
          },

          actions: {
            derp: function (arg1) {
              assert.ok(true, 'action called on action-delgate');
              assert.equal(arg1, 'something special', 'argument passed through properly');
            }
          }
        }),

        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject)
      });

      this.registerComponent('component-a', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            this.name = 'component-a';
          },
          actions: {
            derp: function () {
              assert.ok(false, 'no! bad scoping!');
            }
          }
        })
      });

      var innerChild = undefined;
      this.registerComponent('component-b', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            innerChild = this;
            this.name = 'component-b';
          }
        })
      });

      this.renderDelegate();

      this.runTask(function () {
        return innerChild.sendAction('bar', 'something special');
      });
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Components test: sendAction to a controller', (function (_ApplicationTest) {
babelHelpers.inherits(_class2, _ApplicationTest);

    function _class2() {
      _ApplicationTest.apply(this, arguments);
    }

    _class2.prototype['@test sendAction should trigger an action on the parent component\'s controller if it exists'] = function testSendActionShouldTriggerAnActionOnTheParentComponentSControllerIfItExists(assert) {
      var _this10 = this;

      assert.expect(15);

      var component = undefined;

      this.router.map(function () {
        this.route('a');
        this.route('b');
        this.route('c', function () {
          this.route('d');
          this.route('e');
        });
      });

      this.registerComponent('foo-bar', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            component = this;
          }
        }),
        template: '{{val}}'
      });

      this.registerController('a', _emberRuntime.Controller.extend({
        send: function (actionName, actionContext) {
          assert.equal(actionName, 'poke', 'send() method was invoked from a top level controller');
          assert.equal(actionContext, 'top', 'action arguments were passed into the top level controller');
        }
      }));
      this.registerTemplate('a', '{{foo-bar val="a" poke="poke"}}');

      this.registerRoute('b', _emberRouting.Route.extend({
        actions: {
          poke: function (actionContext) {
            assert.ok(true, 'Unhandled action sent to route');
            assert.equal(actionContext, 'top no controller');
          }
        }
      }));
      this.registerTemplate('b', '{{foo-bar val="b" poke="poke"}}');

      this.registerRoute('c', _emberRouting.Route.extend({
        actions: {
          poke: function (actionContext) {
            assert.ok(true, 'Unhandled action sent to route');
            assert.equal(actionContext, 'top with nested no controller');
          }
        }
      }));
      this.registerTemplate('c', '{{foo-bar val="c" poke="poke"}}{{outlet}}');

      this.registerRoute('c.d', _emberRouting.Route.extend({}));

      this.registerController('c.d', _emberRuntime.Controller.extend({
        send: function (actionName, actionContext) {
          assert.equal(actionName, 'poke', 'send() method was invoked from a nested controller');
          assert.equal(actionContext, 'nested', 'action arguments were passed into the nested controller');
        }
      }));
      this.registerTemplate('c.d', '{{foo-bar val=".d" poke="poke"}}');

      this.registerRoute('c.e', _emberRouting.Route.extend({
        actions: {
          poke: function (actionContext) {
            assert.ok(true, 'Unhandled action sent to route');
            assert.equal(actionContext, 'nested no controller');
          }
        }
      }));
      this.registerTemplate('c.e', '{{foo-bar val=".e" poke="poke"}}');

      return this.visit('/a').then(function () {
        return component.sendAction('poke', 'top');
      }).then(function () {
        _this10.assertText('a');
        return _this10.visit('/b');
      }).then(function () {
        return component.sendAction('poke', 'top no controller');
      }).then(function () {
        _this10.assertText('b');
        return _this10.visit('/c');
      }).then(function () {
        return component.sendAction('poke', 'top with nested no controller');
      }).then(function () {
        _this10.assertText('c');
        return _this10.visit('/c/d');
      }).then(function () {
        return component.sendAction('poke', 'nested');
      }).then(function () {
        _this10.assertText('c.d');
        return _this10.visit('/c/e');
      }).then(function () {
        return component.sendAction('poke', 'nested no controller');
      }).then(function () {
        return _this10.assertText('c.e');
      });
    };

    _class2.prototype['@test sendAction should not trigger an action in an outlet\'s controller if a parent component handles it'] = function testSendActionShouldNotTriggerAnActionInAnOutletSControllerIfAParentComponentHandlesIt(assert) {
      assert.expect(1);

      var component = undefined;

      this.registerComponent('x-parent', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          actions: {
            poke: function () {
              assert.ok(true, 'parent component handled the aciton');
            }
          }
        }),
        template: '{{x-child poke="poke"}}'
      });

      this.registerComponent('x-child', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            component = this;
          }
        })
      });

      this.registerTemplate('application', '{{x-parent}}');
      this.registerController('application', _emberRuntime.Controller.extend({
        send: function (actionName) {
          throw new Error('controller action should not be called');
        }
      }));

      return this.visit('/').then(function () {
        return component.sendAction('poke');
      });
    };

    return _class2;
  })(_emberGlimmerTestsUtilsTestCase.ApplicationTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Components test: sendAction of a closure action', (function (_RenderingTest2) {
babelHelpers.inherits(_class3, _RenderingTest2);

    function _class3() {
      _RenderingTest2.apply(this, arguments);
    }

    _class3.prototype['@test action should be called'] = function testActionShouldBeCalled(assert) {
      assert.expect(1);
      var component = undefined;

      this.registerComponent('inner-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            component = this;
          }
        }),
        template: 'inner'
      });

      this.registerComponent('outer-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          outerSubmit: function () {
            assert.ok(true, 'outerSubmit called');
          }
        }),
        template: '{{inner-component submitAction=(action outerSubmit)}}'
      });

      this.render('{{outer-component}}');

      this.runTask(function () {
        return component.sendAction('submitAction');
      });
    };

    _class3.prototype['@test contexts passed to sendAction are appended to the bound arguments on a closure action'] = function testContextsPassedToSendActionAreAppendedToTheBoundArgumentsOnAClosureAction() {
      var first = 'mitch';
      var second = 'martin';
      var third = 'matt';
      var fourth = 'wacky wycats';

      var innerComponent = undefined;
      var actualArgs = undefined;

      this.registerComponent('inner-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            innerComponent = this;
          }
        }),
        template: 'inner'
      });

      this.registerComponent('outer-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          third: third,
          actions: {
            outerSubmit: function () {
              actualArgs = [].concat(babelHelpers.slice.call(arguments));
            }
          }
        }),
        template: '{{inner-component innerSubmit=(action (action "outerSubmit" "' + first + '") "' + second + '" third)}}'
      });

      this.render('{{outer-component}}');

      this.runTask(function () {
        return innerComponent.sendAction('innerSubmit', fourth);
      });

      this.assert.deepEqual(actualArgs, [first, second, third, fourth], 'action has the correct args');
    };

    return _class3;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Components test: send', (function (_RenderingTest3) {
babelHelpers.inherits(_class4, _RenderingTest3);

    function _class4() {
      _RenderingTest3.apply(this, arguments);
    }

    _class4.prototype['@test sending to undefined actions triggers an error'] = function testSendingToUndefinedActionsTriggersAnError(assert) {
      assert.expect(2);

      var component = undefined;

      this.registerComponent('foo-bar', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super();
            component = this;
          },
          actions: {
            foo: function (message) {
              assert.equal('bar', message);
            }
          }
        })
      });

      this.render('{{foo-bar}}');

      this.runTask(function () {
        return component.send('foo', 'bar');
      });

      expectAssertion(function () {
        return component.send('baz', 'bar');
      }, /had no action handler for: baz/);
    };

    _class4.prototype['@test `send` will call send from a target if it is defined'] = function testSendWillCallSendFromATargetIfItIsDefined() {
      var _this11 = this;

      var component = undefined;
      var target = {
        send: function (message, payload) {
          _this11.assert.equal('foo', message);
          _this11.assert.equal('baz', payload);
        }
      };

      this.registerComponent('foo-bar', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super();
            component = this;
          },
          target: target
        })
      });

      this.render('{{foo-bar}}');

      this.runTask(function () {
        return component.send('foo', 'baz');
      });
    };

    _class4.prototype['@test a handled action can be bubbled to the target for continued processing'] = function testAHandledActionCanBeBubbledToTheTargetForContinuedProcessing() {
      var _this12 = this;

      this.assert.expect(2);

      var component = undefined;

      this.registerComponent('foo-bar', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            component = this;
          },
          actions: {
            poke: function () {
              _this12.assert.ok(true, 'component action called');
              return true;
            }
          },
          target: _emberRuntime.Controller.extend({
            actions: {
              poke: function () {
                _this12.assert.ok(true, 'action bubbled to controller');
              }
            }
          }).create()
        })
      });

      this.render('{{foo-bar poke="poke"}}');

      this.runTask(function () {
        return component.send('poke');
      });
    };

    _class4.prototype['@test action can be handled by a superclass\' actions object'] = function testActionCanBeHandledByASuperclassActionsObject(assert) {
      this.assert.expect(4);

      var component = undefined;

      var SuperComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        actions: {
          foo: function () {
            assert.ok(true, 'foo');
          },
          bar: function (msg) {
            assert.equal(msg, 'HELLO');
          }
        }
      });

      var BarViewMixin = _emberMetal.Mixin.create({
        actions: {
          bar: function (msg) {
            assert.equal(msg, 'HELLO');
            this._super(msg);
          }
        }
      });

      this.registerComponent('x-index', {
        ComponentClass: SuperComponent.extend(BarViewMixin, {
          init: function () {
            this._super.apply(this, arguments);
            component = this;
          },
          actions: {
            baz: function () {
              assert.ok(true, 'baz');
            }
          }
        })
      });

      this.render('{{x-index}}');

      this.runTask(function () {
        component.send('foo');
        component.send('bar', 'HELLO');
        component.send('baz');
      });
    };

    _class4.prototype['@test actions cannot be provided at create time'] = function testActionsCannotBeProvidedAtCreateTime(assert) {
      expectAssertion(function () {
        return _emberGlimmerTestsUtilsHelpers.Component.create({
          actions: {
            foo: function () {
              assert.ok(true, 'foo');
            }
          }
        });
      });
      // but should be OK on an object that doesn't mix in Ember.ActionHandler
      _emberRuntime.Object.create({
        actions: ['foo']
      });
    };

    return _class4;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
});
enifed('ember-glimmer/tests/integration/components/utils-test', ['exports', 'ember-runtime', 'ember-views', 'ember-glimmer/tests/utils/test-case', 'ember-glimmer/tests/utils/helpers'], function (exports, _emberRuntime, _emberViews, _emberGlimmerTestsUtilsTestCase, _emberGlimmerTestsUtilsHelpers) {
  'use strict';

  _emberGlimmerTestsUtilsTestCase.moduleFor('View tree tests', (function (_ApplicationTest) {
    babelHelpers.inherits(_class, _ApplicationTest);

    function _class() {
      _ApplicationTest.call(this);

      this.registerComponent('x-tagless', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          tagName: ''
        }),

        template: '<div id="{{id}}">[{{id}}] {{#if isShowing}}{{yield}}{{/if}}</div>'
      });

      this.registerComponent('x-toggle', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          isExpanded: true,

          click: function () {
            this.toggleProperty('isExpanded');
            return false;
          }
        }),

        template: '[{{id}}] {{#if isExpanded}}{{yield}}{{/if}}'
      });

      var ToggleController = _emberRuntime.Controller.extend({
        isExpanded: true,

        actions: {
          toggle: function () {
            this.toggleProperty('isExpanded');
          }
        }
      });

      this.registerController('application', ToggleController);

      this.registerTemplate('application', '\n      {{x-tagless id="root-1"}}\n\n      {{#x-toggle id="root-2"}}\n        {{x-toggle id="inner-1"}}\n\n        {{#x-toggle id="inner-2"}}\n          {{x-toggle id="inner-3"}}\n        {{/x-toggle}}\n      {{/x-toggle}}\n\n      <button id="toggle-application" {{action "toggle"}}>Toggle</button>\n\n      {{#if isExpanded}}\n        {{x-toggle id="root-3"}}\n      {{/if}}\n\n      {{outlet}}\n    ');

      this.registerController('index', ToggleController.extend({
        isExpanded: false
      }));

      this.registerTemplate('index', '\n      {{x-tagless id="root-4"}}\n\n      {{#x-toggle id="root-5" isExpanded=false}}\n        {{x-toggle id="inner-4"}}\n\n        {{#x-toggle id="inner-5"}}\n          {{x-toggle id="inner-6"}}\n        {{/x-toggle}}\n      {{/x-toggle}}\n\n      <button id="toggle-index" {{action "toggle"}}>Toggle</button>\n\n      {{#if isExpanded}}\n        {{x-toggle id="root-6"}}\n      {{/if}}\n    ');

      this.registerTemplate('zomg', '\n      {{x-tagless id="root-7"}}\n\n      {{#x-toggle id="root-8"}}\n        {{x-toggle id="inner-7"}}\n\n        {{#x-toggle id="inner-8"}}\n          {{x-toggle id="inner-9"}}\n        {{/x-toggle}}\n      {{/x-toggle}}\n\n      {{#x-toggle id="root-9"}}\n        {{outlet}}\n      {{/x-toggle}}\n    ');

      this.registerTemplate('zomg.lol', '\n      {{x-toggle id="inner-10"}}\n    ');

      this.router.map(function () {
        this.route('zomg', function () {
          this.route('lol');
        });
      });
    }

    _class.prototype['@test getRootViews'] = function testGetRootViews(assert) {
      var _this = this;

      return this.visit('/').then(function () {
        _this.assertRootViews(['root-1', 'root-2', 'root-3', 'root-4', 'root-5']);

        _this.runTask(function () {
          return _emberViews.jQuery('#toggle-application').click();
        });

        _this.assertRootViews(['root-1', 'root-2', 'root-4', 'root-5']);

        _this.runTask(function () {
          _emberViews.jQuery('#toggle-application').click();
          _emberViews.jQuery('#toggle-index').click();
        });

        _this.assertRootViews(['root-1', 'root-2', 'root-3', 'root-4', 'root-5', 'root-6']);

        return _this.visit('/zomg/lol');
      }).then(function () {
        _this.assertRootViews(['root-1', 'root-2', 'root-3', 'root-7', 'root-8', 'root-9']);

        return _this.visit('/');
      }).then(function () {
        _this.assertRootViews(['root-1', 'root-2', 'root-3', 'root-4', 'root-5', 'root-6']);
      });
    };

    _class.prototype.assertRootViews = function assertRootViews(ids) {
      var owner = this.applicationInstance;

      var actual = _emberViews.getRootViews(owner).map(function (view) {
        return view.id;
      }).sort();
      var expected = ids.sort();

      this.assert.deepEqual(actual, expected, 'root views');
    };

    _class.prototype['@test getChildViews'] = function testGetChildViews(assert) {
      var _this2 = this;

      return this.visit('/').then(function () {
        _this2.assertChildViews('root-2', ['inner-1', 'inner-2']);
        _this2.assertChildViews('root-5', []);
        _this2.assertChildViews('inner-2', ['inner-3']);

        _this2.runTask(function () {
          return _emberViews.jQuery('#root-2').click();
        });

        _this2.assertChildViews('root-2', []);

        _this2.runTask(function () {
          return _emberViews.jQuery('#root-5').click();
        });

        _this2.assertChildViews('root-5', ['inner-4', 'inner-5']);
        _this2.assertChildViews('inner-5', ['inner-6']);

        return _this2.visit('/zomg');
      }).then(function () {
        _this2.assertChildViews('root-2', []);
        _this2.assertChildViews('root-8', ['inner-7', 'inner-8']);
        _this2.assertChildViews('inner-8', ['inner-9']);
        _this2.assertChildViews('root-9', []);

        _this2.runTask(function () {
          return _emberViews.jQuery('#root-8').click();
        });

        _this2.assertChildViews('root-8', []);

        return _this2.visit('/zomg/lol');
      }).then(function () {
        _this2.assertChildViews('root-2', []);
        _this2.assertChildViews('root-8', []);
        _this2.assertChildViews('root-9', ['inner-10']);

        return _this2.visit('/');
      }).then(function () {
        _this2.assertChildViews('root-2', []);
        _this2.assertChildViews('root-5', []);

        _this2.runTask(function () {
          return _emberViews.jQuery('#root-2').click();
        });
        _this2.runTask(function () {
          return _emberViews.jQuery('#inner-2').click();
        });

        _this2.assertChildViews('root-2', ['inner-1', 'inner-2']);
        _this2.assertChildViews('inner-2', []);
      });
    };

    _class.prototype['@test getChildViews does not return duplicates'] = function testGetChildViewsDoesNotReturnDuplicates(assert) {
      var _this3 = this;

      return this.visit('/').then(function () {
        _this3.assertChildViews('root-2', ['inner-1', 'inner-2']);

        _this3.runTask(function () {
          return _emberViews.jQuery('#root-2').click();
        });
        _this3.runTask(function () {
          return _emberViews.jQuery('#root-2').click();
        });
        _this3.runTask(function () {
          return _emberViews.jQuery('#root-2').click();
        });
        _this3.runTask(function () {
          return _emberViews.jQuery('#root-2').click();
        });
        _this3.runTask(function () {
          return _emberViews.jQuery('#root-2').click();
        });
        _this3.runTask(function () {
          return _emberViews.jQuery('#root-2').click();
        });
        _this3.runTask(function () {
          return _emberViews.jQuery('#root-2').click();
        });
        _this3.runTask(function () {
          return _emberViews.jQuery('#root-2').click();
        });
        _this3.runTask(function () {
          return _emberViews.jQuery('#root-2').click();
        });
        _this3.runTask(function () {
          return _emberViews.jQuery('#root-2').click();
        });

        _this3.assertChildViews('root-2', ['inner-1', 'inner-2']);
      });
    };

    _class.prototype.assertChildViews = function assertChildViews(parentId, childIds) {
      var parentView = this.viewFor(parentId);
      var childViews = _emberViews.getChildViews(parentView);

      var actual = childViews.map(function (view) {
        return view.id;
      }).sort();
      var expected = childIds.sort();

      this.assert.deepEqual(actual, expected, 'child views for #' + parentId);
    };

    _class.prototype.viewFor = function viewFor(id) {
      var owner = this.applicationInstance;
      var registry = owner.lookup('-view-registry:main');
      return registry[id];
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.ApplicationTest));

  var hasGetClientRects = undefined,
      hasGetBoundingClientRect = undefined;
  var ClientRectListCtor = undefined,
      ClientRectCtor = undefined;

  (function () {
    if (document.createRange) {
      var range = document.createRange();

      if (range.getClientRects) {
        var clientRectsList = range.getClientRects();
        hasGetClientRects = true;
        ClientRectListCtor = clientRectsList && clientRectsList.constructor;
      }

      if (range.getBoundingClientRect) {
        var clientRect = range.getBoundingClientRect();
        hasGetBoundingClientRect = true;
        ClientRectCtor = clientRect && clientRect.constructor;
      }
    }
  })();

  _emberGlimmerTestsUtilsTestCase.moduleFor('Bounds tests', (function (_RenderingTest) {
    babelHelpers.inherits(_class2, _RenderingTest);

    function _class2() {
      _RenderingTest.apply(this, arguments);
    }

    _class2.prototype['@test getViewBounds on a regular component'] = function testGetViewBoundsOnARegularComponent(assert) {
      var component = undefined;
      this.registerComponent('hi-mom', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            component = this;
          }
        }),
        template: '<p>Hi, mom!</p>'
      });

      this.render('{{hi-mom}}');

      var _getViewBounds = _emberViews.getViewBounds(component);

      var parentElement = _getViewBounds.parentElement;
      var firstNode = _getViewBounds.firstNode;
      var lastNode = _getViewBounds.lastNode;

      assert.equal(parentElement, this.element, 'a regular component should have the right parentElement');
      assert.equal(firstNode, component.element, 'a regular component should have a single node that is its element');
      assert.equal(lastNode, component.element, 'a regular component should have a single node that is its element');
    };

    _class2.prototype['@test getViewBounds on a tagless component'] = function testGetViewBoundsOnATaglessComponent(assert) {
      var component = undefined;
      this.registerComponent('hi-mom', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          tagName: '',
          init: function () {
            this._super.apply(this, arguments);
            component = this;
          }
        }),
        template: '<span id="start-node">Hi,</span> <em id="before-end-node">mom</em>!'
      });

      this.render('{{hi-mom}}');

      var _getViewBounds2 = _emberViews.getViewBounds(component);

      var parentElement = _getViewBounds2.parentElement;
      var firstNode = _getViewBounds2.firstNode;
      var lastNode = _getViewBounds2.lastNode;

      assert.equal(parentElement, this.element, 'a tagless component should have the right parentElement');
      assert.equal(firstNode, this.$('#start-node')[0], 'a tagless component should have a range enclosing all of its nodes');
      assert.equal(lastNode, this.$('#before-end-node')[0].nextSibling, 'a tagless component should have a range enclosing all of its nodes');
    };

    _class2.prototype['@test getViewClientRects'] = function testGetViewClientRects(assert) {
      if (!hasGetClientRects || !ClientRectListCtor) {
        assert.ok(true, 'The test environment does not support the DOM API required to run this test.');
        return;
      }

      var component = undefined;
      this.registerComponent('hi-mom', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            component = this;
          }
        }),
        template: '<p>Hi, mom!</p>'
      });

      this.render('{{hi-mom}}');

      assert.ok(_emberViews.getViewClientRects(component) instanceof ClientRectListCtor);
    };

    _class2.prototype['@test getViewBoundingClientRect'] = function testGetViewBoundingClientRect(assert) {
      if (!hasGetBoundingClientRect || !ClientRectCtor) {
        assert.ok(true, 'The test environment does not support the DOM API required to run this test.');
        return;
      }

      var component = undefined;
      this.registerComponent('hi-mom', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super.apply(this, arguments);
            component = this;
          }
        }),
        template: '<p>Hi, mom!</p>'
      });

      this.render('{{hi-mom}}');

      assert.ok(_emberViews.getViewBoundingClientRect(component) instanceof ClientRectCtor);
    };

    return _class2;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
});
enifed('ember-glimmer/tests/integration/components/web-component-fallback-test', ['exports', 'ember-glimmer/tests/utils/test-case', 'ember-metal'], function (exports, _emberGlimmerTestsUtilsTestCase, _emberMetal) {
  'use strict';

  _emberGlimmerTestsUtilsTestCase.moduleFor('Components test: web component fallback', (function (_RenderingTest) {
    babelHelpers.inherits(_class, _RenderingTest);

    function _class() {
      _RenderingTest.apply(this, arguments);
    }

    _class.prototype['@test custom elements are rendered'] = function testCustomElementsAreRendered() {
      var template = '<foo-bar some-attr="123">hello</foo-bar>';

      this.render(template);

      this.assertHTML(template);

      this.assertStableRerender();
    };

    _class.prototype['@test custom elements can have bound attributes'] = function testCustomElementsCanHaveBoundAttributes() {
      var _this = this;

      var template = '<foo-bar some-attr="{{name}}">hello</foo-bar>';

      this.render(template, { name: 'Robert' });

      this.assertHTML('<foo-bar some-attr="Robert">hello</foo-bar>');

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(_this.context, 'name', 'Kris');
      });

      this.assertHTML('<foo-bar some-attr="Kris">hello</foo-bar>');

      this.runTask(function () {
        return _emberMetal.set(_this.context, 'name', 'Robert');
      });

      this.assertHTML('<foo-bar some-attr="Robert">hello</foo-bar>');
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
});
enifed('ember-glimmer/tests/integration/components/will-destroy-element-hook-test', ['exports', 'ember-metal', 'ember-glimmer/tests/utils/helpers', 'ember-glimmer/tests/utils/test-case'], function (exports, _emberMetal, _emberGlimmerTestsUtilsHelpers, _emberGlimmerTestsUtilsTestCase) {
  'use strict';

  _emberGlimmerTestsUtilsTestCase.moduleFor('Component willDestroyElement hook', (function (_RenderingTest) {
    babelHelpers.inherits(_class, _RenderingTest);

    function _class() {
      _RenderingTest.apply(this, arguments);
    }

    _class.prototype['@test it calls willDestroyElement when removed by if'] = function testItCallsWillDestroyElementWhenRemovedByIf(assert) {
      var _this = this;

      var didInsertElementCount = 0;
      var willDestroyElementCount = 0;
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        didInsertElement: function () {
          didInsertElementCount++;
          assert.notEqual(this.element.parentNode, null, 'precond component is in DOM');
        },
        willDestroyElement: function () {
          willDestroyElementCount++;
          assert.notEqual(this.element.parentNode, null, 'has not been removed from DOM yet');
        }
      });

      this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });

      this.render('{{#if switch}}{{foo-bar}}{{/if}}', { switch: true });

      assert.equal(didInsertElementCount, 1, 'didInsertElement was called once');

      this.assertComponentElement(this.firstChild, { content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this.context, 'switch', false);
      });

      assert.equal(willDestroyElementCount, 1, 'willDestroyElement was called once');

      this.assertText('');
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
});
enifed('ember-glimmer/tests/integration/content-test', ['exports', 'ember-glimmer/tests/utils/test-case', 'ember-glimmer/tests/utils/abstract-test-case', 'ember-metal', 'ember-runtime', 'ember-glimmer/tests/utils/test-helpers', 'ember-views', 'ember-glimmer/tests/utils/helpers'], function (exports, _emberGlimmerTestsUtilsTestCase, _emberGlimmerTestsUtilsAbstractTestCase, _emberMetal, _emberRuntime, _emberGlimmerTestsUtilsTestHelpers, _emberViews, _emberGlimmerTestsUtilsHelpers) {
  /* globals EmberDev */
  'use strict';

  _emberGlimmerTestsUtilsTestCase.moduleFor('Static content tests', (function (_RenderingTest) {
    babelHelpers.inherits(_class, _RenderingTest);

    function _class() {
      _RenderingTest.apply(this, arguments);
    }

    _class.prototype['@test it can render a static text node'] = function testItCanRenderAStaticTextNode() {
      var _this = this;

      this.render('hello');
      var text1 = this.assertTextNode(this.firstChild, 'hello');

      this.runTask(function () {
        return _this.rerender();
      });

      var text2 = this.assertTextNode(this.firstChild, 'hello');

      this.assertSameNode(text1, text2);
    };

    _class.prototype['@test it can render a static element'] = function testItCanRenderAStaticElement() {
      var _this2 = this;

      this.render('<p>hello</p>');
      var p1 = this.assertElement(this.firstChild, { tagName: 'p' });
      var text1 = this.assertTextNode(this.firstChild.firstChild, 'hello');

      this.runTask(function () {
        return _this2.rerender();
      });

      var p2 = this.assertElement(this.firstChild, { tagName: 'p' });
      var text2 = this.assertTextNode(this.firstChild.firstChild, 'hello');

      this.assertSameNode(p1, p2);
      this.assertSameNode(text1, text2);
    };

    _class.prototype['@test it can render a static template'] = function testItCanRenderAStaticTemplate() {
      var _this3 = this;

      var template = '\n      <div class="header">\n        <h1>Welcome to Ember.js</h1>\n      </div>\n      <div class="body">\n        <h2>Why you should use Ember.js?</h2>\n        <ol>\n          <li>It\'s great</li>\n          <li>It\'s awesome</li>\n          <li>It\'s Ember.js</li>\n        </ol>\n      </div>\n      <div class="footer">\n        Ember.js is free, open source and always will be.\n      </div>\n    ';

      this.render(template);
      this.assertHTML(template);

      this.runTask(function () {
        return _this3.rerender();
      });

      this.assertHTML(template);
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));

  var DynamicContentTest = (function (_RenderingTest2) {
    babelHelpers.inherits(DynamicContentTest, _RenderingTest2);

    function DynamicContentTest() {
      _RenderingTest2.apply(this, arguments);
    }

    /* abstract */

    DynamicContentTest.prototype.renderPath = function renderPath(path) {
      var context = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      throw new Error('Not implemented: `renderValues`');
    };

    DynamicContentTest.prototype.assertIsEmpty = function assertIsEmpty() {
      this.assert.strictEqual(this.firstChild, null);
    };

    /* abstract */

    DynamicContentTest.prototype.assertContent = function assertContent(content) {
      throw new Error('Not implemented: `assertContent`');
    };

    DynamicContentTest.prototype['@test it can render a dynamic path'] = function testItCanRenderADynamicPath() {
      var _this4 = this;

      this.renderPath('message', { message: 'hello' });

      this.assertContent('hello');

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(_this4.context, 'message', 'goodbye');
      });

      this.assertContent('goodbye');
      this.assertInvariants();

      this.runTask(function () {
        return _emberMetal.set(_this4.context, 'message', 'hello');
      });

      this.assertContent('hello');
      this.assertInvariants();
    };

    DynamicContentTest.prototype['@test resolves the string length properly'] = function testResolvesTheStringLengthProperly() {
      var _this5 = this;

      this.render('<p>{{foo.length}}</p>', { foo: undefined });

      this.assertHTML('<p></p>');

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(_this5.context, 'foo', 'foo');
      });

      this.assertHTML('<p>3</p>');

      this.runTask(function () {
        return _emberMetal.set(_this5.context, 'foo', '');
      });

      this.assertHTML('<p>0</p>');

      this.runTask(function () {
        return _emberMetal.set(_this5.context, 'foo', undefined);
      });

      this.assertHTML('<p></p>');
    };

    DynamicContentTest.prototype['@test resolves the array length properly'] = function testResolvesTheArrayLengthProperly() {
      var _this6 = this;

      this.render('<p>{{foo.length}}</p>', { foo: undefined });

      this.assertHTML('<p></p>');

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(_this6.context, 'foo', [1, 2, 3]);
      });

      this.assertHTML('<p>3</p>');

      this.runTask(function () {
        return _emberMetal.set(_this6.context, 'foo', []);
      });

      this.assertHTML('<p>0</p>');

      this.runTask(function () {
        return _emberMetal.set(_this6.context, 'foo', undefined);
      });

      this.assertHTML('<p></p>');
    };

    DynamicContentTest.prototype['@test it can render a capitalized path with no deprecation'] = function testItCanRenderACapitalizedPathWithNoDeprecation() {
      var _this7 = this;

      expectNoDeprecation();

      this.renderPath('CaptializedPath', { CaptializedPath: 'no deprecation' });

      this.assertContent('no deprecation');

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(_this7.context, 'CaptializedPath', 'still no deprecation');
      });

      this.assertContent('still no deprecation');
      this.assertInvariants();

      this.runTask(function () {
        return _emberMetal.set(_this7.context, 'CaptializedPath', 'no deprecation');
      });

      this.assertContent('no deprecation');
      this.assertInvariants();
    };

    DynamicContentTest.prototype['@test it can render undefined dynamic paths'] = function testItCanRenderUndefinedDynamicPaths() {
      var _this8 = this;

      this.renderPath('name', {});

      this.assertIsEmpty();

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(_this8.context, 'name', 'foo-bar');
      });

      this.assertContent('foo-bar');

      this.runTask(function () {
        return _emberMetal.set(_this8.context, 'name', undefined);
      });

      this.assertIsEmpty();
    };

    DynamicContentTest.prototype['@test it can render a deeply nested dynamic path'] = function testItCanRenderADeeplyNestedDynamicPath() {
      var _this9 = this;

      this.renderPath('a.b.c.d.e.f', {
        a: { b: { c: { d: { e: { f: 'hello' } } } } }
      });

      this.assertContent('hello');

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(_this9.context, 'a.b.c.d.e.f', 'goodbye');
      });

      this.assertContent('goodbye');
      this.assertInvariants();

      this.runTask(function () {
        return _emberMetal.set(_this9.context, 'a.b.c.d', { e: { f: 'aloha' } });
      });

      this.assertContent('aloha');
      this.assertInvariants();

      this.runTask(function () {
        _emberMetal.set(_this9.context, 'a', { b: { c: { d: { e: { f: 'hello' } } } } });
      });

      this.assertContent('hello');
      this.assertInvariants();
    };

    DynamicContentTest.prototype['@test it can render a computed property'] = function testItCanRenderAComputedProperty() {
      var _this10 = this;

      var Formatter = _emberRuntime.Object.extend({
        formattedMessage: _emberMetal.computed('message', function () {
          return this.get('message').toUpperCase();
        })
      });

      var m = Formatter.create({ message: 'hello' });

      this.renderPath('m.formattedMessage', { m: m });

      this.assertContent('HELLO');

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(m, 'message', 'goodbye');
      });

      this.assertContent('GOODBYE');
      this.assertInvariants();

      this.runTask(function () {
        return _emberMetal.set(_this10.context, 'm', Formatter.create({ message: 'hello' }));
      });

      this.assertContent('HELLO');
      this.assertInvariants();
    };

    DynamicContentTest.prototype['@test it can render a computed property with nested dependency'] = function testItCanRenderAComputedPropertyWithNestedDependency() {
      var _this11 = this;

      var Formatter = _emberRuntime.Object.extend({
        formattedMessage: _emberMetal.computed('messenger.message', function () {
          return this.get('messenger.message').toUpperCase();
        })
      });

      var m = Formatter.create({ messenger: { message: 'hello' } });

      this.renderPath('m.formattedMessage', { m: m });

      this.assertContent('HELLO');

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(m, 'messenger.message', 'goodbye');
      });

      this.assertContent('GOODBYE');
      this.assertInvariants();

      this.runTask(function () {
        return _emberMetal.set(_this11.context, 'm', Formatter.create({ messenger: { message: 'hello' } }));
      });

      this.assertContent('HELLO');
      this.assertInvariants();
    };

    DynamicContentTest.prototype['@test it can read from a proxy object'] = function testItCanReadFromAProxyObject() {
      var _this12 = this;

      this.renderPath('proxy.name', { proxy: _emberRuntime.ObjectProxy.create({ content: { name: 'Tom Dale' } }) });

      this.assertContent('Tom Dale');

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(_this12.context, 'proxy.content.name', 'Yehuda Katz');
      });

      this.assertContent('Yehuda Katz');
      this.assertInvariants();

      this.runTask(function () {
        return _emberMetal.set(_this12.context, 'proxy.content', { name: 'Godfrey Chan' });
      });

      this.assertContent('Godfrey Chan');
      this.assertInvariants();

      this.runTask(function () {
        return _emberMetal.set(_this12.context, 'proxy.name', 'Stefan Penner');
      });

      this.assertContent('Stefan Penner');
      this.assertInvariants();

      this.runTask(function () {
        return _emberMetal.set(_this12.context, 'proxy.content', null);
      });

      this.assertIsEmpty();

      this.runTask(function () {
        return _emberMetal.set(_this12.context, 'proxy', _emberRuntime.ObjectProxy.create({ content: { name: 'Tom Dale' } }));
      });

      this.assertContent('Tom Dale');
      this.assertInvariants();
    };

    DynamicContentTest.prototype['@test it can read from a nested path in a proxy object'] = function testItCanReadFromANestedPathInAProxyObject() {
      var _this13 = this;

      this.renderPath('proxy.name.last', { proxy: _emberRuntime.ObjectProxy.create({ content: { name: { first: 'Tom', last: 'Dale' } } }) });

      this.assertContent('Dale');

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(_this13.context, 'proxy.content.name.last', 'Cruise');
      });

      this.assertContent('Cruise');
      this.assertInvariants();

      this.runTask(function () {
        return _emberMetal.set(_this13.context, 'proxy.content.name.first', 'Suri');
      });

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(_this13.context, 'proxy.content.name', { first: 'Yehuda', last: 'Katz' });
      });

      this.assertContent('Katz');
      this.assertInvariants();

      this.runTask(function () {
        return _emberMetal.set(_this13.context, 'proxy.content', { name: { first: 'Godfrey', last: 'Chan' } });
      });

      this.assertContent('Chan');
      this.assertInvariants();

      this.runTask(function () {
        return _emberMetal.set(_this13.context, 'proxy.name', { first: 'Stefan', last: 'Penner' });
      });

      this.assertContent('Penner');
      this.assertInvariants();

      this.runTask(function () {
        return _emberMetal.set(_this13.context, 'proxy', null);
      });

      this.assertIsEmpty();

      this.runTask(function () {
        return _emberMetal.set(_this13.context, 'proxy', _emberRuntime.ObjectProxy.create({ content: { name: { first: 'Tom', last: 'Dale' } } }));
      });

      this.assertContent('Dale');
      this.assertInvariants();
    };

    DynamicContentTest.prototype['@test it can read from a path flipping between a proxy and a real object'] = function testItCanReadFromAPathFlippingBetweenAProxyAndARealObject() {
      var _this14 = this;

      this.renderPath('proxyOrObject.name.last', { proxyOrObject: _emberRuntime.ObjectProxy.create({ content: { name: { first: 'Tom', last: 'Dale' } } }) });

      this.assertContent('Dale');

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(_this14.context, 'proxyOrObject', { name: { first: 'Tom', last: 'Dale' } });
      });

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(_this14.context, 'proxyOrObject.name.last', 'Cruise');
      });

      this.assertContent('Cruise');
      this.assertInvariants();

      this.runTask(function () {
        return _emberMetal.set(_this14.context, 'proxyOrObject.name.first', 'Suri');
      });

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(_this14.context, 'proxyOrObject', { name: { first: 'Yehuda', last: 'Katz' } });
      });

      this.assertContent('Katz');
      this.assertInvariants();

      this.runTask(function () {
        return _emberMetal.set(_this14.context, 'proxyOrObject', _emberRuntime.ObjectProxy.create({ content: { name: { first: 'Godfrey', last: 'Chan' } } }));
      });

      this.assertContent('Chan');
      this.assertInvariants();

      this.runTask(function () {
        return _emberMetal.set(_this14.context, 'proxyOrObject.content.name', { first: 'Stefan', last: 'Penner' });
      });

      this.assertContent('Penner');
      this.assertInvariants();

      this.runTask(function () {
        return _emberMetal.set(_this14.context, 'proxyOrObject', null);
      });

      this.assertIsEmpty();

      this.runTask(function () {
        return _emberMetal.set(_this14.context, 'proxyOrObject', _emberRuntime.ObjectProxy.create({ content: { name: { first: 'Tom', last: 'Dale' } } }));
      });

      this.assertContent('Dale');
      this.assertInvariants();
    };

    DynamicContentTest.prototype['@test it can read from a path flipping between a real object and a proxy'] = function testItCanReadFromAPathFlippingBetweenARealObjectAndAProxy() {
      var _this15 = this;

      this.renderPath('objectOrProxy.name.last', { objectOrProxy: { name: { first: 'Tom', last: 'Dale' } } });

      this.assertContent('Dale');

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(_this15.context, 'objectOrProxy', _emberRuntime.ObjectProxy.create({ content: { name: { first: 'Tom', last: 'Dale' } } }));
      });

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(_this15.context, 'objectOrProxy.content.name.last', 'Cruise');
      });

      this.assertContent('Cruise');
      this.assertInvariants();

      this.runTask(function () {
        return _emberMetal.set(_this15.context, 'objectOrProxy.content.name.first', 'Suri');
      });

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(_this15.context, 'objectOrProxy.content', { name: { first: 'Yehuda', last: 'Katz' } });
      });

      this.assertContent('Katz');
      this.assertInvariants();

      this.runTask(function () {
        return _emberMetal.set(_this15.context, 'objectOrProxy', { name: { first: 'Godfrey', last: 'Chan' } });
      });

      this.assertContent('Chan');
      this.assertInvariants();

      this.runTask(function () {
        return _emberMetal.set(_this15.context, 'objectOrProxy.name', { first: 'Stefan', last: 'Penner' });
      });

      this.assertContent('Penner');
      this.assertInvariants();

      this.runTask(function () {
        return _emberMetal.set(_this15.context, 'objectOrProxy', null);
      });

      this.assertIsEmpty();

      this.runTask(function () {
        return _emberMetal.set(_this15.context, 'objectOrProxy', { name: { first: 'Tom', last: 'Dale' } });
      });

      this.assertContent('Dale');
      this.assertInvariants();
    };

    DynamicContentTest.prototype['@test it can read from a null object'] = function testItCanReadFromANullObject() {
      var _this16 = this;

      var nullObject = Object.create(null);
      nullObject['message'] = 'hello';

      this.renderPath('nullObject.message', { nullObject: nullObject });

      this.assertContent('hello');

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(nullObject, 'message', 'goodbye');
      });

      this.assertContent('goodbye');
      this.assertInvariants();

      nullObject = Object.create(null);
      nullObject['message'] = 'hello';

      this.runTask(function () {
        return _emberMetal.set(_this16.context, 'nullObject', nullObject);
      });

      this.assertContent('hello');
      this.assertInvariants();
    };

    DynamicContentTest.prototype['@test it can render a readOnly property of a path'] = function testItCanRenderAReadOnlyPropertyOfAPath() {
      var _this17 = this;

      var Messenger = _emberRuntime.Object.extend({
        message: _emberMetal.computed.readOnly('a.b.c')
      });

      var messenger = Messenger.create({
        a: {
          b: {
            c: 'hello'
          }
        }
      });

      this.renderPath('messenger.message', { messenger: messenger });

      this.assertContent('hello');

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(messenger, 'a.b.c', 'hi');
      });

      this.assertContent('hi');
      this.assertInvariants();

      this.runTask(function () {
        return _emberMetal.set(_this17.context, 'messenger.a.b', {
          c: 'goodbye'
        });
      });

      this.assertContent('goodbye');
      this.assertInvariants();

      this.runTask(function () {
        return _emberMetal.set(_this17.context, 'messenger', {
          message: 'hello'
        });
      });

      this.assertContent('hello');
      this.assertInvariants();
    };

    return DynamicContentTest;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest);

  var EMPTY = {};

  var ContentTestGenerator = (function () {
    function ContentTestGenerator(cases) {
      var tag = arguments.length <= 1 || arguments[1] === undefined ? '@test' : arguments[1];

      this.cases = cases;
      this.tag = tag;
    }

    ContentTestGenerator.prototype.generate = function generate(_ref3) {
      var value = _ref3[0];
      var expected = _ref3[1];
      var label = _ref3[2];

      var tag = this.tag;
      label = label || value;

      if (expected === EMPTY) {
        var _ref;

        return _ref = {}, _ref[tag + ' rendering ' + label] = function () {
          var _this18 = this;

          this.renderPath('value', { value: value });

          this.assertIsEmpty();

          this.runTask(function () {
            return _emberMetal.set(_this18.context, 'value', 'hello');
          });

          this.assertContent('hello');

          this.runTask(function () {
            return _emberMetal.set(_this18.context, 'value', value);
          });

          this.assertIsEmpty();
        }, _ref;
      } else {
        var _ref2;

        return _ref2 = {}, _ref2[tag + ' rendering ' + label] = function () {
          var _this19 = this;

          this.renderPath('value', { value: value });

          this.assertContent(expected);

          this.assertStableRerender();

          this.runTask(function () {
            return _emberMetal.set(_this19.context, 'value', 'hello');
          });

          this.assertContent('hello');
          this.assertInvariants();

          this.runTask(function () {
            return _emberMetal.set(_this19.context, 'value', value);
          });

          this.assertContent(expected);
          this.assertInvariants();
        }, _ref2;
      }
    };

    return ContentTestGenerator;
  })();

  var SharedContentTestCases = new ContentTestGenerator([['foo', 'foo'], [0, '0'], [-0, '0', '-0'], [1, '1'], [-1, '-1'], [0.0, '0', '0.0'], [0.5, '0.5'], [undefined, EMPTY], [null, EMPTY], [true, 'true'], [false, 'false'], [NaN, 'NaN'], [new Date(2000, 0, 1), String(new Date(2000, 0, 1)), 'a Date object'], [Infinity, 'Infinity'], [1 / -0, '-Infinity'], [{ foo: 'bar' }, '[object Object]', '{ foo: \'bar\' }'], [{ toString: function () {
      return 'foo';
    } }, 'foo', 'an object with a custom toString function'], [{ valueOf: function () {
      return 1;
    } }, '[object Object]', 'an object with a custom valueOf function'],

  // Escaping tests
  ['<b>Max</b><b>James</b>', '<b>Max</b><b>James</b>']]);

  var GlimmerContentTestCases = new ContentTestGenerator([[Object.create(null), EMPTY, 'an object with no toString']]);

  if (typeof Symbol !== 'undefined') {
    GlimmerContentTestCases.cases.push([Symbol('debug'), 'Symbol(debug)', 'a symbol']);
  }

  _emberGlimmerTestsUtilsAbstractTestCase.applyMixins(DynamicContentTest, SharedContentTestCases, GlimmerContentTestCases);

  _emberGlimmerTestsUtilsTestCase.moduleFor('Dynamic content tests (content position)', (function (_DynamicContentTest) {
    babelHelpers.inherits(_class2, _DynamicContentTest);

    function _class2() {
      _DynamicContentTest.apply(this, arguments);
    }

    _class2.prototype.renderPath = function renderPath(path) {
      var context = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      this.render('{{' + path + '}}', context);
    };

    _class2.prototype.assertContent = function assertContent(content) {
      this.assert.strictEqual(this.nodesCount, 1, 'It should render exactly one text node');
      this.assertTextNode(this.firstChild, content);
    };

    return _class2;
  })(DynamicContentTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Dynamic content tests (content concat)', (function (_DynamicContentTest2) {
    babelHelpers.inherits(_class3, _DynamicContentTest2);

    function _class3() {
      _DynamicContentTest2.apply(this, arguments);
    }

    _class3.prototype.renderPath = function renderPath(path) {
      var context = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      this.render('{{concat "" ' + path + ' ""}}', context);
    };

    _class3.prototype.assertContent = function assertContent(content) {
      this.assert.strictEqual(this.nodesCount, 1, 'It should render exactly one text node');
      this.assertTextNode(this.firstChild, content);
    };

    return _class3;
  })(DynamicContentTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Dynamic content tests (inside an element)', (function (_DynamicContentTest3) {
    babelHelpers.inherits(_class4, _DynamicContentTest3);

    function _class4() {
      _DynamicContentTest3.apply(this, arguments);
    }

    _class4.prototype.renderPath = function renderPath(path) {
      var context = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      this.render('<p>{{' + path + '}}</p>', context);
    };

    _class4.prototype.assertIsEmpty = function assertIsEmpty() {
      this.assert.strictEqual(this.nodesCount, 1, 'It should render exactly one <p> tag');
      this.assertElement(this.firstChild, { tagName: 'p' });
      this.assertText('');
    };

    _class4.prototype.assertContent = function assertContent(content) {
      this.assert.strictEqual(this.nodesCount, 1, 'It should render exactly one <p> tag');
      this.assertElement(this.firstChild, { tagName: 'p' });
      this.assertText(content);
    };

    return _class4;
  })(DynamicContentTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Dynamic content tests (attribute position)', (function (_DynamicContentTest4) {
    babelHelpers.inherits(_class5, _DynamicContentTest4);

    function _class5() {
      _DynamicContentTest4.apply(this, arguments);
    }

    _class5.prototype.renderPath = function renderPath(path) {
      var context = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      this.render('<div data-foo="{{' + path + '}}"></div>', context);
    };

    _class5.prototype.assertIsEmpty = function assertIsEmpty() {
      this.assert.strictEqual(this.nodesCount, 1, 'It should render exactly one <div> tag');
      this.assertElement(this.firstChild, { tagName: 'div', content: '' });
    };

    _class5.prototype.assertContent = function assertContent(content) {
      this.assert.strictEqual(this.nodesCount, 1, 'It should render exactly one <div> tag');
      this.assertElement(this.firstChild, { tagName: 'div', attrs: { 'data-foo': content }, content: '' });
    };

    return _class5;
  })(DynamicContentTest));

  var TrustedContentTest = (function (_DynamicContentTest5) {
    babelHelpers.inherits(TrustedContentTest, _DynamicContentTest5);

    function TrustedContentTest() {
      _DynamicContentTest5.apply(this, arguments);
    }

    TrustedContentTest.prototype.assertIsEmpty = function assertIsEmpty() {
      this.assert.strictEqual(this.firstChild, null);
    };

    TrustedContentTest.prototype.assertContent = function assertContent(content) {
      this.assertHTML(content);
    };

    TrustedContentTest.prototype.assertStableRerender = function assertStableRerender() {
      var _this20 = this;

      this.takeSnapshot();
      this.runTask(function () {
        return _this20.rerender();
      });
      _DynamicContentTest5.prototype.assertInvariants.call(this);
    };

    TrustedContentTest.prototype.assertInvariants = function assertInvariants() {
      // If it's not stable, we will wipe out all the content and replace them,
      // so there are no invariants
    };

    return TrustedContentTest;
  })(DynamicContentTest);

  _emberGlimmerTestsUtilsTestCase.moduleFor('Dynamic content tests (trusted)', (function (_TrustedContentTest) {
    babelHelpers.inherits(_class6, _TrustedContentTest);

    function _class6() {
      _TrustedContentTest.apply(this, arguments);
    }

    _class6.prototype.renderPath = function renderPath(path) {
      var context = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

      this.render('{{{' + path + '}}}', context);
    };

    _class6.prototype['@test updating trusted curlies'] = function testUpdatingTrustedCurlies() {
      var _this21 = this;

      this.render('{{{htmlContent}}}{{{nested.htmlContent}}}', {
        htmlContent: '<b>Max</b>',
        nested: { htmlContent: '<b>James</b>' }
      });

      this.assertContent('<b>Max</b><b>James</b>');

      this.runTask(function () {
        return _this21.rerender();
      });

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(_this21.context, 'htmlContent', '<i>M</i><u>a</u><s>x</s>');
      });

      this.assertContent('<i>M</i><u>a</u><s>x</s><b>James</b>');

      this.runTask(function () {
        return _emberMetal.set(_this21.context, 'nested.htmlContent', 'Jammie');
      });

      this.assertContent('<i>M</i><u>a</u><s>x</s>Jammie');

      this.runTask(function () {
        _emberMetal.set(_this21.context, 'htmlContent', '<b>Max</b>');
        _emberMetal.set(_this21.context, 'nested', { htmlContent: '<i>James</i>' });
      });

      this.assertContent('<b>Max</b><i>James</i>');
    };

    return _class6;
  })(TrustedContentTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Dynamic content tests (integration)', (function (_RenderingTest3) {
    babelHelpers.inherits(_class7, _RenderingTest3);

    function _class7() {
      _RenderingTest3.apply(this, arguments);
    }

    _class7.prototype['@test it can render a dynamic template'] = function testItCanRenderADynamicTemplate() {
      var _this22 = this;

      var template = '\n      <div class="header">\n        <h1>Welcome to {{framework}}</h1>\n      </div>\n      <div class="body">\n        <h2>Why you should use {{framework}}?</h2>\n        <ol>\n          <li>It\'s great</li>\n          <li>It\'s awesome</li>\n          <li>It\'s {{framework}}</li>\n        </ol>\n      </div>\n      <div class="footer">\n        {{framework}} is free, open source and always will be.\n      </div>\n    ';

      var ember = '\n      <div class="header">\n        <h1>Welcome to Ember.js</h1>\n      </div>\n      <div class="body">\n        <h2>Why you should use Ember.js?</h2>\n        <ol>\n          <li>It\'s great</li>\n          <li>It\'s awesome</li>\n          <li>It\'s Ember.js</li>\n        </ol>\n      </div>\n      <div class="footer">\n        Ember.js is free, open source and always will be.\n      </div>\n    ';

      var react = '\n      <div class="header">\n        <h1>Welcome to React</h1>\n      </div>\n      <div class="body">\n        <h2>Why you should use React?</h2>\n        <ol>\n          <li>It\'s great</li>\n          <li>It\'s awesome</li>\n          <li>It\'s React</li>\n        </ol>\n      </div>\n      <div class="footer">\n        React is free, open source and always will be.\n      </div>\n    ';

      this.render(template, {
        framework: 'Ember.js'
      });
      this.assertHTML(ember);

      this.runTask(function () {
        return _this22.rerender();
      });

      this.assertHTML(ember);

      this.runTask(function () {
        return _emberMetal.set(_this22.context, 'framework', 'React');
      });

      this.assertHTML(react);

      this.runTask(function () {
        return _emberMetal.set(_this22.context, 'framework', 'Ember.js');
      });

      this.assertHTML(ember);
    };

    _class7.prototype['@test it should evaluate to nothing if part of the path is `undefined`'] = function testItShouldEvaluateToNothingIfPartOfThePathIsUndefined() {
      var _this23 = this;

      this.render('{{foo.bar.baz.bizz}}', {
        foo: {}
      });

      this.assertText('');

      this.runTask(function () {
        return _this23.rerender();
      });

      this.assertText('');

      this.runTask(function () {
        return _emberMetal.set(_this23.context, 'foo', {
          bar: { baz: { bizz: 'Hey!' } }
        });
      });

      this.assertText('Hey!');

      this.runTask(function () {
        return _emberMetal.set(_this23.context, 'foo', {});
      });

      this.assertText('');

      this.runTask(function () {
        return _emberMetal.set(_this23.context, 'foo', {
          bar: { baz: { bizz: 'Hello!' } }
        });
      });

      this.assertText('Hello!');

      this.runTask(function () {
        return _emberMetal.set(_this23.context, 'foo', {});
      });

      this.assertText('');
    };

    _class7.prototype['@test it should evaluate to nothing if part of the path is a primative'] = function testItShouldEvaluateToNothingIfPartOfThePathIsAPrimative() {
      var _this24 = this;

      this.render('{{foo.bar.baz.bizz}}', {
        foo: { bar: true }
      });

      this.assertText('');

      this.runTask(function () {
        return _this24.rerender();
      });

      this.assertText('');

      this.runTask(function () {
        return _emberMetal.set(_this24.context, 'foo', {
          bar: false
        });
      });

      this.assertText('');

      this.runTask(function () {
        return _emberMetal.set(_this24.context, 'foo', {
          bar: 'Haha'
        });
      });

      this.assertText('');

      this.runTask(function () {
        return _emberMetal.set(_this24.context, 'foo', {
          bar: null
        });
      });

      this.assertText('');

      this.runTask(function () {
        return _emberMetal.set(_this24.context, 'foo', {
          bar: undefined
        });
      });

      this.assertText('');

      this.runTask(function () {
        return _emberMetal.set(_this24.context, 'foo', {
          bar: 1
        });
      });

      this.assertText('');

      this.runTask(function () {
        return _emberMetal.set(_this24.context, 'foo', {
          bar: { baz: { bizz: 'Hello!' } }
        });
      });

      this.assertText('Hello!');

      this.runTask(function () {
        return _emberMetal.set(_this24.context, 'foo', {
          bar: true
        });
      });

      this.assertText('');
    };

    _class7.prototype['@test can set dynamic href'] = function testCanSetDynamicHref() {
      var _this25 = this;

      this.render('<a href={{model.url}}>Example</a>', {
        model: {
          url: 'http://example.com'
        }
      });

      this.assertElement(this.firstChild, { tagName: 'a', content: 'Example', attrs: { 'href': 'http://example.com' } });

      this.runTask(function () {
        return _this25.rerender();
      });

      this.assertElement(this.firstChild, { tagName: 'a', content: 'Example', attrs: { 'href': 'http://example.com' } });

      this.runTask(function () {
        return _emberMetal.set(_this25.context, 'model.url', 'http://linkedin.com');
      });

      this.assertElement(this.firstChild, { tagName: 'a', content: 'Example', attrs: { 'href': 'http://linkedin.com' } });

      this.runTask(function () {
        return _emberMetal.set(_this25.context, 'model', { url: 'http://example.com' });
      });

      this.assertElement(this.firstChild, { tagName: 'a', content: 'Example', attrs: { 'href': 'http://example.com' } });
    };

    _class7.prototype['@test quoteless class attributes update correctly'] = function testQuotelessClassAttributesUpdateCorrectly() {
      var _this26 = this;

      this.render('<div class={{if fooBar "foo-bar"}}>hello</div>', {
        fooBar: true
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('foo-bar') } });

      this.runTask(function () {
        return _this26.rerender();
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('foo-bar') } });

      this.runTask(function () {
        return _emberMetal.set(_this26.context, 'fooBar', false);
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello' });

      this.runTask(function () {
        return _emberMetal.set(_this26.context, 'fooBar', true);
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('foo-bar') } });
    };

    _class7.prototype['@test quoted class attributes update correctly'] = function testQuotedClassAttributesUpdateCorrectly(assert) {
      var _this27 = this;

      this.render('<div class="{{if fooBar "foo-bar"}}">hello</div>', {
        fooBar: true
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('foo-bar') } });

      this.runTask(function () {
        return _this27.rerender();
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('foo-bar') } });

      this.runTask(function () {
        return _emberMetal.set(_this27.context, 'fooBar', false);
      });

      assert.equal(this.firstChild.className, '');

      this.runTask(function () {
        return _emberMetal.set(_this27.context, 'fooBar', true);
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('foo-bar') } });
    };

    _class7.prototype['@test unquoted class attribute can contain multiple classes'] = function testUnquotedClassAttributeCanContainMultipleClasses() {
      var _this28 = this;

      this.render('<div class={{model.classes}}>hello</div>', {
        model: {
          classes: 'foo bar baz'
        }
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('foo bar baz') } });

      this.runTask(function () {
        return _this28.rerender();
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('foo bar baz') } });

      this.runTask(function () {
        return _emberMetal.set(_this28.context, 'model.classes', 'fizz bizz');
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('fizz bizz') } });

      this.runTask(function () {
        return _emberMetal.set(_this28.context, 'model', { classes: 'foo bar baz' });
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('foo bar baz') } });
    };

    _class7.prototype['@test unquoted class attribute'] = function testUnquotedClassAttribute() {
      var _this29 = this;

      this.render('<div class={{model.foo}}>hello</div>', {
        model: {
          foo: 'foo'
        }
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('foo') } });

      this.runTask(function () {
        return _this29.rerender();
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('foo') } });

      this.runTask(function () {
        return _emberMetal.set(_this29.context, 'model.foo', 'fizz');
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('fizz') } });

      this.runTask(function () {
        return _emberMetal.set(_this29.context, 'model', { foo: 'foo' });
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('foo') } });
    };

    _class7.prototype['@test quoted class attribute'] = function testQuotedClassAttribute() {
      var _this30 = this;

      this.render('<div class="{{model.foo}}">hello</div>', {
        model: {
          foo: 'foo'
        }
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('foo') } });

      this.runTask(function () {
        return _this30.rerender();
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('foo') } });

      this.runTask(function () {
        return _emberMetal.set(_this30.context, 'model.foo', 'fizz');
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('fizz') } });

      this.runTask(function () {
        return _emberMetal.set(_this30.context, 'model', { foo: 'foo' });
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('foo') } });
    };

    _class7.prototype['@test quoted class attribute can contain multiple classes'] = function testQuotedClassAttributeCanContainMultipleClasses() {
      var _this31 = this;

      this.render('<div class="{{model.classes}}">hello</div>', {
        model: {
          classes: 'foo bar baz'
        }
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('foo bar baz') } });

      this.runTask(function () {
        return _this31.rerender();
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('foo bar baz') } });

      this.runTask(function () {
        return _emberMetal.set(_this31.context, 'model.classes', 'fizz bizz');
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('fizz bizz') } });

      this.runTask(function () {
        return _emberMetal.set(_this31.context, 'model', { classes: 'foo bar baz' });
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('foo bar baz') } });
    };

    _class7.prototype['@test class attribute concats bound values'] = function testClassAttributeConcatsBoundValues() {
      var _this32 = this;

      this.render('<div class="{{model.foo}} {{model.bar}} {{model.bizz}}">hello</div>', {
        model: {
          foo: 'foo',
          bar: 'bar',
          bizz: 'bizz'
        }
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('foo bar bizz') } });

      this.runTask(function () {
        return _this32.rerender();
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('foo bar bizz') } });

      this.runTask(function () {
        return _emberMetal.set(_this32.context, 'model.foo', 'fizz');
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('fizz bar bizz') } });

      this.runTask(function () {
        return _emberMetal.set(_this32.context, 'model.bar', null);
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('fizz bizz') } });

      this.runTask(function () {
        return _emberMetal.set(_this32.context, 'model', {
          foo: 'foo',
          bar: 'bar',
          bizz: 'bizz'
        });
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('foo bar bizz') } });
    };

    _class7.prototype['@test class attribute accepts nested helpers, and updates'] = function testClassAttributeAcceptsNestedHelpersAndUpdates() {
      var _this33 = this;

      this.render('<div class="{{if model.hasSize model.size}} {{if model.hasShape model.shape}}">hello</div>', {
        model: {
          size: 'large',
          hasSize: true,
          hasShape: false,
          shape: 'round'
        }
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('large') } });

      this.runTask(function () {
        return _this33.rerender();
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('large') } });

      this.runTask(function () {
        return _emberMetal.set(_this33.context, 'model.hasShape', true);
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('large round') } });

      this.runTask(function () {
        return _emberMetal.set(_this33.context, 'model.hasSize', false);
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('round') } });

      this.runTask(function () {
        return _emberMetal.set(_this33.context, 'model', {
          size: 'large',
          hasSize: true,
          hasShape: false,
          shape: 'round'
        });
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('large') } });
    };

    _class7.prototype['@test Multiple dynamic classes'] = function testMultipleDynamicClasses() {
      var _this34 = this;

      this.render('<div class="{{model.foo}} {{model.bar}} {{model.fizz}} {{model.baz}}">hello</div>', {
        model: {
          foo: 'foo',
          bar: 'bar',
          fizz: 'fizz',
          baz: 'baz'
        }
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('foo bar fizz baz') } });

      this.runTask(function () {
        return _this34.rerender();
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('foo bar fizz baz') } });

      this.runTask(function () {
        _emberMetal.set(_this34.context, 'model.foo', null);
        _emberMetal.set(_this34.context, 'model.fizz', null);
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('bar baz') } });

      this.runTask(function () {
        _emberMetal.set(_this34.context, 'model', {
          foo: 'foo',
          bar: 'bar',
          fizz: 'fizz',
          baz: 'baz'
        });
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': _emberGlimmerTestsUtilsTestHelpers.classes('foo bar fizz baz') } });
    };

    _class7.prototype['@test classes are ordered: See issue #9912'] = function testClassesAreOrderedSeeIssue9912() {
      var _this35 = this;

      this.render('<div class="{{model.foo}}  static   {{model.bar}}">hello</div>', {
        model: {
          foo: 'foo',
          bar: 'bar'
        }
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': 'foo  static   bar' } });

      this.runTask(function () {
        return _this35.rerender();
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': 'foo  static   bar' } });

      this.runTask(function () {
        _emberMetal.set(_this35.context, 'model.bar', null);
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': 'foo  static   ' } });

      this.runTask(function () {
        _emberMetal.set(_this35.context, 'model', {
          foo: 'foo',
          bar: 'bar'
        });
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: 'hello', attrs: { 'class': 'foo  static   bar' } });
    };

    return _class7;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));

  var warnings = undefined,
      originalWarn = undefined;

  var StyleTest = (function (_RenderingTest4) {
    babelHelpers.inherits(StyleTest, _RenderingTest4);

    function StyleTest() {
      _RenderingTest4.apply(this, arguments);
      warnings = [];
      originalWarn = _emberMetal.getDebugFunction('warn');
      _emberMetal.setDebugFunction('warn', function (message, test) {
        if (!test) {
          warnings.push(message);
        }
      });
    }

    StyleTest.prototype.teardown = function teardown() {
      var _RenderingTest4$prototype$teardown;

      (_RenderingTest4$prototype$teardown = _RenderingTest4.prototype.teardown).call.apply(_RenderingTest4$prototype$teardown, [this].concat(babelHelpers.slice.call(arguments)));
      _emberMetal.setDebugFunction('warn', originalWarn);
    };

    StyleTest.prototype.assertStyleWarning = function assertStyleWarning(style) {
      this.assert.deepEqual(warnings, [_emberViews.constructStyleDeprecationMessage(style)]);
    };

    StyleTest.prototype.assertNoWarning = function assertNoWarning() {
      this.assert.deepEqual(warnings, []);
    };

    return StyleTest;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest);

  _emberGlimmerTestsUtilsTestCase.moduleFor('Inline style tests', (function (_StyleTest) {
    babelHelpers.inherits(_class8, _StyleTest);

    function _class8() {
      _StyleTest.apply(this, arguments);
    }

    _class8.prototype['@test can set dynamic style'] = function testCanSetDynamicStyle() {
      var _this36 = this;

      this.render('<div style={{model.style}}></div>', {
        model: {
          style: 'width: 60px;'
        }
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: '', attrs: { 'style': 'width: 60px;' } });

      this.runTask(function () {
        return _this36.rerender();
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: '', attrs: { 'style': 'width: 60px;' } });

      this.runTask(function () {
        return _emberMetal.set(_this36.context, 'model.style', 'height: 60px;');
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: '', attrs: { 'style': 'height: 60px;' } });

      this.runTask(function () {
        return _emberMetal.set(_this36.context, 'model.style', null);
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: '', attrs: {} });

      this.runTask(function () {
        return _emberMetal.set(_this36.context, 'model', { style: 'width: 60px;' });
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: '', attrs: { 'style': 'width: 60px;' } });
    };

    _class8.prototype['@test can set dynamic style with -html-safe'] = function testCanSetDynamicStyleWithHtmlSafe() {
      var _this37 = this;

      this.render('<div style={{-html-safe model.style}}></div>', {
        model: {
          style: 'width: 60px;'
        }
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: '', attrs: { 'style': 'width: 60px;' } });

      this.runTask(function () {
        return _this37.rerender();
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: '', attrs: { 'style': 'width: 60px;' } });

      this.runTask(function () {
        return _emberMetal.set(_this37.context, 'model.style', 'height: 60px;');
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: '', attrs: { 'style': 'height: 60px;' } });

      this.runTask(function () {
        return _emberMetal.set(_this37.context, 'model', { style: 'width: 60px;' });
      });

      this.assertElement(this.firstChild, { tagName: 'div', content: '', attrs: { 'style': 'width: 60px;' } });
    };

    return _class8;
  })(StyleTest));

  if (!EmberDev.runningProdBuild) {
    _emberGlimmerTestsUtilsTestCase.moduleFor('Inline style tests - warnings', (function (_StyleTest2) {
      babelHelpers.inherits(_class9, _StyleTest2);

      function _class9() {
        _StyleTest2.apply(this, arguments);
      }

      _class9.prototype['@test specifying <div style={{userValue}}></div> generates a warning'] = function testSpecifyingDivStyleUserValueDivGeneratesAWarning(assert) {
        var userValue = 'width: 42px';
        this.render('<div style={{userValue}}></div>', {
          userValue: userValue
        });

        this.assertStyleWarning(userValue);
      };

      _class9.prototype['@test specifying `attributeBindings: ["style"]` generates a warning'] = function testSpecifyingAttributeBindingsStyleGeneratesAWarning(assert) {
        var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
          attributeBindings: ['style']
        });

        this.registerComponent('foo-bar', { ComponentClass: FooBarComponent, template: 'hello' });
        var userValue = 'width: 42px';
        this.render('{{foo-bar style=userValue}}', {
          userValue: userValue
        });

        this.assertStyleWarning(userValue);
      };

      _class9.prototype['@test specifying `<div style={{{userValue}}}></div>` works properly without a warning'] = function testSpecifyingDivStyleUserValueDivWorksProperlyWithoutAWarning(assert) {
        this.render('<div style={{{userValue}}}></div>', {
          userValue: 'width: 42px'
        });

        this.assertNoWarning();
      };

      _class9.prototype['@test specifying `<div style={{userValue}}></div>` works properly with a SafeString'] = function testSpecifyingDivStyleUserValueDivWorksProperlyWithASafeString(assert) {
        this.render('<div style={{userValue}}></div>', {
          userValue: new _emberGlimmerTestsUtilsHelpers.SafeString('width: 42px')
        });

        this.assertNoWarning();
      };

      _class9.prototype['@test null value do not generate htmlsafe warning'] = function testNullValueDoNotGenerateHtmlsafeWarning(assert) {
        this.render('<div style={{userValue}}></div>', {
          userValue: null
        });

        this.assertNoWarning();
      };

      _class9.prototype['@test undefined value do not generate htmlsafe warning'] = function testUndefinedValueDoNotGenerateHtmlsafeWarning(assert) {
        this.render('<div style={{userValue}}></div>');

        this.assertNoWarning();
      };

      _class9.prototype['@test no warnings are triggered when using `-html-safe`'] = function testNoWarningsAreTriggeredWhenUsingHtmlSafe(assert) {
        this.render('<div style={{-html-safe userValue}}></div>', {
          userValue: 'width: 42px'
        });

        this.assertNoWarning();
      };

      _class9.prototype['@test no warnings are triggered when a safe string is quoted'] = function testNoWarningsAreTriggeredWhenASafeStringIsQuoted(assert) {
        this.render('<div style="{{userValue}}"></div>', {
          userValue: new _emberGlimmerTestsUtilsHelpers.SafeString('width: 42px')
        });

        this.assertNoWarning();
      };

      _class9.prototype['@test binding warning is triggered when an unsafe string is quoted'] = function testBindingWarningIsTriggeredWhenAnUnsafeStringIsQuoted(assert) {
        var userValue = 'width: 42px';
        this.render('<div style="{{userValue}}"></div>', {
          userValue: userValue
        });

        this.assertStyleWarning(userValue);
      };

      _class9.prototype['@test binding warning is triggered when a safe string for a complete property is concatenated in place'] = function testBindingWarningIsTriggeredWhenASafeStringForACompletePropertyIsConcatenatedInPlace(assert) {
        var userValue = 'width: 42px';
        this.render('<div style="color: green; {{userValue}}"></div>', {
          userValue: new _emberGlimmerTestsUtilsHelpers.SafeString('width: 42px')
        });

        this.assertStyleWarning('color: green; ' + userValue);
      };

      _class9.prototype['@test binding warning is triggered when a safe string for a value is concatenated in place'] = function testBindingWarningIsTriggeredWhenASafeStringForAValueIsConcatenatedInPlace(assert) {
        var userValue = '42px';
        this.render('<div style="color: green; width: {{userValue}}"></div>', {
          userValue: new _emberGlimmerTestsUtilsHelpers.SafeString(userValue)
        });

        this.assertStyleWarning('color: green; width: ' + userValue);
      };

      _class9.prototype['@test binding warning is triggered when a safe string for a property name is concatenated in place'] = function testBindingWarningIsTriggeredWhenASafeStringForAPropertyNameIsConcatenatedInPlace(assert) {
        var userValue = 'width';
        this.render('<div style="color: green; {{userProperty}}: 42px"></div>', {
          userProperty: new _emberGlimmerTestsUtilsHelpers.SafeString(userValue)
        });

        this.assertStyleWarning('color: green; ' + userValue + ': 42px');
      };

      return _class9;
    })(StyleTest));
  }
});
enifed('ember-glimmer/tests/integration/event-dispatcher-test', ['exports', 'ember-glimmer/tests/utils/test-case', 'ember-glimmer/tests/utils/helpers', 'ember-metal'], function (exports, _emberGlimmerTestsUtilsTestCase, _emberGlimmerTestsUtilsHelpers, _emberMetal) {
  'use strict';

  var canDataTransfer = !!document.createEvent('HTMLEvents').dataTransfer;

  function fireNativeWithDataTransfer(node, type, dataTransfer) {
    var event = document.createEvent('HTMLEvents');
    event.initEvent(type, true, true);
    event.dataTransfer = dataTransfer;
    node.dispatchEvent(event);
  }

  _emberGlimmerTestsUtilsTestCase.moduleFor('EventDispatcher', (function (_RenderingTest) {
    babelHelpers.inherits(_class, _RenderingTest);

    function _class() {
      _RenderingTest.apply(this, arguments);
    }

    _class.prototype['@test events bubble view hierarchy for form elements'] = function testEventsBubbleViewHierarchyForFormElements(assert) {
      var _this = this;

      var receivedEvent = undefined;

      this.registerComponent('x-foo', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          change: function (event) {
            receivedEvent = event;
          }
        }),
        template: '<input id="is-done" type="checkbox">'
      });

      this.render('{{x-foo}}');

      this.runTask(function () {
        return _this.$('#is-done').trigger('change');
      });
      assert.ok(receivedEvent, 'change event was triggered');
      assert.strictEqual(receivedEvent.target, this.$('#is-done')[0]);
    };

    _class.prototype['@test dispatches to the nearest event manager'] = function testDispatchesToTheNearestEventManager(assert) {
      var _this2 = this;

      var receivedEvent = undefined;

      this.registerComponent('x-foo', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          click: function (event) {
            assert.notOk(true, 'should not trigger `click` on component');
          },

          eventManager: {
            click: function (event) {
              receivedEvent = event;
            }
          }
        }),

        template: '<input id="is-done" type="checkbox">'
      });

      this.render('{{x-foo}}');

      this.runTask(function () {
        return _this2.$('#is-done').trigger('click');
      });
      assert.strictEqual(receivedEvent.target, this.$('#is-done')[0]);
    };

    _class.prototype['@test event manager can re-dispatch to the component'] = function testEventManagerCanReDispatchToTheComponent(assert) {
      var _this3 = this;

      var handlers = [];

      this.registerComponent('x-foo', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          click: function () {
            handlers.push('component');
          },

          eventManager: {
            click: function (event, component) {
              handlers.push('eventManager');
              // Re-dispatch event when you get it.
              //
              // The second parameter tells the dispatcher
              // that this event has been handled. This
              // API will clearly need to be reworked since
              // multiple eventManagers in a single view
              // hierarchy would break, but it shows that
              // re-dispatching works
              component.$().trigger('click', this);
            }
          }
        }),

        template: '<input id="is-done" type="checkbox">'
      });

      this.render('{{x-foo}}');

      this.runTask(function () {
        return _this3.$('#is-done').trigger('click');
      });
      assert.deepEqual(handlers, ['eventManager', 'component']);
    };

    _class.prototype['@test event handlers are wrapped in a run loop'] = function testEventHandlersAreWrappedInARunLoop(assert) {
      this.registerComponent('x-foo', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          change: function () {
            assert.ok(_emberMetal.run.currentRunLoop, 'a run loop should have started');
          }
        }),
        template: '<input id="is-done" type="checkbox">'
      });

      this.render('{{x-foo}}');

      this.$('#is-done').trigger('click');
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('EventDispatcher#setup', (function (_RenderingTest2) {
    babelHelpers.inherits(_class2, _RenderingTest2);

    function _class2() {
      _RenderingTest2.call(this);

      var dispatcher = this.owner.lookup('event_dispatcher:main');
      _emberMetal.run(dispatcher, 'destroy');
      this.owner.__container__.reset('event_dispatcher:main');
      this.dispatcher = this.owner.lookup('event_dispatcher:main');
    }

    _class2.prototype['@test additonal events can be specified'] = function testAdditonalEventsCanBeSpecified(assert) {
      this.dispatcher.setup({ myevent: 'myEvent' });

      this.registerComponent('x-foo', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          myEvent: function () {
            assert.ok(true, 'custom event was triggered');
          }
        }),
        template: '<p>Hello!</p>'
      });

      this.render('{{x-foo}}');

      this.$('div').trigger('myevent');
    };

    _class2.prototype['@test a rootElement can be specified'] = function testARootElementCanBeSpecified(assert) {
      this.$().append('<div id="app"></div>');
      this.dispatcher.setup({ myevent: 'myEvent' }, '#app');

      assert.ok(this.$('#app').hasClass('ember-application'), 'custom rootElement was used');
      assert.equal(this.dispatcher.rootElement, '#app', 'the dispatchers rootElement was updated');
    };

    _class2.prototype['@test default events can be disabled via `customEvents`'] = function testDefaultEventsCanBeDisabledViaCustomEvents(assert) {
      this.dispatcher.setup({ click: null });

      this.registerComponent('x-foo', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          click: function () {
            assert.ok(false, 'click method was called');
          },

          null: function () {
            assert.ok(false, 'null method was called');
          },

          doubleClick: function () {
            assert.ok(true, 'a non-disabled event is still handled properly');
          }
        }),

        template: '<p>Hello!</p>'
      });

      this.render('{{x-foo}}');

      this.$('div').trigger('click');
      this.$('div').trigger('dblclick');
    };

    _class2.prototype['@test throws if specified rootElement does not exist'] = function testThrowsIfSpecifiedRootElementDoesNotExist(assert) {
      var _this4 = this;

      assert.throws(function () {
        _this4.dispatcher.setup({ myevent: 'myEvent' }, '#app');
      });
    };

    return _class2;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));

  if (false) {
    _emberGlimmerTestsUtilsTestCase.moduleFor('EventDispatcher - Instrumentation', (function (_RenderingTest3) {
      babelHelpers.inherits(_class3, _RenderingTest3);

      function _class3() {
        _RenderingTest3.apply(this, arguments);
      }

      _class3.prototype.teardown = function teardown() {
        _RenderingTest3.prototype.teardown.call(this);
        _emberMetal.instrumentationReset();
      };

      _class3.prototype['@test instruments triggered events'] = function testInstrumentsTriggeredEvents(assert) {
        var clicked = 0;

        this.registerComponent('x-foo', {
          ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
            click: function (evt) {
              clicked++;
            }
          }),
          template: '<p>hello</p>'
        });

        this.render('{{x-foo}}');

        this.$('div').trigger('click');

        assert.equal(clicked, 1, 'precond - the click handler was invoked');

        var clickInstrumented = 0;
        _emberMetal.instrumentationSubscribe('interaction.click', {
          before: function () {
            clickInstrumented++;
            assert.equal(clicked, 1, 'invoked before event is handled');
          },
          after: function () {
            clickInstrumented++;
            assert.equal(clicked, 2, 'invoked after event is handled');
          }
        });

        var keypressInstrumented = 0;
        _emberMetal.instrumentationSubscribe('interaction.keypress', {
          before: function () {
            keypressInstrumented++;
          },
          after: function () {
            keypressInstrumented++;
          }
        });

        this.$('div').trigger('click');
        this.$('div').trigger('change');
        assert.equal(clicked, 2, 'precond - The click handler was invoked');
        assert.equal(clickInstrumented, 2, 'The click was instrumented');
        assert.strictEqual(keypressInstrumented, 0, 'The keypress was not instrumented');
      };

      return _class3;
    })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
  }

  if (canDataTransfer) {
    _emberGlimmerTestsUtilsTestCase.moduleFor('EventDispatcher - Event Properties', (function (_RenderingTest4) {
      babelHelpers.inherits(_class4, _RenderingTest4);

      function _class4() {
        _RenderingTest4.apply(this, arguments);
      }

      _class4.prototype['@test dataTransfer property is added to drop event'] = function testDataTransferPropertyIsAddedToDropEvent(assert) {
        var receivedEvent = undefined;
        this.registerComponent('x-foo', {
          ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
            drop: function (event) {
              receivedEvent = event;
            }
          })
        });

        this.render('{{x-foo}}');

        fireNativeWithDataTransfer(this.$('div')[0], 'drop', 'success');
        assert.equal(receivedEvent.dataTransfer, 'success');
      };

      return _class4;
    })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
  }
});
enifed('ember-glimmer/tests/integration/helpers/-class-test', ['exports', 'ember-glimmer/tests/utils/test-case', 'ember-glimmer/tests/utils/test-helpers', 'ember-metal'], function (exports, _emberGlimmerTestsUtilsTestCase, _emberGlimmerTestsUtilsTestHelpers, _emberMetal) {
  'use strict';

  _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: {{-class}}', (function (_RenderingTest) {
    babelHelpers.inherits(_class, _RenderingTest);

    function _class() {
      _RenderingTest.apply(this, arguments);
    }

    _class.prototype['@test casts binding to dasherized class'] = function testCastsBindingToDasherizedClass() {
      var _this = this;

      this.registerComponent('foo-bar', { template: '' });
      this.render('{{foo-bar class=(-class someTruth "someTruth")}}', {
        someTruth: true
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { class: _emberGlimmerTestsUtilsTestHelpers.classes('some-truth ember-view') } });

      this.runTask(function () {
        return _this.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { class: _emberGlimmerTestsUtilsTestHelpers.classes('some-truth ember-view') } });

      this.runTask(function () {
        return _emberMetal.set(_this.context, 'someTruth', false);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { class: _emberGlimmerTestsUtilsTestHelpers.classes('ember-view') } });

      this.runTask(function () {
        return _emberMetal.set(_this.context, 'someTruth', true);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { class: _emberGlimmerTestsUtilsTestHelpers.classes('some-truth ember-view') } });
    };

    _class.prototype['@tests casts leaf path of binding to dasherized class'] = function testsCastsLeafPathOfBindingToDasherizedClass() {
      var _this2 = this;

      this.registerComponent('foo-bar', { template: '' });
      this.render('{{foo-bar class=(-class model.someTruth "someTruth")}}', {
        model: {
          someTruth: true
        }
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { class: _emberGlimmerTestsUtilsTestHelpers.classes('some-truth ember-view') } });

      this.runTask(function () {
        return _this2.rerender();
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { class: _emberGlimmerTestsUtilsTestHelpers.classes('some-truth ember-view') } });

      this.runTask(function () {
        return _emberMetal.set(_this2.context, 'model.someTruth', false);
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { class: _emberGlimmerTestsUtilsTestHelpers.classes('ember-view') } });

      this.runTask(function () {
        return _emberMetal.set(_this2.context, 'model', { someTruth: true });
      });

      this.assertComponentElement(this.firstChild, { tagName: 'div', attrs: { class: _emberGlimmerTestsUtilsTestHelpers.classes('some-truth ember-view') } });
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
});
enifed('ember-glimmer/tests/integration/helpers/closure-action-test', ['exports', 'ember-metal', 'ember-glimmer/tests/utils/test-case', 'ember-glimmer/tests/utils/abstract-test-case', 'ember-glimmer/tests/utils/helpers'], function (exports, _emberMetal, _emberGlimmerTestsUtilsTestCase, _emberGlimmerTestsUtilsAbstractTestCase, _emberGlimmerTestsUtilsHelpers) {
  'use strict';

  var _templateObject = babelHelpers.taggedTemplateLiteralLoose(['\n        <div id="counter">clicked: {{clicked}}; foo: {{foo}}</div>\n\n        {{click-me id="string-action" onClick=(action "on-click")}}\n        {{click-me id="function-action" onClick=(action onClick)}}\n        {{click-me id="mut-action" onClick=(action (mut clicked))}}\n      '], ['\n        <div id="counter">clicked: {{clicked}}; foo: {{foo}}</div>\n\n        {{click-me id="string-action" onClick=(action "on-click")}}\n        {{click-me id="function-action" onClick=(action onClick)}}\n        {{click-me id="mut-action" onClick=(action (mut clicked))}}\n      ']);

  if (false) {
    _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: closure {{action}} improved instrumentation', (function (_RenderingTest) {
babelHelpers.inherits(_class, _RenderingTest);

      function _class() {
        _RenderingTest.apply(this, arguments);
      }

      _class.prototype.subscribe = function subscribe(eventName, options) {
        this.subscriber = _emberMetal.instrumentationSubscribe(eventName, options);
      };

      _class.prototype.teardown = function teardown() {
        if (this.subscriber) {
          _emberMetal.instrumentationUnsubscribe(this.subscriber);
        }

        _RenderingTest.prototype.teardown.call(this);
      };

      _class.prototype['@test interaction event subscriber should be passed parameters'] = function testInteractionEventSubscriberShouldBePassedParameters() {
        var _this = this;

        var actionParam = 'So krispy';
        var beforeParameters = [];
        var afterParameters = [];

        var InnerComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
          actions: {
            fireAction: function () {
              this.attrs.submit(actionParam);
            }
          }
        });

        var OuterComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
          outerSubmit: function () {}
        });

        this.registerComponent('inner-component', {
          ComponentClass: InnerComponent,
          template: '<button id="instrument-button" {{action "fireAction"}}>What it do</button>'
        });

        this.registerComponent('outer-component', {
          ComponentClass: OuterComponent,
          template: '{{inner-component submit=(action outerSubmit)}}'
        });

        this.subscribe('interaction.ember-action', {
          before: function (name, timestamp, payload) {
            beforeParameters.push(payload.args);
          },
          after: function (name, timestamp, payload) {
            afterParameters.push(payload.args);
          }
        });

        this.render('{{outer-component}}');

        this.runTask(function () {
          _this.$('#instrument-button').trigger('click');
        });

        this.assert.deepEqual(beforeParameters, [[], [actionParam]], 'instrumentation subscriber before function was passed closure action parameters');
        this.assert.deepEqual(afterParameters, [[actionParam], []], 'instrumentation subscriber after function was passed closure action parameters');
      };

      _class.prototype['@test interaction event subscriber should be passed target'] = function testInteractionEventSubscriberShouldBePassedTarget() {
        var _this2 = this;

        var beforeParameters = [];
        var afterParameters = [];

        var InnerComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
          myProperty: 'inner-thing',
          actions: {
            fireAction: function () {
              this.attrs.submit();
            }
          }
        });

        var OuterComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
          myProperty: 'outer-thing',
          outerSubmit: function () {}
        });

        this.registerComponent('inner-component', {
          ComponentClass: InnerComponent,
          template: '<button id="instrument-button" {{action "fireAction"}}>What it do</button>'
        });

        this.registerComponent('outer-component', {
          ComponentClass: OuterComponent,
          template: '{{inner-component submit=(action outerSubmit)}}'
        });

        this.subscribe('interaction.ember-action', {
          before: function (name, timestamp, payload) {
            beforeParameters.push(payload.target.get('myProperty'));
          },
          after: function (name, timestamp, payload) {
            afterParameters.push(payload.target.get('myProperty'));
          }
        });

        this.render('{{outer-component}}');

        this.runTask(function () {
          _this2.$('#instrument-button').trigger('click');
        });

        this.assert.deepEqual(beforeParameters, ['inner-thing', 'outer-thing'], 'instrumentation subscriber before function was passed target');
        this.assert.deepEqual(afterParameters, ['outer-thing', 'inner-thing'], 'instrumentation subscriber after function was passed target');
      };

      _class.prototype['@test instrumented action should return value'] = function testInstrumentedActionShouldReturnValue() {
        var _this3 = this;

        var returnedValue = 'Chris P is so krispy';
        var actualReturnedValue = undefined;

        var InnerComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
          actions: {
            fireAction: function () {
              actualReturnedValue = this.attrs.submit();
            }
          }
        });

        var OuterComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
          outerSubmit: function () {
            return returnedValue;
          }
        });

        this.registerComponent('inner-component', {
          ComponentClass: InnerComponent,
          template: '<button id="instrument-button" {{action "fireAction"}}>What it do</button>'
        });

        this.registerComponent('outer-component', {
          ComponentClass: OuterComponent,
          template: '{{inner-component submit=(action outerSubmit)}}'
        });

        this.subscribe('interaction.ember-action', {
          before: function (name, timestamp, payload) {},
          after: function (name, timestamp, payload) {}
        });

        this.render('{{outer-component}}');

        this.runTask(function () {
          _this3.$('#instrument-button').trigger('click');
        });

        this.assert.equal(actualReturnedValue, returnedValue, 'action can return to caller');
      };

      return _class;
    })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
  }

  _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: closure {{action}}', (function (_RenderingTest2) {
babelHelpers.inherits(_class2, _RenderingTest2);

    function _class2() {
      _RenderingTest2.apply(this, arguments);
    }

    _class2.prototype['@test action should be called'] = function testActionShouldBeCalled() {
      var outerActionCalled = false;
      var component = undefined;

      var InnerComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          component = this;
        },
        fireAction: function () {
          this.attrs.submit();
        }
      });

      var OuterComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        outerSubmit: function () {
          outerActionCalled = true;
        }
      });

      this.registerComponent('inner-component', { ComponentClass: InnerComponent, template: 'inner' });
      this.registerComponent('outer-component', {
        ComponentClass: OuterComponent,
        template: '{{inner-component submit=(action outerSubmit)}}'
      });

      this.render('{{outer-component}}');

      this.runTask(function () {
        component.fireAction();
      });

      this.assert.ok(outerActionCalled, 'the action was called');
    };

    _class2.prototype['@test an error is triggered when bound action function is undefined'] = function testAnErrorIsTriggeredWhenBoundActionFunctionIsUndefined() {
      var _this4 = this;

      this.registerComponent('inner-component', {
        template: 'inner'
      });
      this.registerComponent('outer-component', {
        template: '{{inner-component submit=(action somethingThatIsUndefined)}}'
      });

      expectAssertion(function () {
        _this4.render('{{outer-component}}');
      }, /Action passed is null or undefined in \(action[^)]*\) from .*\./);
    };

    _class2.prototype['@test an error is triggered when bound action being passed in is a non-function'] = function testAnErrorIsTriggeredWhenBoundActionBeingPassedInIsANonFunction() {
      var _this5 = this;

      this.registerComponent('inner-component', {
        template: 'inner'
      });
      this.registerComponent('outer-component', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          nonFunctionThing: {}
        }),
        template: '{{inner-component submit=(action nonFunctionThing)}}'
      });

      expectAssertion(function () {
        _this5.render('{{outer-component}}');
      }, /An action could not be made for `.*` in .*\. Please confirm that you are using either a quoted action name \(i\.e\. `\(action '.*'\)`\) or a function available in .*\./);
    };

    _class2.prototype['@test [#12718] a nice error is shown when a bound action function is undefined and it is passed as attrs.foo'] = function test12718ANiceErrorIsShownWhenABoundActionFunctionIsUndefinedAndItIsPassedAsAttrsFoo() {
      var _this6 = this;

      this.registerComponent('inner-component', {
        template: '<button id="inner-button" {{action (action attrs.external-action)}}>Click me</button>'
      });

      this.registerComponent('outer-component', {
        template: '{{inner-component}}'
      });

      expectAssertion(function () {
        _this6.render('{{outer-component}}');
      }, /Action passed is null or undefined in \(action[^)]*\) from .*\./);
    };

    _class2.prototype['@test action value is returned'] = function testActionValueIsReturned() {
      var expectedValue = 'terrible tom';
      var returnedValue = undefined;
      var innerComponent = undefined;

      var InnerComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          innerComponent = this;
        },
        fireAction: function () {
          returnedValue = this.attrs.submit();
        }
      });

      var OuterComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        outerSubmit: function () {
          return expectedValue;
        }
      });

      this.registerComponent('inner-component', {
        ComponentClass: InnerComponent,
        template: 'inner'
      });

      this.registerComponent('outer-component', {
        ComponentClass: OuterComponent,
        template: '{{inner-component submit=(action outerSubmit)}}'
      });

      this.render('{{outer-component}}');

      this.runTask(function () {
        innerComponent.fireAction();
      });

      this.assert.equal(returnedValue, expectedValue, 'action can return to caller');
    };

    _class2.prototype['@test action should be called on the correct scope'] = function testActionShouldBeCalledOnTheCorrectScope() {
      var innerComponent = undefined;
      var outerComponent = undefined;
      var actualComponent = undefined;

      var InnerComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          innerComponent = this;
        },
        fireAction: function () {
          this.attrs.submit();
        }
      });

      var OuterComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          outerComponent = this;
        },
        isOuterComponent: true,
        outerSubmit: function () {
          actualComponent = this;
        }
      });

      this.registerComponent('inner-component', {
        ComponentClass: InnerComponent,
        template: 'inner'
      });

      this.registerComponent('outer-component', {
        ComponentClass: OuterComponent,
        template: '{{inner-component submit=(action outerSubmit)}}'
      });

      this.render('{{outer-component}}');

      this.runTask(function () {
        innerComponent.fireAction();
      });

      this.assert.equal(actualComponent, outerComponent, 'action has the correct context');
      this.assert.ok(actualComponent.isOuterComponent, 'action has the correct context');
    };

    _class2.prototype['@test arguments to action are passed, curry'] = function testArgumentsToActionArePassedCurry() {
      var first = 'mitch';
      var second = 'martin';
      var third = 'matt';
      var fourth = 'wacky wycats';

      var innerComponent = undefined;
      var actualArgs = undefined;

      var InnerComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          innerComponent = this;
        },
        fireAction: function () {
          this.attrs.submit(fourth);
        }
      });

      var OuterComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        third: third,
        outerSubmit: function (actualFirst, actualSecond, actualThird, actualFourth) {
          actualArgs = [].concat(babelHelpers.slice.call(arguments));
        }
      });

      this.registerComponent('inner-component', {
        ComponentClass: InnerComponent,
        template: 'inner'
      });

      this.registerComponent('outer-component', {
        ComponentClass: OuterComponent,
        template: '{{inner-component submit=(action (action outerSubmit "' + first + '") "' + second + '" third)}}'
      });

      this.render('{{outer-component}}');

      this.runTask(function () {
        innerComponent.fireAction();
      });

      this.assert.deepEqual(actualArgs, [first, second, third, fourth], 'action has the correct args');
    };

    _class2.prototype['@test `this` can be passed as an argument'] = function testThisCanBePassedAsAnArgument() {
      var value = {};
      var component = undefined;
      var innerComponent = undefined;

      var InnerComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          innerComponent = this;
        },
        fireAction: function () {
          this.attrs.submit();
        }
      });

      var OuterComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          component = this;
        },
        actions: {
          outerAction: function (incomingValue) {
            value = incomingValue;
          }
        }
      });

      this.registerComponent('inner-component', { ComponentClass: InnerComponent, template: 'inner' });
      this.registerComponent('outer-component', {
        ComponentClass: OuterComponent,
        template: '{{inner-component submit=(action "outerAction" this)}}'
      });

      this.render('{{outer-component}}');

      this.runTask(function () {
        innerComponent.fireAction();
      });

      this.assert.strictEqual(value, component, 'the component is passed at `this`');
    };

    _class2.prototype['@test arguments to action are bound'] = function testArgumentsToActionAreBound() {
      var value = 'lazy leah';

      var innerComponent = undefined;
      var outerComponent = undefined;
      var actualArg = undefined;

      var InnerComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          innerComponent = this;
        },
        fireAction: function () {
          this.attrs.submit();
        }
      });

      var OuterComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          outerComponent = this;
        },
        value: '',
        outerSubmit: function (incomingValue) {
          actualArg = incomingValue;
        }
      });

      this.registerComponent('inner-component', {
        ComponentClass: InnerComponent,
        template: 'inner'
      });

      this.registerComponent('outer-component', {
        ComponentClass: OuterComponent,
        template: '{{inner-component submit=(action outerSubmit value)}}'
      });

      this.render('{{outer-component}}');

      this.runTask(function () {
        innerComponent.fireAction();
      });

      this.assert.strictEqual(actualArg, '', 'action has the correct first arg');

      this.runTask(function () {
        outerComponent.set('value', value);
      });

      this.runTask(function () {
        innerComponent.fireAction();
      });

      this.assert.strictEqual(actualArg, value, 'action has the correct first arg');
    };

    _class2.prototype['@test array arguments are passed correctly to action'] = function testArrayArgumentsArePassedCorrectlyToAction() {
      var first = 'foo';
      var second = [3, 5];
      var third = [4, 9];

      var actualFirst = undefined;
      var actualSecond = undefined;
      var actualThird = undefined;

      var innerComponent = undefined;
      var outerComponent = undefined;

      var InnerComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          innerComponent = this;
        },
        fireAction: function () {
          this.attrs.submit(second, third);
        }
      });

      var OuterComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          outerComponent = this;
        },
        outerSubmit: function (incomingFirst, incomingSecond, incomingThird) {
          actualFirst = incomingFirst;
          actualSecond = incomingSecond;
          actualThird = incomingThird;
        }
      });

      this.registerComponent('inner-component', {
        ComponentClass: InnerComponent,
        template: 'inner'
      });

      this.registerComponent('outer-component', {
        ComponentClass: OuterComponent,
        template: '{{inner-component submit=(action outerSubmit first)}}'
      });

      this.render('{{outer-component}}');

      this.runTask(function () {
        outerComponent.set('first', first);
        outerComponent.set('second', second);
      });

      this.runTask(function () {
        innerComponent.fireAction();
      });

      this.assert.equal(actualFirst, first, 'action has the correct first arg');
      this.assert.equal(actualSecond, second, 'action has the correct second arg');
      this.assert.equal(actualThird, third, 'action has the correct third arg');
    };

    _class2.prototype['@test mut values can be wrapped in actions, are settable'] = function testMutValuesCanBeWrappedInActionsAreSettable() {
      var newValue = 'trollin trek';

      var innerComponent = undefined;
      var outerComponent = undefined;

      var InnerComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          innerComponent = this;
        },
        fireAction: function () {
          this.attrs.submit(newValue);
        }
      });

      var OuterComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          outerComponent = this;
        },
        outerMut: 'patient peter'
      });

      this.registerComponent('inner-component', {
        ComponentClass: InnerComponent,
        template: 'inner'
      });

      this.registerComponent('outer-component', {
        ComponentClass: OuterComponent,
        template: '{{inner-component submit=(action (mut outerMut))}}'
      });

      this.render('{{outer-component}}');

      this.runTask(function () {
        innerComponent.fireAction();
      });

      this.assert.equal(outerComponent.get('outerMut'), newValue, 'mut value is set');
    };

    _class2.prototype['@test mut values can be wrapped in actions, are settable with a curry'] = function testMutValuesCanBeWrappedInActionsAreSettableWithACurry() {
      var newValue = 'trollin trek';

      var innerComponent = undefined;
      var outerComponent = undefined;

      var InnerComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          innerComponent = this;
        },
        fireAction: function () {
          this.attrs.submit();
        }
      });

      var OuterComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          outerComponent = this;
        },
        outerMut: 'patient peter'
      });

      this.registerComponent('inner-component', {
        ComponentClass: InnerComponent,
        template: 'inner'
      });

      this.registerComponent('outer-component', {
        ComponentClass: OuterComponent,
        template: '{{inner-component submit=(action (mut outerMut) \'' + newValue + '\')}}'
      });

      this.render('{{outer-component}}');

      this.runTask(function () {
        innerComponent.fireAction();
      });

      this.assert.equal(outerComponent.get('outerMut'), newValue, 'mut value is set');
    };

    _class2.prototype['@test action can create closures over actions'] = function testActionCanCreateClosuresOverActions() {
      var first = 'raging robert';
      var second = 'mild machty';
      var returnValue = 'butch brian';

      var actualFirst = undefined;
      var actualSecond = undefined;
      var actualReturnedValue = undefined;

      var innerComponent = undefined;

      var InnerComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          innerComponent = this;
        },
        fireAction: function () {
          actualReturnedValue = this.attrs.submit(second);
        }
      });

      var OuterComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        actions: {
          outerAction: function (incomingFirst, incomingSecond) {
            actualFirst = incomingFirst;
            actualSecond = incomingSecond;
            return returnValue;
          }
        }
      });

      this.registerComponent('inner-component', {
        ComponentClass: InnerComponent,
        template: 'inner'
      });

      this.registerComponent('outer-component', {
        ComponentClass: OuterComponent,
        template: '{{inner-component submit=(action \'outerAction\' \'' + first + '\')}}'
      });

      this.render('{{outer-component}}');

      this.runTask(function () {
        innerComponent.fireAction();
      });

      this.assert.equal(actualReturnedValue, returnValue, 'return value is present');
      this.assert.equal(actualFirst, first, 'first argument is correct');
      this.assert.equal(actualSecond, second, 'second argument is correct');
    };

    _class2.prototype['@test provides a helpful error if an action is not present'] = function testProvidesAHelpfulErrorIfAnActionIsNotPresent() {
      var _this7 = this;

      var InnerComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({});

      var OuterComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        actions: {
          something: function () {
            // this is present to ensure `actions` hash is present
            // a different error is triggered if `actions` is missing
            // completely
          }
        }
      });

      this.registerComponent('inner-component', {
        ComponentClass: InnerComponent,
        template: 'inner'
      });

      this.registerComponent('outer-component', {
        ComponentClass: OuterComponent,
        template: '{{inner-component submit=(action \'doesNotExist\')}}'
      });

      expectAssertion(function () {
        _this7.render('{{outer-component}}');
      }, /An action named 'doesNotExist' was not found in /);
    };

    _class2.prototype['@test provides a helpful error if actions hash is not present'] = function testProvidesAHelpfulErrorIfActionsHashIsNotPresent() {
      var _this8 = this;

      var InnerComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({});

      var OuterComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({});

      this.registerComponent('inner-component', {
        ComponentClass: InnerComponent,
        template: 'inner'
      });

      this.registerComponent('outer-component', {
        ComponentClass: OuterComponent,
        template: '{{inner-component submit=(action \'doesNotExist\')}}'
      });

      expectAssertion(function () {
        _this8.render('{{outer-component}}');
      }, /An action named 'doesNotExist' was not found in /);
    };

    _class2.prototype['@test action can create closures over actions with target'] = function testActionCanCreateClosuresOverActionsWithTarget() {
      var innerComponent = undefined;
      var actionCalled = false;

      var InnerComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          innerComponent = this;
        },
        fireAction: function () {
          this.attrs.submit();
        }
      });

      var OuterComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        otherComponent: _emberMetal.computed(function () {
          return {
            actions: {
              outerAction: function () {
                actionCalled = true;
              }
            }
          };
        })
      });

      this.registerComponent('inner-component', {
        ComponentClass: InnerComponent,
        template: 'inner'
      });

      this.registerComponent('outer-component', {
        ComponentClass: OuterComponent,
        template: '{{inner-component submit=(action \'outerAction\' target=otherComponent)}}'
      });

      this.render('{{outer-component}}');

      this.runTask(function () {
        innerComponent.fireAction();
      });

      this.assert.ok(actionCalled, 'action called on otherComponent');
    };

    _class2.prototype['@test value can be used with action over actions'] = function testValueCanBeUsedWithActionOverActions() {
      var newValue = 'yelping yehuda';

      var innerComponent = undefined;
      var actualValue = undefined;

      var InnerComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          innerComponent = this;
        },
        fireAction: function () {
          this.attrs.submit({
            readProp: newValue
          });
        }
      });

      var OuterComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        outerContent: {
          readProp: newValue
        },
        actions: {
          outerAction: function (incomingValue) {
            actualValue = incomingValue;
          }
        }
      });

      this.registerComponent('inner-component', {
        ComponentClass: InnerComponent,
        template: 'inner'
      });

      this.registerComponent('outer-component', {
        ComponentClass: OuterComponent,
        template: '{{inner-component submit=(action \'outerAction\' value="readProp")}}'
      });

      this.render('{{outer-component}}');

      this.runTask(function () {
        innerComponent.fireAction();
      });

      this.assert.equal(actualValue, newValue, 'value is read');
    };

    _class2.prototype['@test action will read the value of a first property'] = function testActionWillReadTheValueOfAFirstProperty() {
      var newValue = 'irate igor';

      var innerComponent = undefined;
      var actualValue = undefined;

      var InnerComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          innerComponent = this;
        },
        fireAction: function () {
          this.attrs.submit({
            readProp: newValue
          });
        }
      });

      var OuterComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        outerAction: function (incomingValue) {
          actualValue = incomingValue;
        }
      });

      this.registerComponent('inner-component', {
        ComponentClass: InnerComponent,
        template: 'inner'
      });

      this.registerComponent('outer-component', {
        ComponentClass: OuterComponent,
        template: '{{inner-component submit=(action outerAction value="readProp")}}'
      });

      this.render('{{outer-component}}');

      this.runTask(function () {
        innerComponent.fireAction();
      });

      this.assert.equal(actualValue, newValue, 'property is read');
    };

    _class2.prototype['@test action will read the value of a curried first argument property'] = function testActionWillReadTheValueOfACurriedFirstArgumentProperty() {
      var newValue = 'kissing kris';

      var innerComponent = undefined;
      var actualValue = undefined;

      var InnerComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          innerComponent = this;
        },
        fireAction: function () {
          this.attrs.submit();
        }
      });

      var OuterComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        objectArgument: {
          readProp: newValue
        },
        outerAction: function (incomingValue) {
          actualValue = incomingValue;
        }
      });

      this.registerComponent('inner-component', {
        ComponentClass: InnerComponent,
        template: 'inner'
      });

      this.registerComponent('outer-component', {
        ComponentClass: OuterComponent,
        template: '{{inner-component submit=(action outerAction objectArgument value="readProp")}}'
      });

      this.render('{{outer-component}}');

      this.runTask(function () {
        innerComponent.fireAction();
      });

      this.assert.equal(actualValue, newValue, 'property is read');
    };

    _class2.prototype['@test action closure does not get auto-mut wrapped'] = function testActionClosureDoesNotGetAutoMutWrapped(assert) {
      var first = 'raging robert';
      var second = 'mild machty';
      var returnValue = 'butch brian';

      var innerComponent = undefined;
      var actualFirst = undefined;
      var actualSecond = undefined;
      var actualReturnedValue = undefined;

      var InnerComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          innerComponent = this;
        },
        fireAction: function () {
          this.get('submit')(second);
          this.get('attrs-submit')(second);
          var attrsSubmitReturnValue = this.attrs['attrs-submit'](second);
          var submitReturnValue = this.attrs.submit(second);

          assert.equal(attrsSubmitReturnValue, submitReturnValue, 'both attrs.foo and foo should behave the same');

          return submitReturnValue;
        }
      });

      var MiddleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({});

      var OuterComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        actions: {
          outerAction: function (incomingFirst, incomingSecond) {
            actualFirst = incomingFirst;
            actualSecond = incomingSecond;
            return returnValue;
          }
        }
      });

      this.registerComponent('inner-component', {
        ComponentClass: InnerComponent,
        template: 'inner'
      });

      this.registerComponent('middle-component', {
        ComponentClass: MiddleComponent,
        template: '{{inner-component attrs-submit=attrs.submit submit=submit}}'
      });

      this.registerComponent('outer-component', {
        ComponentClass: OuterComponent,
        template: '{{middle-component submit=(action \'outerAction\' \'' + first + '\')}}'
      });

      this.render('{{outer-component}}');

      this.runTask(function () {
        actualReturnedValue = innerComponent.fireAction();
      });

      this.assert.equal(actualFirst, first, 'first argument is correct');
      this.assert.equal(actualSecond, second, 'second argument is correct');
      this.assert.equal(actualReturnedValue, returnValue, 'return value is present');
    };

    _class2.prototype['@test action should be called within a run loop'] = function testActionShouldBeCalledWithinARunLoop() {
      var innerComponent = undefined;
      var capturedRunLoop = undefined;

      var InnerComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          innerComponent = this;
        },
        fireAction: function () {
          this.attrs.submit();
        }
      });

      var OuterComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        actions: {
          submit: function () {
            capturedRunLoop = _emberMetal.run.currentRunLoop;
          }
        }
      });

      this.registerComponent('inner-component', {
        ComponentClass: InnerComponent,
        template: 'inner'
      });

      this.registerComponent('outer-component', {
        ComponentClass: OuterComponent,
        template: '{{inner-component submit=(action \'submit\')}}'
      });

      this.render('{{outer-component}}');

      this.runTask(function () {
        innerComponent.fireAction();
      });

      this.assert.ok(capturedRunLoop, 'action is called within a run loop');
    };

    _class2.prototype['@test objects that define INVOKE can be casted to actions'] = function testObjectsThatDefineINVOKECanBeCastedToActions() {
      var innerComponent = undefined;
      var actionArgs = undefined;
      var invokableArgs = undefined;

      var InnerComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          innerComponent = this;
        },
        fireAction: function () {
          actionArgs = this.attrs.submit(4, 5, 6);
        }
      });

      var OuterComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        foo: 123,
        submitTask: _emberMetal.computed(function () {
          var _ref,
              _this9 = this;

          return _ref = {}, _ref[_emberGlimmerTestsUtilsHelpers.INVOKE] = function () {
            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
              args[_key] = arguments[_key];
            }

            invokableArgs = args;
            return _this9.foo;
          }, _ref;
        })
      });

      this.registerComponent('inner-component', {
        ComponentClass: InnerComponent,
        template: 'inner'
      });

      this.registerComponent('outer-component', {
        ComponentClass: OuterComponent,
        template: '{{inner-component submit=(action submitTask 1 2 3)}}'
      });

      this.render('{{outer-component}}');

      this.runTask(function () {
        innerComponent.fireAction();
      });

      this.assert.equal(actionArgs, 123);
      this.assert.deepEqual(invokableArgs, [1, 2, 3, 4, 5, 6]);
    };

    _class2.prototype['@test closure action with `(mut undefinedThing)` works properly [GH#13959]'] = function testClosureActionWithMutUndefinedThingWorksProperlyGH13959() {
      var _this10 = this;

      var component = undefined;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        label: undefined,
        init: function () {
          this._super.apply(this, arguments);
          component = this;
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<button onclick={{action (mut label) "Clicked!"}}>{{if label label "Click me"}}</button>'
      });

      this.render('{{example-component}}');

      this.assertText('Click me');

      this.assertStableRerender();

      this.runTask(function () {
        _this10.$('button').click();
      });

      this.assertText('Clicked!');

      this.runTask(function () {
        component.set('label', 'Dun clicked');
      });

      this.assertText('Dun clicked');

      this.runTask(function () {
        _this10.$('button').click();
      });

      this.assertText('Clicked!');

      this.runTask(function () {
        component.set('label', undefined);
      });

      this.assertText('Click me');
    };

    _class2.prototype['@test closure actions does not cause component hooks to fire unnecessarily [GH#14305] [GH#14654]'] = function testClosureActionsDoesNotCauseComponentHooksToFireUnnecessarilyGH14305GH14654(assert) {
      var _this12 = this;

      var clicked = 0;
      var didReceiveAttrsFired = 0;

      var ClickMeComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        tagName: 'button',

        click: function () {
          this.get('onClick').call(undefined, ++clicked);
        },

        didReceiveAttrs: function () {
          didReceiveAttrsFired++;
        }
      });

      this.registerComponent('click-me', {
        ComponentClass: ClickMeComponent
      });

      var outer = undefined;

      var OuterComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        clicked: 0,

        actions: {
          'on-click': function () {
            this.incrementProperty('clicked');
          }
        },

        init: function () {
          var _this11 = this;

          this._super();
          outer = this;
          this.set('onClick', function () {
            return _this11.incrementProperty('clicked');
          });
        }
      });

      this.registerComponent('outer-component', {
        ComponentClass: OuterComponent,
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject)
      });

      this.render('{{outer-component foo=foo}}', { foo: 1 });

      this.assertText('clicked: 0; foo: 1');

      assert.equal(didReceiveAttrsFired, 3);

      this.runTask(function () {
        return _this12.rerender();
      });

      this.assertText('clicked: 0; foo: 1');

      assert.equal(didReceiveAttrsFired, 3);

      this.runTask(function () {
        return _emberMetal.set(_this12.context, 'foo', 2);
      });

      this.assertText('clicked: 0; foo: 2');

      assert.equal(didReceiveAttrsFired, 3);

      this.runTask(function () {
        return _this12.$('#string-action').click();
      });

      this.assertText('clicked: 1; foo: 2');

      assert.equal(didReceiveAttrsFired, 3);

      this.runTask(function () {
        return _this12.$('#function-action').click();
      });

      this.assertText('clicked: 2; foo: 2');

      assert.equal(didReceiveAttrsFired, 3);

      this.runTask(function () {
        return _emberMetal.set(outer, 'onClick', function () {
          outer.incrementProperty('clicked');
        });
      });

      this.assertText('clicked: 2; foo: 2');

      assert.equal(didReceiveAttrsFired, 3);

      this.runTask(function () {
        return _this12.$('#function-action').click();
      });

      this.assertText('clicked: 3; foo: 2');

      assert.equal(didReceiveAttrsFired, 3);

      this.runTask(function () {
        return _this12.$('#mut-action').click();
      });

      this.assertText('clicked: 4; foo: 2');

      assert.equal(didReceiveAttrsFired, 3);
    };

    return _class2;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
});
enifed('ember-glimmer/tests/integration/helpers/concat-test', ['exports', 'ember-glimmer/tests/utils/test-case', 'ember-metal'], function (exports, _emberGlimmerTestsUtilsTestCase, _emberMetal) {
  'use strict';

  _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: {{concat}}', (function (_RenderingTest) {
    babelHelpers.inherits(_class, _RenderingTest);

    function _class() {
      _RenderingTest.apply(this, arguments);
    }

    _class.prototype['@test it concats static arguments'] = function testItConcatsStaticArguments() {
      this.render('{{concat "foo" " " "bar" " " "baz"}}');
      this.assertText('foo bar baz');
    };

    _class.prototype['@test it updates for bound arguments'] = function testItUpdatesForBoundArguments() {
      var _this = this;

      this.render('{{concat model.first model.second}}', {
        model: { first: 'one', second: 'two' }
      });

      this.assertText('onetwo');

      this.runTask(function () {
        return _this.rerender();
      });

      this.assertText('onetwo');

      this.runTask(function () {
        return _emberMetal.set(_this.context, 'model.first', 'three');
      });

      this.assertText('threetwo');

      this.runTask(function () {
        return _emberMetal.set(_this.context, 'model.second', 'four');
      });

      this.assertText('threefour');

      this.runTask(function () {
        return _emberMetal.set(_this.context, 'model', { first: 'one', second: 'two' });
      });

      this.assertText('onetwo');
    };

    _class.prototype['@test it can be used as a sub-expression'] = function testItCanBeUsedAsASubExpression() {
      var _this2 = this;

      this.render('{{concat (concat model.first model.second) (concat model.third model.fourth)}}', {
        model: {
          first: 'one',
          second: 'two',
          third: 'three',
          fourth: 'four'
        }
      });

      this.assertText('onetwothreefour');

      this.runTask(function () {
        return _this2.rerender();
      });

      this.assertText('onetwothreefour');

      this.runTask(function () {
        return _emberMetal.set(_this2.context, 'model.first', 'five');
      });

      this.assertText('fivetwothreefour');

      this.runTask(function () {
        _emberMetal.set(_this2.context, 'model.second', 'six');
        _emberMetal.set(_this2.context, 'model.third', 'seven');
      });

      this.assertText('fivesixsevenfour');

      this.runTask(function () {
        _emberMetal.set(_this2.context, 'model', {
          first: 'one',
          second: 'two',
          third: 'three',
          fourth: 'four'
        });
      });

      this.assertText('onetwothreefour');
    };

    _class.prototype['@test it can be used as input for other helpers'] = function testItCanBeUsedAsInputForOtherHelpers() {
      var _this3 = this;

      this.registerHelper('x-eq', function (_ref) {
        var actual = _ref[0];
        var expected = _ref[1];
        return actual === expected;
      });

      this.render('{{#if (x-eq (concat model.first model.second) "onetwo")}}Truthy!{{else}}False{{/if}}', {
        model: {
          first: 'one',
          second: 'two'
        }
      });

      this.assertText('Truthy!');

      this.runTask(function () {
        return _this3.rerender();
      });

      this.assertText('Truthy!');

      this.runTask(function () {
        return _emberMetal.set(_this3.context, 'model.first', 'three');
      });

      this.assertText('False');

      this.runTask(function () {
        return _emberMetal.set(_this3.context, 'model', { first: 'one', second: 'two' });
      });

      this.assertText('Truthy!');
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
});
enifed('ember-glimmer/tests/integration/helpers/custom-helper-test', ['exports', 'ember-glimmer/tests/utils/test-case', 'ember-glimmer/tests/utils/helpers', 'internal-test-helpers', 'ember-metal', 'ember-utils'], function (exports, _emberGlimmerTestsUtilsTestCase, _emberGlimmerTestsUtilsHelpers, _internalTestHelpers, _emberMetal, _emberUtils) {
  /* globals EmberDev */
  'use strict';

  var assert = QUnit.assert;

  _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: custom helpers', (function (_RenderingTest) {
    babelHelpers.inherits(_class, _RenderingTest);

    function _class() {
      _RenderingTest.apply(this, arguments);
    }

    _class.prototype['@test it cannot override built-in syntax'] = function testItCannotOverrideBuiltInSyntax() {
      var _this = this;

      this.registerHelper('if', function () {
        return 'Nope';
      });
      expectAssertion(function () {
        _this.render('{{if foo \'LOL\'}}', { foo: true });
      }, /You attempted to overwrite the built-in helper \"if\" which is not allowed. Please rename the helper./);
    };

    _class.prototype['@test it can resolve custom simple helpers with or without dashes'] = function testItCanResolveCustomSimpleHelpersWithOrWithoutDashes() {
      var _this2 = this;

      this.registerHelper('hello', function () {
        return 'hello';
      });
      this.registerHelper('hello-world', function () {
        return 'hello world';
      });

      this.render('{{hello}} | {{hello-world}}');

      this.assertText('hello | hello world');

      this.runTask(function () {
        return _this2.rerender();
      });

      this.assertText('hello | hello world');
    };

    _class.prototype['@test it does not resolve helpers with a `.` (period)'] = function testItDoesNotResolveHelpersWithAPeriod() {
      var _this3 = this;

      this.registerHelper('hello.world', function () {
        return 'hello world';
      });

      this.render('{{hello.world}}', {
        hello: {
          world: ''
        }
      });

      this.assertText('');

      this.assertStableRerender();

      this.assertText('');

      this.runTask(function () {
        return _emberMetal.set(_this3.context, 'hello', { world: 'hello world!' });
      });

      this.assertText('hello world!');

      this.runTask(function () {
        _emberMetal.set(_this3.context, 'hello', {
          world: ''
        });
      });

      this.assertText('');
    };

    _class.prototype['@test it can resolve custom makeBoundHelper with or without dashes [DEPRECATED]'] = function testItCanResolveCustomMakeBoundHelperWithOrWithoutDashesDEPRECATED() {
      var _this4 = this;

      expectDeprecation(function () {
        _this4.owner.register('helper:hello', _emberGlimmerTestsUtilsHelpers.makeBoundHelper(function () {
          return 'hello';
        }));
      }, 'Using `Ember.HTMLBars.makeBoundHelper` is deprecated. Please refactor to use `Ember.Helper` or `Ember.Helper.helper`.');

      expectDeprecation(function () {
        _this4.owner.register('helper:hello-world', _emberGlimmerTestsUtilsHelpers.makeBoundHelper(function () {
          return 'hello world';
        }));
      }, 'Using `Ember.HTMLBars.makeBoundHelper` is deprecated. Please refactor to use `Ember.Helper` or `Ember.Helper.helper`.');

      this.render('{{hello}} | {{hello-world}}');

      this.assertText('hello | hello world');

      this.runTask(function () {
        return _this4.rerender();
      });

      this.assertText('hello | hello world');
    };

    _class.prototype['@test it can resolve custom class-based helpers with or without dashes'] = function testItCanResolveCustomClassBasedHelpersWithOrWithoutDashes() {
      var _this5 = this;

      this.registerHelper('hello', {
        compute: function () {
          return 'hello';
        }
      });

      this.registerHelper('hello-world', {
        compute: function () {
          return 'hello world';
        }
      });

      this.render('{{hello}} | {{hello-world}}');

      this.assertText('hello | hello world');

      this.runTask(function () {
        return _this5.rerender();
      });

      this.assertText('hello | hello world');
    };

    _class.prototype['@test throws if `this._super` is not called from `init`'] = function testThrowsIfThis_superIsNotCalledFromInit() {
      var _this6 = this;

      this.registerHelper('hello-world', {
        init: function () {}
      });

      expectAssertion(function () {
        _this6.render('{{hello-world}}');
      }, /You must call `this._super\(...arguments\);` when overriding `init` on a framework object. Please update .* to call `this._super\(...arguments\);` from `init`./);
    };

    _class.prototype['@test class-based helper can recompute a new value'] = function testClassBasedHelperCanRecomputeANewValue() {
      var _this7 = this;

      var destroyCount = 0;
      var computeCount = 0;
      var helper = undefined;

      this.registerHelper('hello-world', {
        init: function () {
          this._super.apply(this, arguments);
          helper = this;
        },
        compute: function () {
          return ++computeCount;
        },
        destroy: function () {
          destroyCount++;
          this._super();
        }
      });

      this.render('{{hello-world}}');

      this.assertText('1');

      this.runTask(function () {
        return _this7.rerender();
      });

      this.assertText('1');

      this.runTask(function () {
        return helper.recompute();
      });

      this.assertText('2');

      assert.strictEqual(destroyCount, 0, 'destroy is not called on recomputation');
    };

    _class.prototype['@test class-based helper with static arguments can recompute a new value'] = function testClassBasedHelperWithStaticArgumentsCanRecomputeANewValue() {
      var _this8 = this;

      var destroyCount = 0;
      var computeCount = 0;
      var helper = undefined;

      this.registerHelper('hello-world', {
        init: function () {
          this._super.apply(this, arguments);
          helper = this;
        },
        compute: function () {
          return ++computeCount;
        },
        destroy: function () {
          destroyCount++;
          this._super();
        }
      });

      this.render('{{hello-world "whut"}}');

      this.assertText('1');

      this.runTask(function () {
        return _this8.rerender();
      });

      this.assertText('1');

      this.runTask(function () {
        return helper.recompute();
      });

      this.assertText('2');

      assert.strictEqual(destroyCount, 0, 'destroy is not called on recomputation');
    };

    _class.prototype['@test helper params can be returned'] = function testHelperParamsCanBeReturned() {
      this.registerHelper('hello-world', function (values) {
        return values;
      });

      this.render('{{#each (hello-world model) as |item|}}({{item}}){{/each}}', {
        model: ['bob']
      });

      this.assertText('(bob)');
    };

    _class.prototype['@test helper hash can be returned'] = function testHelperHashCanBeReturned() {
      this.registerHelper('hello-world', function (_, hash) {
        return hash.model;
      });

      this.render('{{get (hello-world model=model) \'name\'}}', {
        model: { name: 'bob' }
      });

      this.assertText('bob');
    };

    _class.prototype['@test simple helper is called for param changes'] = function testSimpleHelperIsCalledForParamChanges() {
      var _this9 = this;

      var computeCount = 0;

      this.registerHelper('hello-world', function (_ref) {
        var value = _ref[0];

        computeCount++;
        return value + '-value';
      });

      this.render('{{hello-world model.name}}', {
        model: { name: 'bob' }
      });

      this.assertText('bob-value');

      assert.strictEqual(computeCount, 1, 'compute is called exactly 1 time');

      this.runTask(function () {
        return _this9.rerender();
      });

      this.assertText('bob-value');

      assert.strictEqual(computeCount, 1, 'compute is called exactly 1 time');

      this.runTask(function () {
        return _emberMetal.set(_this9.context, 'model.name', 'sal');
      });

      this.assertText('sal-value');

      assert.strictEqual(computeCount, 2, 'compute is called exactly 2 times');

      this.runTask(function () {
        return _emberMetal.set(_this9.context, 'model', { name: 'bob' });
      });

      this.assertText('bob-value');

      assert.strictEqual(computeCount, 3, 'compute is called exactly 3 times');
    };

    _class.prototype['@test class-based helper compute is called for param changes'] = function testClassBasedHelperComputeIsCalledForParamChanges() {
      var _this10 = this;

      var createCount = 0;
      var computeCount = 0;

      this.registerHelper('hello-world', {
        init: function () {
          this._super.apply(this, arguments);
          createCount++;
        },
        compute: function (_ref2) {
          var value = _ref2[0];

          computeCount++;
          return value + '-value';
        }
      });

      this.render('{{hello-world model.name}}', {
        model: { name: 'bob' }
      });

      this.assertText('bob-value');

      assert.strictEqual(computeCount, 1, 'compute is called exactly 1 time');

      this.runTask(function () {
        return _this10.rerender();
      });

      this.assertText('bob-value');

      assert.strictEqual(computeCount, 1, 'compute is called exactly 1 time');

      this.runTask(function () {
        return _emberMetal.set(_this10.context, 'model.name', 'sal');
      });

      this.assertText('sal-value');

      assert.strictEqual(computeCount, 2, 'compute is called exactly 2 times');

      this.runTask(function () {
        return _emberMetal.set(_this10.context, 'model', { name: 'bob' });
      });

      this.assertText('bob-value');

      assert.strictEqual(computeCount, 3, 'compute is called exactly 3 times');
      assert.strictEqual(createCount, 1, 'helper is only created once');
    };

    _class.prototype['@test simple helper receives params, hash'] = function testSimpleHelperReceivesParamsHash() {
      var _this11 = this;

      this.registerHelper('hello-world', function (_params, _hash) {
        return 'params: ' + JSON.stringify(_params) + ', hash: ' + JSON.stringify(_hash);
      });

      this.render('{{hello-world model.name "rich" first=model.age last="sam"}}', {
        model: {
          name: 'bob',
          age: 42
        }
      });

      this.assertText('params: ["bob","rich"], hash: {"first":42,"last":"sam"}');

      this.runTask(function () {
        return _this11.rerender();
      });

      this.assertText('params: ["bob","rich"], hash: {"first":42,"last":"sam"}');

      this.runTask(function () {
        return _emberMetal.set(_this11.context, 'model.name', 'sal');
      });

      this.assertText('params: ["sal","rich"], hash: {"first":42,"last":"sam"}');

      this.runTask(function () {
        return _emberMetal.set(_this11.context, 'model.age', 28);
      });

      this.assertText('params: ["sal","rich"], hash: {"first":28,"last":"sam"}');

      this.runTask(function () {
        return _emberMetal.set(_this11.context, 'model', { name: 'bob', age: 42 });
      });

      this.assertText('params: ["bob","rich"], hash: {"first":42,"last":"sam"}');
    };

    _class.prototype['@test class-based helper receives params, hash'] = function testClassBasedHelperReceivesParamsHash() {
      var _this12 = this;

      this.registerHelper('hello-world', {
        compute: function (_params, _hash) {
          return 'params: ' + JSON.stringify(_params) + ', hash: ' + JSON.stringify(_hash);
        }
      });

      this.render('{{hello-world model.name "rich" first=model.age last="sam"}}', {
        model: {
          name: 'bob',
          age: 42
        }
      });

      this.assertText('params: ["bob","rich"], hash: {"first":42,"last":"sam"}');

      this.runTask(function () {
        return _this12.rerender();
      });

      this.assertText('params: ["bob","rich"], hash: {"first":42,"last":"sam"}');

      this.runTask(function () {
        return _emberMetal.set(_this12.context, 'model.name', 'sal');
      });

      this.assertText('params: ["sal","rich"], hash: {"first":42,"last":"sam"}');

      this.runTask(function () {
        return _emberMetal.set(_this12.context, 'model.age', 28);
      });

      this.assertText('params: ["sal","rich"], hash: {"first":28,"last":"sam"}');

      this.runTask(function () {
        return _emberMetal.set(_this12.context, 'model', { name: 'bob', age: 42 });
      });

      this.assertText('params: ["bob","rich"], hash: {"first":42,"last":"sam"}');
    };

    _class.prototype['@test class-based helper usable in subexpressions'] = function testClassBasedHelperUsableInSubexpressions() {
      var _this13 = this;

      this.registerHelper('join-words', {
        compute: function (params) {
          return params.join(' ');
        }
      });

      this.render('{{join-words "Who"\n                   (join-words "overcomes" "by")\n                   model.reason\n                   (join-words (join-words "hath overcome but" "half"))\n                   (join-words "his" (join-words "foe"))}}', { model: { reason: 'force' } });

      this.assertText('Who overcomes by force hath overcome but half his foe');

      this.runTask(function () {
        return _this13.rerender();
      });

      this.assertText('Who overcomes by force hath overcome but half his foe');

      this.runTask(function () {
        return _emberMetal.set(_this13.context, 'model.reason', 'Nickleback');
      });

      this.assertText('Who overcomes by Nickleback hath overcome but half his foe');

      this.runTask(function () {
        return _emberMetal.set(_this13.context, 'model', { reason: 'force' });
      });

      this.assertText('Who overcomes by force hath overcome but half his foe');
    };

    _class.prototype['@test parameterless helper is usable in subexpressions'] = function testParameterlessHelperIsUsableInSubexpressions() {
      var _this14 = this;

      this.registerHelper('should-show', function () {
        return true;
      });

      this.render('{{#if (should-show)}}true{{/if}}');

      this.assertText('true');

      this.runTask(function () {
        return _this14.rerender();
      });

      this.assertText('true');
    };

    _class.prototype['@test parameterless helper is usable in attributes'] = function testParameterlessHelperIsUsableInAttributes() {
      var _this15 = this;

      this.registerHelper('foo-bar', function () {
        return 'baz';
      });

      this.render('<div data-foo-bar="{{foo-bar}}"></div>');

      this.assertHTML('<div data-foo-bar="baz"></div>');

      this.runTask(function () {
        return _this15.rerender();
      });

      this.assertHTML('<div data-foo-bar="baz"></div>');
    };

    _class.prototype['@test simple helper not usable with a block'] = function testSimpleHelperNotUsableWithABlock() {
      var _this16 = this;

      this.registerHelper('some-helper', function () {});

      expectAssertion(function () {
        _this16.render('{{#some-helper}}{{/some-helper}}');
      }, /Helpers may not be used in the block form/);
    };

    _class.prototype['@test class-based helper not usable with a block'] = function testClassBasedHelperNotUsableWithABlock() {
      var _this17 = this;

      this.registerHelper('some-helper', {
        compute: function () {}
      });

      expectAssertion(function () {
        _this17.render('{{#some-helper}}{{/some-helper}}');
      }, /Helpers may not be used in the block form/);
    };

    _class.prototype['@test simple helper not usable within element'] = function testSimpleHelperNotUsableWithinElement() {
      var _this18 = this;

      this.registerHelper('some-helper', function () {});

      expectAssertion(function () {
        _this18.render('<div {{some-helper}}></div>');
      }, /Helpers may not be used in the element form/);
    };

    _class.prototype['@test class-based helper not usable within element'] = function testClassBasedHelperNotUsableWithinElement() {
      var _this19 = this;

      this.registerHelper('some-helper', {
        compute: function () {}
      });

      expectAssertion(function () {
        _this19.render('<div {{some-helper}}></div>');
      }, /Helpers may not be used in the element form/);
    };

    _class.prototype['@test class-based helper is torn down'] = function testClassBasedHelperIsTornDown() {
      var destroyCalled = 0;

      this.registerHelper('some-helper', {
        destroy: function () {
          destroyCalled++;
          this._super.apply(this, arguments);
        },
        compute: function () {
          return 'must define a compute';
        }
      });

      this.render('{{some-helper}}');

      _internalTestHelpers.runDestroy(this.component);

      assert.strictEqual(destroyCalled, 1, 'destroy called once');
    };

    _class.prototype['@test class-based helper used in subexpression can recompute'] = function testClassBasedHelperUsedInSubexpressionCanRecompute() {
      var _this20 = this;

      var helper = undefined;
      var phrase = 'overcomes by';

      this.registerHelper('dynamic-segment', {
        init: function () {
          this._super.apply(this, arguments);
          helper = this;
        },
        compute: function () {
          return phrase;
        }
      });

      this.registerHelper('join-words', {
        compute: function (params) {
          return params.join(' ');
        }
      });

      this.render('{{join-words "Who"\n                   (dynamic-segment)\n                   "force"\n                   (join-words (join-words "hath overcome but" "half"))\n                   (join-words "his" (join-words "foe"))}}');

      this.assertText('Who overcomes by force hath overcome but half his foe');

      this.runTask(function () {
        return _this20.rerender();
      });

      this.assertText('Who overcomes by force hath overcome but half his foe');

      phrase = 'believes his';

      this.runTask(function () {
        return helper.recompute();
      });

      this.assertText('Who believes his force hath overcome but half his foe');

      phrase = 'overcomes by';

      this.runTask(function () {
        return helper.recompute();
      });

      this.assertText('Who overcomes by force hath overcome but half his foe');
    };

    _class.prototype['@test class-based helper used in subexpression can recompute component'] = function testClassBasedHelperUsedInSubexpressionCanRecomputeComponent() {
      var _this21 = this;

      var helper = undefined;
      var phrase = 'overcomes by';

      this.registerHelper('dynamic-segment', {
        init: function () {
          this._super.apply(this, arguments);
          helper = this;
        },
        compute: function () {
          return phrase;
        }
      });

      this.registerHelper('join-words', {
        compute: function (params) {
          return params.join(' ');
        }
      });

      this.registerComponent('some-component', {
        template: '{{first}} {{second}} {{third}} {{fourth}} {{fifth}}'
      });

      this.render('{{some-component first="Who"\n                   second=(dynamic-segment)\n                   third="force"\n                   fourth=(join-words (join-words "hath overcome but" "half"))\n                   fifth=(join-words "his" (join-words "foe"))}}');

      this.assertText('Who overcomes by force hath overcome but half his foe');

      this.runTask(function () {
        return _this21.rerender();
      });

      this.assertText('Who overcomes by force hath overcome but half his foe');

      phrase = 'believes his';

      this.runTask(function () {
        return helper.recompute();
      });

      this.assertText('Who believes his force hath overcome but half his foe');

      phrase = 'overcomes by';

      this.runTask(function () {
        return helper.recompute();
      });

      this.assertText('Who overcomes by force hath overcome but half his foe');
    };

    _class.prototype['@test class-based helper used in subexpression is destroyed'] = function testClassBasedHelperUsedInSubexpressionIsDestroyed() {
      var destroyCount = 0;

      this.registerHelper('dynamic-segment', {
        phrase: 'overcomes by',
        init: function () {
          this._super.apply(this, arguments);
        },
        compute: function () {
          return this.phrase;
        },
        destroy: function () {
          destroyCount++;
          this._super.apply(this, arguments);
        }
      });

      this.registerHelper('join-words', {
        compute: function (params) {
          return params.join(' ');
        }
      });

      this.render('{{join-words "Who"\n                   (dynamic-segment)\n                   "force"\n                   (join-words (join-words "hath overcome but" "half"))\n                   (join-words "his" (join-words "foe"))}}');

      _internalTestHelpers.runDestroy(this.component);

      equal(destroyCount, 1, 'destroy is called after a view is destroyed');
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));

  // these feature detects prevent errors in these tests
  // on platforms (*cough* IE9 *cough*) that do not
  // property support `Object.freeze`
  var pushingIntoFrozenArrayThrows = (function () {
    var array = [];
    Object.freeze(array);

    try {
      array.push('foo');

      return false;
    } catch (e) {
      return true;
    }
  })();

  var assigningExistingFrozenPropertyThrows = (function () {
    var obj = { foo: 'asdf' };
    Object.freeze(obj);

    try {
      obj.foo = 'derp';

      return false;
    } catch (e) {
      return true;
    }
  })();

  var addingPropertyToFrozenObjectThrows = (function () {
    var obj = { foo: 'asdf' };
    Object.freeze(obj);

    try {
      obj.bar = 'derp';

      return false;
    } catch (e) {
      return true;
    }
  })();

  if (!EmberDev.runningProdBuild && _emberUtils.HAS_NATIVE_WEAKMAP && (pushingIntoFrozenArrayThrows || assigningExistingFrozenPropertyThrows || addingPropertyToFrozenObjectThrows)) {
    (function () {
      var HelperMutatingArgsTests = (function (_RenderingTest2) {
        babelHelpers.inherits(HelperMutatingArgsTests, _RenderingTest2);

        function HelperMutatingArgsTests() {
          _RenderingTest2.apply(this, arguments);
        }

        HelperMutatingArgsTests.prototype.buildCompute = function buildCompute() {
          var _this22 = this;

          return function (params, hash) {
            if (pushingIntoFrozenArrayThrows) {
              _this22.assert.throws(function () {
                params.push('foo');

                // cannot assert error message as it varies by platform
              });
            }

            if (assigningExistingFrozenPropertyThrows) {
              _this22.assert.throws(function () {
                hash.foo = 'bar';

                // cannot assert error message as it varies by platform
              });
            }

            if (addingPropertyToFrozenObjectThrows) {
              _this22.assert.throws(function () {
                hash.someUnusedHashProperty = 'bar';

                // cannot assert error message as it varies by platform
              });
            }
          };
        };

        HelperMutatingArgsTests.prototype['@test cannot mutate params - no positional specified / named specified'] = function testCannotMutateParamsNoPositionalSpecifiedNamedSpecified() {
          this.render('{{test-helper foo=bar}}', { bar: 'derp' });
        };

        HelperMutatingArgsTests.prototype['@test cannot mutate params - positional specified / no named specified'] = function testCannotMutateParamsPositionalSpecifiedNoNamedSpecified() {
          this.render('{{test-helper bar}}', { bar: 'derp' });
        };

        HelperMutatingArgsTests.prototype['@test cannot mutate params - positional specified / named specified'] = function testCannotMutateParamsPositionalSpecifiedNamedSpecified() {
          this.render('{{test-helper bar foo=qux}}', { bar: 'derp', qux: 'baz' });
        };

        HelperMutatingArgsTests.prototype['@test cannot mutate params - no positional specified / no named specified'] = function testCannotMutateParamsNoPositionalSpecifiedNoNamedSpecified() {
          this.render('{{test-helper}}', { bar: 'derp', qux: 'baz' });
        };

        return HelperMutatingArgsTests;
      })(_emberGlimmerTestsUtilsTestCase.RenderingTest);

      _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: mutation triggers errors - class based helper', (function (_HelperMutatingArgsTests) {
        babelHelpers.inherits(_class2, _HelperMutatingArgsTests);

        function _class2() {
          _HelperMutatingArgsTests.call(this);

          var compute = this.buildCompute();

          this.registerHelper('test-helper', {
            compute: compute
          });
        }

        return _class2;
      })(HelperMutatingArgsTests));

      _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: mutation triggers errors - simple helper', (function (_HelperMutatingArgsTests2) {
        babelHelpers.inherits(_class3, _HelperMutatingArgsTests2);

        function _class3() {
          _HelperMutatingArgsTests2.call(this);

          var compute = this.buildCompute();

          this.registerHelper('test-helper', compute);
        }

        return _class3;
      })(HelperMutatingArgsTests));
    })();
  }
});
enifed('ember-glimmer/tests/integration/helpers/debugger-test', ['exports', 'ember-glimmer/tests/utils/test-case', 'ember-glimmer/tests/utils/helpers', 'ember-glimmer/helpers/debugger', 'ember-metal', 'ember-runtime'], function (exports, _emberGlimmerTestsUtilsTestCase, _emberGlimmerTestsUtilsHelpers, _emberGlimmerHelpersDebugger, _emberMetal, _emberRuntime) {
  'use strict';

  // This file is generally not I-N-U-R tested, because the {{debugger}} helper currently
  // does not run during re-render. This is something we eventually want to do, and when
  // we implement that feature these tests should be updated accordingly.

  _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: {{debugger}}', (function (_RenderingTest) {
    babelHelpers.inherits(_class, _RenderingTest);

    function _class() {
      _RenderingTest.apply(this, arguments);
    }

    _class.prototype.teardown = function teardown() {
      _RenderingTest.prototype.teardown.call(this);
      _emberGlimmerHelpersDebugger.resetDebuggerCallback();
    };

    _class.prototype.expectDebuggerCallback = function expectDebuggerCallback(callback, debuggerCallback) {
      var times = arguments.length <= 2 || arguments[2] === undefined ? 1 : arguments[2];

      var called = 0;

      _emberGlimmerHelpersDebugger.setDebuggerCallback(function (context, get) {
        called++;
        debuggerCallback(context, get);
      });

      callback();

      this.assert.strictEqual(called, times, 'Expect debugger callback to be called exactly ' + times + ' time(s)');
    };

    _class.prototype.expectNoDebuggerCallback = function expectNoDebuggerCallback(callback) {
      var called = 0;

      _emberGlimmerHelpersDebugger.setDebuggerCallback(function () {
        return called++;
      });

      callback();

      this.assert.strictEqual(called, 0, 'Expect no debugger callback');
    };

    _class.prototype['@test should have the right context when used in a component layout'] = function testShouldHaveTheRightContextWhenUsedInAComponentLayout(assert) {
      var _this = this;

      var instance = undefined;

      this.registerComponent('my-wrapper', {
        template: '{{yield}}'
      });

      this.registerComponent('foo-bar', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super();
            instance = this;
          }
        }),
        template: '{{debugger}}foo-bar'
      });

      this.expectDebuggerCallback(function () {
        _this.render('{{#my-wrapper}}{{foo-bar}}{{/my-wrapper}}');
      }, function (context) {
        assert.strictEqual(context, instance, 'context should be the component instance');
      });

      this.assertText('foo-bar');

      this.expectNoDebuggerCallback(function () {
        return _this.runTask(function () {
          return _this.rerender();
        });
      });

      this.assertText('foo-bar');
    };

    _class.prototype['@test should have the right context when yielded'] = function testShouldHaveTheRightContextWhenYielded(assert) {
      var _this2 = this;

      var instance = undefined;

      this.registerComponent('my-wrapper', {
        template: '{{yield}}'
      });

      this.registerComponent('foo-bar', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super();
            instance = this;
          }
        }),
        template: '{{#my-wrapper}}{{debugger}}foo-bar{{/my-wrapper}}'
      });

      this.expectDebuggerCallback(function () {
        _this2.render('{{foo-bar}}');
      }, function (context) {
        assert.strictEqual(context, instance, 'context should be the component instance');
      });

      this.assertText('foo-bar');

      this.expectNoDebuggerCallback(function () {
        return _this2.runTask(function () {
          return _this2.rerender();
        });
      });

      this.assertText('foo-bar');
    };

    _class.prototype['@test should be called once per iteration in a loop'] = function testShouldBeCalledOncePerIterationInALoop(assert) {
      var _this3 = this;

      var count = 0;

      _emberGlimmerHelpersDebugger.setDebuggerCallback(function () {
        return count++;
      });

      var items = _emberRuntime.A([1, 2, 3, 4, 5]);

      this.render('{{#each items as |item|}}{{debugger}}[{{item}}]{{/each}}', { items: items });

      this.assertText('[1][2][3][4][5]');

      assert.equal(count, 5, 'should have fired once per iteration');

      count = 0;

      this.runTask(function () {
        return _this3.rerender();
      });

      this.assertText('[1][2][3][4][5]');

      assert.strictEqual(count, 0, 'should not fire for re-render');

      count = 0;

      this.runTask(function () {
        return items.pushObjects([6, 7, 8]);
      });

      this.assertText('[1][2][3][4][5][6][7][8]');

      assert.equal(count, 3, 'should fire once per new items added to the loop');
    };

    _class.prototype['@test could `get` properties from "self"'] = function testCouldGetPropertiesFromSelf(assert) {
      var _this4 = this;

      this.registerComponent('foo-bar', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          init: function () {
            this._super();
            this.zomg = 'zomg';
          }
        }),
        template: '{{debugger not.here}}foo-bar'
      });

      this.expectDebuggerCallback(function () {
        _this4.render('{{foo-bar lol="lol" foo=foo}}', { foo: { bar: { baz: 'fooBarBaz' } } });
      }, function (context, get) {
        assert.equal(get('this'), context, '{{this}}');

        assert.equal(get('lol'), 'lol', '{{lol}}');
        assert.equal(get('this.lol'), 'lol', '{{this.lol}}');

        assert.equal(get('zomg'), 'zomg', '{{zomg}}');
        assert.equal(get('this.zomg'), 'zomg', '{{this.zomg}}');

        assert.equal(get('foo.bar.baz'), 'fooBarBaz', '{{foo.bar.baz}}');
        assert.equal(get('this.foo.bar.baz'), 'fooBarBaz', '{{this.foo.bar.baz}}');

        assert.strictEqual(get('nope'), undefined, '{{nope}}');
        assert.strictEqual(get('this.nope'), undefined, '{{this.nope}}');

        assert.strictEqual(get('not.here'), undefined, '{{not.here}}');
        assert.strictEqual(get('this.not.here'), undefined, '{{this.not.here}}');
      });

      this.assertText('foo-bar');

      this.expectNoDebuggerCallback(function () {
        return _this4.runTask(function () {
          return _this4.rerender();
        });
      });

      this.assertText('foo-bar');
    };

    _class.prototype['@test could `get` local variables'] = function testCouldGetLocalVariables(assert) {
      var _this5 = this;

      var obj = {
        foo: 'foo',
        bar: { baz: { bat: 'barBazBat' } }
      };

      this.expectDebuggerCallback(function () {
        _this5.render('{{#each-in obj as |key value|}}{{debugger}}[{{key}}]{{/each-in}}', { obj: obj });
      }, function (context, get) {
        assert.equal(get('this'), context, '{{this}}');

        assert.equal(get('obj'), obj);

        // Glimmer bug:
        // assert.strictEqual(get('this.key'), undefined, '{{this.key}}');
        // assert.strictEqual(get('this.value'), undefined, '{{this.value}}');

        var key = get('key');

        if (key === 'foo') {
          assert.equal(get('value'), 'foo', '{{value}} for key=foo');
          assert.strictEqual(get('value.baz.bat'), undefined, '{{value.baz.bat}} for key=foo');
          assert.strictEqual(get('value.nope'), undefined, '{{value.nope}} for key=foo');
        } else if (key === 'bar') {
          assert.equal(get('value'), obj.bar, '{{value}} for key=bar');
          assert.equal(get('value.baz.bat'), 'barBazBat', '{{value.baz.bat}} for key=bar');
          assert.strictEqual(get('value.nope'), undefined, '{{value.nope}} for key=bar');
        } else {
          assert.ok(false, 'Unknown key: ' + key);
        }
      }, 2);

      this.assertText('[foo][bar]');

      this.expectNoDebuggerCallback(function () {
        return _this5.runTask(function () {
          return _this5.rerender();
        });
      });

      this.assertText('[foo][bar]');

      this.expectDebuggerCallback(function () {
        _this5.runTask(function () {
          return _emberMetal.set(obj, 'baz', 'baz');
        });
      }, function (context, get) {
        assert.equal(get('this'), context, '{{this}}');

        assert.equal(get('obj'), obj);

        assert.strictEqual(get('this.key'), undefined, '{{this.key}}');
        assert.strictEqual(get('this.value'), undefined, '{{this.value}}');

        assert.equal(get('key'), 'baz', '{{key}} for key=baz');
        assert.equal(get('value'), 'baz', '{{value}} for key=baz');
        assert.strictEqual(get('value.baz.bat'), undefined, '{{value.baz.bat}} for key=baz');
        assert.strictEqual(get('value.nope'), undefined, '{{value.nope}} for key=baz');
      });

      this.assertText('[foo][bar][baz]');

      this.expectNoDebuggerCallback(function () {
        return _this5.runTask(function () {
          return _this5.rerender();
        });
      });

      this.assertText('[foo][bar][baz]');
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
});
enifed('ember-glimmer/tests/integration/helpers/element-action-test', ['exports', 'ember-glimmer/tests/utils/test-case', 'ember-glimmer/tests/utils/abstract-test-case', 'ember-glimmer/tests/utils/helpers', 'ember-metal', 'ember-runtime', 'ember-views'], function (exports, _emberGlimmerTestsUtilsTestCase, _emberGlimmerTestsUtilsAbstractTestCase, _emberGlimmerTestsUtilsHelpers, _emberMetal, _emberRuntime, _emberViews) {
  'use strict';

  var _templateObject = babelHelpers.taggedTemplateLiteralLoose(['\n        {{#inner-component}}\n          <button {{action "wat"}}>Wat me!</button>\n        {{/inner-component}}\n      '], ['\n        {{#inner-component}}\n          <button {{action "wat"}}>Wat me!</button>\n        {{/inner-component}}\n      ']),
      _templateObject2 = babelHelpers.taggedTemplateLiteralLoose(['\n          {{#target-component as |parent|}}\n            {{other-component anotherTarget=parent}}\n          {{/target-component}}\n        '], ['\n          {{#target-component as |parent|}}\n            {{other-component anotherTarget=parent}}\n          {{/target-component}}\n        ']),
      _templateObject3 = babelHelpers.taggedTemplateLiteralLoose(['\n        {{#target-component as |aTarget|}}\n          <a id="edit" href="#" {{action "edit" this target=aTarget}}>click me</a>\n        {{/target-component}}\n        '], ['\n        {{#target-component as |aTarget|}}\n          <a id="edit" href="#" {{action "edit" this target=aTarget}}>click me</a>\n        {{/target-component}}\n        ']),
      _templateObject4 = babelHelpers.taggedTemplateLiteralLoose(['\n        <a href="#"\n          {{action "clicked" on="click"}}\n          {{action "doubleClicked" on="doubleClick"}}\n        >click me</a>'], ['\n        <a href="#"\n          {{action "clicked" on="click"}}\n          {{action "doubleClicked" on="doubleClick"}}\n        >click me</a>']),
      _templateObject5 = babelHelpers.taggedTemplateLiteralLoose(['\n        {{#middle-component}}\n          {{inner-component action="hey"}}\n        {{/middle-component}}\n      '], ['\n        {{#middle-component}}\n          {{inner-component action="hey"}}\n        {{/middle-component}}\n      ']),
      _templateObject6 = babelHelpers.taggedTemplateLiteralLoose(['\n        <button>Click Me</button>\n        {{yield}}\n      '], ['\n        <button>Click Me</button>\n        {{yield}}\n      ']);

  function getActionAttributes(element) {
    var attributes = element.attributes;
    var actionAttrs = [];

    for (var i = 0; i < attributes.length; i++) {
      var attr = attributes.item(i);

      if (attr.name.indexOf('data-ember-action-') === 0) {
        actionAttrs.push(attr.name);
      }
    }

    return actionAttrs;
  }

  function getActionIds(element) {
    return getActionAttributes(element).map(function (attribute) {
      return attribute.slice('data-ember-action-'.length);
    });
  }

  if (false) {
    _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: element action instrumentation', (function (_RenderingTest) {
babelHelpers.inherits(_class, _RenderingTest);

      function _class() {
        _RenderingTest.apply(this, arguments);
      }

      _class.prototype.teardown = function teardown() {
        _RenderingTest.prototype.teardown.call(this);
        _emberMetal.instrumentationReset();
      };

      _class.prototype['@test action should fire interaction event with proper params'] = function testActionShouldFireInteractionEventWithProperParams() {
        var _this = this;

        var subscriberCallCount = 0;
        var subscriberPayload = null;

        var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
          actions: {
            foo: function () {}
          }
        });

        this.registerComponent('example-component', {
          ComponentClass: ExampleComponent,
          template: '<button {{action "foo" "bar"}}>Click me</button>'
        });

        _emberMetal.instrumentationSubscribe('interaction.ember-action', {
          before: function () {
            subscriberCallCount++;
          },
          after: function (name, time, payload) {
            subscriberPayload = payload;
          }
        });

        this.render('{{example-component}}');

        this.assert.equal(subscriberCallCount, 0, 'subscriber has not been called');

        this.runTask(function () {
          return _this.rerender();
        });

        this.assert.equal(subscriberCallCount, 0, 'subscriber has not been called');

        this.runTask(function () {
          _this.$('button').click();
        });

        this.assert.equal(subscriberCallCount, 1, 'subscriber has been called 1 time');
        this.assert.equal(subscriberPayload.name, 'foo', 'subscriber called with correct name');
        this.assert.equal(subscriberPayload.args[0], 'bar', 'subscriber called with correct args');
      };

      return _class;
    })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
  }

  _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: element action', (function (_RenderingTest2) {
babelHelpers.inherits(_class2, _RenderingTest2);

    function _class2() {
      _RenderingTest2.apply(this, arguments);
    }

    _class2.prototype['@test it can call an action on its enclosing component'] = function testItCanCallAnActionOnItsEnclosingComponent() {
      var _this2 = this;

      var fooCallCount = 0;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        actions: {
          foo: function () {
            fooCallCount++;
          }
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<button {{action "foo"}}>Click me</button>'
      });

      this.render('{{example-component}}');

      this.assert.equal(fooCallCount, 0, 'foo has not been called');

      this.runTask(function () {
        return _this2.rerender();
      });

      this.assert.equal(fooCallCount, 0, 'foo has not been called');

      this.runTask(function () {
        _this2.$('button').click();
      });

      this.assert.equal(fooCallCount, 1, 'foo has been called 1 time');

      this.runTask(function () {
        _this2.$('button').click();
      });

      this.assert.equal(fooCallCount, 2, 'foo has been called 2 times');
    };

    _class2.prototype['@test it can call an action with parameters'] = function testItCanCallAnActionWithParameters() {
      var _this3 = this;

      var fooArgs = [];
      var component = undefined;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        member: 'a',
        init: function () {
          this._super.apply(this, arguments);
          component = this;
        },
        actions: {
          foo: function (thing) {
            fooArgs.push(thing);
          }
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<button {{action "foo" member}}>Click me</button>'
      });

      this.render('{{example-component}}');

      this.assert.deepEqual(fooArgs, [], 'foo has not been called');

      this.runTask(function () {
        return _this3.rerender();
      });

      this.assert.deepEqual(fooArgs, [], 'foo has not been called');

      this.runTask(function () {
        _this3.$('button').click();
      });

      this.assert.deepEqual(fooArgs, ['a'], 'foo has not been called');

      this.runTask(function () {
        component.set('member', 'b');
      });

      this.runTask(function () {
        _this3.$('button').click();
      });

      this.assert.deepEqual(fooArgs, ['a', 'b'], 'foo has been called with an updated value');
    };

    _class2.prototype['@test it should output a marker attribute with a guid'] = function testItShouldOutputAMarkerAttributeWithAGuid() {
      this.render('<button {{action "show"}}>me the money</button>');

      var button = this.$('button');

      var attributes = getActionAttributes(button.get(0));

      this.assert.ok(button.attr('data-ember-action').match(''), 'An empty data-ember-action attribute was added');
      this.assert.ok(attributes[0].match(/data-ember-action-\d+/), 'A data-ember-action-xyz attribute with a guid was added');
    };

    _class2.prototype['@test it should allow alternative events to be handled'] = function testItShouldAllowAlternativeEventsToBeHandled() {
      var _this4 = this;

      var showCalled = false;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        actions: {
          show: function () {
            showCalled = true;
          }
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<div id="show" {{action "show" on="mouseUp"}}></div>'
      });

      this.render('{{example-component}}');

      this.runTask(function () {
        var event = _emberViews.jQuery.Event('mouseup');
        _this4.$('#show').trigger(event);
      });

      this.assert.ok(showCalled, 'show action was called on mouseUp');
    };

    _class2.prototype['@test inside a yield, the target points at the original target'] = function testInsideAYieldTheTargetPointsAtTheOriginalTarget() {
      var _this5 = this;

      var targetWatted = false;
      var innerWatted = false;

      var TargetComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        actions: {
          wat: function () {
            targetWatted = true;
          }
        }
      });

      var InnerComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        actions: {
          wat: function () {
            innerWatted = true;
          }
        }
      });

      this.registerComponent('inner-component', {
        ComponentClass: InnerComponent,
        template: '{{yield}}'
      });

      this.registerComponent('target-component', {
        ComponentClass: TargetComponent,
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject)
      });

      this.render('{{target-component}}');

      this.runTask(function () {
        _this5.$('button').click();
      });

      this.assert.ok(targetWatted, 'the correct target was watted');
      this.assert.notOk(innerWatted, 'the inner target was not watted');
    };

    _class2.prototype['@test it should allow a target to be specified'] = function testItShouldAllowATargetToBeSpecified() {
      var _this6 = this;

      var targetWatted = false;

      var TargetComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        actions: {
          wat: function () {
            targetWatted = true;
          }
        }
      });

      var OtherComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({});

      this.registerComponent('target-component', {
        ComponentClass: TargetComponent,
        template: '{{yield this}}'
      });

      this.registerComponent('other-component', {
        ComponentClass: OtherComponent,
        template: '<a {{action "wat" target=anotherTarget}}>Wat?</a>'
      });

      this.render(_emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject2));

      this.runTask(function () {
        _this6.$('a').click();
      });

      this.assert.equal(targetWatted, true, 'the specified target was watted');
    };

    _class2.prototype['@test it should lazily evaluate the target'] = function testItShouldLazilyEvaluateTheTarget() {
      var _this7 = this;

      var firstEdit = 0;
      var secondEdit = 0;
      var component = undefined;

      var first = {
        edit: function () {
          firstEdit++;
        }
      };

      var second = {
        edit: function () {
          secondEdit++;
        }
      };

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          component = this;
        },
        theTarget: first
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<a {{action "edit" target=theTarget}}>Edit</a>'
      });

      this.render('{{example-component}}');

      this.runTask(function () {
        _this7.$('a').click();
      });

      this.assert.equal(firstEdit, 1);

      this.runTask(function () {
        _emberMetal.set(component, 'theTarget', second);
      });

      this.runTask(function () {
        _this7.$('a').click();
      });

      this.assert.equal(firstEdit, 1);
      this.assert.equal(secondEdit, 1);
    };

    _class2.prototype['@test it should register an event handler'] = function testItShouldRegisterAnEventHandler() {
      var _this8 = this;

      var editHandlerWasCalled = false;
      var shortcutHandlerWasCalled = false;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        actions: {
          edit: function () {
            editHandlerWasCalled = true;
          },
          shortcut: function () {
            shortcutHandlerWasCalled = true;
          }
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<a href="#" {{action "edit" allowedKeys="alt"}}>click me</a> <div {{action "shortcut" allowedKeys="any"}}>click me too</div>'
      });

      this.render('{{example-component}}');

      this.runTask(function () {
        var event = _emberViews.jQuery.Event('click');
        event.altKey = true;
        _this8.$('a[data-ember-action]').trigger(event);
      });

      this.assert.equal(editHandlerWasCalled, true, 'the event handler was called');

      this.runTask(function () {
        var event = _emberViews.jQuery.Event('click');
        event.ctrlKey = true;
        _this8.$('div[data-ember-action]').trigger(event);
      });

      this.assert.equal(shortcutHandlerWasCalled, true, 'the "any" shortcut\'s event handler was called');
    };

    _class2.prototype['@test it handles whitelisted bound modifier keys'] = function testItHandlesWhitelistedBoundModifierKeys() {
      var _this9 = this;

      var editHandlerWasCalled = false;
      var shortcutHandlerWasCalled = false;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        altKey: 'alt',
        anyKey: 'any',
        actions: {
          edit: function () {
            editHandlerWasCalled = true;
          },
          shortcut: function () {
            shortcutHandlerWasCalled = true;
          }
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<a href="#" {{action "edit" allowedKeys=altKey}}>click me</a> <div {{action "shortcut" allowedKeys=anyKey}}>click me too</div>'
      });

      this.render('{{example-component}}');

      this.runTask(function () {
        var event = _emberViews.jQuery.Event('click');
        event.altKey = true;
        _this9.$('a[data-ember-action]').trigger(event);
      });

      this.assert.equal(editHandlerWasCalled, true, 'the event handler was called');

      this.runTask(function () {
        var event = _emberViews.jQuery.Event('click');
        event.ctrlKey = true;
        _this9.$('div[data-ember-action]').trigger(event);
      });

      this.assert.equal(shortcutHandlerWasCalled, true, 'the "any" shortcut\'s event handler was called');
    };

    _class2.prototype['@test it handles whitelisted bound modifier keys with current value'] = function testItHandlesWhitelistedBoundModifierKeysWithCurrentValue() {
      var _this10 = this;

      var editHandlerWasCalled = false;
      var component = undefined;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          component = this;
        },
        acceptedKeys: 'alt',
        actions: {
          edit: function () {
            editHandlerWasCalled = true;
          }
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<a href="#" {{action "edit" allowedKeys=acceptedKeys}}>click me</a>'
      });

      this.render('{{example-component}}');

      this.runTask(function () {
        var event = _emberViews.jQuery.Event('click');
        event.altKey = true;
        _this10.$('a[data-ember-action]').trigger(event);
      });

      this.assert.equal(editHandlerWasCalled, true, 'the event handler was called');

      editHandlerWasCalled = false;

      this.runTask(function () {
        component.set('acceptedKeys', '');
      });

      this.runTask(function () {
        var event = _emberViews.jQuery.Event('click');
        _this10.$('div[data-ember-action]').trigger(event);
      });

      this.assert.equal(editHandlerWasCalled, false, 'the event handler was not called');
    };

    _class2.prototype['@test should be able to use action more than once for the same event within a view'] = function testShouldBeAbleToUseActionMoreThanOnceForTheSameEventWithinAView() {
      var _this11 = this;

      var editHandlerWasCalled = false;
      var deleteHandlerWasCalled = false;
      var originalHandlerWasCalled = false;
      var component = undefined;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          component = this;
        },
        actions: {
          edit: function () {
            editHandlerWasCalled = true;
          },
          'delete': function () {
            deleteHandlerWasCalled = true;
          }
        },
        click: function () {
          originalHandlerWasCalled = true;
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<a id="edit" href="#" {{action "edit"}}>edit</a><a id="delete" href="#" {{action "delete"}}>delete</a>'
      });

      this.render('{{example-component}}');

      this.runTask(function () {
        _this11.$('#edit').click();
      });

      this.assert.equal(editHandlerWasCalled, true, 'the edit action was called');
      this.assert.equal(deleteHandlerWasCalled, false, 'the delete action was not called');
      this.assert.equal(originalHandlerWasCalled, true, 'the click handler was called (due to bubbling)');

      editHandlerWasCalled = deleteHandlerWasCalled = originalHandlerWasCalled = false;

      this.runTask(function () {
        _this11.$('#delete').click();
      });

      this.assert.equal(editHandlerWasCalled, false, 'the edit action was not called');
      this.assert.equal(deleteHandlerWasCalled, true, 'the delete action was called');
      this.assert.equal(originalHandlerWasCalled, true, 'the click handler was called (due to bubbling)');

      editHandlerWasCalled = deleteHandlerWasCalled = originalHandlerWasCalled = false;

      this.runTask(function () {
        component.$().click();
      });

      this.assert.equal(editHandlerWasCalled, false, 'the edit action was not called');
      this.assert.equal(deleteHandlerWasCalled, false, 'the delete action was not called');
      this.assert.equal(originalHandlerWasCalled, true, 'the click handler was called');
    };

    _class2.prototype['@test the event should not bubble if `bubbles=false` is passed'] = function testTheEventShouldNotBubbleIfBubblesFalseIsPassed() {
      var _this12 = this;

      var editHandlerWasCalled = false;
      var deleteHandlerWasCalled = false;
      var originalHandlerWasCalled = false;
      var component = undefined;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          component = this;
        },
        actions: {
          edit: function () {
            editHandlerWasCalled = true;
          },
          'delete': function () {
            deleteHandlerWasCalled = true;
          }
        },
        click: function () {
          originalHandlerWasCalled = true;
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<a id="edit" href="#" {{action "edit" bubbles=false}}>edit</a><a id="delete" href="#" {{action "delete" bubbles=false}}>delete</a>'
      });

      this.render('{{example-component}}');

      this.runTask(function () {
        _this12.$('#edit').click();
      });

      this.assert.equal(editHandlerWasCalled, true, 'the edit action was called');
      this.assert.equal(deleteHandlerWasCalled, false, 'the delete action was not called');
      this.assert.equal(originalHandlerWasCalled, false, 'the click handler was not called');

      editHandlerWasCalled = deleteHandlerWasCalled = originalHandlerWasCalled = false;

      this.runTask(function () {
        _this12.$('#delete').click();
      });

      this.assert.equal(editHandlerWasCalled, false, 'the edit action was not called');
      this.assert.equal(deleteHandlerWasCalled, true, 'the delete action was called');
      this.assert.equal(originalHandlerWasCalled, false, 'the click handler was not called');

      editHandlerWasCalled = deleteHandlerWasCalled = originalHandlerWasCalled = false;

      this.runTask(function () {
        component.$().click();
      });

      this.assert.equal(editHandlerWasCalled, false, 'the edit action was not called');
      this.assert.equal(deleteHandlerWasCalled, false, 'the delete action was not called');
      this.assert.equal(originalHandlerWasCalled, true, 'the click handler was called');
    };

    _class2.prototype['@test the event should not bubble if `bubbles=false` is passed bound'] = function testTheEventShouldNotBubbleIfBubblesFalseIsPassedBound() {
      var _this13 = this;

      var editHandlerWasCalled = false;
      var deleteHandlerWasCalled = false;
      var originalHandlerWasCalled = false;
      var component = undefined;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          component = this;
        },
        isFalse: false,
        actions: {
          edit: function () {
            editHandlerWasCalled = true;
          },
          'delete': function () {
            deleteHandlerWasCalled = true;
          }
        },
        click: function () {
          originalHandlerWasCalled = true;
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<a id="edit" href="#" {{action "edit" bubbles=isFalse}}>edit</a><a id="delete" href="#" {{action "delete" bubbles=isFalse}}>delete</a>'
      });

      this.render('{{example-component}}');

      this.runTask(function () {
        _this13.$('#edit').click();
      });

      this.assert.equal(editHandlerWasCalled, true, 'the edit action was called');
      this.assert.equal(deleteHandlerWasCalled, false, 'the delete action was not called');
      this.assert.equal(originalHandlerWasCalled, false, 'the click handler was not called');

      editHandlerWasCalled = deleteHandlerWasCalled = originalHandlerWasCalled = false;

      this.runTask(function () {
        _this13.$('#delete').click();
      });

      this.assert.equal(editHandlerWasCalled, false, 'the edit action was not called');
      this.assert.equal(deleteHandlerWasCalled, true, 'the delete action was called');
      this.assert.equal(originalHandlerWasCalled, false, 'the click handler was not called');

      editHandlerWasCalled = deleteHandlerWasCalled = originalHandlerWasCalled = false;

      this.runTask(function () {
        component.$().click();
      });

      this.assert.equal(editHandlerWasCalled, false, 'the edit action was not called');
      this.assert.equal(deleteHandlerWasCalled, false, 'the delete action was not called');
      this.assert.equal(originalHandlerWasCalled, true, 'the click handler was called');
    };

    _class2.prototype['@test the bubbling depends on the bound parameter'] = function testTheBubblingDependsOnTheBoundParameter() {
      var _this14 = this;

      var editHandlerWasCalled = false;
      var originalHandlerWasCalled = false;
      var component = undefined;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          component = this;
        },
        shouldBubble: false,
        actions: {
          edit: function () {
            editHandlerWasCalled = true;
          }
        },
        click: function () {
          originalHandlerWasCalled = true;
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<a id="edit" href="#" {{action "edit" bubbles=shouldBubble}}>edit</a>'
      });

      this.render('{{example-component}}');

      this.runTask(function () {
        _this14.$('#edit').click();
      });

      this.assert.equal(editHandlerWasCalled, true, 'the edit action was called');
      this.assert.equal(originalHandlerWasCalled, false, 'the click handler was not called');

      editHandlerWasCalled = originalHandlerWasCalled = false;

      this.runTask(function () {
        component.set('shouldBubble', true);
      });

      this.runTask(function () {
        _this14.$('#edit').click();
      });

      this.assert.equal(editHandlerWasCalled, true, 'the edit action was called');
      this.assert.equal(originalHandlerWasCalled, true, 'the click handler was called');
    };

    _class2.prototype['@test it should work properly in an #each block'] = function testItShouldWorkProperlyInAnEachBlock() {
      var _this15 = this;

      var editHandlerWasCalled = false;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        items: _emberRuntime.A([1, 2, 3, 4]),
        actions: {
          edit: function () {
            editHandlerWasCalled = true;
          }
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '{{#each items as |item|}}<a href="#" {{action "edit"}}>click me</a>{{/each}}'
      });

      this.render('{{example-component}}');

      this.runTask(function () {
        _this15.$('a').click();
      });

      this.assert.equal(editHandlerWasCalled, true, 'the event handler was called');
    };

    _class2.prototype['@test it should work properly in a {{#with foo as |bar|}} block'] = function testItShouldWorkProperlyInAWithFooAsBarBlock() {
      var _this16 = this;

      var editHandlerWasCalled = false;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        something: { ohai: 'there' },
        actions: {
          edit: function () {
            editHandlerWasCalled = true;
          }
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '{{#with something as |somethingElse|}}<a href="#" {{action "edit"}}>click me</a>{{/with}}'
      });

      this.render('{{example-component}}');

      this.runTask(function () {
        _this16.$('a').click();
      });

      this.assert.equal(editHandlerWasCalled, true, 'the event handler was called');
    };

    _class2.prototype['@test it should unregister event handlers when an element action is removed'] = function testItShouldUnregisterEventHandlersWhenAnElementActionIsRemoved() {
      var _this17 = this;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        actions: {
          edit: function () {}
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '{{#if isActive}}<a href="#" {{action "edit"}}>click me</a>{{/if}}'
      });

      this.render('{{example-component isActive=isActive}}', { isActive: true });

      equal(this.$('a[data-ember-action]').length, 1, 'The element is rendered');

      var actionId = undefined;

      actionId = getActionIds(this.$('a[data-ember-action]').get(0))[0];

      ok(_emberViews.ActionManager.registeredActions[actionId], 'An action is registered');

      this.runTask(function () {
        return _this17.rerender();
      });

      equal(this.$('a[data-ember-action]').length, 1, 'The element is still present');

      ok(_emberViews.ActionManager.registeredActions[actionId], 'The action is still registered');

      this.runTask(function () {
        return _emberMetal.set(_this17.context, 'isActive', false);
      });

      strictEqual(this.$('a[data-ember-action]').length, 0, 'The element is removed');

      ok(!_emberViews.ActionManager.registeredActions[actionId], 'The action is unregistered');

      this.runTask(function () {
        return _emberMetal.set(_this17.context, 'isActive', true);
      });

      equal(this.$('a[data-ember-action]').length, 1, 'The element is rendered');

      actionId = getActionIds(this.$('a[data-ember-action]').get(0))[0];

      ok(_emberViews.ActionManager.registeredActions[actionId], 'A new action is registered');
    };

    _class2.prototype['@test it should capture events from child elements and allow them to trigger the action'] = function testItShouldCaptureEventsFromChildElementsAndAllowThemToTriggerTheAction() {
      var _this18 = this;

      var editHandlerWasCalled = false;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        actions: {
          edit: function () {
            editHandlerWasCalled = true;
          }
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<div {{action "edit"}}><button>click me</button></div>'
      });

      this.render('{{example-component}}');

      this.runTask(function () {
        _this18.$('button').click();
      });

      this.assert.ok(editHandlerWasCalled, 'event on a child target triggered the action of its parent');
    };

    _class2.prototype['@test it should allow bubbling of events from action helper to original parent event'] = function testItShouldAllowBubblingOfEventsFromActionHelperToOriginalParentEvent() {
      var _this19 = this;

      var editHandlerWasCalled = false;
      var originalHandlerWasCalled = false;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        actions: {
          edit: function () {
            editHandlerWasCalled = true;
          }
        },
        click: function () {
          originalHandlerWasCalled = true;
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<a href="#" {{action "edit"}}>click me</a>'
      });

      this.render('{{example-component}}');

      this.runTask(function () {
        _this19.$('a').click();
      });

      this.assert.ok(editHandlerWasCalled && originalHandlerWasCalled, 'both event handlers were called');
    };

    _class2.prototype['@test it should not bubble an event from action helper to original parent event if `bubbles=false` is passed'] = function testItShouldNotBubbleAnEventFromActionHelperToOriginalParentEventIfBubblesFalseIsPassed() {
      var _this20 = this;

      var editHandlerWasCalled = false;
      var originalHandlerWasCalled = false;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        actions: {
          edit: function () {
            editHandlerWasCalled = true;
          }
        },
        click: function () {
          originalHandlerWasCalled = true;
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<a href="#" {{action "edit" bubbles=false}}>click me</a>'
      });

      this.render('{{example-component}}');

      this.runTask(function () {
        _this20.$('a').click();
      });

      this.assert.ok(editHandlerWasCalled, 'the child event handler was called');
      this.assert.notOk(originalHandlerWasCalled, 'the parent handler was not called');
    };

    _class2.prototype['@test it should allow "send" as the action name (#594)'] = function testItShouldAllowSendAsTheActionName594() {
      var _this21 = this;

      var sendHandlerWasCalled = false;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        actions: {
          send: function () {
            sendHandlerWasCalled = true;
          }
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<a href="#" {{action "send"}}>click me</a>'
      });

      this.render('{{example-component}}');

      this.runTask(function () {
        _this21.$('a').click();
      });

      this.assert.ok(sendHandlerWasCalled, 'the event handler was called');
    };

    _class2.prototype['@test it should send the view, event, and current context to the action'] = function testItShouldSendTheViewEventAndCurrentContextToTheAction() {
      var _this22 = this;

      var passedTarget = undefined;
      var passedContext = undefined;
      var targetThis = undefined;

      var TargetComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          targetThis = this;
        },
        actions: {
          edit: function (context) {
            passedTarget = this === targetThis;
            passedContext = context;
          }
        }
      });

      var aContext = undefined;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          aContext = this;
        }
      });

      this.registerComponent('target-component', {
        ComponentClass: TargetComponent,
        template: '{{yield this}}'
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject3)
      });

      this.render('{{example-component}}');

      this.runTask(function () {
        _this22.$('#edit').click();
      });

      this.assert.ok(passedTarget, 'the action is called with the target as this');
      this.assert.strictEqual(passedContext, aContext, 'the parameter is passed along');
    };

    _class2.prototype['@test it should only trigger actions for the event they were registered on'] = function testItShouldOnlyTriggerActionsForTheEventTheyWereRegisteredOn() {
      var _this23 = this;

      var editHandlerWasCalled = false;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        actions: {
          edit: function () {
            editHandlerWasCalled = true;
          }
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<a href="#" {{action "edit"}}>click me</a>'
      });

      this.render('{{example-component}}');

      this.runTask(function () {
        _this23.$('a').click();
      });

      this.assert.ok(editHandlerWasCalled, 'the event handler was called on click');

      editHandlerWasCalled = false;

      this.runTask(function () {
        _this23.$('a').trigger('mouseover');
      });

      this.assert.notOk(editHandlerWasCalled, 'the event handler was not called on mouseover');
    };

    _class2.prototype['@test it should allow multiple contexts to be specified'] = function testItShouldAllowMultipleContextsToBeSpecified() {
      var _this24 = this;

      var passedContexts = undefined;
      var models = [_emberRuntime.Object.create(), _emberRuntime.Object.create()];

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        modelA: models[0],
        modelB: models[1],
        actions: {
          edit: function () {
            for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
              args[_key] = arguments[_key];
            }

            passedContexts = args;
          }
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<button {{action "edit" modelA modelB}}>click me</button>'
      });

      this.render('{{example-component}}');

      this.runTask(function () {
        _this24.$('button').click();
      });

      this.assert.deepEqual(passedContexts, models, 'the action was called with the passed contexts');
    };

    _class2.prototype['@test it should allow multiple contexts to be specified mixed with string args'] = function testItShouldAllowMultipleContextsToBeSpecifiedMixedWithStringArgs() {
      var _this25 = this;

      var passedContexts = undefined;
      var model = _emberRuntime.Object.create();

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        model: model,
        actions: {
          edit: function () {
            for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
              args[_key2] = arguments[_key2];
            }

            passedContexts = args;
          }
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<button {{action "edit" "herp" model}}>click me</button>'
      });

      this.render('{{example-component}}');

      this.runTask(function () {
        _this25.$('button').click();
      });

      this.assert.deepEqual(passedContexts, ['herp', model], 'the action was called with the passed contexts');
    };

    _class2.prototype['@test it should not trigger action with special clicks'] = function testItShouldNotTriggerActionWithSpecialClicks() {
      var showCalled = false;
      var component = undefined;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          component = this;
        },
        actions: {
          show: function () {
            showCalled = true;
          }
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<button {{action "show" href=true}}>Howdy</button>'
      });

      this.render('{{example-component}}');

      var assert = this.assert;

      function checkClick(prop, value, expected) {
        var event = _emberViews.jQuery.Event('click');
        event[prop] = value;

        component.$('button').trigger(event);

        if (expected) {
          assert.ok(showCalled, 'should call action with ' + prop + ':' + value);
          assert.ok(event.isDefaultPrevented(), 'should prevent default');
        } else {
          assert.notOk(showCalled, 'should not call action with ' + prop + ':' + value);
          assert.notOk(event.isDefaultPrevented(), 'should not prevent default');
        }
      }

      checkClick('ctrlKey', true, false);
      checkClick('altKey', true, false);
      checkClick('metaKey', true, false);
      checkClick('shiftKey', true, false);
      checkClick('which', 2, false);

      checkClick('which', 1, true);
      checkClick('which', undefined, true); // IE <9
    };

    _class2.prototype['@test it can trigger actions for keyboard events'] = function testItCanTriggerActionsForKeyboardEvents() {
      var _this26 = this;

      var showCalled = false;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        actions: {
          show: function () {
            showCalled = true;
          }
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<input type="text" {{action "show" on="keyUp"}}>'
      });

      this.render('{{example-component}}');

      this.runTask(function () {
        var event = _emberViews.jQuery.Event('keyup');
        event.char = 'a';
        event.which = 65;
        _this26.$('input').trigger(event);
      });

      this.assert.ok(showCalled, 'the action was called with keyup');
    };

    _class2.prototype['@test a quoteless parameter should allow dynamic lookup of the actionName'] = function testAQuotelessParameterShouldAllowDynamicLookupOfTheActionName() {
      var lastAction = undefined;
      var actionOrder = [];
      var component = undefined;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          component = this;
        },
        hookMeUp: 'rock',
        actions: {
          rock: function () {
            lastAction = 'rock';
            actionOrder.push('rock');
          },
          paper: function () {
            lastAction = 'paper';
            actionOrder.push('paper');
          },
          scissors: function () {
            lastAction = 'scissors';
            actionOrder.push('scissors');
          }
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<a id="bound-param" {{action hookMeUp}}>Whistle tips go woop woooop</a>'
      });

      this.render('{{example-component}}');

      var test = this;

      function testBoundAction(propertyValue) {
        test.runTask(function () {
          component.set('hookMeUp', propertyValue);
        });

        test.runTask(function () {
          component.$('#bound-param').click();
        });

        test.assert.ok(lastAction, propertyValue, 'lastAction set to ' + propertyValue);
      }

      testBoundAction('rock');
      testBoundAction('paper');
      testBoundAction('scissors');

      this.assert.deepEqual(actionOrder, ['rock', 'paper', 'scissors'], 'action name was looked up properly');
    };

    _class2.prototype['@test a quoteless string parameter should resolve actionName, including path'] = function testAQuotelessStringParameterShouldResolveActionNameIncludingPath() {
      var lastAction = undefined;
      var actionOrder = [];
      var component = undefined;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super.apply(this, arguments);
          component = this;
        },
        allactions: _emberRuntime.A([{ title: 'Rock', name: 'rock' }, { title: 'Paper', name: 'paper' }, { title: 'Scissors', name: 'scissors' }]),
        actions: {
          rock: function () {
            lastAction = 'rock';
            actionOrder.push('rock');
          },
          paper: function () {
            lastAction = 'paper';
            actionOrder.push('paper');
          },
          scissors: function () {
            lastAction = 'scissors';
            actionOrder.push('scissors');
          }
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '{{#each allactions as |allaction|}}<a id="{{allaction.name}}" {{action allaction.name}}>{{allaction.title}}</a>{{/each}}'
      });

      this.render('{{example-component}}');

      var test = this;

      function testBoundAction(propertyValue) {
        test.runTask(function () {
          component.$('#' + propertyValue).click();
        });

        test.assert.ok(lastAction, propertyValue, 'lastAction set to ' + propertyValue);
      }

      testBoundAction('rock');
      testBoundAction('paper');
      testBoundAction('scissors');

      this.assert.deepEqual(actionOrder, ['rock', 'paper', 'scissors'], 'action name was looked up properly');
    };

    _class2.prototype['@test a quoteless function parameter should be called, including arguments'] = function testAQuotelessFunctionParameterShouldBeCalledIncludingArguments() {
      var _this27 = this;

      var submitCalled = false;
      var incomingArg = undefined;

      var arg = 'rough ray';

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        submit: function (actualArg) {
          incomingArg = actualArg;
          submitCalled = true;
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<a {{action submit \'' + arg + '\'}}>Hi</a>'
      });

      this.render('{{example-component}}');

      this.runTask(function () {
        _this27.$('a').click();
      });

      this.assert.ok(submitCalled, 'submit function called');
      this.assert.equal(incomingArg, arg, 'argument passed');
    };

    _class2.prototype['@test a quoteless parameter that does not resolve to a value asserts'] = function testAQuotelessParameterThatDoesNotResolveToAValueAsserts() {
      var _this28 = this;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        actions: {
          ohNoeNotValid: function () {}
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<a id="oops-bound-param" {{action ohNoeNotValid}}>Hi</a>'
      });

      expectAssertion(function () {
        _this28.render('{{example-component}}');
      }, 'You specified a quoteless path, `ohNoeNotValid`, to the {{action}} helper ' + 'which did not resolve to an action name (a string). ' + 'Perhaps you meant to use a quoted actionName? (e.g. {{action "ohNoeNotValid"}}).');
    };

    _class2.prototype['@test allows multiple actions on a single element'] = function testAllowsMultipleActionsOnASingleElement() {
      var _this29 = this;

      var clickActionWasCalled = false;
      var doubleClickActionWasCalled = false;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        actions: {
          clicked: function () {
            clickActionWasCalled = true;
          },
          doubleClicked: function () {
            doubleClickActionWasCalled = true;
          }
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject4)
      });

      this.render('{{example-component}}');

      this.runTask(function () {
        _this29.$('a').trigger('click');
      });

      this.assert.ok(clickActionWasCalled, 'the clicked action was called');

      this.runTask(function () {
        _this29.$('a').trigger('dblclick');
      });

      this.assert.ok(doubleClickActionWasCalled, 'the doubleClicked action was called');
    };

    _class2.prototype['@test it should respect preventDefault option if provided'] = function testItShouldRespectPreventDefaultOptionIfProvided() {
      var _this30 = this;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        actions: {
          show: function () {}
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<a {{action "show" preventDefault=false}}>Hi</a>'
      });

      this.render('{{example-component}}');

      var event = _emberViews.jQuery.Event('click');

      this.runTask(function () {
        _this30.$('a').trigger(event);
      });

      this.assert.equal(event.isDefaultPrevented(), false, 'should not preventDefault');
    };

    _class2.prototype['@test it should respect preventDefault option if provided bound'] = function testItShouldRespectPreventDefaultOptionIfProvidedBound() {
      var _this31 = this;

      var component = undefined;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        shouldPreventDefault: false,
        init: function () {
          this._super.apply(this, arguments);
          component = this;
        },
        actions: {
          show: function () {}
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<a {{action "show" preventDefault=shouldPreventDefault}}>Hi</a>'
      });

      this.render('{{example-component}}');

      var event = _emberViews.jQuery.Event('click');

      this.runTask(function () {
        _this31.$('a').trigger(event);
      });

      this.assert.equal(event.isDefaultPrevented(), false, 'should not preventDefault');

      event = _emberViews.jQuery.Event('click');

      this.runTask(function () {
        component.set('shouldPreventDefault', true);
        _this31.$('a').trigger(event);
      });

      this.assert.equal(event.isDefaultPrevented(), true, 'should preventDefault');
    };

    _class2.prototype['@test it should target the proper component when `action` is in yielded block [GH #12409]'] = function testItShouldTargetTheProperComponentWhenActionIsInYieldedBlockGH12409() {
      var _this32 = this;

      var outerActionCalled = false;
      var innerClickCalled = false;

      var OuterComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        actions: {
          hey: function () {
            outerActionCalled = true;
          }
        }
      });

      var MiddleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({});

      var InnerComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        click: function () {
          innerClickCalled = true;
          this.sendAction();
        }
      });

      this.registerComponent('outer-component', {
        ComponentClass: OuterComponent,
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject5)
      });

      this.registerComponent('middle-component', {
        ComponentClass: MiddleComponent,
        template: '{{yield}}'
      });

      this.registerComponent('inner-component', {
        ComponentClass: InnerComponent,
        template: _emberGlimmerTestsUtilsAbstractTestCase.strip(_templateObject6)
      });

      this.render('{{outer-component}}');

      this.runTask(function () {
        _this32.$('button').click();
      });

      this.assert.ok(outerActionCalled, 'the action fired on the proper target');
      this.assert.ok(innerClickCalled, 'the click was triggered');
    };

    _class2.prototype['@test element action with (mut undefinedThing) works properly'] = function testElementActionWithMutUndefinedThingWorksProperly() {
      var _this33 = this;

      var component = undefined;

      var ExampleComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        label: undefined,
        init: function () {
          this._super.apply(this, arguments);
          component = this;
        }
      });

      this.registerComponent('example-component', {
        ComponentClass: ExampleComponent,
        template: '<button {{action (mut label) "Clicked!"}}>{{if label label "Click me"}}</button>'
      });

      this.render('{{example-component}}');

      this.assertText('Click me');

      this.assertStableRerender();

      this.runTask(function () {
        _this33.$('button').click();
      });

      this.assertText('Clicked!');

      this.runTask(function () {
        component.set('label', 'Dun clicked');
      });

      this.assertText('Dun clicked');

      this.runTask(function () {
        _this33.$('button').click();
      });

      this.assertText('Clicked!');

      this.runTask(function () {
        component.set('label', undefined);
      });

      this.assertText('Click me');
    };

    return _class2;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
});
enifed('ember-glimmer/tests/integration/helpers/get-test', ['exports', 'ember-glimmer/tests/utils/test-case', 'ember-glimmer/tests/utils/helpers', 'ember-metal'], function (exports, _emberGlimmerTestsUtilsTestCase, _emberGlimmerTestsUtilsHelpers, _emberMetal) {
  'use strict';

  _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: {{get}}', (function (_RenderingTest) {
    babelHelpers.inherits(_class, _RenderingTest);

    function _class() {
      _RenderingTest.apply(this, arguments);
    }

    _class.prototype['@test should be able to get an object value with a static key'] = function testShouldBeAbleToGetAnObjectValueWithAStaticKey() {
      var _this = this;

      this.render('[{{get colors \'apple\'}}] [{{if true (get colors \'apple\')}}]', {
        colors: { apple: 'red' }
      });

      this.assertText('[red] [red]');

      this.runTask(function () {
        return _this.rerender();
      });

      this.assertText('[red] [red]');

      this.runTask(function () {
        return _emberMetal.set(_this.context, 'colors.apple', 'green');
      });

      this.assertText('[green] [green]');

      this.runTask(function () {
        return _emberMetal.set(_this.context, 'colors', {
          apple: 'red'
        });
      });

      this.assertText('[red] [red]');
    };

    _class.prototype['@test should be able to get an object value with nested static key'] = function testShouldBeAbleToGetAnObjectValueWithNestedStaticKey() {
      var _this2 = this;

      this.render('[{{get colors "apple.gala"}}] [{{if true (get colors "apple.gala")}}]', {
        colors: {
          apple: {
            gala: 'red and yellow'
          }
        }
      });

      this.assertText('[red and yellow] [red and yellow]');

      this.runTask(function () {
        return _this2.rerender();
      });

      this.assertText('[red and yellow] [red and yellow]');

      this.runTask(function () {
        return _emberMetal.set(_this2.context, 'colors.apple.gala', 'yellow and red striped');
      });

      this.assertText('[yellow and red striped] [yellow and red striped]');

      this.runTask(function () {
        return _emberMetal.set(_this2.context, 'colors', { apple: { gala: 'red and yellow' } });
      });

      this.assertText('[red and yellow] [red and yellow]');
    };

    _class.prototype['@test should be able to get an object value with a bound/dynamic key'] = function testShouldBeAbleToGetAnObjectValueWithABoundDynamicKey() {
      var _this3 = this;

      this.render('[{{get colors key}}] [{{if true (get colors key)}}]', {
        colors: { apple: 'red', banana: 'yellow' },
        key: 'apple'
      });

      this.assertText('[red] [red]');

      this.runTask(function () {
        return _this3.rerender();
      });

      this.assertText('[red] [red]');

      this.runTask(function () {
        return _emberMetal.set(_this3.context, 'key', 'banana');
      });

      this.assertText('[yellow] [yellow]');

      this.runTask(function () {
        _emberMetal.set(_this3.context, 'colors.apple', 'green');
        _emberMetal.set(_this3.context, 'colors.banana', 'purple');
      });

      this.assertText('[purple] [purple]');

      this.runTask(function () {
        return _emberMetal.set(_this3.context, 'key', 'apple');
      });

      this.assertText('[green] [green]');

      this.runTask(function () {
        return _emberMetal.set(_this3.context, 'colors', { apple: 'red' });
      });

      this.assertText('[red] [red]');
    };

    _class.prototype['@test should be able to get an object value with nested dynamic key'] = function testShouldBeAbleToGetAnObjectValueWithNestedDynamicKey() {
      var _this4 = this;

      this.render('[{{get colors key}}] [{{if true (get colors key)}}]', {
        colors: {
          apple: {
            gala: 'red and yellow',
            mcintosh: 'red'
          },
          banana: 'yellow'
        },
        key: 'apple.gala'
      });

      this.assertText('[red and yellow] [red and yellow]');

      this.runTask(function () {
        return _this4.rerender();
      });

      this.assertText('[red and yellow] [red and yellow]');

      this.runTask(function () {
        return _emberMetal.set(_this4.context, 'key', 'apple.mcintosh');
      });

      this.assertText('[red] [red]');

      this.runTask(function () {
        return _emberMetal.set(_this4.context, 'key', 'banana');
      });

      this.assertText('[yellow] [yellow]');

      this.runTask(function () {
        return _emberMetal.set(_this4.context, 'key', 'apple.gala');
      });

      this.assertText('[red and yellow] [red and yellow]');
    };

    _class.prototype['@test should be able to get an object value with subexpression returning nested key'] = function testShouldBeAbleToGetAnObjectValueWithSubexpressionReturningNestedKey() {
      var _this5 = this;

      this.render('[{{get colors (concat \'apple\' \'.\' \'gala\')}}] [{{if true (get colors (concat \'apple\' \'.\' \'gala\'))}}]', {
        colors: {
          apple: {
            gala: 'red and yellow',
            mcintosh: 'red'
          }
        },
        key: 'apple.gala'
      });

      this.assertText('[red and yellow] [red and yellow]');

      this.runTask(function () {
        return _this5.rerender();
      });

      this.assertText('[red and yellow] [red and yellow]');

      this.runTask(function () {
        return _emberMetal.set(_this5.context, 'colors.apple.gala', 'yellow and red striped');
      });

      this.assertText('[yellow and red striped] [yellow and red striped]');

      this.runTask(function () {
        return _emberMetal.set(_this5.context, 'colors.apple.gala', 'yellow-redish');
      });

      this.assertText('[yellow-redish] [yellow-redish]');

      this.runTask(function () {
        return _emberMetal.set(_this5.context, 'colors', {
          apple: {
            gala: 'red and yellow',
            mcintosh: 'red'
          }
        });
      });

      this.assertText('[red and yellow] [red and yellow]');
    };

    _class.prototype['@test should be able to get an object value with a get helper as the key'] = function testShouldBeAbleToGetAnObjectValueWithAGetHelperAsTheKey() {
      var _this6 = this;

      this.render('[{{get colors (get possibleKeys key)}}] [{{if true (get colors (get possibleKeys key))}}]', {
        colors: { apple: 'red', banana: 'yellow' },
        key: 'key1',
        possibleKeys: { key1: 'apple', key2: 'banana' }
      });

      this.assertText('[red] [red]');

      this.runTask(function () {
        return _this6.rerender();
      });

      this.assertText('[red] [red]');

      this.runTask(function () {
        return _emberMetal.set(_this6.context, 'key', 'key2');
      });

      this.assertText('[yellow] [yellow]');

      this.runTask(function () {
        _emberMetal.set(_this6.context, 'colors.apple', 'green');
        _emberMetal.set(_this6.context, 'colors.banana', 'purple');
      });

      this.assertText('[purple] [purple]');

      this.runTask(function () {
        return _emberMetal.set(_this6.context, 'key', 'key1');
      });

      this.assertText('[green] [green]');

      this.runTask(function () {
        return _emberMetal.set(_this6.context, 'colors', { apple: 'red', banana: 'yellow' });
      });

      this.assertText('[red] [red]');
    };

    _class.prototype['@test should be able to get an object value with a get helper value as a bound/dynamic key'] = function testShouldBeAbleToGetAnObjectValueWithAGetHelperValueAsABoundDynamicKey() {
      var _this7 = this;

      this.render('[{{get (get possibleValues objectKey) key}}] [{{if true (get (get possibleValues objectKey) key)}}]', {
        possibleValues: {
          colors1: { apple: 'red', banana: 'yellow' },
          colors2: { apple: 'green', banana: 'purple' }
        },
        objectKey: 'colors1',
        key: 'apple'
      });

      this.assertText('[red] [red]');

      this.runTask(function () {
        return _this7.rerender();
      });

      this.assertText('[red] [red]');

      this.runTask(function () {
        return _emberMetal.set(_this7.context, 'objectKey', 'colors2');
      });

      this.assertText('[green] [green]');

      this.runTask(function () {
        return _emberMetal.set(_this7.context, 'objectKey', 'colors1');
      });

      this.assertText('[red] [red]');

      this.runTask(function () {
        return _emberMetal.set(_this7.context, 'key', 'banana');
      });

      this.assertText('[yellow] [yellow]');

      this.runTask(function () {
        return _emberMetal.set(_this7.context, 'objectKey', 'colors2');
      });

      this.assertText('[purple] [purple]');

      this.runTask(function () {
        return _emberMetal.set(_this7.context, 'objectKey', 'colors1');
      });

      this.assertText('[yellow] [yellow]');

      this.runTask(function () {
        return _emberMetal.set(_this7.context, 'key', 'apple');
      });
    };

    _class.prototype['@test should be able to get an object value with a get helper as the value and a get helper as the key'] = function testShouldBeAbleToGetAnObjectValueWithAGetHelperAsTheValueAndAGetHelperAsTheKey() {
      var _this8 = this;

      this.render('[{{get (get possibleValues objectKey) (get possibleKeys key)}}] [{{if true (get (get possibleValues objectKey) (get possibleKeys key))}}]', {
        possibleValues: {
          colors1: { apple: 'red', banana: 'yellow' },
          colors2: { apple: 'green', banana: 'purple' }
        },
        objectKey: 'colors1',
        possibleKeys: {
          key1: 'apple',
          key2: 'banana'
        },
        key: 'key1'
      });

      this.assertText('[red] [red]');

      this.runTask(function () {
        return _this8.rerender();
      });

      this.assertText('[red] [red]');

      this.runTask(function () {
        return _emberMetal.set(_this8.context, 'objectKey', 'colors2');
      });

      this.assertText('[green] [green]');

      this.runTask(function () {
        return _emberMetal.set(_this8.context, 'objectKey', 'colors1');
      });

      this.assertText('[red] [red]');

      this.runTask(function () {
        return _emberMetal.set(_this8.context, 'key', 'key2');
      });

      this.assertText('[yellow] [yellow]');

      this.runTask(function () {
        return _emberMetal.set(_this8.context, 'objectKey', 'colors2');
      });

      this.assertText('[purple] [purple]');

      this.runTask(function () {
        _emberMetal.set(_this8.context, 'objectKey', 'colors1');
        _emberMetal.set(_this8.context, 'key', 'key1');
      });

      this.assertText('[red] [red]');
    };

    _class.prototype['@test the result of a get helper can be yielded'] = function testTheResultOfAGetHelperCanBeYielded() {
      var _this9 = this;

      var fooBarInstance = undefined;
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super();
          fooBarInstance = this;
          this.mcintosh = 'red';
        }
      });

      this.registerComponent('foo-bar', {
        ComponentClass: FooBarComponent,
        template: '{{yield (get colors mcintosh)}}'
      });

      this.render('{{#foo-bar colors=colors as |value|}}{{value}}{{/foo-bar}}', {
        colors: {
          red: 'banana'
        }
      });

      this.assertText('banana');

      this.runTask(function () {
        return _this9.rerender();
      });

      this.assertText('banana');

      this.runTask(function () {
        _emberMetal.set(fooBarInstance, 'mcintosh', 'yellow');
        _emberMetal.set(_this9.context, 'colors', { yellow: 'bus' });
      });

      this.assertText('bus');

      this.runTask(function () {
        _emberMetal.set(fooBarInstance, 'mcintosh', 'red');
        _emberMetal.set(_this9.context, 'colors', { red: 'banana' });
      });

      this.assertText('banana');
    };

    _class.prototype['@test should handle object values as nulls'] = function testShouldHandleObjectValuesAsNulls() {
      var _this10 = this;

      this.render('[{{get colors \'apple\'}}] [{{if true (get colors \'apple\')}}]', {
        colors: null
      });

      this.assertText('[] []');

      this.runTask(function () {
        return _this10.rerender();
      });

      this.assertText('[] []');

      this.runTask(function () {
        return _emberMetal.set(_this10.context, 'colors', { apple: 'green', banana: 'purple' });
      });

      this.assertText('[green] [green]');

      this.runTask(function () {
        return _emberMetal.set(_this10.context, 'colors', null);
      });

      this.assertText('[] []');
    };

    _class.prototype['@test should handle object keys as nulls'] = function testShouldHandleObjectKeysAsNulls() {
      var _this11 = this;

      this.render('[{{get colors key}}] [{{if true (get colors key)}}]', {
        colors: {
          apple: 'red',
          banana: 'yellow'
        },
        key: null
      });

      this.assertText('[] []');

      this.runTask(function () {
        return _this11.rerender();
      });

      this.assertText('[] []');

      this.runTask(function () {
        return _emberMetal.set(_this11.context, 'key', 'banana');
      });

      this.assertText('[yellow] [yellow]');

      this.runTask(function () {
        return _emberMetal.set(_this11.context, 'key', null);
      });

      this.assertText('[] []');
    };

    _class.prototype['@test should handle object values and keys as nulls'] = function testShouldHandleObjectValuesAndKeysAsNulls() {
      this.render('[{{get colors \'apple\'}}] [{{if true (get colors key)}}]', {
        colors: null,
        key: null
      });

      this.assertText('[] []');
    };

    _class.prototype['@test get helper value should be updatable using {{input}} and (mut) - static key'] = function testGetHelperValueShouldBeUpdatableUsingInputAndMutStaticKey(assert) {
      var _this12 = this;

      this.render('{{input type=\'text\' value=(mut (get source \'banana\')) id=\'get-input\'}}', {
        source: {
          banana: 'banana'
        }
      });

      assert.strictEqual(this.$('#get-input').val(), 'banana');

      this.runTask(function () {
        return _this12.rerender();
      });

      assert.strictEqual(this.$('#get-input').val(), 'banana');

      this.runTask(function () {
        return _emberMetal.set(_this12.context, 'source.banana', 'yellow');
      });

      assert.strictEqual(this.$('#get-input').val(), 'yellow');

      this.runTask(function () {
        return _this12.$('#get-input').val('some value').trigger('change');
      });

      assert.strictEqual(this.$('#get-input').val(), 'some value');
      assert.strictEqual(_emberMetal.get(this.context, 'source.banana'), 'some value');

      this.runTask(function () {
        return _emberMetal.set(_this12.context, 'source', { banana: 'banana' });
      });

      assert.strictEqual(this.$('#get-input').val(), 'banana');
    };

    _class.prototype['@test get helper value should be updatable using {{input}} and (mut) - dynamic key'] = function testGetHelperValueShouldBeUpdatableUsingInputAndMutDynamicKey(assert) {
      var _this13 = this;

      this.render('{{input type=\'text\' value=(mut (get source key)) id=\'get-input\'}}', {
        source: {
          apple: 'apple',
          banana: 'banana'
        },
        key: 'banana'
      });

      assert.strictEqual(this.$('#get-input').val(), 'banana');

      this.runTask(function () {
        return _this13.rerender();
      });

      assert.strictEqual(this.$('#get-input').val(), 'banana');

      this.runTask(function () {
        return _emberMetal.set(_this13.context, 'source.banana', 'yellow');
      });

      assert.strictEqual(this.$('#get-input').val(), 'yellow');

      this.runTask(function () {
        return _this13.$('#get-input').val('some value').trigger('change');
      });

      assert.strictEqual(this.$('#get-input').val(), 'some value');
      assert.strictEqual(_emberMetal.get(this.context, 'source.banana'), 'some value');

      this.runTask(function () {
        return _emberMetal.set(_this13.context, 'key', 'apple');
      });

      assert.strictEqual(this.$('#get-input').val(), 'apple');

      this.runTask(function () {
        return _this13.$('#get-input').val('some other value').trigger('change');
      });

      assert.strictEqual(this.$('#get-input').val(), 'some other value');
      assert.strictEqual(_emberMetal.get(this.context, 'source.apple'), 'some other value');

      this.runTask(function () {
        _emberMetal.set(_this13.context, 'key', 'banana');
        _emberMetal.set(_this13.context, 'source', { banana: 'banana' });
      });

      assert.strictEqual(this.$('#get-input').val(), 'banana');
    };

    _class.prototype['@test get helper value should be updatable using {{input}} and (mut) - dynamic nested key'] = function testGetHelperValueShouldBeUpdatableUsingInputAndMutDynamicNestedKey(assert) {
      var _this14 = this;

      this.render('{{input type=\'text\' value=(mut (get source key)) id=\'get-input\'}}', {
        source: {
          apple: {
            gala: 'gala',
            mcintosh: 'mcintosh'
          },
          banana: 'banana'
        },
        key: 'apple.mcintosh'
      });

      assert.strictEqual(this.$('#get-input').val(), 'mcintosh');

      this.runTask(function () {
        return _this14.rerender();
      });

      assert.strictEqual(this.$('#get-input').val(), 'mcintosh');

      this.runTask(function () {
        return _emberMetal.set(_this14.context, 'source.apple.mcintosh', 'red');
      });

      assert.strictEqual(this.$('#get-input').val(), 'red');

      this.runTask(function () {
        return _this14.$('#get-input').val('some value').trigger('change');
      });

      assert.strictEqual(this.$('#get-input').val(), 'some value');
      assert.strictEqual(_emberMetal.get(this.context, 'source.apple.mcintosh'), 'some value');

      this.runTask(function () {
        return _emberMetal.set(_this14.context, 'key', 'apple.gala');
      });

      assert.strictEqual(this.$('#get-input').val(), 'gala');

      this.runTask(function () {
        return _this14.$('#get-input').val('some other value').trigger('change');
      });

      assert.strictEqual(this.$('#get-input').val(), 'some other value');
      assert.strictEqual(_emberMetal.get(this.context, 'source.apple.gala'), 'some other value');

      this.runTask(function () {
        return _emberMetal.set(_this14.context, 'key', 'banana');
      });

      assert.strictEqual(this.$('#get-input').val(), 'banana');

      this.runTask(function () {
        return _this14.$('#get-input').val('yet another value').trigger('change');
      });

      assert.strictEqual(this.$('#get-input').val(), 'yet another value');
      assert.strictEqual(_emberMetal.get(this.context, 'source.banana'), 'yet another value');

      this.runTask(function () {
        _emberMetal.set(_this14.context, 'key', 'apple.mcintosh');
        _emberMetal.set(_this14.context, 'source', {
          apple: {
            gala: 'gala',
            mcintosh: 'mcintosh'
          },
          banana: 'banana'
        });
      });

      assert.strictEqual(this.$('#get-input').val(), 'mcintosh');
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
});
enifed('ember-glimmer/tests/integration/helpers/hash-test', ['exports', 'ember-glimmer/tests/utils/test-case', 'ember-glimmer/tests/utils/helpers', 'ember-metal'], function (exports, _emberGlimmerTestsUtilsTestCase, _emberGlimmerTestsUtilsHelpers, _emberMetal) {
  'use strict';

  _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: {{hash}}', (function (_RenderingTest) {
    babelHelpers.inherits(_class, _RenderingTest);

    function _class() {
      _RenderingTest.apply(this, arguments);
    }

    _class.prototype['@test returns a hash with the right key-value'] = function testReturnsAHashWithTheRightKeyValue() {
      var _this = this;

      this.render('{{#with (hash name="Sergio") as |person|}}{{person.name}}{{/with}}');

      this.assertText('Sergio');

      this.runTask(function () {
        return _this.rerender();
      });

      this.assertText('Sergio');
    };

    _class.prototype['@test can have more than one key-value'] = function testCanHaveMoreThanOneKeyValue() {
      var _this2 = this;

      this.render('{{#with (hash name="Sergio" lastName="Arbeo") as |person|}}{{person.name}} {{person.lastName}}{{/with}}');

      this.assertText('Sergio Arbeo');

      this.runTask(function () {
        return _this2.rerender();
      });

      this.assertText('Sergio Arbeo');
    };

    _class.prototype['@test binds values when variables are used'] = function testBindsValuesWhenVariablesAreUsed() {
      var _this3 = this;

      this.render('{{#with (hash name=model.firstName lastName="Arbeo") as |person|}}{{person.name}} {{person.lastName}}{{/with}}', {
        model: {
          firstName: 'Marisa'
        }
      });

      this.assertText('Marisa Arbeo');

      this.runTask(function () {
        return _this3.rerender();
      });

      this.assertText('Marisa Arbeo');

      this.runTask(function () {
        return _emberMetal.set(_this3.context, 'model.firstName', 'Sergio');
      });

      this.assertText('Sergio Arbeo');

      this.runTask(function () {
        return _emberMetal.set(_this3.context, 'model', { firstName: 'Marisa' });
      });

      this.assertText('Marisa Arbeo');
    };

    _class.prototype['@test binds multiple values when variables are used'] = function testBindsMultipleValuesWhenVariablesAreUsed() {
      var _this4 = this;

      this.render('{{#with (hash name=model.firstName lastName=model.lastName) as |person|}}{{person.name}} {{person.lastName}}{{/with}}', {
        model: {
          firstName: 'Marisa',
          lastName: 'Arbeo'
        }
      });

      this.assertText('Marisa Arbeo');

      this.runTask(function () {
        return _this4.rerender();
      });

      this.assertText('Marisa Arbeo');

      this.runTask(function () {
        return _emberMetal.set(_this4.context, 'model.firstName', 'Sergio');
      });

      this.assertText('Sergio Arbeo');

      this.runTask(function () {
        return _emberMetal.set(_this4.context, 'model.lastName', 'Smith');
      });

      this.assertText('Sergio Smith');

      this.runTask(function () {
        return _emberMetal.set(_this4.context, 'model', {
          firstName: 'Marisa',
          lastName: 'Arbeo'
        });
      });

      this.assertText('Marisa Arbeo');
    };

    _class.prototype['@test hash helpers can be nested'] = function testHashHelpersCanBeNested() {
      var _this5 = this;

      this.render('{{#with (hash person=(hash name=model.firstName)) as |ctx|}}{{ctx.person.name}}{{/with}}', {
        model: { firstName: 'Balint' }
      });

      this.assertText('Balint');

      this.runTask(function () {
        return _this5.rerender();
      });

      this.assertText('Balint');

      this.runTask(function () {
        return _emberMetal.set(_this5.context, 'model.firstName', 'Chad');
      });

      this.assertText('Chad');

      this.runTask(function () {
        return _emberMetal.set(_this5.context, 'model', { firstName: 'Balint' });
      });

      this.assertText('Balint');
    };

    _class.prototype['@test should yield hash of internal properties'] = function testShouldYieldHashOfInternalProperties() {
      var _this6 = this;

      var fooBarInstance = undefined;
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super();
          fooBarInstance = this;
          this.model = { firstName: 'Chad' };
        }
      });

      this.registerComponent('foo-bar', {
        ComponentClass: FooBarComponent,
        template: '{{yield (hash firstName=model.firstName)}}'
      });

      this.render('{{#foo-bar as |values|}}{{values.firstName}}{{/foo-bar}}');

      this.assertText('Chad');

      this.runTask(function () {
        return _this6.rerender();
      });

      this.assertText('Chad');

      this.runTask(function () {
        return _emberMetal.set(fooBarInstance, 'model.firstName', 'Godfrey');
      });

      this.assertText('Godfrey');

      this.runTask(function () {
        return _emberMetal.set(fooBarInstance, 'model', { firstName: 'Chad' });
      });

      this.assertText('Chad');
    };

    _class.prototype['@test should yield hash of internal and external properties'] = function testShouldYieldHashOfInternalAndExternalProperties() {
      var _this7 = this;

      var fooBarInstance = undefined;
      var FooBarComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        init: function () {
          this._super();
          fooBarInstance = this;
          this.model = { firstName: 'Chad' };
        }
      });

      this.registerComponent('foo-bar', {
        ComponentClass: FooBarComponent,
        template: '{{yield (hash firstName=model.firstName lastName=lastName)}}'
      });

      this.render('{{#foo-bar lastName=model.lastName as |values|}}{{values.firstName}} {{values.lastName}}{{/foo-bar}}', {
        model: { lastName: 'Hietala' }
      });

      this.assertText('Chad Hietala');

      this.runTask(function () {
        return _this7.rerender();
      });

      this.assertText('Chad Hietala');

      this.runTask(function () {
        _emberMetal.set(fooBarInstance, 'model.firstName', 'Godfrey');
        _emberMetal.set(_this7.context, 'model.lastName', 'Chan');
      });

      this.assertText('Godfrey Chan');

      this.runTask(function () {
        _emberMetal.set(fooBarInstance, 'model', { firstName: 'Chad' });
        _emberMetal.set(_this7.context, 'model', { lastName: 'Hietala' });
      });

      this.assertText('Chad Hietala');
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
});
enifed('ember-glimmer/tests/integration/helpers/if-unless-test', ['exports', 'ember-glimmer/tests/utils/test-case', 'ember-glimmer/tests/utils/shared-conditional-tests'], function (exports, _emberGlimmerTestsUtilsTestCase, _emberGlimmerTestsUtilsSharedConditionalTests) {
  'use strict';

  _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: inline {{if}}', (function (_IfUnlessHelperTest) {
    babelHelpers.inherits(_class, _IfUnlessHelperTest);

    function _class() {
      _IfUnlessHelperTest.apply(this, arguments);
    }

    _class.prototype.templateFor = function templateFor(_ref) {
      var cond = _ref.cond;
      var truthy = _ref.truthy;
      var falsy = _ref.falsy;

      return '{{if ' + cond + ' ' + truthy + ' ' + falsy + '}}';
    };

    _class.prototype['@test it raises when there are more than three arguments'] = function testItRaisesWhenThereAreMoreThanThreeArguments() {
      var _this = this;

      expectAssertion(function () {
        _this.render('{{if condition \'a\' \'b\' \'c\'}}', { condition: true });
      }, /The inline form of the `if` helper expects two or three arguments/);
    };

    _class.prototype['@test it raises when there are less than two arguments'] = function testItRaisesWhenThereAreLessThanTwoArguments() {
      var _this2 = this;

      expectAssertion(function () {
        _this2.render('{{if condition}}', { condition: true });
      }, /The inline form of the `if` helper expects two or three arguments/);
    };

    return _class;
  })(_emberGlimmerTestsUtilsSharedConditionalTests.IfUnlessHelperTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: nested {{if}} helpers (returning truthy values)', (function (_IfUnlessHelperTest2) {
    babelHelpers.inherits(_class2, _IfUnlessHelperTest2);

    function _class2() {
      _IfUnlessHelperTest2.apply(this, arguments);
    }

    _class2.prototype.templateFor = function templateFor(_ref2) {
      var cond = _ref2.cond;
      var truthy = _ref2.truthy;
      var falsy = _ref2.falsy;

      return '{{if (if ' + cond + ' ' + cond + ' false) ' + truthy + ' ' + falsy + '}}';
    };

    return _class2;
  })(_emberGlimmerTestsUtilsSharedConditionalTests.IfUnlessHelperTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: nested {{if}} helpers (returning falsy values)', (function (_IfUnlessHelperTest3) {
    babelHelpers.inherits(_class3, _IfUnlessHelperTest3);

    function _class3() {
      _IfUnlessHelperTest3.apply(this, arguments);
    }

    _class3.prototype.templateFor = function templateFor(_ref3) {
      var cond = _ref3.cond;
      var truthy = _ref3.truthy;
      var falsy = _ref3.falsy;

      return '{{if (if ' + cond + ' true ' + cond + ') ' + truthy + ' ' + falsy + '}}';
    };

    return _class3;
  })(_emberGlimmerTestsUtilsSharedConditionalTests.IfUnlessHelperTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: {{if}} used with another helper', (function (_IfUnlessHelperTest4) {
    babelHelpers.inherits(_class4, _IfUnlessHelperTest4);

    function _class4() {
      _IfUnlessHelperTest4.apply(this, arguments);
    }

    _class4.prototype.wrapperFor = function wrapperFor(templates) {
      return '{{concat ' + templates.join(' ') + '}}';
    };

    _class4.prototype.templateFor = function templateFor(_ref4) {
      var cond = _ref4.cond;
      var truthy = _ref4.truthy;
      var falsy = _ref4.falsy;

      return '(if ' + cond + ' ' + truthy + ' ' + falsy + ')';
    };

    return _class4;
  })(_emberGlimmerTestsUtilsSharedConditionalTests.IfUnlessHelperTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: {{if}} used in attribute position', (function (_IfUnlessHelperTest5) {
    babelHelpers.inherits(_class5, _IfUnlessHelperTest5);

    function _class5() {
      _IfUnlessHelperTest5.apply(this, arguments);
    }

    _class5.prototype.wrapperFor = function wrapperFor(templates) {
      return '<div data-foo="' + templates.join('') + '" />';
    };

    _class5.prototype.templateFor = function templateFor(_ref5) {
      var cond = _ref5.cond;
      var truthy = _ref5.truthy;
      var falsy = _ref5.falsy;

      return '{{if ' + cond + ' ' + truthy + ' ' + falsy + '}}';
    };

    _class5.prototype.textValue = function textValue() {
      return this.$('div').attr('data-foo');
    };

    return _class5;
  })(_emberGlimmerTestsUtilsSharedConditionalTests.IfUnlessHelperTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: inline {{if}} and {{unless}} without the inverse argument', (function (_IfUnlessHelperTest6) {
    babelHelpers.inherits(_class6, _IfUnlessHelperTest6);

    function _class6() {
      _IfUnlessHelperTest6.apply(this, arguments);
    }

    _class6.prototype.templateFor = function templateFor(_ref6) {
      var cond = _ref6.cond;
      var truthy = _ref6.truthy;
      var falsy = _ref6.falsy;

      return '{{if ' + cond + ' ' + truthy + '}}{{unless ' + cond + ' ' + falsy + '}}';
    };

    return _class6;
  })(_emberGlimmerTestsUtilsSharedConditionalTests.IfUnlessHelperTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: inline {{unless}}', (function (_IfUnlessHelperTest7) {
    babelHelpers.inherits(_class7, _IfUnlessHelperTest7);

    function _class7() {
      _IfUnlessHelperTest7.apply(this, arguments);
    }

    _class7.prototype.templateFor = function templateFor(_ref7) {
      var cond = _ref7.cond;
      var truthy = _ref7.truthy;
      var falsy = _ref7.falsy;

      return '{{unless ' + cond + ' ' + falsy + ' ' + truthy + '}}';
    };

    _class7.prototype['@test it raises when there are more than three arguments'] = function testItRaisesWhenThereAreMoreThanThreeArguments() {
      var _this3 = this;

      expectAssertion(function () {
        _this3.render('{{unless condition \'a\' \'b\' \'c\'}}', { condition: true });
      }, /The inline form of the `unless` helper expects two or three arguments/);
    };

    _class7.prototype['@test it raises when there are less than two arguments'] = function testItRaisesWhenThereAreLessThanTwoArguments() {
      var _this4 = this;

      expectAssertion(function () {
        _this4.render('{{unless condition}}', { condition: true });
      }, /The inline form of the `unless` helper expects two or three arguments/);
    };

    return _class7;
  })(_emberGlimmerTestsUtilsSharedConditionalTests.IfUnlessHelperTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: nested {{unless}} helpers (returning truthy values)', (function (_IfUnlessHelperTest8) {
    babelHelpers.inherits(_class8, _IfUnlessHelperTest8);

    function _class8() {
      _IfUnlessHelperTest8.apply(this, arguments);
    }

    _class8.prototype.templateFor = function templateFor(_ref8) {
      var cond = _ref8.cond;
      var truthy = _ref8.truthy;
      var falsy = _ref8.falsy;

      return '{{unless (unless ' + cond + ' false ' + cond + ') ' + falsy + ' ' + truthy + '}}';
    };

    return _class8;
  })(_emberGlimmerTestsUtilsSharedConditionalTests.IfUnlessHelperTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: nested {{unless}} helpers (returning falsy values)', (function (_IfUnlessHelperTest9) {
    babelHelpers.inherits(_class9, _IfUnlessHelperTest9);

    function _class9() {
      _IfUnlessHelperTest9.apply(this, arguments);
    }

    _class9.prototype.templateFor = function templateFor(_ref9) {
      var cond = _ref9.cond;
      var truthy = _ref9.truthy;
      var falsy = _ref9.falsy;

      return '{{unless (unless ' + cond + ' ' + cond + ' true) ' + falsy + ' ' + truthy + '}}';
    };

    return _class9;
  })(_emberGlimmerTestsUtilsSharedConditionalTests.IfUnlessHelperTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: {{unless}} used with another helper', (function (_IfUnlessHelperTest10) {
    babelHelpers.inherits(_class10, _IfUnlessHelperTest10);

    function _class10() {
      _IfUnlessHelperTest10.apply(this, arguments);
    }

    _class10.prototype.wrapperFor = function wrapperFor(templates) {
      return '{{concat ' + templates.join(' ') + '}}';
    };

    _class10.prototype.templateFor = function templateFor(_ref10) {
      var cond = _ref10.cond;
      var truthy = _ref10.truthy;
      var falsy = _ref10.falsy;

      return '(unless ' + cond + ' ' + falsy + ' ' + truthy + ')';
    };

    return _class10;
  })(_emberGlimmerTestsUtilsSharedConditionalTests.IfUnlessHelperTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: {{unless}} used in attribute position', (function (_IfUnlessHelperTest11) {
    babelHelpers.inherits(_class11, _IfUnlessHelperTest11);

    function _class11() {
      _IfUnlessHelperTest11.apply(this, arguments);
    }

    _class11.prototype.wrapperFor = function wrapperFor(templates) {
      return '<div data-foo="' + templates.join('') + '" />';
    };

    _class11.prototype.templateFor = function templateFor(_ref11) {
      var cond = _ref11.cond;
      var truthy = _ref11.truthy;
      var falsy = _ref11.falsy;

      return '{{unless ' + cond + ' ' + falsy + ' ' + truthy + '}}';
    };

    _class11.prototype.textValue = function textValue() {
      return this.$('div').attr('data-foo');
    };

    return _class11;
  })(_emberGlimmerTestsUtilsSharedConditionalTests.IfUnlessHelperTest));
});
enifed('ember-glimmer/tests/integration/helpers/input-test', ['exports', 'ember-utils', 'ember-metal', 'ember-glimmer/tests/utils/helpers', 'ember-glimmer/tests/utils/test-case', 'internal-test-helpers'], function (exports, _emberUtils, _emberMetal, _emberGlimmerTestsUtilsHelpers, _emberGlimmerTestsUtilsTestCase, _internalTestHelpers) {
  'use strict';

  var InputRenderingTest = (function (_RenderingTest) {
    babelHelpers.inherits(InputRenderingTest, _RenderingTest);

    function InputRenderingTest() {
      _RenderingTest.call(this);

      this.registerComponent('-text-field', { ComponentClass: _emberGlimmerTestsUtilsHelpers.TextField });
      this.registerComponent('-checkbox', { ComponentClass: _emberGlimmerTestsUtilsHelpers.Checkbox });
    }

    InputRenderingTest.prototype.$input = function $input() {
      return this.$('input');
    };

    InputRenderingTest.prototype.inputID = function inputID() {
      return this.$input().prop('id');
    };

    InputRenderingTest.prototype.assertDisabled = function assertDisabled() {
      this.assert.ok(this.$('input').prop('disabled'), 'The input is disabled');
    };

    InputRenderingTest.prototype.assertNotDisabled = function assertNotDisabled() {
      this.assert.ok(this.$('input').is(':not(:disabled)'), 'The input is not disabled');
    };

    InputRenderingTest.prototype.assertInputId = function assertInputId(expectedId) {
      this.assert.equal(this.inputID(), expectedId, 'the input id should be `expectedId`');
    };

    InputRenderingTest.prototype.assertSingleInput = function assertSingleInput() {
      this.assert.equal(this.$('input').length, 1, 'A single text field was inserted');
    };

    InputRenderingTest.prototype.assertSingleCheckbox = function assertSingleCheckbox() {
      this.assert.equal(this.$('input[type=checkbox]').length, 1, 'A single checkbox is added');
    };

    InputRenderingTest.prototype.assertCheckboxIsChecked = function assertCheckboxIsChecked() {
      this.assert.equal(this.$input().prop('checked'), true, 'the checkbox is checked');
    };

    InputRenderingTest.prototype.assertCheckboxIsNotChecked = function assertCheckboxIsNotChecked() {
      this.assert.equal(this.$input().prop('checked'), false, 'the checkbox is not checked');
    };

    InputRenderingTest.prototype.assertValue = function assertValue(expected) {
      this.assert.equal(this.$input().val(), expected, 'the input value should be ' + expected);
    };

    InputRenderingTest.prototype.assertAttr = function assertAttr(name, expected) {
      this.assert.equal(this.$input().attr(name), expected, 'the input ' + name + ' attribute has the value \'' + expected + '\'');
    };

    InputRenderingTest.prototype.assertAllAttrs = function assertAllAttrs(names, expected) {
      var _this = this;

      names.forEach(function (name) {
        return _this.assertAttr(name, expected);
      });
    };

    InputRenderingTest.prototype.assertSelectionRange = function assertSelectionRange(start, end) {
      var input = this.$input()[0];
      this.assert.equal(input.selectionStart, start, 'the cursor start position should be ' + start);
      this.assert.equal(input.selectionEnd, end, 'the cursor end position should be ' + end);
    };

    InputRenderingTest.prototype.triggerEvent = function triggerEvent(type, options) {
      var event = document.createEvent('Events');
      event.initEvent(type, true, true);
      _emberUtils.assign(event, options);

      var element = this.$input()[0];
      this.runTask(function () {
        element.dispatchEvent(event);
      });
    };

    return InputRenderingTest;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest);

  _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: {{input}}', (function (_InputRenderingTest) {
    babelHelpers.inherits(_class, _InputRenderingTest);

    function _class() {
      _InputRenderingTest.apply(this, arguments);
    }

    _class.prototype['@test a single text field is inserted into the DOM'] = function testASingleTextFieldIsInsertedIntoTheDOM(assert) {
      var _this2 = this;

      this.render('{{input type="text" value=value}}', { value: 'hello' });

      var id = this.inputID();

      this.assertValue('hello');
      this.assertSingleInput();

      this.runTask(function () {
        return _this2.rerender();
      });

      this.assertValue('hello');
      this.assertSingleInput();
      this.assertInputId(id);

      this.runTask(function () {
        return _emberMetal.set(_this2.context, 'value', 'goodbye');
      });

      this.assertValue('goodbye');
      this.assertSingleInput();
      this.assertInputId(id);

      this.runTask(function () {
        return _emberMetal.set(_this2.context, 'value', 'hello');
      });

      this.assertValue('hello');
      this.assertSingleInput();
      this.assertInputId(id);
    };

    _class.prototype['@test default type'] = function testDefaultType() {
      var _this3 = this;

      this.render('{{input}}');

      this.assertAttr('type', 'text');

      this.runTask(function () {
        return _this3.rerender();
      });

      this.assertAttr('type', 'text');
    };

    _class.prototype['@test dynamic attributes'] = function testDynamicAttributes() {
      var _this4 = this;

      this.render('\n      {{input type="text"\n        disabled=disabled\n        value=value\n        placeholder=placeholder\n        name=name\n        maxlength=maxlength\n        size=size\n        tabindex=tabindex\n      }}', {
        disabled: false,
        value: 'Original value',
        placeholder: 'Original placeholder',
        name: 'original-name',
        maxlength: 10,
        size: 20,
        tabindex: 30
      });

      this.assertNotDisabled();
      this.assertValue('Original value');
      this.assertAttr('placeholder', 'Original placeholder');
      this.assertAttr('name', 'original-name');
      this.assertAttr('maxlength', '10');
      // this.assertAttr('size', '20'); //NOTE: failing in IE  (TEST_SUITE=sauce)
      // this.assertAttr('tabindex', '30'); //NOTE: failing in IE (TEST_SUITE=sauce)

      this.runTask(function () {
        return _this4.rerender();
      });

      this.assertNotDisabled();
      this.assertValue('Original value');
      this.assertAttr('placeholder', 'Original placeholder');
      this.assertAttr('name', 'original-name');
      this.assertAttr('maxlength', '10');
      // this.assertAttr('size', '20'); //NOTE: failing in IE (TEST_SUITE=sauce)
      // this.assertAttr('tabindex', '30'); //NOTE: failing in IE (TEST_SUITE=sauce)

      this.runTask(function () {
        _emberMetal.set(_this4.context, 'value', 'Updated value');
        _emberMetal.set(_this4.context, 'disabled', true);
        _emberMetal.set(_this4.context, 'placeholder', 'Updated placeholder');
        _emberMetal.set(_this4.context, 'name', 'updated-name');
        _emberMetal.set(_this4.context, 'maxlength', 11);
        // set(this.context, 'size', 21); //NOTE: failing in IE (TEST_SUITE=sauce)
        // set(this.context, 'tabindex', 31); //NOTE: failing in IE (TEST_SUITE=sauce)
      });

      this.assertDisabled();
      this.assertValue('Updated value');
      this.assertAttr('placeholder', 'Updated placeholder');
      this.assertAttr('name', 'updated-name');
      this.assertAttr('maxlength', '11');
      // this.assertAttr('size', '21'); //NOTE: failing in IE (TEST_SUITE=sauce)
      // this.assertAttr('tabindex', '31'); //NOTE: failing in IE (TEST_SUITE=sauce)

      this.runTask(function () {
        _emberMetal.set(_this4.context, 'value', 'Original value');
        _emberMetal.set(_this4.context, 'disabled', false);
        _emberMetal.set(_this4.context, 'placeholder', 'Original placeholder');
        _emberMetal.set(_this4.context, 'name', 'original-name');
        _emberMetal.set(_this4.context, 'maxlength', 10);
        // set(this.context, 'size', 20); //NOTE: failing in IE (TEST_SUITE=sauce)
        // set(this.context, 'tabindex', 30); //NOTE: failing in IE (TEST_SUITE=sauce)
      });

      this.assertNotDisabled();
      this.assertValue('Original value');
      this.assertAttr('placeholder', 'Original placeholder');
      this.assertAttr('name', 'original-name');
      this.assertAttr('maxlength', '10');
      // this.assertAttr('size', '20'); //NOTE: failing in IE (TEST_SUITE=sauce)
      // this.assertAttr('tabindex', '30'); //NOTE: failing in IE (TEST_SUITE=sauce)
    };

    _class.prototype['@test static attributes'] = function testStaticAttributes() {
      var _this5 = this;

      this.render('\n      {{input type="text"\n        disabled=true\n        value="Original value"\n        placeholder="Original placeholder"\n        name="original-name"\n        maxlength=10\n        size=20\n        tabindex=30\n      }}');

      this.assertDisabled();
      this.assertValue('Original value');
      this.assertAttr('placeholder', 'Original placeholder');
      this.assertAttr('name', 'original-name');
      this.assertAttr('maxlength', '10');
      // this.assertAttr('size', '20');  //NOTE: failing in IE (TEST_SUITE=sauce)
      // this.assertAttr('tabindex', '30');  //NOTE: failing in IE (TEST_SUITE=sauce)

      this.runTask(function () {
        return _this5.rerender();
      });

      this.assertDisabled();
      this.assertValue('Original value');
      this.assertAttr('placeholder', 'Original placeholder');
      this.assertAttr('name', 'original-name');
      this.assertAttr('maxlength', '10');
      // this.assertAttr('size', '20');  //NOTE: failing in IE (TEST_SUITE=sauce)
      // this.assertAttr('tabindex', '30');  //NOTE: failing in IE (TEST_SUITE=sauce)
    };

    _class.prototype['@test cursor selection range'] = function testCursorSelectionRange(assert) {
      var _this6 = this;

      // Modifying input.selectionStart, which is utilized in the cursor tests,
      // causes an event in Safari.
      _internalTestHelpers.runDestroy(this.owner.lookup('event_dispatcher:main'));

      this.render('{{input type="text" value=value}}', { value: 'original' });

      var input = this.$input()[0];

      // See https://ember-twiddle.com/33e506329f8176ae874422644d4cc08c?openFiles=components.input-component.js%2Ctemplates.components.input-component.hbs
      // this.assertSelectionRange(8, 8); //NOTE: this is (0, 0) on Firefox (TEST_SUITE=sauce)

      this.runTask(function () {
        return _this6.rerender();
      });

      // this.assertSelectionRange(8, 8); //NOTE: this is (0, 0) on Firefox (TEST_SUITE=sauce)

      this.runTask(function () {
        input.selectionStart = 2;
        input.selectionEnd = 4;
      });

      this.assertSelectionRange(2, 4);

      this.runTask(function () {
        return _this6.rerender();
      });

      this.assertSelectionRange(2, 4);

      // this.runTask(() => set(this.context, 'value', 'updated'));
      //
      // this.assertSelectionRange(7, 7); //NOTE: this fails in IE, the range is 0 -> 0 (TEST_SUITE=sauce)
      //
      // this.runTask(() => set(this.context, 'value', 'original'));
      //
      // this.assertSelectionRange(8, 8); //NOTE: this fails in IE, the range is 0 -> 0 (TEST_SUITE=sauce)
    };

    _class.prototype['@test specifying `on="someevent" action="foo"` results in a deprecation warning'] = function testSpecifyingOnSomeeventActionFooResultsInADeprecationWarning() {
      var _this7 = this;

      expectDeprecation(function () {
        _this7.render('{{input on="focus-in" action="doFoo" value="hello"}}');
      }, 'Using \'{{input on="focus-in" action="doFoo"}}\' (\'-top-level\' @ L1:C0) is deprecated. Please use \'{{input focus-in="doFoo"}}\' instead.');
    };

    _class.prototype['@test sends an action with `{{input action="foo"}}` when <enter> is pressed [DEPRECATED]'] = function testSendsAnActionWithInputActionFooWhenEnterIsPressedDEPRECATED(assert) {
      var _this8 = this;

      assert.expect(2);

      expectDeprecation(function () {
        _this8.render('{{input action=\'foo\'}}', {
          actions: {
            foo: function () {
              assert.ok(true, 'action was triggered');
            }
          }
        });
      }, /Please use '{{input enter="foo"}}' instead/);

      this.triggerEvent('keyup', {
        keyCode: 13
      });
    };

    _class.prototype['@test sends an action with `{{input enter="foo"}}` when <enter> is pressed'] = function testSendsAnActionWithInputEnterFooWhenEnterIsPressed(assert) {
      assert.expect(1);

      this.render('{{input enter=\'foo\'}}', {
        actions: {
          foo: function () {
            assert.ok(true, 'action was triggered');
          }
        }
      });

      this.triggerEvent('keyup', {
        keyCode: 13
      });
    };

    _class.prototype['@test sends an action with `{{input key-press="foo"}}` is pressed'] = function testSendsAnActionWithInputKeyPressFooIsPressed(assert) {
      assert.expect(1);

      this.render('{{input value=value key-press=\'foo\'}}', {
        value: 'initial',

        actions: {
          foo: function () {
            assert.ok(true, 'action was triggered');
          }
        }
      });

      this.triggerEvent('keypress', {
        keyCode: 65
      });
    };

    _class.prototype['@test sends an action to the parent level when `bubbles=true` is provided'] = function testSendsAnActionToTheParentLevelWhenBubblesTrueIsProvided(assert) {
      assert.expect(1);

      var ParentComponent = _emberGlimmerTestsUtilsHelpers.Component.extend({
        change: function () {
          assert.ok(true, 'bubbled upwards');
        }
      });

      this.registerComponent('x-parent', {
        ComponentClass: ParentComponent,
        template: '{{input bubbles=true}}'
      });
      this.render('{{x-parent}}');

      this.triggerEvent('change');
    };

    _class.prototype['@test triggers `focus-in` when focused'] = function testTriggersFocusInWhenFocused(assert) {
      var _this9 = this;

      assert.expect(1);

      this.render('{{input focus-in=\'foo\'}}', {
        actions: {
          foo: function () {
            assert.ok(true, 'action was triggered');
          }
        }
      });

      this.runTask(function () {
        _this9.$input().trigger('focusin');
      });
    };

    _class.prototype['@test sends `insert-newline` when <enter> is pressed'] = function testSendsInsertNewlineWhenEnterIsPressed(assert) {
      assert.expect(1);

      this.render('{{input insert-newline=\'foo\'}}', {
        actions: {
          foo: function () {
            assert.ok(true, 'action was triggered');
          }
        }
      });

      this.triggerEvent('keyup', {
        keyCode: 13
      });
    };

    _class.prototype['@test sends an action with `{{input escape-press="foo"}}` when <escape> is pressed'] = function testSendsAnActionWithInputEscapePressFooWhenEscapeIsPressed(assert) {
      assert.expect(1);

      this.render('{{input escape-press=\'foo\'}}', {
        actions: {
          foo: function () {
            assert.ok(true, 'action was triggered');
          }
        }
      });

      this.triggerEvent('keyup', {
        keyCode: 27
      });
    };

    _class.prototype['@test sends an action with `{{input key-down="foo"}}` when a key is pressed'] = function testSendsAnActionWithInputKeyDownFooWhenAKeyIsPressed(assert) {
      assert.expect(1);

      this.render('{{input key-down=\'foo\'}}', {
        actions: {
          foo: function () {
            assert.ok(true, 'action was triggered');
          }
        }
      });

      this.triggerEvent('keydown', {
        keyCode: 65
      });
    };

    _class.prototype['@test sends an action with `{{input key-up="foo"}}` when a key is pressed'] = function testSendsAnActionWithInputKeyUpFooWhenAKeyIsPressed(assert) {
      assert.expect(1);

      this.render('{{input key-up=\'foo\'}}', {
        actions: {
          foo: function () {
            assert.ok(true, 'action was triggered');
          }
        }
      });

      this.triggerEvent('keyup', {
        keyCode: 65
      });
    };

    return _class;
  })(InputRenderingTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: {{input}} with dynamic type', (function (_InputRenderingTest2) {
    babelHelpers.inherits(_class2, _InputRenderingTest2);

    function _class2() {
      _InputRenderingTest2.apply(this, arguments);
    }

    _class2.prototype['@test a bound property can be used to determine type'] = function testABoundPropertyCanBeUsedToDetermineType() {
      var _this10 = this;

      this.render('{{input type=type}}', { type: 'password' });

      this.assertAttr('type', 'password');

      this.runTask(function () {
        return _this10.rerender();
      });

      this.assertAttr('type', 'password');

      this.runTask(function () {
        return _emberMetal.set(_this10.context, 'type', 'text');
      });

      this.assertAttr('type', 'text');

      this.runTask(function () {
        return _emberMetal.set(_this10.context, 'type', 'password');
      });

      this.assertAttr('type', 'password');
    };

    _class2.prototype['@test a subexpression can be used to determine type'] = function testASubexpressionCanBeUsedToDetermineType() {
      var _this11 = this;

      this.render('{{input type=(if isTruthy trueType falseType)}}', {
        isTruthy: true,
        trueType: 'text',
        falseType: 'password'
      });

      this.assertAttr('type', 'text');

      this.runTask(function () {
        return _this11.rerender();
      });

      this.assertAttr('type', 'text');

      this.runTask(function () {
        return _emberMetal.set(_this11.context, 'isTruthy', false);
      });

      this.assertAttr('type', 'password');

      this.runTask(function () {
        return _emberMetal.set(_this11.context, 'isTruthy', true);
      });

      this.assertAttr('type', 'text');
    };

    return _class2;
  })(InputRenderingTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: {{input type=\'checkbox\'}}', (function (_InputRenderingTest3) {
    babelHelpers.inherits(_class3, _InputRenderingTest3);

    function _class3() {
      _InputRenderingTest3.apply(this, arguments);
    }

    _class3.prototype['@test dynamic attributes'] = function testDynamicAttributes() {
      var _this12 = this;

      this.render('{{input\n      type=\'checkbox\'\n      disabled=disabled\n      name=name\n      checked=checked\n      tabindex=tabindex\n    }}', {
        disabled: false,
        name: 'original-name',
        checked: false,
        tabindex: 10
      });

      this.assertSingleCheckbox();
      this.assertNotDisabled();
      this.assertAttr('name', 'original-name');
      this.assertAttr('tabindex', '10');

      this.runTask(function () {
        return _this12.rerender();
      });

      this.assertSingleCheckbox();
      this.assertNotDisabled();
      this.assertAttr('name', 'original-name');
      this.assertAttr('tabindex', '10');

      this.runTask(function () {
        _emberMetal.set(_this12.context, 'disabled', true);
        _emberMetal.set(_this12.context, 'name', 'updated-name');
        _emberMetal.set(_this12.context, 'tabindex', 11);
      });

      this.assertSingleCheckbox();
      this.assertDisabled();
      this.assertAttr('name', 'updated-name');
      this.assertAttr('tabindex', '11');

      this.runTask(function () {
        _emberMetal.set(_this12.context, 'disabled', false);
        _emberMetal.set(_this12.context, 'name', 'original-name');
        _emberMetal.set(_this12.context, 'tabindex', 10);
      });

      this.assertSingleCheckbox();
      this.assertNotDisabled();
      this.assertAttr('name', 'original-name');
      this.assertAttr('tabindex', '10');
    };

    _class3.prototype['@test `value` property assertion'] = function testValuePropertyAssertion() {
      var _this13 = this;

      expectAssertion(function () {
        _this13.render('{{input type="checkbox" value=value}}', { value: 'value' });
      }, /you must use `checked=/);
    };

    _class3.prototype['@test with a bound type'] = function testWithABoundType(assert) {
      var _this14 = this;

      this.render('{{input type=inputType checked=isChecked}}', { inputType: 'checkbox', isChecked: true });

      this.assertSingleCheckbox();
      this.assertCheckboxIsChecked();

      this.runTask(function () {
        return _this14.rerender();
      });

      this.assertCheckboxIsChecked();

      this.runTask(function () {
        return _emberMetal.set(_this14.context, 'isChecked', false);
      });

      this.assertCheckboxIsNotChecked();

      this.runTask(function () {
        return _emberMetal.set(_this14.context, 'isChecked', true);
      });

      this.assertCheckboxIsChecked();
    };

    _class3.prototype['@test with static values'] = function testWithStaticValues(assert) {
      var _this15 = this;

      this.render('{{input type="checkbox" disabled=false tabindex=10 name="original-name" checked=false}}');

      this.assertSingleCheckbox();
      this.assertCheckboxIsNotChecked();
      this.assertNotDisabled();
      this.assertAttr('tabindex', '10');
      this.assertAttr('name', 'original-name');

      this.runTask(function () {
        return _this15.rerender();
      });

      this.assertSingleCheckbox();
      this.assertCheckboxIsNotChecked();
      this.assertNotDisabled();
      this.assertAttr('tabindex', '10');
      this.assertAttr('name', 'original-name');
    };

    return _class3;
  })(InputRenderingTest));

  _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: {{input type=\'text\'}}', (function (_InputRenderingTest4) {
    babelHelpers.inherits(_class4, _InputRenderingTest4);

    function _class4() {
      _InputRenderingTest4.apply(this, arguments);
    }

    _class4.prototype['@test null values'] = function testNullValues(assert) {
      var _this16 = this;

      var attributes = ['disabled', 'placeholder', 'name', 'maxlength', 'size', 'tabindex'];

      this.render('\n      {{input type="text"\n        disabled=disabled\n        value=value\n        placeholder=placeholder\n        name=name\n        maxlength=maxlength\n        size=size\n        tabindex=tabindex\n      }}', {
        disabled: null,
        value: null,
        placeholder: null,
        name: null,
        maxlength: null,
        size: null,
        tabindex: null
      });

      this.assertValue('');
      this.assertAllAttrs(attributes, undefined);

      this.runTask(function () {
        return _this16.rerender();
      });

      this.assertValue('');
      this.assertAllAttrs(attributes, undefined);

      this.runTask(function () {
        _emberMetal.set(_this16.context, 'disabled', true);
        _emberMetal.set(_this16.context, 'value', 'Updated value');
        _emberMetal.set(_this16.context, 'placeholder', 'Updated placeholder');
        _emberMetal.set(_this16.context, 'name', 'updated-name');
        _emberMetal.set(_this16.context, 'maxlength', 11);
        _emberMetal.set(_this16.context, 'size', 21);
        _emberMetal.set(_this16.context, 'tabindex', 31);
      });

      this.assertDisabled();
      this.assertValue('Updated value');
      this.assertAttr('placeholder', 'Updated placeholder');
      this.assertAttr('name', 'updated-name');
      this.assertAttr('maxlength', '11');
      this.assertAttr('size', '21');
      this.assertAttr('tabindex', '31');

      this.runTask(function () {
        _emberMetal.set(_this16.context, 'disabled', null);
        _emberMetal.set(_this16.context, 'value', null);
        _emberMetal.set(_this16.context, 'placeholder', null);
        _emberMetal.set(_this16.context, 'name', null);
        _emberMetal.set(_this16.context, 'maxlength', null);
        // set(this.context, 'size', null); //NOTE: this fails with `Error: Failed to set the 'size' property on 'HTMLInputElement': The value provided is 0, which is an invalid size.` (TEST_SUITE=sauce)
        _emberMetal.set(_this16.context, 'tabindex', null);
      });

      this.assertAttr('disabled', undefined);
      this.assertValue('');
      // this.assertAttr('placeholder', undefined); //NOTE: this fails with a value of "null" (TEST_SUITE=sauce)
      // this.assertAttr('name', undefined); //NOTE: this fails with a value of "null" (TEST_SUITE=sauce)
      this.assertAttr('maxlength', undefined);
      // this.assertAttr('size', undefined); //NOTE: re-enable once `size` bug above has been addressed
      this.assertAttr('tabindex', undefined);
    };

    return _class4;
  })(InputRenderingTest));
});
enifed('ember-glimmer/tests/integration/helpers/loc-test', ['exports', 'ember-glimmer/tests/utils/test-case', 'ember-metal', 'ember'], function (exports, _emberGlimmerTestsUtilsTestCase, _emberMetal, _ember) {
  'use strict';

  _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: {{loc}}', (function (_RenderingTest) {
    babelHelpers.inherits(_class, _RenderingTest);

    function _class() {
      _RenderingTest.call(this);
      this.oldString = _ember.default.STRINGS;
      _ember.default.STRINGS = {
        'Hello Friend': 'Hallo Freund',
        'Hello': 'Hallo, %@'
      };
    }

    _class.prototype.teardown = function teardown() {
      _RenderingTest.prototype.teardown.call(this);
      _ember.default.STRINGS = this.oldString;
    };

    _class.prototype['@test it lets the original value through by default'] = function testItLetsTheOriginalValueThroughByDefault() {
      var _this = this;

      this.render('{{loc "Hiya buddy!"}}');
      this.assertText('Hiya buddy!', 'the unlocalized string is correct');
      this.runTask(function () {
        return _this.rerender();
      });
      this.assertText('Hiya buddy!', 'the unlocalized string is correct after rerender');
    };

    _class.prototype['@test it localizes a simple string'] = function testItLocalizesASimpleString() {
      var _this2 = this;

      this.render('{{loc "Hello Friend"}}');
      this.assertText('Hallo Freund', 'the localized string is correct');
      this.runTask(function () {
        return _this2.rerender();
      });
      this.assertText('Hallo Freund', 'the localized string is correct after rerender');
    };

    _class.prototype['@test it takes passed formats into an account'] = function testItTakesPassedFormatsIntoAnAccount() {
      var _this3 = this;

      this.render('{{loc "%@, %@" "Hello" "Mr. Pitkin"}}');
      this.assertText('Hello, Mr. Pitkin', 'the formatted string is correct');
      this.runTask(function () {
        return _this3.rerender();
      });
      this.assertText('Hello, Mr. Pitkin', 'the formatted string is correct after rerender');
    };

    _class.prototype['@test it updates when bound params change'] = function testItUpdatesWhenBoundParamsChange() {
      var _this4 = this;

      this.render('{{loc simple}} - {{loc personal \'Mr. Pitkin\'}}', {
        simple: 'Hello Friend',
        personal: 'Hello'
      });
      this.assertText('Hallo Freund - Hallo, Mr. Pitkin', 'the bound value is correct');

      this.runTask(function () {
        return _this4.rerender();
      });
      this.assertText('Hallo Freund - Hallo, Mr. Pitkin', 'the bound value is correct after rerender');

      this.runTask(function () {
        return _emberMetal.set(_this4.context, 'simple', 'G\'day mate');
      });
      this.assertText('G\'day mate - Hallo, Mr. Pitkin', 'the bound value is correct after update');

      this.runTask(function () {
        return _emberMetal.set(_this4.context, 'simple', 'Hello Friend');
      });
      this.assertText('Hallo Freund - Hallo, Mr. Pitkin', 'the bound value is correct after reset');
    };

    _class.prototype['@test it updates when nested bound params change'] = function testItUpdatesWhenNestedBoundParamsChange() {
      var _this5 = this;

      this.render('{{loc greetings.simple}} - {{loc greetings.personal \'Mr. Pitkin\'}}', {
        greetings: {
          simple: 'Hello Friend',
          personal: 'Hello'
        }
      });
      this.assertText('Hallo Freund - Hallo, Mr. Pitkin', 'the bound value is correct');

      this.runTask(function () {
        return _this5.rerender();
      });
      this.assertText('Hallo Freund - Hallo, Mr. Pitkin', 'the bound value is correct after rerender');

      this.runTask(function () {
        return _emberMetal.set(_this5.context, 'greetings.simple', 'G\'day mate');
      });
      this.assertText('G\'day mate - Hallo, Mr. Pitkin', 'the bound value is correct after interior mutation');

      this.runTask(function () {
        return _emberMetal.set(_this5.context, 'greetings', {
          simple: 'Hello Friend',
          personal: 'Hello'
        });
      });
      this.assertText('Hallo Freund - Hallo, Mr. Pitkin', 'the bound value is correct after replacement');
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
});
enifed('ember-glimmer/tests/integration/helpers/log-test', ['exports', 'ember-glimmer/tests/utils/test-case', 'ember-console'], function (exports, _emberGlimmerTestsUtilsTestCase, _emberConsole) {
  'use strict';

  _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: {{log}}', (function (_RenderingTest) {
    babelHelpers.inherits(_class, _RenderingTest);

    function _class(assert) {
      var _this = this;

      _RenderingTest.call(this);

      this.originalLog = _emberConsole.default.log;
      this.logCalls = [];
      _emberConsole.default.log = function () {
        var _logCalls;

        (_logCalls = _this.logCalls).push.apply(_logCalls, arguments);
      };
    }

    _class.prototype.teardown = function teardown() {
      _RenderingTest.prototype.teardown.call(this);
      _emberConsole.default.log = this.originalLog;
    };

    _class.prototype.assertLog = function assertLog(values) {
      this.assertText('');
      this.assert.strictEqual(this.logCalls.length, values.length);

      for (var i = 0, len = values.length; i < len; i++) {
        this.assert.strictEqual(this.logCalls[i], values[i]);
      }
    };

    _class.prototype['@test correctly logs primitives'] = function testCorrectlyLogsPrimitives() {
      this.render('{{log "one" 1 true}}');

      this.assertLog(['one', 1, true]);
    };

    _class.prototype['@test correctly logs a property'] = function testCorrectlyLogsAProperty() {
      this.render('{{log value}}', {
        value: 'one'
      });

      this.assertLog(['one']);
    };

    _class.prototype['@test correctly logs multiple arguments'] = function testCorrectlyLogsMultipleArguments() {
      this.render('{{log "my variable:" value}}', {
        value: 'one'
      });

      this.assertLog(['my variable:', 'one']);
    };

    _class.prototype['@test correctly logs `this`'] = function testCorrectlyLogsThis() {
      this.render('{{log this}}');

      this.assertLog([this.context]);
    };

    return _class;
  })(_emberGlimmerTestsUtilsTestCase.RenderingTest));
});
enifed('ember-glimmer/tests/integration/helpers/mut-test', ['exports', 'ember-glimmer/tests/utils/test-case', 'ember-glimmer/tests/utils/helpers', 'ember-metal', 'ember-glimmer/tests/utils/test-helpers'], function (exports, _emberGlimmerTestsUtilsTestCase, _emberGlimmerTestsUtilsHelpers, _emberMetal, _emberGlimmerTestsUtilsTestHelpers) {
  'use strict';

  _emberGlimmerTestsUtilsTestCase.moduleFor('Helpers test: {{mut}}', (function (_RenderingTest) {
    babelHelpers.inherits(_class, _RenderingTest);

    function _class() {
      _RenderingTest.apply(this, arguments);
    }

    _class.prototype['@test a simple mutable binding using `mut` propagates properly'] = function testASimpleMutableBindingUsingMutPropagatesProperly() {
      var _this = this;

      var bottom = undefined;

      this.registerComponent('bottom-mut', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          didInsertElement: function () {
            bottom = this;
          }
        }),
        template: '{{setMe}}'
      });

      this.registerComponent('middle-mut', {
        template: '{{bottom-mut setMe=value}}'
      });

      this.render('{{middle-mut value=(mut val)}}', {
        val: 12
      });

      this.assertText('12', 'the data propagated downwards');

      this.assertStableRerender();

      this.runTask(function () {
        return bottom.attrs.setMe.update(13);
      });

      this.assertText('13', 'the set took effect');
      this.assert.strictEqual(_emberMetal.get(bottom, 'setMe'), 13, 'the set took effect on bottom\'s prop');
      this.assert.strictEqual(bottom.attrs.setMe.value, 13, 'the set took effect on bottom\'s attr');
      this.assert.strictEqual(_emberMetal.get(this.context, 'val'), 13, 'the set propagated back up');

      this.runTask(function () {
        return _emberMetal.set(bottom, 'setMe', 14);
      });

      this.assertText('14', 'the set took effect');
      this.assert.strictEqual(_emberMetal.get(bottom, 'setMe'), 14, 'the set took effect on bottom\'s prop');
      this.assert.strictEqual(bottom.attrs.setMe.value, 14, 'the set took effect on bottom\'s attr');
      this.assert.strictEqual(_emberMetal.get(this.context, 'val'), 14, 'the set propagated back up');

      this.runTask(function () {
        return _emberMetal.set(_this.context, 'val', 12);
      });

      this.assertText('12');
    };

    _class.prototype['@test a simple mutable binding using `mut` inserts into the DOM'] = function testASimpleMutableBindingUsingMutInsertsIntoTheDOM() {
      var _this2 = this;

      var bottom = undefined,
          middle = undefined;

      this.registerComponent('bottom-mut', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          didInsertElement: function () {
            bottom = this;
          }
        }),
        template: '{{setMe}}'
      });

      this.registerComponent('middle-mut', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          didInsertElement: function () {
            middle = this;
          }
        }),
        template: '{{bottom-mut setMe=(mut value)}}'
      });

      this.render('{{middle-mut value=(mut val)}}', {
        val: 12
      });

      this.assertText('12', 'the data propagated downwards');

      this.assertStableRerender();

      this.runTask(function () {
        return bottom.attrs.setMe.update(13);
      });

      this.assertText('13', 'the set took effect');
      this.assert.strictEqual(_emberMetal.get(bottom, 'setMe'), 13, 'the set took effect on bottom\'s prop');
      this.assert.strictEqual(bottom.attrs.setMe.value, 13, 'the set took effect on bottom\'s attr');
      this.assert.strictEqual(_emberMetal.get(middle, 'value'), 13, 'the set propagated to middle\'s prop');
      this.assert.strictEqual(middle.attrs.value.value, 13, 'the set propagated to middle\'s attr');
      this.assert.strictEqual(_emberMetal.get(this.context, 'val'), 13, 'the set propagated back up');

      this.runTask(function () {
        return _emberMetal.set(bottom, 'setMe', 14);
      });

      this.assertText('14', 'the set took effect');
      this.assert.strictEqual(_emberMetal.get(bottom, 'setMe'), 14, 'the set took effect on bottom\'s prop');
      this.assert.strictEqual(bottom.attrs.setMe.value, 14, 'the set took effect on bottom\'s attr');
      this.assert.strictEqual(_emberMetal.get(middle, 'value'), 14, 'the set propagated to middle\'s prop');
      this.assert.strictEqual(middle.attrs.value.value, 14, 'the set propagated to middle\'s attr');
      this.assert.strictEqual(_emberMetal.get(this.context, 'val'), 14, 'the set propagated back up');

      this.runTask(function () {
        return _emberMetal.set(_this2.context, 'val', 12);
      });

      this.assertText('12');
    };

    _class.prototype['@test passing a literal results in a assertion'] = function testPassingALiteralResultsInAAssertion() {
      var _this3 = this;

      this.registerComponent('bottom-mut', { template: '{{setMe}}' });

      expectAssertion(function () {
        _this3.render('{{bottom-mut setMe=(mut "foo bar")}}');
      }, 'You can only pass a path to mut');
    };

    _class.prototype['@test passing the result of a helper invocation results in an assertion'] = function testPassingTheResultOfAHelperInvocationResultsInAnAssertion() {
      var _this4 = this;

      this.registerComponent('bottom-mut', { template: '{{setMe}}' });

      expectAssertion(function () {
        _this4.render('{{bottom-mut setMe=(mut (concat "foo" " " "bar"))}}');
      }, 'You can only pass a path to mut');
    };

    // See https://github.com/emberjs/ember.js/commit/807a0cd for an explanation of this test

    _class.prototype['@test using a string value through middle tier does not trigger assertion (due to the auto-mut transform)'] = function testUsingAStringValueThroughMiddleTierDoesNotTriggerAssertionDueToTheAutoMutTransform() {
      var bottom = undefined;

      this.registerComponent('bottom-mut', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          didInsertElement: function () {
            bottom = this;
          }
        }),
        template: '{{stuff}}'
      });

      this.registerComponent('middle-mut', {
        template: '{{bottom-mut stuff=value}}'
      });

      this.render('{{middle-mut value="foo"}}');

      this.assert.equal(_emberMetal.get(bottom, 'stuff'), 'foo', 'the data propagated');
      this.assertText('foo');

      this.assertStableRerender();

      // No U-R for this test
    };

    _class.prototype['@test {{readonly}} of a {{mut}} is converted into an immutable binding'] = function testReadonlyOfAMutIsConvertedIntoAnImmutableBinding() {
      var _this5 = this;

      var middle = undefined,
          bottom = undefined;

      this.registerComponent('bottom-mut', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          didInsertElement: function () {
            bottom = this;
          }
        }),
        template: '{{setMe}}'
      });

      this.registerComponent('middle-mut', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          didInsertElement: function () {
            middle = this;
          }
        }),
        template: '{{bottom-mut setMe=(readonly value)}}'
      });

      this.render('{{middle-mut value=(mut val)}}', {
        val: 12
      });

      this.assertText('12');

      this.assertStableRerender();

      this.runTask(function () {
        return middle.attrs.value.update(13);
      });

      this.assert.strictEqual(_emberMetal.get(middle, 'value'), 13, 'the set took effect on middle\'s prop');
      this.assert.strictEqual(middle.attrs.value.value, 13, 'the set took effect on middle\'s attr');

      this.runTask(function () {
        return _emberMetal.set(middle, 'value', 14);
      });

      this.assert.strictEqual(_emberMetal.get(middle, 'value'), 14, 'the set took effect on middle\'s prop');
      this.assert.strictEqual(middle.attrs.value.value, 14, 'the set took effect on middle\'s attr');
      this.assert.strictEqual(bottom.attrs.setMe, 14, 'the mutable binding has been converted to an immutable cell');
      this.assertText('14');
      this.assert.strictEqual(_emberMetal.get(this.context, 'val'), 14, 'the set propagated back up');

      this.runTask(function () {
        return _emberMetal.set(_this5.context, 'val', 12);
      });

      this.assertText('12');
    };

    _class.prototype['@test mutable bindings work inside of yielded content'] = function testMutableBindingsWorkInsideOfYieldedContent() {
      var _this6 = this;

      this.registerComponent('bottom-mut', {
        template: '{{yield}}'
      });

      this.registerComponent('middle-mut', {
        template: '{{#bottom-mut}}{{model.name}}{{/bottom-mut}}'
      });

      this.render('{{middle-mut model=(mut model)}}', {
        model: { name: 'Matthew Beale' }
      });

      this.assertText('Matthew Beale');

      this.assertStableRerender();

      this.runTask(function () {
        return _emberMetal.set(_this6.context, 'model.name', 'Joel Kang');
      });

      this.assertText('Joel Kang');

      this.runTask(function () {
        return _emberMetal.set(_this6.context, 'model', { name: 'Matthew Beale' });
      });

      this.assertText('Matthew Beale');
    };

    _class.prototype['@test a simple mutable binding using {{mut}} is available in hooks'] = function testASimpleMutableBindingUsingMutIsAvailableInHooks() {
      var _this7 = this;

      var bottom = undefined;
      var willRender = [];
      var didInsert = [];

      this.registerComponent('bottom-mut', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          willRender: function () {
            willRender.push(_emberMetal.get(this, 'setMe'));
          },
          didInsertElement: function () {
            didInsert.push(_emberMetal.get(this, 'setMe'));
            bottom = this;
          }
        }),
        template: '{{setMe}}'
      });

      this.registerComponent('middle-mut', {
        template: '{{bottom-mut setMe=(mut value)}}'
      });

      this.render('{{middle-mut value=(mut val)}}', {
        val: 12
      });

      this.assert.deepEqual(willRender, [12], 'willReceive is [12]');
      this.assert.deepEqual(didInsert, [12], 'didInsert is [12]');
      this.assertText('12');

      this.assertStableRerender();

      this.assert.deepEqual(willRender, [12], 'willReceive is [12]');
      this.assert.deepEqual(didInsert, [12], 'didInsert is [12]');
      this.assert.strictEqual(_emberMetal.get(bottom, 'setMe'), 12, 'the data propagated');

      this.runTask(function () {
        return bottom.attrs.setMe.update(13);
      });

      this.assert.strictEqual(_emberMetal.get(bottom, 'setMe'), 13, 'the set took effect on bottom\'s prop');
      this.assert.strictEqual(bottom.attrs.setMe.value, 13, 'the set took effect on bottom\'s attr');
      this.assert.strictEqual(_emberMetal.get(this.context, 'val'), 13, 'the set propagated back up');

      this.runTask(function () {
        return _emberMetal.set(bottom, 'setMe', 14);
      });

      this.assert.strictEqual(_emberMetal.get(bottom, 'setMe'), 14, 'the set took effect on bottom\'s prop');
      this.assert.strictEqual(bottom.attrs.setMe.value, 14, 'the set took effect on bottom\'s attr');
      this.assert.strictEqual(_emberMetal.get(this.context, 'val'), 14, 'the set propagated back up');

      this.runTask(function () {
        return _emberMetal.set(_this7.context, 'val', 12);
      });

      this.assertText('12');
    };

    _class.prototype['@test a mutable binding with a backing computed property and attribute present in the root of the component is updated when the upstream property invalidates #11023'] = function testAMutableBindingWithABackingComputedPropertyAndAttributePresentInTheRootOfTheComponentIsUpdatedWhenTheUpstreamPropertyInvalidates11023() {
      var bottom = undefined,
          middle = undefined;

      this.registerComponent('bottom-mut', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          thingy: null,
          didInsertElement: function () {
            bottom = this;
          }
        }),
        template: '{{thingy}}'
      });

      this.registerComponent('middle-mut', {
        ComponentClass: _emberGlimmerTestsUtilsHelpers.Component.extend({
          baseValue: 12,
          val: _emberMetal.computed('baseValue', function () {
            return this.get('baseValue');
          }),
          didInsertElement: function () {
            middle = this;
          }
        }),
        template: 