(function() {
/*!
 * @overview  Ember - JavaScript Application Framework
 * @copyright Copyright 2011-2017 Tilde Inc. and contributors
 *            Portions Copyright 2006-2011 Strobe Inc.
 *            Portions Copyright 2008-2011 Apple Inc. All rights reserved.
 * @license   Licensed under MIT license
 *            See https://raw.github.com/emberjs/ember.js/master/LICENSE
 * @version   2.17.2
 */

var enifed, requireModule, Ember;
var mainContext = this; // Used in ember-environment/lib/global.js

(function() {
  var isNode = typeof window === 'undefined' &&
    typeof process !== 'undefined' && {}.toString.call(process) === '[object process]';

  if (!isNode) {
    Ember = this.Ember = this.Ember || {};
  }

  if (typeof Ember === 'undefined') { Ember = {}; }

  if (typeof Ember.__loader === 'undefined') {
    var registry = {};
    var seen = {};

    enifed = function(name, deps, callback) {
      var value = { };

      if (!callback) {
        value.deps = [];
        value.callback = deps;
      } else {
        value.deps = deps;
        value.callback = callback;
      }

      registry[name] = value;
    };

    requireModule = function(name) {
      return internalRequire(name, null);
    };

    // setup `require` module
    requireModule['default'] = requireModule;

    requireModule.has = function registryHas(moduleName) {
      return !!registry[moduleName] || !!registry[moduleName + '/index'];
    };

    function missingModule(name, referrerName) {
      if (referrerName) {
        throw new Error('Could not find module ' + name + ' required by: ' + referrerName);
      } else {
        throw new Error('Could not find module ' + name);
      }
    }

    function internalRequire(_name, referrerName) {
      var name = _name;
      var mod = registry[name];

      if (!mod) {
        name = name + '/index';
        mod = registry[name];
      }

      var exports = seen[name];

      if (exports !== undefined) {
        return exports;
      }

      exports = seen[name] = {};

      if (!mod) {
        missingModule(_name, referrerName);
      }

      var deps = mod.deps;
      var callback = mod.callback;
      var reified = new Array(deps.length);

      for (var i = 0; i < deps.length; i++) {
        if (deps[i] === 'exports') {
          reified[i] = exports;
        } else if (deps[i] === 'require') {
          reified[i] = requireModule;
        } else {
          reified[i] = internalRequire(deps[i], name);
        }
      }

      callback.apply(this, reified);

      return exports;
    }

    requireModule._eak_seen = registry;

    Ember.__loader = {
      define: enifed,
      require: requireModule,
      registry: registry
    };
  } else {
    enifed = Ember.__loader.define;
    requireModule = Ember.__loader.require;
  }
})();

enifed("@glimmer/node", ["exports", "@glimmer/runtime"], function (exports, _runtime) {
    "use strict";

    exports.NodeDOMTreeConstruction = undefined;


    function _defaults(obj, defaults) {
        var keys = Object.getOwnPropertyNames(defaults);for (var i = 0; i < keys.length; i++) {
            var key = keys[i];var value = Object.getOwnPropertyDescriptor(defaults, key);if (value && value.configurable && obj[key] === undefined) {
                Object.defineProperty(obj, key, value);
            }
        }return obj;
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults(subClass, superClass);
    }

    var NodeDOMTreeConstruction = function (_DOMTreeConstruction) {
        _inherits(NodeDOMTreeConstruction, _DOMTreeConstruction);

        function NodeDOMTreeConstruction(doc) {
            _classCallCheck(this, NodeDOMTreeConstruction);

            return _possibleConstructorReturn(this, _DOMTreeConstruction.call(this, doc));
        }
        // override to prevent usage of `this.document` until after the constructor


        NodeDOMTreeConstruction.prototype.setupUselessElement = function setupUselessElement() {};

        NodeDOMTreeConstruction.prototype.insertHTMLBefore = function insertHTMLBefore(parent, reference, html) {
            var prev = reference ? reference.previousSibling : parent.lastChild;
            var raw = this.document.createRawHTMLSection(html);
            parent.insertBefore(raw, reference);
            var first = prev ? prev.nextSibling : parent.firstChild;
            var last = reference ? reference.previousSibling : parent.lastChild;
            return new _runtime.ConcreteBounds(parent, first, last);
        };
        // override to avoid SVG detection/work when in node (this is not needed in SSR)


        NodeDOMTreeConstruction.prototype.createElement = function createElement(tag) {
            return this.document.createElement(tag);
        };
        // override to avoid namespace shenanigans when in node (this is not needed in SSR)


        NodeDOMTreeConstruction.prototype.setAttribute = function setAttribute(element, name, value) {
            element.setAttribute(name, value);
        };

        return NodeDOMTreeConstruction;
    }(_runtime.DOMTreeConstruction);

    exports.NodeDOMTreeConstruction = NodeDOMTreeConstruction;
});
enifed("@glimmer/reference", ["exports", "@glimmer/util"], function (exports, _util) {
    "use strict";

    exports.isModified = exports.ReferenceCache = exports.map = exports.CachedReference = exports.UpdatableTag = exports.CachedTag = exports.combine = exports.combineSlice = exports.combineTagged = exports.DirtyableTag = exports.CURRENT_TAG = exports.VOLATILE_TAG = exports.CONSTANT_TAG = exports.TagWrapper = exports.RevisionTag = exports.VOLATILE = exports.INITIAL = exports.CONSTANT = exports.IteratorSynchronizer = exports.ReferenceIterator = exports.IterationArtifacts = exports.referenceFromParts = exports.ListItem = exports.isConst = exports.ConstReference = undefined;


    function _defaults(obj, defaults) {
        var keys = Object.getOwnPropertyNames(defaults);for (var i = 0; i < keys.length; i++) {
            var key = keys[i];var value = Object.getOwnPropertyDescriptor(defaults, key);if (value && value.configurable && obj[key] === undefined) {
                Object.defineProperty(obj, key, value);
            }
        }return obj;
    }

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults(subClass, superClass);
    }

    function _classCallCheck$1(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var CONSTANT = 0;
    var INITIAL = 1;
    var VOLATILE = NaN;
    var RevisionTag = function () {
        function RevisionTag() {
            _classCallCheck$1(this, RevisionTag);
        }

        RevisionTag.prototype.validate = function validate(snapshot) {
            return this.value() === snapshot;
        };

        return RevisionTag;
    }();
    RevisionTag.id = 0;
    var VALUE = [];
    var VALIDATE = [];
    var TagWrapper = function () {
        function TagWrapper(type, inner) {
            _classCallCheck$1(this, TagWrapper);

            this.type = type;
            this.inner = inner;
        }

        TagWrapper.prototype.value = function value() {
            var func = VALUE[this.type];
            return func(this.inner);
        };

        TagWrapper.prototype.validate = function validate(snapshot) {
            var func = VALIDATE[this.type];
            return func(this.inner, snapshot);
        };

        return TagWrapper;
    }();
    function register(Type) {
        var type = VALUE.length;
        VALUE.push(function (tag) {
            return tag.value();
        });
        VALIDATE.push(function (tag, snapshot) {
            return tag.validate(snapshot);
        });
        Type.id = type;
    }
    ///
    // CONSTANT: 0
    VALUE.push(function () {
        return CONSTANT;
    });
    VALIDATE.push(function (_tag, snapshot) {
        return snapshot === CONSTANT;
    });
    var CONSTANT_TAG = new TagWrapper(0, null);
    // VOLATILE: 1
    VALUE.push(function () {
        return VOLATILE;
    });
    VALIDATE.push(function (_tag, snapshot) {
        return snapshot === VOLATILE;
    });
    var VOLATILE_TAG = new TagWrapper(1, null);
    // CURRENT: 2
    VALUE.push(function () {
        return $REVISION;
    });
    VALIDATE.push(function (_tag, snapshot) {
        return snapshot === $REVISION;
    });
    var CURRENT_TAG = new TagWrapper(2, null);
    ///
    var $REVISION = INITIAL;
    var DirtyableTag = function (_RevisionTag) {
        _inherits(DirtyableTag, _RevisionTag);

        DirtyableTag.create = function create() {
            var revision = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : $REVISION;

            return new TagWrapper(this.id, new DirtyableTag(revision));
        };

        function DirtyableTag() {
            var revision = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : $REVISION;

            _classCallCheck$1(this, DirtyableTag);

            var _this = _possibleConstructorReturn(this, _RevisionTag.call(this));

            _this.revision = revision;
            return _this;
        }

        DirtyableTag.prototype.value = function value() {
            return this.revision;
        };

        DirtyableTag.prototype.dirty = function dirty() {
            this.revision = ++$REVISION;
        };

        return DirtyableTag;
    }(RevisionTag);
    register(DirtyableTag);
    function combineTagged(tagged) {
        var optimized = [];
        for (var i = 0, l = tagged.length; i < l; i++) {
            var tag = tagged[i].tag;
            if (tag === VOLATILE_TAG) return VOLATILE_TAG;
            if (tag === CONSTANT_TAG) continue;
            optimized.push(tag);
        }
        return _combine(optimized);
    }
    function combineSlice(slice) {
        var optimized = [];
        var node = slice.head();
        while (node !== null) {
            var tag = node.tag;
            if (tag === VOLATILE_TAG) return VOLATILE_TAG;
            if (tag !== CONSTANT_TAG) optimized.push(tag);
            node = slice.nextNode(node);
        }
        return _combine(optimized);
    }
    function combine(tags) {
        var optimized = [];
        for (var i = 0, l = tags.length; i < l; i++) {
            var tag = tags[i];
            if (tag === VOLATILE_TAG) return VOLATILE_TAG;
            if (tag === CONSTANT_TAG) continue;
            optimized.push(tag);
        }
        return _combine(optimized);
    }
    function _combine(tags) {
        switch (tags.length) {
            case 0:
                return CONSTANT_TAG;
            case 1:
                return tags[0];
            case 2:
                return TagsPair.create(tags[0], tags[1]);
            default:
                return TagsCombinator.create(tags);
        }
    }
    var CachedTag = function (_RevisionTag2) {
        _inherits(CachedTag, _RevisionTag2);

        function CachedTag() {
            _classCallCheck$1(this, CachedTag);

            var _this2 = _possibleConstructorReturn(this, _RevisionTag2.apply(this, arguments));

            _this2.lastChecked = null;
            _this2.lastValue = null;
            return _this2;
        }

        CachedTag.prototype.value = function value() {
            var lastChecked = this.lastChecked,
                lastValue = this.lastValue;

            if (lastChecked !== $REVISION) {
                this.lastChecked = $REVISION;
                this.lastValue = lastValue = this.compute();
            }
            return this.lastValue;
        };

        CachedTag.prototype.invalidate = function invalidate() {
            this.lastChecked = null;
        };

        return CachedTag;
    }(RevisionTag);

    var TagsPair = function (_CachedTag) {
        _inherits(TagsPair, _CachedTag);

        TagsPair.create = function create(first, second) {
            return new TagWrapper(this.id, new TagsPair(first, second));
        };

        function TagsPair(first, second) {
            _classCallCheck$1(this, TagsPair);

            var _this3 = _possibleConstructorReturn(this, _CachedTag.call(this));

            _this3.first = first;
            _this3.second = second;
            return _this3;
        }

        TagsPair.prototype.compute = function compute() {
            return Math.max(this.first.value(), this.second.value());
        };

        return TagsPair;
    }(CachedTag);

    register(TagsPair);

    var TagsCombinator = function (_CachedTag2) {
        _inherits(TagsCombinator, _CachedTag2);

        TagsCombinator.create = function create(tags) {
            return new TagWrapper(this.id, new TagsCombinator(tags));
        };

        function TagsCombinator(tags) {
            _classCallCheck$1(this, TagsCombinator);

            var _this4 = _possibleConstructorReturn(this, _CachedTag2.call(this));

            _this4.tags = tags;
            return _this4;
        }

        TagsCombinator.prototype.compute = function compute() {
            var tags = this.tags;

            var max = -1;
            for (var i = 0; i < tags.length; i++) {
                var value = tags[i].value();
                max = Math.max(value, max);
            }
            return max;
        };

        return TagsCombinator;
    }(CachedTag);

    register(TagsCombinator);
    var UpdatableTag = function (_CachedTag3) {
        _inherits(UpdatableTag, _CachedTag3);

        UpdatableTag.create = function create(tag) {
            return new TagWrapper(this.id, new UpdatableTag(tag));
        };

        function UpdatableTag(tag) {
            _classCallCheck$1(this, UpdatableTag);

            var _this5 = _possibleConstructorReturn(this, _CachedTag3.call(this));

            _this5.tag = tag;
            _this5.lastUpdated = INITIAL;
            return _this5;
        }

        UpdatableTag.prototype.compute = function compute() {
            return Math.max(this.lastUpdated, this.tag.value());
        };

        UpdatableTag.prototype.update = function update(tag) {
            if (tag !== this.tag) {
                this.tag = tag;
                this.lastUpdated = $REVISION;
                this.invalidate();
            }
        };

        return UpdatableTag;
    }(CachedTag);
    register(UpdatableTag);
    var CachedReference = function () {
        function CachedReference() {
            _classCallCheck$1(this, CachedReference);

            this.lastRevision = null;
            this.lastValue = null;
        }

        CachedReference.prototype.value = function value() {
            var tag = this.tag,
                lastRevision = this.lastRevision,
                lastValue = this.lastValue;

            if (!lastRevision || !tag.validate(lastRevision)) {
                lastValue = this.lastValue = this.compute();
                this.lastRevision = tag.value();
            }
            return lastValue;
        };

        CachedReference.prototype.invalidate = function invalidate() {
            this.lastRevision = null;
        };

        return CachedReference;
    }();

    var MapperReference = function (_CachedReference) {
        _inherits(MapperReference, _CachedReference);

        function MapperReference(reference, mapper) {
            _classCallCheck$1(this, MapperReference);

            var _this6 = _possibleConstructorReturn(this, _CachedReference.call(this));

            _this6.tag = reference.tag;
            _this6.reference = reference;
            _this6.mapper = mapper;
            return _this6;
        }

        MapperReference.prototype.compute = function compute() {
            var reference = this.reference,
                mapper = this.mapper;

            return mapper(reference.value());
        };

        return MapperReference;
    }(CachedReference);

    function map(reference, mapper) {
        return new MapperReference(reference, mapper);
    }
    //////////
    var ReferenceCache = function () {
        function ReferenceCache(reference) {
            _classCallCheck$1(this, ReferenceCache);

            this.lastValue = null;
            this.lastRevision = null;
            this.initialized = false;
            this.tag = reference.tag;
            this.reference = reference;
        }

        ReferenceCache.prototype.peek = function peek() {
            if (!this.initialized) {
                return this.initialize();
            }
            return this.lastValue;
        };

        ReferenceCache.prototype.revalidate = function revalidate() {
            if (!this.initialized) {
                return this.initialize();
            }
            var reference = this.reference,
                lastRevision = this.lastRevision;

            var tag = reference.tag;
            if (tag.validate(lastRevision)) return NOT_MODIFIED;
            this.lastRevision = tag.value();
            var lastValue = this.lastValue;

            var value = reference.value();
            if (value === lastValue) return NOT_MODIFIED;
            this.lastValue = value;
            return value;
        };

        ReferenceCache.prototype.initialize = function initialize() {
            var reference = this.reference;

            var value = this.lastValue = reference.value();
            this.lastRevision = reference.tag.value();
            this.initialized = true;
            return value;
        };

        return ReferenceCache;
    }();
    var NOT_MODIFIED = "adb3b78e-3d22-4e4b-877a-6317c2c5c145";
    function isModified(value) {
        return value !== NOT_MODIFIED;
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var ConstReference = function () {
        function ConstReference(inner) {
            _classCallCheck(this, ConstReference);

            this.inner = inner;
            this.tag = CONSTANT_TAG;
        }

        ConstReference.prototype.value = function value() {
            return this.inner;
        };

        return ConstReference;
    }();
    function isConst(reference) {
        return reference.tag === CONSTANT_TAG;
    }

    function _defaults$1(obj, defaults) {
        var keys = Object.getOwnPropertyNames(defaults);for (var i = 0; i < keys.length; i++) {
            var key = keys[i];var value = Object.getOwnPropertyDescriptor(defaults, key);if (value && value.configurable && obj[key] === undefined) {
                Object.defineProperty(obj, key, value);
            }
        }return obj;
    }

    function _classCallCheck$2(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    function _possibleConstructorReturn$1(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits$1(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults$1(subClass, superClass);
    }

    var ListItem = function (_ListNode) {
        _inherits$1(ListItem, _ListNode);

        function ListItem(iterable, result) {
            _classCallCheck$2(this, ListItem);

            var _this = _possibleConstructorReturn$1(this, _ListNode.call(this, iterable.valueReferenceFor(result)));

            _this.retained = false;
            _this.seen = false;
            _this.key = result.key;
            _this.iterable = iterable;
            _this.memo = iterable.memoReferenceFor(result);
            return _this;
        }

        ListItem.prototype.update = function update(item) {
            this.retained = true;
            this.iterable.updateValueReference(this.value, item);
            this.iterable.updateMemoReference(this.memo, item);
        };

        ListItem.prototype.shouldRemove = function shouldRemove() {
            return !this.retained;
        };

        ListItem.prototype.reset = function reset() {
            this.retained = false;
            this.seen = false;
        };

        return ListItem;
    }(_util.ListNode);
    var IterationArtifacts = function () {
        function IterationArtifacts(iterable) {
            _classCallCheck$2(this, IterationArtifacts);

            this.map = (0, _util.dict)();
            this.list = new _util.LinkedList();
            this.tag = iterable.tag;
            this.iterable = iterable;
        }

        IterationArtifacts.prototype.isEmpty = function isEmpty() {
            var iterator = this.iterator = this.iterable.iterate();
            return iterator.isEmpty();
        };

        IterationArtifacts.prototype.iterate = function iterate() {
            var iterator = this.iterator || this.iterable.iterate();
            this.iterator = null;
            return iterator;
        };

        IterationArtifacts.prototype.has = function has(key) {
            return !!this.map[key];
        };

        IterationArtifacts.prototype.get = function get(key) {
            return this.map[key];
        };

        IterationArtifacts.prototype.wasSeen = function wasSeen(key) {
            var node = this.map[key];
            return node && node.seen;
        };

        IterationArtifacts.prototype.append = function append(item) {
            var map = this.map,
                list = this.list,
                iterable = this.iterable;

            var node = map[item.key] = new ListItem(iterable, item);
            list.append(node);
            return node;
        };

        IterationArtifacts.prototype.insertBefore = function insertBefore(item, reference) {
            var map = this.map,
                list = this.list,
                iterable = this.iterable;

            var node = map[item.key] = new ListItem(iterable, item);
            node.retained = true;
            list.insertBefore(node, reference);
            return node;
        };

        IterationArtifacts.prototype.move = function move(item, reference) {
            var list = this.list;

            item.retained = true;
            list.remove(item);
            list.insertBefore(item, reference);
        };

        IterationArtifacts.prototype.remove = function remove(item) {
            var list = this.list;

            list.remove(item);
            delete this.map[item.key];
        };

        IterationArtifacts.prototype.nextNode = function nextNode(item) {
            return this.list.nextNode(item);
        };

        IterationArtifacts.prototype.head = function head() {
            return this.list.head();
        };

        return IterationArtifacts;
    }();
    var ReferenceIterator = function () {
        // if anyone needs to construct this object with something other than
        // an iterable, let @wycats know.
        function ReferenceIterator(iterable) {
            _classCallCheck$2(this, ReferenceIterator);

            this.iterator = null;
            var artifacts = new IterationArtifacts(iterable);
            this.artifacts = artifacts;
        }

        ReferenceIterator.prototype.next = function next() {
            var artifacts = this.artifacts;

            var iterator = this.iterator = this.iterator || artifacts.iterate();
            var item = iterator.next();
            if (!item) return null;
            return artifacts.append(item);
        };

        return ReferenceIterator;
    }();
    var Phase;
    (function (Phase) {
        Phase[Phase["Append"] = 0] = "Append";
        Phase[Phase["Prune"] = 1] = "Prune";
        Phase[Phase["Done"] = 2] = "Done";
    })(Phase || (Phase = {}));
    var IteratorSynchronizer = function () {
        function IteratorSynchronizer(_ref) {
            var target = _ref.target,
                artifacts = _ref.artifacts;

            _classCallCheck$2(this, IteratorSynchronizer);

            this.target = target;
            this.artifacts = artifacts;
            this.iterator = artifacts.iterate();
            this.current = artifacts.head();
        }

        IteratorSynchronizer.prototype.sync = function sync() {
            var phase = Phase.Append;
            while (true) {
                switch (phase) {
                    case Phase.Append:
                        phase = this.nextAppend();
                        break;
                    case Phase.Prune:
                        phase = this.nextPrune();
                        break;
                    case Phase.Done:
                        this.nextDone();
                        return;
                }
            }
        };

        IteratorSynchronizer.prototype.advanceToKey = function advanceToKey(key) {
            var current = this.current,
                artifacts = this.artifacts;

            var seek = current;
            while (seek && seek.key !== key) {
                seek.seen = true;
                seek = artifacts.nextNode(seek);
            }
            this.current = seek && artifacts.nextNode(seek);
        };

        IteratorSynchronizer.prototype.nextAppend = function nextAppend() {
            var iterator = this.iterator,
                current = this.current,
                artifacts = this.artifacts;

            var item = iterator.next();
            if (item === null) {
                return this.startPrune();
            }
            var key = item.key;

            if (current && current.key === key) {
                this.nextRetain(item);
            } else if (artifacts.has(key)) {
                this.nextMove(item);
            } else {
                this.nextInsert(item);
            }
            return Phase.Append;
        };

        IteratorSynchronizer.prototype.nextRetain = function nextRetain(item) {
            var artifacts = this.artifacts,
                current = this.current;

            current = current;
            current.update(item);
            this.current = artifacts.nextNode(current);
            this.target.retain(item.key, current.value, current.memo);
        };

        IteratorSynchronizer.prototype.nextMove = function nextMove(item) {
            var current = this.current,
                artifacts = this.artifacts,
                target = this.target;
            var key = item.key;

            var found = artifacts.get(item.key);
            found.update(item);
            if (artifacts.wasSeen(item.key)) {
                artifacts.move(found, current);
                target.move(found.key, found.value, found.memo, current ? current.key : null);
            } else {
                this.advanceToKey(key);
            }
        };

        IteratorSynchronizer.prototype.nextInsert = function nextInsert(item) {
            var artifacts = this.artifacts,
                target = this.target,
                current = this.current;

            var node = artifacts.insertBefore(item, current);
            target.insert(node.key, node.value, node.memo, current ? current.key : null);
        };

        IteratorSynchronizer.prototype.startPrune = function startPrune() {
            this.current = this.artifacts.head();
            return Phase.Prune;
        };

        IteratorSynchronizer.prototype.nextPrune = function nextPrune() {
            var artifacts = this.artifacts,
                target = this.target,
                current = this.current;

            if (current === null) {
                return Phase.Done;
            }
            var node = current;
            this.current = artifacts.nextNode(node);
            if (node.shouldRemove()) {
                artifacts.remove(node);
                target.delete(node.key);
            } else {
                node.reset();
            }
            return Phase.Prune;
        };

        IteratorSynchronizer.prototype.nextDone = function nextDone() {
            this.target.done();
        };

        return IteratorSynchronizer;
    }();

    function referenceFromParts(root, parts) {
        var reference = root;
        for (var i = 0; i < parts.length; i++) {
            reference = reference.get(parts[i]);
        }
        return reference;
    }

    exports.ConstReference = ConstReference;
    exports.isConst = isConst;
    exports.ListItem = ListItem;
    exports.referenceFromParts = referenceFromParts;
    exports.IterationArtifacts = IterationArtifacts;
    exports.ReferenceIterator = ReferenceIterator;
    exports.IteratorSynchronizer = IteratorSynchronizer;
    exports.CONSTANT = CONSTANT;
    exports.INITIAL = INITIAL;
    exports.VOLATILE = VOLATILE;
    exports.RevisionTag = RevisionTag;
    exports.TagWrapper = TagWrapper;
    exports.CONSTANT_TAG = CONSTANT_TAG;
    exports.VOLATILE_TAG = VOLATILE_TAG;
    exports.CURRENT_TAG = CURRENT_TAG;
    exports.DirtyableTag = DirtyableTag;
    exports.combineTagged = combineTagged;
    exports.combineSlice = combineSlice;
    exports.combine = combine;
    exports.CachedTag = CachedTag;
    exports.UpdatableTag = UpdatableTag;
    exports.CachedReference = CachedReference;
    exports.map = map;
    exports.ReferenceCache = ReferenceCache;
    exports.isModified = isModified;
});
enifed('@glimmer/runtime', ['exports', '@glimmer/util', '@glimmer/reference', '@glimmer/wire-format'], function (exports, _util, _reference2, _wireFormat) {
    'use strict';

    exports.ConcreteBounds = exports.ElementStack = exports.insertHTMLBefore = exports.isWhitespace = exports.DOMTreeConstruction = exports.IDOMChanges = exports.DOMChanges = exports.isComponentDefinition = exports.ComponentDefinition = exports.PartialDefinition = exports.Environment = exports.Scope = exports.isSafeString = exports.RenderResult = exports.UpdatingVM = exports.compileExpression = exports.compileList = exports.InlineMacros = exports.BlockMacros = exports.getDynamicVar = exports.resetDebuggerCallback = exports.setDebuggerCallback = exports.normalizeTextValue = exports.debugSlice = exports.Register = exports.readDOMAttr = exports.defaultPropertyManagers = exports.defaultAttributeManagers = exports.defaultManagers = exports.INPUT_VALUE_PROPERTY_MANAGER = exports.PropertyManager = exports.AttributeManager = exports.IAttributeManager = exports.CompiledDynamicTemplate = exports.CompiledStaticTemplate = exports.compileLayout = exports.OpcodeBuilderDSL = exports.ConditionalReference = exports.PrimitiveReference = exports.UNDEFINED_REFERENCE = exports.NULL_REFERENCE = exports.templateFactory = exports.Simple = undefined;


    function _defaults(obj, defaults) {
        var keys = Object.getOwnPropertyNames(defaults);for (var i = 0; i < keys.length; i++) {
            var key = keys[i];var value = Object.getOwnPropertyDescriptor(defaults, key);if (value && value.configurable && obj[key] === undefined) {
                Object.defineProperty(obj, key, value);
            }
        }return obj;
    }

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults(subClass, superClass);
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    /**
     * Registers
     *
     * For the most part, these follows MIPS naming conventions, however the
     * register numbers are different.
     */
    var Register;
    (function (Register) {
        // $0 or $pc (program counter): pointer into `program` for the next insturction; -1 means exit
        Register[Register["pc"] = 0] = "pc";
        // $1 or $ra (return address): pointer into `program` for the return
        Register[Register["ra"] = 1] = "ra";
        // $2 or $fp (frame pointer): pointer into the `evalStack` for the base of the stack
        Register[Register["fp"] = 2] = "fp";
        // $3 or $sp (stack pointer): pointer into the `evalStack` for the top of the stack
        Register[Register["sp"] = 3] = "sp";
        // $4-$5 or $s0-$s1 (saved): callee saved general-purpose registers
        Register[Register["s0"] = 4] = "s0";
        Register[Register["s1"] = 5] = "s1";
        // $6-$7 or $t0-$t1 (temporaries): caller saved general-purpose registers
        Register[Register["t0"] = 6] = "t0";
        Register[Register["t1"] = 7] = "t1";
    })(Register || (exports.Register = Register = {}));
    function debugSlice(env, start, end) {}
    var AppendOpcodes = function () {
        function AppendOpcodes() {
            _classCallCheck(this, AppendOpcodes);

            this.evaluateOpcode = (0, _util.fillNulls)(72 /* Size */).slice();
        }

        AppendOpcodes.prototype.add = function add(name, evaluate) {
            this.evaluateOpcode[name] = evaluate;
        };

        AppendOpcodes.prototype.evaluate = function evaluate(vm, opcode, type) {
            var func = this.evaluateOpcode[type];
            func(vm, opcode);
        };

        return AppendOpcodes;
    }();
    var APPEND_OPCODES = new AppendOpcodes();
    var AbstractOpcode = function () {
        function AbstractOpcode() {
            _classCallCheck(this, AbstractOpcode);

            (0, _util.initializeGuid)(this);
        }

        AbstractOpcode.prototype.toJSON = function toJSON() {
            return { guid: this._guid, type: this.type };
        };

        return AbstractOpcode;
    }();
    var UpdatingOpcode = function (_AbstractOpcode) {
        _inherits(UpdatingOpcode, _AbstractOpcode);

        function UpdatingOpcode() {
            _classCallCheck(this, UpdatingOpcode);

            var _this = _possibleConstructorReturn(this, _AbstractOpcode.apply(this, arguments));

            _this.next = null;
            _this.prev = null;
            return _this;
        }

        return UpdatingOpcode;
    }(AbstractOpcode);

    function _defaults$1(obj, defaults) {
        var keys = Object.getOwnPropertyNames(defaults);for (var i = 0; i < keys.length; i++) {
            var key = keys[i];var value = Object.getOwnPropertyDescriptor(defaults, key);if (value && value.configurable && obj[key] === undefined) {
                Object.defineProperty(obj, key, value);
            }
        }return obj;
    }

    function _classCallCheck$1(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    function _possibleConstructorReturn$1(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits$1(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults$1(subClass, superClass);
    }

    var PrimitiveReference = function (_ConstReference) {
        _inherits$1(PrimitiveReference, _ConstReference);

        function PrimitiveReference(value) {
            _classCallCheck$1(this, PrimitiveReference);

            return _possibleConstructorReturn$1(this, _ConstReference.call(this, value));
        }

        PrimitiveReference.create = function create(value) {
            if (value === undefined) {
                return UNDEFINED_REFERENCE;
            } else if (value === null) {
                return NULL_REFERENCE;
            } else if (value === true) {
                return TRUE_REFERENCE;
            } else if (value === false) {
                return FALSE_REFERENCE;
            } else if (typeof value === 'number') {
                return new ValueReference(value);
            } else {
                return new StringReference(value);
            }
        };

        PrimitiveReference.prototype.get = function get(_key) {
            return UNDEFINED_REFERENCE;
        };

        return PrimitiveReference;
    }(_reference2.ConstReference);

    var StringReference = function (_PrimitiveReference) {
        _inherits$1(StringReference, _PrimitiveReference);

        function StringReference() {
            _classCallCheck$1(this, StringReference);

            var _this2 = _possibleConstructorReturn$1(this, _PrimitiveReference.apply(this, arguments));

            _this2.lengthReference = null;
            return _this2;
        }

        StringReference.prototype.get = function get(key) {
            if (key === 'length') {
                var lengthReference = this.lengthReference;

                if (lengthReference === null) {
                    lengthReference = this.lengthReference = new ValueReference(this.inner.length);
                }
                return lengthReference;
            } else {
                return _PrimitiveReference.prototype.get.call(this, key);
            }
        };

        return StringReference;
    }(PrimitiveReference);

    var ValueReference = function (_PrimitiveReference2) {
        _inherits$1(ValueReference, _PrimitiveReference2);

        function ValueReference(value) {
            _classCallCheck$1(this, ValueReference);

            return _possibleConstructorReturn$1(this, _PrimitiveReference2.call(this, value));
        }

        return ValueReference;
    }(PrimitiveReference);

    var UNDEFINED_REFERENCE = new ValueReference(undefined);
    var NULL_REFERENCE = new ValueReference(null);
    var TRUE_REFERENCE = new ValueReference(true);
    var FALSE_REFERENCE = new ValueReference(false);
    var ConditionalReference = function () {
        function ConditionalReference(inner) {
            _classCallCheck$1(this, ConditionalReference);

            this.inner = inner;
            this.tag = inner.tag;
        }

        ConditionalReference.prototype.value = function value() {
            return this.toBool(this.inner.value());
        };

        ConditionalReference.prototype.toBool = function toBool(value) {
            return !!value;
        };

        return ConditionalReference;
    }();

    function _defaults$2(obj, defaults) {
        var keys = Object.getOwnPropertyNames(defaults);for (var i = 0; i < keys.length; i++) {
            var key = keys[i];var value = Object.getOwnPropertyDescriptor(defaults, key);if (value && value.configurable && obj[key] === undefined) {
                Object.defineProperty(obj, key, value);
            }
        }return obj;
    }

    function _classCallCheck$2(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    function _possibleConstructorReturn$2(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits$2(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults$2(subClass, superClass);
    }

    var ConcatReference = function (_CachedReference) {
        _inherits$2(ConcatReference, _CachedReference);

        function ConcatReference(parts) {
            _classCallCheck$2(this, ConcatReference);

            var _this = _possibleConstructorReturn$2(this, _CachedReference.call(this));

            _this.parts = parts;
            _this.tag = (0, _reference2.combineTagged)(parts);
            return _this;
        }

        ConcatReference.prototype.compute = function compute() {
            var parts = new Array();
            for (var i = 0; i < this.parts.length; i++) {
                var value = this.parts[i].value();
                if (value !== null && value !== undefined) {
                    parts[i] = castToString(value);
                }
            }
            if (parts.length > 0) {
                return parts.join('');
            }
            return null;
        };

        return ConcatReference;
    }(_reference2.CachedReference);
    function castToString(value) {
        if (typeof value.toString !== 'function') {
            return '';
        }
        return String(value);
    }

    APPEND_OPCODES.add(1 /* Helper */, function (vm, _ref) {
        var _helper = _ref.op1;

        var stack = vm.stack;
        var helper = vm.constants.getFunction(_helper);
        var args = stack.pop();
        var value = helper(vm, args);
        args.clear();
        vm.stack.push(value);
    });
    APPEND_OPCODES.add(2 /* Function */, function (vm, _ref2) {
        var _function = _ref2.op1;

        var func = vm.constants.getFunction(_function);
        vm.stack.push(func(vm));
    });
    APPEND_OPCODES.add(5 /* GetVariable */, function (vm, _ref3) {
        var symbol = _ref3.op1;

        var expr = vm.referenceForSymbol(symbol);
        vm.stack.push(expr);
    });
    APPEND_OPCODES.add(4 /* SetVariable */, function (vm, _ref4) {
        var symbol = _ref4.op1;

        var expr = vm.stack.pop();
        vm.scope().bindSymbol(symbol, expr);
    });
    APPEND_OPCODES.add(70 /* ResolveMaybeLocal */, function (vm, _ref5) {
        var _name = _ref5.op1;

        var name = vm.constants.getString(_name);
        var locals = vm.scope().getPartialMap();
        var ref = locals[name];
        if (ref === undefined) {
            ref = vm.getSelf().get(name);
        }
        vm.stack.push(ref);
    });
    APPEND_OPCODES.add(19 /* RootScope */, function (vm, _ref6) {
        var symbols = _ref6.op1,
            bindCallerScope = _ref6.op2;

        vm.pushRootScope(symbols, !!bindCallerScope);
    });
    APPEND_OPCODES.add(6 /* GetProperty */, function (vm, _ref7) {
        var _key = _ref7.op1;

        var key = vm.constants.getString(_key);
        var expr = vm.stack.pop();
        vm.stack.push(expr.get(key));
    });
    APPEND_OPCODES.add(7 /* PushBlock */, function (vm, _ref8) {
        var _block = _ref8.op1;

        var block = _block ? vm.constants.getBlock(_block) : null;
        vm.stack.push(block);
    });
    APPEND_OPCODES.add(8 /* GetBlock */, function (vm, _ref9) {
        var _block = _ref9.op1;

        vm.stack.push(vm.scope().getBlock(_block));
    });
    APPEND_OPCODES.add(9 /* HasBlock */, function (vm, _ref10) {
        var _block = _ref10.op1;

        var hasBlock = !!vm.scope().getBlock(_block);
        vm.stack.push(hasBlock ? TRUE_REFERENCE : FALSE_REFERENCE);
    });
    APPEND_OPCODES.add(10 /* HasBlockParams */, function (vm, _ref11) {
        var _block = _ref11.op1;

        var block = vm.scope().getBlock(_block);
        var hasBlockParams = block && block.symbolTable.parameters.length;
        vm.stack.push(hasBlockParams ? TRUE_REFERENCE : FALSE_REFERENCE);
    });
    APPEND_OPCODES.add(11 /* Concat */, function (vm, _ref12) {
        var count = _ref12.op1;

        var out = [];
        for (var i = count; i > 0; i--) {
            out.push(vm.stack.pop());
        }
        vm.stack.push(new ConcatReference(out.reverse()));
    });

    var _createClass = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
            }
        }return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
        };
    }();

    function _classCallCheck$4(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var Arguments = function () {
        function Arguments() {
            _classCallCheck$4(this, Arguments);

            this.stack = null;
            this.positional = new PositionalArguments();
            this.named = new NamedArguments();
        }

        Arguments.prototype.empty = function empty() {
            this.setup(null, true);
            return this;
        };

        Arguments.prototype.setup = function setup(stack, synthetic) {
            this.stack = stack;
            var names = stack.fromTop(0);
            var namedCount = names.length;
            var positionalCount = stack.fromTop(namedCount + 1);
            var start = positionalCount + namedCount + 2;
            var positional = this.positional;
            positional.setup(stack, start, positionalCount);
            var named = this.named;
            named.setup(stack, namedCount, names, synthetic);
        };

        Arguments.prototype.at = function at(pos) {
            return this.positional.at(pos);
        };

        Arguments.prototype.get = function get(name) {
            return this.named.get(name);
        };

        Arguments.prototype.capture = function capture() {
            return {
                tag: this.tag,
                length: this.length,
                positional: this.positional.capture(),
                named: this.named.capture()
            };
        };

        Arguments.prototype.clear = function clear() {
            var stack = this.stack,
                length = this.length;

            stack.pop(length + 2);
        };

        _createClass(Arguments, [{
            key: 'tag',
            get: function () {
                return (0, _reference2.combineTagged)([this.positional, this.named]);
            }
        }, {
            key: 'length',
            get: function () {
                return this.positional.length + this.named.length;
            }
        }]);

        return Arguments;
    }();

    var PositionalArguments = function () {
        function PositionalArguments() {
            _classCallCheck$4(this, PositionalArguments);

            this.length = 0;
            this.stack = null;
            this.start = 0;
            this._tag = null;
            this._references = null;
        }

        PositionalArguments.prototype.setup = function setup(stack, start, length) {
            this.stack = stack;
            this.start = start;
            this.length = length;
            this._tag = null;
            this._references = null;
        };

        PositionalArguments.prototype.at = function at(position) {
            var start = this.start,
                length = this.length;

            if (position < 0 || position >= length) {
                return UNDEFINED_REFERENCE;
            }
            // stack: pos1, pos2, pos3, named1, named2
            // start: 4 (top - 4)
            //
            // at(0) === pos1 === top - start
            // at(1) === pos2 === top - (start - 1)
            // at(2) === pos3 === top - (start - 2)
            var fromTop = start - position - 1;
            return this.stack.fromTop(fromTop);
        };

        PositionalArguments.prototype.capture = function capture() {
            return new CapturedPositionalArguments(this.tag, this.references);
        };

        _createClass(PositionalArguments, [{
            key: 'tag',
            get: function () {
                var tag = this._tag;
                if (!tag) {
                    tag = this._tag = (0, _reference2.combineTagged)(this.references);
                }
                return tag;
            }
        }, {
            key: 'references',
            get: function () {
                var references = this._references;
                if (!references) {
                    var length = this.length;

                    references = this._references = new Array(length);
                    for (var i = 0; i < length; i++) {
                        references[i] = this.at(i);
                    }
                }
                return references;
            }
        }]);

        return PositionalArguments;
    }();

    var CapturedPositionalArguments = function () {
        function CapturedPositionalArguments(tag, references) {
            var length = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : references.length;

            _classCallCheck$4(this, CapturedPositionalArguments);

            this.tag = tag;
            this.references = references;
            this.length = length;
        }

        CapturedPositionalArguments.prototype.at = function at(position) {
            return this.references[position];
        };

        CapturedPositionalArguments.prototype.value = function value() {
            return this.references.map(this.valueOf);
        };

        CapturedPositionalArguments.prototype.get = function get(name) {
            var references = this.references,
                length = this.length;

            if (name === 'length') {
                return PrimitiveReference.create(length);
            } else {
                var idx = parseInt(name, 10);
                if (idx < 0 || idx >= length) {
                    return UNDEFINED_REFERENCE;
                } else {
                    return references[idx];
                }
            }
        };

        CapturedPositionalArguments.prototype.valueOf = function valueOf(reference) {
            return reference.value();
        };

        return CapturedPositionalArguments;
    }();

    var NamedArguments = function () {
        function NamedArguments() {
            _classCallCheck$4(this, NamedArguments);

            this.length = 0;
            this._tag = null;
            this._references = null;
            this._names = null;
            this._realNames = _util.EMPTY_ARRAY;
        }

        NamedArguments.prototype.setup = function setup(stack, length, names, synthetic) {
            this.stack = stack;
            this.length = length;
            this._tag = null;
            this._references = null;
            if (synthetic) {
                this._names = names;
                this._realNames = _util.EMPTY_ARRAY;
            } else {
                this._names = null;
                this._realNames = names;
            }
        };

        NamedArguments.prototype.has = function has(name) {
            return this.names.indexOf(name) !== -1;
        };

        NamedArguments.prototype.get = function get(name) {
            var names = this.names,
                length = this.length;

            var idx = names.indexOf(name);
            if (idx === -1) {
                return UNDEFINED_REFERENCE;
            }
            // stack: pos1, pos2, pos3, named1, named2
            // start: 4 (top - 4)
            // namedDict: { named1: 1, named2: 0 };
            //
            // get('named1') === named1 === top - (start - 1)
            // get('named2') === named2 === top - start
            var fromTop = length - idx;
            return this.stack.fromTop(fromTop);
        };

        NamedArguments.prototype.capture = function capture() {
            return new CapturedNamedArguments(this.tag, this.names, this.references);
        };

        NamedArguments.prototype.sliceName = function sliceName(name) {
            return name.slice(1);
        };

        _createClass(NamedArguments, [{
            key: 'tag',
            get: function () {
                return (0, _reference2.combineTagged)(this.references);
            }
        }, {
            key: 'names',
            get: function () {
                var names = this._names;
                if (!names) {
                    names = this._names = this._realNames.map(this.sliceName);
                }
                return names;
            }
        }, {
            key: 'references',
            get: function () {
                var references = this._references;
                if (!references) {
                    var names = this.names,
                        length = this.length;

                    references = this._references = [];
                    for (var i = 0; i < length; i++) {
                        references[i] = this.get(names[i]);
                    }
                }
                return references;
            }
        }]);

        return NamedArguments;
    }();

    var CapturedNamedArguments = function () {
        function CapturedNamedArguments(tag, names, references) {
            _classCallCheck$4(this, CapturedNamedArguments);

            this.tag = tag;
            this.names = names;
            this.references = references;
            this.length = names.length;
            this._map = null;
        }

        CapturedNamedArguments.prototype.has = function has(name) {
            return this.names.indexOf(name) !== -1;
        };

        CapturedNamedArguments.prototype.get = function get(name) {
            var names = this.names,
                references = this.references;

            var idx = names.indexOf(name);
            if (idx === -1) {
                return UNDEFINED_REFERENCE;
            } else {
                return references[idx];
            }
        };

        CapturedNamedArguments.prototype.value = function value() {
            var names = this.names,
                references = this.references;

            var out = (0, _util.dict)();
            for (var i = 0; i < names.length; i++) {
                var name = names[i];
                out[name] = references[i].value();
            }
            return out;
        };

        _createClass(CapturedNamedArguments, [{
            key: 'map',
            get: function () {
                var map$$1 = this._map;
                if (!map$$1) {
                    var names = this.names,
                        references = this.references;

                    map$$1 = this._map = (0, _util.dict)();
                    for (var i = 0; i < names.length; i++) {
                        var name = names[i];
                        map$$1[name] = references[i];
                    }
                }
                return map$$1;
            }
        }]);

        return CapturedNamedArguments;
    }();

    var ARGS = new Arguments();

    function _defaults$5(obj, defaults) {
        var keys = Object.getOwnPropertyNames(defaults);for (var i = 0; i < keys.length; i++) {
            var key = keys[i];var value = Object.getOwnPropertyDescriptor(defaults, key);if (value && value.configurable && obj[key] === undefined) {
                Object.defineProperty(obj, key, value);
            }
        }return obj;
    }

    function _classCallCheck$6(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    function _possibleConstructorReturn$5(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits$5(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults$5(subClass, superClass);
    }

    APPEND_OPCODES.add(20 /* ChildScope */, function (vm) {
        return vm.pushChildScope();
    });
    APPEND_OPCODES.add(21 /* PopScope */, function (vm) {
        return vm.popScope();
    });
    APPEND_OPCODES.add(39 /* PushDynamicScope */, function (vm) {
        return vm.pushDynamicScope();
    });
    APPEND_OPCODES.add(40 /* PopDynamicScope */, function (vm) {
        return vm.popDynamicScope();
    });
    APPEND_OPCODES.add(12 /* Immediate */, function (vm, _ref) {
        var number = _ref.op1;

        vm.stack.push(number);
    });
    APPEND_OPCODES.add(13 /* Constant */, function (vm, _ref2) {
        var other = _ref2.op1;

        vm.stack.push(vm.constants.getOther(other));
    });
    APPEND_OPCODES.add(14 /* PrimitiveReference */, function (vm, _ref3) {
        var primitive = _ref3.op1;

        var stack = vm.stack;
        var flag = (primitive & 3 << 30) >>> 30;
        var value = primitive & ~(3 << 30);
        switch (flag) {
            case 0:
                stack.push(PrimitiveReference.create(value));
                break;
            case 1:
                stack.push(PrimitiveReference.create(vm.constants.getFloat(value)));
                break;
            case 2:
                stack.push(PrimitiveReference.create(vm.constants.getString(value)));
                break;
            case 3:
                switch (value) {
                    case 0:
                        stack.push(FALSE_REFERENCE);
                        break;
                    case 1:
                        stack.push(TRUE_REFERENCE);
                        break;
                    case 2:
                        stack.push(NULL_REFERENCE);
                        break;
                    case 3:
                        stack.push(UNDEFINED_REFERENCE);
                        break;
                }
                break;
        }
    });
    APPEND_OPCODES.add(15 /* Dup */, function (vm, _ref4) {
        var register = _ref4.op1,
            offset = _ref4.op2;

        var position = vm.fetchValue(register) - offset;
        vm.stack.dup(position);
    });
    APPEND_OPCODES.add(16 /* Pop */, function (vm, _ref5) {
        var count = _ref5.op1;
        return vm.stack.pop(count);
    });
    APPEND_OPCODES.add(17 /* Load */, function (vm, _ref6) {
        var register = _ref6.op1;
        return vm.load(register);
    });
    APPEND_OPCODES.add(18 /* Fetch */, function (vm, _ref7) {
        var register = _ref7.op1;
        return vm.fetch(register);
    });
    APPEND_OPCODES.add(38 /* BindDynamicScope */, function (vm, _ref8) {
        var _names = _ref8.op1;

        var names = vm.constants.getArray(_names);
        vm.bindDynamicScope(names);
    });
    APPEND_OPCODES.add(47 /* PushFrame */, function (vm) {
        return vm.pushFrame();
    });
    APPEND_OPCODES.add(48 /* PopFrame */, function (vm) {
        return vm.popFrame();
    });
    APPEND_OPCODES.add(49 /* Enter */, function (vm, _ref9) {
        var args = _ref9.op1;
        return vm.enter(args);
    });
    APPEND_OPCODES.add(50 /* Exit */, function (vm) {
        return vm.exit();
    });
    APPEND_OPCODES.add(41 /* CompileDynamicBlock */, function (vm) {
        var stack = vm.stack;
        var block = stack.pop();
        stack.push(block ? block.compileDynamic(vm.env) : null);
    });
    APPEND_OPCODES.add(42 /* InvokeStatic */, function (vm, _ref10) {
        var _block = _ref10.op1;

        var block = vm.constants.getBlock(_block);
        var compiled = block.compileStatic(vm.env);
        vm.call(compiled.handle);
    });
    APPEND_OPCODES.add(43 /* InvokeDynamic */, function (vm, _ref11) {
        var _invoker = _ref11.op1;

        var invoker = vm.constants.getOther(_invoker);
        var block = vm.stack.pop();
        invoker.invoke(vm, block);
    });
    APPEND_OPCODES.add(44 /* Jump */, function (vm, _ref12) {
        var target = _ref12.op1;
        return vm.goto(target);
    });
    APPEND_OPCODES.add(45 /* JumpIf */, function (vm, _ref13) {
        var target = _ref13.op1;

        var reference = vm.stack.pop();
        if ((0, _reference2.isConst)(reference)) {
            if (reference.value()) {
                vm.goto(target);
            }
        } else {
            var cache = new _reference2.ReferenceCache(reference);
            if (cache.peek()) {
                vm.goto(target);
            }
            vm.updateWith(new Assert(cache));
        }
    });
    APPEND_OPCODES.add(46 /* JumpUnless */, function (vm, _ref14) {
        var target = _ref14.op1;

        var reference = vm.stack.pop();
        if ((0, _reference2.isConst)(reference)) {
            if (!reference.value()) {
                vm.goto(target);
            }
        } else {
            var cache = new _reference2.ReferenceCache(reference);
            if (!cache.peek()) {
                vm.goto(target);
            }
            vm.updateWith(new Assert(cache));
        }
    });
    APPEND_OPCODES.add(22 /* Return */, function (vm) {
        return vm.return();
    });
    APPEND_OPCODES.add(23 /* ReturnTo */, function (vm, _ref15) {
        var relative = _ref15.op1;

        vm.returnTo(relative);
    });
    var ConstTest = function (ref, _env) {
        return new _reference2.ConstReference(!!ref.value());
    };
    var SimpleTest = function (ref, _env) {
        return ref;
    };
    var EnvironmentTest = function (ref, env) {
        return env.toConditionalReference(ref);
    };
    APPEND_OPCODES.add(51 /* Test */, function (vm, _ref16) {
        var _func = _ref16.op1;

        var stack = vm.stack;
        var operand = stack.pop();
        var func = vm.constants.getFunction(_func);
        stack.push(func(operand, vm.env));
    });
    var Assert = function (_UpdatingOpcode) {
        _inherits$5(Assert, _UpdatingOpcode);

        function Assert(cache) {
            _classCallCheck$6(this, Assert);

            var _this = _possibleConstructorReturn$5(this, _UpdatingOpcode.call(this));

            _this.type = 'assert';
            _this.tag = cache.tag;
            _this.cache = cache;
            return _this;
        }

        Assert.prototype.evaluate = function evaluate(vm) {
            var cache = this.cache;

            if ((0, _reference2.isModified)(cache.revalidate())) {
                vm.throw();
            }
        };

        Assert.prototype.toJSON = function toJSON() {
            var type = this.type,
                _guid = this._guid,
                cache = this.cache;

            var expected = void 0;
            try {
                expected = JSON.stringify(cache.peek());
            } catch (e) {
                expected = String(cache.peek());
            }
            return {
                args: [],
                details: { expected: expected },
                guid: _guid,
                type: type
            };
        };

        return Assert;
    }(UpdatingOpcode);
    var JumpIfNotModifiedOpcode = function (_UpdatingOpcode2) {
        _inherits$5(JumpIfNotModifiedOpcode, _UpdatingOpcode2);

        function JumpIfNotModifiedOpcode(tag, target) {
            _classCallCheck$6(this, JumpIfNotModifiedOpcode);

            var _this2 = _possibleConstructorReturn$5(this, _UpdatingOpcode2.call(this));

            _this2.target = target;
            _this2.type = 'jump-if-not-modified';
            _this2.tag = tag;
            _this2.lastRevision = tag.value();
            return _this2;
        }

        JumpIfNotModifiedOpcode.prototype.evaluate = function evaluate(vm) {
            var tag = this.tag,
                target = this.target,
                lastRevision = this.lastRevision;

            if (!vm.alwaysRevalidate && tag.validate(lastRevision)) {
                vm.goto(target);
            }
        };

        JumpIfNotModifiedOpcode.prototype.didModify = function didModify() {
            this.lastRevision = this.tag.value();
        };

        JumpIfNotModifiedOpcode.prototype.toJSON = function toJSON() {
            return {
                args: [JSON.stringify(this.target.inspect())],
                guid: this._guid,
                type: this.type
            };
        };

        return JumpIfNotModifiedOpcode;
    }(UpdatingOpcode);
    var DidModifyOpcode = function (_UpdatingOpcode3) {
        _inherits$5(DidModifyOpcode, _UpdatingOpcode3);

        function DidModifyOpcode(target) {
            _classCallCheck$6(this, DidModifyOpcode);

            var _this3 = _possibleConstructorReturn$5(this, _UpdatingOpcode3.call(this));

            _this3.target = target;
            _this3.type = 'did-modify';
            _this3.tag = _reference2.CONSTANT_TAG;
            return _this3;
        }

        DidModifyOpcode.prototype.evaluate = function evaluate() {
            this.target.didModify();
        };

        return DidModifyOpcode;
    }(UpdatingOpcode);
    var LabelOpcode = function () {
        function LabelOpcode(label) {
            _classCallCheck$6(this, LabelOpcode);

            this.tag = _reference2.CONSTANT_TAG;
            this.type = 'label';
            this.label = null;
            this.prev = null;
            this.next = null;
            (0, _util.initializeGuid)(this);
            this.label = label;
        }

        LabelOpcode.prototype.evaluate = function evaluate() {};

        LabelOpcode.prototype.inspect = function inspect$$1() {
            return this.label + ' [' + this._guid + ']';
        };

        LabelOpcode.prototype.toJSON = function toJSON() {
            return {
                args: [JSON.stringify(this.inspect())],
                guid: this._guid,
                type: this.type
            };
        };

        return LabelOpcode;
    }();

    function _defaults$4(obj, defaults) {
        var keys = Object.getOwnPropertyNames(defaults);for (var i = 0; i < keys.length; i++) {
            var key = keys[i];var value = Object.getOwnPropertyDescriptor(defaults, key);if (value && value.configurable && obj[key] === undefined) {
                Object.defineProperty(obj, key, value);
            }
        }return obj;
    }

    function _possibleConstructorReturn$4(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits$4(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults$4(subClass, superClass);
    }

    function _classCallCheck$5(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    APPEND_OPCODES.add(24 /* Text */, function (vm, _ref) {
        var text = _ref.op1;

        vm.elements().appendText(vm.constants.getString(text));
    });
    APPEND_OPCODES.add(25 /* Comment */, function (vm, _ref2) {
        var text = _ref2.op1;

        vm.elements().appendComment(vm.constants.getString(text));
    });
    APPEND_OPCODES.add(27 /* OpenElement */, function (vm, _ref3) {
        var tag = _ref3.op1;

        vm.elements().openElement(vm.constants.getString(tag));
    });
    APPEND_OPCODES.add(28 /* OpenElementWithOperations */, function (vm, _ref4) {
        var tag = _ref4.op1;

        var tagName = vm.constants.getString(tag);
        var operations = vm.stack.pop();
        vm.elements().openElement(tagName, operations);
    });
    APPEND_OPCODES.add(29 /* OpenDynamicElement */, function (vm) {
        var operations = vm.stack.pop();
        var tagName = vm.stack.pop().value();
        vm.elements().openElement(tagName, operations);
    });
    APPEND_OPCODES.add(36 /* PushRemoteElement */, function (vm) {
        var elementRef = vm.stack.pop();
        var nextSiblingRef = vm.stack.pop();
        var element = void 0;
        var nextSibling = void 0;
        if ((0, _reference2.isConst)(elementRef)) {
            element = elementRef.value();
        } else {
            var cache = new _reference2.ReferenceCache(elementRef);
            element = cache.peek();
            vm.updateWith(new Assert(cache));
        }
        if ((0, _reference2.isConst)(nextSiblingRef)) {
            nextSibling = nextSiblingRef.value();
        } else {
            var _cache = new _reference2.ReferenceCache(nextSiblingRef);
            nextSibling = _cache.peek();
            vm.updateWith(new Assert(_cache));
        }
        vm.elements().pushRemoteElement(element, nextSibling);
    });
    APPEND_OPCODES.add(37 /* PopRemoteElement */, function (vm) {
        return vm.elements().popRemoteElement();
    });

    var ClassList = function () {
        function ClassList() {
            _classCallCheck$5(this, ClassList);

            this.list = null;
            this.isConst = true;
        }

        ClassList.prototype.append = function append(reference) {
            var list = this.list,
                isConst$$1 = this.isConst;

            if (list === null) list = this.list = [];
            list.push(reference);
            this.isConst = isConst$$1 && (0, _reference2.isConst)(reference);
        };

        ClassList.prototype.toReference = function toReference() {
            var list = this.list,
                isConst$$1 = this.isConst;

            if (!list) return NULL_REFERENCE;
            if (isConst$$1) return PrimitiveReference.create(toClassName(list));
            return new ClassListReference(list);
        };

        return ClassList;
    }();

    var ClassListReference = function (_CachedReference) {
        _inherits$4(ClassListReference, _CachedReference);

        function ClassListReference(list) {
            _classCallCheck$5(this, ClassListReference);

            var _this = _possibleConstructorReturn$4(this, _CachedReference.call(this));

            _this.list = [];
            _this.tag = (0, _reference2.combineTagged)(list);
            _this.list = list;
            return _this;
        }

        ClassListReference.prototype.compute = function compute() {
            return toClassName(this.list);
        };

        return ClassListReference;
    }(_reference2.CachedReference);

    function toClassName(list) {
        var ret = [];
        for (var i = 0; i < list.length; i++) {
            var value = list[i].value();
            if (value !== false && value !== null && value !== undefined) ret.push(value);
        }
        return ret.length === 0 ? null : ret.join(' ');
    }
    var SimpleElementOperations = function () {
        function SimpleElementOperations(env) {
            _classCallCheck$5(this, SimpleElementOperations);

            this.env = env;
            this.opcodes = null;
            this.classList = null;
        }

        SimpleElementOperations.prototype.addStaticAttribute = function addStaticAttribute(element, name, value) {
            if (name === 'class') {
                this.addClass(PrimitiveReference.create(value));
            } else {
                this.env.getAppendOperations().setAttribute(element, name, value);
            }
        };

        SimpleElementOperations.prototype.addStaticAttributeNS = function addStaticAttributeNS(element, namespace, name, value) {
            this.env.getAppendOperations().setAttribute(element, name, value, namespace);
        };

        SimpleElementOperations.prototype.addDynamicAttribute = function addDynamicAttribute(element, name, reference, isTrusting) {
            if (name === 'class') {
                this.addClass(reference);
            } else {
                var attributeManager = this.env.attributeFor(element, name, isTrusting);
                var attribute = new DynamicAttribute(element, attributeManager, name, reference);
                this.addAttribute(attribute);
            }
        };

        SimpleElementOperations.prototype.addDynamicAttributeNS = function addDynamicAttributeNS(element, namespace, name, reference, isTrusting) {
            var attributeManager = this.env.attributeFor(element, name, isTrusting, namespace);
            var nsAttribute = new DynamicAttribute(element, attributeManager, name, reference, namespace);
            this.addAttribute(nsAttribute);
        };

        SimpleElementOperations.prototype.flush = function flush(element, vm) {
            var env = vm.env;
            var opcodes = this.opcodes,
                classList = this.classList;

            for (var i = 0; opcodes && i < opcodes.length; i++) {
                vm.updateWith(opcodes[i]);
            }
            if (classList) {
                var attributeManager = env.attributeFor(element, 'class', false);
                var attribute = new DynamicAttribute(element, attributeManager, 'class', classList.toReference());
                var opcode = attribute.flush(env);
                if (opcode) {
                    vm.updateWith(opcode);
                }
            }
            this.opcodes = null;
            this.classList = null;
        };

        SimpleElementOperations.prototype.addClass = function addClass(reference) {
            var classList = this.classList;

            if (!classList) {
                classList = this.classList = new ClassList();
            }
            classList.append(reference);
        };

        SimpleElementOperations.prototype.addAttribute = function addAttribute(attribute) {
            var opcode = attribute.flush(this.env);
            if (opcode) {
                var opcodes = this.opcodes;

                if (!opcodes) {
                    opcodes = this.opcodes = [];
                }
                opcodes.push(opcode);
            }
        };

        return SimpleElementOperations;
    }();
    var ComponentElementOperations = function () {
        function ComponentElementOperations(env) {
            _classCallCheck$5(this, ComponentElementOperations);

            this.env = env;
            this.attributeNames = null;
            this.attributes = null;
            this.classList = null;
        }

        ComponentElementOperations.prototype.addStaticAttribute = function addStaticAttribute(element, name, value) {
            if (name === 'class') {
                this.addClass(PrimitiveReference.create(value));
            } else if (this.shouldAddAttribute(name)) {
                this.addAttribute(name, new StaticAttribute(element, name, value));
            }
        };

        ComponentElementOperations.prototype.addStaticAttributeNS = function addStaticAttributeNS(element, namespace, name, value) {
            if (this.shouldAddAttribute(name)) {
                this.addAttribute(name, new StaticAttribute(element, name, value, namespace));
            }
        };

        ComponentElementOperations.prototype.addDynamicAttribute = function addDynamicAttribute(element, name, reference, isTrusting) {
            if (name === 'class') {
                this.addClass(reference);
            } else if (this.shouldAddAttribute(name)) {
                var attributeManager = this.env.attributeFor(element, name, isTrusting);
                var attribute = new DynamicAttribute(element, attributeManager, name, reference);
                this.addAttribute(name, attribute);
            }
        };

        ComponentElementOperations.prototype.addDynamicAttributeNS = function addDynamicAttributeNS(element, namespace, name, reference, isTrusting) {
            if (this.shouldAddAttribute(name)) {
                var attributeManager = this.env.attributeFor(element, name, isTrusting, namespace);
                var nsAttribute = new DynamicAttribute(element, attributeManager, name, reference, namespace);
                this.addAttribute(name, nsAttribute);
            }
        };

        ComponentElementOperations.prototype.flush = function flush(element, vm) {
            var env = this.env;
            var attributes = this.attributes,
                classList = this.classList;

            for (var i = 0; attributes && i < attributes.length; i++) {
                var opcode = attributes[i].flush(env);
                if (opcode) {
                    vm.updateWith(opcode);
                }
            }
            if (classList) {
                var attributeManager = env.attributeFor(element, 'class', false);
                var attribute = new DynamicAttribute(element, attributeManager, 'class', classList.toReference());
                var _opcode = attribute.flush(env);
                if (_opcode) {
                    vm.updateWith(_opcode);
                }
            }
        };

        ComponentElementOperations.prototype.shouldAddAttribute = function shouldAddAttribute(name) {
            return !this.attributeNames || this.attributeNames.indexOf(name) === -1;
        };

        ComponentElementOperations.prototype.addClass = function addClass(reference) {
            var classList = this.classList;

            if (!classList) {
                classList = this.classList = new ClassList();
            }
            classList.append(reference);
        };

        ComponentElementOperations.prototype.addAttribute = function addAttribute(name, attribute) {
            var attributeNames = this.attributeNames,
                attributes = this.attributes;

            if (!attributeNames) {
                attributeNames = this.attributeNames = [];
                attributes = this.attributes = [];
            }
            attributeNames.push(name);
            attributes.push(attribute);
        };

        return ComponentElementOperations;
    }();
    APPEND_OPCODES.add(33 /* FlushElement */, function (vm) {
        var stack = vm.elements();
        var action = 'FlushElementOpcode#evaluate';
        stack.expectOperations(action).flush(stack.expectConstructing(action), vm);
        stack.flushElement();
    });
    APPEND_OPCODES.add(34 /* CloseElement */, function (vm) {
        return vm.elements().closeElement();
    });
    APPEND_OPCODES.add(30 /* StaticAttr */, function (vm, _ref5) {
        var _name = _ref5.op1,
            _value = _ref5.op2,
            _namespace = _ref5.op3;

        var name = vm.constants.getString(_name);
        var value = vm.constants.getString(_value);
        if (_namespace) {
            var namespace = vm.constants.getString(_namespace);
            vm.elements().setStaticAttributeNS(namespace, name, value);
        } else {
            vm.elements().setStaticAttribute(name, value);
        }
    });
    APPEND_OPCODES.add(35 /* Modifier */, function (vm, _ref6) {
        var _manager = _ref6.op1;

        var manager = vm.constants.getOther(_manager);
        var stack = vm.stack;
        var args = stack.pop();
        var tag = args.tag;

        var _vm$elements = vm.elements(),
            element = _vm$elements.constructing,
            updateOperations = _vm$elements.updateOperations;

        var dynamicScope = vm.dynamicScope();
        var modifier = manager.create(element, args, dynamicScope, updateOperations);
        args.clear();
        vm.env.scheduleInstallModifier(modifier, manager);
        var destructor = manager.getDestructor(modifier);
        if (destructor) {
            vm.newDestroyable(destructor);
        }
        vm.updateWith(new UpdateModifierOpcode(tag, manager, modifier));
    });
    var UpdateModifierOpcode = function (_UpdatingOpcode) {
        _inherits$4(UpdateModifierOpcode, _UpdatingOpcode);

        function UpdateModifierOpcode(tag, manager, modifier) {
            _classCallCheck$5(this, UpdateModifierOpcode);

            var _this2 = _possibleConstructorReturn$4(this, _UpdatingOpcode.call(this));

            _this2.tag = tag;
            _this2.manager = manager;
            _this2.modifier = modifier;
            _this2.type = 'update-modifier';
            _this2.lastUpdated = tag.value();
            return _this2;
        }

        UpdateModifierOpcode.prototype.evaluate = function evaluate(vm) {
            var manager = this.manager,
                modifier = this.modifier,
                tag = this.tag,
                lastUpdated = this.lastUpdated;

            if (!tag.validate(lastUpdated)) {
                vm.env.scheduleUpdateModifier(modifier, manager);
                this.lastUpdated = tag.value();
            }
        };

        UpdateModifierOpcode.prototype.toJSON = function toJSON() {
            return {
                guid: this._guid,
                type: this.type
            };
        };

        return UpdateModifierOpcode;
    }(UpdatingOpcode);
    var StaticAttribute = function () {
        function StaticAttribute(element, name, value, namespace) {
            _classCallCheck$5(this, StaticAttribute);

            this.element = element;
            this.name = name;
            this.value = value;
            this.namespace = namespace;
        }

        StaticAttribute.prototype.flush = function flush(env) {
            env.getAppendOperations().setAttribute(this.element, this.name, this.value, this.namespace);
            return null;
        };

        return StaticAttribute;
    }();
    var DynamicAttribute = function () {
        function DynamicAttribute(element, attributeManager, name, reference, namespace) {
            _classCallCheck$5(this, DynamicAttribute);

            this.element = element;
            this.attributeManager = attributeManager;
            this.name = name;
            this.reference = reference;
            this.namespace = namespace;
            this.cache = null;
            this.tag = reference.tag;
        }

        DynamicAttribute.prototype.patch = function patch(env) {
            var element = this.element,
                cache = this.cache;

            var value = cache.revalidate();
            if ((0, _reference2.isModified)(value)) {
                this.attributeManager.updateAttribute(env, element, value, this.namespace);
            }
        };

        DynamicAttribute.prototype.flush = function flush(env) {
            var reference = this.reference,
                element = this.element;

            if ((0, _reference2.isConst)(reference)) {
                var value = reference.value();
                this.attributeManager.setAttribute(env, element, value, this.namespace);
                return null;
            } else {
                var cache = this.cache = new _reference2.ReferenceCache(reference);
                var _value2 = cache.peek();
                this.attributeManager.setAttribute(env, element, _value2, this.namespace);
                return new PatchElementOpcode(this);
            }
        };

        DynamicAttribute.prototype.toJSON = function toJSON() {
            var element = this.element,
                namespace = this.namespace,
                name = this.name,
                cache = this.cache;

            var formattedElement = formatElement(element);
            var lastValue = cache.peek();
            if (namespace) {
                return {
                    element: formattedElement,
                    lastValue: lastValue,
                    name: name,
                    namespace: namespace,
                    type: 'attribute'
                };
            }
            return {
                element: formattedElement,
                lastValue: lastValue,
                name: name,
                namespace: namespace === undefined ? null : namespace,
                type: 'attribute'
            };
        };

        return DynamicAttribute;
    }();
    function formatElement(element) {
        return JSON.stringify('<' + element.tagName.toLowerCase() + ' />');
    }
    APPEND_OPCODES.add(32 /* DynamicAttrNS */, function (vm, _ref7) {
        var _name = _ref7.op1,
            _namespace = _ref7.op2,
            trusting = _ref7.op3;

        var name = vm.constants.getString(_name);
        var namespace = vm.constants.getString(_namespace);
        var reference = vm.stack.pop();
        vm.elements().setDynamicAttributeNS(namespace, name, reference, !!trusting);
    });
    APPEND_OPCODES.add(31 /* DynamicAttr */, function (vm, _ref8) {
        var _name = _ref8.op1,
            trusting = _ref8.op2;

        var name = vm.constants.getString(_name);
        var reference = vm.stack.pop();
        vm.elements().setDynamicAttribute(name, reference, !!trusting);
    });
    var PatchElementOpcode = function (_UpdatingOpcode2) {
        _inherits$4(PatchElementOpcode, _UpdatingOpcode2);

        function PatchElementOpcode(operation) {
            _classCallCheck$5(this, PatchElementOpcode);

            var _this3 = _possibleConstructorReturn$4(this, _UpdatingOpcode2.call(this));

            _this3.type = 'patch-element';
            _this3.tag = operation.tag;
            _this3.operation = operation;
            return _this3;
        }

        PatchElementOpcode.prototype.evaluate = function evaluate(vm) {
            this.operation.patch(vm.env);
        };

        PatchElementOpcode.prototype.toJSON = function toJSON() {
            var _guid = this._guid,
                type = this.type,
                operation = this.operation;

            return {
                details: operation.toJSON(),
                guid: _guid,
                type: type
            };
        };

        return PatchElementOpcode;
    }(UpdatingOpcode);

    function _defaults$3(obj, defaults) {
        var keys = Object.getOwnPropertyNames(defaults);for (var i = 0; i < keys.length; i++) {
            var key = keys[i];var value = Object.getOwnPropertyDescriptor(defaults, key);if (value && value.configurable && obj[key] === undefined) {
                Object.defineProperty(obj, key, value);
            }
        }return obj;
    }

    function _classCallCheck$3(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    function _possibleConstructorReturn$3(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits$3(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults$3(subClass, superClass);
    }

    APPEND_OPCODES.add(56 /* PushComponentManager */, function (vm, _ref) {
        var _definition = _ref.op1;

        var definition = vm.constants.getOther(_definition);
        var stack = vm.stack;
        stack.push({ definition: definition, manager: definition.manager, component: null });
    });
    APPEND_OPCODES.add(57 /* PushDynamicComponentManager */, function (vm) {
        var stack = vm.stack;
        var reference = stack.pop();
        var cache = (0, _reference2.isConst)(reference) ? undefined : new _reference2.ReferenceCache(reference);
        var definition = cache ? cache.peek() : reference.value();
        stack.push({ definition: definition, manager: definition.manager, component: null });
        if (cache) {
            vm.updateWith(new Assert(cache));
        }
    });
    APPEND_OPCODES.add(58 /* PushArgs */, function (vm, _ref2) {
        var synthetic = _ref2.op1;

        var stack = vm.stack;
        ARGS.setup(stack, !!synthetic);
        stack.push(ARGS);
    });
    APPEND_OPCODES.add(59 /* PrepareArgs */, function (vm, _ref3) {
        var _state = _ref3.op1;

        var stack = vm.stack;

        var _vm$fetchValue = vm.fetchValue(_state),
            definition = _vm$fetchValue.definition,
            manager = _vm$fetchValue.manager;

        var args = stack.pop();
        var preparedArgs = manager.prepareArgs(definition, args);
        if (preparedArgs) {
            args.clear();
            var positional = preparedArgs.positional,
                named = preparedArgs.named;

            var positionalCount = positional.length;
            for (var i = 0; i < positionalCount; i++) {
                stack.push(positional[i]);
            }
            stack.push(positionalCount);
            var names = Object.keys(named);
            var namedCount = names.length;
            var atNames = [];
            for (var _i = 0; _i < namedCount; _i++) {
                var value = named[names[_i]];
                var atName = '@' + names[_i];
                stack.push(value);
                atNames.push(atName);
            }
            stack.push(atNames);
            args.setup(stack, false);
        }
        stack.push(args);
    });
    APPEND_OPCODES.add(60 /* CreateComponent */, function (vm, _ref4) {
        var _vm$fetchValue2;

        var flags = _ref4.op1,
            _state = _ref4.op2;

        var definition = void 0;
        var manager = void 0;
        var args = vm.stack.pop();
        var dynamicScope = vm.dynamicScope();
        var state = (_vm$fetchValue2 = vm.fetchValue(_state), definition = _vm$fetchValue2.definition, manager = _vm$fetchValue2.manager, _vm$fetchValue2);
        var hasDefaultBlock = flags & 1;
        var component = manager.create(vm.env, definition, args, dynamicScope, vm.getSelf(), !!hasDefaultBlock);
        state.component = component;
        vm.updateWith(new UpdateComponentOpcode(args.tag, definition.name, component, manager, dynamicScope));
    });
    APPEND_OPCODES.add(61 /* RegisterComponentDestructor */, function (vm, _ref5) {
        var _state = _ref5.op1;

        var _vm$fetchValue3 = vm.fetchValue(_state),
            manager = _vm$fetchValue3.manager,
            component = _vm$fetchValue3.component;

        var destructor = manager.getDestructor(component);
        if (destructor) vm.newDestroyable(destructor);
    });
    APPEND_OPCODES.add(65 /* BeginComponentTransaction */, function (vm) {
        vm.beginCacheGroup();
        vm.elements().pushSimpleBlock();
    });
    APPEND_OPCODES.add(62 /* PushComponentOperations */, function (vm) {
        vm.stack.push(new ComponentElementOperations(vm.env));
    });
    APPEND_OPCODES.add(67 /* DidCreateElement */, function (vm, _ref6) {
        var _state = _ref6.op1;

        var _vm$fetchValue4 = vm.fetchValue(_state),
            manager = _vm$fetchValue4.manager,
            component = _vm$fetchValue4.component;

        var action = 'DidCreateElementOpcode#evaluate';
        manager.didCreateElement(component, vm.elements().expectConstructing(action), vm.elements().expectOperations(action));
    });
    APPEND_OPCODES.add(63 /* GetComponentSelf */, function (vm, _ref7) {
        var _state = _ref7.op1;

        var state = vm.fetchValue(_state);
        vm.stack.push(state.manager.getSelf(state.component));
    });
    APPEND_OPCODES.add(64 /* GetComponentLayout */, function (vm, _ref8) {
        var _state = _ref8.op1;

        var _vm$fetchValue5 = vm.fetchValue(_state),
            manager = _vm$fetchValue5.manager,
            definition = _vm$fetchValue5.definition,
            component = _vm$fetchValue5.component;

        vm.stack.push(manager.layoutFor(definition, component, vm.env));
    });
    APPEND_OPCODES.add(68 /* DidRenderLayout */, function (vm, _ref9) {
        var _state = _ref9.op1;

        var _vm$fetchValue6 = vm.fetchValue(_state),
            manager = _vm$fetchValue6.manager,
            component = _vm$fetchValue6.component;

        var bounds = vm.elements().popBlock();
        manager.didRenderLayout(component, bounds);
        vm.env.didCreate(component, manager);
        vm.updateWith(new DidUpdateLayoutOpcode(manager, component, bounds));
    });
    APPEND_OPCODES.add(66 /* CommitComponentTransaction */, function (vm) {
        return vm.commitCacheGroup();
    });
    var UpdateComponentOpcode = function (_UpdatingOpcode) {
        _inherits$3(UpdateComponentOpcode, _UpdatingOpcode);

        function UpdateComponentOpcode(tag, name, component, manager, dynamicScope) {
            _classCallCheck$3(this, UpdateComponentOpcode);

            var _this = _possibleConstructorReturn$3(this, _UpdatingOpcode.call(this));

            _this.name = name;
            _this.component = component;
            _this.manager = manager;
            _this.dynamicScope = dynamicScope;
            _this.type = 'update-component';
            var componentTag = manager.getTag(component);
            if (componentTag) {
                _this.tag = (0, _reference2.combine)([tag, componentTag]);
            } else {
                _this.tag = tag;
            }
            return _this;
        }

        UpdateComponentOpcode.prototype.evaluate = function evaluate(_vm) {
            var component = this.component,
                manager = this.manager,
                dynamicScope = this.dynamicScope;

            manager.update(component, dynamicScope);
        };

        UpdateComponentOpcode.prototype.toJSON = function toJSON() {
            return {
                args: [JSON.stringify(this.name)],
                guid: this._guid,
                type: this.type
            };
        };

        return UpdateComponentOpcode;
    }(UpdatingOpcode);
    var DidUpdateLayoutOpcode = function (_UpdatingOpcode2) {
        _inherits$3(DidUpdateLayoutOpcode, _UpdatingOpcode2);

        function DidUpdateLayoutOpcode(manager, component, bounds) {
            _classCallCheck$3(this, DidUpdateLayoutOpcode);

            var _this2 = _possibleConstructorReturn$3(this, _UpdatingOpcode2.call(this));

            _this2.manager = manager;
            _this2.component = component;
            _this2.bounds = bounds;
            _this2.type = 'did-update-layout';
            _this2.tag = _reference2.CONSTANT_TAG;
            return _this2;
        }

        DidUpdateLayoutOpcode.prototype.evaluate = function evaluate(vm) {
            var manager = this.manager,
                component = this.component,
                bounds = this.bounds;

            manager.didUpdateLayout(component, bounds);
            vm.env.didUpdate(component, manager);
        };

        return DidUpdateLayoutOpcode;
    }(UpdatingOpcode);

    function _classCallCheck$8(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var Cursor = function Cursor(element, nextSibling) {
        _classCallCheck$8(this, Cursor);

        this.element = element;
        this.nextSibling = nextSibling;
    };

    var ConcreteBounds = function () {
        function ConcreteBounds(parentNode, first, last) {
            _classCallCheck$8(this, ConcreteBounds);

            this.parentNode = parentNode;
            this.first = first;
            this.last = last;
        }

        ConcreteBounds.prototype.parentElement = function parentElement() {
            return this.parentNode;
        };

        ConcreteBounds.prototype.firstNode = function firstNode() {
            return this.first;
        };

        ConcreteBounds.prototype.lastNode = function lastNode() {
            return this.last;
        };

        return ConcreteBounds;
    }();
    var SingleNodeBounds = function () {
        function SingleNodeBounds(parentNode, node) {
            _classCallCheck$8(this, SingleNodeBounds);

            this.parentNode = parentNode;
            this.node = node;
        }

        SingleNodeBounds.prototype.parentElement = function parentElement() {
            return this.parentNode;
        };

        SingleNodeBounds.prototype.firstNode = function firstNode() {
            return this.node;
        };

        SingleNodeBounds.prototype.lastNode = function lastNode() {
            return this.node;
        };

        return SingleNodeBounds;
    }();

    function single(parent, node) {
        return new SingleNodeBounds(parent, node);
    }
    function move(bounds, reference) {
        var parent = bounds.parentElement();
        var first = bounds.firstNode();
        var last = bounds.lastNode();
        var node = first;
        while (node) {
            var next = node.nextSibling;
            parent.insertBefore(node, reference);
            if (node === last) return next;
            node = next;
        }
        return null;
    }
    function clear(bounds) {
        var parent = bounds.parentElement();
        var first = bounds.firstNode();
        var last = bounds.lastNode();
        var node = first;
        while (node) {
            var next = node.nextSibling;
            parent.removeChild(node);
            if (node === last) return next;
            node = next;
        }
        return null;
    }

    function _defaults$7(obj, defaults) {
        var keys = Object.getOwnPropertyNames(defaults);for (var i = 0; i < keys.length; i++) {
            var key = keys[i];var value = Object.getOwnPropertyDescriptor(defaults, key);if (value && value.configurable && obj[key] === undefined) {
                Object.defineProperty(obj, key, value);
            }
        }return obj;
    }

    function _possibleConstructorReturn$7(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits$7(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults$7(subClass, superClass);
    }

    function _classCallCheck$9(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var First = function () {
        function First(node) {
            _classCallCheck$9(this, First);

            this.node = node;
        }

        First.prototype.firstNode = function firstNode() {
            return this.node;
        };

        return First;
    }();

    var Last = function () {
        function Last(node) {
            _classCallCheck$9(this, Last);

            this.node = node;
        }

        Last.prototype.lastNode = function lastNode() {
            return this.node;
        };

        return Last;
    }();

    var Fragment = function () {
        function Fragment(bounds$$1) {
            _classCallCheck$9(this, Fragment);

            this.bounds = bounds$$1;
        }

        Fragment.prototype.parentElement = function parentElement() {
            return this.bounds.parentElement();
        };

        Fragment.prototype.firstNode = function firstNode() {
            return this.bounds.firstNode();
        };

        Fragment.prototype.lastNode = function lastNode() {
            return this.bounds.lastNode();
        };

        Fragment.prototype.update = function update(bounds$$1) {
            this.bounds = bounds$$1;
        };

        return Fragment;
    }();
    var ElementStack = function () {
        function ElementStack(env, parentNode, nextSibling) {
            _classCallCheck$9(this, ElementStack);

            this.constructing = null;
            this.operations = null;
            this.elementStack = new _util.Stack();
            this.nextSiblingStack = new _util.Stack();
            this.blockStack = new _util.Stack();
            this.env = env;
            this.dom = env.getAppendOperations();
            this.updateOperations = env.getDOM();
            this.element = parentNode;
            this.nextSibling = nextSibling;
            this.defaultOperations = new SimpleElementOperations(env);
            this.pushSimpleBlock();
            this.elementStack.push(this.element);
            this.nextSiblingStack.push(this.nextSibling);
        }

        ElementStack.forInitialRender = function forInitialRender(env, parentNode, nextSibling) {
            return new ElementStack(env, parentNode, nextSibling);
        };

        ElementStack.resume = function resume(env, tracker, nextSibling) {
            var parentNode = tracker.parentElement();
            var stack = new ElementStack(env, parentNode, nextSibling);
            stack.pushBlockTracker(tracker);
            return stack;
        };

        ElementStack.prototype.expectConstructing = function expectConstructing(method) {
            return this.constructing;
        };

        ElementStack.prototype.expectOperations = function expectOperations(method) {
            return this.operations;
        };

        ElementStack.prototype.block = function block() {
            return this.blockStack.current;
        };

        ElementStack.prototype.popElement = function popElement() {
            var elementStack = this.elementStack,
                nextSiblingStack = this.nextSiblingStack;

            var topElement = elementStack.pop();
            nextSiblingStack.pop();
            // LOGGER.debug(`-> element stack ${this.elementStack.toArray().map(e => e.tagName).join(', ')}`);
            this.element = elementStack.current;
            this.nextSibling = nextSiblingStack.current;
            return topElement;
        };

        ElementStack.prototype.pushSimpleBlock = function pushSimpleBlock() {
            var tracker = new SimpleBlockTracker(this.element);
            this.pushBlockTracker(tracker);
            return tracker;
        };

        ElementStack.prototype.pushUpdatableBlock = function pushUpdatableBlock() {
            var tracker = new UpdatableBlockTracker(this.element);
            this.pushBlockTracker(tracker);
            return tracker;
        };

        ElementStack.prototype.pushBlockTracker = function pushBlockTracker(tracker) {
            var isRemote = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

            var current = this.blockStack.current;
            if (current !== null) {
                current.newDestroyable(tracker);
                if (!isRemote) {
                    current.newBounds(tracker);
                }
            }
            this.blockStack.push(tracker);
            return tracker;
        };

        ElementStack.prototype.pushBlockList = function pushBlockList(list) {
            var tracker = new BlockListTracker(this.element, list);
            var current = this.blockStack.current;
            if (current !== null) {
                current.newDestroyable(tracker);
                current.newBounds(tracker);
            }
            this.blockStack.push(tracker);
            return tracker;
        };

        ElementStack.prototype.popBlock = function popBlock() {
            this.block().finalize(this);
            return this.blockStack.pop();
        };

        ElementStack.prototype.openElement = function openElement(tag, _operations) {
            // workaround argument.length transpile of arg initializer
            var operations = _operations === undefined ? this.defaultOperations : _operations;
            var element = this.dom.createElement(tag, this.element);
            this.constructing = element;
            this.operations = operations;
            return element;
        };

        ElementStack.prototype.flushElement = function flushElement() {
            var parent = this.element;
            var element = this.constructing;
            this.dom.insertBefore(parent, element, this.nextSibling);
            this.constructing = null;
            this.operations = null;
            this.pushElement(element, null);
            this.block().openElement(element);
        };

        ElementStack.prototype.pushRemoteElement = function pushRemoteElement(element) {
            var nextSibling = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

            this.pushElement(element, nextSibling);
            var tracker = new RemoteBlockTracker(element);
            this.pushBlockTracker(tracker, true);
        };

        ElementStack.prototype.popRemoteElement = function popRemoteElement() {
            this.popBlock();
            this.popElement();
        };

        ElementStack.prototype.pushElement = function pushElement(element, nextSibling) {
            this.element = element;
            this.elementStack.push(element);
            // LOGGER.debug(`-> element stack ${this.elementStack.toArray().map(e => e.tagName).join(', ')}`);
            this.nextSibling = nextSibling;
            this.nextSiblingStack.push(nextSibling);
        };

        ElementStack.prototype.newDestroyable = function newDestroyable(d) {
            this.block().newDestroyable(d);
        };

        ElementStack.prototype.newBounds = function newBounds(bounds$$1) {
            this.block().newBounds(bounds$$1);
        };

        ElementStack.prototype.appendText = function appendText(string) {
            var dom = this.dom;

            var text = dom.createTextNode(string);
            dom.insertBefore(this.element, text, this.nextSibling);
            this.block().newNode(text);
            return text;
        };

        ElementStack.prototype.appendComment = function appendComment(string) {
            var dom = this.dom;

            var comment = dom.createComment(string);
            dom.insertBefore(this.element, comment, this.nextSibling);
            this.block().newNode(comment);
            return comment;
        };

        ElementStack.prototype.setStaticAttribute = function setStaticAttribute(name, value) {
            this.expectOperations('setStaticAttribute').addStaticAttribute(this.expectConstructing('setStaticAttribute'), name, value);
        };

        ElementStack.prototype.setStaticAttributeNS = function setStaticAttributeNS(namespace, name, value) {
            this.expectOperations('setStaticAttributeNS').addStaticAttributeNS(this.expectConstructing('setStaticAttributeNS'), namespace, name, value);
        };

        ElementStack.prototype.setDynamicAttribute = function setDynamicAttribute(name, reference, isTrusting) {
            this.expectOperations('setDynamicAttribute').addDynamicAttribute(this.expectConstructing('setDynamicAttribute'), name, reference, isTrusting);
        };

        ElementStack.prototype.setDynamicAttributeNS = function setDynamicAttributeNS(namespace, name, reference, isTrusting) {
            this.expectOperations('setDynamicAttributeNS').addDynamicAttributeNS(this.expectConstructing('setDynamicAttributeNS'), namespace, name, reference, isTrusting);
        };

        ElementStack.prototype.closeElement = function closeElement() {
            this.block().closeElement();
            this.popElement();
        };

        return ElementStack;
    }();
    var SimpleBlockTracker = function () {
        function SimpleBlockTracker(parent) {
            _classCallCheck$9(this, SimpleBlockTracker);

            this.parent = parent;
            this.first = null;
            this.last = null;
            this.destroyables = null;
            this.nesting = 0;
        }

        SimpleBlockTracker.prototype.destroy = function destroy() {
            var destroyables = this.destroyables;

            if (destroyables && destroyables.length) {
                for (var i = 0; i < destroyables.length; i++) {
                    destroyables[i].destroy();
                }
            }
        };

        SimpleBlockTracker.prototype.parentElement = function parentElement() {
            return this.parent;
        };

        SimpleBlockTracker.prototype.firstNode = function firstNode() {
            return this.first && this.first.firstNode();
        };

        SimpleBlockTracker.prototype.lastNode = function lastNode() {
            return this.last && this.last.lastNode();
        };

        SimpleBlockTracker.prototype.openElement = function openElement(element) {
            this.newNode(element);
            this.nesting++;
        };

        SimpleBlockTracker.prototype.closeElement = function closeElement() {
            this.nesting--;
        };

        SimpleBlockTracker.prototype.newNode = function newNode(node) {
            if (this.nesting !== 0) return;
            if (!this.first) {
                this.first = new First(node);
            }
            this.last = new Last(node);
        };

        SimpleBlockTracker.prototype.newBounds = function newBounds(bounds$$1) {
            if (this.nesting !== 0) return;
            if (!this.first) {
                this.first = bounds$$1;
            }
            this.last = bounds$$1;
        };

        SimpleBlockTracker.prototype.newDestroyable = function newDestroyable(d) {
            this.destroyables = this.destroyables || [];
            this.destroyables.push(d);
        };

        SimpleBlockTracker.prototype.finalize = function finalize(stack) {
            if (!this.first) {
                stack.appendComment('');
            }
        };

        return SimpleBlockTracker;
    }();

    var RemoteBlockTracker = function (_SimpleBlockTracker) {
        _inherits$7(RemoteBlockTracker, _SimpleBlockTracker);

        function RemoteBlockTracker() {
            _classCallCheck$9(this, RemoteBlockTracker);

            return _possibleConstructorReturn$7(this, _SimpleBlockTracker.apply(this, arguments));
        }

        RemoteBlockTracker.prototype.destroy = function destroy() {
            _SimpleBlockTracker.prototype.destroy.call(this);
            clear(this);
        };

        return RemoteBlockTracker;
    }(SimpleBlockTracker);

    var UpdatableBlockTracker = function (_SimpleBlockTracker2) {
        _inherits$7(UpdatableBlockTracker, _SimpleBlockTracker2);

        function UpdatableBlockTracker() {
            _classCallCheck$9(this, UpdatableBlockTracker);

            return _possibleConstructorReturn$7(this, _SimpleBlockTracker2.apply(this, arguments));
        }

        UpdatableBlockTracker.prototype.reset = function reset(env) {
            var destroyables = this.destroyables;

            if (destroyables && destroyables.length) {
                for (var i = 0; i < destroyables.length; i++) {
                    env.didDestroy(destroyables[i]);
                }
            }
            var nextSibling = clear(this);
            this.first = null;
            this.last = null;
            this.destroyables = null;
            this.nesting = 0;
            return nextSibling;
        };

        return UpdatableBlockTracker;
    }(SimpleBlockTracker);

    var BlockListTracker = function () {
        function BlockListTracker(parent, boundList) {
            _classCallCheck$9(this, BlockListTracker);

            this.parent = parent;
            this.boundList = boundList;
            this.parent = parent;
            this.boundList = boundList;
        }

        BlockListTracker.prototype.destroy = function destroy() {
            this.boundList.forEachNode(function (node) {
                return node.destroy();
            });
        };

        BlockListTracker.prototype.parentElement = function parentElement() {
            return this.parent;
        };

        BlockListTracker.prototype.firstNode = function firstNode() {
            var head = this.boundList.head();
            return head && head.firstNode();
        };

        BlockListTracker.prototype.lastNode = function lastNode() {
            var tail = this.boundList.tail();
            return tail && tail.lastNode();
        };

        BlockListTracker.prototype.openElement = function openElement(_element) {
            (0, _util.assert)(false, 'Cannot openElement directly inside a block list');
        };

        BlockListTracker.prototype.closeElement = function closeElement() {
            (0, _util.assert)(false, 'Cannot closeElement directly inside a block list');
        };

        BlockListTracker.prototype.newNode = function newNode(_node) {
            (0, _util.assert)(false, 'Cannot create a new node directly inside a block list');
        };

        BlockListTracker.prototype.newBounds = function newBounds(_bounds) {};

        BlockListTracker.prototype.newDestroyable = function newDestroyable(_d) {};

        BlockListTracker.prototype.finalize = function finalize(_stack) {};

        return BlockListTracker;
    }();

    function _classCallCheck$10(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var COMPONENT_DEFINITION_BRAND = 'COMPONENT DEFINITION [id=e59c754e-61eb-4392-8c4a-2c0ac72bfcd4]';
    function isComponentDefinition(obj) {
        return typeof obj === 'object' && obj !== null && obj[COMPONENT_DEFINITION_BRAND];
    }
    var ComponentDefinition = function ComponentDefinition(name, manager, ComponentClass) {
        _classCallCheck$10(this, ComponentDefinition);

        this[COMPONENT_DEFINITION_BRAND] = true;
        this.name = name;
        this.manager = manager;
        this.ComponentClass = ComponentClass;
    };

    function _defaults$8(obj, defaults) {
        var keys = Object.getOwnPropertyNames(defaults);for (var i = 0; i < keys.length; i++) {
            var key = keys[i];var value = Object.getOwnPropertyDescriptor(defaults, key);if (value && value.configurable && obj[key] === undefined) {
                Object.defineProperty(obj, key, value);
            }
        }return obj;
    }

    function _possibleConstructorReturn$8(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits$8(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults$8(subClass, superClass);
    }

    function _classCallCheck$11(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    function isSafeString(value) {
        return typeof value === 'object' && value !== null && typeof value.toHTML === 'function';
    }
    function isNode(value) {
        return typeof value === 'object' && value !== null && typeof value.nodeType === 'number';
    }
    function isString(value) {
        return typeof value === 'string';
    }

    var Upsert = function Upsert(bounds$$1) {
        _classCallCheck$11(this, Upsert);

        this.bounds = bounds$$1;
    };

    function cautiousInsert(dom, cursor, value) {
        if (isString(value)) {
            return TextUpsert.insert(dom, cursor, value);
        }
        if (isSafeString(value)) {
            return SafeStringUpsert.insert(dom, cursor, value);
        }
        if (isNode(value)) {
            return NodeUpsert.insert(dom, cursor, value);
        }
        throw (0, _util.unreachable)();
    }
    function trustingInsert(dom, cursor, value) {
        if (isString(value)) {
            return HTMLUpsert.insert(dom, cursor, value);
        }
        if (isNode(value)) {
            return NodeUpsert.insert(dom, cursor, value);
        }
        throw (0, _util.unreachable)();
    }

    var TextUpsert = function (_Upsert) {
        _inherits$8(TextUpsert, _Upsert);

        TextUpsert.insert = function insert(dom, cursor, value) {
            var textNode = dom.createTextNode(value);
            dom.insertBefore(cursor.element, textNode, cursor.nextSibling);
            var bounds$$1 = new SingleNodeBounds(cursor.element, textNode);
            return new TextUpsert(bounds$$1, textNode);
        };

        function TextUpsert(bounds$$1, textNode) {
            _classCallCheck$11(this, TextUpsert);

            var _this = _possibleConstructorReturn$8(this, _Upsert.call(this, bounds$$1));

            _this.textNode = textNode;
            return _this;
        }

        TextUpsert.prototype.update = function update(_dom, value) {
            if (isString(value)) {
                var textNode = this.textNode;

                textNode.nodeValue = value;
                return true;
            } else {
                return false;
            }
        };

        return TextUpsert;
    }(Upsert);

    var HTMLUpsert = function (_Upsert2) {
        _inherits$8(HTMLUpsert, _Upsert2);

        function HTMLUpsert() {
            _classCallCheck$11(this, HTMLUpsert);

            return _possibleConstructorReturn$8(this, _Upsert2.apply(this, arguments));
        }

        HTMLUpsert.insert = function insert(dom, cursor, value) {
            var bounds$$1 = dom.insertHTMLBefore(cursor.element, cursor.nextSibling, value);
            return new HTMLUpsert(bounds$$1);
        };

        HTMLUpsert.prototype.update = function update(dom, value) {
            if (isString(value)) {
                var bounds$$1 = this.bounds;

                var parentElement = bounds$$1.parentElement();
                var nextSibling = clear(bounds$$1);
                this.bounds = dom.insertHTMLBefore(parentElement, nextSibling, value);
                return true;
            } else {
                return false;
            }
        };

        return HTMLUpsert;
    }(Upsert);

    var SafeStringUpsert = function (_Upsert3) {
        _inherits$8(SafeStringUpsert, _Upsert3);

        function SafeStringUpsert(bounds$$1, lastStringValue) {
            _classCallCheck$11(this, SafeStringUpsert);

            var _this3 = _possibleConstructorReturn$8(this, _Upsert3.call(this, bounds$$1));

            _this3.lastStringValue = lastStringValue;
            return _this3;
        }

        SafeStringUpsert.insert = function insert(dom, cursor, value) {
            var stringValue = value.toHTML();
            var bounds$$1 = dom.insertHTMLBefore(cursor.element, cursor.nextSibling, stringValue);
            return new SafeStringUpsert(bounds$$1, stringValue);
        };

        SafeStringUpsert.prototype.update = function update(dom, value) {
            if (isSafeString(value)) {
                var stringValue = value.toHTML();
                if (stringValue !== this.lastStringValue) {
                    var bounds$$1 = this.bounds;

                    var parentElement = bounds$$1.parentElement();
                    var nextSibling = clear(bounds$$1);
                    this.bounds = dom.insertHTMLBefore(parentElement, nextSibling, stringValue);
                    this.lastStringValue = stringValue;
                }
                return true;
            } else {
                return false;
            }
        };

        return SafeStringUpsert;
    }(Upsert);

    var NodeUpsert = function (_Upsert4) {
        _inherits$8(NodeUpsert, _Upsert4);

        function NodeUpsert() {
            _classCallCheck$11(this, NodeUpsert);

            return _possibleConstructorReturn$8(this, _Upsert4.apply(this, arguments));
        }

        NodeUpsert.insert = function insert(dom, cursor, node) {
            dom.insertBefore(cursor.element, node, cursor.nextSibling);
            return new NodeUpsert(single(cursor.element, node));
        };

        NodeUpsert.prototype.update = function update(dom, value) {
            if (isNode(value)) {
                var bounds$$1 = this.bounds;

                var parentElement = bounds$$1.parentElement();
                var nextSibling = clear(bounds$$1);
                this.bounds = dom.insertNodeBefore(parentElement, value, nextSibling);
                return true;
            } else {
                return false;
            }
        };

        return NodeUpsert;
    }(Upsert);

    function _defaults$6(obj, defaults) {
        var keys = Object.getOwnPropertyNames(defaults);for (var i = 0; i < keys.length; i++) {
            var key = keys[i];var value = Object.getOwnPropertyDescriptor(defaults, key);if (value && value.configurable && obj[key] === undefined) {
                Object.defineProperty(obj, key, value);
            }
        }return obj;
    }

    function _possibleConstructorReturn$6(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits$6(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults$6(subClass, superClass);
    }

    function _classCallCheck$7(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    APPEND_OPCODES.add(26 /* DynamicContent */, function (vm, _ref) {
        var append = _ref.op1;

        var opcode = vm.constants.getOther(append);
        opcode.evaluate(vm);
    });
    function isEmpty(value) {
        return value === null || value === undefined || typeof value.toString !== 'function';
    }
    function normalizeTextValue(value) {
        if (isEmpty(value)) {
            return '';
        }
        return String(value);
    }
    function normalizeTrustedValue(value) {
        if (isEmpty(value)) {
            return '';
        }
        if (isString(value)) {
            return value;
        }
        if (isSafeString(value)) {
            return value.toHTML();
        }
        if (isNode(value)) {
            return value;
        }
        return String(value);
    }
    function normalizeValue(value) {
        if (isEmpty(value)) {
            return '';
        }
        if (isString(value)) {
            return value;
        }
        if (isSafeString(value) || isNode(value)) {
            return value;
        }
        return String(value);
    }
    var AppendDynamicOpcode = function () {
        function AppendDynamicOpcode() {
            _classCallCheck$7(this, AppendDynamicOpcode);
        }

        AppendDynamicOpcode.prototype.evaluate = function evaluate(vm) {
            var reference = vm.stack.pop();
            var normalized = this.normalize(reference);
            var value = void 0;
            var cache = void 0;
            if ((0, _reference2.isConst)(reference)) {
                value = normalized.value();
            } else {
                cache = new _reference2.ReferenceCache(normalized);
                value = cache.peek();
            }
            var stack = vm.elements();
            var upsert = this.insert(vm.env.getAppendOperations(), stack, value);
            var bounds$$1 = new Fragment(upsert.bounds);
            stack.newBounds(bounds$$1);
            if (cache /* i.e. !isConst(reference) */) {
                    vm.updateWith(this.updateWith(vm, reference, cache, bounds$$1, upsert));
                }
        };

        return AppendDynamicOpcode;
    }();
    var IsComponentDefinitionReference = function (_ConditionalReference) {
        _inherits$6(IsComponentDefinitionReference, _ConditionalReference);

        function IsComponentDefinitionReference() {
            _classCallCheck$7(this, IsComponentDefinitionReference);

            return _possibleConstructorReturn$6(this, _ConditionalReference.apply(this, arguments));
        }

        IsComponentDefinitionReference.create = function create(inner) {
            return new IsComponentDefinitionReference(inner);
        };

        IsComponentDefinitionReference.prototype.toBool = function toBool(value) {
            return isComponentDefinition(value);
        };

        return IsComponentDefinitionReference;
    }(ConditionalReference);

    var UpdateOpcode = function (_UpdatingOpcode) {
        _inherits$6(UpdateOpcode, _UpdatingOpcode);

        function UpdateOpcode(cache, bounds$$1, upsert) {
            _classCallCheck$7(this, UpdateOpcode);

            var _this2 = _possibleConstructorReturn$6(this, _UpdatingOpcode.call(this));

            _this2.cache = cache;
            _this2.bounds = bounds$$1;
            _this2.upsert = upsert;
            _this2.tag = cache.tag;
            return _this2;
        }

        UpdateOpcode.prototype.evaluate = function evaluate(vm) {
            var value = this.cache.revalidate();
            if ((0, _reference2.isModified)(value)) {
                var bounds$$1 = this.bounds,
                    upsert = this.upsert;
                var dom = vm.dom;

                if (!this.upsert.update(dom, value)) {
                    var cursor = new Cursor(bounds$$1.parentElement(), clear(bounds$$1));
                    upsert = this.upsert = this.insert(vm.env.getAppendOperations(), cursor, value);
                }
                bounds$$1.update(upsert.bounds);
            }
        };

        UpdateOpcode.prototype.toJSON = function toJSON() {
            var guid = this._guid,
                type = this.type,
                cache = this.cache;

            return {
                details: { lastValue: JSON.stringify(cache.peek()) },
                guid: guid,
                type: type
            };
        };

        return UpdateOpcode;
    }(UpdatingOpcode);

    var OptimizedCautiousAppendOpcode = function (_AppendDynamicOpcode) {
        _inherits$6(OptimizedCautiousAppendOpcode, _AppendDynamicOpcode);

        function OptimizedCautiousAppendOpcode() {
            _classCallCheck$7(this, OptimizedCautiousAppendOpcode);

            var _this3 = _possibleConstructorReturn$6(this, _AppendDynamicOpcode.apply(this, arguments));

            _this3.type = 'optimized-cautious-append';
            return _this3;
        }

        OptimizedCautiousAppendOpcode.prototype.normalize = function normalize(reference) {
            return (0, _reference2.map)(reference, normalizeValue);
        };

        OptimizedCautiousAppendOpcode.prototype.insert = function insert(dom, cursor, value) {
            return cautiousInsert(dom, cursor, value);
        };

        OptimizedCautiousAppendOpcode.prototype.updateWith = function updateWith(_vm, _reference, cache, bounds$$1, upsert) {
            return new OptimizedCautiousUpdateOpcode(cache, bounds$$1, upsert);
        };

        return OptimizedCautiousAppendOpcode;
    }(AppendDynamicOpcode);

    var OptimizedCautiousUpdateOpcode = function (_UpdateOpcode) {
        _inherits$6(OptimizedCautiousUpdateOpcode, _UpdateOpcode);

        function OptimizedCautiousUpdateOpcode() {
            _classCallCheck$7(this, OptimizedCautiousUpdateOpcode);

            var _this4 = _possibleConstructorReturn$6(this, _UpdateOpcode.apply(this, arguments));

            _this4.type = 'optimized-cautious-update';
            return _this4;
        }

        OptimizedCautiousUpdateOpcode.prototype.insert = function insert(dom, cursor, value) {
            return cautiousInsert(dom, cursor, value);
        };

        return OptimizedCautiousUpdateOpcode;
    }(UpdateOpcode);

    var OptimizedTrustingAppendOpcode = function (_AppendDynamicOpcode2) {
        _inherits$6(OptimizedTrustingAppendOpcode, _AppendDynamicOpcode2);

        function OptimizedTrustingAppendOpcode() {
            _classCallCheck$7(this, OptimizedTrustingAppendOpcode);

            var _this5 = _possibleConstructorReturn$6(this, _AppendDynamicOpcode2.apply(this, arguments));

            _this5.type = 'optimized-trusting-append';
            return _this5;
        }

        OptimizedTrustingAppendOpcode.prototype.normalize = function normalize(reference) {
            return (0, _reference2.map)(reference, normalizeTrustedValue);
        };

        OptimizedTrustingAppendOpcode.prototype.insert = function insert(dom, cursor, value) {
            return trustingInsert(dom, cursor, value);
        };

        OptimizedTrustingAppendOpcode.prototype.updateWith = function updateWith(_vm, _reference, cache, bounds$$1, upsert) {
            return new OptimizedTrustingUpdateOpcode(cache, bounds$$1, upsert);
        };

        return OptimizedTrustingAppendOpcode;
    }(AppendDynamicOpcode);

    var OptimizedTrustingUpdateOpcode = function (_UpdateOpcode2) {
        _inherits$6(OptimizedTrustingUpdateOpcode, _UpdateOpcode2);

        function OptimizedTrustingUpdateOpcode() {
            _classCallCheck$7(this, OptimizedTrustingUpdateOpcode);

            var _this6 = _possibleConstructorReturn$6(this, _UpdateOpcode2.apply(this, arguments));

            _this6.type = 'optimized-trusting-update';
            return _this6;
        }

        OptimizedTrustingUpdateOpcode.prototype.insert = function insert(dom, cursor, value) {
            return trustingInsert(dom, cursor, value);
        };

        return OptimizedTrustingUpdateOpcode;
    }(UpdateOpcode);

    function _classCallCheck$12(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    /* tslint:disable */
    function debugCallback(context, get) {
        console.info('Use `context`, and `get(<path>)` to debug this template.');
        // for example...
        context === get('this');
        debugger;
    }
    /* tslint:enable */
    var callback = debugCallback;
    // For testing purposes
    function setDebuggerCallback(cb) {
        callback = cb;
    }
    function resetDebuggerCallback() {
        callback = debugCallback;
    }

    var ScopeInspector = function () {
        function ScopeInspector(scope, symbols, evalInfo) {
            _classCallCheck$12(this, ScopeInspector);

            this.scope = scope;
            this.locals = (0, _util.dict)();
            for (var i = 0; i < evalInfo.length; i++) {
                var slot = evalInfo[i];
                var name = symbols[slot - 1];
                var ref = scope.getSymbol(slot);
                this.locals[name] = ref;
            }
        }

        ScopeInspector.prototype.get = function get(path) {
            var scope = this.scope,
                locals = this.locals;

            var parts = path.split('.');

            var _path$split = path.split('.'),
                head = _path$split[0],
                tail = _path$split.slice(1);

            var evalScope = scope.getEvalScope();
            var ref = void 0;
            if (head === 'this') {
                ref = scope.getSelf();
            } else if (locals[head]) {
                ref = locals[head];
            } else if (head.indexOf('@') === 0 && evalScope[head]) {
                ref = evalScope[head];
            } else {
                ref = this.scope.getSelf();
                tail = parts;
            }
            return tail.reduce(function (r, part) {
                return r.get(part);
            }, ref);
        };

        return ScopeInspector;
    }();

    APPEND_OPCODES.add(71 /* Debugger */, function (vm, _ref) {
        var _symbols = _ref.op1,
            _evalInfo = _ref.op2;

        var symbols = vm.constants.getOther(_symbols);
        var evalInfo = vm.constants.getArray(_evalInfo);
        var inspector = new ScopeInspector(vm.scope(), symbols, evalInfo);
        callback(vm.getSelf().value(), function (path) {
            return inspector.get(path).value();
        });
    });

    APPEND_OPCODES.add(69 /* GetPartialTemplate */, function (vm) {
        var stack = vm.stack;
        var definition = stack.pop();
        stack.push(definition.value().template.asPartial());
    });

    function _classCallCheck$13(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var IterablePresenceReference = function () {
        function IterablePresenceReference(artifacts) {
            _classCallCheck$13(this, IterablePresenceReference);

            this.tag = artifacts.tag;
            this.artifacts = artifacts;
        }

        IterablePresenceReference.prototype.value = function value() {
            return !this.artifacts.isEmpty();
        };

        return IterablePresenceReference;
    }();

    APPEND_OPCODES.add(54 /* PutIterator */, function (vm) {
        var stack = vm.stack;
        var listRef = stack.pop();
        var key = stack.pop();
        var iterable = vm.env.iterableFor(listRef, key.value());
        var iterator = new _reference2.ReferenceIterator(iterable);
        stack.push(iterator);
        stack.push(new IterablePresenceReference(iterator.artifacts));
    });
    APPEND_OPCODES.add(52 /* EnterList */, function (vm, _ref) {
        var relativeStart = _ref.op1;

        vm.enterList(relativeStart);
    });
    APPEND_OPCODES.add(53 /* ExitList */, function (vm) {
        return vm.exitList();
    });
    APPEND_OPCODES.add(55 /* Iterate */, function (vm, _ref2) {
        var breaks = _ref2.op1;

        var stack = vm.stack;
        var item = stack.peek().next();
        if (item) {
            var tryOpcode = vm.iterate(item.memo, item.value);
            vm.enterItem(item.key, tryOpcode);
        } else {
            vm.goto(breaks);
        }
    });

    var Ops$2;
    (function (Ops$$1) {
        Ops$$1[Ops$$1["OpenComponentElement"] = 0] = "OpenComponentElement";
        Ops$$1[Ops$$1["DidCreateElement"] = 1] = "DidCreateElement";
        Ops$$1[Ops$$1["DidRenderLayout"] = 2] = "DidRenderLayout";
        Ops$$1[Ops$$1["FunctionExpression"] = 3] = "FunctionExpression";
    })(Ops$2 || (Ops$2 = {}));

    function _classCallCheck$17(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var CompiledStaticTemplate = function CompiledStaticTemplate(handle) {
        _classCallCheck$17(this, CompiledStaticTemplate);

        this.handle = handle;
    };
    var CompiledDynamicTemplate = function CompiledDynamicTemplate(handle, symbolTable) {
        _classCallCheck$17(this, CompiledDynamicTemplate);

        this.handle = handle;
        this.symbolTable = symbolTable;
    };

    var _createClass$2 = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
            }
        }return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
        };
    }();

    function _classCallCheck$20(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    function compileLayout(compilable, env) {
        var builder = new ComponentLayoutBuilder(env);
        compilable.compile(builder);
        return builder.compile();
    }

    var ComponentLayoutBuilder = function () {
        function ComponentLayoutBuilder(env) {
            _classCallCheck$20(this, ComponentLayoutBuilder);

            this.env = env;
        }

        ComponentLayoutBuilder.prototype.wrapLayout = function wrapLayout(layout) {
            this.inner = new WrappedBuilder(this.env, layout);
        };

        ComponentLayoutBuilder.prototype.fromLayout = function fromLayout(componentName, layout) {
            this.inner = new UnwrappedBuilder(this.env, componentName, layout);
        };

        ComponentLayoutBuilder.prototype.compile = function compile() {
            return this.inner.compile();
        };

        _createClass$2(ComponentLayoutBuilder, [{
            key: 'tag',
            get: function () {
                return this.inner.tag;
            }
        }, {
            key: 'attrs',
            get: function () {
                return this.inner.attrs;
            }
        }]);

        return ComponentLayoutBuilder;
    }();

    var WrappedBuilder = function () {
        function WrappedBuilder(env, layout) {
            _classCallCheck$20(this, WrappedBuilder);

            this.env = env;
            this.layout = layout;
            this.tag = new ComponentTagBuilder();
            this.attrs = new ComponentAttrsBuilder();
        }

        WrappedBuilder.prototype.compile = function compile() {
            //========DYNAMIC
            //        PutValue(TagExpr)
            //        Test
            //        JumpUnless(BODY)
            //        OpenDynamicPrimitiveElement
            //        DidCreateElement
            //        ...attr statements...
            //        FlushElement
            // BODY:  Noop
            //        ...body statements...
            //        PutValue(TagExpr)
            //        Test
            //        JumpUnless(END)
            //        CloseElement
            // END:   Noop
            //        DidRenderLayout
            //        Exit
            //
            //========STATIC
            //        OpenPrimitiveElementOpcode
            //        DidCreateElement
            //        ...attr statements...
            //        FlushElement
            //        ...body statements...
            //        CloseElement
            //        DidRenderLayout
            //        Exit
            var env = this.env,
                layout = this.layout;

            var meta = { templateMeta: layout.meta, symbols: layout.symbols, asPartial: false };
            var dynamicTag = this.tag.getDynamic();
            var staticTag = this.tag.getStatic();
            var b = builder(env, meta);
            b.startLabels();
            if (dynamicTag) {
                b.fetch(Register.s1);
                expr(dynamicTag, b);
                b.dup();
                b.load(Register.s1);
                b.test('simple');
                b.jumpUnless('BODY');
                b.fetch(Register.s1);
                b.pushComponentOperations();
                b.openDynamicElement();
            } else if (staticTag) {
                b.pushComponentOperations();
                b.openElementWithOperations(staticTag);
            }
            if (dynamicTag || staticTag) {
                b.didCreateElement(Register.s0);
                var attrs = this.attrs.buffer;
                for (var i = 0; i < attrs.length; i++) {
                    compileStatement(attrs[i], b);
                }
                b.flushElement();
            }
            b.label('BODY');
            b.invokeStatic(layout.asBlock());
            if (dynamicTag) {
                b.fetch(Register.s1);
                b.test('simple');
                b.jumpUnless('END');
                b.closeElement();
            } else if (staticTag) {
                b.closeElement();
            }
            b.label('END');
            b.didRenderLayout(Register.s0);
            if (dynamicTag) {
                b.load(Register.s1);
            }
            b.stopLabels();
            var start = b.start;
            var end = b.finalize();
            return new CompiledDynamicTemplate(start, {
                meta: meta,
                hasEval: layout.hasEval,
                symbols: layout.symbols.concat([ATTRS_BLOCK])
            });
        };

        return WrappedBuilder;
    }();

    var UnwrappedBuilder = function () {
        function UnwrappedBuilder(env, componentName, layout) {
            _classCallCheck$20(this, UnwrappedBuilder);

            this.env = env;
            this.componentName = componentName;
            this.layout = layout;
            this.attrs = new ComponentAttrsBuilder();
        }

        UnwrappedBuilder.prototype.compile = function compile() {
            var env = this.env,
                layout = this.layout;

            return layout.asLayout(this.componentName, this.attrs.buffer).compileDynamic(env);
        };

        _createClass$2(UnwrappedBuilder, [{
            key: 'tag',
            get: function () {
                throw new Error('BUG: Cannot call `tag` on an UnwrappedBuilder');
            }
        }]);

        return UnwrappedBuilder;
    }();

    var ComponentTagBuilder = function () {
        function ComponentTagBuilder() {
            _classCallCheck$20(this, ComponentTagBuilder);

            this.isDynamic = null;
            this.isStatic = null;
            this.staticTagName = null;
            this.dynamicTagName = null;
        }

        ComponentTagBuilder.prototype.getDynamic = function getDynamic() {
            if (this.isDynamic) {
                return this.dynamicTagName;
            }
        };

        ComponentTagBuilder.prototype.getStatic = function getStatic() {
            if (this.isStatic) {
                return this.staticTagName;
            }
        };

        ComponentTagBuilder.prototype.static = function _static(tagName) {
            this.isStatic = true;
            this.staticTagName = tagName;
        };

        ComponentTagBuilder.prototype.dynamic = function dynamic(tagName) {
            this.isDynamic = true;
            this.dynamicTagName = [_wireFormat.Ops.ClientSideExpression, Ops$2.FunctionExpression, tagName];
        };

        return ComponentTagBuilder;
    }();

    var ComponentAttrsBuilder = function () {
        function ComponentAttrsBuilder() {
            _classCallCheck$20(this, ComponentAttrsBuilder);

            this.buffer = [];
        }

        ComponentAttrsBuilder.prototype.static = function _static(name, value) {
            this.buffer.push([_wireFormat.Ops.StaticAttr, name, value, null]);
        };

        ComponentAttrsBuilder.prototype.dynamic = function dynamic(name, value) {
            this.buffer.push([_wireFormat.Ops.DynamicAttr, name, [_wireFormat.Ops.ClientSideExpression, Ops$2.FunctionExpression, value], null]);
        };

        return ComponentAttrsBuilder;
    }();

    var ComponentBuilder = function () {
        function ComponentBuilder(builder) {
            _classCallCheck$20(this, ComponentBuilder);

            this.builder = builder;
            this.env = builder.env;
        }

        ComponentBuilder.prototype.static = function _static(definition, args) {
            var params = args[0],
                hash = args[1],
                _default = args[2],
                inverse = args[3];
            var builder = this.builder;

            builder.pushComponentManager(definition);
            builder.invokeComponent(null, params, hash, _default, inverse);
        };

        ComponentBuilder.prototype.dynamic = function dynamic(definitionArgs, getDefinition, args) {
            var params = args[0],
                hash = args[1],
                block = args[2],
                inverse = args[3];
            var builder = this.builder;

            if (!definitionArgs || definitionArgs.length === 0) {
                throw new Error("Dynamic syntax without an argument");
            }
            var meta = this.builder.meta.templateMeta;
            function helper(vm, a) {
                return getDefinition(vm, a, meta);
            }
            builder.startLabels();
            builder.pushFrame();
            builder.returnTo('END');
            builder.compileArgs(definitionArgs[0], definitionArgs[1], true);
            builder.helper(helper);
            builder.dup();
            builder.test('simple');
            builder.enter(2);
            builder.jumpUnless('ELSE');
            builder.pushDynamicComponentManager();
            builder.invokeComponent(null, params, hash, block, inverse);
            builder.label('ELSE');
            builder.exit();
            builder.return();
            builder.label('END');
            builder.popFrame();
            builder.stopLabels();
        };

        return ComponentBuilder;
    }();
    function builder(env, meta) {
        return new OpcodeBuilder(env, meta);
    }

    function _classCallCheck$21(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var RawInlineBlock = function () {
        function RawInlineBlock(meta, statements, parameters) {
            _classCallCheck$21(this, RawInlineBlock);

            this.meta = meta;
            this.statements = statements;
            this.parameters = parameters;
        }

        RawInlineBlock.prototype.scan = function scan() {
            return new CompilableTemplate(this.statements, { parameters: this.parameters, meta: this.meta });
        };

        return RawInlineBlock;
    }();

    var _createClass$1 = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
            }
        }return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
        };
    }();

    function _defaults$9(obj, defaults) {
        var keys = Object.getOwnPropertyNames(defaults);for (var i = 0; i < keys.length; i++) {
            var key = keys[i];var value = Object.getOwnPropertyDescriptor(defaults, key);if (value && value.configurable && obj[key] === undefined) {
                Object.defineProperty(obj, key, value);
            }
        }return obj;
    }

    function _possibleConstructorReturn$9(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits$9(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults$9(subClass, superClass);
    }

    function _classCallCheck$19(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var Labels = function () {
        function Labels() {
            _classCallCheck$19(this, Labels);

            this.labels = (0, _util.dict)();
            this.targets = [];
        }

        Labels.prototype.label = function label(name, index) {
            this.labels[name] = index;
        };

        Labels.prototype.target = function target(at, Target, _target) {
            this.targets.push({ at: at, Target: Target, target: _target });
        };

        Labels.prototype.patch = function patch(program) {
            var targets = this.targets,
                labels = this.labels;

            for (var i = 0; i < targets.length; i++) {
                var _targets$i = targets[i],
                    at = _targets$i.at,
                    target = _targets$i.target;

                var goto = labels[target] - at;
                program.heap.setbyaddr(at + 1, goto);
            }
        };

        return Labels;
    }();

    var BasicOpcodeBuilder = function () {
        function BasicOpcodeBuilder(env, meta, program) {
            _classCallCheck$19(this, BasicOpcodeBuilder);

            this.env = env;
            this.meta = meta;
            this.program = program;
            this.labelsStack = new _util.Stack();
            this.constants = program.constants;
            this.heap = program.heap;
            this.start = this.heap.malloc();
        }

        BasicOpcodeBuilder.prototype.upvars = function upvars(count) {
            return (0, _util.fillNulls)(count);
        };

        BasicOpcodeBuilder.prototype.reserve = function reserve(name) {
            this.push(name, 0, 0, 0);
        };

        BasicOpcodeBuilder.prototype.push = function push(name) {
            var op1 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
            var op2 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
            var op3 = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;

            this.heap.push(name);
            this.heap.push(op1);
            this.heap.push(op2);
            this.heap.push(op3);
        };

        BasicOpcodeBuilder.prototype.finalize = function finalize() {
            this.push(22 /* Return */);
            this.heap.finishMalloc(this.start);
            return this.start;
        };
        // args


        BasicOpcodeBuilder.prototype.pushArgs = function pushArgs(synthetic) {
            this.push(58 /* PushArgs */, synthetic === true ? 1 : 0);
        };
        // helpers


        BasicOpcodeBuilder.prototype.startLabels = function startLabels() {
            this.labelsStack.push(new Labels());
        };

        BasicOpcodeBuilder.prototype.stopLabels = function stopLabels() {
            var label = this.labelsStack.pop();
            label.patch(this.program);
        };
        // components


        BasicOpcodeBuilder.prototype.pushComponentManager = function pushComponentManager(definition) {
            this.push(56 /* PushComponentManager */, this.other(definition));
        };

        BasicOpcodeBuilder.prototype.pushDynamicComponentManager = function pushDynamicComponentManager() {
            this.push(57 /* PushDynamicComponentManager */);
        };

        BasicOpcodeBuilder.prototype.prepareArgs = function prepareArgs(state) {
            this.push(59 /* PrepareArgs */, state);
        };

        BasicOpcodeBuilder.prototype.createComponent = function createComponent(state, hasDefault, hasInverse) {
            var flag = (hasDefault === true ? 1 : 0) | (hasInverse === true ? 1 : 0) << 1;
            this.push(60 /* CreateComponent */, flag, state);
        };

        BasicOpcodeBuilder.prototype.registerComponentDestructor = function registerComponentDestructor(state) {
            this.push(61 /* RegisterComponentDestructor */, state);
        };

        BasicOpcodeBuilder.prototype.beginComponentTransaction = function beginComponentTransaction() {
            this.push(65 /* BeginComponentTransaction */);
        };

        BasicOpcodeBuilder.prototype.commitComponentTransaction = function commitComponentTransaction() {
            this.push(66 /* CommitComponentTransaction */);
        };

        BasicOpcodeBuilder.prototype.pushComponentOperations = function pushComponentOperations() {
            this.push(62 /* PushComponentOperations */);
        };

        BasicOpcodeBuilder.prototype.getComponentSelf = function getComponentSelf(state) {
            this.push(63 /* GetComponentSelf */, state);
        };

        BasicOpcodeBuilder.prototype.getComponentLayout = function getComponentLayout(state) {
            this.push(64 /* GetComponentLayout */, state);
        };

        BasicOpcodeBuilder.prototype.didCreateElement = function didCreateElement(state) {
            this.push(67 /* DidCreateElement */, state);
        };

        BasicOpcodeBuilder.prototype.didRenderLayout = function didRenderLayout(state) {
            this.push(68 /* DidRenderLayout */, state);
        };
        // partial


        BasicOpcodeBuilder.prototype.getPartialTemplate = function getPartialTemplate() {
            this.push(69 /* GetPartialTemplate */);
        };

        BasicOpcodeBuilder.prototype.resolveMaybeLocal = function resolveMaybeLocal(name) {
            this.push(70 /* ResolveMaybeLocal */, this.string(name));
        };
        // debugger


        BasicOpcodeBuilder.prototype.debugger = function _debugger(symbols, evalInfo) {
            this.push(71 /* Debugger */, this.constants.other(symbols), this.constants.array(evalInfo));
        };
        // content


        BasicOpcodeBuilder.prototype.dynamicContent = function dynamicContent(Opcode) {
            this.push(26 /* DynamicContent */, this.other(Opcode));
        };

        BasicOpcodeBuilder.prototype.cautiousAppend = function cautiousAppend() {
            this.dynamicContent(new OptimizedCautiousAppendOpcode());
        };

        BasicOpcodeBuilder.prototype.trustingAppend = function trustingAppend() {
            this.dynamicContent(new OptimizedTrustingAppendOpcode());
        };
        // dom


        BasicOpcodeBuilder.prototype.text = function text(_text) {
            this.push(24 /* Text */, this.constants.string(_text));
        };

        BasicOpcodeBuilder.prototype.openPrimitiveElement = function openPrimitiveElement(tag) {
            this.push(27 /* OpenElement */, this.constants.string(tag));
        };

        BasicOpcodeBuilder.prototype.openElementWithOperations = function openElementWithOperations(tag) {
            this.push(28 /* OpenElementWithOperations */, this.constants.string(tag));
        };

        BasicOpcodeBuilder.prototype.openDynamicElement = function openDynamicElement() {
            this.push(29 /* OpenDynamicElement */);
        };

        BasicOpcodeBuilder.prototype.flushElement = function flushElement() {
            this.push(33 /* FlushElement */);
        };

        BasicOpcodeBuilder.prototype.closeElement = function closeElement() {
            this.push(34 /* CloseElement */);
        };

        BasicOpcodeBuilder.prototype.staticAttr = function staticAttr(_name, _namespace, _value) {
            var name = this.constants.string(_name);
            var namespace = _namespace ? this.constants.string(_namespace) : 0;
            var value = this.constants.string(_value);
            this.push(30 /* StaticAttr */, name, value, namespace);
        };

        BasicOpcodeBuilder.prototype.dynamicAttrNS = function dynamicAttrNS(_name, _namespace, trusting) {
            var name = this.constants.string(_name);
            var namespace = this.constants.string(_namespace);
            this.push(32 /* DynamicAttrNS */, name, namespace, trusting === true ? 1 : 0);
        };

        BasicOpcodeBuilder.prototype.dynamicAttr = function dynamicAttr(_name, trusting) {
            var name = this.constants.string(_name);
            this.push(31 /* DynamicAttr */, name, trusting === true ? 1 : 0);
        };

        BasicOpcodeBuilder.prototype.comment = function comment(_comment) {
            var comment = this.constants.string(_comment);
            this.push(25 /* Comment */, comment);
        };

        BasicOpcodeBuilder.prototype.modifier = function modifier(_definition) {
            this.push(35 /* Modifier */, this.other(_definition));
        };
        // lists


        BasicOpcodeBuilder.prototype.putIterator = function putIterator() {
            this.push(54 /* PutIterator */);
        };

        BasicOpcodeBuilder.prototype.enterList = function enterList(start) {
            this.reserve(52 /* EnterList */);
            this.labels.target(this.pos, 52 /* EnterList */, start);
        };

        BasicOpcodeBuilder.prototype.exitList = function exitList() {
            this.push(53 /* ExitList */);
        };

        BasicOpcodeBuilder.prototype.iterate = function iterate(breaks) {
            this.reserve(55 /* Iterate */);
            this.labels.target(this.pos, 55 /* Iterate */, breaks);
        };
        // expressions


        BasicOpcodeBuilder.prototype.setVariable = function setVariable(symbol) {
            this.push(4 /* SetVariable */, symbol);
        };

        BasicOpcodeBuilder.prototype.getVariable = function getVariable(symbol) {
            this.push(5 /* GetVariable */, symbol);
        };

        BasicOpcodeBuilder.prototype.getProperty = function getProperty(key) {
            this.push(6 /* GetProperty */, this.string(key));
        };

        BasicOpcodeBuilder.prototype.getBlock = function getBlock(symbol) {
            this.push(8 /* GetBlock */, symbol);
        };

        BasicOpcodeBuilder.prototype.hasBlock = function hasBlock(symbol) {
            this.push(9 /* HasBlock */, symbol);
        };

        BasicOpcodeBuilder.prototype.hasBlockParams = function hasBlockParams(symbol) {
            this.push(10 /* HasBlockParams */, symbol);
        };

        BasicOpcodeBuilder.prototype.concat = function concat(size) {
            this.push(11 /* Concat */, size);
        };

        BasicOpcodeBuilder.prototype.function = function _function(f) {
            this.push(2 /* Function */, this.func(f));
        };

        BasicOpcodeBuilder.prototype.load = function load(register) {
            this.push(17 /* Load */, register);
        };

        BasicOpcodeBuilder.prototype.fetch = function fetch(register) {
            this.push(18 /* Fetch */, register);
        };

        BasicOpcodeBuilder.prototype.dup = function dup() {
            var register = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : Register.sp;
            var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

            return this.push(15 /* Dup */, register, offset);
        };

        BasicOpcodeBuilder.prototype.pop = function pop() {
            var count = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;

            return this.push(16 /* Pop */, count);
        };
        // vm


        BasicOpcodeBuilder.prototype.pushRemoteElement = function pushRemoteElement() {
            this.push(36 /* PushRemoteElement */);
        };

        BasicOpcodeBuilder.prototype.popRemoteElement = function popRemoteElement() {
            this.push(37 /* PopRemoteElement */);
        };

        BasicOpcodeBuilder.prototype.label = function label(name) {
            this.labels.label(name, this.nextPos);
        };

        BasicOpcodeBuilder.prototype.pushRootScope = function pushRootScope(symbols, bindCallerScope) {
            this.push(19 /* RootScope */, symbols, bindCallerScope ? 1 : 0);
        };

        BasicOpcodeBuilder.prototype.pushChildScope = function pushChildScope() {
            this.push(20 /* ChildScope */);
        };

        BasicOpcodeBuilder.prototype.popScope = function popScope() {
            this.push(21 /* PopScope */);
        };

        BasicOpcodeBuilder.prototype.returnTo = function returnTo(label) {
            this.reserve(23 /* ReturnTo */);
            this.labels.target(this.pos, 23 /* ReturnTo */, label);
        };

        BasicOpcodeBuilder.prototype.pushDynamicScope = function pushDynamicScope() {
            this.push(39 /* PushDynamicScope */);
        };

        BasicOpcodeBuilder.prototype.popDynamicScope = function popDynamicScope() {
            this.push(40 /* PopDynamicScope */);
        };

        BasicOpcodeBuilder.prototype.pushImmediate = function pushImmediate(value) {
            this.push(13 /* Constant */, this.other(value));
        };

        BasicOpcodeBuilder.prototype.primitive = function primitive(_primitive) {
            var flag = 0;
            var primitive = void 0;
            switch (typeof _primitive) {
                case 'number':
                    if (_primitive % 1 === 0 && _primitive > 0) {
                        primitive = _primitive;
                    } else {
                        primitive = this.float(_primitive);
                        flag = 1;
                    }
                    break;
                case 'string':
                    primitive = this.string(_primitive);
                    flag = 2;
                    break;
                case 'boolean':
                    primitive = _primitive | 0;
                    flag = 3;
                    break;
                case 'object':
                    // assume null
                    primitive = 2;
                    flag = 3;
                    break;
                case 'undefined':
                    primitive = 3;
                    flag = 3;
                    break;
                default:
                    throw new Error('Invalid primitive passed to pushPrimitive');
            }
            this.push(14 /* PrimitiveReference */, flag << 30 | primitive);
        };

        BasicOpcodeBuilder.prototype.helper = function helper(func) {
            this.push(1 /* Helper */, this.func(func));
        };

        BasicOpcodeBuilder.prototype.pushBlock = function pushBlock(block) {
            this.push(7 /* PushBlock */, this.block(block));
        };

        BasicOpcodeBuilder.prototype.bindDynamicScope = function bindDynamicScope(_names) {
            this.push(38 /* BindDynamicScope */, this.names(_names));
        };

        BasicOpcodeBuilder.prototype.enter = function enter(args) {
            this.push(49 /* Enter */, args);
        };

        BasicOpcodeBuilder.prototype.exit = function exit() {
            this.push(50 /* Exit */);
        };

        BasicOpcodeBuilder.prototype.return = function _return() {
            this.push(22 /* Return */);
        };

        BasicOpcodeBuilder.prototype.pushFrame = function pushFrame() {
            this.push(47 /* PushFrame */);
        };

        BasicOpcodeBuilder.prototype.popFrame = function popFrame() {
            this.push(48 /* PopFrame */);
        };

        BasicOpcodeBuilder.prototype.compileDynamicBlock = function compileDynamicBlock() {
            this.push(41 /* CompileDynamicBlock */);
        };

        BasicOpcodeBuilder.prototype.invokeDynamic = function invokeDynamic(invoker) {
            this.push(43 /* InvokeDynamic */, this.other(invoker));
        };

        BasicOpcodeBuilder.prototype.invokeStatic = function invokeStatic(block) {
            var callerCount = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
            var parameters = block.symbolTable.parameters;

            var calleeCount = parameters.length;
            var count = Math.min(callerCount, calleeCount);
            this.pushFrame();
            if (count) {
                this.pushChildScope();
                for (var i = 0; i < count; i++) {
                    this.dup(Register.fp, callerCount - i);
                    this.setVariable(parameters[i]);
                }
            }
            var _block = this.constants.block(block);
            this.push(42 /* InvokeStatic */, _block);
            if (count) {
                this.popScope();
            }
            this.popFrame();
        };

        BasicOpcodeBuilder.prototype.test = function test(testFunc) {
            var _func = void 0;
            if (testFunc === 'const') {
                _func = ConstTest;
            } else if (testFunc === 'simple') {
                _func = SimpleTest;
            } else if (testFunc === 'environment') {
                _func = EnvironmentTest;
            } else if (typeof testFunc === 'function') {
                _func = testFunc;
            } else {
                throw new Error('unreachable');
            }
            var func = this.constants.function(_func);
            this.push(51 /* Test */, func);
        };

        BasicOpcodeBuilder.prototype.jump = function jump(target) {
            this.reserve(44 /* Jump */);
            this.labels.target(this.pos, 44 /* Jump */, target);
        };

        BasicOpcodeBuilder.prototype.jumpIf = function jumpIf(target) {
            this.reserve(45 /* JumpIf */);
            this.labels.target(this.pos, 45 /* JumpIf */, target);
        };

        BasicOpcodeBuilder.prototype.jumpUnless = function jumpUnless(target) {
            this.reserve(46 /* JumpUnless */);
            this.labels.target(this.pos, 46 /* JumpUnless */, target);
        };

        BasicOpcodeBuilder.prototype.string = function string(_string) {
            return this.constants.string(_string);
        };

        BasicOpcodeBuilder.prototype.float = function float(num) {
            return this.constants.float(num);
        };

        BasicOpcodeBuilder.prototype.names = function names(_names) {
            var names = [];
            for (var i = 0; i < _names.length; i++) {
                var n = _names[i];
                names[i] = this.constants.string(n);
            }
            return this.constants.array(names);
        };

        BasicOpcodeBuilder.prototype.symbols = function symbols(_symbols) {
            return this.constants.array(_symbols);
        };

        BasicOpcodeBuilder.prototype.other = function other(value) {
            return this.constants.other(value);
        };

        BasicOpcodeBuilder.prototype.block = function block(_block2) {
            return _block2 ? this.constants.block(_block2) : 0;
        };

        BasicOpcodeBuilder.prototype.func = function func(_func2) {
            return this.constants.function(_func2);
        };

        _createClass$1(BasicOpcodeBuilder, [{
            key: 'pos',
            get: function () {
                return (0, _util.typePos)(this.heap.size());
            }
        }, {
            key: 'nextPos',
            get: function () {
                return this.heap.size();
            }
        }, {
            key: 'labels',
            get: function () {
                return this.labelsStack.current;
            }
        }]);

        return BasicOpcodeBuilder;
    }();

    function isCompilableExpression(expr$$1) {
        return typeof expr$$1 === 'object' && expr$$1 !== null && typeof expr$$1.compile === 'function';
    }

    var OpcodeBuilder = function (_BasicOpcodeBuilder) {
        _inherits$9(OpcodeBuilder, _BasicOpcodeBuilder);

        function OpcodeBuilder(env, meta) {
            var program = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : env.program;

            _classCallCheck$19(this, OpcodeBuilder);

            var _this = _possibleConstructorReturn$9(this, _BasicOpcodeBuilder.call(this, env, meta, program));

            _this.component = new ComponentBuilder(_this);
            return _this;
        }

        OpcodeBuilder.prototype.compileArgs = function compileArgs(params, hash, synthetic) {
            var positional = 0;
            if (params) {
                for (var i = 0; i < params.length; i++) {
                    expr(params[i], this);
                }
                positional = params.length;
            }
            this.pushImmediate(positional);
            var names = _util.EMPTY_ARRAY;
            if (hash) {
                names = hash[0];
                var val = hash[1];
                for (var _i = 0; _i < val.length; _i++) {
                    expr(val[_i], this);
                }
            }
            this.pushImmediate(names);
            this.pushArgs(synthetic);
        };

        OpcodeBuilder.prototype.compile = function compile(expr$$1) {
            if (isCompilableExpression(expr$$1)) {
                return expr$$1.compile(this);
            } else {
                return expr$$1;
            }
        };

        OpcodeBuilder.prototype.guardedAppend = function guardedAppend(expression, trusting) {
            this.startLabels();
            this.pushFrame();
            this.returnTo('END');
            expr(expression, this);
            this.dup();
            this.test(function (reference) {
                return IsComponentDefinitionReference.create(reference);
            });
            this.enter(2);
            this.jumpUnless('ELSE');
            this.pushDynamicComponentManager();
            this.invokeComponent(null, null, null, null, null);
            this.exit();
            this.return();
            this.label('ELSE');
            if (trusting) {
                this.trustingAppend();
            } else {
                this.cautiousAppend();
            }
            this.exit();
            this.return();
            this.label('END');
            this.popFrame();
            this.stopLabels();
        };

        OpcodeBuilder.prototype.invokeComponent = function invokeComponent(attrs, params, hash, block) {
            var inverse = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;

            this.fetch(Register.s0);
            this.dup(Register.sp, 1);
            this.load(Register.s0);
            this.pushBlock(block);
            this.pushBlock(inverse);
            this.compileArgs(params, hash, false);
            this.prepareArgs(Register.s0);
            this.beginComponentTransaction();
            this.pushDynamicScope();
            this.createComponent(Register.s0, block !== null, inverse !== null);
            this.registerComponentDestructor(Register.s0);
            this.getComponentSelf(Register.s0);
            this.getComponentLayout(Register.s0);
            this.invokeDynamic(new InvokeDynamicLayout(attrs && attrs.scan()));
            this.popFrame();
            this.popScope();
            this.popDynamicScope();
            this.commitComponentTransaction();
            this.load(Register.s0);
        };

        OpcodeBuilder.prototype.template = function template(block) {
            if (!block) return null;
            return new RawInlineBlock(this.meta, block.statements, block.parameters);
        };

        return OpcodeBuilder;
    }(BasicOpcodeBuilder);

    function _classCallCheck$18(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var Ops$3 = _wireFormat.Ops;
    var ATTRS_BLOCK = '&attrs';

    var Compilers = function () {
        function Compilers() {
            var offset = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;

            _classCallCheck$18(this, Compilers);

            this.offset = offset;
            this.names = (0, _util.dict)();
            this.funcs = [];
        }

        Compilers.prototype.add = function add(name, func) {
            this.funcs.push(func);
            this.names[name] = this.funcs.length - 1;
        };

        Compilers.prototype.compile = function compile(sexp, builder) {
            var name = sexp[this.offset];
            var index = this.names[name];
            var func = this.funcs[index];
            (0, _util.assert)(!!func, 'expected an implementation for ' + (this.offset === 0 ? Ops$3[sexp[0]] : Ops$2[sexp[1]]));
            func(sexp, builder);
        };

        return Compilers;
    }();

    var STATEMENTS = new Compilers();
    var CLIENT_SIDE = new Compilers(1);
    STATEMENTS.add(Ops$3.Text, function (sexp, builder) {
        builder.text(sexp[1]);
    });
    STATEMENTS.add(Ops$3.Comment, function (sexp, builder) {
        builder.comment(sexp[1]);
    });
    STATEMENTS.add(Ops$3.CloseElement, function (_sexp, builder) {
        builder.closeElement();
    });
    STATEMENTS.add(Ops$3.FlushElement, function (_sexp, builder) {
        builder.flushElement();
    });
    STATEMENTS.add(Ops$3.Modifier, function (sexp, builder) {
        var env = builder.env,
            meta = builder.meta;
        var name = sexp[1],
            params = sexp[2],
            hash = sexp[3];

        if (env.hasModifier(name, meta.templateMeta)) {
            builder.compileArgs(params, hash, true);
            builder.modifier(env.lookupModifier(name, meta.templateMeta));
        } else {
            throw new Error('Compile Error ' + name + ' is not a modifier: Helpers may not be used in the element form.');
        }
    });
    STATEMENTS.add(Ops$3.StaticAttr, function (sexp, builder) {
        var name = sexp[1],
            value = sexp[2],
            namespace = sexp[3];

        builder.staticAttr(name, namespace, value);
    });
    STATEMENTS.add(Ops$3.DynamicAttr, function (sexp, builder) {
        dynamicAttr(sexp, false, builder);
    });
    STATEMENTS.add(Ops$3.TrustingAttr, function (sexp, builder) {
        dynamicAttr(sexp, true, builder);
    });
    function dynamicAttr(sexp, trusting, builder) {
        var name = sexp[1],
            value = sexp[2],
            namespace = sexp[3];

        expr(value, builder);
        if (namespace) {
            builder.dynamicAttrNS(name, namespace, trusting);
        } else {
            builder.dynamicAttr(name, trusting);
        }
    }
    STATEMENTS.add(Ops$3.OpenElement, function (sexp, builder) {
        builder.openPrimitiveElement(sexp[1]);
    });
    CLIENT_SIDE.add(Ops$2.OpenComponentElement, function (sexp, builder) {
        builder.pushComponentOperations();
        builder.openElementWithOperations(sexp[2]);
    });
    CLIENT_SIDE.add(Ops$2.DidCreateElement, function (_sexp, builder) {
        builder.didCreateElement(Register.s0);
    });
    CLIENT_SIDE.add(Ops$2.DidRenderLayout, function (_sexp, builder) {
        builder.didRenderLayout(Register.s0);
    });
    STATEMENTS.add(Ops$3.Append, function (sexp, builder) {
        var value = sexp[1],
            trusting = sexp[2];

        var _builder$env$macros = builder.env.macros(),
            inlines = _builder$env$macros.inlines;

        var returned = inlines.compile(sexp, builder) || value;
        if (returned === true) return;
        var isGet = E.isGet(value);
        var isMaybeLocal = E.isMaybeLocal(value);
        if (trusting) {
            builder.guardedAppend(value, true);
        } else {
            if (isGet || isMaybeLocal) {
                builder.guardedAppend(value, false);
            } else {
                expr(value, builder);
                builder.cautiousAppend();
            }
        }
    });
    STATEMENTS.add(Ops$3.Block, function (sexp, builder) {
        var name = sexp[1],
            params = sexp[2],
            hash = sexp[3],
            _template = sexp[4],
            _inverse = sexp[5];

        var template = builder.template(_template);
        var inverse = builder.template(_inverse);
        var templateBlock = template && template.scan();
        var inverseBlock = inverse && inverse.scan();

        var _builder$env$macros2 = builder.env.macros(),
            blocks = _builder$env$macros2.blocks;

        blocks.compile(name, params, hash, templateBlock, inverseBlock, builder);
    });
    var InvokeDynamicLayout = function () {
        function InvokeDynamicLayout(attrs) {
            _classCallCheck$18(this, InvokeDynamicLayout);

            this.attrs = attrs;
        }

        InvokeDynamicLayout.prototype.invoke = function invoke(vm, layout) {
            var _layout$symbolTable = layout.symbolTable,
                symbols = _layout$symbolTable.symbols,
                hasEval = _layout$symbolTable.hasEval;

            var stack = vm.stack;
            var scope = vm.pushRootScope(symbols.length + 1, true);
            scope.bindSelf(stack.pop());
            scope.bindBlock(symbols.indexOf(ATTRS_BLOCK) + 1, this.attrs);
            var lookup = null;
            var $eval = -1;
            if (hasEval) {
                $eval = symbols.indexOf('$eval') + 1;
                lookup = (0, _util.dict)();
            }
            var callerNames = stack.pop();
            for (var i = callerNames.length - 1; i >= 0; i--) {
                var symbol = symbols.indexOf(callerNames[i]);
                var value = stack.pop();
                if (symbol !== -1) scope.bindSymbol(symbol + 1, value);
                if (hasEval) lookup[callerNames[i]] = value;
            }
            var numPositionalArgs = stack.pop();
            (0, _util.assert)(typeof numPositionalArgs === 'number', '[BUG] Incorrect value of positional argument count found during invoke-dynamic-layout.');
            // Currently we don't support accessing positional args in templates, so just throw them away
            stack.pop(numPositionalArgs);
            var inverseSymbol = symbols.indexOf('&inverse');
            var inverse = stack.pop();
            if (inverseSymbol !== -1) {
                scope.bindBlock(inverseSymbol + 1, inverse);
            }
            if (lookup) lookup['&inverse'] = inverse;
            var defaultSymbol = symbols.indexOf('&default');
            var defaultBlock = stack.pop();
            if (defaultSymbol !== -1) {
                scope.bindBlock(defaultSymbol + 1, defaultBlock);
            }
            if (lookup) lookup['&default'] = defaultBlock;
            if (lookup) scope.bindEvalScope(lookup);
            vm.pushFrame();
            vm.call(layout.handle);
        };

        InvokeDynamicLayout.prototype.toJSON = function toJSON() {
            return { GlimmerDebug: '<invoke-dynamic-layout>' };
        };

        return InvokeDynamicLayout;
    }();
    STATEMENTS.add(Ops$3.Component, function (sexp, builder) {
        var tag = sexp[1],
            attrs = sexp[2],
            args = sexp[3],
            block = sexp[4];

        if (builder.env.hasComponentDefinition(tag, builder.meta.templateMeta)) {
            var child = builder.template(block);
            var attrsBlock = new RawInlineBlock(builder.meta, attrs, _util.EMPTY_ARRAY);
            var definition = builder.env.getComponentDefinition(tag, builder.meta.templateMeta);
            builder.pushComponentManager(definition);
            builder.invokeComponent(attrsBlock, null, args, child && child.scan());
        } else if (block && block.parameters.length) {
            throw new Error('Compile Error: Cannot find component ' + tag);
        } else {
            builder.openPrimitiveElement(tag);
            for (var i = 0; i < attrs.length; i++) {
                STATEMENTS.compile(attrs[i], builder);
            }
            builder.flushElement();
            if (block) {
                var stmts = block.statements;
                for (var _i = 0; _i < stmts.length; _i++) {
                    STATEMENTS.compile(stmts[_i], builder);
                }
            }
            builder.closeElement();
        }
    });
    var PartialInvoker = function () {
        function PartialInvoker(outerSymbols, evalInfo) {
            _classCallCheck$18(this, PartialInvoker);

            this.outerSymbols = outerSymbols;
            this.evalInfo = evalInfo;
        }

        PartialInvoker.prototype.invoke = function invoke(vm, _partial) {
            var partial = _partial;
            var partialSymbols = partial.symbolTable.symbols;
            var outerScope = vm.scope();
            var evalScope = outerScope.getEvalScope();
            var partialScope = vm.pushRootScope(partialSymbols.length, false);
            partialScope.bindCallerScope(outerScope.getCallerScope());
            partialScope.bindEvalScope(evalScope);
            partialScope.bindSelf(outerScope.getSelf());
            var evalInfo = this.evalInfo,
                outerSymbols = this.outerSymbols;

            var locals = Object.create(outerScope.getPartialMap());
            for (var i = 0; i < evalInfo.length; i++) {
                var slot = evalInfo[i];
                var name = outerSymbols[slot - 1];
                var ref = outerScope.getSymbol(slot);
                locals[name] = ref;
            }
            if (evalScope) {
                for (var _i2 = 0; _i2 < partialSymbols.length; _i2++) {
                    var _name = partialSymbols[_i2];
                    var symbol = _i2 + 1;
                    var value = evalScope[_name];
                    if (value !== undefined) partialScope.bind(symbol, value);
                }
            }
            partialScope.bindPartialMap(locals);
            vm.pushFrame();
            vm.call(partial.handle);
        };

        return PartialInvoker;
    }();
    STATEMENTS.add(Ops$3.Partial, function (sexp, builder) {
        var name = sexp[1],
            evalInfo = sexp[2];
        var _builder$meta = builder.meta,
            templateMeta = _builder$meta.templateMeta,
            symbols = _builder$meta.symbols;

        function helper(vm, args) {
            var env = vm.env;

            var nameRef = args.positional.at(0);
            return (0, _reference2.map)(nameRef, function (n) {
                if (typeof n === 'string' && n) {
                    if (!env.hasPartial(n, templateMeta)) {
                        throw new Error('Could not find a partial named "' + n + '"');
                    }
                    return env.lookupPartial(n, templateMeta);
                } else if (n) {
                    throw new Error('Could not find a partial named "' + String(n) + '"');
                } else {
                    return null;
                }
            });
        }
        builder.startLabels();
        builder.pushFrame();
        builder.returnTo('END');
        expr(name, builder);
        builder.pushImmediate(1);
        builder.pushImmediate(_util.EMPTY_ARRAY);
        builder.pushArgs(true);
        builder.helper(helper);
        builder.dup();
        builder.test('simple');
        builder.enter(2);
        builder.jumpUnless('ELSE');
        builder.getPartialTemplate();
        builder.compileDynamicBlock();
        builder.invokeDynamic(new PartialInvoker(symbols, evalInfo));
        builder.popScope();
        builder.popFrame();
        builder.label('ELSE');
        builder.exit();
        builder.return();
        builder.label('END');
        builder.popFrame();
        builder.stopLabels();
    });

    var InvokeDynamicYield = function () {
        function InvokeDynamicYield(callerCount) {
            _classCallCheck$18(this, InvokeDynamicYield);

            this.callerCount = callerCount;
        }

        InvokeDynamicYield.prototype.invoke = function invoke(vm, block) {
            var callerCount = this.callerCount;

            var stack = vm.stack;
            if (!block) {
                // To balance the pop{Frame,Scope}
                vm.pushFrame();
                vm.pushCallerScope();
                return;
            }
            var table = block.symbolTable;
            var locals = table.parameters; // always present in inline blocks
            var calleeCount = locals ? locals.length : 0;
            var count = Math.min(callerCount, calleeCount);
            vm.pushFrame();
            vm.pushCallerScope(calleeCount > 0);
            var scope = vm.scope();
            for (var i = 0; i < count; i++) {
                scope.bindSymbol(locals[i], stack.fromBase(callerCount - i));
            }
            vm.call(block.handle);
        };

        InvokeDynamicYield.prototype.toJSON = function toJSON() {
            return { GlimmerDebug: '<invoke-dynamic-yield caller-count=' + this.callerCount + '>' };
        };

        return InvokeDynamicYield;
    }();

    STATEMENTS.add(Ops$3.Yield, function (sexp, builder) {
        var to = sexp[1],
            params = sexp[2];

        var count = compileList(params, builder);
        builder.getBlock(to);
        builder.compileDynamicBlock();
        builder.invokeDynamic(new InvokeDynamicYield(count));
        builder.popScope();
        builder.popFrame();
        if (count) {
            builder.pop(count);
        }
    });
    STATEMENTS.add(Ops$3.Debugger, function (sexp, builder) {
        var evalInfo = sexp[1];

        builder.debugger(builder.meta.symbols, evalInfo);
    });
    STATEMENTS.add(Ops$3.ClientSideStatement, function (sexp, builder) {
        CLIENT_SIDE.compile(sexp, builder);
    });
    var EXPRESSIONS = new Compilers();
    var CLIENT_SIDE_EXPRS = new Compilers(1);
    var E = _wireFormat.Expressions;
    function expr(expression, builder) {
        if (Array.isArray(expression)) {
            EXPRESSIONS.compile(expression, builder);
        } else {
            builder.primitive(expression);
        }
    }
    EXPRESSIONS.add(Ops$3.Unknown, function (sexp, builder) {
        var name = sexp[1];
        if (builder.env.hasHelper(name, builder.meta.templateMeta)) {
            EXPRESSIONS.compile([Ops$3.Helper, name, _util.EMPTY_ARRAY, null], builder);
        } else if (builder.meta.asPartial) {
            builder.resolveMaybeLocal(name);
        } else {
            builder.getVariable(0);
            builder.getProperty(name);
        }
    });
    EXPRESSIONS.add(Ops$3.Concat, function (sexp, builder) {
        var parts = sexp[1];
        for (var i = 0; i < parts.length; i++) {
            expr(parts[i], builder);
        }
        builder.concat(parts.length);
    });
    CLIENT_SIDE_EXPRS.add(Ops$2.FunctionExpression, function (sexp, builder) {
        builder.function(sexp[2]);
    });
    EXPRESSIONS.add(Ops$3.Helper, function (sexp, builder) {
        var env = builder.env,
            meta = builder.meta;
        var name = sexp[1],
            params = sexp[2],
            hash = sexp[3];

        if (env.hasHelper(name, meta.templateMeta)) {
            builder.compileArgs(params, hash, true);
            builder.helper(env.lookupHelper(name, meta.templateMeta));
        } else {
            throw new Error('Compile Error: ' + name + ' is not a helper');
        }
    });
    EXPRESSIONS.add(Ops$3.Get, function (sexp, builder) {
        var head = sexp[1],
            path = sexp[2];

        builder.getVariable(head);
        for (var i = 0; i < path.length; i++) {
            builder.getProperty(path[i]);
        }
    });
    EXPRESSIONS.add(Ops$3.MaybeLocal, function (sexp, builder) {
        var path = sexp[1];

        if (builder.meta.asPartial) {
            var head = path[0];
            path = path.slice(1);
            builder.resolveMaybeLocal(head);
        } else {
            builder.getVariable(0);
        }
        for (var i = 0; i < path.length; i++) {
            builder.getProperty(path[i]);
        }
    });
    EXPRESSIONS.add(Ops$3.Undefined, function (_sexp, builder) {
        return builder.primitive(undefined);
    });
    EXPRESSIONS.add(Ops$3.HasBlock, function (sexp, builder) {
        builder.hasBlock(sexp[1]);
    });
    EXPRESSIONS.add(Ops$3.HasBlockParams, function (sexp, builder) {
        builder.hasBlockParams(sexp[1]);
    });
    EXPRESSIONS.add(Ops$3.ClientSideExpression, function (sexp, builder) {
        CLIENT_SIDE_EXPRS.compile(sexp, builder);
    });
    function compileList(params, builder) {
        if (!params) return 0;
        for (var i = 0; i < params.length; i++) {
            expr(params[i], builder);
        }
        return params.length;
    }
    var Blocks = function () {
        function Blocks() {
            _classCallCheck$18(this, Blocks);

            this.names = (0, _util.dict)();
            this.funcs = [];
        }

        Blocks.prototype.add = function add(name, func) {
            this.funcs.push(func);
            this.names[name] = this.funcs.length - 1;
        };

        Blocks.prototype.addMissing = function addMissing(func) {
            this.missing = func;
        };

        Blocks.prototype.compile = function compile(name, params, hash, template, inverse, builder) {
            var index = this.names[name];
            if (index === undefined) {
                (0, _util.assert)(!!this.missing, name + ' not found, and no catch-all block handler was registered');
                var func = this.missing;
                var handled = func(name, params, hash, template, inverse, builder);
                (0, _util.assert)(!!handled, name + ' not found, and the catch-all block handler didn\'t handle it');
            } else {
                var _func = this.funcs[index];
                _func(params, hash, template, inverse, builder);
            }
        };

        return Blocks;
    }();
    var BLOCKS = new Blocks();
    var Inlines = function () {
        function Inlines() {
            _classCallCheck$18(this, Inlines);

            this.names = (0, _util.dict)();
            this.funcs = [];
        }

        Inlines.prototype.add = function add(name, func) {
            this.funcs.push(func);
            this.names[name] = this.funcs.length - 1;
        };

        Inlines.prototype.addMissing = function addMissing(func) {
            this.missing = func;
        };

        Inlines.prototype.compile = function compile(sexp, builder) {
            var value = sexp[1];
            // TODO: Fix this so that expression macros can return
            // things like components, so that {{component foo}}
            // is the same as {{(component foo)}}
            if (!Array.isArray(value)) return ['expr', value];
            var name = void 0;
            var params = void 0;
            var hash = void 0;
            if (value[0] === Ops$3.Helper) {
                name = value[1];
                params = value[2];
                hash = value[3];
            } else if (value[0] === Ops$3.Unknown) {
                name = value[1];
                params = hash = null;
            } else {
                return ['expr', value];
            }
            var index = this.names[name];
            if (index === undefined && this.missing) {
                var func = this.missing;
                var returned = func(name, params, hash, builder);
                return returned === false ? ['expr', value] : returned;
            } else if (index !== undefined) {
                var _func2 = this.funcs[index];
                var _returned = _func2(name, params, hash, builder);
                return _returned === false ? ['expr', value] : _returned;
            } else {
                return ['expr', value];
            }
        };

        return Inlines;
    }();
    var INLINES = new Inlines();
    populateBuiltins(BLOCKS, INLINES);
    function populateBuiltins() {
        var blocks = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : new Blocks();
        var inlines = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : new Inlines();

        blocks.add('if', function (params, _hash, template, inverse, builder) {
            //        PutArgs
            //        Test(Environment)
            //        Enter(BEGIN, END)
            // BEGIN: Noop
            //        JumpUnless(ELSE)
            //        Evaluate(default)
            //        Jump(END)
            // ELSE:  Noop
            //        Evalulate(inverse)
            // END:   Noop
            //        Exit
            if (!params || params.length !== 1) {
                throw new Error('SYNTAX ERROR: #if requires a single argument');
            }
            builder.startLabels();
            builder.pushFrame();
            builder.returnTo('END');
            expr(params[0], builder);
            builder.test('environment');
            builder.enter(1);
            builder.jumpUnless('ELSE');
            builder.invokeStatic(template);
            if (inverse) {
                builder.jump('EXIT');
                builder.label('ELSE');
                builder.invokeStatic(inverse);
                builder.label('EXIT');
                builder.exit();
                builder.return();
            } else {
                builder.label('ELSE');
                builder.exit();
                builder.return();
            }
            builder.label('END');
            builder.popFrame();
            builder.stopLabels();
        });
        blocks.add('unless', function (params, _hash, template, inverse, builder) {
            //        PutArgs
            //        Test(Environment)
            //        Enter(BEGIN, END)
            // BEGIN: Noop
            //        JumpUnless(ELSE)
            //        Evaluate(default)
            //        Jump(END)
            // ELSE:  Noop
            //        Evalulate(inverse)
            // END:   Noop
            //        Exit
            if (!params || params.length !== 1) {
                throw new Error('SYNTAX ERROR: #unless requires a single argument');
            }
            builder.startLabels();
            builder.pushFrame();
            builder.returnTo('END');
            expr(params[0], builder);
            builder.test('environment');
            builder.enter(1);
            builder.jumpIf('ELSE');
            builder.invokeStatic(template);
            if (inverse) {
                builder.jump('EXIT');
                builder.label('ELSE');
                builder.invokeStatic(inverse);
                builder.label('EXIT');
                builder.exit();
                builder.return();
            } else {
                builder.label('ELSE');
                builder.exit();
                builder.return();
            }
            builder.label('END');
            builder.popFrame();
            builder.stopLabels();
        });
        blocks.add('with', function (params, _hash, template, inverse, builder) {
            //        PutArgs
            //        Test(Environment)
            //        Enter(BEGIN, END)
            // BEGIN: Noop
            //        JumpUnless(ELSE)
            //        Evaluate(default)
            //        Jump(END)
            // ELSE:  Noop
            //        Evalulate(inverse)
            // END:   Noop
            //        Exit
            if (!params || params.length !== 1) {
                throw new Error('SYNTAX ERROR: #with requires a single argument');
            }
            builder.startLabels();
            builder.pushFrame();
            builder.returnTo('END');
            expr(params[0], builder);
            builder.dup();
            builder.test('environment');
            builder.enter(2);
            builder.jumpUnless('ELSE');
            builder.invokeStatic(template, 1);
            if (inverse) {
                builder.jump('EXIT');
                builder.label('ELSE');
                builder.invokeStatic(inverse);
                builder.label('EXIT');
                builder.exit();
                builder.return();
            } else {
                builder.label('ELSE');
                builder.exit();
                builder.return();
            }
            builder.label('END');
            builder.popFrame();
            builder.stopLabels();
        });
        blocks.add('each', function (params, hash, template, inverse, builder) {
            //         Enter(BEGIN, END)
            // BEGIN:  Noop
            //         PutArgs
            //         PutIterable
            //         JumpUnless(ELSE)
            //         EnterList(BEGIN2, END2)
            // ITER:   Noop
            //         NextIter(BREAK)
            // BEGIN2: Noop
            //         PushChildScope
            //         Evaluate(default)
            //         PopScope
            // END2:   Noop
            //         Exit
            //         Jump(ITER)
            // BREAK:  Noop
            //         ExitList
            //         Jump(END)
            // ELSE:   Noop
            //         Evalulate(inverse)
            // END:    Noop
            //         Exit
            builder.startLabels();
            builder.pushFrame();
            builder.returnTo('END');
            if (hash && hash[0][0] === 'key') {
                expr(hash[1][0], builder);
            } else {
                builder.primitive(null);
            }
            expr(params[0], builder);
            builder.enter(2);
            builder.putIterator();
            builder.jumpUnless('ELSE');
            builder.pushFrame();
            builder.returnTo('ITER');
            builder.dup(Register.fp, 1);
            builder.enterList('BODY');
            builder.label('ITER');
            builder.iterate('BREAK');
            builder.label('BODY');
            builder.invokeStatic(template, 2);
            builder.pop(2);
            builder.exit();
            builder.return();
            builder.label('BREAK');
            builder.exitList();
            builder.popFrame();
            if (inverse) {
                builder.jump('EXIT');
                builder.label('ELSE');
                builder.invokeStatic(inverse);
                builder.label('EXIT');
                builder.exit();
                builder.return();
            } else {
                builder.label('ELSE');
                builder.exit();
                builder.return();
            }
            builder.label('END');
            builder.popFrame();
            builder.stopLabels();
        });
        blocks.add('-in-element', function (params, hash, template, _inverse, builder) {
            if (!params || params.length !== 1) {
                throw new Error('SYNTAX ERROR: #-in-element requires a single argument');
            }
            builder.startLabels();
            builder.pushFrame();
            builder.returnTo('END');
            if (hash && hash[0].length) {
                var keys = hash[0],
                    values = hash[1];

                if (keys.length === 1 && keys[0] === 'nextSibling') {
                    expr(values[0], builder);
                } else {
                    throw new Error('SYNTAX ERROR: #-in-element does not take a `' + keys[0] + '` option');
                }
            } else {
                expr(null, builder);
            }
            expr(params[0], builder);
            builder.dup();
            builder.test('simple');
            builder.enter(3);
            builder.jumpUnless('ELSE');
            builder.pushRemoteElement();
            builder.invokeStatic(template);
            builder.popRemoteElement();
            builder.label('ELSE');
            builder.exit();
            builder.return();
            builder.label('END');
            builder.popFrame();
            builder.stopLabels();
        });
        blocks.add('-with-dynamic-vars', function (_params, hash, template, _inverse, builder) {
            if (hash) {
                var names = hash[0],
                    expressions = hash[1];

                compileList(expressions, builder);
                builder.pushDynamicScope();
                builder.bindDynamicScope(names);
                builder.invokeStatic(template);
                builder.popDynamicScope();
            } else {
                builder.invokeStatic(template);
            }
        });
        return { blocks: blocks, inlines: inlines };
    }
    function compileStatement(statement, builder) {
        STATEMENTS.compile(statement, builder);
    }
    function compileStatements(statements, meta, env) {
        var b = new OpcodeBuilder(env, meta);
        for (var i = 0; i < statements.length; i++) {
            compileStatement(statements[i], b);
        }
        return b;
    }

    function _classCallCheck$16(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var CompilableTemplate = function () {
        function CompilableTemplate(statements, symbolTable) {
            _classCallCheck$16(this, CompilableTemplate);

            this.statements = statements;
            this.symbolTable = symbolTable;
            this.compiledStatic = null;
            this.compiledDynamic = null;
        }

        CompilableTemplate.prototype.compileStatic = function compileStatic(env) {
            var compiledStatic = this.compiledStatic;

            if (!compiledStatic) {
                var builder = compileStatements(this.statements, this.symbolTable.meta, env);
                builder.finalize();
                var handle = builder.start;
                compiledStatic = this.compiledStatic = new CompiledStaticTemplate(handle);
            }
            return compiledStatic;
        };

        CompilableTemplate.prototype.compileDynamic = function compileDynamic(env) {
            var compiledDynamic = this.compiledDynamic;

            if (!compiledDynamic) {
                var staticBlock = this.compileStatic(env);
                compiledDynamic = new CompiledDynamicTemplate(staticBlock.handle, this.symbolTable);
            }
            return compiledDynamic;
        };

        return CompilableTemplate;
    }();

    function _classCallCheck$15(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var Ops$1 = _wireFormat.Ops;

    var Scanner = function () {
        function Scanner(block, env) {
            _classCallCheck$15(this, Scanner);

            this.block = block;
            this.env = env;
        }

        Scanner.prototype.scanEntryPoint = function scanEntryPoint(meta) {
            var block = this.block;
            var statements = block.statements,
                symbols = block.symbols,
                hasEval = block.hasEval;

            return new CompilableTemplate(statements, { meta: meta, symbols: symbols, hasEval: hasEval });
        };

        Scanner.prototype.scanBlock = function scanBlock(meta) {
            var block = this.block;
            var statements = block.statements;

            return new CompilableTemplate(statements, { meta: meta, parameters: _util.EMPTY_ARRAY });
        };

        Scanner.prototype.scanLayout = function scanLayout(meta, attrs, componentName) {
            var block = this.block;
            var statements = block.statements,
                symbols = block.symbols,
                hasEval = block.hasEval;

            var symbolTable = { meta: meta, hasEval: hasEval, symbols: symbols };
            var newStatements = [];
            var toplevel = void 0;
            var inTopLevel = false;
            for (var i = 0; i < statements.length; i++) {
                var statement = statements[i];
                if (_wireFormat.Statements.isComponent(statement)) {
                    var tagName = statement[1];
                    if (!this.env.hasComponentDefinition(tagName, meta.templateMeta)) {
                        if (toplevel !== undefined) {
                            newStatements.push([Ops$1.OpenElement, tagName]);
                        } else {
                            toplevel = tagName;
                            decorateTopLevelElement(tagName, symbols, attrs, newStatements);
                        }
                        addFallback(statement, newStatements);
                    } else {
                        if (toplevel === undefined && tagName === componentName) {
                            toplevel = tagName;
                            decorateTopLevelElement(tagName, symbols, attrs, newStatements);
                            addFallback(statement, newStatements);
                        } else {
                            newStatements.push(statement);
                        }
                    }
                } else {
                    if (toplevel === undefined && _wireFormat.Statements.isOpenElement(statement)) {
                        toplevel = statement[1];
                        inTopLevel = true;
                        decorateTopLevelElement(toplevel, symbols, attrs, newStatements);
                    } else {
                        if (inTopLevel) {
                            if (_wireFormat.Statements.isFlushElement(statement)) {
                                inTopLevel = false;
                            } else if (_wireFormat.Statements.isModifier(statement)) {
                                throw Error('Found modifier "' + statement[1] + '" on the top-level element of "' + componentName + '". Modifiers cannot be on the top-level element');
                            }
                        }
                        newStatements.push(statement);
                    }
                }
            }
            newStatements.push([Ops$1.ClientSideStatement, Ops$2.DidRenderLayout]);
            return new CompilableTemplate(newStatements, symbolTable);
        };

        return Scanner;
    }();

    function addFallback(statement, buffer) {
        var attrs = statement[2],
            block = statement[4];

        for (var i = 0; i < attrs.length; i++) {
            buffer.push(attrs[i]);
        }
        buffer.push([Ops$1.FlushElement]);
        if (block) {
            var statements = block.statements;

            for (var _i = 0; _i < statements.length; _i++) {
                buffer.push(statements[_i]);
            }
        }
        buffer.push([Ops$1.CloseElement]);
    }
    function decorateTopLevelElement(tagName, symbols, attrs, buffer) {
        var attrsSymbol = symbols.push(ATTRS_BLOCK);
        buffer.push([Ops$1.ClientSideStatement, Ops$2.OpenComponentElement, tagName]);
        buffer.push([Ops$1.ClientSideStatement, Ops$2.DidCreateElement]);
        buffer.push([Ops$1.Yield, attrsSymbol, _util.EMPTY_ARRAY]);
        buffer.push.apply(buffer, attrs);
    }

    function _classCallCheck$24(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var Constants = function () {
        function Constants() {
            _classCallCheck$24(this, Constants);

            // `0` means NULL
            this.references = [];
            this.strings = [];
            this.expressions = [];
            this.floats = [];
            this.arrays = [];
            this.blocks = [];
            this.functions = [];
            this.others = [];
        }

        Constants.prototype.getReference = function getReference(value) {
            return this.references[value - 1];
        };

        Constants.prototype.reference = function reference(value) {
            var index = this.references.length;
            this.references.push(value);
            return index + 1;
        };

        Constants.prototype.getString = function getString(value) {
            return this.strings[value - 1];
        };

        Constants.prototype.getFloat = function getFloat(value) {
            return this.floats[value - 1];
        };

        Constants.prototype.float = function float(value) {
            return this.floats.push(value);
        };

        Constants.prototype.string = function string(value) {
            var index = this.strings.length;
            this.strings.push(value);
            return index + 1;
        };

        Constants.prototype.getExpression = function getExpression(value) {
            return this.expressions[value - 1];
        };

        Constants.prototype.getArray = function getArray(value) {
            return this.arrays[value - 1];
        };

        Constants.prototype.getNames = function getNames(value) {
            var _names = [];
            var names = this.getArray(value);
            for (var i = 0; i < names.length; i++) {
                var n = names[i];
                _names[i] = this.getString(n);
            }
            return _names;
        };

        Constants.prototype.array = function array(values) {
            var index = this.arrays.length;
            this.arrays.push(values);
            return index + 1;
        };

        Constants.prototype.getBlock = function getBlock(value) {
            return this.blocks[value - 1];
        };

        Constants.prototype.block = function block(_block) {
            var index = this.blocks.length;
            this.blocks.push(_block);
            return index + 1;
        };

        Constants.prototype.getFunction = function getFunction(value) {
            return this.functions[value - 1];
        };

        Constants.prototype.function = function _function(f) {
            var index = this.functions.length;
            this.functions.push(f);
            return index + 1;
        };

        Constants.prototype.getOther = function getOther(value) {
            return this.others[value - 1];
        };

        Constants.prototype.other = function other(_other) {
            var index = this.others.length;
            this.others.push(_other);
            return index + 1;
        };

        return Constants;
    }();

    var badProtocols = ['javascript:', 'vbscript:'];
    var badTags = ['A', 'BODY', 'LINK', 'IMG', 'IFRAME', 'BASE', 'FORM'];
    var badTagsForDataURI = ['EMBED'];
    var badAttributes = ['href', 'src', 'background', 'action'];
    var badAttributesForDataURI = ['src'];
    function has(array, item) {
        return array.indexOf(item) !== -1;
    }
    function checkURI(tagName, attribute) {
        return (tagName === null || has(badTags, tagName)) && has(badAttributes, attribute);
    }
    function checkDataURI(tagName, attribute) {
        if (tagName === null) return false;
        return has(badTagsForDataURI, tagName) && has(badAttributesForDataURI, attribute);
    }
    function requiresSanitization(tagName, attribute) {
        return checkURI(tagName, attribute) || checkDataURI(tagName, attribute);
    }
    function sanitizeAttributeValue(env, element, attribute, value) {
        var tagName = null;
        if (value === null || value === undefined) {
            return value;
        }
        if (isSafeString(value)) {
            return value.toHTML();
        }
        if (!element) {
            tagName = null;
        } else {
            tagName = element.tagName.toUpperCase();
        }
        var str = normalizeTextValue(value);
        if (checkURI(tagName, attribute)) {
            var protocol = env.protocolForURL(str);
            if (has(badProtocols, protocol)) {
                return 'unsafe:' + str;
            }
        }
        if (checkDataURI(tagName, attribute)) {
            return 'unsafe:' + str;
        }
        return str;
    }

    /*
     * @method normalizeProperty
     * @param element {HTMLElement}
     * @param slotName {String}
     * @returns {Object} { name, type }
     */
    function normalizeProperty(element, slotName) {
        var type = void 0,
            normalized = void 0;
        if (slotName in element) {
            normalized = slotName;
            type = 'prop';
        } else {
            var lower = slotName.toLowerCase();
            if (lower in element) {
                type = 'prop';
                normalized = lower;
            } else {
                type = 'attr';
                normalized = slotName;
            }
        }
        if (type === 'prop' && (normalized.toLowerCase() === 'style' || preferAttr(element.tagName, normalized))) {
            type = 'attr';
        }
        return { normalized: normalized, type: type };
    }

    // properties that MUST be set as attributes, due to:
    // * browser bug
    // * strange spec outlier
    var ATTR_OVERRIDES = {
        // phantomjs < 2.0 lets you set it as a prop but won't reflect it
        // back to the attribute. button.getAttribute('type') === null
        BUTTON: { type: true, form: true },
        INPUT: {
            // Some version of IE (like IE9) actually throw an exception
            // if you set input.type = 'something-unknown'
            type: true,
            form: true,
            // Chrome 46.0.2464.0: 'autocorrect' in document.createElement('input') === false
            // Safari 8.0.7: 'autocorrect' in document.createElement('input') === false
            // Mobile Safari (iOS 8.4 simulator): 'autocorrect' in document.createElement('input') === true
            autocorrect: true,
            // Chrome 54.0.2840.98: 'list' in document.createElement('input') === true
            // Safari 9.1.3: 'list' in document.createElement('input') === false
            list: true
        },
        // element.form is actually a legitimate readOnly property, that is to be
        // mutated, but must be mutated by setAttribute...
        SELECT: { form: true },
        OPTION: { form: true },
        TEXTAREA: { form: true },
        LABEL: { form: true },
        FIELDSET: { form: true },
        LEGEND: { form: true },
        OBJECT: { form: true }
    };
    function preferAttr(tagName, propName) {
        var tag = ATTR_OVERRIDES[tagName.toUpperCase()];
        return tag && tag[propName.toLowerCase()] || false;
    }

    function _defaults$12(obj, defaults) {
        var keys = Object.getOwnPropertyNames(defaults);for (var i = 0; i < keys.length; i++) {
            var key = keys[i];var value = Object.getOwnPropertyDescriptor(defaults, key);if (value && value.configurable && obj[key] === undefined) {
                Object.defineProperty(obj, key, value);
            }
        }return obj;
    }

    function _classCallCheck$27(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    function _possibleConstructorReturn$12(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits$12(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults$12(subClass, superClass);
    }

    var innerHTMLWrapper = {
        colgroup: { depth: 2, before: '<table><colgroup>', after: '</colgroup></table>' },
        table: { depth: 1, before: '<table>', after: '</table>' },
        tbody: { depth: 2, before: '<table><tbody>', after: '</tbody></table>' },
        tfoot: { depth: 2, before: '<table><tfoot>', after: '</tfoot></table>' },
        thead: { depth: 2, before: '<table><thead>', after: '</thead></table>' },
        tr: { depth: 3, before: '<table><tbody><tr>', after: '</tr></tbody></table>' }
    };
    // Patch:    innerHTML Fix
    // Browsers: IE9
    // Reason:   IE9 don't allow us to set innerHTML on col, colgroup, frameset,
    //           html, style, table, tbody, tfoot, thead, title, tr.
    // Fix:      Wrap the innerHTML we are about to set in its parents, apply the
    //           wrapped innerHTML on a div, then move the unwrapped nodes into the
    //           target position.
    function domChanges(document, DOMChangesClass) {
        if (!document) return DOMChangesClass;
        if (!shouldApplyFix(document)) {
            return DOMChangesClass;
        }
        var div = document.createElement('div');
        return function (_DOMChangesClass) {
            _inherits$12(DOMChangesWithInnerHTMLFix, _DOMChangesClass);

            function DOMChangesWithInnerHTMLFix() {
                _classCallCheck$27(this, DOMChangesWithInnerHTMLFix);

                return _possibleConstructorReturn$12(this, _DOMChangesClass.apply(this, arguments));
            }

            DOMChangesWithInnerHTMLFix.prototype.insertHTMLBefore = function insertHTMLBefore$$1(parent, nextSibling, html) {
                if (html === null || html === '') {
                    return _DOMChangesClass.prototype.insertHTMLBefore.call(this, parent, nextSibling, html);
                }
                var parentTag = parent.tagName.toLowerCase();
                var wrapper = innerHTMLWrapper[parentTag];
                if (wrapper === undefined) {
                    return _DOMChangesClass.prototype.insertHTMLBefore.call(this, parent, nextSibling, html);
                }
                return fixInnerHTML(parent, wrapper, div, html, nextSibling);
            };

            return DOMChangesWithInnerHTMLFix;
        }(DOMChangesClass);
    }
    function treeConstruction(document, DOMTreeConstructionClass) {
        if (!document) return DOMTreeConstructionClass;
        if (!shouldApplyFix(document)) {
            return DOMTreeConstructionClass;
        }
        var div = document.createElement('div');
        return function (_DOMTreeConstructionC) {
            _inherits$12(DOMTreeConstructionWithInnerHTMLFix, _DOMTreeConstructionC);

            function DOMTreeConstructionWithInnerHTMLFix() {
                _classCallCheck$27(this, DOMTreeConstructionWithInnerHTMLFix);

                return _possibleConstructorReturn$12(this, _DOMTreeConstructionC.apply(this, arguments));
            }

            DOMTreeConstructionWithInnerHTMLFix.prototype.insertHTMLBefore = function insertHTMLBefore$$1(parent, referenceNode, html) {
                if (html === null || html === '') {
                    return _DOMTreeConstructionC.prototype.insertHTMLBefore.call(this, parent, referenceNode, html);
                }
                var parentTag = parent.tagName.toLowerCase();
                var wrapper = innerHTMLWrapper[parentTag];
                if (wrapper === undefined) {
                    return _DOMTreeConstructionC.prototype.insertHTMLBefore.call(this, parent, referenceNode, html);
                }
                return fixInnerHTML(parent, wrapper, div, html, referenceNode);
            };

            return DOMTreeConstructionWithInnerHTMLFix;
        }(DOMTreeConstructionClass);
    }
    function fixInnerHTML(parent, wrapper, div, html, reference) {
        var wrappedHtml = wrapper.before + html + wrapper.after;
        div.innerHTML = wrappedHtml;
        var parentNode = div;
        for (var i = 0; i < wrapper.depth; i++) {
            parentNode = parentNode.childNodes[0];
        }

        var _moveNodesBefore = moveNodesBefore(parentNode, parent, reference),
            first = _moveNodesBefore[0],
            last = _moveNodesBefore[1];

        return new ConcreteBounds(parent, first, last);
    }
    function shouldApplyFix(document) {
        var table = document.createElement('table');
        try {
            table.innerHTML = '<tbody></tbody>';
        } catch (e) {} finally {
            if (table.childNodes.length !== 0) {
                // It worked as expected, no fix required
                return false;
            }
        }
        return true;
    }

    function _defaults$13(obj, defaults) {
        var keys = Object.getOwnPropertyNames(defaults);for (var i = 0; i < keys.length; i++) {
            var key = keys[i];var value = Object.getOwnPropertyDescriptor(defaults, key);if (value && value.configurable && obj[key] === undefined) {
                Object.defineProperty(obj, key, value);
            }
        }return obj;
    }

    function _classCallCheck$28(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    function _possibleConstructorReturn$13(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits$13(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults$13(subClass, superClass);
    }

    var SVG_NAMESPACE$1 = 'http://www.w3.org/2000/svg';
    // Patch:    insertAdjacentHTML on SVG Fix
    // Browsers: Safari, IE, Edge, Firefox ~33-34
    // Reason:   insertAdjacentHTML does not exist on SVG elements in Safari. It is
    //           present but throws an exception on IE and Edge. Old versions of
    //           Firefox create nodes in the incorrect namespace.
    // Fix:      Since IE and Edge silently fail to create SVG nodes using
    //           innerHTML, and because Firefox may create nodes in the incorrect
    //           namespace using innerHTML on SVG elements, an HTML-string wrapping
    //           approach is used. A pre/post SVG tag is added to the string, then
    //           that whole string is added to a div. The created nodes are plucked
    //           out and applied to the target location on DOM.
    function domChanges$1(document, DOMChangesClass, svgNamespace) {
        if (!document) return DOMChangesClass;
        if (!shouldApplyFix$1(document, svgNamespace)) {
            return DOMChangesClass;
        }
        var div = document.createElement('div');
        return function (_DOMChangesClass) {
            _inherits$13(DOMChangesWithSVGInnerHTMLFix, _DOMChangesClass);

            function DOMChangesWithSVGInnerHTMLFix() {
                _classCallCheck$28(this, DOMChangesWithSVGInnerHTMLFix);

                return _possibleConstructorReturn$13(this, _DOMChangesClass.apply(this, arguments));
            }

            DOMChangesWithSVGInnerHTMLFix.prototype.insertHTMLBefore = function insertHTMLBefore$$1(parent, nextSibling, html) {
                if (html === null || html === '') {
                    return _DOMChangesClass.prototype.insertHTMLBefore.call(this, parent, nextSibling, html);
                }
                if (parent.namespaceURI !== svgNamespace) {
                    return _DOMChangesClass.prototype.insertHTMLBefore.call(this, parent, nextSibling, html);
                }
                return fixSVG(parent, div, html, nextSibling);
            };

            return DOMChangesWithSVGInnerHTMLFix;
        }(DOMChangesClass);
    }
    function treeConstruction$1(document, TreeConstructionClass, svgNamespace) {
        if (!document) return TreeConstructionClass;
        if (!shouldApplyFix$1(document, svgNamespace)) {
            return TreeConstructionClass;
        }
        var div = document.createElement('div');
        return function (_TreeConstructionClas) {
            _inherits$13(TreeConstructionWithSVGInnerHTMLFix, _TreeConstructionClas);

            function TreeConstructionWithSVGInnerHTMLFix() {
                _classCallCheck$28(this, TreeConstructionWithSVGInnerHTMLFix);

                return _possibleConstructorReturn$13(this, _TreeConstructionClas.apply(this, arguments));
            }

            TreeConstructionWithSVGInnerHTMLFix.prototype.insertHTMLBefore = function insertHTMLBefore$$1(parent, reference, html) {
                if (html === null || html === '') {
                    return _TreeConstructionClas.prototype.insertHTMLBefore.call(this, parent, reference, html);
                }
                if (parent.namespaceURI !== svgNamespace) {
                    return _TreeConstructionClas.prototype.insertHTMLBefore.call(this, parent, reference, html);
                }
                return fixSVG(parent, div, html, reference);
            };

            return TreeConstructionWithSVGInnerHTMLFix;
        }(TreeConstructionClass);
    }
    function fixSVG(parent, div, html, reference) {
        // IE, Edge: also do not correctly support using `innerHTML` on SVG
        // namespaced elements. So here a wrapper is used.
        var wrappedHtml = '<svg>' + html + '</svg>';
        div.innerHTML = wrappedHtml;

        var _moveNodesBefore = moveNodesBefore(div.firstChild, parent, reference),
            first = _moveNodesBefore[0],
            last = _moveNodesBefore[1];

        return new ConcreteBounds(parent, first, last);
    }
    function shouldApplyFix$1(document, svgNamespace) {
        var svg = document.createElementNS(svgNamespace, 'svg');
        try {
            svg['insertAdjacentHTML']('beforeend', '<circle></circle>');
        } catch (e) {
            // IE, Edge: Will throw, insertAdjacentHTML is unsupported on SVG
            // Safari: Will throw, insertAdjacentHTML is not present on SVG
        } finally {
            // FF: Old versions will create a node in the wrong namespace
            if (svg.childNodes.length === 1 && svg.firstChild.namespaceURI === SVG_NAMESPACE$1) {
                // The test worked as expected, no fix required
                return false;
            }
            return true;
        }
    }

    function _defaults$14(obj, defaults) {
        var keys = Object.getOwnPropertyNames(defaults);for (var i = 0; i < keys.length; i++) {
            var key = keys[i];var value = Object.getOwnPropertyDescriptor(defaults, key);if (value && value.configurable && obj[key] === undefined) {
                Object.defineProperty(obj, key, value);
            }
        }return obj;
    }

    function _classCallCheck$29(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    function _possibleConstructorReturn$14(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits$14(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults$14(subClass, superClass);
    }

    // Patch:    Adjacent text node merging fix
    // Browsers: IE, Edge, Firefox w/o inspector open
    // Reason:   These browsers will merge adjacent text nodes. For exmaple given
    //           <div>Hello</div> with div.insertAdjacentHTML(' world') browsers
    //           with proper behavior will populate div.childNodes with two items.
    //           These browsers will populate it with one merged node instead.
    // Fix:      Add these nodes to a wrapper element, then iterate the childNodes
    //           of that wrapper and move the nodes to their target location. Note
    //           that potential SVG bugs will have been handled before this fix.
    //           Note that this fix must only apply to the previous text node, as
    //           the base implementation of `insertHTMLBefore` already handles
    //           following text nodes correctly.
    function domChanges$2(document, DOMChangesClass) {
        if (!document) return DOMChangesClass;
        if (!shouldApplyFix$2(document)) {
            return DOMChangesClass;
        }
        return function (_DOMChangesClass) {
            _inherits$14(DOMChangesWithTextNodeMergingFix, _DOMChangesClass);

            function DOMChangesWithTextNodeMergingFix(document) {
                _classCallCheck$29(this, DOMChangesWithTextNodeMergingFix);

                var _this = _possibleConstructorReturn$14(this, _DOMChangesClass.call(this, document));

                _this.uselessComment = document.createComment('');
                return _this;
            }

            DOMChangesWithTextNodeMergingFix.prototype.insertHTMLBefore = function insertHTMLBefore(parent, nextSibling, html) {
                if (html === null) {
                    return _DOMChangesClass.prototype.insertHTMLBefore.call(this, parent, nextSibling, html);
                }
                var didSetUselessComment = false;
                var nextPrevious = nextSibling ? nextSibling.previousSibling : parent.lastChild;
                if (nextPrevious && nextPrevious instanceof Text) {
                    didSetUselessComment = true;
                    parent.insertBefore(this.uselessComment, nextSibling);
                }
                var bounds = _DOMChangesClass.prototype.insertHTMLBefore.call(this, parent, nextSibling, html);
                if (didSetUselessComment) {
                    parent.removeChild(this.uselessComment);
                }
                return bounds;
            };

            return DOMChangesWithTextNodeMergingFix;
        }(DOMChangesClass);
    }
    function treeConstruction$2(document, TreeConstructionClass) {
        if (!document) return TreeConstructionClass;
        if (!shouldApplyFix$2(document)) {
            return TreeConstructionClass;
        }
        return function (_TreeConstructionClas) {
            _inherits$14(TreeConstructionWithTextNodeMergingFix, _TreeConstructionClas);

            function TreeConstructionWithTextNodeMergingFix(document) {
                _classCallCheck$29(this, TreeConstructionWithTextNodeMergingFix);

                var _this2 = _possibleConstructorReturn$14(this, _TreeConstructionClas.call(this, document));

                _this2.uselessComment = _this2.createComment('');
                return _this2;
            }

            TreeConstructionWithTextNodeMergingFix.prototype.insertHTMLBefore = function insertHTMLBefore(parent, reference, html) {
                if (html === null) {
                    return _TreeConstructionClas.prototype.insertHTMLBefore.call(this, parent, reference, html);
                }
                var didSetUselessComment = false;
                var nextPrevious = reference ? reference.previousSibling : parent.lastChild;
                if (nextPrevious && nextPrevious instanceof Text) {
                    didSetUselessComment = true;
                    parent.insertBefore(this.uselessComment, reference);
                }
                var bounds = _TreeConstructionClas.prototype.insertHTMLBefore.call(this, parent, reference, html);
                if (didSetUselessComment) {
                    parent.removeChild(this.uselessComment);
                }
                return bounds;
            };

            return TreeConstructionWithTextNodeMergingFix;
        }(TreeConstructionClass);
    }
    function shouldApplyFix$2(document) {
        var mergingTextDiv = document.createElement('div');
        mergingTextDiv.innerHTML = 'first';
        mergingTextDiv.insertAdjacentHTML('beforeend', 'second');
        if (mergingTextDiv.childNodes.length === 2) {
            // It worked as expected, no fix required
            return false;
        }
        return true;
    }

    function _defaults$11(obj, defaults) {
        var keys = Object.getOwnPropertyNames(defaults);for (var i = 0; i < keys.length; i++) {
            var key = keys[i];var value = Object.getOwnPropertyDescriptor(defaults, key);if (value && value.configurable && obj[key] === undefined) {
                Object.defineProperty(obj, key, value);
            }
        }return obj;
    }

    function _possibleConstructorReturn$11(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits$11(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults$11(subClass, superClass);
    }

    function _classCallCheck$26(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var SVG_NAMESPACE$$1 = 'http://www.w3.org/2000/svg';
    // http://www.w3.org/TR/html/syntax.html#html-integration-point
    var SVG_INTEGRATION_POINTS = { foreignObject: 1, desc: 1, title: 1 };
    // http://www.w3.org/TR/html/syntax.html#adjust-svg-attributes
    // TODO: Adjust SVG attributes
    // http://www.w3.org/TR/html/syntax.html#parsing-main-inforeign
    // TODO: Adjust SVG elements
    // http://www.w3.org/TR/html/syntax.html#parsing-main-inforeign
    var BLACKLIST_TABLE = Object.create(null);
    ["b", "big", "blockquote", "body", "br", "center", "code", "dd", "div", "dl", "dt", "em", "embed", "h1", "h2", "h3", "h4", "h5", "h6", "head", "hr", "i", "img", "li", "listing", "main", "meta", "nobr", "ol", "p", "pre", "ruby", "s", "small", "span", "strong", "strike", "sub", "sup", "table", "tt", "u", "ul", "var"].forEach(function (tag) {
        return BLACKLIST_TABLE[tag] = 1;
    });
    var WHITESPACE = /[\t-\r \xA0\u1680\u180E\u2000-\u200A\u2028\u2029\u202F\u205F\u3000\uFEFF]/;
    var doc = typeof document === 'undefined' ? null : document;
    function isWhitespace(string) {
        return WHITESPACE.test(string);
    }
    function moveNodesBefore(source, target, nextSibling) {
        var first = source.firstChild;
        var last = null;
        var current = first;
        while (current) {
            last = current;
            current = current.nextSibling;
            target.insertBefore(last, nextSibling);
        }
        return [first, last];
    }
    var DOMOperations = function () {
        function DOMOperations(document) {
            _classCallCheck$26(this, DOMOperations);

            this.document = document;
            this.setupUselessElement();
        }
        // split into seperate method so that NodeDOMTreeConstruction
        // can override it.


        DOMOperations.prototype.setupUselessElement = function setupUselessElement() {
            this.uselessElement = this.document.createElement('div');
        };

        DOMOperations.prototype.createElement = function createElement(tag, context) {
            var isElementInSVGNamespace = void 0,
                isHTMLIntegrationPoint = void 0;
            if (context) {
                isElementInSVGNamespace = context.namespaceURI === SVG_NAMESPACE$$1 || tag === 'svg';
                isHTMLIntegrationPoint = SVG_INTEGRATION_POINTS[context.tagName];
            } else {
                isElementInSVGNamespace = tag === 'svg';
                isHTMLIntegrationPoint = false;
            }
            if (isElementInSVGNamespace && !isHTMLIntegrationPoint) {
                // FIXME: This does not properly handle <font> with color, face, or
                // size attributes, which is also disallowed by the spec. We should fix
                // this.
                if (BLACKLIST_TABLE[tag]) {
                    throw new Error('Cannot create a ' + tag + ' inside an SVG context');
                }
                return this.document.createElementNS(SVG_NAMESPACE$$1, tag);
            } else {
                return this.document.createElement(tag);
            }
        };

        DOMOperations.prototype.insertBefore = function insertBefore(parent, node, reference) {
            parent.insertBefore(node, reference);
        };

        DOMOperations.prototype.insertHTMLBefore = function insertHTMLBefore(_parent, nextSibling, html) {
            return _insertHTMLBefore(this.uselessElement, _parent, nextSibling, html);
        };

        DOMOperations.prototype.createTextNode = function createTextNode(text) {
            return this.document.createTextNode(text);
        };

        DOMOperations.prototype.createComment = function createComment(data) {
            return this.document.createComment(data);
        };

        return DOMOperations;
    }();
    var DOM;
    (function (DOM) {
        var TreeConstruction = function (_DOMOperations) {
            _inherits$11(TreeConstruction, _DOMOperations);

            function TreeConstruction() {
                _classCallCheck$26(this, TreeConstruction);

                return _possibleConstructorReturn$11(this, _DOMOperations.apply(this, arguments));
            }

            TreeConstruction.prototype.createElementNS = function createElementNS(namespace, tag) {
                return this.document.createElementNS(namespace, tag);
            };

            TreeConstruction.prototype.setAttribute = function setAttribute(element, name, value, namespace) {
                if (namespace) {
                    element.setAttributeNS(namespace, name, value);
                } else {
                    element.setAttribute(name, value);
                }
            };

            return TreeConstruction;
        }(DOMOperations);

        DOM.TreeConstruction = TreeConstruction;
        var appliedTreeContruction = TreeConstruction;
        appliedTreeContruction = treeConstruction$2(doc, appliedTreeContruction);
        appliedTreeContruction = treeConstruction(doc, appliedTreeContruction);
        appliedTreeContruction = treeConstruction$1(doc, appliedTreeContruction, SVG_NAMESPACE$$1);
        DOM.DOMTreeConstruction = appliedTreeContruction;
    })(DOM || (DOM = {}));
    var DOMChanges = function (_DOMOperations2) {
        _inherits$11(DOMChanges, _DOMOperations2);

        function DOMChanges(document) {
            _classCallCheck$26(this, DOMChanges);

            var _this2 = _possibleConstructorReturn$11(this, _DOMOperations2.call(this, document));

            _this2.document = document;
            _this2.namespace = null;
            return _this2;
        }

        DOMChanges.prototype.setAttribute = function setAttribute(element, name, value) {
            element.setAttribute(name, value);
        };

        DOMChanges.prototype.setAttributeNS = function setAttributeNS(element, namespace, name, value) {
            element.setAttributeNS(namespace, name, value);
        };

        DOMChanges.prototype.removeAttribute = function removeAttribute(element, name) {
            element.removeAttribute(name);
        };

        DOMChanges.prototype.removeAttributeNS = function removeAttributeNS(element, namespace, name) {
            element.removeAttributeNS(namespace, name);
        };

        DOMChanges.prototype.insertNodeBefore = function insertNodeBefore(parent, node, reference) {
            if (isDocumentFragment(node)) {
                var firstChild = node.firstChild,
                    lastChild = node.lastChild;

                this.insertBefore(parent, node, reference);
                return new ConcreteBounds(parent, firstChild, lastChild);
            } else {
                this.insertBefore(parent, node, reference);
                return new SingleNodeBounds(parent, node);
            }
        };

        DOMChanges.prototype.insertTextBefore = function insertTextBefore(parent, nextSibling, text) {
            var textNode = this.createTextNode(text);
            this.insertBefore(parent, textNode, nextSibling);
            return textNode;
        };

        DOMChanges.prototype.insertBefore = function insertBefore(element, node, reference) {
            element.insertBefore(node, reference);
        };

        DOMChanges.prototype.insertAfter = function insertAfter(element, node, reference) {
            this.insertBefore(element, node, reference.nextSibling);
        };

        return DOMChanges;
    }(DOMOperations);
    function _insertHTMLBefore(_useless, _parent, _nextSibling, html) {
        // TypeScript vendored an old version of the DOM spec where `insertAdjacentHTML`
        // only exists on `HTMLElement` but not on `Element`. We actually work with the
        // newer version of the DOM API here (and monkey-patch this method in `./compat`
        // when we detect older browsers). This is a hack to work around this limitation.
        var parent = _parent;
        var useless = _useless;
        var nextSibling = _nextSibling;
        var prev = nextSibling ? nextSibling.previousSibling : parent.lastChild;
        var last = void 0;
        if (html === null || html === '') {
            return new ConcreteBounds(parent, null, null);
        }
        if (nextSibling === null) {
            parent.insertAdjacentHTML('beforeend', html);
            last = parent.lastChild;
        } else if (nextSibling instanceof HTMLElement) {
            nextSibling.insertAdjacentHTML('beforebegin', html);
            last = nextSibling.previousSibling;
        } else {
            // Non-element nodes do not support insertAdjacentHTML, so add an
            // element and call it on that element. Then remove the element.
            //
            // This also protects Edge, IE and Firefox w/o the inspector open
            // from merging adjacent text nodes. See ./compat/text-node-merging-fix.ts
            parent.insertBefore(useless, nextSibling);
            useless.insertAdjacentHTML('beforebegin', html);
            last = useless.previousSibling;
            parent.removeChild(useless);
        }
        var first = prev ? prev.nextSibling : parent.firstChild;
        return new ConcreteBounds(parent, first, last);
    }
    function isDocumentFragment(node) {
        return node.nodeType === Node.DOCUMENT_FRAGMENT_NODE;
    }
    var helper = DOMChanges;
    helper = domChanges$2(doc, helper);
    helper = domChanges(doc, helper);
    helper = domChanges$1(doc, helper, SVG_NAMESPACE$$1);
    var helper$1 = helper;
    var DOMTreeConstruction = DOM.DOMTreeConstruction;

    function _defaults$10(obj, defaults) {
        var keys = Object.getOwnPropertyNames(defaults);for (var i = 0; i < keys.length; i++) {
            var key = keys[i];var value = Object.getOwnPropertyDescriptor(defaults, key);if (value && value.configurable && obj[key] === undefined) {
                Object.defineProperty(obj, key, value);
            }
        }return obj;
    }

    function _possibleConstructorReturn$10(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits$10(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults$10(subClass, superClass);
    }

    function _classCallCheck$25(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    function defaultManagers(element, attr, _isTrusting, _namespace) {
        var tagName = element.tagName;
        var isSVG = element.namespaceURI === SVG_NAMESPACE$$1;
        if (isSVG) {
            return defaultAttributeManagers(tagName, attr);
        }

        var _normalizeProperty = normalizeProperty(element, attr),
            type = _normalizeProperty.type,
            normalized = _normalizeProperty.normalized;

        if (type === 'attr') {
            return defaultAttributeManagers(tagName, normalized);
        } else {
            return defaultPropertyManagers(tagName, normalized);
        }
    }
    function defaultPropertyManagers(tagName, attr) {
        if (requiresSanitization(tagName, attr)) {
            return new SafePropertyManager(attr);
        }
        if (isUserInputValue(tagName, attr)) {
            return INPUT_VALUE_PROPERTY_MANAGER;
        }
        if (isOptionSelected(tagName, attr)) {
            return OPTION_SELECTED_MANAGER;
        }
        return new PropertyManager(attr);
    }
    function defaultAttributeManagers(tagName, attr) {
        if (requiresSanitization(tagName, attr)) {
            return new SafeAttributeManager(attr);
        }
        return new AttributeManager(attr);
    }
    function readDOMAttr(element, attr) {
        var isSVG = element.namespaceURI === SVG_NAMESPACE$$1;

        var _normalizeProperty2 = normalizeProperty(element, attr),
            type = _normalizeProperty2.type,
            normalized = _normalizeProperty2.normalized;

        if (isSVG) {
            return element.getAttribute(normalized);
        }
        if (type === 'attr') {
            return element.getAttribute(normalized);
        }
        {
            return element[normalized];
        }
    }

    var AttributeManager = function () {
        function AttributeManager(attr) {
            _classCallCheck$25(this, AttributeManager);

            this.attr = attr;
        }

        AttributeManager.prototype.setAttribute = function setAttribute(env, element, value, namespace) {
            var dom = env.getAppendOperations();
            var normalizedValue = normalizeAttributeValue(value);
            if (!isAttrRemovalValue(normalizedValue)) {
                dom.setAttribute(element, this.attr, normalizedValue, namespace);
            }
        };

        AttributeManager.prototype.updateAttribute = function updateAttribute(env, element, value, namespace) {
            if (value === null || value === undefined || value === false) {
                if (namespace) {
                    env.getDOM().removeAttributeNS(element, namespace, this.attr);
                } else {
                    env.getDOM().removeAttribute(element, this.attr);
                }
            } else {
                this.setAttribute(env, element, value);
            }
        };

        return AttributeManager;
    }();

    var PropertyManager = function (_AttributeManager) {
        _inherits$10(PropertyManager, _AttributeManager);

        function PropertyManager() {
            _classCallCheck$25(this, PropertyManager);

            return _possibleConstructorReturn$10(this, _AttributeManager.apply(this, arguments));
        }

        PropertyManager.prototype.setAttribute = function setAttribute(_env, element, value, _namespace) {
            if (!isAttrRemovalValue(value)) {
                element[this.attr] = value;
            }
        };

        PropertyManager.prototype.removeAttribute = function removeAttribute(env, element, namespace) {
            // TODO this sucks but to preserve properties first and to meet current
            // semantics we must do this.
            var attr = this.attr;

            if (namespace) {
                env.getDOM().removeAttributeNS(element, namespace, attr);
            } else {
                env.getDOM().removeAttribute(element, attr);
            }
        };

        PropertyManager.prototype.updateAttribute = function updateAttribute(env, element, value, namespace) {
            // ensure the property is always updated
            element[this.attr] = value;
            if (isAttrRemovalValue(value)) {
                this.removeAttribute(env, element, namespace);
            }
        };

        return PropertyManager;
    }(AttributeManager);

    function normalizeAttributeValue(value) {
        if (value === false || value === undefined || value === null) {
            return null;
        }
        if (value === true) {
            return '';
        }
        // onclick function etc in SSR
        if (typeof value === 'function') {
            return null;
        }
        return String(value);
    }
    function isAttrRemovalValue(value) {
        return value === null || value === undefined;
    }

    var SafePropertyManager = function (_PropertyManager) {
        _inherits$10(SafePropertyManager, _PropertyManager);

        function SafePropertyManager() {
            _classCallCheck$25(this, SafePropertyManager);

            return _possibleConstructorReturn$10(this, _PropertyManager.apply(this, arguments));
        }

        SafePropertyManager.prototype.setAttribute = function setAttribute(env, element, value) {
            _PropertyManager.prototype.setAttribute.call(this, env, element, sanitizeAttributeValue(env, element, this.attr, value));
        };

        SafePropertyManager.prototype.updateAttribute = function updateAttribute(env, element, value) {
            _PropertyManager.prototype.updateAttribute.call(this, env, element, sanitizeAttributeValue(env, element, this.attr, value));
        };

        return SafePropertyManager;
    }(PropertyManager);

    function isUserInputValue(tagName, attribute) {
        return (tagName === 'INPUT' || tagName === 'TEXTAREA') && attribute === 'value';
    }

    var InputValuePropertyManager = function (_AttributeManager2) {
        _inherits$10(InputValuePropertyManager, _AttributeManager2);

        function InputValuePropertyManager() {
            _classCallCheck$25(this, InputValuePropertyManager);

            return _possibleConstructorReturn$10(this, _AttributeManager2.apply(this, arguments));
        }

        InputValuePropertyManager.prototype.setAttribute = function setAttribute(_env, element, value) {
            var input = element;
            input.value = normalizeTextValue(value);
        };

        InputValuePropertyManager.prototype.updateAttribute = function updateAttribute(_env, element, value) {
            var input = element;
            var currentValue = input.value;
            var normalizedValue = normalizeTextValue(value);
            if (currentValue !== normalizedValue) {
                input.value = normalizedValue;
            }
        };

        return InputValuePropertyManager;
    }(AttributeManager);

    var INPUT_VALUE_PROPERTY_MANAGER = new InputValuePropertyManager('value');
    function isOptionSelected(tagName, attribute) {
        return tagName === 'OPTION' && attribute === 'selected';
    }

    var OptionSelectedManager = function (_PropertyManager2) {
        _inherits$10(OptionSelectedManager, _PropertyManager2);

        function OptionSelectedManager() {
            _classCallCheck$25(this, OptionSelectedManager);

            return _possibleConstructorReturn$10(this, _PropertyManager2.apply(this, arguments));
        }

        OptionSelectedManager.prototype.setAttribute = function setAttribute(_env, element, value) {
            if (value !== null && value !== undefined && value !== false) {
                var option = element;
                option.selected = true;
            }
        };

        OptionSelectedManager.prototype.updateAttribute = function updateAttribute(_env, element, value) {
            var option = element;
            if (value) {
                option.selected = true;
            } else {
                option.selected = false;
            }
        };

        return OptionSelectedManager;
    }(PropertyManager);

    var OPTION_SELECTED_MANAGER = new OptionSelectedManager('selected');

    var SafeAttributeManager = function (_AttributeManager3) {
        _inherits$10(SafeAttributeManager, _AttributeManager3);

        function SafeAttributeManager() {
            _classCallCheck$25(this, SafeAttributeManager);

            return _possibleConstructorReturn$10(this, _AttributeManager3.apply(this, arguments));
        }

        SafeAttributeManager.prototype.setAttribute = function setAttribute(env, element, value) {
            _AttributeManager3.prototype.setAttribute.call(this, env, element, sanitizeAttributeValue(env, element, this.attr, value));
        };

        SafeAttributeManager.prototype.updateAttribute = function updateAttribute(env, element, value, _namespace) {
            _AttributeManager3.prototype.updateAttribute.call(this, env, element, sanitizeAttributeValue(env, element, this.attr, value));
        };

        return SafeAttributeManager;
    }(AttributeManager);

    var _createClass$4 = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
            }
        }return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
        };
    }();

    function _classCallCheck$23(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var Scope = function () {
        function Scope(
        // the 0th slot is `self`
        slots, callerScope,
        // named arguments and blocks passed to a layout that uses eval
        evalScope,
        // locals in scope when the partial was invoked
        partialMap) {
            _classCallCheck$23(this, Scope);

            this.slots = slots;
            this.callerScope = callerScope;
            this.evalScope = evalScope;
            this.partialMap = partialMap;
        }

        Scope.root = function root(self) {
            var size = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

            var refs = new Array(size + 1);
            for (var i = 0; i <= size; i++) {
                refs[i] = UNDEFINED_REFERENCE;
            }
            return new Scope(refs, null, null, null).init({ self: self });
        };

        Scope.sized = function sized() {
            var size = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;

            var refs = new Array(size + 1);
            for (var i = 0; i <= size; i++) {
                refs[i] = UNDEFINED_REFERENCE;
            }
            return new Scope(refs, null, null, null);
        };

        Scope.prototype.init = function init(_ref) {
            var self = _ref.self;

            this.slots[0] = self;
            return this;
        };

        Scope.prototype.getSelf = function getSelf() {
            return this.get(0);
        };

        Scope.prototype.getSymbol = function getSymbol(symbol) {
            return this.get(symbol);
        };

        Scope.prototype.getBlock = function getBlock(symbol) {
            return this.get(symbol);
        };

        Scope.prototype.getEvalScope = function getEvalScope() {
            return this.evalScope;
        };

        Scope.prototype.getPartialMap = function getPartialMap() {
            return this.partialMap;
        };

        Scope.prototype.bind = function bind(symbol, value) {
            this.set(symbol, value);
        };

        Scope.prototype.bindSelf = function bindSelf(self) {
            this.set(0, self);
        };

        Scope.prototype.bindSymbol = function bindSymbol(symbol, value) {
            this.set(symbol, value);
        };

        Scope.prototype.bindBlock = function bindBlock(symbol, value) {
            this.set(symbol, value);
        };

        Scope.prototype.bindEvalScope = function bindEvalScope(map$$1) {
            this.evalScope = map$$1;
        };

        Scope.prototype.bindPartialMap = function bindPartialMap(map$$1) {
            this.partialMap = map$$1;
        };

        Scope.prototype.bindCallerScope = function bindCallerScope(scope) {
            this.callerScope = scope;
        };

        Scope.prototype.getCallerScope = function getCallerScope() {
            return this.callerScope;
        };

        Scope.prototype.child = function child() {
            return new Scope(this.slots.slice(), this.callerScope, this.evalScope, this.partialMap);
        };

        Scope.prototype.get = function get(index) {
            if (index >= this.slots.length) {
                throw new RangeError('BUG: cannot get $' + index + ' from scope; length=' + this.slots.length);
            }
            return this.slots[index];
        };

        Scope.prototype.set = function set(index, value) {
            if (index >= this.slots.length) {
                throw new RangeError('BUG: cannot get $' + index + ' from scope; length=' + this.slots.length);
            }
            this.slots[index] = value;
        };

        return Scope;
    }();

    var Transaction = function () {
        function Transaction() {
            _classCallCheck$23(this, Transaction);

            this.scheduledInstallManagers = [];
            this.scheduledInstallModifiers = [];
            this.scheduledUpdateModifierManagers = [];
            this.scheduledUpdateModifiers = [];
            this.createdComponents = [];
            this.createdManagers = [];
            this.updatedComponents = [];
            this.updatedManagers = [];
            this.destructors = [];
        }

        Transaction.prototype.didCreate = function didCreate(component, manager) {
            this.createdComponents.push(component);
            this.createdManagers.push(manager);
        };

        Transaction.prototype.didUpdate = function didUpdate(component, manager) {
            this.updatedComponents.push(component);
            this.updatedManagers.push(manager);
        };

        Transaction.prototype.scheduleInstallModifier = function scheduleInstallModifier(modifier, manager) {
            this.scheduledInstallManagers.push(manager);
            this.scheduledInstallModifiers.push(modifier);
        };

        Transaction.prototype.scheduleUpdateModifier = function scheduleUpdateModifier(modifier, manager) {
            this.scheduledUpdateModifierManagers.push(manager);
            this.scheduledUpdateModifiers.push(modifier);
        };

        Transaction.prototype.didDestroy = function didDestroy(d) {
            this.destructors.push(d);
        };

        Transaction.prototype.commit = function commit() {
            var createdComponents = this.createdComponents,
                createdManagers = this.createdManagers;

            for (var i = 0; i < createdComponents.length; i++) {
                var component = createdComponents[i];
                var manager = createdManagers[i];
                manager.didCreate(component);
            }
            var updatedComponents = this.updatedComponents,
                updatedManagers = this.updatedManagers;

            for (var _i = 0; _i < updatedComponents.length; _i++) {
                var _component = updatedComponents[_i];
                var _manager = updatedManagers[_i];
                _manager.didUpdate(_component);
            }
            var destructors = this.destructors;

            for (var _i2 = 0; _i2 < destructors.length; _i2++) {
                destructors[_i2].destroy();
            }
            var scheduledInstallManagers = this.scheduledInstallManagers,
                scheduledInstallModifiers = this.scheduledInstallModifiers;

            for (var _i3 = 0; _i3 < scheduledInstallManagers.length; _i3++) {
                var _manager2 = scheduledInstallManagers[_i3];
                var modifier = scheduledInstallModifiers[_i3];
                _manager2.install(modifier);
            }
            var scheduledUpdateModifierManagers = this.scheduledUpdateModifierManagers,
                scheduledUpdateModifiers = this.scheduledUpdateModifiers;

            for (var _i4 = 0; _i4 < scheduledUpdateModifierManagers.length; _i4++) {
                var _manager3 = scheduledUpdateModifierManagers[_i4];
                var _modifier = scheduledUpdateModifiers[_i4];
                _manager3.update(_modifier);
            }
        };

        return Transaction;
    }();

    var Opcode = function () {
        function Opcode(heap) {
            _classCallCheck$23(this, Opcode);

            this.heap = heap;
            this.offset = 0;
        }

        _createClass$4(Opcode, [{
            key: 'type',
            get: function () {
                return this.heap.getbyaddr(this.offset);
            }
        }, {
            key: 'op1',
            get: function () {
                return this.heap.getbyaddr(this.offset + 1);
            }
        }, {
            key: 'op2',
            get: function () {
                return this.heap.getbyaddr(this.offset + 2);
            }
        }, {
            key: 'op3',
            get: function () {
                return this.heap.getbyaddr(this.offset + 3);
            }
        }]);

        return Opcode;
    }();
    var TableSlotState;
    (function (TableSlotState) {
        TableSlotState[TableSlotState["Allocated"] = 0] = "Allocated";
        TableSlotState[TableSlotState["Freed"] = 1] = "Freed";
        TableSlotState[TableSlotState["Purged"] = 2] = "Purged";
        TableSlotState[TableSlotState["Pointer"] = 3] = "Pointer";
    })(TableSlotState || (TableSlotState = {}));
    var Heap = function () {
        function Heap() {
            _classCallCheck$23(this, Heap);

            this.heap = [];
            this.offset = 0;
            this.handle = 0;
            /**
             * layout:
             *
             * - pointer into heap
             * - size
             * - freed (0 or 1)
             */
            this.table = [];
        }

        Heap.prototype.push = function push(item) {
            this.heap[this.offset++] = item;
        };

        Heap.prototype.getbyaddr = function getbyaddr(address) {
            return this.heap[address];
        };

        Heap.prototype.setbyaddr = function setbyaddr(address, value) {
            this.heap[address] = value;
        };

        Heap.prototype.malloc = function malloc() {
            this.table.push(this.offset, 0, 0);
            var handle = this.handle;
            this.handle += 3;
            return handle;
        };

        Heap.prototype.finishMalloc = function finishMalloc(handle) {
            var start = this.table[handle];
            var finish = this.offset;
            this.table[handle + 1] = finish - start;
        };

        Heap.prototype.size = function size() {
            return this.offset;
        };
        // It is illegal to close over this address, as compaction
        // may move it. However, it is legal to use this address
        // multiple times between compactions.


        Heap.prototype.getaddr = function getaddr(handle) {
            return this.table[handle];
        };

        Heap.prototype.gethandle = function gethandle(address) {
            this.table.push(address, 0, TableSlotState.Pointer);
            var handle = this.handle;
            this.handle += 3;
            return handle;
        };

        Heap.prototype.sizeof = function sizeof(handle) {
            return -1;
        };

        Heap.prototype.free = function free(handle) {
            this.table[handle + 2] = 1;
        };

        Heap.prototype.compact = function compact() {
            var compactedSize = 0;
            var table = this.table,
                length = this.table.length,
                heap = this.heap;

            for (var i = 0; i < length; i += 3) {
                var offset = table[i];
                var size = table[i + 1];
                var state = table[i + 2];
                if (state === TableSlotState.Purged) {
                    continue;
                } else if (state === TableSlotState.Freed) {
                    // transition to "already freed"
                    // a good improvement would be to reuse
                    // these slots
                    table[i + 2] = 2;
                    compactedSize += size;
                } else if (state === TableSlotState.Allocated) {
                    for (var j = offset; j <= i + size; j++) {
                        heap[j - compactedSize] = heap[j];
                    }
                    table[i] = offset - compactedSize;
                } else if (state === TableSlotState.Pointer) {
                    table[i] = offset - compactedSize;
                }
            }
            this.offset = this.offset - compactedSize;
        };

        return Heap;
    }();
    var Program = function () {
        function Program() {
            _classCallCheck$23(this, Program);

            this.heap = new Heap();
            this._opcode = new Opcode(this.heap);
            this.constants = new Constants();
        }

        Program.prototype.opcode = function opcode(offset) {
            this._opcode.offset = offset;
            return this._opcode;
        };

        return Program;
    }();
    var Environment = function () {
        function Environment(_ref2) {
            var appendOperations = _ref2.appendOperations,
                updateOperations = _ref2.updateOperations;

            _classCallCheck$23(this, Environment);

            this._macros = null;
            this._transaction = null;
            this.program = new Program();
            this.appendOperations = appendOperations;
            this.updateOperations = updateOperations;
        }

        Environment.prototype.toConditionalReference = function toConditionalReference(reference) {
            return new ConditionalReference(reference);
        };

        Environment.prototype.getAppendOperations = function getAppendOperations() {
            return this.appendOperations;
        };

        Environment.prototype.getDOM = function getDOM() {
            return this.updateOperations;
        };

        Environment.prototype.getIdentity = function getIdentity(object) {
            return (0, _util.ensureGuid)(object) + '';
        };

        Environment.prototype.begin = function begin() {
            (0, _util.assert)(!this._transaction, 'a glimmer transaction was begun, but one already exists. You may have a nested transaction');
            this._transaction = new Transaction();
        };

        Environment.prototype.didCreate = function didCreate(component, manager) {
            this.transaction.didCreate(component, manager);
        };

        Environment.prototype.didUpdate = function didUpdate(component, manager) {
            this.transaction.didUpdate(component, manager);
        };

        Environment.prototype.scheduleInstallModifier = function scheduleInstallModifier(modifier, manager) {
            this.transaction.scheduleInstallModifier(modifier, manager);
        };

        Environment.prototype.scheduleUpdateModifier = function scheduleUpdateModifier(modifier, manager) {
            this.transaction.scheduleUpdateModifier(modifier, manager);
        };

        Environment.prototype.didDestroy = function didDestroy(d) {
            this.transaction.didDestroy(d);
        };

        Environment.prototype.commit = function commit() {
            var transaction = this.transaction;
            this._transaction = null;
            transaction.commit();
        };

        Environment.prototype.attributeFor = function attributeFor(element, attr, isTrusting, namespace) {
            return defaultManagers(element, attr, isTrusting, namespace === undefined ? null : namespace);
        };

        Environment.prototype.macros = function macros() {
            var macros = this._macros;
            if (!macros) {
                this._macros = macros = this.populateBuiltins();
            }
            return macros;
        };

        Environment.prototype.populateBuiltins = function populateBuiltins$$1() {
            return populateBuiltins();
        };

        _createClass$4(Environment, [{
            key: 'transaction',
            get: function () {
                return this._transaction;
            }
        }]);

        return Environment;
    }();

    function _defaults$15(obj, defaults) {
        var keys = Object.getOwnPropertyNames(defaults);for (var i = 0; i < keys.length; i++) {
            var key = keys[i];var value = Object.getOwnPropertyDescriptor(defaults, key);if (value && value.configurable && obj[key] === undefined) {
                Object.defineProperty(obj, key, value);
            }
        }return obj;
    }

    var _createClass$5 = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
            }
        }return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
        };
    }();

    function _possibleConstructorReturn$15(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits$15(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults$15(subClass, superClass);
    }

    function _classCallCheck$30(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var UpdatingVM = function () {
        function UpdatingVM(env, _ref) {
            var _ref$alwaysRevalidate = _ref.alwaysRevalidate,
                alwaysRevalidate = _ref$alwaysRevalidate === undefined ? false : _ref$alwaysRevalidate;

            _classCallCheck$30(this, UpdatingVM);

            this.frameStack = new _util.Stack();
            this.env = env;
            this.constants = env.program.constants;
            this.dom = env.getDOM();
            this.alwaysRevalidate = alwaysRevalidate;
        }

        UpdatingVM.prototype.execute = function execute(opcodes, handler) {
            var frameStack = this.frameStack;

            this.try(opcodes, handler);
            while (true) {
                if (frameStack.isEmpty()) break;
                var opcode = this.frame.nextStatement();
                if (opcode === null) {
                    this.frameStack.pop();
                    continue;
                }
                opcode.evaluate(this);
            }
        };

        UpdatingVM.prototype.goto = function goto(op) {
            this.frame.goto(op);
        };

        UpdatingVM.prototype.try = function _try(ops, handler) {
            this.frameStack.push(new UpdatingVMFrame(this, ops, handler));
        };

        UpdatingVM.prototype.throw = function _throw() {
            this.frame.handleException();
            this.frameStack.pop();
        };

        UpdatingVM.prototype.evaluateOpcode = function evaluateOpcode(opcode) {
            opcode.evaluate(this);
        };

        _createClass$5(UpdatingVM, [{
            key: 'frame',
            get: function () {
                return this.frameStack.current;
            }
        }]);

        return UpdatingVM;
    }();

    var BlockOpcode = function (_UpdatingOpcode) {
        _inherits$15(BlockOpcode, _UpdatingOpcode);

        function BlockOpcode(start, state, bounds$$1, children) {
            _classCallCheck$30(this, BlockOpcode);

            var _this = _possibleConstructorReturn$15(this, _UpdatingOpcode.call(this));

            _this.start = start;
            _this.type = "block";
            _this.next = null;
            _this.prev = null;
            var env = state.env,
                scope = state.scope,
                dynamicScope = state.dynamicScope,
                stack = state.stack;

            _this.children = children;
            _this.env = env;
            _this.scope = scope;
            _this.dynamicScope = dynamicScope;
            _this.stack = stack;
            _this.bounds = bounds$$1;
            return _this;
        }

        BlockOpcode.prototype.parentElement = function parentElement() {
            return this.bounds.parentElement();
        };

        BlockOpcode.prototype.firstNode = function firstNode() {
            return this.bounds.firstNode();
        };

        BlockOpcode.prototype.lastNode = function lastNode() {
            return this.bounds.lastNode();
        };

        BlockOpcode.prototype.evaluate = function evaluate(vm) {
            vm.try(this.children, null);
        };

        BlockOpcode.prototype.destroy = function destroy() {
            this.bounds.destroy();
        };

        BlockOpcode.prototype.didDestroy = function didDestroy() {
            this.env.didDestroy(this.bounds);
        };

        BlockOpcode.prototype.toJSON = function toJSON() {
            var details = (0, _util.dict)();
            details["guid"] = '' + this._guid;
            return {
                guid: this._guid,
                type: this.type,
                details: details,
                children: this.children.toArray().map(function (op) {
                    return op.toJSON();
                })
            };
        };

        return BlockOpcode;
    }(UpdatingOpcode);
    var TryOpcode = function (_BlockOpcode) {
        _inherits$15(TryOpcode, _BlockOpcode);

        function TryOpcode(start, state, bounds$$1, children) {
            _classCallCheck$30(this, TryOpcode);

            var _this2 = _possibleConstructorReturn$15(this, _BlockOpcode.call(this, start, state, bounds$$1, children));

            _this2.type = "try";
            _this2.tag = _this2._tag = _reference2.UpdatableTag.create(_reference2.CONSTANT_TAG);
            return _this2;
        }

        TryOpcode.prototype.didInitializeChildren = function didInitializeChildren() {
            this._tag.inner.update((0, _reference2.combineSlice)(this.children));
        };

        TryOpcode.prototype.evaluate = function evaluate(vm) {
            vm.try(this.children, this);
        };

        TryOpcode.prototype.handleException = function handleException() {
            var _this3 = this;

            var env = this.env,
                bounds$$1 = this.bounds,
                children = this.children,
                scope = this.scope,
                dynamicScope = this.dynamicScope,
                start = this.start,
                stack = this.stack,
                prev = this.prev,
                next = this.next;

            children.clear();
            var elementStack = ElementStack.resume(env, bounds$$1, bounds$$1.reset(env));
            var vm = new VM(env, scope, dynamicScope, elementStack);
            var updating = new _util.LinkedList();
            vm.execute(start, function (vm) {
                vm.stack = EvaluationStack.restore(stack);
                vm.updatingOpcodeStack.push(updating);
                vm.updateWith(_this3);
                vm.updatingOpcodeStack.push(children);
            });
            this.prev = prev;
            this.next = next;
        };

        TryOpcode.prototype.toJSON = function toJSON() {
            var json = _BlockOpcode.prototype.toJSON.call(this);
            var details = json["details"];
            if (!details) {
                details = json["details"] = {};
            }
            return _BlockOpcode.prototype.toJSON.call(this);
        };

        return TryOpcode;
    }(BlockOpcode);

    var ListRevalidationDelegate = function () {
        function ListRevalidationDelegate(opcode, marker) {
            _classCallCheck$30(this, ListRevalidationDelegate);

            this.opcode = opcode;
            this.marker = marker;
            this.didInsert = false;
            this.didDelete = false;
            this.map = opcode.map;
            this.updating = opcode['children'];
        }

        ListRevalidationDelegate.prototype.insert = function insert(key, item, memo, before) {
            var map$$1 = this.map,
                opcode = this.opcode,
                updating = this.updating;

            var nextSibling = null;
            var reference = null;
            if (before) {
                reference = map$$1[before];
                nextSibling = reference['bounds'].firstNode();
            } else {
                nextSibling = this.marker;
            }
            var vm = opcode.vmForInsertion(nextSibling);
            var tryOpcode = null;
            var start = opcode.start;

            vm.execute(start, function (vm) {
                map$$1[key] = tryOpcode = vm.iterate(memo, item);
                vm.updatingOpcodeStack.push(new _util.LinkedList());
                vm.updateWith(tryOpcode);
                vm.updatingOpcodeStack.push(tryOpcode.children);
            });
            updating.insertBefore(tryOpcode, reference);
            this.didInsert = true;
        };

        ListRevalidationDelegate.prototype.retain = function retain(_key, _item, _memo) {};

        ListRevalidationDelegate.prototype.move = function move$$1(key, _item, _memo, before) {
            var map$$1 = this.map,
                updating = this.updating;

            var entry = map$$1[key];
            var reference = map$$1[before] || null;
            if (before) {
                move(entry, reference.firstNode());
            } else {
                move(entry, this.marker);
            }
            updating.remove(entry);
            updating.insertBefore(entry, reference);
        };

        ListRevalidationDelegate.prototype.delete = function _delete(key) {
            var map$$1 = this.map;

            var opcode = map$$1[key];
            opcode.didDestroy();
            clear(opcode);
            this.updating.remove(opcode);
            delete map$$1[key];
            this.didDelete = true;
        };

        ListRevalidationDelegate.prototype.done = function done() {
            this.opcode.didInitializeChildren(this.didInsert || this.didDelete);
        };

        return ListRevalidationDelegate;
    }();

    var ListBlockOpcode = function (_BlockOpcode2) {
        _inherits$15(ListBlockOpcode, _BlockOpcode2);

        function ListBlockOpcode(start, state, bounds$$1, children, artifacts) {
            _classCallCheck$30(this, ListBlockOpcode);

            var _this4 = _possibleConstructorReturn$15(this, _BlockOpcode2.call(this, start, state, bounds$$1, children));

            _this4.type = "list-block";
            _this4.map = (0, _util.dict)();
            _this4.lastIterated = _reference2.INITIAL;
            _this4.artifacts = artifacts;
            var _tag = _this4._tag = _reference2.UpdatableTag.create(_reference2.CONSTANT_TAG);
            _this4.tag = (0, _reference2.combine)([artifacts.tag, _tag]);
            return _this4;
        }

        ListBlockOpcode.prototype.didInitializeChildren = function didInitializeChildren() {
            var listDidChange = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

            this.lastIterated = this.artifacts.tag.value();
            if (listDidChange) {
                this._tag.inner.update((0, _reference2.combineSlice)(this.children));
            }
        };

        ListBlockOpcode.prototype.evaluate = function evaluate(vm) {
            var artifacts = this.artifacts,
                lastIterated = this.lastIterated;

            if (!artifacts.tag.validate(lastIterated)) {
                var bounds$$1 = this.bounds;
                var dom = vm.dom;

                var marker = dom.createComment('');
                dom.insertAfter(bounds$$1.parentElement(), marker, bounds$$1.lastNode());
                var target = new ListRevalidationDelegate(this, marker);
                var synchronizer = new _reference2.IteratorSynchronizer({ target: target, artifacts: artifacts });
                synchronizer.sync();
                this.parentElement().removeChild(marker);
            }
            // Run now-updated updating opcodes
            _BlockOpcode2.prototype.evaluate.call(this, vm);
        };

        ListBlockOpcode.prototype.vmForInsertion = function vmForInsertion(nextSibling) {
            var env = this.env,
                scope = this.scope,
                dynamicScope = this.dynamicScope;

            var elementStack = ElementStack.forInitialRender(this.env, this.bounds.parentElement(), nextSibling);
            return new VM(env, scope, dynamicScope, elementStack);
        };

        ListBlockOpcode.prototype.toJSON = function toJSON() {
            var json = _BlockOpcode2.prototype.toJSON.call(this);
            var map$$1 = this.map;
            var inner = Object.keys(map$$1).map(function (key) {
                return JSON.stringify(key) + ': ' + map$$1[key]._guid;
            }).join(", ");
            var details = json["details"];
            if (!details) {
                details = json["details"] = {};
            }
            details["map"] = '{' + inner + '}';
            return json;
        };

        return ListBlockOpcode;
    }(BlockOpcode);

    var UpdatingVMFrame = function () {
        function UpdatingVMFrame(vm, ops, exceptionHandler) {
            _classCallCheck$30(this, UpdatingVMFrame);

            this.vm = vm;
            this.ops = ops;
            this.exceptionHandler = exceptionHandler;
            this.vm = vm;
            this.ops = ops;
            this.current = ops.head();
        }

        UpdatingVMFrame.prototype.goto = function goto(op) {
            this.current = op;
        };

        UpdatingVMFrame.prototype.nextStatement = function nextStatement() {
            var current = this.current,
                ops = this.ops;

            if (current) this.current = ops.nextNode(current);
            return current;
        };

        UpdatingVMFrame.prototype.handleException = function handleException() {
            if (this.exceptionHandler) {
                this.exceptionHandler.handleException();
            }
        };

        return UpdatingVMFrame;
    }();

    function _classCallCheck$31(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var RenderResult = function () {
        function RenderResult(env, updating, bounds$$1) {
            _classCallCheck$31(this, RenderResult);

            this.env = env;
            this.updating = updating;
            this.bounds = bounds$$1;
        }

        RenderResult.prototype.rerender = function rerender() {
            var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : { alwaysRevalidate: false },
                _ref$alwaysRevalidate = _ref.alwaysRevalidate,
                alwaysRevalidate = _ref$alwaysRevalidate === undefined ? false : _ref$alwaysRevalidate;

            var env = this.env,
                updating = this.updating;

            var vm = new UpdatingVM(env, { alwaysRevalidate: alwaysRevalidate });
            vm.execute(updating, this);
        };

        RenderResult.prototype.parentElement = function parentElement() {
            return this.bounds.parentElement();
        };

        RenderResult.prototype.firstNode = function firstNode() {
            return this.bounds.firstNode();
        };

        RenderResult.prototype.lastNode = function lastNode() {
            return this.bounds.lastNode();
        };

        RenderResult.prototype.opcodes = function opcodes() {
            return this.updating;
        };

        RenderResult.prototype.handleException = function handleException() {
            throw "this should never happen";
        };

        RenderResult.prototype.destroy = function destroy() {
            this.bounds.destroy();
            clear(this.bounds);
        };

        return RenderResult;
    }();

    var _createClass$3 = function () {
        function defineProperties(target, props) {
            for (var i = 0; i < props.length; i++) {
                var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
            }
        }return function (Constructor, protoProps, staticProps) {
            if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
        };
    }();

    function _classCallCheck$22(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var EvaluationStack = function () {
        function EvaluationStack(stack, fp, sp) {
            _classCallCheck$22(this, EvaluationStack);

            this.stack = stack;
            this.fp = fp;
            this.sp = sp;
        }

        EvaluationStack.empty = function empty() {
            return new this([], 0, -1);
        };

        EvaluationStack.restore = function restore(snapshot) {
            return new this(snapshot.slice(), 0, snapshot.length - 1);
        };

        EvaluationStack.prototype.isEmpty = function isEmpty() {
            return this.sp === -1;
        };

        EvaluationStack.prototype.push = function push(value) {
            this.stack[++this.sp] = value;
        };

        EvaluationStack.prototype.dup = function dup() {
            var position = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.sp;

            this.push(this.stack[position]);
        };

        EvaluationStack.prototype.pop = function pop() {
            var n = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;

            var top = this.stack[this.sp];
            this.sp -= n;
            return top;
        };

        EvaluationStack.prototype.peek = function peek() {
            return this.stack[this.sp];
        };

        EvaluationStack.prototype.fromBase = function fromBase(offset) {
            return this.stack[this.fp - offset];
        };

        EvaluationStack.prototype.fromTop = function fromTop(offset) {
            return this.stack[this.sp - offset];
        };

        EvaluationStack.prototype.capture = function capture(items) {
            var end = this.sp + 1;
            var start = end - items;
            return this.stack.slice(start, end);
        };

        EvaluationStack.prototype.reset = function reset() {
            this.stack.length = 0;
        };

        EvaluationStack.prototype.toArray = function toArray() {
            return this.stack.slice(this.fp, this.sp + 1);
        };

        return EvaluationStack;
    }();

    var VM = function () {
        function VM(env, scope, dynamicScope, elementStack) {
            _classCallCheck$22(this, VM);

            this.env = env;
            this.elementStack = elementStack;
            this.dynamicScopeStack = new _util.Stack();
            this.scopeStack = new _util.Stack();
            this.updatingOpcodeStack = new _util.Stack();
            this.cacheGroups = new _util.Stack();
            this.listBlockStack = new _util.Stack();
            this.stack = EvaluationStack.empty();
            /* Registers */
            this.pc = -1;
            this.ra = -1;
            this.s0 = null;
            this.s1 = null;
            this.t0 = null;
            this.t1 = null;
            this.env = env;
            this.heap = env.program.heap;
            this.constants = env.program.constants;
            this.elementStack = elementStack;
            this.scopeStack.push(scope);
            this.dynamicScopeStack.push(dynamicScope);
        }

        // Fetch a value from a register onto the stack
        VM.prototype.fetch = function fetch(register) {
            this.stack.push(this[Register[register]]);
        };
        // Load a value from the stack into a register


        VM.prototype.load = function load(register) {
            this[Register[register]] = this.stack.pop();
        };
        // Fetch a value from a register


        VM.prototype.fetchValue = function fetchValue(register) {
            return this[Register[register]];
        };
        // Load a value into a register


        VM.prototype.loadValue = function loadValue(register, value) {
            this[Register[register]] = value;
        };
        // Start a new frame and save $ra and $fp on the stack


        VM.prototype.pushFrame = function pushFrame() {
            this.stack.push(this.ra);
            this.stack.push(this.fp);
            this.fp = this.sp - 1;
        };
        // Restore $ra, $sp and $fp


        VM.prototype.popFrame = function popFrame() {
            this.sp = this.fp - 1;
            this.ra = this.stack.fromBase(0);
            this.fp = this.stack.fromBase(-1);
        };
        // Jump to an address in `program`


        VM.prototype.goto = function goto(offset) {
            this.pc = (0, _util.typePos)(this.pc + offset);
        };
        // Save $pc into $ra, then jump to a new address in `program` (jal in MIPS)


        VM.prototype.call = function call(handle) {
            var pc = this.heap.getaddr(handle);
            this.ra = this.pc;
            this.pc = pc;
        };
        // Put a specific `program` address in $ra


        VM.prototype.returnTo = function returnTo(offset) {
            this.ra = (0, _util.typePos)(this.pc + offset);
        };
        // Return to the `program` address stored in $ra


        VM.prototype.return = function _return() {
            this.pc = this.ra;
        };

        VM.initial = function initial(env, self, dynamicScope, elementStack, program) {
            var scope = Scope.root(self, program.symbolTable.symbols.length);
            var vm = new VM(env, scope, dynamicScope, elementStack);
            vm.pc = vm.heap.getaddr(program.handle);
            vm.updatingOpcodeStack.push(new _util.LinkedList());
            return vm;
        };

        VM.prototype.capture = function capture(args) {
            return {
                dynamicScope: this.dynamicScope(),
                env: this.env,
                scope: this.scope(),
                stack: this.stack.capture(args)
            };
        };

        VM.prototype.beginCacheGroup = function beginCacheGroup() {
            this.cacheGroups.push(this.updating().tail());
        };

        VM.prototype.commitCacheGroup = function commitCacheGroup() {
            //        JumpIfNotModified(END)
            //        (head)
            //        (....)
            //        (tail)
            //        DidModify
            // END:   Noop
            var END = new LabelOpcode("END");
            var opcodes = this.updating();
            var marker = this.cacheGroups.pop();
            var head = marker ? opcodes.nextNode(marker) : opcodes.head();
            var tail = opcodes.tail();
            var tag = (0, _reference2.combineSlice)(new _util.ListSlice(head, tail));
            var guard = new JumpIfNotModifiedOpcode(tag, END);
            opcodes.insertBefore(guard, head);
            opcodes.append(new DidModifyOpcode(guard));
            opcodes.append(END);
        };

        VM.prototype.enter = function enter(args) {
            var updating = new _util.LinkedList();
            var state = this.capture(args);
            var tracker = this.elements().pushUpdatableBlock();
            var tryOpcode = new TryOpcode(this.heap.gethandle(this.pc), state, tracker, updating);
            this.didEnter(tryOpcode);
        };

        VM.prototype.iterate = function iterate(memo, value) {
            var stack = this.stack;
            stack.push(value);
            stack.push(memo);
            var state = this.capture(2);
            var tracker = this.elements().pushUpdatableBlock();
            // let ip = this.ip;
            // this.ip = end + 4;
            // this.frames.push(ip);
            return new TryOpcode(this.heap.gethandle(this.pc), state, tracker, new _util.LinkedList());
        };

        VM.prototype.enterItem = function enterItem(key, opcode) {
            this.listBlock().map[key] = opcode;
            this.didEnter(opcode);
        };

        VM.prototype.enterList = function enterList(relativeStart) {
            var updating = new _util.LinkedList();
            var state = this.capture(0);
            var tracker = this.elements().pushBlockList(updating);
            var artifacts = this.stack.peek().artifacts;
            var start = this.heap.gethandle((0, _util.typePos)(this.pc + relativeStart));
            var opcode = new ListBlockOpcode(start, state, tracker, updating, artifacts);
            this.listBlockStack.push(opcode);
            this.didEnter(opcode);
        };

        VM.prototype.didEnter = function didEnter(opcode) {
            this.updateWith(opcode);
            this.updatingOpcodeStack.push(opcode.children);
        };

        VM.prototype.exit = function exit() {
            this.elements().popBlock();
            this.updatingOpcodeStack.pop();
            var parent = this.updating().tail();
            parent.didInitializeChildren();
        };

        VM.prototype.exitList = function exitList() {
            this.exit();
            this.listBlockStack.pop();
        };

        VM.prototype.updateWith = function updateWith(opcode) {
            this.updating().append(opcode);
        };

        VM.prototype.listBlock = function listBlock() {
            return this.listBlockStack.current;
        };

        VM.prototype.updating = function updating() {
            return this.updatingOpcodeStack.current;
        };

        VM.prototype.elements = function elements() {
            return this.elementStack;
        };

        VM.prototype.scope = function scope() {
            return this.scopeStack.current;
        };

        VM.prototype.dynamicScope = function dynamicScope() {
            return this.dynamicScopeStack.current;
        };

        VM.prototype.pushChildScope = function pushChildScope() {
            this.scopeStack.push(this.scope().child());
        };

        VM.prototype.pushCallerScope = function pushCallerScope() {
            var childScope = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

            var callerScope = this.scope().getCallerScope();
            this.scopeStack.push(childScope ? callerScope.child() : callerScope);
        };

        VM.prototype.pushDynamicScope = function pushDynamicScope() {
            var child = this.dynamicScope().child();
            this.dynamicScopeStack.push(child);
            return child;
        };

        VM.prototype.pushRootScope = function pushRootScope(size, bindCaller) {
            var scope = Scope.sized(size);
            if (bindCaller) scope.bindCallerScope(this.scope());
            this.scopeStack.push(scope);
            return scope;
        };

        VM.prototype.popScope = function popScope() {
            this.scopeStack.pop();
        };

        VM.prototype.popDynamicScope = function popDynamicScope() {
            this.dynamicScopeStack.pop();
        };

        VM.prototype.newDestroyable = function newDestroyable(d) {
            this.elements().newDestroyable(d);
        };
        /// SCOPE HELPERS


        VM.prototype.getSelf = function getSelf() {
            return this.scope().getSelf();
        };

        VM.prototype.referenceForSymbol = function referenceForSymbol(symbol) {
            return this.scope().getSymbol(symbol);
        };
        /// EXECUTION


        VM.prototype.execute = function execute(start, initialize) {
            this.pc = this.heap.getaddr(start);
            if (initialize) initialize(this);
            var result = void 0;
            while (true) {
                result = this.next();
                if (result.done) break;
            }
            return result.value;
        };

        VM.prototype.next = function next() {
            var env = this.env,
                updatingOpcodeStack = this.updatingOpcodeStack,
                elementStack = this.elementStack;

            var opcode = this.nextStatement(env);
            var result = void 0;
            if (opcode !== null) {
                APPEND_OPCODES.evaluate(this, opcode, opcode.type);
                result = { done: false, value: null };
            } else {
                // Unload the stack
                this.stack.reset();
                result = {
                    done: true,
                    value: new RenderResult(env, updatingOpcodeStack.pop(), elementStack.popBlock())
                };
            }
            return result;
        };

        VM.prototype.nextStatement = function nextStatement(env) {
            var pc = this.pc;

            if (pc === -1) {
                return null;
            }
            var program = env.program;
            this.pc += 4;
            return program.opcode(pc);
        };

        VM.prototype.evaluateOpcode = function evaluateOpcode(opcode) {
            APPEND_OPCODES.evaluate(this, opcode, opcode.type);
        };

        VM.prototype.bindDynamicScope = function bindDynamicScope(names) {
            var scope = this.dynamicScope();
            for (var i = names.length - 1; i >= 0; i--) {
                var name = this.constants.getString(names[i]);
                scope.set(name, this.stack.pop());
            }
        };

        _createClass$3(VM, [{
            key: 'fp',
            get: function () {
                return this.stack.fp;
            },
            set: function (fp) {
                this.stack.fp = fp;
            }
        }, {
            key: 'sp',
            get: function () {
                return this.stack.sp;
            },
            set: function (sp) {
                this.stack.sp = sp;
            }
        }]);

        return VM;
    }();

    function _classCallCheck$14(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var TemplateIterator = function () {
        function TemplateIterator(vm) {
            _classCallCheck$14(this, TemplateIterator);

            this.vm = vm;
        }

        TemplateIterator.prototype.next = function next() {
            return this.vm.next();
        };

        return TemplateIterator;
    }();
    var clientId = 0;
    function templateFactory(_ref) {
        var templateId = _ref.id,
            meta = _ref.meta,
            block = _ref.block;

        var parsedBlock = void 0;
        var id = templateId || 'client-' + clientId++;
        var create = function (env, envMeta) {
            var newMeta = envMeta ? (0, _util.assign)({}, envMeta, meta) : meta;
            if (!parsedBlock) {
                parsedBlock = JSON.parse(block);
            }
            return new ScannableTemplate(id, newMeta, env, parsedBlock);
        };
        return { id: id, meta: meta, create: create };
    }

    var ScannableTemplate = function () {
        function ScannableTemplate(id, meta, env, rawBlock) {
            _classCallCheck$14(this, ScannableTemplate);

            this.id = id;
            this.meta = meta;
            this.env = env;
            this.entryPoint = null;
            this.layout = null;
            this.partial = null;
            this.block = null;
            this.scanner = new Scanner(rawBlock, env);
            this.symbols = rawBlock.symbols;
            this.hasEval = rawBlock.hasEval;
        }

        ScannableTemplate.prototype.render = function render(self, appendTo, dynamicScope) {
            var env = this.env;

            var elementStack = ElementStack.forInitialRender(env, appendTo, null);
            var compiled = this.asEntryPoint().compileDynamic(env);
            var vm = VM.initial(env, self, dynamicScope, elementStack, compiled);
            return new TemplateIterator(vm);
        };

        ScannableTemplate.prototype.asEntryPoint = function asEntryPoint() {
            if (!this.entryPoint) this.entryPoint = this.scanner.scanEntryPoint(this.compilationMeta());
            return this.entryPoint;
        };

        ScannableTemplate.prototype.asLayout = function asLayout(componentName, attrs) {
            if (!this.layout) this.layout = this.scanner.scanLayout(this.compilationMeta(), attrs || _util.EMPTY_ARRAY, componentName);
            return this.layout;
        };

        ScannableTemplate.prototype.asPartial = function asPartial() {
            if (!this.partial) this.partial = this.scanner.scanEntryPoint(this.compilationMeta(true));
            return this.partial;
        };

        ScannableTemplate.prototype.asBlock = function asBlock() {
            if (!this.block) this.block = this.scanner.scanBlock(this.compilationMeta());
            return this.block;
        };

        ScannableTemplate.prototype.compilationMeta = function compilationMeta() {
            var asPartial = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

            return { templateMeta: this.meta, symbols: this.symbols, asPartial: asPartial };
        };

        return ScannableTemplate;
    }();

    function _classCallCheck$32(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var DynamicVarReference = function () {
        function DynamicVarReference(scope, nameRef) {
            _classCallCheck$32(this, DynamicVarReference);

            this.scope = scope;
            this.nameRef = nameRef;
            var varTag = this.varTag = _reference2.UpdatableTag.create(_reference2.CONSTANT_TAG);
            this.tag = (0, _reference2.combine)([nameRef.tag, varTag]);
        }

        DynamicVarReference.prototype.value = function value() {
            return this.getVar().value();
        };

        DynamicVarReference.prototype.get = function get(key) {
            return this.getVar().get(key);
        };

        DynamicVarReference.prototype.getVar = function getVar() {
            var name = String(this.nameRef.value());
            var ref = this.scope.get(name);
            this.varTag.inner.update(ref.tag);
            return ref;
        };

        return DynamicVarReference;
    }();

    function getDynamicVar(vm, args) {
        var scope = vm.dynamicScope();
        var nameRef = args.positional.at(0);
        return new DynamicVarReference(scope, nameRef);
    }

    function _classCallCheck$33(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var PartialDefinition = function PartialDefinition(name, // for debugging
    template) {
        _classCallCheck$33(this, PartialDefinition);

        this.name = name;
        this.template = template;
    };

    var NodeType;
    (function (NodeType) {
        NodeType[NodeType["Element"] = 0] = "Element";
        NodeType[NodeType["Attribute"] = 1] = "Attribute";
        NodeType[NodeType["Text"] = 2] = "Text";
        NodeType[NodeType["CdataSection"] = 3] = "CdataSection";
        NodeType[NodeType["EntityReference"] = 4] = "EntityReference";
        NodeType[NodeType["Entity"] = 5] = "Entity";
        NodeType[NodeType["ProcessingInstruction"] = 6] = "ProcessingInstruction";
        NodeType[NodeType["Comment"] = 7] = "Comment";
        NodeType[NodeType["Document"] = 8] = "Document";
        NodeType[NodeType["DocumentType"] = 9] = "DocumentType";
        NodeType[NodeType["DocumentFragment"] = 10] = "DocumentFragment";
        NodeType[NodeType["Notation"] = 11] = "Notation";
    })(NodeType || (NodeType = {}));

    var interfaces = Object.freeze({
        get NodeType() {
            return NodeType;
        }
    });

    exports.Simple = interfaces;
    exports.templateFactory = templateFactory;
    exports.NULL_REFERENCE = NULL_REFERENCE;
    exports.UNDEFINED_REFERENCE = UNDEFINED_REFERENCE;
    exports.PrimitiveReference = PrimitiveReference;
    exports.ConditionalReference = ConditionalReference;
    exports.OpcodeBuilderDSL = OpcodeBuilder;
    exports.compileLayout = compileLayout;
    exports.CompiledStaticTemplate = CompiledStaticTemplate;
    exports.CompiledDynamicTemplate = CompiledDynamicTemplate;
    exports.IAttributeManager = AttributeManager;
    exports.AttributeManager = AttributeManager;
    exports.PropertyManager = PropertyManager;
    exports.INPUT_VALUE_PROPERTY_MANAGER = INPUT_VALUE_PROPERTY_MANAGER;
    exports.defaultManagers = defaultManagers;
    exports.defaultAttributeManagers = defaultAttributeManagers;
    exports.defaultPropertyManagers = defaultPropertyManagers;
    exports.readDOMAttr = readDOMAttr;
    exports.Register = Register;
    exports.debugSlice = debugSlice;
    exports.normalizeTextValue = normalizeTextValue;
    exports.setDebuggerCallback = setDebuggerCallback;
    exports.resetDebuggerCallback = resetDebuggerCallback;
    exports.getDynamicVar = getDynamicVar;
    exports.BlockMacros = Blocks;
    exports.InlineMacros = Inlines;
    exports.compileList = compileList;
    exports.compileExpression = expr;
    exports.UpdatingVM = UpdatingVM;
    exports.RenderResult = RenderResult;
    exports.isSafeString = isSafeString;
    exports.Scope = Scope;
    exports.Environment = Environment;
    exports.PartialDefinition = PartialDefinition;
    exports.ComponentDefinition = ComponentDefinition;
    exports.isComponentDefinition = isComponentDefinition;
    exports.DOMChanges = helper$1;
    exports.IDOMChanges = DOMChanges;
    exports.DOMTreeConstruction = DOMTreeConstruction;
    exports.isWhitespace = isWhitespace;
    exports.insertHTMLBefore = _insertHTMLBefore;
    exports.ElementStack = ElementStack;
    exports.ConcreteBounds = ConcreteBounds;
});
enifed('@glimmer/util', ['exports'], function (exports) {
    'use strict';

    // There is a small whitelist of namespaced attributes specially
    // enumerated in
    // https://www.w3.org/TR/html/syntax.html#attributes-0
    //
    // > When a foreign element has one of the namespaced attributes given by
    // > the local name and namespace of the first and second cells of a row
    // > from the following table, it must be written using the name given by
    // > the third cell from the same row.
    //
    // In all other cases, colons are interpreted as a regular character
    // with no special meaning:
    //
    // > No other namespaced attribute can be expressed in the HTML syntax.
    var XLINK = 'http://www.w3.org/1999/xlink';
    var XML = 'http://www.w3.org/XML/1998/namespace';
    var XMLNS = 'http://www.w3.org/2000/xmlns/';
    var WHITELIST = {
        'xlink:actuate': XLINK,
        'xlink:arcrole': XLINK,
        'xlink:href': XLINK,
        'xlink:role': XLINK,
        'xlink:show': XLINK,
        'xlink:title': XLINK,
        'xlink:type': XLINK,
        'xml:base': XML,
        'xml:lang': XML,
        'xml:space': XML,
        'xmlns': XMLNS,
        'xmlns:xlink': XMLNS
    };
    function getAttrNamespace(attrName) {
        return WHITELIST[attrName] || null;
    }

    function unwrap(val) {
        if (val === null || val === undefined) throw new Error('Expected value to be present');
        return val;
    }
    function expect(val, message) {
        if (val === null || val === undefined) throw new Error(message);
        return val;
    }
    function unreachable() {
        return new Error('unreachable');
    }
    function typePos(lastOperand) {
        return lastOperand - 4;
    }

    // import Logger from './logger';
    // let alreadyWarned = false;
    // import Logger from './logger';
    function debugAssert(test, msg) {
        // if (!alreadyWarned) {
        //   alreadyWarned = true;
        //   Logger.warn("Don't leave debug assertions on in public builds");
        // }
        if (!test) {
            throw new Error(msg || "assertion failure");
        }
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var LogLevel;
    (function (LogLevel) {
        LogLevel[LogLevel["Trace"] = 0] = "Trace";
        LogLevel[LogLevel["Debug"] = 1] = "Debug";
        LogLevel[LogLevel["Warn"] = 2] = "Warn";
        LogLevel[LogLevel["Error"] = 3] = "Error";
    })(LogLevel || (exports.LogLevel = LogLevel = {}));

    var NullConsole = function () {
        function NullConsole() {
            _classCallCheck(this, NullConsole);
        }

        NullConsole.prototype.log = function log(_message) {};

        NullConsole.prototype.warn = function warn(_message) {};

        NullConsole.prototype.error = function error(_message) {};

        NullConsole.prototype.trace = function trace() {};

        return NullConsole;
    }();

    var ALWAYS = void 0;
    var Logger = function () {
        function Logger(_ref) {
            var console = _ref.console,
                level = _ref.level;

            _classCallCheck(this, Logger);

            this.f = ALWAYS;
            this.force = ALWAYS;
            this.console = console;
            this.level = level;
        }

        Logger.prototype.skipped = function skipped(level) {
            return level < this.level;
        };

        Logger.prototype.trace = function trace(message) {
            var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
                _ref2$stackTrace = _ref2.stackTrace,
                stackTrace = _ref2$stackTrace === undefined ? false : _ref2$stackTrace;

            if (this.skipped(LogLevel.Trace)) return;
            this.console.log(message);
            if (stackTrace) this.console.trace();
        };

        Logger.prototype.debug = function debug(message) {
            var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
                _ref3$stackTrace = _ref3.stackTrace,
                stackTrace = _ref3$stackTrace === undefined ? false : _ref3$stackTrace;

            if (this.skipped(LogLevel.Debug)) return;
            this.console.log(message);
            if (stackTrace) this.console.trace();
        };

        Logger.prototype.warn = function warn(message) {
            var _ref4 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
                _ref4$stackTrace = _ref4.stackTrace,
                stackTrace = _ref4$stackTrace === undefined ? false : _ref4$stackTrace;

            if (this.skipped(LogLevel.Warn)) return;
            this.console.warn(message);
            if (stackTrace) this.console.trace();
        };

        Logger.prototype.error = function error(message) {
            if (this.skipped(LogLevel.Error)) return;
            this.console.error(message);
        };

        return Logger;
    }();
    var _console = typeof console === 'undefined' ? new NullConsole() : console;
    ALWAYS = new Logger({ console: _console, level: LogLevel.Trace });
    var LOG_LEVEL = LogLevel.Debug;
    var logger = new Logger({ console: _console, level: LOG_LEVEL });

    var objKeys = Object.keys;

    function assign(obj) {
        for (var i = 1; i < arguments.length; i++) {
            var assignment = arguments[i];
            if (assignment === null || typeof assignment !== 'object') continue;
            var keys = objKeys(assignment);
            for (var j = 0; j < keys.length; j++) {
                var key = keys[j];
                obj[key] = assignment[key];
            }
        }
        return obj;
    }
    function fillNulls(count) {
        var arr = new Array(count);
        for (var i = 0; i < count; i++) {
            arr[i] = null;
        }
        return arr;
    }

    var GUID = 0;
    function initializeGuid(object) {
        return object._guid = ++GUID;
    }
    function ensureGuid(object) {
        return object._guid || initializeGuid(object);
    }

    function _classCallCheck$1(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var proto = Object.create(null, {
        // without this, we will always still end up with (new
        // EmptyObject()).constructor === Object
        constructor: {
            value: undefined,
            enumerable: false,
            writable: true
        }
    });
    function EmptyObject() {}
    EmptyObject.prototype = proto;
    function dict() {
        // let d = Object.create(null);
        // d.x = 1;
        // delete d.x;
        // return d;
        return new EmptyObject();
    }
    var DictSet = function () {
        function DictSet() {
            _classCallCheck$1(this, DictSet);

            this.dict = dict();
        }

        DictSet.prototype.add = function add(obj) {
            if (typeof obj === 'string') this.dict[obj] = obj;else this.dict[ensureGuid(obj)] = obj;
            return this;
        };

        DictSet.prototype.delete = function _delete(obj) {
            if (typeof obj === 'string') delete this.dict[obj];else if (obj._guid) delete this.dict[obj._guid];
        };

        DictSet.prototype.forEach = function forEach(callback) {
            var dict = this.dict;

            var dictKeys = Object.keys(dict);
            for (var i = 0; dictKeys.length; i++) {
                callback(dict[dictKeys[i]]);
            }
        };

        DictSet.prototype.toArray = function toArray() {
            return Object.keys(this.dict);
        };

        return DictSet;
    }();
    var Stack = function () {
        function Stack() {
            _classCallCheck$1(this, Stack);

            this.stack = [];
            this.current = null;
        }

        Stack.prototype.toArray = function toArray() {
            return this.stack;
        };

        Stack.prototype.push = function push(item) {
            this.current = item;
            this.stack.push(item);
        };

        Stack.prototype.pop = function pop() {
            var item = this.stack.pop();
            var len = this.stack.length;
            this.current = len === 0 ? null : this.stack[len - 1];
            return item === undefined ? null : item;
        };

        Stack.prototype.isEmpty = function isEmpty() {
            return this.stack.length === 0;
        };

        return Stack;
    }();

    function _classCallCheck$2(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    var ListNode = function ListNode(value) {
        _classCallCheck$2(this, ListNode);

        this.next = null;
        this.prev = null;
        this.value = value;
    };
    var LinkedList = function () {
        function LinkedList() {
            _classCallCheck$2(this, LinkedList);

            this.clear();
        }

        LinkedList.fromSlice = function fromSlice(slice) {
            var list = new LinkedList();
            slice.forEachNode(function (n) {
                return list.append(n.clone());
            });
            return list;
        };

        LinkedList.prototype.head = function head() {
            return this._head;
        };

        LinkedList.prototype.tail = function tail() {
            return this._tail;
        };

        LinkedList.prototype.clear = function clear() {
            this._head = this._tail = null;
        };

        LinkedList.prototype.isEmpty = function isEmpty() {
            return this._head === null;
        };

        LinkedList.prototype.toArray = function toArray() {
            var out = [];
            this.forEachNode(function (n) {
                return out.push(n);
            });
            return out;
        };

        LinkedList.prototype.splice = function splice(start, end, reference) {
            var before = void 0;
            if (reference === null) {
                before = this._tail;
                this._tail = end;
            } else {
                before = reference.prev;
                end.next = reference;
                reference.prev = end;
            }
            if (before) {
                before.next = start;
                start.prev = before;
            }
        };

        LinkedList.prototype.nextNode = function nextNode(node) {
            return node.next;
        };

        LinkedList.prototype.prevNode = function prevNode(node) {
            return node.prev;
        };

        LinkedList.prototype.forEachNode = function forEachNode(callback) {
            var node = this._head;
            while (node !== null) {
                callback(node);
                node = node.next;
            }
        };

        LinkedList.prototype.contains = function contains(needle) {
            var node = this._head;
            while (node !== null) {
                if (node === needle) return true;
                node = node.next;
            }
            return false;
        };

        LinkedList.prototype.insertBefore = function insertBefore(node) {
            var reference = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

            if (reference === null) return this.append(node);
            if (reference.prev) reference.prev.next = node;else this._head = node;
            node.prev = reference.prev;
            node.next = reference;
            reference.prev = node;
            return node;
        };

        LinkedList.prototype.append = function append(node) {
            var tail = this._tail;
            if (tail) {
                tail.next = node;
                node.prev = tail;
                node.next = null;
            } else {
                this._head = node;
            }
            return this._tail = node;
        };

        LinkedList.prototype.pop = function pop() {
            if (this._tail) return this.remove(this._tail);
            return null;
        };

        LinkedList.prototype.prepend = function prepend(node) {
            if (this._head) return this.insertBefore(node, this._head);
            return this._head = this._tail = node;
        };

        LinkedList.prototype.remove = function remove(node) {
            if (node.prev) node.prev.next = node.next;else this._head = node.next;
            if (node.next) node.next.prev = node.prev;else this._tail = node.prev;
            return node;
        };

        return LinkedList;
    }();
    var ListSlice = function () {
        function ListSlice(head, tail) {
            _classCallCheck$2(this, ListSlice);

            this._head = head;
            this._tail = tail;
        }

        ListSlice.toList = function toList(slice) {
            var list = new LinkedList();
            slice.forEachNode(function (n) {
                return list.append(n.clone());
            });
            return list;
        };

        ListSlice.prototype.forEachNode = function forEachNode(callback) {
            var node = this._head;
            while (node !== null) {
                callback(node);
                node = this.nextNode(node);
            }
        };

        ListSlice.prototype.contains = function contains(needle) {
            var node = this._head;
            while (node !== null) {
                if (node === needle) return true;
                node = node.next;
            }
            return false;
        };

        ListSlice.prototype.head = function head() {
            return this._head;
        };

        ListSlice.prototype.tail = function tail() {
            return this._tail;
        };

        ListSlice.prototype.toArray = function toArray() {
            var out = [];
            this.forEachNode(function (n) {
                return out.push(n);
            });
            return out;
        };

        ListSlice.prototype.nextNode = function nextNode(node) {
            if (node === this._tail) return null;
            return node.next;
        };

        ListSlice.prototype.prevNode = function prevNode(node) {
            if (node === this._head) return null;
            return node.prev;
        };

        ListSlice.prototype.isEmpty = function isEmpty() {
            return false;
        };

        return ListSlice;
    }();
    var EMPTY_SLICE = new ListSlice(null, null);

    var HAS_NATIVE_WEAKMAP = function () {
        // detect if `WeakMap` is even present
        var hasWeakMap = typeof WeakMap === 'function';
        if (!hasWeakMap) {
            return false;
        }
        var instance = new WeakMap();
        // use `Object`'s `.toString` directly to prevent us from detecting
        // polyfills as native weakmaps
        return Object.prototype.toString.call(instance) === '[object WeakMap]';
    }();

    var HAS_TYPED_ARRAYS = typeof Uint32Array !== 'undefined';
    var A = void 0;
    if (HAS_TYPED_ARRAYS) {
        A = Uint32Array;
    } else {
        A = Array;
    }
    var A$1 = A;
    var EMPTY_ARRAY = HAS_NATIVE_WEAKMAP ? Object.freeze([]) : [];

    exports.getAttrNamespace = getAttrNamespace;
    exports.assert = debugAssert;
    exports.LOGGER = logger;
    exports.Logger = Logger;
    exports.LogLevel = LogLevel;
    exports.assign = assign;
    exports.fillNulls = fillNulls;
    exports.ensureGuid = ensureGuid;
    exports.initializeGuid = initializeGuid;
    exports.Stack = Stack;
    exports.DictSet = DictSet;
    exports.dict = dict;
    exports.EMPTY_SLICE = EMPTY_SLICE;
    exports.LinkedList = LinkedList;
    exports.ListNode = ListNode;
    exports.ListSlice = ListSlice;
    exports.A = A$1;
    exports.EMPTY_ARRAY = EMPTY_ARRAY;
    exports.HAS_NATIVE_WEAKMAP = HAS_NATIVE_WEAKMAP;
    exports.unwrap = unwrap;
    exports.expect = expect;
    exports.unreachable = unreachable;
    exports.typePos = typePos;
});
enifed("@glimmer/wire-format", ["exports"], function (exports) {
    "use strict";

    var Opcodes;
    (function (Opcodes) {
        // Statements
        Opcodes[Opcodes["Text"] = 0] = "Text";
        Opcodes[Opcodes["Append"] = 1] = "Append";
        Opcodes[Opcodes["Comment"] = 2] = "Comment";
        Opcodes[Opcodes["Modifier"] = 3] = "Modifier";
        Opcodes[Opcodes["Block"] = 4] = "Block";
        Opcodes[Opcodes["Component"] = 5] = "Component";
        Opcodes[Opcodes["OpenElement"] = 6] = "OpenElement";
        Opcodes[Opcodes["FlushElement"] = 7] = "FlushElement";
        Opcodes[Opcodes["CloseElement"] = 8] = "CloseElement";
        Opcodes[Opcodes["StaticAttr"] = 9] = "StaticAttr";
        Opcodes[Opcodes["DynamicAttr"] = 10] = "DynamicAttr";
        Opcodes[Opcodes["Yield"] = 11] = "Yield";
        Opcodes[Opcodes["Partial"] = 12] = "Partial";
        Opcodes[Opcodes["DynamicArg"] = 13] = "DynamicArg";
        Opcodes[Opcodes["StaticArg"] = 14] = "StaticArg";
        Opcodes[Opcodes["TrustingAttr"] = 15] = "TrustingAttr";
        Opcodes[Opcodes["Debugger"] = 16] = "Debugger";
        Opcodes[Opcodes["ClientSideStatement"] = 17] = "ClientSideStatement";
        // Expressions
        Opcodes[Opcodes["Unknown"] = 18] = "Unknown";
        Opcodes[Opcodes["Get"] = 19] = "Get";
        Opcodes[Opcodes["MaybeLocal"] = 20] = "MaybeLocal";
        Opcodes[Opcodes["FixThisBeforeWeMerge"] = 21] = "FixThisBeforeWeMerge";
        Opcodes[Opcodes["HasBlock"] = 22] = "HasBlock";
        Opcodes[Opcodes["HasBlockParams"] = 23] = "HasBlockParams";
        Opcodes[Opcodes["Undefined"] = 24] = "Undefined";
        Opcodes[Opcodes["Helper"] = 25] = "Helper";
        Opcodes[Opcodes["Concat"] = 26] = "Concat";
        Opcodes[Opcodes["ClientSideExpression"] = 27] = "ClientSideExpression";
    })(Opcodes || (exports.Ops = Opcodes = {}));

    function is(variant) {
        return function (value) {
            return Array.isArray(value) && value[0] === variant;
        };
    }
    var Expressions;
    (function (Expressions) {
        Expressions.isUnknown = is(Opcodes.Unknown);
        Expressions.isGet = is(Opcodes.Get);
        Expressions.isConcat = is(Opcodes.Concat);
        Expressions.isHelper = is(Opcodes.Helper);
        Expressions.isHasBlock = is(Opcodes.HasBlock);
        Expressions.isHasBlockParams = is(Opcodes.HasBlockParams);
        Expressions.isUndefined = is(Opcodes.Undefined);
        Expressions.isClientSide = is(Opcodes.ClientSideExpression);
        Expressions.isMaybeLocal = is(Opcodes.MaybeLocal);
        function isPrimitiveValue(value) {
            if (value === null) {
                return true;
            }
            return typeof value !== 'object';
        }
        Expressions.isPrimitiveValue = isPrimitiveValue;
    })(Expressions || (exports.Expressions = Expressions = {}));
    var Statements;
    (function (Statements) {
        Statements.isText = is(Opcodes.Text);
        Statements.isAppend = is(Opcodes.Append);
        Statements.isComment = is(Opcodes.Comment);
        Statements.isModifier = is(Opcodes.Modifier);
        Statements.isBlock = is(Opcodes.Block);
        Statements.isComponent = is(Opcodes.Component);
        Statements.isOpenElement = is(Opcodes.OpenElement);
        Statements.isFlushElement = is(Opcodes.FlushElement);
        Statements.isCloseElement = is(Opcodes.CloseElement);
        Statements.isStaticAttr = is(Opcodes.StaticAttr);
        Statements.isDynamicAttr = is(Opcodes.DynamicAttr);
        Statements.isYield = is(Opcodes.Yield);
        Statements.isPartial = is(Opcodes.Partial);
        Statements.isDynamicArg = is(Opcodes.DynamicArg);
        Statements.isStaticArg = is(Opcodes.StaticArg);
        Statements.isTrustingAttr = is(Opcodes.TrustingAttr);
        Statements.isDebugger = is(Opcodes.Debugger);
        Statements.isClientSide = is(Opcodes.ClientSideStatement);
        function isAttribute(val) {
            return val[0] === Opcodes.StaticAttr || val[0] === Opcodes.DynamicAttr || val[0] === Opcodes.TrustingAttr;
        }
        Statements.isAttribute = isAttribute;
        function isArgument(val) {
            return val[0] === Opcodes.StaticArg || val[0] === Opcodes.DynamicArg;
        }
        Statements.isArgument = isArgument;
        function isParameter(val) {
            return isAttribute(val) || isArgument(val);
        }
        Statements.isParameter = isParameter;
        function getParameterName(s) {
            return s[1];
        }
        Statements.getParameterName = getParameterName;
    })(Statements || (exports.Statements = Statements = {}));

    exports.is = is;
    exports.Expressions = Expressions;
    exports.Statements = Statements;
    exports.Ops = Opcodes;
});
enifed('backburner', ['exports', 'ember-babel'], function (exports, _emberBabel) {
    'use strict';

    var NUMBER = /\d+/;
    function isString(suspect) {
        return typeof suspect === 'string';
    }
    function isFunction(suspect) {
        return typeof suspect === 'function';
    }
    function isNumber(suspect) {
        return typeof suspect === 'number';
    }
    function isCoercableNumber(suspect) {
        return isNumber(suspect) && suspect === suspect || NUMBER.test(suspect);
    }
    function noSuchQueue(name) {
        throw new Error('You attempted to schedule an action in a queue (' + name + ') that doesn\'t exist');
    }
    function noSuchMethod(name) {
        throw new Error('You attempted to schedule an action in a queue (' + name + ') for a method that doesn\'t exist');
    }
    function getOnError(options) {
        return options.onError || options.onErrorTarget && options.onErrorTarget[options.onErrorMethod];
    }
    function findItem(target, method, collection) {
        var index = -1;
        for (var i = 0, l = collection.length; i < l; i += 3) {
            if (collection[i] === target && collection[i + 1] === method) {
                index = i;
                break;
            }
        }
        return index;
    }
    function findTimer(timer, collection) {
        var index = -1;
        for (var i = 2; i < collection.length; i += 3) {
            if (collection[i] === timer) {
                index = i - 2;
                break;
            }
        }
        return index;
    }

    function binarySearch(time, timers) {
        var start = 0;
        var end = timers.length - 2;
        var middle = void 0;
        var l = void 0;
        while (start < end) {
            // since timers is an array of pairs 'l' will always
            // be an integer
            l = (end - start) / 2;
            // compensate for the index in case even number
            // of pairs inside timers
            middle = start + l - l % 2;
            if (time >= timers[middle]) {
                start = middle + 2;
            } else {
                end = middle;
            }
        }
        return time >= timers[start] ? start + 2 : start;
    }

    var Queue = function () {
        function Queue(name) {
            var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
            var globalOptions = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
            (0, _emberBabel.classCallCheck)(this, Queue);

            this._queue = []; // TODO: should be private
            this._queueBeingFlushed = [];
            this.targetQueues = Object.create(null);
            this.index = 0;
            this.name = name;
            this.options = options;
            this.globalOptions = globalOptions;
        }

        Queue.prototype.push = function push(target, method, args, stack) {
            this._queue.push(target, method, args, stack);
            return {
                queue: this,
                target: target,
                method: method
            };
        };

        Queue.prototype.pushUnique = function pushUnique(target, method, args, stack) {
            var guid = this.guidForTarget(target);
            if (guid) {
                this.pushUniqueWithGuid(guid, target, method, args, stack);
            } else {
                this.pushUniqueWithoutGuid(target, method, args, stack);
            }
            return {
                queue: this,
                target: target,
                method: method
            };
        };

        Queue.prototype.flush = function flush(sync) {
            var _options = this.options,
                before = _options.before,
                after = _options.after;

            var target = void 0;
            var method = void 0;
            var args = void 0;
            var errorRecordedForStack = void 0;
            this.targetQueues = Object.create(null);
            var queueItems = void 0;
            if (this._queueBeingFlushed.length > 0) {
                queueItems = this._queueBeingFlushed;
            } else {
                queueItems = this._queueBeingFlushed = this._queue;
                this._queue = [];
            }
            if (before) {
                before();
            }
            var invoke = void 0;
            if (queueItems.length > 0) {
                var onError = getOnError(this.globalOptions);
                invoke = onError ? this.invokeWithOnError : this.invoke;
                for (var i = this.index; i < queueItems.length; i += 4) {
                    this.index += 4;
                    target = queueItems[i];
                    method = queueItems[i + 1];
                    args = queueItems[i + 2];
                    errorRecordedForStack = queueItems[i + 3]; // Debugging assistance
                    // method could have been nullified / canceled during flush
                    if (method !== null) {
                        //
                        //    ** Attention intrepid developer **
                        //
                        //    To find out the stack of this task when it was scheduled onto
                        //    the run loop, add the following to your app.js:
                        //
                        //    Ember.run.backburner.DEBUG = true; // NOTE: This slows your app, don't leave it on in production.
                        //
                        //    Once that is in place, when you are at a breakpoint and navigate
                        //    here in the stack explorer, you can look at `errorRecordedForStack.stack`,
                        //    which will be the captured stack when this job was scheduled.
                        //
                        //    One possible long-term solution is the following Chrome issue:
                        //       https://bugs.chromium.org/p/chromium/issues/detail?id=332624
                        //
                        invoke(target, method, args, onError, errorRecordedForStack);
                    }
                    if (this.index !== this._queueBeingFlushed.length && this.globalOptions.mustYield && this.globalOptions.mustYield()) {
                        return 1 /* Pause */;
                    }
                }
            }
            if (after) {
                after();
            }
            this._queueBeingFlushed.length = 0;
            this.index = 0;
            if (sync !== false && this._queue.length > 0) {
                // check if new items have been added
                this.flush(true);
            }
        };

        Queue.prototype.hasWork = function hasWork() {
            return this._queueBeingFlushed.length > 0 || this._queue.length > 0;
        };

        Queue.prototype.cancel = function cancel(_ref) {
            var target = _ref.target,
                method = _ref.method;

            var queue = this._queue;
            var currentTarget = void 0;
            var currentMethod = void 0;
            var i = void 0;
            var l = void 0;
            var t = void 0;
            var guid = this.guidForTarget(target);
            var targetQueue = guid ? this.targetQueues[guid] : undefined;
            if (targetQueue !== undefined) {
                for (i = 0, l = targetQueue.length; i < l; i += 2) {
                    t = targetQueue[i];
                    if (t === method) {
                        targetQueue.splice(i, 1);
                    }
                }
            }
            for (i = 0, l = queue.length; i < l; i += 4) {
                currentTarget = queue[i];
                currentMethod = queue[i + 1];
                if (currentTarget === target && currentMethod === method) {
                    queue.splice(i, 4);
                    return true;
                }
            }
            // if not found in current queue
            // could be in the queue that is being flushed
            queue = this._queueBeingFlushed;
            for (i = 0, l = queue.length; i < l; i += 4) {
                currentTarget = queue[i];
                currentMethod = queue[i + 1];
                if (currentTarget === target && currentMethod === method) {
                    // don't mess with array during flush
                    // just nullify the method
                    queue[i + 1] = null;
                    return true;
                }
            }
            return false;
        };

        Queue.prototype.guidForTarget = function guidForTarget(target) {
            if (!target) {
                return;
            }
            var peekGuid = this.globalOptions.peekGuid;
            if (peekGuid) {
                return peekGuid(target);
            }
            var KEY = this.globalOptions.GUID_KEY;
            if (KEY) {
                return target[KEY];
            }
        };

        Queue.prototype.pushUniqueWithoutGuid = function pushUniqueWithoutGuid(target, method, args, stack) {
            var queue = this._queue;
            for (var i = 0, l = queue.length; i < l; i += 4) {
                var currentTarget = queue[i];
                var currentMethod = queue[i + 1];
                if (currentTarget === target && currentMethod === method) {
                    queue[i + 2] = args; // replace args
                    queue[i + 3] = stack; // replace stack
                    return;
                }
            }
            queue.push(target, method, args, stack);
        };

        Queue.prototype.targetQueue = function targetQueue(_targetQueue, target, method, args, stack) {
            var queue = this._queue;
            for (var i = 0, l = _targetQueue.length; i < l; i += 2) {
                var currentMethod = _targetQueue[i];
                if (currentMethod === method) {
                    var currentIndex = _targetQueue[i + 1];
                    queue[currentIndex + 2] = args; // replace args
                    queue[currentIndex + 3] = stack; // replace stack
                    return;
                }
            }
            _targetQueue.push(method, queue.push(target, method, args, stack) - 4);
        };

        Queue.prototype.pushUniqueWithGuid = function pushUniqueWithGuid(guid, target, method, args, stack) {
            var localQueue = this.targetQueues[guid];
            if (localQueue !== undefined) {
                this.targetQueue(localQueue, target, method, args, stack);
            } else {
                this.targetQueues[guid] = [method, this._queue.push(target, method, args, stack) - 4];
            }
        };

        Queue.prototype.invoke = function invoke(target, method, args /*, onError, errorRecordedForStack */) {
            if (args && args.length > 0) {
                method.apply(target, args);
            } else {
                method.call(target);
            }
        };

        Queue.prototype.invokeWithOnError = function invokeWithOnError(target, method, args, onError, errorRecordedForStack) {
            try {
                if (args && args.length > 0) {
                    method.apply(target, args);
                } else {
                    method.call(target);
                }
            } catch (error) {
                onError(error, errorRecordedForStack);
            }
        };

        return Queue;
    }();

    var DeferredActionQueues = function () {
        function DeferredActionQueues() {
            var queueNames = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
            var options = arguments[1];
            (0, _emberBabel.classCallCheck)(this, DeferredActionQueues);

            this.queues = {};
            this.queueNameIndex = 0;
            this.queueNames = queueNames;
            queueNames.reduce(function (queues, queueName) {
                queues[queueName] = new Queue(queueName, options[queueName], options);
                return queues;
            }, this.queues);
        }
        /*
          @method schedule
          @param {String} queueName
          @param {Any} target
          @param {Any} method
          @param {Any} args
          @param {Boolean} onceFlag
          @param {Any} stack
          @return queue
        */


        DeferredActionQueues.prototype.schedule = function schedule(queueName, target, method, args, onceFlag, stack) {
            var queues = this.queues;
            var queue = queues[queueName];
            if (!queue) {
                noSuchQueue(queueName);
            }
            if (!method) {
                noSuchMethod(queueName);
            }
            if (onceFlag) {
                return queue.pushUnique(target, method, args, stack);
            } else {
                return queue.push(target, method, args, stack);
            }
        };

        DeferredActionQueues.prototype.flush = function flush() {
            var queue = void 0;
            var queueName = void 0;
            var numberOfQueues = this.queueNames.length;
            while (this.queueNameIndex < numberOfQueues) {
                queueName = this.queueNames[this.queueNameIndex];
                queue = this.queues[queueName];
                if (queue.hasWork() === false) {
                    this.queueNameIndex++;
                } else {
                    if (queue.flush(false /* async */) === 1 /* Pause */) {
                            return 1 /* Pause */;
                        }
                    this.queueNameIndex = 0; // only reset to first queue if non-pause break
                }
            }
        };

        return DeferredActionQueues;
    }();

    // accepts a function that when invoked will return an iterator
    // iterator will drain until completion
    var iteratorDrain = function (fn) {
        var iterator = fn();
        var result = iterator.next();
        while (result.done === false) {
            result.value();
            result = iterator.next();
        }
    };

    var noop = function () {};
    var SET_TIMEOUT = setTimeout;

    var Backburner = function () {
        function Backburner(queueNames) {
            var _this = this;

            var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
            (0, _emberBabel.classCallCheck)(this, Backburner);

            this.DEBUG = false;
            this.currentInstance = null;
            this._timerTimeoutId = null;
            this._autorun = null;
            this.queueNames = queueNames;
            this.options = options;
            if (!this.options.defaultQueue) {
                this.options.defaultQueue = queueNames[0];
            }
            this.instanceStack = [];
            this._timers = [];
            this._debouncees = [];
            this._throttlers = [];
            this._eventCallbacks = {
                end: [],
                begin: []
            };
            this._onBegin = this.options.onBegin || noop;
            this._onEnd = this.options.onEnd || noop;
            var _platform = this.options._platform || {};
            var platform = Object.create(null);
            platform.setTimeout = _platform.setTimeout || function (fn, ms) {
                return setTimeout(fn, ms);
            };
            platform.clearTimeout = _platform.clearTimeout || function (id) {
                return clearTimeout(id);
            };
            platform.next = _platform.next || function (fn) {
                return SET_TIMEOUT(fn, 0);
            };
            platform.clearNext = _platform.clearNext || platform.clearTimeout;
            platform.now = _platform.now || function () {
                return Date.now();
            };
            this._platform = platform;
            this._boundRunExpiredTimers = function () {
                _this._runExpiredTimers();
            };
            this._boundAutorunEnd = function () {
                _this._autorun = null;
                _this.end();
            };
        }
        /*
          @method begin
          @return instantiated class DeferredActionQueues
        */


        Backburner.prototype.begin = function begin() {
            var options = this.options;
            var previousInstance = this.currentInstance;
            var current = void 0;
            if (this._autorun !== null) {
                current = previousInstance;
                this._cancelAutorun();
            } else {
                if (previousInstance !== null) {
                    this.instanceStack.push(previousInstance);
                }
                current = this.currentInstance = new DeferredActionQueues(this.queueNames, options);
                this._trigger('begin', current, previousInstance);
            }
            this._onBegin(current, previousInstance);
            return current;
        };

        Backburner.prototype.end = function end() {
            var currentInstance = this.currentInstance;
            var nextInstance = null;
            if (currentInstance === null) {
                throw new Error('end called without begin');
            }
            // Prevent double-finally bug in Safari 6.0.2 and iOS 6
            // This bug appears to be resolved in Safari 6.0.5 and iOS 7
            var finallyAlreadyCalled = false;
            var result = void 0;
            try {
                result = currentInstance.flush();
            } finally {
                if (!finallyAlreadyCalled) {
                    finallyAlreadyCalled = true;
                    if (result === 1 /* Pause */) {
                            var next = this._platform.next;
                            this._autorun = next(this._boundAutorunEnd);
                        } else {
                        this.currentInstance = null;
                        if (this.instanceStack.length > 0) {
                            nextInstance = this.instanceStack.pop();
                            this.currentInstance = nextInstance;
                        }
                        this._trigger('end', currentInstance, nextInstance);
                        this._onEnd(currentInstance, nextInstance);
                    }
                }
            }
        };

        Backburner.prototype.on = function on(eventName, callback) {
            if (typeof callback !== 'function') {
                throw new TypeError('Callback must be a function');
            }
            var callbacks = this._eventCallbacks[eventName];
            if (callbacks !== undefined) {
                callbacks.push(callback);
            } else {
                throw new TypeError('Cannot on() event ' + eventName + ' because it does not exist');
            }
        };

        Backburner.prototype.off = function off(eventName, callback) {
            var callbacks = this._eventCallbacks[eventName];
            if (!eventName || callbacks === undefined) {
                throw new TypeError('Cannot off() event ' + eventName + ' because it does not exist');
            }
            var callbackFound = false;
            if (callback) {
                for (var i = 0; i < callbacks.length; i++) {
                    if (callbacks[i] === callback) {
                        callbackFound = true;
                        callbacks.splice(i, 1);
                        i--;
                    }
                }
            }
            if (!callbackFound) {
                throw new TypeError('Cannot off() callback that does not exist');
            }
        };

        Backburner.prototype.run = function run(target, method) {
            for (var _len = arguments.length, args = Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
                args[_key - 2] = arguments[_key];
            }

            var length = arguments.length;
            var _method = void 0;
            var _target = void 0;
            if (length === 1) {
                _method = target;
                _target = null;
            } else {
                _method = method;
                _target = target;
                if (isString(_method)) {
                    _method = _target[_method];
                }
            }
            var onError = getOnError(this.options);
            this.begin();
            if (onError) {
                try {
                    return _method.apply(_target, args);
                } catch (error) {
                    onError(error);
                } finally {
                    this.end();
                }
            } else {
                try {
                    return _method.apply(_target, args);
                } finally {
                    this.end();
                }
            }
        };

        Backburner.prototype.join = function join() {
            if (this.currentInstance === null) {
                return this.run.apply(this, arguments);
            }
            var length = arguments.length;
            var method = void 0;
            var target = void 0;
            var args = void 0;
            if (length === 1) {
                method = arguments[0];
                target = null;
            } else {
                target = arguments[0];
                method = arguments[1];
                if (isString(method)) {
                    method = target[method];
                }
                if (length > 2) {
                    args = new Array(length - 2);
                    for (var i = 0, l = length - 2; i < l; i++) {
                        args[i] = arguments[i + 2];
                    }
                }
            }
            if (length === 1) {
                return method();
            } else if (length === 2) {
                return method.call(target);
            } else {
                return method.apply(target, args);
            }
        };

        Backburner.prototype.defer = function defer() {
            return this.schedule.apply(this, arguments);
        };

        Backburner.prototype.schedule = function schedule(queueName) {
            var length = arguments.length;
            var method = void 0;
            var target = void 0;
            var args = void 0;
            if (length === 2) {
                method = arguments[1];
                target = null;
            } else {
                target = arguments[1];
                method = arguments[2];
                if (isString(method)) {
                    method = target[method];
                }
                if (length > 3) {
                    args = new Array(length - 3);
                    for (var i = 3; i < length; i++) {
                        args[i - 3] = arguments[i];
                    }
                }
            }
            var stack = this.DEBUG ? new Error() : undefined;
            return this._ensureInstance().schedule(queueName, target, method, args, false, stack);
        };

        Backburner.prototype.scheduleIterable = function scheduleIterable(queueName, iterable) {
            var stack = this.DEBUG ? new Error() : undefined;
            return this._ensureInstance().schedule(queueName, null, iteratorDrain, [iterable], false, stack);
        };

        Backburner.prototype.deferOnce = function deferOnce() {
            return this.scheduleOnce.apply(this, arguments);
        };

        Backburner.prototype.scheduleOnce = function scheduleOnce(queueName /* , target, method, args */) {
            var length = arguments.length;
            var method = void 0;
            var target = void 0;
            var args = void 0;
            if (length === 2) {
                method = arguments[1];
                target = null;
            } else {
                target = arguments[1];
                method = arguments[2];
                if (isString(method)) {
                    method = target[method];
                }
                if (length > 3) {
                    args = new Array(length - 3);
                    for (var i = 3; i < length; i++) {
                        args[i - 3] = arguments[i];
                    }
                }
            }
            var stack = this.DEBUG ? new Error() : undefined;
            return this._ensureInstance().schedule(queueName, target, method, args, true, stack);
        };

        Backburner.prototype.setTimeout = function setTimeout() {
            return this.later.apply(this, arguments);
        };

        Backburner.prototype.later = function later() {
            for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
                args[_key2] = arguments[_key2];
            }

            var length = args.length;
            var wait = 0;
            var method = void 0;
            var target = void 0;
            var methodOrTarget = void 0;
            var methodOrWait = void 0;
            var methodOrArgs = void 0;
            if (length === 0) {
                return;
            } else if (length === 1) {
                method = args.shift();
            } else if (length === 2) {
                methodOrTarget = args[0];
                methodOrWait = args[1];
                if (isFunction(methodOrWait)) {
                    target = args.shift();
                    method = args.shift();
                } else if (methodOrTarget !== null && isString(methodOrWait) && methodOrWait in methodOrTarget) {
                    target = args.shift();
                    method = target[args.shift()];
                } else if (isCoercableNumber(methodOrWait)) {
                    method = args.shift();
                    wait = parseInt(args.shift(), 10);
                } else {
                    method = args.shift();
                }
            } else {
                var last = args[args.length - 1];
                if (isCoercableNumber(last)) {
                    wait = parseInt(args.pop(), 10);
                }
                methodOrTarget = args[0];
                methodOrArgs = args[1];
                if (isFunction(methodOrArgs)) {
                    target = args.shift();
                    method = args.shift();
                } else if (methodOrTarget !== null && isString(methodOrArgs) && methodOrArgs in methodOrTarget) {
                    target = args.shift();
                    method = target[args.shift()];
                } else {
                    method = args.shift();
                }
            }
            var onError = getOnError(this.options);
            var executeAt = this._platform.now() + wait;
            var fn = void 0;
            if (onError) {
                fn = function () {
                    try {
                        method.apply(target, args);
                    } catch (e) {
                        onError(e);
                    }
                };
            } else {
                fn = function () {
                    method.apply(target, args);
                };
            }
            return this._setTimeout(fn, executeAt);
        };

        Backburner.prototype.throttle = function throttle(target, method /*, ...args, wait, [immediate] */) {
            var _this2 = this;

            var args = new Array(arguments.length);
            for (var i = 0; i < arguments.length; i++) {
                args[i] = arguments[i];
            }
            var immediate = args.pop();
            var isImmediate = void 0;
            var wait = void 0;
            var index = void 0;
            var timer = void 0;
            if (isCoercableNumber(immediate)) {
                wait = immediate;
                isImmediate = true;
            } else {
                wait = args.pop();
                isImmediate = immediate === true;
            }
            wait = parseInt(wait, 10);
            index = findItem(target, method, this._throttlers);
            if (index > -1) {
                return this._throttlers[index + 2];
            } // throttled
            timer = this._platform.setTimeout(function () {
                if (isImmediate === false) {
                    _this2.run.apply(_this2, args);
                }
                index = findTimer(timer, _this2._throttlers);
                if (index > -1) {
                    _this2._throttlers.splice(index, 3);
                }
            }, wait);
            if (isImmediate) {
                this.join.apply(this, args);
            }
            this._throttlers.push(target, method, timer);
            return timer;
        };

        Backburner.prototype.debounce = function debounce(target, method /* , args, wait, [immediate] */) {
            var _this3 = this;

            var args = new Array(arguments.length);
            for (var i = 0; i < arguments.length; i++) {
                args[i] = arguments[i];
            }
            var immediate = args.pop();
            var isImmediate = void 0;
            var wait = void 0;
            var index = void 0;
            var timer = void 0;
            if (isCoercableNumber(immediate)) {
                wait = immediate;
                isImmediate = false;
            } else {
                wait = args.pop();
                isImmediate = immediate === true;
            }
            wait = parseInt(wait, 10);
            // Remove debouncee
            index = findItem(target, method, this._debouncees);
            if (index > -1) {
                var timerId = this._debouncees[index + 2];
                this._debouncees.splice(index, 3);
                this._platform.clearTimeout(timerId);
            }
            timer = this._platform.setTimeout(function () {
                if (isImmediate === false) {
                    _this3.run.apply(_this3, args);
                }
                index = findTimer(timer, _this3._debouncees);
                if (index > -1) {
                    _this3._debouncees.splice(index, 3);
                }
            }, wait);
            if (isImmediate && index === -1) {
                this.join.apply(this, args);
            }
            this._debouncees.push(target, method, timer);
            return timer;
        };

        Backburner.prototype.cancelTimers = function cancelTimers() {
            for (var i = 2; i < this._throttlers.length; i += 3) {
                this._platform.clearTimeout(this._throttlers[i]);
            }
            this._throttlers = [];
            for (var t = 2; t < this._debouncees.length; t += 3) {
                this._platform.clearTimeout(this._debouncees[t]);
            }
            this._debouncees = [];
            this._clearTimerTimeout();
            this._timers = [];
            this._cancelAutorun();
        };

        Backburner.prototype.hasTimers = function hasTimers() {
            return this._timers.length > 0 || this._debouncees.length > 0 || this._throttlers.length > 0 || this._autorun !== null;
        };

        Backburner.prototype.cancel = function cancel(timer) {
            if (!timer) {
                return false;
            }
            var timerType = typeof timer;
            if (timerType === 'number' || timerType === 'string') {
                return this._cancelItem(timer, this._throttlers) || this._cancelItem(timer, this._debouncees);
            } else if (timerType === 'function') {
                return this._cancelLaterTimer(timer);
            } else if (timerType === 'object' && timer.queue && timer.method) {
                return timer.queue.cancel(timer);
            }
            return false;
        };

        Backburner.prototype.ensureInstance = function ensureInstance() {
            this._ensureInstance();
        };

        Backburner.prototype._cancelAutorun = function _cancelAutorun() {
            if (this._autorun !== null) {
                this._platform.clearNext(this._autorun);
                this._autorun = null;
            }
        };

        Backburner.prototype._setTimeout = function _setTimeout(fn, executeAt) {
            if (this._timers.length === 0) {
                this._timers.push(executeAt, fn);
                this._installTimerTimeout();
                return fn;
            }
            // find position to insert
            var i = binarySearch(executeAt, this._timers);
            this._timers.splice(i, 0, executeAt, fn);
            // we should be the new earliest timer if i == 0
            if (i === 0) {
                this._reinstallTimerTimeout();
            }
            return fn;
        };

        Backburner.prototype._cancelLaterTimer = function _cancelLaterTimer(timer) {
            for (var i = 1; i < this._timers.length; i += 2) {
                if (this._timers[i] === timer) {
                    i = i - 1;
                    this._timers.splice(i, 2); // remove the two elements
                    if (i === 0) {
                        this._reinstallTimerTimeout();
                    }
                    return true;
                }
            }
            return false;
        };

        Backburner.prototype._cancelItem = function _cancelItem(timer, array) {
            var index = findTimer(timer, array);
            if (index > -1) {
                array.splice(index, 3);
                this._platform.clearTimeout(timer);
                return true;
            }
            return false;
        };

        Backburner.prototype._trigger = function _trigger(eventName, arg1, arg2) {
            var callbacks = this._eventCallbacks[eventName];
            if (callbacks !== undefined) {
                for (var i = 0; i < callbacks.length; i++) {
                    callbacks[i](arg1, arg2);
                }
            }
        };

        Backburner.prototype._runExpiredTimers = function _runExpiredTimers() {
            this._timerTimeoutId = null;
            if (this._timers.length === 0) {
                return;
            }
            this.begin();
            this._scheduleExpiredTimers();
            this.end();
        };

        Backburner.prototype._scheduleExpiredTimers = function _scheduleExpiredTimers() {
            var timers = this._timers;
            var l = timers.length;
            var i = 0;
            var defaultQueue = this.options.defaultQueue;
            var n = this._platform.now();
            for (; i < l; i += 2) {
                var executeAt = timers[i];
                if (executeAt <= n) {
                    var fn = timers[i + 1];
                    this.schedule(defaultQueue, null, fn);
                } else {
                    break;
                }
            }
            timers.splice(0, i);
            this._installTimerTimeout();
        };

        Backburner.prototype._reinstallTimerTimeout = function _reinstallTimerTimeout() {
            this._clearTimerTimeout();
            this._installTimerTimeout();
        };

        Backburner.prototype._clearTimerTimeout = function _clearTimerTimeout() {
            if (this._timerTimeoutId === null) {
                return;
            }
            this._platform.clearTimeout(this._timerTimeoutId);
            this._timerTimeoutId = null;
        };

        Backburner.prototype._installTimerTimeout = function _installTimerTimeout() {
            if (this._timers.length === 0) {
                return;
            }
            var minExpiresAt = this._timers[0];
            var n = this._platform.now();
            var wait = Math.max(0, minExpiresAt - n);
            this._timerTimeoutId = this._platform.setTimeout(this._boundRunExpiredTimers, wait);
        };

        Backburner.prototype._ensureInstance = function _ensureInstance() {
            var currentInstance = this.currentInstance;
            if (currentInstance === null) {
                currentInstance = this.begin();
                var next = this._platform.next;
                this._autorun = next(this._boundAutorunEnd);
            }
            return currentInstance;
        };

        return Backburner;
    }();

    Backburner.Queue = Queue;

    exports.default = Backburner;
});
enifed('container', ['exports', 'ember-babel', 'ember-utils', 'ember-debug', 'ember/features'], function (exports, _emberBabel, _emberUtils, _emberDebug, _features) {
  'use strict';

  exports.Container = exports.privatize = exports.Registry = undefined;


  /* globals Proxy */
  var CONTAINER_OVERRIDE = (0, _emberUtils.symbol)('CONTAINER_OVERRIDE');

  /**
   A container used to instantiate and cache objects.
  
   Every `Container` must be associated with a `Registry`, which is referenced
   to determine the factory and options that should be used to instantiate
   objects.
  
   The public API for `Container` is still in flux and should not be considered
   stable.
  
   @private
   @class Container
   */
  function Container(registry) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    this.registry = registry;
    this.owner = options.owner || null;
    this.cache = (0, _emberUtils.dictionary)(options.cache || null);
    this.factoryManagerCache = (0, _emberUtils.dictionary)(options.factoryManagerCache || null);
    this[CONTAINER_OVERRIDE] = undefined;
    this.isDestroyed = false;

    if (true) {
      this.validationCache = (0, _emberUtils.dictionary)(options.validationCache || null);
    }
  }

  Container.prototype = {
    lookup: function (fullName, options) {
      (true && !(this.registry.validateFullName(fullName)) && (0, _emberDebug.assert)('fullName must be a proper full name', this.registry.validateFullName(fullName)));

      return lookup(this, this.registry.normalize(fullName), options);
    },
    destroy: function () {
      destroyDestroyables(this);
      this.isDestroyed = true;
    },
    reset: function (fullName) {
      if (fullName === undefined) {
        resetCache(this);
      } else {
        resetMember(this, this.registry.normalize(fullName));
      }
    },
    ownerInjection: function () {
      var _ref;

      return _ref = {}, _ref[_emberUtils.OWNER] = this.owner, _ref;
    },
    _resolverCacheKey: function (name, options) {
      return this.registry.resolverCacheKey(name, options);
    },
    factoryFor: function (fullName) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      var normalizedName = this.registry.normalize(fullName);

      (true && !(this.registry.validateFullName(normalizedName)) && (0, _emberDebug.assert)('fullName must be a proper full name', this.registry.validateFullName(normalizedName)));


      if (options.source) {
        var expandedFullName = this.registry.expandLocalLookup(fullName, options);
        // if expandLocalLookup returns falsey, we do not support local lookup
        if (!_features.EMBER_MODULE_UNIFICATION) {
          if (!expandedFullName) {
            return;
          }

          normalizedName = expandedFullName;
        } else if (expandedFullName) {
          // with ember-module-unification, if expandLocalLookup returns something,
          // pass it to the resolve without the source
          normalizedName = expandedFullName;
          options = {};
        }
      }

      var cacheKey = this._resolverCacheKey(normalizedName, options);
      var cached = this.factoryManagerCache[cacheKey];

      if (cached !== undefined) {
        return cached;
      }

      var factory = _features.EMBER_MODULE_UNIFICATION ? this.registry.resolve(normalizedName, options) : this.registry.resolve(normalizedName);

      if (factory === undefined) {
        return;
      }

      if (true && factory && typeof factory._onLookup === 'function') {
        factory._onLookup(fullName);
      }

      var manager = new FactoryManager(this, factory, fullName, normalizedName);

      if (true) {
        manager = wrapManagerInDeprecationProxy(manager);
      }

      this.factoryManagerCache[cacheKey] = manager;
      return manager;
    }
  };

  /*
   * Wrap a factory manager in a proxy which will not permit properties to be
   * set on the manager.
   */
  function wrapManagerInDeprecationProxy(manager) {
    if (_emberUtils.HAS_NATIVE_PROXY) {
      var validator = {
        set: function (obj, prop, value) {
          throw new Error('You attempted to set "' + prop + '" on a factory manager created by container#factoryFor. A factory manager is a read-only construct.');
        }
      };

      // Note:
      // We have to proxy access to the manager here so that private property
      // access doesn't cause the above errors to occur.
      var m = manager;
      var proxiedManager = {
        class: m.class,
        create: function (props) {
          return m.create(props);
        }
      };

      return new Proxy(proxiedManager, validator);
    }

    return manager;
  }

  function isSingleton(container, fullName) {
    return container.registry.getOption(fullName, 'singleton') !== false;
  }

  function isInstantiatable(container, fullName) {
    return container.registry.getOption(fullName, 'instantiate') !== false;
  }

  function lookup(container, fullName) {
    var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    if (options.source) {
      var expandedFullName = container.registry.expandLocalLookup(fullName, options);

      if (!_features.EMBER_MODULE_UNIFICATION) {
        // if expandLocalLookup returns falsey, we do not support local lookup
        if (!expandedFullName) {
          return;
        }

        fullName = expandedFullName;
      } else if (expandedFullName) {
        // with ember-module-unification, if expandLocalLookup returns something,
        // pass it to the resolve without the source
        fullName = expandedFullName;
        options = {};
      }
    }

    if (options.singleton !== false) {
      var cacheKey = container._resolverCacheKey(fullName, options);
      var cached = container.cache[cacheKey];
      if (cached !== undefined) {
        return cached;
      }
    }

    return instantiateFactory(container, fullName, options);
  }

  function isSingletonClass(container, fullName, _ref2) {
    var instantiate = _ref2.instantiate,
        singleton = _ref2.singleton;

    return singleton !== false && !instantiate && isSingleton(container, fullName) && !isInstantiatable(container, fullName);
  }

  function isSingletonInstance(container, fullName, _ref3) {
    var instantiate = _ref3.instantiate,
        singleton = _ref3.singleton;

    return singleton !== false && instantiate !== false && isSingleton(container, fullName) && isInstantiatable(container, fullName);
  }

  function isFactoryClass(container, fullname, _ref4) {
    var instantiate = _ref4.instantiate,
        singleton = _ref4.singleton;

    return instantiate === false && (singleton === false || !isSingleton(container, fullname)) && !isInstantiatable(container, fullname);
  }

  function isFactoryInstance(container, fullName, _ref5) {
    var instantiate = _ref5.instantiate,
        singleton = _ref5.singleton;

    return instantiate !== false && (singleton !== false || isSingleton(container, fullName)) && isInstantiatable(container, fullName);
  }

  function instantiateFactory(container, fullName, options) {
    var factoryManager = _features.EMBER_MODULE_UNIFICATION && options && options.source ? container.factoryFor(fullName, options) : container.factoryFor(fullName);

    if (factoryManager === undefined) {
      return;
    }

    // SomeClass { singleton: true, instantiate: true } | { singleton: true } | { instantiate: true } | {}
    // By default majority of objects fall into this case
    if (isSingletonInstance(container, fullName, options)) {
      var cacheKey = container._resolverCacheKey(fullName, options);
      return container.cache[cacheKey] = factoryManager.create();
    }

    // SomeClass { singleton: false, instantiate: true }
    if (isFactoryInstance(container, fullName, options)) {
      return factoryManager.create();
    }

    // SomeClass { singleton: true, instantiate: false } | { instantiate: false } | { singleton: false, instantiation: false }
    if (isSingletonClass(container, fullName, options) || isFactoryClass(container, fullName, options)) {
      return factoryManager.class;
    }

    throw new Error('Could not create factory');
  }

  function buildInjections() /* container, ...injections */{
    var hash = {};
    var isDynamic = false;

    if (arguments.length > 1) {
      var container = arguments[0];
      var injections = [];
      var injection = void 0;

      for (var i = 1; i < arguments.length; i++) {
        if (arguments[i]) {
          injections = injections.concat(arguments[i]);
        }
      }

      if (true) {
        container.registry.validateInjections(injections);
      }

      for (var _i = 0; _i < injections.length; _i++) {
        injection = injections[_i];
        hash[injection.property] = lookup(container, injection.fullName);
        if (!isDynamic) {
          isDynamic = !isSingleton(container, injection.fullName);
        }
      }
    }

    return { injections: hash, isDynamic: isDynamic };
  }

  function injectionsFor(container, fullName) {
    var registry = container.registry;
    var splitName = fullName.split(':');
    var type = splitName[0];

    return buildInjections(container, registry.getTypeInjections(type), registry.getInjections(fullName));
  }

  function destroyDestroyables(container) {
    var cache = container.cache;
    var keys = Object.keys(cache);

    for (var i = 0; i < keys.length; i++) {
      var key = keys[i];
      var value = cache[key];

      if (value.destroy) {
        value.destroy();
      }
    }
  }

  function resetCache(container) {
    destroyDestroyables(container);
    container.cache = (0, _emberUtils.dictionary)(null);
    container.factoryManagerCache = (0, _emberUtils.dictionary)(null);
  }

  function resetMember(container, fullName) {
    var member = container.cache[fullName];

    delete container.factoryManagerCache[fullName];

    if (member) {
      delete container.cache[fullName];

      if (member.destroy) {
        member.destroy();
      }
    }
  }

  var FactoryManager = function () {
    function FactoryManager(container, factory, fullName, normalizedName) {
      (0, _emberBabel.classCallCheck)(this, FactoryManager);

      this.container = container;
      this.owner = container.owner;
      this.class = factory;
      this.fullName = fullName;
      this.normalizedName = normalizedName;
      this.madeToString = undefined;
      this.injections = undefined;
    }

    FactoryManager.prototype.toString = function toString() {
      if (this.madeToString === undefined) {
        this.madeToString = this.container.registry.makeToString(this.class, this.fullName);
      }

      return this.madeToString;
    };

    FactoryManager.prototype.create = function create() {
      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      var injectionsCache = this.injections;
      if (injectionsCache === undefined) {
        var _injectionsFor = injectionsFor(this.container, this.normalizedName),
            injections = _injectionsFor.injections,
            isDynamic = _injectionsFor.isDynamic;

        injectionsCache = injections;
        if (!isDynamic) {
          this.injections = injections;
        }
      }

      var props = (0, _emberUtils.assign)({}, injectionsCache, options);

      if (true) {
        var lazyInjections = void 0;
        var validationCache = this.container.validationCache;
        // Ensure that all lazy injections are valid at instantiation time
        if (!validationCache[this.fullName] && this.class && typeof this.class._lazyInjections === 'function') {
          lazyInjections = this.class._lazyInjections();
          lazyInjections = this.container.registry.normalizeInjectionsHash(lazyInjections);

          this.container.registry.validateInjections(lazyInjections);
        }

        validationCache[this.fullName] = true;
      }

      if (!this.class.create) {
        throw new Error('Failed to create an instance of \'' + this.normalizedName + '\'. Most likely an improperly defined class or' + ' an invalid module export.');
      }

      // required to allow access to things like
      // the customized toString, _debugContainerKey,
      // owner, etc. without a double extend and without
      // modifying the objects properties
      if (typeof this.class._initFactory === 'function') {
        this.class._initFactory(this);
      } else {
        // in the non-EmberObject case we need to still setOwner
        // this is required for supporting glimmer environment and
        // template instantiation which rely heavily on
        // `options[OWNER]` being passed into `create`
        // TODO: clean this up, and remove in future versions
        (0, _emberUtils.setOwner)(props, this.owner);
      }

      return this.class.create(props);
    };

    return FactoryManager;
  }();

  var VALID_FULL_NAME_REGEXP = /^[^:]+:[^:]+$/;

  /**
   A registry used to store factory and option information keyed
   by type.
  
   A `Registry` stores the factory and option information needed by a
   `Container` to instantiate and cache objects.
  
   The API for `Registry` is still in flux and should not be considered stable.
  
   @private
   @class Registry
   @since 1.11.0
  */
  function Registry() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    this.fallback = options.fallback || null;

    if (options.resolver) {
      this.resolver = options.resolver;
      if (typeof this.resolver === 'function') {
        deprecateResolverFunction(this);
      }
    }

    this.registrations = (0, _emberUtils.dictionary)(options.registrations || null);

    this._typeInjections = (0, _emberUtils.dictionary)(null);
    this._injections = (0, _emberUtils.dictionary)(null);

    this._localLookupCache = Object.create(null);
    this._normalizeCache = (0, _emberUtils.dictionary)(null);
    this._resolveCache = (0, _emberUtils.dictionary)(null);
    this._failCache = (0, _emberUtils.dictionary)(null);

    this._options = (0, _emberUtils.dictionary)(null);
    this._typeOptions = (0, _emberUtils.dictionary)(null);
  }

  Registry.prototype = {
    /**
     A backup registry for resolving registrations when no matches can be found.
      @private
     @property fallback
     @type Registry
     */
    fallback: null,

    /**
     An object that has a `resolve` method that resolves a name.
      @private
     @property resolver
     @type Resolver
     */
    resolver: null,

    /**
     @private
     @property registrations
     @type InheritingDict
     */
    registrations: null,

    /**
     @private
      @property _typeInjections
     @type InheritingDict
     */
    _typeInjections: null,

    /**
     @private
      @property _injections
     @type InheritingDict
     */
    _injections: null,

    /**
     @private
      @property _normalizeCache
     @type InheritingDict
     */
    _normalizeCache: null,

    /**
     @private
      @property _resolveCache
     @type InheritingDict
     */
    _resolveCache: null,

    /**
     @private
      @property _options
     @type InheritingDict
     */
    _options: null,

    /**
     @private
      @property _typeOptions
     @type InheritingDict
     */
    _typeOptions: null,

    container: function (options) {
      return new Container(this, options);
    },
    register: function (fullName, factory) {
      var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
      (true && !(this.validateFullName(fullName)) && (0, _emberDebug.assert)('fullName must be a proper full name', this.validateFullName(fullName)));


      if (factory === undefined) {
        throw new TypeError('Attempting to register an unknown factory: \'' + fullName + '\'');
      }

      var normalizedName = this.normalize(fullName);

      if (this._resolveCache[normalizedName]) {
        throw new Error('Cannot re-register: \'' + fullName + '\', as it has already been resolved.');
      }

      delete this._failCache[normalizedName];
      this.registrations[normalizedName] = factory;
      this._options[normalizedName] = options;
    },
    unregister: function (fullName) {
      (true && !(this.validateFullName(fullName)) && (0, _emberDebug.assert)('fullName must be a proper full name', this.validateFullName(fullName)));


      var normalizedName = this.normalize(fullName);

      this._localLookupCache = Object.create(null);

      delete this.registrations[normalizedName];
      delete this._resolveCache[normalizedName];
      delete this._failCache[normalizedName];
      delete this._options[normalizedName];
    },
    resolve: function (fullName, options) {
      (true && !(this.validateFullName(fullName)) && (0, _emberDebug.assert)('fullName must be a proper full name', this.validateFullName(fullName)));

      var factory = resolve(this, this.normalize(fullName), options);
      if (factory === undefined && this.fallback) {
        var _fallback;

        factory = (_fallback = this.fallback).resolve.apply(_fallback, arguments);
      }
      return factory;
    },
    describe: function (fullName) {
      if (this.resolver && this.resolver.lookupDescription) {
        return this.resolver.lookupDescription(fullName);
      } else if (this.fallback) {
        return this.fallback.describe(fullName);
      } else {
        return fullName;
      }
    },
    normalizeFullName: function (fullName) {
      if (this.resolver && this.resolver.normalize) {
        return this.resolver.normalize(fullName);
      } else if (this.fallback) {
        return this.fallback.normalizeFullName(fullName);
      } else {
        return fullName;
      }
    },
    normalize: function (fullName) {
      return this._normalizeCache[fullName] || (this._normalizeCache[fullName] = this.normalizeFullName(fullName));
    },
    makeToString: function (factory, fullName) {
      if (this.resolver && this.resolver.makeToString) {
        return this.resolver.makeToString(factory, fullName);
      } else if (this.fallback) {
        return this.fallback.makeToString(factory, fullName);
      } else {
        return factory.toString();
      }
    },
    has: function (fullName, options) {
      if (!this.isValidFullName(fullName)) {
        return false;
      }

      var source = options && options.source && this.normalize(options.source);

      return has(this, this.normalize(fullName), source);
    },
    optionsForType: function (type, options) {
      this._typeOptions[type] = options;
    },
    getOptionsForType: function (type) {
      var optionsForType = this._typeOptions[type];
      if (optionsForType === undefined && this.fallback) {
        optionsForType = this.fallback.getOptionsForType(type);
      }
      return optionsForType;
    },
    options: function (fullName) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      var normalizedName = this.normalize(fullName);
      this._options[normalizedName] = options;
    },
    getOptions: function (fullName) {
      var normalizedName = this.normalize(fullName);
      var options = this._options[normalizedName];

      if (options === undefined && this.fallback) {
        options = this.fallback.getOptions(fullName);
      }
      return options;
    },
    getOption: function (fullName, optionName) {
      var options = this._options[fullName];

      if (options && options[optionName] !== undefined) {
        return options[optionName];
      }

      var type = fullName.split(':')[0];
      options = this._typeOptions[type];

      if (options && options[optionName] !== undefined) {
        return options[optionName];
      } else if (this.fallback) {
        return this.fallback.getOption(fullName, optionName);
      }
    },
    typeInjection: function (type, property, fullName) {
      (true && !(this.validateFullName(fullName)) && (0, _emberDebug.assert)('fullName must be a proper full name', this.validateFullName(fullName)));


      var fullNameType = fullName.split(':')[0];
      if (fullNameType === type) {
        throw new Error('Cannot inject a \'' + fullName + '\' on other ' + type + '(s).');
      }

      var injections = this._typeInjections[type] || (this._typeInjections[type] = []);

      injections.push({ property: property, fullName: fullName });
    },
    injection: function (fullName, property, injectionName) {
      this.validateFullName(injectionName);
      var normalizedInjectionName = this.normalize(injectionName);

      if (fullName.indexOf(':') === -1) {
        return this.typeInjection(fullName, property, normalizedInjectionName);
      }

      (true && !(this.validateFullName(fullName)) && (0, _emberDebug.assert)('fullName must be a proper full name', this.validateFullName(fullName)));

      var normalizedName = this.normalize(fullName);

      var injections = this._injections[normalizedName] || (this._injections[normalizedName] = []);

      injections.push({ property: property, fullName: normalizedInjectionName });
    },
    knownForType: function (type) {
      var fallbackKnown = void 0,
          resolverKnown = void 0;

      var localKnown = (0, _emberUtils.dictionary)(null);
      var registeredNames = Object.keys(this.registrations);
      for (var index = 0; index < registeredNames.length; index++) {
        var fullName = registeredNames[index];
        var itemType = fullName.split(':')[0];

        if (itemType === type) {
          localKnown[fullName] = true;
        }
      }

      if (this.fallback) {
        fallbackKnown = this.fallback.knownForType(type);
      }

      if (this.resolver && this.resolver.knownForType) {
        resolverKnown = this.resolver.knownForType(type);
      }

      return (0, _emberUtils.assign)({}, fallbackKnown, localKnown, resolverKnown);
    },
    validateFullName: function (fullName) {
      if (!this.isValidFullName(fullName)) {
        throw new TypeError('Invalid Fullname, expected: \'type:name\' got: ' + fullName);
      }

      return true;
    },
    isValidFullName: function (fullName) {
      return VALID_FULL_NAME_REGEXP.test(fullName);
    },
    getInjections: function (fullName) {
      var injections = this._injections[fullName] || [];
      if (this.fallback) {
        injections = injections.concat(this.fallback.getInjections(fullName));
      }
      return injections;
    },
    getTypeInjections: function (type) {
      var injections = this._typeInjections[type] || [];
      if (this.fallback) {
        injections = injections.concat(this.fallback.getTypeInjections(type));
      }
      return injections;
    },
    resolverCacheKey: function (name, options) {
      if (!_features.EMBER_MODULE_UNIFICATION) {
        return name;
      }

      return options && options.source ? options.source + ':' + name : name;
    },
    expandLocalLookup: function (fullName, options) {
      if (this.resolver && this.resolver.expandLocalLookup) {
        (true && !(this.validateFullName(fullName)) && (0, _emberDebug.assert)('fullName must be a proper full name', this.validateFullName(fullName)));
        (true && !(options && options.source) && (0, _emberDebug.assert)('options.source must be provided to expandLocalLookup', options && options.source));
        (true && !(this.validateFullName(options.source)) && (0, _emberDebug.assert)('options.source must be a proper full name', this.validateFullName(options.source)));


        var normalizedFullName = this.normalize(fullName);
        var normalizedSource = this.normalize(options.source);

        return expandLocalLookup(this, normalizedFullName, normalizedSource);
      } else if (this.fallback) {
        return this.fallback.expandLocalLookup(fullName, options);
      } else {
        return null;
      }
    }
  };

  function deprecateResolverFunction(registry) {
    (true && !(false) && (0, _emberDebug.deprecate)('Passing a `resolver` function into a Registry is deprecated. Please pass in a Resolver object with a `resolve` method.', false, { id: 'ember-application.registry-resolver-as-function', until: '3.0.0', url: 'https://emberjs.com/deprecations/v2.x#toc_registry-resolver-as-function' }));

    registry.resolver = {
      resolve: registry.resolver
    };
  }

  if (true) {
    Registry.prototype.normalizeInjectionsHash = function (hash) {
      var injections = [];

      for (var key in hash) {
        if (hash.hasOwnProperty(key)) {
          (true && !(this.validateFullName(hash[key])) && (0, _emberDebug.assert)('Expected a proper full name, given \'' + hash[key] + '\'', this.validateFullName(hash[key])));


          injections.push({
            property: key,
            fullName: hash[key]
          });
        }
      }

      return injections;
    };

    Registry.prototype.validateInjections = function (injections) {
      if (!injections) {
        return;
      }

      var fullName = void 0;

      for (var i = 0; i < injections.length; i++) {
        fullName = injections[i].fullName;

        (true && !(this.has(fullName)) && (0, _emberDebug.assert)('Attempting to inject an unknown injection: \'' + fullName + '\'', this.has(fullName)));
      }
    };
  }

  function expandLocalLookup(registry, normalizedName, normalizedSource) {
    var cache = registry._localLookupCache;
    var normalizedNameCache = cache[normalizedName];

    if (!normalizedNameCache) {
      normalizedNameCache = cache[normalizedName] = Object.create(null);
    }

    var cached = normalizedNameCache[normalizedSource];

    if (cached !== undefined) {
      return cached;
    }

    var expanded = registry.resolver.expandLocalLookup(normalizedName, normalizedSource);

    return normalizedNameCache[normalizedSource] = expanded;
  }

  function resolve(registry, normalizedName, options) {
    if (options && options.source) {
      // when `source` is provided expand normalizedName
      // and source into the full normalizedName
      var expandedNormalizedName = registry.expandLocalLookup(normalizedName, options);

      // if expandLocalLookup returns falsey, we do not support local lookup
      if (!_features.EMBER_MODULE_UNIFICATION) {
        if (!expandedNormalizedName) {
          return;
        }

        normalizedName = expandedNormalizedName;
      } else if (expandedNormalizedName) {
        // with ember-module-unification, if expandLocalLookup returns something,
        // pass it to the resolve without the source
        normalizedName = expandedNormalizedName;
        options = {};
      }
    }

    var cacheKey = registry.resolverCacheKey(normalizedName, options);
    var cached = registry._resolveCache[cacheKey];
    if (cached !== undefined) {
      return cached;
    }
    if (registry._failCache[cacheKey]) {
      return;
    }

    var resolved = void 0;

    if (registry.resolver) {
      resolved = registry.resolver.resolve(normalizedName, options && options.source);
    }

    if (resolved === undefined) {
      resolved = registry.registrations[normalizedName];
    }

    if (resolved === undefined) {
      registry._failCache[cacheKey] = true;
    } else {
      registry._resolveCache[cacheKey] = resolved;
    }

    return resolved;
  }

  function has(registry, fullName, source) {
    return registry.resolve(fullName, { source: source }) !== undefined;
  }

  var privateNames = (0, _emberUtils.dictionary)(null);
  var privateSuffix = ('' + Math.random() + Date.now()).replace('.', '');

  function privatize(_ref6) {
    var fullName = _ref6[0];

    var name = privateNames[fullName];
    if (name) {
      return name;
    }

    var _fullName$split = fullName.split(':'),
        type = _fullName$split[0],
        rawName = _fullName$split[1];

    return privateNames[fullName] = (0, _emberUtils.intern)(type + ':' + rawName + '-' + privateSuffix);
  }

  /*
  Public API for the container is still in flux.
  The public API, specified on the application namespace should be considered the stable API.
  // @module container
    @private
  */

  exports.Registry = Registry;
  exports.privatize = privatize;
  exports.Container = Container;
});
enifed("dag-map", ["exports"], function (exports) {
    "use strict";

    /**
     * A topologically ordered map of key/value pairs with a simple API for adding constraints.
     *
     * Edges can forward reference keys that have not been added yet (the forward reference will
     * map the key to undefined).
     */
    var DAG = function () {
        function DAG() {
            this._vertices = new Vertices();
        }
        /**
         * Adds a key/value pair with dependencies on other key/value pairs.
         *
         * @public
         * @param key    The key of the vertex to be added.
         * @param value  The value of that vertex.
         * @param before A key or array of keys of the vertices that must
         *               be visited before this vertex.
         * @param after  An string or array of strings with the keys of the
         *               vertices that must be after this vertex is visited.
         */
        DAG.prototype.add = function (key, value, before, after) {
            if (!key) throw new Error('argument `key` is required');
            var vertices = this._vertices;
            var v = vertices.add(key);
            v.val = value;
            if (before) {
                if (typeof before === "string") {
                    vertices.addEdge(v, vertices.add(before));
                } else {
                    for (var i = 0; i < before.length; i++) {
                        vertices.addEdge(v, vertices.add(before[i]));
                    }
                }
            }
            if (after) {
                if (typeof after === "string") {
                    vertices.addEdge(vertices.add(after), v);
                } else {
                    for (var i = 0; i < after.length; i++) {
                        vertices.addEdge(vertices.add(after[i]), v);
                    }
                }
            }
        };
        /**
         * @deprecated please use add.
         */
        DAG.prototype.addEdges = function (key, value, before, after) {
            this.add(key, value, before, after);
        };
        /**
         * Visits key/value pairs in topological order.
         *
         * @public
         * @param callback The function to be invoked with each key/value.
         */
        DAG.prototype.each = function (callback) {
            this._vertices.walk(callback);
        };
        /**
         * @deprecated please use each.
         */
        DAG.prototype.topsort = function (callback) {
            this.each(callback);
        };
        return DAG;
    }();
    exports.default = DAG;

    /** @private */
    var Vertices = function () {
        function Vertices() {
            this.length = 0;
            this.stack = new IntStack();
            this.path = new IntStack();
            this.result = new IntStack();
        }
        Vertices.prototype.add = function (key) {
            if (!key) throw new Error("missing key");
            var l = this.length | 0;
            var vertex;
            for (var i = 0; i < l; i++) {
                vertex = this[i];
                if (vertex.key === key) return vertex;
            }
            this.length = l + 1;
            return this[l] = {
                idx: l,
                key: key,
                val: undefined,
                out: false,
                flag: false,
                length: 0
            };
        };
        Vertices.prototype.addEdge = function (v, w) {
            this.check(v, w.key);
            var l = w.length | 0;
            for (var i = 0; i < l; i++) {
                if (w[i] === v.idx) return;
            }
            w.length = l + 1;
            w[l] = v.idx;
            v.out = true;
        };
        Vertices.prototype.walk = function (cb) {
            this.reset();
            for (var i = 0; i < this.length; i++) {
                var vertex = this[i];
                if (vertex.out) continue;
                this.visit(vertex, "");
            }
            this.each(this.result, cb);
        };
        Vertices.prototype.check = function (v, w) {
            if (v.key === w) {
                throw new Error("cycle detected: " + w + " <- " + w);
            }
            // quick check
            if (v.length === 0) return;
            // shallow check
            for (var i = 0; i < v.length; i++) {
                var key = this[v[i]].key;
                if (key === w) {
                    throw new Error("cycle detected: " + w + " <- " + v.key + " <- " + w);
                }
            }
            // deep check
            this.reset();
            this.visit(v, w);
            if (this.path.length > 0) {
                var msg_1 = "cycle detected: " + w;
                this.each(this.path, function (key) {
                    msg_1 += " <- " + key;
                });
                throw new Error(msg_1);
            }
        };
        Vertices.prototype.reset = function () {
            this.stack.length = 0;
            this.path.length = 0;
            this.result.length = 0;
            for (var i = 0, l = this.length; i < l; i++) {
                this[i].flag = false;
            }
        };
        Vertices.prototype.visit = function (start, search) {
            var _a = this,
                stack = _a.stack,
                path = _a.path,
                result = _a.result;
            stack.push(start.idx);
            while (stack.length) {
                var index = stack.pop() | 0;
                if (index >= 0) {
                    // enter
                    var vertex = this[index];
                    if (vertex.flag) continue;
                    vertex.flag = true;
                    path.push(index);
                    if (search === vertex.key) break;
                    // push exit
                    stack.push(~index);
                    this.pushIncoming(vertex);
                } else {
                    // exit
                    path.pop();
                    result.push(~index);
                }
            }
        };
        Vertices.prototype.pushIncoming = function (incomming) {
            var stack = this.stack;
            for (var i = incomming.length - 1; i >= 0; i--) {
                var index = incomming[i];
                if (!this[index].flag) {
                    stack.push(index);
                }
            }
        };
        Vertices.prototype.each = function (indices, cb) {
            for (var i = 0, l = indices.length; i < l; i++) {
                var vertex = this[indices[i]];
                cb(vertex.key, vertex.val);
            }
        };
        return Vertices;
    }();
    /** @private */
    var IntStack = function () {
        function IntStack() {
            this.length = 0;
        }
        IntStack.prototype.push = function (n) {
            this[this.length++] = n | 0;
        };
        IntStack.prototype.pop = function () {
            return this[--this.length] | 0;
        };
        return IntStack;
    }();
});
enifed('ember-application/index', ['exports', 'ember-application/system/application', 'ember-application/system/application-instance', 'ember-application/system/resolver', 'ember-application/system/engine', 'ember-application/system/engine-instance', 'ember-application/system/engine-parent', 'ember-application/initializers/dom-templates'], function (exports, _application, _applicationInstance, _resolver, _engine, _engineInstance, _engineParent) {
  'use strict';

  exports.setEngineParent = exports.getEngineParent = exports.EngineInstance = exports.Engine = exports.Resolver = exports.ApplicationInstance = exports.Application = undefined;
  Object.defineProperty(exports, 'Application', {
    enumerable: true,
    get: function () {
      return _application.default;
    }
  });
  Object.defineProperty(exports, 'ApplicationInstance', {
    enumerable: true,
    get: function () {
      return _applicationInstance.default;
    }
  });
  Object.defineProperty(exports, 'Resolver', {
    enumerable: true,
    get: function () {
      return _resolver.default;
    }
  });
  Object.defineProperty(exports, 'Engine', {
    enumerable: true,
    get: function () {
      return _engine.default;
    }
  });
  Object.defineProperty(exports, 'EngineInstance', {
    enumerable: true,
    get: function () {
      return _engineInstance.default;
    }
  });
  Object.defineProperty(exports, 'getEngineParent', {
    enumerable: true,
    get: function () {
      return _engineParent.getEngineParent;
    }
  });
  Object.defineProperty(exports, 'setEngineParent', {
    enumerable: true,
    get: function () {
      return _engineParent.setEngineParent;
    }
  });
});
enifed('ember-application/initializers/dom-templates', ['require', 'ember-glimmer', 'ember-environment', 'ember-application/system/application'], function (_require2, _emberGlimmer, _emberEnvironment, _application) {
  'use strict';

  var bootstrap = function () {};

  _application.default.initializer({
    name: 'domTemplates',
    initialize: function () {
      var bootstrapModuleId = 'ember-template-compiler/system/bootstrap';
      var context = void 0;
      if (_emberEnvironment.environment.hasDOM && (0, _require2.has)(bootstrapModuleId)) {
        bootstrap = (0, _require2.default)(bootstrapModuleId).default;
        context = document;
      }

      bootstrap({ context: context, hasTemplate: _emberGlimmer.hasTemplate, setTemplate: _emberGlimmer.setTemplate });
    }
  });
});
enifed('ember-application/system/application-instance', ['exports', 'ember-utils', 'ember-metal', 'ember-runtime', 'ember-environment', 'ember-views', 'ember-application/system/engine-instance'], function (exports, _emberUtils, _emberMetal, _emberRuntime, _emberEnvironment, _emberViews, _engineInstance) {
  'use strict';

  /**
    The `ApplicationInstance` encapsulates all of the stateful aspects of a
    running `Application`.
  
    At a high-level, we break application boot into two distinct phases:
  
    * Definition time, where all of the classes, templates, and other
      dependencies are loaded (typically in the browser).
    * Run time, where we begin executing the application once everything
      has loaded.
  
    Definition time can be expensive and only needs to happen once since it is
    an idempotent operation. For example, between test runs and FastBoot
    requests, the application stays the same. It is only the state that we want
    to reset.
  
    That state is what the `ApplicationInstance` manages: it is responsible for
    creating the container that contains all application state, and disposing of
    it once the particular test run or FastBoot request has finished.
  
    @public
    @class ApplicationInstance
    @extends EngineInstance
  */

  /**
  @module @ember/application
  */

  var ApplicationInstance = _engineInstance.default.extend({
    /**
      The `Application` for which this is an instance.
       @property {Application} application
      @private
    */
    application: null,

    /**
      The DOM events for which the event dispatcher should listen.
       By default, the application's `Ember.EventDispatcher` listens
      for a set of standard DOM events, such as `mousedown` and
      `keyup`, and delegates them to your application's `Ember.View`
      instances.
       @private
      @property {Object} customEvents
    */
    customEvents: null,

    /**
      The root DOM element of the Application as an element or a
      [jQuery-compatible selector
      string](http://api.jquery.com/category/selectors/).
       @private
      @property {String|DOMElement} rootElement
    */
    rootElement: null,

    init: function () {
      this._super.apply(this, arguments);

      // Register this instance in the per-instance registry.
      //
      // Why do we need to register the instance in the first place?
      // Because we need a good way for the root route (a.k.a ApplicationRoute)
      // to notify us when it has created the root-most view. That view is then
      // appended to the rootElement, in the case of apps, to the fixture harness
      // in tests, or rendered to a string in the case of FastBoot.
      this.register('-application-instance:main', this, { instantiate: false });
    },
    _bootSync: function (options) {
      if (this._booted) {
        return this;
      }

      options = new BootOptions(options);

      this.setupRegistry(options);

      if (options.rootElement) {
        this.rootElement = options.rootElement;
      } else {
        this.rootElement = this.application.rootElement;
      }

      if (options.location) {
        var router = (0, _emberMetal.get)(this, 'router');
        (0, _emberMetal.set)(router, 'location', options.location);
      }

      this.application.runInstanceInitializers(this);

      if (options.isInteractive) {
        this.setupEventDispatcher();
      }

      this._booted = true;

      return this;
    },
    setupRegistry: function (options) {
      this.constructor.setupRegistry(this.__registry__, options);
    },


    router: (0, _emberMetal.computed)(function () {
      return this.lookup('router:main');
    }).readOnly(),

    didCreateRootView: function (view) {
      view.appendTo(this.rootElement);
    },
    startRouting: function () {
      var router = (0, _emberMetal.get)(this, 'router');
      router.startRouting();
      this._didSetupRouter = true;
    },
    setupRouter: function () {
      if (this._didSetupRouter) {
        return;
      }
      this._didSetupRouter = true;

      var router = (0, _emberMetal.get)(this, 'router');
      router.setupRouter();
    },
    handleURL: function (url) {
      var router = (0, _emberMetal.get)(this, 'router');

      this.setupRouter();
      return router.handleURL(url);
    },
    setupEventDispatcher: function () {
      var dispatcher = this.lookup('event_dispatcher:main');
      var applicationCustomEvents = (0, _emberMetal.get)(this.application, 'customEvents');
      var instanceCustomEvents = (0, _emberMetal.get)(this, 'customEvents');

      var customEvents = (0, _emberUtils.assign)({}, applicationCustomEvents, instanceCustomEvents);
      dispatcher.setup(customEvents, this.rootElement);

      return dispatcher;
    },
    getURL: function () {
      return (0, _emberMetal.get)(this, 'router.url');
    },
    visit: function (url) {
      var _this = this;

      this.setupRouter();

      var bootOptions = this.__container__.lookup('-environment:main');

      var router = (0, _emberMetal.get)(this, 'router');

      var handleTransitionResolve = function () {
        if (!bootOptions.options.shouldRender) {
          // No rendering is needed, and routing has completed, simply return.
          return _this;
        } else {
          return new _emberRuntime.RSVP.Promise(function (resolve) {
            // Resolve once rendering is completed. `router.handleURL` returns the transition (as a thennable)
            // which resolves once the transition is completed, but the transition completion only queues up
            // a scheduled revalidation (into the `render` queue) in the Renderer.
            //
            // This uses `run.schedule('afterRender', ....)` to resolve after that rendering has completed.
            _emberMetal.run.schedule('afterRender', null, resolve, _this);
          });
        }
      };

      var handleTransitionReject = function (error) {
        if (error.error) {
          throw error.error;
        } else if (error.name === 'TransitionAborted' && router._routerMicrolib.activeTransition) {
          return router._routerMicrolib.activeTransition.then(handleTransitionResolve, handleTransitionReject);
        } else if (error.name === 'TransitionAborted') {
          throw new Error(error.message);
        } else {
          throw error;
        }
      };

      var location = (0, _emberMetal.get)(router, 'location');

      // Keeps the location adapter's internal URL in-sync
      location.setURL(url);

      // getURL returns the set url with the rootURL stripped off
      return router.handleURL(location.getURL()).then(handleTransitionResolve, handleTransitionReject);
    }
  });

  ApplicationInstance.reopenClass({
    setupRegistry: function (registry) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      if (!options.toEnvironment) {
        options = new BootOptions(options);
      }

      registry.register('-environment:main', options.toEnvironment(), { instantiate: false });
      registry.register('service:-document', options.document, { instantiate: false });

      this._super(registry, options);
    }
  });

  /**
    A list of boot-time configuration options for customizing the behavior of
    an `Ember.ApplicationInstance`.
  
    This is an interface class that exists purely to document the available
    options; you do not need to construct it manually. Simply pass a regular
    JavaScript object containing the desired options into methods that require
    one of these options object:
  
    ```javascript
    MyApp.visit("/", { location: "none", rootElement: "#container" });
    ```
  
    Not all combinations of the supported options are valid. See the documentation
    on `Ember.Application#visit` for the supported configurations.
  
    Internal, experimental or otherwise unstable flags are marked as private.
  
    @class BootOptions
    @namespace ApplicationInstance
    @public
  */
  function BootOptions() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

    /**
      Provide a specific instance of jQuery. This is useful in conjunction with
      the `document` option, as it allows you to use a copy of `jQuery` that is
      appropriately bound to the foreign `document` (e.g. a jsdom).
       This is highly experimental and support very incomplete at the moment.
       @property jQuery
      @type Object
      @default auto-detected
      @private
    */
    this.jQuery = _emberViews.jQuery; // This default is overridable below

    /**
      Interactive mode: whether we need to set up event delegation and invoke
      lifecycle callbacks on Components.
       @property isInteractive
      @type boolean
      @default auto-detected
      @private
    */
    this.isInteractive = _emberEnvironment.environment.hasDOM; // This default is overridable below

    /**
      Run in a full browser environment.
       When this flag is set to `false`, it will disable most browser-specific
      and interactive features. Specifically:
       * It does not use `jQuery` to append the root view; the `rootElement`
        (either specified as a subsequent option or on the application itself)
        must already be an `Element` in the given `document` (as opposed to a
        string selector).
       * It does not set up an `EventDispatcher`.
       * It does not run any `Component` lifecycle hooks (such as `didInsertElement`).
       * It sets the `location` option to `"none"`. (If you would like to use
        the location adapter specified in the app's router instead, you can also
        specify `{ location: null }` to specifically opt-out.)
       @property isBrowser
      @type boolean
      @default auto-detected
      @public
    */
    if (options.isBrowser !== undefined) {
      this.isBrowser = !!options.isBrowser;
    } else {
      this.isBrowser = _emberEnvironment.environment.hasDOM;
    }

    if (!this.isBrowser) {
      this.jQuery = null;
      this.isInteractive = false;
      this.location = 'none';
    }

    /**
      Disable rendering completely.
       When this flag is set to `true`, it will disable the entire rendering
      pipeline. Essentially, this puts the app into "routing-only" mode. No
      templates will be rendered, and no Components will be created.
       @property shouldRender
      @type boolean
      @default true
      @public
    */
    if (options.shouldRender !== undefined) {
      this.shouldRender = !!options.shouldRender;
    } else {
      this.shouldRender = true;
    }

    if (!this.shouldRender) {
      this.jQuery = null;
      this.isInteractive = false;
    }

    /**
      If present, render into the given `Document` object instead of the
      global `window.document` object.
       In practice, this is only useful in non-browser environment or in
      non-interactive mode, because Ember's `jQuery` dependency is
      implicitly bound to the current document, causing event delegation
      to not work properly when the app is rendered into a foreign
      document object (such as an iframe's `contentDocument`).
       In non-browser mode, this could be a "`Document`-like" object as
      Ember only interact with a small subset of the DOM API in non-
      interactive mode. While the exact requirements have not yet been
      formalized, the `SimpleDOM` library's implementation is known to
      work.
       @property document
      @type Document
      @default the global `document` object
      @public
    */
    if (options.document) {
      this.document = options.document;
    } else {
      this.document = typeof document !== 'undefined' ? document : null;
    }

    /**
      If present, overrides the application's `rootElement` property on
      the instance. This is useful for testing environment, where you
      might want to append the root view to a fixture area.
       In non-browser mode, because Ember does not have access to jQuery,
      this options must be specified as a DOM `Element` object instead of
      a selector string.
       See the documentation on `Ember.Applications`'s `rootElement` for
      details.
       @property rootElement
      @type String|Element
      @default null
      @public
     */
    if (options.rootElement) {
      this.rootElement = options.rootElement;
    }

    // Set these options last to give the user a chance to override the
    // defaults from the "combo" options like `isBrowser` (although in
    // practice, the resulting combination is probably invalid)

    /**
      If present, overrides the router's `location` property with this
      value. This is useful for environments where trying to modify the
      URL would be inappropriate.
       @property location
      @type string
      @default null
      @public
    */
    if (options.location !== undefined) {
      this.location = options.location;
    }

    if (options.jQuery !== undefined) {
      this.jQuery = options.jQuery;
    }

    if (options.isInteractive !== undefined) {
      this.isInteractive = !!options.isInteractive;
    }
  }

  BootOptions.prototype.toEnvironment = function () {
    var env = (0, _emberUtils.assign)({}, _emberEnvironment.environment);
    // For compatibility with existing code
    env.hasDOM = this.isBrowser;
    env.isInteractive = this.isInteractive;
    env.options = this;
    return env;
  };

  Object.defineProperty(ApplicationInstance.prototype, 'registry', {
    configurable: true,
    enumerable: false,
    get: function () {
      return (0, _emberRuntime.buildFakeRegistryWithDeprecations)(this, 'ApplicationInstance');
    }
  });

  exports.default = ApplicationInstance;
});
enifed('ember-application/system/application', ['exports', 'ember-babel', 'ember-utils', 'ember-environment', 'ember-debug', 'ember-metal', 'ember-runtime', 'ember-views', 'ember-routing', 'ember-application/system/application-instance', 'container', 'ember-application/system/engine', 'ember-glimmer', 'ember/features'], function (exports, _emberBabel, _emberUtils, _emberEnvironment, _emberDebug, _emberMetal, _emberRuntime, _emberViews, _emberRouting, _applicationInstance, _container, _engine, _emberGlimmer, _features) {
  'use strict';

  var _templateObject = (0, _emberBabel.taggedTemplateLiteralLoose)(['-bucket-cache:main'], ['-bucket-cache:main']);

  var librariesRegistered = false;

  /**
    An instance of `Ember.Application` is the starting point for every Ember
    application. It helps to instantiate, initialize and coordinate the many
    objects that make up your app.
  
    Each Ember app has one and only one `Ember.Application` object. In fact, the
    very first thing you should do in your application is create the instance:
  
    ```javascript
    window.App = Ember.Application.create();
    ```
  
    Typically, the application object is the only global variable. All other
    classes in your app should be properties on the `Ember.Application` instance,
    which highlights its first role: a global namespace.
  
    For example, if you define a view class, it might look like this:
  
    ```javascript
    App.MyView = Ember.View.extend();
    ```
  
    By default, calling `Ember.Application.create()` will automatically initialize
    your application by calling the `Ember.Application.initialize()` method. If
    you need to delay initialization, you can call your app's `deferReadiness()`
    method. When you are ready for your app to be initialized, call its
    `advanceReadiness()` method.
  
    You can define a `ready` method on the `Ember.Application` instance, which
    will be run by Ember when the application is initialized.
  
    Because `Ember.Application` inherits from `Ember.Namespace`, any classes
    you create will have useful string representations when calling `toString()`.
    See the `Ember.Namespace` documentation for more information.
  
    While you can think of your `Ember.Application` as a container that holds the
    other classes in your application, there are several other responsibilities
    going on under-the-hood that you may want to understand.
  
    ### Event Delegation
  
    Ember uses a technique called _event delegation_. This allows the framework
    to set up a global, shared event listener instead of requiring each view to
    do it manually. For example, instead of each view registering its own
    `mousedown` listener on its associated element, Ember sets up a `mousedown`
    listener on the `body`.
  
    If a `mousedown` event occurs, Ember will look at the target of the event and
    start walking up the DOM node tree, finding corresponding views and invoking
    their `mouseDown` method as it goes.
  
    `Ember.Application` has a number of default events that it listens for, as
    well as a mapping from lowercase events to camel-cased view method names. For
    example, the `keypress` event causes the `keyPress` method on the view to be
    called, the `dblclick` event causes `doubleClick` to be called, and so on.
  
    If there is a bubbling browser event that Ember does not listen for by
    default, you can specify custom events and their corresponding view method
    names by setting the application's `customEvents` property:
  
    ```javascript
    let App = Ember.Application.create({
      customEvents: {
        // add support for the paste event
        paste: 'paste'
      }
    });
    ```
  
    To prevent Ember from setting up a listener for a default event,
    specify the event name with a `null` value in the `customEvents`
    property:
  
    ```javascript
    let App = Ember.Application.create({
      customEvents: {
        // prevent listeners for mouseenter/mouseleave events
        mouseenter: null,
        mouseleave: null
      }
    });
    ```
  
    By default, the application sets up these event listeners on the document
    body. However, in cases where you are embedding an Ember application inside
    an existing page, you may want it to set up the listeners on an element
    inside the body.
  
    For example, if only events inside a DOM element with the ID of `ember-app`
    should be delegated, set your application's `rootElement` property:
  
    ```javascript
    let App = Ember.Application.create({
      rootElement: '#ember-app'
    });
    ```
  
    The `rootElement` can be either a DOM element or a jQuery-compatible selector
    string. Note that *views appended to the DOM outside the root element will
    not receive events.* If you specify a custom root element, make sure you only
    append views inside it!
  
    To learn more about the events Ember components use, see
    [components/handling-events](https://guides.emberjs.com/v2.6.0/components/handling-events/#toc_event-names).
  
    ### Initializers
  
    Libraries on top of Ember can add initializers, like so:
  
    ```javascript
    Ember.Application.initializer({
      name: 'api-adapter',
  
      initialize: function(application) {
        application.register('api-adapter:main', ApiAdapter);
      }
    });
    ```
  
    Initializers provide an opportunity to access the internal registry, which
    organizes the different components of an Ember application. Additionally
    they provide a chance to access the instantiated application. Beyond
    being used for libraries, initializers are also a great way to organize
    dependency injection or setup in your own application.
  
    ### Routing
  
    In addition to creating your application's router, `Ember.Application` is
    also responsible for telling the router when to start routing. Transitions
    between routes can be logged with the `LOG_TRANSITIONS` flag, and more
    detailed intra-transition logging can be logged with
    the `LOG_TRANSITIONS_INTERNAL` flag:
  
    ```javascript
    let App = Ember.Application.create({
      LOG_TRANSITIONS: true, // basic logging of successful transitions
      LOG_TRANSITIONS_INTERNAL: true // detailed logging of all routing steps
    });
    ```
  
    By default, the router will begin trying to translate the current URL into
    application state once the browser emits the `DOMContentReady` event. If you
    need to defer routing, you can call the application's `deferReadiness()`
    method. Once routing can begin, call the `advanceReadiness()` method.
  
    If there is any setup required before routing begins, you can implement a
    `ready()` method on your app that will be invoked immediately before routing
    begins.
  
    @class Application
    @extends Engine
    @uses RegistryProxyMixin
    @public
  */

  var Application = _engine.default.extend({
    /**
      The root DOM element of the Application. This can be specified as an
      element or a
      [jQuery-compatible selector string](http://api.jquery.com/category/selectors/).
       This is the element that will be passed to the Application's,
      `eventDispatcher`, which sets up the listeners for event delegation. Every
      view in your application should be a child of the element you specify here.
       @property rootElement
      @type DOMElement
      @default 'body'
      @public
    */
    rootElement: 'body',

    /**
      The `Ember.EventDispatcher` responsible for delegating events to this
      application's views.
       The event dispatcher is created by the application at initialization time
      and sets up event listeners on the DOM element described by the
      application's `rootElement` property.
       See the documentation for `Ember.EventDispatcher` for more information.
       @property eventDispatcher
      @type Ember.EventDispatcher
      @default null
      @public
    */
    eventDispatcher: null,

    /**
      The DOM events for which the event dispatcher should listen.
       By default, the application's `Ember.EventDispatcher` listens
      for a set of standard DOM events, such as `mousedown` and
      `keyup`, and delegates them to your application's `Ember.View`
      instances.
       If you would like additional bubbling events to be delegated to your
      views, set your `Ember.Application`'s `customEvents` property
      to a hash containing the DOM event name as the key and the
      corresponding view method name as the value. Setting an event to
      a value of `null` will prevent a default event listener from being
      added for that event.
       To add new events to be listened to:
       ```javascript
      let App = Ember.Application.create({
        customEvents: {
          // add support for the paste event
          paste: 'paste'
        }
      });
      ```
       To prevent default events from being listened to:
       ```javascript
      let App = Ember.Application.create({
        customEvents: {
          // remove support for mouseenter / mouseleave events
          mouseenter: null,
          mouseleave: null
        }
      });
      ```
      @property customEvents
      @type Object
      @default null
      @public
    */
    customEvents: null,

    /**
      Whether the application should automatically start routing and render
      templates to the `rootElement` on DOM ready. While default by true,
      other environments such as FastBoot or a testing harness can set this
      property to `false` and control the precise timing and behavior of the boot
      process.
       @property autoboot
      @type Boolean
      @default true
      @private
    */
    autoboot: true,

    /**
      Whether the application should be configured for the legacy "globals mode".
      Under this mode, the Application object serves as a global namespace for all
      classes.
       ```javascript
      let App = Ember.Application.create({
        ...
      });
       App.Router.reopen({
        location: 'none'
      });
       App.Router.map({
        ...
      });
       App.MyComponent = Ember.Component.extend({
        ...
      });
      ```
       This flag also exposes other internal APIs that assumes the existence of
      a special "default instance", like `App.__container__.lookup(...)`.
       This option is currently not configurable, its value is derived from
      the `autoboot` flag – disabling `autoboot` also implies opting-out of
      globals mode support, although they are ultimately orthogonal concerns.
       Some of the global modes features are already deprecated in 1.x. The
      existence of this flag is to untangle the globals mode code paths from
      the autoboot code paths, so that these legacy features can be reviewed
      for deprecation/removal separately.
       Forcing the (autoboot=true, _globalsMode=false) here and running the tests
      would reveal all the places where we are still relying on these legacy
      behavior internally (mostly just tests).
       @property _globalsMode
      @type Boolean
      @default true
      @private
    */
    _globalsMode: true,

    init: function (options) {
      this._super.apply(this, arguments);

      if (!this.$) {
        this.$ = _emberViews.jQuery;
      }

      registerLibraries();

      if (true) {
        logLibraryVersions();
      }

      // Start off the number of deferrals at 1. This will be decremented by
      // the Application's own `boot` method.
      this._readinessDeferrals = 1;
      this._booted = false;

      this.autoboot = this._globalsMode = !!this.autoboot;

      if (this._globalsMode) {
        this._prepareForGlobalsMode();
      }

      if (this.autoboot) {
        this.waitForDOMReady();
      }
    },
    buildInstance: function () {
      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      options.base = this;
      options.application = this;
      return _applicationInstance.default.create(options);
    },
    _prepareForGlobalsMode: function () {
      // Create subclass of Ember.Router for this Application instance.
      // This is to ensure that someone reopening `App.Router` does not
      // tamper with the default `Ember.Router`.
      this.Router = (this.Router || _emberRouting.Router).extend();

      this._buildDeprecatedInstance();
    },
    _buildDeprecatedInstance: function () {
      // Build a default instance
      var instance = this.buildInstance();

      // Legacy support for App.__container__ and other global methods
      // on App that rely on a single, default instance.
      this.__deprecatedInstance__ = instance;
      this.__container__ = instance.__container__;
    },
    waitForDOMReady: function () {
      if (!this.$ || this.$.isReady) {
        _emberMetal.run.schedule('actions', this, 'domReady');
      } else {
        this.$().ready(_emberMetal.run.bind(this, 'domReady'));
      }
    },
    domReady: function () {
      if (this.isDestroyed) {
        return;
      }

      this._bootSync();

      // Continues to `didBecomeReady`
    },
    deferReadiness: function () {
      (true && !(this instanceof Application) && (0, _emberDebug.assert)('You must call deferReadiness on an instance of Ember.Application', this instanceof Application));
      (true && !(this._readinessDeferrals > 0) && (0, _emberDebug.assert)('You cannot defer readiness since the `ready()` hook has already been called.', this._readinessDeferrals > 0));

      this._readinessDeferrals++;
    },
    advanceReadiness: function () {
      (true && !(this instanceof Application) && (0, _emberDebug.assert)('You must call advanceReadiness on an instance of Ember.Application', this instanceof Application));

      this._readinessDeferrals--;

      if (this._readinessDeferrals === 0) {
        _emberMetal.run.once(this, this.didBecomeReady);
      }
    },
    boot: function () {
      if (this._bootPromise) {
        return this._bootPromise;
      }

      try {
        this._bootSync();
      } catch (_) {
        // Ignore th error: in the asynchronous boot path, the error is already reflected
        // in the promise rejection
      }

      return this._bootPromise;
    },
    _bootSync: function () {
      if (this._booted) {
        return;
      }

      // Even though this returns synchronously, we still need to make sure the
      // boot promise exists for book-keeping purposes: if anything went wrong in
      // the boot process, we need to store the error as a rejection on the boot
      // promise so that a future caller of `boot()` can tell what failed.
      var defer = this._bootResolver = _emberRuntime.RSVP.defer();
      this._bootPromise = defer.promise;

      try {
        this.runInitializers();
        (0, _emberRuntime.runLoadHooks)('application', this);
        this.advanceReadiness();
        // Continues to `didBecomeReady`
      } catch (error) {
        // For the asynchronous boot path
        defer.reject(error);

        // For the synchronous boot path
        throw error;
      }
    },
    reset: function () {
      (true && !(this._globalsMode && this.autoboot) && (0, _emberDebug.assert)('Calling reset() on instances of `Ember.Application` is not\n            supported when globals mode is disabled; call `visit()` to\n            create new `Ember.ApplicationInstance`s and dispose them\n            via their `destroy()` method instead.', this._globalsMode && this.autoboot));


      var instance = this.__deprecatedInstance__;

      this._readinessDeferrals = 1;
      this._bootPromise = null;
      this._bootResolver = null;
      this._booted = false;

      function handleReset() {
        (0, _emberMetal.run)(instance, 'destroy');
        this._buildDeprecatedInstance();
        _emberMetal.run.schedule('actions', this, '_bootSync');
      }

      _emberMetal.run.join(this, handleReset);
    },
    didBecomeReady: function () {
      try {
        // TODO: Is this still needed for _globalsMode = false?
        if (!(0, _emberDebug.isTesting)()) {
          // Eagerly name all classes that are already loaded
          _emberRuntime.Namespace.processAll();
          (0, _emberRuntime.setNamespaceSearchDisabled)(true);
        }

        // See documentation on `_autoboot()` for details
        if (this.autoboot) {
          var instance = void 0;

          if (this._globalsMode) {
            // If we already have the __deprecatedInstance__ lying around, boot it to
            // avoid unnecessary work
            instance = this.__deprecatedInstance__;
          } else {
            // Otherwise, build an instance and boot it. This is currently unreachable,
            // because we forced _globalsMode to === autoboot; but having this branch
            // allows us to locally toggle that flag for weeding out legacy globals mode
            // dependencies independently
            instance = this.buildInstance();
          }

          instance._bootSync();

          // TODO: App.ready() is not called when autoboot is disabled, is this correct?
          this.ready();

          instance.startRouting();
        }

        // For the asynchronous boot path
        this._bootResolver.resolve(this);

        // For the synchronous boot path
        this._booted = true;
      } catch (error) {
        // For the asynchronous boot path
        this._bootResolver.reject(error);

        // For the synchronous boot path
        throw error;
      }
    },
    ready: function () {
      return this;
    },
    willDestroy: function () {
      this._super.apply(this, arguments);
      (0, _emberRuntime.setNamespaceSearchDisabled)(false);
      this._booted = false;
      this._bootPromise = null;
      this._bootResolver = null;

      if (_emberRuntime._loaded.application === this) {
        _emberRuntime._loaded.application = undefined;
      }

      if (this._globalsMode && this.__deprecatedInstance__) {
        this.__deprecatedInstance__.destroy();
      }
    },
    visit: function (url, options) {
      var _this = this;

      return this.boot().then(function () {
        var instance = _this.buildInstance();

        return instance.boot(options).then(function () {
          return instance.visit(url);
        }).catch(function (error) {
          (0, _emberMetal.run)(instance, 'destroy');
          throw error;
        });
      });
    }
  });

  Object.defineProperty(Application.prototype, 'registry', {
    configurable: true,
    enumerable: false,
    get: function () {
      return (0, _emberRuntime.buildFakeRegistryWithDeprecations)(this, 'Application');
    }
  });

  Application.reopenClass({
    buildRegistry: function (application) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      var registry = this._super.apply(this, arguments);

      commonSetupRegistry(registry);

      (0, _emberGlimmer.setupApplicationRegistry)(registry);

      return registry;
    }
  });

  function commonSetupRegistry(registry) {
    registry.register('router:main', _emberRouting.Router.extend());
    registry.register('-view-registry:main', {
      create: function () {
        return (0, _emberUtils.dictionary)(null);
      }
    });

    registry.register('route:basic', _emberRouting.Route);
    registry.register('event_dispatcher:main', _emberViews.EventDispatcher);

    registry.injection('router:main', 'namespace', 'application:main');

    registry.register('location:auto', _emberRouting.AutoLocation);
    registry.register('location:hash', _emberRouting.HashLocation);
    registry.register('location:history', _emberRouting.HistoryLocation);
    registry.register('location:none', _emberRouting.NoneLocation);

    registry.register((0, _container.privatize)(_templateObject), _emberRouting.BucketCache);

    if (_features.EMBER_ROUTING_ROUTER_SERVICE) {
      registry.register('service:router', _emberRouting.RouterService);
      registry.injection('service:router', '_router', 'router:main');
    }
  }

  function registerLibraries() {
    if (!librariesRegistered) {
      librariesRegistered = true;

      if (_emberEnvironment.environment.hasDOM && typeof _emberViews.jQuery === 'function') {
        _emberMetal.libraries.registerCoreLibrary('jQuery', (0, _emberViews.jQuery)().jquery);
      }
    }
  }

  function logLibraryVersions() {
    if (true) {
      if (_emberEnvironment.ENV.LOG_VERSION) {
        // we only need to see this once per Application#init
        _emberEnvironment.ENV.LOG_VERSION = false;
        var libs = _emberMetal.libraries._registry;

        var nameLengths = libs.map(function (item) {
          return (0, _emberMetal.get)(item, 'name.length');
        });

        var maxNameLength = Math.max.apply(this, nameLengths);

        (0, _emberDebug.debug)('-------------------------------');
        for (var i = 0; i < libs.length; i++) {
          var lib = libs[i];
          var spaces = new Array(maxNameLength - lib.name.length + 1).join(' ');
          (0, _emberDebug.debug)([lib.name, spaces, ' : ', lib.version].join(''));
        }
        (0, _emberDebug.debug)('-------------------------------');
      }
    }
  }

  exports.default = Application;
});
enifed('ember-application/system/engine-instance', ['exports', 'ember-babel', 'ember-utils', 'ember-runtime', 'ember-debug', 'ember-metal', 'container', 'ember-application/system/engine-parent'], function (exports, _emberBabel, _emberUtils, _emberRuntime, _emberDebug, _emberMetal, _container, _engineParent) {
  'use strict';

  var _templateObject = (0, _emberBabel.taggedTemplateLiteralLoose)(['-bucket-cache:main'], ['-bucket-cache:main']);

  /**
    The `EngineInstance` encapsulates all of the stateful aspects of a
    running `Engine`.
  
    @public
    @class EngineInstance
    @extends EmberObject
    @uses RegistryProxyMixin
    @uses ContainerProxyMixin
  */

  var EngineInstance = _emberRuntime.Object.extend(_emberRuntime.RegistryProxyMixin, _emberRuntime.ContainerProxyMixin, {
    /**
      The base `Engine` for which this is an instance.
       @property {Ember.Engine} engine
      @private
    */
    base: null,

    init: function () {
      this._super.apply(this, arguments);

      (0, _emberUtils.guidFor)(this);

      var base = this.base;

      if (!base) {
        base = this.application;
        this.base = base;
      }

      // Create a per-instance registry that will use the application's registry
      // as a fallback for resolving registrations.
      var registry = this.__registry__ = new _container.Registry({
        fallback: base.__registry__
      });

      // Create a per-instance container from the instance's registry
      this.__container__ = registry.container({ owner: this });

      this._booted = false;
    },
    boot: function (options) {
      var _this = this;

      if (this._bootPromise) {
        return this._bootPromise;
      }

      this._bootPromise = new _emberRuntime.RSVP.Promise(function (resolve) {
        return resolve(_this._bootSync(options));
      });

      return this._bootPromise;
    },
    _bootSync: function (options) {
      if (this._booted) {
        return this;
      }

      (true && !((0, _engineParent.getEngineParent)(this)) && (0, _emberDebug.assert)('An engine instance\'s parent must be set via `setEngineParent(engine, parent)` prior to calling `engine.boot()`.', (0, _engineParent.getEngineParent)(this)));


      this.cloneParentDependencies();

      this.setupRegistry(options);

      this.base.runInstanceInitializers(this);

      this._booted = true;

      return this;
    },
    setupRegistry: function () {
      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.__container__.lookup('-environment:main');

      this.constructor.setupRegistry(this.__registry__, options);
    },
    unregister: function (fullName) {
      this.__container__.reset(fullName);
      this._super.apply(this, arguments);
    },
    buildChildEngineInstance: function (name) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      var Engine = this.lookup('engine:' + name);

      if (!Engine) {
        throw new _emberDebug.Error('You attempted to mount the engine \'' + name + '\', but it is not registered with its parent.');
      }

      var engineInstance = Engine.buildInstance(options);

      (0, _engineParent.setEngineParent)(engineInstance, this);

      return engineInstance;
    },
    cloneParentDependencies: function () {
      var _this2 = this;

      var parent = (0, _engineParent.getEngineParent)(this);

      var registrations = ['route:basic', 'service:-routing', 'service:-glimmer-environment'];

      registrations.forEach(function (key) {
        return _this2.register(key, parent.resolveRegistration(key));
      });

      var env = parent.lookup('-environment:main');
      this.register('-environment:main', env, { instantiate: false });

      var singletons = ['router:main', (0, _container.privatize)(_templateObject), '-view-registry:main', 'renderer:-' + (env.isInteractive ? 'dom' : 'inert'), 'service:-document'];

      if (env.isInteractive) {
        singletons.push('event_dispatcher:main');
      }

      singletons.forEach(function (key) {
        return _this2.register(key, parent.lookup(key), { instantiate: false });
      });

      this.inject('view', '_environment', '-environment:main');
      this.inject('route', '_environment', '-environment:main');
    }
  });

  EngineInstance.reopenClass({
    setupRegistry: function (registry, options) {
      // when no options/environment is present, do nothing
      if (!options) {
        return;
      }

      registry.injection('view', '_environment', '-environment:main');
      registry.injection('route', '_environment', '-environment:main');

      if (options.isInteractive) {
        registry.injection('view', 'renderer', 'renderer:-dom');
        registry.injection('component', 'renderer', 'renderer:-dom');
      } else {
        registry.injection('view', 'renderer', 'renderer:-inert');
        registry.injection('component', 'renderer', 'renderer:-inert');
      }
    }
  });

  exports.default = EngineInstance;
});
enifed('ember-application/system/engine-parent', ['exports', 'ember-utils'], function (exports, _emberUtils) {
  'use strict';

  exports.ENGINE_PARENT = undefined;
  exports.getEngineParent = getEngineParent;
  exports.setEngineParent = setEngineParent;
  var ENGINE_PARENT = exports.ENGINE_PARENT = (0, _emberUtils.symbol)('ENGINE_PARENT');

  /**
    `getEngineParent` retrieves an engine instance's parent instance.
  
    @method getEngineParent
    @param {EngineInstance} engine An engine instance.
    @return {EngineInstance} The parent engine instance.
    @for @ember/engine
    @static
    @private
  */
  function getEngineParent(engine) {
    return engine[ENGINE_PARENT];
  }

  /**
    `setEngineParent` sets an engine instance's parent instance.
  
    @method setEngineParent
    @param {EngineInstance} engine An engine instance.
    @param {EngineInstance} parent The parent engine instance.
    @private
  */
  function setEngineParent(engine, parent) {
    engine[ENGINE_PARENT] = parent;
  }
});
enifed('ember-application/system/engine', ['exports', 'ember-babel', 'ember-utils', 'ember-runtime', 'container', 'dag-map', 'ember-debug', 'ember-metal', 'ember-application/system/resolver', 'ember-application/system/engine-instance', 'ember-routing', 'ember-extension-support', 'ember-views', 'ember-glimmer'], function (exports, _emberBabel, _emberUtils, _emberRuntime, _container, _dagMap, _emberDebug, _emberMetal, _resolver, _engineInstance, _emberRouting, _emberExtensionSupport, _emberViews, _emberGlimmer) {
  'use strict';

  var _templateObject = (0, _emberBabel.taggedTemplateLiteralLoose)(['-bucket-cache:main'], ['-bucket-cache:main']);

  function props(obj) {
    var properties = [];

    for (var key in obj) {
      properties.push(key);
    }

    return properties;
  }

  /**
    The `Engine` class contains core functionality for both applications and
    engines.
  
    Each engine manages a registry that's used for dependency injection and
    exposed through `RegistryProxy`.
  
    Engines also manage initializers and instance initializers.
  
    Engines can spawn `EngineInstance` instances via `buildInstance()`.
  
    @class Engine
    @extends Ember.Namespace
    @uses RegistryProxy
    @public
  */
  var Engine = _emberRuntime.Namespace.extend(_emberRuntime.RegistryProxyMixin, {
    init: function () {
      this._super.apply(this, arguments);

      this.buildRegistry();
    },


    /**
      A private flag indicating whether an engine's initializers have run yet.
       @private
      @property _initializersRan
    */
    _initializersRan: false,

    ensureInitializers: function () {
      if (!this._initializersRan) {
        this.runInitializers();
        this._initializersRan = true;
      }
    },
    buildInstance: function () {
      var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      this.ensureInitializers();
      options.base = this;
      return _engineInstance.default.create(options);
    },
    buildRegistry: function () {
      var registry = this.__registry__ = this.constructor.buildRegistry(this);

      return registry;
    },
    initializer: function (options) {
      this.constructor.initializer(options);
    },
    instanceInitializer: function (options) {
      this.constructor.instanceInitializer(options);
    },
    runInitializers: function () {
      var _this = this;

      this._runInitializer('initializers', function (name, initializer) {
        (true && !(!!initializer) && (0, _emberDebug.assert)('No application initializer named \'' + name + '\'', !!initializer));

        if (initializer.initialize.length === 2) {
          (true && !(false) && (0, _emberDebug.deprecate)('The `initialize` method for Application initializer \'' + name + '\' should take only one argument - `App`, an instance of an `Application`.', false, {
            id: 'ember-application.app-initializer-initialize-arguments',
            until: '3.0.0',
            url: 'https://emberjs.com/deprecations/v2.x/#toc_initializer-arity'
          }));


          initializer.initialize(_this.__registry__, _this);
        } else {
          initializer.initialize(_this);
        }
      });
    },
    runInstanceInitializers: function (instance) {
      this._runInitializer('instanceInitializers', function (name, initializer) {
        (true && !(!!initializer) && (0, _emberDebug.assert)('No instance initializer named \'' + name + '\'', !!initializer));

        initializer.initialize(instance);
      });
    },
    _runInitializer: function (bucketName, cb) {
      var initializersByName = (0, _emberMetal.get)(this.constructor, bucketName);
      var initializers = props(initializersByName);
      var graph = new _dagMap.default();
      var initializer = void 0;

      for (var i = 0; i < initializers.length; i++) {
        initializer = initializersByName[initializers[i]];
        graph.add(initializer.name, initializer, initializer.before, initializer.after);
      }

      graph.topsort(cb);
    }
  });

  Engine.reopenClass({
    initializers: Object.create(null),
    instanceInitializers: Object.create(null),

    /**
      The goal of initializers should be to register dependencies and injections.
      This phase runs once. Because these initializers may load code, they are
      allowed to defer application readiness and advance it. If you need to access
      the container or store you should use an InstanceInitializer that will be run
      after all initializers and therefore after all code is loaded and the app is
      ready.
       Initializer receives an object which has the following attributes:
      `name`, `before`, `after`, `initialize`. The only required attribute is
      `initialize`, all others are optional.
       * `name` allows you to specify under which name the initializer is registered.
      This must be a unique name, as trying to register two initializers with the
      same name will result in an error.
       ```app/initializer/named-initializer.js
      import { debug } from '@ember/debug';
       export function initialize() {
        debug('Running namedInitializer!');
      }
       export default {
        name: 'named-initializer',
        initialize
      };
      ```
       * `before` and `after` are used to ensure that this initializer is ran prior
      or after the one identified by the value. This value can be a single string
      or an array of strings, referencing the `name` of other initializers.
       An example of ordering initializers, we create an initializer named `first`:
       ```app/initializer/first.js
      import { debug } from '@ember/debug';
       export function initialize() {
        debug('First initializer!');
      }
       export default {
        name: 'first',
        initialize
      };
      ```
       ```bash
      // DEBUG: First initializer!
      ```
       We add another initializer named `second`, specifying that it should run
      after the initializer named `first`:
       ```app/initializer/second.js
      import { debug } from '@ember/debug';
       export function initialize() {
        debug('Second initializer!');
      }
       export default {
        name: 'second',
        after: 'first',
        initialize
      };
      ```
       ```
      // DEBUG: First initializer!
      // DEBUG: Second initializer!
      ```
       Afterwards we add a further initializer named `pre`, this time specifying
      that it should run before the initializer named `first`:
       ```app/initializer/pre.js
      import { debug } from '@ember/debug';
       export function initialize() {
        debug('Pre initializer!');
      }
       export default {
        name: 'pre',
        before: 'first',
        initialize
      };
      ```
       ```bash
      // DEBUG: Pre initializer!
      // DEBUG: First initializer!
      // DEBUG: Second initializer!
      ```
       Finally we add an initializer named `post`, specifying it should run after
      both the `first` and the `second` initializers:
       ```app/initializer/post.js
      import { debug } from '@ember/debug';
       export function initialize() {
        debug('Post initializer!');
      }
       export default {
        name: 'post',
        after: ['first', 'second'],
        initialize
      };
      ```
       ```bash
      // DEBUG: Pre initializer!
      // DEBUG: First initializer!
      // DEBUG: Second initializer!
      // DEBUG: Post initializer!
      ```
       * `initialize` is a callback function that receives one argument,
        `application`, on which you can operate.
       Example of using `application` to register an adapter:
       ```app/initializer/api-adapter.js
      import ApiAdapter from '../utils/api-adapter';
       export function initialize(application) {
        application.register('api-adapter:main', ApiAdapter);
      }
       export default {
        name: 'post',
        after: ['first', 'second'],
        initialize
      };
      ```
       @method initializer
      @param initializer {Object}
      @public
    */

    initializer: buildInitializerMethod('initializers', 'initializer'),

    /**
      Instance initializers run after all initializers have run. Because
      instance initializers run after the app is fully set up. We have access
      to the store, container, and other items. However, these initializers run
      after code has loaded and are not allowed to defer readiness.
       Instance initializer receives an object which has the following attributes:
      `name`, `before`, `after`, `initialize`. The only required attribute is
      `initialize`, all others are optional.
       * `name` allows you to specify under which name the instanceInitializer is
      registered. This must be a unique name, as trying to register two
      instanceInitializer with the same name will result in an error.
       ```app/initializer/named-instance-initializer.js
      import { debug } from '@ember/debug';
       export function initialize() {
        debug('Running named-instance-initializer!');
      }
       export default {
        name: 'named-instance-initializer',
        initialize
      };
      ```
       * `before` and `after` are used to ensure that this initializer is ran prior
      or after the one identified by the value. This value can be a single string
      or an array of strings, referencing the `name` of other initializers.
       * See Ember.Application.initializer for discussion on the usage of before
      and after.
       Example instanceInitializer to preload data into the store.
       ```app/initializer/preload-data.js
      import $ from 'jquery';
       export function initialize(application) {
          var userConfig, userConfigEncoded, store;
          // We have a HTML escaped JSON representation of the user's basic
          // configuration generated server side and stored in the DOM of the main
          // index.html file. This allows the app to have access to a set of data
          // without making any additional remote calls. Good for basic data that is
          // needed for immediate rendering of the page. Keep in mind, this data,
          // like all local models and data can be manipulated by the user, so it
          // should not be relied upon for security or authorization.
           // Grab the encoded data from the meta tag
          userConfigEncoded = $('head meta[name=app-user-config]').attr('content');
           // Unescape the text, then parse the resulting JSON into a real object
          userConfig = JSON.parse(unescape(userConfigEncoded));
           // Lookup the store
          store = application.lookup('service:store');
           // Push the encoded JSON into the store
          store.pushPayload(userConfig);
      }
       export default {
        name: 'named-instance-initializer',
        initialize
      };
      ```
       @method instanceInitializer
      @param instanceInitializer
      @public
    */
    instanceInitializer: buildInitializerMethod('instanceInitializers', 'instance initializer'),

    buildRegistry: function (namespace) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      var registry = new _container.Registry({
        resolver: resolverFor(namespace)
      });

      registry.set = _emberMetal.set;

      registry.register('application:main', namespace, { instantiate: false });

      commonSetupRegistry(registry);
      (0, _emberGlimmer.setupEngineRegistry)(registry);

      return registry;
    },


    /**
      Set this to provide an alternate class to `Ember.DefaultResolver`
       @deprecated Use 'Resolver' instead
      @property resolver
      @public
    */
    resolver: null,

    /**
      Set this to provide an alternate class to `Ember.DefaultResolver`
       @property resolver
      @public
    */
    Resolver: null
  });

  /**
    This function defines the default lookup rules for container lookups:
  
    * templates are looked up on `Ember.TEMPLATES`
    * other names are looked up on the application after classifying the name.
      For example, `controller:post` looks up `App.PostController` by default.
    * if the default lookup fails, look for registered classes on the container
  
    This allows the application to register default injections in the container
    that could be overridden by the normal naming convention.
  
    @private
    @method resolverFor
    @param {Ember.Namespace} namespace the namespace to look for classes
    @return {*} the resolved value for a given lookup
  */
  function resolverFor(namespace) {
    var ResolverClass = namespace.get('Resolver') || _resolver.default;

    return ResolverClass.create({
      namespace: namespace
    });
  }

  function buildInitializerMethod(bucketName, humanName) {
    return function (initializer) {
      // If this is the first initializer being added to a subclass, we are going to reopen the class
      // to make sure we have a new `initializers` object, which extends from the parent class' using
      // prototypal inheritance. Without this, attempting to add initializers to the subclass would
      // pollute the parent class as well as other subclasses.
      if (this.superclass[bucketName] !== undefined && this.superclass[bucketName] === this[bucketName]) {
        var attrs = {};
        attrs[bucketName] = Object.create(this[bucketName]);
        this.reopenClass(attrs);
      }

      (true && !(!this[bucketName][initializer.name]) && (0, _emberDebug.assert)('The ' + humanName + ' \'' + initializer.name + '\' has already been registered', !this[bucketName][initializer.name]));
      (true && !((0, _emberUtils.canInvoke)(initializer, 'initialize')) && (0, _emberDebug.assert)('An ' + humanName + ' cannot be registered without an initialize function', (0, _emberUtils.canInvoke)(initializer, 'initialize')));
      (true && !(initializer.name !== undefined) && (0, _emberDebug.assert)('An ' + humanName + ' cannot be registered without a name property', initializer.name !== undefined));


      this[bucketName][initializer.name] = initializer;
    };
  }

  function commonSetupRegistry(registry) {
    registry.optionsForType('component', { singleton: false });
    registry.optionsForType('view', { singleton: false });

    registry.register('controller:basic', _emberRuntime.Controller, { instantiate: false });

    registry.injection('view', '_viewRegistry', '-view-registry:main');
    registry.injection('renderer', '_viewRegistry', '-view-registry:main');
    registry.injection('event_dispatcher:main', '_viewRegistry', '-view-registry:main');

    registry.injection('route', '_topLevelViewTemplate', 'template:-outlet');

    registry.injection('view:-outlet', 'namespace', 'application:main');

    registry.injection('controller', 'target', 'router:main');
    registry.injection('controller', 'namespace', 'application:main');

    registry.injection('router', '_bucketCache', (0, _container.privatize)(_templateObject));
    registry.injection('route', '_bucketCache', (0, _container.privatize)(_templateObject));

    registry.injection('route', 'router', 'router:main');

    // Register the routing service...
    registry.register('service:-routing', _emberRouting.RoutingService);
    // Then inject the app router into it
    registry.injection('service:-routing', 'router', 'router:main');

    // DEBUGGING
    registry.register('resolver-for-debugging:main', registry.resolver, { instantiate: false });
    registry.injection('container-debug-adapter:main', 'resolver', 'resolver-for-debugging:main');
    registry.injection('data-adapter:main', 'containerDebugAdapter', 'container-debug-adapter:main');
    // Custom resolver authors may want to register their own ContainerDebugAdapter with this key

    registry.register('container-debug-adapter:main', _emberExtensionSupport.ContainerDebugAdapter);

    registry.register('component-lookup:main', _emberViews.ComponentLookup);
  }

  exports.default = Engine;
});
enifed('ember-application/system/resolver', ['exports', 'ember-utils', 'ember-metal', 'ember-debug', 'ember-runtime', 'ember-application/utils/validate-type', 'ember-glimmer'], function (exports, _emberUtils, _emberMetal, _emberDebug, _emberRuntime, _validateType, _emberGlimmer) {
  'use strict';

  exports.Resolver = undefined;
  /**
  @module @ember/application
  */

  var Resolver = exports.Resolver = _emberRuntime.Object.extend({
    /*
      This will be set to the Application instance when it is
      created.
       @property namespace
    */
    namespace: null,
    normalize: null, // required
    resolve: null, // required
    parseName: null, // required
    lookupDescription: null, // required
    makeToString: null, // required
    resolveOther: null, // required
    _logLookup: null // required
  });

  /**
    The DefaultResolver defines the default lookup rules to resolve
    container lookups before consulting the container for registered
    items:
  
    * templates are looked up on `Ember.TEMPLATES`
    * other names are looked up on the application after converting
      the name. For example, `controller:post` looks up
      `App.PostController` by default.
    * there are some nuances (see examples below)
  
    ### How Resolving Works
  
    The container calls this object's `resolve` method with the
    `fullName` argument.
  
    It first parses the fullName into an object using `parseName`.
  
    Then it checks for the presence of a type-specific instance
    method of the form `resolve[Type]` and calls it if it exists.
    For example if it was resolving 'template:post', it would call
    the `resolveTemplate` method.
  
    Its last resort is to call the `resolveOther` method.
  
    The methods of this object are designed to be easy to override
    in a subclass. For example, you could enhance how a template
    is resolved like so:
  
    ```app/app.js
    import Application from '@ember/application';
    import GlobalsResolver from '@ember/application/globals-resolver';
  
    App = Application.create({
      Resolver: GlobalsResolver.extend({
        resolveTemplate(parsedName) {
          let resolvedTemplate = this._super(parsedName);
          if (resolvedTemplate) { return resolvedTemplate; }
  
          return Ember.TEMPLATES['not_found'];
        }
      })
    });
    ```
  
    Some examples of how names are resolved:
  
    ```text
    'template:post'           //=> Ember.TEMPLATES['post']
    'template:posts/byline'   //=> Ember.TEMPLATES['posts/byline']
    'template:posts.byline'   //=> Ember.TEMPLATES['posts/byline']
    'template:blogPost'       //=> Ember.TEMPLATES['blog-post']
    'controller:post'         //=> App.PostController
    'controller:posts.index'  //=> App.PostsIndexController
    'controller:blog/post'    //=> Blog.PostController
    'controller:basic'        //=> Controller
    'route:post'              //=> App.PostRoute
    'route:posts.index'       //=> App.PostsIndexRoute
    'route:blog/post'         //=> Blog.PostRoute
    'route:basic'             //=> Route
    'foo:post'                //=> App.PostFoo
    'model:post'              //=> App.Post
    ```
  
    @class GlobalsResolver
    @extends EmberObject
    @public
  */

  exports.default = _emberRuntime.Object.extend({
    /**
      This will be set to the Application instance when it is
      created.
       @property namespace
      @public
    */
    namespace: null,

    init: function () {
      this._parseNameCache = (0, _emberUtils.dictionary)(null);
    },
    normalize: function (fullName) {
      var _fullName$split = fullName.split(':'),
          type = _fullName$split[0],
          name = _fullName$split[1];

      (true && !(fullName.split(':').length === 2) && (0, _emberDebug.assert)('Tried to normalize a container name without a colon (:) in it. ' + 'You probably tried to lookup a name that did not contain a type, ' + 'a colon, and a name. A proper lookup name would be `view:post`.', fullName.split(':').length === 2));


      if (type !== 'template') {
        var result = name.replace(/(\.|_|-)./g, function (m) {
          return m.charAt(1).toUpperCase();
        });

        return type + ':' + result;
      } else {
        return fullName;
      }
    },


    /**
      This method is called via the container's resolver method.
      It parses the provided `fullName` and then looks up and
      returns the appropriate template or class.
       @method resolve
      @param {String} fullName the lookup string
      @return {Object} the resolved factory
      @public
    */
    resolve: function (fullName) {
      var parsedName = this.parseName(fullName);
      var resolveMethodName = parsedName.resolveMethodName;
      var resolved = void 0;

      if (this[resolveMethodName]) {
        resolved = this[resolveMethodName](parsedName);
      }

      resolved = resolved || this.resolveOther(parsedName);

      if (true) {
        if (parsedName.root && parsedName.root.LOG_RESOLVER) {
          this._logLookup(resolved, parsedName);
        }
      }

      if (resolved) {
        (0, _validateType.default)(resolved, parsedName);
      }

      return resolved;
    },


    /**
      Convert the string name of the form 'type:name' to
      a Javascript object with the parsed aspects of the name
      broken out.
       @param {String} fullName the lookup string
      @method parseName
      @protected
    */

    parseName: function (fullName) {
      return this._parseNameCache[fullName] || (this._parseNameCache[fullName] = this._parseName(fullName));
    },
    _parseName: function (fullName) {
      var _fullName$split2 = fullName.split(':'),
          type = _fullName$split2[0],
          fullNameWithoutType = _fullName$split2[1];

      var name = fullNameWithoutType;
      var namespace = (0, _emberMetal.get)(this, 'namespace');
      var root = namespace;
      var lastSlashIndex = name.lastIndexOf('/');
      var dirname = lastSlashIndex !== -1 ? name.slice(0, lastSlashIndex) : null;

      if (type !== 'template' && lastSlashIndex !== -1) {
        var parts = name.split('/');
        name = parts[parts.length - 1];
        var namespaceName = _emberRuntime.String.capitalize(parts.slice(0, -1).join('.'));
        root = _emberRuntime.Namespace.byName(namespaceName);

        (true && !(root) && (0, _emberDebug.assert)('You are looking for a ' + name + ' ' + type + ' in the ' + namespaceName + ' namespace, but the namespace could not be found', root));
      }

      var resolveMethodName = fullNameWithoutType === 'main' ? 'Main' : _emberRuntime.String.classify(type);

      if (!(name && type)) {
        throw new TypeError('Invalid fullName: `' + fullName + '`, must be of the form `type:name` ');
      }

      return {
        fullName: fullName,
        type: type,
        fullNameWithoutType: fullNameWithoutType,
        dirname: dirname,
        name: name,
        root: root,
        resolveMethodName: 'resolve' + resolveMethodName
      };
    },


    /**
      Returns a human-readable description for a fullName. Used by the
      Application namespace in assertions to describe the
      precise name of the class that Ember is looking for, rather than
      container keys.
       @param {String} fullName the lookup string
      @method lookupDescription
      @protected
    */
    lookupDescription: function (fullName) {
      var parsedName = this.parseName(fullName);
      var description = void 0;

      if (parsedName.type === 'template') {
        return 'template at ' + parsedName.fullNameWithoutType.replace(/\./g, '/');
      }

      description = parsedName.root + '.' + _emberRuntime.String.classify(parsedName.name).replace(/\./g, '');

      if (parsedName.type !== 'model') {
        description += _emberRuntime.String.classify(parsedName.type);
      }

      return description;
    },
    makeToString: function (factory, fullName) {
      return factory.toString();
    },


    /**
      Given a parseName object (output from `parseName`), apply
      the conventions expected by `Ember.Router`
       @param {Object} parsedName a parseName object with the parsed
        fullName lookup string
      @method useRouterNaming
      @protected
    */
    useRouterNaming: function (parsedName) {
      if (parsedName.name === 'basic') {
        parsedName.name = '';
      } else {
        parsedName.name = parsedName.name.replace(/\./g, '_');
      }
    },

    /**
      Look up the template in Ember.TEMPLATES
       @param {Object} parsedName a parseName object with the parsed
        fullName lookup string
      @method resolveTemplate
      @protected
    */
    resolveTemplate: function (parsedName) {
      var templateName = parsedName.fullNameWithoutType.replace(/\./g, '/');

      return (0, _emberGlimmer.getTemplate)(templateName) || (0, _emberGlimmer.getTemplate)(_emberRuntime.String.decamelize(templateName));
    },


    /**
      Lookup the view using `resolveOther`
       @param {Object} parsedName a parseName object with the parsed
        fullName lookup string
      @method resolveView
      @protected
    */
    resolveView: function (parsedName) {
      this.useRouterNaming(parsedName);
      return this.resolveOther(parsedName);
    },


    /**
      Lookup the controller using `resolveOther`
       @param {Object} parsedName a parseName object with the parsed
        fullName lookup string
      @method resolveController
      @protected
    */
    resolveController: function (parsedName) {
      this.useRouterNaming(parsedName);
      return this.resolveOther(parsedName);
    },

    /**
      Lookup the route using `resolveOther`
       @param {Object} parsedName a parseName object with the parsed
        fullName lookup string
      @method resolveRoute
      @protected
    */
    resolveRoute: function (parsedName) {
      this.useRouterNaming(parsedName);
      return this.resolveOther(parsedName);
    },


    /**
      Lookup the model on the Application namespace
       @param {Object} parsedName a parseName object with the parsed
        fullName lookup string
      @method resolveModel
      @protected
    */
    resolveModel: function (parsedName) {
      var className = _emberRuntime.String.classify(parsedName.name);
      var factory = (0, _emberMetal.get)(parsedName.root, className);

      return factory;
    },

    /**
      Look up the specified object (from parsedName) on the appropriate
      namespace (usually on the Application)
       @param {Object} parsedName a parseName object with the parsed
        fullName lookup string
      @method resolveHelper
      @protected
    */
    resolveHelper: function (parsedName) {
      return this.resolveOther(parsedName);
    },

    /**
      Look up the specified object (from parsedName) on the appropriate
      namespace (usually on the Application)
       @param {Object} parsedName a parseName object with the parsed
        fullName lookup string
      @method resolveOther
      @protected
    */
    resolveOther: function (parsedName) {
      var className = _emberRuntime.String.classify(parsedName.name) + _emberRuntime.String.classify(parsedName.type);
      var factory = (0, _emberMetal.get)(parsedName.root, className);
      return factory;
    },
    resolveMain: function (parsedName) {
      var className = _emberRuntime.String.classify(parsedName.type);
      return (0, _emberMetal.get)(parsedName.root, className);
    },


    /**
      @method _logLookup
      @param {Boolean} found
      @param {Object} parsedName
      @private
    */
    _logLookup: function (found, parsedName) {
      var symbol = found ? '[✓]' : '[ ]';

      var padding = void 0;
      if (parsedName.fullName.length > 60) {
        padding = '.';
      } else {
        padding = new Array(60 - parsedName.fullName.length).join('.');
      }

      (0, _emberDebug.info)(symbol, parsedName.fullName, padding, this.lookupDescription(parsedName.fullName));
    },


    /**
      Used to iterate all items of a given type.
       @method knownForType
      @param {String} type the type to search for
      @private
    */
    knownForType: function (type) {
      var namespace = (0, _emberMetal.get)(this, 'namespace');
      var suffix = _emberRuntime.String.classify(type);
      var typeRegexp = new RegExp(suffix + '$');

      var known = (0, _emberUtils.dictionary)(null);
      var knownKeys = Object.keys(namespace);
      for (var index = 0; index < knownKeys.length; index++) {
        var name = knownKeys[index];

        if (typeRegexp.test(name)) {
          var containerName = this.translateToContainerFullname(type, name);

          known[containerName] = true;
        }
      }

      return known;
    },


    /**
      Converts provided name from the backing namespace into a container lookup name.
       Examples:
       * App.FooBarHelper -> helper:foo-bar
      * App.THelper -> helper:t
       @method translateToContainerFullname
      @param {String} type
      @param {String} name
      @private
    */
    translateToContainerFullname: function (type, name) {
      var suffix = _emberRuntime.String.classify(type);
      var namePrefix = name.slice(0, suffix.length * -1);
      var dasherizedName = _emberRuntime.String.dasherize(namePrefix);

      return type + ':' + dasherizedName;
    }
  });
});
enifed('ember-application/utils/validate-type', ['exports', 'ember-debug'], function (exports, _emberDebug) {
  'use strict';

  exports.default = validateType;


  var VALIDATED_TYPES = {
    route: ['assert', 'isRouteFactory', 'Ember.Route'],
    component: ['deprecate', 'isComponentFactory', 'Ember.Component'],
    view: ['deprecate', 'isViewFactory', 'Ember.View'],
    service: ['deprecate', 'isServiceFactory', 'Ember.Service']
  };

  function validateType(resolvedType, parsedName) {
    var validationAttributes = VALIDATED_TYPES[parsedName.type];

    if (!validationAttributes) {
      return;
    }

    var action = validationAttributes[0],
        factoryFlag = validationAttributes[1],
        expectedType = validationAttributes[2];
    (true && !(!!resolvedType[factoryFlag]) && (0, _emberDebug.assert)('Expected ' + parsedName.fullName + ' to resolve to an ' + expectedType + ' but ' + ('instead it was ' + resolvedType + '.'), !!resolvedType[factoryFlag]));
  }
});
enifed('ember-babel', ['exports'], function (exports) {
  'use strict';

  exports.classCallCheck = classCallCheck;
  exports.inherits = inherits;
  exports.taggedTemplateLiteralLoose = taggedTemplateLiteralLoose;
  exports.createClass = createClass;
  exports.defaults = defaults;
  function classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError('Cannot call a class as a function');
    }
  }

  function inherits(subClass, superClass) {
    if (typeof superClass !== 'function' && superClass !== null) {
      throw new TypeError('Super expression must either be null or a function, not ' + typeof superClass);
    }

    subClass.prototype = Object.create(superClass && superClass.prototype, {
      constructor: {
        value: subClass,
        enumerable: false,
        writable: true,
        configurable: true
      }
    });

    if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : defaults(subClass, superClass);
  }

  function taggedTemplateLiteralLoose(strings, raw) {
    strings.raw = raw;
    return strings;
  }

  function defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];
      descriptor.enumerable = descriptor.enumerable || false;
      descriptor.configurable = true;
      if ('value' in descriptor) descriptor.writable = true;
      Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function createClass(Constructor, protoProps, staticProps) {
    if (protoProps) defineProperties(Constructor.prototype, protoProps);
    if (staticProps) defineProperties(Constructor, staticProps);
    return Constructor;
  }

  function defaults(obj, defaults) {
    var keys = Object.getOwnPropertyNames(defaults);
    for (var i = 0; i < keys.length; i++) {
      var key = keys[i];
      var value = Object.getOwnPropertyDescriptor(defaults, key);
      if (value && value.configurable && obj[key] === undefined) {
        Object.defineProperty(obj, key, value);
      }
    }
    return obj;
  }

  var possibleConstructorReturn = exports.possibleConstructorReturn = function (self, call) {
    if (!self) {
      throw new ReferenceError('this hasn\'t been initialized - super() hasn\'t been called');
    }
    return call && (typeof call === 'object' || typeof call === 'function') ? call : self;
  };

  var slice = exports.slice = Array.prototype.slice;
});
enifed('ember-console', ['exports', 'ember-environment'], function (exports, _emberEnvironment) {
  'use strict';

  function K() {}

  function consoleMethod(name) {
    var consoleObj = void 0;
    if (_emberEnvironment.context.imports.console) {
      consoleObj = _emberEnvironment.context.imports.console;
    } else if (typeof console !== 'undefined') {
      // eslint-disable-line no-undef
      consoleObj = console; // eslint-disable-line no-undef
    }

    var method = typeof consoleObj === 'object' ? consoleObj[name] : null;

    if (typeof method !== 'function') {
      return;
    }

    if (typeof method.bind === 'function') {
      return method.bind(consoleObj);
    }

    return function () {
      method.apply(consoleObj, arguments);
    };
  }

  function assertPolyfill(test, message) {
    if (!test) {
      try {
        // attempt to preserve the stack
        throw new Error('assertion failed: ' + message);
      } catch (error) {
        setTimeout(function () {
          throw error;
        }, 0);
      }
    }
  }

  /**
    Inside Ember-Metal, simply uses the methods from `imports.console`.
    Override this to provide more robust logging functionality.
  
    @class Logger
    @namespace Ember
    @public
  */
  var index = {
    /**
     Logs the arguments to the console.
     You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      var foo = 1;
      Ember.Logger.log('log value of foo:', foo);
      // "log value of foo: 1" will be printed to the console
      ```
      @method log
     @for Ember.Logger
     @param {*} arguments
     @public
    */
    log: consoleMethod('log') || K,

    /**
     Prints the arguments to the console with a warning icon.
     You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      Ember.Logger.warn('Something happened!');
      // "Something happened!" will be printed to the console with a warning icon.
      ```
      @method warn
     @for Ember.Logger
     @param {*} arguments
     @public
    */
    warn: consoleMethod('warn') || K,

    /**
     Prints the arguments to the console with an error icon, red text and a stack trace.
     You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      Ember.Logger.error('Danger! Danger!');
      // "Danger! Danger!" will be printed to the console in red text.
      ```
      @method error
     @for Ember.Logger
     @param {*} arguments
     @public
    */
    error: consoleMethod('error') || K,

    /**
     Logs the arguments to the console.
     You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      var foo = 1;
      Ember.Logger.info('log value of foo:', foo);
      // "log value of foo: 1" will be printed to the console
      ```
      @method info
     @for Ember.Logger
     @param {*} arguments
     @public
    */
    info: consoleMethod('info') || K,

    /**
     Logs the arguments to the console in blue text.
     You can pass as many arguments as you want and they will be joined together with a space.
       ```javascript
      var foo = 1;
      Ember.Logger.debug('log value of foo:', foo);
      // "log value of foo: 1" will be printed to the console
      ```
      @method debug
     @for Ember.Logger
     @param {*} arguments
     @public
    */
    debug: consoleMethod('debug') || consoleMethod('info') || K,

    /**
     If the value passed into `Ember.Logger.assert` is not truthy it will throw an error with a stack trace.
       ```javascript
      Ember.Logger.assert(true); // undefined
      Ember.Logger.assert(true === false); // Throws an Assertion failed error.
      Ember.Logger.assert(true === false, 'Something invalid'); // Throws an Assertion failed error with message.
      ```
      @method assert
     @for Ember.Logger
     @param {Boolean} bool Value to test
     @param {String} message Assertion message on failed
     @public
    */
    assert: consoleMethod('assert') || assertPolyfill
  };

  exports.default = index;
});
enifed('ember-debug/deprecate', ['exports', 'ember-debug/error', 'ember-console', 'ember-environment', 'ember-debug/handlers'], function (exports, _error, _emberConsole, _emberEnvironment, _handlers) {
  'use strict';

  exports.missingOptionsUntilDeprecation = exports.missingOptionsIdDeprecation = exports.missingOptionsDeprecation = exports.registerHandler = undefined;

  /**
   @module @ember/debug
   @public
  */
  /**
    Allows for runtime registration of handler functions that override the default deprecation behavior.
    Deprecations are invoked by calls to [Ember.deprecate](https://emberjs.com/api/classes/Ember.html#method_deprecate).
    The following example demonstrates its usage by registering a handler that throws an error if the
    message contains the word "should", otherwise defers to the default handler.
  
    ```javascript
    Ember.Debug.registerDeprecationHandler((message, options, next) => {
      if (message.indexOf('should') !== -1) {
        throw new Error(`Deprecation message with should: ${message}`);
      } else {
        // defer to whatever handler was registered before this one
        next(message, options);
      }
    });
    ```
  
    The handler function takes the following arguments:
  
    <ul>
      <li> <code>message</code> - The message received from the deprecation call.</li>
      <li> <code>options</code> - An object passed in with the deprecation call containing additional information including:</li>
        <ul>
          <li> <code>id</code> - An id of the deprecation in the form of <code>package-name.specific-deprecation</code>.</li>
          <li> <code>until</code> - The Ember version number the feature and deprecation will be removed in.</li>
        </ul>
      <li> <code>next</code> - A function that calls into the previously registered handler.</li>
    </ul>
  
    @public
    @static
    @method registerDeprecationHandler
    @for @ember/debug
    @param handler {Function} A function to handle deprecation calls.
    @since 2.1.0
  */
  var registerHandler = function () {}; /*global __fail__*/

  var missingOptionsDeprecation = void 0,
      missingOptionsIdDeprecation = void 0,
      missingOptionsUntilDeprecation = void 0,
      deprecate = void 0;

  if (true) {
    exports.registerHandler = registerHandler = function registerHandler(handler) {
      (0, _handlers.registerHandler)('deprecate', handler);
    };

    var formatMessage = function formatMessage(_message, options) {
      var message = _message;

      if (options && options.id) {
        message = message + (' [deprecation id: ' + options.id + ']');
      }

      if (options && options.url) {
        message += ' See ' + options.url + ' for more details.';
      }

      return message;
    };

    registerHandler(function logDeprecationToConsole(message, options) {
      var updatedMessage = formatMessage(message, options);

      _emberConsole.default.warn('DEPRECATION: ' + updatedMessage);
    });

    var captureErrorForStack = void 0;

    if (new Error().stack) {
      captureErrorForStack = function () {
        return new Error();
      };
    } else {
      captureErrorForStack = function () {
        try {
          __fail__.fail();
        } catch (e) {
          return e;
        }
      };
    }

    registerHandler(function logDeprecationStackTrace(message, options, next) {
      if (_emberEnvironment.ENV.LOG_STACKTRACE_ON_DEPRECATION) {
        var stackStr = '';
        var error = captureErrorForStack();
        var stack = void 0;

        if (error.stack) {
          if (error['arguments']) {
            // Chrome
            stack = error.stack.replace(/^\s+at\s+/gm, '').replace(/^([^\(]+?)([\n$])/gm, '{anonymous}($1)$2').replace(/^Object.<anonymous>\s*\(([^\)]+)\)/gm, '{anonymous}($1)').split('\n');
            stack.shift();
          } else {
            // Firefox
            stack = error.stack.replace(/(?:\n@:0)?\s+$/m, '').replace(/^\(/gm, '{anonymous}(').split('\n');
          }

          stackStr = '\n    ' + stack.slice(2).join('\n    ');
        }

        var updatedMessage = formatMessage(message, options);

        _emberConsole.default.warn('DEPRECATION: ' + updatedMessage + stackStr);
      } else {
        next.apply(undefined, arguments);
      }
    });

    registerHandler(function raiseOnDeprecation(message, options, next) {
      if (_emberEnvironment.ENV.RAISE_ON_DEPRECATION) {
        var updatedMessage = formatMessage(message);

        throw new _error.default(updatedMessage);
      } else {
        next.apply(undefined, arguments);
      }
    });

    exports.missingOptionsDeprecation = missingOptionsDeprecation = 'When calling `Ember.deprecate` you ' + 'must provide an `options` hash as the third parameter.  ' + '`options` should include `id` and `until` properties.';
    exports.missingOptionsIdDeprecation = missingOptionsIdDeprecation = 'When calling `Ember.deprecate` you must provide `id` in options.';
    exports.missingOptionsUntilDeprecation = missingOptionsUntilDeprecation = 'When calling `Ember.deprecate` you must provide `until` in options.';
    /**
     @module @ember/application
     @public
     */
    /**
      Display a deprecation warning with the provided message and a stack trace
      (Chrome and Firefox only).
       * In a production build, this method is defined as an empty function (NOP).
      Uses of this method in Ember itself are stripped from the ember.prod.js build.
       @method deprecate
      @for @ember/application/deprecations
      @param {String} message A description of the deprecation.
      @param {Boolean} test A boolean. If falsy, the deprecation will be displayed.
      @param {Object} options
      @param {String} options.id A unique id for this deprecation. The id can be
        used by Ember debugging tools to change the behavior (raise, log or silence)
        for that specific deprecation. The id should be namespaced by dots, e.g.
        "view.helper.select".
      @param {string} options.until The version of Ember when this deprecation
        warning will be removed.
      @param {String} [options.url] An optional url to the transition guide on the
        emberjs.com website.
      @static
      @public
      @since 1.0.0
    */
    deprecate = function deprecate(message, test, options) {
      if (!options || !options.id && !options.until) {
        deprecate(missingOptionsDeprecation, false, {
          id: 'ember-debug.deprecate-options-missing',
          until: '3.0.0',
          url: 'https://emberjs.com/deprecations/v2.x/#toc_ember-debug-function-options'
        });
      }

      if (options && !options.id) {
        deprecate(missingOptionsIdDeprecation, false, {
          id: 'ember-debug.deprecate-id-missing',
          until: '3.0.0',
          url: 'https://emberjs.com/deprecations/v2.x/#toc_ember-debug-function-options'
        });
      }

      if (options && !options.until) {
        deprecate(missingOptionsUntilDeprecation, options && options.until, {
          id: 'ember-debug.deprecate-until-missing',
          until: '3.0.0',
          url: 'https://emberjs.com/deprecations/v2.x/#toc_ember-debug-function-options'
        });
      }

      _handlers.invoke.apply(undefined, ['deprecate'].concat(Array.prototype.slice.call(arguments)));
    };
  }

  exports.default = deprecate;
  exports.registerHandler = registerHandler;
  exports.missingOptionsDeprecation = missingOptionsDeprecation;
  exports.missingOptionsIdDeprecation = missingOptionsIdDeprecation;
  exports.missingOptionsUntilDeprecation = missingOptionsUntilDeprecation;
});
enifed("ember-debug/error", ["exports", "ember-babel"], function (exports, _emberBabel) {
  "use strict";

  /**
   @module @ember/error
  */
  function ExtendBuiltin(klass) {
    function ExtendableBuiltin() {
      klass.apply(this, arguments);
    }

    ExtendableBuiltin.prototype = Object.create(klass.prototype);
    ExtendableBuiltin.prototype.constructor = ExtendableBuiltin;
    return ExtendableBuiltin;
  }

  /**
    A subclass of the JavaScript Error object for use in Ember.
  
    @class EmberError
    @extends Error
    @constructor
    @public
  */

  var EmberError = function (_ExtendBuiltin) {
    (0, _emberBabel.inherits)(EmberError, _ExtendBuiltin);

    function EmberError(message) {
      (0, _emberBabel.classCallCheck)(this, EmberError);

      var _this = (0, _emberBabel.possibleConstructorReturn)(this, _ExtendBuiltin.call(this));

      if (!(_this instanceof EmberError)) {
        var _ret;

        return _ret = new EmberError(message), (0, _emberBabel.possibleConstructorReturn)(_this, _ret);
      }

      var error = Error.call(_this, message);
      _this.stack = error.stack;
      _this.description = error.description;
      _this.fileName = error.fileName;
      _this.lineNumber = error.lineNumber;
      _this.message = error.message;
      _this.name = error.name;
      _this.number = error.number;
      _this.code = error.code;
      return _this;
    }

    return EmberError;
  }(ExtendBuiltin(Error));

  exports.default = EmberError;
});
enifed('ember-debug/features', ['exports', 'ember-environment', 'ember/features'], function (exports, _emberEnvironment, _features) {
  'use strict';

  exports.default = isEnabled;
  var FEATURES = _features.FEATURES;


  /**
   @module ember
  */

  /**
    The hash of enabled Canary features. Add to this, any canary features
    before creating your application.
  
    Alternatively (and recommended), you can also define `EmberENV.FEATURES`
    if you need to enable features flagged at runtime.
  
    @class FEATURES
    @namespace Ember
    @static
    @since 1.1.0
    @public
  */

  // Auto-generated

  /**
    Determine whether the specified `feature` is enabled. Used by Ember's
    build tools to exclude experimental features from beta/stable builds.
  
    You can define the following configuration options:
  
    * `EmberENV.ENABLE_OPTIONAL_FEATURES` - enable any features that have not been explicitly
      enabled/disabled.
  
    @method isEnabled
    @param {String} feature The feature to check
    @return {Boolean}
    @for Ember.FEATURES
    @since 1.1.0
    @public
  */
  function isEnabled(feature) {
    var featureValue = FEATURES[feature];

    if (featureValue === true || featureValue === false || featureValue === undefined) {
      return featureValue;
    } else if (_emberEnvironment.ENV.ENABLE_OPTIONAL_FEATURES) {
      return true;
    } else {
      return false;
    }
  }
});
enifed('ember-debug/handlers', ['exports'], function (exports) {
  'use strict';

  var HANDLERS = exports.HANDLERS = {};

  var registerHandler = function () {};
  var invoke = function () {};

  if (true) {
    exports.registerHandler = registerHandler = function registerHandler(type, callback) {
      var nextHandler = HANDLERS[type] || function () {};

      HANDLERS[type] = function (message, options) {
        callback(message, options, nextHandler);
      };
    };

    exports.invoke = invoke = function invoke(type, message, test, options) {
      if (test) {
        return;
      }

      var handlerForType = HANDLERS[type];

      if (handlerForType) {
        handlerForType(message, options);
      }
    };
  }

  exports.registerHandler = registerHandler;
  exports.invoke = invoke;
});
enifed('ember-debug/index', ['exports', 'ember-debug/warn', 'ember-debug/deprecate', 'ember-debug/features', 'ember-debug/error', 'ember-debug/testing', 'ember-environment', 'ember-console', 'ember/features'], function (exports, _warn2, _deprecate2, _features, _error, _testing, _emberEnvironment, _emberConsole, _features2) {
  'use strict';

  exports._warnIfUsingStrippedFeatureFlags = exports.getDebugFunction = exports.setDebugFunction = exports.deprecateFunc = exports.runInDebug = exports.debugFreeze = exports.debugSeal = exports.deprecate = exports.debug = exports.warn = exports.info = exports.assert = exports.setTesting = exports.isTesting = exports.Error = exports.isFeatureEnabled = exports.registerDeprecationHandler = exports.registerWarnHandler = undefined;
  Object.defineProperty(exports, 'registerWarnHandler', {
    enumerable: true,
    get: function () {
      return _warn2.registerHandler;
    }
  });
  Object.defineProperty(exports, 'registerDeprecationHandler', {
    enumerable: true,
    get: function () {
      return _deprecate2.registerHandler;
    }
  });
  Object.defineProperty(exports, 'isFeatureEnabled', {
    enumerable: true,
    get: function () {
      return _features.default;
    }
  });
  Object.defineProperty(exports, 'Error', {
    enumerable: true,
    get: function () {
      return _error.default;
    }
  });
  Object.defineProperty(exports, 'isTesting', {
    enumerable: true,
    get: function () {
      return _testing.isTesting;
    }
  });
  Object.defineProperty(exports, 'setTesting', {
    enumerable: true,
    get: function () {
      return _testing.setTesting;
    }
  });
  var DEFAULT_FEATURES = _features2.DEFAULT_FEATURES,
      FEATURES = _features2.FEATURES;


  // These are the default production build versions:
  var noop = function () {};

  var assert = noop;
  var info = noop;
  var warn = noop;
  var debug = noop;
  var deprecate = noop;
  var debugSeal = noop;
  var debugFreeze = noop;
  var runInDebug = noop;
  var setDebugFunction = noop;
  var getDebugFunction = noop;

  var deprecateFunc = function () {
    return arguments[arguments.length - 1];
  };

  if (true) {
    exports.setDebugFunction = setDebugFunction = function (type, callback) {
      switch (type) {
        case 'assert':
          return exports.assert = assert = callback;
        case 'info':
          return exports.info = info = callback;
        case 'warn':
          return exports.warn = warn = callback;
        case 'debug':
          return exports.debug = debug = callback;
        case 'deprecate':
          return exports.deprecate = deprecate = callback;
        case 'debugSeal':
          return exports.debugSeal = debugSeal = callback;
        case 'debugFreeze':
          return exports.debugFreeze = debugFreeze = callback;
        case 'runInDebug':
          return exports.runInDebug = runInDebug = callback;
        case 'deprecateFunc':
          return exports.deprecateFunc = deprecateFunc = callback;
      }
    };

    exports.getDebugFunction = getDebugFunction = function (type) {
      switch (type) {
        case 'assert':
          return assert;
        case 'info':
          return info;
        case 'warn':
          return warn;
        case 'debug':
          return debug;
        case 'deprecate':
          return deprecate;
        case 'debugSeal':
          return debugSeal;
        case 'debugFreeze':
          return debugFreeze;
        case 'runInDebug':
          return runInDebug;
        case 'deprecateFunc':
          return deprecateFunc;
      }
    };
  }

  /**
  @module @ember/debug
  */

  if (true) {
    /**
      Define an assertion that will throw an exception if the condition is not met.
       * In a production build, this method is defined as an empty function (NOP).
      Uses of this method in Ember itself are stripped from the ember.prod.js build.
       ```javascript
      import { assert } from '@ember/debug';
       // Test for truthiness
      assert('Must pass a valid object', obj);
       // Fail unconditionally
      assert('This code path should never be run');
      ```
       @method assert
      @static
      @for @ember/debug
      @param {String} desc A description of the assertion. This will become
        the text of the Error thrown if the assertion fails.
      @param {Boolean} test Must be truthy for the assertion to pass. If
        falsy, an exception will be thrown.
      @public
      @since 1.0.0
    */
    setDebugFunction('assert', function assert(desc, test) {
      if (!test) {
        throw new _error.default('Assertion Failed: ' + desc);
      }
    });

    /**
      Display a debug notice.
       * In a production build, this method is defined as an empty function (NOP).
      Uses of this method in Ember itself are stripped from the ember.prod.js build.
       ```javascript
      import { debug } from '@ember/debug';
       debug('I\'m a debug notice!');
      ```
       @method debug
      @for @ember/debug
      @static
      @param {String} message A debug message to display.
      @public
    */
    setDebugFunction('debug', function debug(message) {
      _emberConsole.default.debug('DEBUG: ' + message);
    });

    /**
      Display an info notice.
       * In a production build, this method is defined as an empty function (NOP).
      Uses of this method in Ember itself are stripped from the ember.prod.js build.
       @method info
      @private
    */
    setDebugFunction('info', function info() {
      _emberConsole.default.info.apply(undefined, arguments);
    });

    /**
     @module @ember/application
     @public
    */

    /**
      Alias an old, deprecated method with its new counterpart.
       Display a deprecation warning with the provided message and a stack trace
      (Chrome and Firefox only) when the assigned method is called.
       * In a production build, this method is defined as an empty function (NOP).
       ```javascript
      Ember.oldMethod = Ember.deprecateFunc('Please use the new, updated method', Ember.newMethod);
      ```
       @method deprecateFunc
      @static
      @for @ember/application/deprecations
      @param {String} message A description of the deprecation.
      @param {Object} [options] The options object for Ember.deprecate.
      @param {Function} func The new function called to replace its deprecated counterpart.
      @return {Function} A new function that wraps the original function with a deprecation warning
      @private
    */
    setDebugFunction('deprecateFunc', function deprecateFunc() {
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      if (args.length === 3) {
        var message = args[0],
            options = args[1],
            func = args[2];

        return function () {
          deprecate(message, false, options);
          return func.apply(this, arguments);
        };
      } else {
        var _message = args[0],
            _func = args[1];

        return function () {
          deprecate(_message);
          return _func.apply(this, arguments);
        };
      }
    });

    /**
     @module @ember/debug
     @public
    */
    /**
      Run a function meant for debugging.
       * In a production build, this method is defined as an empty function (NOP).
      Uses of this method in Ember itself are stripped from the ember.prod.js build.
       ```javascript
      import Component from '@ember/component';
      import { runInDebug } from '@ember/debug';
       runInDebug(() => {
        Component.reopen({
          didInsertElement() {
            console.log("I'm happy");
          }
        });
      });
      ```
       @method runInDebug
      @for @ember/debug
      @static
      @param {Function} func The function to be executed.
      @since 1.5.0
      @public
    */
    setDebugFunction('runInDebug', function runInDebug(func) {
      func();
    });

    setDebugFunction('debugSeal', function debugSeal(obj) {
      Object.seal(obj);
    });

    setDebugFunction('debugFreeze', function debugFreeze(obj) {
      Object.freeze(obj);
    });

    setDebugFunction('deprecate', _deprecate2.default);

    setDebugFunction('warn', _warn2.default);
  }

  var _warnIfUsingStrippedFeatureFlags = void 0;

  if (true && !(0, _testing.isTesting)()) {
    /**
       Will call `warn()` if ENABLE_OPTIONAL_FEATURES or
       any specific FEATURES flag is truthy.
        This method is called automatically in debug canary builds.
        @private
       @method _warnIfUsingStrippedFeatureFlags
       @return {void}
    */
    exports._warnIfUsingStrippedFeatureFlags = _warnIfUsingStrippedFeatureFlags = function _warnIfUsingStrippedFeatureFlags(FEATURES, knownFeatures, featuresWereStripped) {
      if (featuresWereStripped) {
        warn('Ember.ENV.ENABLE_OPTIONAL_FEATURES is only available in canary builds.', !_emberEnvironment.ENV.ENABLE_OPTIONAL_FEATURES, { id: 'ember-debug.feature-flag-with-features-stripped' });

        var keys = Object.keys(FEATURES || {});
        for (var i = 0; i < keys.length; i++) {
          var key = keys[i];
          if (key === 'isEnabled' || !(key in knownFeatures)) {
            continue;
          }

          warn('FEATURE["' + key + '"] is set as enabled, but FEATURE flags are only available in canary builds.', !FEATURES[key], { id: 'ember-debug.feature-flag-with-features-stripped' });
        }
      }
    };

    // Complain if they're using FEATURE flags in builds other than canary
    FEATURES['features-stripped-test'] = true;
    var featuresWereStripped = true;

    if ((0, _features.default)('features-stripped-test')) {
      featuresWereStripped = false;
    }

    delete FEATURES['features-stripped-test'];
    _warnIfUsingStrippedFeatureFlags(_emberEnvironment.ENV.FEATURES, DEFAULT_FEATURES, featuresWereStripped);

    // Inform the developer about the Ember Inspector if not installed.
    var isFirefox = _emberEnvironment.environment.isFirefox;
    var isChrome = _emberEnvironment.environment.isChrome;

    if (typeof window !== 'undefined' && (isFirefox || isChrome) && window.addEventListener) {
      window.addEventListener('load', function () {
        if (document.documentElement && document.documentElement.dataset && !document.documentElement.dataset.emberExtension) {
          var downloadURL = void 0;

          if (isChrome) {
            downloadURL = 'https://chrome.google.com/webstore/detail/ember-inspector/bmdblncegkenkacieihfhpjfppoconhi';
          } else if (isFirefox) {
            downloadURL = 'https://addons.mozilla.org/en-US/firefox/addon/ember-inspector/';
          }

          debug('For more advanced debugging, install the Ember Inspector from ' + downloadURL);
        }
      }, false);
    }
  }

  exports.assert = assert;
  exports.info = info;
  exports.warn = warn;
  exports.debug = debug;
  exports.deprecate = deprecate;
  exports.debugSeal = debugSeal;
  exports.debugFreeze = debugFreeze;
  exports.runInDebug = runInDebug;
  exports.deprecateFunc = deprecateFunc;
  exports.setDebugFunction = setDebugFunction;
  exports.getDebugFunction = getDebugFunction;
  exports._warnIfUsingStrippedFeatureFlags = _warnIfUsingStrippedFeatureFlags;
});
enifed("ember-debug/testing", ["exports"], function (exports) {
  "use strict";

  exports.isTesting = isTesting;
  exports.setTesting = setTesting;
  var testing = false;

  function isTesting() {
    return testing;
  }

  function setTesting(value) {
    testing = !!value;
  }
});
enifed('ember-debug/warn', ['exports', 'ember-console', 'ember-debug/deprecate', 'ember-debug/handlers'], function (exports, _emberConsole, _deprecate, _handlers) {
  'use strict';

  exports.missingOptionsDeprecation = exports.missingOptionsIdDeprecation = exports.registerHandler = undefined;


  var registerHandler = function () {};
  var warn = function () {};
  var missingOptionsDeprecation = void 0,
      missingOptionsIdDeprecation = void 0;

  /**
  @module @ember/debug
  */

  if (true) {
    /**
      Allows for runtime registration of handler functions that override the default warning behavior.
      Warnings are invoked by calls made to [warn](https://emberjs.com/api/classes/Ember.html#method_warn).
      The following example demonstrates its usage by registering a handler that does nothing overriding Ember's
      default warning behavior.
       ```javascript
      import { registerWarnHandler } from '@ember/debug';
       // next is not called, so no warnings get the default behavior
      registerWarnHandler(() => {});
      ```
       The handler function takes the following arguments:
       <ul>
        <li> <code>message</code> - The message received from the warn call. </li>
        <li> <code>options</code> - An object passed in with the warn call containing additional information including:</li>
          <ul>
            <li> <code>id</code> - An id of the warning in the form of <code>package-name.specific-warning</code>.</li>
          </ul>
        <li> <code>next</code> - A function that calls into the previously registered handler.</li>
      </ul>
       @public
      @static
      @method registerWarnHandler
      @for @ember/debug
      @param handler {Function} A function to handle warnings.
      @since 2.1.0
    */
    exports.registerHandler = registerHandler = function registerHandler(handler) {
      (0, _handlers.registerHandler)('warn', handler);
    };

    registerHandler(function logWarning(message, options) {
      _emberConsole.default.warn('WARNING: ' + message);
      if ('trace' in _emberConsole.default) {
        _emberConsole.default.trace();
      }
    });

    exports.missingOptionsDeprecation = missingOptionsDeprecation = 'When calling `warn` you ' + 'must provide an `options` hash as the third parameter.  ' + '`options` should include an `id` property.';
    exports.missingOptionsIdDeprecation = missingOptionsIdDeprecation = 'When calling `warn` you must provide `id` in options.';

    /**
      Display a warning with the provided message.
       * In a production build, this method is defined as an empty function (NOP).
      Uses of this method in Ember itself are stripped from the ember.prod.js build.
       @method warn
      @for @ember/debug
      @static
      @param {String} message A warning to display.
      @param {Boolean} test An optional boolean. If falsy, the warning
        will be displayed.
      @param {Object} options An object that can be used to pass a unique
        `id` for this warning.  The `id` can be used by Ember debugging tools
        to change the behavior (raise, log, or silence) for that specific warning.
        The `id` should be namespaced by dots, e.g. "ember-debug.feature-flag-with-features-stripped"
      @public
      @since 1.0.0
    */
    warn = function warn(message, test, options) {
      if (arguments.length === 2 && typeof test === 'object') {
        options = test;
        test = false;
      }
      if (!options) {
        (0, _deprecate.default)(missingOptionsDeprecation, false, {
          id: 'ember-debug.warn-options-missing',
          until: '3.0.0',
          url: 'https://emberjs.com/deprecations/v2.x/#toc_ember-debug-function-options'
        });
      }

      if (options && !options.id) {
        (0, _deprecate.default)(missingOptionsIdDeprecation, false, {
          id: 'ember-debug.warn-id-missing',
          until: '3.0.0',
          url: 'https://emberjs.com/deprecations/v2.x/#toc_ember-debug-function-options'
        });
      }

      (0, _handlers.invoke)('warn', message, test, options);
    };
  }

  exports.default = warn;
  exports.registerHandler = registerHandler;
  exports.missingOptionsIdDeprecation = missingOptionsIdDeprecation;
  exports.missingOptionsDeprecation = missingOptionsDeprecation;
});
enifed('ember-environment', ['exports'], function (exports) {
  'use strict';

  /* globals global, window, self, mainContext */

  // from lodash to catch fake globals
  function checkGlobal(value) {
    return value && value.Object === Object ? value : undefined;
  }

  // element ids can ruin global miss checks
  function checkElementIdShadowing(value) {
    return value && value.nodeType === undefined ? value : undefined;
  }

  // export real global
  var global$1 = checkGlobal(checkElementIdShadowing(typeof global === 'object' && global)) || checkGlobal(typeof self === 'object' && self) || checkGlobal(typeof window === 'object' && window) || mainContext || // set before strict mode in Ember loader/wrapper
  new Function('return this')(); // eval outside of strict mode

  function defaultTrue(v) {
    return v === false ? false : true;
  }

  function defaultFalse(v) {
    return v === true ? true : false;
  }

  function normalizeExtendPrototypes(obj) {
    if (obj === false) {
      return { String: false, Array: false, Function: false };
    } else if (!obj || obj === true) {
      return { String: true, Array: true, Function: true };
    } else {
      return {
        String: defaultTrue(obj.String),
        Array: defaultTrue(obj.Array),
        Function: defaultTrue(obj.Function)
      };
    }
  }

  /* globals module */
  /**
    The hash of environment variables used to control various configuration
    settings. To specify your own or override default settings, add the
    desired properties to a global hash named `EmberENV` (or `ENV` for
    backwards compatibility with earlier versions of Ember). The `EmberENV`
    hash must be created before loading Ember.
  
    @class EmberENV
    @type Object
    @public
  */
  var ENV = typeof global$1.EmberENV === 'object' && global$1.EmberENV || typeof global$1.ENV === 'object' && global$1.ENV || {};

  // ENABLE_ALL_FEATURES was documented, but you can't actually enable non optional features.
  if (ENV.ENABLE_ALL_FEATURES) {
    ENV.ENABLE_OPTIONAL_FEATURES = true;
  }

  /**
    Determines whether Ember should add to `Array`, `Function`, and `String`
    native object prototypes, a few extra methods in order to provide a more
    friendly API.
  
    We generally recommend leaving this option set to true however, if you need
    to turn it off, you can add the configuration property
    `EXTEND_PROTOTYPES` to `EmberENV` and set it to `false`.
  
    Note, when disabled (the default configuration for Ember Addons), you will
    instead have to access all methods and functions from the Ember
    namespace.
  
    @property EXTEND_PROTOTYPES
    @type Boolean
    @default true
    @for EmberENV
    @public
  */
  ENV.EXTEND_PROTOTYPES = normalizeExtendPrototypes(ENV.EXTEND_PROTOTYPES);

  /**
    The `LOG_STACKTRACE_ON_DEPRECATION` property, when true, tells Ember to log
    a full stack trace during deprecation warnings.
  
    @property LOG_STACKTRACE_ON_DEPRECATION
    @type Boolean
    @default true
    @for EmberENV
    @public
  */
  ENV.LOG_STACKTRACE_ON_DEPRECATION = defaultTrue(ENV.LOG_STACKTRACE_ON_DEPRECATION);

  /**
    The `LOG_VERSION` property, when true, tells Ember to log versions of all
    dependent libraries in use.
  
    @property LOG_VERSION
    @type Boolean
    @default true
    @for EmberENV
    @public
  */
  ENV.LOG_VERSION = defaultTrue(ENV.LOG_VERSION);

  /**
    Debug parameter you can turn on. This will log all bindings that fire to
    the console. This should be disabled in production code. Note that you
    can also enable this from the console or temporarily.
  
    @property LOG_BINDINGS
    @for EmberENV
    @type Boolean
    @default false
    @public
  */
  ENV.LOG_BINDINGS = defaultFalse(ENV.LOG_BINDINGS);

  ENV.RAISE_ON_DEPRECATION = defaultFalse(ENV.RAISE_ON_DEPRECATION);

  // check if window exists and actually is the global
  var hasDOM = typeof window !== 'undefined' && window === global$1 && window.document && window.document.createElement && !ENV.disableBrowserEnvironment; // is this a public thing?

  // legacy imports/exports/lookup stuff (should we keep this??)
  var originalContext = global$1.Ember || {};

  var context = {
    // import jQuery
    imports: originalContext.imports || global$1,
    // export Ember
    exports: originalContext.exports || global$1,
    // search for Namespaces
    lookup: originalContext.lookup || global$1
  };

  // TODO: cleanup single source of truth issues with this stuff
  var environment = hasDOM ? {
    hasDOM: true,
    isChrome: !!window.chrome && !window.opera,
    isFirefox: typeof InstallTrigger !== 'undefined',
    isPhantom: !!window.callPhantom,
    location: window.location,
    history: window.history,
    userAgent: window.navigator.userAgent,
    window: window
  } : {
    hasDOM: false,
    isChrome: false,
    isFirefox: false,
    isPhantom: false,
    location: null,
    history: null,
    userAgent: 'Lynx (textmode)',
    window: null
  };

  exports.ENV = ENV;
  exports.context = context;
  exports.environment = environment;
});
enifed('ember-extension-support/container_debug_adapter', ['exports', 'ember-metal', 'ember-runtime'], function (exports, _emberMetal, _emberRuntime) {
  'use strict';

  exports.default = _emberRuntime.Object.extend({
    /**
      The resolver instance of the application
      being debugged. This property will be injected
      on creation.
       @property resolver
      @default null
      @public
    */
    resolver: null,

    /**
      Returns true if it is possible to catalog a list of available
      classes in the resolver for a given type.
       @method canCatalogEntriesByType
      @param {String} type The type. e.g. "model", "controller", "route".
      @return {boolean} whether a list is available for this type.
      @public
    */
    canCatalogEntriesByType: function (type) {
      if (type === 'model' || type === 'template') {
        return false;
      }

      return true;
    },


    /**
      Returns the available classes a given type.
       @method catalogEntriesByType
      @param {String} type The type. e.g. "model", "controller", "route".
      @return {Array} An array of strings.
      @public
    */
    catalogEntriesByType: function (type) {
      var namespaces = (0, _emberRuntime.A)(_emberRuntime.Namespace.NAMESPACES);
      var types = (0, _emberRuntime.A)();
      var typeSuffixRegex = new RegExp(_emberRuntime.String.classify(type) + '$');

      namespaces.forEach(function (namespace) {
        if (namespace !== _emberMetal.default) {
          for (var key in namespace) {
            if (!namespace.hasOwnProperty(key)) {
              continue;
            }
            if (typeSuffixRegex.test(key)) {
              var klass = namespace[key];
              if ((0, _emberRuntime.typeOf)(klass) === 'class') {
                types.push(_emberRuntime.String.dasherize(key.replace(typeSuffixRegex, '')));
              }
            }
          }
        }
      });
      return types;
    }
  });
});
enifed('ember-extension-support/data_adapter', ['exports', 'ember-utils', 'ember-metal', 'ember-runtime'], function (exports, _emberUtils, _emberMetal, _emberRuntime) {
  'use strict';

  exports.default = _emberRuntime.Object.extend({
    init: function () {
      this._super.apply(this, arguments);
      this.releaseMethods = (0, _emberRuntime.A)();
    },


    /**
      The container-debug-adapter which is used
      to list all models.
       @property containerDebugAdapter
      @default undefined
      @since 1.5.0
      @public
    **/
    containerDebugAdapter: undefined,

    /**
      The number of attributes to send
      as columns. (Enough to make the record
      identifiable).
       @private
      @property attributeLimit
      @default 3
      @since 1.3.0
    */
    attributeLimit: 3,

    /**
       Ember Data > v1.0.0-beta.18
       requires string model names to be passed
       around instead of the actual factories.
        This is a stamp for the Ember Inspector
       to differentiate between the versions
       to be able to support older versions too.
        @public
       @property acceptsModelName
     */
    acceptsModelName: true,

    /**
      Stores all methods that clear observers.
      These methods will be called on destruction.
       @private
      @property releaseMethods
      @since 1.3.0
    */
    releaseMethods: (0, _emberRuntime.A)(),

    /**
      Specifies how records can be filtered.
      Records returned will need to have a `filterValues`
      property with a key for every name in the returned array.
       @public
      @method getFilters
      @return {Array} List of objects defining filters.
       The object should have a `name` and `desc` property.
    */
    getFilters: function () {
      return (0, _emberRuntime.A)();
    },


    /**
      Fetch the model types and observe them for changes.
       @public
      @method watchModelTypes
       @param {Function} typesAdded Callback to call to add types.
      Takes an array of objects containing wrapped types (returned from `wrapModelType`).
       @param {Function} typesUpdated Callback to call when a type has changed.
      Takes an array of objects containing wrapped types.
       @return {Function} Method to call to remove all observers
    */
    watchModelTypes: function (typesAdded, typesUpdated) {
      var _this = this;

      var modelTypes = this.getModelTypes();
      var releaseMethods = (0, _emberRuntime.A)();
      var typesToSend = void 0;

      typesToSend = modelTypes.map(function (type) {
        var klass = type.klass;
        var wrapped = _this.wrapModelType(klass, type.name);
        releaseMethods.push(_this.observeModelType(type.name, typesUpdated));
        return wrapped;
      });

      typesAdded(typesToSend);

      var release = function () {
        releaseMethods.forEach(function (fn) {
          return fn();
        });
        _this.releaseMethods.removeObject(release);
      };
      this.releaseMethods.pushObject(release);
      return release;
    },
    _nameToClass: function (type) {
      if (typeof type === 'string') {
        var owner = (0, _emberUtils.getOwner)(this);
        var Factory = owner.factoryFor('model:' + type);
        type = Factory && Factory.class;
      }
      return type;
    },


    /**
      Fetch the records of a given type and observe them for changes.
       @public
      @method watchRecords
       @param {String} modelName The model name.
       @param {Function} recordsAdded Callback to call to add records.
      Takes an array of objects containing wrapped records.
      The object should have the following properties:
        columnValues: {Object} The key and value of a table cell.
        object: {Object} The actual record object.
       @param {Function} recordsUpdated Callback to call when a record has changed.
      Takes an array of objects containing wrapped records.
       @param {Function} recordsRemoved Callback to call when a record has removed.
      Takes the following parameters:
        index: The array index where the records were removed.
        count: The number of records removed.
       @return {Function} Method to call to remove all observers.
    */
    watchRecords: function (modelName, recordsAdded, recordsUpdated, recordsRemoved) {
      var _this2 = this;

      var releaseMethods = (0, _emberRuntime.A)();
      var klass = this._nameToClass(modelName);
      var records = this.getRecords(klass, modelName);
      var release = void 0;

      function recordUpdated(updatedRecord) {
        recordsUpdated([updatedRecord]);
      }

      var recordsToSend = records.map(function (record) {
        releaseMethods.push(_this2.observeRecord(record, recordUpdated));
        return _this2.wrapRecord(record);
      });

      var contentDidChange = function (array, idx, removedCount, addedCount) {
        for (var i = idx; i < idx + addedCount; i++) {
          var record = (0, _emberRuntime.objectAt)(array, i);
          var wrapped = _this2.wrapRecord(record);
          releaseMethods.push(_this2.observeRecord(record, recordUpdated));
          recordsAdded([wrapped]);
        }

        if (removedCount) {
          recordsRemoved(idx, removedCount);
        }
      };

      var observer = { didChange: contentDidChange, willChange: function () {
          return this;
        }
      };
      (0, _emberRuntime.addArrayObserver)(records, this, observer);

      release = function () {
        releaseMethods.forEach(function (fn) {
          return fn();
        });
        (0, _emberRuntime.removeArrayObserver)(records, _this2, observer);
        _this2.releaseMethods.removeObject(release);
      };

      recordsAdded(recordsToSend);

      this.releaseMethods.pushObject(release);
      return release;
    },


    /**
      Clear all observers before destruction
      @private
      @method willDestroy
    */
    willDestroy: function () {
      this._super.apply(this, arguments);
      this.releaseMethods.forEach(function (fn) {
        return fn();
      });
    },


    /**
      Detect whether a class is a model.
       Test that against the model class
      of your persistence library.
       @private
      @method detect
      @param {Class} klass The class to test.
      @return boolean Whether the class is a model class or not.
    */
    detect: function (klass) {
      return false;
    },


    /**
      Get the columns for a given model type.
       @private
      @method columnsForType
      @param {Class} type The model type.
      @return {Array} An array of columns of the following format:
       name: {String} The name of the column.
       desc: {String} Humanized description (what would show in a table column name).
    */
    columnsForType: function (type) {
      return (0, _emberRuntime.A)();
    },


    /**
      Adds observers to a model type class.
       @private
      @method observeModelType
      @param {String} modelName The model type name.
      @param {Function} typesUpdated Called when a type is modified.
      @return {Function} The function to call to remove observers.
    */

    observeModelType: function (modelName, typesUpdated) {
      var _this3 = this;

      var klass = this._nameToClass(modelName);
      var records = this.getRecords(klass, modelName);

      function onChange() {
        typesUpdated([this.wrapModelType(klass, modelName)]);
      }

      var observer = {
        didChange: function (array, idx, removedCount, addedCount) {
          // Only re-fetch records if the record count changed
          // (which is all we care about as far as model types are concerned).
          if (removedCount > 0 || addedCount > 0) {
            _emberMetal.run.scheduleOnce('actions', this, onChange);
          }
        },
        willChange: function () {
          return this;
        }
      };

      (0, _emberRuntime.addArrayObserver)(records, this, observer);

      var release = function () {
        return (0, _emberRuntime.removeArrayObserver)(records, _this3, observer);
      };

      return release;
    },


    /**
      Wraps a given model type and observes changes to it.
       @private
      @method wrapModelType
      @param {Class} klass A model class.
      @param {String} modelName Name of the class.
      @return {Object} Contains the wrapped type and the function to remove observers
      Format:
        type: {Object} The wrapped type.
          The wrapped type has the following format:
            name: {String} The name of the type.
            count: {Integer} The number of records available.
            columns: {Columns} An array of columns to describe the record.
            object: {Class} The actual Model type class.
        release: {Function} The function to remove observers.
    */
    wrapModelType: function (klass, name) {
      var records = this.getRecords(klass, name);
      var typeToSend = void 0;

      typeToSend = {
        name: name,
        count: (0, _emberMetal.get)(records, 'length'),
        columns: this.columnsForType(klass),
        object: klass
      };

      return typeToSend;
    },


    /**
      Fetches all models defined in the application.
       @private
      @method getModelTypes
      @return {Array} Array of model types.
    */
    getModelTypes: function () {
      var _this4 = this;

      var containerDebugAdapter = this.get('containerDebugAdapter');
      var types = void 0;

      if (containerDebugAdapter.canCatalogEntriesByType('model')) {
        types = containerDebugAdapter.catalogEntriesByType('model');
      } else {
        types = this._getObjectsOnNamespaces();
      }

      // New adapters return strings instead of classes.
      types = (0, _emberRuntime.A)(types).map(function (name) {
        return {
          klass: _this4._nameToClass(name),
          name: name
        };
      });
      types = (0, _emberRuntime.A)(types).filter(function (type) {
        return _this4.detect(type.klass);
      });

      return (0, _emberRuntime.A)(types);
    },


    /**
      Loops over all namespaces and all objects
      attached to them.
       @private
      @method _getObjectsOnNamespaces
      @return {Array} Array of model type strings.
    */
    _getObjectsOnNamespaces: function () {
      var _this5 = this;

      var namespaces = (0, _emberRuntime.A)(_emberRuntime.Namespace.NAMESPACES);
      var types = (0, _emberRuntime.A)();

      namespaces.forEach(function (namespace) {
        for (var key in namespace) {
          if (!namespace.hasOwnProperty(key)) {
            continue;
          }
          // Even though we will filter again in `getModelTypes`,
          // we should not call `lookupFactory` on non-models
          if (!_this5.detect(namespace[key])) {
            continue;
          }
          var name = _emberRuntime.String.dasherize(key);
          types.push(name);
        }
      });
      return types;
    },


    /**
      Fetches all loaded records for a given type.
       @private
      @method getRecords
      @return {Array} An array of records.
       This array will be observed for changes,
       so it should update when new records are added/removed.
    */
    getRecords: function (type) {
      return (0, _emberRuntime.A)();
    },


    /**
      Wraps a record and observers changes to it.
       @private
      @method wrapRecord
      @param {Object} record The record instance.
      @return {Object} The wrapped record. Format:
      columnValues: {Array}
      searchKeywords: {Array}
    */
    wrapRecord: function (record) {
      var recordToSend = { object: record };

      recordToSend.columnValues = this.getRecordColumnValues(record);
      recordToSend.searchKeywords = this.getRecordKeywords(record);
      recordToSend.filterValues = this.getRecordFilterValues(record);
      recordToSend.color = this.getRecordColor(record);

      return recordToSend;
    },


    /**
      Gets the values for each column.
       @private
      @method getRecordColumnValues
      @return {Object} Keys should match column names defined
      by the model type.
    */
    getRecordColumnValues: function (record) {
      return {};
    },


    /**
      Returns keywords to match when searching records.
       @private
      @method getRecordKeywords
      @return {Array} Relevant keywords for search.
    */
    getRecordKeywords: function (record) {
      return (0, _emberRuntime.A)();
    },


    /**
      Returns the values of filters defined by `getFilters`.
       @private
      @method getRecordFilterValues
      @param {Object} record The record instance.
      @return {Object} The filter values.
    */
    getRecordFilterValues: function (record) {
      return {};
    },


    /**
      Each record can have a color that represents its state.
       @private
      @method getRecordColor
      @param {Object} record The record instance
      @return {String} The records color.
        Possible options: black, red, blue, green.
    */
    getRecordColor: function (record) {
      return null;
    },


    /**
      Observes all relevant properties and re-sends the wrapped record
      when a change occurs.
       @private
      @method observerRecord
      @param {Object} record The record instance.
      @param {Function} recordUpdated The callback to call when a record is updated.
      @return {Function} The function to call to remove all observers.
    */
    observeRecord: function (record, recordUpdated) {
      return function () {};
    }
  });
});
enifed('ember-extension-support/index', ['exports', 'ember-extension-support/data_adapter', 'ember-extension-support/container_debug_adapter'], function (exports, _data_adapter, _container_debug_adapter) {
  'use strict';

  Object.defineProperty(exports, 'DataAdapter', {
    enumerable: true,
    get: function () {
      return _data_adapter.default;
    }
  });
  Object.defineProperty(exports, 'ContainerDebugAdapter', {
    enumerable: true,
    get: function () {
      return _container_debug_adapter.default;
    }
  });
});
enifed('ember-glimmer/component-managers/abstract', ['exports', 'ember-babel'], function (exports, _emberBabel) {
  'use strict';

  var AbstractManager = function () {
    function AbstractManager() {
      (0, _emberBabel.classCallCheck)(this, AbstractManager);

      this.debugStack = undefined;
    }

    AbstractManager.prototype.prepareArgs = function prepareArgs(definition, args) {
      return null;
    };

    AbstractManager.prototype.create = function create(env, definition, args, dynamicScope, caller, hasBlock) {
      if (true) {
        throw new Error('AbstractManager#create must be implemented.');
      }
    };

    AbstractManager.prototype.layoutFor = function layoutFor(definition, bucket, env) {
      if (true) {
        throw new Error('AbstractManager#create must be implemented.');
      }
    };

    AbstractManager.prototype.getSelf = function getSelf(bucket) {
      return bucket;
    };

    AbstractManager.prototype.didCreateElement = function didCreateElement(bucket, element, operations) {};

    AbstractManager.prototype.didRenderLayout = function didRenderLayout(bucket, bounds) {};

    AbstractManager.prototype.didCreate = function didCreate(bucket) {};

    AbstractManager.prototype.getTag = function getTag(bucket) {
      return null;
    };

    AbstractManager.prototype.update = function update(bucket, dynamicScope) {};

    AbstractManager.prototype.didUpdateLayout = function didUpdateLayout(bucket, bounds) {};

    AbstractManager.prototype.didUpdate = function didUpdate(bucket) {};

    AbstractManager.prototype.getDestructor = function getDestructor(bucket) {};

    return AbstractManager;
  }();

  exports.default = AbstractManager;


  if (true) {
    AbstractManager.prototype._pushToDebugStack = function (name, environment) {
      this.debugStack = environment.debugStack;
      this.debugStack.push(name);
    };

    AbstractManager.prototype._pushEngineToDebugStack = function (name, environment) {
      this.debugStack = environment.debugStack;
      this.debugStack.pushEngine(name);
    };
  }
});
enifed('ember-glimmer/component-managers/curly', ['exports', 'ember-babel', 'ember-utils', '@glimmer/reference', '@glimmer/runtime', 'ember-debug', 'ember-glimmer/component', 'ember-glimmer/utils/bindings', 'ember-metal', 'ember-glimmer/utils/process-args', 'ember-views', 'container', 'ember-glimmer/component-managers/abstract', 'ember-glimmer/utils/curly-component-state-bucket', 'ember-glimmer/utils/references'], function (exports, _emberBabel, _emberUtils, _reference, _runtime, _emberDebug, _component, _bindings, _emberMetal, _processArgs, _emberViews, _container, _abstract, _curlyComponentStateBucket, _references) {
  'use strict';

  exports.CurlyComponentDefinition = exports.PositionalArgumentReference = undefined;
  exports.validatePositionalParameters = validatePositionalParameters;
  exports.processComponentInitializationAssertions = processComponentInitializationAssertions;
  exports.initialRenderInstrumentDetails = initialRenderInstrumentDetails;
  exports.rerenderInstrumentDetails = rerenderInstrumentDetails;

  var _templateObject = (0, _emberBabel.taggedTemplateLiteralLoose)(['template:components/-default'], ['template:components/-default']);

  var DEFAULT_LAYOUT = (0, _container.privatize)(_templateObject);

  function aliasIdToElementId(args, props) {
    if (args.named.has('id')) {
      (true && !(!args.named.has('elementId')) && (0, _emberDebug.assert)('You cannot invoke a component with both \'id\' and \'elementId\' at the same time.', !args.named.has('elementId')));

      props.elementId = props.id;
    }
  }

  // We must traverse the attributeBindings in reverse keeping track of
  // what has already been applied. This is essentially refining the concated
  // properties applying right to left.
  function applyAttributeBindings(element, attributeBindings, component, operations) {
    var seen = [];
    var i = attributeBindings.length - 1;

    while (i !== -1) {
      var binding = attributeBindings[i];
      var parsed = _bindings.AttributeBinding.parse(binding);
      var attribute = parsed[1];

      if (seen.indexOf(attribute) === -1) {
        seen.push(attribute);
        _bindings.AttributeBinding.install(element, component, parsed, operations);
      }

      i--;
    }

    if (seen.indexOf('id') === -1) {
      operations.addStaticAttribute(element, 'id', component.elementId);
    }

    if (seen.indexOf('style') === -1) {
      _bindings.IsVisibleBinding.install(element, component, operations);
    }
  }

  function tagName(vm) {
    var tagName = vm.dynamicScope().view.tagName;


    return _runtime.PrimitiveReference.create(tagName === '' ? null : tagName || 'div');
  }

  function ariaRole(vm) {
    return vm.getSelf().get('ariaRole');
  }

  var CurlyComponentLayoutCompiler = function () {
    function CurlyComponentLayoutCompiler(template) {
      (0, _emberBabel.classCallCheck)(this, CurlyComponentLayoutCompiler);

      this.template = template;
    }

    CurlyComponentLayoutCompiler.prototype.compile = function compile(builder) {
      builder.wrapLayout(this.template);
      builder.tag.dynamic(tagName);
      builder.attrs.dynamic('role', ariaRole);
      builder.attrs.static('class', 'ember-view');
    };

    return CurlyComponentLayoutCompiler;
  }();

  CurlyComponentLayoutCompiler.id = 'curly';

  var PositionalArgumentReference = exports.PositionalArgumentReference = function () {
    function PositionalArgumentReference(references) {
      (0, _emberBabel.classCallCheck)(this, PositionalArgumentReference);

      this.tag = (0, _reference.combineTagged)(references);
      this._references = references;
    }

    PositionalArgumentReference.prototype.value = function value() {
      return this._references.map(function (reference) {
        return reference.value();
      });
    };

    PositionalArgumentReference.prototype.get = function get(key) {
      return _references.PropertyReference.create(this, key);
    };

    return PositionalArgumentReference;
  }();

  var CurlyComponentManager = function (_AbstractManager) {
    (0, _emberBabel.inherits)(CurlyComponentManager, _AbstractManager);

    function CurlyComponentManager() {
      (0, _emberBabel.classCallCheck)(this, CurlyComponentManager);
      return (0, _emberBabel.possibleConstructorReturn)(this, _AbstractManager.apply(this, arguments));
    }

    CurlyComponentManager.prototype.prepareArgs = function prepareArgs(definition, args) {
      var componentPositionalParamsDefinition = definition.ComponentClass.class.positionalParams;

      if (true && componentPositionalParamsDefinition) {
        validatePositionalParameters(args.named, args.positional, componentPositionalParamsDefinition);
      }

      var componentHasRestStylePositionalParams = typeof componentPositionalParamsDefinition === 'string';
      var componentHasPositionalParams = componentHasRestStylePositionalParams || componentPositionalParamsDefinition.length > 0;
      var needsPositionalParamMunging = componentHasPositionalParams && args.positional.length !== 0;
      var isClosureComponent = definition.args;

      if (!needsPositionalParamMunging && !isClosureComponent) {
        return null;
      }

      var capturedArgs = args.capture();
      // grab raw positional references array
      var positional = capturedArgs.positional.references;

      // handle prep for closure component with positional params
      var curriedNamed = void 0;
      if (definition.args) {
        var remainingDefinitionPositionals = definition.args.positional.slice(positional.length);
        positional = positional.concat(remainingDefinitionPositionals);
        curriedNamed = definition.args.named;
      }

      // handle positionalParams
      var positionalParamsToNamed = void 0;
      if (componentHasRestStylePositionalParams) {
        var _positionalParamsToNa;

        positionalParamsToNamed = (_positionalParamsToNa = {}, _positionalParamsToNa[componentPositionalParamsDefinition] = new PositionalArgumentReference(positional), _positionalParamsToNa);
        positional = [];
      } else if (componentHasPositionalParams) {
        positionalParamsToNamed = {};
        var length = Math.min(positional.length, componentPositionalParamsDefinition.length);
        for (var i = 0; i < length; i++) {
          var name = componentPositionalParamsDefinition[i];
          positionalParamsToNamed[name] = positional[i];
        }
      }

      var named = (0, _emberUtils.assign)({}, curriedNamed, positionalParamsToNamed, capturedArgs.named.map);

      return { positional: positional, named: named };
    };

    CurlyComponentManager.prototype.create = function create(environment, definition, args, dynamicScope, callerSelfRef, hasBlock) {
      if (true) {
        this._pushToDebugStack('component:' + definition.name, environment);
      }

      var parentView = dynamicScope.view;

      var factory = definition.ComponentClass;

      var capturedArgs = args.named.capture();
      var props = (0, _processArgs.processComponentArgs)(capturedArgs);

      aliasIdToElementId(args, props);

      props.parentView = parentView;
      props[_component.HAS_BLOCK] = hasBlock;

      props._targetObject = callerSelfRef.value();

      var component = factory.create(props);

      var finalizer = (0, _emberMetal._instrumentStart)('render.component', initialRenderInstrumentDetails, component);

      dynamicScope.view = component;

      if (parentView !== null) {
        parentView.appendChild(component);
      }

      // We usually do this in the `didCreateElement`, but that hook doesn't fire for tagless components
      if (component.tagName === '') {
        if (environment.isInteractive) {
          component.trigger('willRender');
        }

        component._transitionTo('hasElement');

        if (environment.isInteractive) {
          component.trigger('willInsertElement');
        }
      }

      var bucket = new _curlyComponentStateBucket.default(environment, component, capturedArgs, finalizer);

      if (args.named.has('class')) {
        bucket.classRef = args.named.get('class');
      }

      if (true) {
        processComponentInitializationAssertions(component, props);
      }

      if (environment.isInteractive && component.tagName !== '') {
        component.trigger('willRender');
      }

      return bucket;
    };

    CurlyComponentManager.prototype.layoutFor = function layoutFor(definition, bucket, env) {
      var template = definition.template;
      if (!template) {
        var component = bucket.component;

        template = this.templateFor(component, env);
      }
      return env.getCompiledBlock(CurlyComponentLayoutCompiler, template);
    };

    CurlyComponentManager.prototype.templateFor = function templateFor(component, env) {
      var Template = (0, _emberMetal.get)(component, 'layout');
      var owner = component[_emberUtils.OWNER];
      if (Template) {
        return env.getTemplate(Template, owner);
      }
      var layoutName = (0, _emberMetal.get)(component, 'layoutName');
      if (layoutName) {
        var template = owner.lookup('template:' + layoutName);
        if (template) {
          return template;
        }
      }
      return owner.lookup(DEFAULT_LAYOUT);
    };

    CurlyComponentManager.prototype.getSelf = function getSelf(_ref) {
      var component = _ref.component;

      return component[_component.ROOT_REF];
    };

    CurlyComponentManager.prototype.didCreateElement = function didCreateElement(_ref2, element, operations) {
      var component = _ref2.component,
          classRef = _ref2.classRef,
          environment = _ref2.environment;

      (0, _emberViews.setViewElement)(component, element);

      var attributeBindings = component.attributeBindings,
          classNames = component.classNames,
          classNameBindings = component.classNameBindings;


      if (attributeBindings && attributeBindings.length) {
        applyAttributeBindings(element, attributeBindings, component, operations);
      } else {
        operations.addStaticAttribute(element, 'id', component.elementId);
        _bindings.IsVisibleBinding.install(element, component, operations);
      }

      if (classRef) {
        operations.addDynamicAttribute(element, 'class', classRef);
      }

      if (classNames && classNames.length) {
        classNames.forEach(function (name) {
          operations.addStaticAttribute(element, 'class', name);
        });
      }

      if (classNameBindings && classNameBindings.length) {
        classNameBindings.forEach(function (binding) {
          _bindings.ClassNameBinding.install(element, component, binding, operations);
        });
      }

      component._transitionTo('hasElement');

      if (environment.isInteractive) {
        component.trigger('willInsertElement');
      }
    };

    CurlyComponentManager.prototype.didRenderLayout = function didRenderLayout(bucket, bounds) {
      bucket.component[_component.BOUNDS] = bounds;
      bucket.finalize();

      if (true) {
        this.debugStack.pop();
      }
    };

    CurlyComponentManager.prototype.getTag = function getTag(_ref3) {
      var component = _ref3.component;

      return component[_component.DIRTY_TAG];
    };

    CurlyComponentManager.prototype.didCreate = function didCreate(_ref4) {
      var component = _ref4.component,
          environment = _ref4.environment;

      if (environment.isInteractive) {
        component._transitionTo('inDOM');
        component.trigger('didInsertElement');
        component.trigger('didRender');
      }
    };

    CurlyComponentManager.prototype.update = function update(bucket, _, dynamicScope) {
      var component = bucket.component,
          args = bucket.args,
          argsRevision = bucket.argsRevision,
          environment = bucket.environment;


      if (true) {
        this._pushToDebugStack(component._debugContainerKey, environment);
      }

      bucket.finalizer = (0, _emberMetal._instrumentStart)('render.component', rerenderInstrumentDetails, component);

      if (!args.tag.validate(argsRevision)) {
        var props = (0, _processArgs.processComponentArgs)(args);

        bucket.argsRevision = args.tag.value();

        component[_component.IS_DISPATCHING_ATTRS] = true;
        component.setProperties(props);
        component[_component.IS_DISPATCHING_ATTRS] = false;

        component.trigger('didUpdateAttrs');
        component.trigger('didReceiveAttrs');
      }

      if (environment.isInteractive) {
        component.trigger('willUpdate');
        component.trigger('willRender');
      }
    };

    CurlyComponentManager.prototype.didUpdateLayout = function didUpdateLayout(bucket) {
      bucket.finalize();

      if (true) {
        this.debugStack.pop();
      }
    };

    CurlyComponentManager.prototype.didUpdate = function didUpdate(_ref5) {
      var component = _ref5.component,
          environment = _ref5.environment;

      if (environment.isInteractive) {
        component.trigger('didUpdate');
        component.trigger('didRender');
      }
    };

    CurlyComponentManager.prototype.getDestructor = function getDestructor(stateBucket) {
      return stateBucket;
    };

    return CurlyComponentManager;
  }(_abstract.default);

  exports.default = CurlyComponentManager;
  function validatePositionalParameters(named, positional, positionalParamsDefinition) {
    if (true) {
      if (!named || !positional || !positional.length) {
        return;
      }

      var paramType = typeof positionalParamsDefinition;

      if (paramType === 'string') {
        (true && !(!named.has(positionalParamsDefinition)) && (0, _emberDebug.assert)('You cannot specify positional parameters and the hash argument `' + positionalParamsDefinition + '`.', !named.has(positionalParamsDefinition)));
      } else {
        if (positional.length < positionalParamsDefinition.length) {
          positionalParamsDefinition = positionalParamsDefinition.slice(0, positional.length);
        }

        for (var i = 0; i < positionalParamsDefinition.length; i++) {
          var name = positionalParamsDefinition[i];

          (true && !(!named.has(name)) && (0, _emberDebug.assert)('You cannot specify both a positional param (at position ' + i + ') and the hash argument `' + name + '`.', !named.has(name)));
        }
      }
    }
  }

  function processComponentInitializationAssertions(component, props) {
    (true && !(function () {
      var classNameBindings = component.classNameBindings;

      for (var i = 0; i < classNameBindings.length; i++) {
        var binding = classNameBindings[i];
        if (binding.split(' ').length > 1) {
          return false;
        }
      }
      return true;
    }()) && (0, _emberDebug.assert)('classNameBindings must not have spaces in them: ' + component.toString(), function () {
      var classNameBindings = component.classNameBindings;
      for (var i = 0; i < classNameBindings.length; i++) {
        var binding = classNameBindings[i];if (binding.split(' ').length > 1) {
          return false;
        }
      }return true;
    }()));
    (true && !(function () {
      var classNameBindings = component.classNameBindings,
          tagName = component.tagName;

      return tagName !== '' || !classNameBindings || classNameBindings.length === 0;
    }()) && (0, _emberDebug.assert)('You cannot use `classNameBindings` on a tag-less component: ' + component.toString(), function () {
      var classNameBindings = component.classNameBindings,
          tagName = component.tagName;
      return tagName !== '' || !classNameBindings || classNameBindings.length === 0;
    }()));
    (true && !(function () {
      var elementId = component.elementId,
          tagName = component.tagName;

      return tagName !== '' || props.id === elementId || !elementId && elementId !== '';
    }()) && (0, _emberDebug.assert)('You cannot use `elementId` on a tag-less component: ' + component.toString(), function () {
      var elementId = component.elementId,
          tagName = component.tagName;
      return tagName !== '' || props.id === elementId || !elementId && elementId !== '';
    }()));
    (true && !(function () {
      var attributeBindings = component.attributeBindings,
          tagName = component.tagName;

      return tagName !== '' || !attributeBindings || attributeBindings.length === 0;
    }()) && (0, _emberDebug.assert)('You cannot use `attributeBindings` on a tag-less component: ' + component.toString(), function () {
      var attributeBindings = component.attributeBindings,
          tagName = component.tagName;
      return tagName !== '' || !attributeBindings || attributeBindings.length === 0;
    }()));
  }

  function initialRenderInstrumentDetails(component) {
    return component.instrumentDetails({ initialRender: true });
  }

  function rerenderInstrumentDetails(component) {
    return component.instrumentDetails({ initialRender: false });
  }

  var MANAGER = new CurlyComponentManager();

  var CurlyComponentDefinition = exports.CurlyComponentDefinition = function (_ComponentDefinition) {
    (0, _emberBabel.inherits)(CurlyComponentDefinition, _ComponentDefinition);

    function CurlyComponentDefinition(name, ComponentClass, template, args, customManager) {
      (0, _emberBabel.classCallCheck)(this, CurlyComponentDefinition);

      var _this2 = (0, _emberBabel.possibleConstructorReturn)(this, _ComponentDefinition.call(this, name, customManager || MANAGER, ComponentClass));

      _this2.template = template;
      _this2.args = args;
      return _this2;
    }

    return CurlyComponentDefinition;
  }(_runtime.ComponentDefinition);
});
enifed('ember-glimmer/component-managers/mount', ['exports', 'ember-babel', '@glimmer/runtime', '@glimmer/reference', 'ember-glimmer/utils/references', 'ember-glimmer/component-managers/outlet', 'ember-glimmer/component-managers/abstract', 'ember-routing', 'ember/features'], function (exports, _emberBabel, _runtime, _reference, _references, _outlet, _abstract, _emberRouting, _features) {
  'use strict';

  exports.MountDefinition = undefined;

  var MountManager = function (_AbstractManager) {
    (0, _emberBabel.inherits)(MountManager, _AbstractManager);

    function MountManager() {
      (0, _emberBabel.classCallCheck)(this, MountManager);
      return (0, _emberBabel.possibleConstructorReturn)(this, _AbstractManager.apply(this, arguments));
    }

    MountManager.prototype.prepareArgs = function prepareArgs(definition, args) {
      return null;
    };

    MountManager.prototype.create = function create(environment, _ref, args, dynamicScope) {
      var name = _ref.name;

      if (true) {
        this._pushEngineToDebugStack('engine:' + name, environment);
      }

      dynamicScope.outletState = _reference.UNDEFINED_REFERENCE;

      var engine = environment.owner.buildChildEngineInstance(name);

      engine.boot();

      var bucket = { engine: engine };

      if (_features.EMBER_ENGINES_MOUNT_PARAMS) {
        bucket.modelReference = args.named.get('model');
      }

      return bucket;
    };

    MountManager.prototype.layoutFor = function layoutFor(definition, _ref2, env) {
      var engine = _ref2.engine;

      var template = engine.lookup('template:application');
      return env.getCompiledBlock(_outlet.OutletLayoutCompiler, template);
    };

    MountManager.prototype.getSelf = function getSelf(bucket) {
      var engine = bucket.engine,
          modelReference = bucket.modelReference;


      var applicationFactory = engine.factoryFor('controller:application');
      var controllerFactory = applicationFactory || (0, _emberRouting.generateControllerFactory)(engine, 'application');
      var controller = bucket.controller = controllerFactory.create();

      if (_features.EMBER_ENGINES_MOUNT_PARAMS) {
        var model = modelReference.value();
        bucket.modelRevision = modelReference.tag.value();
        controller.set('model', model);
      }

      return new _references.RootReference(controller);
    };

    MountManager.prototype.getDestructor = function getDestructor(_ref3) {
      var engine = _ref3.engine;

      return engine;
    };

    MountManager.prototype.didRenderLayout = function didRenderLayout() {
      if (true) {
        this.debugStack.pop();
      }
    };

    MountManager.prototype.update = function update(bucket) {
      if (_features.EMBER_ENGINES_MOUNT_PARAMS) {
        var controller = bucket.controller,
            modelReference = bucket.modelReference,
            modelRevision = bucket.modelRevision;


        if (!modelReference.tag.validate(modelRevision)) {
          var model = modelReference.value();
          bucket.modelRevision = modelReference.tag.value();
          controller.set('model', model);
        }
      }
    };

    return MountManager;
  }(_abstract.default);

  var MOUNT_MANAGER = new MountManager();

  var MountDefinition = exports.MountDefinition = function (_ComponentDefinition) {
    (0, _emberBabel.inherits)(MountDefinition, _ComponentDefinition);

    function MountDefinition(name) {
      (0, _emberBabel.classCallCheck)(this, MountDefinition);
      return (0, _emberBabel.possibleConstructorReturn)(this, _ComponentDefinition.call(this, name, MOUNT_MANAGER, null));
    }

    return MountDefinition;
  }(_runtime.ComponentDefinition);
});
enifed('ember-glimmer/component-managers/outlet', ['exports', 'ember-babel', 'ember-utils', '@glimmer/runtime', 'ember-metal', 'ember-glimmer/utils/references', 'ember-glimmer/component-managers/abstract'], function (exports, _emberBabel, _emberUtils, _runtime, _emberMetal, _references, _abstract) {
  'use strict';

  exports.OutletLayoutCompiler = exports.OutletComponentDefinition = exports.TopLevelOutletComponentDefinition = undefined;


  function instrumentationPayload(_ref) {
    var _ref$render = _ref.render,
        name = _ref$render.name,
        outlet = _ref$render.outlet;

    return { object: name + ':' + outlet };
  }

  function NOOP() {}

  var StateBucket = function () {
    function StateBucket(outletState) {
      (0, _emberBabel.classCallCheck)(this, StateBucket);

      this.outletState = outletState;
      this.instrument();
    }

    StateBucket.prototype.instrument = function instrument() {
      this.finalizer = (0, _emberMetal._instrumentStart)('render.outlet', instrumentationPayload, this.outletState);
    };

    StateBucket.prototype.finalize = function finalize() {
      var finalizer = this.finalizer;

      finalizer();
      this.finalizer = NOOP;
    };

    return StateBucket;
  }();

  var OutletComponentManager = function (_AbstractManager) {
    (0, _emberBabel.inherits)(OutletComponentManager, _AbstractManager);

    function OutletComponentManager() {
      (0, _emberBabel.classCallCheck)(this, OutletComponentManager);
      return (0, _emberBabel.possibleConstructorReturn)(this, _AbstractManager.apply(this, arguments));
    }

    OutletComponentManager.prototype.create = function create(environment, definition, args, dynamicScope) {
      if (true) {
        this._pushToDebugStack('template:' + definition.template.meta.moduleName, environment);
      }

      var outletStateReference = dynamicScope.outletState = dynamicScope.outletState.get('outlets').get(definition.outletName);
      var outletState = outletStateReference.value();
      return new StateBucket(outletState);
    };

    OutletComponentManager.prototype.layoutFor = function layoutFor(definition, bucket, env) {
      return env.getCompiledBlock(OutletLayoutCompiler, definition.template);
    };

    OutletComponentManager.prototype.getSelf = function getSelf(_ref2) {
      var outletState = _ref2.outletState;

      return new _references.RootReference(outletState.render.controller);
    };

    OutletComponentManager.prototype.didRenderLayout = function didRenderLayout(bucket) {
      bucket.finalize();

      if (true) {
        this.debugStack.pop();
      }
    };

    return OutletComponentManager;
  }(_abstract.default);

  var MANAGER = new OutletComponentManager();

  var TopLevelOutletComponentManager = function (_OutletComponentManag) {
    (0, _emberBabel.inherits)(TopLevelOutletComponentManager, _OutletComponentManag);

    function TopLevelOutletComponentManager() {
      (0, _emberBabel.classCallCheck)(this, TopLevelOutletComponentManager);
      return (0, _emberBabel.possibleConstructorReturn)(this, _OutletComponentManag.apply(this, arguments));
    }

    TopLevelOutletComponentManager.prototype.create = function create(environment, definition, args, dynamicScope) {
      if (true) {
        this._pushToDebugStack('template:' + definition.template.meta.moduleName, environment);
      }
      return new StateBucket(dynamicScope.outletState.value());
    };

    TopLevelOutletComponentManager.prototype.layoutFor = function layoutFor(definition, bucket, env) {
      return env.getCompiledBlock(TopLevelOutletLayoutCompiler, definition.template);
    };

    return TopLevelOutletComponentManager;
  }(OutletComponentManager);

  var TOP_LEVEL_MANAGER = new TopLevelOutletComponentManager();

  var TopLevelOutletComponentDefinition = exports.TopLevelOutletComponentDefinition = function (_ComponentDefinition) {
    (0, _emberBabel.inherits)(TopLevelOutletComponentDefinition, _ComponentDefinition);

    function TopLevelOutletComponentDefinition(instance) {
      (0, _emberBabel.classCallCheck)(this, TopLevelOutletComponentDefinition);

      var _this3 = (0, _emberBabel.possibleConstructorReturn)(this, _ComponentDefinition.call(this, 'outlet', TOP_LEVEL_MANAGER, instance));

      _this3.template = instance.template;
      (0, _emberUtils.generateGuid)(_this3);
      return _this3;
    }

    return TopLevelOutletComponentDefinition;
  }(_runtime.ComponentDefinition);

  var TopLevelOutletLayoutCompiler = function () {
    function TopLevelOutletLayoutCompiler(template) {
      (0, _emberBabel.classCallCheck)(this, TopLevelOutletLayoutCompiler);

      this.template = template;
    }

    TopLevelOutletLayoutCompiler.prototype.compile = function compile(builder) {
      builder.wrapLayout(this.template);
      builder.tag.static('div');
      builder.attrs.static('id', (0, _emberUtils.guidFor)(this));
      builder.attrs.static('class', 'ember-view');
    };

    return TopLevelOutletLayoutCompiler;
  }();

  TopLevelOutletLayoutCompiler.id = 'top-level-outlet';

  var OutletComponentDefinition = exports.OutletComponentDefinition = function (_ComponentDefinition2) {
    (0, _emberBabel.inherits)(OutletComponentDefinition, _ComponentDefinition2);

    function OutletComponentDefinition(outletName, template) {
      (0, _emberBabel.classCallCheck)(this, OutletComponentDefinition);

      var _this4 = (0, _emberBabel.possibleConstructorReturn)(this, _ComponentDefinition2.call(this, 'outlet', MANAGER, null));

      _this4.outletName = outletName;
      _this4.template = template;
      (0, _emberUtils.generateGuid)(_this4);
      return _this4;
    }

    return OutletComponentDefinition;
  }(_runtime.ComponentDefinition);

  var OutletLayoutCompiler = exports.OutletLayoutCompiler = function () {
    function OutletLayoutCompiler(template) {
      (0, _emberBabel.classCallCheck)(this, OutletLayoutCompiler);

      this.template = template;
    }

    OutletLayoutCompiler.prototype.compile = function compile(builder) {
      builder.wrapLayout(this.template);
    };

    return OutletLayoutCompiler;
  }();

  OutletLayoutCompiler.id = 'outlet';
});
enifed('ember-glimmer/component-managers/render', ['exports', 'ember-babel', '@glimmer/runtime', 'ember-debug', 'ember-glimmer/utils/references', 'ember-routing', 'ember-glimmer/component-managers/outlet', 'ember-glimmer/component-managers/abstract'], function (exports, _emberBabel, _runtime, _emberDebug, _references, _emberRouting, _outlet, _abstract) {
  'use strict';

  exports.RenderDefinition = exports.NON_SINGLETON_RENDER_MANAGER = exports.SINGLETON_RENDER_MANAGER = exports.AbstractRenderManager = undefined;

  var AbstractRenderManager = exports.AbstractRenderManager = function (_AbstractManager) {
    (0, _emberBabel.inherits)(AbstractRenderManager, _AbstractManager);

    function AbstractRenderManager() {
      (0, _emberBabel.classCallCheck)(this, AbstractRenderManager);
      return (0, _emberBabel.possibleConstructorReturn)(this, _AbstractManager.apply(this, arguments));
    }

    AbstractRenderManager.prototype.layoutFor = function layoutFor(definition, bucket, env) {
      return env.getCompiledBlock(_outlet.OutletLayoutCompiler, definition.template);
    };

    AbstractRenderManager.prototype.getSelf = function getSelf(_ref) {
      var controller = _ref.controller;

      return new _references.RootReference(controller);
    };

    return AbstractRenderManager;
  }(_abstract.default);

  if (true) {
    AbstractRenderManager.prototype.didRenderLayout = function () {
      this.debugStack.pop();
    };
  }

  var SingletonRenderManager = function (_AbstractRenderManage) {
    (0, _emberBabel.inherits)(SingletonRenderManager, _AbstractRenderManage);

    function SingletonRenderManager() {
      (0, _emberBabel.classCallCheck)(this, SingletonRenderManager);
      return (0, _emberBabel.possibleConstructorReturn)(this, _AbstractRenderManage.apply(this, arguments));
    }

    SingletonRenderManager.prototype.create = function create(environment, definition, args, dynamicScope) {
      var name = definition.name,
          env = definition.env;

      var controller = env.owner.lookup('controller:' + name) || (0, _emberRouting.generateController)(env.owner, name);

      if (true) {
        this._pushToDebugStack('controller:' + name + ' (with the render helper)', environment);
      }

      if (dynamicScope.rootOutletState) {
        dynamicScope.outletState = dynamicScope.rootOutletState.getOrphan(name);
      }

      return { controller: controller };
    };

    return SingletonRenderManager;
  }(AbstractRenderManager);

  var SINGLETON_RENDER_MANAGER = exports.SINGLETON_RENDER_MANAGER = new SingletonRenderManager();

  var NonSingletonRenderManager = function (_AbstractRenderManage2) {
    (0, _emberBabel.inherits)(NonSingletonRenderManager, _AbstractRenderManage2);

    function NonSingletonRenderManager() {
      (0, _emberBabel.classCallCheck)(this, NonSingletonRenderManager);
      return (0, _emberBabel.possibleConstructorReturn)(this, _AbstractRenderManage2.apply(this, arguments));
    }

    NonSingletonRenderManager.prototype.create = function create(environment, definition, args, dynamicScope) {
      var name = definition.name,
          env = definition.env;

      var modelRef = args.positional.at(0);
      var controllerFactory = env.owner.factoryFor('controller:' + name);

      var factory = controllerFactory || (0, _emberRouting.generateControllerFactory)(env.owner, name);
      var controller = factory.create({ model: modelRef.value() });

      if (true) {
        this._pushToDebugStack('controller:' + name + ' (with the render helper)', environment);
      }

      if (dynamicScope.rootOutletState) {
        dynamicScope.outletState = dynamicScope.rootOutletState.getOrphan(name);
      }

      return { controller: controller, model: modelRef };
    };

    NonSingletonRenderManager.prototype.update = function update(_ref2, dynamicScope) {
      var controller = _ref2.controller,
          model = _ref2.model;

      controller.set('model', model.value());
    };

    NonSingletonRenderManager.prototype.getDestructor = function getDestructor(_ref3) {
      var controller = _ref3.controller;

      return controller;
    };

    return NonSingletonRenderManager;
  }(AbstractRenderManager);

  var NON_SINGLETON_RENDER_MANAGER = exports.NON_SINGLETON_RENDER_MANAGER = new NonSingletonRenderManager();

  var RenderDefinition = exports.RenderDefinition = function (_ComponentDefinition) {
    (0, _emberBabel.inherits)(RenderDefinition, _ComponentDefinition);

    function RenderDefinition(name, template, env, manager) {
      (0, _emberBabel.classCallCheck)(this, RenderDefinition);

      var _this4 = (0, _emberBabel.possibleConstructorReturn)(this, _ComponentDefinition.call(this, 'render', manager, null));

      _this4.name = name;
      _this4.template = template;
      _this4.env = env;
      return _this4;
    }

    return RenderDefinition;
  }(_runtime.ComponentDefinition);
});
enifed('ember-glimmer/component-managers/root', ['exports', 'ember-babel', '@glimmer/runtime', 'ember-metal', 'ember-debug', 'ember-glimmer/utils/curly-component-state-bucket', 'ember-glimmer/component-managers/curly'], function (exports, _emberBabel, _runtime, _emberMetal, _emberDebug, _curlyComponentStateBucket, _curly) {
  'use strict';

  exports.RootComponentDefinition = undefined;

  var RootComponentManager = function (_CurlyComponentManage) {
    (0, _emberBabel.inherits)(RootComponentManager, _CurlyComponentManage);

    function RootComponentManager() {
      (0, _emberBabel.classCallCheck)(this, RootComponentManager);
      return (0, _emberBabel.possibleConstructorReturn)(this, _CurlyComponentManage.apply(this, arguments));
    }

    RootComponentManager.prototype.create = function create(environment, definition, args, dynamicScope, currentScope, hasBlock) {
      var component = definition.ComponentClass.create();

      if (true) {
        this._pushToDebugStack(component._debugContainerKey, environment);
      }

      var finalizer = (0, _emberMetal._instrumentStart)('render.component', _curly.initialRenderInstrumentDetails, component);

      dynamicScope.view = component;

      // We usually do this in the `didCreateElement`, but that hook doesn't fire for tagless components
      if (component.tagName === '') {
        if (environment.isInteractive) {
          component.trigger('willRender');
        }

        component._transitionTo('hasElement');

        if (environment.isInteractive) {
          component.trigger('willInsertElement');
        }
      }

      if (true) {
        (0, _curly.processComponentInitializationAssertions)(component, {});
      }

      return new _curlyComponentStateBucket.default(environment, component, args.named.capture(), finalizer);
    };

    return RootComponentManager;
  }(_curly.default);

  var ROOT_MANAGER = new RootComponentManager();

  var RootComponentDefinition = exports.RootComponentDefinition = function (_ComponentDefinition) {
    (0, _emberBabel.inherits)(RootComponentDefinition, _ComponentDefinition);

    function RootComponentDefinition(instance) {
      (0, _emberBabel.classCallCheck)(this, RootComponentDefinition);

      var _this2 = (0, _emberBabel.possibleConstructorReturn)(this, _ComponentDefinition.call(this, '-root', ROOT_MANAGER, {
        class: instance.constructor,
        create: function () {
          return instance;
        }
      }));

      _this2.template = undefined;
      _this2.args = undefined;
      return _this2;
    }

    return RootComponentDefinition;
  }(_runtime.ComponentDefinition);
});
enifed('ember-glimmer/component', ['exports', 'ember-utils', 'ember-views', 'ember-runtime', 'ember-debug', 'ember-metal', 'ember-glimmer/utils/references', '@glimmer/reference', '@glimmer/runtime'], function (exports, _emberUtils, _emberViews, _emberRuntime, _emberDebug, _emberMetal, _references, _reference, _runtime) {
  'use strict';

  exports.BOUNDS = exports.HAS_BLOCK = exports.IS_DISPATCHING_ATTRS = exports.ROOT_REF = exports.ARGS = exports.DIRTY_TAG = undefined;

  var _CoreView$extend;

  var DIRTY_TAG = exports.DIRTY_TAG = (0, _emberUtils.symbol)('DIRTY_TAG');
  var ARGS = exports.ARGS = (0, _emberUtils.symbol)('ARGS');
  var ROOT_REF = exports.ROOT_REF = (0, _emberUtils.symbol)('ROOT_REF');
  var IS_DISPATCHING_ATTRS = exports.IS_DISPATCHING_ATTRS = (0, _emberUtils.symbol)('IS_DISPATCHING_ATTRS');
  var HAS_BLOCK = exports.HAS_BLOCK = (0, _emberUtils.symbol)('HAS_BLOCK');
  var BOUNDS = exports.BOUNDS = (0, _emberUtils.symbol)('BOUNDS');

  /**
  @module @ember/component
  */

  /**
    A `Component` is a view that is completely
    isolated. Properties accessed in its templates go
    to the view object and actions are targeted at
    the view object. There is no access to the
    surrounding context or outer controller; all
    contextual information must be passed in.
  
    The easiest way to create a `Component` is via
    a template. If you name a template
    `app/components/my-foo.hbs`, you will be able to use
    `{{my-foo}}` in other templates, which will make
    an instance of the isolated component.
  
    ```app/components/my-foo.hbs
    {{person-profile person=currentUser}}
    ```
  
    ```app/components/person-profile.hbs
    <h1>{{person.title}}</h1>
    <img src={{person.avatar}}>
    <p class='signature'>{{person.signature}}</p>
    ```
  
    You can use `yield` inside a template to
    include the **contents** of any block attached to
    the component. The block will be executed in the
    context of the surrounding context or outer controller:
  
    ```handlebars
    {{#person-profile person=currentUser}}
      <p>Admin mode</p>
      {{! Executed in the controller's context. }}
    {{/person-profile}}
    ```
  
    ```app/components/person-profile.hbs
    <h1>{{person.title}}</h1>
    {{! Executed in the component's context. }}
    {{yield}} {{! block contents }}
    ```
  
    If you want to customize the component, in order to
    handle events or actions, you implement a subclass
    of `Component` named after the name of the
    component.
  
    For example, you could implement the action
    `hello` for the `person-profile` component:
  
    ```app/components/person-profile.js
    import Component from '@ember/component';
  
    export default Component.extend({
      actions: {
        hello(name) {
          console.log("Hello", name);
        }
      }
    });
    ```
  
    And then use it in the component's template:
  
    ```app/templates/components/person-profile.hbs
    <h1>{{person.title}}</h1>
    {{yield}} <!-- block contents -->
    <button {{action 'hello' person.name}}>
      Say Hello to {{person.name}}
    </button>
    ```
  
    Components must have a `-` in their name to avoid
    conflicts with built-in controls that wrap HTML
    elements. This is consistent with the same
    requirement in web components.
  
  
    ## HTML Tag
  
    The default HTML tag name used for a component's DOM representation is `div`.
    This can be customized by setting the `tagName` property.
    The following component class:
  
    ```app/components/emphasized-paragraph.js
    import Component from '@ember/component';
  
    export default Component.extend({
      tagName: 'em'
    });
    ```
  
    Would result in instances with the following HTML:
  
    ```html
    <em id="ember1" class="ember-view"></em>
    ```
  
  
    ## HTML `class` Attribute
  
    The HTML `class` attribute of a component's tag can be set by providing a
    `classNames` property that is set to an array of strings:
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
  
    export default Component.extend({
      classNames: ['my-class', 'my-other-class']
    });
    ```
  
    Will result in component instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view my-class my-other-class"></div>
    ```
  
    `class` attribute values can also be set by providing a `classNameBindings`
    property set to an array of properties names for the component. The return value
    of these properties will be added as part of the value for the components's `class`
    attribute. These properties can be computed properties:
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
    import { computed } from '@ember/object';
  
    export default Component.extend({
      classNameBindings: ['propertyA', 'propertyB'],
  
      propertyA: 'from-a',
      propertyB: computed(function() {
        if (someLogic) { return 'from-b'; }
      })
    });
    ```
  
    Will result in component instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view from-a from-b"></div>
    ```
  
    If the value of a class name binding returns a boolean the property name
    itself will be used as the class name if the property is true.
    The class name will not be added if the value is `false` or `undefined`.
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
  
    export default Component.extend({
      classNameBindings: ['hovered'],
  
      hovered: true
    });
    ```
  
    Will result in component instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view hovered"></div>
    ```
  
    When using boolean class name bindings you can supply a string value other
    than the property name for use as the `class` HTML attribute by appending the
    preferred value after a ":" character when defining the binding:
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
  
    export default Component.extend({
      classNameBindings: ['awesome:so-very-cool'],
  
      awesome: true
    });
    ```
  
    Will result in component instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view so-very-cool"></div>
    ```
  
    Boolean value class name bindings whose property names are in a
    camelCase-style format will be converted to a dasherized format:
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
  
    export default Component.extend({
      classNameBindings: ['isUrgent'],
  
      isUrgent: true
    });
    ```
  
    Will result in component instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view is-urgent"></div>
    ```
  
    Class name bindings can also refer to object values that are found by
    traversing a path relative to the component itself:
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
    import EmberObject from '@ember/object';
  
    export default Component.extend({
      classNameBindings: ['messages.empty'],
  
      messages: EmberObject.create({
        empty: true
      })
    });
    ```
  
    Will result in component instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view empty"></div>
    ```
  
    If you want to add a class name for a property which evaluates to true and
    and a different class name if it evaluates to false, you can pass a binding
    like this:
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
  
    export default Component.extend({
      classNameBindings: ['isEnabled:enabled:disabled'],
      isEnabled: true
    });
    ```
  
    Will result in component instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view enabled"></div>
    ```
  
    When isEnabled is `false`, the resulting HTML representation looks like
    this:
  
    ```html
    <div id="ember1" class="ember-view disabled"></div>
    ```
  
    This syntax offers the convenience to add a class if a property is `false`:
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
  
    // Applies no class when isEnabled is true and class 'disabled' when isEnabled is false
    export default Component.extend({
      classNameBindings: ['isEnabled::disabled'],
      isEnabled: true
    });
    ```
  
    Will result in component instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view"></div>
    ```
  
    When the `isEnabled` property on the component is set to `false`, it will result
    in component instances with an HTML representation of:
  
    ```html
    <div id="ember1" class="ember-view disabled"></div>
    ```
  
    Updates to the value of a class name binding will result in automatic
    update of the  HTML `class` attribute in the component's rendered HTML
    representation. If the value becomes `false` or `undefined` the class name
    will be removed.
    Both `classNames` and `classNameBindings` are concatenated properties. See
    [EmberObject](/api/classes/Ember.Object.html) documentation for more
    information about concatenated properties.
  
  
    ## HTML Attributes
  
    The HTML attribute section of a component's tag can be set by providing an
    `attributeBindings` property set to an array of property names on the component.
    The return value of these properties will be used as the value of the component's
    HTML associated attribute:
  
    ```app/components/my-anchor.js
    import Component from '@ember/component';
  
    export default Component.extend({
      tagName: 'a',
      attributeBindings: ['href'],
  
      href: 'http://google.com'
    });
    ```
  
    Will result in component instances with an HTML representation of:
  
    ```html
    <a id="ember1" class="ember-view" href="http://google.com"></a>
    ```
  
    One property can be mapped on to another by placing a ":" between
    the source property and the destination property:
  
    ```app/components/my-anchor.js
    import Component from '@ember/component';
  
    export default Component.extend({
      tagName: 'a',
      attributeBindings: ['url:href'],
  
      url: 'http://google.com'
    });
    ```
  
    Will result in component instances with an HTML representation of:
  
    ```html
    <a id="ember1" class="ember-view" href="http://google.com"></a>
    ```
  
    Namespaced attributes (e.g. `xlink:href`) are supported, but have to be
    mapped, since `:` is not a valid character for properties in Javascript:
  
    ```app/components/my-use.js
    import Component from '@ember/component';
  
    export default Component.extend({
      tagName: 'use',
      attributeBindings: ['xlinkHref:xlink:href'],
  
      xlinkHref: '#triangle'
    });
    ```
  
    Will result in component instances with an HTML representation of:
  
    ```html
    <use xlink:href="#triangle"></use>
    ```
  
    If the return value of an `attributeBindings` monitored property is a boolean
    the attribute will be present or absent depending on the value:
  
    ```app/components/my-text-input.js
    import Component from '@ember/component';
  
    export default Component.extend({
      tagName: 'input',
      attributeBindings: ['disabled'],
  
      disabled: false
    });
    ```
  
    Will result in a component instance with an HTML representation of:
  
    ```html
    <input id="ember1" class="ember-view" />
    ```
  
    `attributeBindings` can refer to computed properties:
  
    ```app/components/my-text-input.js
    import Component from '@ember/component';
    import { computed } from '@ember/object';
  
    export default Component.extend({
      tagName: 'input',
      attributeBindings: ['disabled'],
  
      disabled: computed(function() {
        if (someLogic) {
          return true;
        } else {
          return false;
        }
      })
    });
    ```
  
    To prevent setting an attribute altogether, use `null` or `undefined` as the
    return value of the `attributeBindings` monitored property:
  
    ```app/components/my-text-input.js
    import Component from '@ember/component';
  
    export default Component.extend({
      tagName: 'form',
      attributeBindings: ['novalidate'],
      novalidate: null
    });
    ```
  
    Updates to the property of an attribute binding will result in automatic
    update of the  HTML attribute in the component's rendered HTML representation.
    `attributeBindings` is a concatenated property. See [EmberObject](/api/classes/Ember.Object.html)
    documentation for more information about concatenated properties.
  
  
    ## Layouts
  
    See [Ember.Templates.helpers.yield](/api/classes/Ember.Templates.helpers.html#method_yield)
    for more information.
  
    Layout can be used to wrap content in a component. In addition
    to wrapping content in a Component's template, you can also use
    the public layout API in your Component JavaScript.
  
    ```app/templates/components/person-profile.hbs
      <h1>Person's Title</h1>
      <div class='details'>{{yield}}</div>
    ```
  
    ```app/components/person-profile.js
      import Component from '@ember/component';
      import layout from '../templates/components/person-profile';
  
      export default Component.extend({
        layout
      });
    ```
  
    The above will result in the following HTML output:
  
    ```html
      <h1>Person's Title</h1>
      <div class="details">
        <h2>Chief Basket Weaver</h2>
        <h3>Fisherman Industries</h3>
      </div>
    ```
  
  
    ## Responding to Browser Events
  
    Components can respond to user-initiated events in one of three ways: method
    implementation, through an event manager, and through `{{action}}` helper use
    in their template or layout.
  
  
    ### Method Implementation
  
    Components can respond to user-initiated events by implementing a method that
    matches the event name. A `jQuery.Event` object will be passed as the
    argument to this method.
  
    ```app/components/my-widget.js
    import Component from '@ember/component';
  
    export default Component.extend({
      click(event) {
        // will be called when an instance's
        // rendered element is clicked
      }
    });
    ```
  
  
    ### `{{action}}` Helper
  
    See [Ember.Templates.helpers.action](/api/classes/Ember.Templates.helpers.html#method_action).
  
  
    ### Event Names
  
    All of the event handling approaches described above respond to the same set
    of events. The names of the built-in events are listed below. (The hash of
    built-in events exists in `Ember.EventDispatcher`.) Additional, custom events
    can be registered by using `Ember.Application.customEvents`.
  
    Touch events:
  
    * `touchStart`
    * `touchMove`
    * `touchEnd`
    * `touchCancel`
  
    Keyboard events:
  
    * `keyDown`
    * `keyUp`
    * `keyPress`
  
    Mouse events:
  
    * `mouseDown`
    * `mouseUp`
    * `contextMenu`
    * `click`
    * `doubleClick`
    * `mouseMove`
    * `focusIn`
    * `focusOut`
    * `mouseEnter`
    * `mouseLeave`
  
    Form events:
  
    * `submit`
    * `change`
    * `focusIn`
    * `focusOut`
    * `input`
  
    HTML5 drag and drop events:
  
    * `dragStart`
    * `drag`
    * `dragEnter`
    * `dragLeave`
    * `dragOver`
    * `dragEnd`
    * `drop`
  
    @class Component
    @extends Ember.CoreView
    @uses Ember.TargetActionSupport
    @uses Ember.ClassNamesSupport
    @uses Ember.ActionSupport
    @uses Ember.ViewMixin
    @uses Ember.ViewStateSupport
    @public
  */
  var Component = _emberViews.CoreView.extend(_emberViews.ChildViewsSupport, _emberViews.ViewStateSupport, _emberViews.ClassNamesSupport, _emberRuntime.TargetActionSupport, _emberViews.ActionSupport, _emberViews.ViewMixin, (_CoreView$extend = {
    isComponent: true,

    init: function () {
      var _this = this;

      this._super.apply(this, arguments);
      this[IS_DISPATCHING_ATTRS] = false;
      this[DIRTY_TAG] = new _reference.DirtyableTag();
      this[ROOT_REF] = new _references.RootReference(this);
      this[BOUNDS] = null;

      // If a `defaultLayout` was specified move it to the `layout` prop.
      // `layout` is no longer a CP, so this just ensures that the `defaultLayout`
      // logic is supported with a deprecation
      if (this.defaultLayout && !this.layout) {
        (true && !(false) && (0, _emberDebug.deprecate)('Specifying `defaultLayout` to ' + this + ' is deprecated. Please use `layout` instead.', false, {
          id: 'ember-views.component.defaultLayout',
          until: '3.0.0',
          url: 'https://emberjs.com/deprecations/v2.x/#toc_ember-component-defaultlayout'
        }));


        this.layout = this.defaultLayout;
      }

      // If in a tagless component, assert that no event handlers are defined
      (true && !(this.tagName !== '' || !this.renderer._destinedForDOM || !function () {
        var eventDispatcher = (0, _emberUtils.getOwner)(_this).lookup('event_dispatcher:main');
        var events = eventDispatcher && eventDispatcher._finalEvents || {};

        for (var key in events) {
          var methodName = events[key];

          if (typeof _this[methodName] === 'function') {
            return true; // indicate that the assertion should be triggered
          }
        }
      }()) && (0, _emberDebug.assert)('You can not define a function that handles DOM events in the `' + this + '` tagless component since it doesn\'t have any DOM element.', this.tagName !== '' || !this.renderer._destinedForDOM || !function () {
        var eventDispatcher = (0, _emberUtils.getOwner)(_this).lookup('event_dispatcher:main');var events = eventDispatcher && eventDispatcher._finalEvents || {};for (var key in events) {
          var methodName = events[key];if (typeof _this[methodName] === 'function') {
            return true;
          }
        }
      }()));
      (true && !(!(this.tagName && this.tagName.isDescriptor)) && (0, _emberDebug.assert)('You cannot use a computed property for the component\'s `tagName` (' + this + ').', !(this.tagName && this.tagName.isDescriptor)));
    },
    rerender: function () {
      this[DIRTY_TAG].dirty();
      this._super();
    },
    __defineNonEnumerable: function (property) {
      this[property.name] = property.descriptor.value;
    }
  }, _CoreView$extend[_emberMetal.PROPERTY_DID_CHANGE] = function (key) {
    if (this[IS_DISPATCHING_ATTRS]) {
      return;
    }

    var args = void 0,
        reference = void 0;

    if ((args = this[ARGS]) && (reference = args[key])) {
      if (reference[_references.UPDATE]) {
        reference[_references.UPDATE]((0, _emberMetal.get)(this, key));
      }
    }
  }, _CoreView$extend.getAttr = function (key) {
    // TODO Intimate API should be deprecated
    return this.get(key);
  }, _CoreView$extend.readDOMAttr = function (name) {
    var element = (0, _emberViews.getViewElement)(this);
    return (0, _runtime.readDOMAttr)(element, name);
  }, _CoreView$extend));

  Component[_emberUtils.NAME_KEY] = 'Ember.Component';

  Component.reopenClass({
    isComponentFactory: true,
    positionalParams: []
  });

  exports.default = Component;
});
enifed('ember-glimmer/components/checkbox', ['exports', 'ember-metal', 'ember-glimmer/component', 'ember-glimmer/templates/empty'], function (exports, _emberMetal, _component, _empty) {
  'use strict';

  exports.default = _component.default.extend({
    layout: _empty.default,
    classNames: ['ember-checkbox'],

    tagName: 'input',

    attributeBindings: ['type', 'checked', 'indeterminate', 'disabled', 'tabindex', 'name', 'autofocus', 'required', 'form'],

    type: 'checkbox',
    disabled: false,
    indeterminate: false,

    didInsertElement: function () {
      this._super.apply(this, arguments);
      (0, _emberMetal.get)(this, 'element').indeterminate = !!(0, _emberMetal.get)(this, 'indeterminate');
    },
    change: function () {
      (0, _emberMetal.set)(this, 'checked', this.$().prop('checked'));
    }
  });
});
enifed('ember-glimmer/components/link-to', ['exports', 'ember-console', 'ember-debug', 'ember-metal', 'ember-runtime', 'ember-views', 'ember-glimmer/templates/link-to', 'ember-glimmer/component'], function (exports, _emberConsole, _emberDebug, _emberMetal, _emberRuntime, _emberViews, _linkTo, _component) {
  'use strict';

  /**
    @module @ember/routing
  */
  /**
    `LinkComponent` renders an element whose `click` event triggers a
    transition of the application's instance of `Router` to
    a supplied route by name.
  
    `LinkComponent` components are invoked with {{#link-to}}. Properties
    of this class can be overridden with `reopen` to customize application-wide
    behavior.
  
    @class LinkComponent
    @extends Component
    @see {Ember.Templates.helpers.link-to}
    @public
  **/
  var LinkComponent = _component.default.extend({
    layout: _linkTo.default,

    tagName: 'a',

    /**
      @deprecated Use current-when instead.
      @property currentWhen
      @private
    */
    currentWhen: (0, _emberRuntime.deprecatingAlias)('current-when', { id: 'ember-routing-view.deprecated-current-when', until: '3.0.0' }),

    /**
      Used to determine when this `LinkComponent` is active.
       @property currentWhen
      @public
    */
    'current-when': null,

    /**
      Sets the `title` attribute of the `LinkComponent`'s HTML element.
       @property title
      @default null
      @public
    **/
    title: null,

    /**
      Sets the `rel` attribute of the `LinkComponent`'s HTML element.
       @property rel
      @default null
      @public
    **/
    rel: null,

    /**
      Sets the `tabindex` attribute of the `LinkComponent`'s HTML element.
       @property tabindex
      @default null
      @public
    **/
    tabindex: null,

    /**
      Sets the `target` attribute of the `LinkComponent`'s HTML element.
       @since 1.8.0
      @property target
      @default null
      @public
    **/
    target: null,

    /**
      The CSS class to apply to `LinkComponent`'s element when its `active`
      property is `true`.
       @property activeClass
      @type String
      @default active
      @public
    **/
    activeClass: 'active',

    /**
      The CSS class to apply to `LinkComponent`'s element when its `loading`
      property is `true`.
       @property loadingClass
      @type String
      @default loading
      @private
    **/
    loadingClass: 'loading',

    /**
      The CSS class to apply to a `LinkComponent`'s element when its `disabled`
      property is `true`.
       @property disabledClass
      @type String
      @default disabled
      @private
    **/
    disabledClass: 'disabled',
    _isDisabled: false,

    /**
      Determines whether the `LinkComponent` will trigger routing via
      the `replaceWith` routing strategy.
       @property replace
      @type Boolean
      @default false
      @public
    **/
    replace: false,

    /**
      By default the `{{link-to}}` component will bind to the `href` and
      `title` attributes. It's discouraged that you override these defaults,
      however you can push onto the array if needed.
       @property attributeBindings
      @type Array | String
      @default ['title', 'rel', 'tabindex', 'target']
      @public
    */
    attributeBindings: ['href', 'title', 'rel', 'tabindex', 'target'],

    /**
      By default the `{{link-to}}` component will bind to the `active`, `loading`,
      and `disabled` classes. It is discouraged to override these directly.
       @property classNameBindings
      @type Array
      @default ['active', 'loading', 'disabled', 'ember-transitioning-in', 'ember-transitioning-out']
      @public
    */
    classNameBindings: ['active', 'loading', 'disabled', 'transitioningIn', 'transitioningOut'],

    /**
      By default the `{{link-to}}` component responds to the `click` event. You
      can override this globally by setting this property to your custom
      event name.
       This is particularly useful on mobile when one wants to avoid the 300ms
      click delay using some sort of custom `tap` event.
       @property eventName
      @type String
      @default click
      @private
    */
    eventName: 'click',

    init: function () {
      this._super.apply(this, arguments);

      // Map desired event name to invoke function
      var eventName = (0, _emberMetal.get)(this, 'eventName');
      this.on(eventName, this, this._invoke);
    },


    _routing: _emberRuntime.inject.service('-routing'),

    /**
      Accessed as a classname binding to apply the `LinkComponent`'s `disabledClass`
      CSS `class` to the element when the link is disabled.
       When `true` interactions with the element will not trigger route changes.
      @property disabled
      @private
    */
    disabled: (0, _emberMetal.computed)({
      get: function (key, value) {
        return false;
      },
      set: function (key, value) {
        if (value !== undefined) {
          this.set('_isDisabled', value);
        }

        return value ? (0, _emberMetal.get)(this, 'disabledClass') : false;
      }
    }),

    _isActive: function (routerState) {
      if ((0, _emberMetal.get)(this, 'loading')) {
        return false;
      }

      var routing = (0, _emberMetal.get)(this, '_routing');
      var models = (0, _emberMetal.get)(this, 'models');
      var resolvedQueryParams = (0, _emberMetal.get)(this, 'resolvedQueryParams');
      var currentWhen = (0, _emberMetal.get)(this, 'current-when');

      if (typeof currentWhen === 'boolean') {
        return currentWhen ? (0, _emberMetal.get)(this, 'activeClass') : false;
      }

      var isCurrentWhenSpecified = !!currentWhen;
      currentWhen = currentWhen || (0, _emberMetal.get)(this, 'qualifiedRouteName');
      currentWhen = currentWhen.split(' ');

      for (var i = 0; i < currentWhen.length; i++) {
        if (routing.isActiveForRoute(models, resolvedQueryParams, currentWhen[i], routerState, isCurrentWhenSpecified)) {
          return true;
        }
      }

      return false;
    },


    /**
      Accessed as a classname binding to apply the `LinkComponent`'s `activeClass`
      CSS `class` to the element when the link is active.
       A `LinkComponent` is considered active when its `currentWhen` property is `true`
      or the application's current route is the route the `LinkComponent` would trigger
      transitions into.
       The `currentWhen` property can match against multiple routes by separating
      route names using the ` ` (space) character.
       @property active
      @private
    */
    active: (0, _emberMetal.computed)('attrs.params', '_active', function computeLinkToComponentActiveClass() {
      var currentState = (0, _emberMetal.get)(this, '_routing.currentState');
      if (!currentState) {
        return false;
      }

      return this.get('_active') ? (0, _emberMetal.get)(this, 'activeClass') : false;
    }),

    _active: (0, _emberMetal.computed)('_routing.currentState', function computeLinkToComponentActive() {
      var currentState = (0, _emberMetal.get)(this, '_routing.currentState');
      if (!currentState) {
        return false;
      }
      return this._isActive(currentState);
    }),

    willBeActive: (0, _emberMetal.computed)('_routing.targetState', function computeLinkToComponentWillBeActive() {
      var routing = (0, _emberMetal.get)(this, '_routing');
      var targetState = (0, _emberMetal.get)(routing, 'targetState');
      if ((0, _emberMetal.get)(routing, 'currentState') === targetState) {
        return;
      }

      return this._isActive(targetState);
    }),

    transitioningIn: (0, _emberMetal.computed)('active', 'willBeActive', function computeLinkToComponentTransitioningIn() {
      if ((0, _emberMetal.get)(this, 'willBeActive') === true && !(0, _emberMetal.get)(this, '_active')) {
        return 'ember-transitioning-in';
      } else {
        return false;
      }
    }),

    transitioningOut: (0, _emberMetal.computed)('active', 'willBeActive', function computeLinkToComponentTransitioningOut() {
      if ((0, _emberMetal.get)(this, 'willBeActive') === false && (0, _emberMetal.get)(this, '_active')) {
        return 'ember-transitioning-out';
      } else {
        return false;
      }
    }),

    _invoke: function (event) {
      if (!(0, _emberViews.isSimpleClick)(event)) {
        return true;
      }

      var preventDefault = (0, _emberMetal.get)(this, 'preventDefault');
      var targetAttribute = (0, _emberMetal.get)(this, 'target');

      if (preventDefault !== false) {
        if (!targetAttribute || targetAttribute === '_self') {
          event.preventDefault();
        }
      }

      if ((0, _emberMetal.get)(this, 'bubbles') === false) {
        event.stopPropagation();
      }

      if ((0, _emberMetal.get)(this, '_isDisabled')) {
        return false;
      }

      if ((0, _emberMetal.get)(this, 'loading')) {
        _emberConsole.default.warn('This link-to is in an inactive loading state because at least one of its parameters presently has a null/undefined value, or the provided route name is invalid.');
        return false;
      }

      if (targetAttribute && targetAttribute !== '_self') {
        return false;
      }

      var qualifiedRouteName = (0, _emberMetal.get)(this, 'qualifiedRouteName');
      var models = (0, _emberMetal.get)(this, 'models');
      var queryParams = (0, _emberMetal.get)(this, 'queryParams.values');
      var shouldReplace = (0, _emberMetal.get)(this, 'replace');

      var payload = {
        queryParams: queryParams,
        routeName: qualifiedRouteName
      };

      (0, _emberMetal.flaggedInstrument)('interaction.link-to', payload, this._generateTransition(payload, qualifiedRouteName, models, queryParams, shouldReplace));
    },
    _generateTransition: function (payload, qualifiedRouteName, models, queryParams, shouldReplace) {
      var routing = (0, _emberMetal.get)(this, '_routing');
      return function () {
        payload.transition = routing.transitionTo(qualifiedRouteName, models, queryParams, shouldReplace);
      };
    },


    queryParams: null,

    qualifiedRouteName: (0, _emberMetal.computed)('targetRouteName', '_routing.currentState', function computeLinkToComponentQualifiedRouteName() {
      var params = (0, _emberMetal.get)(this, 'params');
      var paramsLength = params.length;
      var lastParam = params[paramsLength - 1];
      if (lastParam && lastParam.isQueryParams) {
        paramsLength--;
      }
      var onlyQueryParamsSupplied = this[_component.HAS_BLOCK] ? paramsLength === 0 : paramsLength === 1;
      if (onlyQueryParamsSupplied) {
        return (0, _emberMetal.get)(this, '_routing.currentRouteName');
      }
      return (0, _emberMetal.get)(this, 'targetRouteName');
    }),

    resolvedQueryParams: (0, _emberMetal.computed)('queryParams', function computeLinkToComponentResolvedQueryParams() {
      var resolvedQueryParams = {};
      var queryParams = (0, _emberMetal.get)(this, 'queryParams');

      if (!queryParams) {
        return resolvedQueryParams;
      }

      var values = queryParams.values;
      for (var key in values) {
        if (!values.hasOwnProperty(key)) {
          continue;
        }
        resolvedQueryParams[key] = values[key];
      }

      return resolvedQueryParams;
    }),

    /**
      Sets the element's `href` attribute to the url for
      the `LinkComponent`'s targeted route.
       If the `LinkComponent`'s `tagName` is changed to a value other
      than `a`, this property will be ignored.
       @property href
      @private
    */
    href: (0, _emberMetal.computed)('models', 'qualifiedRouteName', function computeLinkToComponentHref() {
      if ((0, _emberMetal.get)(this, 'tagName') !== 'a') {
        return;
      }

      var qualifiedRouteName = (0, _emberMetal.get)(this, 'qualifiedRouteName');
      var models = (0, _emberMetal.get)(this, 'models');

      if ((0, _emberMetal.get)(this, 'loading')) {
        return (0, _emberMetal.get)(this, 'loadingHref');
      }

      var routing = (0, _emberMetal.get)(this, '_routing');
      var queryParams = (0, _emberMetal.get)(this, 'queryParams.values');

      if (true) {
        /*
         * Unfortunately, to get decent error messages, we need to do this.
         * In some future state we should be able to use a "feature flag"
         * which allows us to strip this without needing to call it twice.
         *
         * if (isDebugBuild()) {
         *   // Do the useful debug thing, probably including try/catch.
         * } else {
         *   // Do the performant thing.
         * }
         */
        try {
          routing.generateURL(qualifiedRouteName, models, queryParams);
        } catch (e) {
          (true && !(false) && (0, _emberDebug.assert)('You attempted to define a `{{link-to "' + qualifiedRouteName + '"}}` but did not pass the parameters required for generating its dynamic segments. ' + e.message));
        }
      }

      return routing.generateURL(qualifiedRouteName, models, queryParams);
    }),

    loading: (0, _emberMetal.computed)('_modelsAreLoaded', 'qualifiedRouteName', function computeLinkToComponentLoading() {
      var qualifiedRouteName = (0, _emberMetal.get)(this, 'qualifiedRouteName');
      var modelsAreLoaded = (0, _emberMetal.get)(this, '_modelsAreLoaded');

      if (!modelsAreLoaded || qualifiedRouteName == null) {
        return (0, _emberMetal.get)(this, 'loadingClass');
      }
    }),

    _modelsAreLoaded: (0, _emberMetal.computed)('models', function computeLinkToComponentModelsAreLoaded() {
      var models = (0, _emberMetal.get)(this, 'models');
      for (var i = 0; i < models.length; i++) {
        if (models[i] == null) {
          return false;
        }
      }

      return true;
    }),

    _getModels: function (params) {
      var modelCount = params.length - 1;
      var models = new Array(modelCount);

      for (var i = 0; i < modelCount; i++) {
        var value = params[i + 1];

        while (_emberRuntime.ControllerMixin.detect(value)) {
          (true && !(false) && (0, _emberDebug.deprecate)('Providing `{{link-to}}` with a param that is wrapped in a controller is deprecated. ' + (this.parentView ? 'Please update `' + this.parentView + '` to use `{{link-to "post" someController.model}}` instead.' : ''), false, { id: 'ember-routing-views.controller-wrapped-param', until: '3.0.0' }));

          value = value.get('model');
        }

        models[i] = value;
      }

      return models;
    },


    /**
      The default href value to use while a link-to is loading.
      Only applies when tagName is 'a'
       @property loadingHref
      @type String
      @default #
      @private
    */
    loadingHref: '#',

    didReceiveAttrs: function () {
      var queryParams = void 0;

      var params = (0, _emberMetal.get)(this, 'params');

      if (params) {
        // Do not mutate params in place
        params = params.slice();
      }

      (true && !(params && params.length) && (0, _emberDebug.assert)('You must provide one or more parameters to the link-to component.', params && params.length));


      var disabledWhen = (0, _emberMetal.get)(this, 'disabledWhen');
      if (disabledWhen !== undefined) {
        this.set('disabled', disabledWhen);
      }

      // Process the positional arguments, in order.
      // 1. Inline link title comes first, if present.
      if (!this[_component.HAS_BLOCK]) {
        this.set('linkTitle', params.shift());
      }

      // 2. `targetRouteName` is now always at index 0.
      this.set('targetRouteName', params[0]);

      // 3. The last argument (if still remaining) is the `queryParams` object.
      var lastParam = params[params.length - 1];

      if (lastParam && lastParam.isQueryParams) {
        queryParams = params.pop();
      } else {
        queryParams = { values: {} };
      }
      this.set('queryParams', queryParams);

      // 4. Any remaining indices (excepting `targetRouteName` at 0) are `models`.
      if (params.length > 1) {
        this.set('models', this._getModels(params));
      } else {
        this.set('models', []);
      }
    }
  }); /**
      @module ember
      */

  /**
    The `{{link-to}}` component renders a link to the supplied
    `routeName` passing an optionally supplied model to the
    route as its `model` context of the route. The block
    for `{{link-to}}` becomes the innerHTML of the rendered
    element:
  
    ```handlebars
    {{#link-to 'photoGallery'}}
      Great Hamster Photos
    {{/link-to}}
    ```
  
    You can also use an inline form of `{{link-to}}` component by
    passing the link text as the first argument
    to the component:
  
    ```handlebars
    {{link-to 'Great Hamster Photos' 'photoGallery'}}
    ```
  
    Both will result in:
  
    ```html
    <a href="/hamster-photos">
      Great Hamster Photos
    </a>
    ```
  
    ### Supplying a tagName
    By default `{{link-to}}` renders an `<a>` element. This can
    be overridden for a single use of `{{link-to}}` by supplying
    a `tagName` option:
  
    ```handlebars
    {{#link-to 'photoGallery' tagName="li"}}
      Great Hamster Photos
    {{/link-to}}
    ```
  
    ```html
    <li>
      Great Hamster Photos
    </li>
    ```
  
    To override this option for your entire application, see
    "Overriding Application-wide Defaults".
  
    ### Disabling the `link-to` component
    By default `{{link-to}}` is enabled.
    any passed value to the `disabled` component property will disable
    the `link-to` component.
  
    static use: the `disabled` option:
  
    ```handlebars
    {{#link-to 'photoGallery' disabled=true}}
      Great Hamster Photos
    {{/link-to}}
    ```
  
    dynamic use: the `disabledWhen` option:
  
    ```handlebars
    {{#link-to 'photoGallery' disabledWhen=controller.someProperty}}
      Great Hamster Photos
    {{/link-to}}
    ```
  
    any passed value to `disabled` will disable it except `undefined`.
    to ensure that only `true` disable the `link-to` component you can
    override the global behavior of `LinkComponent`.
  
    ```javascript
    import LinkComponent from '@ember/routing/link-component';
    import { computed } from '@ember/object';
  
    LinkComponent.reopen({
      disabled: computed(function(key, value) {
        if (value !== undefined) {
          this.set('_isDisabled', value === true);
        }
        return value === true ? get(this, 'disabledClass') : false;
      })
    });
    ```
  
    see "Overriding Application-wide Defaults" for more.
  
    ### Handling `href`
    `{{link-to}}` will use your application's Router to
    fill the element's `href` property with a url that
    matches the path to the supplied `routeName` for your
    router's configured `Location` scheme, which defaults
    to HashLocation.
  
    ### Handling current route
    `{{link-to}}` will apply a CSS class name of 'active'
    when the application's current route matches
    the supplied routeName. For example, if the application's
    current route is 'photoGallery.recent' the following
    use of `{{link-to}}`:
  
    ```handlebars
    {{#link-to 'photoGallery.recent'}}
      Great Hamster Photos
    {{/link-to}}
    ```
  
    will result in
  
    ```html
    <a href="/hamster-photos/this-week" class="active">
      Great Hamster Photos
    </a>
    ```
  
    The CSS class name used for active classes can be customized
    for a single use of `{{link-to}}` by passing an `activeClass`
    option:
  
    ```handlebars
    {{#link-to 'photoGallery.recent' activeClass="current-url"}}
      Great Hamster Photos
    {{/link-to}}
    ```
  
    ```html
    <a href="/hamster-photos/this-week" class="current-url">
      Great Hamster Photos
    </a>
    ```
  
    To override this option for your entire application, see
    "Overriding Application-wide Defaults".
  
    ### Keeping a link active for other routes
  
    If you need a link to be 'active' even when it doesn't match
    the current route, you can use the `current-when` argument.
  
    ```handlebars
    {{#link-to 'photoGallery' current-when='photos'}}
      Photo Gallery
    {{/link-to}}
    ```
  
    This may be helpful for keeping links active for:
  
    * non-nested routes that are logically related
    * some secondary menu approaches
    * 'top navigation' with 'sub navigation' scenarios
  
    A link will be active if `current-when` is `true` or the current
    route is the route this link would transition to.
  
    To match multiple routes 'space-separate' the routes:
  
    ```handlebars
    {{#link-to 'gallery' current-when='photos drawings paintings'}}
      Art Gallery
    {{/link-to}}
    ```
  
    ### Supplying a model
    An optional model argument can be used for routes whose
    paths contain dynamic segments. This argument will become
    the model context of the linked route:
  
    ```javascript
    Router.map(function() {
      this.route("photoGallery", {path: "hamster-photos/:photo_id"});
    });
    ```
  
    ```handlebars
    {{#link-to 'photoGallery' aPhoto}}
      {{aPhoto.title}}
    {{/link-to}}
    ```
  
    ```html
    <a href="/hamster-photos/42">
      Tomster
    </a>
    ```
  
    ### Supplying multiple models
    For deep-linking to route paths that contain multiple
    dynamic segments, multiple model arguments can be used.
    As the router transitions through the route path, each
    supplied model argument will become the context for the
    route with the dynamic segments:
  
    ```javascript
    Router.map(function() {
      this.route("photoGallery", { path: "hamster-photos/:photo_id" }, function() {
        this.route("comment", {path: "comments/:comment_id"});
      });
    });
    ```
    This argument will become the model context of the linked route:
  
    ```handlebars
    {{#link-to 'photoGallery.comment' aPhoto comment}}
      {{comment.body}}
    {{/link-to}}
    ```
  
    ```html
    <a href="/hamster-photos/42/comments/718">
      A+++ would snuggle again.
    </a>
    ```
  
    ### Supplying an explicit dynamic segment value
    If you don't have a model object available to pass to `{{link-to}}`,
    an optional string or integer argument can be passed for routes whose
    paths contain dynamic segments. This argument will become the value
    of the dynamic segment:
  
    ```javascript
    Router.map(function() {
      this.route("photoGallery", { path: "hamster-photos/:photo_id" });
    });
    ```
  
    ```handlebars
    {{#link-to 'photoGallery' aPhotoId}}
      {{aPhoto.title}}
    {{/link-to}}
    ```
  
    ```html
    <a href="/hamster-photos/42">
      Tomster
    </a>
    ```
  
    When transitioning into the linked route, the `model` hook will
    be triggered with parameters including this passed identifier.
  
    ### Allowing Default Action
  
    By default the `{{link-to}}` component prevents the default browser action
    by calling `preventDefault()` as this sort of action bubbling is normally
    handled internally and we do not want to take the browser to a new URL (for
    example).
  
    If you need to override this behavior specify `preventDefault=false` in
    your template:
  
    ```handlebars
    {{#link-to 'photoGallery' aPhotoId preventDefault=false}}
      {{aPhotoId.title}}
    {{/link-to}}
    ```
  
    ### Overriding attributes
    You can override any given property of the `LinkComponent`
    that is generated by the `{{link-to}}` component by passing
    key/value pairs, like so:
  
    ```handlebars
    {{#link-to  aPhoto tagName='li' title='Following this link will change your life' classNames='pic sweet'}}
      Uh-mazing!
    {{/link-to}}
    ```
  
    See [LinkComponent](/api/classes/Ember.LinkComponent.html) for a
    complete list of overrideable properties. Be sure to also
    check out inherited properties of `LinkComponent`.
  
    ### Overriding Application-wide Defaults
    ``{{link-to}}`` creates an instance of `LinkComponent`
    for rendering. To override options for your entire
    application, reopen `LinkComponent` and supply the
    desired values:
  
    ``` javascript
    import LinkComponent from '@ember/routing/link-component';
  
    LinkComponent.reopen({
      activeClass: "is-active",
      tagName: 'li'
    })
    ```
  
    It is also possible to override the default event in
    this manner:
  
    ``` javascript
    import LinkCompoennt from '@ember/routing/link-component';
  
    LinkComponent.reopen({
      eventName: 'customEventName'
    });
    ```
    @method link-to
    @for Ember.Templates.helpers
    @param {String} routeName
    @param {Object} [context]*
    @param [options] {Object} Handlebars key/value pairs of options, you can override any property of Ember.LinkComponent
    @return {String} HTML string
    @see {LinkComponent}
    @public
  */

  LinkComponent.toString = function () {
    return 'LinkComponent';
  };

  LinkComponent.reopenClass({
    positionalParams: 'params'
  });

  exports.default = LinkComponent;
});
enifed('ember-glimmer/components/text_area', ['exports', 'ember-glimmer/component', 'ember-views', 'ember-glimmer/templates/empty'], function (exports, _component, _emberViews, _empty) {
  'use strict';

  exports.default = _component.default.extend(_emberViews.TextSupport, {
    classNames: ['ember-text-area'],

    layout: _empty.default,

    tagName: 'textarea',
    attributeBindings: ['rows', 'cols', 'name', 'selectionEnd', 'selectionStart', 'wrap', 'lang', 'dir', 'value'],
    rows: null,
    cols: null
  });
});
enifed('ember-glimmer/components/text_field', ['exports', 'ember-metal', 'ember-environment', 'ember-glimmer/component', 'ember-glimmer/templates/empty', 'ember-views'], function (exports, _emberMetal, _emberEnvironment, _component, _empty, _emberViews) {
  'use strict';

  var inputTypes = Object.create(null); /**
                                        @module @ember/component
                                        */

  function canSetTypeOfInput(type) {
    if (type in inputTypes) {
      return inputTypes[type];
    }

    // if running in outside of a browser always return the
    // original type
    if (!_emberEnvironment.environment.hasDOM) {
      inputTypes[type] = type;

      return type;
    }

    var inputTypeTestElement = document.createElement('input');

    try {
      inputTypeTestElement.type = type;
    } catch (e) {
      // ignored
    }

    return inputTypes[type] = inputTypeTestElement.type === type;
  }

  /**
  
    The internal class used to create text inputs when the `{{input}}`
    helper is used with `type` of `text`.
  
    See [Ember.Templates.helpers.input](/api/classes/Ember.Templates.helpers.html#method_input)  for usage details.
  
    ## Layout and LayoutName properties
  
    Because HTML `input` elements are self closing `layout` and `layoutName`
    properties will not be applied.
  
    @class TextField
    @extends Component
    @uses Ember.TextSupport
    @public
  */
  exports.default = _component.default.extend(_emberViews.TextSupport, {
    layout: _empty.default,
    classNames: ['ember-text-field'],
    tagName: 'input',
    attributeBindings: ['accept', 'autocomplete', 'autosave', 'dir', 'formaction', 'formenctype', 'formmethod', 'formnovalidate', 'formtarget', 'height', 'inputmode', 'lang', 'list', 'type', // needs to be before min and max. See #15675
    'max', 'min', 'multiple', 'name', 'pattern', 'size', 'step', 'value', 'width'],

    /**
      The `value` attribute of the input element. As the user inputs text, this
      property is updated live.
       @property value
      @type String
      @default ""
      @public
    */
    value: '',

    /**
      The `type` attribute of the input element.
       @property type
      @type String
      @default "text"
      @public
    */
    type: (0, _emberMetal.computed)({
      get: function () {
        return 'text';
      },
      set: function (key, value) {
        var type = 'text';

        if (canSetTypeOfInput(value)) {
          type = value;
        }

        return type;
      }
    }),

    /**
      The `size` of the text field in characters.
       @property size
      @type String
      @default null
      @public
    */
    size: null,

    /**
      The `pattern` attribute of input element.
       @property pattern
      @type String
      @default null
      @public
    */
    pattern: null,

    /**
      The `min` attribute of input element used with `type="number"` or `type="range"`.
       @property min
      @type String
      @default null
      @since 1.4.0
      @public
    */
    min: null,

    /**
      The `max` attribute of input element used with `type="number"` or `type="range"`.
       @property max
      @type String
      @default null
      @since 1.4.0
      @public
    */
    max: null
  });
});
enifed('ember-glimmer/dom', ['exports', '@glimmer/runtime', '@glimmer/node'], function (exports, _runtime, _node) {
  'use strict';

  Object.defineProperty(exports, 'DOMChanges', {
    enumerable: true,
    get: function () {
      return _runtime.DOMChanges;
    }
  });
  Object.defineProperty(exports, 'DOMTreeConstruction', {
    enumerable: true,
    get: function () {
      return _runtime.DOMTreeConstruction;
    }
  });
  Object.defineProperty(exports, 'NodeDOMTreeConstruction', {
    enumerable: true,
    get: function () {
      return _node.NodeDOMTreeConstruction;
    }
  });
});
enifed('ember-glimmer/environment', ['exports', 'ember-babel', 'ember-utils', 'ember-metal', 'ember-debug', 'ember/features', 'ember-views', '@glimmer/runtime', 'ember-glimmer/component-managers/curly', 'ember-glimmer/syntax', 'ember-glimmer/utils/iterable', 'ember-glimmer/utils/references', 'ember-glimmer/utils/debug-stack', 'ember-glimmer/helpers/if-unless', 'ember-glimmer/helpers/action', 'ember-glimmer/helpers/component', 'ember-glimmer/helpers/concat', 'ember-glimmer/helpers/get', 'ember-glimmer/helpers/hash', 'ember-glimmer/helpers/loc', 'ember-glimmer/helpers/log', 'ember-glimmer/helpers/mut', 'ember-glimmer/helpers/readonly', 'ember-glimmer/helpers/unbound', 'ember-glimmer/helpers/-class', 'ember-glimmer/helpers/-input-type', 'ember-glimmer/helpers/query-param', 'ember-glimmer/helpers/each-in', 'ember-glimmer/helpers/-normalize-class', 'ember-glimmer/helpers/-html-safe', 'ember-glimmer/protocol-for-url', 'ember-glimmer/modifiers/action'], function (exports, _emberBabel, _emberUtils, _emberMetal, _emberDebug, _features, _emberViews, _runtime, _curly, _syntax, _iterable, _references, _debugStack, _ifUnless, _action, _component, _concat, _get, _hash, _loc, _log, _mut, _readonly, _unbound, _class, _inputType, _queryParam, _eachIn, _normalizeClass, _htmlSafe, _protocolForUrl, _action2) {
  'use strict';

  function instrumentationPayload(name) {
    return { object: 'component:' + name };
  }

  var Environment = function (_GlimmerEnvironment) {
    (0, _emberBabel.inherits)(Environment, _GlimmerEnvironment);

    Environment.create = function create(options) {
      return new this(options);
    };

    function Environment(_ref) {
      var owner = _ref[_emberUtils.OWNER];
      (0, _emberBabel.classCallCheck)(this, Environment);

      var _this = (0, _emberBabel.possibleConstructorReturn)(this, _GlimmerEnvironment.apply(this, arguments));

      _this.owner = owner;
      _this.isInteractive = owner.lookup('-environment:main').isInteractive;

      // can be removed once https://github.com/tildeio/glimmer/pull/305 lands
      _this.destroyedComponents = [];

      (0, _protocolForUrl.default)(_this);

      _this._definitionCache = new _emberMetal.Cache(2000, function (_ref2) {
        var name = _ref2.name,
            source = _ref2.source,
            owner = _ref2.owner;

        var _lookupComponent = (0, _emberViews.lookupComponent)(owner, name, { source: source }),
            componentFactory = _lookupComponent.component,
            layout = _lookupComponent.layout;

        var customManager = undefined;

        if (componentFactory || layout) {
          if (_features.GLIMMER_CUSTOM_COMPONENT_MANAGER) {
            var managerId = layout && layout.meta.managerId;

            if (managerId) {
              customManager = owner.factoryFor('component-manager:' + managerId).class;
            }
          }
          return new _curly.CurlyComponentDefinition(name, componentFactory, layout, undefined, customManager);
        }
      }, function (_ref3) {
        var name = _ref3.name,
            source = _ref3.source,
            owner = _ref3.owner;

        var expandedName = source && _this._resolveLocalLookupName(name, source, owner) || name;

        var ownerGuid = (0, _emberUtils.guidFor)(owner);

        return ownerGuid + '|' + expandedName;
      });

      _this._templateCache = new _emberMetal.Cache(1000, function (_ref4) {
        var Template = _ref4.Template,
            owner = _ref4.owner;

        if (Template.create) {
          var _Template$create;

          // we received a factory
          return Template.create((_Template$create = { env: _this }, _Template$create[_emberUtils.OWNER] = owner, _Template$create));
        } else {
          // we were provided an instance already
          return Template;
        }
      }, function (_ref5) {
        var Template = _ref5.Template,
            owner = _ref5.owner;
        return (0, _emberUtils.guidFor)(owner) + '|' + Template.id;
      });

      _this._compilerCache = new _emberMetal.Cache(10, function (Compiler) {
        return new _emberMetal.Cache(2000, function (template) {
          var compilable = new Compiler(template);
          return (0, _runtime.compileLayout)(compilable, _this);
        }, function (template) {
          var owner = template.meta.owner;
          return (0, _emberUtils.guidFor)(owner) + '|' + template.id;
        });
      }, function (Compiler) {
        return Compiler.id;
      });

      _this.builtInModifiers = {
        action: new _action2.default()
      };

      _this.builtInHelpers = {
        if: _ifUnless.inlineIf,
        action: _action.default,
        concat: _concat.default,
        get: _get.default,
        hash: _hash.default,
        loc: _loc.default,
        log: _log.default,
        mut: _mut.default,
        'query-params': _queryParam.default,
        readonly: _readonly.default,
        unbound: _unbound.default,
        unless: _ifUnless.inlineUnless,
        '-class': _class.default,
        '-each-in': _eachIn.default,
        '-input-type': _inputType.default,
        '-normalize-class': _normalizeClass.default,
        '-html-safe': _htmlSafe.default,
        '-get-dynamic-var': _runtime.getDynamicVar
      };

      if (true) {
        _this.debugStack = new _debugStack.default();
      }
      return _this;
    }

    Environment.prototype._resolveLocalLookupName = function _resolveLocalLookupName(name, source, owner) {
      return _features.EMBER_MODULE_UNIFICATION ? source + ':' + name : owner._resolveLocalLookupName(name, source);
    };

    Environment.prototype.macros = function macros() {
      var macros = _GlimmerEnvironment.prototype.macros.call(this);
      (0, _syntax.populateMacros)(macros.blocks, macros.inlines);
      return macros;
    };

    Environment.prototype.hasComponentDefinition = function hasComponentDefinition() {
      return false;
    };

    Environment.prototype.getComponentDefinition = function getComponentDefinition(name, _ref6) {
      var owner = _ref6.owner,
          moduleName = _ref6.moduleName;

      var finalizer = (0, _emberMetal._instrumentStart)('render.getComponentDefinition', instrumentationPayload, name);
      var source = moduleName && 'template:' + moduleName;
      var definition = this._definitionCache.get({ name: name, source: source, owner: owner });
      finalizer();
      return definition;
    };

    Environment.prototype.getTemplate = function getTemplate(Template, owner) {
      return this._templateCache.get({ Template: Template, owner: owner });
    };

    Environment.prototype.getCompiledBlock = function getCompiledBlock(Compiler, template) {
      var compilerCache = this._compilerCache.get(Compiler);
      return compilerCache.get(template);
    };

    Environment.prototype.hasPartial = function hasPartial(name, _ref7) {
      var owner = _ref7.owner;

      return (0, _emberViews.hasPartial)(name, owner);
    };

    Environment.prototype.lookupPartial = function lookupPartial(name, _ref8) {
      var owner = _ref8.owner;

      var partial = {
        template: (0, _emberViews.lookupPartial)(name, owner)
      };

      if (partial.template) {
        return partial;
      } else {
        throw new Error(name + ' is not a partial');
      }
    };

    Environment.prototype.hasHelper = function hasHelper(name, _ref9) {
      var owner = _ref9.owner,
          moduleName = _ref9.moduleName;

      if (name === 'component' || this.builtInHelpers[name]) {
        return true;
      }

      var options = { source: 'template:' + moduleName };

      return owner.hasRegistration('helper:' + name, options) || owner.hasRegistration('helper:' + name);
    };

    Environment.prototype.lookupHelper = function lookupHelper(name, meta) {
      if (name === 'component') {
        return function (vm, args) {
          return (0, _component.default)(vm, args, meta);
        };
      }

      var owner = meta.owner,
          moduleName = meta.moduleName;

      var helper = this.builtInHelpers[name];

      if (helper) {
        return helper;
      }

      var options = moduleName && { source: 'template:' + moduleName } || {};
      var helperFactory = owner.factoryFor('helper:' + name, options) || owner.factoryFor('helper:' + name);

      // TODO: try to unify this into a consistent protocol to avoid wasteful closure allocations
      var HelperReference = void 0;
      if (helperFactory.class.isSimpleHelperFactory) {
        HelperReference = _references.SimpleHelperReference;
      } else if (helperFactory.class.isHelperFactory) {
        HelperReference = _references.ClassBasedHelperReference;
      } else {
        throw new Error(name + ' is not a helper');
      }

      return function (vm, args) {
        return HelperReference.create(helperFactory, vm, args.capture());
      };
    };

    Environment.prototype.hasModifier = function hasModifier(name) {
      return !!this.builtInModifiers[name];
    };

    Environment.prototype.lookupModifier = function lookupModifier(name) {
      var modifier = this.builtInModifiers[name];

      if (modifier) {
        return modifier;
      } else {
        throw new Error(name + ' is not a modifier');
      }
    };

    Environment.prototype.toConditionalReference = function toConditionalReference(reference) {
      return _references.ConditionalReference.create(reference);
    };

    Environment.prototype.iterableFor = function iterableFor(ref, key) {
      return (0, _iterable.default)(ref, key);
    };

    Environment.prototype.scheduleInstallModifier = function scheduleInstallModifier() {
      if (this.isInteractive) {
        var _GlimmerEnvironment$p;

        (_GlimmerEnvironment$p = _GlimmerEnvironment.prototype.scheduleInstallModifier).call.apply(_GlimmerEnvironment$p, [this].concat(Array.prototype.slice.call(arguments)));
      }
    };

    Environment.prototype.scheduleUpdateModifier = function scheduleUpdateModifier() {
      if (this.isInteractive) {
        var _GlimmerEnvironment$p2;

        (_GlimmerEnvironment$p2 = _GlimmerEnvironment.prototype.scheduleUpdateModifier).call.apply(_GlimmerEnvironment$p2, [this].concat(Array.prototype.slice.call(arguments)));
      }
    };

    Environment.prototype.didDestroy = function didDestroy(destroyable) {
      destroyable.destroy();
    };

    Environment.prototype.begin = function begin() {
      this.inTransaction = true;

      _GlimmerEnvironment.prototype.begin.call(this);
    };

    Environment.prototype.commit = function commit() {
      var destroyedComponents = this.destroyedComponents;
      this.destroyedComponents = [];
      // components queued for destruction must be destroyed before firing
      // `didCreate` to prevent errors when removing and adding a component
      // with the same name (would throw an error when added to view registry)
      for (var i = 0; i < destroyedComponents.length; i++) {
        destroyedComponents[i].destroy();
      }

      try {
        _GlimmerEnvironment.prototype.commit.call(this);
      } finally {
        this.inTransaction = false;
      }
    };

    return Environment;
  }(_runtime.Environment);

  exports.default = Environment;


  if (true) {
    var StyleAttributeManager = function (_AttributeManager) {
      (0, _emberBabel.inherits)(StyleAttributeManager, _AttributeManager);

      function StyleAttributeManager() {
        (0, _emberBabel.classCallCheck)(this, StyleAttributeManager);
        return (0, _emberBabel.possibleConstructorReturn)(this, _AttributeManager.apply(this, arguments));
      }

      StyleAttributeManager.prototype.setAttribute = function setAttribute(dom, element, value) {
        var _AttributeManager$pro;

        (true && (0, _emberDebug.warn)((0, _emberViews.constructStyleDeprecationMessage)(value), function () {
          if (value === null || value === undefined || (0, _runtime.isSafeString)(value)) {
            return true;
          }
          return false;
        }(), { id: 'ember-htmlbars.style-xss-warning' }));

        (_AttributeManager$pro = _AttributeManager.prototype.setAttribute).call.apply(_AttributeManager$pro, [this].concat(Array.prototype.slice.call(arguments)));
      };

      StyleAttributeManager.prototype.updateAttribute = function updateAttribute(dom, element, value) {
        var _AttributeManager$pro2;

        (true && (0, _emberDebug.warn)((0, _emberViews.constructStyleDeprecationMessage)(value), function () {
          if (value === null || value === undefined || (0, _runtime.isSafeString)(value)) {
            return true;
          }
          return false;
        }(), { id: 'ember-htmlbars.style-xss-warning' }));

        (_AttributeManager$pro2 = _AttributeManager.prototype.updateAttribute).call.apply(_AttributeManager$pro2, [this].concat(Array.prototype.slice.call(arguments)));
      };

      return StyleAttributeManager;
    }(_runtime.AttributeManager);

    var STYLE_ATTRIBUTE_MANANGER = new StyleAttributeManager('style');

    Environment.prototype.attributeFor = function (element, attribute, isTrusting, namespace) {
      if (attribute === 'style' && !isTrusting) {
        return STYLE_ATTRIBUTE_MANANGER;
      }

      return _runtime.Environment.prototype.attributeFor.call(this, element, attribute, isTrusting);
    };
  }
});
enifed('ember-glimmer/helper', ['exports', 'ember-babel', 'ember-utils', 'ember-runtime', '@glimmer/reference'], function (exports, _emberBabel, _emberUtils, _emberRuntime, _reference) {
  'use strict';

  exports.SimpleHelper = exports.RECOMPUTE_TAG = undefined;
  exports.helper = helper;
  var RECOMPUTE_TAG = exports.RECOMPUTE_TAG = (0, _emberUtils.symbol)('RECOMPUTE_TAG');

  /**
    Ember Helpers are functions that can compute values, and are used in templates.
    For example, this code calls a helper named `format-currency`:
  
    ```handlebars
    <div>{{format-currency cents currency="$"}}</div>
    ```
  
    Additionally a helper can be called as a nested helper (sometimes called a
    subexpression). In this example, the computed value of a helper is passed
    to a component named `show-money`:
  
    ```handlebars
    {{show-money amount=(format-currency cents currency="$")}}
    ```
  
    Helpers defined using a class must provide a `compute` function. For example:
  
    ```app/helpers/format-currency.js
    import Helper from '@ember/component/helper';
  
    export default Helper.extend({
      compute(params, hash) {
        let cents = params[0];
        let currency = hash.currency;
        return `${currency}${cents * 0.01}`;
      }
    });
    ```
  
    Each time the input to a helper changes, the `compute` function will be
    called again.
  
    As instances, these helpers also have access to the container an will accept
    injected dependencies.
  
    Additionally, class helpers can call `recompute` to force a new computation.
  
    @class Helper
    @public
    @since 1.13.0
  */
  /**
  @module @ember/component
  */

  var Helper = _emberRuntime.FrameworkObject.extend({
    isHelperInstance: true,

    init: function () {
      this._super.apply(this, arguments);
      this[RECOMPUTE_TAG] = new _reference.DirtyableTag();
    },
    recompute: function () {
      this[RECOMPUTE_TAG].dirty();
    }
  }

  /**
    Override this function when writing a class-based helper.
     @method compute
    @param {Array} params The positional arguments to the helper
    @param {Object} hash The named arguments to the helper
    @public
    @since 1.13.0
  */
  );

  Helper.reopenClass({
    isHelperFactory: true
  });

  var SimpleHelper = exports.SimpleHelper = function () {
    function SimpleHelper(compute) {
      (0, _emberBabel.classCallCheck)(this, SimpleHelper);

      this.isHelperFactory = true;
      this.isHelperInstance = true;
      this.isSimpleHelperFactory = true;
      this.compute = compute;
    }

    SimpleHelper.prototype.create = function create() {
      return this;
    };

    return SimpleHelper;
  }();

  /**
    In many cases, the ceremony of a full `Helper` class is not required.
    The `helper` method create pure-function helpers without instances. For
    example:
  
    ```app/helpers/format-currency.js
    import { helper } from '@ember/component/helper';
  
    export default helper(function(params, hash) {
      let cents = params[0];
      let currency = hash.currency;
      return `${currency}${cents * 0.01}`;
    });
    ```
  
    @static
    @param {Function} helper The helper function
    @method helper
    @for @ember/component/helper
    @public
    @since 1.13.0
  */
  function helper(helperFn) {
    return new SimpleHelper(helperFn);
  }

  exports.default = Helper;
});
enifed('ember-glimmer/helpers/-class', ['exports', 'ember-glimmer/utils/references', 'ember-runtime'], function (exports, _references, _emberRuntime) {
  'use strict';

  exports.default = function (vm, args) {
    return new _references.InternalHelperReference(classHelper, args.capture());
  };

  function classHelper(_ref) {
    var positional = _ref.positional;

    var path = positional.at(0);
    var args = positional.length;
    var value = path.value();

    if (value === true) {
      if (args > 1) {
        return _emberRuntime.String.dasherize(positional.at(1).value());
      }
      return null;
    }

    if (value === false) {
      if (args > 2) {
        return _emberRuntime.String.dasherize(positional.at(2).value());
      }
      return null;
    }

    return value;
  }
});
enifed('ember-glimmer/helpers/-html-safe', ['exports', 'ember-glimmer/utils/references', 'ember-glimmer/utils/string'], function (exports, _references, _string) {
  'use strict';

  exports.default = function (vm, args) {
    return new _references.InternalHelperReference(htmlSafe, args.capture());
  };

  function htmlSafe(_ref) {
    var positional = _ref.positional;

    var path = positional.at(0);
    return new _string.SafeString(path.value());
  }
});
enifed('ember-glimmer/helpers/-input-type', ['exports', 'ember-glimmer/utils/references'], function (exports, _references) {
  'use strict';

  exports.default = function (vm, args) {
    return new _references.InternalHelperReference(inputTypeHelper, args.capture());
  };

  function inputTypeHelper(_ref) {
    var positional = _ref.positional,
        named = _ref.named;

    var type = positional.at(0).value();
    if (type === 'checkbox') {
      return '-checkbox';
    }
    return '-text-field';
  }
});
enifed('ember-glimmer/helpers/-normalize-class', ['exports', 'ember-glimmer/utils/references', 'ember-runtime'], function (exports, _references, _emberRuntime) {
  'use strict';

  exports.default = function (vm, args) {
    return new _references.InternalHelperReference(normalizeClass, args.capture());
  };

  function normalizeClass(_ref) {
    var positional = _ref.positional,
        named = _ref.named;

    var classNameParts = positional.at(0).value().split('.');
    var className = classNameParts[classNameParts.length - 1];
    var value = positional.at(1).value();

    if (value === true) {
      return _emberRuntime.String.dasherize(className);
    } else if (!value && value !== 0) {
      return '';
    } else {
      return String(value);
    }
  }
});
enifed('ember-glimmer/helpers/action', ['exports', 'ember-utils', 'ember-metal', 'ember-glimmer/utils/references', '@glimmer/reference', 'ember-debug'], function (exports, _emberUtils, _emberMetal, _references, _reference, _emberDebug) {
  'use strict';

  exports.ACTION = exports.INVOKE = undefined;

  exports.default = function (vm, args) {
    var named = args.named,
        positional = args.positional;


    var capturedArgs = positional.capture();

    // The first two argument slots are reserved.
    // pos[0] is the context (or `this`)
    // pos[1] is the action name or function
    // Anything else is an action argument.

    var _capturedArgs$referen = capturedArgs.references,
        context = _capturedArgs$referen[0],
        action = _capturedArgs$referen[1],
        restArgs = _capturedArgs$referen.slice(2);

    // TODO: Is there a better way of doing this?


    var debugKey = action._propertyKey;

    var target = named.has('target') ? named.get('target') : context;
    var processArgs = makeArgsProcessor(named.has('value') && named.get('value'), restArgs);

    var fn = void 0;

    if (typeof action[INVOKE] === 'function') {
      fn = makeClosureAction(action, action, action[INVOKE], processArgs, debugKey);
    } else if ((0, _reference.isConst)(target) && (0, _reference.isConst)(action)) {
      fn = makeClosureAction(context.value(), target.value(), action.value(), processArgs, debugKey);
    } else {
      fn = makeDynamicClosureAction(context.value(), target, action, processArgs, debugKey);
    }

    fn[ACTION] = true;

    return new _references.UnboundReference(fn);
  };

  var INVOKE = exports.INVOKE = (0, _emberUtils.symbol)('INVOKE'); /**
                                                                   @module ember
                                                                   */
  var ACTION = exports.ACTION = (0, _emberUtils.symbol)('ACTION');

  /**
    The `{{action}}` helper provides a way to pass triggers for behavior (usually
    just a function) between components, and into components from controllers.
  
    ### Passing functions with the action helper
  
    There are three contexts an action helper can be used in. The first two
    contexts to discuss are attribute context, and Handlebars value context.
  
    ```handlebars
    {{! An example of attribute context }}
    <div onclick={{action "save"}}></div>
    {{! Examples of Handlebars value context }}
    {{input on-input=(action "save")}}
    {{yield (action "refreshData") andAnotherParam}}
    ```
  
    In these contexts,
    the helper is called a "closure action" helper. Its behavior is simple:
    If passed a function name, read that function off the `actions` property
    of the current context. Once that function is read (or if a function was
    passed), create a closure over that function and any arguments.
    The resulting value of an action helper used this way is simply a function.
  
    For example, in the attribute context:
  
    ```handlebars
    {{! An example of attribute context }}
    <div onclick={{action "save"}}></div>
    ```
  
    The resulting template render logic would be:
  
    ```js
    var div = document.createElement('div');
    var actionFunction = (function(context){
      return function() {
        return context.actions.save.apply(context, arguments);
      };
    })(context);
    div.onclick = actionFunction;
    ```
  
    Thus when the div is clicked, the action on that context is called.
    Because the `actionFunction` is just a function, closure actions can be
    passed between components and still execute in the correct context.
  
    Here is an example action handler on a component:
  
    ```app/components/my-component.js
    import Component from '@ember/component';
  
    export default Component.extend({
      actions: {
        save() {
          this.get('model').save();
        }
      }
    });
    ```
  
    Actions are always looked up on the `actions` property of the current context.
    This avoids collisions in the naming of common actions, such as `destroy`.
    Two options can be passed to the `action` helper when it is used in this way.
  
    * `target=someProperty` will look to `someProperty` instead of the current
      context for the `actions` hash. This can be useful when targeting a
      service for actions.
    * `value="target.value"` will read the path `target.value` off the first
      argument to the action when it is called and rewrite the first argument
      to be that value. This is useful when attaching actions to event listeners.
  
    ### Invoking an action
  
    Closure actions curry both their scope and any arguments. When invoked, any
    additional arguments are added to the already curried list.
    Actions should be invoked using the [sendAction](/api/classes/Ember.Component.html#method_sendAction)
    method. The first argument to `sendAction` is the action to be called, and
    additional arguments are passed to the action function. This has interesting
    properties combined with currying of arguments. For example:
  
    ```app/components/my-component.js
    import Component from '@ember/component';
  
    export default Component.extend({
      actions: {
        // Usage {{input on-input=(action (action 'setName' model) value="target.value")}}
        setName(model, name) {
          model.set('name', name);
        }
      }
    });
    ```
  
    The first argument (`model`) was curried over, and the run-time argument (`event`)
    becomes a second argument. Action calls can be nested this way because each simply
    returns a function. Any function can be passed to the `{{action}}` helper, including
    other actions.
  
    Actions invoked with `sendAction` have the same currying behavior as demonstrated
    with `on-input` above. For example:
  
    ```app/components/my-input.js
    import Component from '@ember/component';
  
    export default Component.extend({
      actions: {
        setName(model, name) {
          model.set('name', name);
        }
      }
    });
    ```
  
    ```handlebars
    {{my-input submit=(action 'setName' model)}}
    ```
  
    ```app/components/my-component.js
    import Component from '@ember/component';
  
    export default Component.extend({
      click() {
        // Note that model is not passed, it was curried in the template
        this.sendAction('submit', 'bob');
      }
    });
    ```
  
    ### Attaching actions to DOM elements
  
    The third context of the `{{action}}` helper can be called "element space".
    For example:
  
    ```handlebars
    {{! An example of element space }}
    <div {{action "save"}}></div>
    ```
  
    Used this way, the `{{action}}` helper provides a useful shortcut for
    registering an HTML element in a template for a single DOM event and
    forwarding that interaction to the template's context (controller or component).
    If the context of a template is a controller, actions used this way will
    bubble to routes when the controller does not implement the specified action.
    Once an action hits a route, it will bubble through the route hierarchy.
  
    ### Event Propagation
  
    `{{action}}` helpers called in element space can control event bubbling. Note
    that the closure style actions cannot.
  
    Events triggered through the action helper will automatically have
    `.preventDefault()` called on them. You do not need to do so in your event
    handlers. If you need to allow event propagation (to handle file inputs for
    example) you can supply the `preventDefault=false` option to the `{{action}}` helper:
  
    ```handlebars
    <div {{action "sayHello" preventDefault=false}}>
      <input type="file" />
      <input type="checkbox" />
    </div>
    ```
  
    To disable bubbling, pass `bubbles=false` to the helper:
  
    ```handlebars
    <button {{action 'edit' post bubbles=false}}>Edit</button>
    ```
  
    To disable bubbling with closure style actions you must create your own
    wrapper helper that makes use of `event.stopPropagation()`:
  
    ```handlebars
    <div onclick={{disable-bubbling (action "sayHello")}}>Hello</div>
    ```
  
    ```app/helpers/disable-bubbling.js
    import { helper } from '@ember/component/helper';
  
    export function disableBubbling([action]) {
      return function(event) {
        event.stopPropagation();
        return action(event);
      };
    }
    export default helper(disableBubbling);
    ```
  
    If you need the default handler to trigger you should either register your
    own event handler, or use event methods on your view class. See
    ["Responding to Browser Events"](/api/classes/Ember.Component#responding-to-browser-events)
    in the documentation for `Component` for more information.
  
    ### Specifying DOM event type
  
    `{{action}}` helpers called in element space can specify an event type.
    By default the `{{action}}` helper registers for DOM `click` events. You can
    supply an `on` option to the helper to specify a different DOM event name:
  
    ```handlebars
    <div {{action "anActionName" on="doubleClick"}}>
      click me
    </div>
    ```
  
    See ["Event Names"](/api/classes/Ember.Component#event-names) for a list of
    acceptable DOM event names.
  
    ### Specifying whitelisted modifier keys
  
    `{{action}}` helpers called in element space can specify modifier keys.
    By default the `{{action}}` helper will ignore click events with pressed modifier
    keys. You can supply an `allowedKeys` option to specify which keys should not be ignored.
  
    ```handlebars
    <div {{action "anActionName" allowedKeys="alt"}}>
      click me
    </div>
    ```
  
    This way the action will fire when clicking with the alt key pressed down.
    Alternatively, supply "any" to the `allowedKeys` option to accept any combination of modifier keys.
  
    ```handlebars
    <div {{action "anActionName" allowedKeys="any"}}>
      click me with any key pressed
    </div>
    ```
  
    ### Specifying a Target
  
    A `target` option can be provided to the helper to change
    which object will receive the method call. This option must be a path
    to an object, accessible in the current context:
  
    ```app/templates/application.hbs
    <div {{action "anActionName" target=someService}}>
      click me
    </div>
    ```
  
    ```app/controllers/application.js
    import Controller from '@ember/controller';
    import { inject as service } from '@ember/service';
  
    export default Controller.extend({
      someService: service()
    });
    ```
  
    @method action
    @for Ember.Templates.helpers
    @public
  */


  function NOOP(args) {
    return args;
  }

  function makeArgsProcessor(valuePathRef, actionArgsRef) {
    var mergeArgs = null;

    if (actionArgsRef.length > 0) {
      mergeArgs = function (args) {
        return actionArgsRef.map(function (ref) {
          return ref.value();
        }).concat(args);
      };
    }

    var readValue = null;

    if (valuePathRef) {
      readValue = function (args) {
        var valuePath = valuePathRef.value();

        if (valuePath && args.length > 0) {
          args[0] = (0, _emberMetal.get)(args[0], valuePath);
        }

        return args;
      };
    }

    if (mergeArgs && readValue) {
      return function (args) {
        return readValue(mergeArgs(args));
      };
    } else {
      return mergeArgs || readValue || NOOP;
    }
  }

  function makeDynamicClosureAction(context, targetRef, actionRef, processArgs, debugKey) {
    // We don't allow undefined/null values, so this creates a throw-away action to trigger the assertions
    if (true) {
      makeClosureAction(context, targetRef.value(), actionRef.value(), processArgs, debugKey);
    }

    return function () {
      return makeClosureAction(context, targetRef.value(), actionRef.value(), processArgs, debugKey).apply(undefined, arguments);
    };
  }

  function makeClosureAction(context, target, action, processArgs, debugKey) {
    var self = void 0,
        fn = void 0;

    (true && !(!(0, _emberMetal.isNone)(action)) && (0, _emberDebug.assert)('Action passed is null or undefined in (action) from ' + target + '.', !(0, _emberMetal.isNone)(action)));


    if (typeof action[INVOKE] === 'function') {
      self = action;
      fn = action[INVOKE];
    } else {
      var typeofAction = typeof action;

      if (typeofAction === 'string') {
        self = target;
        fn = target.actions && target.actions[action];

        (true && !(fn) && (0, _emberDebug.assert)('An action named \'' + action + '\' was not found in ' + target, fn));
      } else if (typeofAction === 'function') {
        self = context;
        fn = action;
      } else {
        (true && !(false) && (0, _emberDebug.assert)('An action could not be made for `' + (debugKey || action) + '` in ' + target + '. Please confirm that you are using either a quoted action name (i.e. `(action \'' + (debugKey || 'myAction') + '\')`) or a function available in ' + target + '.', false));
      }
    }

    return function () {
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      var payload = { target: self, args: args, label: '@glimmer/closure-action' };
      return (0, _emberMetal.flaggedInstrument)('interaction.ember-action', payload, function () {
        return _emberMetal.run.join.apply(_emberMetal.run, [self, fn].concat(processArgs(args)));
      });
    };
  }
});
enifed('ember-glimmer/helpers/component', ['exports', 'ember-babel', 'ember-utils', 'ember-glimmer/utils/references', 'ember-glimmer/component-managers/curly', '@glimmer/runtime', 'ember-debug'], function (exports, _emberBabel, _emberUtils, _references, _curly, _runtime, _emberDebug) {
  'use strict';

  exports.ClosureComponentReference = undefined;

  exports.default = function (vm, args, meta) {
    return ClosureComponentReference.create(args.capture(), meta, vm.env);
  };

  var ClosureComponentReference = exports.ClosureComponentReference = function (_CachedReference) {
    (0, _emberBabel.inherits)(ClosureComponentReference, _CachedReference);

    ClosureComponentReference.create = function create(args, meta, env) {
      return new ClosureComponentReference(args, meta, env);
    };

    function ClosureComponentReference(args, meta, env) {
      (0, _emberBabel.classCallCheck)(this, ClosureComponentReference);

      var _this = (0, _emberBabel.possibleConstructorReturn)(this, _CachedReference.call(this));

      var firstArg = args.positional.at(0);
      _this.defRef = firstArg;
      _this.tag = firstArg.tag;
      _this.args = args;
      _this.meta = meta;
      _this.env = env;
      _this.lastDefinition = undefined;
      _this.lastName = undefined;
      return _this;
    }

    ClosureComponentReference.prototype.compute = function compute() {
      // TODO: Figure out how to extract this because it's nearly identical to
      // DynamicComponentReference::compute(). The only differences besides
      // currying are in the assertion messages.
      var args = this.args,
          defRef = this.defRef,
          env = this.env,
          meta = this.meta,
          lastDefinition = this.lastDefinition,
          lastName = this.lastName;

      var nameOrDef = defRef.value();
      var definition = null;

      if (nameOrDef && nameOrDef === lastName) {
        return lastDefinition;
      }

      this.lastName = nameOrDef;

      if (typeof nameOrDef === 'string') {
        (true && !(nameOrDef !== 'input') && (0, _emberDebug.assert)('You cannot use the input helper as a contextual helper. Please extend TextField or Checkbox to use it as a contextual component.', nameOrDef !== 'input'));
        (true && !(nameOrDef !== 'textarea') && (0, _emberDebug.assert)('You cannot use the textarea helper as a contextual helper. Please extend TextArea to use it as a contextual component.', nameOrDef !== 'textarea'));

        definition = env.getComponentDefinition(nameOrDef, meta);
        (true && !(definition) && (0, _emberDebug.assert)('The component helper cannot be used without a valid component name. You used "' + nameOrDef + '" via (component "' + nameOrDef + '")', definition));
      } else if ((0, _runtime.isComponentDefinition)(nameOrDef)) {
        definition = nameOrDef;
      } else {
        (true && !(nameOrDef) && (0, _emberDebug.assert)('You cannot create a component from ' + nameOrDef + ' using the {{component}} helper', nameOrDef));

        return null;
      }

      var newDef = createCurriedDefinition(definition, args);

      this.lastDefinition = newDef;

      return newDef;
    };

    return ClosureComponentReference;
  }(_references.CachedReference);

  function createCurriedDefinition(definition, args) {
    var curriedArgs = curryArgs(definition, args);

    return new _curly.CurlyComponentDefinition(definition.name, definition.ComponentClass, definition.template, curriedArgs);
  }

  function curryArgs(definition, newArgs) {
    var args = definition.args,
        ComponentClass = definition.ComponentClass;

    var positionalParams = ComponentClass.class.positionalParams;

    // The args being passed in are from the (component ...) invocation,
    // so the first positional argument is actually the name or component
    // definition. It needs to be dropped in order for any actual positional
    // args to coincide with the ComponentClass's positionParams.

    // For "normal" curly components this slicing is done at the syntax layer,
    // but we don't have that luxury here.

    var _newArgs$positional$r = newArgs.positional.references,
        slicedPositionalArgs = _newArgs$positional$r.slice(1);

    if (positionalParams && slicedPositionalArgs.length) {
      (0, _curly.validatePositionalParameters)(newArgs.named, slicedPositionalArgs, positionalParams);
    }

    var isRest = typeof positionalParams === 'string';

    // For non-rest position params, we need to perform the position -> name mapping
    // at each layer to avoid a collision later when the args are used to construct
    // the component instance (inside of processArgs(), inside of create()).
    var positionalToNamedParams = {};

    if (!isRest && positionalParams.length > 0) {
      var limit = Math.min(positionalParams.length, slicedPositionalArgs.length);

      for (var i = 0; i < limit; i++) {
        var name = positionalParams[i];
        positionalToNamedParams[name] = slicedPositionalArgs[i];
      }

      slicedPositionalArgs.length = 0; // Throw them away since you're merged in.
    }

    // args (aka 'oldArgs') may be undefined or simply be empty args, so
    // we need to fall back to an empty array or object.
    var oldNamed = args && args.named || {};
    var oldPositional = args && args.positional || [];

    // Merge positional arrays
    var positional = new Array(Math.max(oldPositional.length, slicedPositionalArgs.length));
    positional.splice.apply(positional, [0, oldPositional.length].concat(oldPositional));
    positional.splice.apply(positional, [0, slicedPositionalArgs.length].concat(slicedPositionalArgs));

    // Merge named maps
    var named = (0, _emberUtils.assign)({}, oldNamed, positionalToNamedParams, newArgs.named.map);

    return { positional: positional, named: named };
  }
});
enifed('ember-glimmer/helpers/concat', ['exports', 'ember-glimmer/utils/references', '@glimmer/runtime'], function (exports, _references, _runtime) {
  'use strict';

  exports.default = function (vm, args) {
    return new _references.InternalHelperReference(concat, args.capture());
  };

  /**
  @module ember
  */

  /**
    Concatenates the given arguments into a string.
  
    Example:
  
    ```handlebars
    {{some-component name=(concat firstName " " lastName)}}
  
    {{! would pass name="<first name value> <last name value>" to the component}}
    ```
  
    @public
    @method concat
    @for Ember.Templates.helpers
    @since 1.13.0
  */
  function concat(_ref) {
    var positional = _ref.positional;

    return positional.value().map(_runtime.normalizeTextValue).join('');
  }
});
enifed('ember-glimmer/helpers/each-in', ['exports', 'ember-utils'], function (exports, _emberUtils) {
  'use strict';

  exports.isEachIn = isEachIn;

  exports.default = function (vm, args) {
    var ref = Object.create(args.positional.at(0));
    ref[EACH_IN_REFERENCE] = true;
    return ref;
  };

  /**
    The `{{#each}}` helper loops over elements in a collection. It is an extension
    of the base Handlebars `{{#each}}` helper.
    The default behavior of `{{#each}}` is to yield its inner block once for every
    item in an array passing the item as the first block parameter.
  
    ```javascript
    var developers = [{ name: 'Yehuda' },{ name: 'Tom' }, { name: 'Paul' }];
    ```
  
    ```handlebars
    {{#each developers key="name" as |person|}}
      {{person.name}}
      {{! `this` is whatever it was outside the #each }}
    {{/each}}
    ```
  
    The same rules apply to arrays of primitives.
  
    ```javascript
    var developerNames = ['Yehuda', 'Tom', 'Paul']
    ```
  
    ```handlebars
    {{#each developerNames key="@index" as |name|}}
      {{name}}
    {{/each}}
    ```
  
    During iteration, the index of each item in the array is provided as a second block parameter.
  
    ```handlebars
    <ul>
      {{#each people as |person index|}}
        <li>Hello, {{person.name}}! You're number {{index}} in line</li>
      {{/each}}
    </ul>
    ```
  
    ### Specifying Keys
  
    The `key` option is used to tell Ember how to determine if the array being
    iterated over with `{{#each}}` has changed between renders. By helping Ember
    detect that some elements in the array are the same, DOM elements can be
    re-used, significantly improving rendering speed.
  
    For example, here's the `{{#each}}` helper with its `key` set to `id`:
  
    ```handlebars
    {{#each model key="id" as |item|}}
    {{/each}}
    ```
  
    When this `{{#each}}` re-renders, Ember will match up the previously rendered
    items (and reorder the generated DOM elements) based on each item's `id`
    property.
    By default the item's own reference is used.
  
    ### {{else}} condition
  
    `{{#each}}` can have a matching `{{else}}`. The contents of this block will render
    if the collection is empty.
  
    ```handlebars
    {{#each developers as |person|}}
      {{person.name}}
    {{else}}
      <p>Sorry, nobody is available for this task.</p>
    {{/each}}
    ```
  
    @method each
    @for Ember.Templates.helpers
    @public
   */

  /**
    The `{{each-in}}` helper loops over properties on an object.
  
    For example, given a `user` object that looks like:
  
    ```javascript
    {
      "name": "Shelly Sails",
      "age": 42
    }
    ```
  
    This template would display all properties on the `user`
    object in a list:
  
    ```handlebars
    <ul>
    {{#each-in user as |key value|}}
      <li>{{key}}: {{value}}</li>
    {{/each-in}}
    </ul>
    ```
  
    Outputting their name and age.
  
    @method each-in
    @for Ember.Templates.helpers
    @public
    @since 2.1.0
  */
  var EACH_IN_REFERENCE = (0, _emberUtils.symbol)('EACH_IN'); /**
                                                              @module ember
                                                              */
  function isEachIn(ref) {
    return ref && ref[EACH_IN_REFERENCE];
  }
});
enifed('ember-glimmer/helpers/get', ['exports', 'ember-babel', 'ember-metal', 'ember-glimmer/utils/references', '@glimmer/reference', '@glimmer/runtime'], function (exports, _emberBabel, _emberMetal, _references, _reference, _runtime) {
  'use strict';

  exports.default = function (vm, args) {
    return GetHelperReference.create(args.positional.at(0), args.positional.at(1));
  };

  var GetHelperReference = function (_CachedReference) {
    (0, _emberBabel.inherits)(GetHelperReference, _CachedReference);

    GetHelperReference.create = function create(sourceReference, pathReference) {
      if ((0, _reference.isConst)(pathReference)) {
        var parts = pathReference.value().split('.');
        return (0, _reference.referenceFromParts)(sourceReference, parts);
      } else {
        return new GetHelperReference(sourceReference, pathReference);
      }
    };

    function GetHelperReference(sourceReference, pathReference) {
      (0, _emberBabel.classCallCheck)(this, GetHelperReference);

      var _this = (0, _emberBabel.possibleConstructorReturn)(this, _CachedReference.call(this));

      _this.sourceReference = sourceReference;
      _this.pathReference = pathReference;

      _this.lastPath = null;
      _this.innerReference = _runtime.NULL_REFERENCE;

      var innerTag = _this.innerTag = new _reference.UpdatableTag(_reference.CONSTANT_TAG);

      _this.tag = (0, _reference.combine)([sourceReference.tag, pathReference.tag, innerTag]);
      return _this;
    }

    GetHelperReference.prototype.compute = function compute() {
      var lastPath = this.lastPath,
          innerReference = this.innerReference,
          innerTag = this.innerTag;


      var path = this.lastPath = this.pathReference.value();

      if (path !== lastPath) {
        if (path !== undefined && path !== null && path !== '') {
          var pathType = typeof path;

          if (pathType === 'string') {
            innerReference = (0, _reference.referenceFromParts)(this.sourceReference, path.split('.'));
          } else if (pathType === 'number') {
            innerReference = this.sourceReference.get('' + path);
          }

          innerTag.update(innerReference.tag);
        } else {
          innerReference = _runtime.NULL_REFERENCE;
          innerTag.update(_reference.CONSTANT_TAG);
        }

        this.innerReference = innerReference;
      }

      return innerReference.value();
    };

    GetHelperReference.prototype[_references.UPDATE] = function (value) {
      (0, _emberMetal.set)(this.sourceReference.value(), this.pathReference.value(), value);
    };

    return GetHelperReference;
  }(_references.CachedReference);
});
enifed("ember-glimmer/helpers/hash", ["exports"], function (exports) {
  "use strict";

  exports.default = function (vm, args) {
    return args.named.capture();
  };
});
enifed('ember-glimmer/helpers/if-unless', ['exports', 'ember-babel', 'ember-debug', 'ember-glimmer/utils/references', '@glimmer/reference'], function (exports, _emberBabel, _emberDebug, _references, _reference) {
  'use strict';

  exports.inlineIf = inlineIf;
  exports.inlineUnless = inlineUnless;

  var ConditionalHelperReference = function (_CachedReference) {
    (0, _emberBabel.inherits)(ConditionalHelperReference, _CachedReference);

    ConditionalHelperReference.create = function create(_condRef, truthyRef, falsyRef) {
      var condRef = _references.ConditionalReference.create(_condRef);
      if ((0, _reference.isConst)(condRef)) {
        return condRef.value() ? truthyRef : falsyRef;
      } else {
        return new ConditionalHelperReference(condRef, truthyRef, falsyRef);
      }
    };

    function ConditionalHelperReference(cond, truthy, falsy) {
      (0, _emberBabel.classCallCheck)(this, ConditionalHelperReference);

      var _this = (0, _emberBabel.possibleConstructorReturn)(this, _CachedReference.call(this));

      _this.branchTag = new _reference.UpdatableTag(_reference.CONSTANT_TAG);
      _this.tag = (0, _reference.combine)([cond.tag, _this.branchTag]);

      _this.cond = cond;
      _this.truthy = truthy;
      _this.falsy = falsy;
      return _this;
    }

    ConditionalHelperReference.prototype.compute = function compute() {
      var branch = this.cond.value() ? this.truthy : this.falsy;

      this.branchTag.update(branch.tag);

      return branch.value();
    };

    return ConditionalHelperReference;
  }(_references.CachedReference);

  /**
    The `if` helper allows you to conditionally render one of two branches,
    depending on the "truthiness" of a property.
    For example the following values are all falsey: `false`, `undefined`, `null`, `""`, `0`, `NaN` or an empty array.
  
    This helper has two forms, block and inline.
  
    ## Block form
  
    You can use the block form of `if` to conditionally render a section of the template.
  
    To use it, pass the conditional value to the `if` helper,
    using the block form to wrap the section of template you want to conditionally render.
    Like so:
  
    ```handlebars
    {{! will not render if foo is falsey}}
    {{#if foo}}
      Welcome to the {{foo.bar}}
    {{/if}}
    ```
  
    You can also specify a template to show if the property is falsey by using
    the `else` helper.
  
    ```handlebars
    {{! is it raining outside?}}
    {{#if isRaining}}
      Yes, grab an umbrella!
    {{else}}
      No, it's lovely outside!
    {{/if}}
    ```
  
    You are also able to combine `else` and `if` helpers to create more complex
    conditional logic.
  
    ```handlebars
    {{#if isMorning}}
      Good morning
    {{else if isAfternoon}}
      Good afternoon
    {{else}}
      Good night
    {{/if}}
    ```
  
    ## Inline form
  
    The inline `if` helper conditionally renders a single property or string.
  
    In this form, the `if` helper receives three arguments, the conditional value,
    the value to render when truthy, and the value to render when falsey.
  
    For example, if `useLongGreeting` is truthy, the following:
  
    ```handlebars
    {{if useLongGreeting "Hello" "Hi"}} Alex
    ```
  
    Will render:
  
    ```html
    Hello Alex
    ```
  
    ### Nested `if`
  
    You can use the `if` helper inside another helper as a nested helper:
  
    ```handlebars
    {{some-component height=(if isBig "100" "10")}}
    ```
  
    One detail to keep in mind is that both branches of the `if` helper will be evaluated,
    so if you have `{{if condition "foo" (expensive-operation "bar")`,
    `expensive-operation` will always calculate.
  
    @method if
    @for Ember.Templates.helpers
    @public
  */
  function inlineIf(vm, _ref) {
    var positional = _ref.positional;
    (true && !(positional.length === 3 || positional.length === 2) && (0, _emberDebug.assert)('The inline form of the `if` helper expects two or three arguments, e.g. ' + '`{{if trialExpired "Expired" expiryDate}}`.', positional.length === 3 || positional.length === 2));

    return ConditionalHelperReference.create(positional.at(0), positional.at(1), positional.at(2));
  }

  /**
    The inline `unless` helper conditionally renders a single property or string.
    This helper acts like a ternary operator. If the first property is falsy,
    the second argument will be displayed, otherwise, the third argument will be
    displayed
  
    ```handlebars
    {{unless useLongGreeting "Hi" "Hello"}} Ben
    ```
  
    You can use the `unless` helper inside another helper as a subexpression.
  
    ```handlebars
    {{some-component height=(unless isBig "10" "100")}}
    ```
  
    @method unless
    @for Ember.Templates.helpers
    @public
  */
  function inlineUnless(vm, _ref2) {
    var positional = _ref2.positional;
    (true && !(positional.length === 3 || positional.length === 2) && (0, _emberDebug.assert)('The inline form of the `unless` helper expects two or three arguments, e.g. ' + '`{{unless isFirstLogin "Welcome back!"}}`.', positional.length === 3 || positional.length === 2));

    return ConditionalHelperReference.create(positional.at(0), positional.at(2), positional.at(1));
  }
});
enifed('ember-glimmer/helpers/loc', ['exports', 'ember-glimmer/utils/references', 'ember-runtime'], function (exports, _references, _emberRuntime) {
  'use strict';

  exports.default = function (vm, args) {
    return new _references.InternalHelperReference(locHelper, args.capture());
  };

  /**
    Calls [loc](/api/classes/Ember.String.html#method_loc) with the
    provided string. This is a convenient way to localize text within a template.
    For example:
  
    ```javascript
    Ember.STRINGS = {
      '_welcome_': 'Bonjour'
    };
    ```
  
    ```handlebars
    <div class='message'>
      {{loc '_welcome_'}}
    </div>
    ```
  
    ```html
    <div class='message'>
      Bonjour
    </div>
    ```
  
    See [Ember.String.loc](/api/classes/Ember.String.html#method_loc) for how to
    set up localized string references.
  
    @method loc
    @for Ember.Templates.helpers
    @param {String} str The string to format.
    @see {Ember.String#loc}
    @public
  */

  /**
  @module ember
  */
  function locHelper(_ref) {
    var positional = _ref.positional;

    return _emberRuntime.String.loc.apply(null, positional.value());
  }
});
enifed('ember-glimmer/helpers/log', ['exports', 'ember-glimmer/utils/references', 'ember-console'], function (exports, _references, _emberConsole) {
  'use strict';

  exports.default = function (vm, args) {
    return new _references.InternalHelperReference(log, args.capture());
  };

  /**
    `log` allows you to output the value of variables in the current rendering
    context. `log` also accepts primitive types such as strings or numbers.
  
    ```handlebars
    {{log "myVariable:" myVariable }}
    ```
  
    @method log
    @for Ember.Templates.helpers
    @param {Array} params
    @public
  */
  function log(_ref) {
    var positional = _ref.positional;

    _emberConsole.default.log.apply(null, positional.value());
  }
  /**
  @module ember
  */
});
enifed('ember-glimmer/helpers/mut', ['exports', 'ember-utils', 'ember-debug', 'ember-glimmer/utils/references', 'ember-glimmer/helpers/action'], function (exports, _emberUtils, _emberDebug, _references, _action) {
  'use strict';

  exports.isMut = isMut;
  exports.unMut = unMut;

  exports.default = function (vm, args) {
    var rawRef = args.positional.at(0);

    if (isMut(rawRef)) {
      return rawRef;
    }

    // TODO: Improve this error message. This covers at least two distinct
    // cases:
    //
    // 1. (mut "not a path") – passing a literal, result from a helper
    //    invocation, etc
    //
    // 2. (mut receivedValue) – passing a value received from the caller
    //    that was originally derived from a literal, result from a helper
    //    invocation, etc
    //
    // This message is alright for the first case, but could be quite
    // confusing for the second case.
    (true && !(rawRef[_references.UPDATE]) && (0, _emberDebug.assert)('You can only pass a path to mut', rawRef[_references.UPDATE]));


    var wrappedRef = Object.create(rawRef);

    wrappedRef[SOURCE] = rawRef;
    wrappedRef[_action.INVOKE] = rawRef[_references.UPDATE];
    wrappedRef[MUT_REFERENCE] = true;

    return wrappedRef;
  };

  /**
    The `mut` helper lets you __clearly specify__ that a child `Component` can update the
    (mutable) value passed to it, which will __change the value of the parent component__.
  
    To specify that a parameter is mutable, when invoking the child `Component`:
  
    ```handlebars
    {{my-child childClickCount=(mut totalClicks)}}
    ```
  
    The child `Component` can then modify the parent's value just by modifying its own
    property:
  
    ```javascript
    // my-child.js
    export default Component.extend({
      click() {
        this.incrementProperty('childClickCount');
      }
    });
    ```
  
    Note that for curly components (`{{my-component}}`) the bindings are already mutable,
    making the `mut` unnecessary.
  
    Additionally, the `mut` helper can be combined with the `action` helper to
    mutate a value. For example:
  
    ```handlebars
    {{my-child childClickCount=totalClicks click-count-change=(action (mut totalClicks))}}
    ```
  
    The child `Component` would invoke the action with the new click value:
  
    ```javascript
    // my-child.js
    export default Component.extend({
      click() {
        this.get('click-count-change')(this.get('childClickCount') + 1);
      }
    });
    ```
  
    The `mut` helper changes the `totalClicks` value to what was provided as the action argument.
  
    The `mut` helper, when used with `action`, will return a function that
    sets the value passed to `mut` to its first argument. This works like any other
    closure action and interacts with the other features `action` provides.
    As an example, we can create a button that increments a value passing the value
    directly to the `action`:
  
    ```handlebars
    {{! inc helper is not provided by Ember }}
    <button onclick={{action (mut count) (inc count)}}>
      Increment count
    </button>
    ```
  
    You can also use the `value` option:
  
    ```handlebars
    <input value={{name}} oninput={{action (mut name) value="target.value"}}>
    ```
  
    @method mut
    @param {Object} [attr] the "two-way" attribute that can be modified.
    @for Ember.Templates.helpers
    @public
  */
  /**
  @module ember
  */
  var MUT_REFERENCE = (0, _emberUtils.symbol)('MUT');
  var SOURCE = (0, _emberUtils.symbol)('SOURCE');

  function isMut(ref) {
    return ref && ref[MUT_REFERENCE];
  }

  function unMut(ref) {
    return ref[SOURCE] || ref;
  }
});
enifed('ember-glimmer/helpers/query-param', ['exports', 'ember-utils', 'ember-glimmer/utils/references', 'ember-debug', 'ember-routing'], function (exports, _emberUtils, _references, _emberDebug, _emberRouting) {
  'use strict';

  exports.default = function (vm, args) {
    return new _references.InternalHelperReference(queryParams, args.capture());
  };

  /**
    This is a helper to be used in conjunction with the link-to helper.
    It will supply url query parameters to the target route.
  
    Example
  
    ```handlebars
    {{#link-to 'posts' (query-params direction="asc")}}Sort{{/link-to}}
    ```
  
    @method query-params
    @for Ember.Templates.helpers
    @param {Object} hash takes a hash of query parameters
    @return {Object} A `QueryParams` object for `{{link-to}}`
    @public
  */
  /**
  @module ember
  */
  function queryParams(_ref) {
    var positional = _ref.positional,
        named = _ref.named;
    (true && !(positional.value().length === 0) && (0, _emberDebug.assert)('The `query-params` helper only accepts hash parameters, e.g. (query-params queryParamPropertyName=\'foo\') as opposed to just (query-params \'foo\')', positional.value().length === 0));


    return _emberRouting.QueryParams.create({
      values: (0, _emberUtils.assign)({}, named.value())
    });
  }
});
enifed('ember-glimmer/helpers/readonly', ['exports', 'ember-glimmer/utils/references', 'ember-glimmer/helpers/mut'], function (exports, _references, _mut) {
  'use strict';

  exports.default = function (vm, args) {
    var ref = (0, _mut.unMut)(args.positional.at(0));

    var wrapped = Object.create(ref);

    wrapped[_references.UPDATE] = undefined;

    return wrapped;
  };
});
enifed('ember-glimmer/helpers/unbound', ['exports', 'ember-debug', 'ember-glimmer/utils/references'], function (exports, _emberDebug, _references) {
  'use strict';

  exports.default = function (vm, args) {
    (true && !(args.positional.length === 1 && args.named.length === 0) && (0, _emberDebug.assert)('unbound helper cannot be called with multiple params or hash params', args.positional.length === 1 && args.named.length === 0));


    return _references.UnboundReference.create(args.positional.at(0).value());
  };
});
enifed('ember-glimmer/index', ['exports', 'ember-glimmer/helpers/action', 'ember-glimmer/templates/root', 'ember-glimmer/template', 'ember-glimmer/components/checkbox', 'ember-glimmer/components/text_field', 'ember-glimmer/components/text_area', 'ember-glimmer/components/link-to', 'ember-glimmer/component', 'ember-glimmer/helper', 'ember-glimmer/environment', 'ember-glimmer/utils/string', 'ember-glimmer/renderer', 'ember-glimmer/template_registry', 'ember-glimmer/setup-registry', 'ember-glimmer/dom', 'ember-glimmer/syntax', 'ember-glimmer/component-managers/abstract'], function (exports, _action, _root, _template, _checkbox, _text_field, _text_area, _linkTo, _component, _helper, _environment, _string, _renderer, _template_registry, _setupRegistry, _dom, _syntax, _abstract) {
  'use strict';

  Object.defineProperty(exports, 'INVOKE', {
    enumerable: true,
    get: function () {
      return _action.INVOKE;
    }
  });
  Object.defineProperty(exports, 'RootTemplate', {
    enumerable: true,
    get: function () {
      return _root.default;
    }
  });
  Object.defineProperty(exports, 'template', {
    enumerable: true,
    get: function () {
      return _template.default;
    }
  });
  Object.defineProperty(exports, 'Checkbox', {
    enumerable: true,
    get: function () {
      return _checkbox.default;
    }
  });
  Object.defineProperty(exports, 'TextField', {
    enumerable: true,
    get: function () {
      return _text_field.default;
    }
  });
  Object.defineProperty(exports, 'TextArea', {
    enumerable: true,
    get: function () {
      return _text_area.default;
    }
  });
  Object.defineProperty(exports, 'LinkComponent', {
    enumerable: true,
    get: function () {
      return _linkTo.default;
    }
  });
  Object.defineProperty(exports, 'Component', {
    enumerable: true,
    get: function () {
      return _component.default;
    }
  });
  Object.defineProperty(exports, 'Helper', {
    enumerable: true,
    get: function () {
      return _helper.default;
    }
  });
  Object.defineProperty(exports, 'helper', {
    enumerable: true,
    get: function () {
      return _helper.helper;
    }
  });
  Object.defineProperty(exports, 'Environment', {
    enumerable: true,
    get: function () {
      return _environment.default;
    }
  });
  Object.defineProperty(exports, 'SafeString', {
    enumerable: true,
    get: function () {
      return _string.SafeString;
    }
  });
  Object.defineProperty(exports, 'escapeExpression', {
    enumerable: true,
    get: function () {
      return _string.escapeExpression;
    }
  });
  Object.defineProperty(exports, 'htmlSafe', {
    enumerable: true,
    get: function () {
      return _string.htmlSafe;
    }
  });
  Object.defineProperty(exports, 'isHTMLSafe', {
    enumerable: true,
    get: function () {
      return _string.isHTMLSafe;
    }
  });
  Object.defineProperty(exports, '_getSafeString', {
    enumerable: true,
    get: function () {
      return _string.getSafeString;
    }
  });
  Object.defineProperty(exports, 'Renderer', {
    enumerable: true,
    get: function () {
      return _renderer.Renderer;
    }
  });
  Object.defineProperty(exports, 'InertRenderer', {
    enumerable: true,
    get: function () {
      return _renderer.InertRenderer;
    }
  });
  Object.defineProperty(exports, 'InteractiveRenderer', {
    enumerable: true,
    get: function () {
      return _renderer.InteractiveRenderer;
    }
  });
  Object.defineProperty(exports, '_resetRenderers', {
    enumerable: true,
    get: function () {
      return _renderer._resetRenderers;
    }
  });
  Object.defineProperty(exports, 'getTemplate', {
    enumerable: true,
    get: function () {
      return _template_registry.getTemplate;
    }
  });
  Object.defineProperty(exports, 'setTemplate', {
    enumerable: true,
    get: function () {
      return _template_registry.setTemplate;
    }
  });
  Object.defineProperty(exports, 'hasTemplate', {
    enumerable: true,
    get: function () {
      return _template_registry.hasTemplate;
    }
  });
  Object.defineProperty(exports, 'getTemplates', {
    enumerable: true,
    get: function () {
      return _template_registry.getTemplates;
    }
  });
  Object.defineProperty(exports, 'setTemplates', {
    enumerable: true,
    get: function () {
      return _template_registry.setTemplates;
    }
  });
  Object.defineProperty(exports, 'setupEngineRegistry', {
    enumerable: true,
    get: function () {
      return _setupRegistry.setupEngineRegistry;
    }
  });
  Object.defineProperty(exports, 'setupApplicationRegistry', {
    enumerable: true,
    get: function () {
      return _setupRegistry.setupApplicationRegistry;
    }
  });
  Object.defineProperty(exports, 'DOMChanges', {
    enumerable: true,
    get: function () {
      return _dom.DOMChanges;
    }
  });
  Object.defineProperty(exports, 'NodeDOMTreeConstruction', {
    enumerable: true,
    get: function () {
      return _dom.NodeDOMTreeConstruction;
    }
  });
  Object.defineProperty(exports, 'DOMTreeConstruction', {
    enumerable: true,
    get: function () {
      return _dom.DOMTreeConstruction;
    }
  });
  Object.defineProperty(exports, '_registerMacros', {
    enumerable: true,
    get: function () {
      return _syntax.registerMacros;
    }
  });
  Object.defineProperty(exports, '_experimentalMacros', {
    enumerable: true,
    get: function () {
      return _syntax.experimentalMacros;
    }
  });
  Object.defineProperty(exports, 'AbstractComponentManager', {
    enumerable: true,
    get: function () {
      return _abstract.default;
    }
  });
});
enifed('ember-glimmer/modifiers/action', ['exports', 'ember-babel', 'ember-utils', 'ember-metal', 'ember-debug', 'ember-views', 'ember-glimmer/helpers/action'], function (exports, _emberBabel, _emberUtils, _emberMetal, _emberDebug, _emberViews, _action) {
  'use strict';

  exports.ActionState = exports.ActionHelper = undefined;


  var MODIFIERS = ['alt', 'shift', 'meta', 'ctrl'];
  var POINTER_EVENT_TYPE_REGEX = /^click|mouse|touch/;

  function isAllowedEvent(event, allowedKeys) {
    if (allowedKeys === null || allowedKeys === undefined) {
      if (POINTER_EVENT_TYPE_REGEX.test(event.type)) {
        return (0, _emberViews.isSimpleClick)(event);
      } else {
        allowedKeys = '';
      }
    }

    if (allowedKeys.indexOf('any') >= 0) {
      return true;
    }

    for (var i = 0; i < MODIFIERS.length; i++) {
      if (event[MODIFIERS[i] + 'Key'] && allowedKeys.indexOf(MODIFIERS[i]) === -1) {
        return false;
      }
    }

    return true;
  }

  var ActionHelper = exports.ActionHelper = {
    // registeredActions is re-exported for compatibility with older plugins
    // that were using this undocumented API.
    registeredActions: _emberViews.ActionManager.registeredActions,

    registerAction: function (actionState) {
      var actionId = actionState.actionId;


      _emberViews.ActionManager.registeredActions[actionId] = actionState;

      return actionId;
    },
    unregisterAction: function (actionState) {
      var actionId = actionState.actionId;


      delete _emberViews.ActionManager.registeredActions[actionId];
    }
  };

  var ActionState = exports.ActionState = function () {
    function ActionState(element, actionId, actionName, actionArgs, namedArgs, positionalArgs, implicitTarget, dom) {
      (0, _emberBabel.classCallCheck)(this, ActionState);

      this.element = element;
      this.actionId = actionId;
      this.actionName = actionName;
      this.actionArgs = actionArgs;
      this.namedArgs = namedArgs;
      this.positional = positionalArgs;
      this.implicitTarget = implicitTarget;
      this.dom = dom;
      this.eventName = this.getEventName();
    }

    ActionState.prototype.getEventName = function getEventName() {
      return this.namedArgs.get('on').value() || 'click';
    };

    ActionState.prototype.getActionArgs = function getActionArgs() {
      var result = new Array(this.actionArgs.length);

      for (var i = 0; i < this.actionArgs.length; i++) {
        result[i] = this.actionArgs[i].value();
      }

      return result;
    };

    ActionState.prototype.getTarget = function getTarget() {
      var implicitTarget = this.implicitTarget,
          namedArgs = this.namedArgs;

      var target = void 0;

      if (namedArgs.has('target')) {
        target = namedArgs.get('target').value();
      } else {
        target = implicitTarget.value();
      }

      return target;
    };

    ActionState.prototype.handler = function handler(event) {
      var _this = this;

      var actionName = this.actionName,
          namedArgs = this.namedArgs;

      var bubbles = namedArgs.get('bubbles');
      var preventDefault = namedArgs.get('preventDefault');
      var allowedKeys = namedArgs.get('allowedKeys');
      var target = this.getTarget();

      if (!isAllowedEvent(event, allowedKeys.value())) {
        return true;
      }

      if (preventDefault.value() !== false) {
        event.preventDefault();
      }

      if (bubbles.value() === false) {
        event.stopPropagation();
      }

      (0, _emberMetal.run)(function () {
        var args = _this.getActionArgs();
        var payload = {
          args: args,
          target: target
        };
        if (typeof actionName[_action.INVOKE] === 'function') {
          (0, _emberMetal.flaggedInstrument)('interaction.ember-action', payload, function () {
            actionName[_action.INVOKE].apply(actionName, args);
          });
          return;
        }
        if (typeof actionName === 'function') {
          (0, _emberMetal.flaggedInstrument)('interaction.ember-action', payload, function () {
            actionName.apply(target, args);
          });
          return;
        }
        payload.name = actionName;
        if (target.send) {
          (0, _emberMetal.flaggedInstrument)('interaction.ember-action', payload, function () {
            target.send.apply(target, [actionName].concat(args));
          });
        } else {
          (true && !(typeof target[actionName] === 'function') && (0, _emberDebug.assert)('The action \'' + actionName + '\' did not exist on ' + target, typeof target[actionName] === 'function'));

          (0, _emberMetal.flaggedInstrument)('interaction.ember-action', payload, function () {
            target[actionName].apply(target, args);
          });
        }
      });
    };

    ActionState.prototype.destroy = function destroy() {
      ActionHelper.unregisterAction(this);
    };

    return ActionState;
  }();

  var ActionModifierManager = function () {
    function ActionModifierManager() {
      (0, _emberBabel.classCallCheck)(this, ActionModifierManager);
    }

    ActionModifierManager.prototype.create = function create(element, args, dynamicScope, dom) {
      var _args$capture = args.capture(),
          named = _args$capture.named,
          positional = _args$capture.positional;

      var implicitTarget = void 0;
      var actionName = void 0;
      var actionNameRef = void 0;
      if (positional.length > 1) {
        implicitTarget = positional.at(0);
        actionNameRef = positional.at(1);

        if (actionNameRef[_action.INVOKE]) {
          actionName = actionNameRef;
        } else {
          var actionLabel = actionNameRef._propertyKey;
          actionName = actionNameRef.value();

          (true && !(typeof actionName === 'string' || typeof actionName === 'function') && (0, _emberDebug.assert)('You specified a quoteless path, `' + actionLabel + '`, to the ' + '{{action}} helper which did not resolve to an action name (a ' + 'string). Perhaps you meant to use a quoted actionName? (e.g. ' + '{{action "' + actionLabel + '"}}).', typeof actionName === 'string' || typeof actionName === 'function'));
        }
      }

      var actionArgs = [];
      // The first two arguments are (1) `this` and (2) the action name.
      // Everything else is a param.
      for (var i = 2; i < positional.length; i++) {
        actionArgs.push(positional.at(i));
      }

      var actionId = (0, _emberUtils.uuid)();
      return new ActionState(element, actionId, actionName, actionArgs, named, positional, implicitTarget, dom);
    };

    ActionModifierManager.prototype.install = function install(actionState) {
      var dom = actionState.dom,
          element = actionState.element,
          actionId = actionState.actionId;


      ActionHelper.registerAction(actionState);

      dom.setAttribute(element, 'data-ember-action', '');
      dom.setAttribute(element, 'data-ember-action-' + actionId, actionId);
    };

    ActionModifierManager.prototype.update = function update(actionState) {
      var positional = actionState.positional;

      var actionNameRef = positional.at(1);

      if (!actionNameRef[_action.INVOKE]) {
        actionState.actionName = actionNameRef.value();
      }

      actionState.eventName = actionState.getEventName();
    };

    ActionModifierManager.prototype.getDestructor = function getDestructor(modifier) {
      return modifier;
    };

    return ActionModifierManager;
  }();

  exports.default = ActionModifierManager;
});
enifed('ember-glimmer/protocol-for-url', ['exports', 'ember-environment', 'node-module'], function (exports, _emberEnvironment, _nodeModule) {
  'use strict';

  exports.default = installProtocolForURL;
  /* globals module, URL */

  var nodeURL = void 0;
  var parsingNode = void 0;

  function installProtocolForURL(environment) {
    var protocol = void 0;

    if (_emberEnvironment.environment.hasDOM) {
      protocol = browserProtocolForURL.call(environment, 'foobar:baz');
    }

    // Test to see if our DOM implementation parses
    // and normalizes URLs.
    if (protocol === 'foobar:') {
      // Swap in the method that doesn't do this test now that
      // we know it works.
      environment.protocolForURL = browserProtocolForURL;
    } else if (typeof URL === 'object') {
      // URL globally provided, likely from FastBoot's sandbox
      nodeURL = URL;
      environment.protocolForURL = nodeProtocolForURL;
    } else if (_nodeModule.IS_NODE) {
      // Otherwise, we need to fall back to our own URL parsing.
      // Global `require` is shadowed by Ember's loader so we have to use the fully
      // qualified `module.require`.
      nodeURL = (0, _nodeModule.require)('url');
      environment.protocolForURL = nodeProtocolForURL;
    } else {
      throw new Error('Could not find valid URL parsing mechanism for URL Sanitization');
    }
  }

  function browserProtocolForURL(url) {
    if (!parsingNode) {
      parsingNode = document.createElement('a');
    }

    parsingNode.href = url;
    return parsingNode.protocol;
  }

  function nodeProtocolForURL(url) {
    var protocol = null;
    if (typeof url === 'string') {
      protocol = nodeURL.parse(url).protocol;
    }
    return protocol === null ? ':' : protocol;
  }
});
enifed('ember-glimmer/renderer', ['exports', 'ember-babel', 'ember-glimmer/utils/references', 'ember-metal', '@glimmer/reference', 'ember-views', 'ember-glimmer/component', 'ember-glimmer/component-managers/root', 'ember-glimmer/component-managers/outlet', 'ember-debug'], function (exports, _emberBabel, _references, _emberMetal, _reference, _emberViews, _component, _root2, _outlet, _emberDebug) {
  'use strict';

  exports.InteractiveRenderer = exports.InertRenderer = undefined;
  exports._resetRenderers = _resetRenderers;
  var backburner = _emberMetal.run.backburner;

  var DynamicScope = function () {
    function DynamicScope(view, outletState, rootOutletState, targetObject) {
      (0, _emberBabel.classCallCheck)(this, DynamicScope);

      this.view = view;
      this.outletState = outletState;
      this.rootOutletState = rootOutletState;
    }

    DynamicScope.prototype.child = function child() {
      return new DynamicScope(this.view, this.outletState, this.rootOutletState);
    };

    DynamicScope.prototype.get = function get(key) {
      (true && !(key === 'outletState') && (0, _emberDebug.assert)('Using `-get-dynamic-scope` is only supported for `outletState` (you used `' + key + '`).', key === 'outletState'));

      return this.outletState;
    };

    DynamicScope.prototype.set = function set(key, value) {
      (true && !(key === 'outletState') && (0, _emberDebug.assert)('Using `-with-dynamic-scope` is only supported for `outletState` (you used `' + key + '`).', key === 'outletState'));

      this.outletState = value;
      return value;
    };

    return DynamicScope;
  }();

  var RootState = function () {
    function RootState(root, env, template, self, parentElement, dynamicScope) {
      var _this = this;

      (0, _emberBabel.classCallCheck)(this, RootState);
      (true && !(template) && (0, _emberDebug.assert)('You cannot render `' + self.value() + '` without a template.', template));


      this.id = (0, _emberViews.getViewId)(root);
      this.env = env;
      this.root = root;
      this.result = undefined;
      this.shouldReflush = false;
      this.destroyed = false;
      this._removing = false;

      var options = this.options = {
        alwaysRevalidate: false
      };

      this.render = function () {
        var iterator = template.render(self, parentElement, dynamicScope);
        var iteratorResult = void 0;

        do {
          iteratorResult = iterator.next();
        } while (!iteratorResult.done);

        var result = _this.result = iteratorResult.value;

        // override .render function after initial render
        _this.render = function () {
          return result.rerender(options);
        };
      };
    }

    RootState.prototype.isFor = function isFor(possibleRoot) {
      return this.root === possibleRoot;
    };

    RootState.prototype.destroy = function destroy() {
      var result = this.result,
          env = this.env;


      this.destroyed = true;

      this.env = null;
      this.root = null;
      this.result = null;
      this.render = null;

      if (result) {
        /*
         Handles these scenarios:
          * When roots are removed during standard rendering process, a transaction exists already
           `.begin()` / `.commit()` are not needed.
         * When roots are being destroyed manually (`component.append(); component.destroy() case), no
           transaction exists already.
         * When roots are being destroyed during `Renderer#destroy`, no transaction exists
          */
        var needsTransaction = !env.inTransaction;

        if (needsTransaction) {
          env.begin();
        }

        result.destroy();

        if (needsTransaction) {
          env.commit();
        }
      }
    };

    return RootState;
  }();

  var renderers = [];

  function _resetRenderers() {
    renderers.length = 0;
  }

  (0, _emberMetal.setHasViews)(function () {
    return renderers.length > 0;
  });

  function register(renderer) {
    (true && !(renderers.indexOf(renderer) === -1) && (0, _emberDebug.assert)('Cannot register the same renderer twice', renderers.indexOf(renderer) === -1));

    renderers.push(renderer);
  }

  function deregister(renderer) {
    var index = renderers.indexOf(renderer);
    (true && !(index !== -1) && (0, _emberDebug.assert)('Cannot deregister unknown unregistered renderer', index !== -1));

    renderers.splice(index, 1);
  }

  function loopBegin() {
    for (var i = 0; i < renderers.length; i++) {
      renderers[i]._scheduleRevalidate();
    }
  }

  function K() {}

  var loops = 0;
  function loopEnd(current, next) {
    for (var i = 0; i < renderers.length; i++) {
      if (!renderers[i]._isValid()) {
        if (loops > 10) {
          loops = 0;
          // TODO: do something better
          renderers[i].destroy();
          throw new Error('infinite rendering invalidation detected');
        }
        loops++;
        return backburner.join(null, K);
      }
    }
    loops = 0;
  }

  backburner.on('begin', loopBegin);
  backburner.on('end', loopEnd);

  var Renderer = function () {
    function Renderer(env, rootTemplate) {
      var _viewRegistry = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : _emberViews.fallbackViewRegistry;

      var destinedForDOM = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
      (0, _emberBabel.classCallCheck)(this, Renderer);

      this._env = env;
      this._rootTemplate = rootTemplate;
      this._viewRegistry = _viewRegistry;
      this._destinedForDOM = destinedForDOM;
      this._destroyed = false;
      this._roots = [];
      this._lastRevision = null;
      this._isRenderingRoots = false;
      this._removedRoots = [];
    }

    // renderer HOOKS

    Renderer.prototype.appendOutletView = function appendOutletView(view, target) {
      var definition = new _outlet.TopLevelOutletComponentDefinition(view);
      var outletStateReference = view.toReference();
      var targetObject = view.outletState.render.controller;

      this._appendDefinition(view, definition, target, outletStateReference, targetObject);
    };

    Renderer.prototype.appendTo = function appendTo(view, target) {
      var rootDef = new _root2.RootComponentDefinition(view);

      this._appendDefinition(view, rootDef, target);
    };

    Renderer.prototype._appendDefinition = function _appendDefinition(root, definition, target) {
      var outletStateReference = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : _reference.UNDEFINED_REFERENCE;
      var targetObject = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : null;

      var self = new _references.RootReference(definition);
      var dynamicScope = new DynamicScope(null, outletStateReference, outletStateReference, true, targetObject);
      var rootState = new RootState(root, this._env, this._rootTemplate, self, target, dynamicScope);

      this._renderRoot(rootState);
    };

    Renderer.prototype.rerender = function rerender(view) {
      this._scheduleRevalidate();
    };

    Renderer.prototype.register = function register(view) {
      var id = (0, _emberViews.getViewId)(view);
      (true && !(!this._viewRegistry[id]) && (0, _emberDebug.assert)('Attempted to register a view with an id already in use: ' + id, !this._viewRegistry[id]));

      this._viewRegistry[id] = view;
    };

    Renderer.prototype.unregister = function unregister(view) {
      delete this._viewRegistry[(0, _emberViews.getViewId)(view)];
    };

    Renderer.prototype.remove = function remove(view) {
      view._transitionTo('destroying');

      this.cleanupRootFor(view);

      (0, _emberViews.setViewElement)(view, null);

      if (this._destinedForDOM) {
        view.trigger('didDestroyElement');
      }

      if (!view.isDestroying) {
        view.destroy();
      }
    };

    Renderer.prototype.cleanupRootFor = function cleanupRootFor(view) {
      // no need to cleanup roots if we have already been destroyed
      if (this._destroyed) {
        return;
      }

      var roots = this._roots;

      // traverse in reverse so we can remove items
      // without mucking up the index
      var i = this._roots.length;
      while (i--) {
        var root = roots[i];
        if (root.isFor(view)) {
          root.destroy();
          roots.splice(i, 1);
        }
      }
    };

    Renderer.prototype.destroy = function destroy() {
      if (this._destroyed) {
        return;
      }
      this._destroyed = true;
      this._clearAllRoots();
    };

    Renderer.prototype.getElement = function getElement(view) {
      // overridden in the subclasses
    };

    Renderer.prototype.getBounds = function getBounds(view) {
      var bounds = view[_component.BOUNDS];

      var parentElement = bounds.parentElement();
      var firstNode = bounds.firstNode();
      var lastNode = bounds.lastNode();

      return { parentElement: parentElement, firstNode: firstNode, lastNode: lastNode };
    };

    Renderer.prototype.createElement = function createElement(tagName) {
      return this._env.getAppendOperations().createElement(tagName);
    };

    Renderer.prototype._renderRoot = function _renderRoot(root) {
      var roots = this._roots;


      roots.push(root);

      if (roots.length === 1) {
        register(this);
      }

      this._renderRootsTransaction();
    };

    Renderer.prototype._renderRoots = function _renderRoots() {
      var roots = this._roots,
          env = this._env,
          removedRoots = this._removedRoots;

      var globalShouldReflush = void 0,
          initialRootsLength = void 0;

      do {
        env.begin();

        // ensure that for the first iteration of the loop
        // each root is processed
        initialRootsLength = roots.length;
        globalShouldReflush = false;

        for (var i = 0; i < roots.length; i++) {
          var root = roots[i];

          if (root.destroyed) {
            // add to the list of roots to be removed
            // they will be removed from `this._roots` later
            removedRoots.push(root);

            // skip over roots that have been marked as destroyed
            continue;
          }

          var shouldReflush = root.shouldReflush;


          // when processing non-initial reflush loops,
          // do not process more roots than needed
          if (i >= initialRootsLength && !shouldReflush) {
            continue;
          }

          root.options.alwaysRevalidate = shouldReflush;
          // track shouldReflush based on this roots render result
          shouldReflush = root.shouldReflush = (0, _emberMetal.runInTransaction)(root, 'render');

          // globalShouldReflush should be `true` if *any* of
          // the roots need to reflush
          globalShouldReflush = globalShouldReflush || shouldReflush;
        }

        this._lastRevision = _reference.CURRENT_TAG.value();

        env.commit();
      } while (globalShouldReflush || roots.length > initialRootsLength);

      // remove any roots that were destroyed during this transaction
      while (removedRoots.length) {
        var _root = removedRoots.pop();

        var rootIndex = roots.indexOf(_root);
        roots.splice(rootIndex, 1);
      }

      if (this._roots.length === 0) {
        deregister(this);
      }
    };

    Renderer.prototype._renderRootsTransaction = function _renderRootsTransaction() {
      if (this._isRenderingRoots) {
        // currently rendering roots, a new root was added and will
        // be processed by the existing _renderRoots invocation
        return;
      }

      // used to prevent calling _renderRoots again (see above)
      // while we are actively rendering roots
      this._isRenderingRoots = true;

      var completedWithoutError = false;
      try {
        this._renderRoots();
        completedWithoutError = true;
      } finally {
        if (!completedWithoutError) {
          this._lastRevision = _reference.CURRENT_TAG.value();
          if (this._env.inTransaction === true) {
            this._env.commit();
          }
        }
        this._isRenderingRoots = false;
      }
    };

    Renderer.prototype._clearAllRoots = function _clearAllRoots() {
      var roots = this._roots;
      for (var i = 0; i < roots.length; i++) {
        var root = roots[i];
        root.destroy();
      }

      this._removedRoots.length = 0;
      this._roots = null;

      // if roots were present before destroying
      // deregister this renderer instance
      if (roots.length) {
        deregister(this);
      }
    };

    Renderer.prototype._scheduleRevalidate = function _scheduleRevalidate() {
      backburner.scheduleOnce('render', this, this._revalidate);
    };

    Renderer.prototype._isValid = function _isValid() {
      return this._destroyed || this._roots.length === 0 || _reference.CURRENT_TAG.validate(this._lastRevision);
    };

    Renderer.prototype._revalidate = function _revalidate() {
      if (this._isValid()) {
        return;
      }
      this._renderRootsTransaction();
    };

    return Renderer;
  }();

  var InertRenderer = exports.InertRenderer = function (_Renderer) {
    (0, _emberBabel.inherits)(InertRenderer, _Renderer);

    function InertRenderer() {
      (0, _emberBabel.classCallCheck)(this, InertRenderer);
      return (0, _emberBabel.possibleConstructorReturn)(this, _Renderer.apply(this, arguments));
    }

    InertRenderer.create = function create(_ref) {
      var env = _ref.env,
          rootTemplate = _ref.rootTemplate,
          _viewRegistry = _ref._viewRegistry;

      return new this(env, rootTemplate, _viewRegistry, false);
    };

    InertRenderer.prototype.getElement = function getElement(view) {
      throw new Error('Accessing `this.element` is not allowed in non-interactive environments (such as FastBoot).');
    };

    return InertRenderer;
  }(Renderer);

  var InteractiveRenderer = exports.InteractiveRenderer = function (_Renderer2) {
    (0, _emberBabel.inherits)(InteractiveRenderer, _Renderer2);

    function InteractiveRenderer() {
      (0, _emberBabel.classCallCheck)(this, InteractiveRenderer);
      return (0, _emberBabel.possibleConstructorReturn)(this, _Renderer2.apply(this, arguments));
    }

    InteractiveRenderer.create = function create(_ref2) {
      var env = _ref2.env,
          rootTemplate = _ref2.rootTemplate,
          _viewRegistry = _ref2._viewRegistry;

      return new this(env, rootTemplate, _viewRegistry, true);
    };

    InteractiveRenderer.prototype.getElement = function getElement(view) {
      return (0, _emberViews.getViewElement)(view);
    };

    return InteractiveRenderer;
  }(Renderer);
});
enifed('ember-glimmer/setup-registry', ['exports', 'ember-babel', 'ember-environment', 'container', 'ember-glimmer/renderer', 'ember-glimmer/dom', 'ember-glimmer/views/outlet', 'ember-glimmer/components/text_field', 'ember-glimmer/components/text_area', 'ember-glimmer/components/checkbox', 'ember-glimmer/components/link-to', 'ember-glimmer/component', 'ember-glimmer/templates/component', 'ember-glimmer/templates/root', 'ember-glimmer/templates/outlet', 'ember-glimmer/environment'], function (exports, _emberBabel, _emberEnvironment, _container, _renderer, _dom, _outlet, _text_field, _text_area, _checkbox, _linkTo, _component, _component2, _root, _outlet2, _environment) {
  'use strict';

  exports.setupApplicationRegistry = setupApplicationRegistry;
  exports.setupEngineRegistry = setupEngineRegistry;

  var _templateObject = (0, _emberBabel.taggedTemplateLiteralLoose)(['template:-root'], ['template:-root']),
      _templateObject2 = (0, _emberBabel.taggedTemplateLiteralLoose)(['template:components/-default'], ['template:components/-default']),
      _templateObject3 = (0, _emberBabel.taggedTemplateLiteralLoose)(['component:-default'], ['component:-default']);

  function setupApplicationRegistry(registry) {
    registry.injection('service:-glimmer-environment', 'appendOperations', 'service:-dom-tree-construction');
    registry.injection('renderer', 'env', 'service:-glimmer-environment');

    registry.register((0, _container.privatize)(_templateObject), _root.default);
    registry.injection('renderer', 'rootTemplate', (0, _container.privatize)(_templateObject));

    registry.register('renderer:-dom', _renderer.InteractiveRenderer);
    registry.register('renderer:-inert', _renderer.InertRenderer);

    if (_emberEnvironment.environment.hasDOM) {
      registry.injection('service:-glimmer-environment', 'updateOperations', 'service:-dom-changes');
    }

    registry.register('service:-dom-changes', {
      create: function (_ref) {
        var document = _ref.document;

        return new _dom.DOMChanges(document);
      }
    });

    registry.register('service:-dom-tree-construction', {
      create: function (_ref2) {
        var document = _ref2.document;

        var Implementation = _emberEnvironment.environment.hasDOM ? _dom.DOMTreeConstruction : _dom.NodeDOMTreeConstruction;
        return new Implementation(document);
      }
    });
  }

  function setupEngineRegistry(registry) {
    registry.register('view:-outlet', _outlet.default);
    registry.register('template:-outlet', _outlet2.default);
    registry.injection('view:-outlet', 'template', 'template:-outlet');

    registry.injection('service:-dom-changes', 'document', 'service:-document');
    registry.injection('service:-dom-tree-construction', 'document', 'service:-document');

    registry.register((0, _container.privatize)(_templateObject2), _component2.default);

    registry.register('service:-glimmer-environment', _environment.default);
    registry.injection('template', 'env', 'service:-glimmer-environment');

    registry.optionsForType('helper', { instantiate: false });

    registry.register('component:-text-field', _text_field.default);
    registry.register('component:-text-area', _text_area.default);
    registry.register('component:-checkbox', _checkbox.default);
    registry.register('component:link-to', _linkTo.default);
    registry.register((0, _container.privatize)(_templateObject3), _component.default);
  }
});
enifed('ember-glimmer/syntax', ['exports', 'ember-glimmer/syntax/render', 'ember-glimmer/syntax/outlet', 'ember-glimmer/syntax/mount', 'ember-glimmer/syntax/dynamic-component', 'ember-glimmer/utils/bindings', 'ember-glimmer/syntax/input', 'ember-glimmer/syntax/-text-area', 'ember-glimmer/syntax/utils', 'ember-debug'], function (exports, _render, _outlet, _mount, _dynamicComponent, _bindings, _input, _textArea, _utils, _emberDebug) {
  'use strict';

  exports.experimentalMacros = undefined;
  exports.registerMacros = registerMacros;
  exports.populateMacros = populateMacros;


  function refineInlineSyntax(name, params, hash, builder) {
    (true && !(!(builder.env.builtInHelpers[name] && builder.env.owner.hasRegistration('helper:' + name))) && (0, _emberDebug.assert)('You attempted to overwrite the built-in helper "' + name + '" which is not allowed. Please rename the helper.', !(builder.env.builtInHelpers[name] && builder.env.owner.hasRegistration('helper:' + name))));


    var definition = void 0;
    if (name.indexOf('-') > -1) {
      definition = builder.env.getComponentDefinition(name, builder.meta.templateMeta);
    }

    if (definition) {
      (0, _bindings.wrapComponentClassAttribute)(hash);
      builder.component.static(definition, [params, (0, _utils.hashToArgs)(hash), null, null]);
      return true;
    }

    return false;
  }

  function refineBlockSyntax(name, params, hash, _default, inverse, builder) {
    if (name.indexOf('-') === -1) {
      return false;
    }

    var meta = builder.meta.templateMeta;

    var definition = void 0;
    if (name.indexOf('-') > -1) {
      definition = builder.env.getComponentDefinition(name, meta);
    }

    if (definition) {
      (0, _bindings.wrapComponentClassAttribute)(hash);
      builder.component.static(definition, [params, (0, _utils.hashToArgs)(hash), _default, inverse]);
      return true;
    }

    (true && !(builder.env.hasHelper(name, meta)) && (0, _emberDebug.assert)('A component or helper named "' + name + '" could not be found', builder.env.hasHelper(name, meta)));
    (true && !(!builder.env.hasHelper(name, meta)) && (0, _emberDebug.assert)('Helpers may not be used in the block form, for example {{#' + name + '}}{{/' + name + '}}. Please use a component, or alternatively use the helper in combination with a built-in Ember helper, for example {{#if (' + name + ')}}{{/if}}.', !builder.env.hasHelper(name, meta)));


    return false;
  }

  var experimentalMacros = exports.experimentalMacros = [];

  // This is a private API to allow for experimental macros
  // to be created in user space. Registering a macro should
  // should be done in an initializer.
  function registerMacros(macro) {
    experimentalMacros.push(macro);
  }

  function populateMacros(blocks, inlines) {
    inlines.add('outlet', _outlet.outletMacro);
    inlines.add('component', _dynamicComponent.inlineComponentMacro);
    inlines.add('render', _render.renderMacro);
    inlines.add('mount', _mount.mountMacro);
    inlines.add('input', _input.inputMacro);
    inlines.add('textarea', _textArea.textAreaMacro);
    inlines.addMissing(refineInlineSyntax);
    blocks.add('component', _dynamicComponent.blockComponentMacro);
    blocks.addMissing(refineBlockSyntax);

    for (var i = 0; i < experimentalMacros.length; i++) {
      var macro = experimentalMacros[i];
      macro(blocks, inlines);
    }

    return { blocks: blocks, inlines: inlines };
  }
});
enifed('ember-glimmer/syntax/-text-area', ['exports', 'ember-glimmer/utils/bindings', 'ember-glimmer/syntax/utils'], function (exports, _bindings, _utils) {
  'use strict';

  exports.textAreaMacro = textAreaMacro;
  function textAreaMacro(name, params, hash, builder) {
    var definition = builder.env.getComponentDefinition('-text-area', builder.meta.templateMeta);
    (0, _bindings.wrapComponentClassAttribute)(hash);
    builder.component.static(definition, [params, (0, _utils.hashToArgs)(hash), null, null]);
    return true;
  }
});
enifed('ember-glimmer/syntax/dynamic-component', ['exports', 'ember-babel', '@glimmer/runtime', '@glimmer/reference', 'ember-debug', 'ember-glimmer/syntax/utils'], function (exports, _emberBabel, _runtime, _reference, _emberDebug, _utils) {
  'use strict';

  exports.dynamicComponentMacro = dynamicComponentMacro;
  exports.blockComponentMacro = blockComponentMacro;
  exports.inlineComponentMacro = inlineComponentMacro;


  function dynamicComponentFor(vm, args, meta) {
    var env = vm.env;
    var nameRef = args.positional.at(0);

    return new DynamicComponentReference({ nameRef: nameRef, env: env, meta: meta });
  }

  function dynamicComponentMacro(params, hash, _default, inverse, builder) {
    var definitionArgs = [params.slice(0, 1), null, null, null];
    var args = [params.slice(1), (0, _utils.hashToArgs)(hash), null, null];
    builder.component.dynamic(definitionArgs, dynamicComponentFor, args);
    return true;
  }

  function blockComponentMacro(params, hash, _default, inverse, builder) {
    var definitionArgs = [params.slice(0, 1), null, null, null];
    var args = [params.slice(1), (0, _utils.hashToArgs)(hash), _default, inverse];
    builder.component.dynamic(definitionArgs, dynamicComponentFor, args);
    return true;
  }

  function inlineComponentMacro(name, params, hash, builder) {
    var definitionArgs = [params.slice(0, 1), null, null, null];
    var args = [params.slice(1), (0, _utils.hashToArgs)(hash), null, null];
    builder.component.dynamic(definitionArgs, dynamicComponentFor, args);
    return true;
  }

  var DynamicComponentReference = function () {
    function DynamicComponentReference(_ref) {
      var nameRef = _ref.nameRef,
          env = _ref.env,
          meta = _ref.meta,
          args = _ref.args;
      (0, _emberBabel.classCallCheck)(this, DynamicComponentReference);

      this.tag = nameRef.tag;
      this.nameRef = nameRef;
      this.env = env;
      this.meta = meta;
      this.args = args;
    }

    DynamicComponentReference.prototype.value = function value() {
      var env = this.env,
          nameRef = this.nameRef,
          meta = this.meta;

      var nameOrDef = nameRef.value();

      if (typeof nameOrDef === 'string') {
        var definition = env.getComponentDefinition(nameOrDef, meta);

        (true && !(definition) && (0, _emberDebug.assert)('Could not find component named "' + nameOrDef + '" (no component or template with that name was found)', definition));


        return definition;
      } else if ((0, _runtime.isComponentDefinition)(nameOrDef)) {
        return nameOrDef;
      } else {
        return null;
      }
    };

    DynamicComponentReference.prototype.get = function get() {
      return _reference.UNDEFINED_REFERENCE;
    };

    return DynamicComponentReference;
  }();
});
enifed('ember-glimmer/syntax/input', ['exports', 'ember-debug', 'ember-glimmer/utils/bindings', 'ember-glimmer/syntax/dynamic-component', 'ember-glimmer/syntax/utils'], function (exports, _emberDebug, _bindings, _dynamicComponent, _utils) {
  'use strict';

  exports.inputMacro = inputMacro;
  /**
  @module ember
  */
  function buildSyntax(type, params, hash, builder) {
    var definition = builder.env.getComponentDefinition(type, builder.meta.templateMeta);
    builder.component.static(definition, [params, (0, _utils.hashToArgs)(hash), null, null]);
    return true;
  }

  /**
    The `{{input}}` helper lets you create an HTML `<input />` component.
    It causes an `TextField` component to be rendered.  For more info,
    see the [TextField](/api/classes/Ember.TextField.html) docs and
    the [templates guide](https://emberjs.com/guides/templates/input-helpers/).
  
    ```handlebars
    {{input value="987"}}
    ```
  
    renders as:
  
    ```HTML
    <input type="text" value="987" />
    ```
  
    ### Text field
  
    If no `type` option is specified, a default of type 'text' is used.
    Many of the standard HTML attributes may be passed to this helper.
    <table>
      <tr><td>`readonly`</td><td>`required`</td><td>`autofocus`</td></tr>
      <tr><td>`value`</td><td>`placeholder`</td><td>`disabled`</td></tr>
      <tr><td>`size`</td><td>`tabindex`</td><td>`maxlength`</td></tr>
      <tr><td>`name`</td><td>`min`</td><td>`max`</td></tr>
      <tr><td>`pattern`</td><td>`accept`</td><td>`autocomplete`</td></tr>
      <tr><td>`autosave`</td><td>`formaction`</td><td>`formenctype`</td></tr>
      <tr><td>`formmethod`</td><td>`formnovalidate`</td><td>`formtarget`</td></tr>
      <tr><td>`height`</td><td>`inputmode`</td><td>`multiple`</td></tr>
      <tr><td>`step`</td><td>`width`</td><td>`form`</td></tr>
      <tr><td>`selectionDirection`</td><td>`spellcheck`</td><td>&nbsp;</td></tr>
    </table>
    When set to a quoted string, these values will be directly applied to the HTML
    element. When left unquoted, these values will be bound to a property on the
    template's current rendering context (most typically a controller instance).
    A very common use of this helper is to bind the `value` of an input to an Object's attribute:
  
    ```handlebars
    Search:
    {{input value=searchWord}}
    ```
  
    In this example, the initial value in the `<input />` will be set to the value of `searchWord`.
    If the user changes the text, the value of `searchWord` will also be updated.
  
    ### Actions
  
    The helper can send multiple actions based on user events.
    The action property defines the action which is sent when
    the user presses the return key.
  
    ```handlebars
    {{input action="submit"}}
    ```
  
    The helper allows some user events to send actions.
  
    * `enter`
    * `insert-newline`
    * `escape-press`
    * `focus-in`
    * `focus-out`
    * `key-press`
    * `key-up`
  
    For example, if you desire an action to be sent when the input is blurred,
    you only need to setup the action name to the event name property.
  
    ```handlebars
    {{input focus-out="alertMessage"}}
    ```
    See more about [Text Support Actions](/api/classes/Ember.TextField.html)
  
    ### Extending `TextField`
  
    Internally, `{{input type="text"}}` creates an instance of `TextField`, passing
    arguments from the helper to `TextField`'s `create` method. You can extend the
    capabilities of text inputs in your applications by reopening this class. For example,
    if you are building a Bootstrap project where `data-*` attributes are used, you
    can add one to the `TextField`'s `attributeBindings` property:
  
    ```javascript
    import TextField from '@ember/component/text-field';
    TextField.reopen({
      attributeBindings: ['data-error']
    });
    ```
  
    Keep in mind when writing `TextField` subclasses that `TextField`
    itself extends `Component`. Expect isolated component semantics, not
    legacy 1.x view semantics (like `controller` being present).
    See more about [Ember components](/api/classes/Ember.Component.html)
  
    ### Checkbox
  
    Checkboxes are special forms of the `{{input}}` helper.  To create a `<checkbox />`:
  
    ```handlebars
    Emberize Everything:
    {{input type="checkbox" name="isEmberized" checked=isEmberized}}
    ```
  
    This will bind checked state of this checkbox to the value of `isEmberized`  -- if either one changes,
    it will be reflected in the other.
  
    The following HTML attributes can be set via the helper:
  
    * `checked`
    * `disabled`
    * `tabindex`
    * `indeterminate`
    * `name`
    * `autofocus`
    * `form`
  
    ### Extending `Checkbox`
  
    Internally, `{{input type="checkbox"}}` creates an instance of `Checkbox`, passing
    arguments from the helper to `Checkbox`'s `create` method. You can extend the
    capablilties of checkbox inputs in your applications by reopening this class. For example,
    if you wanted to add a css class to all checkboxes in your application:
  
    ```javascript
    import Checkbox from '@ember/component/checkbox';
  
    Checkbox.reopen({
      classNames: ['my-app-checkbox']
    });
    ```
  
    @method input
    @for Ember.Templates.helpers
    @param {Hash} options
    @public
  */

  function inputMacro(name, params, hash, builder) {
    var keys = void 0;
    var values = void 0;
    var typeIndex = -1;
    var valueIndex = -1;

    if (hash) {
      keys = hash[0];
      values = hash[1];
      typeIndex = keys.indexOf('type');
      valueIndex = keys.indexOf('value');
    }

    if (!params) {
      params = [];
    }

    if (typeIndex > -1) {
      var typeArg = values[typeIndex];
      if (Array.isArray(typeArg)) {
        return (0, _dynamicComponent.dynamicComponentMacro)(params, hash, null, null, builder);
      } else if (typeArg === 'checkbox') {
        (true && !(valueIndex === -1) && (0, _emberDebug.assert)('{{input type=\'checkbox\'}} does not support setting `value=someBooleanValue`; ' + 'you must use `checked=someBooleanValue` instead.', valueIndex === -1));

        (0, _bindings.wrapComponentClassAttribute)(hash);
        return buildSyntax('-checkbox', params, hash, builder);
      }
    }

    return buildSyntax('-text-field', params, hash, builder);
  }
});
enifed('ember-glimmer/syntax/mount', ['exports', 'ember-babel', 'ember-debug', 'ember/features', 'ember-glimmer/syntax/utils', 'ember-glimmer/component-managers/mount'], function (exports, _emberBabel, _emberDebug, _features, _utils, _mount) {
  'use strict';

  exports.mountMacro = mountMacro;
  /**
  @module ember
  */
  function dynamicEngineFor(vm, args, meta) {
    var env = vm.env;
    var nameRef = args.positional.at(0);

    return new DynamicEngineReference({ nameRef: nameRef, env: env, meta: meta });
  }

  /**
    The `{{mount}}` helper lets you embed a routeless engine in a template.
    Mounting an engine will cause an instance to be booted and its `application`
    template to be rendered.
  
    For example, the following template mounts the `ember-chat` engine:
  
    ```handlebars
    {{! application.hbs }}
    {{mount "ember-chat"}}
    ```
  
    Additionally, you can also pass in a `model` argument that will be
    set as the engines model. This can be an existing object:
  
    ```
    <div>
      {{mount 'admin' model=userSettings}}
    </div>
    ```
  
    Or an inline `hash`, and you can even pass components:
  
    ```
    <div>
      <h1>Application template!</h1>
      {{mount 'admin' model=(hash
          title='Secret Admin'
          signInButton=(component 'sign-in-button')
      )}}
    </div>
    ```
  
    @method mount
    @param {String} name Name of the engine to mount.
    @param {Object} [model] Object that will be set as
                            the model of the engine.
    @for Ember.Templates.helpers
    @category ember-application-engines
    @public
  */
  function mountMacro(name, params, hash, builder) {
    if (_features.EMBER_ENGINES_MOUNT_PARAMS) {
      (true && !(params.length === 1) && (0, _emberDebug.assert)('You can only pass a single positional argument to the {{mount}} helper, e.g. {{mount "chat-engine"}}.', params.length === 1));
    } else {
      (true && !(params.length === 1 && hash === null) && (0, _emberDebug.assert)('You can only pass a single argument to the {{mount}} helper, e.g. {{mount "chat-engine"}}.', params.length === 1 && hash === null));
    }

    var definitionArgs = [params.slice(0, 1), null, null, null];
    var args = [null, (0, _utils.hashToArgs)(hash), null, null];
    builder.component.dynamic(definitionArgs, dynamicEngineFor, args);
    return true;
  }

  var DynamicEngineReference = function () {
    function DynamicEngineReference(_ref) {
      var nameRef = _ref.nameRef,
          env = _ref.env,
          meta = _ref.meta;
      (0, _emberBabel.classCallCheck)(this, DynamicEngineReference);

      this.tag = nameRef.tag;
      this.nameRef = nameRef;
      this.env = env;
      this.meta = meta;
      this._lastName = undefined;
      this._lastDef = undefined;
    }

    DynamicEngineReference.prototype.value = function value() {
      var env = this.env,
          nameRef = this.nameRef;

      var nameOrDef = nameRef.value();

      if (typeof nameOrDef === 'string') {
        if (this._lastName === nameOrDef) {
          return this._lastDef;
        }

        (true && !(env.owner.hasRegistration('engine:' + nameOrDef)) && (0, _emberDebug.assert)('You used `{{mount \'' + nameOrDef + '\'}}`, but the engine \'' + nameOrDef + '\' can not be found.', env.owner.hasRegistration('engine:' + nameOrDef)));


        if (!env.owner.hasRegistration('engine:' + nameOrDef)) {
          return null;
        }

        this._lastName = nameOrDef;
        this._lastDef = new _mount.MountDefinition(nameOrDef);

        return this._lastDef;
      } else {
        (true && !(nameOrDef === null || nameOrDef === undefined) && (0, _emberDebug.assert)('Invalid engine name \'' + nameOrDef + '\' specified, engine name must be either a string, null or undefined.', nameOrDef === null || nameOrDef === undefined));


        return null;
      }
    };

    return DynamicEngineReference;
  }();
});
enifed('ember-glimmer/syntax/outlet', ['exports', 'ember-babel', '@glimmer/reference', 'ember-glimmer/component-managers/outlet'], function (exports, _emberBabel, _reference, _outlet) {
  'use strict';

  exports.outletMacro = outletMacro;

  var OutletComponentReference = function () {
    function OutletComponentReference(outletNameRef, parentOutletStateRef) {
      (0, _emberBabel.classCallCheck)(this, OutletComponentReference);

      this.outletNameRef = outletNameRef;
      this.parentOutletStateRef = parentOutletStateRef;
      this.definition = null;
      this.lastState = null;
      var outletStateTag = this.outletStateTag = new _reference.UpdatableTag(parentOutletStateRef.tag);
      this.tag = (0, _reference.combine)([outletStateTag.tag, outletNameRef.tag]);
    }

    OutletComponentReference.prototype.value = function value() {
      var outletNameRef = this.outletNameRef,
          parentOutletStateRef = this.parentOutletStateRef,
          definition = this.definition,
          lastState = this.lastState;


      var outletName = outletNameRef.value();
      var outletStateRef = parentOutletStateRef.get('outlets').get(outletName);
      var newState = this.lastState = outletStateRef.value();

      this.outletStateTag.update(outletStateRef.tag);

      definition = revalidate(definition, lastState, newState);

      var hasTemplate = newState && newState.render.template;

      if (definition) {
        return definition;
      } else if (hasTemplate) {
        return this.definition = new _outlet.OutletComponentDefinition(outletName, newState.render.template);
      } else {
        return this.definition = null;
      }
    };

    return OutletComponentReference;
  }();

  function revalidate(definition, lastState, newState) {
    if (!lastState && !newState) {
      return definition;
    }

    if (!lastState && newState || lastState && !newState) {
      return null;
    }

    if (newState.render.template === lastState.render.template && newState.render.controller === lastState.render.controller) {
      return definition;
    }

    return null;
  }

  function outletComponentFor(vm, args) {
    var _vm$dynamicScope = vm.dynamicScope(),
        outletState = _vm$dynamicScope.outletState;

    var outletNameRef = void 0;
    if (args.positional.length === 0) {
      outletNameRef = new _reference.ConstReference('main');
    } else {
      outletNameRef = args.positional.at(0);
    }

    return new OutletComponentReference(outletNameRef, outletState);
  }

  /**
    The `{{outlet}}` helper lets you specify where a child route will render in
    your template. An important use of the `{{outlet}}` helper is in your
    application's `application.hbs` file:
  
    ```handlebars
    {{! app/templates/application.hbs }}
    <!-- header content goes here, and will always display -->
    {{my-header}}
    <div class="my-dynamic-content">
      <!-- this content will change based on the current route, which depends on the current URL -->
      {{outlet}}
    </div>
    <!-- footer content goes here, and will always display -->
    {{my-footer}}
    ```
  
    See [templates guide](https://emberjs.com/guides/templates/the-application-template/) for
    additional information on using `{{outlet}}` in `application.hbs`.
    You may also specify a name for the `{{outlet}}`, which is useful when using more than one
    `{{outlet}}` in a template:
  
    ```handlebars
    {{outlet "menu"}}
    {{outlet "sidebar"}}
    {{outlet "main"}}
    ```
  
    Your routes can then render into a specific one of these `outlet`s by specifying the `outlet`
    attribute in your `renderTemplate` function:
  
    ```app/routes/menu.js
    import Route from '@ember/routing/route';
  
    export default Route.extend({
      renderTemplate() {
        this.render({ outlet: 'menu' });
      }
    });
    ```
  
    See the [routing guide](https://emberjs.com/guides/routing/rendering-a-template/) for more
    information on how your `route` interacts with the `{{outlet}}` helper.
    Note: Your content __will not render__ if there isn't an `{{outlet}}` for it.
  
    @method outlet
    @param {String} [name]
    @for Ember.Templates.helpers
    @public
  */
  function outletMacro(name, params, hash, builder) {
    if (!params) {
      params = [];
    }
    var definitionArgs = [params.slice(0, 1), null, null, null];
    var emptyArgs = [[], null, null, null]; // FIXME
    builder.component.dynamic(definitionArgs, outletComponentFor, emptyArgs);
    return true;
  }
});
enifed('ember-glimmer/syntax/render', ['exports', '@glimmer/reference', 'ember-debug', 'ember-glimmer/syntax/utils', 'ember-glimmer/component-managers/render'], function (exports, _reference, _emberDebug, _utils, _render) {
  'use strict';

  exports.renderMacro = renderMacro;
  /**
  @module ember
  */

  function makeComponentDefinition(vm, args) {
    var env = vm.env;
    var nameRef = args.positional.at(0);

    (true && !((0, _reference.isConst)(nameRef)) && (0, _emberDebug.assert)('The first argument of {{render}} must be quoted, e.g. {{render "sidebar"}}.', (0, _reference.isConst)(nameRef)));
    (true && !(args.positional.length === 1 || !(0, _reference.isConst)(args.positional.at(1))) && (0, _emberDebug.assert)('The second argument of {{render}} must be a path, e.g. {{render "post" post}}.', args.positional.length === 1 || !(0, _reference.isConst)(args.positional.at(1))));


    var templateName = nameRef.value();

    (true && !(env.owner.hasRegistration('template:' + templateName)) && (0, _emberDebug.assert)('You used `{{render \'' + templateName + '\'}}`, but \'' + templateName + '\' can not be found as a template.', env.owner.hasRegistration('template:' + templateName)));


    var template = env.owner.lookup('template:' + templateName);

    var controllerName = void 0;

    if (args.named.has('controller')) {
      var controllerNameRef = args.named.get('controller');

      (true && !((0, _reference.isConst)(controllerNameRef)) && (0, _emberDebug.assert)('The controller argument for {{render}} must be quoted, e.g. {{render "sidebar" controller="foo"}}.', (0, _reference.isConst)(controllerNameRef)));


      controllerName = controllerNameRef.value();

      (true && !(env.owner.hasRegistration('controller:' + controllerName)) && (0, _emberDebug.assert)('The controller name you supplied \'' + controllerName + '\' did not resolve to a controller.', env.owner.hasRegistration('controller:' + controllerName)));
    } else {
      controllerName = templateName;
    }

    if (args.positional.length === 1) {
      return new _reference.ConstReference(new _render.RenderDefinition(controllerName, template, env, _render.SINGLETON_RENDER_MANAGER));
    } else {
      return new _reference.ConstReference(new _render.RenderDefinition(controllerName, template, env, _render.NON_SINGLETON_RENDER_MANAGER));
    }
  }

  /**
    Calling ``{{render}}`` from within a template will insert another
    template that matches the provided name. The inserted template will
    access its properties on its own controller (rather than the controller
    of the parent template).
  
    If a view class with the same name exists, the view class also will be used.
    Note: A given controller may only be used *once* in your app in this manner.
    A singleton instance of the controller will be created for you.
  
    Example:
  
    ```app/controllers/navigation.js
    import Controller from '@ember/controller';
  
    export default Controller.extend({
      who: "world"
    });
    ```
  
    ```handlebars
    <!-- navigation.hbs -->
    Hello, {{who}}.
    ```
  
    ```handlebars
    <!-- application.hbs -->
    <h1>My great app</h1>
    {{render "navigation"}}
    ```
  
    ```html
    <h1>My great app</h1>
    <div class='ember-view'>
      Hello, world.
    </div>
    ```
  
    Optionally you may provide a second argument: a property path
    that will be bound to the `model` property of the controller.
    If a `model` property path is specified, then a new instance of the
    controller will be created and `{{render}}` can be used multiple times
    with the same name.
  
    For example if you had this `author` template.
  
    ```handlebars
    <div class="author">
      Written by {{firstName}} {{lastName}}.
      Total Posts: {{postCount}}
    </div>
    ```
  
    You could render it inside the `post` template using the `render` helper.
  
    ```handlebars
    <div class="post">
      <h1>{{title}}</h1>
      <div>{{body}}</div>
      {{render "author" author}}
    </div>
    ```
  
    @method render
    @for Ember.Templates.helpers
    @param {String} name
    @param {Object?} context
    @param {Hash} options
    @return {String} HTML string
    @public
    @deprecated Use a component instead
  */
  function renderMacro(name, params, hash, builder) {
    if (!params) {
      params = [];
    }
    var definitionArgs = [params.slice(0), hash, null, null];
    var args = [params.slice(1), (0, _utils.hashToArgs)(hash), null, null];
    builder.component.dynamic(definitionArgs, makeComponentDefinition, args);
    return true;
  }
});
enifed("ember-glimmer/syntax/utils", ["exports"], function (exports) {
  "use strict";

  exports.hashToArgs = hashToArgs;
  function hashToArgs(hash) {
    if (hash === null) return null;
    var names = hash[0].map(function (key) {
      return "@" + key;
    });
    return [names, hash[1]];
  }
});
enifed('ember-glimmer/template', ['exports', 'ember-utils', '@glimmer/runtime'], function (exports, _emberUtils, _runtime) {
  'use strict';

  exports.default = template;
  function template(json) {
    var factory = (0, _runtime.templateFactory)(json);

    return {
      id: factory.id,
      meta: factory.meta,
      create: function (props) {
        return factory.create(props.env, { owner: props[_emberUtils.OWNER] });
      }
    };
  }
});
enifed("ember-glimmer/template_registry", ["exports"], function (exports) {
  "use strict";

  exports.setTemplates = setTemplates;
  exports.getTemplates = getTemplates;
  exports.getTemplate = getTemplate;
  exports.hasTemplate = hasTemplate;
  exports.setTemplate = setTemplate;
  // STATE within a module is frowned upon, this exists
  // to support Ember.TEMPLATES but shield ember internals from this legacy
  // global API.
  var TEMPLATES = {};

  function setTemplates(templates) {
    TEMPLATES = templates;
  }

  function getTemplates() {
    return TEMPLATES;
  }

  function getTemplate(name) {
    if (TEMPLATES.hasOwnProperty(name)) {
      return TEMPLATES[name];
    }
  }

  function hasTemplate(name) {
    return TEMPLATES.hasOwnProperty(name);
  }

  function setTemplate(name, template) {
    return TEMPLATES[name] = template;
  }
});
enifed("ember-glimmer/templates/component", ["exports", "ember-glimmer/template"], function (exports, _template) {
  "use strict";

  exports.default = (0, _template.default)({ "id": "mvSJ6iUj", "block": "{\"symbols\":[\"&default\"],\"statements\":[[11,1]],\"hasEval\":false}", "meta": { "moduleName": "ember-glimmer/templates/component.hbs" } });
});
enifed("ember-glimmer/templates/empty", ["exports", "ember-glimmer/template"], function (exports, _template) {
  "use strict";

  exports.default = (0, _template.default)({ "id": "EPhvcwzD", "block": "{\"symbols\":[],\"statements\":[],\"hasEval\":false}", "meta": { "moduleName": "ember-glimmer/templates/empty.hbs" } });
});
enifed("ember-glimmer/templates/link-to", ["exports", "ember-glimmer/template"], function (exports, _template) {
  "use strict";

  exports.default = (0, _template.default)({ "id": "Gq3gxZ6f", "block": "{\"symbols\":[\"&default\"],\"statements\":[[4,\"if\",[[20,[\"linkTitle\"]]],null,{\"statements\":[[1,[18,\"linkTitle\"],false]],\"parameters\":[]},{\"statements\":[[11,1]],\"parameters\":[]}]],\"hasEval\":false}", "meta": { "moduleName": "ember-glimmer/templates/link-to.hbs" } });
});
enifed("ember-glimmer/templates/outlet", ["exports", "ember-glimmer/template"], function (exports, _template) {
  "use strict";

  exports.default = (0, _template.default)({ "id": "NblF8298", "block": "{\"symbols\":[],\"statements\":[[1,[18,\"outlet\"],false]],\"hasEval\":false}", "meta": { "moduleName": "ember-glimmer/templates/outlet.hbs" } });
});
enifed("ember-glimmer/templates/root", ["exports", "ember-glimmer/template"], function (exports, _template) {
  "use strict";

  exports.default = (0, _template.default)({ "id": "Jhwo1zmY", "block": "{\"symbols\":[],\"statements\":[[1,[25,\"component\",[[19,0,[]]],null],false]],\"hasEval\":false}", "meta": { "moduleName": "ember-glimmer/templates/root.hbs" } });
});
enifed('ember-glimmer/utils/bindings', ['exports', 'ember-babel', '@glimmer/reference', '@glimmer/wire-format', 'ember-debug', 'ember-metal', 'ember-runtime', 'ember-glimmer/component', 'ember-glimmer/utils/string'], function (exports, _emberBabel, _reference, _wireFormat, _emberDebug, _emberMetal, _emberRuntime, _component, _string) {
  'use strict';

  exports.ClassNameBinding = exports.IsVisibleBinding = exports.AttributeBinding = undefined;
  exports.wrapComponentClassAttribute = wrapComponentClassAttribute;


  function referenceForKey(component, key) {
    return component[_component.ROOT_REF].get(key);
  }

  function referenceForParts(component, parts) {
    var isAttrs = parts[0] === 'attrs';

    // TODO deprecate this
    if (isAttrs) {
      parts.shift();

      if (parts.length === 1) {
        return referenceForKey(component, parts[0]);
      }
    }

    return (0, _reference.referenceFromParts)(component[_component.ROOT_REF], parts);
  }

  // TODO we should probably do this transform at build time
  function wrapComponentClassAttribute(hash) {
    if (!hash) {
      return hash;
    }

    var keys = hash[0],
        values = hash[1];

    var index = keys.indexOf('class');

    if (index !== -1) {
      var _values$index = values[index],
          type = _values$index[0];


      if (type === _wireFormat.Ops.Get || type === _wireFormat.Ops.MaybeLocal) {
        var getExp = values[index];
        var path = getExp[getExp.length - 1];
        var propName = path[path.length - 1];
        hash[1][index] = [_wireFormat.Ops.Helper, ['-class'], [getExp, propName]];
      }
    }

    return hash;
  }

  var AttributeBinding = exports.AttributeBinding = {
    parse: function (microsyntax) {
      var colonIndex = microsyntax.indexOf(':');

      if (colonIndex === -1) {
        (true && !(microsyntax !== 'class') && (0, _emberDebug.assert)('You cannot use class as an attributeBinding, use classNameBindings instead.', microsyntax !== 'class'));

        return [microsyntax, microsyntax, true];
      } else {
        var prop = microsyntax.substring(0, colonIndex);
        var attribute = microsyntax.substring(colonIndex + 1);

        (true && !(attribute !== 'class') && (0, _emberDebug.assert)('You cannot use class as an attributeBinding, use classNameBindings instead.', attribute !== 'class'));


        return [prop, attribute, false];
      }
    },
    install: function (element, component, parsed, operations) {
      var prop = parsed[0],
          attribute = parsed[1],
          isSimple = parsed[2];


      if (attribute === 'id') {
        var elementId = (0, _emberMetal.get)(component, prop);
        if (elementId === undefined || elementId === null) {
          elementId = component.elementId;
        }
        operations.addStaticAttribute(element, 'id', elementId);
        return;
      }

      var isPath = prop.indexOf('.') > -1;
      var reference = isPath ? referenceForParts(component, prop.split('.')) : referenceForKey(component, prop);

      (true && !(!(isSimple && isPath)) && (0, _emberDebug.assert)('Illegal attributeBinding: \'' + prop + '\' is not a valid attribute name.', !(isSimple && isPath)));


      if (attribute === 'style') {
        reference = new StyleBindingReference(reference, referenceForKey(component, 'isVisible'));
      }

      operations.addDynamicAttribute(element, attribute, reference);
    }
  };

  var DISPLAY_NONE = 'display: none;';
  var SAFE_DISPLAY_NONE = (0, _string.htmlSafe)(DISPLAY_NONE);

  var StyleBindingReference = function (_CachedReference) {
    (0, _emberBabel.inherits)(StyleBindingReference, _CachedReference);

    function StyleBindingReference(inner, isVisible) {
      (0, _emberBabel.classCallCheck)(this, StyleBindingReference);

      var _this = (0, _emberBabel.possibleConstructorReturn)(this, _CachedReference.call(this));

      _this.tag = (0, _reference.combine)([inner.tag, isVisible.tag]);
      _this.inner = inner;
      _this.isVisible = isVisible;
      return _this;
    }

    StyleBindingReference.prototype.compute = function compute() {
      var value = this.inner.value();
      var isVisible = this.isVisible.value();

      if (isVisible !== false) {
        return value;
      } else if (!value && value !== 0) {
        return SAFE_DISPLAY_NONE;
      } else {
        var style = value + ' ' + DISPLAY_NONE;
        return (0, _string.isHTMLSafe)(value) ? (0, _string.htmlSafe)(style) : style;
      }
    };

    return StyleBindingReference;
  }(_reference.CachedReference);

  var IsVisibleBinding = exports.IsVisibleBinding = {
    install: function (element, component, operations) {
      operations.addDynamicAttribute(element, 'style', (0, _reference.map)(referenceForKey(component, 'isVisible'), this.mapStyleValue));
    },
    mapStyleValue: function (isVisible) {
      return isVisible === false ? SAFE_DISPLAY_NONE : null;
    }
  };

  var ClassNameBinding = exports.ClassNameBinding = {
    install: function (element, component, microsyntax, operations) {
      var _microsyntax$split = microsyntax.split(':'),
          prop = _microsyntax$split[0],
          truthy = _microsyntax$split[1],
          falsy = _microsyntax$split[2];

      var isStatic = prop === '';

      if (isStatic) {
        operations.addStaticAttribute(element, 'class', truthy);
      } else {
        var isPath = prop.indexOf('.') > -1;
        var parts = isPath && prop.split('.');
        var value = isPath ? referenceForParts(component, parts) : referenceForKey(component, prop);
        var ref = void 0;

        if (truthy === undefined) {
          ref = new SimpleClassNameBindingReference(value, isPath ? parts[parts.length - 1] : prop);
        } else {
          ref = new ColonClassNameBindingReference(value, truthy, falsy);
        }

        operations.addDynamicAttribute(element, 'class', ref);
      }
    }
  };

  var SimpleClassNameBindingReference = function (_CachedReference2) {
    (0, _emberBabel.inherits)(SimpleClassNameBindingReference, _CachedReference2);

    function SimpleClassNameBindingReference(inner, path) {
      (0, _emberBabel.classCallCheck)(this, SimpleClassNameBindingReference);

      var _this2 = (0, _emberBabel.possibleConstructorReturn)(this, _CachedReference2.call(this));

      _this2.tag = inner.tag;
      _this2.inner = inner;
      _this2.path = path;
      _this2.dasherizedPath = null;
      return _this2;
    }

    SimpleClassNameBindingReference.prototype.compute = function compute() {
      var value = this.inner.value();

      if (value === true) {
        var path = this.path,
            dasherizedPath = this.dasherizedPath;

        return dasherizedPath || (this.dasherizedPath = _emberRuntime.String.dasherize(path));
      } else if (value || value === 0) {
        return value;
      } else {
        return null;
      }
    };

    return SimpleClassNameBindingReference;
  }(_reference.CachedReference);

  var ColonClassNameBindingReference = function (_CachedReference3) {
    (0, _emberBabel.inherits)(ColonClassNameBindingReference, _CachedReference3);

    function ColonClassNameBindingReference(inner, truthy, falsy) {
      (0, _emberBabel.classCallCheck)(this, ColonClassNameBindingReference);

      var _this3 = (0, _emberBabel.possibleConstructorReturn)(this, _CachedReference3.call(this));

      _this3.tag = inner.tag;
      _this3.inner = inner;
      _this3.truthy = truthy || null;
      _this3.falsy = falsy || null;
      return _this3;
    }

    ColonClassNameBindingReference.prototype.compute = function compute() {
      var inner = this.inner,
          truthy = this.truthy,
          falsy = this.falsy;

      return inner.value() ? truthy : falsy;
    };

    return ColonClassNameBindingReference;
  }(_reference.CachedReference);
});
enifed('ember-glimmer/utils/curly-component-state-bucket', ['exports', 'ember-babel'], function (exports, _emberBabel) {
  'use strict';

  function NOOP() {}

  /**
    @module ember
  */

  /**
    Represents the internal state of the component.
  
    @class ComponentStateBucket
    @private
  */

  var ComponentStateBucket = function () {
    function ComponentStateBucket(environment, component, args, finalizer) {
      (0, _emberBabel.classCallCheck)(this, ComponentStateBucket);

      this.environment = environment;
      this.component = component;
      this.classRef = null;
      this.args = args;
      this.argsRevision = args.tag.value();
      this.finalizer = finalizer;
    }

    ComponentStateBucket.prototype.destroy = function destroy() {
      var component = this.component,
          environment = this.environment;


      if (environment.isInteractive) {
        component.trigger('willDestroyElement');
        component.trigger('willClearRender');
      }

      environment.destroyedComponents.push(component);
    };

    ComponentStateBucket.prototype.finalize = function finalize() {
      var finalizer = this.finalizer;

      finalizer();
      this.finalizer = NOOP;
    };

    return ComponentStateBucket;
  }();

  exports.default = ComponentStateBucket;
});
enifed('ember-glimmer/utils/debug-stack', ['exports', 'ember-babel'], function (exports, _emberBabel) {
  'use strict';

  var DebugStack = void 0;

  if (true) {
    var Element = function Element(name) {
      (0, _emberBabel.classCallCheck)(this, Element);

      this.name = name;
    };

    var TemplateElement = function (_Element) {
      (0, _emberBabel.inherits)(TemplateElement, _Element);

      function TemplateElement() {
        (0, _emberBabel.classCallCheck)(this, TemplateElement);
        return (0, _emberBabel.possibleConstructorReturn)(this, _Element.apply(this, arguments));
      }

      return TemplateElement;
    }(Element);

    var EngineElement = function (_Element2) {
      (0, _emberBabel.inherits)(EngineElement, _Element2);

      function EngineElement() {
        (0, _emberBabel.classCallCheck)(this, EngineElement);
        return (0, _emberBabel.possibleConstructorReturn)(this, _Element2.apply(this, arguments));
      }

      return EngineElement;
    }(Element);

    DebugStack = function () {
      function DebugStack() {
        (0, _emberBabel.classCallCheck)(this, DebugStack);

        this._stack = [];
      }

      DebugStack.prototype.push = function push(name) {
        this._stack.push(new TemplateElement(name));
      };

      DebugStack.prototype.pushEngine = function pushEngine(name) {
        this._stack.push(new EngineElement(name));
      };

      DebugStack.prototype.pop = function pop() {
        var element = this._stack.pop();

        if (element) {
          return element.name;
        }
      };

      DebugStack.prototype.peek = function peek() {
        var template = this._currentTemplate();
        var engine = this._currentEngine();

        if (engine) {
          return '"' + template + '" (in "' + engine + '")';
        } else if (template) {
          return '"' + template + '"';
        }
      };

      DebugStack.prototype._currentTemplate = function _currentTemplate() {
        return this._getCurrentByType(TemplateElement);
      };

      DebugStack.prototype._currentEngine = function _currentEngine() {
        return this._getCurrentByType(EngineElement);
      };

      DebugStack.prototype._getCurrentByType = function _getCurrentByType(type) {
        for (var i = this._stack.length; i >= 0; i--) {
          var element = this._stack[i];
          if (element instanceof type) {
            return element.name;
          }
        }
      };

      return DebugStack;
    }();
  }

  exports.default = DebugStack;
});
enifed('ember-glimmer/utils/iterable', ['exports', 'ember-babel', 'ember-utils', 'ember-metal', 'ember-runtime', 'ember-glimmer/utils/references', 'ember-glimmer/helpers/each-in', '@glimmer/reference'], function (exports, _emberBabel, _emberUtils, _emberMetal, _emberRuntime, _references, _eachIn, _reference) {
  'use strict';

  exports.default = iterableFor;


  var ITERATOR_KEY_GUID = 'be277757-bbbe-4620-9fcb-213ef433cca2';

  function iterableFor(ref, keyPath) {
    if ((0, _eachIn.isEachIn)(ref)) {
      return new EachInIterable(ref, keyForEachIn(keyPath));
    } else {
      return new ArrayIterable(ref, keyForArray(keyPath));
    }
  }

  function keyForEachIn(keyPath) {
    switch (keyPath) {
      case '@index':
      case undefined:
      case null:
        return index;
      case '@identity':
        return identity;
      default:
        return function (item) {
          return (0, _emberMetal.get)(item, keyPath);
        };
    }
  }

  function keyForArray(keyPath) {
    switch (keyPath) {
      case '@index':
        return index;
      case '@identity':
      case undefined:
      case null:
        return identity;
      default:
        return function (item) {
          return (0, _emberMetal.get)(item, keyPath);
        };
    }
  }

  function index(item, index) {
    return String(index);
  }

  function identity(item) {
    switch (typeof item) {
      case 'string':
      case 'number':
        return String(item);
      default:
        return (0, _emberUtils.guidFor)(item);
    }
  }

  function ensureUniqueKey(seen, key) {
    var seenCount = seen[key];

    if (seenCount > 0) {
      seen[key]++;
      return '' + key + ITERATOR_KEY_GUID + seenCount;
    } else {
      seen[key] = 1;
    }

    return key;
  }

  var ArrayIterator = function () {
    function ArrayIterator(array, keyFor) {
      (0, _emberBabel.classCallCheck)(this, ArrayIterator);

      this.array = array;
      this.length = array.length;
      this.keyFor = keyFor;
      this.position = 0;
      this.seen = Object.create(null);
    }

    ArrayIterator.prototype.isEmpty = function isEmpty() {
      return false;
    };

    ArrayIterator.prototype.getMemo = function getMemo(position) {
      return position;
    };

    ArrayIterator.prototype.getValue = function getValue(position) {
      return this.array[position];
    };

    ArrayIterator.prototype.next = function next() {
      var length = this.length,
          keyFor = this.keyFor,
          position = this.position,
          seen = this.seen;


      if (position >= length) {
        return null;
      }

      var value = this.getValue(position);
      var memo = this.getMemo(position);
      var key = ensureUniqueKey(seen, keyFor(value, memo));

      this.position++;

      return { key: key, value: value, memo: memo };
    };

    return ArrayIterator;
  }();

  var EmberArrayIterator = function (_ArrayIterator) {
    (0, _emberBabel.inherits)(EmberArrayIterator, _ArrayIterator);

    function EmberArrayIterator(array, keyFor) {
      (0, _emberBabel.classCallCheck)(this, EmberArrayIterator);

      var _this = (0, _emberBabel.possibleConstructorReturn)(this, _ArrayIterator.call(this, array, keyFor));

      _this.length = (0, _emberMetal.get)(array, 'length');
      return _this;
    }

    EmberArrayIterator.prototype.getValue = function getValue(position) {
      return (0, _emberRuntime.objectAt)(this.array, position);
    };

    return EmberArrayIterator;
  }(ArrayIterator);

  var ObjectKeysIterator = function (_ArrayIterator2) {
    (0, _emberBabel.inherits)(ObjectKeysIterator, _ArrayIterator2);

    function ObjectKeysIterator(keys, values, keyFor) {
      (0, _emberBabel.classCallCheck)(this, ObjectKeysIterator);

      var _this2 = (0, _emberBabel.possibleConstructorReturn)(this, _ArrayIterator2.call(this, values, keyFor));

      _this2.keys = keys;
      return _this2;
    }

    ObjectKeysIterator.prototype.getMemo = function getMemo(position) {
      return this.keys[position];
    };

    return ObjectKeysIterator;
  }(ArrayIterator);

  var EmptyIterator = function () {
    function EmptyIterator() {
      (0, _emberBabel.classCallCheck)(this, EmptyIterator);
    }

    EmptyIterator.prototype.isEmpty = function isEmpty() {
      return true;
    };

    EmptyIterator.prototype.next = function next() {
      throw new Error('Cannot call next() on an empty iterator');
    };

    return EmptyIterator;
  }();

  var EMPTY_ITERATOR = new EmptyIterator();

  var EachInIterable = function () {
    function EachInIterable(ref, keyFor) {
      (0, _emberBabel.classCallCheck)(this, EachInIterable);

      this.ref = ref;
      this.keyFor = keyFor;

      var valueTag = this.valueTag = new _reference.UpdatableTag(_reference.CONSTANT_TAG);

      this.tag = (0, _reference.combine)([ref.tag, valueTag]);
    }

    EachInIterable.prototype.iterate = function iterate() {
      var ref = this.ref,
          keyFor = this.keyFor,
          valueTag = this.valueTag;


      var iterable = ref.value();

      valueTag.update((0, _emberMetal.tagFor)(iterable));

      if ((0, _emberMetal.isProxy)(iterable)) {
        iterable = (0, _emberMetal.get)(iterable, 'content');
      }

      var typeofIterable = typeof iterable;

      if (iterable !== null && (typeofIterable === 'object' || typeofIterable === 'function')) {
        var keys = Object.keys(iterable);
        var values = keys.map(function (key) {
          return iterable[key];
        });
        return keys.length > 0 ? new ObjectKeysIterator(keys, values, keyFor) : EMPTY_ITERATOR;
      } else {
        return EMPTY_ITERATOR;
      }
    };

    EachInIterable.prototype.valueReferenceFor = function valueReferenceFor(item) {
      return new _references.UpdatablePrimitiveReference(item.memo);
    };

    EachInIterable.prototype.updateValueReference = function updateValueReference(reference, item) {
      reference.update(item.memo);
    };

    EachInIterable.prototype.memoReferenceFor = function memoReferenceFor(item) {
      return new _references.UpdatableReference(item.value);
    };

    EachInIterable.prototype.updateMemoReference = function updateMemoReference(reference, item) {
      reference.update(item.value);
    };

    return EachInIterable;
  }();

  var ArrayIterable = function () {
    function ArrayIterable(ref, keyFor) {
      (0, _emberBabel.classCallCheck)(this, ArrayIterable);

      this.ref = ref;
      this.keyFor = keyFor;

      var valueTag = this.valueTag = new _reference.UpdatableTag(_reference.CONSTANT_TAG);

      this.tag = (0, _reference.combine)([ref.tag, valueTag]);
    }

    ArrayIterable.prototype.iterate = function iterate() {
      var ref = this.ref,
          keyFor = this.keyFor,
          valueTag = this.valueTag;


      var iterable = ref.value();

      valueTag.update((0, _emberMetal.tagForProperty)(iterable, '[]'));

      if (iterable === null || typeof iterable !== 'object') {
        return EMPTY_ITERATOR;
      }

      if (Array.isArray(iterable)) {
        return iterable.length > 0 ? new ArrayIterator(iterable, keyFor) : EMPTY_ITERATOR;
      } else if ((0, _emberRuntime.isEmberArray)(iterable)) {
        return (0, _emberMetal.get)(iterable, 'length') > 0 ? new EmberArrayIterator(iterable, keyFor) : EMPTY_ITERATOR;
      } else if (typeof iterable.forEach === 'function') {
        var array = [];
        iterable.forEach(function (item) {
          array.push(item);
        });
        return array.length > 0 ? new ArrayIterator(array, keyFor) : EMPTY_ITERATOR;
      } else {
        return EMPTY_ITERATOR;
      }
    };

    ArrayIterable.prototype.valueReferenceFor = function valueReferenceFor(item) {
      return new _references.UpdatableReference(item.value);
    };

    ArrayIterable.prototype.updateValueReference = function updateValueReference(reference, item) {
      reference.update(item.value);
    };

    ArrayIterable.prototype.memoReferenceFor = function memoReferenceFor(item) {
      return new _references.UpdatablePrimitiveReference(item.memo);
    };

    ArrayIterable.prototype.updateMemoReference = function updateMemoReference(reference, item) {
      reference.update(item.memo);
    };

    return ArrayIterable;
  }();
});
enifed('ember-glimmer/utils/process-args', ['exports', 'ember-babel', 'ember-utils', 'ember-glimmer/component', 'ember-glimmer/utils/references', 'ember-views', 'ember-glimmer/helpers/action'], function (exports, _emberBabel, _emberUtils, _component, _references, _emberViews, _action) {
  'use strict';

  exports.processComponentArgs = processComponentArgs;


  // ComponentArgs takes EvaluatedNamedArgs and converts them into the
  // inputs needed by CurlyComponents (attrs and props, with mutable
  // cells, etc).
  function processComponentArgs(namedArgs) {
    var keys = namedArgs.names;
    var attrs = namedArgs.value();
    var props = Object.create(null);
    var args = Object.create(null);

    props[_component.ARGS] = args;

    for (var i = 0; i < keys.length; i++) {
      var name = keys[i];
      var ref = namedArgs.get(name);
      var value = attrs[name];

      if (typeof value === 'function' && value[_action.ACTION]) {
        attrs[name] = value;
      } else if (ref[_references.UPDATE]) {
        attrs[name] = new MutableCell(ref, value);
      }

      args[name] = ref;
      props[name] = value;
    }

    props.attrs = attrs;

    return props;
  }

  var REF = (0, _emberUtils.symbol)('REF');

  var MutableCell = function () {
    function MutableCell(ref, value) {
      (0, _emberBabel.classCallCheck)(this, MutableCell);

      this[_emberViews.MUTABLE_CELL] = true;
      this[REF] = ref;
      this.value = value;
    }

    MutableCell.prototype.update = function update(val) {
      this[REF][_references.UPDATE](val);
    };

    return MutableCell;
  }();
});
enifed('ember-glimmer/utils/references', ['exports', 'ember-babel', 'ember-utils', 'ember-metal', '@glimmer/reference', '@glimmer/runtime', 'ember-glimmer/utils/to-bool', 'ember-glimmer/helper', 'ember/features'], function (exports, _emberBabel, _emberUtils, _emberMetal, _reference, _runtime, _toBool, _helper, _features) {
  'use strict';

  exports.UnboundReference = exports.InternalHelperReference = exports.ClassBasedHelperReference = exports.SimpleHelperReference = exports.ConditionalReference = exports.UpdatablePrimitiveReference = exports.UpdatableReference = exports.NestedPropertyReference = exports.RootPropertyReference = exports.PropertyReference = exports.RootReference = exports.CachedReference = exports.UPDATE = undefined;
  var UPDATE = exports.UPDATE = (0, _emberUtils.symbol)('UPDATE');

  var maybeFreeze = void 0;
  if (true) {
    // gaurding this in a DEBUG gaurd (as well as all invocations)
    // so that it is properly stripped during the minification's
    // dead code elimination
    maybeFreeze = function (obj) {
      // re-freezing an already frozen object introduces a significant
      // performance penalty on Chrome (tested through 59).
      //
      // See: https://bugs.chromium.org/p/v8/issues/detail?id=6450
      if (!Object.isFrozen(obj) && _emberUtils.HAS_NATIVE_WEAKMAP) {
        Object.freeze(obj);
      }
    };
  }

  // @abstract
  // @implements PathReference

  var EmberPathReference = function () {
    function EmberPathReference() {
      (0, _emberBabel.classCallCheck)(this, EmberPathReference);
    }

    EmberPathReference.prototype.get = function get(key) {
      return PropertyReference.create(this, key);
    };

    return EmberPathReference;
  }();

  var CachedReference = exports.CachedReference = function (_EmberPathReference) {
    (0, _emberBabel.inherits)(CachedReference, _EmberPathReference);

    function CachedReference() {
      (0, _emberBabel.classCallCheck)(this, CachedReference);

      var _this = (0, _emberBabel.possibleConstructorReturn)(this, _EmberPathReference.call(this));

      _this._lastRevision = null;
      _this._lastValue = null;
      return _this;
    }

    CachedReference.prototype.value = function value() {
      var tag = this.tag,
          _lastRevision = this._lastRevision,
          _lastValue = this._lastValue;


      if (!_lastRevision || !tag.validate(_lastRevision)) {
        _lastValue = this._lastValue = this.compute();
        this._lastRevision = tag.value();
      }

      return _lastValue;
    };

    // @abstract compute()


    return CachedReference;
  }(EmberPathReference);

  var RootReference = exports.RootReference = function (_ConstReference) {
    (0, _emberBabel.inherits)(RootReference, _ConstReference);

    function RootReference(value) {
      (0, _emberBabel.classCallCheck)(this, RootReference);

      var _this2 = (0, _emberBabel.possibleConstructorReturn)(this, _ConstReference.call(this, value));

      _this2.children = Object.create(null);
      return _this2;
    }

    RootReference.prototype.get = function get(propertyKey) {
      var ref = this.children[propertyKey];

      if (ref === undefined) {
        ref = this.children[propertyKey] = new RootPropertyReference(this.inner, propertyKey);
      }

      return ref;
    };

    return RootReference;
  }(_reference.ConstReference);

  var TwoWayFlushDetectionTag = void 0;

  if (_features.EMBER_GLIMMER_DETECT_BACKTRACKING_RERENDER || _features.EMBER_GLIMMER_ALLOW_BACKTRACKING_RERENDER) {
    TwoWayFlushDetectionTag = function () {
      function TwoWayFlushDetectionTag(tag, key, ref) {
        (0, _emberBabel.classCallCheck)(this, TwoWayFlushDetectionTag);

        this.tag = tag;
        this.parent = null;
        this.key = key;
        this.ref = ref;
      }

      TwoWayFlushDetectionTag.prototype.value = function value() {
        return this.tag.value();
      };

      TwoWayFlushDetectionTag.prototype.validate = function validate(ticket) {
        var parent = this.parent,
            key = this.key;


        var isValid = this.tag.validate(ticket);

        if (isValid && parent) {
          (0, _emberMetal.didRender)(parent, key, this.ref);
        }

        return isValid;
      };

      TwoWayFlushDetectionTag.prototype.didCompute = function didCompute(parent) {
        this.parent = parent;
        (0, _emberMetal.didRender)(parent, this.key, this.ref);
      };

      return TwoWayFlushDetectionTag;
    }();
  }

  var PropertyReference = exports.PropertyReference = function (_CachedReference) {
    (0, _emberBabel.inherits)(PropertyReference, _CachedReference);

    function PropertyReference() {
      (0, _emberBabel.classCallCheck)(this, PropertyReference);
      return (0, _emberBabel.possibleConstructorReturn)(this, _CachedReference.apply(this, arguments));
    }

    PropertyReference.create = function create(parentReference, propertyKey) {
      if ((0, _reference.isConst)(parentReference)) {
        return new RootPropertyReference(parentReference.value(), propertyKey);
      } else {
        return new NestedPropertyReference(parentReference, propertyKey);
      }
    };

    PropertyReference.prototype.get = function get(key) {
      return new NestedPropertyReference(this, key);
    };

    return PropertyReference;
  }(CachedReference);

  var RootPropertyReference = exports.RootPropertyReference = function (_PropertyReference) {
    (0, _emberBabel.inherits)(RootPropertyReference, _PropertyReference);

    function RootPropertyReference(parentValue, propertyKey) {
      (0, _emberBabel.classCallCheck)(this, RootPropertyReference);

      var _this4 = (0, _emberBabel.possibleConstructorReturn)(this, _PropertyReference.call(this));

      _this4._parentValue = parentValue;
      _this4._propertyKey = propertyKey;

      if (_features.EMBER_GLIMMER_DETECT_BACKTRACKING_RERENDER || _features.EMBER_GLIMMER_ALLOW_BACKTRACKING_RERENDER) {
        _this4.tag = new TwoWayFlushDetectionTag((0, _emberMetal.tagForProperty)(parentValue, propertyKey), propertyKey, _this4);
      } else {
        _this4.tag = (0, _emberMetal.tagForProperty)(parentValue, propertyKey);
      }

      if (_features.MANDATORY_SETTER) {
        (0, _emberMetal.watchKey)(parentValue, propertyKey);
      }
      return _this4;
    }

    RootPropertyReference.prototype.compute = function compute() {
      var _parentValue = this._parentValue,
          _propertyKey = this._propertyKey;


      if (_features.EMBER_GLIMMER_DETECT_BACKTRACKING_RERENDER || _features.EMBER_GLIMMER_ALLOW_BACKTRACKING_RERENDER) {
        this.tag.didCompute(_parentValue);
      }

      return (0, _emberMetal.get)(_parentValue, _propertyKey);
    };

    RootPropertyReference.prototype[UPDATE] = function (value) {
      (0, _emberMetal.set)(this._parentValue, this._propertyKey, value);
    };

    return RootPropertyReference;
  }(PropertyReference);

  var NestedPropertyReference = exports.NestedPropertyReference = function (_PropertyReference2) {
    (0, _emberBabel.inherits)(NestedPropertyReference, _PropertyReference2);

    function NestedPropertyReference(parentReference, propertyKey) {
      (0, _emberBabel.classCallCheck)(this, NestedPropertyReference);

      var _this5 = (0, _emberBabel.possibleConstructorReturn)(this, _PropertyReference2.call(this));

      var parentReferenceTag = parentReference.tag;
      var parentObjectTag = new _reference.UpdatableTag(_reference.CONSTANT_TAG);

      _this5._parentReference = parentReference;
      _this5._parentObjectTag = parentObjectTag;
      _this5._propertyKey = propertyKey;

      if (_features.EMBER_GLIMMER_DETECT_BACKTRACKING_RERENDER || _features.EMBER_GLIMMER_ALLOW_BACKTRACKING_RERENDER) {
        var tag = (0, _reference.combine)([parentReferenceTag, parentObjectTag]);
        _this5.tag = new TwoWayFlushDetectionTag(tag, propertyKey, _this5);
      } else {
        _this5.tag = (0, _reference.combine)([parentReferenceTag, parentObjectTag]);
      }
      return _this5;
    }

    NestedPropertyReference.prototype.compute = function compute() {
      var _parentReference = this._parentReference,
          _parentObjectTag = this._parentObjectTag,
          _propertyKey = this._propertyKey;


      var parentValue = _parentReference.value();

      _parentObjectTag.update((0, _emberMetal.tagForProperty)(parentValue, _propertyKey));

      var parentValueType = typeof parentValue;

      if (parentValueType === 'string' && _propertyKey === 'length') {
        return parentValue.length;
      }

      if (parentValueType === 'object' && parentValue !== null || parentValueType === 'function') {
        if (_features.MANDATORY_SETTER) {
          (0, _emberMetal.watchKey)(parentValue, _propertyKey);
        }

        if (_features.EMBER_GLIMMER_DETECT_BACKTRACKING_RERENDER || _features.EMBER_GLIMMER_ALLOW_BACKTRACKING_RERENDER) {
          this.tag.didCompute(parentValue);
        }

        return (0, _emberMetal.get)(parentValue, _propertyKey);
      } else {
        return undefined;
      }
    };

    NestedPropertyReference.prototype[UPDATE] = function (value) {
      var parent = this._parentReference.value();
      (0, _emberMetal.set)(parent, this._propertyKey, value);
    };

    return NestedPropertyReference;
  }(PropertyReference);

  var UpdatableReference = exports.UpdatableReference = function (_EmberPathReference2) {
    (0, _emberBabel.inherits)(UpdatableReference, _EmberPathReference2);

    function UpdatableReference(value) {
      (0, _emberBabel.classCallCheck)(this, UpdatableReference);

      var _this6 = (0, _emberBabel.possibleConstructorReturn)(this, _EmberPathReference2.call(this));

      _this6.tag = new _reference.DirtyableTag();
      _this6._value = value;
      return _this6;
    }

    UpdatableReference.prototype.value = function value() {
      return this._value;
    };

    UpdatableReference.prototype.update = function update(value) {
      var _value = this._value;


      if (value !== _value) {
        this.tag.dirty();
        this._value = value;
      }
    };

    return UpdatableReference;
  }(EmberPathReference);

  var UpdatablePrimitiveReference = exports.UpdatablePrimitiveReference = function (_UpdatableReference) {
    (0, _emberBabel.inherits)(UpdatablePrimitiveReference, _UpdatableReference);

    function UpdatablePrimitiveReference() {
      (0, _emberBabel.classCallCheck)(this, UpdatablePrimitiveReference);
      return (0, _emberBabel.possibleConstructorReturn)(this, _UpdatableReference.apply(this, arguments));
    }

    UpdatablePrimitiveReference.prototype.get = function get() {
      return _runtime.UNDEFINED_REFERENCE;
    };

    return UpdatablePrimitiveReference;
  }(UpdatableReference);

  var ConditionalReference = exports.ConditionalReference = function (_GlimmerConditionalRe) {
    (0, _emberBabel.inherits)(ConditionalReference, _GlimmerConditionalRe);

    ConditionalReference.create = function create(reference) {
      if ((0, _reference.isConst)(reference)) {
        var value = reference.value();

        if ((0, _emberMetal.isProxy)(value)) {
          return new RootPropertyReference(value, 'isTruthy');
        } else {
          return _runtime.PrimitiveReference.create((0, _toBool.default)(value));
        }
      }

      return new ConditionalReference(reference);
    };

    function ConditionalReference(reference) {
      (0, _emberBabel.classCallCheck)(this, ConditionalReference);

      var _this8 = (0, _emberBabel.possibleConstructorReturn)(this, _GlimmerConditionalRe.call(this, reference));

      _this8.objectTag = new _reference.UpdatableTag(_reference.CONSTANT_TAG);
      _this8.tag = (0, _reference.combine)([reference.tag, _this8.objectTag]);
      return _this8;
    }

    ConditionalReference.prototype.toBool = function toBool(predicate) {
      if ((0, _emberMetal.isProxy)(predicate)) {
        this.objectTag.update((0, _emberMetal.tagForProperty)(predicate, 'isTruthy'));
        return (0, _emberMetal.get)(predicate, 'isTruthy');
      } else {
        this.objectTag.update((0, _emberMetal.tagFor)(predicate));
        return (0, _toBool.default)(predicate);
      }
    };

    return ConditionalReference;
  }(_runtime.ConditionalReference);

  var SimpleHelperReference = exports.SimpleHelperReference = function (_CachedReference2) {
    (0, _emberBabel.inherits)(SimpleHelperReference, _CachedReference2);

    SimpleHelperReference.create = function create(Helper, _vm, args) {
      var helper = Helper.create();

      if ((0, _reference.isConst)(args)) {
        var positional = args.positional,
            named = args.named;


        var positionalValue = positional.value();
        var namedValue = named.value();

        if (true) {
          maybeFreeze(positionalValue);
          maybeFreeze(namedValue);
        }

        var result = helper.compute(positionalValue, namedValue);

        if (typeof result === 'object' && result !== null || typeof result === 'function') {
          return new RootReference(result);
        } else {
          return _runtime.PrimitiveReference.create(result);
        }
      } else {
        return new SimpleHelperReference(helper.compute, args);
      }
    };

    function SimpleHelperReference(helper, args) {
      (0, _emberBabel.classCallCheck)(this, SimpleHelperReference);

      var _this9 = (0, _emberBabel.possibleConstructorReturn)(this, _CachedReference2.call(this));

      _this9.tag = args.tag;
      _this9.helper = helper;
      _this9.args = args;
      return _this9;
    }

    SimpleHelperReference.prototype.compute = function compute() {
      var helper = this.helper,
          _args = this.args,
          positional = _args.positional,
          named = _args.named;


      var positionalValue = positional.value();
      var namedValue = named.value();

      if (true) {
        maybeFreeze(positionalValue);
        maybeFreeze(namedValue);
      }

      return helper(positionalValue, namedValue);
    };

    return SimpleHelperReference;
  }(CachedReference);

  var ClassBasedHelperReference = exports.ClassBasedHelperReference = function (_CachedReference3) {
    (0, _emberBabel.inherits)(ClassBasedHelperReference, _CachedReference3);

    ClassBasedHelperReference.create = function create(helperClass, vm, args) {
      var instance = helperClass.create();
      vm.newDestroyable(instance);
      return new ClassBasedHelperReference(instance, args);
    };

    function ClassBasedHelperReference(instance, args) {
      (0, _emberBabel.classCallCheck)(this, ClassBasedHelperReference);

      var _this10 = (0, _emberBabel.possibleConstructorReturn)(this, _CachedReference3.call(this));

      _this10.tag = (0, _reference.combine)([instance[_helper.RECOMPUTE_TAG], args.tag]);
      _this10.instance = instance;
      _this10.args = args;
      return _this10;
    }

    ClassBasedHelperReference.prototype.compute = function compute() {
      var instance = this.instance,
          _args2 = this.args,
          positional = _args2.positional,
          named = _args2.named;


      var positionalValue = positional.value();
      var namedValue = named.value();

      if (true) {
        maybeFreeze(positionalValue);
        maybeFreeze(namedValue);
      }

      return instance.compute(positionalValue, namedValue);
    };

    return ClassBasedHelperReference;
  }(CachedReference);

  var InternalHelperReference = exports.InternalHelperReference = function (_CachedReference4) {
    (0, _emberBabel.inherits)(InternalHelperReference, _CachedReference4);

    function InternalHelperReference(helper, args) {
      (0, _emberBabel.classCallCheck)(this, InternalHelperReference);

      var _this11 = (0, _emberBabel.possibleConstructorReturn)(this, _CachedReference4.call(this));

      _this11.tag = args.tag;
      _this11.helper = helper;
      _this11.args = args;
      return _this11;
    }

    InternalHelperReference.prototype.compute = function compute() {
      var helper = this.helper,
          args = this.args;

      return helper(args);
    };

    return InternalHelperReference;
  }(CachedReference);

  var UnboundReference = exports.UnboundReference = function (_ConstReference2) {
    (0, _emberBabel.inherits)(UnboundReference, _ConstReference2);

    function UnboundReference() {
      (0, _emberBabel.classCallCheck)(this, UnboundReference);
      return (0, _emberBabel.possibleConstructorReturn)(this, _ConstReference2.apply(this, arguments));
    }

    UnboundReference.create = function create(value) {
      if (typeof value === 'object' && value !== null) {
        return new UnboundReference(value);
      } else {
        return _runtime.PrimitiveReference.create(value);
      }
    };

    UnboundReference.prototype.get = function get(key) {
      return new UnboundReference((0, _emberMetal.get)(this.inner, key));
    };

    return UnboundReference;
  }(_reference.ConstReference);
});
enifed('ember-glimmer/utils/string', ['exports', 'ember-babel', 'ember-debug'], function (exports, _emberBabel, _emberDebug) {
  'use strict';

  exports.SafeString = undefined;
  exports.getSafeString = getSafeString;
  exports.escapeExpression = escapeExpression;
  exports.htmlSafe = htmlSafe;
  exports.isHTMLSafe = isHTMLSafe;

  var SafeString = exports.SafeString = function () {
    function SafeString(string) {
      (0, _emberBabel.classCallCheck)(this, SafeString);

      this.string = string;
    }

    SafeString.prototype.toString = function toString() {
      return '' + this.string;
    };

    SafeString.prototype.toHTML = function toHTML() {
      return this.toString();
    };

    return SafeString;
  }();

  function getSafeString() {
    (true && !(false) && (0, _emberDebug.deprecate)('Ember.Handlebars.SafeString is deprecated in favor of Ember.String.htmlSafe', false, {
      id: 'ember-htmlbars.ember-handlebars-safestring',
      until: '3.0.0',
      url: 'https://emberjs.com/deprecations/v2.x#toc_use-ember-string-htmlsafe-over-ember-handlebars-safestring'
    }));


    return SafeString;
  }

  var escape = {
    '&': '&amp;',
    '<': '&lt;',
    '>': '&gt;',
    '"': '&quot;',
    // jscs:disable
    "'": '&#x27;',
    // jscs:enable
    '`': '&#x60;',
    '=': '&#x3D;'
  };

  var possible = /[&<>"'`=]/;
  var badChars = /[&<>"'`=]/g;

  function escapeChar(chr) {
    return escape[chr];
  }

  function escapeExpression(string) {
    if (typeof string !== 'string') {
      // don't escape SafeStrings, since they're already safe
      if (string && string.toHTML) {
        return string.toHTML();
      } else if (string == null) {
        return '';
      } else if (!string) {
        return string + '';
      }

      // Force a string conversion as this will be done by the append regardless and
      // the regex test will do this transparently behind the scenes, causing issues if
      // an object's to string has escaped characters in it.
      string = '' + string;
    }

    if (!possible.test(string)) {
      return string;
    }
    return string.replace(badChars, escapeChar);
  }

  /**
    Mark a string as safe for unescaped output with Ember templates. If you
    return HTML from a helper, use this function to
    ensure Ember's rendering layer does not escape the HTML.
  
    ```javascript
    import { htmlSafe } from '@ember/string';
  
    htmlSafe('<div>someString</div>')
    ```
  
    @method htmlSafe
    @for @ember/string
    @static
    @return {Handlebars.SafeString} A string that will not be HTML escaped by Handlebars.
    @public
  */
  function htmlSafe(str) {
    if (str === null || str === undefined) {
      str = '';
    } else if (typeof str !== 'string') {
      str = '' + str;
    }
    return new SafeString(str);
  }

  /**
    Detects if a string was decorated using `htmlSafe`.
  
    ```javascript
    import { htmlSafe, isHTMLSafe } from '@ember/string';
  
    var plainString = 'plain string',
        safeString = htmlSafe('<div>someValue</div>');
  
    isHTMLSafe(plainString); // false
    isHTMLSafe(safeString);  // true
    ```
  
    @method isHTMLSafe
    @for @ember/string
    @static
    @return {Boolean} `true` if the string was decorated with `htmlSafe`, `false` otherwise.
    @public
  */
  function isHTMLSafe(str) {
    return str && typeof str.toHTML === 'function';
  }
});
enifed('ember-glimmer/utils/to-bool', ['exports', 'ember-runtime', 'ember-metal'], function (exports, _emberRuntime, _emberMetal) {
  'use strict';

  exports.default = toBool;
  function toBool(predicate) {
    if (!predicate) {
      return false;
    }

    if (predicate === true) {
      return true;
    }

    if ((0, _emberRuntime.isArray)(predicate)) {
      return (0, _emberMetal.get)(predicate, 'length') !== 0;
    }

    return true;
  }
});
enifed('ember-glimmer/views/outlet', ['exports', 'ember-babel', 'ember-utils', '@glimmer/reference', 'ember-environment', 'ember-metal'], function (exports, _emberBabel, _emberUtils, _reference, _emberEnvironment, _emberMetal) {
  'use strict';

  var OutletStateReference = function () {
    function OutletStateReference(outletView) {
      (0, _emberBabel.classCallCheck)(this, OutletStateReference);

      this.outletView = outletView;
      this.tag = outletView._tag;
    }

    OutletStateReference.prototype.get = function get(key) {
      return new ChildOutletStateReference(this, key);
    };

    OutletStateReference.prototype.value = function value() {
      return this.outletView.outletState;
    };

    OutletStateReference.prototype.getOrphan = function getOrphan(name) {
      return new OrphanedOutletStateReference(this, name);
    };

    OutletStateReference.prototype.update = function update(state) {
      this.outletView.setOutletState(state);
    };

    return OutletStateReference;
  }();

  var OrphanedOutletStateReference = function (_OutletStateReference) {
    (0, _emberBabel.inherits)(OrphanedOutletStateReference, _OutletStateReference);

    function OrphanedOutletStateReference(root, name) {
      (0, _emberBabel.classCallCheck)(this, OrphanedOutletStateReference);

      var _this = (0, _emberBabel.possibleConstructorReturn)(this, _OutletStateReference.call(this, root.outletView));

      _this.root = root;
      _this.name = name;
      return _this;
    }

    OrphanedOutletStateReference.prototype.value = function value() {
      var rootState = this.root.value();

      var orphans = rootState.outlets.main.outlets.__ember_orphans__;

      if (!orphans) {
        return null;
      }

      var matched = orphans.outlets[this.name];

      if (!matched) {
        return null;
      }

      var state = Object.create(null);
      state[matched.render.outlet] = matched;
      matched.wasUsed = true;
      return { outlets: state };
    };

    return OrphanedOutletStateReference;
  }(OutletStateReference);

  var ChildOutletStateReference = function () {
    function ChildOutletStateReference(parent, key) {
      (0, _emberBabel.classCallCheck)(this, ChildOutletStateReference);

      this.parent = parent;
      this.key = key;
      this.tag = parent.tag;
    }

    ChildOutletStateReference.prototype.get = function get(key) {
      return new ChildOutletStateReference(this, key);
    };

    ChildOutletStateReference.prototype.value = function value() {
      return this.parent.value()[this.key];
    };

    return ChildOutletStateReference;
  }();

  var OutletView = function () {
    OutletView.extend = function extend(injections) {
      return function (_OutletView) {
        (0, _emberBabel.inherits)(_class, _OutletView);

        function _class() {
          (0, _emberBabel.classCallCheck)(this, _class);
          return (0, _emberBabel.possibleConstructorReturn)(this, _OutletView.apply(this, arguments));
        }

        _class.create = function create(options) {
          if (options) {
            return _OutletView.create.call(this, (0, _emberUtils.assign)({}, injections, options));
          } else {
            return _OutletView.create.call(this, injections);
          }
        };

        return _class;
      }(OutletView);
    };

    OutletView.reopenClass = function reopenClass(injections) {
      (0, _emberUtils.assign)(this, injections);
    };

    OutletView.create = function create(options) {
      var _environment = options._environment,
          renderer = options.renderer,
          template = options.template;

      var owner = options[_emberUtils.OWNER];
      return new OutletView(_environment, renderer, owner, template);
    };

    function OutletView(_environment, renderer, owner, template) {
      (0, _emberBabel.classCallCheck)(this, OutletView);

      this._environment = _environment;
      this.renderer = renderer;
      this.owner = owner;
      this.template = template;
      this.outletState = null;
      this._tag = new _reference.DirtyableTag();
    }

    OutletView.prototype.appendTo = function appendTo(selector) {
      var env = this._environment || _emberEnvironment.environment;
      var target = void 0;

      if (env.hasDOM) {
        target = typeof selector === 'string' ? document.querySelector(selector) : selector;
      } else {
        target = selector;
      }

      _emberMetal.run.schedule('render', this.renderer, 'appendOutletView', this, target);
    };

    OutletView.prototype.rerender = function rerender() {};

    OutletView.prototype.setOutletState = function setOutletState(state) {
      this.outletState = {
        outlets: {
          main: state
        },
        render: {
          owner: undefined,
          into: undefined,
          outlet: 'main',
          name: '-top-level',
          controller: undefined,
          ViewClass: undefined,
          template: undefined
        }
      };
      this._tag.dirty();
    };

    OutletView.prototype.toReference = function toReference() {
      return new OutletStateReference(this);
    };

    OutletView.prototype.destroy = function destroy() {};

    return OutletView;
  }();

  exports.default = OutletView;
});
enifed('ember-metal', ['exports', 'ember-environment', 'ember-utils', 'ember-debug', 'ember-babel', 'ember/features', '@glimmer/reference', 'require', 'ember-console', 'backburner'], function (exports, emberEnvironment, emberUtils, emberDebug, emberBabel, ember_features, _glimmer_reference, require, Logger, Backburner) {
  'use strict';

  require = 'default' in require ? require['default'] : require;
  Logger = 'default' in Logger ? Logger['default'] : Logger;
  Backburner = 'default' in Backburner ? Backburner['default'] : Backburner;

  /**
  @module ember
  */

  /**
    This namespace contains all Ember methods and functions. Future versions of
    Ember may overwrite this namespace and therefore, you should avoid adding any
    new properties.
  
    At the heart of Ember is Ember-Runtime, a set of core functions that provide
    cross-platform compatibility and object property observing.  Ember-Runtime is
    small and performance-focused so you can use it alongside other
    cross-platform libraries such as jQuery. For more details, see
    [Ember-Runtime](https://emberjs.com/api/modules/ember-runtime.html).
  
    @class Ember
    @static
    @public
  */
  var Ember = typeof emberEnvironment.context.imports.Ember === 'object' && emberEnvironment.context.imports.Ember || {};

  // Make sure these are set whether Ember was already defined or not
  Ember.isNamespace = true;
  Ember.toString = function () {
    return 'Ember';
  };

  /*
   When we render a rich template hierarchy, the set of events that
   *might* happen tends to be much larger than the set of events that
   actually happen. This implies that we should make listener creation &
   destruction cheap, even at the cost of making event dispatch more
   expensive.
  
   Thus we store a new listener with a single push and no new
   allocations, without even bothering to do deduplication -- we can
   save that for dispatch time, if an event actually happens.
   */

  /* listener flags */
  var ONCE = 1;
  var SUSPENDED = 2;

  var protoMethods = {
    addToListeners: function (eventName, target, method, flags) {
      if (this._listeners === undefined) {
        this._listeners = [];
      }
      this._listeners.push(eventName, target, method, flags);
    },
    _finalizeListeners: function () {
      if (this._listenersFinalized) {
        return;
      }
      if (this._listeners === undefined) {
        this._listeners = [];
      }
      var pointer = this.parent;
      while (pointer !== undefined) {
        var listeners = pointer._listeners;
        if (listeners !== undefined) {
          this._listeners = this._listeners.concat(listeners);
        }
        if (pointer._listenersFinalized) {
          break;
        }
        pointer = pointer.parent;
      }
      this._listenersFinalized = true;
    },
    removeFromListeners: function (eventName, target, method, didRemove) {
      var pointer = this;
      while (pointer !== undefined) {
        var listeners = pointer._listeners;
        if (listeners !== undefined) {
          for (var index = listeners.length - 4; index >= 0; index -= 4) {
            if (listeners[index] === eventName && (!method || listeners[index + 1] === target && listeners[index + 2] === method)) {
              if (pointer === this) {
                // we are modifying our own list, so we edit directly
                if (typeof didRemove === 'function') {
                  didRemove(eventName, target, listeners[index + 2]);
                }
                listeners.splice(index, 4);
              } else {
                // we are trying to remove an inherited listener, so we do
                // just-in-time copying to detach our own listeners from
                // our inheritance chain.
                this._finalizeListeners();
                return this.removeFromListeners(eventName, target, method);
              }
            }
          }
        }
        if (pointer._listenersFinalized) {
          break;
        }
        pointer = pointer.parent;
      }
    },
    matchingListeners: function (eventName) {
      var pointer = this;
      var result = void 0;
      while (pointer !== undefined) {
        var listeners = pointer._listeners;
        if (listeners !== undefined) {
          for (var index = 0; index < listeners.length; index += 4) {
            if (listeners[index] === eventName) {
              result = result || [];
              pushUniqueListener(result, listeners, index);
            }
          }
        }
        if (pointer._listenersFinalized) {
          break;
        }
        pointer = pointer.parent;
      }
      var sus = this._suspendedListeners;
      if (sus !== undefined && result !== undefined) {
        for (var susIndex = 0; susIndex < sus.length; susIndex += 3) {
          if (eventName === sus[susIndex]) {
            for (var resultIndex = 0; resultIndex < result.length; resultIndex += 3) {
              if (result[resultIndex] === sus[susIndex + 1] && result[resultIndex + 1] === sus[susIndex + 2]) {
                result[resultIndex + 2] |= SUSPENDED;
              }
            }
          }
        }
      }
      return result;
    },
    suspendListeners: function (eventNames, target, method, callback) {
      var sus = this._suspendedListeners;
      if (sus === undefined) {
        sus = this._suspendedListeners = [];
      }
      for (var i = 0; i < eventNames.length; i++) {
        sus.push(eventNames[i], target, method);
      }
      try {
        return callback.call(target);
      } finally {
        if (sus.length === eventNames.length) {
          this._suspendedListeners = undefined;
        } else {
          for (var _i = sus.length - 3; _i >= 0; _i -= 3) {
            if (sus[_i + 1] === target && sus[_i + 2] === method && eventNames.indexOf(sus[_i]) !== -1) {
              sus.splice(_i, 3);
            }
          }
        }
      }
    },
    watchedEvents: function () {
      var pointer = this;
      var names = {};
      while (pointer !== undefined) {
        var listeners = pointer._listeners;
        if (listeners !== undefined) {
          for (var index = 0; index < listeners.length; index += 4) {
            names[listeners[index]] = true;
          }
        }
        if (pointer._listenersFinalized) {
          break;
        }
        pointer = pointer.parent;
      }
      return Object.keys(names);
    }
  };

  function pushUniqueListener(destination, source, index) {
    var target = source[index + 1];
    var method = source[index + 2];
    for (var destinationIndex = 0; destinationIndex < destination.length; destinationIndex += 3) {
      if (destination[destinationIndex] === target && destination[destinationIndex + 1] === method) {
        return;
      }
    }
    destination.push(target, method, source[index + 3]);
  }

  /**
  @module @ember/object
  */
  /*
    The event system uses a series of nested hashes to store listeners on an
    object. When a listener is registered, or when an event arrives, these
    hashes are consulted to determine which target and action pair to invoke.
  
    The hashes are stored in the object's meta hash, and look like this:
  
        // Object's meta hash
        {
          listeners: {       // variable name: `listenerSet`
            "foo:changed": [ // variable name: `actions`
              target, method, flags
            ]
          }
        }
  
  */

  /**
    Add an event listener
  
    @method addListener
    @static
    @for @ember/object/events
    @param obj
    @param {String} eventName
    @param {Object|Function} target A target object or a function
    @param {Function|String} method A function or the name of a function to be called on `target`
    @param {Boolean} once A flag whether a function should only be called once
    @public
  */
  function addListener(obj, eventName, target, method, once) {
    true && !(!!obj && !!eventName) && emberDebug.assert('You must pass at least an object and event name to addListener', !!obj && !!eventName);
    true && !(eventName !== 'didInitAttrs') && emberDebug.deprecate('didInitAttrs called in ' + (obj && obj.toString && obj.toString()) + '.', eventName !== 'didInitAttrs', {
      id: 'ember-views.did-init-attrs',
      until: '3.0.0',
      url: 'https://emberjs.com/deprecations/v2.x#toc_ember-component-didinitattrs'
    });

    if (!method && 'function' === typeof target) {
      method = target;
      target = null;
    }

    var flags = 0;
    if (once) {
      flags |= ONCE;
    }

    meta(obj).addToListeners(eventName, target, method, flags);

    if ('function' === typeof obj.didAddListener) {
      obj.didAddListener(eventName, target, method);
    }
  }

  /**
    Remove an event listener
  
    Arguments should match those passed to `addListener`.
  
    @method removeListener
    @static
    @for @ember/object/events
    @param obj
    @param {String} eventName
    @param {Object|Function} target A target object or a function
    @param {Function|String} method A function or the name of a function to be called on `target`
    @public
  */
  function removeListener(obj, eventName, target, method) {
    true && !(!!obj && !!eventName) && emberDebug.assert('You must pass at least an object and event name to removeListener', !!obj && !!eventName);

    if (!method && 'function' === typeof target) {
      method = target;
      target = null;
    }

    var func = 'function' === typeof obj.didRemoveListener ? obj.didRemoveListener.bind(obj) : function () {};
    meta(obj).removeFromListeners(eventName, target, method, func);
  }

  /**
    Suspend listener during callback.
  
    This should only be used by the target of the event listener
    when it is taking an action that would cause the event, e.g.
    an object might suspend its property change listener while it is
    setting that property.
  
    @method suspendListener
    @static
    @for @ember/object/events
  
    @private
    @param obj
    @param {String} eventName
    @param {Object|Function} target A target object or a function
    @param {Function|String} method A function or the name of a function to be called on `target`
    @param {Function} callback
  */
  function suspendListener(obj, eventName, target, method, callback) {
    return suspendListeners(obj, [eventName], target, method, callback);
  }

  /**
    Suspends multiple listeners during a callback.
  
    @method suspendListeners
    @static
    @for @ember/object/events
  
    @private
    @param obj
    @param {Array} eventNames Array of event names
    @param {Object|Function} target A target object or a function
    @param {Function|String} method A function or the name of a function to be called on `target`
    @param {Function} callback
  */
  function suspendListeners(obj, eventNames, target, method, callback) {
    if (!method && 'function' === typeof target) {
      method = target;
      target = null;
    }
    return meta(obj).suspendListeners(eventNames, target, method, callback);
  }

  /**
    Return a list of currently watched events
  
    @private
    @method watchedEvents
    @static
    @for @ember/object/events
    @param obj
  */
  function watchedEvents(obj) {
    var meta$$1 = exports.peekMeta(obj);
    return meta$$1 !== undefined ? meta$$1.watchedEvents() : [];
  }

  /**
    Send an event. The execution of suspended listeners
    is skipped, and once listeners are removed. A listener without
    a target is executed on the passed object. If an array of actions
    is not passed, the actions stored on the passed object are invoked.
  
    @method sendEvent
    @static
    @for @ember/object/events
    @param obj
    @param {String} eventName
    @param {Array} params Optional parameters for each listener.
    @param {Array} actions Optional array of actions (listeners).
    @param {Meta}  meta Optional meta to lookup listeners
    @return true
    @public
  */
  function sendEvent(obj, eventName, params, actions, _meta) {
    if (actions === undefined) {
      var meta$$1 = _meta === undefined ? exports.peekMeta(obj) : _meta;
      actions = typeof meta$$1 === 'object' && meta$$1 !== null && meta$$1.matchingListeners(eventName);
    }

    if (actions === undefined || actions.length === 0) {
      return false;
    }

    for (var i = actions.length - 3; i >= 0; i -= 3) {
      // looping in reverse for once listeners
      var target = actions[i];
      var method = actions[i + 1];
      var flags = actions[i + 2];

      if (!method) {
        continue;
      }
      if (flags & SUSPENDED) {
        continue;
      }
      if (flags & ONCE) {
        removeListener(obj, eventName, target, method);
      }
      if (!target) {
        target = obj;
      }
      if ('string' === typeof method) {
        if (params) {
          emberUtils.applyStr(target, method, params);
        } else {
          target[method]();
        }
      } else {
        if (params) {
          method.apply(target, params);
        } else {
          method.call(target);
        }
      }
    }
    return true;
  }

  /**
    @private
    @method hasListeners
    @static
    @for @ember/object/events
    @param obj
    @param {String} eventName
  */
  function hasListeners(obj, eventName) {
    var meta$$1 = exports.peekMeta(obj);
    if (meta$$1 === undefined) {
      return false;
    }
    var matched = meta$$1.matchingListeners(eventName);
    return matched !== undefined && matched.length > 0;
  }

  /**
    @private
    @method listenersFor
    @static
    @for @ember/object/events
    @param obj
    @param {String} eventName
  */
  function listenersFor(obj, eventName) {
    var ret = [];
    var meta$$1 = exports.peekMeta(obj);
    var actions = meta$$1 !== undefined ? meta$$1.matchingListeners(eventName) : undefined;

    if (actions === undefined) {
      return ret;
    }

    for (var i = 0; i < actions.length; i += 3) {
      var target = actions[i];
      var method = actions[i + 1];
      ret.push([target, method]);
    }

    return ret;
  }

  /**
    Define a property as a function that should be executed when
    a specified event or events are triggered.
  
  
    ``` javascript
    import EmberObject from '@ember/object';
    import { on } from '@ember/object/evented';
    import { sendEvent } from '@ember/object/events';
  
    let Job = EmberObject.extend({
      logCompleted: on('completed', function() {
        console.log('Job completed!');
      })
    });
  
    let job = Job.create();
  
    sendEvent(job, 'completed'); // Logs 'Job completed!'
   ```
  
    @method on
    @static
    @for @ember/object/evented
    @param {String} eventNames*
    @param {Function} func
    @return func
    @public
  */
  function on() {
    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    var func = args.pop();
    var events = args;

    true && !(typeof func === 'function') && emberDebug.assert('on expects function as last argument', typeof func === 'function');
    true && !(events.length > 0 && events.every(function (p) {
      return typeof p === 'string' && p.length;
    })) && emberDebug.assert('on called without valid event names', events.length > 0 && events.every(function (p) {
      return typeof p === 'string' && p.length;
    }));

    func.__ember_listens__ = events;
    return func;
  }

  var hasViews = function () {
    return false;
  };

  function setHasViews(fn) {
    hasViews = fn;
  }

  function makeTag() {
    return new _glimmer_reference.DirtyableTag();
  }

  function tagForProperty(object, propertyKey, _meta) {
    if (typeof object !== 'object' || object === null) {
      return _glimmer_reference.CONSTANT_TAG;
    }

    var meta$$1 = _meta === undefined ? meta(object) : _meta;
    if (meta$$1.isProxy()) {
      return tagFor(object, meta$$1);
    }

    var tags = meta$$1.writableTags();
    var tag = tags[propertyKey];
    if (tag) {
      return tag;
    }

    return tags[propertyKey] = makeTag();
  }

  function tagFor(object, _meta) {
    if (typeof object === 'object' && object !== null) {
      var meta$$1 = _meta === undefined ? meta(object) : _meta;
      return meta$$1.writableTag(makeTag);
    } else {
      return _glimmer_reference.CONSTANT_TAG;
    }
  }

  function markObjectAsDirty(meta$$1, propertyKey) {
    var objectTag = meta$$1.readableTag();

    if (objectTag !== undefined) {
      objectTag.dirty();
    }

    var tags = meta$$1.readableTags();
    var propertyTag = tags !== undefined ? tags[propertyKey] : undefined;

    if (propertyTag !== undefined) {
      propertyTag.dirty();
    }

    if (propertyKey === 'content' && meta$$1.isProxy()) {
      objectTag.contentDidChange();
    }

    if (objectTag !== undefined || propertyTag !== undefined) {
      ensureRunloop();
    }
  }

  var backburner = void 0;
  function ensureRunloop() {
    if (backburner === undefined) {
      backburner = require('ember-metal').run.backburner;
    }

    if (hasViews()) {
      backburner.ensureInstance();
    }
  }

  /*
    this.observerSet = {
      [senderGuid]: { // variable name: `keySet`
        [keyName]: listIndex
      }
    },
    this.observers = [
      {
        sender: obj,
        keyName: keyName,
        eventName: eventName,
        listeners: [
          [target, method, flags]
        ]
      },
      ...
    ]
  */

  var ObserverSet = function () {
    function ObserverSet() {
      emberBabel.classCallCheck(this, ObserverSet);

      this.clear();
    }

    ObserverSet.prototype.add = function add(sender, keyName, eventName) {
      var observerSet = this.observerSet;
      var observers = this.observers;
      var senderGuid = emberUtils.guidFor(sender);
      var keySet = observerSet[senderGuid];

      if (keySet === undefined) {
        observerSet[senderGuid] = keySet = {};
      }

      var index = keySet[keyName];
      if (index === undefined) {
        index = observers.push({
          sender: sender,
          keyName: keyName,
          eventName: eventName,
          listeners: []
        }) - 1;
        keySet[keyName] = index;
      }
      return observers[index].listeners;
    };

    ObserverSet.prototype.flush = function flush() {
      var observers = this.observers;
      var observer = void 0,
          sender = void 0;
      this.clear();
      for (var i = 0; i < observers.length; ++i) {
        observer = observers[i];
        sender = observer.sender;
        if (sender.isDestroying || sender.isDestroyed) {
          continue;
        }
        sendEvent(sender, observer.eventName, [sender, observer.keyName], observer.listeners);
      }
    };

    ObserverSet.prototype.clear = function clear() {
      this.observerSet = {};
      this.observers = [];
    };

    return ObserverSet;
  }();

  /**
   @module ember
  */
  var id = 0;

  // Returns whether Type(value) is Object according to the terminology in the spec
  function isObject$1(value) {
    return typeof value === 'object' && value !== null || typeof value === 'function';
  }

  /*
   * @class Ember.WeakMap
   * @public
   * @category ember-metal-weakmap
   *
   * A partial polyfill for [WeakMap](http://www.ecma-international.org/ecma-262/6.0/#sec-weakmap-objects).
   *
   * There is a small but important caveat. This implementation assumes that the
   * weak map will live longer (in the sense of garbage collection) than all of its
   * keys, otherwise it is possible to leak the values stored in the weak map. In
   * practice, most use cases satisfy this limitation which is why it is included
   * in ember-metal.
   */
  var WeakMapPolyfill = function () {
    function WeakMapPolyfill(iterable) {
      emberBabel.classCallCheck(this, WeakMapPolyfill);

      this._id = emberUtils.GUID_KEY + id++;

      if (iterable === null || iterable === undefined) {
        return;
      } else if (Array.isArray(iterable)) {
        for (var i = 0; i < iterable.length; i++) {
          var _iterable$i = iterable[i],
              key = _iterable$i[0],
              value = _iterable$i[1];

          this.set(key, value);
        }
      } else {
        throw new TypeError('The weak map constructor polyfill only supports an array argument');
      }
    }

    /*
     * @method get
     * @param key {Object | Function}
     * @return {Any} stored value
     */

    WeakMapPolyfill.prototype.get = function get(obj) {
      if (!isObject$1(obj)) {
        return undefined;
      }

      var meta$$1 = exports.peekMeta(obj);
      if (meta$$1 !== undefined) {
        var map = meta$$1.readableWeak();
        if (map !== undefined) {
          var val = map[this._id];
          if (val === UNDEFINED) {
            return undefined;
          }
          return val;
        }
      }
    };

    /*
     * @method set
     * @param key {Object | Function}
     * @param value {Any}
     * @return {WeakMap} the weak map
     */

    WeakMapPolyfill.prototype.set = function set(obj, value) {
      if (!isObject$1(obj)) {
        throw new TypeError('Invalid value used as weak map key');
      }

      if (value === undefined) {
        value = UNDEFINED;
      }

      meta(obj).writableWeak()[this._id] = value;

      return this;
    };

    /*
     * @method has
     * @param key {Object | Function}
     * @return {boolean} if the key exists
     */

    WeakMapPolyfill.prototype.has = function has(obj) {
      if (!isObject$1(obj)) {
        return false;
      }

      var meta$$1 = exports.peekMeta(obj);
      if (meta$$1 !== undefined) {
        var map = meta$$1.readableWeak();
        if (map !== undefined) {
          return map[this._id] !== undefined;
        }
      }

      return false;
    };

    /*
     * @method delete
     * @param key {Object | Function}
     * @return {boolean} if the key was deleted
     */

    WeakMapPolyfill.prototype.delete = function _delete(obj) {
      if (this.has(obj)) {
        delete exports.peekMeta(obj).writableWeak()[this._id];
        return true;
      } else {
        return false;
      }
    };

    /*
     * @method toString
     * @return {String}
     */

    WeakMapPolyfill.prototype.toString = function toString$$1() {
      return '[object WeakMap]';
    };

    return WeakMapPolyfill;
  }();

  var WeakMap$1 = emberUtils.HAS_NATIVE_WEAKMAP ? WeakMap : WeakMapPolyfill;

  exports.runInTransaction = void 0;
  exports.didRender = void 0;
  exports.assertNotRendered = void 0;

  // detect-backtracking-rerender by default is debug build only
  // detect-glimmer-allow-backtracking-rerender can be enabled in custom builds
  if (ember_features.EMBER_GLIMMER_DETECT_BACKTRACKING_RERENDER || ember_features.EMBER_GLIMMER_ALLOW_BACKTRACKING_RERENDER) {

    // there are 4 states

    // NATIVE WEAKMAP AND DEBUG
    // tracks lastRef and lastRenderedIn per rendered object and key during a transaction
    // release everything via normal weakmap semantics by just derefencing the weakmap

    // NATIVE WEAKMAP AND RELEASE
    // tracks transactionId per rendered object and key during a transaction
    // release everything via normal weakmap semantics by just derefencing the weakmap

    // WEAKMAP POLYFILL AND DEBUG
    // tracks lastRef and lastRenderedIn per rendered object and key during a transaction
    // since lastRef retains a lot of app state (will have a ref to the Container)
    // if the object rendered is retained (like a immutable POJO in module state)
    // during acceptance tests this adds up and obfuscates finding other leaks.

    // WEAKMAP POLYFILL AND RELEASE
    // tracks transactionId per rendered object and key during a transaction
    // leaks it because small and likely not worth tracking it since it will only
    // be leaked if the object is retained

    var TransactionRunner = function () {
      function TransactionRunner() {
        emberBabel.classCallCheck(this, TransactionRunner);

        this.transactionId = 0;
        this.inTransaction = false;
        this.shouldReflush = false;
        this.weakMap = new WeakMap$1();
        {
          // track templates
          this.debugStack = undefined;

          if (!emberUtils.HAS_NATIVE_WEAKMAP) {
            // DEBUG AND POLYFILL
            // needs obj tracking
            this.objs = [];
          }
        }
      }

      TransactionRunner.prototype.runInTransaction = function runInTransaction(context$$1, methodName) {
        this.before(context$$1);
        try {
          context$$1[methodName]();
        } finally {
          this.after();
        }
        return this.shouldReflush;
      };

      TransactionRunner.prototype.didRender = function didRender(object, key, reference) {
        if (!this.inTransaction) {
          return;
        }
        {
          this.setKey(object, key, {
            lastRef: reference,
            lastRenderedIn: this.debugStack.peek()
          });
        }
      };

      TransactionRunner.prototype.assertNotRendered = function assertNotRendered(object, key) {
        if (!this.inTransaction) {
          return;
        }
        if (this.hasRendered(object, key)) {
          {
            var _getKey = this.getKey(object, key),
                lastRef = _getKey.lastRef,
                lastRenderedIn = _getKey.lastRenderedIn;

            var currentlyIn = this.debugStack.peek();

            var parts = [];
            var label = void 0;

            if (lastRef !== undefined) {
              while (lastRef && lastRef._propertyKey) {
                parts.unshift(lastRef._propertyKey);
                lastRef = lastRef._parentReference;
              }

              label = parts.join('.');
            } else {
              label = 'the same value';
            }

            var message = 'You modified "' + label + '" twice on ' + object + ' in a single render. It was rendered in ' + lastRenderedIn + ' and modified in ' + currentlyIn + '. This was unreliable and slow in Ember 1.x and';

            if (ember_features.EMBER_GLIMMER_ALLOW_BACKTRACKING_RERENDER) {
              true && !false && emberDebug.deprecate(message + ' will be removed in Ember 3.0.', false, { id: 'ember-views.render-double-modify', until: '3.0.0' });
            } else {
              true && !false && emberDebug.assert(message + ' is no longer supported. See https://github.com/emberjs/ember.js/issues/13948 for more details.', false);
            }
          }

          this.shouldReflush = true;
        }
      };

      TransactionRunner.prototype.hasRendered = function hasRendered(object, key) {
        if (!this.inTransaction) {
          return false;
        }
        {
          return this.getKey(object, key) !== undefined;
        }
        return this.getKey(object, key) === this.transactionId;
      };

      TransactionRunner.prototype.before = function before(context$$1) {
        this.inTransaction = true;
        this.shouldReflush = false;
        {
          this.debugStack = context$$1.env.debugStack;
        }
      };

      TransactionRunner.prototype.after = function after() {
        this.transactionId++;
        this.inTransaction = false;
        {
          this.debugStack = undefined;
        }
        this.clearObjectMap();
      };

      TransactionRunner.prototype.createMap = function createMap(object) {
        var map = Object.create(null);
        this.weakMap.set(object, map);
        if (true && !emberUtils.HAS_NATIVE_WEAKMAP) {
          // POLYFILL AND DEBUG
          // requires tracking objects
          this.objs.push(object);
        }
        return map;
      };

      TransactionRunner.prototype.getOrCreateMap = function getOrCreateMap(object) {
        var map = this.weakMap.get(object);
        if (map === undefined) {
          map = this.createMap(object);
        }
        return map;
      };

      TransactionRunner.prototype.setKey = function setKey(object, key, value) {
        var map = this.getOrCreateMap(object);
        map[key] = value;
      };

      TransactionRunner.prototype.getKey = function getKey(object, key) {
        var map = this.weakMap.get(object);
        if (map !== undefined) {
          return map[key];
        }
      };

      TransactionRunner.prototype.clearObjectMap = function clearObjectMap() {
        if (emberUtils.HAS_NATIVE_WEAKMAP) {
          // NATIVE AND (DEBUG OR RELEASE)
          // if we have a real native weakmap
          // releasing the ref will allow the values to be GCed
          this.weakMap = new WeakMap$1();
        } else {
          // POLYFILL AND DEBUG
          // with a polyfill the weakmap keys must be cleared since
          // they have the last reference, acceptance tests will leak
          // the container if you render a immutable object retained
          // in module scope.
          var objs = this.objs,
              weakMap = this.weakMap;

          this.objs = [];
          for (var i = 0; i < objs.length; i++) {
            weakMap.delete(objs[i]);
          }
        }
        // POLYFILL AND RELEASE
        // we leak the key map if the object is retained but this is
        // a POJO of keys to transaction ids
      };

      return TransactionRunner;
    }();

    var runner = new TransactionRunner();

    exports.runInTransaction = runner.runInTransaction.bind(runner);
    exports.didRender = runner.didRender.bind(runner);
    exports.assertNotRendered = runner.assertNotRendered.bind(runner);
  } else {
    // in production do nothing to detect reflushes
    exports.runInTransaction = function (context$$1, methodName) {
      context$$1[methodName]();
      return false;
    };
  }

  /**
   @module ember
   @private
   */

  var PROPERTY_DID_CHANGE = emberUtils.symbol('PROPERTY_DID_CHANGE');

  var beforeObserverSet = new ObserverSet();
  var observerSet = new ObserverSet();
  var deferred = 0;

  // ..........................................................
  // PROPERTY CHANGES
  //

  /**
    This function is called just before an object property is about to change.
    It will notify any before observers and prepare caches among other things.
  
    Normally you will not need to call this method directly but if for some
    reason you can't directly watch a property you can invoke this method
    manually along with `Ember.propertyDidChange()` which you should call just
    after the property value changes.
  
    @method propertyWillChange
    @for Ember
    @param {Object} obj The object with the property that will change
    @param {String} keyName The property key (or path) that will change.
    @return {void}
    @private
  */
  function propertyWillChange(obj, keyName, _meta) {
    var meta$$1 = _meta === undefined ? exports.peekMeta(obj) : _meta;
    if (meta$$1 !== undefined && !meta$$1.isInitialized(obj)) {
      return;
    }

    var watching = meta$$1 !== undefined && meta$$1.peekWatching(keyName) > 0;
    var possibleDesc = obj[keyName];
    var isDescriptor = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor;

    if (isDescriptor && possibleDesc.willChange) {
      possibleDesc.willChange(obj, keyName);
    }

    if (watching) {
      dependentKeysWillChange(obj, keyName, meta$$1);
      chainsWillChange(obj, keyName, meta$$1);
      notifyBeforeObservers(obj, keyName, meta$$1);
    }
  }

  /**
    This function is called just after an object property has changed.
    It will notify any observers and clear caches among other things.
  
    Normally you will not need to call this method directly but if for some
    reason you can't directly watch a property you can invoke this method
    manually along with `Ember.propertyWillChange()` which you should call just
    before the property value changes.
  
    @method propertyDidChange
    @for Ember
    @param {Object} obj The object with the property that will change
    @param {String} keyName The property key (or path) that will change.
    @param {Meta} meta The objects meta.
    @return {void}
    @private
  */
  function propertyDidChange(obj, keyName, _meta) {
    var meta$$1 = _meta === undefined ? exports.peekMeta(obj) : _meta;
    var hasMeta = meta$$1 !== undefined;

    if (hasMeta && !meta$$1.isInitialized(obj)) {
      return;
    }

    var possibleDesc = obj[keyName];
    var isDescriptor = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor;

    // shouldn't this mean that we're watching this key?
    if (isDescriptor && possibleDesc.didChange) {
      possibleDesc.didChange(obj, keyName);
    }

    if (hasMeta && meta$$1.peekWatching(keyName) > 0) {
      dependentKeysDidChange(obj, keyName, meta$$1);
      chainsDidChange(obj, keyName, meta$$1);
      notifyObservers(obj, keyName, meta$$1);
    }

    if (obj[PROPERTY_DID_CHANGE]) {
      obj[PROPERTY_DID_CHANGE](keyName);
    }

    if (hasMeta) {
      if (meta$$1.isSourceDestroying()) {
        return;
      }
      markObjectAsDirty(meta$$1, keyName);
    }

    if (ember_features.EMBER_GLIMMER_DETECT_BACKTRACKING_RERENDER || ember_features.EMBER_GLIMMER_ALLOW_BACKTRACKING_RERENDER) {
      exports.assertNotRendered(obj, keyName, meta$$1);
    }
  }

  var WILL_SEEN = void 0;
  var DID_SEEN = void 0;
  // called whenever a property is about to change to clear the cache of any dependent keys (and notify those properties of changes, etc...)
  function dependentKeysWillChange(obj, depKey, meta$$1) {
    if (meta$$1.isSourceDestroying() || !meta$$1.hasDeps(depKey)) {
      return;
    }
    var seen = WILL_SEEN;
    var top = !seen;

    if (top) {
      seen = WILL_SEEN = {};
    }

    iterDeps(propertyWillChange, obj, depKey, seen, meta$$1);

    if (top) {
      WILL_SEEN = null;
    }
  }

  // called whenever a property has just changed to update dependent keys
  function dependentKeysDidChange(obj, depKey, meta$$1) {
    if (meta$$1.isSourceDestroying() || !meta$$1.hasDeps(depKey)) {
      return;
    }
    var seen = DID_SEEN;
    var top = !seen;

    if (top) {
      seen = DID_SEEN = {};
    }

    iterDeps(propertyDidChange, obj, depKey, seen, meta$$1);

    if (top) {
      DID_SEEN = null;
    }
  }

  function iterDeps(method, obj, depKey, seen, meta$$1) {
    var possibleDesc = void 0,
        isDescriptor = void 0;
    var guid = emberUtils.guidFor(obj);
    var current = seen[guid];

    if (!current) {
      current = seen[guid] = {};
    }

    if (current[depKey]) {
      return;
    }

    current[depKey] = true;

    meta$$1.forEachInDeps(depKey, function (key, value) {
      if (!value) {
        return;
      }

      possibleDesc = obj[key];
      isDescriptor = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor;

      if (isDescriptor && possibleDesc._suspended === obj) {
        return;
      }

      method(obj, key, meta$$1);
    });
  }

  function chainsWillChange(obj, keyName, meta$$1) {
    var chainWatchers = meta$$1.readableChainWatchers();
    if (chainWatchers !== undefined) {
      chainWatchers.notify(keyName, false, propertyWillChange);
    }
  }

  function chainsDidChange(obj, keyName, meta$$1) {
    var chainWatchers = meta$$1.readableChainWatchers();
    if (chainWatchers !== undefined) {
      chainWatchers.notify(keyName, true, propertyDidChange);
    }
  }

  function overrideChains(obj, keyName, meta$$1) {
    var chainWatchers = meta$$1.readableChainWatchers();
    if (chainWatchers !== undefined) {
      chainWatchers.revalidate(keyName);
    }
  }

  /**
    @method beginPropertyChanges
    @chainable
    @private
  */
  function beginPropertyChanges() {
    deferred++;
  }

  /**
    @method endPropertyChanges
    @private
  */
  function endPropertyChanges() {
    deferred--;
    if (deferred <= 0) {
      beforeObserverSet.clear();
      observerSet.flush();
    }
  }

  /**
    Make a series of property changes together in an
    exception-safe way.
  
    ```javascript
    Ember.changeProperties(function() {
      obj1.set('foo', mayBlowUpWhenSet);
      obj2.set('bar', baz);
    });
    ```
  
    @method changeProperties
    @param {Function} callback
    @param [binding]
    @private
  */
  function changeProperties(callback, binding) {
    beginPropertyChanges();
    try {
      callback.call(binding);
    } finally {
      endPropertyChanges();
    }
  }

  function indexOf(array, target, method) {
    var index = -1;
    // hashes are added to the end of the event array
    // so it makes sense to start searching at the end
    // of the array and search in reverse
    for (var i = array.length - 3; i >= 0; i -= 3) {
      if (target === array[i] && method === array[i + 1]) {
        index = i;
        break;
      }
    }
    return index;
  }

  function accumulateListeners(obj, eventName, otherActions, meta$$1) {
    var actions = meta$$1.matchingListeners(eventName);
    if (actions === undefined) {
      return;
    }
    var newActions = [];

    for (var i = actions.length - 3; i >= 0; i -= 3) {
      var target = actions[i];
      var method = actions[i + 1];
      var flags = actions[i + 2];
      var actionIndex = indexOf(otherActions, target, method);

      if (actionIndex === -1) {
        otherActions.push(target, method, flags);
        newActions.push(target, method, flags);
      }
    }

    return newActions;
  }

  function notifyBeforeObservers(obj, keyName, meta$$1) {
    if (meta$$1.isSourceDestroying()) {
      return;
    }

    var eventName = keyName + ':before';
    var listeners = void 0,
        added = void 0;
    if (deferred > 0) {
      listeners = beforeObserverSet.add(obj, keyName, eventName);
      added = accumulateListeners(obj, eventName, listeners, meta$$1);
    }
    sendEvent(obj, eventName, [obj, keyName], added);
  }

  function notifyObservers(obj, keyName, meta$$1) {
    if (meta$$1.isSourceDestroying()) {
      return;
    }

    var eventName = keyName + ':change';
    var listeners = void 0;
    if (deferred > 0) {
      listeners = observerSet.add(obj, keyName, eventName);
      accumulateListeners(obj, eventName, listeners, meta$$1);
    } else {
      sendEvent(obj, eventName, [obj, keyName]);
    }
  }

  /**
  @module @ember/object
  */

  // ..........................................................
  // DESCRIPTOR
  //

  /**
    Objects of this type can implement an interface to respond to requests to
    get and set. The default implementation handles simple properties.
  
    @class Descriptor
    @private
  */
  function Descriptor() {
    this.isDescriptor = true;
  }

  var REDEFINE_SUPPORTED = function () {
    // https://github.com/spalger/kibana/commit/b7e35e6737df585585332857a4c397dc206e7ff9
    var a = Object.create(Object.prototype, {
      prop: {
        configurable: true,
        value: 1
      }
    });

    Object.defineProperty(a, 'prop', {
      configurable: true,
      value: 2
    });

    return a.prop === 2;
  }();
  // ..........................................................
  // DEFINING PROPERTIES API
  //

  function MANDATORY_SETTER_FUNCTION(name) {
    function SETTER_FUNCTION(value) {
      var m = exports.peekMeta(this);
      if (!m.isInitialized(this)) {
        m.writeValues(name, value);
      } else {
        true && !false && emberDebug.assert('You must use set() to set the `' + name + '` property (of ' + this + ') to `' + value + '`.', false);
      }
    }

    SETTER_FUNCTION.isMandatorySetter = true;
    return SETTER_FUNCTION;
  }

  function DEFAULT_GETTER_FUNCTION(name) {
    return function GETTER_FUNCTION() {
      var meta$$1 = exports.peekMeta(this);
      if (meta$$1 !== undefined) {
        return meta$$1.peekValues(name);
      }
    };
  }

  function INHERITING_GETTER_FUNCTION(name) {
    function IGETTER_FUNCTION() {
      var meta$$1 = exports.peekMeta(this);
      var val = void 0;
      if (meta$$1 !== undefined) {
        val = meta$$1.readInheritedValue('values', name);
      }

      if (val === UNDEFINED) {
        var proto = Object.getPrototypeOf(this);
        return proto && proto[name];
      } else {
        return val;
      }
    }

    IGETTER_FUNCTION.isInheritingGetter = true;
    return IGETTER_FUNCTION;
  }

  /**
    NOTE: This is a low-level method used by other parts of the API. You almost
    never want to call this method directly. Instead you should use
    `mixin()` to define new properties.
  
    Defines a property on an object. This method works much like the ES5
    `Object.defineProperty()` method except that it can also accept computed
    properties and other special descriptors.
  
    Normally this method takes only three parameters. However if you pass an
    instance of `Descriptor` as the third param then you can pass an
    optional value as the fourth parameter. This is often more efficient than
    creating new descriptor hashes for each property.
  
    ## Examples
  
    ```javascript
    import { defineProperty, computed } from '@ember/object';
  
    // ES5 compatible mode
    defineProperty(contact, 'firstName', {
      writable: true,
      configurable: false,
      enumerable: true,
      value: 'Charles'
    });
  
    // define a simple property
    defineProperty(contact, 'lastName', undefined, 'Jolley');
  
    // define a computed property
    defineProperty(contact, 'fullName', computed('firstName', 'lastName', function() {
      return this.firstName+' '+this.lastName;
    }));
    ```
  
    @private
    @method defineProperty
    @for @ember/object
    @param {Object} obj the object to define this property on. This may be a prototype.
    @param {String} keyName the name of the property
    @param {Descriptor} [desc] an instance of `Descriptor` (typically a
      computed property) or an ES5 descriptor.
      You must provide this or `data` but not both.
    @param {*} [data] something other than a descriptor, that will
      become the explicit value of this property.
  */
  function defineProperty(obj, keyName, desc, data, meta$$1) {
    if (meta$$1 === undefined) {
      meta$$1 = meta(obj);
    }

    var watchEntry = meta$$1.peekWatching(keyName);
    var watching = watchEntry !== undefined && watchEntry > 0;
    var possibleDesc = obj[keyName];
    var isDescriptor = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor;

    if (isDescriptor) {
      possibleDesc.teardown(obj, keyName, meta$$1);
    }

    var value = void 0;
    if (desc instanceof Descriptor) {
      value = desc;
      if (ember_features.MANDATORY_SETTER) {
        if (watching) {
          Object.defineProperty(obj, keyName, {
            configurable: true,
            enumerable: true,
            writable: true,
            value: value
          });
        } else {
          obj[keyName] = value;
        }
      } else {
        obj[keyName] = value;
      }

      didDefineComputedProperty(obj.constructor);

      if (typeof desc.setup === 'function') {
        desc.setup(obj, keyName);
      }
    } else if (desc === undefined || desc === null) {
      value = data;

      if (ember_features.MANDATORY_SETTER) {
        if (watching) {
          meta$$1.writeValues(keyName, data);

          var defaultDescriptor = {
            configurable: true,
            enumerable: true,
            set: MANDATORY_SETTER_FUNCTION(keyName),
            get: DEFAULT_GETTER_FUNCTION(keyName)
          };

          if (REDEFINE_SUPPORTED) {
            Object.defineProperty(obj, keyName, defaultDescriptor);
          } else {
            handleBrokenPhantomDefineProperty(obj, keyName, defaultDescriptor);
          }
        } else {
          obj[keyName] = data;
        }
      } else {
        obj[keyName] = data;
      }
    } else {
      value = desc;

      // fallback to ES5
      Object.defineProperty(obj, keyName, desc);
    }

    // if key is being watched, override chains that
    // were initialized with the prototype
    if (watching) {
      overrideChains(obj, keyName, meta$$1);
    }

    // The `value` passed to the `didDefineProperty` hook is
    // either the descriptor or data, whichever was passed.
    if (typeof obj.didDefineProperty === 'function') {
      obj.didDefineProperty(obj, keyName, value);
    }

    return this;
  }

  var hasCachedComputedProperties = false;
  function _hasCachedComputedProperties() {
    hasCachedComputedProperties = true;
  }

  function didDefineComputedProperty(constructor) {
    if (hasCachedComputedProperties === false) {
      return;
    }
    var cache = meta(constructor).readableCache();

    if (cache && cache._computedProperties !== undefined) {
      cache._computedProperties = undefined;
    }
  }

  function handleBrokenPhantomDefineProperty(obj, keyName, desc) {
    // https://github.com/ariya/phantomjs/issues/11856
    Object.defineProperty(obj, keyName, { configurable: true, writable: true, value: 'iCry' });
    Object.defineProperty(obj, keyName, desc);
  }

  var handleMandatorySetter = void 0;

  function watchKey(obj, keyName, _meta) {
    if (typeof obj !== 'object' || obj === null) {
      return;
    }

    var meta$$1 = _meta === undefined ? meta(obj) : _meta;
    var count = meta$$1.peekWatching(keyName) || 0;
    meta$$1.writeWatching(keyName, count + 1);

    if (count === 0) {
      // activate watching first time
      var possibleDesc = obj[keyName];
      var isDescriptor = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor;
      if (isDescriptor && possibleDesc.willWatch) {
        possibleDesc.willWatch(obj, keyName, meta$$1);
      }

      if (typeof obj.willWatchProperty === 'function') {
        obj.willWatchProperty(keyName);
      }

      if (ember_features.MANDATORY_SETTER) {
        // NOTE: this is dropped for prod + minified builds
        handleMandatorySetter(meta$$1, obj, keyName);
      }
    }
  }

  if (ember_features.MANDATORY_SETTER) {
    var _hasOwnProperty = function (obj, key) {
      return Object.prototype.hasOwnProperty.call(obj, key);
    };
    var _propertyIsEnumerable = function (obj, key) {
      return Object.prototype.propertyIsEnumerable.call(obj, key);
    };

    // Future traveler, although this code looks scary. It merely exists in
    // development to aid in development asertions. Production builds of
    // ember strip this entire block out
    handleMandatorySetter = function handleMandatorySetter(m, obj, keyName) {
      var descriptor = emberUtils.lookupDescriptor(obj, keyName);
      var hasDescriptor = descriptor !== null;
      var configurable = hasDescriptor ? descriptor.configurable : true;
      var isWritable = hasDescriptor ? descriptor.writable : true;
      var hasValue = hasDescriptor ? 'value' in descriptor : true;
      var possibleDesc = hasDescriptor && descriptor.value;
      var isDescriptor = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor;

      if (isDescriptor) {
        return;
      }

      // this x in Y deopts, so keeping it in this function is better;
      if (configurable && isWritable && hasValue && keyName in obj) {
        var desc = {
          configurable: true,
          set: MANDATORY_SETTER_FUNCTION(keyName),
          enumerable: _propertyIsEnumerable(obj, keyName),
          get: undefined
        };

        if (_hasOwnProperty(obj, keyName)) {
          m.writeValues(keyName, obj[keyName]);
          desc.get = DEFAULT_GETTER_FUNCTION(keyName);
        } else {
          desc.get = INHERITING_GETTER_FUNCTION(keyName);
        }

        Object.defineProperty(obj, keyName, desc);
      }
    };
  }

  function unwatchKey(obj, keyName, _meta) {
    if (typeof obj !== 'object' || obj === null) {
      return;
    }
    var meta$$1 = _meta === undefined ? exports.peekMeta(obj) : _meta;

    // do nothing of this object has already been destroyed
    if (meta$$1 === undefined || meta$$1.isSourceDestroyed()) {
      return;
    }

    var count = meta$$1.peekWatching(keyName);
    if (count === 1) {
      meta$$1.writeWatching(keyName, 0);

      var possibleDesc = obj[keyName];
      var isDescriptor = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor;

      if (isDescriptor && possibleDesc.didUnwatch) {
        possibleDesc.didUnwatch(obj, keyName, meta$$1);
      }

      if (typeof obj.didUnwatchProperty === 'function') {
        obj.didUnwatchProperty(keyName);
      }

      if (ember_features.MANDATORY_SETTER) {
        // It is true, the following code looks quite WAT. But have no fear, It
        // exists purely to improve development ergonomics and is removed from
        // ember.min.js and ember.prod.js builds.
        //
        // Some further context: Once a property is watched by ember, bypassing `set`
        // for mutation, will bypass observation. This code exists to assert when
        // that occurs, and attempt to provide more helpful feedback. The alternative
        // is tricky to debug partially observable properties.
        if (!isDescriptor && keyName in obj) {
          var maybeMandatoryDescriptor = emberUtils.lookupDescriptor(obj, keyName);

          if (maybeMandatoryDescriptor.set && maybeMandatoryDescriptor.set.isMandatorySetter) {
            if (maybeMandatoryDescriptor.get && maybeMandatoryDescriptor.get.isInheritingGetter) {
              var possibleValue = meta$$1.readInheritedValue('values', keyName);
              if (possibleValue === UNDEFINED) {
                delete obj[keyName];
                return;
              }
            }

            Object.defineProperty(obj, keyName, {
              configurable: true,
              enumerable: Object.prototype.propertyIsEnumerable.call(obj, keyName),
              writable: true,
              value: meta$$1.peekValues(keyName)
            });
            meta$$1.deleteFromValues(keyName);
          }
        }
      }
    } else if (count > 1) {
      meta$$1.writeWatching(keyName, count - 1);
    }
  }

  function makeChainNode(obj) {
    return new ChainNode(null, null, obj);
  }

  function watchPath(obj, keyPath, meta$$1) {
    if (typeof obj !== 'object' || obj === null) {
      return;
    }
    var m = meta$$1 === undefined ? meta(obj) : meta$$1;
    var counter = m.peekWatching(keyPath) || 0;

    m.writeWatching(keyPath, counter + 1);
    if (counter === 0) {
      // activate watching first time
      m.writableChains(makeChainNode).add(keyPath);
    }
  }

  function unwatchPath(obj, keyPath, meta$$1) {
    if (typeof obj !== 'object' || obj === null) {
      return;
    }
    var m = meta$$1 === undefined ? exports.peekMeta(obj) : meta$$1;

    if (m === undefined) {
      return;
    }
    var counter = m.peekWatching(keyPath) || 0;

    if (counter === 1) {
      m.writeWatching(keyPath, 0);
      m.readableChains().remove(keyPath);
    } else if (counter > 1) {
      m.writeWatching(keyPath, counter - 1);
    }
  }

  var FIRST_KEY = /^([^\.]+)/;

  function firstKey(path) {
    return path.match(FIRST_KEY)[0];
  }

  function isObject(obj) {
    return typeof obj === 'object' && obj !== null;
  }

  function isVolatile(obj) {
    return !(isObject(obj) && obj.isDescriptor && obj._volatile === false);
  }

  var ChainWatchers = function () {
    function ChainWatchers() {
      emberBabel.classCallCheck(this, ChainWatchers);

      // chain nodes that reference a key in this obj by key
      // we only create ChainWatchers when we are going to add them
      // so create this upfront
      this.chains = Object.create(null);
    }

    ChainWatchers.prototype.add = function add(key, node) {
      var nodes = this.chains[key];
      if (nodes === undefined) {
        this.chains[key] = [node];
      } else {
        nodes.push(node);
      }
    };

    ChainWatchers.prototype.remove = function remove(key, node) {
      var nodes = this.chains[key];
      if (nodes !== undefined) {
        for (var i = 0; i < nodes.length; i++) {
          if (nodes[i] === node) {
            nodes.splice(i, 1);
            break;
          }
        }
      }
    };

    ChainWatchers.prototype.has = function has(key, node) {
      var nodes = this.chains[key];
      if (nodes !== undefined) {
        for (var i = 0; i < nodes.length; i++) {
          if (nodes[i] === node) {
            return true;
          }
        }
      }
      return false;
    };

    ChainWatchers.prototype.revalidateAll = function revalidateAll() {
      for (var key in this.chains) {
        this.notify(key, true, undefined);
      }
    };

    ChainWatchers.prototype.revalidate = function revalidate(key) {
      this.notify(key, true, undefined);
    };

    // key: the string key that is part of a path changed
    // revalidate: boolean; the chains that are watching this value should revalidate
    // callback: function that will be called with the object and path that
    //           will be/are invalidated by this key change, depending on
    //           whether the revalidate flag is passed


    ChainWatchers.prototype.notify = function notify(key, revalidate, callback) {
      var nodes = this.chains[key];
      if (nodes === undefined || nodes.length === 0) {
        return;
      }

      var affected = void 0;

      if (callback) {
        affected = [];
      }

      for (var i = 0; i < nodes.length; i++) {
        nodes[i].notify(revalidate, affected);
      }

      if (callback === undefined) {
        return;
      }

      // we gather callbacks so we don't notify them during revalidation
      for (var _i = 0; _i < affected.length; _i += 2) {
        var obj = affected[_i];
        var path = affected[_i + 1];
        callback(obj, path);
      }
    };

    return ChainWatchers;
  }();

  function makeChainWatcher() {
    return new ChainWatchers();
  }

  function addChainWatcher(obj, keyName, node) {
    var m = meta(obj);
    m.writableChainWatchers(makeChainWatcher).add(keyName, node);
    watchKey(obj, keyName, m);
  }

  function removeChainWatcher(obj, keyName, node, _meta) {
    if (!isObject(obj)) {
      return;
    }

    var meta$$1 = _meta === undefined ? exports.peekMeta(obj) : _meta;

    if (meta$$1 === undefined || meta$$1.readableChainWatchers() === undefined) {
      return;
    }

    // make meta writable
    meta$$1 = meta(obj);

    meta$$1.readableChainWatchers().remove(keyName, node);

    unwatchKey(obj, keyName, meta$$1);
  }

  // A ChainNode watches a single key on an object. If you provide a starting
  // value for the key then the node won't actually watch it. For a root node
  // pass null for parent and key and object for value.

  var ChainNode = function () {
    function ChainNode(parent, key, value) {
      emberBabel.classCallCheck(this, ChainNode);

      this._parent = parent;
      this._key = key;

      // _watching is true when calling get(this._parent, this._key) will
      // return the value of this node.
      //
      // It is false for the root of a chain (because we have no parent)
      // and for global paths (because the parent node is the object with
      // the observer on it)
      var isWatching = this._watching = value === undefined;

      this._chains = undefined;
      this._object = undefined;
      this.count = 0;

      this._value = value;
      this._paths = undefined;
      if (isWatching) {
        var obj = parent.value();

        if (!isObject(obj)) {
          return;
        }

        this._object = obj;

        addChainWatcher(this._object, this._key, this);
      }
    }

    ChainNode.prototype.value = function value() {
      if (this._value === undefined && this._watching) {
        var obj = this._parent.value();
        this._value = lazyGet(obj, this._key);
      }
      return this._value;
    };

    ChainNode.prototype.destroy = function destroy() {
      if (this._watching) {
        removeChainWatcher(this._object, this._key, this);
        this._watching = false; // so future calls do nothing
      }
    };

    // copies a top level object only


    ChainNode.prototype.copy = function copy(obj) {
      var ret = new ChainNode(null, null, obj);
      var paths = this._paths;
      if (paths !== undefined) {
        var path = void 0;
        for (path in paths) {
          if (paths[path] > 0) {
            ret.add(path);
          }
        }
      }
      return ret;
    };

    // called on the root node of a chain to setup watchers on the specified
    // path.


    ChainNode.prototype.add = function add(path) {
      var paths = this._paths || (this._paths = {});
      paths[path] = (paths[path] || 0) + 1;

      var key = firstKey(path);
      var tail = path.slice(key.length + 1);

      this.chain(key, tail);
    };

    // called on the root node of a chain to teardown watcher on the specified
    // path


    ChainNode.prototype.remove = function remove(path) {
      var paths = this._paths;
      if (paths === undefined) {
        return;
      }

      if (paths[path] > 0) {
        paths[path]--;
      } else {
        return;
      }

      var key = firstKey(path);
      var tail = path.slice(key.length + 1);

      this.unchain(key, tail);
    };

    ChainNode.prototype.chain = function chain(key, path) {
      var chains = this._chains;
      var node = void 0;
      if (chains === undefined) {
        chains = this._chains = Object.create(null);
      } else {
        node = chains[key];
      }

      if (node === undefined) {
        node = chains[key] = new ChainNode(this, key, undefined);
      }

      node.count++; // count chains...

      // chain rest of path if there is one
      if (path) {
        key = firstKey(path);
        path = path.slice(key.length + 1);
        node.chain(key, path);
      }
    };

    ChainNode.prototype.unchain = function unchain(key, path) {
      var chains = this._chains;
      var node = chains[key];

      // unchain rest of path first...
      if (path && path.length > 1) {
        var nextKey = firstKey(path);
        var nextPath = path.slice(nextKey.length + 1);
        node.unchain(nextKey, nextPath);
      }

      // delete node if needed.
      node.count--;
      if (node.count <= 0) {
        chains[node._key] = undefined;
        node.destroy();
      }
    };

    ChainNode.prototype.notify = function notify(revalidate, affected) {
      if (revalidate && this._watching) {
        var parentValue = this._parent.value();

        if (parentValue !== this._object) {
          removeChainWatcher(this._object, this._key, this);

          if (isObject(parentValue)) {
            this._object = parentValue;
            addChainWatcher(parentValue, this._key, this);
          } else {
            this._object = undefined;
          }
        }
        this._value = undefined;
      }

      // then notify chains...
      var chains = this._chains;
      if (chains !== undefined) {
        var node = void 0;
        for (var key in chains) {
          node = chains[key];
          if (node !== undefined) {
            node.notify(revalidate, affected);
          }
        }
      }

      if (affected && this._parent) {
        this._parent.populateAffected(this._key, 1, affected);
      }
    };

    ChainNode.prototype.populateAffected = function populateAffected(path, depth, affected) {
      if (this._key) {
        path = this._key + '.' + path;
      }

      if (this._parent) {
        this._parent.populateAffected(path, depth + 1, affected);
      } else if (depth > 1) {
        affected.push(this.value(), path);
      }
    };

    return ChainNode;
  }();

  function lazyGet(obj, key) {
    if (!isObject(obj)) {
      return;
    }

    var meta$$1 = exports.peekMeta(obj);

    // check if object meant only to be a prototype
    if (meta$$1 !== undefined && meta$$1.proto === obj) {
      return;
    }

    // Use `get` if the return value is an EachProxy or an uncacheable value.
    if (isVolatile(obj[key])) {
      return get(obj, key);
      // Otherwise attempt to get the cached value of the computed property
    } else {
      var cache = meta$$1.readableCache();
      if (cache !== undefined) {
        return cacheFor.get(cache, key);
      }
    }
  }

  function finishChains(meta$$1) {
    // finish any current chains node watchers that reference obj
    var chainWatchers = meta$$1.readableChainWatchers();
    if (chainWatchers !== undefined) {
      chainWatchers.revalidateAll();
    }
    // ensure that if we have inherited any chains they have been
    // copied onto our own meta.
    if (meta$$1.readableChains() !== undefined) {
      meta$$1.writableChains(makeChainNode);
    }
  }

  var counters = void 0;
  {
    counters = {
      peekCalls: 0,
      peekParentCalls: 0,
      peekPrototypeWalks: 0,
      setCalls: 0,
      deleteCalls: 0,
      metaCalls: 0,
      metaInstantiated: 0
    };
  }

  /**
  @module ember
  */

  var UNDEFINED = emberUtils.symbol('undefined');

  // FLAGS
  var SOURCE_DESTROYING = 1 << 1;
  var SOURCE_DESTROYED = 1 << 2;
  var META_DESTROYED = 1 << 3;
  var IS_PROXY = 1 << 4;

  var META_FIELD = '__ember_meta__';
  var NODE_STACK = [];

  var Meta = function () {
    function Meta(obj, parentMeta) {
      emberBabel.classCallCheck(this, Meta);

      {
        counters.metaInstantiated++;
      }

      this._cache = undefined;
      this._weak = undefined;
      this._watching = undefined;
      this._mixins = undefined;
      this._bindings = undefined;
      this._values = undefined;
      this._deps = undefined;
      this._chainWatchers = undefined;
      this._chains = undefined;
      this._tag = undefined;
      this._tags = undefined;
      this._factory = undefined;

      // initial value for all flags right now is false
      // see FLAGS const for detailed list of flags used
      this._flags = 0;

      // used only internally
      this.source = obj;

      // when meta(obj).proto === obj, the object is intended to be only a
      // prototype and doesn't need to actually be observable itself
      this.proto = undefined;

      // The next meta in our inheritance chain. We (will) track this
      // explicitly instead of using prototypical inheritance because we
      // have detailed knowledge of how each property should really be
      // inherited, and we can optimize it much better than JS runtimes.
      this.parent = parentMeta;

      this._listeners = undefined;
      this._listenersFinalized = false;
      this._suspendedListeners = undefined;
    }

    Meta.prototype.isInitialized = function isInitialized(obj) {
      return this.proto !== obj;
    };

    Meta.prototype.destroy = function destroy() {
      if (this.isMetaDestroyed()) {
        return;
      }

      // remove chainWatchers to remove circular references that would prevent GC
      var nodes = void 0,
          key = void 0,
          nodeObject = void 0;
      var node = this.readableChains();
      if (node !== undefined) {
        NODE_STACK.push(node);
        // process tree
        while (NODE_STACK.length > 0) {
          node = NODE_STACK.pop();
          // push children
          nodes = node._chains;
          if (nodes !== undefined) {
            for (key in nodes) {
              if (nodes[key] !== undefined) {
                NODE_STACK.push(nodes[key]);
              }
            }
          }

          // remove chainWatcher in node object
          if (node._watching) {
            nodeObject = node._object;
            if (nodeObject !== undefined) {
              var foreignMeta = exports.peekMeta(nodeObject);
              // avoid cleaning up chain watchers when both current and
              // foreign objects are being destroyed
              // if both are being destroyed manual cleanup is not needed
              // as they will be GC'ed and no non-destroyed references will
              // be remaining
              if (foreignMeta && !foreignMeta.isSourceDestroying()) {
                removeChainWatcher(nodeObject, node._key, node, foreignMeta);
              }
            }
          }
        }
      }

      this.setMetaDestroyed();
    };

    Meta.prototype.isSourceDestroying = function isSourceDestroying() {
      return (this._flags & SOURCE_DESTROYING) !== 0;
    };

    Meta.prototype.setSourceDestroying = function setSourceDestroying() {
      this._flags |= SOURCE_DESTROYING;
    };

    Meta.prototype.isSourceDestroyed = function isSourceDestroyed() {
      return (this._flags & SOURCE_DESTROYED) !== 0;
    };

    Meta.prototype.setSourceDestroyed = function setSourceDestroyed() {
      this._flags |= SOURCE_DESTROYED;
    };

    Meta.prototype.isMetaDestroyed = function isMetaDestroyed() {
      return (this._flags & META_DESTROYED) !== 0;
    };

    Meta.prototype.setMetaDestroyed = function setMetaDestroyed() {
      this._flags |= META_DESTROYED;
    };

    Meta.prototype.isProxy = function isProxy() {
      return (this._flags & IS_PROXY) !== 0;
    };

    Meta.prototype.setProxy = function setProxy() {
      this._flags |= IS_PROXY;
    };

    Meta.prototype._getOrCreateOwnMap = function _getOrCreateOwnMap(key) {
      return this[key] || (this[key] = Object.create(null));
    };

    Meta.prototype._getInherited = function _getInherited(key) {
      var pointer = this;
      while (pointer !== undefined) {
        var map = pointer[key];
        if (map !== undefined) {
          return map;
        }
        pointer = pointer.parent;
      }
    };

    Meta.prototype._findInherited = function _findInherited(key, subkey) {
      var pointer = this;
      while (pointer !== undefined) {
        var map = pointer[key];
        if (map !== undefined) {
          var value = map[subkey];
          if (value !== undefined) {
            return value;
          }
        }
        pointer = pointer.parent;
      }
    };

    // Implements a member that provides a lazily created map of maps,
    // with inheritance at both levels.


    Meta.prototype.writeDeps = function writeDeps(subkey, itemkey, value) {
      true && !!this.isMetaDestroyed() && emberDebug.assert('Cannot modify dependent keys for `' + itemkey + '` on `' + emberUtils.toString(this.source) + '` after it has been destroyed.', !this.isMetaDestroyed());

      var outerMap = this._getOrCreateOwnMap('_deps');
      var innerMap = outerMap[subkey];
      if (innerMap === undefined) {
        innerMap = outerMap[subkey] = Object.create(null);
      }
      innerMap[itemkey] = value;
    };

    Meta.prototype.peekDeps = function peekDeps(subkey, itemkey) {
      var pointer = this;
      while (pointer !== undefined) {
        var map = pointer._deps;
        if (map !== undefined) {
          var value = map[subkey];
          if (value !== undefined) {
            var itemvalue = value[itemkey];
            if (itemvalue !== undefined) {
              return itemvalue;
            }
          }
        }
        pointer = pointer.parent;
      }
    };

    Meta.prototype.hasDeps = function hasDeps(subkey) {
      var pointer = this;
      while (pointer !== undefined) {
        var deps = pointer._deps;
        if (deps !== undefined && deps[subkey] !== undefined) {
          return true;
        }
        pointer = pointer.parent;
      }
      return false;
    };

    Meta.prototype.forEachInDeps = function forEachInDeps(subkey, fn) {
      return this._forEachIn('_deps', subkey, fn);
    };

    Meta.prototype._forEachIn = function _forEachIn(key, subkey, fn) {
      var pointer = this;
      var seen = void 0;
      var calls = void 0;
      while (pointer !== undefined) {
        var map = pointer[key];
        if (map !== undefined) {
          var innerMap = map[subkey];
          if (innerMap !== undefined) {
            for (var innerKey in innerMap) {
              seen = seen || Object.create(null);
              if (seen[innerKey] === undefined) {
                seen[innerKey] = true;
                calls = calls || [];
                calls.push(innerKey, innerMap[innerKey]);
              }
            }
          }
        }
        pointer = pointer.parent;
      }

      if (calls !== undefined) {
        for (var i = 0; i < calls.length; i += 2) {
          fn(calls[i], calls[i + 1]);
        }
      }
    };

    Meta.prototype.writableCache = function writableCache() {
      return this._getOrCreateOwnMap('_cache');
    };

    Meta.prototype.readableCache = function readableCache() {
      return this._cache;
    };

    Meta.prototype.writableWeak = function writableWeak() {
      return this._getOrCreateOwnMap('_weak');
    };

    Meta.prototype.readableWeak = function readableWeak() {
      return this._weak;
    };

    Meta.prototype.writableTags = function writableTags() {
      return this._getOrCreateOwnMap('_tags');
    };

    Meta.prototype.readableTags = function readableTags() {
      return this._tags;
    };

    Meta.prototype.writableTag = function writableTag(create) {
      true && !!this.isMetaDestroyed() && emberDebug.assert('Cannot create a new tag for `' + emberUtils.toString(this.source) + '` after it has been destroyed.', !this.isMetaDestroyed());

      var ret = this._tag;
      if (ret === undefined) {
        ret = this._tag = create(this.source);
      }
      return ret;
    };

    Meta.prototype.readableTag = function readableTag() {
      return this._tag;
    };

    Meta.prototype.writableChainWatchers = function writableChainWatchers(create) {
      true && !!this.isMetaDestroyed() && emberDebug.assert('Cannot create a new chain watcher for `' + emberUtils.toString(this.source) + '` after it has been destroyed.', !this.isMetaDestroyed());

      var ret = this._chainWatchers;
      if (ret === undefined) {
        ret = this._chainWatchers = create(this.source);
      }
      return ret;
    };

    Meta.prototype.readableChainWatchers = function readableChainWatchers() {
      return this._chainWatchers;
    };

    Meta.prototype.writableChains = function writableChains(create) {
      true && !!this.isMetaDestroyed() && emberDebug.assert('Cannot create a new chains for `' + emberUtils.toString(this.source) + '` after it has been destroyed.', !this.isMetaDestroyed());

      var ret = this._chains;
      if (ret === undefined) {
        if (this.parent === undefined) {
          ret = create(this.source);
        } else {
          ret = this.parent.writableChains(create).copy(this.source);
        }
        this._chains = ret;
      }
      return ret;
    };

    Meta.prototype.readableChains = function readableChains() {
      return this._getInherited('_chains');
    };

    Meta.prototype.writeWatching = function writeWatching(subkey, value) {
      true && !!this.isMetaDestroyed() && emberDebug.assert('Cannot update watchers for `' + subkey + '` on `' + emberUtils.toString(this.source) + '` after it has been destroyed.', !this.isMetaDestroyed());

      var map = this._getOrCreateOwnMap('_watching');
      map[subkey] = value;
    };

    Meta.prototype.peekWatching = function peekWatching(subkey) {
      return this._findInherited('_watching', subkey);
    };

    Meta.prototype.writeMixins = function writeMixins(subkey, value) {
      true && !!this.isMetaDestroyed() && emberDebug.assert('Cannot add mixins for `' + subkey + '` on `' + emberUtils.toString(this.source) + '` call writeMixins after it has been destroyed.', !this.isMetaDestroyed());

      var map = this._getOrCreateOwnMap('_mixins');
      map[subkey] = value;
    };

    Meta.prototype.peekMixins = function peekMixins(subkey) {
      return this._findInherited('_mixins', subkey);
    };

    Meta.prototype.forEachMixins = function forEachMixins(fn) {
      var pointer = this;
      var seen = void 0;
      while (pointer !== undefined) {
        var map = pointer._mixins;
        if (map !== undefined) {
          for (var key in map) {
            seen = seen || Object.create(null);
            if (seen[key] === undefined) {
              seen[key] = true;
              fn(key, map[key]);
            }
          }
        }
        pointer = pointer.parent;
      }
    };

    Meta.prototype.writeBindings = function writeBindings(subkey, value) {
      true && !!this.isMetaDestroyed() && emberDebug.assert('Cannot add a binding for `' + subkey + '` on `' + emberUtils.toString(this.source) + '` after it has been destroyed.', !this.isMetaDestroyed());

      var map = this._getOrCreateOwnMap('_bindings');
      map[subkey] = value;
    };

    Meta.prototype.peekBindings = function peekBindings(subkey) {
      return this._findInherited('_bindings', subkey);
    };

    Meta.prototype.forEachBindings = function forEachBindings(fn) {
      var pointer = this;
      var seen = void 0;
      while (pointer !== undefined) {
        var map = pointer._bindings;
        if (map !== undefined) {
          for (var key in map) {
            seen = seen || Object.create(null);
            if (seen[key] === undefined) {
              seen[key] = true;
              fn(key, map[key]);
            }
          }
        }
        pointer = pointer.parent;
      }
    };

    Meta.prototype.clearBindings = function clearBindings() {
      true && !!this.isMetaDestroyed() && emberDebug.assert('Cannot clear bindings on `' + emberUtils.toString(this.source) + '` after it has been destroyed.', !this.isMetaDestroyed());

      this._bindings = undefined;
    };

    Meta.prototype.writeValues = function writeValues(subkey, value) {
      true && !!this.isMetaDestroyed() && emberDebug.assert('Cannot set the value of `' + subkey + '` on `' + emberUtils.toString(this.source) + '` after it has been destroyed.', !this.isMetaDestroyed());

      var map = this._getOrCreateOwnMap('_values');
      map[subkey] = value;
    };

    Meta.prototype.peekValues = function peekValues(subkey) {
      return this._findInherited('_values', subkey);
    };

    Meta.prototype.deleteFromValues = function deleteFromValues(subkey) {
      delete this._getOrCreateOwnMap('_values')[subkey];
    };

    emberBabel.createClass(Meta, [{
      key: 'factory',
      set: function (factory) {
        this._factory = factory;
      },
      get: function () {
        return this._factory;
      }
    }]);

    return Meta;
  }();

  for (var name in protoMethods) {
    Meta.prototype[name] = protoMethods[name];
  }

  var META_DESC = {
    writable: true,
    configurable: true,
    enumerable: false,
    value: null
  };

  var EMBER_META_PROPERTY = {
    name: META_FIELD,
    descriptor: META_DESC
  };

  if (ember_features.MANDATORY_SETTER) {
    Meta.prototype.readInheritedValue = function (key, subkey) {
      var internalKey = '_' + key;

      var pointer = this;

      while (pointer !== undefined) {
        var map = pointer[internalKey];
        if (map !== undefined) {
          var value = map[subkey];
          if (value !== undefined || subkey in map) {
            return value;
          }
        }
        pointer = pointer.parent;
      }

      return UNDEFINED;
    };

    Meta.prototype.writeValue = function (obj, key, value) {
      var descriptor = emberUtils.lookupDescriptor(obj, key);
      var isMandatorySetter = descriptor !== null && descriptor.set && descriptor.set.isMandatorySetter;

      if (isMandatorySetter) {
        this.writeValues(key, value);
      } else {
        obj[key] = value;
      }
    };
  }

  var setMeta = void 0;
  exports.peekMeta = void 0;

  // choose the one appropriate for given platform
  if (emberUtils.HAS_NATIVE_WEAKMAP) {
    var getPrototypeOf = Object.getPrototypeOf;
    var metaStore = new WeakMap();

    setMeta = function WeakMap_setMeta(obj, meta) {
      {
        counters.setCalls++;
      }
      metaStore.set(obj, meta);
    };

    exports.peekMeta = function WeakMap_peekParentMeta(obj) {
      var pointer = obj;
      var meta = void 0;
      while (pointer !== undefined && pointer !== null) {
        meta = metaStore.get(pointer);
        // jshint loopfunc:true
        {
          counters.peekCalls++;
        }
        if (meta !== undefined) {
          return meta;
        }

        pointer = getPrototypeOf(pointer);
        {
          counters.peekPrototypeWalks++;
        }
      }
    };
  } else {
    setMeta = function Fallback_setMeta(obj, meta) {
      if (obj.__defineNonEnumerable) {
        obj.__defineNonEnumerable(EMBER_META_PROPERTY);
      } else {
        Object.defineProperty(obj, META_FIELD, META_DESC);
      }

      obj[META_FIELD] = meta;
    };

    exports.peekMeta = function Fallback_peekMeta(obj) {
      return obj[META_FIELD];
    };
  }

  /**
    Tears down the meta on an object so that it can be garbage collected.
    Multiple calls will have no effect.
  
    @method deleteMeta
    @for Ember
    @param {Object} obj  the object to destroy
    @return {void}
    @private
  */
  function deleteMeta(obj) {
    {
      counters.deleteCalls++;
    }

    var meta = exports.peekMeta(obj);
    if (meta !== undefined) {
      meta.destroy();
    }
  }

  /**
    Retrieves the meta hash for an object. If `writable` is true ensures the
    hash is writable for this object as well.
  
    The meta object contains information about computed property descriptors as
    well as any watched properties and other information. You generally will
    not access this information directly but instead work with higher level
    methods that manipulate this hash indirectly.
  
    @method meta
    @for Ember
    @private
  
    @param {Object} obj The object to retrieve meta for
    @param {Boolean} [writable=true] Pass `false` if you do not intend to modify
      the meta hash, allowing the method to avoid making an unnecessary copy.
    @return {Object} the meta hash for an object
  */
  function meta(obj) {
    {
      counters.metaCalls++;
    }

    var maybeMeta = exports.peekMeta(obj);
    var parent = void 0;

    // remove this code, in-favor of explicit parent
    if (maybeMeta !== undefined) {
      if (maybeMeta.source === obj) {
        return maybeMeta;
      }
      parent = maybeMeta;
    }

    var newMeta = new Meta(obj, parent);
    setMeta(obj, newMeta);
    return newMeta;
  }

  var Cache = function () {
    function Cache(limit, func, key, store) {
      emberBabel.classCallCheck(this, Cache);

      this.size = 0;
      this.misses = 0;
      this.hits = 0;
      this.limit = limit;
      this.func = func;
      this.key = key;
      this.store = store || new DefaultStore();
    }

    Cache.prototype.get = function get(obj) {
      var key = this.key === undefined ? obj : this.key(obj);
      var value = this.store.get(key);
      if (value === undefined) {
        this.misses++;
        value = this._set(key, this.func(obj));
      } else if (value === UNDEFINED) {
        this.hits++;
        value = undefined;
      } else {
        this.hits++;
        // nothing to translate
      }

      return value;
    };

    Cache.prototype.set = function set(obj, value) {
      var key = this.key === undefined ? obj : this.key(obj);
      return this._set(key, value);
    };

    Cache.prototype._set = function _set(key, value) {
      if (this.limit > this.size) {
        this.size++;
        if (value === undefined) {
          this.store.set(key, UNDEFINED);
        } else {
          this.store.set(key, value);
        }
      }

      return value;
    };

    Cache.prototype.purge = function purge() {
      this.store.clear();
      this.size = 0;
      this.hits = 0;
      this.misses = 0;
    };

    return Cache;
  }();

  var DefaultStore = function () {
    function DefaultStore() {
      emberBabel.classCallCheck(this, DefaultStore);

      this.data = Object.create(null);
    }

    DefaultStore.prototype.get = function get(key) {
      return this.data[key];
    };

    DefaultStore.prototype.set = function set(key, value) {
      this.data[key] = value;
    };

    DefaultStore.prototype.clear = function clear() {
      this.data = Object.create(null);
    };

    return DefaultStore;
  }();

  var IS_GLOBAL_PATH = /^[A-Z$].*[\.]/;

  var isGlobalPathCache = new Cache(1000, function (key) {
    return IS_GLOBAL_PATH.test(key);
  });
  var firstDotIndexCache = new Cache(1000, function (key) {
    return key.indexOf('.');
  });

  var firstKeyCache = new Cache(1000, function (path) {
    var index = firstDotIndexCache.get(path);
    return index === -1 ? path : path.slice(0, index);
  });

  var tailPathCache = new Cache(1000, function (path) {
    var index = firstDotIndexCache.get(path);
    return index === -1 ? undefined : path.slice(index + 1);
  });

  function isGlobalPath(path) {
    return isGlobalPathCache.get(path);
  }

  function isPath(path) {
    return firstDotIndexCache.get(path) !== -1;
  }

  function getFirstKey(path) {
    return firstKeyCache.get(path);
  }

  function getTailPath(path) {
    return tailPathCache.get(path);
  }

  /**
  @module @ember/object
  */

  var ALLOWABLE_TYPES = {
    object: true,
    function: true,
    string: true
  };

  // ..........................................................
  // GET AND SET
  //
  // If we are on a platform that supports accessors we can use those.
  // Otherwise simulate accessors by looking up the property directly on the
  // object.

  /**
    Gets the value of a property on an object. If the property is computed,
    the function will be invoked. If the property is not defined but the
    object implements the `unknownProperty` method then that will be invoked.
  
    ```javascript
    Ember.get(obj, "name");
    ```
  
    If you plan to run on IE8 and older browsers then you should use this
    method anytime you want to retrieve a property on an object that you don't
    know for sure is private. (Properties beginning with an underscore '_'
    are considered private.)
  
    On all newer browsers, you only need to use this method to retrieve
    properties if the property might not be defined on the object and you want
    to respect the `unknownProperty` handler. Otherwise you can ignore this
    method.
  
    Note that if the object itself is `undefined`, this method will throw
    an error.
  
    @method get
    @for @ember/object
    @static
    @param {Object} obj The object to retrieve from.
    @param {String} keyName The property key to retrieve
    @return {Object} the property value or `null`.
    @public
  */
  function get(obj, keyName) {
    true && !(arguments.length === 2) && emberDebug.assert('Get must be called with two arguments; an object and a property key', arguments.length === 2);
    true && !(obj !== undefined && obj !== null) && emberDebug.assert('Cannot call get with \'' + keyName + '\' on an undefined object.', obj !== undefined && obj !== null);
    true && !(typeof keyName === 'string') && emberDebug.assert('The key provided to get must be a string, you passed ' + keyName, typeof keyName === 'string');
    true && !(keyName.lastIndexOf('this.', 0) !== 0) && emberDebug.assert('\'this\' in paths is not supported', keyName.lastIndexOf('this.', 0) !== 0);
    true && !(keyName !== '') && emberDebug.assert('Cannot call `Ember.get` with an empty string', keyName !== '');

    var value = obj[keyName];
    var isDescriptor = value !== null && typeof value === 'object' && value.isDescriptor;

    if (isDescriptor) {
      return value.get(obj, keyName);
    } else if (isPath(keyName)) {
      return _getPath(obj, keyName);
    } else if (value === undefined && 'object' === typeof obj && !(keyName in obj) && typeof obj.unknownProperty === 'function') {
      return obj.unknownProperty(keyName);
    } else {
      return value;
    }
  }

  function _getPath(root, path) {
    var obj = root;
    var parts = path.split('.');

    for (var i = 0; i < parts.length; i++) {
      if (!isGettable(obj)) {
        return undefined;
      }

      obj = get(obj, parts[i]);

      if (obj && obj.isDestroyed) {
        return undefined;
      }
    }

    return obj;
  }

  function isGettable(obj) {
    return obj !== undefined && obj !== null && ALLOWABLE_TYPES[typeof obj];
  }

  /**
    Retrieves the value of a property from an Object, or a default value in the
    case that the property returns `undefined`.
  
    ```javascript
    Ember.getWithDefault(person, 'lastName', 'Doe');
    ```
  
    @method getWithDefault
    @for @ember/object
    @static
    @param {Object} obj The object to retrieve from.
    @param {String} keyName The name of the property to retrieve
    @param {Object} defaultValue The value to return if the property value is undefined
    @return {Object} The property value or the defaultValue.
    @public
  */
  function getWithDefault(root, key, defaultValue) {
    var value = get(root, key);

    if (value === undefined) {
      return defaultValue;
    }
    return value;
  }

  /**
   @module @ember/object
  */
  /**
    Sets the value of a property on an object, respecting computed properties
    and notifying observers and other listeners of the change. If the
    property is not defined but the object implements the `setUnknownProperty`
    method then that will be invoked as well.
  
    ```javascript
    Ember.set(obj, "name", value);
    ```
  
    @method set
    @static
    @for @ember/object
    @param {Object} obj The object to modify.
    @param {String} keyName The property key to set
    @param {Object} value The value to set
    @return {Object} the passed value.
    @public
  */
  function set(obj, keyName, value, tolerant) {
    true && !(arguments.length === 3 || arguments.length === 4) && emberDebug.assert('Set must be called with three or four arguments; an object, a property key, a value and tolerant true/false', arguments.length === 3 || arguments.length === 4);
    true && !(obj && typeof obj === 'object' || typeof obj === 'function') && emberDebug.assert('Cannot call set with \'' + keyName + '\' on an undefined object.', obj && typeof obj === 'object' || typeof obj === 'function');
    true && !(typeof keyName === 'string') && emberDebug.assert('The key provided to set must be a string, you passed ' + keyName, typeof keyName === 'string');
    true && !(keyName.lastIndexOf('this.', 0) !== 0) && emberDebug.assert('\'this\' in paths is not supported', keyName.lastIndexOf('this.', 0) !== 0);
    true && !!obj.isDestroyed && emberDebug.assert('calling set on destroyed object: ' + emberUtils.toString(obj) + '.' + keyName + ' = ' + emberUtils.toString(value), !obj.isDestroyed);

    if (isPath(keyName)) {
      return setPath(obj, keyName, value, tolerant);
    }

    var currentValue = obj[keyName];
    var isDescriptor = currentValue !== null && typeof currentValue === 'object' && currentValue.isDescriptor;

    if (isDescriptor) {
      /* computed property */
      currentValue.set(obj, keyName, value);
    } else if (currentValue === undefined && 'object' === typeof obj && !(keyName in obj) && typeof obj.setUnknownProperty === 'function') {
      /* unknown property */
      obj.setUnknownProperty(keyName, value);
    } else if (currentValue === value) {/* no change */
    } else {
      var meta$$1 = exports.peekMeta(obj);
      propertyWillChange(obj, keyName, meta$$1);

      if (ember_features.MANDATORY_SETTER) {
        setWithMandatorySetter(meta$$1, obj, keyName, value);
      } else {
        obj[keyName] = value;
      }

      propertyDidChange(obj, keyName, meta$$1);
    }

    return value;
  }

  if (ember_features.MANDATORY_SETTER) {
    var setWithMandatorySetter = function (meta$$1, obj, keyName, value) {
      if (meta$$1 !== undefined && meta$$1.peekWatching(keyName) > 0) {
        makeEnumerable(obj, keyName);
        meta$$1.writeValue(obj, keyName, value);
      } else {
        obj[keyName] = value;
      }
    };

    var makeEnumerable = function (obj, key) {
      var desc = Object.getOwnPropertyDescriptor(obj, key);

      if (desc && desc.set && desc.set.isMandatorySetter) {
        desc.enumerable = true;
        Object.defineProperty(obj, key, desc);
      }
    };
  }

  function setPath(root, path, value, tolerant) {
    var parts = path.split('.');
    var keyName = parts.pop();

    true && !(keyName.trim().length > 0) && emberDebug.assert('Property set failed: You passed an empty path', keyName.trim().length > 0);

    var newPath = parts.join('.');

    var newRoot = _getPath(root, newPath);

    if (newRoot) {
      return set(newRoot, keyName, value);
    } else if (!tolerant) {
      throw new emberDebug.Error('Property set failed: object in path "' + newPath + '" could not be found or was destroyed.');
    }
  }

  /**
    Error-tolerant form of `Ember.set`. Will not blow up if any part of the
    chain is `undefined`, `null`, or destroyed.
  
    This is primarily used when syncing bindings, which may try to update after
    an object has been destroyed.
  
    @method trySet
    @static
    @for @ember/object
    @param {Object} root The object to modify.
    @param {String} path The property path to set
    @param {Object} value The value to set
    @public
  */
  function trySet(root, path, value) {
    return set(root, path, value, true);
  }

  /**
  @module @ember/object
  */

  var END_WITH_EACH_REGEX = /\.@each$/;

  /**
    Expands `pattern`, invoking `callback` for each expansion.
  
    The only pattern supported is brace-expansion, anything else will be passed
    once to `callback` directly.
  
    Example
  
    ```js
    import { expandProperties } from '@ember/object/computed';
  
    function echo(arg){ console.log(arg); }
  
    expandProperties('foo.bar', echo);              //=> 'foo.bar'
    expandProperties('{foo,bar}', echo);            //=> 'foo', 'bar'
    expandProperties('foo.{bar,baz}', echo);        //=> 'foo.bar', 'foo.baz'
    expandProperties('{foo,bar}.baz', echo);        //=> 'foo.baz', 'bar.baz'
    expandProperties('foo.{bar,baz}.[]', echo)      //=> 'foo.bar.[]', 'foo.baz.[]'
    expandProperties('{foo,bar}.{spam,eggs}', echo) //=> 'foo.spam', 'foo.eggs', 'bar.spam', 'bar.eggs'
    expandProperties('{foo}.bar.{baz}')             //=> 'foo.bar.baz'
    ```
  
    @method expandProperties
    @static
    @for @ember/object
    @public
    @param {String} pattern The property pattern to expand.
    @param {Function} callback The callback to invoke.  It is invoked once per
    expansion, and is passed the expansion.
  */
  function expandProperties(pattern, callback) {
    true && !(typeof pattern === 'string') && emberDebug.assert('A computed property key must be a string, you passed ' + typeof pattern + ' ' + pattern, typeof pattern === 'string');
    true && !(pattern.indexOf(' ') === -1) && emberDebug.assert('Brace expanded properties cannot contain spaces, e.g. "user.{firstName, lastName}" should be "user.{firstName,lastName}"', pattern.indexOf(' ') === -1);
    // regex to look for double open, double close, or unclosed braces

    true && !(pattern.match(/\{[^}{]*\{|\}[^}{]*\}|\{[^}]*$/g) === null) && emberDebug.assert('Brace expanded properties have to be balanced and cannot be nested, pattern: ' + pattern, pattern.match(/\{[^}{]*\{|\}[^}{]*\}|\{[^}]*$/g) === null);

    var start = pattern.indexOf('{');
    if (start < 0) {
      callback(pattern.replace(END_WITH_EACH_REGEX, '.[]'));
    } else {
      dive('', pattern, start, callback);
    }
  }

  function dive(prefix, pattern, start, callback) {
    var end = pattern.indexOf('}'),
        i = 0,
        newStart = void 0,
        arrayLength = void 0;
    var tempArr = pattern.substring(start + 1, end).split(',');
    var after = pattern.substring(end + 1);
    prefix = prefix + pattern.substring(0, start);

    arrayLength = tempArr.length;
    while (i < arrayLength) {
      newStart = after.indexOf('{');
      if (newStart < 0) {
        callback((prefix + tempArr[i++] + after).replace(END_WITH_EACH_REGEX, '.[]'));
      } else {
        dive(prefix + tempArr[i++], after, newStart, callback);
      }
    }
  }

  /**
  @module ember
  */
  /**
    Starts watching a property on an object. Whenever the property changes,
    invokes `Ember.propertyWillChange` and `Ember.propertyDidChange`. This is the
    primitive used by observers and dependent keys; usually you will never call
    this method directly but instead use higher level methods like
    `Ember.addObserver()`
  
    @private
    @method watch
    @for Ember
    @param obj
    @param {String} _keyPath
  */
  function watch(obj, _keyPath, m) {
    if (isPath(_keyPath)) {
      watchPath(obj, _keyPath, m);
    } else {
      watchKey(obj, _keyPath, m);
    }
  }

  function isWatching(obj, key) {
    return watcherCount(obj, key) > 0;
  }

  function watcherCount(obj, key) {
    var meta$$1 = exports.peekMeta(obj);
    return meta$$1 !== undefined && meta$$1.peekWatching(key) || 0;
  }

  function unwatch(obj, _keyPath, m) {
    if (isPath(_keyPath)) {
      unwatchPath(obj, _keyPath, m);
    } else {
      unwatchKey(obj, _keyPath, m);
    }
  }

  // ..........................................................
  // DEPENDENT KEYS
  //

  function addDependentKeys(desc, obj, keyName, meta) {
    // the descriptor has a list of dependent keys, so
    // add all of its dependent keys.
    var depKeys = desc._dependentKeys;
    if (depKeys === null || depKeys === undefined) {
      return;
    }

    for (var idx = 0; idx < depKeys.length; idx++) {
      var depKey = depKeys[idx];
      // Increment the number of times depKey depends on keyName.
      meta.writeDeps(depKey, keyName, (meta.peekDeps(depKey, keyName) || 0) + 1);
      // Watch the depKey
      watch(obj, depKey, meta);
    }
  }

  function removeDependentKeys(desc, obj, keyName, meta) {
    // the descriptor has a list of dependent keys, so
    // remove all of its dependent keys.
    var depKeys = desc._dependentKeys;
    if (depKeys === null || depKeys === undefined) {
      return;
    }

    for (var idx = 0; idx < depKeys.length; idx++) {
      var depKey = depKeys[idx];
      // Decrement the number of times depKey depends on keyName.
      meta.writeDeps(depKey, keyName, (meta.peekDeps(depKey, keyName) || 0) - 1);
      // Unwatch the depKey
      unwatch(obj, depKey, meta);
    }
  }

  /**
  @module @ember/object
  */

  var DEEP_EACH_REGEX = /\.@each\.[^.]+\./;

  /**
    A computed property transforms an object literal with object's accessor function(s) into a property.
  
    By default the function backing the computed property will only be called
    once and the result will be cached. You can specify various properties
    that your computed property depends on. This will force the cached
    result to be recomputed if the dependencies are modified.
  
    In the following example we declare a computed property - `fullName` - by calling
    `computed` with property dependencies (`firstName` and `lastName`) as leading arguments and getter accessor function. The `fullName` getter function
    will be called once (regardless of how many times it is accessed) as long
    as its dependencies have not changed. Once `firstName` or `lastName` are updated
    any future calls (or anything bound) to `fullName` will incorporate the new
    values.
  
    ```javascript
    import EmberObject, { computed } from '@ember/object';
  
    let Person = EmberObject.extend({
      // these will be supplied by `create`
      firstName: null,
      lastName: null,
  
      fullName: computed('firstName', 'lastName', function() {
        let firstName = this.get('firstName'),
            lastName  = this.get('lastName');
  
        return `${firstName} ${lastName}`;
      })
    });
  
    let tom = Person.create({
      firstName: 'Tom',
      lastName: 'Dale'
    });
  
    tom.get('fullName') // 'Tom Dale'
    ```
  
    You can also define what Ember should do when setting a computed property by providing additional function (`set`) in hash argument.
    If you try to set a computed property, it will try to invoke setter accessor function with the key and
    value you want to set it to as arguments.
  
    ```javascript
    import EmberObject, { computed } from '@ember/object';
  
    let Person = EmberObject.extend({
      // these will be supplied by `create`
      firstName: null,
      lastName: null,
  
      fullName: computed('firstName', 'lastName', {
        get(key) {
          let firstName = this.get('firstName'),
              lastName  = this.get('lastName');
  
          return firstName + ' ' + lastName;
        },
        set(key, value) {
          let [firstName, lastName] = value.split(' ');
  
          this.set('firstName', firstName);
          this.set('lastName', lastName);
  
          return value;
        }
      })
    });
  
    let person = Person.create();
  
    person.set('fullName', 'Peter Wagenet');
    person.get('firstName'); // 'Peter'
    person.get('lastName');  // 'Wagenet'
    ```
  
    You can overwrite computed property with normal property (no longer computed), that won't change if dependencies change, if you set computed property and it won't have setter accessor function defined.
  
    You can also mark computed property as `.readOnly()` and block all attempts to set it.
  
    ```javascript
    import EmberObject, { computed } from '@ember/object';
  
    let Person = EmberObject.extend({
      // these will be supplied by `create`
      firstName: null,
      lastName: null,
  
      fullName: computed('firstName', 'lastName', {
        get(key) {
          let firstName = this.get('firstName');
          let lastName  = this.get('lastName');
  
          return firstName + ' ' + lastName;
        }
      }).readOnly()
    });
  
    let person = Person.create();
    person.set('fullName', 'Peter Wagenet'); // Uncaught Error: Cannot set read-only property "fullName" on object: <(...):emberXXX>
    ```
  
    Additional resources:
    - [New CP syntax RFC](https://github.com/emberjs/rfcs/blob/master/text/0011-improved-cp-syntax.md)
    - [New computed syntax explained in "Ember 1.12 released" ](https://emberjs.com/blog/2015/05/13/ember-1-12-released.html#toc_new-computed-syntax)
  
    @class ComputedProperty
    @public
  */
  function ComputedProperty(config, opts) {
    this.isDescriptor = true;
    var hasGetterOnly = typeof config === 'function';
    if (hasGetterOnly) {
      this._getter = config;
    } else {
      true && !(typeof config === 'object' && !Array.isArray(config)) && emberDebug.assert('computed expects a function or an object as last argument.', typeof config === 'object' && !Array.isArray(config));
      true && !Object.keys(config).every(function (key) {
        return key === 'get' || key === 'set';
      }) && emberDebug.assert('Config object passed to computed can only contain `get` or `set` keys.', Object.keys(config).every(function (key) {
        return key === 'get' || key === 'set';
      }));

      this._getter = config.get;
      this._setter = config.set;
    }
    true && !(!!this._getter || !!this._setter) && emberDebug.assert('Computed properties must receive a getter or a setter, you passed none.', !!this._getter || !!this._setter);

    this._suspended = undefined;
    this._meta = undefined;
    this._volatile = false;

    this._dependentKeys = opts && opts.dependentKeys;
    this._readOnly = opts && hasGetterOnly && opts.readOnly === true;
  }

  ComputedProperty.prototype = new Descriptor();
  ComputedProperty.prototype.constructor = ComputedProperty;

  var ComputedPropertyPrototype = ComputedProperty.prototype;

  /**
    Call on a computed property to set it into non-cached mode. When in this
    mode the computed property will not automatically cache the return value.
  
    It also does not automatically fire any change events. You must manually notify
    any changes if you want to observe this property.
  
    Dependency keys have no effect on volatile properties as they are for cache
    invalidation and notification when cached value is invalidated.
  
    ```javascript
    import EmberObject, { computed } from '@ember/object';
  
    let outsideService = EmberObject.extend({
      value: computed(function() {
        return OutsideService.getValue();
      }).volatile()
    }).create();
    ```
  
    @method volatile
    @static
    @for @ember/object/computed
    @return {ComputedProperty} this
    @chainable
    @public
  */
  ComputedPropertyPrototype.volatile = function () {
    this._volatile = true;
    return this;
  };

  /**
    Call on a computed property to set it into read-only mode. When in this
    mode the computed property will throw an error when set.
  
    ```javascript
    import EmberObject, { computed } from '@ember/object';
  
    let Person = EmberObject.extend({
      guid: computed(function() {
        return 'guid-guid-guid';
      }).readOnly()
    });
  
    let person = Person.create();
  
    person.set('guid', 'new-guid'); // will throw an exception
    ```
  
    @method readOnly
    @static
    @for @ember/object/computed
    @return {ComputedProperty} this
    @chainable
    @public
  */
  ComputedPropertyPrototype.readOnly = function () {
    this._readOnly = true;
    true && !!(this._readOnly && this._setter && this._setter !== this._getter) && emberDebug.assert('Computed properties that define a setter using the new syntax cannot be read-only', !(this._readOnly && this._setter && this._setter !== this._getter));

    return this;
  };

  /**
    Sets the dependent keys on this computed property. Pass any number of
    arguments containing key paths that this computed property depends on.
  
    ```javascript
    import EmberObject, { computed } from '@ember/object';
  
    let President = EmberObject.extend({
      fullName: computed('firstName', 'lastName', function() {
        return this.get('firstName') + ' ' + this.get('lastName');
  
        // Tell Ember that this computed property depends on firstName
        // and lastName
      })
    });
  
    let president = President.create({
      firstName: 'Barack',
      lastName: 'Obama'
    });
  
    president.get('fullName'); // 'Barack Obama'
    ```
  
    @method property
    @static
    @for @ember/object/computed
    @param {String} path* zero or more property paths
    @return {ComputedProperty} this
    @chainable
    @public
  */
  ComputedPropertyPrototype.property = function () {
    var args = [];

    function addArg(property) {
      true && emberDebug.warn('Dependent keys containing @each only work one level deep. ' + ('You used the key "' + property + '" which is invalid. ') + 'Please create an intermediary computed property.', DEEP_EACH_REGEX.test(property) === false, { id: 'ember-metal.computed-deep-each' });

      args.push(property);
    }

    for (var i = 0; i < arguments.length; i++) {
      expandProperties(arguments[i], addArg);
    }

    this._dependentKeys = args;
    return this;
  };

  /**
    In some cases, you may want to annotate computed properties with additional
    metadata about how they function or what values they operate on. For example,
    computed property functions may close over variables that are then no longer
    available for introspection.
  
    You can pass a hash of these values to a computed property like this:
  
    ```
    import { computed } from '@ember/object';
    import Person from 'my-app/utils/person';
  
    person: computed(function() {
      let personId = this.get('personId');
      return Person.create({ id: personId });
    }).meta({ type: Person })
    ```
  
    The hash that you pass to the `meta()` function will be saved on the
    computed property descriptor under the `_meta` key. Ember runtime
    exposes a public API for retrieving these values from classes,
    via the `metaForProperty()` function.
  
    @method meta
    @static
    @for @ember/object/computed
    @param {Object} meta
    @chainable
    @public
  */
  ComputedPropertyPrototype.meta = function (meta$$1) {
    if (arguments.length === 0) {
      return this._meta || {};
    } else {
      this._meta = meta$$1;
      return this;
    }
  };

  // invalidate cache when CP key changes
  ComputedPropertyPrototype.didChange = function (obj, keyName) {
    // _suspended is set via a CP.set to ensure we don't clear
    // the cached value set by the setter
    if (this._volatile || this._suspended === obj) {
      return;
    }

    // don't create objects just to invalidate
    var meta$$1 = exports.peekMeta(obj);
    if (meta$$1 === undefined || meta$$1.source !== obj) {
      return;
    }

    var cache = meta$$1.readableCache();
    if (cache !== undefined && cache[keyName] !== undefined) {
      cache[keyName] = undefined;
      removeDependentKeys(this, obj, keyName, meta$$1);
    }
  };

  ComputedPropertyPrototype.get = function (obj, keyName) {
    if (this._volatile) {
      return this._getter.call(obj, keyName);
    }

    var meta$$1 = meta(obj);
    var cache = meta$$1.writableCache();

    var result = cache[keyName];
    if (result === UNDEFINED) {
      return undefined;
    } else if (result !== undefined) {
      return result;
    }

    var ret = this._getter.call(obj, keyName);
    cache[keyName] = ret === undefined ? UNDEFINED : ret;

    var chainWatchers = meta$$1.readableChainWatchers();
    if (chainWatchers !== undefined) {
      chainWatchers.revalidate(keyName);
    }
    addDependentKeys(this, obj, keyName, meta$$1);

    return ret;
  };

  ComputedPropertyPrototype.set = function computedPropertySetEntry(obj, keyName, value) {
    if (this._readOnly) {
      this._throwReadOnlyError(obj, keyName);
    }

    if (!this._setter) {
      return this.clobberSet(obj, keyName, value);
    }

    if (this._volatile) {
      return this.volatileSet(obj, keyName, value);
    }

    return this.setWithSuspend(obj, keyName, value);
  };

  ComputedPropertyPrototype._throwReadOnlyError = function computedPropertyThrowReadOnlyError(obj, keyName) {
    throw new emberDebug.Error('Cannot set read-only property "' + keyName + '" on object: ' + emberUtils.inspect(obj));
  };

  ComputedPropertyPrototype.clobberSet = function computedPropertyClobberSet(obj, keyName, value) {
    var cachedValue = cacheFor(obj, keyName);
    defineProperty(obj, keyName, null, cachedValue);
    set(obj, keyName, value);
    return value;
  };

  ComputedPropertyPrototype.volatileSet = function computedPropertyVolatileSet(obj, keyName, value) {
    return this._setter.call(obj, keyName, value);
  };

  ComputedPropertyPrototype.setWithSuspend = function computedPropertySetWithSuspend(obj, keyName, value) {
    var oldSuspended = this._suspended;
    this._suspended = obj;
    try {
      return this._set(obj, keyName, value);
    } finally {
      this._suspended = oldSuspended;
    }
  };

  ComputedPropertyPrototype._set = function computedPropertySet(obj, keyName, value) {
    var meta$$1 = meta(obj);
    var cache = meta$$1.writableCache();
    var hadCachedValue = false;
    var cachedValue = void 0;
    var val = cache[keyName];
    if (val !== undefined) {
      if (val !== UNDEFINED) {
        cachedValue = val;
      }
      hadCachedValue = true;
    }

    var ret = this._setter.call(obj, keyName, value, cachedValue);

    // allows setter to return the same value that is cached already
    if (hadCachedValue && cachedValue === ret) {
      return ret;
    }

    propertyWillChange(obj, keyName, meta$$1);

    if (hadCachedValue) {
      cache[keyName] = undefined;
    } else {
      addDependentKeys(this, obj, keyName, meta$$1);
    }

    if (ret === undefined) {
      cache[keyName] = UNDEFINED;
    } else {
      cache[keyName] = ret;
    }

    propertyDidChange(obj, keyName, meta$$1);

    return ret;
  };

  /* called before property is overridden */
  ComputedPropertyPrototype.teardown = function (obj, keyName, meta$$1) {
    if (this._volatile) {
      return;
    }
    var cache = meta$$1.readableCache();
    if (cache !== undefined && cache[keyName] !== undefined) {
      removeDependentKeys(this, obj, keyName, meta$$1);
      cache[keyName] = undefined;
    }
  };

  /**
    This helper returns a new property descriptor that wraps the passed
    computed property function. You can use this helper to define properties
    with mixins or via `defineProperty()`.
  
    If you pass a function as an argument, it will be used as a getter. A computed
    property defined in this way might look like this:
  
    ```js
    import EmberObject, { computed } from '@ember/object';
  
    let Person = EmberObject.extend({
      init() {
        this._super(...arguments);
  
        this.firstName = 'Betty';
        this.lastName = 'Jones';
      },
  
      fullName: computed('firstName', 'lastName', function() {
        return `${this.get('firstName')} ${this.get('lastName')}`;
      })
    });
  
    let client = Person.create();
  
    client.get('fullName'); // 'Betty Jones'
  
    client.set('lastName', 'Fuller');
    client.get('fullName'); // 'Betty Fuller'
    ```
  
    You can pass a hash with two functions, `get` and `set`, as an
    argument to provide both a getter and setter:
  
    ```js
    import EmberObject, { computed } from '@ember/object';
  
    let Person = EmberObject.extend({
      init() {
        this._super(...arguments);
  
        this.firstName = 'Betty';
        this.lastName = 'Jones';
      },
  
      fullName: computed('firstName', 'lastName', {
        get(key) {
          return `${this.get('firstName')} ${this.get('lastName')}`;
        },
        set(key, value) {
          let [firstName, lastName] = value.split(/\s+/);
          this.setProperties({ firstName, lastName });
          return value;
        }
      })
    });
  
    let client = Person.create();
    client.get('firstName'); // 'Betty'
  
    client.set('fullName', 'Carroll Fuller');
    client.get('firstName'); // 'Carroll'
    ```
  
    The `set` function should accept two parameters, `key` and `value`. The value
    returned from `set` will be the new value of the property.
  
    _Note: This is the preferred way to define computed properties when writing third-party
    libraries that depend on or use Ember, since there is no guarantee that the user
    will have [prototype Extensions](https://emberjs.com/guides/configuring-ember/disabling-prototype-extensions/) enabled._
  
    The alternative syntax, with prototype extensions, might look like:
  
    ```js
    fullName: function() {
      return this.get('firstName') + ' ' + this.get('lastName');
    }.property('firstName', 'lastName')
    ```
  
    @method computed
    @for @ember/object
    @static
    @param {String} [dependentKeys*] Optional dependent keys that trigger this computed property.
    @param {Function} func The computed property function.
    @return {ComputedProperty} property descriptor instance
    @public
  */
  function computed() {
    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    var func = args.pop();

    var cp = new ComputedProperty(func);

    if (args.length > 0) {
      cp.property.apply(cp, args);
    }

    return cp;
  }

  /**
    Returns the cached value for a property, if one exists.
    This can be useful for peeking at the value of a computed
    property that is generated lazily, without accidentally causing
    it to be created.
  
    @method cacheFor
    @static
    @for @ember/object/internals
    @param {Object} obj the object whose property you want to check
    @param {String} key the name of the property whose cached value you want
      to return
    @return {Object} the cached value
    @public
  */
  function cacheFor(obj, key) {
    var meta$$1 = exports.peekMeta(obj);
    var cache = meta$$1 !== undefined ? meta$$1.source === obj && meta$$1.readableCache() : undefined;
    var ret = cache !== undefined ? cache[key] : undefined;

    if (ret === UNDEFINED) {
      return undefined;
    }
    return ret;
  }

  cacheFor.set = function (cache, key, value) {
    if (value === undefined) {
      cache[key] = UNDEFINED;
    } else {
      cache[key] = value;
    }
  };

  cacheFor.get = function (cache, key) {
    var ret = cache[key];
    if (ret === UNDEFINED) {
      return undefined;
    }
    return ret;
  };

  cacheFor.remove = function (cache, key) {
    cache[key] = undefined;
  };

  var CONSUMED = {};

  function alias(altKey) {
    return new AliasedProperty(altKey);
  }

  var AliasedProperty = function (_Descriptor) {
    emberBabel.inherits(AliasedProperty, _Descriptor);

    function AliasedProperty(altKey) {
      emberBabel.classCallCheck(this, AliasedProperty);

      var _this = emberBabel.possibleConstructorReturn(this, _Descriptor.call(this));

      _this.isDescriptor = true;
      _this.altKey = altKey;
      _this._dependentKeys = [altKey];
      return _this;
    }

    AliasedProperty.prototype.setup = function setup(obj, keyName) {
      true && !(this.altKey !== keyName) && emberDebug.assert('Setting alias \'' + keyName + '\' on self', this.altKey !== keyName);

      var meta$$1 = meta(obj);
      if (meta$$1.peekWatching(keyName)) {
        addDependentKeys(this, obj, keyName, meta$$1);
      }
    };

    AliasedProperty.prototype.teardown = function teardown(obj, keyName, meta$$1) {
      if (meta$$1.peekWatching(keyName)) {
        removeDependentKeys(this, obj, keyName, meta$$1);
      }
    };

    AliasedProperty.prototype.willWatch = function willWatch(obj, keyName, meta$$1) {
      addDependentKeys(this, obj, keyName, meta$$1);
    };

    AliasedProperty.prototype.didUnwatch = function didUnwatch(obj, keyName, meta$$1) {
      removeDependentKeys(this, obj, keyName, meta$$1);
    };

    AliasedProperty.prototype.get = function get$$1(obj, keyName) {
      var ret = get(obj, this.altKey);
      var meta$$1 = meta(obj);
      var cache = meta$$1.writableCache();
      if (cache[keyName] !== CONSUMED) {
        cache[keyName] = CONSUMED;
        addDependentKeys(this, obj, keyName, meta$$1);
      }
      return ret;
    };

    AliasedProperty.prototype.set = function set$$1(obj, keyName, value) {
      return set(obj, this.altKey, value);
    };

    AliasedProperty.prototype.readOnly = function readOnly() {
      this.set = AliasedProperty_readOnlySet;
      return this;
    };

    AliasedProperty.prototype.oneWay = function oneWay() {
      this.set = AliasedProperty_oneWaySet;
      return this;
    };

    return AliasedProperty;
  }(Descriptor);

  function AliasedProperty_readOnlySet(obj, keyName, value) {
    throw new emberDebug.Error('Cannot set read-only property \'' + keyName + '\' on object: ' + emberUtils.inspect(obj));
  }

  function AliasedProperty_oneWaySet(obj, keyName, value) {
    defineProperty(obj, keyName, null);
    return set(obj, keyName, value);
  }

  // Backwards compatibility with Ember Data.
  AliasedProperty.prototype._meta = undefined;
  AliasedProperty.prototype.meta = ComputedProperty.prototype.meta;

  /**
   @module @ember/polyfills
  */
  /**
    Merge the contents of two objects together into the first object.
  
    ```javascript
    import { merge } from '@ember/polyfills';
  
    merge({ first: 'Tom' }, { last: 'Dale' }); // { first: 'Tom', last: 'Dale' }
    var a = { first: 'Yehuda' };
    var b = { last: 'Katz' };
    merge(a, b); // a == { first: 'Yehuda', last: 'Katz' }, b == { last: 'Katz' }
    ```
  
    @method merge
    @static
    @for @ember/polyfills
    @param {Object} original The object to merge into
    @param {Object} updates The object to copy properties from
    @return {Object}
    @public
  */
  function merge(original, updates) {
    if (updates === null || typeof updates !== 'object') {
      return original;
    }

    var props = Object.keys(updates);
    var prop = void 0;

    for (var i = 0; i < props.length; i++) {
      prop = props[i];
      original[prop] = updates[prop];
    }

    return original;
  }

  /**
  @module ember
  */

  /**
    Used internally to allow changing properties in a backwards compatible way, and print a helpful
    deprecation warning.
  
    @method deprecateProperty
    @param {Object} object The object to add the deprecated property to.
    @param {String} deprecatedKey The property to add (and print deprecation warnings upon accessing).
    @param {String} newKey The property that will be aliased.
    @private
    @since 1.7.0
  */

  function deprecateProperty(object, deprecatedKey, newKey, options) {
    function _deprecate() {
      true && !false && emberDebug.deprecate('Usage of `' + deprecatedKey + '` is deprecated, use `' + newKey + '` instead.', false, options);
    }

    Object.defineProperty(object, deprecatedKey, {
      configurable: true,
      enumerable: false,
      set: function (value) {
        _deprecate();
        set(this, newKey, value);
      },
      get: function () {
        _deprecate();
        return get(this, newKey);
      }
    });
  }

  /* eslint no-console:off */
  /* global console */

  /**
  @module @ember/instrumentation
  @private
  */

  /**
    The purpose of the Ember Instrumentation module is
    to provide efficient, general-purpose instrumentation
    for Ember.
  
    Subscribe to a listener by using `subscribe`:
  
    ```javascript
    import { subscribe } from '@ember/instrumentation';
  
    subscribe("render", {
      before(name, timestamp, payload) {
  
      },
  
      after(name, timestamp, payload) {
  
      }
    });
    ```
  
    If you return a value from the `before` callback, that same
    value will be passed as a fourth parameter to the `after`
    callback.
  
    Instrument a block of code by using `instrument`:
  
    ```javascript
    import { instrument } from '@ember/instrumentation';
  
    instrument("render.handlebars", payload, function() {
      // rendering logic
    }, binding);
    ```
  
    Event names passed to `instrument` are namespaced
    by periods, from more general to more specific. Subscribers
    can listen for events by whatever level of granularity they
    are interested in.
  
    In the above example, the event is `render.handlebars`,
    and the subscriber listened for all events beginning with
    `render`. It would receive callbacks for events named
    `render`, `render.handlebars`, `render.container`, or
    even `render.handlebars.layout`.
  
    @class Instrumentation
    @static
    @private
  */
  var subscribers = [];
  var cache = {};

  function populateListeners(name) {
    var listeners = [];
    var subscriber = void 0;

    for (var i = 0; i < subscribers.length; i++) {
      subscriber = subscribers[i];
      if (subscriber.regex.test(name)) {
        listeners.push(subscriber.object);
      }
    }

    cache[name] = listeners;
    return listeners;
  }

  var time = function () {
    var perf = 'undefined' !== typeof window ? window.performance || {} : {};
    var fn = perf.now || perf.mozNow || perf.webkitNow || perf.msNow || perf.oNow;
    // fn.bind will be available in all the browsers that support the advanced window.performance... ;-)
    return fn ? fn.bind(perf) : function () {
      return +new Date();
    };
  }();

  /**
    Notifies event's subscribers, calls `before` and `after` hooks.
  
    @method instrument
    @for @ember/instrumentation
    @static
    @param {String} [name] Namespaced event name.
    @param {Object} _payload
    @param {Function} callback Function that you're instrumenting.
    @param {Object} binding Context that instrument function is called with.
    @private
  */
  function instrument(name, _payload, callback, binding) {
    if (arguments.length <= 3 && typeof _payload === 'function') {
      binding = callback;
      callback = _payload;
      _payload = undefined;
    }
    if (subscribers.length === 0) {
      return callback.call(binding);
    }
    var payload = _payload || {};
    var finalizer = _instrumentStart(name, function () {
      return payload;
    });

    if (finalizer) {
      return withFinalizer(callback, finalizer, payload, binding);
    } else {
      return callback.call(binding);
    }
  }

  exports.flaggedInstrument = void 0;
  if (ember_features.EMBER_IMPROVED_INSTRUMENTATION) {
    exports.flaggedInstrument = instrument;
  } else {
    exports.flaggedInstrument = function (name, payload, callback) {
      return callback();
    };
  }
  function withFinalizer(callback, finalizer, payload, binding) {
    var result = void 0;
    try {
      result = callback.call(binding);
    } catch (e) {
      payload.exception = e;
      result = payload;
    } finally {
      finalizer();
    }
    return result;
  }

  function NOOP() {}

  // private for now
  function _instrumentStart(name, _payload, _payloadParam) {
    if (subscribers.length === 0) {
      return NOOP;
    }

    var listeners = cache[name];

    if (!listeners) {
      listeners = populateListeners(name);
    }

    if (listeners.length === 0) {
      return NOOP;
    }

    var payload = _payload(_payloadParam);

    var STRUCTURED_PROFILE = emberEnvironment.ENV.STRUCTURED_PROFILE;
    var timeName = void 0;
    if (STRUCTURED_PROFILE) {
      timeName = name + ': ' + payload.object;
      console.time(timeName);
    }

    var beforeValues = new Array(listeners.length);
    var i = void 0,
        listener = void 0;
    var timestamp = time();
    for (i = 0; i < listeners.length; i++) {
      listener = listeners[i];
      beforeValues[i] = listener.before(name, timestamp, payload);
    }

    return function _instrumentEnd() {
      var i = void 0,
          listener = void 0;
      var timestamp = time();
      for (i = 0; i < listeners.length; i++) {
        listener = listeners[i];
        if (typeof listener.after === 'function') {
          listener.after(name, timestamp, payload, beforeValues[i]);
        }
      }

      if (STRUCTURED_PROFILE) {
        console.timeEnd(timeName);
      }
    };
  }

  /**
    Subscribes to a particular event or instrumented block of code.
  
    @method subscribe
    @for @ember/instrumentation
    @static
  
    @param {String} [pattern] Namespaced event name.
    @param {Object} [object] Before and After hooks.
  
    @return {Subscriber}
    @private
  */
  function subscribe(pattern, object) {
    var paths = pattern.split('.');
    var path = void 0;
    var regex = [];

    for (var i = 0; i < paths.length; i++) {
      path = paths[i];
      if (path === '*') {
        regex.push('[^\\.]*');
      } else {
        regex.push(path);
      }
    }

    regex = regex.join('\\.');
    regex = regex + '(\\..*)?';

    var subscriber = {
      pattern: pattern,
      regex: new RegExp('^' + regex + '$'),
      object: object
    };

    subscribers.push(subscriber);
    cache = {};

    return subscriber;
  }

  /**
    Unsubscribes from a particular event or instrumented block of code.
  
    @method unsubscribe
    @for @ember/instrumentation
    @static
  
    @param {Object} [subscriber]
    @private
  */
  function unsubscribe(subscriber) {
    var index = void 0;

    for (var i = 0; i < subscribers.length; i++) {
      if (subscribers[i] === subscriber) {
        index = i;
      }
    }

    subscribers.splice(index, 1);
    cache = {};
  }

  /**
    Resets `Instrumentation` by flushing list of subscribers.
  
    @method reset
    @for @ember/instrumentation
    @static
    @private
  */
  function reset() {
    subscribers.length = 0;
    cache = {};
  }

  var onerror = void 0;
  var onErrorTarget = {
    get onerror() {
      return onerror;
    }
  };

  // Ember.onerror getter
  function getOnerror() {
    return onerror;
  }
  // Ember.onerror setter
  function setOnerror(handler) {
    onerror = handler;
  }

  var dispatchOverride = void 0;

  // allows testing adapter to override dispatch
  function getDispatchOverride() {
    return dispatchOverride;
  }
  function setDispatchOverride(handler) {
    dispatchOverride = handler;
  }

  /**
   @module @ember/utils
  */
  /**
    Returns true if the passed value is null or undefined. This avoids errors
    from JSLint complaining about use of ==, which can be technically
    confusing.
  
    ```javascript
    isNone();              // true
    isNone(null);          // true
    isNone(undefined);     // true
    isNone('');            // false
    isNone([]);            // false
    isNone(function() {}); // false
    ```
  
    @method isNone
    @static
    @for @ember/utils
    @param {Object} obj Value to test
    @return {Boolean}
    @public
  */
  function isNone(obj) {
    return obj === null || obj === undefined;
  }

  /**
   @module @ember/utils
  */
  /**
    Verifies that a value is `null` or `undefined`, an empty string, or an empty
    array.
  
    Constrains the rules on `isNone` by returning true for empty strings and
    empty arrays.
  
    ```javascript
    isEmpty();                // true
    isEmpty(null);            // true
    isEmpty(undefined);       // true
    isEmpty('');              // true
    isEmpty([]);              // true
    isEmpty({});              // false
    isEmpty('Adam Hawkins');  // false
    isEmpty([0,1,2]);         // false
    isEmpty('\n\t');          // false
    isEmpty('  ');            // false
    ```
  
    @method isEmpty
    @static
    @for @ember/utils
    @param {Object} obj Value to test
    @return {Boolean}
    @public
  */
  function isEmpty(obj) {
    var none = isNone(obj);
    if (none) {
      return none;
    }

    if (typeof obj.size === 'number') {
      return !obj.size;
    }

    var objectType = typeof obj;

    if (objectType === 'object') {
      var size = get(obj, 'size');
      if (typeof size === 'number') {
        return !size;
      }
    }

    if (typeof obj.length === 'number' && objectType !== 'function') {
      return !obj.length;
    }

    if (objectType === 'object') {
      var length = get(obj, 'length');
      if (typeof length === 'number') {
        return !length;
      }
    }

    return false;
  }

  /**
   @module @ember/utils
  */
  /**
    A value is blank if it is empty or a whitespace string.
  
    ```javascript
    import { isBlank } from '@ember/utils';
  
    isBlank();                // true
    isBlank(null);            // true
    isBlank(undefined);       // true
    isBlank('');              // true
    isBlank([]);              // true
    isBlank('\n\t');          // true
    isBlank('  ');            // true
    isBlank({});              // false
    isBlank('\n\t Hello');    // false
    isBlank('Hello world');   // false
    isBlank([1,2,3]);         // false
    ```
  
    @method isBlank
    @static
    @for @ember/utils
    @param {Object} obj Value to test
    @return {Boolean}
    @since 1.5.0
    @public
  */
  function isBlank(obj) {
    return isEmpty(obj) || typeof obj === 'string' && /\S/.test(obj) === false;
  }

  /**
   @module @ember/utils
  */
  /**
    A value is present if it not `isBlank`.
  
    ```javascript
    isPresent();                // false
    isPresent(null);            // false
    isPresent(undefined);       // false
    isPresent('');              // false
    isPresent('  ');            // false
    isPresent('\n\t');          // false
    isPresent([]);              // false
    isPresent({ length: 0 })    // false
    isPresent(false);           // true
    isPresent(true);            // true
    isPresent('string');        // true
    isPresent(0);               // true
    isPresent(function() {})    // true
    isPresent({});              // true
    isPresent(false);           // true
    isPresent('\n\t Hello');    // true
    isPresent([1,2,3]);         // true
    ```
  
    @method isPresent
    @static
    @for @ember/utils
    @param {Object} obj Value to test
    @return {Boolean}
    @since 1.8.0
    @public
  */
  function isPresent(obj) {
    return !isBlank(obj);
  }

  function onBegin(current) {
    run.currentRunLoop = current;
  }

  function onEnd(current, next) {
    run.currentRunLoop = next;
  }

  var backburner$1 = new Backburner(['sync', 'actions', 'destroy'], {
    GUID_KEY: emberUtils.GUID_KEY,
    sync: {
      before: beginPropertyChanges,
      after: endPropertyChanges
    },
    defaultQueue: 'actions',
    onBegin: onBegin,
    onEnd: onEnd,
    onErrorTarget: onErrorTarget,
    onErrorMethod: 'onerror'
  });

  /**
   @module @ember/runloop
  */
  // ..........................................................
  // run - this is ideally the only public API the dev sees
  //

  /**
    Runs the passed target and method inside of a RunLoop, ensuring any
    deferred actions including bindings and views updates are flushed at the
    end.
  
    Normally you should not need to invoke this method yourself. However if
    you are implementing raw event handlers when interfacing with other
    libraries or plugins, you should probably wrap all of your code inside this
    call.
  
    ```javascript
    run(function() {
      // code to be executed within a RunLoop
    });
    ```
  
    @class @ember/runloop
    @static
    @constructor
    @param {Object} [target] target of method to call
    @param {Function|String} method Method to invoke.
      May be a function or a string. If you pass a string
      then it will be looked up on the passed target.
    @param {Object} [args*] Any additional arguments you wish to pass to the method.
    @return {Object} return value from invoking the passed function.
    @public
  */
  function run() {
    return backburner$1.run.apply(backburner$1, arguments);
  }

  /**
    If no run-loop is present, it creates a new one. If a run loop is
    present it will queue itself to run on the existing run-loops action
    queue.
  
    Please note: This is not for normal usage, and should be used sparingly.
  
    If invoked when not within a run loop:
  
    ```javascript
    run.join(function() {
      // creates a new run-loop
    });
    ```
  
    Alternatively, if called within an existing run loop:
  
    ```javascript
    run(function() {
      // creates a new run-loop
      run.join(function() {
        // joins with the existing run-loop, and queues for invocation on
        // the existing run-loops action queue.
      });
    });
    ```
  
    @method join
    @static
    @for @ember/runloop
    @param {Object} [target] target of method to call
    @param {Function|String} method Method to invoke.
      May be a function or a string. If you pass a string
      then it will be looked up on the passed target.
    @param {Object} [args*] Any additional arguments you wish to pass to the method.
    @return {Object} Return value from invoking the passed function. Please note,
    when called within an existing loop, no return value is possible.
    @public
  */
  run.join = function () {
    return backburner$1.join.apply(backburner$1, arguments);
  };

  /**
    Allows you to specify which context to call the specified function in while
    adding the execution of that function to the Ember run loop. This ability
    makes this method a great way to asynchronously integrate third-party libraries
    into your Ember application.
  
    `run.bind` takes two main arguments, the desired context and the function to
    invoke in that context. Any additional arguments will be supplied as arguments
    to the function that is passed in.
  
    Let's use the creation of a TinyMCE component as an example. Currently,
    TinyMCE provides a setup configuration option we can use to do some processing
    after the TinyMCE instance is initialized but before it is actually rendered.
    We can use that setup option to do some additional setup for our component.
    The component itself could look something like the following:
  
    ```app/components/rich-text-editor.js
    import Component from '@ember/component';
    import { bind } from '@ember/runloop';
  
    export default Component.extend({
      initializeTinyMCE: Ember.on('didInsertElement', function() {
        tinymce.init({
          selector: '#' + this.$().prop('id'),
          setup: Ember.run.bind(this, this.setupEditor)
        });
      }),
      
      didInsertElement() {
        tinymce.init({
          selector: '#' + this.$().prop('id'),
          setup: Ember.run.bind(this, this.setupEditor)
        });
      }
  
      setupEditor(editor) {
        this.set('editor', editor);
  
        editor.on('change', function() {
          console.log('content changed!');
        });
      }
    });
    ```
  
    In this example, we use Ember.run.bind to bind the setupEditor method to the
    context of the RichTextEditor component and to have the invocation of that
    method be safely handled and executed by the Ember run loop.
  
    @method bind
    @static
    @for @ember/runloop
    @param {Object} [target] target of method to call
    @param {Function|String} method Method to invoke.
      May be a function or a string. If you pass a string
      then it will be looked up on the passed target.
    @param {Object} [args*] Any additional arguments you wish to pass to the method.
    @return {Function} returns a new function that will always have a particular context
    @since 1.4.0
    @public
  */
  run.bind = function () {
    for (var _len = arguments.length, curried = Array(_len), _key = 0; _key < _len; _key++) {
      curried[_key] = arguments[_key];
    }

    return function () {
      for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      return run.join.apply(run, curried.concat(args));
    };
  };

  run.backburner = backburner$1;
  run.currentRunLoop = null;
  run.queues = backburner$1.queueNames;

  /**
    Begins a new RunLoop. Any deferred actions invoked after the begin will
    be buffered until you invoke a matching call to `run.end()`. This is
    a lower-level way to use a RunLoop instead of using `run()`.
  
    ```javascript
    run.begin();
    // code to be executed within a RunLoop
    run.end();
    ```
  
    @method begin
    @static
    @for @ember/runloop
    @return {void}
    @public
  */
  run.begin = function () {
    backburner$1.begin();
  };

  /**
    Ends a RunLoop. This must be called sometime after you call
    `run.begin()` to flush any deferred actions. This is a lower-level way
    to use a RunLoop instead of using `run()`.
  
    ```javascript
    run.begin();
    // code to be executed within a RunLoop
    run.end();
    ```
  
    @method end
    @static
    @for @ember/runloop
    @return {void}
    @public
  */
  run.end = function () {
    backburner$1.end();
  };

  /**
    Array of named queues. This array determines the order in which queues
    are flushed at the end of the RunLoop. You can define your own queues by
    simply adding the queue name to this array. Normally you should not need
    to inspect or modify this property.
  
    @property queues
    @type Array
    @default ['sync', 'actions', 'destroy']
    @private
  */

  /**
    Adds the passed target/method and any optional arguments to the named
    queue to be executed at the end of the RunLoop. If you have not already
    started a RunLoop when calling this method one will be started for you
    automatically.
  
    At the end of a RunLoop, any methods scheduled in this way will be invoked.
    Methods will be invoked in an order matching the named queues defined in
    the `run.queues` property.
  
    ```javascript
    run.schedule('sync', this, function() {
      // this will be executed in the first RunLoop queue, when bindings are synced
      console.log('scheduled on sync queue');
    });
  
    run.schedule('actions', this, function() {
      // this will be executed in the 'actions' queue, after bindings have synced.
      console.log('scheduled on actions queue');
    });
  
    // Note the functions will be run in order based on the run queues order.
    // Output would be:
    //   scheduled on sync queue
    //   scheduled on actions queue
    ```
  
    @method schedule
    @static
    @for @ember/runloop
    @param {String} queue The name of the queue to schedule against.
      Default queues are 'sync' and 'actions'
    @param {Object} [target] target object to use as the context when invoking a method.
    @param {String|Function} method The method to invoke. If you pass a string it
      will be resolved on the target object at the time the scheduled item is
      invoked allowing you to change the target function.
    @param {Object} [arguments*] Optional arguments to be passed to the queued method.
    @return {*} Timer information for use in canceling, see `run.cancel`.
    @public
  */
  run.schedule = function () /* queue, target, method */{
    true && !(run.currentRunLoop || !emberDebug.isTesting()) && emberDebug.assert('You have turned on testing mode, which disabled the run-loop\'s autorun. ' + 'You will need to wrap any code with asynchronous side-effects in a run', run.currentRunLoop || !emberDebug.isTesting());

    return backburner$1.schedule.apply(backburner$1, arguments);
  };

  // Used by global test teardown
  run.hasScheduledTimers = function () {
    return backburner$1.hasTimers();
  };

  // Used by global test teardown
  run.cancelTimers = function () {
    backburner$1.cancelTimers();
  };

  /**
    Immediately flushes any events scheduled in the 'sync' queue. Bindings
    use this queue so this method is a useful way to immediately force all
    bindings in the application to sync.
  
    You should call this method anytime you need any changed state to propagate
    throughout the app immediately without repainting the UI (which happens
    in the later 'render' queue added by the `ember-views` package).
  
    ```javascript
    run.sync();
    ```
  
    @method sync
    @static
    @for @ember/runloop
    @return {void}
    @private
  */
  run.sync = function () {
    if (backburner$1.currentInstance) {
      backburner$1.currentInstance.queues.sync.flush();
    }
  };

  /**
    Invokes the passed target/method and optional arguments after a specified
    period of time. The last parameter of this method must always be a number
    of milliseconds.
  
    You should use this method whenever you need to run some action after a
    period of time instead of using `setTimeout()`. This method will ensure that
    items that expire during the same script execution cycle all execute
    together, which is often more efficient than using a real setTimeout.
  
    ```javascript
    run.later(myContext, function() {
      // code here will execute within a RunLoop in about 500ms with this == myContext
    }, 500);
    ```
  
    @method later
    @static
    @for @ember/runloop
    @param {Object} [target] target of method to invoke
    @param {Function|String} method The method to invoke.
      If you pass a string it will be resolved on the
      target at the time the method is invoked.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @param {Number} wait Number of milliseconds to wait.
    @return {*} Timer information for use in canceling, see `run.cancel`.
    @public
  */
  run.later = function () /*target, method*/{
    return backburner$1.later.apply(backburner$1, arguments);
  };

  /**
    Schedule a function to run one time during the current RunLoop. This is equivalent
    to calling `scheduleOnce` with the "actions" queue.
  
    @method once
    @static
    @for @ember/runloop
    @param {Object} [target] The target of the method to invoke.
    @param {Function|String} method The method to invoke.
      If you pass a string it will be resolved on the
      target at the time the method is invoked.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @return {Object} Timer information for use in canceling, see `run.cancel`.
    @public
  */
  run.once = function () {
    true && !(run.currentRunLoop || !emberDebug.isTesting()) && emberDebug.assert('You have turned on testing mode, which disabled the run-loop\'s autorun. ' + 'You will need to wrap any code with asynchronous side-effects in a run', run.currentRunLoop || !emberDebug.isTesting());

    for (var _len3 = arguments.length, args = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
      args[_key3] = arguments[_key3];
    }

    args.unshift('actions');
    return backburner$1.scheduleOnce.apply(backburner$1, args);
  };

  /**
    Schedules a function to run one time in a given queue of the current RunLoop.
    Calling this method with the same queue/target/method combination will have
    no effect (past the initial call).
  
    Note that although you can pass optional arguments these will not be
    considered when looking for duplicates. New arguments will replace previous
    calls.
  
    ```javascript
    function sayHi() {
      console.log('hi');
    }
  
    run(function() {
      run.scheduleOnce('afterRender', myContext, sayHi);
      run.scheduleOnce('afterRender', myContext, sayHi);
      // sayHi will only be executed once, in the afterRender queue of the RunLoop
    });
    ```
  
    Also note that for `run.scheduleOnce` to prevent additional calls, you need to
    pass the same function instance. The following case works as expected:
  
    ```javascript
    function log() {
      console.log('Logging only once');
    }
  
    function scheduleIt() {
      run.scheduleOnce('actions', myContext, log);
    }
  
    scheduleIt();
    scheduleIt();
    ```
  
    But this other case will schedule the function multiple times:
  
    ```javascript
    function scheduleIt() {
      run.scheduleOnce('actions', myContext, function() {
        console.log('Closure');
      });
    }
  
    scheduleIt();
    scheduleIt();
  
    // "Closure" will print twice, even though we're using `run.scheduleOnce`,
    // because the function we pass to it won't match the
    // previously scheduled operation.
    ```
  
    Available queues, and their order, can be found at `run.queues`
  
    @method scheduleOnce
    @static
    @for @ember/runloop
    @param {String} [queue] The name of the queue to schedule against. Default queues are 'sync' and 'actions'.
    @param {Object} [target] The target of the method to invoke.
    @param {Function|String} method The method to invoke.
      If you pass a string it will be resolved on the
      target at the time the method is invoked.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @return {Object} Timer information for use in canceling, see `run.cancel`.
    @public
  */
  run.scheduleOnce = function () /*queue, target, method*/{
    true && !(run.currentRunLoop || !emberDebug.isTesting()) && emberDebug.assert('You have turned on testing mode, which disabled the run-loop\'s autorun. ' + 'You will need to wrap any code with asynchronous side-effects in a run', run.currentRunLoop || !emberDebug.isTesting());

    return backburner$1.scheduleOnce.apply(backburner$1, arguments);
  };

  /**
    Schedules an item to run from within a separate run loop, after
    control has been returned to the system. This is equivalent to calling
    `run.later` with a wait time of 1ms.
  
    ```javascript
    run.next(myContext, function() {
      // code to be executed in the next run loop,
      // which will be scheduled after the current one
    });
    ```
  
    Multiple operations scheduled with `run.next` will coalesce
    into the same later run loop, along with any other operations
    scheduled by `run.later` that expire right around the same
    time that `run.next` operations will fire.
  
    Note that there are often alternatives to using `run.next`.
    For instance, if you'd like to schedule an operation to happen
    after all DOM element operations have completed within the current
    run loop, you can make use of the `afterRender` run loop queue (added
    by the `ember-views` package, along with the preceding `render` queue
    where all the DOM element operations happen).
  
    Example:
  
    ```app/components/my-component.js
    import Component from '@ember/component';
  
    export Component.extend({
      didInsertElement() {
        this._super(...arguments);
        run.scheduleOnce('afterRender', this, 'processChildElements');
      },
  
      processChildElements() {
        // ... do something with component's child component
        // elements after they've finished rendering, which
        // can't be done within this component's
        // `didInsertElement` hook because that gets run
        // before the child elements have been added to the DOM.
      }
    });
    ```
  
    One benefit of the above approach compared to using `run.next` is
    that you will be able to perform DOM/CSS operations before unprocessed
    elements are rendered to the screen, which may prevent flickering or
    other artifacts caused by delaying processing until after rendering.
  
    The other major benefit to the above approach is that `run.next`
    introduces an element of non-determinism, which can make things much
    harder to test, due to its reliance on `setTimeout`; it's much harder
    to guarantee the order of scheduled operations when they are scheduled
    outside of the current run loop, i.e. with `run.next`.
  
    @method next
    @static
    @for @ember/runloop
    @param {Object} [target] target of method to invoke
    @param {Function|String} method The method to invoke.
      If you pass a string it will be resolved on the
      target at the time the method is invoked.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @return {Object} Timer information for use in canceling, see `run.cancel`.
    @public
  */
  run.next = function () {
    for (var _len4 = arguments.length, args = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
      args[_key4] = arguments[_key4];
    }

    args.push(1);
    return backburner$1.later.apply(backburner$1, args);
  };

  /**
    Cancels a scheduled item. Must be a value returned by `run.later()`,
    `run.once()`, `run.scheduleOnce()`, `run.next()`, `run.debounce()`, or
    `run.throttle()`.
  
    ```javascript
    let runNext = run.next(myContext, function() {
      // will not be executed
    });
  
    run.cancel(runNext);
  
    let runLater = run.later(myContext, function() {
      // will not be executed
    }, 500);
  
    run.cancel(runLater);
  
    let runScheduleOnce = run.scheduleOnce('afterRender', myContext, function() {
      // will not be executed
    });
  
    run.cancel(runScheduleOnce);
  
    let runOnce = run.once(myContext, function() {
      // will not be executed
    });
  
    run.cancel(runOnce);
  
    let throttle = run.throttle(myContext, function() {
      // will not be executed
    }, 1, false);
  
    run.cancel(throttle);
  
    let debounce = run.debounce(myContext, function() {
      // will not be executed
    }, 1);
  
    run.cancel(debounce);
  
    let debounceImmediate = run.debounce(myContext, function() {
      // will be executed since we passed in true (immediate)
    }, 100, true);
  
    // the 100ms delay until this method can be called again will be canceled
    run.cancel(debounceImmediate);
    ```
  
    @method cancel
    @static
    @for @ember/runloop
    @param {Object} timer Timer object to cancel
    @return {Boolean} true if canceled or false/undefined if it wasn't found
    @public
  */
  run.cancel = function (timer) {
    return backburner$1.cancel(timer);
  };

  /**
    Delay calling the target method until the debounce period has elapsed
    with no additional debounce calls. If `debounce` is called again before
    the specified time has elapsed, the timer is reset and the entire period
    must pass again before the target method is called.
  
    This method should be used when an event may be called multiple times
    but the action should only be called once when the event is done firing.
    A common example is for scroll events where you only want updates to
    happen once scrolling has ceased.
  
    ```javascript
    function whoRan() {
      console.log(this.name + ' ran.');
    }
  
    let myContext = { name: 'debounce' };
  
    run.debounce(myContext, whoRan, 150);
  
    // less than 150ms passes
    run.debounce(myContext, whoRan, 150);
  
    // 150ms passes
    // whoRan is invoked with context myContext
    // console logs 'debounce ran.' one time.
    ```
  
    Immediate allows you to run the function immediately, but debounce
    other calls for this function until the wait time has elapsed. If
    `debounce` is called again before the specified time has elapsed,
    the timer is reset and the entire period must pass again before
    the method can be called again.
  
    ```javascript
    function whoRan() {
      console.log(this.name + ' ran.');
    }
  
    let myContext = { name: 'debounce' };
  
    run.debounce(myContext, whoRan, 150, true);
  
    // console logs 'debounce ran.' one time immediately.
    // 100ms passes
    run.debounce(myContext, whoRan, 150, true);
  
    // 150ms passes and nothing else is logged to the console and
    // the debouncee is no longer being watched
    run.debounce(myContext, whoRan, 150, true);
  
    // console logs 'debounce ran.' one time immediately.
    // 150ms passes and nothing else is logged to the console and
    // the debouncee is no longer being watched
  
    ```
  
    @method debounce
    @static
    @for @ember/runloop
    @param {Object} [target] target of method to invoke
    @param {Function|String} method The method to invoke.
      May be a function or a string. If you pass a string
      then it will be looked up on the passed target.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @param {Number} wait Number of milliseconds to wait.
    @param {Boolean} immediate Trigger the function on the leading instead
      of the trailing edge of the wait interval. Defaults to false.
    @return {Array} Timer information for use in canceling, see `run.cancel`.
    @public
  */
  run.debounce = function () {
    return backburner$1.debounce.apply(backburner$1, arguments);
  };

  /**
    Ensure that the target method is never called more frequently than
    the specified spacing period. The target method is called immediately.
  
    ```javascript
    function whoRan() {
      console.log(this.name + ' ran.');
    }
  
    let myContext = { name: 'throttle' };
  
    run.throttle(myContext, whoRan, 150);
    // whoRan is invoked with context myContext
    // console logs 'throttle ran.'
  
    // 50ms passes
    run.throttle(myContext, whoRan, 150);
  
    // 50ms passes
    run.throttle(myContext, whoRan, 150);
  
    // 150ms passes
    run.throttle(myContext, whoRan, 150);
    // whoRan is invoked with context myContext
    // console logs 'throttle ran.'
    ```
  
    @method throttle
    @static
    @for @ember/runloop
    @param {Object} [target] target of method to invoke
    @param {Function|String} method The method to invoke.
      May be a function or a string. If you pass a string
      then it will be looked up on the passed target.
    @param {Object} [args*] Optional arguments to pass to the timeout.
    @param {Number} spacing Number of milliseconds to space out requests.
    @param {Boolean} immediate Trigger the function on the leading instead
      of the trailing edge of the wait interval. Defaults to true.
    @return {Array} Timer information for use in canceling, see `run.cancel`.
    @public
  */
  run.throttle = function () {
    return backburner$1.throttle.apply(backburner$1, arguments);
  };

  /**
    Add a new named queue after the specified queue.
  
    The queue to add will only be added once.
  
    @method _addQueue
    @param {String} name the name of the queue to add.
    @param {String} after the name of the queue to add after.
    @private
  */
  run._addQueue = function (name, after) {
    if (run.queues.indexOf(name) === -1) {
      run.queues.splice(run.queues.indexOf(after) + 1, 0, name);
    }
  };

  /**
   @module ember
  */
  /**
    Helper class that allows you to register your library with Ember.
  
    Singleton created at `Ember.libraries`.
  
    @class Libraries
    @constructor
    @private
  */
  var Libraries = function () {
    function Libraries() {
      emberBabel.classCallCheck(this, Libraries);

      this._registry = [];
      this._coreLibIndex = 0;
    }

    Libraries.prototype.isRegistered = function isRegistered(name) {
      return !!this._getLibraryByName(name);
    };

    return Libraries;
  }();

  Libraries.prototype = {
    constructor: Libraries,

    _getLibraryByName: function (name) {
      var libs = this._registry;
      var count = libs.length;

      for (var i = 0; i < count; i++) {
        if (libs[i].name === name) {
          return libs[i];
        }
      }
    },
    register: function (name, version, isCoreLibrary) {
      var index = this._registry.length;

      if (!this._getLibraryByName(name)) {
        if (isCoreLibrary) {
          index = this._coreLibIndex++;
        }
        this._registry.splice(index, 0, { name: name, version: version });
      } else {
        true && emberDebug.warn('Library "' + name + '" is already registered with Ember.', false, { id: 'ember-metal.libraries-register' });
      }
    },
    registerCoreLibrary: function (name, version) {
      this.register(name, version, true);
    },
    deRegister: function (name) {
      var lib = this._getLibraryByName(name);
      var index = void 0;

      if (lib) {
        index = this._registry.indexOf(lib);
        this._registry.splice(index, 1);
      }
    }
  };

  if (ember_features.EMBER_LIBRARIES_ISREGISTERED) {
    Libraries.prototype.isRegistered = function (name) {
      return !!this._getLibraryByName(name);
    };
  }

  var libraries = new Libraries();

  /**
  @module ember
  */

  /*
    JavaScript (before ES6) does not have a Map implementation. Objects,
    which are often used as dictionaries, may only have Strings as keys.
  
    Because Ember has a way to get a unique identifier for every object
    via `guidFor`, we can implement a performant Map with arbitrary
    keys. Because it is commonly used in low-level bookkeeping, Map is
    implemented as a pure JavaScript object for performance.
  
    This implementation follows the current iteration of the ES6 proposal for
    maps (http://wiki.ecmascript.org/doku.php?id=harmony:simple_maps_and_sets),
    with one exception:  as we do not have the luxury of in-VM iteration, we implement a
    forEach method for iteration.
  
    Map is mocked out to look like an Ember object, so you can do
    `EmberMap.create()` for symmetry with other Ember classes.
  */

  function copyNull(obj) {
    var output = Object.create(null);

    for (var prop in obj) {
      // hasOwnPropery is not needed because obj is Object.create(null);
      output[prop] = obj[prop];
    }

    return output;
  }

  function copyMap(original, newObject) {
    var keys = original._keys.copy();
    var values = copyNull(original._values);

    newObject._keys = keys;
    newObject._values = values;
    newObject.size = original.size;

    return newObject;
  }

  /**
    This class is used internally by Ember and Ember Data.
    Please do not use it at this time. We plan to clean it up
    and add many tests soon.
  
    @class OrderedSet
    @namespace Ember
    @constructor
    @private
  */

  var OrderedSet = function () {
    function OrderedSet() {
      emberBabel.classCallCheck(this, OrderedSet);

      this.clear();
    }

    /**
      @method create
      @static
      @return {Ember.OrderedSet}
      @private
    */

    OrderedSet.create = function create() {
      var Constructor = this;
      return new Constructor();
    };

    /**
      @method clear
      @private
    */

    OrderedSet.prototype.clear = function clear() {
      this.presenceSet = Object.create(null);
      this.list = [];
      this.size = 0;
    };

    /**
      @method add
      @param obj
      @param guid (optional, and for internal use)
      @return {Ember.OrderedSet}
      @private
    */

    OrderedSet.prototype.add = function add(obj, _guid) {
      var guid = _guid || emberUtils.guidFor(obj);
      var presenceSet = this.presenceSet;
      var list = this.list;

      if (presenceSet[guid] !== true) {
        presenceSet[guid] = true;
        this.size = list.push(obj);
      }

      return this;
    };

    /**
      @since 1.8.0
      @method delete
      @param obj
      @param _guid (optional and for internal use only)
      @return {Boolean}
      @private
    */

    OrderedSet.prototype.delete = function _delete(obj, _guid) {
      var guid = _guid || emberUtils.guidFor(obj);
      var presenceSet = this.presenceSet;
      var list = this.list;

      if (presenceSet[guid] === true) {
        delete presenceSet[guid];
        var index = list.indexOf(obj);
        if (index > -1) {
          list.splice(index, 1);
        }
        this.size = list.length;
        return true;
      } else {
        return false;
      }
    };

    /**
      @method isEmpty
      @return {Boolean}
      @private
    */

    OrderedSet.prototype.isEmpty = function isEmpty() {
      return this.size === 0;
    };

    /**
      @method has
      @param obj
      @return {Boolean}
      @private
    */

    OrderedSet.prototype.has = function has(obj) {
      if (this.size === 0) {
        return false;
      }

      var guid = emberUtils.guidFor(obj);
      var presenceSet = this.presenceSet;

      return presenceSet[guid] === true;
    };

    /**
      @method forEach
      @param {Function} fn
      @param self
      @private
    */

    OrderedSet.prototype.forEach = function forEach(fn /*, ...thisArg*/) {
      true && !(typeof fn === 'function') && emberDebug.assert(Object.prototype.toString.call(fn) + ' is not a function', typeof fn === 'function');

      if (this.size === 0) {
        return;
      }

      var list = this.list;

      if (arguments.length === 2) {
        for (var i = 0; i < list.length; i++) {
          fn.call(arguments[1], list[i]);
        }
      } else {
        for (var _i = 0; _i < list.length; _i++) {
          fn(list[_i]);
        }
      }
    };

    /**
      @method toArray
      @return {Array}
      @private
    */

    OrderedSet.prototype.toArray = function toArray() {
      return this.list.slice();
    };

    /**
      @method copy
      @return {Ember.OrderedSet}
      @private
    */

    OrderedSet.prototype.copy = function copy() {
      var Constructor = this.constructor;
      var set = new Constructor();

      set.presenceSet = copyNull(this.presenceSet);
      set.list = this.toArray();
      set.size = this.size;

      return set;
    };

    return OrderedSet;
  }();

  /**
    A Map stores values indexed by keys. Unlike JavaScript's
    default Objects, the keys of a Map can be any JavaScript
    object.
  
    Internally, a Map has two data structures:
  
    1. `keys`: an OrderedSet of all of the existing keys
    2. `values`: a JavaScript Object indexed by the `guidFor(key)`
  
    When a key/value pair is added for the first time, we
    add the key to the `keys` OrderedSet, and create or
    replace an entry in `values`. When an entry is deleted,
    we delete its entry in `keys` and `values`.
  
    @class Map
    @namespace Ember
    @private
    @constructor
  */

  var Map = function () {
    function Map() {
      emberBabel.classCallCheck(this, Map);

      this._keys = new OrderedSet();
      this._values = Object.create(null);
      this.size = 0;
    }

    /**
      @method create
      @static
      @private
    */

    Map.create = function create() {
      var Constructor = this;
      return new Constructor();
    };

    /**
      Retrieve the value associated with a given key.
       @method get
      @param {*} key
      @return {*} the value associated with the key, or `undefined`
      @private
    */

    Map.prototype.get = function get(key) {
      if (this.size === 0) {
        return;
      }

      var values = this._values;
      var guid = emberUtils.guidFor(key);

      return values[guid];
    };

    /**
      Adds a value to the map. If a value for the given key has already been
      provided, the new value will replace the old value.
       @method set
      @param {*} key
      @param {*} value
      @return {Ember.Map}
      @private
    */

    Map.prototype.set = function set(key, value) {
      var keys = this._keys;
      var values = this._values;
      var guid = emberUtils.guidFor(key);

      // ensure we don't store -0
      var k = key === -0 ? 0 : key;

      keys.add(k, guid);

      values[guid] = value;

      this.size = keys.size;

      return this;
    };

    /**
      Removes a value from the map for an associated key.
       @since 1.8.0
      @method delete
      @param {*} key
      @return {Boolean} true if an item was removed, false otherwise
      @private
    */

    Map.prototype.delete = function _delete(key) {
      if (this.size === 0) {
        return false;
      }
      // don't use ES6 "delete" because it will be annoying
      // to use in browsers that are not ES6 friendly;
      var keys = this._keys;
      var values = this._values;
      var guid = emberUtils.guidFor(key);

      if (keys.delete(key, guid)) {
        delete values[guid];
        this.size = keys.size;
        return true;
      } else {
        return false;
      }
    };

    /**
      Check whether a key is present.
       @method has
      @param {*} key
      @return {Boolean} true if the item was present, false otherwise
      @private
    */

    Map.prototype.has = function has(key) {
      return this._keys.has(key);
    };

    /**
      Iterate over all the keys and values. Calls the function once
      for each key, passing in value, key, and the map being iterated over,
      in that order.
       The keys are guaranteed to be iterated over in insertion order.
       @method forEach
      @param {Function} callback
      @param {*} self if passed, the `this` value inside the
        callback. By default, `this` is the map.
      @private
    */

    Map.prototype.forEach = function forEach(callback /*, ...thisArg*/) {
      true && !(typeof callback === 'function') && emberDebug.assert(Object.prototype.toString.call(callback) + ' is not a function', typeof callback === 'function');

      if (this.size === 0) {
        return;
      }

      var map = this;
      var cb = void 0,
          thisArg = void 0;

      if (arguments.length === 2) {
        thisArg = arguments[1];
        cb = function (key) {
          return callback.call(thisArg, map.get(key), key, map);
        };
      } else {
        cb = function (key) {
          return callback(map.get(key), key, map);
        };
      }

      this._keys.forEach(cb);
    };

    /**
      @method clear
      @private
    */

    Map.prototype.clear = function clear() {
      this._keys.clear();
      this._values = Object.create(null);
      this.size = 0;
    };

    /**
      @method copy
      @return {Ember.Map}
      @private
    */

    Map.prototype.copy = function copy() {
      return copyMap(this, new Map());
    };

    return Map;
  }();

  /**
    @class MapWithDefault
    @namespace Ember
    @extends Ember.Map
    @private
    @constructor
    @param [options]
      @param {*} [options.defaultValue]
  */

  var MapWithDefault = function (_Map) {
    emberBabel.inherits(MapWithDefault, _Map);

    function MapWithDefault(options) {
      emberBabel.classCallCheck(this, MapWithDefault);

      var _this = emberBabel.possibleConstructorReturn(this, _Map.call(this));

      _this.defaultValue = options.defaultValue;
      return _this;
    }

    /**
      @method create
      @static
      @param [options]
        @param {*} [options.defaultValue]
      @return {Ember.MapWithDefault|Ember.Map} If options are passed, returns
        `MapWithDefault` otherwise returns `EmberMap`
      @private
    */

    MapWithDefault.create = function create(options) {
      if (options) {
        return new MapWithDefault(options);
      } else {
        return new Map();
      }
    };

    /**
      Retrieve the value associated with a given key.
       @method get
      @param {*} key
      @return {*} the value associated with the key, or the default value
      @private
    */

    MapWithDefault.prototype.get = function get(key) {
      var hasValue = this.has(key);

      if (hasValue) {
        return _Map.prototype.get.call(this, key);
      } else {
        var defaultValue = this.defaultValue(key);
        this.set(key, defaultValue);
        return defaultValue;
      }
    };

    /**
      @method copy
      @return {Ember.MapWithDefault}
      @private
    */

    MapWithDefault.prototype.copy = function copy() {
      var Constructor = this.constructor;
      return copyMap(this, new Constructor({
        defaultValue: this.defaultValue
      }));
    };

    return MapWithDefault;
  }(Map);

  /**
   @module @ember/object
  */

  /**
    To get multiple properties at once, call `getProperties`
    with an object followed by a list of strings or an array:
  
    ```javascript
    import { getProperties } from '@ember/object';
  
    getProperties(record, 'firstName', 'lastName', 'zipCode');
    // { firstName: 'John', lastName: 'Doe', zipCode: '10011' }
    ```
  
    is equivalent to:
  
    ```javascript
    import { getProperties } from '@ember/object';
  
    getProperties(record, ['firstName', 'lastName', 'zipCode']);
    // { firstName: 'John', lastName: 'Doe', zipCode: '10011' }
    ```
  
    @method getProperties
    @static
    @for @ember/object
    @param {Object} obj
    @param {String...|Array} list of keys to get
    @return {Object}
    @public
  */
  function getProperties(obj) {
    var ret = {};
    var propertyNames = arguments;
    var i = 1;

    if (arguments.length === 2 && Array.isArray(arguments[1])) {
      i = 0;
      propertyNames = arguments[1];
    }
    for (; i < propertyNames.length; i++) {
      ret[propertyNames[i]] = get(obj, propertyNames[i]);
    }
    return ret;
  }

  /**
   @module @ember/object
  */
  /**
    Set a list of properties on an object. These properties are set inside
    a single `beginPropertyChanges` and `endPropertyChanges` batch, so
    observers will be buffered.
  
    ```javascript
    let anObject = Ember.Object.create();
  
    anObject.setProperties({
      firstName: 'Stanley',
      lastName: 'Stuart',
      age: 21
    });
    ```
  
    @method setProperties
    @static
    @for @ember/object
    @param obj
    @param {Object} properties
    @return properties
    @public
  */
  function setProperties(obj, properties) {
    if (properties === null || typeof properties !== 'object') {
      return properties;
    }
    changeProperties(function () {
      var props = Object.keys(properties);
      var propertyName = void 0;

      for (var i = 0; i < props.length; i++) {
        propertyName = props[i];

        set(obj, propertyName, properties[propertyName]);
      }
    });
    return properties;
  }

  /**
  @module @ember/object
  */

  var AFTER_OBSERVERS = ':change';
  var BEFORE_OBSERVERS = ':before';

  function changeEvent(keyName) {
    return keyName + AFTER_OBSERVERS;
  }

  function beforeEvent(keyName) {
    return keyName + BEFORE_OBSERVERS;
  }

  /**
    @method addObserver
    @static
    @for @ember/object/observers
    @param obj
    @param {String} _path
    @param {Object|Function} target
    @param {Function|String} [method]
    @public
  */
  function addObserver(obj, _path, target, method) {
    addListener(obj, changeEvent(_path), target, method);
    watch(obj, _path);

    return this;
  }

  function observersFor(obj, path) {
    return listenersFor(obj, changeEvent(path));
  }

  /**
    @method removeObserver
    @static
    @for @ember/object/observers
    @param obj
    @param {String} path
    @param {Object|Function} target
    @param {Function|String} [method]
    @public
  */
  function removeObserver(obj, path, target, method) {
    unwatch(obj, path);
    removeListener(obj, changeEvent(path), target, method);

    return this;
  }

  /**
    @method _addBeforeObserver
    @static
    @for @ember/object/observers
    @param obj
    @param {String} path
    @param {Object|Function} target
    @param {Function|String} [method]
    @deprecated
    @private
  */
  function _addBeforeObserver(obj, path, target, method) {
    addListener(obj, beforeEvent(path), target, method);
    watch(obj, path);

    return this;
  }

  // Suspend observer during callback.
  //
  // This should only be used by the target of the observer
  // while it is setting the observed path.
  function _suspendObserver(obj, path, target, method, callback) {
    return suspendListener(obj, changeEvent(path), target, method, callback);
  }

  function _suspendObservers(obj, paths, target, method, callback) {
    var events = paths.map(changeEvent);
    return suspendListeners(obj, events, target, method, callback);
  }

  /**
    @method removeBeforeObserver
    @static
    @for @ember/object/observers
    @param obj
    @param {String} path
    @param {Object|Function} target
    @param {Function|String} [method]
    @deprecated
    @private
  */
  function _removeBeforeObserver(obj, path, target, method) {
    unwatch(obj, path);
    removeListener(obj, beforeEvent(path), target, method);

    return this;
  }

  /**
  @module ember
  */

  // ..........................................................
  // BINDING
  //

  var Binding = function () {
    function Binding(toPath, fromPath) {
      emberBabel.classCallCheck(this, Binding);

      // Configuration
      this._from = fromPath;
      this._to = toPath;
      this._oneWay = undefined;

      // State
      this._direction = undefined;
      this._readyToSync = undefined;
      this._fromObj = undefined;
      this._fromPath = undefined;
      this._toObj = undefined;
    }

    /**
      @class Binding
      @namespace Ember
      @deprecated See https://emberjs.com/deprecations/v2.x#toc_ember-binding
      @public
    */

    /**
      This copies the Binding so it can be connected to another object.
       @method copy
      @return {Ember.Binding} `this`
      @public
    */

    Binding.prototype.copy = function copy() {
      var copy = new Binding(this._to, this._from);
      if (this._oneWay) {
        copy._oneWay = true;
      }
      return copy;
    };

    // ..........................................................
    // CONFIG
    //

    /**
      This will set `from` property path to the specified value. It will not
      attempt to resolve this property path to an actual object until you
      connect the binding.
       The binding will search for the property path starting at the root object
      you pass when you `connect()` the binding. It follows the same rules as
      `get()` - see that method for more information.
       @method from
      @param {String} path The property path to connect to.
      @return {Ember.Binding} `this`
      @public
    */

    Binding.prototype.from = function from(path) {
      this._from = path;
      return this;
    };

    /**
      This will set the `to` property path to the specified value. It will not
      attempt to resolve this property path to an actual object until you
      connect the binding.
       The binding will search for the property path starting at the root object
      you pass when you `connect()` the binding. It follows the same rules as
      `get()` - see that method for more information.
       @method to
      @param {String|Tuple} path A property path or tuple.
      @return {Ember.Binding} `this`
      @public
    */

    Binding.prototype.to = function to(path) {
      this._to = path;
      return this;
    };

    /**
      Configures the binding as one way. A one-way binding will relay changes
      on the `from` side to the `to` side, but not the other way around. This
      means that if you change the `to` side directly, the `from` side may have
      a different value.
       @method oneWay
      @return {Ember.Binding} `this`
      @public
    */

    Binding.prototype.oneWay = function oneWay() {
      this._oneWay = true;
      return this;
    };

    /**
      @method toString
      @return {String} string representation of binding
      @public
    */

    Binding.prototype.toString = function toString$$1() {
      var oneWay = this._oneWay ? '[oneWay]' : '';
      return 'Ember.Binding<' + emberUtils.guidFor(this) + '>(' + this._from + ' -> ' + this._to + ')' + oneWay;
    };

    // ..........................................................
    // CONNECT AND SYNC
    //

    /**
      Attempts to connect this binding instance so that it can receive and relay
      changes. This method will raise an exception if you have not set the
      from/to properties yet.
       @method connect
      @param {Object} obj The root object for this binding.
      @return {Ember.Binding} `this`
      @public
    */

    Binding.prototype.connect = function connect(obj) {
      true && !!!obj && emberDebug.assert('Must pass a valid object to Ember.Binding.connect()', !!obj);

      var fromObj = void 0,
          fromPath = void 0,
          possibleGlobal = void 0;

      // If the binding's "from" path could be interpreted as a global, verify
      // whether the path refers to a global or not by consulting `Ember.lookup`.
      if (isGlobalPath(this._from)) {
        var name = getFirstKey(this._from);
        possibleGlobal = emberEnvironment.context.lookup[name];

        if (possibleGlobal) {
          fromObj = possibleGlobal;
          fromPath = getTailPath(this._from);
        }
      }

      if (fromObj === undefined) {
        fromObj = obj;
        fromPath = this._from;
      }

      trySet(obj, this._to, get(fromObj, fromPath));

      // Add an observer on the object to be notified when the binding should be updated.
      addObserver(fromObj, fromPath, this, 'fromDidChange');

      // If the binding is a two-way binding, also set up an observer on the target.
      if (!this._oneWay) {
        addObserver(obj, this._to, this, 'toDidChange');
      }

      addListener(obj, 'willDestroy', this, 'disconnect');

      fireDeprecations(obj, this._to, this._from, possibleGlobal, this._oneWay, !possibleGlobal && !this._oneWay);

      this._readyToSync = true;
      this._fromObj = fromObj;
      this._fromPath = fromPath;
      this._toObj = obj;

      return this;
    };

    /**
      Disconnects the binding instance. Changes will no longer be relayed. You
      will not usually need to call this method.
       @method disconnect
      @return {Ember.Binding} `this`
      @public
    */

    Binding.prototype.disconnect = function disconnect() {
      true && !!!this._toObj && emberDebug.assert('Must pass a valid object to Ember.Binding.disconnect()', !!this._toObj);

      // Remove an observer on the object so we're no longer notified of
      // changes that should update bindings.

      removeObserver(this._fromObj, this._fromPath, this, 'fromDidChange');

      // If the binding is two-way, remove the observer from the target as well.
      if (!this._oneWay) {
        removeObserver(this._toObj, this._to, this, 'toDidChange');
      }

      this._readyToSync = false; // Disable scheduled syncs...
      return this;
    };

    // ..........................................................
    // PRIVATE
    //

    /* Called when the from side changes. */

    Binding.prototype.fromDidChange = function fromDidChange(target) {
      this._scheduleSync('fwd');
    };

    /* Called when the to side changes. */

    Binding.prototype.toDidChange = function toDidChange(target) {
      this._scheduleSync('back');
    };

    Binding.prototype._scheduleSync = function _scheduleSync(dir) {
      var existingDir = this._direction;

      // If we haven't scheduled the binding yet, schedule it.
      if (existingDir === undefined) {
        run.schedule('sync', this, '_sync');
        this._direction = dir;
      }

      // If both a 'back' and 'fwd' sync have been scheduled on the same object,
      // default to a 'fwd' sync so that it remains deterministic.
      if (existingDir === 'back' && dir === 'fwd') {
        this._direction = 'fwd';
      }
    };

    Binding.prototype._sync = function _sync() {
      var log = emberEnvironment.ENV.LOG_BINDINGS;

      var toObj = this._toObj;

      // Don't synchronize destroyed objects or disconnected bindings.
      if (toObj.isDestroyed || !this._readyToSync) {
        return;
      }

      // Get the direction of the binding for the object we are
      // synchronizing from.
      var direction = this._direction;

      var fromObj = this._fromObj;
      var fromPath = this._fromPath;

      this._direction = undefined;

      // If we're synchronizing from the remote object...
      if (direction === 'fwd') {
        var fromValue = get(fromObj, fromPath);
        if (log) {
          Logger.log(' ', this.toString(), '->', fromValue, fromObj);
        }
        if (this._oneWay) {
          trySet(toObj, this._to, fromValue);
        } else {
          _suspendObserver(toObj, this._to, this, 'toDidChange', function () {
            trySet(toObj, this._to, fromValue);
          });
        }
        // If we're synchronizing *to* the remote object.
      } else if (direction === 'back') {
        var toValue = get(toObj, this._to);
        if (log) {
          Logger.log(' ', this.toString(), '<-', toValue, toObj);
        }
        _suspendObserver(fromObj, fromPath, this, 'fromDidChange', function () {
          trySet(fromObj, fromPath, toValue);
        });
      }
    };

    return Binding;
  }();

  function fireDeprecations(obj, toPath, fromPath, deprecateGlobal, deprecateOneWay, deprecateAlias) {
    var deprecateGlobalMessage = '`Ember.Binding` is deprecated. Since you' + ' are binding to a global consider using a service instead.';
    var deprecateOneWayMessage = '`Ember.Binding` is deprecated. Since you' + ' are using a `oneWay` binding consider using a `readOnly` computed' + ' property instead.';
    var deprecateAliasMessage = '`Ember.Binding` is deprecated. Consider' + ' using an `alias` computed property instead.';

    var objectInfo = 'The `' + toPath + '` property of `' + obj + '` is an `Ember.Binding` connected to `' + fromPath + '`, but ';
    true && !!deprecateGlobal && emberDebug.deprecate(objectInfo + deprecateGlobalMessage, !deprecateGlobal, {
      id: 'ember-metal.binding',
      until: '3.0.0',
      url: 'https://emberjs.com/deprecations/v2.x#toc_ember-binding'
    });
    true && !!deprecateOneWay && emberDebug.deprecate(objectInfo + deprecateOneWayMessage, !deprecateOneWay, {
      id: 'ember-metal.binding',
      until: '3.0.0',
      url: 'https://emberjs.com/deprecations/v2.x#toc_ember-binding'
    });
    true && !!deprecateAlias && emberDebug.deprecate(objectInfo + deprecateAliasMessage, !deprecateAlias, {
      id: 'ember-metal.binding',
      until: '3.0.0',
      url: 'https://emberjs.com/deprecations/v2.x#toc_ember-binding'
    });
  }

  function mixinProperties$1(to, from) {
    for (var key in from) {
      if (from.hasOwnProperty(key)) {
        to[key] = from[key];
      }
    }
  }

  mixinProperties$1(Binding, {

    /*
      See `Ember.Binding.from`.
       @method from
      @static
    */
    from: function (from) {
      var C = this;
      return new C(undefined, from);
    },

    /*
      See `Ember.Binding.to`.
       @method to
      @static
    */
    to: function (to) {
      var C = this;
      return new C(to, undefined);
    }
  });
  /**
    An `Ember.Binding` connects the properties of two objects so that whenever
    the value of one property changes, the other property will be changed also.
  
    ## Automatic Creation of Bindings with `/^*Binding/`-named Properties.
  
    You do not usually create Binding objects directly but instead describe
    bindings in your class or object definition using automatic binding
    detection.
  
    Properties ending in a `Binding` suffix will be converted to `Ember.Binding`
    instances. The value of this property should be a string representing a path
    to another object or a custom binding instance created using Binding helpers
    (see "One Way Bindings"):
  
    ```
    valueBinding: "MyApp.someController.title"
    ```
  
    This will create a binding from `MyApp.someController.title` to the `value`
    property of your object instance automatically. Now the two values will be
    kept in sync.
  
    ## One Way Bindings
  
    One especially useful binding customization you can use is the `oneWay()`
    helper. This helper tells Ember that you are only interested in
    receiving changes on the object you are binding from. For example, if you
    are binding to a preference and you want to be notified if the preference
    has changed, but your object will not be changing the preference itself, you
    could do:
  
    ```
    bigTitlesBinding: Ember.Binding.oneWay("MyApp.preferencesController.bigTitles")
    ```
  
    This way if the value of `MyApp.preferencesController.bigTitles` changes the
    `bigTitles` property of your object will change also. However, if you
    change the value of your `bigTitles` property, it will not update the
    `preferencesController`.
  
    One way bindings are almost twice as fast to setup and twice as fast to
    execute because the binding only has to worry about changes to one side.
  
    You should consider using one way bindings anytime you have an object that
    may be created frequently and you do not intend to change a property; only
    to monitor it for changes (such as in the example above).
  
    ## Adding Bindings Manually
  
    All of the examples above show you how to configure a custom binding, but the
    result of these customizations will be a binding template, not a fully active
    Binding instance. The binding will actually become active only when you
    instantiate the object the binding belongs to. It is useful, however, to
    understand what actually happens when the binding is activated.
  
    For a binding to function it must have at least a `from` property and a `to`
    property. The `from` property path points to the object/key that you want to
    bind from while the `to` path points to the object/key you want to bind to.
  
    When you define a custom binding, you are usually describing the property
    you want to bind from (such as `MyApp.someController.value` in the examples
    above). When your object is created, it will automatically assign the value
    you want to bind `to` based on the name of your binding key. In the
    examples above, during init, Ember objects will effectively call
    something like this on your binding:
  
    ```javascript
    binding = Ember.Binding.from("valueBinding").to("value");
    ```
  
    This creates a new binding instance based on the template you provide, and
    sets the to path to the `value` property of the new object. Now that the
    binding is fully configured with a `from` and a `to`, it simply needs to be
    connected to become active. This is done through the `connect()` method:
  
    ```javascript
    binding.connect(this);
    ```
  
    Note that when you connect a binding you pass the object you want it to be
    connected to. This object will be used as the root for both the from and
    to side of the binding when inspecting relative paths. This allows the
    binding to be automatically inherited by subclassed objects as well.
  
    This also allows you to bind between objects using the paths you declare in
    `from` and `to`:
  
    ```javascript
    // Example 1
    binding = Ember.Binding.from("App.someObject.value").to("value");
    binding.connect(this);
  
    // Example 2
    binding = Ember.Binding.from("parentView.value").to("App.someObject.value");
    binding.connect(this);
    ```
  
    Now that the binding is connected, it will observe both the from and to side
    and relay changes.
  
    If you ever needed to do so (you almost never will, but it is useful to
    understand this anyway), you could manually create an active binding by
    using the `Ember.bind()` helper method. (This is the same method used by
    to setup your bindings on objects):
  
    ```javascript
    Ember.bind(MyApp.anotherObject, "value", "MyApp.someController.value");
    ```
  
    Both of these code fragments have the same effect as doing the most friendly
    form of binding creation like so:
  
    ```javascript
    MyApp.anotherObject = Ember.Object.create({
      valueBinding: "MyApp.someController.value",
  
      // OTHER CODE FOR THIS OBJECT...
    });
    ```
  
    Ember's built in binding creation method makes it easy to automatically
    create bindings for you. You should always use the highest-level APIs
    available, even if you understand how it works underneath.
  
    @class Binding
    @namespace Ember
    @since Ember 0.9
    @public
  */
  // Ember.Binding = Binding; ES6TODO: where to put this?


  /**
    Global helper method to create a new binding. Just pass the root object
    along with a `to` and `from` path to create and connect the binding.
  
    @method bind
    @for Ember
    @param {Object} obj The root object of the transform.
    @param {String} to The path to the 'to' side of the binding.
      Must be relative to obj.
    @param {String} from The path to the 'from' side of the binding.
      Must be relative to obj or a global path.
    @return {Ember.Binding} binding instance
    @public
  */
  function bind(obj, to, from) {
    return new Binding(to, from).connect(obj);
  }

  /**
  @module @ember/object
  */
  var a_concat = Array.prototype.concat;
  var isArray = Array.isArray;

  function isMethod(obj) {
    return 'function' === typeof obj && obj.isMethod !== false && obj !== Boolean && obj !== Object && obj !== Number && obj !== Array && obj !== Date && obj !== String;
  }

  var CONTINUE = {};

  function mixinProperties(mixinsMeta, mixin) {
    var guid = void 0;

    if (mixin instanceof Mixin) {
      guid = emberUtils.guidFor(mixin);
      if (mixinsMeta.peekMixins(guid)) {
        return CONTINUE;
      }
      mixinsMeta.writeMixins(guid, mixin);
      return mixin.properties;
    } else {
      return mixin; // apply anonymous mixin properties
    }
  }

  function concatenatedMixinProperties(concatProp, props, values, base) {
    // reset before adding each new mixin to pickup concats from previous
    var concats = values[concatProp] || base[concatProp];
    if (props[concatProp]) {
      concats = concats ? a_concat.call(concats, props[concatProp]) : props[concatProp];
    }
    return concats;
  }

  function giveDescriptorSuper(meta$$1, key, property, values, descs, base) {
    var superProperty = void 0;

    // Computed properties override methods, and do not call super to them
    if (values[key] === undefined) {
      // Find the original descriptor in a parent mixin
      superProperty = descs[key];
    }

    // If we didn't find the original descriptor in a parent mixin, find
    // it on the original object.
    if (!superProperty) {
      var possibleDesc = base[key];
      var superDesc = possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor ? possibleDesc : undefined;

      superProperty = superDesc;
    }

    if (superProperty === undefined || !(superProperty instanceof ComputedProperty)) {
      return property;
    }

    // Since multiple mixins may inherit from the same parent, we need
    // to clone the computed property so that other mixins do not receive
    // the wrapped version.
    property = Object.create(property);
    property._getter = emberUtils.wrap(property._getter, superProperty._getter);
    if (superProperty._setter) {
      if (property._setter) {
        property._setter = emberUtils.wrap(property._setter, superProperty._setter);
      } else {
        property._setter = superProperty._setter;
      }
    }

    return property;
  }

  function giveMethodSuper(obj, key, method, values, descs) {
    var superMethod = void 0;

    // Methods overwrite computed properties, and do not call super to them.
    if (descs[key] === undefined) {
      // Find the original method in a parent mixin
      superMethod = values[key];
    }

    // If we didn't find the original value in a parent mixin, find it in
    // the original object
    superMethod = superMethod || obj[key];

    // Only wrap the new method if the original method was a function
    if (superMethod === undefined || 'function' !== typeof superMethod) {
      return method;
    }

    return emberUtils.wrap(method, superMethod);
  }

  function applyConcatenatedProperties(obj, key, value, values) {
    var baseValue = values[key] || obj[key];
    var ret = void 0;

    if (baseValue === null || baseValue === undefined) {
      ret = emberUtils.makeArray(value);
    } else if (isArray(baseValue)) {
      if (value === null || value === undefined) {
        ret = baseValue;
      } else {
        ret = a_concat.call(baseValue, value);
      }
    } else {
      ret = a_concat.call(emberUtils.makeArray(baseValue), value);
    }

    {
      // it is possible to use concatenatedProperties with strings (which cannot be frozen)
      // only freeze objects...
      if (typeof ret === 'object' && ret !== null) {
        // prevent mutating `concatenatedProperties` array after it is applied
        Object.freeze(ret);
      }
    }

    return ret;
  }

  function applyMergedProperties(obj, key, value, values) {
    var baseValue = values[key] || obj[key];

    true && !!isArray(value) && emberDebug.assert('You passed in `' + JSON.stringify(value) + '` as the value for `' + key + '` but `' + key + '` cannot be an Array', !isArray(value));

    if (!baseValue) {
      return value;
    }

    var newBase = emberUtils.assign({}, baseValue);
    var hasFunction = false;

    for (var prop in value) {
      if (!value.hasOwnProperty(prop)) {
        continue;
      }

      var propValue = value[prop];
      if (isMethod(propValue)) {
        // TODO: support for Computed Properties, etc?
        hasFunction = true;
        newBase[prop] = giveMethodSuper(obj, prop, propValue, baseValue, {});
      } else {
        newBase[prop] = propValue;
      }
    }

    if (hasFunction) {
      newBase._super = emberUtils.ROOT;
    }

    return newBase;
  }

  function addNormalizedProperty(base, key, value, meta$$1, descs, values, concats, mergings) {
    if (value instanceof Descriptor) {
      if (value === REQUIRED && descs[key]) {
        return CONTINUE;
      }

      // Wrap descriptor function to implement
      // _super() if needed
      if (value._getter) {
        value = giveDescriptorSuper(meta$$1, key, value, values, descs, base);
      }

      descs[key] = value;
      values[key] = undefined;
    } else {
      if (concats && concats.indexOf(key) >= 0 || key === 'concatenatedProperties' || key === 'mergedProperties') {
        value = applyConcatenatedProperties(base, key, value, values);
      } else if (mergings && mergings.indexOf(key) > -1) {
        value = applyMergedProperties(base, key, value, values);
      } else if (isMethod(value)) {
        value = giveMethodSuper(base, key, value, values, descs);
      }

      descs[key] = undefined;
      values[key] = value;
    }
  }

  function mergeMixins(mixins, meta$$1, descs, values, base, keys) {
    var currentMixin = void 0,
        props = void 0,
        key = void 0,
        concats = void 0,
        mergings = void 0;

    function removeKeys(keyName) {
      delete descs[keyName];
      delete values[keyName];
    }

    for (var i = 0; i < mixins.length; i++) {
      currentMixin = mixins[i];
      true && !(typeof currentMixin === 'object' && currentMixin !== null && Object.prototype.toString.call(currentMixin) !== '[object Array]') && emberDebug.assert('Expected hash or Mixin instance, got ' + Object.prototype.toString.call(currentMixin), typeof currentMixin === 'object' && currentMixin !== null && Object.prototype.toString.call(currentMixin) !== '[object Array]');

      props = mixinProperties(meta$$1, currentMixin);
      if (props === CONTINUE) {
        continue;
      }

      if (props) {
        if (base.willMergeMixin) {
          base.willMergeMixin(props);
        }
        concats = concatenatedMixinProperties('concatenatedProperties', props, values, base);
        mergings = concatenatedMixinProperties('mergedProperties', props, values, base);

        for (key in props) {
          if (!props.hasOwnProperty(key)) {
            continue;
          }
          keys.push(key);
          addNormalizedProperty(base, key, props[key], meta$$1, descs, values, concats, mergings);
        }

        // manually copy toString() because some JS engines do not enumerate it
        if (props.hasOwnProperty('toString')) {
          base.toString = props.toString;
        }
      } else if (currentMixin.mixins) {
        mergeMixins(currentMixin.mixins, meta$$1, descs, values, base, keys);
        if (currentMixin._without) {
          currentMixin._without.forEach(removeKeys);
        }
      }
    }
  }

  function detectBinding(key) {
    var length = key.length;

    return length > 7 && key.charCodeAt(length - 7) === 66 && key.indexOf('inding', length - 6) !== -1;
  }
  // warm both paths of above function
  detectBinding('notbound');
  detectBinding('fooBinding');

  function connectBindings(obj, meta$$1) {
    // TODO Mixin.apply(instance) should disconnect binding if exists
    meta$$1.forEachBindings(function (key, binding) {
      if (binding) {
        var to = key.slice(0, -7); // strip Binding off end
        if (binding instanceof Binding) {
          binding = binding.copy(); // copy prototypes' instance
          binding.to(to);
        } else {
          // binding is string path
          binding = new Binding(to, binding);
        }
        binding.connect(obj);
        obj[key] = binding;
      }
    });
    // mark as applied
    meta$$1.clearBindings();
  }

  function finishPartial(obj, meta$$1) {
    connectBindings(obj, meta$$1 === undefined ? meta(obj) : meta$$1);
    return obj;
  }

  function followAlias(obj, desc, descs, values) {
    var altKey = desc.methodName;
    var value = void 0;
    var possibleDesc = void 0;
    if (descs[altKey] || values[altKey]) {
      value = values[altKey];
      desc = descs[altKey];
    } else if ((possibleDesc = obj[altKey]) && possibleDesc !== null && typeof possibleDesc === 'object' && possibleDesc.isDescriptor) {
      desc = possibleDesc;
      value = undefined;
    } else {
      desc = undefined;
      value = obj[altKey];
    }

    return { desc: desc, value: value };
  }

  function updateObserversAndListeners(obj, key, paths, updateMethod) {
    if (paths) {
      for (var i = 0; i < paths.length; i++) {
        updateMethod(obj, paths[i], null, key);
      }
    }
  }

  function replaceObserversAndListeners(obj, key, observerOrListener) {
    var prev = obj[key];

    if (typeof prev === 'function') {
      updateObserversAndListeners(obj, key, prev.__ember_observesBefore__, _removeBeforeObserver);
      updateObserversAndListeners(obj, key, prev.__ember_observes__, removeObserver);
      updateObserversAndListeners(obj, key, prev.__ember_listens__, removeListener);
    }

    if (typeof observerOrListener === 'function') {
      updateObserversAndListeners(obj, key, observerOrListener.__ember_observesBefore__, _addBeforeObserver);
      updateObserversAndListeners(obj, key, observerOrListener.__ember_observes__, addObserver);
      updateObserversAndListeners(obj, key, observerOrListener.__ember_listens__, addListener);
    }
  }

  function applyMixin(obj, mixins, partial) {
    var descs = {};
    var values = {};
    var meta$$1 = meta(obj);
    var keys = [];
    var key = void 0,
        value = void 0,
        desc = void 0;

    obj._super = emberUtils.ROOT;

    // Go through all mixins and hashes passed in, and:
    //
    // * Handle concatenated properties
    // * Handle merged properties
    // * Set up _super wrapping if necessary
    // * Set up computed property descriptors
    // * Copying `toString` in broken browsers
    mergeMixins(mixins, meta$$1, descs, values, obj, keys);

    for (var i = 0; i < keys.length; i++) {
      key = keys[i];
      if (key === 'constructor' || !values.hasOwnProperty(key)) {
        continue;
      }

      desc = descs[key];
      value = values[key];

      if (desc === REQUIRED) {
        continue;
      }

      while (desc && desc instanceof Alias) {
        var followed = followAlias(obj, desc, descs, values);
        desc = followed.desc;
        value = followed.value;
      }

      if (desc === undefined && value === undefined) {
        continue;
      }

      replaceObserversAndListeners(obj, key, value);

      if (detectBinding(key)) {
        meta$$1.writeBindings(key, value);
      }

      defineProperty(obj, key, desc, value, meta$$1);
    }

    if (!partial) {
      // don't apply to prototype
      finishPartial(obj, meta$$1);
    }

    return obj;
  }

  /**
    @method mixin
    @param obj
    @param mixins*
    @return obj
    @private
  */
  function mixin(obj) {
    for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    applyMixin(obj, args, false);
    return obj;
  }

  /**
    The `Mixin` class allows you to create mixins, whose properties can be
    added to other classes. For instance,
  
    ```javascript
    import Mixin from '@ember/object/mixin';
  
    const EditableMixin = Mixin.create({
      edit() {
        console.log('starting to edit');
        this.set('isEditing', true);
      },
      isEditing: false
    });
    ```
  
    ```javascript
    import EmberObject from '@ember/object';
    import EditableMixin from '../mixins/editable';
  
    // Mix mixins into classes by passing them as the first arguments to
    // `.extend.`
    const Comment = EmberObject.extend(EditableMixin, {
      post: null
    });
  
    let comment = Comment.create({
      post: somePost
    });
  
    comment.edit(); // outputs 'starting to edit'
    ```
  
    Note that Mixins are created with `Mixin.create`, not
    `Mixin.extend`.
  
    Note that mixins extend a constructor's prototype so arrays and object literals
    defined as properties will be shared amongst objects that implement the mixin.
    If you want to define a property in a mixin that is not shared, you can define
    it either as a computed property or have it be created on initialization of the object.
  
    ```javascript
    // filters array will be shared amongst any object implementing mixin
    import Mixin from '@ember/object/mixin';
    import { A } from '@ember/array';
  
    const FilterableMixin = Mixin.create({
      filters: A()
    });
    ```
  
    ```javascript
    import Mixin from '@ember/object/mixin';
    import { A } from '@ember/array';
    import { computed } from '@ember/object';
  
    // filters will be a separate array for every object implementing the mixin
    const FilterableMixin = Mixin.create({
      filters: computed(function() {
        return A();
      })
    });
    ```
  
    ```javascript
    import Mixin from '@ember/object/mixin';
    import { A } from '@ember/array';
  
    // filters will be created as a separate array during the object's initialization
    const Filterable = Mixin.create({
      filters: null,
  
      init() {
        this._super(...arguments);
        this.set("filters", A());
      }
    });
    ```
  
    @class Mixin
    @public
  */

  var Mixin = function () {
    function Mixin(mixins, properties) {
      emberBabel.classCallCheck(this, Mixin);

      this.properties = properties;

      var length = mixins && mixins.length;

      if (length > 0) {
        var m = new Array(length);

        for (var i = 0; i < length; i++) {
          var x = mixins[i];
          if (x instanceof Mixin) {
            m[i] = x;
          } else {
            m[i] = new Mixin(undefined, x);
          }
        }

        this.mixins = m;
      } else {
        this.mixins = undefined;
      }
      this.ownerConstructor = undefined;
      this._without = undefined;
      this[emberUtils.GUID_KEY] = null;
      this[emberUtils.NAME_KEY] = null;
      emberDebug.debugSeal(this);
    }

    Mixin.applyPartial = function applyPartial(obj) {
      for (var _len2 = arguments.length, args = Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
        args[_key2 - 1] = arguments[_key2];
      }

      return applyMixin(obj, args, true);
    };

    /**
      @method create
      @for @ember/object/mixin
      @static
      @param arguments*
      @public
    */

    Mixin.create = function create() {
      // ES6TODO: this relies on a global state?
      unprocessedFlag = true;
      var M = this;

      for (var _len3 = arguments.length, args = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
        args[_key3] = arguments[_key3];
      }

      return new M(args, undefined);
    };

    // returns the mixins currently applied to the specified object
    // TODO: Make `mixin`


    Mixin.mixins = function mixins(obj) {
      var meta$$1 = exports.peekMeta(obj);
      var ret = [];
      if (meta$$1 === undefined) {
        return ret;
      }

      meta$$1.forEachMixins(function (key, currentMixin) {
        // skip primitive mixins since these are always anonymous
        if (!currentMixin.properties) {
          ret.push(currentMixin);
        }
      });

      return ret;
    };

    /**
      @method reopen
      @param arguments*
      @private
    */

    Mixin.prototype.reopen = function reopen() {
      var currentMixin = void 0;

      if (this.properties) {
        currentMixin = new Mixin(undefined, this.properties);
        this.properties = undefined;
        this.mixins = [currentMixin];
      } else if (!this.mixins) {
        this.mixins = [];
      }

      var mixins = this.mixins;
      var idx = void 0;

      for (idx = 0; idx < arguments.length; idx++) {
        currentMixin = arguments[idx];
        true && !(typeof currentMixin === 'object' && currentMixin !== null && Object.prototype.toString.call(currentMixin) !== '[object Array]') && emberDebug.assert('Expected hash or Mixin instance, got ' + Object.prototype.toString.call(currentMixin), typeof currentMixin === 'object' && currentMixin !== null && Object.prototype.toString.call(currentMixin) !== '[object Array]');

        if (currentMixin instanceof Mixin) {
          mixins.push(currentMixin);
        } else {
          mixins.push(new Mixin(undefined, currentMixin));
        }
      }

      return this;
    };

    /**
      @method apply
      @param obj
      @return applied object
      @private
    */

    Mixin.prototype.apply = function apply(obj) {
      return applyMixin(obj, [this], false);
    };

    Mixin.prototype.applyPartial = function applyPartial(obj) {
      return applyMixin(obj, [this], true);
    };

    /**
      @method detect
      @param obj
      @return {Boolean}
      @private
    */

    Mixin.prototype.detect = function detect(obj) {
      if (typeof obj !== 'object' || obj === null) {
        return false;
      }
      if (obj instanceof Mixin) {
        return _detect(obj, this, {});
      }
      var meta$$1 = exports.peekMeta(obj);
      if (meta$$1 === undefined) {
        return false;
      }
      return !!meta$$1.peekMixins(emberUtils.guidFor(this));
    };

    Mixin.prototype.without = function without() {
      var ret = new Mixin([this]);

      for (var _len4 = arguments.length, args = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
        args[_key4] = arguments[_key4];
      }

      ret._without = args;
      return ret;
    };

    Mixin.prototype.keys = function keys() {
      var keys = {};
      var seen = {};

      _keys(keys, this, seen);
      var ret = Object.keys(keys);
      return ret;
    };

    return Mixin;
  }();

  Mixin._apply = applyMixin;
  Mixin.finishPartial = finishPartial;

  var MixinPrototype = Mixin.prototype;
  MixinPrototype.toString = Object.toString;

  emberDebug.debugSeal(MixinPrototype);

  var unprocessedFlag = false;

  function hasUnprocessedMixins() {
    return unprocessedFlag;
  }

  function clearUnprocessedMixins() {
    unprocessedFlag = false;
  }

  function _detect(curMixin, targetMixin, seen) {
    var guid = emberUtils.guidFor(curMixin);

    if (seen[guid]) {
      return false;
    }
    seen[guid] = true;

    if (curMixin === targetMixin) {
      return true;
    }
    var mixins = curMixin.mixins;
    var loc = mixins ? mixins.length : 0;
    while (--loc >= 0) {
      if (_detect(mixins[loc], targetMixin, seen)) {
        return true;
      }
    }
    return false;
  }

  function _keys(ret, mixin, seen) {
    if (seen[emberUtils.guidFor(mixin)]) {
      return;
    }
    seen[emberUtils.guidFor(mixin)] = true;

    if (mixin.properties) {
      var props = Object.keys(mixin.properties);
      for (var i = 0; i < props.length; i++) {
        var key = props[i];
        ret[key] = true;
      }
    } else if (mixin.mixins) {
      mixin.mixins.forEach(function (x) {
        return _keys(ret, x, seen);
      });
    }
  }

  var REQUIRED = new Descriptor();
  REQUIRED.toString = function () {
    return '(Required Property)';
  };

  /**
    Denotes a required property for a mixin
  
    @method required
    @for Ember
    @private
  */
  function required() {
    true && !false && emberDebug.deprecate('Ember.required is deprecated as its behavior is inconsistent and unreliable.', false, { id: 'ember-metal.required', until: '3.0.0' });

    return REQUIRED;
  }

  function Alias(methodName) {
    this.isDescriptor = true;
    this.methodName = methodName;
  }

  Alias.prototype = new Descriptor();

  /**
    Makes a method available via an additional name.
  
    ```app/utils/person.js
    import EmberObject, {
      aliasMethod
    } from '@ember/object';
  
    export default EmberObject.extend({
      name() {
        return 'Tomhuda Katzdale';
      },
      moniker: aliasMethod('name')
    });
    ```
  
    ```javascript
    let goodGuy = Person.create();
  
    goodGuy.name();    // 'Tomhuda Katzdale'
    goodGuy.moniker(); // 'Tomhuda Katzdale'
    ```
  
    @method aliasMethod
    @static
    @for @ember/object
    @param {String} methodName name of the method to alias
    @public
  */
  function aliasMethod(methodName) {
    return new Alias(methodName);
  }

  // ..........................................................
  // OBSERVER HELPER
  //

  /**
    Specify a method that observes property changes.
  
    ```javascript
    import EmberObject from '@ember/object';
    import { observer } from '@ember/object';
  
    export default EmberObject.extend({
      valueObserver: observer('value', function() {
        // Executes whenever the "value" property changes
      })
    });
    ```
  
    Also available as `Function.prototype.observes` if prototype extensions are
    enabled.
  
    @method observer
    @for @ember/object
    @param {String} propertyNames*
    @param {Function} func
    @return func
    @public
    @static
  */
  function observer() {
    var _paths = void 0,
        func = void 0;

    for (var _len5 = arguments.length, args = Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
      args[_key5] = arguments[_key5];
    }

    if (typeof args[args.length - 1] !== 'function') {
      // revert to old, soft-deprecated argument ordering
      true && !false && emberDebug.deprecate('Passing the dependentKeys after the callback function in observer is deprecated. Ensure the callback function is the last argument.', false, { id: 'ember-metal.observer-argument-order', until: '3.0.0' });

      func = args.shift();
      _paths = args;
    } else {
      func = args.pop();
      _paths = args;
    }

    true && !(typeof func === 'function') && emberDebug.assert('observer called without a function', typeof func === 'function');
    true && !(_paths.length > 0 && _paths.every(function (p) {
      return typeof p === 'string' && p.length;
    })) && emberDebug.assert('observer called without valid path', _paths.length > 0 && _paths.every(function (p) {
      return typeof p === 'string' && p.length;
    }));

    var paths = [];
    var addWatchedProperty = function (path) {
      return paths.push(path);
    };

    for (var i = 0; i < _paths.length; ++i) {
      expandProperties(_paths[i], addWatchedProperty);
    }

    func.__ember_observes__ = paths;
    return func;
  }

  /**
    Specify a method that observes property changes.
  
    ```javascript
    import EmberObject from '@ember/object';
  
    EmberObject.extend({
      valueObserver: Ember.immediateObserver('value', function() {
        // Executes whenever the "value" property changes
      })
    });
    ```
  
    In the future, `observer` may become asynchronous. In this event,
    `immediateObserver` will maintain the synchronous behavior.
  
    Also available as `Function.prototype.observesImmediately` if prototype extensions are
    enabled.
  
    @method _immediateObserver
    @for Ember
    @param {String} propertyNames*
    @param {Function} func
    @deprecated Use `observer` instead.
    @return func
    @private
  */
  function _immediateObserver() {
    true && !false && emberDebug.deprecate('Usage of `Ember.immediateObserver` is deprecated, use `observer` instead.', false, { id: 'ember-metal.immediate-observer', until: '3.0.0' });

    for (var i = 0; i < arguments.length; i++) {
      var arg = arguments[i];
      true && !(typeof arg !== 'strin