/* eslint-env browser, node */

'use strict';

var viewport = {};
var width = -1;
var height = -1;


// Public interface
//------------------------------------------------------------------------------

/**
 * Get browser viewport width.
 *
 * @returns {number} Internal reference to browser viewport width.
 */
viewport.width = function() {
  return width;
};

/**
 * Get browser viewport height.
 *
 * @returns {number} Internal reference to browser viewport height.
 */
viewport.height = function() {
  return height;
};

/**
 * Get maximum browser viewport dimension (width or height).
 *
 * @returns {number} Internal reference to maximum browser viewport dimension.
 */
viewport.max = function() {
  return Math.max(width, height);
};

/**
 * Get minimum browser viewport dimension (width or height).
 *
 * @returns {number} Internal reference to minimum browser viewport dimension.
 */
viewport.min = function() {
  return Math.min(width, height);
};


/**
 * Set internal dimension references to current browser viewport width and height.
 * Called by viewport#onWindowResize on resize and orientationchange.
 */
viewport.setDimensions = function() {
  /* istanbul ignore else */
  if (typeof document !== 'undefined') {
    width = document.documentElement.clientWidth;
    height = document.documentElement.clientHeight;
  }
};


// Protected methods
//------------------------------------------------------------------------------

/**
 * Handler for window resize and orientationchange events. Calls viewport#setDimensions.
 *
 * @private
 */
viewport.onWindowResize = function() {
  viewport.setDimensions();
};

/* istanbul ignore else */
if (typeof window !== 'undefined') {
  window.addEventListener('resize', viewport.onWindowResize, false);
  window.addEventListener('orientationchange', viewport.onWindowResize, false);

  viewport.setDimensions();
}

// Exports
module.exports = viewport;
