/*!
 * cdp-cli.js 0.1.6
 *
 * Date: 2018-02-23T13:25:43.889Z
 */
module.exports=function(modules){var installedModules={};function __webpack_require__(moduleId){if(installedModules[moduleId]){return installedModules[moduleId].exports}var module=installedModules[moduleId]={i:moduleId,l:false,exports:{}};modules[moduleId].call(module.exports,module,module.exports,__webpack_require__);module.l=true;return module.exports}__webpack_require__.m=modules;__webpack_require__.c=installedModules;__webpack_require__.d=function(exports,name,getter){if(!__webpack_require__.o(exports,name)){Object.defineProperty(exports,name,{configurable:false,enumerable:true,get:getter})}};__webpack_require__.n=function(module){var getter=module&&module.__esModule?function getDefault(){return module["default"]}:function getModuleExports(){return module};__webpack_require__.d(getter,"a",getter);return getter};__webpack_require__.o=function(object,property){return Object.prototype.hasOwnProperty.call(object,property)};__webpack_require__.p="";return __webpack_require__(__webpack_require__.s=8)}([function(module,exports){module.exports=require("cdp-lib")},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});const path=__webpack_require__(2);const inquirer=__webpack_require__(3);const cdp_lib_1=__webpack_require__(0);const fs=cdp_lib_1.Utils.fs;const chalk=cdp_lib_1.Utils.chalk;const _=cdp_lib_1.Utils._;class PromptBase{constructor(){this._answers={};this._locale={}}prompting(cmdInfo){this._cmdInfo=cmdInfo;return new Promise((resolve,reject)=>{this.showPrologue();this.inquireLanguage().then(()=>{return this.inquire()}).then(settings=>{resolve(settings)}).catch(reason=>{reject(reason)})})}say(message){const GREETING="\n    ≡   "+chalk.yellow("|￣ |")+"\n  ≡    "+chalk.yellow("_|___ |_")+"   ／￣￣￣￣￣￣￣￣￣￣￣￣￣￣￣￣￣￣￣￣"+"\n    ≡ "+chalk.cyan("（ -^0^ ）")+"＜  "+chalk.yellow(message)+"\n  ≡   "+chalk.cyan("（  つ")+"＝"+chalk.cyan("つ")+"  ＼＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿＿"+"\n    ≡  "+chalk.cyan("｜ ｜ |")+"＼"+"\n    ≡ "+chalk.cyan("（_＿）＿）")+"＼"+"\n  ≡   "+chalk.red("◎")+"￣￣￣￣"+chalk.red("◎");console.log(GREETING)}get lang(){return this._locale}get answers(){return this._answers}get prologueComment(){return"Welcome to CDP Boilerplate Generator!"}showPrologue(){console.log("\n"+chalk.gray("================================================================"));this.say(this.prologueComment);console.log("\n"+chalk.gray("================================================================")+"\n")}updateAnswers(update){return _.merge(this._answers,update)}inquireSettings(){return new Promise((resolve,reject)=>{inquirer.prompt(this.questions).then(answers=>{resolve(answers)}).catch(reason=>{reject(reason)})})}config2description(config,itemName,color="cyan"){const item=this.lang.settings[itemName];if(null==item){console.error(chalk.red("error. item not found. item name: "+itemName));process.exit(1)}const prop=(()=>{if(item.props){return item.props[config[itemName]]}else if("boolean"===typeof config[itemName]){return item.bool[config[itemName]?"yes":"no"]}else{return config[itemName]}})();return item.label+chalk[color](prop)}loadLanguage(locale){try{this._locale=JSON.parse(fs.readFileSync(path.join(this._cmdInfo.pkgDir,"res/locales/messages."+locale+".json"),"utf8").toString())}catch(error){throw Error("Language resource JSON parse error: "+error.message)}}inquireLanguage(){return new Promise((resolve,reject)=>{const question=[{type:"list",name:"language",message:"Please choose your preferred language.",choices:[{name:"English/英語",value:"en-US"},{name:"Japanese/日本語",value:"ja-JP"}],default:0}];inquirer.prompt(question).then(answer=>{this.loadLanguage(answer.language);resolve()}).catch(reason=>{reject(reason)})})}confirmSettings(){return new Promise((resolve,reject)=>{console.log("\n"+chalk.gray("================================================================")+"\n");const settings=this.displaySettingsByAnswers(this._answers);console.log("\n"+chalk.gray("================================================================")+"\n");console.log("check: "+this.lang.prompt.common.confirm.message);const question=[{type:"confirm",name:"confirmation",message:this.lang.prompt.common.confirm.message,default:true}];inquirer.prompt(question).then(answer=>{if(answer.confirmation){resolve(settings)}else{reject()}}).catch(reason=>{reject(reason)})})}reflectCommandInfo(config){config.action=this._cmdInfo.action;config.minify=this._cmdInfo.cliOptions.minify;config.settings={force:this._cmdInfo.cliOptions.force,verbose:this._cmdInfo.cliOptions.verbose,silent:this._cmdInfo.cliOptions.silent,targetDir:this._cmdInfo.cliOptions.targetDir,lang:this.lang.type};return config}inquire(){return new Promise((resolve,reject)=>{const proc=()=>{this.inquireSettings().then(answers=>{this.updateAnswers(answers);this.confirmSettings().then(config=>{resolve(this.reflectCommandInfo(config))}).catch(()=>{setTimeout(proc)})}).catch(reason=>{reject(reason)})};setTimeout(proc)})}}exports.PromptBase=PromptBase},function(module,exports){module.exports=require("path")},function(module,exports){module.exports=require("inquirer")},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});const libraryOnBrowser={projectType:"library",es:"es5",module:"umd",env:"web",tools:["webpack","nyc"]};const libraryOnNode={projectType:"library",es:"es2015",module:"commonjs",env:"node",tools:["webpack","nyc"]};const libraryOnElectron={projectType:"library",es:"es2015",module:"commonjs",env:"electron",tools:["webpack","nyc"]};const mobileOnBrowser={projectType:"mobile",es:"es5",module:"amd",env:"web",tools:["nyc"],platforms:["android","ios"],projectStructure:[],external:{"hogan.js":{acquisition:"npm",regular:true,alias:"hogan"},hammerjs:{acquisition:"npm",regular:true,globalExport:"Hammer",fileName:"hammer",subset:{"jquery-hammerjs":{acquisition:"npm",venderName:"hammerjs",fileName:"jquery.hammer",regular:true},"@types/hammerjs":{acquisition:"npm:dev",regular:true}}},"cordova-plugin-cdp-nativebridge":{acquisition:"cordova",regular:true},"cordova-plugin-inappbrowser":{acquisition:"cordova",regular:false,subset:{"@types/cordova-plugin-inappbrowser":{acquisition:"npm:dev",default:true}}},"cordova-plugin-app-version":{acquisition:"cordova",regular:false,subset:{"@types/cordova-plugin-app-version":{acquisition:"npm:dev",regular:true}}},iscroll:{acquisition:"npm",regular:false,globalExport:"IScroll",fileName:"iscroll-probe",subset:{"@types/iscroll":{acquisition:"npm:dev",regular:true}}},flipsnap:{acquisition:"npm",regular:false,globalExport:"Flipsnap",subset:{"@types/flipsnap":{acquisition:"npm:dev",regular:true}}}}};const desktopOnBrowser={projectType:"desktop",es:"es5",module:"amd",env:"web",tools:["nyc"]};const desktopOnElectron={projectType:"desktop",es:"es2015",module:"commonjs",env:"electron-renderer",tools:["webpack","nyc"]};const webOnBrowser={projectType:"web",es:"es5",module:"amd",env:"web"};exports.default={library:{browser:libraryOnBrowser,node:libraryOnNode,electron:libraryOnElectron,ELECTRON_AVAILABLE:false},mobile:{browser:mobileOnBrowser},desctop:{browser:desktopOnBrowser,electron:desktopOnElectron},web:{browser:webOnBrowser}}},function(module,exports,__webpack_require__){"use strict";function __export(m){for(var p in m)if(!exports.hasOwnProperty(p))exports[p]=m[p]}Object.defineProperty(exports,"__esModule",{value:true});__export(__webpack_require__(17));__export(__webpack_require__(6));__export(__webpack_require__(7))},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});__webpack_require__(7);const index_1=__webpack_require__(5);let _settings={force:false,verbose:false,silent:false,lang:"en-US"};function getSettings(){return index_1.deepExtend({},_settings)}exports.getSettings=getSettings;function setSettings(settings){if(settings){_settings.force=settings.force||_settings.force;_settings.verbose=settings.verbose||_settings.verbose;_settings.silent=settings.silent||_settings.silent;_settings.targetDir=settings.targetDir||_settings.targetDir;_settings.lang=settings.lang||_settings.lang}else{_settings={force:false,verbose:false,silent:false,lang:"en-US"}}}exports.setSettings=setSettings;function log(message,...optionalParams){if(!_settings.silent){if(0<optionalParams.length){console.log(message,optionalParams)}else{console.log(message)}}}exports.log=log;function debug(message,...optionalParams){if(!_settings.silent&&_settings.verbose){if(0<optionalParams.length){console.error("DEBUG: "+message,optionalParams)}else{console.error("DEBUG: "+message)}}}exports.debug=debug;function assert(test,message,...optionalParams){if(!test){if(_settings.force){if(0<optionalParams.length){console.warn(message,optionalParams)}else{console.warn(message)}}else{if(0<optionalParams.length){console.error(message,optionalParams)}else{console.error(message)}process.exit(1)}}}exports.assert=assert},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});const os=__webpack_require__(22);const child_process_1=__webpack_require__(23);const cli_spinner_1=__webpack_require__(24);const which=__webpack_require__(25);const deepExtend=__webpack_require__(26);exports.deepExtend=deepExtend;const settings_1=__webpack_require__(6);function handleError(error){settings_1.assert(false,error)}exports.handleError=handleError;function getSpinner(format,index){const spinners=["|/-\\","┤┘┴└├┌┬┐","◢◣◤◥","▌▀▐▄","▉▊▋▌▍▎▏▎▍▌▋▊▉","▁▃▄▅▆▇█▇▆▅▄▃","☱☲☴",".oO@*","◐◓◑◒","◡◡ ⊙⊙ ◠◠","■□▪▫","←↖↑↗→↘↓↙",".oO°Oo."];const fmt=format||"%s";const spinner=new cli_spinner_1.Spinner(fmt);const idx=null!=index&&0<=index&&index<14?index:Math.floor(Math.random()*10);spinner.setSpinnerString(spinners[idx]);return spinner}exports.getSpinner=getSpinner;function execCommand(command,args,options){return new Promise((resolve,reject)=>{const opt=deepExtend({},{stdio:"inherit",spinner:{format:"%s"},stdout:data=>{},stderr:data=>{}},options);const quoteIfNeeded=str=>{if("win32"===os.platform()&&str.includes(" ")){str='"'+str+'"';opt.shell=true}return str};which(command,(error,resolvedCommand)=>{if(error){handleError(JSON.stringify(error))}const spinner=opt.spinner?getSpinner(opt.spinner.format,opt.spinner.index):null;if(spinner){spinner.start()}resolvedCommand=quoteIfNeeded(resolvedCommand);args=args.map(quoteIfNeeded);const child=child_process_1.spawn(resolvedCommand,args,opt).on("error",handleError).on("close",code=>{if(spinner){spinner.stop(true)}resolve(code)});if("pipe"===opt.stdio){child.stdout.on("data",data=>{opt.stdout(data.toString())});child.stderr.on("data",data=>{opt.stderr(data.toString())})}})})}exports.execCommand=execCommand},function(module,exports,__webpack_require__){module.exports=__webpack_require__(9)},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});const cdp_lib_1=__webpack_require__(0);const command_parser_1=__webpack_require__(10);const prompt_library_1=__webpack_require__(12);const prompt_mobile_1=__webpack_require__(13);const prompt_desktop_1=__webpack_require__(14);const prompt_web_1=__webpack_require__(15);const cdp_doc_1=__webpack_require__(16);const chalk=cdp_lib_1.Utils.chalk;function getCreateInquirer(cmdInfo){switch(cmdInfo.target){case"library":return new prompt_library_1.PromptLibrary;case"mobile":return new prompt_mobile_1.PromptMobileApp;case"desktop":return new prompt_desktop_1.PromptDesktopApp;case"web":return new prompt_web_1.PromptWebApp;default:console.error(chalk.red("unsupported target: "+cmdInfo.target));process.exit(1)}}function inquireCreate(cmdInfo){const inquirer=getCreateInquirer(cmdInfo);inquirer.prompting(cmdInfo).then(config=>{return cdp_lib_1.default.execute(config)}).then(()=>{console.log(chalk.green(inquirer.lang.finished[cmdInfo.action]))}).catch(reason=>{if("string"!==typeof reason){if(null!=reason.message){reason=reason.message}else{reason=JSON.stringify(reason)}}console.error(chalk.red(reason))}).then(()=>{})}function browseDoc(prt){cdp_doc_1.default.execute(prt).then(resolve=>{console.log("Automaticaly web browser opened and you can browse cdp documents.");console.log("To quit browsing, press Ctrl + C.")}).catch(reject=>{console.log("Default port 8080 is already used. Please use another port, for example $ cdp doc -p 3000")})}function main(){process.title="cdp";const cmdInfo=command_parser_1.CommandParser.parse(process.argv);const prt=cmdInfo.cliOptions.port;switch(cmdInfo.action){case"create":inquireCreate(cmdInfo);break;case"doc":browseDoc(prt);break;default:console.error(chalk.red(cmdInfo.action+" command: under construction."));process.exit(1)}}exports.main=main},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});const path=__webpack_require__(2);const commander=__webpack_require__(11);const cdp_lib_1=__webpack_require__(0);const fs=cdp_lib_1.Utils.fs;const chalk=cdp_lib_1.Utils.chalk;class CommandParser{static parse(argv,options){const cmdline={pkgDir:this.getPackageDirectory(argv)};let pkg;try{pkg=JSON.parse(fs.readFileSync(path.join(cmdline.pkgDir,"package.json"),"utf8").toString())}catch(error){throw Error("package.json parse error: "+error.message)}commander.version(pkg.version).option("-f, --force","Continue execution even if in error situation").option("-t, --targetdir <path>","Specify project target directory").option("-c, --config <path>","Specify config file path").option("-v, --verbose","Show debug messages.").option("-s, --silent","Run as silent mode.").option("--no-minify","Not minified on release.").option("-p, --port <port>","Set local server port when browsing document");commander.command("init").description("init project").action(()=>{cmdline.action="init"}).on("--help",()=>{console.log(chalk.green("  Examples:"));console.log("");console.log(chalk.green("    $ cdp init"));console.log("")});commander.command("create <target>").description("create boilerplate for 'library, module' | 'mobile, app' | 'desktop' | 'web'").action(target=>{if(/^(module|app|library|mobile|desktop|web)$/i.test(target)){cmdline.action="create";cmdline.target=target;if("module"===cmdline.target){cmdline.target="library"}else if("app"===cmdline.target){cmdline.target="mobile"}}else{console.log(chalk.red.underline("  unsupported target: "+target));this.showHelp()}}).on("--help",()=>{console.log(chalk.green("  Examples:"));console.log("");console.log(chalk.green("    $ cdp create library"));console.log(chalk.green("    $ cdp create mobile"));console.log(chalk.green("    $ cdp create app -c setting.json"));console.log("")});commander.command("*",null,{noHelp:true}).action(cmd=>{console.log(chalk.red.underline("  unsupported command: "+cmd));this.showHelp()});commander.command("doc").description("show document with browser").action(()=>{cmdline.action="doc"}).on("--help",()=>{console.log(chalk.green("  Examples:"));console.log("");console.log(chalk.green("    $ cdp doc -p <port number>"));console.log(chalk.green("    $ cdp doc <<in case of using default port: 8080>>"));console.log("")});commander.parse(argv);if(argv.length<=2){this.showHelp()}cmdline.cliOptions=this.toCommandLineOptions(commander);return cmdline}static getPackageDirectory(argv){const execRealPath=fs.realpathSync(argv[1]);const execDir=path.dirname(execRealPath);return path.join(execDir,"..")}static toCommandLineOptions(command){return{force:!!command.force,targetDir:command.targetdir,config:command.config,verbose:!!command.verbose,silent:!!command.silent,minify:command.minify,port:command.port}}static showHelp(){const inform=text=>{return chalk.green(text)};commander.outputHelp(inform);process.exit(1)}}exports.CommandParser=CommandParser},function(module,exports){module.exports=require("commander")},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});const inquirer=__webpack_require__(3);const cdp_lib_1=__webpack_require__(0);const prompt_base_1=__webpack_require__(1);const default_config_1=__webpack_require__(4);const $=cdp_lib_1.Utils.$;const chalk=cdp_lib_1.Utils.chalk;const semverRegex=cdp_lib_1.Utils.semverRegex;const libConfig=default_config_1.default.library;class PromptLibrary extends prompt_base_1.PromptBase{get questions(){return[{type:"input",name:"projectName",message:this.lang.prompt.common.projectName.message,default:this.answers.projectName||"cool-project-name",validate:value=>{if(!/^[a-zA-Z0-9/@._-]+$/.test(value)){return this.lang.prompt.common.projectName.invalidMessage}else{return true}}},{type:"input",name:"version",message:this.lang.prompt.common.version.message,default:this.answers.version||"0.0.1",filter:value=>{if(semverRegex().test(value)){return semverRegex().exec(value)[0]}else{return value}},validate:value=>{if(semverRegex().test(value)){return true}else{return this.lang.prompt.common.version.invalidMessage}}},{type:"list",name:"license",message:this.lang.prompt.common.license.message,choices:[{name:this.lang.prompt.common.license.choices.apache2,value:"Apache-2.0"},{name:this.lang.prompt.common.license.choices.mit,value:"MIT"},{name:this.lang.prompt.common.license.choices.proprietary,value:"NONE"}],default:this.answers.license||"NONE"},{type:"list",name:"env",message:this.lang.prompt.library.env.message,choices:[{name:this.lang.prompt.common.env.choices.browser,value:"web"},{name:this.lang.prompt.common.env.choices.node,value:"node"},new inquirer.Separator,{name:this.lang.prompt.common.env.choices.electron+this.LIMITATION(),value:"electron"},{name:this.lang.prompt.common.env.choices.electronRenderer+this.LIMITATION(),value:"electron-renderer"}],filter:value=>{if(libConfig.ELECTRON_AVAILABLE){return value}else if("electron"===value){return"node"}else if("electron-renderer"===value){return"web"}else{return value}},default:this.answers.env||"web"},{type:"list",name:"extraSettings",message:this.lang.prompt.common.extraSettings.message,choices:[{name:this.lang.prompt.common.extraSettings.choices.recommended,value:"recommended"},{name:this.lang.prompt.common.extraSettings.choices.custom,value:"custom"}],default:this.answers.extraSettings||"recommended"},{type:"list",name:"module",message:this.lang.prompt.common.module.message,choices:[{name:this.lang.prompt.common.module.choices.none,value:"none"},{name:this.lang.prompt.common.module.choices.commonjs,value:"commonjs"},{name:this.lang.prompt.common.module.choices.umd,value:"umd"}],default:"amd"!==this.answers.module?this.answers.module||"commonjs":"commonjs",when:answers=>{return"custom"===answers.extraSettings&&/^(node|electron)$/i.test(answers.env)}},{type:"list",name:"module",message:this.lang.prompt.common.module.message,choices:[{name:this.lang.prompt.common.module.choices.none,value:"none"},{name:this.lang.prompt.common.module.choices.amd,value:"amd"},{name:this.lang.prompt.common.module.choices.umd,value:"umd"}],default:"commonjs"!==this.answers.module?this.answers.module||"amd":"amd",when:answers=>{return"custom"===answers.extraSettings&&"web"===answers.env}},{type:"list",name:"module",message:this.lang.prompt.common.module.message,choices:[{name:this.lang.prompt.common.module.choices.none,value:"none"},{name:this.lang.prompt.common.module.choices.commonjs,value:"commonjs"},{name:this.lang.prompt.common.module.choices.amd,value:"amd"},{name:this.lang.prompt.common.module.choices.umd,value:"umd"}],default:this.answers.module||"commonjs",when:answers=>{return"custom"===answers.extraSettings&&"electron-renderer"===answers.env}},{type:"list",name:"es",message:this.lang.prompt.common.es.message,choices:[{name:this.lang.prompt.common.es.choices.es5,value:"es5"},{name:this.lang.prompt.common.es.choices.es2015,value:"es2015"}],default:this.answers.es||("web"===this.answers.env?"es5":"es2015"),when:answers=>{return"custom"===answers.extraSettings}}]}displaySettingsByAnswers(answers){const config=(()=>{switch(answers.env){case"web":return $.extend({},libConfig.browser,answers);case"node":return $.extend({},libConfig.node,answers);case"electron":return $.extend({},libConfig.electron,answers);case"electron-renderer":return $.extend({},libConfig.electron,answers);default:console.error(chalk.red("unsupported target: "+answers.env));process.exit(1)}})();const items=[{name:"extraSettings",recommend:false},{name:"projectName",recommend:false},{name:"version",recommend:false},{name:"license",recommend:false},{name:"env",recommend:false},{name:"module",recommend:true},{name:"es",recommend:true}];try{items.forEach(item=>{const color=item.recommend&&"recommended"===answers.extraSettings?"yellow":undefined;console.log(this.config2description(config,item.name,color))})}catch(error){console.error(chalk.red("error: "+JSON.stringify(error,null,4)));process.exit(1)}return config}LIMITATION(){return libConfig.ELECTRON_AVAILABLE?"":" "+this.lang.prompt.common.stilNotAvailable}}exports.PromptLibrary=PromptLibrary},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});const inquirer=__webpack_require__(3);const cdp_lib_1=__webpack_require__(0);const prompt_base_1=__webpack_require__(1);const default_config_1=__webpack_require__(4);const $=cdp_lib_1.Utils.$;const _=cdp_lib_1.Utils._;const chalk=cdp_lib_1.Utils.chalk;const semverRegex=cdp_lib_1.Utils.semverRegex;const mobileConfig=default_config_1.default.mobile;const EXTERNAL_DEFAULTS=(()=>{const defaults=[];Object.keys(mobileConfig.browser.external).forEach(target=>{if(mobileConfig.browser.external[target].regular){defaults.push(target)}});return defaults})();class PromptMobileApp extends prompt_base_1.PromptBase{get questions(){const platforms_default=this.answers.platforms?this.answers.platforms.slice():mobileConfig.browser.platforms;delete this.answers.platforms;const projectStructure_default=this.answers.projectStructure?this.answers.projectStructure.slice():mobileConfig.browser.projectStructure;delete this.answers.projectStructure;const external_default=this.answers.external?this.answers.external.slice():EXTERNAL_DEFAULTS;delete this.answers.external;return[{type:"input",name:"appName",message:this.lang.prompt.mobile.appName.message,default:this.answers.appName||"Cool App Name",validate:value=>{if(/^.*[(\\|/|:|*|?|"|<|>||)].*$/.test(value)){return this.lang.prompt.mobile.appName.invalidMessage}else{return true}}},{type:"input",name:"projectName",message:this.lang.prompt.common.projectName.message,default:answers=>{return _.trim(_.dasherize(answers.appName.toLowerCase()),"-")},validate:value=>{if(!/^[a-zA-Z0-9_-]*$/.test(value)){return this.lang.prompt.common.projectName.invalidMessage}else{return true}}},{type:"input",name:"appId",message:this.lang.prompt.mobile.appId.message,default:this.answers.appId||"org.cool.appname",filter:value=>{return value.toLowerCase()}},{type:"input",name:"version",message:this.lang.prompt.common.version.message,default:this.answers.version||"0.0.1",filter:value=>{if(semverRegex().test(value)){return semverRegex().exec(value)[0]}else{return value}},validate:value=>{if(semverRegex().test(value)){return true}else{return this.lang.prompt.common.version.invalidMessage}}},{type:"list",name:"license",message:this.lang.prompt.common.license.message,choices:[{name:this.lang.prompt.common.license.choices.apache2,value:"Apache-2.0"},{name:this.lang.prompt.common.license.choices.mit,value:"MIT"},{name:this.lang.prompt.common.license.choices.proprietary,value:"NONE"}],default:this.answers.license||"NONE"},{type:"checkbox",name:"platforms",message:this.lang.prompt.mobile.platforms.message,choices:[{name:"android",checked:0<=platforms_default.indexOf("android")},{name:"ios",checked:0<=platforms_default.indexOf("ios")}]},{type:"list",name:"extraSettings",message:this.lang.prompt.common.extraSettings.message,choices:[{name:this.lang.prompt.common.extraSettings.choices.recommended,value:"recommended"},{name:this.lang.prompt.common.extraSettings.choices.custom,value:"custom"}],default:this.answers.extraSettings||"recommended"},{type:"checkbox",name:"projectStructure",message:this.lang.prompt.mobile.projectStructure.message,choices:[{name:this.lang.prompt.mobile.projectStructure.lib,value:"lib",checked:0<=projectStructure_default.indexOf("lib")},{name:this.lang.prompt.mobile.projectStructure.porting,value:"porting",checked:0<=projectStructure_default.indexOf("porting")}],when:answers=>{return"custom"===answers.extraSettings}},{type:"checkbox",name:"external",message:this.lang.prompt.mobile.external.message,paginated:false,choices:[new inquirer.Separator(this.lang.prompt.mobile.external.separator.cordova),{name:this.lang.prompt.mobile.external.modules["cordova-plugin-cdp-nativebridge"],value:"cordova-plugin-cdp-nativebridge",checked:0<=external_default.indexOf("cordova-plugin-cdp-nativebridge"),disabled:answers=>{if(!answers.platforms||answers.platforms.length<=0){return this.lang.prompt.mobile.external.noCordovaMessage}}},{name:this.lang.prompt.mobile.external.modules["cordova-plugin-inappbrowser"],value:"cordova-plugin-inappbrowser",checked:0<=external_default.indexOf("cordova-plugin-inappbrowser"),disabled:answers=>{if(!answers.platforms||answers.platforms.length<=0){return this.lang.prompt.mobile.external.noCordovaMessage}}},{name:this.lang.prompt.mobile.external.modules["cordova-plugin-app-version"],value:"cordova-plugin-app-version",checked:0<=external_default.indexOf("cordova-plugin-app-version"),disabled:answers=>{if(!answers.platforms||answers.platforms.length<=0){return this.lang.prompt.mobile.external.noCordovaMessage}}},new inquirer.Separator(this.lang.prompt.mobile.external.separator.utils),{name:this.lang.prompt.mobile.external.modules["hogan.js"],value:"hogan.js",checked:0<=external_default.indexOf("hogan.js")},{name:this.lang.prompt.mobile.external.modules["hammerjs"],value:"hammerjs",checked:0<=external_default.indexOf("hammerjs")},{name:this.lang.prompt.mobile.external.modules["iscroll"],value:"iscroll",checked:0<=external_default.indexOf("iscroll")},{name:this.lang.prompt.mobile.external.modules["flipsnap"],value:"flipsnap",checked:0<=external_default.indexOf("flipsnap")}],when:answers=>{return"custom"===answers.extraSettings}}]}displaySettingsByAnswers(answers){const config=(()=>{const defaults=$.extend({},mobileConfig.browser);const lookup=defaults.external;delete defaults.external;const _config=$.extend({},defaults,{external:EXTERNAL_DEFAULTS,dependencies:[],devDependencies:[],cordova_plugin:[],resource_addon:[]},answers);try{const resolveDependencies=(moduleName,info)=>{switch(info.acquisition){case"npm":_config.dependencies.push({name:moduleName,alias:info.alias,globalExport:info.globalExport,venderName:info.venderName,fileName:info.fileName});return true;case"npm:dev":_config.devDependencies.push({name:moduleName});return true;case"cordova":if(0<_config.platforms.length){_config.cordova_plugin.push({name:moduleName});return true}else{return false}case"resource":_config.resource_addon.push({name:moduleName,alias:info.alias,globalExport:info.globalExport,venderName:info.venderName,fileName:info.fileName});return true;default:return false}};_config.external.forEach(top=>{const info=lookup[top];const valid=resolveDependencies(top,info);if(valid&&info.subset){Object.keys(info.subset).forEach(sub=>{resolveDependencies(sub,info.subset[sub])})}})}catch(error){console.error(chalk.red("error: "+JSON.stringify(error,null,4)));process.exit(1)}delete _config.external;return _config})();const items=[{name:"extraSettings",fixed:false},{name:"appName",fixed:false},{name:"projectName",fixed:false},{name:"appId",fixed:false},{name:"version",fixed:false},{name:"license",fixed:false},{name:"module",fixed:true},{name:"es",fixed:true}];try{items.forEach(item=>{const color=item.fixed?"yellow":undefined;console.log(this.config2description(config,item.name,color))})}catch(error){console.error(chalk.red("error: "+JSON.stringify(error,null,4)));process.exit(1)}const platformInfo=0<config.platforms.length?config.platforms.join(", "):this.lang.settings.mobile.platforms.none;console.log("\n"+this.lang.settings.mobile.platforms.label+chalk.cyan(platformInfo));const COLOR="recommended"===answers.extraSettings?"yellow":"cyan";if(0<config.projectStructure.length){const projectStructure=config.projectStructure.join(", ");console.log("\n"+this.lang.settings.mobile.projectStructure.label+chalk[COLOR](projectStructure))}if(0<config.cordova_plugin.length){console.log("\n"+this.lang.settings.mobile.cordovaPlugins.label);config.cordova_plugin.forEach(info=>{console.log("    "+chalk[COLOR](info.name))})}if(0<config.dependencies.length){console.log("\n"+this.lang.settings.mobile.dependencies.label);config.resource_addon.forEach(info=>{console.log("    "+chalk[COLOR](info.name))});config.dependencies.forEach(info=>{console.log("    "+chalk[COLOR](info.name))})}return config}}exports.PromptMobileApp=PromptMobileApp},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});const cdp_lib_1=__webpack_require__(0);const prompt_base_1=__webpack_require__(1);const chalk=cdp_lib_1.Utils.chalk;class PromptDesktopApp extends prompt_base_1.PromptBase{prompting(cmdInfo){return new Promise((resolve,reject)=>{reject("desktop app prompting, under construction.")})}get questions(){return[]}displaySettingsByAnswers(answers){return null}}exports.PromptDesktopApp=PromptDesktopApp},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});const cdp_lib_1=__webpack_require__(0);const prompt_base_1=__webpack_require__(1);const chalk=cdp_lib_1.Utils.chalk;class PromptWebApp extends prompt_base_1.PromptBase{prompting(cmdInfo){return new Promise((resolve,reject)=>{reject("web app prompting, under construction.")})}get questions(){return[]}displaySettingsByAnswers(answers){return null}}exports.PromptWebApp=PromptWebApp},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});const Utils=__webpack_require__(5);class CDPDoc{static execute(prt){return Utils.launchLocalServer(prt).then(()=>{return Utils.launchBrowser(prt)})}}exports.default=CDPDoc},function(module,exports,__webpack_require__){"use strict";Object.defineProperty(exports,"__esModule",{value:true});const path=__webpack_require__(2);const opn=__webpack_require__(18);const express=__webpack_require__(19);const http=__webpack_require__(20);const url=__webpack_require__(21);let hostName="http://localhost:";const DEFAULT_PORT=8080;function launchBrowser(prt){let prtNumber=Number.parseInt(prt);prtNumber=prtNumber||DEFAULT_PORT;hostName+=String(prtNumber);const hostUrl=url.parse(hostName,true);return opn(hostUrl.href)}exports.launchBrowser=launchBrowser;function launchLocalServer(prt){return new Promise((resolve,reject)=>{const app=express();const htmlRoot=path.join(__dirname,"..","root");app.use(express.static(htmlRoot));let prtNumber=Number.parseInt(prt);prtNumber=prtNumber||DEFAULT_PORT;const server=http.createServer(app);server.on("error",e=>{const error_json_string=JSON.stringify(e);const error_js_object=JSON.parse(error_json_string);if(error_js_object.errno==="EADDRINUSE"){
// console.log("'EADDRINUSE' error happened!");     // debug message
return reject()}else{console.log("Unknown error except 'EADDRINUSE (default prot used)' happend!")}});server.listen(prtNumber,()=>{return resolve()})})}exports.launchLocalServer=launchLocalServer},function(module,exports){module.exports=require("opn")},function(module,exports){module.exports=require("express")},function(module,exports){module.exports=require("http")},function(module,exports){module.exports=require("url")},function(module,exports){module.exports=require("os")},function(module,exports){module.exports=require("child_process")},function(module,exports){module.exports=require("cli-spinner")},function(module,exports){module.exports=require("which")},function(module,exports){module.exports=require("deep-extend")}]);
//# sourceMappingURL=cdp-cli.min.js.map