/*!
 * @cdp/mobile 2.1.0
 *
 * Date: 2017-11-06T05:40:51.092Z
 *
 * including:
 *     @cdp/core 2.1.0
 *     @cdp/promise 2.1.0
 *     @cdp/nativebridge 2.1.0
 *     @cdp/i18n 2.1.0
 *     @cdp/framework-jqm 2.1.0
 *     @cdp/tools 2.1.0
 *     @cdp/ui-listview 2.1.0
 *     @cdp/ui-jqm 2.1.0
 */

//======================================================//

/*!
 * cdp.core.js 2.1.0
 *
 * Date: 2017-11-06T05:33:05.221Z
 */
(function (root, factory) { if (typeof define === "function" && define.amd) { define("cdp.core",[],function () { return factory(root.CDP || (root.CDP = {})); }); } else if (typeof exports === "object") { module.exports = factory(root.CDP || (root.CDP = {})); } else { factory(root.CDP || (root.CDP = {})); } }(((this || 0).self || global), function (CDP) {
var CDP;
(function (CDP) {
    var TAG = "[CDP] ";
    /**
     * @en Accessor for system global object.<br>
     *     It'll be usually a `window` object.
     * @ja システムの global オブジェクトへのアクセス<br>
     *     通常は `window` オブジェクトとなる
     */
    CDP.global = Function("return this")();
    /**
     * @en Accsessor for Web root location <br>
     *     Only the browser environment will be an allocating place in index.html, and becomes effective.
     * @ja Web root location へのアクセス <br>
     *     index.html の配置場所となり、ブラウザ環境のみ有効となる.
     */
    CDP.webRoot = (function () {
        if (CDP.global.location) {
            var baseUrl = /(.+\/)[^/]*#[^/]+/.exec(CDP.global.location.href);
            if (!baseUrl) {
                baseUrl = /(.+\/)/.exec(CDP.global.location.href);
            }
            return baseUrl[1];
        }
    })();
    /**
     * @en Converter from relative path to absolute url string. <br>
     *     If you want to access to Assets and in spite of the script location, the function is available.
     * @ja 相対 path を絶対 URL に変換 <br>
     *     js の配置に依存することなく `assets` アクセスしたいときに使用する.
     *
     * @see https://stackoverflow.com/questions/2188218/relative-paths-in-javascript-in-an-external-file
     *
     * @example <br>
     *
     * ```ts
     *  console.log(toUrl("/res/data/collection.json"));
     *  // "http://localhost:8080/app/res/data/collection.json"
     * ```
     *
     * @param path
     *  - `en` set relative path from [[webRoot]].
     *  - `ja` [[webRoot]] からの相対パスを指定
     * @returns url string
     *  - `en` set relative path from [[webRoot]].
     *  - `ja` [[webRoot]] からの相対パスを指定
     */
    function toUrl(path) {
        var root = CDP.webRoot || "";
        if (null != path && null != path[0]) {
            if ("/" === path[0]) {
                return root + path.slice(1);
            }
            else {
                return root + path;
            }
        }
        else {
            return root;
        }
    }
    CDP.toUrl = toUrl;
    /**
     * @en Accessor for global Config object.
     * @ja Config オブジェクトへのアクセス
     */
    CDP.Config = CDP.Config || CDP.global.Config || {};
    /**
     * @en Initialize function for `cdp-core`. <br>
     *     This function applies patch to the run time environment.
     * @ja `cdp-core` の初期化関数<br>
     *     環境の差分を吸収する patch を適用する.
     */
    function initialize(options) {
        setTimeout(function () {
            try {
                CDP.Patch.apply();
                if (options && typeof options.success === "function") {
                    options.success();
                }
            }
            catch (error) {
                var cause = CDP.ensureErrorInfo(error);
                var errorInfo = CDP.makeErrorInfo(CDP.RESULT_CODE.ERROR_CDP_INITIALIZE_FAILED, TAG, cause.message, cause);
                console.error(errorInfo.message);
                if (options && typeof options.fail === "function") {
                    options.fail(errorInfo);
                }
            }
        });
    }
    CDP.initialize = initialize;
})(CDP || (CDP = {}));
var CDP;
(function (CDP) {
    var TAG = "[CDP.Patch] ";
    /**
     * @en Utility class for appling the patch to the run time environment.
     * @ja 実行環境用 Patch 適用ユーティリティクラス
     *
     * @internal
     */
    var Patch = /** @class */ (function () {
        function Patch() {
        }
        ///////////////////////////////////////////////////////////////////////
        // public static methods:
        /**
         * @en Apply the patch
         * @ja パッチの適用
         *
         * @internal
         */
        Patch.apply = function () {
            Patch.consolePatch();
            Patch.nodePatch();
        };
        ///////////////////////////////////////////////////////////////////////
        // private static methods:
        // console 用 patch
        Patch.consolePatch = function () {
            if (null == CDP.global.console || null == CDP.global.console.error) {
                CDP.global.console = {
                    count: function () { },
                    groupEnd: function () { },
                    time: function () { },
                    timeEnd: function () { },
                    trace: function () { },
                    group: function () { },
                    dirxml: function () { },
                    debug: function () { },
                    groupCollapsed: function () { },
                    select: function () { },
                    info: function () { },
                    profile: function () { },
                    assert: function () { },
                    msIsIndependentlyComposed: function () { },
                    clear: function () { },
                    dir: function () { },
                    warn: function () { },
                    error: function () { },
                    log: function () { },
                    profileEnd: function () { }
                };
            }
        };
        // WinRT 用 patch
        Patch.nodePatch = function () {
            if ("object" === typeof MSApp) {
                var _MSApp_1 = MSApp;
                var originalAppendChild_1 = Node.prototype.appendChild;
                Node.prototype.appendChild = function (node) {
                    var self = this;
                    return _MSApp_1.execUnsafeLocalFunction(function () {
                        return originalAppendChild_1.call(self, node);
                    });
                };
                var originalInsertBefore_1 = Node.prototype.insertBefore;
                Node.prototype.insertBefore = function (newElement, referenceElement) {
                    var self = this;
                    return _MSApp_1.execUnsafeLocalFunction(function () {
                        return originalInsertBefore_1.call(self, newElement, referenceElement);
                    });
                };
            }
        };
        return Patch;
    }());
    CDP.Patch = Patch;
})(CDP || (CDP = {}));
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var CDP;
(function (CDP) {
    var UNKNOWN_ERROR_NAME = "Unknown Error";
    var ERROR_NAME_SEPARATOR = ": ";
    var CANCELED_MESSAGE = "abort";
    var s_code2message = {
        "0": "operation succeeded.",
        "1": "operation canceled.",
        "-1": "operation failed."
    };
    ///////////////////////////////////////////////////////////////////////
    // error utilities:
    /**
     * @en Common error code for the application.
     * @ja アプリケーション全体で使用する共通エラーコード定義
     */
    var RESULT_CODE;
    (function (RESULT_CODE) {
        /** `en` general success code <br> `ja` 汎用成功コード        */
        RESULT_CODE[RESULT_CODE["SUCCEEDED"] = 0] = "SUCCEEDED";
        /** `en` general cancel code  <br> `ja` 汎用キャンセルコード  */
        RESULT_CODE[RESULT_CODE["CANCELED"] = 1] = "CANCELED";
        /** `en` general error code   <br> `ja` 汎用エラーコード      */
        RESULT_CODE[RESULT_CODE["FAILED"] = -1] = "FAILED";
    })(RESULT_CODE = CDP.RESULT_CODE || (CDP.RESULT_CODE = {}));
    /**
     * @en The assignable range for the client's local result cord by which expansion is possible.
     * @ja クライアントが拡張可能なローカルリザルトコードのアサイン可能領域
     */
    CDP.MODULE_RESULT_CODE_RANGE = 1000;
    /**
     * @en Generate the [[ErrorInfo]] object.
     * @ja [[ErrorInfo]] オブジェクトを生成
     *
     * @example <br>
     *
     * ```ts
     *  someAsyncFunc()
     *      .then((result) => {
     *          outputMessage(result);
     *      })
     *      .catch((reason: Error) => {
     *          throw makeErrorInfo(
     *              RESULT_CODE.FAILED,
     *              TAG,
     *              "error occur.",
     *              reason  // set received error info.
     *          );
     *      });
     * ```
     *
     * @param resultCode
     *  - `en` set [[RESULT_CODE]] defined.
     *  - `ja` 定義した [[RESULT_CODE]] を指定
     * @param tag
     *  - `en` Log tag information
     *  - `ja` 識別情報
     * @param message
     *  - `en` Human readable message
     *  - `ja` メッセージを指定
     * @param cause
     *  - `en` low-level Error object
     *  - `ja` 下位のエラーを指定
     * @returns
     */
    function makeErrorInfo(resultCode, tag, message, cause) {
        var canceled = (cause && CANCELED_MESSAGE === cause.message) ? true : false;
        var msg = canceled ? CANCELED_MESSAGE : message;
        var code = canceled ? RESULT_CODE.CANCELED : resultCode;
        var errorInfo = new Error(msg || messageFromResultCode(code));
        errorInfo.name = buildErrorName(code, tag);
        errorInfo.code = code;
        errorInfo.cause = cause;
        return errorInfo;
    }
    CDP.makeErrorInfo = makeErrorInfo;
    /**
     * @en Generate canceled error information. <br>
     *     The [[ErrorInfo]] object generated by this function has [[RESULT_CODE.CANCELED]] code.
     * @ja キャンセルエラー情報生成 <br>
     *     この関数で生成された [[ErrorInfo]] は [[RESULT_CODE.CANCELED]] を格納する
     *
     * @param tag
     *  - `en` Log tag information
     *  - `ja` 識別情報
     * @param cause
     *  - `en` low-level Error object
     *  - `ja` 下位のエラーを指定
     * @returns
     */
    function makeCanceledErrorInfo(tag, cause) {
        return makeErrorInfo(RESULT_CODE.CANCELED, tag, CANCELED_MESSAGE, cause);
    }
    CDP.makeCanceledErrorInfo = makeCanceledErrorInfo;
    /**
     * @es Judge the error is canceled.
     * @ja エラー情報がキャンセルされたものか判定
     *
     * @example <br>
     *
     * ```ts
     *  :
     *  .catch((reason: ErrorInfo) => {
     *      if (!isCanceledError(reason)) {
     *          handleErrorInfo(reason);
     *      }
     *   });
     *  :
     * ```
     *
     * @param error
     * @returns
     *  - `en` true: canceled error / false: others
     *  - `ja` true: キャンセル / false: その他エラー
     */
    function isCanceledError(error) {
        if ("string" === typeof error) {
            return CANCELED_MESSAGE === error;
        }
        else {
            var errorInfo = error;
            if (errorInfo) {
                if (RESULT_CODE.CANCELED === errorInfo.code || CANCELED_MESSAGE === errorInfo.message) {
                    return true;
                }
            }
        }
        return false;
    }
    CDP.isCanceledError = isCanceledError;
    /**
     * @es Convert from any type error information to [[ErrorInfo]] object.
     * @jp あらゆるエラー入力を [[ErrorInfo]] に変換
     */
    function ensureErrorInfo(cause) {
        var unknown = {
            name: UNKNOWN_ERROR_NAME + ERROR_NAME_SEPARATOR,
            code: RESULT_CODE.FAILED,
            message: "unknown error occured.",
        };
        var valid = function (error) {
            if (!error) {
                return false;
            }
            return ("number" === typeof error.code &&
                "string" === typeof error.name &&
                "string" === typeof error.message);
        };
        if (valid(cause)) {
            return cause;
        }
        else if (cause instanceof Error) {
            cause.code = RESULT_CODE.FAILED;
            return cause;
        }
        else if ("string" === typeof cause) {
            if (isCanceledError(cause)) {
                return makeCanceledErrorInfo();
            }
            else {
                return __assign({}, unknown, { message: cause });
            }
        }
        else if ("number" === typeof cause) {
            return __assign({}, unknown, {
                cause: {
                    name: UNKNOWN_ERROR_NAME + ERROR_NAME_SEPARATOR,
                    message: "Please check the error code.",
                    code: cause
                }
            });
        }
        else if ("object" === typeof cause) {
            return __assign({}, unknown, cause);
        }
        return unknown;
    }
    CDP.ensureErrorInfo = ensureErrorInfo;
    /**
     * @internal for CDP modules assignable range.
     */
    CDP._MODULE_RESULT_CODE_RANGE_CDP = 100;
    /**
     * @en Offset value enumeration for [[RESULT_CODE]]. <br>
     *     The client can expand a definition in other module.
     * @ja [[RESULT_CODE]] のオフセット値 <br>
     *     エラーコード対応するモジュール内で 定義を拡張する.
     *
     * @example <br>
     *
     * ```ts
     *  export enum RESULT_CODE {
     *      ERROR_SOMEMODULE_UNEXPECTED  = DECLARE_ERROR_CODE(RESULT_CODE_BASE, LOCAL_CODE_BASE.COMMON + 1, "error unexpected."),
     *      ERROR_SOMEMODULE_INVALID_ARG = DECLARE_ERROR_CODE(RESULT_CODE_BASE, LOCAL_CODE_BASE.COMMON + 2, "invalid arguments."),
     *  }
     *  ASSIGN_RESULT_CODE(RESULT_CODE);
     * ```
     */
    var RESULT_CODE_BASE;
    (function (RESULT_CODE_BASE) {
        RESULT_CODE_BASE[RESULT_CODE_BASE["CDP_DECLARERATION"] = 0] = "CDP_DECLARERATION";
        //      MODULE_A = 1 * MODULE_RESULT_CODE_RANGE,    // ex) moduleA: abs(1001 ～ 1999)
        //      MODULE_B = 2 * MODULE_RESULT_CODE_RANGE,    // ex) moduleB: abs(2001 ～ 2999)
        //      MODULE_C = 3 * MODULE_RESULT_CODE_RANGE,    // ex) moduleC: abs(3001 ～ 3999)
        RESULT_CODE_BASE[RESULT_CODE_BASE["CDP"] = 1 * CDP._MODULE_RESULT_CODE_RANGE_CDP] = "CDP";
    })(RESULT_CODE_BASE = CDP.RESULT_CODE_BASE || (CDP.RESULT_CODE_BASE = {}));
    // "CDP" 以外の namespace で定義した場合は、ASSIGN ユーティリティをコールする.
    //  ASSIGN_RESULT_CODE_BASE(RESULT_CODE_BASE);
    /**
     * @en Generate success code.
     * @ja 成功コードを生成
     *
     * @param base
     * @param localCode
     * @param message
     */
    function DECLARE_SUCCESS_CODE(base, localCode, message) {
        if ("string" === typeof base) {
            base = CDP.RESULT_CODE_BASE[base];
        }
        return declareResultCode(base, localCode, message, true);
    }
    CDP.DECLARE_SUCCESS_CODE = DECLARE_SUCCESS_CODE;
    /**
     * @en Generate error code.
     * @ja エラーコード生成
     *
     * @param base
     * @param localCode
     * @param message
     */
    function DECLARE_ERROR_CODE(base, localCode, message) {
        if ("string" === typeof base) {
            base = CDP.RESULT_CODE_BASE[base];
        }
        return declareResultCode(base, localCode, message, false);
    }
    CDP.DECLARE_ERROR_CODE = DECLARE_ERROR_CODE;
    /**
     * @en Judge success or not.
     * @ja 成功判定
     *
     * @param code
     */
    function SUCCEEDED(code) {
        return 0 <= code;
    }
    CDP.SUCCEEDED = SUCCEEDED;
    /**
     * @en Judge error or not.
     * @ja 失敗判定
     *
     * @param code
     */
    function FAILED(code) {
        return code < 0;
    }
    CDP.FAILED = FAILED;
    /**
     * @en Assign declared [[RESULT_CODE_BASE]] to root enumeration.<br>
     *     (It's necessary also to merge enum in the module system environment.)
     * @ja 拡張した [[RESULT_CODE_BASE]] を ルート enum にアサイン<br>
     *     モジュールシステム環境においても、enum をマージするために必要
     */
    function ASSIGN_RESULT_CODE_BASE(resultCodeBase) {
        CDP.RESULT_CODE_BASE = __assign({}, CDP.RESULT_CODE_BASE, resultCodeBase);
    }
    CDP.ASSIGN_RESULT_CODE_BASE = ASSIGN_RESULT_CODE_BASE;
    /**
     * @en Assign declared [[ASSIGN_RESULT_CODE]] to root enumeration.
     *     (It's necessary also to merge enum in the module system environment.)
     * @ja 拡張した [[ASSIGN_RESULT_CODE]] を ルート enum にアサイン
     *     モジュールシステム環境においても、enum をマージするために必要
     */
    function ASSIGN_RESULT_CODE(resultCode) {
        CDP.RESULT_CODE = __assign({}, CDP.RESULT_CODE, resultCode);
    }
    CDP.ASSIGN_RESULT_CODE = ASSIGN_RESULT_CODE;
    ///////////////////////////////////////////////////////////////////////
    // module error declaration:
    var FUNCTION_CODE_RANGE = 10;
    // cdp.core 内のローカルコードオフセット値
    var LOCAL_CODE_BASE;
    (function (LOCAL_CODE_BASE) {
        LOCAL_CODE_BASE[LOCAL_CODE_BASE["CORE"] = 0] = "CORE";
        LOCAL_CODE_BASE[LOCAL_CODE_BASE["PATCH"] = 1 * FUNCTION_CODE_RANGE] = "PATCH";
    })(LOCAL_CODE_BASE || (LOCAL_CODE_BASE = {}));
    // @internal Error code definition of `cdp-core`.
    (function (RESULT_CODE) {
        RESULT_CODE[RESULT_CODE["ERROR_CDP_DECLARATION_CDP"] = 0] = "ERROR_CDP_DECLARATION_CDP";
        /** `en` [[CDP.initialize]]() failer code. <br> `ja` [[CDP.initialize]]() のエラーコード */
        RESULT_CODE[RESULT_CODE["ERROR_CDP_INITIALIZE_FAILED"] = DECLARE_ERROR_CODE(RESULT_CODE_BASE.CDP, LOCAL_CODE_BASE.CORE + 1, "initialized failed.")] = "ERROR_CDP_INITIALIZE_FAILED";
    })(RESULT_CODE = CDP.RESULT_CODE || (CDP.RESULT_CODE = {}));
    // "CDP" 以外の namespace で定義した場合は、ASSIGN ユーティリティをコールする.
    //  ASSIGN_RESULT_CODE_BASE(RESULT_CODE);
    ///////////////////////////////////////////////////////////////////////
    // private static methods:
    // RESULT_CODE の登録
    function declareResultCode(base, moduleCode, message, succeeded) {
        if (succeeded === void 0) { succeeded = false; }
        if (moduleCode <= 0 || CDP.MODULE_RESULT_CODE_RANGE <= moduleCode) {
            console.error("declareResultCode(), invalid localCode range. [localCode: " + moduleCode + "]");
            return;
        }
        var signed = succeeded ? 1 : -1;
        var resultCode = signed * (base + moduleCode);
        s_code2message[resultCode] = message ? message : ("[RESULT_CODE: " + resultCode + "]");
        return resultCode;
    }
    // RESULT_CODE から登録されているメッセージを取得
    function messageFromResultCode(resultCode) {
        if (s_code2message[resultCode]) {
            return s_code2message[resultCode];
        }
        else {
            return "unregistered result code. [RESULT_CODE: " + resultCode + "]";
        }
    }
    // RESULT_CODE から登録されている RESULT_CODE 文字列を取得
    function buildErrorName(resultCode, tag) {
        var prefix = tag || "";
        if (CDP.RESULT_CODE[resultCode]) {
            return prefix + CDP.RESULT_CODE[resultCode] + ERROR_NAME_SEPARATOR;
        }
        else {
            return prefix + UNKNOWN_ERROR_NAME + ERROR_NAME_SEPARATOR;
        }
    }
})(CDP || (CDP = {}));

return CDP; }));
/*!
 * cdp.promise.js 2.1.0
 *
 * Date: 2017-11-06T05:33:59.451Z
 */
(function (root, factory) { if (typeof define === "function" && define.amd) { define("cdp.promise",["jquery"], function ($) { return factory(root.CDP || (root.CDP = {}), $, root); }); } else if (typeof exports === "object") { module.exports = factory(root.CDP || (root.CDP = {}), require("jquery"), root); } else { factory(root.CDP || (root.CDP = {}), root.jQuery || root.$, root); } }(((this || 0).self || global), function (CDP, $, root) {
var CDP;
(function (CDP) {
    var TAG = "[CDP.Promise] ";
    /**
     * Cancel 可能オブジェクトの作成
     *
     * @internal <br>
     *
     * @param df jQueryDeferred instance を指定
     * @param options jQueryPromise を拡張するオブジェクト or キャンセル時に呼び出される関数を指定
     * @returns Cancelable property
     */
    function makeCancelable(df, options) {
        var extendOptions;
        var cancel;
        if ("function" === typeof options) {
            cancel = options;
        }
        else {
            extendOptions = options;
            if (extendOptions && extendOptions.cancelCallback) {
                cancel = extendOptions.cancelCallback;
            }
            else {
                cancel = function () { };
            }
        }
        var _abort = function (info) {
            var originalMessage = (info && info.message) ? info.message : undefined;
            var detail = info ? $.extend({}, info, { message: "abort", originalMessage: originalMessage }) : { message: "abort" };
            cancel(detail);
            if (null != this.dependency) {
                if (this.dependency.abort) {
                    this.dependency.abort(detail);
                }
                else {
                    console.error(TAG + "[call] dependency object doesn't have 'abort()' method.");
                }
                if (this.callReject && "pending" === this.state()) {
                    df.reject(detail);
                }
            }
            else if ("pending" === this.state()) {
                df.reject(detail);
            }
        };
        var _dependOn = function (promise) {
            var _this = this;
            if (promise.abort) {
                this.dependency = promise;
                promise
                    .always(function () {
                    _this.dependency = null;
                });
            }
            else {
                console.error(TAG + "[set] dependency object doesn't have 'abort()' method.");
            }
            return promise;
        };
        var _target = $.extend({}, {
            dependency: null,
            callReject: false,
        }, extendOptions);
        return {
            df: df,
            target: _target,
            abort: _abort,
            dependOn: _dependOn,
        };
    }
    /**
     * @en make [[IPromise]] object.
     * @ja [[IPromise]] オブジェクトの作成
     *
     * @example <br>
     *
     * ```ts
     *  // pipe line operation
     *  function procPipeline(): IPromise<SomeData> {
     *      const df = $.Deferred();            // create jQueryDeferred instance.
     *      const promise = makePromise(df);    // create IPromise instance.
     *
     *      // async1(), async2(), async3() are async function and returned IPromise instance.
     *      promsie.dependOn(async1())
     *          .then(() => {
     *              return promsie.dependOn(async2());
     *          })
     *          .then(() => {
     *              return promsie.dependOn(async3());
     *          })
     *          .done(() => {
     *              df.resolve({ somedata: "hoge" });
     *          })
     *          .fail((error) => {
     *              df.reject(error);
     *          });
     *
     *      return promise;
     *  }
     *
     *  // client of pipe line operation
     *  function procCaller(): void {
     *      const promise = procPipeline();
     *      setTimeout(() => {
     *          promise.abort(); // The whole cancellation is possible by optional timing.
     *          // In whichever processing of async1(), async2() or async3(),
     *          // it can be canceled appropriately.
     *      });
     *  }
     *
     * ```
     *
     * @param df
     *  - `en` set the jQueryDeferred instance.
     *  - `ja` jQueryDeferred instance を指定
     * @param options
     *  - `en` set the extend object or cancel callback function.
     *  - `ja` jQueryPromise を拡張するオブジェクト or キャンセル時に呼び出される関数を指定
     * @returns
     */
    function makePromise(df, options) {
        var cancelable = makeCancelable(df, options);
        var promise = df.promise(cancelable.target);
        if (null == promise.abort) {
            promise.abort = cancelable.abort.bind(promise);
        }
        if (null == promise.dependOn) {
            promise.dependOn = cancelable.dependOn.bind(promise);
        }
        return promise;
    }
    CDP.makePromise = makePromise;
    function wait() {
        var deferreds = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            deferreds[_i] = arguments[_i];
        }
        // 1次元配列に保証
        var _deferreds = [].concat.apply([], deferreds);
        // 実際の作業
        var df = $.Deferred();
        var results = [];
        var isFinished = function () {
            return !results.some(function (element) {
                return "pending" === element.status;
            });
        };
        _deferreds.forEach(function (deferred, index) {
            results.push({
                status: "pending",
                args: null,
            });
            deferred
                .then(function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                results[index].status = "resolved";
                results[index].args = args;
            }, function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                results[index].status = "rejected";
                results[index].args = args;
            })
                .always(function () {
                if (isFinished()) {
                    df.resolve(results);
                }
            });
        });
        return df.promise();
    }
    CDP.wait = wait;
    function race() {
        var deferreds = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            deferreds[_i] = arguments[_i];
        }
        var df = $.Deferred();
        var _deferreds = [].concat.apply([], deferreds);
        _deferreds.forEach(function (deferred, index) {
            deferred
                .then(function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                if ("pending" === df.state()) {
                    df.resolve(args);
                }
            }, function () {
                var args = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    args[_i] = arguments[_i];
                }
                if ("pending" === df.state()) {
                    df.reject(args);
                }
            });
        });
        return df.promise();
    }
    CDP.race = race;
    //___________________________________________________________________________________________________________________//
    /**
     * @en The class provides the operation for multiple [[IPromise]] object.
     * @ja 複数の [[IPromise]] を一括管理するクラス
     *
     * @example <br>
     *
     * ```ts
     *  let _prmsManager = new PromiseManager();
     *
     *  function procCaller(): void {
     *      // add parallel operations under the management.
     *      _prmsManager.add(async1);
     *      _prmsManager.add(async2);
     *      _prmsManager.add(async3);
     *  }
     *
     *  function allCancel(): void {
     *      // just one call. all parallel ops are canceled.
     *      _prmsManager.cancel();
     *  }
     * ```
     */
    var PromiseManager = /** @class */ (function () {
        function PromiseManager() {
            this._pool = [];
            this._id = 0;
        }
        ///////////////////////////////////////////////////////////////////////
        // public method
        /**
         * @en add Promise object that has abort() method.
         * @ja abort() を持つ Promise オブジェクトを管理下に追加
         */
        PromiseManager.prototype.add = function (promise) {
            var _this = this;
            if (promise == null) {
                return null;
            }
            // abort() を持っていない場合はエラー
            if (!promise.abort) {
                console.error(TAG + "[add] promise object doesn't have 'abort()' method.");
                return promise;
            }
            var cookie = {
                promise: promise,
                id: this._id++,
            };
            this._pool.push(cookie);
            promise
                .always(function () {
                _this._pool = _this._pool.filter(function (element) {
                    if (element.id !== cookie.id) {
                        return true;
                    }
                    else {
                        return false;
                    }
                });
            });
            return promise;
        };
        /**
         * @en call abort() to under the management Promises.
         * @ja 管理対象の Promise に対して abort を発行
         *
         * @param info
         *  - `en` abort() argument
         *  - `ja` abort() に渡される引数
         * @returns
         *  - `en` The cancellation to cancel processing is prohibited.
         *  - `ja` キャンセル処理に対するキャンセルは不可
         */
        PromiseManager.prototype.cancel = function (info) {
            var promises = this.promises();
            promises.forEach(function (element) {
                if (element.abort) {
                    element.abort(info);
                }
            });
            return wait.apply(null, promises);
        };
        /**
         * @en get Promise objects as array. <br>
         *     only pending state object are returned.
         * @ja 管理対象の Promise を配列で取得 <br>
         *     pending 状態のオブジェクトのみが返る.
         */
        PromiseManager.prototype.promises = function () {
            return this._pool.map(function (element) {
                return element.promise;
            });
        };
        return PromiseManager;
    }());
    CDP.PromiseManager = PromiseManager;
    //___________________________________________________________________________________________________________________//
    /**
     * @en Cancelable Promise class for ES2015 Promiise compatible.
     * @ja ES2015 Promise 互換のキャンセル可能な Promise オブジェクト
     */
    var PromiseConstructor = /** @class */ (function () {
        /**
         * @example <br>
         *
         * ```ts
         *  // override global "Promise" for using Cancelable Promise in this module scope.
         *  import { Promise } from "cdp";
         *
         *  function (): IPromise<SomeData> => {
         *      return new Promise((resolve, reject, dependOn) => {
         *          // async1(), async2() are async function and returned IPromise instance.
         *          dependOn(async1())
         *              .then(() => {
         *                  return dependOn(async2());
         *              })
         *              .then(() => {
         *                  resolve({ somedata: "hoge" });
         *              })
         *              .catch((error) => {
         *                  reject(error);
         *              });
         *          });
         *      };
         *  }
         * ```
         *
         * @param executor
         *  - `en` ES2015 Promise executer compatible with `dependOn` 3rd arg.
         *  - `ja` ES6 Promise 互換引数. (dependOn を第3引数に渡す)
         * @param options
         *  - `en` set the extend object or cancel callback function.
         *  - `ja` jQueryPromise を拡張するオブジェクト or キャンセル時に呼び出される関数を指定
         */
        function PromiseConstructor(executor, options) {
            // apply mixin
            var cancelable = makeCancelable($.Deferred(), options);
            $.extend(true, this, cancelable.df, cancelable.target);
            this.abort = cancelable.abort.bind(this);
            this.dependOn = cancelable.dependOn.bind(this);
            executor(this.resolve, this.reject, this.dependOn);
        }
        ///////////////////////////////////////////////////////////////////////
        // static methods:
        PromiseConstructor.resolve = function (value) {
            return $.Deferred().resolve(value);
        };
        PromiseConstructor.reject = function (reason) {
            return $.Deferred().reject(reason);
        };
        PromiseConstructor.all = function () {
            var deferreds = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                deferreds[_i] = arguments[_i];
            }
            return $.when.apply(this, [].concat.apply([], deferreds));
        };
        PromiseConstructor.wait = function () {
            var deferreds = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                deferreds[_i] = arguments[_i];
            }
            return wait([].concat.apply([], deferreds));
        };
        PromiseConstructor.race = function () {
            var deferreds = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                deferreds[_i] = arguments[_i];
            }
            return race([].concat.apply([], deferreds));
        };
        return PromiseConstructor;
    }());
    CDP.PromiseConstructor = PromiseConstructor;
    CDP.Promise = PromiseConstructor;
})(CDP || (CDP = {}));

root.Promise = root.Promise || CDP.Promise; return CDP; }));
/*!
 * cdp.i18n.js 2.1.0
 *
 * Date: 2017-11-06T05:35:00.319Z
 */

(function webpackUniversalModuleDefinition(root, factory) {
    if(typeof exports === 'object' && typeof module === 'object')
        module.exports = factory(require("jquery"), require("cdp.core"), require("cdp.promise"));
    else if(typeof define === 'function' && define.amd)
        define("cdp.i18n", ["jquery", "cdp.core", "cdp.promise"], factory);
    else if(typeof exports === 'object')
        exports["CDP"] = factory(require("jquery"), require("cdp.core"), require("cdp.promise"));
    else
        root["CDP"] = factory(root["jQuery"], root["CDP"], root["CDP"]);
})(this, function(__WEBPACK_EXTERNAL_MODULE_1__, __WEBPACK_EXTERNAL_MODULE_2__, __WEBPACK_EXTERNAL_MODULE_3__) {
return /******/ (function(modules) { // webpackBootstrap
/******/     // The module cache
/******/     var installedModules = {};
/******/
/******/     // The require function
/******/     function __webpack_require__(moduleId) {
/******/
/******/         // Check if module is in cache
/******/         if(installedModules[moduleId]) {
/******/             return installedModules[moduleId].exports;
/******/         }
/******/         // Create a new module (and put it into the cache)
/******/         var module = installedModules[moduleId] = {
/******/             i: moduleId,
/******/             l: false,
/******/             exports: {}
/******/         };
/******/
/******/         // Execute the module function
/******/         modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/         // Flag the module as loaded
/******/         module.l = true;
/******/
/******/         // Return the exports of the module
/******/         return module.exports;
/******/     }
/******/
/******/
/******/     // expose the modules object (__webpack_modules__)
/******/     __webpack_require__.m = modules;
/******/
/******/     // expose the module cache
/******/     __webpack_require__.c = installedModules;
/******/
/******/     // define getter function for harmony exports
/******/     __webpack_require__.d = function(exports, name, getter) {
/******/         if(!__webpack_require__.o(exports, name)) {
/******/             Object.defineProperty(exports, name, {
/******/                 configurable: false,
/******/                 enumerable: true,
/******/                 get: getter
/******/             });
/******/         }
/******/     };
/******/
/******/     // getDefaultExport function for compatibility with non-harmony modules
/******/     __webpack_require__.n = function(module) {
/******/         var getter = module && module.__esModule ?
/******/             function getDefault() { return module['default']; } :
/******/             function getModuleExports() { return module; };
/******/         __webpack_require__.d(getter, 'a', getter);
/******/         return getter;
/******/     };
/******/
/******/     // Object.prototype.hasOwnProperty.call
/******/     __webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/     // __webpack_public_path__
/******/     __webpack_require__.p = "";
/******/
/******/     // Load entry module and return exports
/******/     return __webpack_require__(__webpack_require__.s = 0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;(function (root, factory) { if (true) { !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(1), __webpack_require__(2), __webpack_require__(3)], __WEBPACK_AMD_DEFINE_RESULT__ = function ($, CDP) { return factory($, CDP); }.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
                __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)); } else { factory(root.jQuery || root.$, root.CDP || (root.CDP = {})); } }(this, function ($, CDP) {
var CDP;
(function (CDP) {
    // @internal Error code offset definition of `cdp-i18n`.
    var RESULT_CODE_BASE;
    (function (RESULT_CODE_BASE) {
        RESULT_CODE_BASE[RESULT_CODE_BASE["CDP_I18N_DECLARERATION"] = 0] = "CDP_I18N_DECLARERATION";
        RESULT_CODE_BASE[RESULT_CODE_BASE["CDP_I18N"] = 3 * CDP._MODULE_RESULT_CODE_RANGE_CDP] = "CDP_I18N";
    })(RESULT_CODE_BASE = CDP.RESULT_CODE_BASE || (CDP.RESULT_CODE_BASE = {}));
    ///////////////////////////////////////////////////////////////////////
    // module error declaration:
    // @internal cdp.i18n 内のローカルコードオフセット値
    var LOCAL_CODE_BASE;
    (function (LOCAL_CODE_BASE) {
        LOCAL_CODE_BASE[LOCAL_CODE_BASE["I18N"] = 0] = "I18N";
    })(LOCAL_CODE_BASE || (LOCAL_CODE_BASE = {}));
    /* tslint:disable:max-line-length */
    // Error code definition of `cdp-i18n`.
    var RESULT_CODE;
    (function (RESULT_CODE) {
        RESULT_CODE[RESULT_CODE["ERROR_CDP_I18N_DECLARATION"] = 0] = "ERROR_CDP_I18N_DECLARATION";
        /** `en` [[CDP.initializeI18N]]() failer code. <br> `ja` [[CDP.initializeI18N]]() のエラーコード */
        RESULT_CODE[RESULT_CODE["ERROR_CDP_I18N_INITIALIZE_FAILED"] = CDP.DECLARE_ERROR_CODE(RESULT_CODE_BASE.CDP_I18N, LOCAL_CODE_BASE.I18N + 1, "i18n initialize failed.")] = "ERROR_CDP_I18N_INITIALIZE_FAILED";
    })(RESULT_CODE = CDP.RESULT_CODE || (CDP.RESULT_CODE = {}));
    /* tslint:enable:max-line-length */
})(CDP || (CDP = {}));

/* tslint:disable:max-line-length */
var CDP;
(function (CDP) {
    var Promise = CDP.Promise;
    var TAG = "[CDP.i18n] ";
    /**
     * @en initialize i18next. <br>
     *     It'll be usually called from framework.
     * @ja i18next の初期化 <br>
     *     通常は Framework が呼び出す。
     */
    function initializeI18N(settings) {
        return new Promise(function (resolve, reject) {
            var i18nSettings = settings || {};
            i18nSettings.options = i18nSettings.options || {};
            try {
                var i18nOptions_1 = (function (resources) {
                    if (resources) {
                        for (var lng in resources) {
                            if (resources.hasOwnProperty(lng)) {
                                for (var ns in resources[lng]) {
                                    if (resources[lng].hasOwnProperty(ns)) {
                                        resources[lng][ns] = getLocaleFallbackResource(resources[lng][ns]);
                                    }
                                }
                            }
                        }
                        i18nSettings.options.resources = resources;
                        return i18nSettings.options;
                    }
                    else {
                        return i18nSettings.options;
                    }
                })(i18nSettings.fallbackResources);
                new Promise(function(resolve) { resolve(); }).then(function() { var __WEBPACK_AMD_REQUIRE_ARRAY__ = [__webpack_require__(4)]; (function ($18Next) {
                    new Promise(function(resolve) { resolve(); }).then(function() { var __WEBPACK_AMD_REQUIRE_ARRAY__ = [
                        __webpack_require__(5),
                        __webpack_require__(6),
                        __webpack_require__(7),
                        __webpack_require__(8),
                        __webpack_require__(9),
                    ]; (function (i18next, Backend, Cache, PostProcessor, LanguageDetector) {
                        i18next
                            .use(Backend)
                            .use(Cache)
                            .use(PostProcessor)
                            .use(LanguageDetector)
                            .init(i18nOptions_1, function (error, t) {
                            $18Next.init(i18next, $, {
                                tName: "t",
                                i18nName: "i18n",
                                handleName: "localize",
                                selectorAttr: "data-i18n",
                                targetAttr: "i18n-target",
                                optionsAttr: "i18n-options",
                                useOptionsAttr: false,
                                parseDefaultValueFromContent: true // parses default values from content ele.val or ele.text
                            });
                            // i18next 3.4.1: resources が指定されると preload が読み込まれないため、再読み込み処理を行う.
                            if (i18next.options.resources && i18next.options.preload) {
                                // options からプロパティを一旦削除.
                                var _preload_1 = i18next.options.preload;
                                var _resources_1 = i18next.options.resources;
                                delete i18next.options.resources;
                                delete i18next.options.preload;
                                i18next.loadLanguages(_preload_1, function () {
                                    // options を元に戻す
                                    i18next.options.resources = _resources_1;
                                    i18next.options.preload = _preload_1;
                                    CDP.i18n = i18next;
                                    resolve();
                                });
                            }
                            else {
                                CDP.i18n = i18next;
                                resolve();
                            }
                        });
                    }.apply(null, __WEBPACK_AMD_REQUIRE_ARRAY__));}).catch(__webpack_require__.oe);
                }.apply(null, __WEBPACK_AMD_REQUIRE_ARRAY__));}).catch(__webpack_require__.oe);
            }
            catch (e) {
                return reject(e);
            }
        });
    }
    CDP.initializeI18N = initializeI18N;
    /**
     * @es get string resource for fallback.
     * @js Fallback 用ローカライズリソースの取得
     *
     * @internal
     * @returns
     *   - `en` fallback resource object
     *   - `ja` fallback リソースオブジェクト
     */
    function getLocaleFallbackResource(path) {
        var json;
        var error;
        $.ajax({
            url: CDP.toUrl(path),
            method: "GET",
            async: false,
            dataType: "json",
            success: function (data) {
                json = data;
            },
            error: function (xhr, status) {
                error = CDP.makeErrorInfo(CDP.RESULT_CODE.ERROR_CDP_I18N_INITIALIZE_FAILED, TAG, "ajax request failed. status: " + status);
            }
        });
        if (null != error) {
            throw error;
        }
        return json;
    }
})(CDP || (CDP = {}));

return CDP; }));


/***/ }),
/* 1 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_1__;

/***/ }),
/* 2 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_2__;

/***/ }),
/* 3 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_3__;

/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

(function (global, factory) {
   true ? module.exports = factory() :
  typeof define === 'function' && define.amd ? define(factory) :
  (global.jqueryI18next = factory());
}(this, (function () { 'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var defaults = {
  tName: 't',
  i18nName: 'i18n',
  handleName: 'localize',
  selectorAttr: 'data-i18n',
  targetAttr: 'i18n-target',
  optionsAttr: 'i18n-options',
  useOptionsAttr: false,
  parseDefaultValueFromContent: true
};

function init(i18next, $) {
  var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};


  options = _extends({}, defaults, options);

  function parse(ele, key, opts) {
    if (key.length === 0) return;

    var attr = 'text';

    if (key.indexOf('[') === 0) {
      var parts = key.split(']');
      key = parts[1];
      attr = parts[0].substr(1, parts[0].length - 1);
    }

    if (key.indexOf(';') === key.length - 1) {
      key = key.substr(0, key.length - 2);
    }

    function extendDefault(o, val) {
      if (!options.parseDefaultValueFromContent) return o;
      return _extends({}, o, { defaultValue: val });
    }

    if (attr === 'html') {
      ele.html(i18next.t(key, extendDefault(opts, ele.html())));
    } else if (attr === 'text') {
      ele.text(i18next.t(key, extendDefault(opts, ele.text())));
    } else if (attr === 'prepend') {
      ele.prepend(i18next.t(key, extendDefault(opts, ele.html())));
    } else if (attr === 'append') {
      ele.append(i18next.t(key, extendDefault(opts, ele.html())));
    } else if (attr.indexOf('data-') === 0) {
      var dataAttr = attr.substr('data-'.length);
      var translated = i18next.t(key, extendDefault(opts, ele.data(dataAttr)));

      // we change into the data cache
      ele.data(dataAttr, translated);
      // we change into the dom
      ele.attr(attr, translated);
    } else {
      ele.attr(attr, i18next.t(key, extendDefault(opts, ele.attr(attr))));
    }
  }

  function localize(ele, opts) {
    var key = ele.attr(options.selectorAttr);
    if (!key && typeof key !== 'undefined' && key !== false) key = ele.text() || ele.val();
    if (!key) return;

    var target = ele,
        targetSelector = ele.data(options.targetAttr);

    if (targetSelector) target = ele.find(targetSelector) || ele;

    if (!opts && options.useOptionsAttr === true) opts = ele.data(options.optionsAttr);

    opts = opts || {};

    if (key.indexOf(';') >= 0) {
      var keys = key.split(';');

      $.each(keys, function (m, k) {
        // .trim(): Trim the comma-separated parameters on the data-i18n attribute.
        if (k !== '') parse(target, k.trim(), opts);
      });
    } else {
      parse(target, key, opts);
    }

    if (options.useOptionsAttr === true) {
      var clone = {};
      clone = _extends({ clone: clone }, opts);

      delete clone.lng;
      ele.data(options.optionsAttr, clone);
    }
  }

  function handle(opts) {
    return this.each(function () {
      // localize element itself
      localize($(this), opts);

      // localize children
      var elements = $(this).find('[' + options.selectorAttr + ']');
      elements.each(function () {
        localize($(this), opts);
      });
    });
  };

  // $.t $.i18n shortcut
  $[options.tName] = i18next.t.bind(i18next);
  $[options.i18nName] = i18next;

  // selector function $(mySelector).localize(opts);
  $.fn[options.handleName] = handle;
}

var index = {
  init: init
};

return index;

})));

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

(function (global, factory) {
     true ? module.exports = factory() :
    typeof define === 'function' && define.amd ? define(factory) :
    (global.i18next = factory());
}(this, (function () { 'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
  return typeof obj;
} : function (obj) {
  return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
};











var classCallCheck = function (instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
};









var _extends = Object.assign || function (target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i];

    for (var key in source) {
      if (Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key];
      }
    }
  }

  return target;
};



var inherits = function (subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
  }

  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });
  if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
};











var possibleConstructorReturn = function (self, call) {
  if (!self) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return call && (typeof call === "object" || typeof call === "function") ? call : self;
};





var slicedToArray = function () {
  function sliceIterator(arr, i) {
    var _arr = [];
    var _n = true;
    var _d = false;
    var _e = undefined;

    try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);

        if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;
      _e = err;
    } finally {
      try {
        if (!_n && _i["return"]) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }

    return _arr;
  }

  return function (arr, i) {
    if (Array.isArray(arr)) {
      return arr;
    } else if (Symbol.iterator in Object(arr)) {
      return sliceIterator(arr, i);
    } else {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }
  };
}();













var toConsumableArray = function (arr) {
  if (Array.isArray(arr)) {
    for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];

    return arr2;
  } else {
    return Array.from(arr);
  }
};

var consoleLogger = {
  type: 'logger',

  log: function log(args) {
    this.output('log', args);
  },
  warn: function warn(args) {
    this.output('warn', args);
  },
  error: function error(args) {
    this.output('error', args);
  },
  output: function output(type, args) {
    var _console;

    /* eslint no-console: 0 */
    if (console && console[type]) (_console = console)[type].apply(_console, toConsumableArray(args));
  }
};

var Logger = function () {
  function Logger(concreteLogger) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    classCallCheck(this, Logger);

    this.init(concreteLogger, options);
  }

  Logger.prototype.init = function init(concreteLogger) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    this.prefix = options.prefix || 'i18next:';
    this.logger = concreteLogger || consoleLogger;
    this.options = options;
    this.debug = options.debug;
  };

  Logger.prototype.setDebug = function setDebug(bool) {
    this.debug = bool;
  };

  Logger.prototype.log = function log() {
    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return this.forward(args, 'log', '', true);
  };

  Logger.prototype.warn = function warn() {
    for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      args[_key2] = arguments[_key2];
    }

    return this.forward(args, 'warn', '', true);
  };

  Logger.prototype.error = function error() {
    for (var _len3 = arguments.length, args = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
      args[_key3] = arguments[_key3];
    }

    return this.forward(args, 'error', '');
  };

  Logger.prototype.deprecate = function deprecate() {
    for (var _len4 = arguments.length, args = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
      args[_key4] = arguments[_key4];
    }

    return this.forward(args, 'warn', 'WARNING DEPRECATED: ', true);
  };

  Logger.prototype.forward = function forward(args, lvl, prefix, debugOnly) {
    if (debugOnly && !this.debug) return null;
    if (typeof args[0] === 'string') args[0] = '' + prefix + this.prefix + ' ' + args[0];
    return this.logger[lvl](args);
  };

  Logger.prototype.create = function create(moduleName) {
    return new Logger(this.logger, _extends({ prefix: this.prefix + ':' + moduleName + ':' }, this.options));
  };

  return Logger;
}();

var baseLogger = new Logger();

var EventEmitter = function () {
  function EventEmitter() {
    classCallCheck(this, EventEmitter);

    this.observers = {};
  }

  EventEmitter.prototype.on = function on(events, listener) {
    var _this = this;

    events.split(' ').forEach(function (event) {
      _this.observers[event] = _this.observers[event] || [];
      _this.observers[event].push(listener);
    });
  };

  EventEmitter.prototype.off = function off(event, listener) {
    var _this2 = this;

    if (!this.observers[event]) {
      return;
    }

    this.observers[event].forEach(function () {
      if (!listener) {
        delete _this2.observers[event];
      } else {
        var index = _this2.observers[event].indexOf(listener);
        if (index > -1) {
          _this2.observers[event].splice(index, 1);
        }
      }
    });
  };

  EventEmitter.prototype.emit = function emit(event) {
    for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    if (this.observers[event]) {
      var cloned = [].concat(this.observers[event]);
      cloned.forEach(function (observer) {
        observer.apply(undefined, args);
      });
    }

    if (this.observers['*']) {
      var _cloned = [].concat(this.observers['*']);
      _cloned.forEach(function (observer) {
        var _ref;

        observer.apply(observer, (_ref = [event]).concat.apply(_ref, args));
      });
    }
  };

  return EventEmitter;
}();

function makeString(object) {
  if (object == null) return '';
  /* eslint prefer-template: 0 */
  return '' + object;
}

function copy(a, s, t) {
  a.forEach(function (m) {
    if (s[m]) t[m] = s[m];
  });
}

function getLastOfPath(object, path, Empty) {
  function cleanKey(key) {
    return key && key.indexOf('###') > -1 ? key.replace(/###/g, '.') : key;
  }

  function canNotTraverseDeeper() {
    return !object || typeof object === 'string';
  }

  var stack = typeof path !== 'string' ? [].concat(path) : path.split('.');
  while (stack.length > 1) {
    if (canNotTraverseDeeper()) return {};

    var key = cleanKey(stack.shift());
    if (!object[key] && Empty) object[key] = new Empty();
    object = object[key];
  }

  if (canNotTraverseDeeper()) return {};
  return {
    obj: object,
    k: cleanKey(stack.shift())
  };
}

function setPath(object, path, newValue) {
  var _getLastOfPath = getLastOfPath(object, path, Object),
      obj = _getLastOfPath.obj,
      k = _getLastOfPath.k;

  obj[k] = newValue;
}

function pushPath(object, path, newValue, concat) {
  var _getLastOfPath2 = getLastOfPath(object, path, Object),
      obj = _getLastOfPath2.obj,
      k = _getLastOfPath2.k;

  obj[k] = obj[k] || [];
  if (concat) obj[k] = obj[k].concat(newValue);
  if (!concat) obj[k].push(newValue);
}

function getPath(object, path) {
  var _getLastOfPath3 = getLastOfPath(object, path),
      obj = _getLastOfPath3.obj,
      k = _getLastOfPath3.k;

  if (!obj) return undefined;
  return obj[k];
}

function deepExtend(target, source, overwrite) {
  /* eslint no-restricted-syntax: 0 */
  for (var prop in source) {
    if (prop in target) {
      // If we reached a leaf string in target or source then replace with source or skip depending on the 'overwrite' switch
      if (typeof target[prop] === 'string' || target[prop] instanceof String || typeof source[prop] === 'string' || source[prop] instanceof String) {
        if (overwrite) target[prop] = source[prop];
      } else {
        deepExtend(target[prop], source[prop], overwrite);
      }
    } else {
      target[prop] = source[prop];
    }
  }
  return target;
}

function regexEscape(str) {
  /* eslint no-useless-escape: 0 */
  return str.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, '\\$&');
}

/* eslint-disable */
var _entityMap = {
  "&": "&amp;",
  "<": "&lt;",
  ">": "&gt;",
  '"': '&quot;',
  "'": '&#39;',
  "/": '&#x2F;'
};
/* eslint-enable */

function escape(data) {
  if (typeof data === 'string') {
    return data.replace(/[&<>"'\/]/g, function (s) {
      return _entityMap[s];
    });
  }

  return data;
}

var ResourceStore = function (_EventEmitter) {
  inherits(ResourceStore, _EventEmitter);

  function ResourceStore(data) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : { ns: ['translation'], defaultNS: 'translation' };
    classCallCheck(this, ResourceStore);

    var _this = possibleConstructorReturn(this, _EventEmitter.call(this));

    _this.data = data || {};
    _this.options = options;
    return _this;
  }

  ResourceStore.prototype.addNamespaces = function addNamespaces(ns) {
    if (this.options.ns.indexOf(ns) < 0) {
      this.options.ns.push(ns);
    }
  };

  ResourceStore.prototype.removeNamespaces = function removeNamespaces(ns) {
    var index = this.options.ns.indexOf(ns);
    if (index > -1) {
      this.options.ns.splice(index, 1);
    }
  };

  ResourceStore.prototype.getResource = function getResource(lng, ns, key) {
    var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};

    var keySeparator = options.keySeparator || this.options.keySeparator;
    if (keySeparator === undefined) keySeparator = '.';

    var path = [lng, ns];
    if (key && typeof key !== 'string') path = path.concat(key);
    if (key && typeof key === 'string') path = path.concat(keySeparator ? key.split(keySeparator) : key);

    if (lng.indexOf('.') > -1) {
      path = lng.split('.');
    }

    return getPath(this.data, path);
  };

  ResourceStore.prototype.addResource = function addResource(lng, ns, key, value) {
    var options = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : { silent: false };

    var keySeparator = this.options.keySeparator;
    if (keySeparator === undefined) keySeparator = '.';

    var path = [lng, ns];
    if (key) path = path.concat(keySeparator ? key.split(keySeparator) : key);

    if (lng.indexOf('.') > -1) {
      path = lng.split('.');
      value = ns;
      ns = path[1];
    }

    this.addNamespaces(ns);

    setPath(this.data, path, value);

    if (!options.silent) this.emit('added', lng, ns, key, value);
  };

  ResourceStore.prototype.addResources = function addResources(lng, ns, resources) {
    /* eslint no-restricted-syntax: 0 */
    for (var m in resources) {
      if (typeof resources[m] === 'string') this.addResource(lng, ns, m, resources[m], { silent: true });
    }
    this.emit('added', lng, ns, resources);
  };

  ResourceStore.prototype.addResourceBundle = function addResourceBundle(lng, ns, resources, deep, overwrite) {
    var path = [lng, ns];
    if (lng.indexOf('.') > -1) {
      path = lng.split('.');
      deep = resources;
      resources = ns;
      ns = path[1];
    }

    this.addNamespaces(ns);

    var pack = getPath(this.data, path) || {};

    if (deep) {
      deepExtend(pack, resources, overwrite);
    } else {
      pack = _extends({}, pack, resources);
    }

    setPath(this.data, path, pack);

    this.emit('added', lng, ns, resources);
  };

  ResourceStore.prototype.removeResourceBundle = function removeResourceBundle(lng, ns) {
    if (this.hasResourceBundle(lng, ns)) {
      delete this.data[lng][ns];
    }
    this.removeNamespaces(ns);

    this.emit('removed', lng, ns);
  };

  ResourceStore.prototype.hasResourceBundle = function hasResourceBundle(lng, ns) {
    return this.getResource(lng, ns) !== undefined;
  };

  ResourceStore.prototype.getResourceBundle = function getResourceBundle(lng, ns) {
    if (!ns) ns = this.options.defaultNS;

    // COMPATIBILITY: remove extend in v2.1.0
    if (this.options.compatibilityAPI === 'v1') return _extends({}, this.getResource(lng, ns));

    return this.getResource(lng, ns);
  };

  ResourceStore.prototype.toJSON = function toJSON() {
    return this.data;
  };

  return ResourceStore;
}(EventEmitter);

var postProcessor = {

  processors: {},

  addPostProcessor: function addPostProcessor(module) {
    this.processors[module.name] = module;
  },
  handle: function handle(processors, value, key, options, translator) {
    var _this = this;

    processors.forEach(function (processor) {
      if (_this.processors[processor]) value = _this.processors[processor].process(value, key, options, translator);
    });

    return value;
  }
};

var Translator = function (_EventEmitter) {
  inherits(Translator, _EventEmitter);

  function Translator(services) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    classCallCheck(this, Translator);

    var _this = possibleConstructorReturn(this, _EventEmitter.call(this));

    copy(['resourceStore', 'languageUtils', 'pluralResolver', 'interpolator', 'backendConnector'], services, _this);

    _this.options = options;
    _this.logger = baseLogger.create('translator');
    return _this;
  }

  Translator.prototype.changeLanguage = function changeLanguage(lng) {
    if (lng) this.language = lng;
  };

  Translator.prototype.exists = function exists(key) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : { interpolation: {} };

    var resolved = this.resolve(key, options);
    return resolved && resolved.res !== undefined;
  };

  Translator.prototype.extractFromKey = function extractFromKey(key, options) {
    var nsSeparator = options.nsSeparator || this.options.nsSeparator;
    if (nsSeparator === undefined) nsSeparator = ':';
    var keySeparator = options.keySeparator || this.options.keySeparator || '.';

    var namespaces = options.ns || this.options.defaultNS;
    if (nsSeparator && key.indexOf(nsSeparator) > -1) {
      var parts = key.split(nsSeparator);
      if (nsSeparator !== keySeparator || nsSeparator === keySeparator && this.options.ns.indexOf(parts[0]) > -1) namespaces = parts.shift();
      key = parts.join(keySeparator);
    }
    if (typeof namespaces === 'string') namespaces = [namespaces];

    return {
      key: key,
      namespaces: namespaces
    };
  };

  Translator.prototype.translate = function translate(keys) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    if ((typeof options === 'undefined' ? 'undefined' : _typeof(options)) !== 'object') {
      /* eslint prefer-rest-params: 0 */
      options = this.options.overloadTranslationOptionHandler(arguments);
    }

    // non valid keys handling
    if (keys === undefined || keys === null || keys === '') return '';
    if (typeof keys === 'number') keys = String(keys);
    if (typeof keys === 'string') keys = [keys];

    // separators
    var keySeparator = options.keySeparator || this.options.keySeparator || '.';

    // get namespace(s)

    var _extractFromKey = this.extractFromKey(keys[keys.length - 1], options),
        key = _extractFromKey.key,
        namespaces = _extractFromKey.namespaces;

    var namespace = namespaces[namespaces.length - 1];

    // return key on CIMode
    var lng = options.lng || this.language;
    var appendNamespaceToCIMode = options.appendNamespaceToCIMode || this.options.appendNamespaceToCIMode;
    if (lng && lng.toLowerCase() === 'cimode') {
      if (appendNamespaceToCIMode) {
        var nsSeparator = options.nsSeparator || this.options.nsSeparator;
        return namespace + nsSeparator + key;
      }

      return key;
    }

    // resolve from store
    var resolved = this.resolve(keys, options);
    var res = resolved && resolved.res;
    var usedKey = resolved && resolved.usedKey || key;

    var resType = Object.prototype.toString.apply(res);
    var noObject = ['[object Number]', '[object Function]', '[object RegExp]'];
    var joinArrays = options.joinArrays !== undefined ? options.joinArrays : this.options.joinArrays;

    // object
    if (res && typeof res !== 'string' && noObject.indexOf(resType) < 0 && !(joinArrays && resType === '[object Array]')) {
      if (!options.returnObjects && !this.options.returnObjects) {
        this.logger.warn('accessing an object - but returnObjects options is not enabled!');
        return this.options.returnedObjectHandler ? this.options.returnedObjectHandler(usedKey, res, options) : 'key \'' + key + ' (' + this.language + ')\' returned an object instead of string.';
      }

      // if we got a separator we loop over children - else we just return object as is
      // as having it set to false means no hierarchy so no lookup for nested values
      if (options.keySeparator || this.options.keySeparator) {
        var copy$$1 = resType === '[object Array]' ? [] : {}; // apply child translation on a copy

        /* eslint no-restricted-syntax: 0 */
        for (var m in res) {
          if (Object.prototype.hasOwnProperty.call(res, m)) {
            copy$$1[m] = this.translate('' + usedKey + keySeparator + m, _extends({}, options, { joinArrays: false, ns: namespaces }));
          }
        }
        res = copy$$1;
      }
    } else if (joinArrays && resType === '[object Array]') {
      // array special treatment
      res = res.join(joinArrays);
      if (res) res = this.extendTranslation(res, keys, options);
    } else {
      // string, empty or null
      var usedDefault = false;
      var _usedKey = false;

      // fallback value
      if (!this.isValidLookup(res) && options.defaultValue !== undefined) {
        usedDefault = true;
        res = options.defaultValue;
      }
      if (!this.isValidLookup(res)) {
        _usedKey = true;
        res = key;
      }

      // save missing
      if (_usedKey || usedDefault) {
        this.logger.log('missingKey', lng, namespace, key, res);

        var lngs = [];
        var fallbackLngs = this.languageUtils.getFallbackCodes(this.options.fallbackLng, options.lng || this.language);
        if (this.options.saveMissingTo === 'fallback' && fallbackLngs && fallbackLngs[0]) {
          for (var i = 0; i < fallbackLngs.length; i++) {
            lngs.push(fallbackLngs[i]);
          }
        } else if (this.options.saveMissingTo === 'all') {
          lngs = this.languageUtils.toResolveHierarchy(options.lng || this.language);
        } else {
          lngs.push(options.lng || this.language);
        }

        if (this.options.saveMissing) {
          if (this.options.missingKeyHandler) {
            this.options.missingKeyHandler(lngs, namespace, key, res);
          } else if (this.backendConnector && this.backendConnector.saveMissing) {
            this.backendConnector.saveMissing(lngs, namespace, key, res);
          }
        }

        this.emit('missingKey', lngs, namespace, key, res);
      }

      // extend
      res = this.extendTranslation(res, keys, options);

      // append namespace if still key
      if (_usedKey && res === key && this.options.appendNamespaceToMissingKey) res = namespace + ':' + key;

      // parseMissingKeyHandler
      if (_usedKey && this.options.parseMissingKeyHandler) res = this.options.parseMissingKeyHandler(res);
    }

    // return
    return res;
  };

  Translator.prototype.extendTranslation = function extendTranslation(res, key, options) {
    var _this2 = this;

    if (options.interpolation) this.interpolator.init(_extends({}, options, { interpolation: _extends({}, this.options.interpolation, options.interpolation) }));

    // interpolate
    var data = options.replace && typeof options.replace !== 'string' ? options.replace : options;
    if (this.options.interpolation.defaultVariables) data = _extends({}, this.options.interpolation.defaultVariables, data);
    res = this.interpolator.interpolate(res, data, options.lng || this.language);

    // nesting
    if (options.nest !== false) res = this.interpolator.nest(res, function () {
      return _this2.translate.apply(_this2, arguments);
    }, options);

    if (options.interpolation) this.interpolator.reset();

    // post process
    var postProcess = options.postProcess || this.options.postProcess;
    var postProcessorNames = typeof postProcess === 'string' ? [postProcess] : postProcess;

    if (res !== undefined && postProcessorNames && postProcessorNames.length && options.applyPostProcessor !== false) {
      res = postProcessor.handle(postProcessorNames, res, key, options, this);
    }

    return res;
  };

  Translator.prototype.resolve = function resolve(keys) {
    var _this3 = this;

    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    var found = void 0;
    var usedKey = void 0;

    if (typeof keys === 'string') keys = [keys];

    // forEach possible key
    keys.forEach(function (k) {
      if (_this3.isValidLookup(found)) return;
      var extracted = _this3.extractFromKey(k, options);
      var key = extracted.key;
      usedKey = key;
      var namespaces = extracted.namespaces;
      if (_this3.options.fallbackNS) namespaces = namespaces.concat(_this3.options.fallbackNS);

      var needsPluralHandling = options.count !== undefined && typeof options.count !== 'string';
      var needsContextHandling = options.context !== undefined && typeof options.context === 'string' && options.context !== '';

      var codes = options.lngs ? options.lngs : _this3.languageUtils.toResolveHierarchy(options.lng || _this3.language);

      namespaces.forEach(function (ns) {
        if (_this3.isValidLookup(found)) return;

        codes.forEach(function (code) {
          if (_this3.isValidLookup(found)) return;

          var finalKey = key;
          var finalKeys = [finalKey];

          var pluralSuffix = void 0;
          if (needsPluralHandling) pluralSuffix = _this3.pluralResolver.getSuffix(code, options.count);

          // fallback for plural if context not found
          if (needsPluralHandling && needsContextHandling) finalKeys.push(finalKey + pluralSuffix);

          // get key for context if needed
          if (needsContextHandling) finalKeys.push(finalKey += '' + _this3.options.contextSeparator + options.context);

          // get key for plural if needed
          if (needsPluralHandling) finalKeys.push(finalKey += pluralSuffix);

          // iterate over finalKeys starting with most specific pluralkey (-> contextkey only) -> singularkey only
          var possibleKey = void 0;
          /* eslint no-cond-assign: 0 */
          while (possibleKey = finalKeys.pop()) {
            if (!_this3.isValidLookup(found)) {
              found = _this3.getResource(code, ns, possibleKey, options);
            }
          }
        });
      });
    });

    return { res: found, usedKey: usedKey };
  };

  Translator.prototype.isValidLookup = function isValidLookup(res) {
    return res !== undefined && !(!this.options.returnNull && res === null) && !(!this.options.returnEmptyString && res === '');
  };

  Translator.prototype.getResource = function getResource(code, ns, key) {
    var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};

    return this.resourceStore.getResource(code, ns, key, options);
  };

  return Translator;
}(EventEmitter);

function capitalize(string) {
  return string.charAt(0).toUpperCase() + string.slice(1);
}

var LanguageUtil = function () {
  function LanguageUtil(options) {
    classCallCheck(this, LanguageUtil);

    this.options = options;

    this.whitelist = this.options.whitelist || false;
    this.logger = baseLogger.create('languageUtils');
  }

  LanguageUtil.prototype.getScriptPartFromCode = function getScriptPartFromCode(code) {
    if (!code || code.indexOf('-') < 0) return null;

    var p = code.split('-');
    if (p.length === 2) return null;
    p.pop();
    return this.formatLanguageCode(p.join('-'));
  };

  LanguageUtil.prototype.getLanguagePartFromCode = function getLanguagePartFromCode(code) {
    if (!code || code.indexOf('-') < 0) return code;

    var p = code.split('-');
    return this.formatLanguageCode(p[0]);
  };

  LanguageUtil.prototype.formatLanguageCode = function formatLanguageCode(code) {
    // http://www.iana.org/assignments/language-tags/language-tags.xhtml
    if (typeof code === 'string' && code.indexOf('-') > -1) {
      var specialCases = ['hans', 'hant', 'latn', 'cyrl', 'cans', 'mong', 'arab'];
      var p = code.split('-');

      if (this.options.lowerCaseLng) {
        p = p.map(function (part) {
          return part.toLowerCase();
        });
      } else if (p.length === 2) {
        p[0] = p[0].toLowerCase();
        p[1] = p[1].toUpperCase();

        if (specialCases.indexOf(p[1].toLowerCase()) > -1) p[1] = capitalize(p[1].toLowerCase());
      } else if (p.length === 3) {
        p[0] = p[0].toLowerCase();

        // if lenght 2 guess it's a country
        if (p[1].length === 2) p[1] = p[1].toUpperCase();
        if (p[0] !== 'sgn' && p[2].length === 2) p[2] = p[2].toUpperCase();

        if (specialCases.indexOf(p[1].toLowerCase()) > -1) p[1] = capitalize(p[1].toLowerCase());
        if (specialCases.indexOf(p[2].toLowerCase()) > -1) p[2] = capitalize(p[2].toLowerCase());
      }

      return p.join('-');
    }

    return this.options.cleanCode || this.options.lowerCaseLng ? code.toLowerCase() : code;
  };

  LanguageUtil.prototype.isWhitelisted = function isWhitelisted(code) {
    if (this.options.load === 'languageOnly' || this.options.nonExplicitWhitelist) {
      code = this.getLanguagePartFromCode(code);
    }
    return !this.whitelist || !this.whitelist.length || this.whitelist.indexOf(code) > -1;
  };

  LanguageUtil.prototype.getFallbackCodes = function getFallbackCodes(fallbacks, code) {
    if (!fallbacks) return [];
    if (typeof fallbacks === 'string') fallbacks = [fallbacks];
    if (Object.prototype.toString.apply(fallbacks) === '[object Array]') return fallbacks;

    if (!code) return fallbacks.default || [];

    // asume we have an object defining fallbacks
    var found = fallbacks[code];
    if (!found) found = fallbacks[this.getScriptPartFromCode(code)];
    if (!found) found = fallbacks[this.formatLanguageCode(code)];
    if (!found) found = fallbacks.default;

    return found || [];
  };

  LanguageUtil.prototype.toResolveHierarchy = function toResolveHierarchy(code, fallbackCode) {
    var _this = this;

    var fallbackCodes = this.getFallbackCodes(fallbackCode || this.options.fallbackLng || [], code);

    var codes = [];
    var addCode = function addCode(c) {
      if (!c) return;
      if (_this.isWhitelisted(c)) {
        codes.push(c);
      } else {
        _this.logger.warn('rejecting non-whitelisted language code: ' + c);
      }
    };

    if (typeof code === 'string' && code.indexOf('-') > -1) {
      if (this.options.load !== 'languageOnly') addCode(this.formatLanguageCode(code));
      if (this.options.load !== 'languageOnly' && this.options.load !== 'currentOnly') addCode(this.getScriptPartFromCode(code));
      if (this.options.load !== 'currentOnly') addCode(this.getLanguagePartFromCode(code));
    } else if (typeof code === 'string') {
      addCode(this.formatLanguageCode(code));
    }

    fallbackCodes.forEach(function (fc) {
      if (codes.indexOf(fc) < 0) addCode(_this.formatLanguageCode(fc));
    });

    return codes;
  };

  return LanguageUtil;
}();

// definition http://translate.sourceforge.net/wiki/l10n/pluralforms
/* eslint-disable */
var sets = [{ lngs: ['ach', 'ak', 'am', 'arn', 'br', 'fil', 'gun', 'ln', 'mfe', 'mg', 'mi', 'oc', 'pt', 'pt-BR', 'tg', 'ti', 'tr', 'uz', 'wa'], nr: [1, 2], fc: 1 }, { lngs: ['af', 'an', 'ast', 'az', 'bg', 'bn', 'ca', 'da', 'de', 'dev', 'el', 'en', 'eo', 'es', 'et', 'eu', 'fi', 'fo', 'fur', 'fy', 'gl', 'gu', 'ha', 'he', 'hi', 'hu', 'hy', 'ia', 'it', 'kn', 'ku', 'lb', 'mai', 'ml', 'mn', 'mr', 'nah', 'nap', 'nb', 'ne', 'nl', 'nn', 'no', 'nso', 'pa', 'pap', 'pms', 'ps', 'pt-PT', 'rm', 'sco', 'se', 'si', 'so', 'son', 'sq', 'sv', 'sw', 'ta', 'te', 'tk', 'ur', 'yo'], nr: [1, 2], fc: 2 }, { lngs: ['ay', 'bo', 'cgg', 'fa', 'id', 'ja', 'jbo', 'ka', 'kk', 'km', 'ko', 'ky', 'lo', 'ms', 'sah', 'su', 'th', 'tt', 'ug', 'vi', 'wo', 'zh'], nr: [1], fc: 3 }, { lngs: ['be', 'bs', 'dz', 'hr', 'ru', 'sr', 'uk'], nr: [1, 2, 5], fc: 4 }, { lngs: ['ar'], nr: [0, 1, 2, 3, 11, 100], fc: 5 }, { lngs: ['cs', 'sk'], nr: [1, 2, 5], fc: 6 }, { lngs: ['csb', 'pl'], nr: [1, 2, 5], fc: 7 }, { lngs: ['cy'], nr: [1, 2, 3, 8], fc: 8 }, { lngs: ['fr'], nr: [1, 2], fc: 9 }, { lngs: ['ga'], nr: [1, 2, 3, 7, 11], fc: 10 }, { lngs: ['gd'], nr: [1, 2, 3, 20], fc: 11 }, { lngs: ['is'], nr: [1, 2], fc: 12 }, { lngs: ['jv'], nr: [0, 1], fc: 13 }, { lngs: ['kw'], nr: [1, 2, 3, 4], fc: 14 }, { lngs: ['lt'], nr: [1, 2, 10], fc: 15 }, { lngs: ['lv'], nr: [1, 2, 0], fc: 16 }, { lngs: ['mk'], nr: [1, 2], fc: 17 }, { lngs: ['mnk'], nr: [0, 1, 2], fc: 18 }, { lngs: ['mt'], nr: [1, 2, 11, 20], fc: 19 }, { lngs: ['or'], nr: [2, 1], fc: 2 }, { lngs: ['ro'], nr: [1, 2, 20], fc: 20 }, { lngs: ['sl'], nr: [5, 1, 2, 3], fc: 21 }];

var _rulesPluralsTypes = {
  1: function _(n) {
    return Number(n > 1);
  },
  2: function _(n) {
    return Number(n != 1);
  },
  3: function _(n) {
    return 0;
  },
  4: function _(n) {
    return Number(n % 10 == 1 && n % 100 != 11 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2);
  },
  5: function _(n) {
    return Number(n === 0 ? 0 : n == 1 ? 1 : n == 2 ? 2 : n % 100 >= 3 && n % 100 <= 10 ? 3 : n % 100 >= 11 ? 4 : 5);
  },
  6: function _(n) {
    return Number(n == 1 ? 0 : n >= 2 && n <= 4 ? 1 : 2);
  },
  7: function _(n) {
    return Number(n == 1 ? 0 : n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2);
  },
  8: function _(n) {
    return Number(n == 1 ? 0 : n == 2 ? 1 : n != 8 && n != 11 ? 2 : 3);
  },
  9: function _(n) {
    return Number(n >= 2);
  },
  10: function _(n) {
    return Number(n == 1 ? 0 : n == 2 ? 1 : n < 7 ? 2 : n < 11 ? 3 : 4);
  },
  11: function _(n) {
    return Number(n == 1 || n == 11 ? 0 : n == 2 || n == 12 ? 1 : n > 2 && n < 20 ? 2 : 3);
  },
  12: function _(n) {
    return Number(n % 10 != 1 || n % 100 == 11);
  },
  13: function _(n) {
    return Number(n !== 0);
  },
  14: function _(n) {
    return Number(n == 1 ? 0 : n == 2 ? 1 : n == 3 ? 2 : 3);
  },
  15: function _(n) {
    return Number(n % 10 == 1 && n % 100 != 11 ? 0 : n % 10 >= 2 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2);
  },
  16: function _(n) {
    return Number(n % 10 == 1 && n % 100 != 11 ? 0 : n !== 0 ? 1 : 2);
  },
  17: function _(n) {
    return Number(n == 1 || n % 10 == 1 ? 0 : 1);
  },
  18: function _(n) {
    return Number(n == 0 ? 0 : n == 1 ? 1 : 2);
  },
  19: function _(n) {
    return Number(n == 1 ? 0 : n === 0 || n % 100 > 1 && n % 100 < 11 ? 1 : n % 100 > 10 && n % 100 < 20 ? 2 : 3);
  },
  20: function _(n) {
    return Number(n == 1 ? 0 : n === 0 || n % 100 > 0 && n % 100 < 20 ? 1 : 2);
  },
  21: function _(n) {
    return Number(n % 100 == 1 ? 1 : n % 100 == 2 ? 2 : n % 100 == 3 || n % 100 == 4 ? 3 : 0);
  }
};
/* eslint-enable */

function createRules() {
  var rules = {};
  sets.forEach(function (set$$1) {
    set$$1.lngs.forEach(function (l) {
      rules[l] = {
        numbers: set$$1.nr,
        plurals: _rulesPluralsTypes[set$$1.fc]
      };
    });
  });
  return rules;
}

var PluralResolver = function () {
  function PluralResolver(languageUtils) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    classCallCheck(this, PluralResolver);

    this.languageUtils = languageUtils;
    this.options = options;

    this.logger = baseLogger.create('pluralResolver');

    this.rules = createRules();
  }

  PluralResolver.prototype.addRule = function addRule(lng, obj) {
    this.rules[lng] = obj;
  };

  PluralResolver.prototype.getRule = function getRule(code) {
    return this.rules[code] || this.rules[this.languageUtils.getLanguagePartFromCode(code)];
  };

  PluralResolver.prototype.needsPlural = function needsPlural(code) {
    var rule = this.getRule(code);

    return rule && rule.numbers.length > 1;
  };

  PluralResolver.prototype.getSuffix = function getSuffix(code, count) {
    var _this = this;

    var rule = this.getRule(code);

    if (rule) {
      //if (rule.numbers.length === 1) return ''; // only singular

      var idx = rule.noAbs ? rule.plurals(count) : rule.plurals(Math.abs(count));
      var suffix = rule.numbers[idx];

      // special treatment for lngs only having singular and plural
      if (this.options.simplifyPluralSuffix && rule.numbers.length === 2 && rule.numbers[0] === 1) {
        if (suffix === 2) {
          suffix = 'plural';
        } else if (suffix === 1) {
          suffix = '';
        }
      }

      var returnSuffix = function returnSuffix() {
        return _this.options.prepend && suffix.toString() ? _this.options.prepend + suffix.toString() : suffix.toString();
      };

      // COMPATIBILITY JSON
      // v1
      if (this.options.compatibilityJSON === 'v1') {
        if (suffix === 1) return '';
        if (typeof suffix === 'number') return '_plural_' + suffix.toString();
        return returnSuffix();
      } else if ( /* v2 */this.options.compatibilityJSON === 'v2' || rule.numbers.length === 2 && rule.numbers[0] === 1) {
        return returnSuffix();
      } else if ( /* v3 - gettext index */rule.numbers.length === 2 && rule.numbers[0] === 1) {
        return returnSuffix();
      }
      return this.options.prepend && idx.toString() ? this.options.prepend + idx.toString() : idx.toString();
    }

    this.logger.warn('no plural rule found for: ' + code);
    return '';
  };

  return PluralResolver;
}();

var Interpolator = function () {
  function Interpolator() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    classCallCheck(this, Interpolator);

    this.logger = baseLogger.create('interpolator');

    this.init(options, true);
  }

  /* eslint no-param-reassign: 0 */


  Interpolator.prototype.init = function init() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var reset = arguments[1];

    if (reset) {
      this.options = options;
      this.format = options.interpolation && options.interpolation.format || function (value) {
        return value;
      };
      this.escape = options.interpolation && options.interpolation.escape || escape;
    }
    if (!options.interpolation) options.interpolation = { escapeValue: true };

    var iOpts = options.interpolation;

    this.escapeValue = iOpts.escapeValue !== undefined ? iOpts.escapeValue : true;

    this.prefix = iOpts.prefix ? regexEscape(iOpts.prefix) : iOpts.prefixEscaped || '{{';
    this.suffix = iOpts.suffix ? regexEscape(iOpts.suffix) : iOpts.suffixEscaped || '}}';

    this.formatSeparator = iOpts.formatSeparator ? iOpts.formatSeparator : iOpts.formatSeparator || ',';

    this.unescapePrefix = iOpts.unescapeSuffix ? '' : iOpts.unescapePrefix || '-';
    this.unescapeSuffix = this.unescapePrefix ? '' : iOpts.unescapeSuffix || '';

    this.nestingPrefix = iOpts.nestingPrefix ? regexEscape(iOpts.nestingPrefix) : iOpts.nestingPrefixEscaped || regexEscape('$t(');
    this.nestingSuffix = iOpts.nestingSuffix ? regexEscape(iOpts.nestingSuffix) : iOpts.nestingSuffixEscaped || regexEscape(')');

    this.maxReplaces = iOpts.maxReplaces ? iOpts.maxReplaces : 1000;

    // the regexp
    this.resetRegExp();
  };

  Interpolator.prototype.reset = function reset() {
    if (this.options) this.init(this.options);
  };

  Interpolator.prototype.resetRegExp = function resetRegExp() {
    // the regexp
    var regexpStr = this.prefix + '(.+?)' + this.suffix;
    this.regexp = new RegExp(regexpStr, 'g');

    var regexpUnescapeStr = '' + this.prefix + this.unescapePrefix + '(.+?)' + this.unescapeSuffix + this.suffix;
    this.regexpUnescape = new RegExp(regexpUnescapeStr, 'g');

    var nestingRegexpStr = this.nestingPrefix + '(.+?)' + this.nestingSuffix;
    this.nestingRegexp = new RegExp(nestingRegexpStr, 'g');
  };

  Interpolator.prototype.interpolate = function interpolate(str, data, lng) {
    var _this = this;

    var match = void 0;
    var value = void 0;
    var replaces = void 0;

    function regexSafe(val) {
      return val.replace(/\$/g, '$$$$');
    }

    var handleFormat = function handleFormat(key) {
      if (key.indexOf(_this.formatSeparator) < 0) return getPath(data, key);

      var p = key.split(_this.formatSeparator);
      var k = p.shift().trim();
      var f = p.join(_this.formatSeparator).trim();

      return _this.format(getPath(data, k), f, lng);
    };

    this.resetRegExp();

    replaces = 0;
    // unescape if has unescapePrefix/Suffix
    /* eslint no-cond-assign: 0 */
    while (match = this.regexpUnescape.exec(str)) {
      value = handleFormat(match[1].trim());
      str = str.replace(match[0], value);
      this.regexpUnescape.lastIndex = 0;
      replaces++;
      if (replaces >= this.maxReplaces) {
        break;
      }
    }

    replaces = 0;
    // regular escape on demand
    while (match = this.regexp.exec(str)) {
      value = handleFormat(match[1].trim());
      if (typeof value !== 'string') value = makeString(value);
      if (!value) {
        this.logger.warn('missed to pass in variable ' + match[1] + ' for interpolating ' + str);
        value = '';
      }
      value = this.escapeValue ? regexSafe(this.escape(value)) : regexSafe(value);
      str = str.replace(match[0], value);
      this.regexp.lastIndex = 0;
      replaces++;
      if (replaces >= this.maxReplaces) {
        break;
      }
    }
    return str;
  };

  Interpolator.prototype.nest = function nest(str, fc) {
    var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};

    var match = void 0;
    var value = void 0;

    var clonedOptions = _extends({}, options);
    clonedOptions.applyPostProcessor = false; // avoid post processing on nested lookup

    // if value is something like "myKey": "lorem $(anotherKey, { "count": {{aValueInOptions}} })"
    function handleHasOptions(key) {
      if (key.indexOf(',') < 0) return key;

      var p = key.split(',');
      key = p.shift();
      var optionsString = p.join(',');
      optionsString = this.interpolate(optionsString, clonedOptions);
      optionsString = optionsString.replace(/'/g, '"');

      try {
        clonedOptions = JSON.parse(optionsString);
      } catch (e) {
        this.logger.error('failed parsing options string in nesting for key ' + key, e);
      }

      return key;
    }

    // regular escape on demand
    while (match = this.nestingRegexp.exec(str)) {
      value = fc(handleHasOptions.call(this, match[1].trim()), clonedOptions);

      // is only the nesting key (key1 = '$(key2)') return the value without stringify
      if (value && match[0] === str && typeof value !== 'string') return value;

      // no string to include or empty
      if (typeof value !== 'string') value = makeString(value);
      if (!value) {
        this.logger.warn('missed to resolve ' + match[1] + ' for nesting ' + str);
        value = '';
      }
      // Nested keys should not be escaped by default #854
      // value = this.escapeValue ? regexSafe(utils.escape(value)) : regexSafe(value);
      str = str.replace(match[0], value);
      this.regexp.lastIndex = 0;
    }
    return str;
  };

  return Interpolator;
}();

function remove(arr, what) {
  var found = arr.indexOf(what);

  while (found !== -1) {
    arr.splice(found, 1);
    found = arr.indexOf(what);
  }
}

var Connector = function (_EventEmitter) {
  inherits(Connector, _EventEmitter);

  function Connector(backend, store, services) {
    var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
    classCallCheck(this, Connector);

    var _this = possibleConstructorReturn(this, _EventEmitter.call(this));

    _this.backend = backend;
    _this.store = store;
    _this.languageUtils = services.languageUtils;
    _this.options = options;
    _this.logger = baseLogger.create('backendConnector');

    _this.state = {};
    _this.queue = [];

    if (_this.backend && _this.backend.init) {
      _this.backend.init(services, options.backend, options);
    }
    return _this;
  }

  Connector.prototype.queueLoad = function queueLoad(languages, namespaces, callback) {
    var _this2 = this;

    // find what needs to be loaded
    var toLoad = [];
    var pending = [];
    var toLoadLanguages = [];
    var toLoadNamespaces = [];

    languages.forEach(function (lng) {
      var hasAllNamespaces = true;

      namespaces.forEach(function (ns) {
        var name = lng + '|' + ns;

        if (_this2.store.hasResourceBundle(lng, ns)) {
          _this2.state[name] = 2; // loaded
        } else if (_this2.state[name] < 0) {
          // nothing to do for err
        } else if (_this2.state[name] === 1) {
          if (pending.indexOf(name) < 0) pending.push(name);
        } else {
          _this2.state[name] = 1; // pending

          hasAllNamespaces = false;

          if (pending.indexOf(name) < 0) pending.push(name);
          if (toLoad.indexOf(name) < 0) toLoad.push(name);
          if (toLoadNamespaces.indexOf(ns) < 0) toLoadNamespaces.push(ns);
        }
      });

      if (!hasAllNamespaces) toLoadLanguages.push(lng);
    });

    if (toLoad.length || pending.length) {
      this.queue.push({
        pending: pending,
        loaded: {},
        errors: [],
        callback: callback
      });
    }

    return {
      toLoad: toLoad,
      pending: pending,
      toLoadLanguages: toLoadLanguages,
      toLoadNamespaces: toLoadNamespaces
    };
  };

  Connector.prototype.loaded = function loaded(name, err, data) {
    var _this3 = this;

    var _name$split = name.split('|'),
        _name$split2 = slicedToArray(_name$split, 2),
        lng = _name$split2[0],
        ns = _name$split2[1];

    if (err) this.emit('failedLoading', lng, ns, err);

    if (data) {
      this.store.addResourceBundle(lng, ns, data);
    }

    // set loaded
    this.state[name] = err ? -1 : 2;

    // callback if ready
    this.queue.forEach(function (q) {
      pushPath(q.loaded, [lng], ns);
      remove(q.pending, name);

      if (err) q.errors.push(err);

      if (q.pending.length === 0 && !q.done) {
        _this3.emit('loaded', q.loaded);
        /* eslint no-param-reassign: 0 */
        q.done = true;
        if (q.errors.length) {
          q.callback(q.errors);
        } else {
          q.callback();
        }
      }
    });

    // remove done load requests
    this.queue = this.queue.filter(function (q) {
      return !q.done;
    });
  };

  Connector.prototype.read = function read(lng, ns, fcName) {
    var tried = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;

    var _this4 = this;

    var wait = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 250;
    var callback = arguments[5];

    if (!lng.length) return callback(null, {}); // noting to load

    return this.backend[fcName](lng, ns, function (err, data) {
      if (err && data /* = retryFlag */ && tried < 5) {
        setTimeout(function () {
          _this4.read.call(_this4, lng, ns, fcName, tried + 1, wait * 2, callback);
        }, wait);
        return;
      }
      callback(err, data);
    });
  };

  /* eslint consistent-return: 0 */


  Connector.prototype.load = function load(languages, namespaces, callback) {
    var _this5 = this;

    if (!this.backend) {
      this.logger.warn('No backend was added via i18next.use. Will not load resources.');
      return callback && callback();
    }
    var options = _extends({}, this.backend.options, this.options.backend);

    if (typeof languages === 'string') languages = this.languageUtils.toResolveHierarchy(languages);
    if (typeof namespaces === 'string') namespaces = [namespaces];

    var toLoad = this.queueLoad(languages, namespaces, callback);
    if (!toLoad.toLoad.length) {
      if (!toLoad.pending.length) callback(); // nothing to load and no pendings...callback now
      return null; // pendings will trigger callback
    }

    // load with multi-load
    if (options.allowMultiLoading && this.backend.readMulti) {
      this.read(toLoad.toLoadLanguages, toLoad.toLoadNamespaces, 'readMulti', null, null, function (err, data) {
        if (err) _this5.logger.warn('loading namespaces ' + toLoad.toLoadNamespaces.join(', ') + ' for languages ' + toLoad.toLoadLanguages.join(', ') + ' via multiloading failed', err);
        if (!err && data) _this5.logger.log('successfully loaded namespaces ' + toLoad.toLoadNamespaces.join(', ') + ' for languages ' + toLoad.toLoadLanguages.join(', ') + ' via multiloading', data);

        toLoad.toLoad.forEach(function (name) {
          var _name$split3 = name.split('|'),
              _name$split4 = slicedToArray(_name$split3, 2),
              l = _name$split4[0],
              n = _name$split4[1];

          var bundle = getPath(data, [l, n]);
          if (bundle) {
            _this5.loaded(name, err, bundle);
          } else {
            var error = 'loading namespace ' + n + ' for language ' + l + ' via multiloading failed';
            _this5.loaded(name, error);
            _this5.logger.error(error);
          }
        });
      });
    } else {
      toLoad.toLoad.forEach(function (name) {
        _this5.loadOne(name);
      });
    }
  };

  Connector.prototype.reload = function reload(languages, namespaces) {
    var _this6 = this;

    if (!this.backend) {
      this.logger.warn('No backend was added via i18next.use. Will not load resources.');
    }
    var options = _extends({}, this.backend.options, this.options.backend);

    if (typeof languages === 'string') languages = this.languageUtils.toResolveHierarchy(languages);
    if (typeof namespaces === 'string') namespaces = [namespaces];

    // load with multi-load
    if (options.allowMultiLoading && this.backend.readMulti) {
      this.read(languages, namespaces, 'readMulti', null, null, function (err, data) {
        if (err) _this6.logger.warn('reloading namespaces ' + namespaces.join(', ') + ' for languages ' + languages.join(', ') + ' via multiloading failed', err);
        if (!err && data) _this6.logger.log('successfully reloaded namespaces ' + namespaces.join(', ') + ' for languages ' + languages.join(', ') + ' via multiloading', data);

        languages.forEach(function (l) {
          namespaces.forEach(function (n) {
            var bundle = getPath(data, [l, n]);
            if (bundle) {
              _this6.loaded(l + '|' + n, err, bundle);
            } else {
              var error = 'reloading namespace ' + n + ' for language ' + l + ' via multiloading failed';
              _this6.loaded(l + '|' + n, error);
              _this6.logger.error(error);
            }
          });
        });
      });
    } else {
      languages.forEach(function (l) {
        namespaces.forEach(function (n) {
          _this6.loadOne(l + '|' + n, 're');
        });
      });
    }
  };

  Connector.prototype.loadOne = function loadOne(name) {
    var _this7 = this;

    var prefix = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';

    var _name$split5 = name.split('|'),
        _name$split6 = slicedToArray(_name$split5, 2),
        lng = _name$split6[0],
        ns = _name$split6[1];

    this.read(lng, ns, 'read', null, null, function (err, data) {
      if (err) _this7.logger.warn(prefix + 'loading namespace ' + ns + ' for language ' + lng + ' failed', err);
      if (!err && data) _this7.logger.log(prefix + 'loaded namespace ' + ns + ' for language ' + lng, data);

      _this7.loaded(name, err, data);
    });
  };

  Connector.prototype.saveMissing = function saveMissing(languages, namespace, key, fallbackValue) {
    if (this.backend && this.backend.create) this.backend.create(languages, namespace, key, fallbackValue);

    // write to store to avoid resending
    if (!languages || !languages[0]) return;
    this.store.addResource(languages[0], namespace, key, fallbackValue);
  };

  return Connector;
}(EventEmitter);

var Connector$1 = function (_EventEmitter) {
  inherits(Connector, _EventEmitter);

  function Connector(cache, store, services) {
    var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
    classCallCheck(this, Connector);

    var _this = possibleConstructorReturn(this, _EventEmitter.call(this));

    _this.cache = cache;
    _this.store = store;
    _this.services = services;
    _this.options = options;
    _this.logger = baseLogger.create('cacheConnector');

    if (_this.cache && _this.cache.init) _this.cache.init(services, options.cache, options);
    return _this;
  }

  /* eslint consistent-return: 0 */


  Connector.prototype.load = function load(languages, namespaces, callback) {
    var _this2 = this;

    if (!this.cache) return callback && callback();
    var options = _extends({}, this.cache.options, this.options.cache);

    var loadLngs = typeof languages === 'string' ? this.services.languageUtils.toResolveHierarchy(languages) : languages;

    if (options.enabled) {
      this.cache.load(loadLngs, function (err, data) {
        if (err) _this2.logger.error('loading languages ' + loadLngs.join(', ') + ' from cache failed', err);
        if (data) {
          /* eslint no-restricted-syntax: 0 */
          for (var l in data) {
            if (Object.prototype.hasOwnProperty.call(data, l)) {
              for (var n in data[l]) {
                if (Object.prototype.hasOwnProperty.call(data[l], n)) {
                  if (n !== 'i18nStamp') {
                    var bundle = data[l][n];
                    if (bundle) _this2.store.addResourceBundle(l, n, bundle);
                  }
                }
              }
            }
          }
        }
        if (callback) callback();
      });
    } else if (callback) {
      callback();
    }
  };

  Connector.prototype.save = function save() {
    if (this.cache && this.options.cache && this.options.cache.enabled) this.cache.save(this.store.data);
  };

  return Connector;
}(EventEmitter);

function get$1() {
  return {
    debug: false,
    initImmediate: true,

    ns: ['translation'],
    defaultNS: ['translation'],
    fallbackLng: ['dev'],
    fallbackNS: false, // string or array of namespaces

    whitelist: false, // array with whitelisted languages
    nonExplicitWhitelist: false,
    load: 'all', // | currentOnly | languageOnly
    preload: false, // array with preload languages

    simplifyPluralSuffix: true,
    keySeparator: '.',
    nsSeparator: ':',
    pluralSeparator: '_',
    contextSeparator: '_',

    saveMissing: false, // enable to send missing values
    saveMissingTo: 'fallback', // 'current' || 'all'
    missingKeyHandler: false, // function(lng, ns, key, fallbackValue) -> override if prefer on handling

    postProcess: false, // string or array of postProcessor names
    returnNull: true, // allows null value as valid translation
    returnEmptyString: true, // allows empty string value as valid translation
    returnObjects: false,
    joinArrays: false, // or string to join array
    returnedObjectHandler: function returnedObjectHandler() {}, // function(key, value, options) triggered if key returns object but returnObjects is set to false
    parseMissingKeyHandler: false, // function(key) parsed a key that was not found in t() before returning
    appendNamespaceToMissingKey: false,
    appendNamespaceToCIMode: false,
    overloadTranslationOptionHandler: function handle(args) {
      return { defaultValue: args[1] };
    },

    interpolation: {
      escapeValue: true,
      format: function format(value, _format, lng) {
        return value;
      },
      prefix: '{{',
      suffix: '}}',
      formatSeparator: ',',
      // prefixEscaped: '{{',
      // suffixEscaped: '}}',
      // unescapeSuffix: '',
      unescapePrefix: '-',

      nestingPrefix: '$t(',
      nestingSuffix: ')',
      // nestingPrefixEscaped: '$t(',
      // nestingSuffixEscaped: ')',
      // defaultVariables: undefined // object that can have values to interpolate on - extends passed in interpolation data
      maxReplaces: 1000 // max replaces to prevent endless loop
    }
  };
}

/* eslint no-param-reassign: 0 */
function transformOptions(options) {
  // create namespace object if namespace is passed in as string
  if (typeof options.ns === 'string') options.ns = [options.ns];
  if (typeof options.fallbackLng === 'string') options.fallbackLng = [options.fallbackLng];
  if (typeof options.fallbackNS === 'string') options.fallbackNS = [options.fallbackNS];

  // extend whitelist with cimode
  if (options.whitelist && options.whitelist.indexOf('cimode') < 0) options.whitelist.push('cimode');

  return options;
}

function noop() {}

var I18n = function (_EventEmitter) {
  inherits(I18n, _EventEmitter);

  function I18n() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var callback = arguments[1];
    classCallCheck(this, I18n);

    var _this = possibleConstructorReturn(this, _EventEmitter.call(this));

    _this.options = transformOptions(options);
    _this.services = {};
    _this.logger = baseLogger;
    _this.modules = { external: [] };

    if (callback && !_this.isInitialized && !options.isClone) {
      var _ret;

      // https://github.com/i18next/i18next/issues/879
      if (!_this.options.initImmediate) return _ret = _this.init(options, callback), possibleConstructorReturn(_this, _ret);
      setTimeout(function () {
        _this.init(options, callback);
      }, 0);
    }
    return _this;
  }

  I18n.prototype.init = function init() {
    var _this2 = this;

    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var callback = arguments[1];

    if (typeof options === 'function') {
      callback = options;
      options = {};
    }
    this.options = _extends({}, get$1(), this.options, transformOptions(options));

    this.format = this.options.interpolation.format;
    if (!callback) callback = noop;

    function createClassOnDemand(ClassOrObject) {
      if (!ClassOrObject) return null;
      if (typeof ClassOrObject === 'function') return new ClassOrObject();
      return ClassOrObject;
    }

    // init services
    if (!this.options.isClone) {
      if (this.modules.logger) {
        baseLogger.init(createClassOnDemand(this.modules.logger), this.options);
      } else {
        baseLogger.init(null, this.options);
      }

      var lu = new LanguageUtil(this.options);
      this.store = new ResourceStore(this.options.resources, this.options);

      var s = this.services;
      s.logger = baseLogger;
      s.resourceStore = this.store;
      s.resourceStore.on('added removed', function (lng, ns) {
        s.cacheConnector.save();
      });
      s.languageUtils = lu;
      s.pluralResolver = new PluralResolver(lu, { prepend: this.options.pluralSeparator, compatibilityJSON: this.options.compatibilityJSON, simplifyPluralSuffix: this.options.simplifyPluralSuffix });
      s.interpolator = new Interpolator(this.options);

      s.backendConnector = new Connector(createClassOnDemand(this.modules.backend), s.resourceStore, s, this.options);
      // pipe events from backendConnector
      s.backendConnector.on('*', function (event) {
        for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }

        _this2.emit.apply(_this2, [event].concat(args));
      });

      s.backendConnector.on('loaded', function (loaded) {
        s.cacheConnector.save();
      });

      s.cacheConnector = new Connector$1(createClassOnDemand(this.modules.cache), s.resourceStore, s, this.options);
      // pipe events from backendConnector
      s.cacheConnector.on('*', function (event) {
        for (var _len2 = arguments.length, args = Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
          args[_key2 - 1] = arguments[_key2];
        }

        _this2.emit.apply(_this2, [event].concat(args));
      });

      if (this.modules.languageDetector) {
        s.languageDetector = createClassOnDemand(this.modules.languageDetector);
        s.languageDetector.init(s, this.options.detection, this.options);
      }

      this.translator = new Translator(this.services, this.options);
      // pipe events from translator
      this.translator.on('*', function (event) {
        for (var _len3 = arguments.length, args = Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {
          args[_key3 - 1] = arguments[_key3];
        }

        _this2.emit.apply(_this2, [event].concat(args));
      });

      this.modules.external.forEach(function (m) {
        if (m.init) m.init(_this2);
      });
    }

    // append api
    var storeApi = ['getResource', 'addResource', 'addResources', 'addResourceBundle', 'removeResourceBundle', 'hasResourceBundle', 'getResourceBundle'];
    storeApi.forEach(function (fcName) {
      _this2[fcName] = function () {
        var _store;

        return (_store = _this2.store)[fcName].apply(_store, arguments);
      };
    });

    var load = function load() {
      _this2.changeLanguage(_this2.options.lng, function (err, t) {
        _this2.isInitialized = true;
        _this2.logger.log('initialized', _this2.options);
        _this2.emit('initialized', _this2.options);

        callback(err, t);
      });
    };

    if (this.options.resources || !this.options.initImmediate) {
      load();
    } else {
      setTimeout(load, 0);
    }

    return this;
  };

  /* eslint consistent-return: 0 */


  I18n.prototype.loadResources = function loadResources() {
    var _this3 = this;

    var callback = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : noop;

    if (!this.options.resources) {
      if (this.language && this.language.toLowerCase() === 'cimode') return callback(); // avoid loading resources for cimode

      var toLoad = [];

      var append = function append(lng) {
        if (!lng) return;
        var lngs = _this3.services.languageUtils.toResolveHierarchy(lng);
        lngs.forEach(function (l) {
          if (toLoad.indexOf(l) < 0) toLoad.push(l);
        });
      };

      if (!this.language) {
        // at least load fallbacks in this case
        var fallbacks = this.services.languageUtils.getFallbackCodes(this.options.fallbackLng);
        fallbacks.forEach(function (l) {
          return append(l);
        });
      } else {
        append(this.language);
      }

      if (this.options.preload) {
        this.options.preload.forEach(function (l) {
          return append(l);
        });
      }

      this.services.cacheConnector.load(toLoad, this.options.ns, function () {
        _this3.services.backendConnector.load(toLoad, _this3.options.ns, callback);
      });
    } else {
      callback(null);
    }
  };

  I18n.prototype.reloadResources = function reloadResources(lngs, ns) {
    if (!lngs) lngs = this.languages;
    if (!ns) ns = this.options.ns;
    this.services.backendConnector.reload(lngs, ns);
  };

  I18n.prototype.use = function use(module) {
    if (module.type === 'backend') {
      this.modules.backend = module;
    }

    if (module.type === 'cache') {
      this.modules.cache = module;
    }

    if (module.type === 'logger' || module.log && module.warn && module.error) {
      this.modules.logger = module;
    }

    if (module.type === 'languageDetector') {
      this.modules.languageDetector = module;
    }

    if (module.type === 'postProcessor') {
      postProcessor.addPostProcessor(module);
    }

    if (module.type === '3rdParty') {
      this.modules.external.push(module);
    }

    return this;
  };

  I18n.prototype.changeLanguage = function changeLanguage(lng, callback) {
    var _this4 = this;

    var done = function done(err, l) {
      _this4.translator.changeLanguage(l);

      if (l) {
        _this4.emit('languageChanged', l);
        _this4.logger.log('languageChanged', l);
      }

      if (callback) callback(err, function () {
        return _this4.t.apply(_this4, arguments);
      });
    };

    var setLng = function setLng(l) {
      if (l) {
        _this4.language = l;
        _this4.languages = _this4.services.languageUtils.toResolveHierarchy(l);

        if (_this4.services.languageDetector) _this4.services.languageDetector.cacheUserLanguage(l);
      }

      _this4.loadResources(function (err) {
        done(err, l);
      });
    };

    if (!lng && this.services.languageDetector && !this.services.languageDetector.async) {
      setLng(this.services.languageDetector.detect());
    } else if (!lng && this.services.languageDetector && this.services.languageDetector.async) {
      this.services.languageDetector.detect(setLng);
    } else {
      setLng(lng);
    }
  };

  I18n.prototype.getFixedT = function getFixedT(lng, ns) {
    var _this5 = this;

    var fixedT = function fixedT(key, opts) {
      for (var _len4 = arguments.length, rest = Array(_len4 > 2 ? _len4 - 2 : 0), _key4 = 2; _key4 < _len4; _key4++) {
        rest[_key4 - 2] = arguments[_key4];
      }

      var options = _extends({}, opts);
      if ((typeof opts === 'undefined' ? 'undefined' : _typeof(opts)) !== 'object') {
        options = _this5.options.overloadTranslationOptionHandler([key, opts].concat(rest));
      }

      options.lng = options.lng || fixedT.lng;
      options.lngs = options.lngs || fixedT.lngs;
      options.ns = options.ns || fixedT.ns;
      return _this5.t(key, options);
    };
    if (typeof lng === 'string') {
      fixedT.lng = lng;
    } else {
      fixedT.lngs = lng;
    }
    fixedT.ns = ns;
    return fixedT;
  };

  I18n.prototype.t = function t() {
    var _translator;

    return this.translator && (_translator = this.translator).translate.apply(_translator, arguments);
  };

  I18n.prototype.exists = function exists() {
    var _translator2;

    return this.translator && (_translator2 = this.translator).exists.apply(_translator2, arguments);
  };

  I18n.prototype.setDefaultNamespace = function setDefaultNamespace(ns) {
    this.options.defaultNS = ns;
  };

  I18n.prototype.loadNamespaces = function loadNamespaces(ns, callback) {
    var _this6 = this;

    if (!this.options.ns) return callback && callback();
    if (typeof ns === 'string') ns = [ns];

    ns.forEach(function (n) {
      if (_this6.options.ns.indexOf(n) < 0) _this6.options.ns.push(n);
    });

    this.loadResources(callback);
  };

  I18n.prototype.loadLanguages = function loadLanguages(lngs, callback) {
    if (typeof lngs === 'string') lngs = [lngs];
    var preloaded = this.options.preload || [];

    var newLngs = lngs.filter(function (lng) {
      return preloaded.indexOf(lng) < 0;
    });
    // Exit early if all given languages are already preloaded
    if (!newLngs.length) return callback();

    this.options.preload = preloaded.concat(newLngs);
    this.loadResources(callback);
  };

  I18n.prototype.dir = function dir(lng) {
    if (!lng) lng = this.languages && this.languages.length > 0 ? this.languages[0] : this.language;
    if (!lng) return 'rtl';

    var rtlLngs = ['ar', 'shu', 'sqr', 'ssh', 'xaa', 'yhd', 'yud', 'aao', 'abh', 'abv', 'acm', 'acq', 'acw', 'acx', 'acy', 'adf', 'ads', 'aeb', 'aec', 'afb', 'ajp', 'apc', 'apd', 'arb', 'arq', 'ars', 'ary', 'arz', 'auz', 'avl', 'ayh', 'ayl', 'ayn', 'ayp', 'bbz', 'pga', 'he', 'iw', 'ps', 'pbt', 'pbu', 'pst', 'prp', 'prd', 'ur', 'ydd', 'yds', 'yih', 'ji', 'yi', 'hbo', 'men', 'xmn', 'fa', 'jpr', 'peo', 'pes', 'prs', 'dv', 'sam'];

    return rtlLngs.indexOf(this.services.languageUtils.getLanguagePartFromCode(lng)) >= 0 ? 'rtl' : 'ltr';
  };

  /* eslint class-methods-use-this: 0 */


  I18n.prototype.createInstance = function createInstance() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var callback = arguments[1];

    return new I18n(options, callback);
  };

  I18n.prototype.cloneInstance = function cloneInstance() {
    var _this7 = this;

    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var callback = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : noop;

    var mergedOptions = _extends({}, this.options, options, { isClone: true });
    var clone = new I18n(mergedOptions);
    var membersToCopy = ['store', 'services', 'language'];
    membersToCopy.forEach(function (m) {
      clone[m] = _this7[m];
    });
    clone.translator = new Translator(clone.services, clone.options);
    clone.translator.on('*', function (event) {
      for (var _len5 = arguments.length, args = Array(_len5 > 1 ? _len5 - 1 : 0), _key5 = 1; _key5 < _len5; _key5++) {
        args[_key5 - 1] = arguments[_key5];
      }

      clone.emit.apply(clone, [event].concat(args));
    });
    clone.init(mergedOptions, callback);
    clone.translator.options = clone.options; // sync options

    return clone;
  };

  return I18n;
}(EventEmitter);

var i18next = new I18n();

return i18next;

})));


/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

(function (global, factory) {
   true ? module.exports = factory() :
  typeof define === 'function' && define.amd ? define(factory) :
  (global.i18nextXHRBackend = factory());
}(this, (function () { 'use strict';

var arr = [];
var each = arr.forEach;
var slice = arr.slice;

function defaults(obj) {
  each.call(slice.call(arguments, 1), function (source) {
    if (source) {
      for (var prop in source) {
        if (obj[prop] === undefined) obj[prop] = source[prop];
      }
    }
  });
  return obj;
}

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

function addQueryString(url, params) {
  if (params && (typeof params === 'undefined' ? 'undefined' : _typeof(params)) === 'object') {
    var queryString = '',
        e = encodeURIComponent;

    // Must encode data
    for (var paramName in params) {
      queryString += '&' + e(paramName) + '=' + e(params[paramName]);
    }

    if (!queryString) {
      return url;
    }

    url = url + (url.indexOf('?') !== -1 ? '&' : '?') + queryString.slice(1);
  }

  return url;
}

// https://gist.github.com/Xeoncross/7663273
function ajax(url, options, callback, data, cache) {

  if (data && (typeof data === 'undefined' ? 'undefined' : _typeof(data)) === 'object') {
    if (!cache) {
      data['_t'] = new Date();
    }
    // URL encoded form data must be in querystring format
    data = addQueryString('', data).slice(1);
  }

  if (options.queryStringParams) {
    url = addQueryString(url, options.queryStringParams);
  }

  try {
    var x;
    if (XMLHttpRequest) {
      x = new XMLHttpRequest();
    } else {
      x = new ActiveXObject('MSXML2.XMLHTTP.3.0');
    }
    x.open(data ? 'POST' : 'GET', url, 1);
    if (!options.crossDomain) {
      x.setRequestHeader('X-Requested-With', 'XMLHttpRequest');
    }
    x.withCredentials = !!options.withCredentials;
    if (data) {
      x.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
    }
    if (x.overrideMimeType) {
      x.overrideMimeType("application/json");
    }
    var h = options.customHeaders;
    if (h) {
      for (var i in h) {
        x.setRequestHeader(i, h[i]);
      }
    }
    x.onreadystatechange = function () {
      x.readyState > 3 && callback && callback(x.responseText, x);
    };
    x.send(data);
  } catch (e) {
    console && console.log(e);
  }
}

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function getDefaults() {
  return {
    loadPath: '/locales/{{lng}}/{{ns}}.json',
    addPath: 'locales/add/{{lng}}/{{ns}}',
    allowMultiLoading: false,
    parse: JSON.parse,
    crossDomain: false,
    ajax: ajax
  };
}

var Backend = function () {
  function Backend(services) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, Backend);

    this.init(services, options);

    this.type = 'backend';
  }

  _createClass(Backend, [{
    key: 'init',
    value: function init(services) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      this.services = services;
      this.options = defaults(options, this.options || {}, getDefaults());
    }
  }, {
    key: 'readMulti',
    value: function readMulti(languages, namespaces, callback) {
      var loadPath = this.options.loadPath;
      if (typeof this.options.loadPath === 'function') {
        loadPath = this.options.loadPath(languages, namespaces);
      }

      var url = this.services.interpolator.interpolate(loadPath, { lng: languages.join('+'), ns: namespaces.join('+') });

      this.loadUrl(url, callback);
    }
  }, {
    key: 'read',
    value: function read(language, namespace, callback) {
      var loadPath = this.options.loadPath;
      if (typeof this.options.loadPath === 'function') {
        loadPath = this.options.loadPath([language], [namespace]);
      }

      var url = this.services.interpolator.interpolate(loadPath, { lng: language, ns: namespace });

      this.loadUrl(url, callback);
    }
  }, {
    key: 'loadUrl',
    value: function loadUrl(url, callback) {
      var _this = this;

      this.options.ajax(url, this.options, function (data, xhr) {
        if (xhr.status >= 500 && xhr.status < 600) return callback('failed loading ' + url, true /* retry */);
        if (xhr.status >= 400 && xhr.status < 500) return callback('failed loading ' + url, false /* no retry */);

        var ret = void 0,
            err = void 0;
        try {
          ret = _this.options.parse(data, url);
        } catch (e) {
          err = 'failed parsing ' + url + ' to json';
        }
        if (err) return callback(err, false);
        callback(null, ret);
      });
    }
  }, {
    key: 'create',
    value: function create(languages, namespace, key, fallbackValue) {
      var _this2 = this;

      if (typeof languages === 'string') languages = [languages];

      var payload = {};
      payload[key] = fallbackValue || '';

      languages.forEach(function (lng) {
        var url = _this2.services.interpolator.interpolate(_this2.options.addPath, { lng: lng, ns: namespace });

        _this2.options.ajax(url, _this2.options, function (data, xhr) {
          //const statusCode = xhr.status.toString();
          // TODO: if statusCode === 4xx do log
        }, payload);
      });
    }
  }]);

  return Backend;
}();

Backend.type = 'backend';

return Backend;

})));


/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

(function (global, factory) {
     true ? module.exports = factory() :
    typeof define === 'function' && define.amd ? define(factory) :
    (global.i18nextLocalStorageCache = factory());
}(this, (function () { 'use strict';

var arr = [];
var each = arr.forEach;
var slice = arr.slice;

function defaults(obj) {
  each.call(slice.call(arguments, 1), function (source) {
    if (source) {
      for (var prop in source) {
        if (obj[prop] === undefined) obj[prop] = source[prop];
      }
    }
  });
  return obj;
}



function debounce(func, wait, immediate) {
  var timeout;
  return function () {
    var context = this,
        args = arguments;
    var later = function later() {
      timeout = null;
      if (!immediate) func.apply(context, args);
    };
    var callNow = immediate && !timeout;
    clearTimeout(timeout);
    timeout = setTimeout(later, wait);
    if (callNow) func.apply(context, args);
  };
}

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var storage = {
  setItem: function setItem(key, value) {
    if (window.localStorage) {
      try {
        window.localStorage.setItem(key, value);
      } catch (e) {
        // f.log('failed to set value for key "' + key + '" to localStorage.');
      }
    }
  },
  getItem: function getItem(key, value) {
    if (window.localStorage) {
      try {
        return window.localStorage.getItem(key, value);
      } catch (e) {
        // f.log('failed to get value for key "' + key + '" from localStorage.');
      }
    }
    return undefined;
  }
};

function getDefaults() {
  return {
    enabled: false,
    prefix: 'i18next_res_',
    expirationTime: 7 * 24 * 60 * 60 * 1000,
    versions: {}
  };
}

var Cache = function () {
  function Cache(services) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    _classCallCheck(this, Cache);

    this.init(services, options);

    this.type = 'cache';
    this.debouncedStore = debounce(this.store, 10000);
  }

  _createClass(Cache, [{
    key: 'init',
    value: function init(services) {
      var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      this.services = services;
      this.options = defaults(options, this.options || {}, getDefaults());
    }
  }, {
    key: 'load',
    value: function load(lngs, callback) {
      var _this = this;

      var store = {};
      var nowMS = new Date().getTime();

      if (!window.localStorage || !lngs.length) {
        return callback(null, null);
      }

      var todo = lngs.length;

      lngs.forEach(function (lng) {
        var local = storage.getItem(_this.options.prefix + lng);

        if (local) {
          local = JSON.parse(local);
          if (
          // expiration field is mandatory, and should not be expired
          local.i18nStamp && local.i18nStamp + _this.options.expirationTime > nowMS &&

          // there should be no language version set, or if it is, it should match the one in translation
          _this.options.versions[lng] === local.i18nVersion) {
            delete local.i18nVersion;
            store[lng] = local;
          }
        }

        todo -= 1;
        if (todo === 0) {
          callback(null, store);
        }
      });
      return undefined;
    }
  }, {
    key: 'store',
    value: function store(storeParam) {
      var store = storeParam;
      if (window.localStorage) {
        for (var m in store) {
          // eslint-disable-line
          // timestamp
          store[m].i18nStamp = new Date().getTime();

          // language version (if set)
          if (this.options.versions[m]) {
            store[m].i18nVersion = this.options.versions[m];
          }

          // save
          storage.setItem(this.options.prefix + m, JSON.stringify(store[m]));
        }
      }
    }
  }, {
    key: 'save',
    value: function save(store) {
      this.debouncedStore(store);
    }
  }]);

  return Cache;
}();

Cache.type = 'cache';

return Cache;

})));


/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

(function (global, factory) {
     true ? module.exports = factory() :
    typeof define === 'function' && define.amd ? define('i18nextSprintfPostProcessor', factory) :
    (global.i18nextSprintfPostProcessor = factory());
}(this, function () { 'use strict';

    var babelHelpers = {};
    babelHelpers.typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) {
      return typeof obj;
    } : function (obj) {
      return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj;
    };
    babelHelpers;

    var re = {
        not_string: /[^s]/,
        number: /[diefg]/,
        json: /[j]/,
        not_json: /[^j]/,
        text: /^[^\x25]+/,
        modulo: /^\x25{2}/,
        placeholder: /^\x25(?:([1-9]\d*)\$|\(([^\)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-gijosuxX])/,
        key: /^([a-z_][a-z_\d]*)/i,
        key_access: /^\.([a-z_][a-z_\d]*)/i,
        index_access: /^\[(\d+)\]/,
        sign: /^[\+\-]/
    };

    function sprintf() {
        var key = arguments[0],
            cache = sprintf.cache;
        if (!(cache[key] && cache.hasOwnProperty(key))) {
            cache[key] = sprintf.parse(key);
        }
        return sprintf.format.call(null, cache[key], arguments);
    }

    sprintf.format = function (parse_tree, argv) {
        var cursor = 1,
            tree_length = parse_tree.length,
            node_type = "",
            arg,
            output = [],
            i,
            k,
            match,
            pad,
            pad_character,
            pad_length,
            is_positive = true,
            sign = "";
        for (i = 0; i < tree_length; i++) {
            node_type = get_type(parse_tree[i]);
            if (node_type === "string") {
                output[output.length] = parse_tree[i];
            } else if (node_type === "array") {
                match = parse_tree[i]; // convenience purposes only
                if (match[2]) {
                    // keyword argument
                    arg = argv[cursor];
                    for (k = 0; k < match[2].length; k++) {
                        if (!arg.hasOwnProperty(match[2][k])) {
                            throw new Error(sprintf("[sprintf] property '%s' does not exist", match[2][k]));
                        }
                        arg = arg[match[2][k]];
                    }
                } else if (match[1]) {
                    // positional argument (explicit)
                    arg = argv[match[1]];
                } else {
                    // positional argument (implicit)
                    arg = argv[cursor++];
                }

                if (get_type(arg) == "function") {
                    arg = arg();
                }

                if (re.not_string.test(match[8]) && re.not_json.test(match[8]) && get_type(arg) != "number" && isNaN(arg)) {
                    throw new TypeError(sprintf("[sprintf] expecting number but found %s", get_type(arg)));
                }

                if (re.number.test(match[8])) {
                    is_positive = arg >= 0;
                }

                switch (match[8]) {
                    case "b":
                        arg = arg.toString(2);
                        break;
                    case "c":
                        arg = String.fromCharCode(arg);
                        break;
                    case "d":
                    case "i":
                        arg = parseInt(arg, 10);
                        break;
                    case "j":
                        arg = JSON.stringify(arg, null, match[6] ? parseInt(match[6]) : 0);
                        break;
                    case "e":
                        arg = match[7] ? arg.toExponential(match[7]) : arg.toExponential();
                        break;
                    case "f":
                        arg = match[7] ? parseFloat(arg).toFixed(match[7]) : parseFloat(arg);
                        break;
                    case "g":
                        arg = match[7] ? parseFloat(arg).toPrecision(match[7]) : parseFloat(arg);
                        break;
                    case "o":
                        arg = arg.toString(8);
                        break;
                    case "s":
                        arg = (arg = String(arg)) && match[7] ? arg.substring(0, match[7]) : arg;
                        break;
                    case "u":
                        arg = arg >>> 0;
                        break;
                    case "x":
                        arg = arg.toString(16);
                        break;
                    case "X":
                        arg = arg.toString(16).toUpperCase();
                        break;
                }
                if (re.json.test(match[8])) {
                    output[output.length] = arg;
                } else {
                    if (re.number.test(match[8]) && (!is_positive || match[3])) {
                        sign = is_positive ? "+" : "-";
                        arg = arg.toString().replace(re.sign, "");
                    } else {
                        sign = "";
                    }
                    pad_character = match[4] ? match[4] === "0" ? "0" : match[4].charAt(1) : " ";
                    pad_length = match[6] - (sign + arg).length;
                    pad = match[6] ? pad_length > 0 ? str_repeat(pad_character, pad_length) : "" : "";
                    output[output.length] = match[5] ? sign + arg + pad : pad_character === "0" ? sign + pad + arg : pad + sign + arg;
                }
            }
        }
        return output.join("");
    };

    sprintf.cache = {};

    sprintf.parse = function (fmt) {
        var _fmt = fmt,
            match = [],
            parse_tree = [],
            arg_names = 0;
        while (_fmt) {
            if ((match = re.text.exec(_fmt)) !== null) {
                parse_tree[parse_tree.length] = match[0];
            } else if ((match = re.modulo.exec(_fmt)) !== null) {
                parse_tree[parse_tree.length] = "%";
            } else if ((match = re.placeholder.exec(_fmt)) !== null) {
                if (match[2]) {
                    arg_names |= 1;
                    var field_list = [],
                        replacement_field = match[2],
                        field_match = [];
                    if ((field_match = re.key.exec(replacement_field)) !== null) {
                        field_list[field_list.length] = field_match[1];
                        while ((replacement_field = replacement_field.substring(field_match[0].length)) !== "") {
                            if ((field_match = re.key_access.exec(replacement_field)) !== null) {
                                field_list[field_list.length] = field_match[1];
                            } else if ((field_match = re.index_access.exec(replacement_field)) !== null) {
                                field_list[field_list.length] = field_match[1];
                            } else {
                                throw new SyntaxError("[sprintf] failed to parse named argument key");
                            }
                        }
                    } else {
                        throw new SyntaxError("[sprintf] failed to parse named argument key");
                    }
                    match[2] = field_list;
                } else {
                    arg_names |= 2;
                }
                if (arg_names === 3) {
                    throw new Error("[sprintf] mixing positional and named placeholders is not (yet) supported");
                }
                parse_tree[parse_tree.length] = match;
            } else {
                throw new SyntaxError("[sprintf] unexpected placeholder");
            }
            _fmt = _fmt.substring(match[0].length);
        }
        return parse_tree;
    };

    function vsprintf(fmt, argv, _argv) {
        _argv = (argv || []).slice(0);
        _argv.splice(0, 0, fmt);
        return sprintf.apply(null, _argv);
    }

    /**
     * helpers
     */
    function get_type(variable) {
        return Object.prototype.toString.call(variable).slice(8, -1).toLowerCase();
    }

    function str_repeat(input, multiplier) {
        return Array(multiplier + 1).join(input);
    }

    var index = {
      name: 'sprintf',
      type: 'postProcessor',

      process: function process(value, key, options) {
        if (!options.sprintf) return value;

        if (Object.prototype.toString.apply(options.sprintf) === '[object Array]') {
          return vsprintf(value, options.sprintf);
        } else if (babelHelpers.typeof(options.sprintf) === 'object') {
          return sprintf(value, options.sprintf);
        }

        return value;
      },
      overloadTranslationOptionHandler: function overloadTranslationOptionHandler(args) {
        var values = [];

        for (var i = 1; i < args.length; i++) {
          values.push(args[i]);
        }

        return {
          postProcess: 'sprintf',
          sprintf: values
        };
      }
    };

    return index;

}));

/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

(function (global, factory) {
   true ? module.exports = factory() :
  typeof define === 'function' && define.amd ? define(factory) :
  (global.i18nextBrowserLanguageDetector = factory());
}(this, function () { 'use strict';

  var babelHelpers = {};

  babelHelpers.classCallCheck = function (instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  };

  babelHelpers.createClass = function () {
    function defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor) descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    return function (Constructor, protoProps, staticProps) {
      if (protoProps) defineProperties(Constructor.prototype, protoProps);
      if (staticProps) defineProperties(Constructor, staticProps);
      return Constructor;
    };
  }();

  babelHelpers;

  var arr = [];
  var each = arr.forEach;
  var slice = arr.slice;

  function defaults(obj) {
    each.call(slice.call(arguments, 1), function (source) {
      if (source) {
        for (var prop in source) {
          if (obj[prop] === undefined) obj[prop] = source[prop];
        }
      }
    });
    return obj;
  }

  var cookie = {
    create: function create(name, value, minutes, domain) {
      var expires = void 0;
      if (minutes) {
        var date = new Date();
        date.setTime(date.getTime() + minutes * 60 * 1000);
        expires = '; expires=' + date.toGMTString();
      } else expires = '';
      domain = domain ? 'domain=' + domain + ';' : '';
      document.cookie = name + '=' + value + expires + ';' + domain + 'path=/';
    },

    read: function read(name) {
      var nameEQ = name + '=';
      var ca = document.cookie.split(';');
      for (var i = 0; i < ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0) === ' ') {
          c = c.substring(1, c.length);
        }if (c.indexOf(nameEQ) === 0) return c.substring(nameEQ.length, c.length);
      }
      return null;
    },

    remove: function remove(name) {
      this.create(name, '', -1);
    }
  };

  var cookie$1 = {
    name: 'cookie',

    lookup: function lookup(options) {
      var found = void 0;

      if (options.lookupCookie && typeof document !== 'undefined') {
        var c = cookie.read(options.lookupCookie);
        if (c) found = c;
      }

      return found;
    },
    cacheUserLanguage: function cacheUserLanguage(lng, options) {
      if (options.lookupCookie && typeof document !== 'undefined') {
        cookie.create(options.lookupCookie, lng, options.cookieMinutes, options.cookieDomain);
      }
    }
  };

  var querystring = {
    name: 'querystring',

    lookup: function lookup(options) {
      var found = void 0;

      if (typeof window !== 'undefined') {
        var query = window.location.search.substring(1);
        var params = query.split('&');
        for (var i = 0; i < params.length; i++) {
          var pos = params[i].indexOf('=');
          if (pos > 0) {
            var key = params[i].substring(0, pos);
            if (key === options.lookupQuerystring) {
              found = params[i].substring(pos + 1);
            }
          }
        }
      }

      return found;
    }
  };

  var hasLocalStorageSupport = void 0;
  try {
    hasLocalStorageSupport = window !== 'undefined' && window.localStorage !== null;
    var testKey = 'i18next.translate.boo';
    window.localStorage.setItem(testKey, 'foo');
    window.localStorage.removeItem(testKey);
  } catch (e) {
    hasLocalStorageSupport = false;
  }

  var localStorage = {
    name: 'localStorage',

    lookup: function lookup(options) {
      var found = void 0;

      if (options.lookupLocalStorage && hasLocalStorageSupport) {
        var lng = window.localStorage.getItem(options.lookupLocalStorage);
        if (lng) found = lng;
      }

      return found;
    },
    cacheUserLanguage: function cacheUserLanguage(lng, options) {
      if (options.lookupLocalStorage && hasLocalStorageSupport) {
        window.localStorage.setItem(options.lookupLocalStorage, lng);
      }
    }
  };

  var navigator$1 = {
    name: 'navigator',

    lookup: function lookup(options) {
      var found = [];

      if (typeof navigator !== 'undefined') {
        if (navigator.languages) {
          // chrome only; not an array, so can't use .push.apply instead of iterating
          for (var i = 0; i < navigator.languages.length; i++) {
            found.push(navigator.languages[i]);
          }
        }
        if (navigator.userLanguage) {
          found.push(navigator.userLanguage);
        }
        if (navigator.language) {
          found.push(navigator.language);
        }
      }

      return found.length > 0 ? found : undefined;
    }
  };

  var htmlTag = {
    name: 'htmlTag',

    lookup: function lookup(options) {
      var found = void 0;
      var htmlTag = options.htmlTag || (typeof document !== 'undefined' ? document.documentElement : null);

      if (htmlTag && typeof htmlTag.getAttribute === 'function') {
        found = htmlTag.getAttribute('lang');
      }

      return found;
    }
  };

  function getDefaults() {
    return {
      order: ['querystring', 'cookie', 'localStorage', 'navigator', 'htmlTag'],
      lookupQuerystring: 'lng',
      lookupCookie: 'i18next',
      lookupLocalStorage: 'i18nextLng',

      // cache user language
      caches: ['localStorage'],
      excludeCacheFor: ['cimode']
      //cookieMinutes: 10,
      //cookieDomain: 'myDomain'
    };
  }

  var Browser = function () {
    function Browser(services) {
      var options = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];
      babelHelpers.classCallCheck(this, Browser);

      this.type = 'languageDetector';
      this.detectors = {};

      this.init(services, options);
    }

    babelHelpers.createClass(Browser, [{
      key: 'init',
      value: function init(services) {
        var options = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];
        var i18nOptions = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];

        this.services = services;
        this.options = defaults(options, this.options || {}, getDefaults());
        this.i18nOptions = i18nOptions;

        this.addDetector(cookie$1);
        this.addDetector(querystring);
        this.addDetector(localStorage);
        this.addDetector(navigator$1);
        this.addDetector(htmlTag);
      }
    }, {
      key: 'addDetector',
      value: function addDetector(detector) {
        this.detectors[detector.name] = detector;
      }
    }, {
      key: 'detect',
      value: function detect(detectionOrder) {
        var _this = this;

        if (!detectionOrder) detectionOrder = this.options.order;

        var detected = [];
        detectionOrder.forEach(function (detectorName) {
          if (_this.detectors[detectorName]) {
            var lookup = _this.detectors[detectorName].lookup(_this.options);
            if (lookup && typeof lookup === 'string') lookup = [lookup];
            if (lookup) detected = detected.concat(lookup);
          }
        });

        var found = void 0;
        detected.forEach(function (lng) {
          if (found) return;
          var cleanedLng = _this.services.languageUtils.formatLanguageCode(lng);
          if (_this.services.languageUtils.isWhitelisted(cleanedLng)) found = cleanedLng;
        });

        return found || this.i18nOptions.fallbackLng[0];
      }
    }, {
      key: 'cacheUserLanguage',
      value: function cacheUserLanguage(lng, caches) {
        var _this2 = this;

        if (!caches) caches = this.options.caches;
        if (!caches) return;
        if (this.options.excludeCacheFor && this.options.excludeCacheFor.indexOf(lng) > -1) return;
        caches.forEach(function (cacheName) {
          if (_this2.detectors[cacheName]) _this2.detectors[cacheName].cacheUserLanguage(lng, _this2.options);
        });
      }
    }]);
    return Browser;
  }();

  Browser.type = 'languageDetector';

  return Browser;

}));

/***/ })
/******/ ]);
});
/*!
 * cdp.framework.jqm.js 2.1.0
 *
 * Date: 2017-11-06T05:35:57.958Z
 */

(function webpackUniversalModuleDefinition(root, factory) {
    if(typeof exports === 'object' && typeof module === 'object')
        module.exports = factory(require("jquery"), require("cdp.i18n"), require("backbone"));
    else if(typeof define === 'function' && define.amd)
        define("cdp.framework.jqm",["jquery", "cdp.i18n", "backbone"], factory);
    else if(typeof exports === 'object')
        exports["Framework"] = factory(require("jquery"), require("cdp.i18n"), require("backbone"));
    else
        root["CDP"] = root["CDP"] || {}, root["CDP"]["Framework"] = factory(root["jQuery"], root["CDP"], root["Backbone"]);
})(this, function(__WEBPACK_EXTERNAL_MODULE_0__, __WEBPACK_EXTERNAL_MODULE_3__, __WEBPACK_EXTERNAL_MODULE_4__) {
return /******/ (function(modules) { // webpackBootstrap
/******/     // The module cache
/******/     var installedModules = {};
/******/
/******/     // The require function
/******/     function __webpack_require__(moduleId) {
/******/
/******/         // Check if module is in cache
/******/         if(installedModules[moduleId]) {
/******/             return installedModules[moduleId].exports;
/******/         }
/******/         // Create a new module (and put it into the cache)
/******/         var module = installedModules[moduleId] = {
/******/             i: moduleId,
/******/             l: false,
/******/             exports: {}
/******/         };
/******/
/******/         // Execute the module function
/******/         modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/         // Flag the module as loaded
/******/         module.l = true;
/******/
/******/         // Return the exports of the module
/******/         return module.exports;
/******/     }
/******/
/******/
/******/     // expose the modules object (__webpack_modules__)
/******/     __webpack_require__.m = modules;
/******/
/******/     // expose the module cache
/******/     __webpack_require__.c = installedModules;
/******/
/******/     // define getter function for harmony exports
/******/     __webpack_require__.d = function(exports, name, getter) {
/******/         if(!__webpack_require__.o(exports, name)) {
/******/             Object.defineProperty(exports, name, {
/******/                 configurable: false,
/******/                 enumerable: true,
/******/                 get: getter
/******/             });
/******/         }
/******/     };
/******/
/******/     // getDefaultExport function for compatibility with non-harmony modules
/******/     __webpack_require__.n = function(module) {
/******/         var getter = module && module.__esModule ?
/******/             function getDefault() { return module['default']; } :
/******/             function getModuleExports() { return module; };
/******/         __webpack_require__.d(getter, 'a', getter);
/******/         return getter;
/******/     };
/******/
/******/     // Object.prototype.hasOwnProperty.call
/******/     __webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/     // __webpack_public_path__
/******/     __webpack_require__.p = "";
/******/
/******/     // Load entry module and return exports
/******/     return __webpack_require__(__webpack_require__.s = 2);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_0__;

/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*** IMPORTS FROM imports-loader ***/
(function() {

/*!
* jQuery Mobile 1.4.5
* Git HEAD hash: 68e55e78b292634d3991c795f06f5e37a512decc <> Date: Fri Oct 31 2014 17:33:30 UTC
* http://jquerymobile.com
*
* Copyright 2010, 2014 jQuery Foundation, Inc. and othercontributors
* Released under the MIT license.
* http://jquery.org/license
*
*/


(function ( root, doc, factory ) {
    if ( true ) {
        // AMD. Register as an anonymous module.
        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [ __webpack_require__(0) ], __WEBPACK_AMD_DEFINE_RESULT__ = function ( $ ) {
            factory( $, root, doc );
            return $.mobile;
        }.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
                __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else {
        // Browser globals
        factory( root.jQuery, root, doc );
    }
}( this, document, function ( jQuery, window, document, undefined ) {
(function( $ ) {
    $.mobile = {};
}( jQuery ));

/*!
 * jQuery UI Core c0ab71056b936627e8a7821f03c044aec6280a40
 * http://jqueryui.com
 *
 * Copyright 2013 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/category/ui-core/
 */
(function( $, undefined ) {

var uuid = 0,
    runiqueId = /^ui-id-\d+$/;

// $.ui might exist from components with no dependencies, e.g., $.ui.position
$.ui = $.ui || {};

$.extend( $.ui, {
    version: "c0ab71056b936627e8a7821f03c044aec6280a40",

    keyCode: {
        BACKSPACE: 8,
        COMMA: 188,
        DELETE: 46,
        DOWN: 40,
        END: 35,
        ENTER: 13,
        ESCAPE: 27,
        HOME: 36,
        LEFT: 37,
        PAGE_DOWN: 34,
        PAGE_UP: 33,
        PERIOD: 190,
        RIGHT: 39,
        SPACE: 32,
        TAB: 9,
        UP: 38
    }
});

// plugins
$.fn.extend({
    focus: (function( orig ) {
        return function( delay, fn ) {
            return typeof delay === "number" ?
                this.each(function() {
                    var elem = this;
                    setTimeout(function() {
                        $( elem ).focus();
                        if ( fn ) {
                            fn.call( elem );
                        }
                    }, delay );
                }) :
                orig.apply( this, arguments );
        };
    })( $.fn.focus ),

    scrollParent: function() {
        var scrollParent;
        if (($.ui.ie && (/(static|relative)/).test(this.css("position"))) || (/absolute/).test(this.css("position"))) {
            scrollParent = this.parents().filter(function() {
                return (/(relative|absolute|fixed)/).test($.css(this,"position")) && (/(auto|scroll)/).test($.css(this,"overflow")+$.css(this,"overflow-y")+$.css(this,"overflow-x"));
            }).eq(0);
        } else {
            scrollParent = this.parents().filter(function() {
                return (/(auto|scroll)/).test($.css(this,"overflow")+$.css(this,"overflow-y")+$.css(this,"overflow-x"));
            }).eq(0);
        }

        return ( /fixed/ ).test( this.css( "position") ) || !scrollParent.length ? $( this[ 0 ].ownerDocument || document ) : scrollParent;
    },

    uniqueId: function() {
        return this.each(function() {
            if ( !this.id ) {
                this.id = "ui-id-" + (++uuid);
            }
        });
    },

    removeUniqueId: function() {
        return this.each(function() {
            if ( runiqueId.test( this.id ) ) {
                $( this ).removeAttr( "id" );
            }
        });
    }
});

// selectors
function focusable( element, isTabIndexNotNaN ) {
    var map, mapName, img,
        nodeName = element.nodeName.toLowerCase();
    if ( "area" === nodeName ) {
        map = element.parentNode;
        mapName = map.name;
        if ( !element.href || !mapName || map.nodeName.toLowerCase() !== "map" ) {
            return false;
        }
        img = $( "img[usemap=#" + mapName + "]" )[0];
        return !!img && visible( img );
    }
    return ( /input|select|textarea|button|object/.test( nodeName ) ?
        !element.disabled :
        "a" === nodeName ?
            element.href || isTabIndexNotNaN :
            isTabIndexNotNaN) &&
        // the element and all of its ancestors must be visible
        visible( element );
}

function visible( element ) {
    return $.expr.filters.visible( element ) &&
        !$( element ).parents().addBack().filter(function() {
            return $.css( this, "visibility" ) === "hidden";
        }).length;
}

$.extend( $.expr[ ":" ], {
    data: $.expr.createPseudo ?
        $.expr.createPseudo(function( dataName ) {
            return function( elem ) {
                return !!$.data( elem, dataName );
            };
        }) :
        // support: jQuery <1.8
        function( elem, i, match ) {
            return !!$.data( elem, match[ 3 ] );
        },

    focusable: function( element ) {
        return focusable( element, !isNaN( $.attr( element, "tabindex" ) ) );
    },

    tabbable: function( element ) {
        var tabIndex = $.attr( element, "tabindex" ),
            isTabIndexNaN = isNaN( tabIndex );
        return ( isTabIndexNaN || tabIndex >= 0 ) && focusable( element, !isTabIndexNaN );
    }
});

// support: jQuery <1.8
if ( !$( "<a>" ).outerWidth( 1 ).jquery ) {
    $.each( [ "Width", "Height" ], function( i, name ) {
        var side = name === "Width" ? [ "Left", "Right" ] : [ "Top", "Bottom" ],
            type = name.toLowerCase(),
            orig = {
                innerWidth: $.fn.innerWidth,
                innerHeight: $.fn.innerHeight,
                outerWidth: $.fn.outerWidth,
                outerHeight: $.fn.outerHeight
            };

        function reduce( elem, size, border, margin ) {
            $.each( side, function() {
                size -= parseFloat( $.css( elem, "padding" + this ) ) || 0;
                if ( border ) {
                    size -= parseFloat( $.css( elem, "border" + this + "Width" ) ) || 0;
                }
                if ( margin ) {
                    size -= parseFloat( $.css( elem, "margin" + this ) ) || 0;
                }
            });
            return size;
        }

        $.fn[ "inner" + name ] = function( size ) {
            if ( size === undefined ) {
                return orig[ "inner" + name ].call( this );
            }

            return this.each(function() {
                $( this ).css( type, reduce( this, size ) + "px" );
            });
        };

        $.fn[ "outer" + name] = function( size, margin ) {
            if ( typeof size !== "number" ) {
                return orig[ "outer" + name ].call( this, size );
            }

            return this.each(function() {
                $( this).css( type, reduce( this, size, true, margin ) + "px" );
            });
        };
    });
}

// support: jQuery <1.8
if ( !$.fn.addBack ) {
    $.fn.addBack = function( selector ) {
        return this.add( selector == null ?
            this.prevObject : this.prevObject.filter( selector )
        );
    };
}

// support: jQuery 1.6.1, 1.6.2 (http://bugs.jquery.com/ticket/9413)
if ( $( "<a>" ).data( "a-b", "a" ).removeData( "a-b" ).data( "a-b" ) ) {
    $.fn.removeData = (function( removeData ) {
        return function( key ) {
            if ( arguments.length ) {
                return removeData.call( this, $.camelCase( key ) );
            } else {
                return removeData.call( this );
            }
        };
    })( $.fn.removeData );
}





// deprecated
$.ui.ie = !!/msie [\w.]+/.exec( navigator.userAgent.toLowerCase() );

$.support.selectstart = "onselectstart" in document.createElement( "div" );
$.fn.extend({
    disableSelection: function() {
        return this.bind( ( $.support.selectstart ? "selectstart" : "mousedown" ) +
            ".ui-disableSelection", function( event ) {
                event.preventDefault();
            });
    },

    enableSelection: function() {
        return this.unbind( ".ui-disableSelection" );
    },

    zIndex: function( zIndex ) {
        if ( zIndex !== undefined ) {
            return this.css( "zIndex", zIndex );
        }

        if ( this.length ) {
            var elem = $( this[ 0 ] ), position, value;
            while ( elem.length && elem[ 0 ] !== document ) {
                // Ignore z-index if position is set to a value where z-index is ignored by the browser
                // This makes behavior of this function consistent across browsers
                // WebKit always returns auto if the element is positioned
                position = elem.css( "position" );
                if ( position === "absolute" || position === "relative" || position === "fixed" ) {
                    // IE returns 0 when zIndex is not specified
                    // other browsers return a string
                    // we ignore the case of nested elements with an explicit value of 0
                    // <div style="z-index: -10;"><div style="z-index: 0;"></div></div>
                    value = parseInt( elem.css( "zIndex" ), 10 );
                    if ( !isNaN( value ) && value !== 0 ) {
                        return value;
                    }
                }
                elem = elem.parent();
            }
        }

        return 0;
    }
});

// $.ui.plugin is deprecated. Use $.widget() extensions instead.
$.ui.plugin = {
    add: function( module, option, set ) {
        var i,
            proto = $.ui[ module ].prototype;
        for ( i in set ) {
            proto.plugins[ i ] = proto.plugins[ i ] || [];
            proto.plugins[ i ].push( [ option, set[ i ] ] );
        }
    },
    call: function( instance, name, args, allowDisconnected ) {
        var i,
            set = instance.plugins[ name ];

        if ( !set ) {
            return;
        }

        if ( !allowDisconnected && ( !instance.element[ 0 ].parentNode || instance.element[ 0 ].parentNode.nodeType === 11 ) ) {
            return;
        }

        for ( i = 0; i < set.length; i++ ) {
            if ( instance.options[ set[ i ][ 0 ] ] ) {
                set[ i ][ 1 ].apply( instance.element, args );
            }
        }
    }
};

})( jQuery );

(function( $, window, undefined ) {

    // Subtract the height of external toolbars from the page height, if the page does not have
    // internal toolbars of the same type. We take care to use the widget options if we find a
    // widget instance and the element's data-attributes otherwise.
    var compensateToolbars = function( page, desiredHeight ) {
        var pageParent = page.parent(),
            toolbarsAffectingHeight = [],

            // We use this function to filter fixed toolbars with option updatePagePadding set to
            // true (which is the default) from our height subtraction, because fixed toolbars with
            // option updatePagePadding set to true compensate for their presence by adding padding
            // to the active page. We want to avoid double-counting by also subtracting their
            // height from the desired page height.
            noPadders = function() {
                var theElement = $( this ),
                    widgetOptions = $.mobile.toolbar && theElement.data( "mobile-toolbar" ) ?
                        theElement.toolbar( "option" ) : {
                            position: theElement.attr( "data-" + $.mobile.ns + "position" ),
                            updatePagePadding: ( theElement.attr( "data-" + $.mobile.ns +
                                "update-page-padding" ) !== false )
                        };

                return !( widgetOptions.position === "fixed" &&
                    widgetOptions.updatePagePadding === true );
            },
            externalHeaders = pageParent.children( ":jqmData(role='header')" ).filter( noPadders ),
            internalHeaders = page.children( ":jqmData(role='header')" ),
            externalFooters = pageParent.children( ":jqmData(role='footer')" ).filter( noPadders ),
            internalFooters = page.children( ":jqmData(role='footer')" );

        // If we have no internal headers, but we do have external headers, then their height
        // reduces the page height
        if ( internalHeaders.length === 0 && externalHeaders.length > 0 ) {
            toolbarsAffectingHeight = toolbarsAffectingHeight.concat( externalHeaders.toArray() );
        }

        // If we have no internal footers, but we do have external footers, then their height
        // reduces the page height
        if ( internalFooters.length === 0 && externalFooters.length > 0 ) {
            toolbarsAffectingHeight = toolbarsAffectingHeight.concat( externalFooters.toArray() );
        }

        $.each( toolbarsAffectingHeight, function( index, value ) {
            desiredHeight -= $( value ).outerHeight();
        });

        // Height must be at least zero
        return Math.max( 0, desiredHeight );
    };

    $.extend( $.mobile, {
        // define the window and the document objects
        window: $( window ),
        document: $( document ),

        // TODO: Remove and use $.ui.keyCode directly
        keyCode: $.ui.keyCode,

        // Place to store various widget extensions
        behaviors: {},

        // Scroll page vertically: scroll to 0 to hide iOS address bar, or pass a Y value
        silentScroll: function( ypos ) {
            if ( $.type( ypos ) !== "number" ) {
                ypos = $.mobile.defaultHomeScroll;
            }

            // prevent scrollstart and scrollstop events
            $.event.special.scrollstart.enabled = false;

            setTimeout(function() {
                window.scrollTo( 0, ypos );
                $.mobile.document.trigger( "silentscroll", { x: 0, y: ypos });
            }, 20 );

            setTimeout(function() {
                $.event.special.scrollstart.enabled = true;
            }, 150 );
        },

        getClosestBaseUrl: function( ele )    {
            // Find the closest page and extract out its url.
            var url = $( ele ).closest( ".ui-page" ).jqmData( "url" ),
                base = $.mobile.path.documentBase.hrefNoHash;

            if ( !$.mobile.dynamicBaseEnabled || !url || !$.mobile.path.isPath( url ) ) {
                url = base;
            }

            return $.mobile.path.makeUrlAbsolute( url, base );
        },
        removeActiveLinkClass: function( forceRemoval ) {
            if ( !!$.mobile.activeClickedLink &&
                ( !$.mobile.activeClickedLink.closest( "." + $.mobile.activePageClass ).length ||
                    forceRemoval ) ) {

                $.mobile.activeClickedLink.removeClass( $.mobile.activeBtnClass );
            }
            $.mobile.activeClickedLink = null;
        },

        // DEPRECATED in 1.4
        // Find the closest parent with a theme class on it. Note that
        // we are not using $.fn.closest() on purpose here because this
        // method gets called quite a bit and we need it to be as fast
        // as possible.
        getInheritedTheme: function( el, defaultTheme ) {
            var e = el[ 0 ],
                ltr = "",
                re = /ui-(bar|body|overlay)-([a-z])\b/,
                c, m;
            while ( e ) {
                c = e.className || "";
                if ( c && ( m = re.exec( c ) ) && ( ltr = m[ 2 ] ) ) {
                    // We found a parent with a theme class
                    // on it so bail from this loop.
                    break;
                }

                e = e.parentNode;
            }
            // Return the theme letter we found, if none, return the
            // specified default.
            return ltr || defaultTheme || "a";
        },

        enhanceable: function( elements ) {
            return this.haveParents( elements, "enhance" );
        },

        hijackable: function( elements ) {
            return this.haveParents( elements, "ajax" );
        },

        haveParents: function( elements, attr ) {
            if ( !$.mobile.ignoreContentEnabled ) {
                return elements;
            }

            var count = elements.length,
                $newSet = $(),
                e, $element, excluded,
                i, c;

            for ( i = 0; i < count; i++ ) {
                $element = elements.eq( i );
                excluded = false;
                e = elements[ i ];

                while ( e ) {
                    c = e.getAttribute ? e.getAttribute( "data-" + $.mobile.ns + attr ) : "";

                    if ( c === "false" ) {
                        excluded = true;
                        break;
                    }

                    e = e.parentNode;
                }

                if ( !excluded ) {
                    $newSet = $newSet.add( $element );
                }
            }

            return $newSet;
        },

        getScreenHeight: function() {
            // Native innerHeight returns more accurate value for this across platforms,
            // jQuery version is here as a normalized fallback for platforms like Symbian
            return window.innerHeight || $.mobile.window.height();
        },

        //simply set the active page's minimum height to screen height, depending on orientation
        resetActivePageHeight: function( height ) {
            var page = $( "." + $.mobile.activePageClass ),
                pageHeight = page.height(),
                pageOuterHeight = page.outerHeight( true );

            height = compensateToolbars( page,
                ( typeof height === "number" ) ? height : $.mobile.getScreenHeight() );

            // Remove any previous min-height setting
            page.css( "min-height", "" );

            // Set the minimum height only if the height as determined by CSS is insufficient
            if ( page.height() < height ) {
                page.css( "min-height", height - ( pageOuterHeight - pageHeight ) );
            }
        },

        loading: function() {
            // If this is the first call to this function, instantiate a loader widget
            var loader = this.loading._widget || $( $.mobile.loader.prototype.defaultHtml ).loader(),

                // Call the appropriate method on the loader
                returnValue = loader.loader.apply( loader, arguments );

            // Make sure the loader is retained for future calls to this function.
            this.loading._widget = loader;

            return returnValue;
        }
    });

    $.addDependents = function( elem, newDependents ) {
        var $elem = $( elem ),
            dependents = $elem.jqmData( "dependents" ) || $();

        $elem.jqmData( "dependents", $( dependents ).add( newDependents ) );
    };

    // plugins
    $.fn.extend({
        removeWithDependents: function() {
            $.removeWithDependents( this );
        },

        // Enhance child elements
        enhanceWithin: function() {
            var index,
                widgetElements = {},
                keepNative = $.mobile.page.prototype.keepNativeSelector(),
                that = this;

            // Add no js class to elements
            if ( $.mobile.nojs ) {
                $.mobile.nojs( this );
            }

            // Bind links for ajax nav
            if ( $.mobile.links ) {
                $.mobile.links( this );
            }

            // Degrade inputs for styleing
            if ( $.mobile.degradeInputsWithin ) {
                $.mobile.degradeInputsWithin( this );
            }

            // Run buttonmarkup
            if ( $.fn.buttonMarkup ) {
                this.find( $.fn.buttonMarkup.initSelector ).not( keepNative )
                .jqmEnhanceable().buttonMarkup();
            }

            // Add classes for fieldContain
            if ( $.fn.fieldcontain ) {
                this.find( ":jqmData(role='fieldcontain')" ).not( keepNative )
                .jqmEnhanceable().fieldcontain();
            }

            // Enhance widgets
            $.each( $.mobile.widgets, function( name, constructor ) {

                // If initSelector not false find elements
                if ( constructor.initSelector ) {

                    // Filter elements that should not be enhanced based on parents
                    var elements = $.mobile.enhanceable( that.find( constructor.initSelector ) );

                    // If any matching elements remain filter ones with keepNativeSelector
                    if ( elements.length > 0 ) {

                        // $.mobile.page.prototype.keepNativeSelector is deprecated this is just for backcompat
                        // Switch to $.mobile.keepNative in 1.5 which is just a value not a function
                        elements = elements.not( keepNative );
                    }

                    // Enhance whatever is left
                    if ( elements.length > 0 ) {
                        widgetElements[ constructor.prototype.widgetName ] = elements;
                    }
                }
            });

            for ( index in widgetElements ) {
                widgetElements[ index ][ index ]();
            }

            return this;
        },

        addDependents: function( newDependents ) {
            $.addDependents( this, newDependents );
        },

        // note that this helper doesn't attempt to handle the callback
        // or setting of an html element's text, its only purpose is
        // to return the html encoded version of the text in all cases. (thus the name)
        getEncodedText: function() {
            return $( "<a>" ).text( this.text() ).html();
        },

        // fluent helper function for the mobile namespaced equivalent
        jqmEnhanceable: function() {
            return $.mobile.enhanceable( this );
        },

        jqmHijackable: function() {
            return $.mobile.hijackable( this );
        }
    });

    $.removeWithDependents = function( nativeElement ) {
        var element = $( nativeElement );

        ( element.jqmData( "dependents" ) || $() ).remove();
        element.remove();
    };
    $.addDependents = function( nativeElement, newDependents ) {
        var element = $( nativeElement ),
            dependents = element.jqmData( "dependents" ) || $();

        element.jqmData( "dependents", $( dependents ).add( newDependents ) );
    };

    $.find.matches = function( expr, set ) {
        return $.find( expr, null, null, set );
    };

    $.find.matchesSelector = function( node, expr ) {
        return $.find( expr, null, null, [ node ] ).length > 0;
    };

})( jQuery, this );

(function( $, window, undefined ) {
    $.extend( $.mobile, {

        // Version of the jQuery Mobile Framework
        version: "1.4.5",

        // Deprecated and no longer used in 1.4 remove in 1.5
        // Define the url parameter used for referencing widget-generated sub-pages.
        // Translates to example.html&ui-page=subpageIdentifier
        // hash segment before &ui-page= is used to make Ajax request
        subPageUrlKey: "ui-page",

        hideUrlBar: true,

        // Keepnative Selector
        keepNative: ":jqmData(role='none'), :jqmData(role='nojs')",

        // Deprecated in 1.4 remove in 1.5
        // Class assigned to page currently in view, and during transitions
        activePageClass: "ui-page-active",

        // Deprecated in 1.4 remove in 1.5
        // Class used for "active" button state, from CSS framework
        activeBtnClass: "ui-btn-active",

        // Deprecated in 1.4 remove in 1.5
        // Class used for "focus" form element state, from CSS framework
        focusClass: "ui-focus",

        // Automatically handle clicks and form submissions through Ajax, when same-domain
        ajaxEnabled: true,

        // Automatically load and show pages based on location.hash
        hashListeningEnabled: true,

        // disable to prevent jquery from bothering with links
        linkBindingEnabled: true,

        // Set default page transition - 'none' for no transitions
        defaultPageTransition: "fade",

        // Set maximum window width for transitions to apply - 'false' for no limit
        maxTransitionWidth: false,

        // Minimum scroll distance that will be remembered when returning to a page
        // Deprecated remove in 1.5
        minScrollBack: 0,

        // Set default dialog transition - 'none' for no transitions
        defaultDialogTransition: "pop",

        // Error response message - appears when an Ajax page request fails
        pageLoadErrorMessage: "Error Loading Page",

        // For error messages, which theme does the box use?
        pageLoadErrorMessageTheme: "a",

        // replace calls to window.history.back with phonegaps navigation helper
        // where it is provided on the window object
        phonegapNavigationEnabled: false,

        //automatically initialize the DOM when it's ready
        autoInitializePage: true,

        pushStateEnabled: true,

        // allows users to opt in to ignoring content by marking a parent element as
        // data-ignored
        ignoreContentEnabled: false,

        buttonMarkup: {
            hoverDelay: 200
        },

        // disable the alteration of the dynamic base tag or links in the case
        // that a dynamic base tag isn't supported
        dynamicBaseEnabled: true,

        // default the property to remove dependency on assignment in init module
        pageContainer: $(),

        //enable cross-domain page support
        allowCrossDomainPages: false,

        dialogHashKey: "&ui-state=dialog"
    });
})( jQuery, this );

/*!
 * jQuery UI Widget c0ab71056b936627e8a7821f03c044aec6280a40
 * http://jqueryui.com
 *
 * Copyright 2013 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/jQuery.widget/
 */
(function( $, undefined ) {

var uuid = 0,
    slice = Array.prototype.slice,
    _cleanData = $.cleanData;
$.cleanData = function( elems ) {
    for ( var i = 0, elem; (elem = elems[i]) != null; i++ ) {
        try {
            $( elem ).triggerHandler( "remove" );
        // http://bugs.jquery.com/ticket/8235
        } catch( e ) {}
    }
    _cleanData( elems );
};

$.widget = function( name, base, prototype ) {
    var fullName, existingConstructor, constructor, basePrototype,
        // proxiedPrototype allows the provided prototype to remain unmodified
        // so that it can be used as a mixin for multiple widgets (#8876)
        proxiedPrototype = {},
        namespace = name.split( "." )[ 0 ];

    name = name.split( "." )[ 1 ];
    fullName = namespace + "-" + name;

    if ( !prototype ) {
        prototype = base;
        base = $.Widget;
    }

    // create selector for plugin
    $.expr[ ":" ][ fullName.toLowerCase() ] = function( elem ) {
        return !!$.data( elem, fullName );
    };

    $[ namespace ] = $[ namespace ] || {};
    existingConstructor = $[ namespace ][ name ];
    constructor = $[ namespace ][ name ] = function( options, element ) {
        // allow instantiation without "new" keyword
        if ( !this._createWidget ) {
            return new constructor( options, element );
        }

        // allow instantiation without initializing for simple inheritance
        // must use "new" keyword (the code above always passes args)
        if ( arguments.length ) {
            this._createWidget( options, element );
        }
    };
    // extend with the existing constructor to carry over any static properties
    $.extend( constructor, existingConstructor, {
        version: prototype.version,
        // copy the object used to create the prototype in case we need to
        // redefine the widget later
        _proto: $.extend( {}, prototype ),
        // track widgets that inherit from this widget in case this widget is
        // redefined after a widget inherits from it
        _childConstructors: []
    });

    basePrototype = new base();
    // we need to make the options hash a property directly on the new instance
    // otherwise we'll modify the options hash on the prototype that we're
    // inheriting from
    basePrototype.options = $.widget.extend( {}, basePrototype.options );
    $.each( prototype, function( prop, value ) {
        if ( !$.isFunction( value ) ) {
            proxiedPrototype[ prop ] = value;
            return;
        }
        proxiedPrototype[ prop ] = (function() {
            var _super = function() {
                    return base.prototype[ prop ].apply( this, arguments );
                },
                _superApply = function( args ) {
                    return base.prototype[ prop ].apply( this, args );
                };
            return function() {
                var __super = this._super,
                    __superApply = this._superApply,
                    returnValue;

                this._super = _super;
                this._superApply = _superApply;

                returnValue = value.apply( this, arguments );

                this._super = __super;
                this._superApply = __superApply;

                return returnValue;
            };
        })();
    });
    constructor.prototype = $.widget.extend( basePrototype, {
        // TODO: remove support for widgetEventPrefix
        // always use the name + a colon as the prefix, e.g., draggable:start
        // don't prefix for widgets that aren't DOM-based
        widgetEventPrefix: existingConstructor ? (basePrototype.widgetEventPrefix || name) : name
    }, proxiedPrototype, {
        constructor: constructor,
        namespace: namespace,
        widgetName: name,
        widgetFullName: fullName
    });

    // If this widget is being redefined then we need to find all widgets that
    // are inheriting from it and redefine all of them so that they inherit from
    // the new version of this widget. We're essentially trying to replace one
    // level in the prototype chain.
    if ( existingConstructor ) {
        $.each( existingConstructor._childConstructors, function( i, child ) {
            var childPrototype = child.prototype;

            // redefine the child widget using the same prototype that was
            // originally used, but inherit from the new version of the base
            $.widget( childPrototype.namespace + "." + childPrototype.widgetName, constructor, child._proto );
        });
        // remove the list of existing child constructors from the old constructor
        // so the old child constructors can be garbage collected
        delete existingConstructor._childConstructors;
    } else {
        base._childConstructors.push( constructor );
    }

    $.widget.bridge( name, constructor );

    return constructor;
};

$.widget.extend = function( target ) {
    var input = slice.call( arguments, 1 ),
        inputIndex = 0,
        inputLength = input.length,
        key,
        value;
    for ( ; inputIndex < inputLength; inputIndex++ ) {
        for ( key in input[ inputIndex ] ) {
            value = input[ inputIndex ][ key ];
            if ( input[ inputIndex ].hasOwnProperty( key ) && value !== undefined ) {
                // Clone objects
                if ( $.isPlainObject( value ) ) {
                    target[ key ] = $.isPlainObject( target[ key ] ) ?
                        $.widget.extend( {}, target[ key ], value ) :
                        // Don't extend strings, arrays, etc. with objects
                        $.widget.extend( {}, value );
                // Copy everything else by reference
                } else {
                    target[ key ] = value;
                }
            }
        }
    }
    return target;
};

$.widget.bridge = function( name, object ) {
    var fullName = object.prototype.widgetFullName || name;
    $.fn[ name ] = function( options ) {
        var isMethodCall = typeof options === "string",
            args = slice.call( arguments, 1 ),
            returnValue = this;

        // allow multiple hashes to be passed on init
        options = !isMethodCall && args.length ?
            $.widget.extend.apply( null, [ options ].concat(args) ) :
            options;

        if ( isMethodCall ) {
            this.each(function() {
                var methodValue,
                    instance = $.data( this, fullName );
                if ( options === "instance" ) {
                    returnValue = instance;
                    return false;
                }
                if ( !instance ) {
                    return $.error( "cannot call methods on " + name + " prior to initialization; " +
                        "attempted to call method '" + options + "'" );
                }
                if ( !$.isFunction( instance[options] ) || options.charAt( 0 ) === "_" ) {
                    return $.error( "no such method '" + options + "' for " + name + " widget instance" );
                }
                methodValue = instance[ options ].apply( instance, args );
                if ( methodValue !== instance && methodValue !== undefined ) {
                    returnValue = methodValue && methodValue.jquery ?
                        returnValue.pushStack( methodValue.get() ) :
                        methodValue;
                    return false;
                }
            });
        } else {
            this.each(function() {
                var instance = $.data( this, fullName );
                if ( instance ) {
                    instance.option( options || {} )._init();
                } else {
                    $.data( this, fullName, new object( options, this ) );
                }
            });
        }

        return returnValue;
    };
};

$.Widget = function( /* options, element */ ) {};
$.Widget._childConstructors = [];

$.Widget.prototype = {
    widgetName: "widget",
    widgetEventPrefix: "",
    defaultElement: "<div>",
    options: {
        disabled: false,

        // callbacks
        create: null
    },
    _createWidget: function( options, element ) {
        element = $( element || this.defaultElement || this )[ 0 ];
        this.element = $( element );
        this.uuid = uuid++;
        this.eventNamespace = "." + this.widgetName + this.uuid;
        this.options = $.widget.extend( {},
            this.options,
            this._getCreateOptions(),
            options );

        this.bindings = $();
        this.hoverable = $();
        this.focusable = $();

        if ( element !== this ) {
            $.data( element, this.widgetFullName, this );
            this._on( true, this.element, {
                remove: function( event ) {
                    if ( event.target === element ) {
                        this.destroy();
                    }
                }
            });
            this.document = $( element.style ?
                // element within the document
                element.ownerDocument :
                // element is window or document
                element.document || element );
            this.window = $( this.document[0].defaultView || this.document[0].parentWindow );
        }

        this._create();
        this._trigger( "create", null, this._getCreateEventData() );
        this._init();
    },
    _getCreateOptions: $.noop,
    _getCreateEventData: $.noop,
    _create: $.noop,
    _init: $.noop,

    destroy: function() {
        this._destroy();
        // we can probably remove the unbind calls in 2.0
        // all event bindings should go through this._on()
        this.element
            .unbind( this.eventNamespace )
            .removeData( this.widgetFullName )
            // support: jquery <1.6.3
            // http://bugs.jquery.com/ticket/9413
            .removeData( $.camelCase( this.widgetFullName ) );
        this.widget()
            .unbind( this.eventNamespace )
            .removeAttr( "aria-disabled" )
            .removeClass(
                this.widgetFullName + "-disabled " +
                "ui-state-disabled" );

        // clean up events and states
        this.bindings.unbind( this.eventNamespace );
        this.hoverable.removeClass( "ui-state-hover" );
        this.focusable.removeClass( "ui-state-focus" );
    },
    _destroy: $.noop,

    widget: function() {
        return this.element;
    },

    option: function( key, value ) {
        var options = key,
            parts,
            curOption,
            i;

        if ( arguments.length === 0 ) {
            // don't return a reference to the internal hash
            return $.widget.extend( {}, this.options );
        }

        if ( typeof key === "string" ) {
            // handle nested keys, e.g., "foo.bar" => { foo: { bar: ___ } }
            options = {};
            parts = key.split( "." );
            key = parts.shift();
            if ( parts.length ) {
                curOption = options[ key ] = $.widget.extend( {}, this.options[ key ] );
                for ( i = 0; i < parts.length - 1; i++ ) {
                    curOption[ parts[ i ] ] = curOption[ parts[ i ] ] || {};
                    curOption = curOption[ parts[ i ] ];
                }
                key = parts.pop();
                if ( value === undefined ) {
                    return curOption[ key ] === undefined ? null : curOption[ key ];
                }
                curOption[ key ] = value;
            } else {
                if ( value === undefined ) {
                    return this.options[ key ] === undefined ? null : this.options[ key ];
                }
                options[ key ] = value;
            }
        }

        this._setOptions( options );

        return this;
    },
    _setOptions: function( options ) {
        var key;

        for ( key in options ) {
            this._setOption( key, options[ key ] );
        }

        return this;
    },
    _setOption: function( key, value ) {
        this.options[ key ] = value;

        if ( key === "disabled" ) {
            this.widget()
                .toggleClass( this.widgetFullName + "-disabled", !!value );
            this.hoverable.removeClass( "ui-state-hover" );
            this.focusable.removeClass( "ui-state-focus" );
        }

        return this;
    },

    enable: function() {
        return this._setOptions({ disabled: false });
    },
    disable: function() {
        return this._setOptions({ disabled: true });
    },

    _on: function( suppressDisabledCheck, element, handlers ) {
        var delegateElement,
            instance = this;

        // no suppressDisabledCheck flag, shuffle arguments
        if ( typeof suppressDisabledCheck !== "boolean" ) {
            handlers = element;
            element = suppressDisabledCheck;
            suppressDisabledCheck = false;
        }

        // no element argument, shuffle and use this.element
        if ( !handlers ) {
            handlers = element;
            element = this.element;
            delegateElement = this.widget();
        } else {
            // accept selectors, DOM elements
            element = delegateElement = $( element );
            this.bindings = this.bindings.add( element );
        }

        $.each( handlers, function( event, handler ) {
            function handlerProxy() {
                // allow widgets to customize the disabled handling
                // - disabled as an array instead of boolean
                // - disabled class as method for disabling individual parts
                if ( !suppressDisabledCheck &&
                        ( instance.options.disabled === true ||
                            $( this ).hasClass( "ui-state-disabled" ) ) ) {
                    return;
                }
                return ( typeof handler === "string" ? instance[ handler ] : handler )
                    .apply( instance, arguments );
            }

            // copy the guid so direct unbinding works
            if ( typeof handler !== "string" ) {
                handlerProxy.guid = handler.guid =
                    handler.guid || handlerProxy.guid || $.guid++;
            }

            var match = event.match( /^(\w+)\s*(.*)$/ ),
                eventName = match[1] + instance.eventNamespace,
                selector = match[2];
            if ( selector ) {
                delegateElement.delegate( selector, eventName, handlerProxy );
            } else {
                element.bind( eventName, handlerProxy );
            }
        });
    },

    _off: function( element, eventName ) {
        eventName = (eventName || "").split( " " ).join( this.eventNamespace + " " ) + this.eventNamespace;
        element.unbind( eventName ).undelegate( eventName );
    },

    _delay: function( handler, delay ) {
        function handlerProxy() {
            return ( typeof handler === "string" ? instance[ handler ] : handler )
                .apply( instance, arguments );
        }
        var instance = this;
        return setTimeout( handlerProxy, delay || 0 );
    },

    _hoverable: function( element ) {
        this.hoverable = this.hoverable.add( element );
        this._on( element, {
            mouseenter: function( event ) {
                $( event.currentTarget ).addClass( "ui-state-hover" );
            },
            mouseleave: function( event ) {
                $( event.currentTarget ).removeClass( "ui-state-hover" );
            }
        });
    },

    _focusable: function( element ) {
        this.focusable = this.focusable.add( element );
        this._on( element, {
            focusin: function( event ) {
                $( event.currentTarget ).addClass( "ui-state-focus" );
            },
            focusout: function( event ) {
                $( event.currentTarget ).removeClass( "ui-state-focus" );
            }
        });
    },

    _trigger: function( type, event, data ) {
        var prop, orig,
            callback = this.options[ type ];

        data = data || {};
        event = $.Event( event );
        event.type = ( type === this.widgetEventPrefix ?
            type :
            this.widgetEventPrefix + type ).toLowerCase();
        // the original event may come from any element
        // so we need to reset the target on the new event
        event.target = this.element[ 0 ];

        // copy original event properties over to the new event
        orig = event.originalEvent;
        if ( orig ) {
            for ( prop in orig ) {
                if ( !( prop in event ) ) {
                    event[ prop ] = orig[ prop ];
                }
            }
        }

        this.element.trigger( event, data );
        return !( $.isFunction( callback ) &&
            callback.apply( this.element[0], [ event ].concat( data ) ) === false ||
            event.isDefaultPrevented() );
    }
};

$.each( { show: "fadeIn", hide: "fadeOut" }, function( method, defaultEffect ) {
    $.Widget.prototype[ "_" + method ] = function( element, options, callback ) {
        if ( typeof options === "string" ) {
            options = { effect: options };
        }
        var hasOptions,
            effectName = !options ?
                method :
                options === true || typeof options === "number" ?
                    defaultEffect :
                    options.effect || defaultEffect;
        options = options || {};
        if ( typeof options === "number" ) {
            options = { duration: options };
        }
        hasOptions = !$.isEmptyObject( options );
        options.complete = callback;
        if ( options.delay ) {
            element.delay( options.delay );
        }
        if ( hasOptions && $.effects && $.effects.effect[ effectName ] ) {
            element[ method ]( options );
        } else if ( effectName !== method && element[ effectName ] ) {
            element[ effectName ]( options.duration, options.easing, callback );
        } else {
            element.queue(function( next ) {
                $( this )[ method ]();
                if ( callback ) {
                    callback.call( element[ 0 ] );
                }
                next();
            });
        }
    };
});

})( jQuery );

(function( $, window, undefined ) {
    var nsNormalizeDict = {},
        oldFind = $.find,
        rbrace = /(?:\{[\s\S]*\}|\[[\s\S]*\])$/,
        jqmDataRE = /:jqmData\(([^)]*)\)/g;

    $.extend( $.mobile, {

        // Namespace used framework-wide for data-attrs. Default is no namespace

        ns: "",

        // Retrieve an attribute from an element and perform some massaging of the value

        getAttribute: function( element, key ) {
            var data;

            element = element.jquery ? element[0] : element;

            if ( element && element.getAttribute ) {
                data = element.getAttribute( "data-" + $.mobile.ns + key );
            }

            // Copied from core's src/data.js:dataAttr()
            // Convert from a string to a proper data type
            try {
                data = data === "true" ? true :
                    data === "false" ? false :
                    data === "null" ? null :
                    // Only convert to a number if it doesn't change the string
                    +data + "" === data ? +data :
                    rbrace.test( data ) ? JSON.parse( data ) :
                    data;
            } catch( err ) {}

            return data;
        },

        // Expose our cache for testing purposes.
        nsNormalizeDict: nsNormalizeDict,

        // Take a data attribute property, prepend the namespace
        // and then camel case the attribute string. Add the result
        // to our nsNormalizeDict so we don't have to do this again.
        nsNormalize: function( prop ) {
            return nsNormalizeDict[ prop ] ||
                ( nsNormalizeDict[ prop ] = $.camelCase( $.mobile.ns + prop ) );
        },

        // Find the closest javascript page element to gather settings data jsperf test
        // http://jsperf.com/single-complex-selector-vs-many-complex-selectors/edit
        // possibly naive, but it shows that the parsing overhead for *just* the page selector vs
        // the page and dialog selector is negligable. This could probably be speed up by
        // doing a similar parent node traversal to the one found in the inherited theme code above
        closestPageData: function( $target ) {
            return $target
                .closest( ":jqmData(role='page'), :jqmData(role='dialog')" )
                .data( "mobile-page" );
        }

    });

    // Mobile version of data and removeData and hasData methods
    // ensures all data is set and retrieved using jQuery Mobile's data namespace
    $.fn.jqmData = function( prop, value ) {
        var result;
        if ( typeof prop !== "undefined" ) {
            if ( prop ) {
                prop = $.mobile.nsNormalize( prop );
            }

            // undefined is permitted as an explicit input for the second param
            // in this case it returns the value and does not set it to undefined
            if ( arguments.length < 2 || value === undefined ) {
                result = this.data( prop );
            } else {
                result = this.data( prop, value );
            }
        }
        return result;
    };

    $.jqmData = function( elem, prop, value ) {
        var result;
        if ( typeof prop !== "undefined" ) {
            result = $.data( elem, prop ? $.mobile.nsNormalize( prop ) : prop, value );
        }
        return result;
    };

    $.fn.jqmRemoveData = function( prop ) {
        return this.removeData( $.mobile.nsNormalize( prop ) );
    };

    $.jqmRemoveData = function( elem, prop ) {
        return $.removeData( elem, $.mobile.nsNormalize( prop ) );
    };

    $.find = function( selector, context, ret, extra ) {
        if ( selector.indexOf( ":jqmData" ) > -1 ) {
            selector = selector.replace( jqmDataRE, "[data-" + ( $.mobile.ns || "" ) + "$1]" );
        }

        return oldFind.call( this, selector, context, ret, extra );
    };

    $.extend( $.find, oldFind );

})( jQuery, this );

(function( $, undefined ) {

var rcapitals = /[A-Z]/g,
    replaceFunction = function( c ) {
        return "-" + c.toLowerCase();
    };

$.extend( $.Widget.prototype, {
    _getCreateOptions: function() {
        var option, value,
            elem = this.element[ 0 ],
            options = {};

        //
        if ( !$.mobile.getAttribute( elem, "defaults" ) ) {
            for ( option in this.options ) {
                value = $.mobile.getAttribute( elem, option.replace( rcapitals, replaceFunction ) );

                if ( value != null ) {
                    options[ option ] = value;
                }
            }
        }

        return options;
    }
});

//TODO: Remove in 1.5 for backcompat only
$.mobile.widget = $.Widget;

})( jQuery );


(function( $ ) {
    // TODO move loader class down into the widget settings
    var loaderClass = "ui-loader", $html = $( "html" );

    $.widget( "mobile.loader", {
        // NOTE if the global config settings are defined they will override these
        //      options
        options: {
            // the theme for the loading message
            theme: "a",

            // whether the text in the loading message is shown
            textVisible: false,

            // custom html for the inner content of the loading message
            html: "",

            // the text to be displayed when the popup is shown
            text: "loading"
        },

        defaultHtml: "<div class='" + loaderClass + "'>" +
            "<span class='ui-icon-loading'></span>" +
            "<h1></h1>" +
            "</div>",

        // For non-fixed supportin browsers. Position at y center (if scrollTop supported), above the activeBtn (if defined), or just 100px from top
        fakeFixLoader: function() {
            var activeBtn = $( "." + $.mobile.activeBtnClass ).first();

            this.element
                .css({
                    top: $.support.scrollTop && this.window.scrollTop() + this.window.height() / 2 ||
                        activeBtn.length && activeBtn.offset().top || 100
                });
        },

        // check position of loader to see if it appears to be "fixed" to center
        // if not, use abs positioning
        checkLoaderPosition: function() {
            var offset = this.element.offset(),
                scrollTop = this.window.scrollTop(),
                screenHeight = $.mobile.getScreenHeight();

            if ( offset.top < scrollTop || ( offset.top - scrollTop ) > screenHeight ) {
                this.element.addClass( "ui-loader-fakefix" );
                this.fakeFixLoader();
                this.window
                    .unbind( "scroll", this.checkLoaderPosition )
                    .bind( "scroll", $.proxy( this.fakeFixLoader, this ) );
            }
        },

        resetHtml: function() {
            this.element.html( $( this.defaultHtml ).html() );
        },

        // Turn on/off page loading message. Theme doubles as an object argument
        // with the following shape: { theme: '', text: '', html: '', textVisible: '' }
        // NOTE that the $.mobile.loading* settings and params past the first are deprecated
        // TODO sweet jesus we need to break some of this out
        show: function( theme, msgText, textonly ) {
            var textVisible, message, loadSettings;

            this.resetHtml();

            // use the prototype options so that people can set them globally at
            // mobile init. Consistency, it's what's for dinner
            if ( $.type( theme ) === "object" ) {
                loadSettings = $.extend( {}, this.options, theme );

                theme = loadSettings.theme;
            } else {
                loadSettings = this.options;

                // here we prefer the theme value passed as a string argument, then
                // we prefer the global option because we can't use undefined default
                // prototype options, then the prototype option
                theme = theme || loadSettings.theme;
            }

            // set the message text, prefer the param, then the settings object
            // then loading message
            message = msgText || ( loadSettings.text === false ? "" : loadSettings.text );

            // prepare the dom
            $html.addClass( "ui-loading" );

            textVisible = loadSettings.textVisible;

            // add the proper css given the options (theme, text, etc)
            // Force text visibility if the second argument was supplied, or
            // if the text was explicitly set in the object args
            this.element.attr("class", loaderClass +
                " ui-corner-all ui-body-" + theme +
                " ui-loader-" + ( textVisible || msgText || theme.text ? "verbose" : "default" ) +
                ( loadSettings.textonly || textonly ? " ui-loader-textonly" : "" ) );

            // TODO verify that jquery.fn.html is ok to use in both cases here
            //      this might be overly defensive in preventing unknowing xss
            // if the html attribute is defined on the loading settings, use that
            // otherwise use the fallbacks from above
            if ( loadSettings.html ) {
                this.element.html( loadSettings.html );
            } else {
                this.element.find( "h1" ).text( message );
            }

            // If the pagecontainer widget has been defined we may use the :mobile-pagecontainer
            // and attach to the element on which the pagecontainer widget has been defined. If not,
            // we attach to the body.
            this.element.appendTo( $.mobile.pagecontainer ?
                $( ":mobile-pagecontainer" ) : $( "body" ) );

            // check that the loader is visible
            this.checkLoaderPosition();

            // on scroll check the loader position
            this.window.bind( "scroll", $.proxy( this.checkLoaderPosition, this ) );
        },

        hide: function() {
            $html.removeClass( "ui-loading" );

            if ( this.options.text ) {
                this.element.removeClass( "ui-loader-fakefix" );
            }

            this.window.unbind( "scroll", this.fakeFixLoader );
            this.window.unbind( "scroll", this.checkLoaderPosition );
        }
    });

})(jQuery, this);


/*!
 * jQuery hashchange event - v1.3 - 7/21/2010
 * http://benalman.com/projects/jquery-hashchange-plugin/
 * 
 * Copyright (c) 2010 "Cowboy" Ben Alman
 * Dual licensed under the MIT and GPL licenses.
 * http://benalman.com/about/license/
 */

// Script: jQuery hashchange event
//
// *Version: 1.3, Last updated: 7/21/2010*
// 
// Project Home - http://benalman.com/projects/jquery-hashchange-plugin/
// GitHub       - http://github.com/cowboy/jquery-hashchange/
// Source       - http://github.com/cowboy/jquery-hashchange/raw/master/jquery.ba-hashchange.js
// (Minified)   - http://github.com/cowboy/jquery-hashchange/raw/master/jquery.ba-hashchange.min.js (0.8kb gzipped)
// 
// About: License
// 
// Copyright (c) 2010 "Cowboy" Ben Alman,
// Dual licensed under the MIT and GPL licenses.
// http://benalman.com/about/license/
// 
// About: Examples
// 
// These working examples, complete with fully commented code, illustrate a few
// ways in which this plugin can be used.
// 
// hashchange event - http://benalman.com/code/projects/jquery-hashchange/examples/hashchange/
// document.domain - http://benalman.com/code/projects/jquery-hashchange/examples/document_domain/
// 
// About: Support and Testing
// 
// Information about what version or versions of jQuery this plugin has been
// tested with, what browsers it has been tested in, and where the unit tests
// reside (so you can test it yourself).
// 
// jQuery Versions - 1.2.6, 1.3.2, 1.4.1, 1.4.2
// Browsers Tested - Internet Explorer 6-8, Firefox 2-4, Chrome 5-6, Safari 3.2-5,
//                   Opera 9.6-10.60, iPhone 3.1, Android 1.6-2.2, BlackBerry 4.6-5.
// Unit Tests      - http://benalman.com/code/projects/jquery-hashchange/unit/
// 
// About: Known issues
// 
// While this jQuery hashchange event implementation is quite stable and
// robust, there are a few unfortunate browser bugs surrounding expected
// hashchange event-based behaviors, independent of any JavaScript
// window.onhashchange abstraction. See the following examples for more
// information:
// 
// Chrome: Back Button - http://benalman.com/code/projects/jquery-hashchange/examples/bug-chrome-back-button/
// Firefox: Remote XMLHttpRequest - http://benalman.com/code/projects/jquery-hashchange/examples/bug-firefox-remote-xhr/
// WebKit: Back Button in an Iframe - http://benalman.com/code/projects/jquery-hashchange/examples/bug-webkit-hash-iframe/
// Safari: Back Button from a different domain - http://benalman.com/code/projects/jquery-hashchange/examples/bug-safari-back-from-diff-domain/
// 
// Also note that should a browser natively support the window.onhashchange 
// event, but not report that it does, the fallback polling loop will be used.
// 
// About: Release History
// 
// 1.3   - (7/21/2010) Reorganized IE6/7 Iframe code to make it more
//         "removable" for mobile-only development. Added IE6/7 document.title
//         support. Attempted to make Iframe as hidden as possible by using
//         techniques from http://www.paciellogroup.com/blog/?p=604. Added 
//         support for the "shortcut" format $(window).hashchange( fn ) and
//         $(window).hashchange() like jQuery provides for built-in events.
//         Renamed jQuery.hashchangeDelay to <jQuery.fn.hashchange.delay> and
//         lowered its default value to 50. Added <jQuery.fn.hashchange.domain>
//         and <jQuery.fn.hashchange.src> properties plus document-domain.html
//         file to address access denied issues when setting document.domain in
//         IE6/7.
// 1.2   - (2/11/2010) Fixed a bug where coming back to a page using this plugin
//         from a page on another domain would cause an error in Safari 4. Also,
//         IE6/7 Iframe is now inserted after the body (this actually works),
//         which prevents the page from scrolling when the event is first bound.
//         Event can also now be bound before DOM ready, but it won't be usable
//         before then in IE6/7.
// 1.1   - (1/21/2010) Incorporated document.documentMode test to fix IE8 bug
//         where browser version is incorrectly reported as 8.0, despite
//         inclusion of the X-UA-Compatible IE=EmulateIE7 meta tag.
// 1.0   - (1/9/2010) Initial Release. Broke out the jQuery BBQ event.special
//         window.onhashchange functionality into a separate plugin for users
//         who want just the basic event & back button support, without all the
//         extra awesomeness that BBQ provides. This plugin will be included as
//         part of jQuery BBQ, but also be available separately.

(function($,window,undefined){
  '$:nomunge'; // Used by YUI compressor.
  
  // Reused string.
  var str_hashchange = 'hashchange',
    
    // Method / object references.
    doc = document,
    fake_onhashchange,
    special = $.event.special,
    
    // Does the browser support window.onhashchange? Note that IE8 running in
    // IE7 compatibility mode reports true for 'onhashchange' in window, even
    // though the event isn't supported, so also test document.documentMode.
    doc_mode = doc.documentMode,
    supports_onhashchange = 'on' + str_hashchange in window && ( doc_mode === undefined || doc_mode > 7 );
  
  // Get location.hash (or what you'd expect location.hash to be) sans any
  // leading #. Thanks for making this necessary, Firefox!
  function get_fragment( url ) {
    url = url || location.href;
    return '#' + url.replace( /^[^#]*#?(.*)$/, '$1' );
  };
  
  // Method: jQuery.fn.hashchange
  // 
  // Bind a handler to the window.onhashchange event or trigger all bound
  // window.onhashchange event handlers. This behavior is consistent with
  // jQuery's built-in event handlers.
  // 
  // Usage:
  // 
  // > jQuery(window).hashchange( [ handler ] );
  // 
  // Arguments:
  // 
  //  handler - (Function) Optional handler to be bound to the hashchange
  //    event. This is a "shortcut" for the more verbose form:
  //    jQuery(window).bind( 'hashchange', handler ). If handler is omitted,
  //    all bound window.onhashchange event handlers will be triggered. This
  //    is a shortcut for the more verbose
  //    jQuery(window).trigger( 'hashchange' ). These forms are described in
  //    the <hashchange event> section.
  // 
  // Returns:
  // 
  //  (jQuery) The initial jQuery collection of elements.
  
  // Allow the "shortcut" format $(elem).hashchange( fn ) for binding and
  // $(elem).hashchange() for triggering, like jQuery does for built-in events.
  $.fn[ str_hashchange ] = function( fn ) {
    return fn ? this.bind( str_hashchange, fn ) : this.trigger( str_hashchange );
  };
  
  // Property: jQuery.fn.hashchange.delay
  // 
  // The numeric interval (in milliseconds) at which the <hashchange event>
  // polling loop executes. Defaults to 50.
  
  // Property: jQuery.fn.hashchange.domain
  // 
  // If you're setting document.domain in your JavaScript, and you want hash
  // history to work in IE6/7, not only must this property be set, but you must
  // also set document.domain BEFORE jQuery is loaded into the page. This
  // property is only applicable if you are supporting IE6/7 (or IE8 operating
  // in "IE7 compatibility" mode).
  // 
  // In addition, the <jQuery.fn.hashchange.src> property must be set to the
  // path of the included "document-domain.html" file, which can be renamed or
  // modified if necessary (note that the document.domain specified must be the
  // same in both your main JavaScript as well as in this file).
  // 
  // Usage:
  // 
  // jQuery.fn.hashchange.domain = document.domain;
  
  // Property: jQuery.fn.hashchange.src
  // 
  // If, for some reason, you need to specify an Iframe src file (for example,
  // when setting document.domain as in <jQuery.fn.hashchange.domain>), you can
  // do so using this property. Note that when using this property, history
  // won't be recorded in IE6/7 until the Iframe src file loads. This property
  // is only applicable if you are supporting IE6/7 (or IE8 operating in "IE7
  // compatibility" mode).
  // 
  // Usage:
  // 
  // jQuery.fn.hashchange.src = 'path/to/file.html';
  
  $.fn[ str_hashchange ].delay = 50;
  /*
  $.fn[ str_hashchange ].domain = null;
  $.fn[ str_hashchange ].src = null;
  */
  
  // Event: hashchange event
  // 
  // Fired when location.hash changes. In browsers that support it, the native
  // HTML5 window.onhashchange event is used, otherwise a polling loop is
  // initialized, running every <jQuery.fn.hashchange.delay> milliseconds to
  // see if the hash has changed. In IE6/7 (and IE8 operating in "IE7
  // compatibility" mode), a hidden Iframe is created to allow the back button
  // and hash-based history to work.
  // 
  // Usage as described in <jQuery.fn.hashchange>:
  // 
  // > // Bind an event handler.
  // > jQuery(window).hashchange( function(e) {
  // >   var hash = location.hash;
  // >   ...
  // > });
  // > 
  // > // Manually trigger the event handler.
  // > jQuery(window).hashchange();
  // 
  // A more verbose usage that allows for event namespacing:
  // 
  // > // Bind an event handler.
  // > jQuery(window).bind( 'hashchange', function(e) {
  // >   var hash = location.hash;
  // >   ...
  // > });
  // > 
  // > // Manually trigger the event handler.
  // > jQuery(window).trigger( 'hashchange' );
  // 
  // Additional Notes:
  // 
  // * The polling loop and Iframe are not created until at least one handler
  //   is actually bound to the 'hashchange' event.
  // * If you need the bound handler(s) to execute immediately, in cases where
  //   a location.hash exists on page load, via bookmark or page refresh for
  //   example, use jQuery(window).hashchange() or the more verbose 
  //   jQuery(window).trigger( 'hashchange' ).
  // * The event can be bound before DOM ready, but since it won't be usable
  //   before then in IE6/7 (due to the necessary Iframe), recommended usage is
  //   to bind it inside a DOM ready handler.
  
  // Override existing $.event.special.hashchange methods (allowing this plugin
  // to be defined after jQuery BBQ in BBQ's source code).
  special[ str_hashchange ] = $.extend( special[ str_hashchange ], {
    
    // Called only when the first 'hashchange' event is bound to window.
    setup: function() {
      // If window.onhashchange is supported natively, there's nothing to do..
      if ( supports_onhashchange ) { return false; }
      
      // Otherwise, we need to create our own. And we don't want to call this
      // until the user binds to the event, just in case they never do, since it
      // will create a polling loop and possibly even a hidden Iframe.
      $( fake_onhashchange.start );
    },
    
    // Called only when the last 'hashchange' event is unbound from window.
    teardown: function() {
      // If window.onhashchange is supported natively, there's nothing to do..
      if ( supports_onhashchange ) { return false; }
      
      // Otherwise, we need to stop ours (if possible).
      $( fake_onhashchange.stop );
    }
    
  });
  
  // fake_onhashchange does all the work of triggering the window.onhashchange
  // event for browsers that don't natively support it, including creating a
  // polling loop to watch for hash changes and in IE 6/7 creating a hidden
  // Iframe to enable back and forward.
  fake_onhashchange = (function(){
    var self = {},
      timeout_id,
      
      // Remember the initial hash so it doesn't get triggered immediately.
      last_hash = get_fragment(),
      
      fn_retval = function(val){ return val; },
      history_set = fn_retval,
      history_get = fn_retval;
    
    // Start the polling loop.
    self.start = function() {
      timeout_id || poll();
    };
    
    // Stop the polling loop.
    self.stop = function() {
      timeout_id && clearTimeout( timeout_id );
      timeout_id = undefined;
    };
    
    // This polling loop checks every $.fn.hashchange.delay milliseconds to see
    // if location.hash has changed, and triggers the 'hashchange' event on
    // window when necessary.
    function poll() {
      var hash = get_fragment(),
        history_hash = history_get( last_hash );
      
      if ( hash !== last_hash ) {
        history_set( last_hash = hash, history_hash );
        
        $(window).trigger( str_hashchange );
        
      } else if ( history_hash !== last_hash ) {
        location.href = location.href.replace( /#.*/, '' ) + history_hash;
      }
      
      timeout_id = setTimeout( poll, $.fn[ str_hashchange ].delay );
    };
    
    // vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
    // vvvvvvvvvvvvvvvvvvv REMOVE IF NOT SUPPORTING IE6/7/8 vvvvvvvvvvvvvvvvvvv
    // vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
    window.attachEvent && !window.addEventListener && !supports_onhashchange && (function(){
      // Not only do IE6/7 need the "magical" Iframe treatment, but so does IE8
      // when running in "IE7 compatibility" mode.
      
      var iframe,
        iframe_src;
      
      // When the event is bound and polling starts in IE 6/7, create a hidden
      // Iframe for history handling.
      self.start = function(){
        if ( !iframe ) {
          iframe_src = $.fn[ str_hashchange ].src;
          iframe_src = iframe_src && iframe_src + get_fragment();
          
          // Create hidden Iframe. Attempt to make Iframe as hidden as possible
          // by using techniques from http://www.paciellogroup.com/blog/?p=604.
          iframe = $('<iframe tabindex="-1" title="empty"/>').hide()
            
            // When Iframe has completely loaded, initialize the history and
            // start polling.
            .one( 'load', function(){
              iframe_src || history_set( get_fragment() );
              poll();
            })
            
            // Load Iframe src if specified, otherwise nothing.
            .attr( 'src', iframe_src || 'javascript:0' )
            
            // Append Iframe after the end of the body to prevent unnecessary
            // initial page scrolling (yes, this works).
            .insertAfter( 'body' )[0].contentWindow;
          
          // Whenever `document.title` changes, update the Iframe's title to
          // prettify the back/next history menu entries. Since IE sometimes
          // errors with "Unspecified error" the very first time this is set
          // (yes, very useful) wrap this with a try/catch block.
          doc.onpropertychange = function(){
            try {
              if ( event.propertyName === 'title' ) {
                iframe.document.title = doc.title;
              }
            } catch(e) {}
          };
          
        }
      };
      
      // Override the "stop" method since an IE6/7 Iframe was created. Even
      // if there are no longer any bound event handlers, the polling loop
      // is still necessary for back/next to work at all!
      self.stop = fn_retval;
      
      // Get history by looking at the hidden Iframe's location.hash.
      history_get = function() {
        return get_fragment( iframe.location.href );
      };
      
      // Set a new history item by opening and then closing the Iframe
      // document, *then* setting its location.hash. If document.domain has
      // been set, update that as well.
      history_set = function( hash, history_hash ) {
        var iframe_doc = iframe.document,
          domain = $.fn[ str_hashchange ].domain;
        
        if ( hash !== history_hash ) {
          // Update Iframe with any initial `document.title` that might be set.
          iframe_doc.title = doc.title;
          
          // Opening the Iframe's document after it has been closed is what
          // actually adds a history entry.
          iframe_doc.open();
          
          // Set document.domain for the Iframe document as well, if necessary.
          domain && iframe_doc.write( '\x3cscript>document.domain="' + domain + '"\x3c/script>' );
          
          iframe_doc.close();
          
          // Update the Iframe's hash, for great justice.
          iframe.location.hash = hash;
        }
      };
      
    })();
    // ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
    // ^^^^^^^^^^^^^^^^^^^ REMOVE IF NOT SUPPORTING IE6/7/8 ^^^^^^^^^^^^^^^^^^^
    // ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
    
    return self;
  })();
  
})(jQuery,this);


(function( $, undefined ) {

    /*! matchMedia() polyfill - Test a CSS media type/query in JS. Authors & copyright (c) 2012: Scott Jehl, Paul Irish, Nicholas Zakas. Dual MIT/BSD license */
    window.matchMedia = window.matchMedia || (function( doc, undefined ) {

        var bool,
            docElem = doc.documentElement,
            refNode = docElem.firstElementChild || docElem.firstChild,
            // fakeBody required for <FF4 when executed in <head>
            fakeBody = doc.createElement( "body" ),
            div = doc.createElement( "div" );

        div.id = "mq-test-1";
        div.style.cssText = "position:absolute;top:-100em";
        fakeBody.style.background = "none";
        fakeBody.appendChild(div);

        return function(q){

            div.innerHTML = "&shy;<style media=\"" + q + "\"> #mq-test-1 { width: 42px; }</style>";

            docElem.insertBefore( fakeBody, refNode );
            bool = div.offsetWidth === 42;
            docElem.removeChild( fakeBody );

            return {
                matches: bool,
                media: q
            };

        };

    }( document ));

    // $.mobile.media uses matchMedia to return a boolean.
    $.mobile.media = function( q ) {
        return window.matchMedia( q ).matches;
    };

})(jQuery);

    (function( $, undefined ) {
        var support = {
            touch: "ontouchend" in document
        };

        $.mobile.support = $.mobile.support || {};
        $.extend( $.support, support );
        $.extend( $.mobile.support, support );
    }( jQuery ));

    (function( $, undefined ) {
        $.extend( $.support, {
            orientation: "orientation" in window && "onorientationchange" in window
        });
    }( jQuery ));

(function( $, undefined ) {

// thx Modernizr
function propExists( prop ) {
    var uc_prop = prop.charAt( 0 ).toUpperCase() + prop.substr( 1 ),
        props = ( prop + " " + vendors.join( uc_prop + " " ) + uc_prop ).split( " " ),
        v;

    for ( v in props ) {
        if ( fbCSS[ props[ v ] ] !== undefined ) {
            return true;
        }
    }
}

var fakeBody = $( "<body>" ).prependTo( "html" ),
    fbCSS = fakeBody[ 0 ].style,
    vendors = [ "Webkit", "Moz", "O" ],
    webos = "palmGetResource" in window, //only used to rule out scrollTop
    operamini = window.operamini && ({}).toString.call( window.operamini ) === "[object OperaMini]",
    bb = window.blackberry && !propExists( "-webkit-transform" ), //only used to rule out box shadow, as it's filled opaque on BB 5 and lower
    nokiaLTE7_3;

// inline SVG support test
function inlineSVG() {
    // Thanks Modernizr & Erik Dahlstrom
    var w = window,
        svg = !!w.document.createElementNS && !!w.document.createElementNS( "http://www.w3.org/2000/svg", "svg" ).createSVGRect && !( w.opera && navigator.userAgent.indexOf( "Chrome" ) === -1 ),
        support = function( data ) {
            if ( !( data && svg ) ) {
                $( "html" ).addClass( "ui-nosvg" );
            }
        },
        img = new w.Image();

    img.onerror = function() {
        support( false );
    };
    img.onload = function() {
        support( img.width === 1 && img.height === 1 );
    };
    img.src = "data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///ywAAAAAAQABAAACAUwAOw==";
}

function transform3dTest() {
    var mqProp = "transform-3d",
        // Because the `translate3d` test below throws false positives in Android:
        ret = $.mobile.media( "(-" + vendors.join( "-" + mqProp + "),(-" ) + "-" + mqProp + "),(" + mqProp + ")" ),
        el, transforms, t;

    if ( ret ) {
        return !!ret;
    }

    el = document.createElement( "div" );
    transforms = {
        // We’re omitting Opera for the time being; MS uses unprefixed.
        "MozTransform": "-moz-transform",
        "transform": "transform"
    };

    fakeBody.append( el );

    for ( t in transforms ) {
        if ( el.style[ t ] !== undefined ) {
            el.style[ t ] = "translate3d( 100px, 1px, 1px )";
            ret = window.getComputedStyle( el ).getPropertyValue( transforms[ t ] );
        }
    }
    return ( !!ret && ret !== "none" );
}

// Test for dynamic-updating base tag support ( allows us to avoid href,src attr rewriting )
function baseTagTest() {
    var fauxBase = location.protocol + "//" + location.host + location.pathname + "ui-dir/",
        base = $( "head base" ),
        fauxEle = null,
        href = "",
        link, rebase;

    if ( !base.length ) {
        base = fauxEle = $( "<base>", { "href": fauxBase }).appendTo( "head" );
    } else {
        href = base.attr( "href" );
    }

    link = $( "<a href='testurl' />" ).prependTo( fakeBody );
    rebase = link[ 0 ].href;
    base[ 0 ].href = href || location.pathname;

    if ( fauxEle ) {
        fauxEle.remove();
    }
    return rebase.indexOf( fauxBase ) === 0;
}

// Thanks Modernizr
function cssPointerEventsTest() {
    var element = document.createElement( "x" ),
        documentElement = document.documentElement,
        getComputedStyle = window.getComputedStyle,
        supports;

    if ( !( "pointerEvents" in element.style ) ) {
        return false;
    }

    element.style.pointerEvents = "auto";
    element.style.pointerEvents = "x";
    documentElement.appendChild( element );
    supports = getComputedStyle &&
    getComputedStyle( element, "" ).pointerEvents === "auto";
    documentElement.removeChild( element );
    return !!supports;
}

function boundingRect() {
    var div = document.createElement( "div" );
    return typeof div.getBoundingClientRect !== "undefined";
}

// non-UA-based IE version check by James Padolsey, modified by jdalton - from http://gist.github.com/527683
// allows for inclusion of IE 6+, including Windows Mobile 7
$.extend( $.mobile, { browser: {} } );
$.mobile.browser.oldIE = (function() {
    var v = 3,
        div = document.createElement( "div" ),
        a = div.all || [];

    do {
        div.innerHTML = "<!--[if gt IE " + ( ++v ) + "]><br><![endif]-->";
    } while( a[0] );

    return v > 4 ? v : !v;
})();

function fixedPosition() {
    var w = window,
        ua = navigator.userAgent,
        platform = navigator.platform,
        // Rendering engine is Webkit, and capture major version
        wkmatch = ua.match( /AppleWebKit\/([0-9]+)/ ),
        wkversion = !!wkmatch && wkmatch[ 1 ],
        ffmatch = ua.match( /Fennec\/([0-9]+)/ ),
        ffversion = !!ffmatch && ffmatch[ 1 ],
        operammobilematch = ua.match( /Opera Mobi\/([0-9]+)/ ),
        omversion = !!operammobilematch && operammobilematch[ 1 ];

    if (
        // iOS 4.3 and older : Platform is iPhone/Pad/Touch and Webkit version is less than 534 (ios5)
        ( ( platform.indexOf( "iPhone" ) > -1 || platform.indexOf( "iPad" ) > -1  || platform.indexOf( "iPod" ) > -1 ) && wkversion && wkversion < 534 ) ||
        // Opera Mini
        ( w.operamini && ({}).toString.call( w.operamini ) === "[object OperaMini]" ) ||
        ( operammobilematch && omversion < 7458 )    ||
        //Android lte 2.1: Platform is Android and Webkit version is less than 533 (Android 2.2)
        ( ua.indexOf( "Android" ) > -1 && wkversion && wkversion < 533 ) ||
        // Firefox Mobile before 6.0 -
        ( ffversion && ffversion < 6 ) ||
        // WebOS less than 3
        ( "palmGetResource" in window && wkversion && wkversion < 534 )    ||
        // MeeGo
        ( ua.indexOf( "MeeGo" ) > -1 && ua.indexOf( "NokiaBrowser/8.5.0" ) > -1 ) ) {
        return false;
    }

    return true;
}

$.extend( $.support, {
    // Note, Chrome for iOS has an extremely quirky implementation of popstate.
    // We've chosen to take the shortest path to a bug fix here for issue #5426
    // See the following link for information about the regex chosen
    // https://developers.google.com/chrome/mobile/docs/user-agent#chrome_for_ios_user-agent
    pushState: "pushState" in history &&
        "replaceState" in history &&
        // When running inside a FF iframe, calling replaceState causes an error
        !( window.navigator.userAgent.indexOf( "Firefox" ) >= 0 && window.top !== window ) &&
        ( window.navigator.userAgent.search(/CriOS/) === -1 ),

    mediaquery: $.mobile.media( "only all" ),
    cssPseudoElement: !!propExists( "content" ),
    touchOverflow: !!propExists( "overflowScrolling" ),
    cssTransform3d: transform3dTest(),
    boxShadow: !!propExists( "boxShadow" ) && !bb,
    fixedPosition: fixedPosition(),
    scrollTop: ("pageXOffset" in window ||
        "scrollTop" in document.documentElement ||
        "scrollTop" in fakeBody[ 0 ]) && !webos && !operamini,

    dynamicBaseTag: baseTagTest(),
    cssPointerEvents: cssPointerEventsTest(),
    boundingRect: boundingRect(),
    inlineSVG: inlineSVG
});

fakeBody.remove();

// $.mobile.ajaxBlacklist is used to override ajaxEnabled on platforms that have known conflicts with hash history updates (BB5, Symbian)
// or that generally work better browsing in regular http for full page refreshes (Opera Mini)
// Note: This detection below is used as a last resort.
// We recommend only using these detection methods when all other more reliable/forward-looking approaches are not possible
nokiaLTE7_3 = (function() {

    var ua = window.navigator.userAgent;

    //The following is an attempt to match Nokia browsers that are running Symbian/s60, with webkit, version 7.3 or older
    return ua.indexOf( "Nokia" ) > -1 &&
            ( ua.indexOf( "Symbian/3" ) > -1 || ua.indexOf( "Series60/5" ) > -1 ) &&
            ua.indexOf( "AppleWebKit" ) > -1 &&
            ua.match( /(BrowserNG|NokiaBrowser)\/7\.[0-3]/ );
})();

// Support conditions that must be met in order to proceed
// default enhanced qualifications are media query support OR IE 7+

$.mobile.gradeA = function() {
    return ( ( $.support.mediaquery && $.support.cssPseudoElement ) || $.mobile.browser.oldIE && $.mobile.browser.oldIE >= 8 ) && ( $.support.boundingRect || $.fn.jquery.match(/1\.[0-7+]\.[0-9+]?/) !== null );
};

$.mobile.ajaxBlacklist =
            // BlackBerry browsers, pre-webkit
            window.blackberry && !window.WebKitPoint ||
            // Opera Mini
            operamini ||
            // Symbian webkits pre 7.3
            nokiaLTE7_3;

// Lastly, this workaround is the only way we've found so far to get pre 7.3 Symbian webkit devices
// to render the stylesheets when they're referenced before this script, as we'd recommend doing.
// This simply reappends the CSS in place, which for some reason makes it apply
if ( nokiaLTE7_3 ) {
    $(function() {
        $( "head link[rel='stylesheet']" ).attr( "rel", "alternate stylesheet" ).attr( "rel", "stylesheet" );
    });
}

// For ruling out shadows via css
if ( !$.support.boxShadow ) {
    $( "html" ).addClass( "ui-noboxshadow" );
}

})( jQuery );


(function( $, undefined ) {
    var $win = $.mobile.window, self,
        dummyFnToInitNavigate = function() {
        };

    $.event.special.beforenavigate = {
        setup: function() {
            $win.on( "navigate", dummyFnToInitNavigate );
        },

        teardown: function() {
            $win.off( "navigate", dummyFnToInitNavigate );
        }
    };

    $.event.special.navigate = self = {
        bound: false,

        pushStateEnabled: true,

        originalEventName: undefined,

        // If pushstate support is present and push state support is defined to
        // be true on the mobile namespace.
        isPushStateEnabled: function() {
            return $.support.pushState &&
                $.mobile.pushStateEnabled === true &&
                this.isHashChangeEnabled();
        },

        // !! assumes mobile namespace is present
        isHashChangeEnabled: function() {
            return $.mobile.hashListeningEnabled === true;
        },

        // TODO a lot of duplication between popstate and hashchange
        popstate: function( event ) {
            var newEvent = new $.Event( "navigate" ),
                beforeNavigate = new $.Event( "beforenavigate" ),
                state = event.originalEvent.state || {};

            beforeNavigate.originalEvent = event;
            $win.trigger( beforeNavigate );

            if ( beforeNavigate.isDefaultPrevented() ) {
                return;
            }

            if ( event.historyState ) {
                $.extend(state, event.historyState);
            }

            // Make sure the original event is tracked for the end
            // user to inspect incase they want to do something special
            newEvent.originalEvent = event;

            // NOTE we let the current stack unwind because any assignment to
            //      location.hash will stop the world and run this event handler. By
            //      doing this we create a similar behavior to hashchange on hash
            //      assignment
            setTimeout(function() {
                $win.trigger( newEvent, {
                    state: state
                });
            }, 0);
        },

        hashchange: function( event /*, data */ ) {
            var newEvent = new $.Event( "navigate" ),
                beforeNavigate = new $.Event( "beforenavigate" );

            beforeNavigate.originalEvent = event;
            $win.trigger( beforeNavigate );

            if ( beforeNavigate.isDefaultPrevented() ) {
                return;
            }

            // Make sure the original event is tracked for the end
            // user to inspect incase they want to do something special
            newEvent.originalEvent = event;

            // Trigger the hashchange with state provided by the user
            // that altered the hash
            $win.trigger( newEvent, {
                // Users that want to fully normalize the two events
                // will need to do history management down the stack and
                // add the state to the event before this binding is fired
                // TODO consider allowing for the explicit addition of callbacks
                //      to be fired before this value is set to avoid event timing issues
                state: event.hashchangeState || {}
            });
        },

        // TODO We really only want to set this up once
        //      but I'm not clear if there's a beter way to achieve
        //      this with the jQuery special event structure
        setup: function( /* data, namespaces */ ) {
            if ( self.bound ) {
                return;
            }

            self.bound = true;

            if ( self.isPushStateEnabled() ) {
                self.originalEventName = "popstate";
                $win.bind( "popstate.navigate", self.popstate );
            } else if ( self.isHashChangeEnabled() ) {
                self.originalEventName = "hashchange";
                $win.bind( "hashchange.navigate", self.hashchange );
            }
        }
    };
})( jQuery );



(function( $, undefined ) {
        var path, $base, dialogHashKey = "&ui-state=dialog";

        $.mobile.path = path = {
            uiStateKey: "&ui-state",

            // This scary looking regular expression parses an absolute URL or its relative
            // variants (protocol, site, document, query, and hash), into the various
            // components (protocol, host, path, query, fragment, etc that make up the
            // URL as well as some other commonly used sub-parts. When used with RegExp.exec()
            // or String.match, it parses the URL into a results array that looks like this:
            //
            //     [0]: http://jblas:password@mycompany.com:8080/mail/inbox?msg=1234&type=unread#msg-content
            //     [1]: http://jblas:password@mycompany.com:8080/mail/inbox?msg=1234&type=unread
            //     [2]: http://jblas:password@mycompany.com:8080/mail/inbox
            //     [3]: http://jblas:password@mycompany.com:8080
            //     [4]: http:
            //     [5]: //
            //     [6]: jblas:password@mycompany.com:8080
            //     [7]: jblas:password
            //     [8]: jblas
            //     [9]: password
            //    [10]: mycompany.com:8080
            //    [11]: mycompany.com
            //    [12]: 8080
            //    [13]: /mail/inbox
            //    [14]: /mail/
            //    [15]: inbox
            //    [16]: ?msg=1234&type=unread
            //    [17]: #msg-content
            //
            urlParseRE: /^\s*(((([^:\/#\?]+:)?(?:(\/\/)((?:(([^:@\/#\?]+)(?:\:([^:@\/#\?]+))?)@)?(([^:\/#\?\]\[]+|\[[^\/\]@#?]+\])(?:\:([0-9]+))?))?)?)?((\/?(?:[^\/\?#]+\/+)*)([^\?#]*)))?(\?[^#]+)?)(#.*)?/,

            // Abstraction to address xss (Issue #4787) by removing the authority in
            // browsers that auto-decode it. All references to location.href should be
            // replaced with a call to this method so that it can be dealt with properly here
            getLocation: function( url ) {
                var parsedUrl = this.parseUrl( url || location.href ),
                    uri = url ? parsedUrl : location,

                    // Make sure to parse the url or the location object for the hash because using
                    // location.hash is autodecoded in firefox, the rest of the url should be from
                    // the object (location unless we're testing) to avoid the inclusion of the
                    // authority
                    hash = parsedUrl.hash;

                // mimic the browser with an empty string when the hash is empty
                hash = hash === "#" ? "" : hash;

                return uri.protocol +
                    parsedUrl.doubleSlash +
                    uri.host +

                    // The pathname must start with a slash if there's a protocol, because you
                    // can't have a protocol followed by a relative path. Also, it's impossible to
                    // calculate absolute URLs from relative ones if the absolute one doesn't have
                    // a leading "/".
                    ( ( uri.protocol !== "" && uri.pathname.substring( 0, 1 ) !== "/" ) ?
                        "/" : "" ) +
                    uri.pathname +
                    uri.search +
                    hash;
            },

            //return the original document url
            getDocumentUrl: function( asParsedObject ) {
                return asParsedObject ? $.extend( {}, path.documentUrl ) : path.documentUrl.href;
            },

            parseLocation: function() {
                return this.parseUrl( this.getLocation() );
            },

            //Parse a URL into a structure that allows easy access to
            //all of the URL components by name.
            parseUrl: function( url ) {
                // If we're passed an object, we'll assume that it is
                // a parsed url object and just return it back to the caller.
                if ( $.type( url ) === "object" ) {
                    return url;
                }

                var matches = path.urlParseRE.exec( url || "" ) || [];

                    // Create an object that allows the caller to access the sub-matches
                    // by name. Note that IE returns an empty string instead of undefined,
                    // like all other browsers do, so we normalize everything so its consistent
                    // no matter what browser we're running on.
                    return {
                        href:         matches[  0 ] || "",
                        hrefNoHash:   matches[  1 ] || "",
                        hrefNoSearch: matches[  2 ] || "",
                        domain:       matches[  3 ] || "",
                        protocol:     matches[  4 ] || "",
                        doubleSlash:  matches[  5 ] || "",
                        authority:    matches[  6 ] || "",
                        username:     matches[  8 ] || "",
                        password:     matches[  9 ] || "",
                        host:         matches[ 10 ] || "",
                        hostname:     matches[ 11 ] || "",
                        port:         matches[ 12 ] || "",
                        pathname:     matches[ 13 ] || "",
                        directory:    matches[ 14 ] || "",
                        filename:     matches[ 15 ] || "",
                        search:       matches[ 16 ] || "",
                        hash:         matches[ 17 ] || ""
                    };
            },

            //Turn relPath into an asbolute path. absPath is
            //an optional absolute path which describes what
            //relPath is relative to.
            makePathAbsolute: function( relPath, absPath ) {
                var absStack,
                    relStack,
                    i, d;

                if ( relPath && relPath.charAt( 0 ) === "/" ) {
                    return relPath;
                }

                relPath = relPath || "";
                absPath = absPath ? absPath.replace( /^\/|(\/[^\/]*|[^\/]+)$/g, "" ) : "";

                absStack = absPath ? absPath.split( "/" ) : [];
                relStack = relPath.split( "/" );

                for ( i = 0; i < relStack.length; i++ ) {
                    d = relStack[ i ];
                    switch ( d ) {
                        case ".":
                            break;
                        case "..":
                            if ( absStack.length ) {
                                absStack.pop();
                            }
                            break;
                        default:
                            absStack.push( d );
                            break;
                    }
                }
                return "/" + absStack.join( "/" );
            },

            //Returns true if both urls have the same domain.
            isSameDomain: function( absUrl1, absUrl2 ) {
                return path.parseUrl( absUrl1 ).domain.toLowerCase() ===
                    path.parseUrl( absUrl2 ).domain.toLowerCase();
            },

            //Returns true for any relative variant.
            isRelativeUrl: function( url ) {
                // All relative Url variants have one thing in common, no protocol.
                return path.parseUrl( url ).protocol === "";
            },

            //Returns true for an absolute url.
            isAbsoluteUrl: function( url ) {
                return path.parseUrl( url ).protocol !== "";
            },

            //Turn the specified realtive URL into an absolute one. This function
            //can handle all relative variants (protocol, site, document, query, fragment).
            makeUrlAbsolute: function( relUrl, absUrl ) {
                if ( !path.isRelativeUrl( relUrl ) ) {
                    return relUrl;
                }

                if ( absUrl === undefined ) {
                    absUrl = this.documentBase;
                }

                var relObj = path.parseUrl( relUrl ),
                    absObj = path.parseUrl( absUrl ),
                    protocol = relObj.protocol || absObj.protocol,
                    doubleSlash = relObj.protocol ? relObj.doubleSlash : ( relObj.doubleSlash || absObj.doubleSlash ),
                    authority = relObj.authority || absObj.authority,
                    hasPath = relObj.pathname !== "",
                    pathname = path.makePathAbsolute( relObj.pathname || absObj.filename, absObj.pathname ),
                    search = relObj.search || ( !hasPath && absObj.search ) || "",
                    hash = relObj.hash;

                return protocol + doubleSlash + authority + pathname + search + hash;
            },

            //Add search (aka query) params to the specified url.
            addSearchParams: function( url, params ) {
                var u = path.parseUrl( url ),
                    p = ( typeof params === "object" ) ? $.param( params ) : params,
                    s = u.search || "?";
                return u.hrefNoSearch + s + ( s.charAt( s.length - 1 ) !== "?" ? "&" : "" ) + p + ( u.hash || "" );
            },

            convertUrlToDataUrl: function( absUrl ) {
                var result = absUrl,
                    u = path.parseUrl( absUrl );

                if ( path.isEmbeddedPage( u ) ) {
                    // For embedded pages, remove the dialog hash key as in getFilePath(),
                    // and remove otherwise the Data Url won't match the id of the embedded Page.
                    result = u.hash
                        .split( dialogHashKey )[0]
                        .replace( /^#/, "" )
                        .replace( /\?.*$/, "" );
                } else if ( path.isSameDomain( u, this.documentBase ) ) {
                    result = u.hrefNoHash.replace( this.documentBase.domain, "" ).split( dialogHashKey )[0];
                }

                return window.decodeURIComponent( result );
            },

            //get path from current hash, or from a file path
            get: function( newPath ) {
                if ( newPath === undefined ) {
                    newPath = path.parseLocation().hash;
                }
                return path.stripHash( newPath ).replace( /[^\/]*\.[^\/*]+$/, "" );
            },

            //set location hash to path
            set: function( path ) {
                location.hash = path;
            },

            //test if a given url (string) is a path
            //NOTE might be exceptionally naive
            isPath: function( url ) {
                return ( /\// ).test( url );
            },

            //return a url path with the window's location protocol/hostname/pathname removed
            clean: function( url ) {
                return url.replace( this.documentBase.domain, "" );
            },

            //just return the url without an initial #
            stripHash: function( url ) {
                return url.replace( /^#/, "" );
            },

            stripQueryParams: function( url ) {
                return url.replace( /\?.*$/, "" );
            },

            //remove the preceding hash, any query params, and dialog notations
            cleanHash: function( hash ) {
                return path.stripHash( hash.replace( /\?.*$/, "" ).replace( dialogHashKey, "" ) );
            },

            isHashValid: function( hash ) {
                return ( /^#[^#]+$/ ).test( hash );
            },

            //check whether a url is referencing the same domain, or an external domain or different protocol
            //could be mailto, etc
            isExternal: function( url ) {
                var u = path.parseUrl( url );

                return !!( u.protocol &&
                    ( u.domain.toLowerCase() !== this.documentUrl.domain.toLowerCase() ) );
            },

            hasProtocol: function( url ) {
                return ( /^(:?\w+:)/ ).test( url );
            },

            isEmbeddedPage: function( url ) {
                var u = path.parseUrl( url );

                //if the path is absolute, then we need to compare the url against
                //both the this.documentUrl and the documentBase. The main reason for this
                //is that links embedded within external documents will refer to the
                //application document, whereas links embedded within the application
                //document will be resolved against the document base.
                if ( u.protocol !== "" ) {
                    return ( !this.isPath(u.hash) && u.hash && ( u.hrefNoHash === this.documentUrl.hrefNoHash || ( this.documentBaseDiffers && u.hrefNoHash === this.documentBase.hrefNoHash ) ) );
                }
                return ( /^#/ ).test( u.href );
            },

            squash: function( url, resolutionUrl ) {
                var href, cleanedUrl, search, stateIndex, docUrl,
                    isPath = this.isPath( url ),
                    uri = this.parseUrl( url ),
                    preservedHash = uri.hash,
                    uiState = "";

                // produce a url against which we can resolve the provided path
                if ( !resolutionUrl ) {
                    if ( isPath ) {
                        resolutionUrl = path.getLocation();
                    } else {
                        docUrl = path.getDocumentUrl( true );
                        if ( path.isPath( docUrl.hash ) ) {
                            resolutionUrl = path.squash( docUrl.href );
                        } else {
                            resolutionUrl = docUrl.href;
                        }
                    }
                }

                // If the url is anything but a simple string, remove any preceding hash
                // eg #foo/bar -> foo/bar
                //    #foo -> #foo
                cleanedUrl = isPath ? path.stripHash( url ) : url;

                // If the url is a full url with a hash check if the parsed hash is a path
                // if it is, strip the #, and use it otherwise continue without change
                cleanedUrl = path.isPath( uri.hash ) ? path.stripHash( uri.hash ) : cleanedUrl;

                // Split the UI State keys off the href
                stateIndex = cleanedUrl.indexOf( this.uiStateKey );

                // store the ui state keys for use
                if ( stateIndex > -1 ) {
                    uiState = cleanedUrl.slice( stateIndex );
                    cleanedUrl = cleanedUrl.slice( 0, stateIndex );
                }

                // make the cleanedUrl absolute relative to the resolution url
                href = path.makeUrlAbsolute( cleanedUrl, resolutionUrl );

                // grab the search from the resolved url since parsing from
                // the passed url may not yield the correct result
                search = this.parseUrl( href ).search;

                // TODO all this crap is terrible, clean it up
                if ( isPath ) {
                    // reject the hash if it's a path or it's just a dialog key
                    if ( path.isPath( preservedHash ) || preservedHash.replace("#", "").indexOf( this.uiStateKey ) === 0) {
                        preservedHash = "";
                    }

                    // Append the UI State keys where it exists and it's been removed
                    // from the url
                    if ( uiState && preservedHash.indexOf( this.uiStateKey ) === -1) {
                        preservedHash += uiState;
                    }

                    // make sure that pound is on the front of the hash
                    if ( preservedHash.indexOf( "#" ) === -1 && preservedHash !== "" ) {
                        preservedHash = "#" + preservedHash;
                    }

                    // reconstruct each of the pieces with the new search string and hash
                    href = path.parseUrl( href );
                    href = href.protocol + href.doubleSlash + href.host + href.pathname + search +
                        preservedHash;
                } else {
                    href += href.indexOf( "#" ) > -1 ? uiState : "#" + uiState;
                }

                return href;
            },

            isPreservableHash: function( hash ) {
                return hash.replace( "#", "" ).indexOf( this.uiStateKey ) === 0;
            },

            // Escape weird characters in the hash if it is to be used as a selector
            hashToSelector: function( hash ) {
                var hasHash = ( hash.substring( 0, 1 ) === "#" );
                if ( hasHash ) {
                    hash = hash.substring( 1 );
                }
                return ( hasHash ? "#" : "" ) + hash.replace( /([!"#$%&'()*+,./:;<=>?@[\]^`{|}~])/g, "\\$1" );
            },

            // return the substring of a filepath before the dialogHashKey, for making a server
            // request
            getFilePath: function( path ) {
                return path && path.split( dialogHashKey )[0];
            },

            // check if the specified url refers to the first page in the main
            // application document.
            isFirstPageUrl: function( url ) {
                // We only deal with absolute paths.
                var u = path.parseUrl( path.makeUrlAbsolute( url, this.documentBase ) ),

                    // Does the url have the same path as the document?
                    samePath = u.hrefNoHash === this.documentUrl.hrefNoHash ||
                        ( this.documentBaseDiffers &&
                            u.hrefNoHash === this.documentBase.hrefNoHash ),

                    // Get the first page element.
                    fp = $.mobile.firstPage,

                    // Get the id of the first page element if it has one.
                    fpId = fp && fp[0] ? fp[0].id : undefined;

                // The url refers to the first page if the path matches the document and
                // it either has no hash value, or the hash is exactly equal to the id
                // of the first page element.
                return samePath &&
                    ( !u.hash ||
                        u.hash === "#" ||
                        ( fpId && u.hash.replace( /^#/, "" ) === fpId ) );
            },

            // Some embedded browsers, like the web view in Phone Gap, allow
            // cross-domain XHR requests if the document doing the request was loaded
            // via the file:// protocol. This is usually to allow the application to
            // "phone home" and fetch app specific data. We normally let the browser
            // handle external/cross-domain urls, but if the allowCrossDomainPages
            // option is true, we will allow cross-domain http/https requests to go
            // through our page loading logic.
            isPermittedCrossDomainRequest: function( docUrl, reqUrl ) {
                return $.mobile.allowCrossDomainPages &&
                    (docUrl.protocol === "file:" || docUrl.protocol === "content:") &&
                    reqUrl.search( /^https?:/ ) !== -1;
            }
        };

        path.documentUrl = path.parseLocation();

        $base = $( "head" ).find( "base" );

        path.documentBase = $base.length ?
            path.parseUrl( path.makeUrlAbsolute( $base.attr( "href" ), path.documentUrl.href ) ) :
            path.documentUrl;

        path.documentBaseDiffers = (path.documentUrl.hrefNoHash !== path.documentBase.hrefNoHash);

        //return the original document base url
        path.getDocumentBase = function( asParsedObject ) {
            return asParsedObject ? $.extend( {}, path.documentBase ) : path.documentBase.href;
        };

        // DEPRECATED as of 1.4.0 - remove in 1.5.0
        $.extend( $.mobile, {

            //return the original document url
            getDocumentUrl: path.getDocumentUrl,

            //return the original document base url
            getDocumentBase: path.getDocumentBase
        });
})( jQuery );



(function( $, undefined ) {
    $.mobile.History = function( stack, index ) {
        this.stack = stack || [];
        this.activeIndex = index || 0;
    };

    $.extend($.mobile.History.prototype, {
        getActive: function() {
            return this.stack[ this.activeIndex ];
        },

        getLast: function() {
            return this.stack[ this.previousIndex ];
        },

        getNext: function() {
            return this.stack[ this.activeIndex + 1 ];
        },

        getPrev: function() {
            return this.stack[ this.activeIndex - 1 ];
        },

        // addNew is used whenever a new page is added
        add: function( url, data ) {
            data = data || {};

            //if there's forward history, wipe it
            if ( this.getNext() ) {
                this.clearForward();
            }

            // if the hash is included in the data make sure the shape
            // is consistent for comparison
            if ( data.hash && data.hash.indexOf( "#" ) === -1) {
                data.hash = "#" + data.hash;
            }

            data.url = url;
            this.stack.push( data );
            this.activeIndex = this.stack.length - 1;
        },

        //wipe urls ahead of active index
        clearForward: function() {
            this.stack = this.stack.slice( 0, this.activeIndex + 1 );
        },

        find: function( url, stack, earlyReturn ) {
            stack = stack || this.stack;

            var entry, i, length = stack.length, index;

            for ( i = 0; i < length; i++ ) {
                entry = stack[i];

                if ( decodeURIComponent(url) === decodeURIComponent(entry.url) ||
                    decodeURIComponent(url) === decodeURIComponent(entry.hash) ) {
                    index = i;

                    if ( earlyReturn ) {
                        return index;
                    }
                }
            }

            return index;
        },

        closest: function( url ) {
            var closest, a = this.activeIndex;

            // First, take the slice of the history stack before the current index and search
            // for a url match. If one is found, we'll avoid avoid looking through forward history
            // NOTE the preference for backward history movement is driven by the fact that
            //      most mobile browsers only have a dedicated back button, and users rarely use
            //      the forward button in desktop browser anyhow
            closest = this.find( url, this.stack.slice(0, a) );

            // If nothing was found in backward history check forward. The `true`
            // value passed as the third parameter causes the find method to break
            // on the first match in the forward history slice. The starting index
            // of the slice must then be added to the result to get the element index
            // in the original history stack :( :(
            //
            // TODO this is hyper confusing and should be cleaned up (ugh so bad)
            if ( closest === undefined ) {
                closest = this.find( url, this.stack.slice(a), true );
                closest = closest === undefined ? closest : closest + a;
            }

            return closest;
        },

        direct: function( opts ) {
            var newActiveIndex = this.closest( opts.url ), a = this.activeIndex;

            // save new page index, null check to prevent falsey 0 result
            // record the previous index for reference
            if ( newActiveIndex !== undefined ) {
                this.activeIndex = newActiveIndex;
                this.previousIndex = a;
            }

            // invoke callbacks where appropriate
            //
            // TODO this is also convoluted and confusing
            if ( newActiveIndex < a ) {
                ( opts.present || opts.back || $.noop )( this.getActive(), "back" );
            } else if ( newActiveIndex > a ) {
                ( opts.present || opts.forward || $.noop )( this.getActive(), "forward" );
            } else if ( newActiveIndex === undefined && opts.missing ) {
                opts.missing( this.getActive() );
            }
        }
    });
})( jQuery );



(function( $, undefined ) {
    var path = $.mobile.path,
        initialHref = location.href;

    $.mobile.Navigator = function( history ) {
        this.history = history;
        this.ignoreInitialHashChange = true;

        $.mobile.window.bind({
            "popstate.history": $.proxy( this.popstate, this ),
            "hashchange.history": $.proxy( this.hashchange, this )
        });
    };

    $.extend($.mobile.Navigator.prototype, {
        squash: function( url, data ) {
            var state, href, hash = path.isPath(url) ? path.stripHash(url) : url;

            href = path.squash( url );

            // make sure to provide this information when it isn't explicitly set in the
            // data object that was passed to the squash method
            state = $.extend({
                hash: hash,
                url: href
            }, data);

            // replace the current url with the new href and store the state
            // Note that in some cases we might be replacing an url with the
            // same url. We do this anyways because we need to make sure that
            // all of our history entries have a state object associated with
            // them. This allows us to work around the case where $.mobile.back()
            // is called to transition from an external page to an embedded page.
            // In that particular case, a hashchange event is *NOT* generated by the browser.
            // Ensuring each history entry has a state object means that onPopState()
            // will always trigger our hashchange callback even when a hashchange event
            // is not fired.
            window.history.replaceState( state, state.title || document.title, href );

            return state;
        },

        hash: function( url, href ) {
            var parsed, loc, hash, resolved;

            // Grab the hash for recording. If the passed url is a path
            // we used the parsed version of the squashed url to reconstruct,
            // otherwise we assume it's a hash and store it directly
            parsed = path.parseUrl( url );
            loc = path.parseLocation();

            if ( loc.pathname + loc.search === parsed.pathname + parsed.search ) {
                // If the pathname and search of the passed url is identical to the current loc
                // then we must use the hash. Otherwise there will be no event
                // eg, url = "/foo/bar?baz#bang", location.href = "http://example.com/foo/bar?baz"
                hash = parsed.hash ? parsed.hash : parsed.pathname + parsed.search;
            } else if ( path.isPath(url) ) {
                resolved = path.parseUrl( href );
                // If the passed url is a path, make it domain relative and remove any trailing hash
                hash = resolved.pathname + resolved.search + (path.isPreservableHash( resolved.hash )? resolved.hash.replace( "#", "" ) : "");
            } else {
                hash = url;
            }

            return hash;
        },

        // TODO reconsider name
        go: function( url, data, noEvents ) {
            var state, href, hash, popstateEvent,
                isPopStateEvent = $.event.special.navigate.isPushStateEnabled();

            // Get the url as it would look squashed on to the current resolution url
            href = path.squash( url );

            // sort out what the hash sould be from the url
            hash = this.hash( url, href );

            // Here we prevent the next hash change or popstate event from doing any
            // history management. In the case of hashchange we don't swallow it
            // if there will be no hashchange fired (since that won't reset the value)
            // and will swallow the following hashchange
            if ( noEvents && hash !== path.stripHash(path.parseLocation().hash) ) {
                this.preventNextHashChange = noEvents;
            }

            // IMPORTANT in the case where popstate is supported the event will be triggered
            //      directly, stopping further execution - ie, interupting the flow of this
            //      method call to fire bindings at this expression. Below the navigate method
            //      there is a binding to catch this event and stop its propagation.
            //
            //      We then trigger a new popstate event on the window with a null state
            //      so that the navigate events can conclude their work properly
            //
            // if the url is a path we want to preserve the query params that are available on
            // the current url.
            this.preventHashAssignPopState = true;
            window.location.hash = hash;

            // If popstate is enabled and the browser triggers `popstate` events when the hash
            // is set (this often happens immediately in browsers like Chrome), then the
            // this flag will be set to false already. If it's a browser that does not trigger
            // a `popstate` on hash assignement or `replaceState` then we need avoid the branch
            // that swallows the event created by the popstate generated by the hash assignment
            // At the time of this writing this happens with Opera 12 and some version of IE
            this.preventHashAssignPopState = false;

            state = $.extend({
                url: href,
                hash: hash,
                title: document.title
            }, data);

            if ( isPopStateEvent ) {
                popstateEvent = new $.Event( "popstate" );
                popstateEvent.originalEvent = {
                    type: "popstate",
                    state: null
                };

                this.squash( url, state );

                // Trigger a new faux popstate event to replace the one that we
                // caught that was triggered by the hash setting above.
                if ( !noEvents ) {
                    this.ignorePopState = true;
                    $.mobile.window.trigger( popstateEvent );
                }
            }

            // record the history entry so that the information can be included
            // in hashchange event driven navigate events in a similar fashion to
            // the state that's provided by popstate
            this.history.add( state.url, state );
        },

        // This binding is intended to catch the popstate events that are fired
        // when execution of the `$.navigate` method stops at window.location.hash = url;
        // and completely prevent them from propagating. The popstate event will then be
        // retriggered after execution resumes
        //
        // TODO grab the original event here and use it for the synthetic event in the
        //      second half of the navigate execution that will follow this binding
        popstate: function( event ) {
            var hash, state;

            // Partly to support our test suite which manually alters the support
            // value to test hashchange. Partly to prevent all around weirdness
            if ( !$.event.special.navigate.isPushStateEnabled() ) {
                return;
            }

            // If this is the popstate triggered by the actual alteration of the hash
            // prevent it completely. History is tracked manually
            if ( this.preventHashAssignPopState ) {
                this.preventHashAssignPopState = false;
                event.stopImmediatePropagation();
                return;
            }

            // if this is the popstate triggered after the `replaceState` call in the go
            // method, then simply ignore it. The history entry has already been captured
            if ( this.ignorePopState ) {
                this.ignorePopState = false;
                return;
            }

            // If there is no state, and the history stack length is one were
            // probably getting the page load popstate fired by browsers like chrome
            // avoid it and set the one time flag to false.
            // TODO: Do we really need all these conditions? Comparing location hrefs
            // should be sufficient.
            if ( !event.originalEvent.state &&
                this.history.stack.length === 1 &&
                this.ignoreInitialHashChange ) {
                this.ignoreInitialHashChange = false;

                if ( location.href === initialHref ) {
                    event.preventDefault();
                    return;
                }
            }

            // account for direct manipulation of the hash. That is, we will receive a popstate
            // when the hash is changed by assignment, and it won't have a state associated. We
            // then need to squash the hash. See below for handling of hash assignment that
            // matches an existing history entry
            // TODO it might be better to only add to the history stack
            //      when the hash is adjacent to the active history entry
            hash = path.parseLocation().hash;
            if ( !event.originalEvent.state && hash ) {
                // squash the hash that's been assigned on the URL with replaceState
                // also grab the resulting state object for storage
                state = this.squash( hash );

                // record the new hash as an additional history entry
                // to match the browser's treatment of hash assignment
                this.history.add( state.url, state );

                // pass the newly created state information
                // along with the event
                event.historyState = state;

                // do not alter history, we've added a new history entry
                // so we know where we are
                return;
            }

            // If all else fails this is a popstate that comes from the back or forward buttons
            // make sure to set the state of our history stack properly, and record the directionality
            this.history.direct({
                url: (event.originalEvent.state || {}).url || hash,

                // When the url is either forward or backward in history include the entry
                // as data on the event object for merging as data in the navigate event
                present: function( historyEntry, direction ) {
                    // make sure to create a new object to pass down as the navigate event data
                    event.historyState = $.extend({}, historyEntry);
                    event.historyState.direction = direction;
                }
            });
        },

        // NOTE must bind before `navigate` special event hashchange binding otherwise the
        //      navigation data won't be attached to the hashchange event in time for those
        //      bindings to attach it to the `navigate` special event
        // TODO add a check here that `hashchange.navigate` is bound already otherwise it's
        //      broken (exception?)
        hashchange: function( event ) {
            var history, hash;

            // If hashchange listening is explicitly disabled or pushstate is supported
            // avoid making use of the hashchange handler.
            if (!$.event.special.navigate.isHashChangeEnabled() ||
                $.event.special.navigate.isPushStateEnabled() ) {
                return;
            }

            // On occasion explicitly want to prevent the next hash from propogating because we only
            // with to alter the url to represent the new state do so here
            if ( this.preventNextHashChange ) {
                this.preventNextHashChange = false;
                event.stopImmediatePropagation();
                return;
            }

            history = this.history;
            hash = path.parseLocation().hash;

            // If this is a hashchange caused by the back or forward button
            // make sure to set the state of our history stack properly
            this.history.direct({
                url: hash,

                // When the url is either forward or backward in history include the entry
                // as data on the event object for merging as data in the navigate event
                present: function( historyEntry, direction ) {
                    // make sure to create a new object to pass down as the navigate event data
                    event.hashchangeState = $.extend({}, historyEntry);
                    event.hashchangeState.direction = direction;
                },

                // When we don't find a hash in our history clearly we're aiming to go there
                // record the entry as new for future traversal
                //
                // NOTE it's not entirely clear that this is the right thing to do given that we
                //      can't know the users intention. It might be better to explicitly _not_
                //      support location.hash assignment in preference to $.navigate calls
                // TODO first arg to add should be the href, but it causes issues in identifying
                //      embeded pages
                missing: function() {
                    history.add( hash, {
                        hash: hash,
                        title: document.title
                    });
                }
            });
        }
    });
})( jQuery );



(function( $, undefined ) {
    // TODO consider queueing navigation activity until previous activities have completed
    //      so that end users don't have to think about it. Punting for now
    // TODO !! move the event bindings into callbacks on the navigate event
    $.mobile.navigate = function( url, data, noEvents ) {
        $.mobile.navigate.navigator.go( url, data, noEvents );
    };

    // expose the history on the navigate method in anticipation of full integration with
    // existing navigation functionalty that is tightly coupled to the history information
    $.mobile.navigate.history = new $.mobile.History();

    // instantiate an instance of the navigator for use within the $.navigate method
    $.mobile.navigate.navigator = new $.mobile.Navigator( $.mobile.navigate.history );

    var loc = $.mobile.path.parseLocation();
    $.mobile.navigate.history.add( loc.href, {hash: loc.hash} );
})( jQuery );


(function( $, undefined ) {
    var props = {
            "animation": {},
            "transition": {}
        },
        testElement = document.createElement( "a" ),
        vendorPrefixes = [ "", "webkit-", "moz-", "o-" ];

    $.each( [ "animation", "transition" ], function( i, test ) {

        // Get correct name for test
        var testName = ( i === 0 ) ? test + "-" + "name" : test;

        $.each( vendorPrefixes, function( j, prefix ) {
            if ( testElement.style[ $.camelCase( prefix + testName ) ] !== undefined ) {
                 props[ test ][ "prefix" ] = prefix;
                return false;
            }
        });

        // Set event and duration names for later use
        props[ test ][ "duration" ] =
            $.camelCase( props[ test ][ "prefix" ] + test + "-" + "duration" );
        props[ test ][ "event" ] =
            $.camelCase( props[ test ][ "prefix" ] + test + "-" + "end" );

        // All lower case if not a vendor prop
        if ( props[ test ][ "prefix" ] === "" ) {
            props[ test ][ "event" ] = props[ test ][ "event" ].toLowerCase();
        }
    });

    // If a valid prefix was found then the it is supported by the browser
    $.support.cssTransitions = ( props[ "transition" ][ "prefix" ] !== undefined );
    $.support.cssAnimations = ( props[ "animation" ][ "prefix" ] !== undefined );

    // Remove the testElement
    $( testElement ).remove();

    // Animation complete callback
    $.fn.animationComplete = function( callback, type, fallbackTime ) {
        var timer, duration,
            that = this,
            eventBinding = function() {

                // Clear the timer so we don't call callback twice
                clearTimeout( timer );
                callback.apply( this, arguments );
            },
            animationType = ( !type || type === "animation" ) ? "animation" : "transition";

        // Make sure selected type is supported by browser
        if ( ( $.support.cssTransitions && animationType === "transition" ) ||
            ( $.support.cssAnimations && animationType === "animation" ) ) {

            // If a fallback time was not passed set one
            if ( fallbackTime === undefined ) {

                // Make sure the was not bound to document before checking .css
                if ( $( this ).context !== document ) {

                    // Parse the durration since its in second multiple by 1000 for milliseconds
                    // Multiply by 3 to make sure we give the animation plenty of time.
                    duration = parseFloat(
                        $( this ).css( props[ animationType ].duration )
                    ) * 3000;
                }

                // If we could not read a duration use the default
                if ( duration === 0 || duration === undefined || isNaN( duration ) ) {
                    duration = $.fn.animationComplete.defaultDuration;
                }
            }

            // Sets up the fallback if event never comes
            timer = setTimeout( function() {
                $( that ).off( props[ animationType ].event, eventBinding );
                callback.apply( that );
            }, duration );

            // Bind the event
            return $( this ).one( props[ animationType ].event, eventBinding );
        } else {

            // CSS animation / transitions not supported
            // Defer execution for consistency between webkit/non webkit
            setTimeout( $.proxy( callback, this ), 0 );
            return $( this );
        }
    };

    // Allow default callback to be configured on mobileInit
    $.fn.animationComplete.defaultDuration = 1000;
})( jQuery );

// This plugin is an experiment for abstracting away the touch and mouse
// events so that developers don't have to worry about which method of input
// the device their document is loaded on supports.
//
// The idea here is to allow the developer to register listeners for the
// basic mouse events, such as mousedown, mousemove, mouseup, and click,
// and the plugin will take care of registering the correct listeners
// behind the scenes to invoke the listener at the fastest possible time
// for that device, while still retaining the order of event firing in
// the traditional mouse environment, should multiple handlers be registered
// on the same element for different events.
//
// The current version exposes the following virtual events to jQuery bind methods:
// "vmouseover vmousedown vmousemove vmouseup vclick vmouseout vmousecancel"

(function( $, window, document, undefined ) {

var dataPropertyName = "virtualMouseBindings",
    touchTargetPropertyName = "virtualTouchID",
    virtualEventNames = "vmouseover vmousedown vmousemove vmouseup vclick vmouseout vmousecancel".split( " " ),
    touchEventProps = "clientX clientY pageX pageY screenX screenY".split( " " ),
    mouseHookProps = $.event.mouseHooks ? $.event.mouseHooks.props : [],
    mouseEventProps = $.event.props.concat( mouseHookProps ),
    activeDocHandlers = {},
    resetTimerID = 0,
    startX = 0,
    startY = 0,
    didScroll = false,
    clickBlockList = [],
    blockMouseTriggers = false,
    blockTouchTriggers = false,
    eventCaptureSupported = "addEventListener" in document,
    $document = $( document ),
    nextTouchID = 1,
    lastTouchID = 0, threshold,
    i;

$.vmouse = {
    moveDistanceThreshold: 10,
    clickDistanceThreshold: 10,
    resetTimerDuration: 1500
};

function getNativeEvent( event ) {

    while ( event && typeof event.originalEvent !== "undefined" ) {
        event = event.originalEvent;
    }
    return event;
}

function createVirtualEvent( event, eventType ) {

    var t = event.type,
        oe, props, ne, prop, ct, touch, i, j, len;

    event = $.Event( event );
    event.type = eventType;

    oe = event.originalEvent;
    props = $.event.props;

    // addresses separation of $.event.props in to $.event.mouseHook.props and Issue 3280
    // https://github.com/jquery/jquery-mobile/issues/3280
    if ( t.search( /^(mouse|click)/ ) > -1 ) {
        props = mouseEventProps;
    }

    // copy original event properties over to the new event
    // this would happen if we could call $.event.fix instead of $.Event
    // but we don't have a way to force an event to be fixed multiple times
    if ( oe ) {
        for ( i = props.length, prop; i; ) {
            prop = props[ --i ];
            event[ prop ] = oe[ prop ];
        }
    }

    // make sure that if the mouse and click virtual events are generated
    // without a .which one is defined
    if ( t.search(/mouse(down|up)|click/) > -1 && !event.which ) {
        event.which = 1;
    }

    if ( t.search(/^touch/) !== -1 ) {
        ne = getNativeEvent( oe );
        t = ne.touches;
        ct = ne.changedTouches;
        touch = ( t && t.length ) ? t[0] : ( ( ct && ct.length ) ? ct[ 0 ] : undefined );

        if ( touch ) {
            for ( j = 0, len = touchEventProps.length; j < len; j++) {
                prop = touchEventProps[ j ];
                event[ prop ] = touch[ prop ];
            }
        }
    }

    return event;
}

function getVirtualBindingFlags( element ) {

    var flags = {},
        b, k;

    while ( element ) {

        b = $.data( element, dataPropertyName );

        for (  k in b ) {
            if ( b[ k ] ) {
                flags[ k ] = flags.hasVirtualBinding = true;
            }
        }
        element = element.parentNode;
    }
    return flags;
}

function getClosestElementWithVirtualBinding( element, eventType ) {
    var b;
    while ( element ) {

        b = $.data( element, dataPropertyName );

        if ( b && ( !eventType || b[ eventType ] ) ) {
            return element;
        }
        element = element.parentNode;
    }
    return null;
}

function enableTouchBindings() {
    blockTouchTriggers = false;
}

function disableTouchBindings() {
    blockTouchTriggers = true;
}

function enableMouseBindings() {
    lastTouchID = 0;
    clickBlockList.length = 0;
    blockMouseTriggers = false;

    // When mouse bindings are enabled, our
    // touch bindings are disabled.
    disableTouchBindings();
}

function disableMouseBindings() {
    // When mouse bindings are disabled, our
    // touch bindings are enabled.
    enableTouchBindings();
}

function startResetTimer() {
    clearResetTimer();
    resetTimerID = setTimeout( function() {
        resetTimerID = 0;
        enableMouseBindings();
    }, $.vmouse.resetTimerDuration );
}

function clearResetTimer() {
    if ( resetTimerID ) {
        clearTimeout( resetTimerID );
        resetTimerID = 0;
    }
}

function triggerVirtualEvent( eventType, event, flags ) {
    var ve;

    if ( ( flags && flags[ eventType ] ) ||
                ( !flags && getClosestElementWithVirtualBinding( event.target, eventType ) ) ) {

        ve = createVirtualEvent( event, eventType );

        $( event.target).trigger( ve );
    }

    return ve;
}

function mouseEventCallback( event ) {
    var touchID = $.data( event.target, touchTargetPropertyName ),
        ve;

    if ( !blockMouseTriggers && ( !lastTouchID || lastTouchID !== touchID ) ) {
        ve = triggerVirtualEvent( "v" + event.type, event );
        if ( ve ) {
            if ( ve.isDefaultPrevented() ) {
                event.preventDefault();
            }
            if ( ve.isPropagationStopped() ) {
                event.stopPropagation();
            }
            if ( ve.isImmediatePropagationStopped() ) {
                event.stopImmediatePropagation();
            }
        }
    }
}

function handleTouchStart( event ) {

    var touches = getNativeEvent( event ).touches,
        target, flags, t;

    if ( touches && touches.length === 1 ) {

        target = event.target;
        flags = getVirtualBindingFlags( target );

        if ( flags.hasVirtualBinding ) {

            lastTouchID = nextTouchID++;
            $.data( target, touchTargetPropertyName, lastTouchID );

            clearResetTimer();

            disableMouseBindings();
            didScroll = false;

            t = getNativeEvent( event ).touches[ 0 ];
            startX = t.pageX;
            startY = t.pageY;

            triggerVirtualEvent( "vmouseover", event, flags );
            triggerVirtualEvent( "vmousedown", event, flags );
        }
    }
}

function handleScroll( event ) {
    if ( blockTouchTriggers ) {
        return;
    }

    if ( !didScroll ) {
        triggerVirtualEvent( "vmousecancel", event, getVirtualBindingFlags( event.target ) );
    }

    didScroll = true;
    startResetTimer();
}

function handleTouchMove( event ) {
    if ( blockTouchTriggers ) {
        return;
    }

    var t = getNativeEvent( event ).touches[ 0 ],
        didCancel = didScroll,
        moveThreshold = $.vmouse.moveDistanceThreshold,
        flags = getVirtualBindingFlags( event.target );

        didScroll = didScroll ||
            ( Math.abs( t.pageX - startX ) > moveThreshold ||
                Math.abs( t.pageY - startY ) > moveThreshold );

    if ( didScroll && !didCancel ) {
        triggerVirtualEvent( "vmousecancel", event, flags );
    }

    triggerVirtualEvent( "vmousemove", event, flags );
    startResetTimer();
}

function handleTouchEnd( event ) {
    if ( blockTouchTriggers ) {
        return;
    }

    disableTouchBindings();

    var flags = getVirtualBindingFlags( event.target ),
        ve, t;
    triggerVirtualEvent( "vmouseup", event, flags );

    if ( !didScroll ) {
        ve = triggerVirtualEvent( "vclick", event, flags );
        if ( ve && ve.isDefaultPrevented() ) {
            // The target of the mouse events that follow the touchend
            // event don't necessarily match the target used during the
            // touch. This means we need to rely on coordinates for blocking
            // any click that is generated.
            t = getNativeEvent( event ).changedTouches[ 0 ];
            clickBlockList.push({
                touchID: lastTouchID,
                x: t.clientX,
                y: t.clientY
            });

            // Prevent any mouse events that follow from triggering
            // virtual event notifications.
            blockMouseTriggers = true;
        }
    }
    triggerVirtualEvent( "vmouseout", event, flags);
    didScroll = false;

    startResetTimer();
}

function hasVirtualBindings( ele ) {
    var bindings = $.data( ele, dataPropertyName ),
        k;

    if ( bindings ) {
        for ( k in bindings ) {
            if ( bindings[ k ] ) {
                return true;
            }
        }
    }
    return false;
}

function dummyMouseHandler() {}

function getSpecialEventObject( eventType ) {
    var realType = eventType.substr( 1 );

    return {
        setup: function(/* data, namespace */) {
            // If this is the first virtual mouse binding for this element,
            // add a bindings object to its data.

            if ( !hasVirtualBindings( this ) ) {
                $.data( this, dataPropertyName, {} );
            }

            // If setup is called, we know it is the first binding for this
            // eventType, so initialize the count for the eventType to zero.
            var bindings = $.data( this, dataPropertyName );
            bindings[ eventType ] = true;

            // If this is the first virtual mouse event for this type,
            // register a global handler on the document.

            activeDocHandlers[ eventType ] = ( activeDocHandlers[ eventType ] || 0 ) + 1;

            if ( activeDocHandlers[ eventType ] === 1 ) {
                $document.bind( realType, mouseEventCallback );
            }

            // Some browsers, like Opera Mini, won't dispatch mouse/click events
            // for elements unless they actually have handlers registered on them.
            // To get around this, we register dummy handlers on the elements.

            $( this ).bind( realType, dummyMouseHandler );

            // For now, if event capture is not supported, we rely on mouse handlers.
            if ( eventCaptureSupported ) {
                // If this is the first virtual mouse binding for the document,
                // register our touchstart handler on the document.

                activeDocHandlers[ "touchstart" ] = ( activeDocHandlers[ "touchstart" ] || 0) + 1;

                if ( activeDocHandlers[ "touchstart" ] === 1 ) {
                    $document.bind( "touchstart", handleTouchStart )
                        .bind( "touchend", handleTouchEnd )

                        // On touch platforms, touching the screen and then dragging your finger
                        // causes the window content to scroll after some distance threshold is
                        // exceeded. On these platforms, a scroll prevents a click event from being
                        // dispatched, and on some platforms, even the touchend is suppressed. To
                        // mimic the suppression of the click event, we need to watch for a scroll
                        // event. Unfortunately, some platforms like iOS don't dispatch scroll
                        // events until *AFTER* the user lifts their finger (touchend). This means
                        // we need to watch both scroll and touchmove events to figure out whether
                        // or not a scroll happenens before the touchend event is fired.

                        .bind( "touchmove", handleTouchMove )
                        .bind( "scroll", handleScroll );
                }
            }
        },

        teardown: function(/* data, namespace */) {
            // If this is the last virtual binding for this eventType,
            // remove its global handler from the document.

            --activeDocHandlers[ eventType ];

            if ( !activeDocHandlers[ eventType ] ) {
                $document.unbind( realType, mouseEventCallback );
            }

            if ( eventCaptureSupported ) {
                // If this is the last virtual mouse binding in existence,
                // remove our document touchstart listener.

                --activeDocHandlers[ "touchstart" ];

                if ( !activeDocHandlers[ "touchstart" ] ) {
                    $document.unbind( "touchstart", handleTouchStart )
                        .unbind( "touchmove", handleTouchMove )
                        .unbind( "touchend", handleTouchEnd )
                        .unbind( "scroll", handleScroll );
                }
            }

            var $this = $( this ),
                bindings = $.data( this, dataPropertyName );

            // teardown may be called when an element was
            // removed from the DOM. If this is the case,
            // jQuery core may have already stripped the element
            // of any data bindings so we need to check it before
            // using it.
            if ( bindings ) {
                bindings[ eventType ] = false;
            }

            // Unregister the dummy event handler.

            $this.unbind( realType, dummyMouseHandler );

            // If this is the last virtual mouse binding on the
            // element, remove the binding data from the element.

            if ( !hasVirtualBindings( this ) ) {
                $this.removeData( dataPropertyName );
            }
        }
    };
}

// Expose our custom events to the jQuery bind/unbind mechanism.

for ( i = 0; i < virtualEventNames.length; i++ ) {
    $.event.special[ virtualEventNames[ i ] ] = getSpecialEventObject( virtualEventNames[ i ] );
}

// Add a capture click handler to block clicks.
// Note that we require event capture support for this so if the device
// doesn't support it, we punt for now and rely solely on mouse events.
if ( eventCaptureSupported ) {
    document.addEventListener( "click", function( e ) {
        var cnt = clickBlockList.length,
            target = e.target,
            x, y, ele, i, o, touchID;

        if ( cnt ) {
            x = e.clientX;
            y = e.clientY;
            threshold = $.vmouse.clickDistanceThreshold;

            // The idea here is to run through the clickBlockList to see if
            // the current click event is in the proximity of one of our
            // vclick events that had preventDefault() called on it. If we find
            // one, then we block the click.
            //
            // Why do we have to rely on proximity?
            //
            // Because the target of the touch event that triggered the vclick
            // can be different from the target of the click event synthesized
            // by the browser. The target of a mouse/click event that is synthesized
            // from a touch event seems to be implementation specific. For example,
            // some browsers will fire mouse/click events for a link that is near
            // a touch event, even though the target of the touchstart/touchend event
            // says the user touched outside the link. Also, it seems that with most
            // browsers, the target of the mouse/click event is not calculated until the
            // time it is dispatched, so if you replace an element that you touched
            // with another element, the target of the mouse/click will be the new
            // element underneath that point.
            //
            // Aside from proximity, we also check to see if the target and any
            // of its ancestors were the ones that blocked a click. This is necessary
            // because of the strange mouse/click target calculation done in the
            // Android 2.1 browser, where if you click on an element, and there is a
            // mouse/click handler on one of its ancestors, the target will be the
            // innermost child of the touched element, even if that child is no where
            // near the point of touch.

            ele = target;

            while ( ele ) {
                for ( i = 0; i < cnt; i++ ) {
                    o = clickBlockList[ i ];
                    touchID = 0;

                    if ( ( ele === target && Math.abs( o.x - x ) < threshold && Math.abs( o.y - y ) < threshold ) ||
                                $.data( ele, touchTargetPropertyName ) === o.touchID ) {
                        // XXX: We may want to consider removing matches from the block list
                        //      instead of waiting for the reset timer to fire.
                        e.preventDefault();
                        e.stopPropagation();
                        return;
                    }
                }
                ele = ele.parentNode;
            }
        }
    }, true);
}
})( jQuery, window, document );


(function( $, window, undefined ) {
    var $document = $( document ),
        supportTouch = $.mobile.support.touch,
        scrollEvent = "touchmove scroll",
        touchStartEvent = supportTouch ? "touchstart" : "mousedown",
        touchStopEvent = supportTouch ? "touchend" : "mouseup",
        touchMoveEvent = supportTouch ? "touchmove" : "mousemove";

    // setup new event shortcuts
    $.each( ( "touchstart touchmove touchend " +
        "tap taphold " +
        "swipe swipeleft swiperight " +
        "scrollstart scrollstop" ).split( " " ), function( i, name ) {

        $.fn[ name ] = function( fn ) {
            return fn ? this.bind( name, fn ) : this.trigger( name );
        };

        // jQuery < 1.8
        if ( $.attrFn ) {
            $.attrFn[ name ] = true;
        }
    });

    function triggerCustomEvent( obj, eventType, event, bubble ) {
        var originalType = event.type;
        event.type = eventType;
        if ( bubble ) {
            $.event.trigger( event, undefined, obj );
        } else {
            $.event.dispatch.call( obj, event );
        }
        event.type = originalType;
    }

    // also handles scrollstop
    $.event.special.scrollstart = {

        enabled: true,
        setup: function() {

            var thisObject = this,
                $this = $( thisObject ),
                scrolling,
                timer;

            function trigger( event, state ) {
                scrolling = state;
                triggerCustomEvent( thisObject, scrolling ? "scrollstart" : "scrollstop", event );
            }

            // iPhone triggers scroll after a small delay; use touchmove instead
            $this.bind( scrollEvent, function( event ) {

                if ( !$.event.special.scrollstart.enabled ) {
                    return;
                }

                if ( !scrolling ) {
                    trigger( event, true );
                }

                clearTimeout( timer );
                timer = setTimeout( function() {
                    trigger( event, false );
                }, 50 );
            });
        },
        teardown: function() {
            $( this ).unbind( scrollEvent );
        }
    };

    // also handles taphold
    $.event.special.tap = {
        tapholdThreshold: 750,
        emitTapOnTaphold: true,
        setup: function() {
            var thisObject = this,
                $this = $( thisObject ),
                isTaphold = false;

            $this.bind( "vmousedown", function( event ) {
                isTaphold = false;
                if ( event.which && event.which !== 1 ) {
                    return false;
                }

                var origTarget = event.target,
                    timer;

                function clearTapTimer() {
                    clearTimeout( timer );
                }

                function clearTapHandlers() {
                    clearTapTimer();

                    $this.unbind( "vclick", clickHandler )
                        .unbind( "vmouseup", clearTapTimer );
                    $document.unbind( "vmousecancel", clearTapHandlers );
                }

                function clickHandler( event ) {
                    clearTapHandlers();

                    // ONLY trigger a 'tap' event if the start target is
                    // the same as the stop target.
                    if ( !isTaphold && origTarget === event.target ) {
                        triggerCustomEvent( thisObject, "tap", event );
                    } else if ( isTaphold ) {
                        event.preventDefault();
                    }
                }

                $this.bind( "vmouseup", clearTapTimer )
                    .bind( "vclick", clickHandler );
                $document.bind( "vmousecancel", clearTapHandlers );

                timer = setTimeout( function() {
                    if ( !$.event.special.tap.emitTapOnTaphold ) {
                        isTaphold = true;
                    }
                    triggerCustomEvent( thisObject, "taphold", $.Event( "taphold", { target: origTarget } ) );
                }, $.event.special.tap.tapholdThreshold );
            });
        },
        teardown: function() {
            $( this ).unbind( "vmousedown" ).unbind( "vclick" ).unbind( "vmouseup" );
            $document.unbind( "vmousecancel" );
        }
    };

    // Also handles swipeleft, swiperight
    $.event.special.swipe = {

        // More than this horizontal displacement, and we will suppress scrolling.
        scrollSupressionThreshold: 30,

        // More time than this, and it isn't a swipe.
        durationThreshold: 1000,

        // Swipe horizontal displacement must be more than this.
        horizontalDistanceThreshold: 30,

        // Swipe vertical displacement must be less than this.
        verticalDistanceThreshold: 30,

        getLocation: function ( event ) {
            var winPageX = window.pageXOffset,
                winPageY = window.pageYOffset,
                x = event.clientX,
                y = event.clientY;

            if ( event.pageY === 0 && Math.floor( y ) > Math.floor( event.pageY ) ||
                event.pageX === 0 && Math.floor( x ) > Math.floor( event.pageX ) ) {

                // iOS4 clientX/clientY have the value that should have been
                // in pageX/pageY. While pageX/page/ have the value 0
                x = x - winPageX;
                y = y - winPageY;
            } else if ( y < ( event.pageY - winPageY) || x < ( event.pageX - winPageX ) ) {

                // Some Android browsers have totally bogus values for clientX/Y
                // when scrolling/zooming a page. Detectable since clientX/clientY
                // should never be smaller than pageX/pageY minus page scroll
                x = event.pageX - winPageX;
                y = event.pageY - winPageY;
            }

            return {
                x: x,
                y: y
            };
        },

        start: function( event ) {
            var data = event.originalEvent.touches ?
                    event.originalEvent.touches[ 0 ] : event,
                location = $.event.special.swipe.getLocation( data );
            return {
                        time: ( new Date() ).getTime(),
                        coords: [ location.x, location.y ],
                        origin: $( event.target )
                    };
        },

        stop: function( event ) {
            var data = event.originalEvent.touches ?
                    event.originalEvent.touches[ 0 ] : event,
                location = $.event.special.swipe.getLocation( data );
            return {
                        time: ( new Date() ).getTime(),
                        coords: [ location.x, location.y ]
                    };
        },

        handleSwipe: function( start, stop, thisObject, origTarget ) {
            if ( stop.time - start.time < $.event.special.swipe.durationThreshold &&
                Math.abs( start.coords[ 0 ] - stop.coords[ 0 ] ) > $.event.special.swipe.horizontalDistanceThreshold &&
                Math.abs( start.coords[ 1 ] - stop.coords[ 1 ] ) < $.event.special.swipe.verticalDistanceThreshold ) {
                var direction = start.coords[0] > stop.coords[ 0 ] ? "swipeleft" : "swiperight";

                triggerCustomEvent( thisObject, "swipe", $.Event( "swipe", { target: origTarget, swipestart: start, swipestop: stop }), true );
                triggerCustomEvent( thisObject, direction,$.Event( direction, { target: origTarget, swipestart: start, swipestop: stop } ), true );
                return true;
            }
            return false;

        },

        // This serves as a flag to ensure that at most one swipe event event is
        // in work at any given time
        eventInProgress: false,

        setup: function() {
            var events,
                thisObject = this,
                $this = $( thisObject ),
                context = {};

            // Retrieve the events data for this element and add the swipe context
            events = $.data( this, "mobile-events" );
            if ( !events ) {
                events = { length: 0 };
                $.data( this, "mobile-events", events );
            }
            events.length++;
            events.swipe = context;

            context.start = function( event ) {

                // Bail if we're already working on a swipe event
                if ( $.event.special.swipe.eventInProgress ) {
                    return;
                }
                $.event.special.swipe.eventInProgress = true;

                var stop,
                    start = $.event.special.swipe.start( event ),
                    origTarget = event.target,
                    emitted = false;

                context.move = function( event ) {
                    if ( !start || event.isDefaultPrevented() ) {
                        return;
                    }

                    stop = $.event.special.swipe.stop( event );
                    if ( !emitted ) {
                        emitted = $.event.special.swipe.handleSwipe( start, stop, thisObject, origTarget );
                        if ( emitted ) {

                            // Reset the context to make way for the next swipe event
                            $.event.special.swipe.eventInProgress = false;
                        }
                    }
                    // prevent scrolling
                    if ( Math.abs( start.coords[ 0 ] - stop.coords[ 0 ] ) > $.event.special.swipe.scrollSupressionThreshold ) {
                        event.preventDefault();
                    }
                };

                context.stop = function() {
                        emitted = true;

                        // Reset the context to make way for the next swipe event
                        $.event.special.swipe.eventInProgress = false;
                        $document.off( touchMoveEvent, context.move );
                        context.move = null;
                };

                $document.on( touchMoveEvent, context.move )
                    .one( touchStopEvent, context.stop );
            };
            $this.on( touchStartEvent, context.start );
        },

        teardown: function() {
            var events, context;

            events = $.data( this, "mobile-events" );
            if ( events ) {
                context = events.swipe;
                delete events.swipe;
                events.length--;
                if ( events.length === 0 ) {
                    $.removeData( this, "mobile-events" );
                }
            }

            if ( context ) {
                if ( context.start ) {
                    $( this ).off( touchStartEvent, context.start );
                }
                if ( context.move ) {
                    $document.off( touchMoveEvent, context.move );
                }
                if ( context.stop ) {
                    $document.off( touchStopEvent, context.stop );
                }
            }
        }
    };
    $.each({
        scrollstop: "scrollstart",
        taphold: "tap",
        swipeleft: "swipe.left",
        swiperight: "swipe.right"
    }, function( event, sourceEvent ) {

        $.event.special[ event ] = {
            setup: function() {
                $( this ).bind( sourceEvent, $.noop );
            },
            teardown: function() {
                $( this ).unbind( sourceEvent );
            }
        };
    });

})( jQuery, this );


    // throttled resize event
    (function( $ ) {
        $.event.special.throttledresize = {
            setup: function() {
                $( this ).bind( "resize", handler );
            },
            teardown: function() {
                $( this ).unbind( "resize", handler );
            }
        };

        var throttle = 250,
            handler = function() {
                curr = ( new Date() ).getTime();
                diff = curr - lastCall;

                if ( diff >= throttle ) {

                    lastCall = curr;
                    $( this ).trigger( "throttledresize" );

                } else {

                    if ( heldCall ) {
                        clearTimeout( heldCall );
                    }

                    // Promise a held call will still execute
                    heldCall = setTimeout( handler, throttle - diff );
                }
            },
            lastCall = 0,
            heldCall,
            curr,
            diff;
    })( jQuery );


(function( $, window ) {
    var win = $( window ),
        event_name = "orientationchange",
        get_orientation,
        last_orientation,
        initial_orientation_is_landscape,
        initial_orientation_is_default,
        portrait_map = { "0": true, "180": true },
        ww, wh, landscape_threshold;

    // It seems that some device/browser vendors use window.orientation values 0 and 180 to
    // denote the "default" orientation. For iOS devices, and most other smart-phones tested,
    // the default orientation is always "portrait", but in some Android and RIM based tablets,
    // the default orientation is "landscape". The following code attempts to use the window
    // dimensions to figure out what the current orientation is, and then makes adjustments
    // to the to the portrait_map if necessary, so that we can properly decode the
    // window.orientation value whenever get_orientation() is called.
    //
    // Note that we used to use a media query to figure out what the orientation the browser
    // thinks it is in:
    //
    //     initial_orientation_is_landscape = $.mobile.media("all and (orientation: landscape)");
    //
    // but there was an iPhone/iPod Touch bug beginning with iOS 4.2, up through iOS 5.1,
    // where the browser *ALWAYS* applied the landscape media query. This bug does not
    // happen on iPad.

    if ( $.support.orientation ) {

        // Check the window width and height to figure out what the current orientation
        // of the device is at this moment. Note that we've initialized the portrait map
        // values to 0 and 180, *AND* we purposely check for landscape so that if we guess
        // wrong, , we default to the assumption that portrait is the default orientation.
        // We use a threshold check below because on some platforms like iOS, the iPhone
        // form-factor can report a larger width than height if the user turns on the
        // developer console. The actual threshold value is somewhat arbitrary, we just
        // need to make sure it is large enough to exclude the developer console case.

        ww = window.innerWidth || win.width();
        wh = window.innerHeight || win.height();
        landscape_threshold = 50;

        initial_orientation_is_landscape = ww > wh && ( ww - wh ) > landscape_threshold;

        // Now check to see if the current window.orientation is 0 or 180.
        initial_orientation_is_default = portrait_map[ window.orientation ];

        // If the initial orientation is landscape, but window.orientation reports 0 or 180, *OR*
        // if the initial orientation is portrait, but window.orientation reports 90 or -90, we
        // need to flip our portrait_map values because landscape is the default orientation for
        // this device/browser.
        if ( ( initial_orientation_is_landscape && initial_orientation_is_default ) || ( !initial_orientation_is_landscape && !initial_orientation_is_default ) ) {
            portrait_map = { "-90": true, "90": true };
        }
    }

    $.event.special.orientationchange = $.extend( {}, $.event.special.orientationchange, {
        setup: function() {
            // If the event is supported natively, return false so that jQuery
            // will bind to the event using DOM methods.
            if ( $.support.orientation && !$.event.special.orientationchange.disabled ) {
                return false;
            }

            // Get the current orientation to avoid initial double-triggering.
            last_orientation = get_orientation();

            // Because the orientationchange event doesn't exist, simulate the
            // event by testing window dimensions on resize.
            win.bind( "throttledresize", handler );
        },
        teardown: function() {
            // If the event is not supported natively, return false so that
            // jQuery will unbind the event using DOM methods.
            if ( $.support.orientation && !$.event.special.orientationchange.disabled ) {
                return false;
            }

            // Because the orientationchange event doesn't exist, unbind the
            // resize event handler.
            win.unbind( "throttledresize", handler );
        },
        add: function( handleObj ) {
            // Save a reference to the bound event handler.
            var old_handler = handleObj.handler;

            handleObj.handler = function( event ) {
                // Modify event object, adding the .orientation property.
                event.orientation = get_orientation();

                // Call the originally-bound event handler and return its result.
                return old_handler.apply( this, arguments );
            };
        }
    });

    // If the event is not supported natively, this handler will be bound to
    // the window resize event to simulate the orientationchange event.
    function handler() {
        // Get the current orientation.
        var orientation = get_orientation();

        if ( orientation !== last_orientation ) {
            // The orientation has changed, so trigger the orientationchange event.
            last_orientation = orientation;
            win.trigger( event_name );
        }
    }

    // Get the current page orientation. This method is exposed publicly, should it
    // be needed, as jQuery.event.special.orientationchange.orientation()
    $.event.special.orientationchange.orientation = get_orientation = function() {
        var isPortrait = true, elem = document.documentElement;

        // prefer window orientation to the calculation based on screensize as
        // the actual screen resize takes place before or after the orientation change event
        // has been fired depending on implementation (eg android 2.3 is before, iphone after).
        // More testing is required to determine if a more reliable method of determining the new screensize
        // is possible when orientationchange is fired. (eg, use media queries + element + opacity)
        if ( $.support.orientation ) {
            // if the window orientation registers as 0 or 180 degrees report
            // portrait, otherwise landscape
            isPortrait = portrait_map[ window.orientation ];
        } else {
            isPortrait = elem && elem.clientWidth / elem.clientHeight < 1.1;
        }

        return isPortrait ? "portrait" : "landscape";
    };

    $.fn[ event_name ] = function( fn ) {
        return fn ? this.bind( event_name, fn ) : this.trigger( event_name );
    };

    // jQuery < 1.8
    if ( $.attrFn ) {
        $.attrFn[ event_name ] = true;
    }

}( jQuery, this ));




(function( $, undefined ) {

    // existing base tag?
    var baseElement = $( "head" ).children( "base" ),

    // base element management, defined depending on dynamic base tag support
    // TODO move to external widget
    base = {

        // define base element, for use in routing asset urls that are referenced
        // in Ajax-requested markup
        element: ( baseElement.length ? baseElement :
            $( "<base>", { href: $.mobile.path.documentBase.hrefNoHash } ).prependTo( $( "head" ) ) ),

        linkSelector: "[src], link[href], a[rel='external'], :jqmData(ajax='false'), a[target]",

        // set the generated BASE element's href to a new page's base path
        set: function( href ) {

            // we should do nothing if the user wants to manage their url base
            // manually
            if ( !$.mobile.dynamicBaseEnabled ) {
                return;
            }

            // we should use the base tag if we can manipulate it dynamically
            if ( $.support.dynamicBaseTag ) {
                base.element.attr( "href",
                    $.mobile.path.makeUrlAbsolute( href, $.mobile.path.documentBase ) );
            }
        },

        rewrite: function( href, page ) {
            var newPath = $.mobile.path.get( href );

            page.find( base.linkSelector ).each(function( i, link ) {
                var thisAttr = $( link ).is( "[href]" ) ? "href" :
                    $( link ).is( "[src]" ) ? "src" : "action",
                theLocation = $.mobile.path.parseLocation(),
                thisUrl = $( link ).attr( thisAttr );

                // XXX_jblas: We need to fix this so that it removes the document
                //            base URL, and then prepends with the new page URL.
                // if full path exists and is same, chop it - helps IE out
                thisUrl = thisUrl.replace( theLocation.protocol + theLocation.doubleSlash +
                    theLocation.host + theLocation.pathname, "" );

                if ( !/^(\w+:|#|\/)/.test( thisUrl ) ) {
                    $( link ).attr( thisAttr, newPath + thisUrl );
                }
            });
        },

        // set the generated BASE element's href to a new page's base path
        reset: function(/* href */) {
            base.element.attr( "href", $.mobile.path.documentBase.hrefNoSearch );
        }
    };

    $.mobile.base = base;

})( jQuery );


(function( $, undefined ) {
$.mobile.widgets = {};

var originalWidget = $.widget,

    // Record the original, non-mobileinit-modified version of $.mobile.keepNative
    // so we can later determine whether someone has modified $.mobile.keepNative
    keepNativeFactoryDefault = $.mobile.keepNative;

$.widget = (function( orig ) {
    return function() {
        var constructor = orig.apply( this, arguments ),
            name = constructor.prototype.widgetName;

        constructor.initSelector = ( ( constructor.prototype.initSelector !== undefined ) ?
            constructor.prototype.initSelector : ":jqmData(role='" + name + "')" );

        $.mobile.widgets[ name ] = constructor;

        return constructor;
    };
})( $.widget );

// Make sure $.widget still has bridge and extend methods
$.extend( $.widget, originalWidget );

// For backcompat remove in 1.5
$.mobile.document.on( "create", function( event ) {
    $( event.target ).enhanceWithin();
});

$.widget( "mobile.page", {
    options: {
        theme: "a",
        domCache: false,

        // Deprecated in 1.4 remove in 1.5
        keepNativeDefault: $.mobile.keepNative,

        // Deprecated in 1.4 remove in 1.5
        contentTheme: null,
        enhanced: false
    },

    // DEPRECATED for > 1.4
    // TODO remove at 1.5
    _createWidget: function() {
        $.Widget.prototype._createWidget.apply( this, arguments );
        this._trigger( "init" );
    },

    _create: function() {
        // If false is returned by the callbacks do not create the page
        if ( this._trigger( "beforecreate" ) === false ) {
            return false;
        }

        if ( !this.options.enhanced ) {
            this._enhance();
        }

        this._on( this.element, {
            pagebeforehide: "removeContainerBackground",
            pagebeforeshow: "_handlePageBeforeShow"
        });

        this.element.enhanceWithin();
        // Dialog widget is deprecated in 1.4 remove this in 1.5
        if ( $.mobile.getAttribute( this.element[0], "role" ) === "dialog" && $.mobile.dialog ) {
            this.element.dialog();
        }
    },

    _enhance: function () {
        var attrPrefix = "data-" + $.mobile.ns,
            self = this;

        if ( this.options.role ) {
            this.element.attr( "data-" + $.mobile.ns + "role", this.options.role );
        }

        this.element
            .attr( "tabindex", "0" )
            .addClass( "ui-page ui-page-theme-" + this.options.theme );

        // Manipulation of content os Deprecated as of 1.4 remove in 1.5
        this.element.find( "[" + attrPrefix + "role='content']" ).each( function() {
            var $this = $( this ),
                theme = this.getAttribute( attrPrefix + "theme" ) || undefined;
                self.options.contentTheme = theme || self.options.contentTheme || ( self.options.dialog && self.options.theme ) || ( self.element.jqmData("role") === "dialog" &&  self.options.theme );
                $this.addClass( "ui-content" );
                if ( self.options.contentTheme ) {
                    $this.addClass( "ui-body-" + ( self.options.contentTheme ) );
                }
                // Add ARIA role
                $this.attr( "role", "main" ).addClass( "ui-content" );
        });
    },

    bindRemove: function( callback ) {
        var page = this.element;

        // when dom caching is not enabled or the page is embedded bind to remove the page on hide
        if ( !page.data( "mobile-page" ).options.domCache &&
            page.is( ":jqmData(external-page='true')" ) ) {

            // TODO use _on - that is, sort out why it doesn't work in this case
            page.bind( "pagehide.remove", callback || function( e, data ) {

                //check if this is a same page transition and if so don't remove the page
                if( !data.samePage ){
                    var $this = $( this ),
                        prEvent = new $.Event( "pageremove" );

                    $this.trigger( prEvent );

                    if ( !prEvent.isDefaultPrevented() ) {
                        $this.removeWithDependents();
                    }
                }
            });
        }
    },

    _setOptions: function( o ) {
        if ( o.theme !== undefined ) {
            this.element.removeClass( "ui-page-theme-" + this.options.theme ).addClass( "ui-page-theme-" + o.theme );
        }

        if ( o.contentTheme !== undefined ) {
            this.element.find( "[data-" + $.mobile.ns + "='content']" ).removeClass( "ui-body-" + this.options.contentTheme )
                .addClass( "ui-body-" + o.contentTheme );
        }
    },

    _handlePageBeforeShow: function(/* e */) {
        this.setContainerBackground();
    },
    // Deprecated in 1.4 remove in 1.5
    removeContainerBackground: function() {
        this.element.closest( ":mobile-pagecontainer" ).pagecontainer({ "theme": "none" });
    },
    // Deprecated in 1.4 remove in 1.5
    // set the page container background to the page theme
    setContainerBackground: function( theme ) {
        this.element.parent().pagecontainer( { "theme": theme || this.options.theme } );
    },
    // Deprecated in 1.4 remove in 1.5
    keepNativeSelector: function() {
        var options = this.options,
            keepNative = $.trim( options.keepNative || "" ),
            globalValue = $.trim( $.mobile.keepNative ),
            optionValue = $.trim( options.keepNativeDefault ),

            // Check if $.mobile.keepNative has changed from the factory default
            newDefault = ( keepNativeFactoryDefault === globalValue ?
                "" : globalValue ),

            // If $.mobile.keepNative has not changed, use options.keepNativeDefault
            oldDefault = ( newDefault === "" ? optionValue : "" );

        // Concatenate keepNative selectors from all sources where the value has
        // changed or, if nothing has changed, return the default
        return ( ( keepNative ? [ keepNative ] : [] )
            .concat( newDefault ? [ newDefault ] : [] )
            .concat( oldDefault ? [ oldDefault ] : [] )
            .join( ", " ) );
    }
});
})( jQuery );

(function( $, undefined ) {

    $.widget( "mobile.pagecontainer", {
        options: {
            theme: "a"
        },

        initSelector: false,

        _create: function() {
            this._trigger( "beforecreate" );
            this.setLastScrollEnabled = true;

            this._on( this.window, {
                // disable an scroll setting when a hashchange has been fired,
                // this only works because the recording of the scroll position
                // is delayed for 100ms after the browser might have changed the
                // position because of the hashchange
                navigate: "_disableRecordScroll",

                // bind to scrollstop for the first page, "pagechange" won't be
                // fired in that case
                scrollstop: "_delayedRecordScroll"
            });

            // TODO consider moving the navigation handler OUT of widget into
            //      some other object as glue between the navigate event and the
            //      content widget load and change methods
            this._on( this.window, { navigate: "_filterNavigateEvents" });

            // TODO move from page* events to content* events
            this._on({ pagechange: "_afterContentChange" });

            // handle initial hashchange from chrome :(
            this.window.one( "navigate", $.proxy(function() {
                this.setLastScrollEnabled = true;
            }, this));
        },

        _setOptions: function( options ) {
            if ( options.theme !== undefined && options.theme !== "none" ) {
                this.element.removeClass( "ui-overlay-" + this.options.theme )
                    .addClass( "ui-overlay-" + options.theme );
            } else if ( options.theme !== undefined ) {
                this.element.removeClass( "ui-overlay-" + this.options.theme );
            }

            this._super( options );
        },

        _disableRecordScroll: function() {
            this.setLastScrollEnabled = false;
        },

        _enableRecordScroll: function() {
            this.setLastScrollEnabled = true;
        },

        // TODO consider the name here, since it's purpose specific
        _afterContentChange: function() {
            // once the page has changed, re-enable the scroll recording
            this.setLastScrollEnabled = true;

            // remove any binding that previously existed on the get scroll
            // which may or may not be different than the scroll element
            // determined for this page previously
            this._off( this.window, "scrollstop" );

            // determine and bind to the current scoll element which may be the
            // window or in the case of touch overflow the element touch overflow
            this._on( this.window, { scrollstop: "_delayedRecordScroll" });
        },

        _recordScroll: function() {
            // this barrier prevents setting the scroll value based on
            // the browser scrolling the window based on a hashchange
            if ( !this.setLastScrollEnabled ) {
                return;
            }

            var active = this._getActiveHistory(),
                currentScroll, minScroll, defaultScroll;

            if ( active ) {
                currentScroll = this._getScroll();
                minScroll = this._getMinScroll();
                defaultScroll = this._getDefaultScroll();

                // Set active page's lastScroll prop. If the location we're
                // scrolling to is less than minScrollBack, let it go.
                active.lastScroll = currentScroll < minScroll ? defaultScroll : currentScroll;
            }
        },

        _delayedRecordScroll: function() {
            setTimeout( $.proxy(this, "_recordScroll"), 100 );
        },

        _getScroll: function() {
            return this.window.scrollTop();
        },

        _getMinScroll: function() {
            return $.mobile.minScrollBack;
        },

        _getDefaultScroll: function() {
            return $.mobile.defaultHomeScroll;
        },

        _filterNavigateEvents: function( e, data ) {
            var url;

            if ( e.originalEvent && e.originalEvent.isDefaultPrevented() ) {
                return;
            }

            url = e.originalEvent.type.indexOf( "hashchange" ) > -1 ? data.state.hash : data.state.url;

            if ( !url ) {
                url = this._getHash();
            }

            if ( !url || url === "#" || url.indexOf( "#" + $.mobile.path.uiStateKey ) === 0 ) {
                url = location.href;
            }

            this._handleNavigate( url, data.state );
        },

        _getHash: function() {
            return $.mobile.path.parseLocation().hash;
        },

        // TODO active page should be managed by the container (ie, it should be a property)
        getActivePage: function() {
            return this.activePage;
        },

        // TODO the first page should be a property set during _create using the logic
        //      that currently resides in init
        _getInitialContent: function() {
            return $.mobile.firstPage;
        },

        // TODO each content container should have a history object
        _getHistory: function() {
            return $.mobile.navigate.history;
        },

        _getActiveHistory: function() {
            return this._getHistory().getActive();
        },

        // TODO the document base should be determined at creation
        _getDocumentBase: function() {
            return $.mobile.path.documentBase;
        },

        back: function() {
            this.go( -1 );
        },

        forward: function() {
            this.go( 1 );
        },

        go: function( steps ) {

            //if hashlistening is enabled use native history method
            if ( $.mobile.hashListeningEnabled ) {
                window.history.go( steps );
            } else {

                //we are not listening to the hash so handle history internally
                var activeIndex = $.mobile.navigate.history.activeIndex,
                    index = activeIndex + parseInt( steps, 10 ),
                    url = $.mobile.navigate.history.stack[ index ].url,
                    direction = ( steps >= 1 )? "forward" : "back";

                //update the history object
                $.mobile.navigate.history.activeIndex = index;
                $.mobile.navigate.history.previousIndex = activeIndex;

                //change to the new page
                this.change( url, { direction: direction, changeHash: false, fromHashChange: true } );
            }
        },

        // TODO rename _handleDestination
        _handleDestination: function( to ) {
            var history;

            // clean the hash for comparison if it's a url
            if ( $.type(to) === "string" ) {
                to = $.mobile.path.stripHash( to );
            }

            if ( to ) {
                history = this._getHistory();

                // At this point, 'to' can be one of 3 things, a cached page
                // element from a history stack entry, an id, or site-relative /
                // absolute URL. If 'to' is an id, we need to resolve it against
                // the documentBase, not the location.href, since the hashchange
                // could've been the result of a forward/backward navigation
                // that crosses from an external page/dialog to an internal
                // page/dialog.
                //
                // TODO move check to history object or path object?
                to = !$.mobile.path.isPath( to ) ? ( $.mobile.path.makeUrlAbsolute( "#" + to, this._getDocumentBase() ) ) : to;
            }
            return to || this._getInitialContent();
        },

        _transitionFromHistory: function( direction, defaultTransition ) {
            var history = this._getHistory(),
                entry = ( direction === "back" ? history.getLast() : history.getActive() );

            return ( entry && entry.transition ) || defaultTransition;
        },

        _handleDialog: function( changePageOptions, data ) {
            var to, active, activeContent = this.getActivePage();

            // If current active page is not a dialog skip the dialog and continue
            // in the same direction
            // Note: The dialog widget is deprecated as of 1.4.0 and will be removed in 1.5.0.
            // Thus, as of 1.5.0 activeContent.data( "mobile-dialog" ) will always evaluate to
            // falsy, so the second condition in the if-statement below can be removed altogether.
            if ( activeContent && !activeContent.data( "mobile-dialog" ) ) {
                // determine if we're heading forward or backward and continue
                // accordingly past the current dialog
                if ( data.direction === "back" ) {
                    this.back();
                } else {
                    this.forward();
                }

                // prevent changePage call
                return false;
            } else {
                // if the current active page is a dialog and we're navigating
                // to a dialog use the dialog objected saved in the stack
                to = data.pageUrl;
                active = this._getActiveHistory();

                // make sure to set the role, transition and reversal
                // as most of this is lost by the domCache cleaning
                $.extend( changePageOptions, {
                    role: active.role,
                    transition: this._transitionFromHistory(
                        data.direction,
                        changePageOptions.transition ),
                    reverse: data.direction === "back"
                });
            }

            return to;
        },

        _handleNavigate: function( url, data ) {
            //find first page via hash
            // TODO stripping the hash twice with handleUrl
            var to = $.mobile.path.stripHash( url ), history = this._getHistory(),

                // transition is false if it's the first page, undefined
                // otherwise (and may be overridden by default)
                transition = history.stack.length === 0 ? "none" :
                    this._transitionFromHistory( data.direction ),

                // default options for the changPage calls made after examining
                // the current state of the page and the hash, NOTE that the
                // transition is derived from the previous history entry
                changePageOptions = {
                    changeHash: false,
                    fromHashChange: true,
                    reverse: data.direction === "back"
                };

            $.extend( changePageOptions, data, {
                transition: transition
            });

            // TODO move to _handleDestination ?
            // If this isn't the first page, if the current url is a dialog hash
            // key, and the initial destination isn't equal to the current target
            // page, use the special dialog handling
            if ( history.activeIndex > 0 &&
                to.indexOf( $.mobile.dialogHashKey ) > -1 ) {

                to = this._handleDialog( changePageOptions, data );

                if ( to === false ) {
                    return;
                }
            }

            this._changeContent( this._handleDestination( to ), changePageOptions );
        },

        _changeContent: function( to, opts ) {
            $.mobile.changePage( to, opts );
        },

        _getBase: function() {
            return $.mobile.base;
        },

        _getNs: function() {
            return $.mobile.ns;
        },

        _enhance: function( content, role ) {
            // TODO consider supporting a custom callback, and passing in
            // the settings which includes the role
            return content.page({ role: role });
        },

        _include: function( page, settings ) {
            // append to page and enhance
            page.appendTo( this.element );

            // use the page widget to enhance
            this._enhance( page, settings.role );

            // remove page on hide
            page.page( "bindRemove" );
        },

        _find: function( absUrl ) {
            // TODO consider supporting a custom callback
            var fileUrl = this._createFileUrl( absUrl ),
                dataUrl = this._createDataUrl( absUrl ),
                page, initialContent = this._getInitialContent();

            // Check to see if the page already exists in the DOM.
            // NOTE do _not_ use the :jqmData pseudo selector because parenthesis
            //      are a valid url char and it breaks on the first occurence
            page = this.element
                .children( "[data-" + this._getNs() +
                    "url='" + $.mobile.path.hashToSelector( dataUrl ) + "']" );

            // If we failed to find the page, check to see if the url is a
            // reference to an embedded page. If so, it may have been dynamically
            // injected by a developer, in which case it would be lacking a
            // data-url attribute and in need of enhancement.
            if ( page.length === 0 && dataUrl && !$.mobile.path.isPath( dataUrl ) ) {
                page = this.element.children( $.mobile.path.hashToSelector("#" + dataUrl) )
                    .attr( "data-" + this._getNs() + "url", dataUrl )
                    .jqmData( "url", dataUrl );
            }

            // If we failed to find a page in the DOM, check the URL to see if it
            // refers to the first page in the application. Also check to make sure
            // our cached-first-page is actually in the DOM. Some user deployed
            // apps are pruning the first page from the DOM for various reasons.
            // We check for this case here because we don't want a first-page with
            // an id falling through to the non-existent embedded page error case.
            if ( page.length === 0 &&
                $.mobile.path.isFirstPageUrl( fileUrl ) &&
                initialContent &&
                initialContent.parent().length ) {
                page = $( initialContent );
            }

            return page;
        },

        _getLoader: function() {
            return $.mobile.loading();
        },

        _showLoading: function( delay, theme, msg, textonly ) {
            // This configurable timeout allows cached pages a brief
            // delay to load without showing a message
            if ( this._loadMsg ) {
                return;
            }

            this._loadMsg = setTimeout($.proxy(function() {
                this._getLoader().loader( "show", theme, msg, textonly );
                this._loadMsg = 0;
            }, this), delay );
        },

        _hideLoading: function() {
            // Stop message show timer
            clearTimeout( this._loadMsg );
            this._loadMsg = 0;

            // Hide loading message
            this._getLoader().loader( "hide" );
        },

        _showError: function() {
            // make sure to remove the current loading message
            this._hideLoading();

            // show the error message
            this._showLoading( 0, $.mobile.pageLoadErrorMessageTheme, $.mobile.pageLoadErrorMessage, true );

            // hide the error message after a delay
            // TODO configuration
            setTimeout( $.proxy(this, "_hideLoading"), 1500 );
        },

        _parse: function( html, fileUrl ) {
            // TODO consider allowing customization of this method. It's very JQM specific
            var page, all = $( "<div></div>" );

            //workaround to allow scripts to execute when included in page divs
            all.get( 0 ).innerHTML = html;

            page = all.find( ":jqmData(role='page'), :jqmData(role='dialog')" ).first();

            //if page elem couldn't be found, create one and insert the body element's contents
            if ( !page.length ) {
                page = $( "<div data-" + this._getNs() + "role='page'>" +
                    ( html.split( /<\/?body[^>]*>/gmi )[1] || "" ) +
                    "</div>" );
            }

            // TODO tagging a page with external to make sure that embedded pages aren't
            // removed by the various page handling code is bad. Having page handling code
            // in many places is bad. Solutions post 1.0
            page.attr( "data-" + this._getNs() + "url", this._createDataUrl( fileUrl ) )
                .attr( "data-" + this._getNs() + "external-page", true );

            return page;
        },

        _setLoadedTitle: function( page, html ) {
            //page title regexp
            var newPageTitle = html.match( /<title[^>]*>([^<]*)/ ) && RegExp.$1;

            if ( newPageTitle && !page.jqmData("title") ) {
                newPageTitle = $( "<div>" + newPageTitle + "</div>" ).text();
                page.jqmData( "title", newPageTitle );
            }
        },

        _isRewritableBaseTag: function() {
            return $.mobile.dynamicBaseEnabled && !$.support.dynamicBaseTag;
        },

        _createDataUrl: function( absoluteUrl ) {
            return $.mobile.path.convertUrlToDataUrl( absoluteUrl );
        },

        _createFileUrl: function( absoluteUrl ) {
            return $.mobile.path.getFilePath( absoluteUrl );
        },

        _triggerWithDeprecated: function( name, data, page ) {
            var deprecatedEvent = $.Event( "page" + name ),
                newEvent = $.Event( this.widgetName + name );

            // DEPRECATED
            // trigger the old deprecated event on the page if it's provided
            ( page || this.element ).trigger( deprecatedEvent, data );

            // use the widget trigger method for the new content* event
            this._trigger( name, newEvent, data );

            return {
                deprecatedEvent: deprecatedEvent,
                event: newEvent
            };
        },

        // TODO it would be nice to split this up more but everything appears to be "one off"
        //      or require ordering such that other bits are sprinkled in between parts that
        //      could be abstracted out as a group
        _loadSuccess: function( absUrl, triggerData, settings, deferred ) {
            var fileUrl = this._createFileUrl( absUrl );

            return $.proxy(function( html, textStatus, xhr ) {
                //pre-parse html to check for a data-url,
                //use it as the new fileUrl, base path, etc
                var content,

                    // TODO handle dialogs again
                    pageElemRegex = new RegExp( "(<[^>]+\\bdata-" + this._getNs() + "role=[\"']?page[\"']?[^>]*>)" ),

                    dataUrlRegex = new RegExp( "\\bdata-" + this._getNs() + "url=[\"']?([^\"'>]*)[\"']?" );

                // data-url must be provided for the base tag so resource requests
                // can be directed to the correct url. loading into a temprorary
                // element makes these requests immediately
                if ( pageElemRegex.test( html ) &&
                    RegExp.$1 &&
                    dataUrlRegex.test( RegExp.$1 ) &&
                    RegExp.$1 ) {
                    fileUrl = $.mobile.path.getFilePath( $("<div>" + RegExp.$1 + "</div>").text() );

                    // We specify that, if a data-url attribute is given on the page div, its value
                    // must be given non-URL-encoded. However, in this part of the code, fileUrl is
                    // assumed to be URL-encoded, so we URL-encode the retrieved value here
                    fileUrl = this.window[ 0 ].encodeURIComponent( fileUrl );
                }

                //dont update the base tag if we are prefetching
                if ( settings.prefetch === undefined ) {
                    this._getBase().set( fileUrl );
                }

                content = this._parse( html, fileUrl );

                this._setLoadedTitle( content, html );

                // Add the content reference and xhr to our triggerData.
                triggerData.xhr = xhr;
                triggerData.textStatus = textStatus;

                // DEPRECATED
                triggerData.page = content;

                triggerData.content = content;

                triggerData.toPage = content;

                // If the default behavior is prevented, stop here!
                // Note that it is the responsibility of the listener/handler
                // that called preventDefault(), to resolve/reject the
                // deferred object within the triggerData.
                if ( this._triggerWithDeprecated( "load", triggerData ).event.isDefaultPrevented() ) {
                    return;
                }

                // rewrite src and href attrs to use a base url if the base tag won't work
                if ( this._isRewritableBaseTag() && content ) {
                    this._getBase().rewrite( fileUrl, content );
                }

                this._include( content, settings );

                // Remove loading message.
                if ( settings.showLoadMsg ) {
                    this._hideLoading();
                }

                deferred.resolve( absUrl, settings, content );
            }, this);
        },

        _loadDefaults: {
            type: "get",
            data: undefined,

            // DEPRECATED
            reloadPage: false,

            reload: false,

            // By default we rely on the role defined by the @data-role attribute.
            role: undefined,

            showLoadMsg: false,

            // This delay allows loads that pull from browser cache to
            // occur without showing the loading message.
            loadMsgDelay: 50
        },

        load: function( url, options ) {
            // This function uses deferred notifications to let callers
            // know when the content is done loading, or if an error has occurred.
            var deferred = ( options && options.deferred ) || $.Deferred(),

                // Examining the option "reloadPage" passed by the user is deprecated as of 1.4.0
                // and will be removed in 1.5.0.
                // Copy option "reloadPage" to "reload", but only if option "reload" is not present
                reloadOptionExtension =
                    ( ( options && options.reload === undefined &&
                        options.reloadPage !== undefined ) ?
                            { reload: options.reloadPage } : {} ),

                // The default load options with overrides specified by the caller.
                settings = $.extend( {}, this._loadDefaults, options, reloadOptionExtension ),

                // The DOM element for the content after it has been loaded.
                content = null,

                // The absolute version of the URL passed into the function. This
                // version of the URL may contain dialog/subcontent params in it.
                absUrl = $.mobile.path.makeUrlAbsolute( url, this._findBaseWithDefault() ),
                fileUrl, dataUrl, pblEvent, triggerData;

            // If the caller provided data, and we're using "get" request,
            // append the data to the URL.
            if ( settings.data && settings.type === "get" ) {
                absUrl = $.mobile.path.addSearchParams( absUrl, settings.data );
                settings.data = undefined;
            }

            // If the caller is using a "post" request, reload must be true
            if ( settings.data && settings.type === "post" ) {
                settings.reload = true;
            }

            // The absolute version of the URL minus any dialog/subcontent params.
            // In otherwords the real URL of the content to be loaded.
            fileUrl = this._createFileUrl( absUrl );

            // The version of the Url actually stored in the data-url attribute of
            // the content. For embedded content, it is just the id of the page. For
            // content within the same domain as the document base, it is the site
            // relative path. For cross-domain content (Phone Gap only) the entire
            // absolute Url is used to load the content.
            dataUrl = this._createDataUrl( absUrl );

            content = this._find( absUrl );

            // If it isn't a reference to the first content and refers to missing
            // embedded content reject the deferred and return
            if ( content.length === 0 &&
                $.mobile.path.isEmbeddedPage(fileUrl) &&
                !$.mobile.path.isFirstPageUrl(fileUrl) ) {
                deferred.reject( absUrl, settings );
                return deferred.promise();
            }

            // Reset base to the default document base
            // TODO figure out why we doe this
            this._getBase().reset();

            // If the content we are interested in is already in the DOM,
            // and the caller did not indicate that we should force a
            // reload of the file, we are done. Resolve the deferrred so that
            // users can bind to .done on the promise
            if ( content.length && !settings.reload ) {
                this._enhance( content, settings.role );
                deferred.resolve( absUrl, settings, content );

                //if we are reloading the content make sure we update
                // the base if its not a prefetch
                if ( !settings.prefetch ) {
                    this._getBase().set(url);
                }

                return deferred.promise();
            }

            triggerData = {
                url: url,
                absUrl: absUrl,
                toPage: url,
                prevPage: options ? options.fromPage : undefined,
                dataUrl: dataUrl,
                deferred: deferred,
                options: settings
            };

            // Let listeners know we're about to load content.
            pblEvent = this._triggerWithDeprecated( "beforeload", triggerData );

            // If the default behavior is prevented, stop here!
            if ( pblEvent.deprecatedEvent.isDefaultPrevented() ||
                pblEvent.event.isDefaultPrevented() ) {
                return deferred.promise();
            }

            if ( settings.showLoadMsg ) {
                this._showLoading( settings.loadMsgDelay );
            }

            // Reset base to the default document base.
            // only reset if we are not prefetching
            if ( settings.prefetch === undefined ) {
                this._getBase().reset();
            }

            if ( !( $.mobile.allowCrossDomainPages ||
                $.mobile.path.isSameDomain($.mobile.path.documentUrl, absUrl ) ) ) {
                deferred.reject( absUrl, settings );
                return deferred.promise();
            }

            // Load the new content.
            $.ajax({
                url: fileUrl,
                type: settings.type,
                data: settings.data,
                contentType: settings.contentType,
                dataType: "html",
                success: this._loadSuccess( absUrl, triggerData, settings, deferred ),
                error: this._loadError( absUrl, triggerData, settings, deferred )
            });

            return deferred.promise();
        },

        _loadError: function( absUrl, triggerData, settings, deferred ) {
            return $.proxy(function( xhr, textStatus, errorThrown ) {
                //set base back to current path
                this._getBase().set( $.mobile.path.get() );

                // Add error info to our triggerData.
                triggerData.xhr = xhr;
                triggerData.textStatus = textStatus;
                triggerData.errorThrown = errorThrown;

                // Let listeners know the page load failed.
                var plfEvent = this._triggerWithDeprecated( "loadfailed", triggerData );

                // If the default behavior is prevented, stop here!
                // Note that it is the responsibility of the listener/handler
                // that called preventDefault(), to resolve/reject the
                // deferred object within the triggerData.
                if ( plfEvent.deprecatedEvent.isDefaultPrevented() ||
                    plfEvent.event.isDefaultPrevented() ) {
                    return;
                }

                // Remove loading message.
                if ( settings.showLoadMsg ) {
                    this._showError();
                }

                deferred.reject( absUrl, settings );
            }, this);
        },

        _getTransitionHandler: function( transition ) {
            transition = $.mobile._maybeDegradeTransition( transition );

            //find the transition handler for the specified transition. If there
            //isn't one in our transitionHandlers dictionary, use the default one.
            //call the handler immediately to kick-off the transition.
            return $.mobile.transitionHandlers[ transition ] || $.mobile.defaultTransitionHandler;
        },

        // TODO move into transition handlers?
        _triggerCssTransitionEvents: function( to, from, prefix ) {
            var samePage = false;

            prefix = prefix || "";

            // TODO decide if these events should in fact be triggered on the container
            if ( from ) {

                //Check if this is a same page transition and tell the handler in page
                if( to[0] === from[0] ){
                    samePage = true;
                }

                //trigger before show/hide events
                // TODO deprecate nextPage in favor of next
                this._triggerWithDeprecated( prefix + "hide", {

                    // Deprecated in 1.4 remove in 1.5
                    nextPage: to,
                    toPage: to,
                    prevPage: from,
                    samePage: samePage
                }, from );
            }

            // TODO deprecate prevPage in favor of previous
            this._triggerWithDeprecated( prefix + "show", {
                prevPage: from || $( "" ),
                toPage: to
            }, to );
        },

        // TODO make private once change has been defined in the widget
        _cssTransition: function( to, from, options ) {
            var transition = options.transition,
                reverse = options.reverse,
                deferred = options.deferred,
                TransitionHandler,
                promise;

            this._triggerCssTransitionEvents( to, from, "before" );

            // TODO put this in a binding to events *outside* the widget
            this._hideLoading();

            TransitionHandler = this._getTransitionHandler( transition );

            promise = ( new TransitionHandler( transition, reverse, to, from ) ).transition();

            promise.done( $.proxy( function() {
                this._triggerCssTransitionEvents( to, from );
            }, this ));

            // TODO temporary accomodation of argument deferred
            promise.done(function() {
                deferred.resolve.apply( deferred, arguments );
            });
        },

        _releaseTransitionLock: function() {
            //release transition lock so navigation is free again
            isPageTransitioning = false;
            if ( pageTransitionQueue.length > 0 ) {
                $.mobile.changePage.apply( null, pageTransitionQueue.pop() );
            }
        },

        _removeActiveLinkClass: function( force ) {
            //clear out the active button state
            $.mobile.removeActiveLinkClass( force );
        },

        _loadUrl: function( to, triggerData, settings ) {
            // preserve the original target as the dataUrl value will be
            // simplified eg, removing ui-state, and removing query params
            // from the hash this is so that users who want to use query
            // params have access to them in the event bindings for the page
            // life cycle See issue #5085
            settings.target = to;
            settings.deferred = $.Deferred();

            this.load( to, settings );

            settings.deferred.done($.proxy(function( url, options, content ) {
                isPageTransitioning = false;

                // store the original absolute url so that it can be provided
                // to events in the triggerData of the subsequent changePage call
                options.absUrl = triggerData.absUrl;

                this.transition( content, triggerData, options );
            }, this));

            settings.deferred.fail($.proxy(function(/* url, options */) {
                this._removeActiveLinkClass( true );
                this._releaseTransitionLock();
                this._triggerWithDeprecated( "changefailed", triggerData );
            }, this));
        },

        _triggerPageBeforeChange: function( to, triggerData, settings ) {
            var returnEvents;

            triggerData.prevPage = this.activePage;
            $.extend( triggerData, {
                toPage: to,
                options: settings
            });

            // NOTE: preserve the original target as the dataUrl value will be
            // simplified eg, removing ui-state, and removing query params from
            // the hash this is so that users who want to use query params have
            // access to them in the event bindings for the page life cycle
            // See issue #5085
            if ( $.type(to) === "string" ) {
                // if the toPage is a string simply convert it
                triggerData.absUrl = $.mobile.path.makeUrlAbsolute( to, this._findBaseWithDefault() );
            } else {
                // if the toPage is a jQuery object grab the absolute url stored
                // in the loadPage callback where it exists
                triggerData.absUrl = settings.absUrl;
            }

            // Let listeners know we're about to change the current page.
            returnEvents = this._triggerWithDeprecated( "beforechange", triggerData );

            // If the default behavior is prevented, stop here!
            if ( returnEvents.event.isDefaultPrevented() ||
                returnEvents.deprecatedEvent.isDefaultPrevented() ) {
                return false;
            }

            return true;
        },

        change: function( to, options ) {
            // If we are in the midst of a transition, queue the current request.
            // We'll call changePage() once we're done with the current transition
            // to service the request.
            if ( isPageTransitioning ) {
                pageTransitionQueue.unshift( arguments );
                return;
            }

            var settings = $.extend( {}, $.mobile.changePage.defaults, options ),
                triggerData = {};

            // Make sure we have a fromPage.
            settings.fromPage = settings.fromPage || this.activePage;

            // if the page beforechange default is prevented return early
            if ( !this._triggerPageBeforeChange(to, triggerData, settings) ) {
                return;
            }

            // We allow "pagebeforechange" observers to modify the to in
            // the trigger data to allow for redirects. Make sure our to is
            // updated. We also need to re-evaluate whether it is a string,
            // because an object can also be replaced by a string
            to = triggerData.toPage;

            // If the caller passed us a url, call loadPage()
            // to make sure it is loaded into the DOM. We'll listen
            // to the promise object it returns so we know when
            // it is done loading or if an error ocurred.
            if ( $.type(to) === "string" ) {
                // Set the isPageTransitioning flag to prevent any requests from
                // entering this method while we are in the midst of loading a page
                // or transitioning.
                isPageTransitioning = true;

                this._loadUrl( to, triggerData, settings );
            } else {
                this.transition( to, triggerData, settings );
            }
        },

        transition: function( toPage, triggerData, settings ) {
            var fromPage, url, pageUrl, fileUrl,
                active, activeIsInitialPage,
                historyDir, pageTitle, isDialog,
                alreadyThere, newPageTitle,
                params,    cssTransitionDeferred,
                beforeTransition;

            // If we are in the midst of a transition, queue the current request.
            // We'll call changePage() once we're done with the current transition
            // to service the request.
            if ( isPageTransitioning ) {
                // make sure to only queue the to and settings values so the arguments
                // work with a call to the change method
                pageTransitionQueue.unshift( [toPage, settings] );
                return;
            }

            // DEPRECATED - this call only, in favor of the before transition
            // if the page beforechange default is prevented return early
            if ( !this._triggerPageBeforeChange(toPage, triggerData, settings) ) {
                return;
            }

            triggerData.prevPage = settings.fromPage;
            // if the (content|page)beforetransition default is prevented return early
            // Note, we have to check for both the deprecated and new events
            beforeTransition = this._triggerWithDeprecated( "beforetransition", triggerData );
            if (beforeTransition.deprecatedEvent.isDefaultPrevented() ||
                beforeTransition.event.isDefaultPrevented() ) {
                return;
            }

            // Set the isPageTransitioning flag to prevent any requests from
            // entering this method while we are in the midst of loading a page
            // or transitioning.
            isPageTransitioning = true;

            // If we are going to the first-page of the application, we need to make
            // sure settings.dataUrl is set to the application document url. This allows
            // us to avoid generating a document url with an id hash in the case where the
            // first-page of the document has an id attribute specified.
            if ( toPage[ 0 ] === $.mobile.firstPage[ 0 ] && !settings.dataUrl ) {
                settings.dataUrl = $.mobile.path.documentUrl.hrefNoHash;
            }

            // The caller passed us a real page DOM element. Update our
            // internal state and then trigger a transition to the page.
            fromPage = settings.fromPage;
            url = ( settings.dataUrl && $.mobile.path.convertUrlToDataUrl(settings.dataUrl) ) ||
                toPage.jqmData( "url" );

            // The pageUrl var is usually the same as url, except when url is obscured
            // as a dialog url. pageUrl always contains the file path
            pageUrl = url;
            fileUrl = $.mobile.path.getFilePath( url );
            active = $.mobile.navigate.history.getActive();
            activeIsInitialPage = $.mobile.navigate.history.activeIndex === 0;
            historyDir = 0;
            pageTitle = document.title;
            isDialog = ( settings.role === "dialog" ||
                toPage.jqmData( "role" ) === "dialog" ) &&
                toPage.jqmData( "dialog" ) !== true;

            // By default, we prevent changePage requests when the fromPage and toPage
            // are the same element, but folks that generate content
            // manually/dynamically and reuse pages want to be able to transition to
            // the same page. To allow this, they will need to change the default
            // value of allowSamePageTransition to true, *OR*, pass it in as an
            // option when they manually call changePage(). It should be noted that
            // our default transition animations assume that the formPage and toPage
            // are different elements, so they may behave unexpectedly. It is up to
            // the developer that turns on the allowSamePageTransitiona option to
            // either turn off transition animations, or make sure that an appropriate
            // animation transition is used.
            if ( fromPage && fromPage[0] === toPage[0] &&
                !settings.allowSamePageTransition ) {

                isPageTransitioning = false;
                this._triggerWithDeprecated( "transition", triggerData );
                this._triggerWithDeprecated( "change", triggerData );

                // Even if there is no page change to be done, we should keep the
                // urlHistory in sync with the hash changes
                if ( settings.fromHashChange ) {
                    $.mobile.navigate.history.direct({ url: url });
                }

                return;
            }

            // We need to make sure the page we are given has already been enhanced.
            toPage.page({ role: settings.role });

            // If the changePage request was sent from a hashChange event, check to
            // see if the page is already within the urlHistory stack. If so, we'll
            // assume the user hit the forward/back button and will try to match the
            // transition accordingly.
            if ( settings.fromHashChange ) {
                historyDir = settings.direction === "back" ? -1 : 1;
            }

            // Kill the keyboard.
            // XXX_jblas: We need to stop crawling the entire document to kill focus.
            //            Instead, we should be tracking focus with a delegate()
            //            handler so we already have the element in hand at this
            //            point.
            // Wrap this in a try/catch block since IE9 throw "Unspecified error" if
            // document.activeElement is undefined when we are in an IFrame.
            try {
                if ( document.activeElement &&
                    document.activeElement.nodeName.toLowerCase() !== "body" ) {

                    $( document.activeElement ).blur();
                } else {
                    $( "input:focus, textarea:focus, select:focus" ).blur();
                }
            } catch( e ) {}

            // Record whether we are at a place in history where a dialog used to be -
            // if so, do not add a new history entry and do not change the hash either
            alreadyThere = false;

            // If we're displaying the page as a dialog, we don't want the url
            // for the dialog content to be used in the hash. Instead, we want
            // to append the dialogHashKey to the url of the current page.
            if ( isDialog && active ) {
                // on the initial page load active.url is undefined and in that case
                // should be an empty string. Moving the undefined -> empty string back
                // into urlHistory.addNew seemed imprudent given undefined better
                // represents the url state

                // If we are at a place in history that once belonged to a dialog, reuse
                // this state without adding to urlHistory and without modifying the
                // hash. However, if a dialog is already displayed at this point, and
                // we're about to display another dialog, then we must add another hash
                // and history entry on top so that one may navigate back to the
                // original dialog
                if ( active.url &&
                    active.url.indexOf( $.mobile.dialogHashKey ) > -1 &&
                    this.activePage &&
                    !this.activePage.hasClass( "ui-dialog" ) &&
                    $.mobile.navigate.history.activeIndex > 0 ) {

                    settings.changeHash = false;
                    alreadyThere = true;
                }

                // Normally, we tack on a dialog hash key, but if this is the location
                // of a stale dialog, we reuse the URL from the entry
                url = ( active.url || "" );

                // account for absolute urls instead of just relative urls use as hashes
                if ( !alreadyThere && url.indexOf("#") > -1 ) {
                    url += $.mobile.dialogHashKey;
                } else {
                    url += "#" + $.mobile.dialogHashKey;
                }
            }

            // if title element wasn't found, try the page div data attr too
            // If this is a deep-link or a reload ( active === undefined ) then just
            // use pageTitle
            newPageTitle = ( !active ) ? pageTitle : toPage.jqmData( "title" ) ||
                toPage.children( ":jqmData(role='header')" ).find( ".ui-title" ).text();
            if ( !!newPageTitle && pageTitle === document.title ) {
                pageTitle = newPageTitle;
            }
            if ( !toPage.jqmData( "title" ) ) {
                toPage.jqmData( "title", pageTitle );
            }

            // Make sure we have a transition defined.
            settings.transition = settings.transition ||
                ( ( historyDir && !activeIsInitialPage ) ? active.transition : undefined ) ||
                ( isDialog ? $.mobile.defaultDialogTransition : $.mobile.defaultPageTransition );

            //add page to history stack if it's not back or forward
            if ( !historyDir && alreadyThere ) {
                $.mobile.navigate.history.getActive().pageUrl = pageUrl;
            }

            // Set the location hash.
            if ( url && !settings.fromHashChange ) {

                // rebuilding the hash here since we loose it earlier on
                // TODO preserve the originally passed in path
                if ( !$.mobile.path.isPath( url ) && url.indexOf( "#" ) < 0 ) {
                    url = "#" + url;
                }

                // TODO the property names here are just silly
                params = {
                    transition: settings.transition,
                    title: pageTitle,
                    pageUrl: pageUrl,
                    role: settings.role
                };

                if ( settings.changeHash !== false && $.mobile.hashListeningEnabled ) {
                    $.mobile.navigate( this.window[ 0 ].encodeURI( url ), params, true);
                } else if ( toPage[ 0 ] !== $.mobile.firstPage[ 0 ] ) {
                    $.mobile.navigate.history.add( url, params );
                }
            }

            //set page title
            document.title = pageTitle;

            //set "toPage" as activePage deprecated in 1.4 remove in 1.5
            $.mobile.activePage = toPage;

            //new way to handle activePage
            this.activePage = toPage;

            // If we're navigating back in the URL history, set reverse accordingly.
            settings.reverse = settings.reverse || historyDir < 0;

            cssTransitionDeferred = $.Deferred();

            this._cssTransition(toPage, fromPage, {
                transition: settings.transition,
                reverse: settings.reverse,
                deferred: cssTransitionDeferred
            });

            cssTransitionDeferred.done($.proxy(function( name, reverse, $to, $from, alreadyFocused ) {
                $.mobile.removeActiveLinkClass();

                //if there's a duplicateCachedPage, remove it from the DOM now that it's hidden
                if ( settings.duplicateCachedPage ) {
                    settings.duplicateCachedPage.remove();
                }

                // despite visibility: hidden addresses issue #2965
                // https://github.com/jquery/jquery-mobile/issues/2965
                if ( !alreadyFocused ) {
                    $.mobile.focusPage( toPage );
                }

                this._releaseTransitionLock();
                this._triggerWithDeprecated( "transition", triggerData );
                this._triggerWithDeprecated( "change", triggerData );
            }, this));
        },

        // determine the current base url
        _findBaseWithDefault: function() {
            var closestBase = ( this.activePage &&
            $.mobile.getClosestBaseUrl( this.activePage ) );
        return closestBase || $.mobile.path.documentBase.hrefNoHash;
        }
    });

    // The following handlers should be bound after mobileinit has been triggered
    // the following deferred is resolved in the init file
    $.mobile.navreadyDeferred = $.Deferred();

    //these variables make all page containers use the same queue and only navigate one at a time
    // queue to hold simultanious page transitions
    var pageTransitionQueue = [],

        // indicates whether or not page is in process of transitioning
        isPageTransitioning = false;

})( jQuery );

(function( $, undefined ) {

        // resolved on domready
    var domreadyDeferred = $.Deferred(),

        // resolved and nulled on window.load()
        loadDeferred = $.Deferred(),

        // function that resolves the above deferred
        pageIsFullyLoaded = function() {

            // Resolve and null the deferred
            loadDeferred.resolve();
            loadDeferred = null;
        },

        documentUrl = $.mobile.path.documentUrl,

        // used to track last vclicked element to make sure its value is added to form data
        $lastVClicked = null;

    /* Event Bindings - hashchange, submit, and click */
    function findClosestLink( ele )    {
        while ( ele ) {
            // Look for the closest element with a nodeName of "a".
            // Note that we are checking if we have a valid nodeName
            // before attempting to access it. This is because the
            // node we get called with could have originated from within
            // an embedded SVG document where some symbol instance elements
            // don't have nodeName defined on them, or strings are of type
            // SVGAnimatedString.
            if ( ( typeof ele.nodeName === "string" ) && ele.nodeName.toLowerCase() === "a" ) {
                break;
            }
            ele = ele.parentNode;
        }
        return ele;
    }

    $.mobile.loadPage = function( url, opts ) {
        var container;

        opts = opts || {};
        container = ( opts.pageContainer || $.mobile.pageContainer );

        // create the deferred that will be supplied to loadPage callers
        // and resolved by the content widget's load method
        opts.deferred = $.Deferred();

        // Preferring to allow exceptions for uninitialized opts.pageContainer
        // widgets so we know if we need to force init here for users
        container.pagecontainer( "load", url, opts );

        // provide the deferred
        return opts.deferred.promise();
    };

    //define vars for interal use

    /* internal utility functions */

    // NOTE Issue #4950 Android phonegap doesn't navigate back properly
    //      when a full page refresh has taken place. It appears that hashchange
    //      and replacestate history alterations work fine but we need to support
    //      both forms of history traversal in our code that uses backward history
    //      movement
    $.mobile.back = function() {
        var nav = window.navigator;

        // if the setting is on and the navigator object is
        // available use the phonegap navigation capability
        if ( this.phonegapNavigationEnabled &&
            nav &&
            nav.app &&
            nav.app.backHistory ) {
            nav.app.backHistory();
        } else {
            $.mobile.pageContainer.pagecontainer( "back" );
        }
    };

    // Direct focus to the page title, or otherwise first focusable element
    $.mobile.focusPage = function ( page ) {
        var autofocus = page.find( "[autofocus]" ),
            pageTitle = page.find( ".ui-title:eq(0)" );

        if ( autofocus.length ) {
            autofocus.focus();
            return;
        }

        if ( pageTitle.length ) {
            pageTitle.focus();
        } else{
            page.focus();
        }
    };

    // No-op implementation of transition degradation
    $.mobile._maybeDegradeTransition = $.mobile._maybeDegradeTransition || function( transition ) {
        return transition;
    };

    // Exposed $.mobile methods

    $.mobile.changePage = function( to, options ) {
        $.mobile.pageContainer.pagecontainer( "change", to, options );
    };

    $.mobile.changePage.defaults = {
        transition: undefined,
        reverse: false,
        changeHash: true,
        fromHashChange: false,
        role: undefined, // By default we rely on the role defined by the @data-role attribute.
        duplicateCachedPage: undefined,
        pageContainer: undefined,
        showLoadMsg: true, //loading message shows by default when pages are being fetched during changePage
        dataUrl: undefined,
        fromPage: undefined,
        allowSamePageTransition: false
    };

    $.mobile._registerInternalEvents = function() {
        var getAjaxFormData = function( $form, calculateOnly ) {
            var url, ret = true, formData, vclickedName, method;
            if ( !$.mobile.ajaxEnabled ||
                    // test that the form is, itself, ajax false
                    $form.is( ":jqmData(ajax='false')" ) ||
                    // test that $.mobile.ignoreContentEnabled is set and
                    // the form or one of it's parents is ajax=false
                    !$form.jqmHijackable().length ||
                    $form.attr( "target" ) ) {
                return false;
            }

            url = ( $lastVClicked && $lastVClicked.attr( "formaction" ) ) ||
                $form.attr( "action" );
            method = ( $form.attr( "method" ) || "get" ).toLowerCase();

            // If no action is specified, browsers default to using the
            // URL of the document containing the form. Since we dynamically
            // pull in pages from external documents, the form should submit
            // to the URL for the source document of the page containing
            // the form.
            if ( !url ) {
                // Get the @data-url for the page containing the form.
                url = $.mobile.getClosestBaseUrl( $form );

                // NOTE: If the method is "get", we need to strip off the query string
                // because it will get replaced with the new form data. See issue #5710.
                if ( method === "get" ) {
                    url = $.mobile.path.parseUrl( url ).hrefNoSearch;
                }

                if ( url === $.mobile.path.documentBase.hrefNoHash ) {
                    // The url we got back matches the document base,
                    // which means the page must be an internal/embedded page,
                    // so default to using the actual document url as a browser
                    // would.
                    url = documentUrl.hrefNoSearch;
                }
            }

            url = $.mobile.path.makeUrlAbsolute(  url, $.mobile.getClosestBaseUrl( $form ) );

            if ( ( $.mobile.path.isExternal( url ) && !$.mobile.path.isPermittedCrossDomainRequest( documentUrl, url ) ) ) {
                return false;
            }

            if ( !calculateOnly ) {
                formData = $form.serializeArray();

                if ( $lastVClicked && $lastVClicked[ 0 ].form === $form[ 0 ] ) {
                    vclickedName = $lastVClicked.attr( "name" );
                    if ( vclickedName ) {
                        // Make sure the last clicked element is included in the form
                        $.each( formData, function( key, value ) {
                            if ( value.name === vclickedName ) {
                                // Unset vclickedName - we've found it in the serialized data already
                                vclickedName = "";
                                return false;
                            }
                        });
                        if ( vclickedName ) {
                            formData.push( { name: vclickedName, value: $lastVClicked.attr( "value" ) } );
                        }
                    }
                }

                ret = {
                    url: url,
                    options: {
                        type:        method,
                        data:        $.param( formData ),
                        transition:    $form.jqmData( "transition" ),
                        reverse:    $form.jqmData( "direction" ) === "reverse",
                        reloadPage:    true
                    }
                };
            }

            return ret;
        };

        //bind to form submit events, handle with Ajax
        $.mobile.document.delegate( "form", "submit", function( event ) {
            var formData;

            if ( !event.isDefaultPrevented() ) {
                formData = getAjaxFormData( $( this ) );
                if ( formData ) {
                    $.mobile.changePage( formData.url, formData.options );
                    event.preventDefault();
                }
            }
        });

        //add active state on vclick
        $.mobile.document.bind( "vclick", function( event ) {
            var $btn, btnEls, target = event.target, needClosest = false;
            // if this isn't a left click we don't care. Its important to note
            // that when the virtual event is generated it will create the which attr
            if ( event.which > 1 || !$.mobile.linkBindingEnabled ) {
                return;
            }

            // Record that this element was clicked, in case we need it for correct
            // form submission during the "submit" handler above
            $lastVClicked = $( target );

            // Try to find a target element to which the active class will be applied
            if ( $.data( target, "mobile-button" ) ) {
                // If the form will not be submitted via AJAX, do not add active class
                if ( !getAjaxFormData( $( target ).closest( "form" ), true ) ) {
                    return;
                }
                // We will apply the active state to this button widget - the parent
                // of the input that was clicked will have the associated data
                if ( target.parentNode ) {
                    target = target.parentNode;
                }
            } else {
                target = findClosestLink( target );
                if ( !( target && $.mobile.path.parseUrl( target.getAttribute( "href" ) || "#" ).hash !== "#" ) ) {
                    return;
                }

                // TODO teach $.mobile.hijackable to operate on raw dom elements so the
                // link wrapping can be avoided
                if ( !$( target ).jqmHijackable().length ) {
                    return;
                }
            }

            // Avoid calling .closest by using the data set during .buttonMarkup()
            // List items have the button data in the parent of the element clicked
            if ( !!~target.className.indexOf( "ui-link-inherit" ) ) {
                if ( target.parentNode ) {
                    btnEls = $.data( target.parentNode, "buttonElements" );
                }
            // Otherwise, look for the data on the target itself
            } else {
                btnEls = $.data( target, "buttonElements" );
            }
            // If found, grab the button's outer element
            if ( btnEls ) {
                target = btnEls.outer;
            } else {
                needClosest = true;
            }

            $btn = $( target );
            // If the outer element wasn't found by the our heuristics, use .closest()
            if ( needClosest ) {
                $btn = $btn.closest( ".ui-btn" );
            }

            if ( $btn.length > 0 &&
                !( $btn.hasClass( "ui-state-disabled" ||

                    // DEPRECATED as of 1.4.0 - remove after 1.4.0 release
                    // only ui-state-disabled should be present thereafter
                    $btn.hasClass( "ui-disabled" ) ) ) ) {
                $.mobile.removeActiveLinkClass( true );
                $.mobile.activeClickedLink = $btn;
                $.mobile.activeClickedLink.addClass( $.mobile.activeBtnClass );
            }
        });

        // click routing - direct to HTTP or Ajax, accordingly
        $.mobile.document.bind( "click", function( event ) {
            if ( !$.mobile.linkBindingEnabled || event.isDefaultPrevented() ) {
                return;
            }

            var link = findClosestLink( event.target ),
                $link = $( link ),

                //remove active link class if external (then it won't be there if you come back)
                httpCleanup = function() {
                    window.setTimeout(function() { $.mobile.removeActiveLinkClass( true ); }, 200 );
                },
                baseUrl, href,
                useDefaultUrlHandling, isExternal,
                transition, reverse, role;

            // If a button was clicked, clean up the active class added by vclick above
            if ( $.mobile.activeClickedLink &&
                $.mobile.activeClickedLink[ 0 ] === event.target.parentNode ) {
                httpCleanup();
            }

            // If there is no link associated with the click or its not a left
            // click we want to ignore the click
            // TODO teach $.mobile.hijackable to operate on raw dom elements so the link wrapping
            // can be avoided
            if ( !link || event.which > 1 || !$link.jqmHijackable().length ) {
                return;
            }

            //if there's a data-rel=back attr, go back in history
            if ( $link.is( ":jqmData(rel='back')" ) ) {
                $.mobile.back();
                return false;
            }

            baseUrl = $.mobile.getClosestBaseUrl( $link );

            //get href, if defined, otherwise default to empty hash
            href = $.mobile.path.makeUrlAbsolute( $link.attr( "href" ) || "#", baseUrl );

            //if ajax is disabled, exit early
            if ( !$.mobile.ajaxEnabled && !$.mobile.path.isEmbeddedPage( href ) ) {
                httpCleanup();
                //use default click handling
                return;
            }

            // XXX_jblas: Ideally links to application pages should be specified as
            //            an url to the application document with a hash that is either
            //            the site relative path or id to the page. But some of the
            //            internal code that dynamically generates sub-pages for nested
            //            lists and select dialogs, just write a hash in the link they
            //            create. This means the actual URL path is based on whatever
            //            the current value of the base tag is at the time this code
            //            is called.
            if ( href.search( "#" ) !== -1 &&
                !( $.mobile.path.isExternal( href ) && $.mobile.path.isAbsoluteUrl( href ) ) ) {

                href = href.replace( /[^#]*#/, "" );
                if ( !href ) {
                    //link was an empty hash meant purely
                    //for interaction, so we ignore it.
                    event.preventDefault();
                    return;
                } else if ( $.mobile.path.isPath( href ) ) {
                    //we have apath so make it the href we want to load.
                    href = $.mobile.path.makeUrlAbsolute( href, baseUrl );
                } else {
                    //we have a simple id so use the documentUrl as its base.
                    href = $.mobile.path.makeUrlAbsolute( "#" + href, documentUrl.hrefNoHash );
                }
            }

            // Should we handle this link, or let the browser deal with it?
            useDefaultUrlHandling = $link.is( "[rel='external']" ) || $link.is( ":jqmData(ajax='false')" ) || $link.is( "[target]" );

            // Some embedded browsers, like the web view in Phone Gap, allow cross-domain XHR
            // requests if the document doing the request was loaded via the file:// protocol.
            // This is usually to allow the application to "phone home" and fetch app specific
            // data. We normally let the browser handle external/cross-domain urls, but if the
            // allowCrossDomainPages option is true, we will allow cross-domain http/https
            // requests to go through our page loading logic.

            //check for protocol or rel and its not an embedded page
            //TODO overlap in logic from isExternal, rel=external check should be
            //     moved into more comprehensive isExternalLink
            isExternal = useDefaultUrlHandling || ( $.mobile.path.isExternal( href ) && !$.mobile.path.isPermittedCrossDomainRequest( documentUrl, href ) );

            if ( isExternal ) {
                httpCleanup();
                //use default click handling
                return;
            }

            //use ajax
            transition = $link.jqmData( "transition" );
            reverse = $link.jqmData( "direction" ) === "reverse" ||
                        // deprecated - remove by 1.0
                        $link.jqmData( "back" );

            //this may need to be more specific as we use data-rel more
            role = $link.attr( "data-" + $.mobile.ns + "rel" ) || undefined;

            $.mobile.changePage( href, { transition: transition, reverse: reverse, role: role, link: $link } );
            event.preventDefault();
        });

        //prefetch pages when anchors with data-prefetch are encountered
        $.mobile.document.delegate( ".ui-page", "pageshow.prefetch", function() {
            var urls = [];
            $( this ).find( "a:jqmData(prefetch)" ).each(function() {
                var $link = $( this ),
                    url = $link.attr( "href" );

                if ( url && $.inArray( url, urls ) === -1 ) {
                    urls.push( url );

                    $.mobile.loadPage( url, { role: $link.attr( "data-" + $.mobile.ns + "rel" ),prefetch: true } );
                }
            });
        });

        // TODO ensure that the navigate binding in the content widget happens at the right time
        $.mobile.pageContainer.pagecontainer();

        //set page min-heights to be device specific
        $.mobile.document.bind( "pageshow", function() {

            // We need to wait for window.load to make sure that styles have already been rendered,
            // otherwise heights of external toolbars will have the wrong value
            if ( loadDeferred ) {
                loadDeferred.done( $.mobile.resetActivePageHeight );
            } else {
                $.mobile.resetActivePageHeight();
            }
        });
        $.mobile.window.bind( "throttledresize", $.mobile.resetActivePageHeight );

    };//navreadyDeferred done callback

    $( function() { domreadyDeferred.resolve(); } );

    // Account for the possibility that the load event has already fired
    if ( document.readyState === "complete" ) {
        pageIsFullyLoaded();
    } else {
        $.mobile.window.load( pageIsFullyLoaded );
    }

    $.when( domreadyDeferred, $.mobile.navreadyDeferred ).done( function() { $.mobile._registerInternalEvents(); } );
})( jQuery );


(function( $, window, undefined ) {

    // TODO remove direct references to $.mobile and properties, we should
    //      favor injection with params to the constructor
    $.mobile.Transition = function() {
        this.init.apply( this, arguments );
    };

    $.extend($.mobile.Transition.prototype, {
        toPreClass: " ui-page-pre-in",

        init: function( name, reverse, $to, $from ) {
            $.extend(this, {
                name: name,
                reverse: reverse,
                $to: $to,
                $from: $from,
                deferred: new $.Deferred()
            });
        },

        cleanFrom: function() {
            this.$from
                .removeClass( $.mobile.activePageClass + " out in reverse " + this.name )
                .height( "" );
        },

        // NOTE overridden by child object prototypes, noop'd here as defaults
        beforeDoneIn: function() {},
        beforeDoneOut: function() {},
        beforeStartOut: function() {},

        doneIn: function() {
            this.beforeDoneIn();

            this.$to.removeClass( "out in reverse " + this.name ).height( "" );

            this.toggleViewportClass();

            // In some browsers (iOS5), 3D transitions block the ability to scroll to the desired location during transition
            // This ensures we jump to that spot after the fact, if we aren't there already.
            if ( $.mobile.window.scrollTop() !== this.toScroll ) {
                this.scrollPage();
            }
            if ( !this.sequential ) {
                this.$to.addClass( $.mobile.activePageClass );
            }
            this.deferred.resolve( this.name, this.reverse, this.$to, this.$from, true );
        },

        doneOut: function( screenHeight, reverseClass, none, preventFocus ) {
            this.beforeDoneOut();
            this.startIn( screenHeight, reverseClass, none, preventFocus );
        },

        hideIn: function( callback ) {
            // Prevent flickering in phonegap container: see comments at #4024 regarding iOS
            this.$to.css( "z-index", -10 );
            callback.call( this );
            this.$to.css( "z-index", "" );
        },

        scrollPage: function() {
            // By using scrollTo instead of silentScroll, we can keep things better in order
            // Just to be precautios, disable scrollstart listening like silentScroll would
            $.event.special.scrollstart.enabled = false;
            //if we are hiding the url bar or the page was previously scrolled scroll to hide or return to position
            if ( $.mobile.hideUrlBar || this.toScroll !== $.mobile.defaultHomeScroll ) {
                window.scrollTo( 0, this.toScroll );
            }

            // reenable scrollstart listening like silentScroll would
            setTimeout( function() {
                $.event.special.scrollstart.enabled = true;
            }, 150 );
        },

        startIn: function( screenHeight, reverseClass, none, preventFocus ) {
            this.hideIn(function() {
                this.$to.addClass( $.mobile.activePageClass + this.toPreClass );

                // Send focus to page as it is now display: block
                if ( !preventFocus ) {
                    $.mobile.focusPage( this.$to );
                }

                // Set to page height
                this.$to.height( screenHeight + this.toScroll );

                if ( !none ) {
                    this.scrollPage();
                }
            });

            this.$to
                .removeClass( this.toPreClass )
                .addClass( this.name + " in " + reverseClass );

            if ( !none ) {
                this.$to.animationComplete( $.proxy(function() {
                    this.doneIn();
                }, this ));
            } else {
                this.doneIn();
            }

        },

        startOut: function( screenHeight, reverseClass, none ) {
            this.beforeStartOut( screenHeight, reverseClass, none );

            // Set the from page's height and start it transitioning out
            // Note: setting an explicit height helps eliminate tiling in the transitions
            this.$from
                .height( screenHeight + $.mobile.window.scrollTop() )
                .addClass( this.name + " out" + reverseClass );
        },

        toggleViewportClass: function() {
            $.mobile.pageContainer.toggleClass( "ui-mobile-viewport-transitioning viewport-" + this.name );
        },

        transition: function() {
            // NOTE many of these could be calculated/recorded in the constructor, it's my
            //      opinion that binding them as late as possible has value with regards to
            //      better transitions with fewer bugs. Ie, it's not guaranteed that the
            //      object will be created and transition will be run immediately after as
            //      it is today. So we wait until transition is invoked to gather the following
            var none,
                reverseClass = this.reverse ? " reverse" : "",
                screenHeight = $.mobile.getScreenHeight(),
                maxTransitionOverride = $.mobile.maxTransitionWidth !== false &&
                    $.mobile.window.width() > $.mobile.maxTransitionWidth;

            this.toScroll = $.mobile.navigate.history.getActive().lastScroll || $.mobile.defaultHomeScroll;

            none = !$.support.cssTransitions || !$.support.cssAnimations ||
                maxTransitionOverride || !this.name || this.name === "none" ||
                Math.max( $.mobile.window.scrollTop(), this.toScroll ) >
                    $.mobile.getMaxScrollForTransition();

            this.toggleViewportClass();

            if ( this.$from && !none ) {
                this.startOut( screenHeight, reverseClass, none );
            } else {
                this.doneOut( screenHeight, reverseClass, none, true );
            }

            return this.deferred.promise();
        }
    });
})( jQuery, this );


(function( $ ) {

    $.mobile.SerialTransition = function() {
        this.init.apply(this, arguments);
    };

    $.extend($.mobile.SerialTransition.prototype, $.mobile.Transition.prototype, {
        sequential: true,

        beforeDoneOut: function() {
            if ( this.$from ) {
                this.cleanFrom();
            }
        },

        beforeStartOut: function( screenHeight, reverseClass, none ) {
            this.$from.animationComplete($.proxy(function() {
                this.doneOut( screenHeight, reverseClass, none );
            }, this ));
        }
    });

})( jQuery );


(function( $ ) {

    $.mobile.ConcurrentTransition = function() {
        this.init.apply(this, arguments);
    };

    $.extend($.mobile.ConcurrentTransition.prototype, $.mobile.Transition.prototype, {
        sequential: false,

        beforeDoneIn: function() {
            if ( this.$from ) {
                this.cleanFrom();
            }
        },

        beforeStartOut: function( screenHeight, reverseClass, none ) {
            this.doneOut( screenHeight, reverseClass, none );
        }
    });

})( jQuery );


(function( $ ) {

    // generate the handlers from the above
    var defaultGetMaxScrollForTransition = function() {
        return $.mobile.getScreenHeight() * 3;
    };

    //transition handler dictionary for 3rd party transitions
    $.mobile.transitionHandlers = {
        "sequential": $.mobile.SerialTransition,
        "simultaneous": $.mobile.ConcurrentTransition
    };

    // Make our transition handler the public default.
    $.mobile.defaultTransitionHandler = $.mobile.transitionHandlers.sequential;

    $.mobile.transitionFallbacks = {};

    // If transition is defined, check if css 3D transforms are supported, and if not, if a fallback is specified
    $.mobile._maybeDegradeTransition = function( transition ) {
        if ( transition && !$.support.cssTransform3d && $.mobile.transitionFallbacks[ transition ] ) {
            transition = $.mobile.transitionFallbacks[ transition ];
        }

        return transition;
    };

    // Set the getMaxScrollForTransition to default if no implementation was set by user
    $.mobile.getMaxScrollForTransition = $.mobile.getMaxScrollForTransition || defaultGetMaxScrollForTransition;

})( jQuery );

/*
* fallback transition for flip in non-3D supporting browsers (which tend to handle complex transitions poorly in general
*/

(function( $, window, undefined ) {

$.mobile.transitionFallbacks.flip = "fade";

})( jQuery, this );

/*
* fallback transition for flow in non-3D supporting browsers (which tend to handle complex transitions poorly in general
*/

(function( $, window, undefined ) {

$.mobile.transitionFallbacks.flow = "fade";

})( jQuery, this );

/*
* fallback transition for pop in non-3D supporting browsers (which tend to handle complex transitions poorly in general
*/

(function( $, window, undefined ) {

$.mobile.transitionFallbacks.pop = "fade";

})( jQuery, this );

/*
* fallback transition for slide in non-3D supporting browsers (which tend to handle complex transitions poorly in general
*/

(function( $, window, undefined ) {

// Use the simultaneous transitions handler for slide transitions
$.mobile.transitionHandlers.slide = $.mobile.transitionHandlers.simultaneous;

// Set the slide transitions's fallback to "fade"
$.mobile.transitionFallbacks.slide = "fade";

})( jQuery, this );

/*
* fallback transition for slidedown in non-3D supporting browsers (which tend to handle complex transitions poorly in general
*/

(function( $, window, undefined ) {

$.mobile.transitionFallbacks.slidedown = "fade";

})( jQuery, this );

/*
* fallback transition for slidefade in non-3D supporting browsers (which tend to handle complex transitions poorly in general
*/

(function( $, window, undefined ) {

// Set the slide transitions's fallback to "fade"
$.mobile.transitionFallbacks.slidefade = "fade";

})( jQuery, this );

/*
* fallback transition for slideup in non-3D supporting browsers (which tend to handle complex transitions poorly in general
*/

(function( $, window, undefined ) {

$.mobile.transitionFallbacks.slideup = "fade";

})( jQuery, this );

/*
* fallback transition for turn in non-3D supporting browsers (which tend to handle complex transitions poorly in general
*/

(function( $, window, undefined ) {

$.mobile.transitionFallbacks.turn = "fade";

})( jQuery, this );


(function( $, undefined ) {

$.mobile.degradeInputs = {
    color: false,
    date: false,
    datetime: false,
    "datetime-local": false,
    email: false,
    month: false,
    number: false,
    range: "number",
    search: "text",
    tel: false,
    time: false,
    url: false,
    week: false
};
// Backcompat remove in 1.5
$.mobile.page.prototype.options.degradeInputs = $.mobile.degradeInputs;

// Auto self-init widgets
$.mobile.degradeInputsWithin = function( target ) {

    target = $( target );

    // Degrade inputs to avoid poorly implemented native functionality
    target.find( "input" ).not( $.mobile.page.prototype.keepNativeSelector() ).each(function() {
        var element = $( this ),
            type = this.getAttribute( "type" ),
            optType = $.mobile.degradeInputs[ type ] || "text",
            html, hasType, findstr, repstr;

        if ( $.mobile.degradeInputs[ type ] ) {
            html = $( "<div>" ).html( element.clone() ).html();
            // In IE browsers, the type sometimes doesn't exist in the cloned markup, so we replace the closing tag instead
            hasType = html.indexOf( " type=" ) > -1;
            findstr = hasType ? /\s+type=["']?\w+['"]?/ : /\/?>/;
            repstr = " type=\"" + optType + "\" data-" + $.mobile.ns + "type=\"" + type + "\"" + ( hasType ? "" : ">" );

            element.replaceWith( html.replace( findstr, repstr ) );
        }
    });

};

})( jQuery );

(function( $, window, undefined ) {

$.widget( "mobile.page", $.mobile.page, {
    options: {

        // Accepts left, right and none
        closeBtn: "left",
        closeBtnText: "Close",
        overlayTheme: "a",
        corners: true,
        dialog: false
    },

    _create: function() {
        this._super();
        if ( this.options.dialog ) {

            $.extend( this, {
                _inner: this.element.children(),
                _headerCloseButton: null
            });

            if ( !this.options.enhanced ) {
                this._setCloseBtn( this.options.closeBtn );
            }
        }
    },

    _enhance: function() {
        this._super();

        // Class the markup for dialog styling and wrap interior
        if ( this.options.dialog ) {
            this.element.addClass( "ui-dialog" )
                .wrapInner( $( "<div/>", {

                    // ARIA role
                    "role" : "dialog",
                    "class" : "ui-dialog-contain ui-overlay-shadow" +
                        ( this.options.corners ? " ui-corner-all" : "" )
                }));
        }
    },

    _setOptions: function( options ) {
        var closeButtonLocation, closeButtonText,
            currentOpts = this.options;

        if ( options.corners !== undefined ) {
            this._inner.toggleClass( "ui-corner-all", !!options.corners );
        }

        if ( options.overlayTheme !== undefined ) {
            if ( $.mobile.activePage[ 0 ] === this.element[ 0 ] ) {
                currentOpts.overlayTheme = options.overlayTheme;
                this._handlePageBeforeShow();
            }
        }

        if ( options.closeBtnText !== undefined ) {
            closeButtonLocation = currentOpts.closeBtn;
            closeButtonText = options.closeBtnText;
        }

        if ( options.closeBtn !== undefined ) {
            closeButtonLocation = options.closeBtn;
        }

        if ( closeButtonLocation ) {
            this._setCloseBtn( closeButtonLocation, closeButtonText );
        }

        this._super( options );
    },

    _handlePageBeforeShow: function () {
        if ( this.options.overlayTheme && this.options.dialog ) {
            this.removeContainerBackground();
            this.setContainerBackground( this.options.overlayTheme );
        } else {
            this._super();
        }
    },

    _setCloseBtn: function( location, text ) {
        var dst,
            btn = this._headerCloseButton;

        // Sanitize value
        location = "left" === location ? "left" : "right" === location ? "right" : "none";

        if ( "none" === location ) {
            if ( btn ) {
                btn.remove();
                btn = null;
            }
        } else if ( btn ) {
            btn.removeClass( "ui-btn-left ui-btn-right" ).addClass( "ui-btn-" + location );
            if ( text ) {
                btn.text( text );
            }
        } else {
            dst = this._inner.find( ":jqmData(role='header')" ).first();
            btn = $( "<a></a>", {
                    "href": "#",
                    "class": "ui-btn ui-corner-all ui-icon-delete ui-btn-icon-notext ui-btn-" + location
                })
                .attr( "data-" + $.mobile.ns + "rel", "back" )
                .text( text || this.options.closeBtnText || "" )
                .prependTo( dst );
        }

        this._headerCloseButton = btn;
    }
});

})( jQuery, this );

(function( $, window, undefined ) {

$.widget( "mobile.dialog", {
    options: {

        // Accepts left, right and none
        closeBtn: "left",
        closeBtnText: "Close",
        overlayTheme: "a",
        corners: true
    },

    // Override the theme set by the page plugin on pageshow
    _handlePageBeforeShow: function() {
        this._isCloseable = true;
        if ( this.options.overlayTheme ) {
            this.element
                .page( "removeContainerBackground" )
                .page( "setContainerBackground", this.options.overlayTheme );
        }
    },

    _handlePageBeforeHide: function() {
        this._isCloseable = false;
    },

    // click and submit events:
    // - clicks and submits should use the closing transition that the dialog
    //   opened with unless a data-transition is specified on the link/form
    // - if the click was on the close button, or the link has a data-rel="back"
    //   it'll go back in history naturally
    _handleVClickSubmit: function( event ) {
        var attrs,
            $target = $( event.target ).closest( event.type === "vclick" ? "a" : "form" );

        if ( $target.length && !$target.jqmData( "transition" ) ) {
            attrs = {};
            attrs[ "data-" + $.mobile.ns + "transition" ] =
                ( $.mobile.navigate.history.getActive() || {} )[ "transition" ] ||
                $.mobile.defaultDialogTransition;
            attrs[ "data-" + $.mobile.ns + "direction" ] = "reverse";
            $target.attr( attrs );
        }
    },

    _create: function() {
        var elem = this.element,
            opts = this.options;

        // Class the markup for dialog styling and wrap interior
        elem.addClass( "ui-dialog" )
            .wrapInner( $( "<div/>", {

                // ARIA role
                "role" : "dialog",
                "class" : "ui-dialog-contain ui-overlay-shadow" +
                    ( !!opts.corners ? " ui-corner-all" : "" )
            }));

        $.extend( this, {
            _isCloseable: false,
            _inner: elem.children(),
            _headerCloseButton: null
        });

        this._on( elem, {
            vclick: "_handleVClickSubmit",
            submit: "_handleVClickSubmit",
            pagebeforeshow: "_handlePageBeforeShow",
            pagebeforehide: "_handlePageBeforeHide"
        });

        this._setCloseBtn( opts.closeBtn );
    },

    _setOptions: function( options ) {
        var closeButtonLocation, closeButtonText,
            currentOpts = this.options;

        if ( options.corners !== undefined ) {
            this._inner.toggleClass( "ui-corner-all", !!options.corners );
        }

        if ( options.overlayTheme !== undefined ) {
            if ( $.mobile.activePage[ 0 ] === this.element[ 0 ] ) {
                currentOpts.overlayTheme = options.overlayTheme;
                this._handlePageBeforeShow();
            }
        }

        if ( options.closeBtnText !== undefined ) {
            closeButtonLocation = currentOpts.closeBtn;
            closeButtonText = options.closeBtnText;
        }

        if ( options.closeBtn !== undefined ) {
            closeButtonLocation = options.closeBtn;
        }

        if ( closeButtonLocation ) {
            this._setCloseBtn( closeButtonLocation, closeButtonText );
        }

        this._super( options );
    },

    _setCloseBtn: function( location, text ) {
        var dst,
            btn = this._headerCloseButton;

        // Sanitize value
        location = "left" === location ? "left" : "right" === location ? "right" : "none";

        if ( "none" === location ) {
            if ( btn ) {
                btn.remove();
                btn = null;
            }
        } else if ( btn ) {
            btn.removeClass( "ui-btn-left ui-btn-right" ).addClass( "ui-btn-" + location );
            if ( text ) {
                btn.text( text );
            }
        } else {
            dst = this._inner.find( ":jqmData(role='header')" ).first();
            btn = $( "<a></a>", {
                    "role": "button",
                    "href": "#",
                    "class": "ui-btn ui-corner-all ui-icon-delete ui-btn-icon-notext ui-btn-" + location
                })
                .text( text || this.options.closeBtnText || "" )
                .prependTo( dst );
            this._on( btn, { click: "close" } );
        }

        this._headerCloseButton = btn;
    },

    // Close method goes back in history
    close: function() {
        var hist = $.mobile.navigate.history;

        if ( this._isCloseable ) {
            this._isCloseable = false;
            // If the hash listening is enabled and there is at least one preceding history
            // entry it's ok to go back. Initial pages with the dialog hash state are an example
            // where the stack check is necessary
            if ( $.mobile.hashListeningEnabled && hist.activeIndex > 0 ) {
                $.mobile.back();
            } else {
                $.mobile.pageContainer.pagecontainer( "back" );
            }
        }
    }
});

})( jQuery, this );

(function( $, undefined ) {

var rInitialLetter = /([A-Z])/g,

    // Construct iconpos class from iconpos value
    iconposClass = function( iconpos ) {
        return ( "ui-btn-icon-" + ( iconpos === null ? "left" : iconpos ) );
    };

$.widget( "mobile.collapsible", {
    options: {
        enhanced: false,
        expandCueText: null,
        collapseCueText: null,
        collapsed: true,
        heading: "h1,h2,h3,h4,h5,h6,legend",
        collapsedIcon: null,
        expandedIcon: null,
        iconpos: null,
        theme: null,
        contentTheme: null,
        inset: null,
        corners: null,
        mini: null
    },

    _create: function() {
        var elem = this.element,
            ui = {
                accordion: elem
                    .closest( ":jqmData(role='collapsible-set')," +
                        ":jqmData(role='collapsibleset')" +
                        ( $.mobile.collapsibleset ? ", :mobile-collapsibleset" :
                            "" ) )
                    .addClass( "ui-collapsible-set" )
            };

        this._ui = ui;
        this._renderedOptions = this._getOptions( this.options );

        if ( this.options.enhanced ) {
            ui.heading = this.element.children( ".ui-collapsible-heading" );
            ui.content = ui.heading.next();
            ui.anchor = ui.heading.children();
            ui.status = ui.anchor.children( ".ui-collapsible-heading-status" );
        } else {
            this._enhance( elem, ui );
        }

        this._on( ui.heading, {
            "tap": function() {
                ui.heading.find( "a" ).first().addClass( $.mobile.activeBtnClass );
            },

            "click": function( event ) {
                this._handleExpandCollapse( !ui.heading.hasClass( "ui-collapsible-heading-collapsed" ) );
                event.preventDefault();
                event.stopPropagation();
            }
        });
    },

    // Adjust the keys inside options for inherited values
    _getOptions: function( options ) {
        var key,
            accordion = this._ui.accordion,
            accordionWidget = this._ui.accordionWidget;

        // Copy options
        options = $.extend( {}, options );

        if ( accordion.length && !accordionWidget ) {
            this._ui.accordionWidget =
            accordionWidget = accordion.data( "mobile-collapsibleset" );
        }

        for ( key in options ) {

            // Retrieve the option value first from the options object passed in and, if
            // null, from the parent accordion or, if that's null too, or if there's no
            // parent accordion, then from the defaults.
            options[ key ] =
                ( options[ key ] != null ) ? options[ key ] :
                ( accordionWidget ) ? accordionWidget.options[ key ] :
                accordion.length ? $.mobile.getAttribute( accordion[ 0 ],
                    key.replace( rInitialLetter, "-$1" ).toLowerCase() ):
                null;

            if ( null == options[ key ] ) {
                options[ key ] = $.mobile.collapsible.defaults[ key ];
            }
        }

        return options;
    },

    _themeClassFromOption: function( prefix, value ) {
        return ( value ? ( value === "none" ? "" : prefix + value ) : "" );
    },

    _enhance: function( elem, ui ) {
        var iconclass,
            opts = this._renderedOptions,
            contentThemeClass = this._themeClassFromOption( "ui-body-", opts.contentTheme );

        elem.addClass( "ui-collapsible " +
            ( opts.inset ? "ui-collapsible-inset " : "" ) +
            ( opts.inset && opts.corners ? "ui-corner-all " : "" ) +
            ( contentThemeClass ? "ui-collapsible-themed-content " : "" ) );
        ui.originalHeading = elem.children( this.options.heading ).first(),
        ui.content = elem
            .wrapInner( "<div " +
                "class='ui-collapsible-content " +
                contentThemeClass + "'></div>" )
            .children( ".ui-collapsible-content" ),
        ui.heading = ui.originalHeading;

        // Replace collapsibleHeading if it's a legend
        if ( ui.heading.is( "legend" ) ) {
            ui.heading = $( "<div role='heading'>"+ ui.heading.html() +"</div>" );
            ui.placeholder = $( "<div><!-- placeholder for legend --></div>" ).insertBefore( ui.originalHeading );
            ui.originalHeading.remove();
        }

        iconclass = ( opts.collapsed ? ( opts.collapsedIcon ? "ui-icon-" + opts.collapsedIcon : "" ):
            ( opts.expandedIcon ? "ui-icon-" + opts.expandedIcon : "" ) );

        ui.status = $( "<span class='ui-collapsible-heading-status'></span>" );
        ui.anchor = ui.heading
            .detach()
            //modify markup & attributes
            .addClass( "ui-collapsible-heading" )
            .append( ui.status )
            .wrapInner( "<a href='#' class='ui-collapsible-heading-toggle'></a>" )
            .find( "a" )
                .first()
                .addClass( "ui-btn " +
                    ( iconclass ? iconclass + " " : "" ) +
                    ( iconclass ? iconposClass( opts.iconpos ) +
                        " " : "" ) +
                    this._themeClassFromOption( "ui-btn-", opts.theme ) + " " +
                    ( opts.mini ? "ui-mini " : "" ) );

        //drop heading in before content
        ui.heading.insertBefore( ui.content );

        this._handleExpandCollapse( this.options.collapsed );

        return ui;
    },

    refresh: function() {
        this._applyOptions( this.options );
        this._renderedOptions = this._getOptions( this.options );
    },

    _applyOptions: function( options ) {
        var isCollapsed, newTheme, oldTheme, hasCorners, hasIcon,
            elem = this.element,
            currentOpts = this._renderedOptions,
            ui = this._ui,
            anchor = ui.anchor,
            status = ui.status,
            opts = this._getOptions( options );

        // First and foremost we need to make sure the collapsible is in the proper
        // state, in case somebody decided to change the collapsed option at the
        // same time as another option
        if ( options.collapsed !== undefined ) {
            this._handleExpandCollapse( options.collapsed );
        }

        isCollapsed = elem.hasClass( "ui-collapsible-collapsed" );

        // We only need to apply the cue text for the current state right away.
        // The cue text for the alternate state will be stored in the options
        // and applied the next time the collapsible's state is toggled
        if ( isCollapsed ) {
            if ( opts.expandCueText !== undefined ) {
                status.text( opts.expandCueText );
            }
        } else {
            if ( opts.collapseCueText !== undefined ) {
                status.text( opts.collapseCueText );
            }
        }

        // Update icon

        // Is it supposed to have an icon?
        hasIcon =

            // If the collapsedIcon is being set, consult that
            ( opts.collapsedIcon !== undefined ? opts.collapsedIcon !== false :

                // Otherwise consult the existing option value
                currentOpts.collapsedIcon !== false );


        // If any icon-related options have changed, make sure the new icon
        // state is reflected by first removing all icon-related classes
        // reflecting the current state and then adding all icon-related
        // classes for the new state
        if ( !( opts.iconpos === undefined &&
            opts.collapsedIcon === undefined &&
            opts.expandedIcon === undefined ) ) {

            // Remove all current icon-related classes
            anchor.removeClass( [ iconposClass( currentOpts.iconpos ) ]
                .concat( ( currentOpts.expandedIcon ?
                    [ "ui-icon-" + currentOpts.expandedIcon ] : [] ) )
                .concat( ( currentOpts.collapsedIcon ?
                    [ "ui-icon-" + currentOpts.collapsedIcon ] : [] ) )
                .join( " " ) );

            // Add new classes if an icon is supposed to be present
            if ( hasIcon ) {
                anchor.addClass(
                    [ iconposClass( opts.iconpos !== undefined ?
                        opts.iconpos : currentOpts.iconpos ) ]
                        .concat( isCollapsed ?
                            [ "ui-icon-" + ( opts.collapsedIcon !== undefined ?
                                opts.collapsedIcon :
                                currentOpts.collapsedIcon ) ] :
                            [ "ui-icon-" + ( opts.expandedIcon !== undefined ?
                                opts.expandedIcon :
                                currentOpts.expandedIcon ) ] )
                        .join( " " ) );
            }
        }

        if ( opts.theme !== undefined ) {
            oldTheme = this._themeClassFromOption( "ui-btn-", currentOpts.theme );
            newTheme = this._themeClassFromOption( "ui-btn-", opts.theme );
            anchor.removeClass( oldTheme ).addClass( newTheme );
        }

        if ( opts.contentTheme !== undefined ) {
            oldTheme = this._themeClassFromOption( "ui-body-",
                currentOpts.contentTheme );
            newTheme = this._themeClassFromOption( "ui-body-",
                opts.contentTheme );
            ui.content.removeClass( oldTheme ).addClass( newTheme );
        }

        if ( opts.inset !== undefined ) {
            elem.toggleClass( "ui-collapsible-inset", opts.inset );
            hasCorners = !!( opts.inset && ( opts.corners || currentOpts.corners ) );
        }

        if ( opts.corners !== undefined ) {
            hasCorners = !!( opts.corners && ( opts.inset || currentOpts.inset ) );
        }

        if ( hasCorners !== undefined ) {
            elem.toggleClass( "ui-corner-all", hasCorners );
        }

        if ( opts.mini !== undefined ) {
            anchor.toggleClass( "ui-mini", opts.mini );
        }
    },

    _setOptions: function( options ) {
        this._applyOptions( options );
        this._super( options );
        this._renderedOptions = this._getOptions( this.options );
    },

    _handleExpandCollapse: function( isCollapse ) {
        var opts = this._renderedOptions,
            ui = this._ui;

        ui.status.text( isCollapse ? opts.expandCueText : opts.collapseCueText );
        ui.heading
            .toggleClass( "ui-collapsible-heading-collapsed", isCollapse )
            .find( "a" ).first()
            .toggleClass( "ui-icon-" + opts.expandedIcon, !isCollapse )

            // logic or cause same icon for expanded/collapsed state would remove the ui-icon-class
            .toggleClass( "ui-icon-" + opts.collapsedIcon, ( isCollapse || opts.expandedIcon === opts.collapsedIcon ) )
            .removeClass( $.mobile.activeBtnClass );

        this.element.toggleClass( "ui-collapsible-collapsed", isCollapse );
        ui.content
            .toggleClass( "ui-collapsible-content-collapsed", isCollapse )
            .attr( "aria-hidden", isCollapse )
            .trigger( "updatelayout" );
        this.options.collapsed = isCollapse;
        this._trigger( isCollapse ? "collapse" : "expand" );
    },

    expand: function() {
        this._handleExpandCollapse( false );
    },

    collapse: function() {
        this._handleExpandCollapse( true );
    },

    _destroy: function() {
        var ui = this._ui,
            opts = this.options;

        if ( opts.enhanced ) {
            return;
        }

        if ( ui.placeholder ) {
            ui.originalHeading.insertBefore( ui.placeholder );
            ui.placeholder.remove();
            ui.heading.remove();
        } else {
            ui.status.remove();
            ui.heading
                .removeClass( "ui-collapsible-heading ui-collapsible-heading-collapsed" )
                .children()
                    .contents()
                        .unwrap();
        }

        ui.anchor.contents().unwrap();
        ui.content.contents().unwrap();
        this.element
            .removeClass( "ui-collapsible ui-collapsible-collapsed " +
                "ui-collapsible-themed-content ui-collapsible-inset ui-corner-all" );
    }
});

// Defaults to be used by all instances of collapsible if per-instance values
// are unset or if nothing is specified by way of inheritance from an accordion.
// Note that this hash does not contain options "collapsed" or "heading",
// because those are not inheritable.
$.mobile.collapsible.defaults = {
    expandCueText: " click to expand contents",
    collapseCueText: " click to collapse contents",
    collapsedIcon: "plus",
    contentTheme: "inherit",
    expandedIcon: "minus",
    iconpos: "left",
    inset: true,
    corners: true,
    theme: "inherit",
    mini: false
};

})( jQuery );

(function( $, undefined ) {

var uiScreenHiddenRegex = /\bui-screen-hidden\b/;
function noHiddenClass( elements ) {
    var index,
        length = elements.length,
        result = [];

    for ( index = 0; index < length; index++ ) {
        if ( !elements[ index ].className.match( uiScreenHiddenRegex ) ) {
            result.push( elements[ index ] );
        }
    }

    return $( result );
}

$.mobile.behaviors.addFirstLastClasses = {
    _getVisibles: function( $els, create ) {
        var visibles;

        if ( create ) {
            visibles = noHiddenClass( $els );
        } else {
            visibles = $els.filter( ":visible" );
            if ( visibles.length === 0 ) {
                visibles = noHiddenClass( $els );
            }
        }

        return visibles;
    },

    _addFirstLastClasses: function( $els, $visibles, create ) {
        $els.removeClass( "ui-first-child ui-last-child" );
        $visibles.eq( 0 ).addClass( "ui-first-child" ).end().last().addClass( "ui-last-child" );
        if ( !create ) {
            this.element.trigger( "updatelayout" );
        }
    },

    _removeFirstLastClasses: function( $els ) {
        $els.removeClass( "ui-first-child ui-last-child" );
    }
};

})( jQuery );

(function( $, undefined ) {

var childCollapsiblesSelector = ":mobile-collapsible, " + $.mobile.collapsible.initSelector;

$.widget( "mobile.collapsibleset", $.extend( {

    // The initSelector is deprecated as of 1.4.0. In 1.5.0 we will use
    // :jqmData(role='collapsibleset') which will allow us to get rid of the line
    // below altogether, because the autoinit will generate such an initSelector
    initSelector: ":jqmData(role='collapsible-set'),:jqmData(role='collapsibleset')",

    options: $.extend( {
        enhanced: false
    }, $.mobile.collapsible.defaults ),

    _handleCollapsibleExpand: function( event ) {
        var closestCollapsible = $( event.target ).closest( ".ui-collapsible" );

        if ( closestCollapsible.parent().is( ":mobile-collapsibleset, :jqmData(role='collapsible-set')" ) ) {
            closestCollapsible
                .siblings( ".ui-collapsible:not(.ui-collapsible-collapsed)" )
                .collapsible( "collapse" );
        }
    },

    _create: function() {
        var elem = this.element,
            opts = this.options;

        $.extend( this, {
            _classes: ""
        });

        if ( !opts.enhanced ) {
            elem.addClass( "ui-collapsible-set " +
                this._themeClassFromOption( "ui-group-theme-", opts.theme ) + " " +
                ( opts.corners && opts.inset ? "ui-corner-all " : "" ) );
            this.element.find( $.mobile.collapsible.initSelector ).collapsible();
        }

        this._on( elem, { collapsibleexpand: "_handleCollapsibleExpand" } );
    },

    _themeClassFromOption: function( prefix, value ) {
        return ( value ? ( value === "none" ? "" : prefix + value ) : "" );
    },

    _init: function() {
        this._refresh( true );

        // Because the corners are handled by the collapsible itself and the default state is collapsed
        // That was causing https://github.com/jquery/jquery-mobile/issues/4116
        this.element
            .children( childCollapsiblesSelector )
            .filter( ":jqmData(collapsed='false')" )
            .collapsible( "expand" );
    },

    _setOptions: function( options ) {
        var ret, hasCorners,
            elem = this.element,
            themeClass = this._themeClassFromOption( "ui-group-theme-", options.theme );

        if ( themeClass ) {
            elem
                .removeClass( this._themeClassFromOption( "ui-group-theme-", this.options.theme ) )
                .addClass( themeClass );
        }

        if ( options.inset !== undefined ) {
            hasCorners = !!( options.inset && ( options.corners || this.options.corners ) );
        }

        if ( options.corners !== undefined ) {
            hasCorners = !!( options.corners && ( options.inset || this.options.inset ) );
        }

        if ( hasCorners !== undefined ) {
            elem.toggleClass( "ui-corner-all", hasCorners );
        }

        ret = this._super( options );
        this.element.children( ":mobile-collapsible" ).collapsible( "refresh" );
        return ret;
    },

    _destroy: function() {
        var el = this.element;

        this._removeFirstLastClasses( el.children( childCollapsiblesSelector ) );
        el
            .removeClass( "ui-collapsible-set ui-corner-all " +
                this._themeClassFromOption( "ui-group-theme-", this.options.theme ) )
            .children( ":mobile-collapsible" )
            .collapsible( "destroy" );
    },

    _refresh: function( create ) {
        var collapsiblesInSet = this.element.children( childCollapsiblesSelector );

        this.element.find( $.mobile.collapsible.initSelector ).not( ".ui-collapsible" ).collapsible();

        this._addFirstLastClasses( collapsiblesInSet, this._getVisibles( collapsiblesInSet, create ), create );
    },

    refresh: function() {
        this._refresh( false );
    }
}, $.mobile.behaviors.addFirstLastClasses ) );

})( jQuery );

(function( $, undefined ) {

// Deprecated in 1.4
$.fn.fieldcontain = function(/* options */) {
    return this.addClass( "ui-field-contain" );
};

})( jQuery );

(function( $, undefined ) {

$.fn.grid = function( options ) {
    return this.each(function() {

        var $this = $( this ),
            o = $.extend({
                grid: null
            }, options ),
            $kids = $this.children(),
            gridCols = { solo:1, a:2, b:3, c:4, d:5 },
            grid = o.grid,
            iterator,
            letter;

            if ( !grid ) {
                if ( $kids.length <= 5 ) {
                    for ( letter in gridCols ) {
                        if ( gridCols[ letter ] === $kids.length ) {
                            grid = letter;
                        }
                    }
                } else {
                    grid = "a";
                    $this.addClass( "ui-grid-duo" );
                }
            }
            iterator = gridCols[grid];

        $this.addClass( "ui-grid-" + grid );

        $kids.filter( ":nth-child(" + iterator + "n+1)" ).addClass( "ui-block-a" );

        if ( iterator > 1 ) {
            $kids.filter( ":nth-child(" + iterator + "n+2)" ).addClass( "ui-block-b" );
        }
        if ( iterator > 2 ) {
            $kids.filter( ":nth-child(" + iterator + "n+3)" ).addClass( "ui-block-c" );
        }
        if ( iterator > 3 ) {
            $kids.filter( ":nth-child(" + iterator + "n+4)" ).addClass( "ui-block-d" );
        }
        if ( iterator > 4 ) {
            $kids.filter( ":nth-child(" + iterator + "n+5)" ).addClass( "ui-block-e" );
        }
    });
};
})( jQuery );

(function( $, undefined ) {

$.widget( "mobile.navbar", {
    options: {
        iconpos: "top",
        grid: null
    },

    _create: function() {

        var $navbar = this.element,
            $navbtns = $navbar.find( "a, button" ),
            iconpos = $navbtns.filter( ":jqmData(icon)" ).length ? this.options.iconpos : undefined;

        $navbar.addClass( "ui-navbar" )
            .attr( "role", "navigation" )
            .find( "ul" )
            .jqmEnhanceable()
            .grid({ grid: this.options.grid });

        $navbtns
            .each( function() {
                var icon = $.mobile.getAttribute( this, "icon" ),
                    theme = $.mobile.getAttribute( this, "theme" ),
                    classes = "ui-btn";

                if ( theme ) {
                    classes += " ui-btn-" + theme;
                }
                if ( icon ) {
                    classes += " ui-icon-" + icon + " ui-btn-icon-" + iconpos;
                }
                $( this ).addClass( classes );
            });

        $navbar.delegate( "a", "vclick", function( /* event */ ) {
            var activeBtn = $( this );

            if ( !( activeBtn.hasClass( "ui-state-disabled" ) ||

                // DEPRECATED as of 1.4.0 - remove after 1.4.0 release
                // only ui-state-disabled should be present thereafter
                activeBtn.hasClass( "ui-disabled" ) ||
                activeBtn.hasClass( $.mobile.activeBtnClass ) ) ) {

                $navbtns.removeClass( $.mobile.activeBtnClass );
                activeBtn.addClass( $.mobile.activeBtnClass );

                // The code below is a workaround to fix #1181
                $( document ).one( "pagehide", function() {
                    activeBtn.removeClass( $.mobile.activeBtnClass );
                });
            }
        });

        // Buttons in the navbar with ui-state-persist class should regain their active state before page show
        $navbar.closest( ".ui-page" ).bind( "pagebeforeshow", function() {
            $navbtns.filter( ".ui-state-persist" ).addClass( $.mobile.activeBtnClass );
        });
    }
});

})( jQuery );

(function( $, undefined ) {

var getAttr = $.mobile.getAttribute;

$.widget( "mobile.listview", $.extend( {

    options: {
        theme: null,
        countTheme: null, /* Deprecated in 1.4 */
        dividerTheme: null,
        icon: "carat-r",
        splitIcon: "carat-r",
        splitTheme: null,
        corners: true,
        shadow: true,
        inset: false
    },

    _create: function() {
        var t = this,
            listviewClasses = "";

        listviewClasses += t.options.inset ? " ui-listview-inset" : "";

        if ( !!t.options.inset ) {
            listviewClasses += t.options.corners ? " ui-corner-all" : "";
            listviewClasses += t.options.shadow ? " ui-shadow" : "";
        }

        // create listview markup
        t.element.addClass( " ui-listview" + listviewClasses );

        t.refresh( true );
    },

    // TODO: Remove in 1.5
    _findFirstElementByTagName: function( ele, nextProp, lcName, ucName ) {
        var dict = {};
        dict[ lcName ] = dict[ ucName ] = true;
        while ( ele ) {
            if ( dict[ ele.nodeName ] ) {
                return ele;
            }
            ele = ele[ nextProp ];
        }
        return null;
    },
    // TODO: Remove in 1.5
    _addThumbClasses: function( containers ) {
        var i, img, len = containers.length;
        for ( i = 0; i < len; i++ ) {
            img = $( this._findFirstElementByTagName( containers[ i ].firstChild, "nextSibling", "img", "IMG" ) );
            if ( img.length ) {
                $( this._findFirstElementByTagName( img[ 0 ].parentNode, "parentNode", "li", "LI" ) ).addClass( img.hasClass( "ui-li-icon" ) ? "ui-li-has-icon" : "ui-li-has-thumb" );
            }
        }
    },

    _getChildrenByTagName: function( ele, lcName, ucName ) {
        var results = [],
            dict = {};
        dict[ lcName ] = dict[ ucName ] = true;
        ele = ele.firstChild;
        while ( ele ) {
            if ( dict[ ele.nodeName ] ) {
                results.push( ele );
            }
            ele = ele.nextSibling;
        }
        return $( results );
    },

    _beforeListviewRefresh: $.noop,
    _afterListviewRefresh: $.noop,

    refresh: function( create ) {
        var buttonClass, pos, numli, item, itemClass, itemTheme, itemIcon, icon, a,
            isDivider, startCount, newStartCount, value, last, splittheme, splitThemeClass, spliticon,
            altButtonClass, dividerTheme, li,
            o = this.options,
            $list = this.element,
            ol = !!$.nodeName( $list[ 0 ], "ol" ),
            start = $list.attr( "start" ),
            itemClassDict = {},
            countBubbles = $list.find( ".ui-li-count" ),
            countTheme = getAttr( $list[ 0 ], "counttheme" ) || this.options.countTheme,
            countThemeClass = countTheme ? "ui-body-" + countTheme : "ui-body-inherit";

        if ( o.theme ) {
            $list.addClass( "ui-group-theme-" + o.theme );
        }

        // Check if a start attribute has been set while taking a value of 0 into account
        if ( ol && ( start || start === 0 ) ) {
            startCount = parseInt( start, 10 ) - 1;
            $list.css( "counter-reset", "listnumbering " + startCount );
        }

        this._beforeListviewRefresh();

        li = this._getChildrenByTagName( $list[ 0 ], "li", "LI" );

        for ( pos = 0, numli = li.length; pos < numli; pos++ ) {
            item = li.eq( pos );
            itemClass = "";

            if ( create || item[ 0 ].className.search( /\bui-li-static\b|\bui-li-divider\b/ ) < 0 ) {
                a = this._getChildrenByTagName( item[ 0 ], "a", "A" );
                isDivider = ( getAttr( item[ 0 ], "role" ) === "list-divider" );
                value = item.attr( "value" );
                itemTheme = getAttr( item[ 0 ], "theme" );

                if ( a.length && a[ 0 ].className.search( /\bui-btn\b/ ) < 0 && !isDivider ) {
                    itemIcon = getAttr( item[ 0 ], "icon" );
                    icon = ( itemIcon === false ) ? false : ( itemIcon || o.icon );

                    // TODO: Remove in 1.5 together with links.js (links.js / .ui-link deprecated in 1.4)
                    a.removeClass( "ui-link" );

                    buttonClass = "ui-btn";

                    if ( itemTheme ) {
                        buttonClass += " ui-btn-" + itemTheme;
                    }

                    if ( a.length > 1 ) {
                        itemClass = "ui-li-has-alt";

                        last = a.last();
                        splittheme = getAttr( last[ 0 ], "theme" ) || o.splitTheme || getAttr( item[ 0 ], "theme", true );
                        splitThemeClass = splittheme ? " ui-btn-" + splittheme : "";
                        spliticon = getAttr( last[ 0 ], "icon" ) || getAttr( item[ 0 ], "icon" ) || o.splitIcon;
                        altButtonClass = "ui-btn ui-btn-icon-notext ui-icon-" + spliticon + splitThemeClass;

                        last
                            .attr( "title", $.trim( last.getEncodedText() ) )
                            .addClass( altButtonClass )
                            .empty();

                        // Reduce to the first anchor, because only the first gets the buttonClass
                        a = a.first();
                    } else if ( icon ) {
                        buttonClass += " ui-btn-icon-right ui-icon-" + icon;
                    }

                    // Apply buttonClass to the (first) anchor
                    a.addClass( buttonClass );
                } else if ( isDivider ) {
                    dividerTheme = ( getAttr( item[ 0 ], "theme" ) || o.dividerTheme || o.theme );

                    itemClass = "ui-li-divider ui-bar-" + ( dividerTheme ? dividerTheme : "inherit" );

                    item.attr( "role", "heading" );
                } else if ( a.length <= 0 ) {
                    itemClass = "ui-li-static ui-body-" + ( itemTheme ? itemTheme : "inherit" );
                }
                if ( ol && value ) {
                    newStartCount = parseInt( value , 10 ) - 1;

                    item.css( "counter-reset", "listnumbering " + newStartCount );
                }
            }

            // Instead of setting item class directly on the list item
            // at this point in time, push the item into a dictionary
            // that tells us what class to set on it so we can do this after this
            // processing loop is finished.

            if ( !itemClassDict[ itemClass ] ) {
                itemClassDict[ itemClass ] = [];
            }

            itemClassDict[ itemClass ].push( item[ 0 ] );
        }

        // Set the appropriate listview item classes on each list item.
        // The main reason we didn't do this
        // in the for-loop above is because we can eliminate per-item function overhead
        // by calling addClass() and children() once or twice afterwards. This
        // can give us a significant boost on platforms like WP7.5.

        for ( itemClass in itemClassDict ) {
            $( itemClassDict[ itemClass ] ).addClass( itemClass );
        }

        countBubbles.each( function() {
            $( this ).closest( "li" ).addClass( "ui-li-has-count" );
        });
        if ( countThemeClass ) {
            countBubbles.not( "[class*='ui-body-']" ).addClass( countThemeClass );
        }

        // Deprecated in 1.4. From 1.5 you have to add class ui-li-has-thumb or ui-li-has-icon to the LI.
        this._addThumbClasses( li );
        this._addThumbClasses( li.find( ".ui-btn" ) );

        this._afterListviewRefresh();

        this._addFirstLastClasses( li, this._getVisibles( li, create ), create );
    }
}, $.mobile.behaviors.addFirstLastClasses ) );

})( jQuery );

(function( $, undefined ) {

function defaultAutodividersSelector( elt ) {
    // look for the text in the given element
    var text = $.trim( elt.text() ) || null;

    if ( !text ) {
        return null;
    }

    // create the text for the divider (first uppercased letter)
    text = text.slice( 0, 1 ).toUpperCase();

    return text;
}

$.widget( "mobile.listview", $.mobile.listview, {
    options: {
        autodividers: false,
        autodividersSelector: defaultAutodividersSelector
    },

    _beforeListviewRefresh: function() {
        if ( this.options.autodividers ) {
            this._replaceDividers();
            this._superApply( arguments );
        }
    },

    _replaceDividers: function() {
        var i, lis, li, dividerText,
            lastDividerText = null,
            list = this.element,
            divider;

        list.children( "li:jqmData(role='list-divider')" ).remove();

        lis = list.children( "li" );

        for ( i = 0; i < lis.length ; i++ ) {
            li = lis[ i ];
            dividerText = this.options.autodividersSelector( $( li ) );

            if ( dividerText && lastDividerText !== dividerText ) {
                divider = document.createElement( "li" );
                divider.appendChild( document.createTextNode( dividerText ) );
                divider.setAttribute( "data-" + $.mobile.ns + "role", "list-divider" );
                li.parentNode.insertBefore( divider, li );
            }

            lastDividerText = dividerText;
        }
    }
});

})( jQuery );

(function( $, undefined ) {

var rdivider = /(^|\s)ui-li-divider($|\s)/,
    rhidden = /(^|\s)ui-screen-hidden($|\s)/;

$.widget( "mobile.listview", $.mobile.listview, {
    options: {
        hideDividers: false
    },

    _afterListviewRefresh: function() {
        var items, idx, item, hideDivider = true;

        this._superApply( arguments );

        if ( this.options.hideDividers ) {
            items = this._getChildrenByTagName( this.element[ 0 ], "li", "LI" );
            for ( idx = items.length - 1 ; idx > -1 ; idx-- ) {
                item = items[ idx ];
                if ( item.className.match( rdivider ) ) {
                    if ( hideDivider ) {
                        item.className = item.className + " ui-screen-hidden";
                    }
                    hideDivider = true;
                } else {
                    if ( !item.className.match( rhidden ) ) {
                        hideDivider = false;
                    }
                }
            }
        }
    }
});

})( jQuery );

(function( $, undefined ) {

$.mobile.nojs = function( target ) {
    $( ":jqmData(role='nojs')", target ).addClass( "ui-nojs" );
};

})( jQuery );

(function( $, undefined ) {

$.mobile.behaviors.formReset = {
    _handleFormReset: function() {
        this._on( this.element.closest( "form" ), {
            reset: function() {
                this._delay( "_reset" );
            }
        });
    }
};

})( jQuery );

/*
* "checkboxradio" plugin
*/

(function( $, undefined ) {

var escapeId = $.mobile.path.hashToSelector;

$.widget( "mobile.checkboxradio", $.extend( {

    initSelector: "input:not( :jqmData(role='flipswitch' ) )[type='checkbox'],input[type='radio']:not( :jqmData(role='flipswitch' ))",

    options: {
        theme: "inherit",
        mini: false,
        wrapperClass: null,
        enhanced: false,
        iconpos: "left"

    },
    _create: function() {
        var input = this.element,
            o = this.options,
            inheritAttr = function( input, dataAttr ) {
                return input.jqmData( dataAttr ) ||
                    input.closest( "form, fieldset" ).jqmData( dataAttr );
            },
            label = this.options.enhanced ?
                {
                    element: this.element.siblings( "label" ),
                    isParent: false
                } :
                this._findLabel(),
            inputtype = input[0].type,
            checkedClass = "ui-" + inputtype + "-on",
            uncheckedClass = "ui-" + inputtype + "-off";

        if ( inputtype !== "checkbox" && inputtype !== "radio" ) {
            return;
        }

        if ( this.element[0].disabled ) {
            this.options.disabled = true;
        }

        o.iconpos = inheritAttr( input, "iconpos" ) ||
            label.element.attr( "data-" + $.mobile.ns + "iconpos" ) || o.iconpos,

        // Establish options
        o.mini = inheritAttr( input, "mini" ) || o.mini;

        // Expose for other methods
        $.extend( this, {
            input: input,
            label: label.element,
            labelIsParent: label.isParent,
            inputtype: inputtype,
            checkedClass: checkedClass,
            uncheckedClass: uncheckedClass
        });

        if ( !this.options.enhanced ) {
            this._enhance();
        }

        this._on( label.element, {
            vmouseover: "_handleLabelVMouseOver",
            vclick: "_handleLabelVClick"
        });

        this._on( input, {
            vmousedown: "_cacheVals",
            vclick: "_handleInputVClick",
            focus: "_handleInputFocus",
            blur: "_handleInputBlur"
        });

        this._handleFormReset();
        this.refresh();
    },

    _findLabel: function() {
        var parentLabel, label, isParent,
            input = this.element,
            labelsList = input[ 0 ].labels;

        if( labelsList && labelsList.length > 0 ) {
            label = $( labelsList[ 0 ] );
            isParent = $.contains( label[ 0 ], input[ 0 ] );
        } else {
            parentLabel = input.closest( "label" );
            isParent = ( parentLabel.length > 0 );

            // NOTE: Windows Phone could not find the label through a selector
            // filter works though.
            label = isParent ? parentLabel :
                $( this.document[ 0 ].getElementsByTagName( "label" ) )
                    .filter( "[for='" + escapeId( input[ 0 ].id ) + "']" )
                    .first();
        }

        return {
            element: label,
            isParent: isParent
        };
    },

    _enhance: function() {
        this.label.addClass( "ui-btn ui-corner-all");

        if ( this.labelIsParent ) {
            this.input.add( this.label ).wrapAll( this._wrapper() );
        } else {
            //this.element.replaceWith( this.input.add( this.label ).wrapAll( this._wrapper() ) );
            this.element.wrap( this._wrapper() );
            this.element.parent().prepend( this.label );
        }

        // Wrap the input + label in a div

        this._setOptions({
            "theme": this.options.theme,
            "iconpos": this.options.iconpos,
            "mini": this.options.mini
        });

    },

    _wrapper: function() {
        return $( "<div class='"  +
            ( this.options.wrapperClass ? this.options.wrapperClass : "" ) +
            " ui-" + this.inputtype +
            ( this.options.disabled ? " ui-state-disabled" : "" ) + "' ></div>" );
    },

    _handleInputFocus: function() {
        this.label.addClass( $.mobile.focusClass );
    },

    _handleInputBlur: function() {
        this.label.removeClass( $.mobile.focusClass );
    },

    _handleInputVClick: function() {
        // Adds checked attribute to checked input when keyboard is used
        this.element.prop( "checked", this.element.is( ":checked" ) );
        this._getInputSet().not( this.element ).prop( "checked", false );
        this._updateAll( true );
    },

    _handleLabelVMouseOver: function( event ) {
        if ( this.label.parent().hasClass( "ui-state-disabled" ) ) {
            event.stopPropagation();
        }
    },

    _handleLabelVClick: function( event ) {
        var input = this.element;

        if ( input.is( ":disabled" ) ) {
            event.preventDefault();
            return;
        }

        this._cacheVals();

        input.prop( "checked", this.inputtype === "radio" && true || !input.prop( "checked" ) );

        // trigger click handler's bound directly to the input as a substitute for
        // how label clicks behave normally in the browsers
        // TODO: it would be nice to let the browser's handle the clicks and pass them
        //       through to the associate input. we can swallow that click at the parent
        //       wrapper element level
        input.triggerHandler( "click" );

        // Input set for common radio buttons will contain all the radio
        // buttons, but will not for checkboxes. clearing the checked status
        // of other radios ensures the active button state is applied properly
        this._getInputSet().not( input ).prop( "checked", false );

        this._updateAll();
        return false;
    },

    _cacheVals: function() {
        this._getInputSet().each( function() {
            $( this ).attr("data-" + $.mobile.ns + "cacheVal", this.checked );
        });
    },

    // Returns those radio buttons that are supposed to be in the same group as
    // this radio button. In the case of a checkbox or a radio lacking a name
    // attribute, it returns this.element.
    _getInputSet: function() {
        var selector, formId,
            radio = this.element[ 0 ],
            name = radio.name,
            form = radio.form,
            doc = this.element.parents().last().get( 0 ),

            // A radio is always a member of its own group
            radios = this.element;

        // Only start running selectors if this is an attached radio button with a name
        if ( name && this.inputtype === "radio" && doc ) {
            selector = "input[type='radio'][name='" + escapeId( name ) + "']";

            // If we're inside a form
            if ( form ) {
                formId = form.getAttribute( "id" );

                // If the form has an ID, collect radios scattered throught the document which
                // nevertheless are part of the form by way of the value of their form attribute
                if ( formId ) {
                    radios = $( selector + "[form='" + escapeId( formId ) + "']", doc );
                }

                // Also add to those the radios in the form itself
                radios = $( form ).find( selector ).filter( function() {

                    // Some radios inside the form may belong to some other form by virtue of
                    // having a form attribute defined on them, so we must filter them out here
                    return ( this.form === form );
                }).add( radios );

            // If we're outside a form
            } else {

                // Collect all those radios which are also outside of a form and match our name
                radios = $( selector, doc ).filter( function() {
                    return !this.form;
                });
            }
        }
        return radios;
    },

    _updateAll: function( changeTriggered ) {
        var self = this;

        this._getInputSet().each( function() {
            var $this = $( this );

            if ( ( this.checked || self.inputtype === "checkbox" ) && !changeTriggered ) {
                $this.trigger( "change" );
            }
        })
        .checkboxradio( "refresh" );
    },

    _reset: function() {
        this.refresh();
    },

    // Is the widget supposed to display an icon?
    _hasIcon: function() {
        var controlgroup, controlgroupWidget,
            controlgroupConstructor = $.mobile.controlgroup;

        // If the controlgroup widget is defined ...
        if ( controlgroupConstructor ) {
            controlgroup = this.element.closest(
                ":mobile-controlgroup," +
                controlgroupConstructor.prototype.initSelector );

            // ... and the checkbox is in a controlgroup ...
            if ( controlgroup.length > 0 ) {

                // ... look for a controlgroup widget instance, and ...
                controlgroupWidget = $.data( controlgroup[ 0 ], "mobile-controlgroup" );

                // ... if found, decide based on the option value, ...
                return ( ( controlgroupWidget ? controlgroupWidget.options.type :

                    // ... otherwise decide based on the "type" data attribute.
                    controlgroup.attr( "data-" + $.mobile.ns + "type" ) ) !== "horizontal" );
            }
        }

        // Normally, the widget displays an icon.
        return true;
    },

    refresh: function() {
        var isChecked = this.element[ 0 ].checked,
            active = $.mobile.activeBtnClass,
            iconposClass = "ui-btn-icon-" + this.options.iconpos,
            addClasses = [],
            removeClasses = [];

        if ( this._hasIcon() ) {
            removeClasses.push( active );
            addClasses.push( iconposClass );
        } else {
            removeClasses.push( iconposClass );
            ( isChecked ? addClasses : removeClasses ).push( active );
        }

        if ( isChecked ) {
            addClasses.push( this.checkedClass );
            removeClasses.push( this.uncheckedClass );
        } else {
            addClasses.push( this.uncheckedClass );
            removeClasses.push( this.checkedClass );
        }

        this.widget().toggleClass( "ui-state-disabled", this.element.prop( "disabled" ) );

        this.label
            .addClass( addClasses.join( " " ) )
            .removeClass( removeClasses.join( " " ) );
    },

    widget: function() {
        return this.label.parent();
    },

    _setOptions: function( options ) {
        var label = this.label,
            currentOptions = this.options,
            outer = this.widget(),
            hasIcon = this._hasIcon();

        if ( options.disabled !== undefined ) {
            this.input.prop( "disabled", !!options.disabled );
            outer.toggleClass( "ui-state-disabled", !!options.disabled );
        }
        if ( options.mini !== undefined ) {
            outer.toggleClass( "ui-mini", !!options.mini );
        }
        if ( options.theme !== undefined ) {
            label
                .removeClass( "ui-btn-" + currentOptions.theme )
                .addClass( "ui-btn-" + options.theme );
        }
        if ( options.wrapperClass !== undefined ) {
            outer
                .removeClass( currentOptions.wrapperClass )
                .addClass( options.wrapperClass );
        }
        if ( options.iconpos !== undefined && hasIcon ) {
            label.removeClass( "ui-btn-icon-" + currentOptions.iconpos ).addClass( "ui-btn-icon-" + options.iconpos );
        } else if ( !hasIcon ) {
            label.removeClass( "ui-btn-icon-" + currentOptions.iconpos );
        }
        this._super( options );
    }

}, $.mobile.behaviors.formReset ) );

})( jQuery );

(function( $, undefined ) {

$.widget( "mobile.button", {

    initSelector: "input[type='button'], input[type='submit'], input[type='reset']",

    options: {
        theme: null,
        icon: null,
        iconpos: "left",
        iconshadow: false, /* TODO: Deprecated in 1.4, remove in 1.5. */
        corners: true,
        shadow: true,
        inline: null,
        mini: null,
        wrapperClass: null,
        enhanced: false
    },

    _create: function() {

        if ( this.element.is( ":disabled" ) ) {
            this.options.disabled = true;
        }

        if ( !this.options.enhanced ) {
            this._enhance();
        }

        $.extend( this, {
            wrapper: this.element.parent()
        });

        this._on( {
            focus: function() {
                this.widget().addClass( $.mobile.focusClass );
            },

            blur: function() {
                this.widget().removeClass( $.mobile.focusClass );
            }
        });

        this.refresh( true );
    },

    _enhance: function() {
        this.element.wrap( this._button() );
    },

    _button: function() {
        var options = this.options,
            iconClasses = this._getIconClasses( this.options );

        return $("<div class='ui-btn ui-input-btn" +
            ( options.wrapperClass ? " " + options.wrapperClass : "" ) +
            ( options.theme ? " ui-btn-" + options.theme : "" ) +
            ( options.corners ? " ui-corner-all" : "" ) +
            ( options.shadow ? " ui-shadow" : "" ) +
            ( options.inline ? " ui-btn-inline" : "" ) +
            ( options.mini ? " ui-mini" : "" ) +
            ( options.disabled ? " ui-state-disabled" : "" ) +
            ( iconClasses ? ( " " + iconClasses ) : "" ) +
            "' >" + this.element.val() + "</div>" );
    },

    widget: function() {
        return this.wrapper;
    },

    _destroy: function() {
            this.element.insertBefore( this.wrapper );
            this.wrapper.remove();
    },

    _getIconClasses: function( options ) {
        return ( options.icon ? ( "ui-icon-" + options.icon +
            ( options.iconshadow ? " ui-shadow-icon" : "" ) + /* TODO: Deprecated in 1.4, remove in 1.5. */
            " ui-btn-icon-" + options.iconpos ) : "" );
    },

    _setOptions: function( options ) {
        var outer = this.widget();

        if ( options.theme !== undefined ) {
            outer
                .removeClass( this.options.theme )
                .addClass( "ui-btn-" + options.theme );
        }
        if ( options.corners !== undefined ) {
            outer.toggleClass( "ui-corner-all", options.corners );
        }
        if ( options.shadow !== undefined ) {
            outer.toggleClass( "ui-shadow", options.shadow );
        }
        if ( options.inline !== undefined ) {
            outer.toggleClass( "ui-btn-inline", options.inline );
        }
        if ( options.mini !== undefined ) {
            outer.toggleClass( "ui-mini", options.mini );
        }
        if ( options.disabled !== undefined ) {
            this.element.prop( "disabled", options.disabled );
            outer.toggleClass( "ui-state-disabled", options.disabled );
        }

        if ( options.icon !== undefined ||
                options.iconshadow !== undefined || /* TODO: Deprecated in 1.4, remove in 1.5. */
                options.iconpos !== undefined ) {
            outer
                .removeClass( this._getIconClasses( this.options ) )
                .addClass( this._getIconClasses(
                    $.extend( {}, this.options, options ) ) );
        }

        this._super( options );
    },

    refresh: function( create ) {
        var originalElement,
            isDisabled = this.element.prop( "disabled" );

        if ( this.options.icon && this.options.iconpos === "notext" && this.element.attr( "title" ) ) {
            this.element.attr( "title", this.element.val() );
        }
        if ( !create ) {
            originalElement = this.element.detach();
            $( this.wrapper ).text( this.element.val() ).append( originalElement );
        }
        if ( this.options.disabled !== isDisabled ) {
            this._setOptions({ disabled: isDisabled });
        }
    }
});

})( jQuery );

(function( $ ) {
    var    meta = $( "meta[name=viewport]" ),
        initialContent = meta.attr( "content" ),
        disabledZoom = initialContent + ",maximum-scale=1, user-scalable=no",
        enabledZoom = initialContent + ",maximum-scale=10, user-scalable=yes",
        disabledInitially = /(user-scalable[\s]*=[\s]*no)|(maximum-scale[\s]*=[\s]*1)[$,\s]/.test( initialContent );

    $.mobile.zoom = $.extend( {}, {
        enabled: !disabledInitially,
        locked: false,
        disable: function( lock ) {
            if ( !disabledInitially && !$.mobile.zoom.locked ) {
                meta.attr( "content", disabledZoom );
                $.mobile.zoom.enabled = false;
                $.mobile.zoom.locked = lock || false;
            }
        },
        enable: function( unlock ) {
            if ( !disabledInitially && ( !$.mobile.zoom.locked || unlock === true ) ) {
                meta.attr( "content", enabledZoom );
                $.mobile.zoom.enabled = true;
                $.mobile.zoom.locked = false;
            }
        },
        restore: function() {
            if ( !disabledInitially ) {
                meta.attr( "content", initialContent );
                $.mobile.zoom.enabled = true;
            }
        }
    });

}( jQuery ));

(function( $, undefined ) {

$.widget( "mobile.textinput", {
    initSelector: "input[type='text']," +
        "input[type='search']," +
        ":jqmData(type='search')," +
        "input[type='number']," +
        ":jqmData(type='number')," +
        "input[type='password']," +
        "input[type='email']," +
        "input[type='url']," +
        "input[type='tel']," +
        "textarea," +
        "input[type='time']," +
        "input[type='date']," +
        "input[type='month']," +
        "input[type='week']," +
        "input[type='datetime']," +
        "input[type='datetime-local']," +
        "input[type='color']," +
        "input:not([type])," +
        "input[type='file']",

    options: {
        theme: null,
        corners: true,
        mini: false,
        // This option defaults to true on iOS devices.
        preventFocusZoom: /iPhone|iPad|iPod/.test( navigator.platform ) && navigator.userAgent.indexOf( "AppleWebKit" ) > -1,
        wrapperClass: "",
        enhanced: false
    },

    _create: function() {

        var options = this.options,
            isSearch = this.element.is( "[type='search'], :jqmData(type='search')" ),
            isTextarea = this.element[ 0 ].tagName === "TEXTAREA",
            isRange = this.element.is( "[data-" + ( $.mobile.ns || "" ) + "type='range']" ),
            inputNeedsWrap = ( (this.element.is( "input" ) ||
                this.element.is( "[data-" + ( $.mobile.ns || "" ) + "type='search']" ) ) &&
                    !isRange );

        if ( this.element.prop( "disabled" ) ) {
            options.disabled = true;
        }

        $.extend( this, {
            classes: this._classesFromOptions(),
            isSearch: isSearch,
            isTextarea: isTextarea,
            isRange: isRange,
            inputNeedsWrap: inputNeedsWrap
        });

        this._autoCorrect();

        if ( !options.enhanced ) {
            this._enhance();
        }

        this._on( {
            "focus": "_handleFocus",
            "blur": "_handleBlur"
        });

    },

    refresh: function() {
        this.setOptions({
            "disabled" : this.element.is( ":disabled" )
        });
    },

    _enhance: function() {
        var elementClasses = [];

        if ( this.isTextarea ) {
            elementClasses.push( "ui-input-text" );
        }

        if ( this.isTextarea || this.isRange ) {
            elementClasses.push( "ui-shadow-inset" );
        }

        //"search" and "text" input widgets
        if ( this.inputNeedsWrap ) {
            this.element.wrap( this._wrap() );
        } else {
            elementClasses = elementClasses.concat( this.classes );
        }

        this.element.addClass( elementClasses.join( " " ) );
    },

    widget: function() {
        return ( this.inputNeedsWrap ) ? this.element.parent() : this.element;
    },

    _classesFromOptions: function() {
        var options = this.options,
            classes = [];

        classes.push( "ui-body-" + ( ( options.theme === null ) ? "inherit" : options.theme ) );
        if ( options.corners ) {
            classes.push( "ui-corner-all" );
        }
        if ( options.mini ) {
            classes.push( "ui-mini" );
        }
        if ( options.disabled ) {
            classes.push( "ui-state-disabled" );
        }
        if ( options.wrapperClass ) {
            classes.push( options.wrapperClass );
        }

        return classes;
    },

    _wrap: function() {
        return $( "<div class='" +
            ( this.isSearch ? "ui-input-search " : "ui-input-text " ) +
            this.classes.join( " " ) + " " +
            "ui-shadow-inset'></div>" );
    },

    _autoCorrect: function() {
        // XXX: Temporary workaround for issue 785 (Apple bug 8910589).
        //      Turn off autocorrect and autocomplete on non-iOS 5 devices
        //      since the popup they use can't be dismissed by the user. Note
        //      that we test for the presence of the feature by looking for
        //      the autocorrect property on the input element. We currently
        //      have no test for iOS 5 or newer so we're temporarily using
        //      the touchOverflow support flag for jQM 1.0. Yes, I feel dirty.
        //      - jblas
        if ( typeof this.element[0].autocorrect !== "undefined" &&
            !$.support.touchOverflow ) {

            // Set the attribute instead of the property just in case there
            // is code that attempts to make modifications via HTML.
            this.element[0].setAttribute( "autocorrect", "off" );
            this.element[0].setAttribute( "autocomplete", "off" );
        }
    },

    _handleBlur: function() {
        this.widget().removeClass( $.mobile.focusClass );
        if ( this.options.preventFocusZoom ) {
            $.mobile.zoom.enable( true );
        }
    },

    _handleFocus: function() {
        // In many situations, iOS will zoom into the input upon tap, this
        // prevents that from happening
        if ( this.options.preventFocusZoom ) {
            $.mobile.zoom.disable( true );
        }
        this.widget().addClass( $.mobile.focusClass );
    },

    _setOptions: function ( options ) {
        var outer = this.widget();

        this._super( options );

        if ( !( options.disabled === undefined &&
            options.mini === undefined &&
            options.corners === undefined &&
            options.theme === undefined &&
            options.wrapperClass === undefined ) ) {

            outer.removeClass( this.classes.join( " " ) );
            this.classes = this._classesFromOptions();
            outer.addClass( this.classes.join( " " ) );
        }

        if ( options.disabled !== undefined ) {
            this.element.prop( "disabled", !!options.disabled );
        }
    },

    _destroy: function() {
        if ( this.options.enhanced ) {
            return;
        }
        if ( this.inputNeedsWrap ) {
            this.element.unwrap();
        }
        this.element.removeClass( "ui-input-text " + this.classes.join( " " ) );
    }
});

})( jQuery );

(function( $, undefined ) {

$.widget( "mobile.slider", $.extend( {
    initSelector: "input[type='range'], :jqmData(type='range'), :jqmData(role='slider')",

    widgetEventPrefix: "slide",

    options: {
        theme: null,
        trackTheme: null,
        corners: true,
        mini: false,
        highlight: false
    },

    _create: function() {

        // TODO: Each of these should have comments explain what they're for
        var self = this,
            control = this.element,
            trackTheme = this.options.trackTheme || $.mobile.getAttribute( control[ 0 ], "theme" ),
            trackThemeClass = trackTheme ? " ui-bar-" + trackTheme : " ui-bar-inherit",
            cornerClass = ( this.options.corners || control.jqmData( "corners" ) ) ? " ui-corner-all" : "",
            miniClass = ( this.options.mini || control.jqmData( "mini" ) ) ? " ui-mini" : "",
            cType = control[ 0 ].nodeName.toLowerCase(),
            isToggleSwitch = ( cType === "select" ),
            isRangeslider = control.parent().is( ":jqmData(role='rangeslider')" ),
            selectClass = ( isToggleSwitch ) ? "ui-slider-switch" : "",
            controlID = control.attr( "id" ),
            $label = $( "[for='" + controlID + "']" ),
            labelID = $label.attr( "id" ) || controlID + "-label",
            min = !isToggleSwitch ? parseFloat( control.attr( "min" ) ) : 0,
            max =  !isToggleSwitch ? parseFloat( control.attr( "max" ) ) : control.find( "option" ).length-1,
            step = window.parseFloat( control.attr( "step" ) || 1 ),
            domHandle = document.createElement( "a" ),
            handle = $( domHandle ),
            domSlider = document.createElement( "div" ),
            slider = $( domSlider ),
            valuebg = this.options.highlight && !isToggleSwitch ? (function() {
                var bg = document.createElement( "div" );
                bg.className = "ui-slider-bg " + $.mobile.activeBtnClass;
                return $( bg ).prependTo( slider );
            })() : false,
            options,
            wrapper,
            j, length,
            i, optionsCount, origTabIndex,
            side, activeClass, sliderImg;

        $label.attr( "id", labelID );
        this.isToggleSwitch = isToggleSwitch;

        domHandle.setAttribute( "href", "#" );
        domSlider.setAttribute( "role", "application" );
        domSlider.className = [ this.isToggleSwitch ? "ui-slider ui-slider-track ui-shadow-inset " : "ui-slider-track ui-shadow-inset ", selectClass, trackThemeClass, cornerClass, miniClass ].join( "" );
        domHandle.className = "ui-slider-handle";
        domSlider.appendChild( domHandle );

        handle.attr({
            "role": "slider",
            "aria-valuemin": min,
            "aria-valuemax": max,
            "aria-valuenow": this._value(),
            "aria-valuetext": this._value(),
            "title": this._value(),
            "aria-labelledby": labelID
        });

        $.extend( this, {
            slider: slider,
            handle: handle,
            control: control,
            type: cType,
            step: step,
            max: max,
            min: min,
            valuebg: valuebg,
            isRangeslider: isRangeslider,
            dragging: false,
            beforeStart: null,
            userModified: false,
            mouseMoved: false
        });

        if ( isToggleSwitch ) {
            // TODO: restore original tabindex (if any) in a destroy method
            origTabIndex = control.attr( "tabindex" );
            if ( origTabIndex ) {
                handle.attr( "tabindex", origTabIndex );
            }
            control.attr( "tabindex", "-1" ).focus(function() {
                $( this ).blur();
                handle.focus();
            });

            wrapper = document.createElement( "div" );
            wrapper.className = "ui-slider-inneroffset";

            for ( j = 0, length = domSlider.childNodes.length; j < length; j++ ) {
                wrapper.appendChild( domSlider.childNodes[j] );
            }

            domSlider.appendChild( wrapper );

            // slider.wrapInner( "<div class='ui-slider-inneroffset'></div>" );

            // make the handle move with a smooth transition
            handle.addClass( "ui-slider-handle-snapping" );

            options = control.find( "option" );

            for ( i = 0, optionsCount = options.length; i < optionsCount; i++ ) {
                side = !i ? "b" : "a";
                activeClass = !i ? "" : " " + $.mobile.activeBtnClass;
                sliderImg = document.createElement( "span" );

                sliderImg.className = [ "ui-slider-label ui-slider-label-", side, activeClass ].join( "" );
                sliderImg.setAttribute( "role", "img" );
                sliderImg.appendChild( document.createTextNode( options[i].innerHTML ) );
                $( sliderImg ).prependTo( slider );
            }

            self._labels = $( ".ui-slider-label", slider );

        }

        // monitor the input for updated values
        control.addClass( isToggleSwitch ? "ui-slider-switch" : "ui-slider-input" );

        this._on( control, {
            "change": "_controlChange",
            "keyup": "_controlKeyup",
            "blur": "_controlBlur",
            "vmouseup": "_controlVMouseUp"
        });

        slider.bind( "vmousedown", $.proxy( this._sliderVMouseDown, this ) )
            .bind( "vclick", false );

        // We have to instantiate a new function object for the unbind to work properly
        // since the method itself is defined in the prototype (causing it to unbind everything)
        this._on( document, { "vmousemove": "_preventDocumentDrag" });
        this._on( slider.add( document ), { "vmouseup": "_sliderVMouseUp" });

        slider.insertAfter( control );

        // wrap in a div for styling purposes
        if ( !isToggleSwitch && !isRangeslider ) {
            wrapper = this.options.mini ? "<div class='ui-slider ui-mini'>" : "<div class='ui-slider'>";

            control.add( slider ).wrapAll( wrapper );
        }

        // bind the handle event callbacks and set the context to the widget instance
        this._on( this.handle, {
            "vmousedown": "_handleVMouseDown",
            "keydown": "_handleKeydown",
            "keyup": "_handleKeyup"
        });

        this.handle.bind( "vclick", false );

        this._handleFormReset();

        this.refresh( undefined, undefined, true );
    },

    _setOptions: function( options ) {
        if ( options.theme !== undefined ) {
            this._setTheme( options.theme );
        }

        if ( options.trackTheme !== undefined ) {
            this._setTrackTheme( options.trackTheme );
        }

        if ( options.corners !== undefined ) {
            this._setCorners( options.corners );
        }

        if ( options.mini !== undefined ) {
            this._setMini( options.mini );
        }

        if ( options.highlight !== undefined ) {
            this._setHighlight( options.highlight );
        }

        if ( options.disabled !== undefined ) {
            this._setDisabled( options.disabled );
        }
        this._super( options );
    },

    _controlChange: function( event ) {
        // if the user dragged the handle, the "change" event was triggered from inside refresh(); don't call refresh() again
        if ( this._trigger( "controlchange", event ) === false ) {
            return false;
        }
        if ( !this.mouseMoved ) {
            this.refresh( this._value(), true );
        }
    },

    _controlKeyup: function(/* event */) { // necessary?
        this.refresh( this._value(), true, true );
    },

    _controlBlur: function(/* event */) {
        this.refresh( this._value(), true );
    },

    // it appears the clicking the up and down buttons in chrome on
    // range/number inputs doesn't trigger a change until the field is
    // blurred. Here we check thif the value has changed and refresh
    _controlVMouseUp: function(/* event */) {
        this._checkedRefresh();
    },

    // NOTE force focus on handle
    _handleVMouseDown: function(/* event */) {
        this.handle.focus();
    },

    _handleKeydown: function( event ) {
        var index = this._value();
        if ( this.options.disabled ) {
            return;
        }

        // In all cases prevent the default and mark the handle as active
        switch ( event.keyCode ) {
            case $.mobile.keyCode.HOME:
            case $.mobile.keyCode.END:
            case $.mobile.keyCode.PAGE_UP:
            case $.mobile.keyCode.PAGE_DOWN:
            case $.mobile.keyCode.UP:
            case $.mobile.keyCode.RIGHT:
            case $.mobile.keyCode.DOWN:
            case $.mobile.keyCode.LEFT:
                event.preventDefault();

                if ( !this._keySliding ) {
                    this._keySliding = true;
                    this.handle.addClass( "ui-state-active" ); /* TODO: We don't use this class for styling. Do we need to add it? */
                }

                break;
        }

        // move the slider according to the keypress
        switch ( event.keyCode ) {
            case $.mobile.keyCode.HOME:
                this.refresh( this.min );
                break;
            case $.mobile.keyCode.END:
                this.refresh( this.max );
                break;
            case $.mobile.keyCode.PAGE_UP:
            case $.mobile.keyCode.UP:
            case $.mobile.keyCode.RIGHT:
                this.refresh( index + this.step );
                break;
            case $.mobile.keyCode.PAGE_DOWN:
            case $.mobile.keyCode.DOWN:
            case $.mobile.keyCode.LEFT:
                this.refresh( index - this.step );
                break;
        }
    }, // remove active mark

    _handleKeyup: function(/* event */) {
        if ( this._keySliding ) {
            this._keySliding = false;
            this.handle.removeClass( "ui-state-active" ); /* See comment above. */
        }
    },

    _sliderVMouseDown: function( event ) {
        // NOTE: we don't do this in refresh because we still want to
        //       support programmatic alteration of disabled inputs
        if ( this.options.disabled || !( event.which === 1 || event.which === 0 || event.which === undefined ) ) {
            return false;
        }
        if ( this._trigger( "beforestart", event ) === false ) {
            return false;
        }
        this.dragging = true;
        this.userModified = false;
        this.mouseMoved = false;

        if ( this.isToggleSwitch ) {
            this.beforeStart = this.element[0].selectedIndex;
        }

        this.refresh( event );
        this._trigger( "start" );
        return false;
    },

    _sliderVMouseUp: function() {
        if ( this.dragging ) {
            this.dragging = false;

            if ( this.isToggleSwitch ) {
                // make the handle move with a smooth transition
                this.handle.addClass( "ui-slider-handle-snapping" );

                if ( this.mouseMoved ) {
                    // this is a drag, change the value only if user dragged enough
                    if ( this.userModified ) {
                        this.refresh( this.beforeStart === 0 ? 1 : 0 );
                    } else {
                        this.refresh( this.beforeStart );
                    }
                } else {
                    // this is just a click, change the value
                    this.refresh( this.beforeStart === 0 ? 1 : 0 );
                }
            }

            this.mouseMoved = false;
            this._trigger( "stop" );
            return false;
        }
    },

    _preventDocumentDrag: function( event ) {
            // NOTE: we don't do this in refresh because we still want to
            //       support programmatic alteration of disabled inputs
            if ( this._trigger( "drag", event ) === false) {
                return false;
            }
            if ( this.dragging && !this.options.disabled ) {

                // this.mouseMoved must be updated before refresh() because it will be used in the control "change" event
                this.mouseMoved = true;

                if ( this.isToggleSwitch ) {
                    // make the handle move in sync with the mouse
                    this.handle.removeClass( "ui-slider-handle-snapping" );
                }

                this.refresh( event );

                // only after refresh() you can calculate this.userModified
                this.userModified = this.beforeStart !== this.element[0].selectedIndex;
                return false;
            }
        },

    _checkedRefresh: function() {
        if ( this.value !== this._value() ) {
            this.refresh( this._value() );
        }
    },

    _value: function() {
        return  this.isToggleSwitch ? this.element[0].selectedIndex : parseFloat( this.element.val() ) ;
    },

    _reset: function() {
        this.refresh( undefined, false, true );
    },

    refresh: function( val, isfromControl, preventInputUpdate ) {
        // NOTE: we don't return here because we want to support programmatic
        //       alteration of the input value, which should still update the slider

        var self = this,
            parentTheme = $.mobile.getAttribute( this.element[ 0 ], "theme" ),
            theme = this.options.theme || parentTheme,
            themeClass =  theme ? " ui-btn-" + theme : "",
            trackTheme = this.options.trackTheme || parentTheme,
            trackThemeClass = trackTheme ? " ui-bar-" + trackTheme : " ui-bar-inherit",
            cornerClass = this.options.corners ? " ui-corner-all" : "",
            miniClass = this.options.mini ? " ui-mini" : "",
            left, width, data, tol,
            pxStep, percent,
            control, isInput, optionElements, min, max, step,
            newval, valModStep, alignValue, percentPerStep,
            handlePercent, aPercent, bPercent,
            valueChanged;

        self.slider[0].className = [ this.isToggleSwitch ? "ui-slider ui-slider-switch ui-slider-track ui-shadow-inset" : "ui-slider-track ui-shadow-inset", trackThemeClass, cornerClass, miniClass ].join( "" );
        if ( this.options.disabled || this.element.prop( "disabled" ) ) {
            this.disable();
        }

        // set the stored value for comparison later
        this.value = this._value();
        if ( this.options.highlight && !this.isToggleSwitch && this.slider.find( ".ui-slider-bg" ).length === 0 ) {
            this.valuebg = (function() {
                var bg = document.createElement( "div" );
                bg.className = "ui-slider-bg " + $.mobile.activeBtnClass;
                return $( bg ).prependTo( self.slider );
            })();
        }
        this.handle.addClass( "ui-btn" + themeClass + " ui-shadow" );

        control = this.element;
        isInput = !this.isToggleSwitch;
        optionElements = isInput ? [] : control.find( "option" );
        min =  isInput ? parseFloat( control.attr( "min" ) ) : 0;
        max = isInput ? parseFloat( control.attr( "max" ) ) : optionElements.length - 1;
        step = ( isInput && parseFloat( control.attr( "step" ) ) > 0 ) ? parseFloat( control.attr( "step" ) ) : 1;

        if ( typeof val === "object" ) {
            data = val;
            // a slight tolerance helped get to the ends of the slider
            tol = 8;

            left = this.slider.offset().left;
            width = this.slider.width();
            pxStep = width/((max-min)/step);
            if ( !this.dragging ||
                    data.pageX < left - tol ||
                    data.pageX > left + width + tol ) {
                return;
            }
            if ( pxStep > 1 ) {
                percent = ( ( data.pageX - left ) / width ) * 100;
            } else {
                percent = Math.round( ( ( data.pageX - left ) / width ) * 100 );
            }
        } else {
            if ( val == null ) {
                val = isInput ? parseFloat( control.val() || 0 ) : control[0].selectedIndex;
            }
            percent = ( parseFloat( val ) - min ) / ( max - min ) * 100;
        }

        if ( isNaN( percent ) ) {
            return;
        }

        newval = ( percent / 100 ) * ( max - min ) + min;

        //from jQuery UI slider, the following source will round to the nearest step
        valModStep = ( newval - min ) % step;
        alignValue = newval - valModStep;

        if ( Math.abs( valModStep ) * 2 >= step ) {
            alignValue += ( valModStep > 0 ) ? step : ( -step );
        }

        percentPerStep = 100/((max-min)/step);
        // Since JavaScript has problems with large floats, round
        // the final value to 5 digits after the decimal point (see jQueryUI: #4124)
        newval = parseFloat( alignValue.toFixed(5) );

        if ( typeof pxStep === "undefined" ) {
            pxStep = width / ( (max-min) / step );
        }
        if ( pxStep > 1 && isInput ) {
            percent = ( newval - min ) * percentPerStep * ( 1 / step );
        }
        if ( percent < 0 ) {
            percent = 0;
        }

        if ( percent > 100 ) {
            percent = 100;
        }

        if ( newval < min ) {
            newval = min;
        }

        if ( newval > max ) {
            newval = max;
        }

        this.handle.css( "left", percent + "%" );

        this.handle[0].setAttribute( "aria-valuenow", isInput ? newval : optionElements.eq( newval ).attr( "value" ) );

        this.handle[0].setAttribute( "aria-valuetext", isInput ? newval : optionElements.eq( newval ).getEncodedText() );

        this.handle[0].setAttribute( "title", isInput ? newval : optionElements.eq( newval ).getEncodedText() );

        if ( this.valuebg ) {
            this.valuebg.css( "width", percent + "%" );
        }

        // drag the label widths
        if ( this._labels ) {
            handlePercent = this.handle.width() / this.slider.width() * 100;
            aPercent = percent && handlePercent + ( 100 - handlePercent ) * percent / 100;
            bPercent = percent === 100 ? 0 : Math.min( handlePercent + 100 - aPercent, 100 );

            this._labels.each(function() {
                var ab = $( this ).hasClass( "ui-slider-label-a" );
                $( this ).width( ( ab ? aPercent : bPercent  ) + "%" );
            });
        }

        if ( !preventInputUpdate ) {
            valueChanged = false;

            // update control"s value
            if ( isInput ) {
                valueChanged = parseFloat( control.val() ) !== newval;
                control.val( newval );
            } else {
                valueChanged = control[ 0 ].selectedIndex !== newval;
                control[ 0 ].selectedIndex = newval;
            }
            if ( this._trigger( "beforechange", val ) === false) {
                    return false;
            }
            if ( !isfromControl && valueChanged ) {
                control.trigger( "change" );
            }
        }
    },

    _setHighlight: function( value ) {
        value = !!value;
        if ( value ) {
            this.options.highlight = !!value;
            this.refresh();
        } else if ( this.valuebg ) {
            this.valuebg.remove();
            this.valuebg = false;
        }
    },

    _setTheme: function( value ) {
        this.handle
            .removeClass( "ui-btn-" + this.options.theme )
            .addClass( "ui-btn-" + value );

        var currentTheme = this.options.theme ? this.options.theme : "inherit",
            newTheme = value ? value : "inherit";

        this.control
            .removeClass( "ui-body-" + currentTheme )
            .addClass( "ui-body-" + newTheme );
    },

    _setTrackTheme: function( value ) {
        var currentTrackTheme = this.options.trackTheme ? this.options.trackTheme : "inherit",
            newTrackTheme = value ? value : "inherit";

        this.slider
            .removeClass( "ui-body-" + currentTrackTheme )
            .addClass( "ui-body-" + newTrackTheme );
    },

    _setMini: function( value ) {
        value = !!value;
        if ( !this.isToggleSwitch && !this.isRangeslider ) {
            this.slider.parent().toggleClass( "ui-mini", value );
            this.element.toggleClass( "ui-mini", value );
        }
        this.slider.toggleClass( "ui-mini", value );
    },

    _setCorners: function( value ) {
        this.slider.toggleClass( "ui-corner-all", value );

        if ( !this.isToggleSwitch ) {
            this.control.toggleClass( "ui-corner-all", value );
        }
    },

    _setDisabled: function( value ) {
        value = !!value;
        this.element.prop( "disabled", value );
        this.slider
            .toggleClass( "ui-state-disabled", value )
            .attr( "aria-disabled", value );

        this.element.toggleClass( "ui-state-disabled", value );
    }

}, $.mobile.behaviors.formReset ) );

})( jQuery );

(function( $, undefined ) {

var popup;

function getPopup() {
    if ( !popup ) {
        popup = $( "<div></div>", {
            "class": "ui-slider-popup ui-shadow ui-corner-all"
        });
    }
    return popup.clone();
}

$.widget( "mobile.slider", $.mobile.slider, {
    options: {
        popupEnabled: false,
        showValue: false
    },

    _create: function() {
        this._super();

        $.extend( this, {
            _currentValue: null,
            _popup: null,
            _popupVisible: false
        });

        this._setOption( "popupEnabled", this.options.popupEnabled );

        this._on( this.handle, { "vmousedown" : "_showPopup" } );
        this._on( this.slider.add( this.document ), { "vmouseup" : "_hidePopup" } );
        this._refresh();
    },

    // position the popup centered 5px above the handle
    _positionPopup: function() {
        var dstOffset = this.handle.offset();

        this._popup.offset( {
            left: dstOffset.left + ( this.handle.width() - this._popup.width() ) / 2,
            top: dstOffset.top - this._popup.outerHeight() - 5
        });
    },

    _setOption: function( key, value ) {
        this._super( key, value );

        if ( key === "showValue" ) {
            this.handle.html( value && !this.options.mini ? this._value() : "" );
        } else if ( key === "popupEnabled" ) {
            if ( value && !this._popup ) {
                this._popup = getPopup()
                    .addClass( "ui-body-" + ( this.options.theme || "a" ) )
                    .hide()
                    .insertBefore( this.element );
            }
        }
    },

    // show value on the handle and in popup
    refresh: function() {
        this._super.apply( this, arguments );
        this._refresh();
    },

    _refresh: function() {
        var o = this.options, newValue;

        if ( o.popupEnabled ) {
            // remove the title attribute from the handle (which is
            // responsible for the annoying tooltip); NB we have
            // to do it here as the jqm slider sets it every time
            // the slider's value changes :(
            this.handle.removeAttr( "title" );
        }

        newValue = this._value();
        if ( newValue === this._currentValue ) {
            return;
        }
        this._currentValue = newValue;

        if ( o.popupEnabled && this._popup ) {
            this._positionPopup();
            this._popup.html( newValue );
        }

        if ( o.showValue && !this.options.mini ) {
            this.handle.html( newValue );
        }
    },

    _showPopup: function() {
        if ( this.options.popupEnabled && !this._popupVisible ) {
            this.handle.html( "" );
            this._popup.show();
            this._positionPopup();
            this._popupVisible = true;
        }
    },

    _hidePopup: function() {
        var o = this.options;

        if ( o.popupEnabled && this._popupVisible ) {
            if ( o.showValue && !o.mini ) {
                this.handle.html( this._value() );
            }
            this._popup.hide();
            this._popupVisible = false;
        }
    }
});

})( jQuery );

(function( $, undefined ) {

$.widget( "mobile.flipswitch", $.extend({

    options: {
        onText: "On",
        offText: "Off",
        theme: null,
        enhanced: false,
        wrapperClass: null,
        corners: true,
        mini: false
    },

    _create: function() {
            if ( !this.options.enhanced ) {
                this._enhance();
            } else {
                $.extend( this, {
                    flipswitch: this.element.parent(),
                    on: this.element.find( ".ui-flipswitch-on" ).eq( 0 ),
                    off: this.element.find( ".ui-flipswitch-off" ).eq(0),
                    type: this.element.get( 0 ).tagName
                });
            }

            this._handleFormReset();

            // Transfer tabindex to "on" element and make input unfocusable
            this._originalTabIndex = this.element.attr( "tabindex" );
            if ( this._originalTabIndex != null ) {
                this.on.attr( "tabindex", this._originalTabIndex );
            }
            this.element.attr( "tabindex", "-1" );
            this._on({
                "focus" : "_handleInputFocus"
            });

            if ( this.element.is( ":disabled" ) ) {
                this._setOptions({
                    "disabled": true
                });
            }

            this._on( this.flipswitch, {
                "click": "_toggle",
                "swipeleft": "_left",
                "swiperight": "_right"
            });

            this._on( this.on, {
                "keydown": "_keydown"
            });

            this._on( {
                "change": "refresh"
            });
    },

    _handleInputFocus: function() {
        this.on.focus();
    },

    widget: function() {
        return this.flipswitch;
    },

    _left: function() {
        this.flipswitch.removeClass( "ui-flipswitch-active" );
        if ( this.type === "SELECT" ) {
            this.element.get( 0 ).selectedIndex = 0;
        } else {
            this.element.prop( "checked", false );
        }
        this.element.trigger( "change" );
    },

    _right: function() {
        this.flipswitch.addClass( "ui-flipswitch-active" );
        if ( this.type === "SELECT" ) {
            this.element.get( 0 ).selectedIndex = 1;
        } else {
            this.element.prop( "checked", true );
        }
        this.element.trigger( "change" );
    },

    _enhance: function() {
        var flipswitch = $( "<div>" ),
            options = this.options,
            element = this.element,
            theme = options.theme ? options.theme : "inherit",

            // The "on" button is an anchor so it's focusable
            on = $( "<a></a>", {
                "href": "#"
            }),
            off = $( "<span></span>" ),
            type = element.get( 0 ).tagName,
            onText = ( type === "INPUT" ) ?
                options.onText : element.find( "option" ).eq( 1 ).text(),
            offText = ( type === "INPUT" ) ?
                options.offText : element.find( "option" ).eq( 0 ).text();

            on
                .addClass( "ui-flipswitch-on ui-btn ui-shadow ui-btn-inherit" )
                .text( onText );
            off
                .addClass( "ui-flipswitch-off" )
                .text( offText );

            flipswitch
                .addClass( "ui-flipswitch ui-shadow-inset " +
                    "ui-bar-" + theme + " " +
                    ( options.wrapperClass ? options.wrapperClass : "" ) + " " +
                    ( ( element.is( ":checked" ) ||
                        element
                            .find( "option" )
                            .eq( 1 )
                            .is( ":selected" ) ) ? "ui-flipswitch-active" : "" ) +
                    ( element.is(":disabled") ? " ui-state-disabled": "") +
                    ( options.corners ? " ui-corner-all": "" ) +
                    ( options.mini ? " ui-mini": "" ) )
                .append( on, off );

            element
                .addClass( "ui-flipswitch-input" )
                .after( flipswitch )
                .appendTo( flipswitch );

        $.extend( this, {
            flipswitch: flipswitch,
            on: on,
            off: off,
            type: type
        });
    },

    _reset: function() {
        this.refresh();
    },

    refresh: function() {
        var direction,
            existingDirection = this.flipswitch.hasClass( "ui-flipswitch-active" ) ? "_right" : "_left";

        if ( this.type === "SELECT" ) {
            direction = ( this.element.get( 0 ).selectedIndex > 0 ) ? "_right": "_left";
        } else {
            direction = this.element.prop( "checked" ) ? "_right": "_left";
        }

        if ( direction !== existingDirection ) {
            this[ direction ]();
        }
    },

    _toggle: function() {
        var direction = this.flipswitch.hasClass( "ui-flipswitch-active" ) ? "_left" : "_right";

        this[ direction ]();
    },

    _keydown: function( e ) {
        if ( e.which === $.mobile.keyCode.LEFT ) {
            this._left();
        } else if ( e.which === $.mobile.keyCode.RIGHT ) {
            this._right();
        } else if ( e.which === $.mobile.keyCode.SPACE ) {
            this._toggle();
            e.preventDefault();
        }
    },

    _setOptions: function( options ) {
        if ( options.theme !== undefined ) {
            var currentTheme = options.theme ? options.theme : "inherit",
                newTheme = options.theme ? options.theme : "inherit";

            this.widget()
                .removeClass( "ui-bar-" + currentTheme )
                .addClass( "ui-bar-" + newTheme );
        }
        if ( options.onText !== undefined ) {
            this.on.text( options.onText );
        }
        if ( options.offText !== undefined ) {
            this.off.text( options.offText );
        }
        if ( options.disabled !== undefined ) {
            this.widget().toggleClass( "ui-state-disabled", options.disabled );
        }
        if ( options.mini !== undefined ) {
            this.widget().toggleClass( "ui-mini", options.mini );
        }
        if ( options.corners !== undefined ) {
            this.widget().toggleClass( "ui-corner-all", options.corners );
        }

        this._super( options );
    },

    _destroy: function() {
        if ( this.options.enhanced ) {
            return;
        }
        if ( this._originalTabIndex != null ) {
            this.element.attr( "tabindex", this._originalTabIndex );
        } else {
            this.element.removeAttr( "tabindex" );
        }
        this.on.remove();
        this.off.remove();
        this.element.unwrap();
        this.flipswitch.remove();
        this.removeClass( "ui-flipswitch-input" );
    }

}, $.mobile.behaviors.formReset ) );

})( jQuery );

(function( $, undefined ) {
    $.widget( "mobile.rangeslider", $.extend( {

        options: {
            theme: null,
            trackTheme: null,
            corners: true,
            mini: false,
            highlight: true
        },

        _create: function() {
            var $el = this.element,
            elClass = this.options.mini ? "ui-rangeslider ui-mini" : "ui-rangeslider",
            _inputFirst = $el.find( "input" ).first(),
            _inputLast = $el.find( "input" ).last(),
            _label = $el.find( "label" ).first(),
            _sliderWidgetFirst = $.data( _inputFirst.get( 0 ), "mobile-slider" ) ||
                $.data( _inputFirst.slider().get( 0 ), "mobile-slider" ),
            _sliderWidgetLast = $.data( _inputLast.get(0), "mobile-slider" ) ||
                $.data( _inputLast.slider().get( 0 ), "mobile-slider" ),
            _sliderFirst = _sliderWidgetFirst.slider,
            _sliderLast = _sliderWidgetLast.slider,
            firstHandle = _sliderWidgetFirst.handle,
            _sliders = $( "<div class='ui-rangeslider-sliders' />" ).appendTo( $el );

            _inputFirst.addClass( "ui-rangeslider-first" );
            _inputLast.addClass( "ui-rangeslider-last" );
            $el.addClass( elClass );

            _sliderFirst.appendTo( _sliders );
            _sliderLast.appendTo( _sliders );
            _label.insertBefore( $el );
            firstHandle.prependTo( _sliderLast );

            $.extend( this, {
                _inputFirst: _inputFirst,
                _inputLast: _inputLast,
                _sliderFirst: _sliderFirst,
                _sliderLast: _sliderLast,
                _label: _label,
                _targetVal: null,
                _sliderTarget: false,
                _sliders: _sliders,
                _proxy: false
            });

            this.refresh();
            this._on( this.element.find( "input.ui-slider-input" ), {
                "slidebeforestart": "_slidebeforestart",
                "slidestop": "_slidestop",
                "slidedrag": "_slidedrag",
                "slidebeforechange": "_change",
                "blur": "_change",
                "keyup": "_change"
            });
            this._on({
                "mousedown":"_change"
            });
            this._on( this.element.closest( "form" ), {
                "reset":"_handleReset"
            });
            this._on( firstHandle, {
                "vmousedown": "_dragFirstHandle"
            });
        },
        _handleReset: function() {
            var self = this;
            //we must wait for the stack to unwind before updateing other wise sliders will not have updated yet
            setTimeout( function() {
                self._updateHighlight();
            },0);
        },

        _dragFirstHandle: function( event ) {
            //if the first handle is dragged send the event to the first slider
            $.data( this._inputFirst.get(0), "mobile-slider" ).dragging = true;
            $.data( this._inputFirst.get(0), "mobile-slider" ).refresh( event );
            $.data( this._inputFirst.get(0), "mobile-slider" )._trigger( "start" );
            return false;
        },

        _slidedrag: function( event ) {
            var first = $( event.target ).is( this._inputFirst ),
                otherSlider = ( first ) ? this._inputLast : this._inputFirst;

            this._sliderTarget = false;
            //if the drag was initiated on an extreme and the other handle is focused send the events to
            //the closest handle
            if ( ( this._proxy === "first" && first ) || ( this._proxy === "last" && !first ) ) {
                $.data( otherSlider.get(0), "mobile-slider" ).dragging = true;
                $.data( otherSlider.get(0), "mobile-slider" ).refresh( event );
                return false;
            }
        },

        _slidestop: function( event ) {
            var first = $( event.target ).is( this._inputFirst );

            this._proxy = false;
            //this stops dragging of the handle and brings the active track to the front
            //this makes clicks on the track go the the last handle used
            this.element.find( "input" ).trigger( "vmouseup" );
            this._sliderFirst.css( "z-index", first ? 1 : "" );
        },

        _slidebeforestart: function( event ) {
            this._sliderTarget = false;
            //if the track is the target remember this and the original value
            if ( $( event.originalEvent.target ).hasClass( "ui-slider-track" ) ) {
                this._sliderTarget = true;
                this._targetVal = $( event.target ).val();
            }
        },

        _setOptions: function( options ) {
            if ( options.theme !== undefined ) {
                this._setTheme( options.theme );
            }

            if ( options.trackTheme !== undefined ) {
                this._setTrackTheme( options.trackTheme );
            }

            if ( options.mini !== undefined ) {
                this._setMini( options.mini );
            }

            if ( options.highlight !== undefined ) {
                this._setHighlight( options.highlight );
            }

            if ( options.disabled !== undefined ) {
                this._setDisabled( options.disabled );
            }

            this._super( options );
            this.refresh();
        },

        refresh: function() {
            var $el = this.element,
                o = this.options;

            if ( this._inputFirst.is( ":disabled" ) || this._inputLast.is( ":disabled" ) ) {
                this.options.disabled = true;
            }

            $el.find( "input" ).slider({
                theme: o.theme,
                trackTheme: o.trackTheme,
                disabled: o.disabled,
                corners: o.corners,
                mini: o.mini,
                highlight: o.highlight
            }).slider( "refresh" );
            this._updateHighlight();
        },

        _change: function( event ) {
            if ( event.type === "keyup" ) {
                this._updateHighlight();
                return false;
            }

            var self = this,
                min = parseFloat( this._inputFirst.val(), 10 ),
                max = parseFloat( this._inputLast.val(), 10 ),
                first = $( event.target ).hasClass( "ui-rangeslider-first" ),
                thisSlider = first ? this._inputFirst : this._inputLast,
                otherSlider = first ? this._inputLast : this._inputFirst;

            if ( ( this._inputFirst.val() > this._inputLast.val() && event.type === "mousedown" && !$(event.target).hasClass("ui-slider-handle")) ) {
                thisSlider.blur();
            } else if ( event.type === "mousedown" ) {
                return;
            }
            if ( min > max && !this._sliderTarget ) {
                //this prevents min from being greater then max
                thisSlider.val( first ? max: min ).slider( "refresh" );
                this._trigger( "normalize" );
            } else if ( min > max ) {
                //this makes it so clicks on the target on either extreme go to the closest handle
                thisSlider.val( this._targetVal ).slider( "refresh" );

                //You must wait for the stack to unwind so first slider is updated before updating second
                setTimeout( function() {
                    otherSlider.val( first ? min: max ).slider( "refresh" );
                    $.data( otherSlider.get(0), "mobile-slider" ).handle.focus();
                    self._sliderFirst.css( "z-index", first ? "" : 1 );
                    self._trigger( "normalize" );
                }, 0 );
                this._proxy = ( first ) ? "first" : "last";
            }
            //fixes issue where when both _sliders are at min they cannot be adjusted
            if ( min === max ) {
                $.data( thisSlider.get(0), "mobile-slider" ).handle.css( "z-index", 1 );
                $.data( otherSlider.get(0), "mobile-slider" ).handle.css( "z-index", 0 );
            } else {
                $.data( otherSlider.get(0), "mobile-slider" ).handle.css( "z-index", "" );
                $.data( thisSlider.get(0), "mobile-slider" ).handle.css( "z-index", "" );
            }

            this._updateHighlight();

            if ( min >= max ) {
                return false;
            }
        },

        _updateHighlight: function() {
            var min = parseInt( $.data( this._inputFirst.get(0), "mobile-slider" ).handle.get(0).style.left, 10 ),
                max = parseInt( $.data( this._inputLast.get(0), "mobile-slider" ).handle.get(0).style.left, 10 ),
                width = (max - min);

            this.element.find( ".ui-slider-bg" ).css({
                "margin-left": min + "%",
                "width": width + "%"
            });
        },

        _setTheme: function( value ) {
            this._inputFirst.slider( "option", "theme", value );
            this._inputLast.slider( "option", "theme", value );
        },

        _setTrackTheme: function( value ) {
            this._inputFirst.slider( "option", "trackTheme", value );
            this._inputLast.slider( "option", "trackTheme", value );
        },

        _setMini: function( value ) {
            this._inputFirst.slider( "option", "mini", value );
            this._inputLast.slider( "option", "mini", value );
            this.element.toggleClass( "ui-mini", !!value );
        },

        _setHighlight: function( value ) {
            this._inputFirst.slider( "option", "highlight", value );
            this._inputLast.slider( "option", "highlight", value );
        },

        _setDisabled: function( value ) {
            this._inputFirst.prop( "disabled", value );
            this._inputLast.prop( "disabled", value );
        },

        _destroy: function() {
            this._label.prependTo( this.element );
            this.element.removeClass( "ui-rangeslider ui-mini" );
            this._inputFirst.after( this._sliderFirst );
            this._inputLast.after( this._sliderLast );
            this._sliders.remove();
            this.element.find( "input" ).removeClass( "ui-rangeslider-first ui-rangeslider-last" ).slider( "destroy" );
        }

    }, $.mobile.behaviors.formReset ) );

})( jQuery );

(function( $, undefined ) {

    $.widget( "mobile.textinput", $.mobile.textinput, {
        options: {
            clearBtn: false,
            clearBtnText: "Clear text"
        },

        _create: function() {
            this._super();

            if ( this.isSearch ) {
                this.options.clearBtn = true;
            }

            if ( !!this.options.clearBtn && this.inputNeedsWrap ) {
                this._addClearBtn();
            }
        },

        clearButton: function() {
            return $( "<a href='#' tabindex='-1' aria-hidden='true' " +
                "class='ui-input-clear ui-btn ui-icon-delete ui-btn-icon-notext ui-corner-all'>" +
                "</a>" )
                    .attr( "title", this.options.clearBtnText )
                    .text( this.options.clearBtnText );
        },

        _clearBtnClick: function( event ) {
            this.element.val( "" )
                    .focus()
                    .trigger( "change" );

            this._clearBtn.addClass( "ui-input-clear-hidden" );
            event.preventDefault();
        },

        _addClearBtn: function() {

            if ( !this.options.enhanced ) {
                this._enhanceClear();
            }

            $.extend( this, {
                _clearBtn: this.widget().find("a.ui-input-clear")
            });

            this._bindClearEvents();

            this._toggleClear();

        },

        _enhanceClear: function() {

            this.clearButton().appendTo( this.widget() );
            this.widget().addClass( "ui-input-has-clear" );

        },

        _bindClearEvents: function() {

            this._on( this._clearBtn, {
                "click": "_clearBtnClick"
            });

            this._on({
                "keyup": "_toggleClear",
                "change": "_toggleClear",
                "input": "_toggleClear",
                "focus": "_toggleClear",
                "blur": "_toggleClear",
                "cut": "_toggleClear",
                "paste": "_toggleClear"

            });

        },

        _unbindClear: function() {
            this._off( this._clearBtn, "click");
            this._off( this.element, "keyup change input focus blur cut paste" );
        },

        _setOptions: function( options ) {
            this._super( options );

            if ( options.clearBtn !== undefined &&
                !this.element.is( "textarea, :jqmData(type='range')" ) ) {
                if ( options.clearBtn ) {
                    this._addClearBtn();
                } else {
                    this._destroyClear();
                }
            }

            if ( options.clearBtnText !== undefined && this._clearBtn !== undefined ) {
                this._clearBtn.text( options.clearBtnText )
                    .attr("title", options.clearBtnText);
            }
        },

        _toggleClear: function() {
            this._delay( "_toggleClearClass", 0 );
        },

        _toggleClearClass: function() {
            this._clearBtn.toggleClass( "ui-input-clear-hidden", !this.element.val() );
        },

        _destroyClear: function() {
            this.widget().removeClass( "ui-input-has-clear" );
            this._unbindClear();
            this._clearBtn.remove();
        },

        _destroy: function() {
            this._super();
            if ( this.options.clearBtn ) {
                this._destroyClear();
            }
        }

    });

})( jQuery );

(function( $, undefined ) {

    $.widget( "mobile.textinput", $.mobile.textinput, {
        options: {
            autogrow:true,
            keyupTimeoutBuffer: 100
        },

        _create: function() {
            this._super();

            if ( this.options.autogrow && this.isTextarea ) {
                this._autogrow();
            }
        },

        _autogrow: function() {
            this.element.addClass( "ui-textinput-autogrow" );

            this._on({
                "keyup": "_timeout",
                "change": "_timeout",
                "input": "_timeout",
                "paste": "_timeout"
            });

            // Attach to the various you-have-become-visible notifications that the
            // various framework elements emit.
            // TODO: Remove all but the updatelayout handler once #6426 is fixed.
            this._on( true, this.document, {

                // TODO: Move to non-deprecated event
                "pageshow": "_handleShow",
                "popupbeforeposition": "_handleShow",
                "updatelayout": "_handleShow",
                "panelopen": "_handleShow"
            });
        },

        // Synchronously fix the widget height if this widget's parents are such
        // that they show/hide content at runtime. We still need to check whether
        // the widget is actually visible in case it is contained inside multiple
        // such containers. For example: panel contains collapsible contains
        // autogrow textinput. The panel may emit "panelopen" indicating that its
        // content has become visible, but the collapsible is still collapsed, so
        // the autogrow textarea is still not visible.
        _handleShow: function( event ) {
            if ( $.contains( event.target, this.element[ 0 ] ) &&
                this.element.is( ":visible" ) ) {

                if ( event.type !== "popupbeforeposition" ) {
                    this.element
                        .addClass( "ui-textinput-autogrow-resize" )
                        .animationComplete(
                            $.proxy( function() {
                                this.element.removeClass( "ui-textinput-autogrow-resize" );
                            }, this ),
                        "transition" );
                }
                this._prepareHeightUpdate();
            }
        },

        _unbindAutogrow: function() {
            this.element.removeClass( "ui-textinput-autogrow" );
            this._off( this.element, "keyup change input paste" );
            this._off( this.document,
                "pageshow popupbeforeposition updatelayout panelopen" );
        },

        keyupTimeout: null,

        _prepareHeightUpdate: function( delay ) {
            if ( this.keyupTimeout ) {
                clearTimeout( this.keyupTimeout );
            }
            if ( delay === undefined ) {
                this._updateHeight();
            } else {
                this.keyupTimeout = this._delay( "_updateHeight", delay );
            }
        },

        _timeout: function() {
            this._prepareHeightUpdate( this.options.keyupTimeoutBuffer );
        },

        _updateHeight: function() {
            var paddingTop, paddingBottom, paddingHeight, scrollHeight, clientHeight,
                borderTop, borderBottom, borderHeight, height,
                scrollTop = this.window.scrollTop();
            this.keyupTimeout = 0;

            // IE8 textareas have the onpage property - others do not
            if ( !( "onpage" in this.element[ 0 ] ) ) {
                this.element.css({
                    "height": 0,
                    "min-height": 0,
                    "max-height": 0
                });
            }

            scrollHeight = this.element[ 0 ].scrollHeight;
            clientHeight = this.element[ 0 ].clientHeight;
            borderTop = parseFloat( this.element.css( "border-top-width" ) );
            borderBottom = parseFloat( this.element.css( "border-bottom-width" ) );
            borderHeight = borderTop + borderBottom;
            height = scrollHeight + borderHeight + 15;

            // Issue 6179: Padding is not included in scrollHeight and
            // clientHeight by Firefox if no scrollbar is visible. Because
            // textareas use the border-box box-sizing model, padding should be
            // included in the new (assigned) height. Because the height is set
            // to 0, clientHeight == 0 in Firefox. Therefore, we can use this to
            // check if padding must be added.
            if ( clientHeight === 0 ) {
                paddingTop = parseFloat( this.element.css( "padding-top" ) );
                paddingBottom = parseFloat( this.element.css( "padding-bottom" ) );
                paddingHeight = paddingTop + paddingBottom;

                height += paddingHeight;
            }

            this.element.css({
                "height": height,
                "min-height": "",
                "max-height": ""
            });

            this.window.scrollTop( scrollTop );
        },

        refresh: function() {
            if ( this.options.autogrow && this.isTextarea ) {
                this._updateHeight();
            }
        },

        _setOptions: function( options ) {

            this._super( options );

            if ( options.autogrow !== undefined && this.isTextarea ) {
                if ( options.autogrow ) {
                    this._autogrow();
                } else {
                    this._unbindAutogrow();
                }
            }
        }

    });
})( jQuery );

(function( $, undefined ) {

$.widget( "mobile.selectmenu", $.extend( {
    initSelector: "select:not( :jqmData(role='slider')):not( :jqmData(role='flipswitch') )",

    options: {
        theme: null,
        icon: "carat-d",
        iconpos: "right",
        inline: false,
        corners: true,
        shadow: true,
        iconshadow: false, /* TODO: Deprecated in 1.4, remove in 1.5. */
        overlayTheme: null,
        dividerTheme: null,
        hidePlaceholderMenuItems: true,
        closeText: "Close",
        nativeMenu: true,
        // This option defaults to true on iOS devices.
        preventFocusZoom: /iPhone|iPad|iPod/.test( navigator.platform ) && navigator.userAgent.indexOf( "AppleWebKit" ) > -1,
        mini: false
    },

    _button: function() {
        return $( "<div/>" );
    },

    _setDisabled: function( value ) {
        this.element.attr( "disabled", value );
        this.button.attr( "aria-disabled", value );
        return this._setOption( "disabled", value );
    },

    _focusButton : function() {
        var self = this;

        setTimeout( function() {
            self.button.focus();
        }, 40);
    },

    _selectOptions: function() {
        return this.select.find( "option" );
    },

    // setup items that are generally necessary for select menu extension
    _preExtension: function() {
        var inline = this.options.inline || this.element.jqmData( "inline" ),
            mini = this.options.mini || this.element.jqmData( "mini" ),
            classes = "";
        // TODO: Post 1.1--once we have time to test thoroughly--any classes manually applied to the original element should be carried over to the enhanced element, with an `-enhanced` suffix. See https://github.com/jquery/jquery-mobile/issues/3577
        /* if ( $el[0].className.length ) {
            classes = $el[0].className;
        } */
        if ( !!~this.element[0].className.indexOf( "ui-btn-left" ) ) {
            classes = " ui-btn-left";
        }

        if (  !!~this.element[0].className.indexOf( "ui-btn-right" ) ) {
            classes = " ui-btn-right";
        }

        if ( inline ) {
            classes += " ui-btn-inline";
        }
        if ( mini ) {
            classes += " ui-mini";
        }

        this.select = this.element.removeClass( "ui-btn-left ui-btn-right" ).wrap( "<div class='ui-select" + classes + "'>" );
        this.selectId  = this.select.attr( "id" ) || ( "select-" + this.uuid );
        this.buttonId = this.selectId + "-button";
        this.label = $( "label[for='"+ this.selectId +"']" );
        this.isMultiple = this.select[ 0 ].multiple;
    },

    _destroy: function() {
        var wrapper = this.element.parents( ".ui-select" );
        if ( wrapper.length > 0 ) {
            if ( wrapper.is( ".ui-btn-left, .ui-btn-right" ) ) {
                this.element.addClass( wrapper.hasClass( "ui-btn-left" ) ? "ui-btn-left" : "ui-btn-right" );
            }
            this.element.insertAfter( wrapper );
            wrapper.remove();
        }
    },

    _create: function() {
        this._preExtension();

        this.button = this._button();

        var self = this,

            options = this.options,

            iconpos = options.icon ? ( options.iconpos || this.select.jqmData( "iconpos" ) ) : false,

            button = this.button
                .insertBefore( this.select )
                .attr( "id", this.buttonId )
                .addClass( "ui-btn" +
                    ( options.icon ? ( " ui-icon-" + options.icon + " ui-btn-icon-" + iconpos +
                    ( options.iconshadow ? " ui-shadow-icon" : "" ) ) :    "" ) + /* TODO: Remove in 1.5. */
                    ( options.theme ? " ui-btn-" + options.theme : "" ) +
                    ( options.corners ? " ui-corner-all" : "" ) +
                    ( options.shadow ? " ui-shadow" : "" ) );

        this.setButtonText();

        // Opera does not properly support opacity on select elements
        // In Mini, it hides the element, but not its text
        // On the desktop,it seems to do the opposite
        // for these reasons, using the nativeMenu option results in a full native select in Opera
        if ( options.nativeMenu && window.opera && window.opera.version ) {
            button.addClass( "ui-select-nativeonly" );
        }

        // Add counter for multi selects
        if ( this.isMultiple ) {
            this.buttonCount = $( "<span>" )
                .addClass( "ui-li-count ui-body-inherit" )
                .hide()
                .appendTo( button.addClass( "ui-li-has-count" ) );
        }

        // Disable if specified
        if ( options.disabled || this.element.attr( "disabled" )) {
            this.disable();
        }

        // Events on native select
        this.select.change(function() {
            self.refresh();

            if ( !!options.nativeMenu ) {
                self._delay( function() {
                    self.select.blur();
                });
            }
        });

        this._handleFormReset();

        this._on( this.button, {
            keydown: "_handleKeydown"
        });

        this.build();
    },

    build: function() {
        var self = this;

        this.select
            .appendTo( self.button )
            .bind( "vmousedown", function() {
                // Add active class to button
                self.button.addClass( $.mobile.activeBtnClass );
            })
            .bind( "focus", function() {
                self.button.addClass( $.mobile.focusClass );
            })
            .bind( "blur", function() {
                self.button.removeClass( $.mobile.focusClass );
            })
            .bind( "focus vmouseover", function() {
                self.button.trigger( "vmouseover" );
            })
            .bind( "vmousemove", function() {
                // Remove active class on scroll/touchmove
                self.button.removeClass( $.mobile.activeBtnClass );
            })
            .bind( "change blur vmouseout", function() {
                self.button.trigger( "vmouseout" )
                    .removeClass( $.mobile.activeBtnClass );
            });

        // In many situations, iOS will zoom into the select upon tap, this prevents that from happening
        self.button.bind( "vmousedown", function() {
            if ( self.options.preventFocusZoom ) {
                    $.mobile.zoom.disable( true );
            }
        });
        self.label.bind( "click focus", function() {
            if ( self.options.preventFocusZoom ) {
                    $.mobile.zoom.disable( true );
            }
        });
        self.select.bind( "focus", function() {
            if ( self.options.preventFocusZoom ) {
                    $.mobile.zoom.disable( true );
            }
        });
        self.button.bind( "mouseup", function() {
            if ( self.options.preventFocusZoom ) {
                setTimeout(function() {
                    $.mobile.zoom.enable( true );
                }, 0 );
            }
        });
        self.select.bind( "blur", function() {
            if ( self.options.preventFocusZoom ) {
                $.mobile.zoom.enable( true );
            }
        });

    },

    selected: function() {
        return this._selectOptions().filter( ":selected" );
    },

    selectedIndices: function() {
        var self = this;

        return this.selected().map(function() {
            return self._selectOptions().index( this );
        }).get();
    },

    setButtonText: function() {
        var self = this,
            selected = this.selected(),
            text = this.placeholder,
            span = $( document.createElement( "span" ) );

        this.button.children( "span" ).not( ".ui-li-count" ).remove().end().end().prepend( (function() {
            if ( selected.length ) {
                text = selected.map(function() {
                    return $( this ).text();
                }).get().join( ", " );
            } else {
                text = self.placeholder;
            }

            if ( text ) {
                span.text( text );
            } else {

                // Set the contents to &nbsp; which we write as &#160; to be XHTML compliant - see gh-6699
                span.html( "&#160;" );
            }

            // TODO possibly aggregate multiple select option classes
            return span
                .addClass( self.select.attr( "class" ) )
                .addClass( selected.attr( "class" ) )
                .removeClass( "ui-screen-hidden" );
        })());
    },

    setButtonCount: function() {
        var selected = this.selected();

        // multiple count inside button
        if ( this.isMultiple ) {
            this.buttonCount[ selected.length > 1 ? "show" : "hide" ]().text( selected.length );
        }
    },

    _handleKeydown: function( /* event */ ) {
        this._delay( "_refreshButton" );
    },

    _reset: function() {
        this.refresh();
    },

    _refreshButton: function() {
        this.setButtonText();
        this.setButtonCount();
    },

    refresh: function() {
        this._refreshButton();
    },

    // open and close preserved in native selects
    // to simplify users code when looping over selects
    open: $.noop,
    close: $.noop,

    disable: function() {
        this._setDisabled( true );
        this.button.addClass( "ui-state-disabled" );
    },

    enable: function() {
        this._setDisabled( false );
        this.button.removeClass( "ui-state-disabled" );
    }
}, $.mobile.behaviors.formReset ) );

})( jQuery );

(function( $, undefined ) {

$.mobile.links = function( target ) {

    //links within content areas, tests included with page
    $( target )
        .find( "a" )
        .jqmEnhanceable()
        .filter( ":jqmData(rel='popup')[href][href!='']" )
        .each( function() {
            // Accessibility info for popups
            var element = this,
                idref = element.getAttribute( "href" ).substring( 1 );

            if ( idref ) {
                element.setAttribute( "aria-haspopup", true );
                element.setAttribute( "aria-owns", idref );
                element.setAttribute( "aria-expanded", false );
            }
        })
        .end()
        .not( ".ui-btn, :jqmData(role='none'), :jqmData(role='nojs')" )
        .addClass( "ui-link" );

};

})( jQuery );


(function( $, undefined ) {

function fitSegmentInsideSegment( windowSize, segmentSize, offset, desired ) {
    var returnValue = desired;

    if ( windowSize < segmentSize ) {
        // Center segment if it's bigger than the window
        returnValue = offset + ( windowSize - segmentSize ) / 2;
    } else {
        // Otherwise center it at the desired coordinate while keeping it completely inside the window
        returnValue = Math.min( Math.max( offset, desired - segmentSize / 2 ), offset + windowSize - segmentSize );
    }

    return returnValue;
}

function getWindowCoordinates( theWindow ) {
    return {
        x: theWindow.scrollLeft(),
        y: theWindow.scrollTop(),
        cx: ( theWindow[ 0 ].innerWidth || theWindow.width() ),
        cy: ( theWindow[ 0 ].innerHeight || theWindow.height() )
    };
}

$.widget( "mobile.popup", {
    options: {
        wrapperClass: null,
        theme: null,
        overlayTheme: null,
        shadow: true,
        corners: true,
        transition: "none",
        positionTo: "origin",
        tolerance: null,
        closeLinkSelector: "a:jqmData(rel='back')",
        closeLinkEvents: "click.popup",
        navigateEvents: "navigate.popup",
        closeEvents: "navigate.popup pagebeforechange.popup",
        dismissible: true,
        enhanced: false,

        // NOTE Windows Phone 7 has a scroll position caching issue that
        //      requires us to disable popup history management by default
        //      https://github.com/jquery/jquery-mobile/issues/4784
        //
        // NOTE this option is modified in _create!
        history: !$.mobile.browser.oldIE
    },

    // When the user depresses the mouse/finger on an element inside the popup while the popup is
    // open, we ignore resize events for a short while. This prevents #6961.
    _handleDocumentVmousedown: function( theEvent ) {
        if ( this._isOpen && $.contains( this._ui.container[ 0 ], theEvent.target ) ) {
            this._ignoreResizeEvents();
        }
    },

    _create: function() {
        var theElement = this.element,
            myId = theElement.attr( "id" ),
            currentOptions = this.options;

        // We need to adjust the history option to be false if there's no AJAX nav.
        // We can't do it in the option declarations because those are run before
        // it is determined whether there shall be AJAX nav.
        currentOptions.history = currentOptions.history && $.mobile.ajaxEnabled && $.mobile.hashListeningEnabled;

        this._on( this.document, {
            "vmousedown": "_handleDocumentVmousedown"
        });

        // Define instance variables
        $.extend( this, {
            _scrollTop: 0,
            _page: theElement.closest( ".ui-page" ),
            _ui: null,
            _fallbackTransition: "",
            _currentTransition: false,
            _prerequisites: null,
            _isOpen: false,
            _tolerance: null,
            _resizeData: null,
            _ignoreResizeTo: 0,
            _orientationchangeInProgress: false
        });

        if ( this._page.length === 0 ) {
            this._page = $( "body" );
        }

        if ( currentOptions.enhanced ) {
            this._ui = {
                container: theElement.parent(),
                screen: theElement.parent().prev(),
                placeholder: $( this.document[ 0 ].getElementById( myId + "-placeholder" ) )
            };
        } else {
            this._ui = this._enhance( theElement, myId );
            this._applyTransition( currentOptions.transition );
        }
        this
            ._setTolerance( currentOptions.tolerance )
            ._ui.focusElement = this._ui.container;

        // Event handlers
        this._on( this._ui.screen, { "vclick": "_eatEventAndClose" } );
        this._on( this.window, {
            orientationchange: $.proxy( this, "_handleWindowOrientationchange" ),
            resize: $.proxy( this, "_handleWindowResize" ),
            keyup: $.proxy( this, "_handleWindowKeyUp" )
        });
        this._on( this.document, { "focusin": "_handleDocumentFocusIn" } );
    },

    _enhance: function( theElement, myId ) {
        var currentOptions = this.options,
            wrapperClass = currentOptions.wrapperClass,
            ui = {
                screen: $( "<div class='ui-screen-hidden ui-popup-screen " +
                this._themeClassFromOption( "ui-overlay-", currentOptions.overlayTheme ) + "'></div>" ),
                placeholder: $( "<div style='display: none;'><!-- placeholder --></div>" ),
                container: $( "<div class='ui-popup-container ui-popup-hidden ui-popup-truncate" +
                    ( wrapperClass ? ( " " + wrapperClass ) : "" ) + "'></div>" )
            },
            fragment = this.document[ 0 ].createDocumentFragment();

        fragment.appendChild( ui.screen[ 0 ] );
        fragment.appendChild( ui.container[ 0 ] );

        if ( myId ) {
            ui.screen.attr( "id", myId + "-screen" );
            ui.container.attr( "id", myId + "-popup" );
            ui.placeholder
                .attr( "id", myId + "-placeholder" )
                .html( "<!-- placeholder for " + myId + " -->" );
        }

        // Apply the proto
        this._page[ 0 ].appendChild( fragment );
        // Leave a placeholder where the element used to be
        ui.placeholder.insertAfter( theElement );
        theElement
            .detach()
            .addClass( "ui-popup " +
                this._themeClassFromOption( "ui-body-", currentOptions.theme ) + " " +
                ( currentOptions.shadow ? "ui-overlay-shadow " : "" ) +
                ( currentOptions.corners ? "ui-corner-all " : "" ) )
            .appendTo( ui.container );

        return ui;
    },

    _eatEventAndClose: function( theEvent ) {
        theEvent.preventDefault();
        theEvent.stopImmediatePropagation();
        if ( this.options.dismissible ) {
            this.close();
        }
        return false;
    },

    // Make sure the screen covers the entire document - CSS is sometimes not
    // enough to accomplish this.
    _resizeScreen: function() {
        var screen = this._ui.screen,
            popupHeight = this._ui.container.outerHeight( true ),
            screenHeight = screen.removeAttr( "style" ).height(),

            // Subtracting 1 here is necessary for an obscure Andrdoid 4.0 bug where
            // the browser hangs if the screen covers the entire document :/
            documentHeight = this.document.height() - 1;

        if ( screenHeight < documentHeight ) {
            screen.height( documentHeight );
        } else if ( popupHeight > screenHeight ) {
            screen.height( popupHeight );
        }
    },

    _handleWindowKeyUp: function( theEvent ) {
        if ( this._isOpen && theEvent.keyCode === $.mobile.keyCode.ESCAPE ) {
            return this._eatEventAndClose( theEvent );
        }
    },

    _expectResizeEvent: function() {
        var windowCoordinates = getWindowCoordinates( this.window );

        if ( this._resizeData ) {
            if ( windowCoordinates.x === this._resizeData.windowCoordinates.x &&
                windowCoordinates.y === this._resizeData.windowCoordinates.y &&
                windowCoordinates.cx === this._resizeData.windowCoordinates.cx &&
                windowCoordinates.cy === this._resizeData.windowCoordinates.cy ) {
                // timeout not refreshed
                return false;
            } else {
                // clear existing timeout - it will be refreshed below
                clearTimeout( this._resizeData.timeoutId );
            }
        }

        this._resizeData = {
            timeoutId: this._delay( "_resizeTimeout", 200 ),
            windowCoordinates: windowCoordinates
        };

        return true;
    },

    _resizeTimeout: function() {
        if ( this._isOpen ) {
            if ( !this._expectResizeEvent() ) {
                if ( this._ui.container.hasClass( "ui-popup-hidden" ) ) {
                    // effectively rapid-open the popup while leaving the screen intact
                    this._ui.container.removeClass( "ui-popup-hidden ui-popup-truncate" );
                    this.reposition( { positionTo: "window" } );
                    this._ignoreResizeEvents();
                }

                this._resizeScreen();
                this._resizeData = null;
                this._orientationchangeInProgress = false;
            }
        } else {
            this._resizeData = null;
            this._orientationchangeInProgress = false;
        }
    },

    _stopIgnoringResizeEvents: function() {
        this._ignoreResizeTo = 0;
    },

    _ignoreResizeEvents: function() {
        if ( this._ignoreResizeTo ) {
            clearTimeout( this._ignoreResizeTo );
        }
        this._ignoreResizeTo = this._delay( "_stopIgnoringResizeEvents", 1000 );
    },

    _handleWindowResize: function(/* theEvent */) {
        if ( this._isOpen && this._ignoreResizeTo === 0 ) {
            if ( ( this._expectResizeEvent() || this._orientationchangeInProgress ) &&
                !this._ui.container.hasClass( "ui-popup-hidden" ) ) {
                // effectively rapid-close the popup while leaving the screen intact
                this._ui.container
                    .addClass( "ui-popup-hidden ui-popup-truncate" )
                    .removeAttr( "style" );
            }
        }
    },

    _handleWindowOrientationchange: function(/* theEvent */) {
        if ( !this._orientationchangeInProgress && this._isOpen && this._ignoreResizeTo === 0 ) {
            this._expectResizeEvent();
            this._orientationchangeInProgress = true;
        }
    },

    // When the popup is open, attempting to focus on an element that is not a
    // child of the popup will redirect focus to the popup
    _handleDocumentFocusIn: function( theEvent ) {
        var target,
            targetElement = theEvent.target,
            ui = this._ui;

        if ( !this._isOpen ) {
            return;
        }

        if ( targetElement !== ui.container[ 0 ] ) {
            target = $( targetElement );
            if ( !$.contains( ui.container[ 0 ], targetElement ) ) {
                $( this.document[ 0 ].activeElement ).one( "focus", $.proxy( function() {
                    this._safelyBlur( targetElement );
                }, this ) );
                ui.focusElement.focus();
                theEvent.preventDefault();
                theEvent.stopImmediatePropagation();
                return false;
            } else if ( ui.focusElement[ 0 ] === ui.container[ 0 ] ) {
                ui.focusElement = target;
            }
        }

        this._ignoreResizeEvents();
    },

    _themeClassFromOption: function( prefix, value ) {
        return ( value ? ( value === "none" ? "" : ( prefix + value ) ) : ( prefix + "inherit" ) );
    },

    _applyTransition: function( value ) {
        if ( value ) {
            this._ui.container.removeClass( this._fallbackTransition );
            if ( value !== "none" ) {
                this._fallbackTransition = $.mobile._maybeDegradeTransition( value );
                if ( this._fallbackTransition === "none" ) {
                    this._fallbackTransition = "";
                }
                this._ui.container.addClass( this._fallbackTransition );
            }
        }

        return this;
    },

    _setOptions: function( newOptions ) {
        var currentOptions = this.options,
            theElement = this.element,
            screen = this._ui.screen;

        if ( newOptions.wrapperClass !== undefined ) {
            this._ui.container
                .removeClass( currentOptions.wrapperClass )
                .addClass( newOptions.wrapperClass );
        }

        if ( newOptions.theme !== undefined ) {
            theElement
                .removeClass( this._themeClassFromOption( "ui-body-", currentOptions.theme ) )
                .addClass( this._themeClassFromOption( "ui-body-", newOptions.theme ) );
        }

        if ( newOptions.overlayTheme !== undefined ) {
            screen
                .removeClass( this._themeClassFromOption( "ui-overlay-", currentOptions.overlayTheme ) )
                .addClass( this._themeClassFromOption( "ui-overlay-", newOptions.overlayTheme ) );

            if ( this._isOpen ) {
                screen.addClass( "in" );
            }
        }

        if ( newOptions.shadow !== undefined ) {
            theElement.toggleClass( "ui-overlay-shadow", newOptions.shadow );
        }

        if ( newOptions.corners !== undefined ) {
            theElement.toggleClass( "ui-corner-all", newOptions.corners );
        }

        if ( newOptions.transition !== undefined ) {
            if ( !this._currentTransition ) {
                this._applyTransition( newOptions.transition );
            }
        }

        if ( newOptions.tolerance !== undefined ) {
            this._setTolerance( newOptions.tolerance );
        }

        if ( newOptions.disabled !== undefined ) {
            if ( newOptions.disabled ) {
                this.close();
            }
        }

        return this._super( newOptions );
    },

    _setTolerance: function( value ) {
        var tol = { t: 30, r: 15, b: 30, l: 15 },
            ar;

        if ( value !== undefined ) {
            ar = String( value ).split( "," );

            $.each( ar, function( idx, val ) { ar[ idx ] = parseInt( val, 10 ); } );

            switch( ar.length ) {
                // All values are to be the same
                case 1:
                    if ( !isNaN( ar[ 0 ] ) ) {
                        tol.t = tol.r = tol.b = tol.l = ar[ 0 ];
                    }
                    break;

                // The first value denotes top/bottom tolerance, and the second value denotes left/right tolerance
                case 2:
                    if ( !isNaN( ar[ 0 ] ) ) {
                        tol.t = tol.b = ar[ 0 ];
                    }
                    if ( !isNaN( ar[ 1 ] ) ) {
                        tol.l = tol.r = ar[ 1 ];
                    }
                    break;

                // The array contains values in the order top, right, bottom, left
                case 4:
                    if ( !isNaN( ar[ 0 ] ) ) {
                        tol.t = ar[ 0 ];
                    }
                    if ( !isNaN( ar[ 1 ] ) ) {
                        tol.r = ar[ 1 ];
                    }
                    if ( !isNaN( ar[ 2 ] ) ) {
                        tol.b = ar[ 2 ];
                    }
                    if ( !isNaN( ar[ 3 ] ) ) {
                        tol.l = ar[ 3 ];
                    }
                    break;

                default:
                    break;
            }
        }

        this._tolerance = tol;
        return this;
    },

    _clampPopupWidth: function( infoOnly ) {
        var menuSize,
            windowCoordinates = getWindowCoordinates( this.window ),
            // rectangle within which the popup must fit
            rectangle = {
                x: this._tolerance.l,
                y: windowCoordinates.y + this._tolerance.t,
                cx: windowCoordinates.cx - this._tolerance.l - this._tolerance.r,
                cy: windowCoordinates.cy - this._tolerance.t - this._tolerance.b
            };

        if ( !infoOnly ) {
            // Clamp the width of the menu before grabbing its size
            this._ui.container.css( "max-width", rectangle.cx );
        }

        menuSize = {
            cx: this._ui.container.outerWidth( true ),
            cy: this._ui.container.outerHeight( true )
        };

        return { rc: rectangle, menuSize: menuSize };
    },

    _calculateFinalLocation: function( desired, clampInfo ) {
        var returnValue,
            rectangle = clampInfo.rc,
            menuSize = clampInfo.menuSize;

        // Center the menu over the desired coordinates, while not going outside
        // the window tolerances. This will center wrt. the window if the popup is
        // too large.
        returnValue = {
            left: fitSegmentInsideSegment( rectangle.cx, menuSize.cx, rectangle.x, desired.x ),
            top: fitSegmentInsideSegment( rectangle.cy, menuSize.cy, rectangle.y, desired.y )
        };

        // Make sure the top of the menu is visible
        returnValue.top = Math.max( 0, returnValue.top );

        // If the height of the menu is smaller than the height of the document
        // align the bottom with the bottom of the document

        returnValue.top -= Math.min( returnValue.top,
            Math.max( 0, returnValue.top + menuSize.cy - this.document.height() ) );

        return returnValue;
    },

    // Try and center the overlay over the given coordinates
    _placementCoords: function( desired ) {
        return this._calculateFinalLocation( desired, this._clampPopupWidth() );
    },

    _createPrerequisites: function( screenPrerequisite, containerPrerequisite, whenDone ) {
        var prerequisites,
            self = this;

        // It is important to maintain both the local variable prerequisites and
        // self._prerequisites. The local variable remains in the closure of the
        // functions which call the callbacks passed in. The comparison between the
        // local variable and self._prerequisites is necessary, because once a
        // function has been passed to .animationComplete() it will be called next
        // time an animation completes, even if that's not the animation whose end
        // the function was supposed to catch (for example, if an abort happens
        // during the opening animation, the .animationComplete handler is not
        // called for that animation anymore, but the handler remains attached, so
        // it is called the next time the popup is opened - making it stale.
        // Comparing the local variable prerequisites to the widget-level variable
        // self._prerequisites ensures that callbacks triggered by a stale
        // .animationComplete will be ignored.

        prerequisites = {
            screen: $.Deferred(),
            container: $.Deferred()
        };

        prerequisites.screen.then( function() {
            if ( prerequisites === self._prerequisites ) {
                screenPrerequisite();
            }
        });

        prerequisites.container.then( function() {
            if ( prerequisites === self._prerequisites ) {
                containerPrerequisite();
            }
        });

        $.when( prerequisites.screen, prerequisites.container ).done( function() {
            if ( prerequisites === self._prerequisites ) {
                self._prerequisites = null;
                whenDone();
            }
        });

        self._prerequisites = prerequisites;
    },

    _animate: function( args ) {
        // NOTE before removing the default animation of the screen
        //      this had an animate callback that would resolve the deferred
        //      now the deferred is resolved immediately
        // TODO remove the dependency on the screen deferred
        this._ui.screen
            .removeClass( args.classToRemove )
            .addClass( args.screenClassToAdd );

        args.prerequisites.screen.resolve();

        if ( args.transition && args.transition !== "none" ) {
            if ( args.applyTransition ) {
                this._applyTransition( args.transition );
            }
            if ( this._fallbackTransition ) {
                this._ui.container
                    .addClass( args.containerClassToAdd )
                    .removeClass( args.classToRemove )
                    .animationComplete( $.proxy( args.prerequisites.container, "resolve" ) );
                return;
            }
        }
        this._ui.container.removeClass( args.classToRemove );
        args.prerequisites.container.resolve();
    },

    // The desired coordinates passed in will be returned untouched if no reference element can be identified via
    // desiredPosition.positionTo. Nevertheless, this function ensures that its return value always contains valid
    // x and y coordinates by specifying the center middle of the window if the coordinates are absent.
    // options: { x: coordinate, y: coordinate, positionTo: string: "origin", "window", or jQuery selector
    _desiredCoords: function( openOptions ) {
        var offset,
            dst = null,
            windowCoordinates = getWindowCoordinates( this.window ),
            x = openOptions.x,
            y = openOptions.y,
            pTo = openOptions.positionTo;

        // Establish which element will serve as the reference
        if ( pTo && pTo !== "origin" ) {
            if ( pTo === "window" ) {
                x = windowCoordinates.cx / 2 + windowCoordinates.x;
                y = windowCoordinates.cy / 2 + windowCoordinates.y;
            } else {
                try {
                    dst = $( pTo );
                } catch( err ) {
                    dst = null;
                }
                if ( dst ) {
                    dst.filter( ":visible" );
                    if ( dst.length === 0 ) {
                        dst = null;
                    }
                }
            }
        }

        // If an element was found, center over it
        if ( dst ) {
            offset = dst.offset();
            x = offset.left + dst.outerWidth() / 2;
            y = offset.top + dst.outerHeight() / 2;
        }

        // Make sure x and y are valid numbers - center over the window
        if ( $.type( x ) !== "number" || isNaN( x ) ) {
            x = windowCoordinates.cx / 2 + windowCoordinates.x;
        }
        if ( $.type( y ) !== "number" || isNaN( y ) ) {
            y = windowCoordinates.cy / 2 + windowCoordinates.y;
        }

        return { x: x, y: y };
    },

    _reposition: function( openOptions ) {
        // We only care about position-related parameters for repositioning
        openOptions = {
            x: openOptions.x,
            y: openOptions.y,
            positionTo: openOptions.positionTo
        };
        this._trigger( "beforeposition", undefined, openOptions );
        this._ui.container.offset( this._placementCoords( this._desiredCoords( openOptions ) ) );
    },

    reposition: function( openOptions ) {
        if ( this._isOpen ) {
            this._reposition( openOptions );
        }
    },

    _safelyBlur: function( currentElement ){
        if ( currentElement !== this.window[ 0 ] &&
            currentElement.nodeName.toLowerCase() !== "body" ) {
                $( currentElement ).blur();
        }
    },

    _openPrerequisitesComplete: function() {
        var id = this.element.attr( "id" ),
            firstFocus = this._ui.container.find( ":focusable" ).first();

        this._ui.container.addClass( "ui-popup-active" );
        this._isOpen = true;
        this._resizeScreen();

        // Check to see if currElement is not a child of the container.  If it's not, blur
        if ( !$.contains( this._ui.container[ 0 ], this.document[ 0 ].activeElement ) ) {
            this._safelyBlur( this.document[ 0 ].activeElement );
        }
        if ( firstFocus.length > 0 ) {
            this._ui.focusElement = firstFocus;
        }
        this._ignoreResizeEvents();
        if ( id ) {
            this.document.find( "[aria-haspopup='true'][aria-owns='" +  id + "']" ).attr( "aria-expanded", true );
        }
        this._trigger( "afteropen" );
    },

    _open: function( options ) {
        var openOptions = $.extend( {}, this.options, options ),
            // TODO move blacklist to private method
            androidBlacklist = ( function() {
                var ua = navigator.userAgent,
                    // Rendering engine is Webkit, and capture major version
                    wkmatch = ua.match( /AppleWebKit\/([0-9\.]+)/ ),
                    wkversion = !!wkmatch && wkmatch[ 1 ],
                    androidmatch = ua.match( /Android (\d+(?:\.\d+))/ ),
                    andversion = !!androidmatch && androidmatch[ 1 ],
                    chromematch = ua.indexOf( "Chrome" ) > -1;

                // Platform is Android, WebKit version is greater than 534.13 ( Android 3.2.1 ) and not Chrome.
                if ( androidmatch !== null && andversion === "4.0" && wkversion && wkversion > 534.13 && !chromematch ) {
                    return true;
                }
                return false;
            }());

        // Count down to triggering "popupafteropen" - we have two prerequisites:
        // 1. The popup window animation completes (container())
        // 2. The screen opacity animation completes (screen())
        this._createPrerequisites(
            $.noop,
            $.noop,
            $.proxy( this, "_openPrerequisitesComplete" ) );

        this._currentTransition = openOptions.transition;
        this._applyTransition( openOptions.transition );

        this._ui.screen.removeClass( "ui-screen-hidden" );
        this._ui.container.removeClass( "ui-popup-truncate" );

        // Give applications a chance to modify the contents of the container before it appears
        this._reposition( openOptions );

        this._ui.container.removeClass( "ui-popup-hidden" );

        if ( this.options.overlayTheme && androidBlacklist ) {
            /* TODO: The native browser on Android 4.0.X ("Ice Cream Sandwich") suffers from an issue where the popup overlay appears to be z-indexed above the popup itself when certain other styles exist on the same page -- namely, any element set to `position: fixed` and certain types of input. These issues are reminiscent of previously uncovered bugs in older versions of Android's native browser: https://github.com/scottjehl/Device-Bugs/issues/3
            This fix closes the following bugs ( I use "closes" with reluctance, and stress that this issue should be revisited as soon as possible ):
            https://github.com/jquery/jquery-mobile/issues/4816
            https://github.com/jquery/jquery-mobile/issues/4844
            https://github.com/jquery/jquery-mobile/issues/4874
            */

            // TODO sort out why this._page isn't working
            this.element.closest( ".ui-page" ).addClass( "ui-popup-open" );
        }
        this._animate({
            additionalCondition: true,
            transition: openOptions.transition,
            classToRemove: "",
            screenClassToAdd: "in",
            containerClassToAdd: "in",
            applyTransition: false,
            prerequisites: this._prerequisites
        });
    },

    _closePrerequisiteScreen: function() {
        this._ui.screen
            .removeClass( "out" )
            .addClass( "ui-screen-hidden" );
    },

    _closePrerequisiteContainer: function() {
        this._ui.container
            .removeClass( "reverse out" )
            .addClass( "ui-popup-hidden ui-popup-truncate" )
            .removeAttr( "style" );
    },

    _closePrerequisitesDone: function() {
        var container = this._ui.container,
            id = this.element.attr( "id" );

        // remove the global mutex for popups
        $.mobile.popup.active = undefined;

        // Blur elements inside the container, including the container
        $( ":focus", container[ 0 ] ).add( container[ 0 ] ).blur();

        if ( id ) {
            this.document.find( "[aria-haspopup='true'][aria-owns='" +  id + "']" ).attr( "aria-expanded", false );
        }

        // alert users that the popup is closed
        this._trigger( "afterclose" );
    },

    _close: function( immediate ) {
        this._ui.container.removeClass( "ui-popup-active" );
        this._page.removeClass( "ui-popup-open" );

        this._isOpen = false;

        // Count down to triggering "popupafterclose" - we have two prerequisites:
        // 1. The popup window reverse animation completes (container())
        // 2. The screen opacity animation completes (screen())
        this._createPrerequisites(
            $.proxy( this, "_closePrerequisiteScreen" ),
            $.proxy( this, "_closePrerequisiteContainer" ),
            $.proxy( this, "_closePrerequisitesDone" ) );

        this._animate( {
            additionalCondition: this._ui.screen.hasClass( "in" ),
            transition: ( immediate ? "none" : ( this._currentTransition ) ),
            classToRemove: "in",
            screenClassToAdd: "out",
            containerClassToAdd: "reverse out",
            applyTransition: true,
            prerequisites: this._prerequisites
        });
    },

    _unenhance: function() {
        if ( this.options.enhanced ) {
            return;
        }

        // Put the element back to where the placeholder was and remove the "ui-popup" class
        this._setOptions( { theme: $.mobile.popup.prototype.options.theme } );
        this.element
            // Cannot directly insertAfter() - we need to detach() first, because
            // insertAfter() will do nothing if the payload div was not attached
            // to the DOM at the time the widget was created, and so the payload
            // will remain inside the container even after we call insertAfter().
            // If that happens and we remove the container a few lines below, we
            // will cause an infinite recursion - #5244
            .detach()
            .insertAfter( this._ui.placeholder )
            .removeClass( "ui-popup ui-overlay-shadow ui-corner-all ui-body-inherit" );
        this._ui.screen.remove();
        this._ui.container.remove();
        this._ui.placeholder.remove();
    },

    _destroy: function() {
        if ( $.mobile.popup.active === this ) {
            this.element.one( "popupafterclose", $.proxy( this, "_unenhance" ) );
            this.close();
        } else {
            this._unenhance();
        }

        return this;
    },

    _closePopup: function( theEvent, data ) {
        var parsedDst, toUrl,
            currentOptions = this.options,
            immediate = false;

        if ( ( theEvent && theEvent.isDefaultPrevented() ) || $.mobile.popup.active !== this ) {
            return;
        }

        // restore location on screen
        window.scrollTo( 0, this._scrollTop );

        if ( theEvent && theEvent.type === "pagebeforechange" && data ) {
            // Determine whether we need to rapid-close the popup, or whether we can
            // take the time to run the closing transition
            if ( typeof data.toPage === "string" ) {
                parsedDst = data.toPage;
            } else {
                parsedDst = data.toPage.jqmData( "url" );
            }
            parsedDst = $.mobile.path.parseUrl( parsedDst );
            toUrl = parsedDst.pathname + parsedDst.search + parsedDst.hash;

            if ( this._myUrl !== $.mobile.path.makeUrlAbsolute( toUrl ) ) {
                // Going to a different page - close immediately
                immediate = true;
            } else {
                theEvent.preventDefault();
            }
        }

        // remove nav bindings
        this.window.off( currentOptions.closeEvents );
        // unbind click handlers added when history is disabled
        this.element.undelegate( currentOptions.closeLinkSelector, currentOptions.closeLinkEvents );

        this._close( immediate );
    },

    // any navigation event after a popup is opened should close the popup
    // NOTE the pagebeforechange is bound to catch navigation events that don't
    //      alter the url (eg, dialogs from popups)
    _bindContainerClose: function() {
        this.window
            .on( this.options.closeEvents, $.proxy( this, "_closePopup" ) );
    },

    widget: function() {
        return this._ui.container;
    },

    // TODO no clear deliniation of what should be here and
    // what should be in _open. Seems to be "visual" vs "history" for now
    open: function( options ) {
        var url, hashkey, activePage, currentIsDialog, hasHash, urlHistory,
            self = this,
            currentOptions = this.options;

        // make sure open is idempotent
        if ( $.mobile.popup.active || currentOptions.disabled ) {
            return this;
        }

        // set the global popup mutex
        $.mobile.popup.active = this;
        this._scrollTop = this.window.scrollTop();

        // if history alteration is disabled close on navigate events
        // and leave the url as is
        if ( !( currentOptions.history ) ) {
            self._open( options );
            self._bindContainerClose();

            // When histoy is disabled we have to grab the data-rel
            // back link clicks so we can close the popup instead of
            // relying on history to do it for us
            self.element
                .delegate( currentOptions.closeLinkSelector, currentOptions.closeLinkEvents, function( theEvent ) {
                    self.close();
                    theEvent.preventDefault();
                });

            return this;
        }

        // cache some values for min/readability
        urlHistory = $.mobile.navigate.history;
        hashkey = $.mobile.dialogHashKey;
        activePage = $.mobile.activePage;
        currentIsDialog = ( activePage ? activePage.hasClass( "ui-dialog" ) : false );
        this._myUrl = url = urlHistory.getActive().url;
        hasHash = ( url.indexOf( hashkey ) > -1 ) && !currentIsDialog && ( urlHistory.activeIndex > 0 );

        if ( hasHash ) {
            self._open( options );
            self._bindContainerClose();
            return this;
        }

        // if the current url has no dialog hash key proceed as normal
        // otherwise, if the page is a dialog simply tack on the hash key
        if ( url.indexOf( hashkey ) === -1 && !currentIsDialog ) {
            url = url + (url.indexOf( "#" ) > -1 ? hashkey : "#" + hashkey);
        } else {
            url = $.mobile.path.parseLocation().hash + hashkey;
        }

        // swallow the the initial navigation event, and bind for the next
        this.window.one( "beforenavigate", function( theEvent ) {
            theEvent.preventDefault();
            self._open( options );
            self._bindContainerClose();
        });

        this.urlAltered = true;
        $.mobile.navigate( url, { role: "dialog" } );

        return this;
    },

    close: function() {
        // make sure close is idempotent
        if ( $.mobile.popup.active !== this ) {
            return this;
        }

        this._scrollTop = this.window.scrollTop();

        if ( this.options.history && this.urlAltered ) {
            $.mobile.back();
            this.urlAltered = false;
        } else {
            // simulate the nav bindings having fired
            this._closePopup();
        }

        return this;
    }
});

// TODO this can be moved inside the widget
$.mobile.popup.handleLink = function( $link ) {
    var offset,
        path = $.mobile.path,

        // NOTE make sure to get only the hash from the href because ie7 (wp7)
        //      returns the absolute href in this case ruining the element selection
        popup = $( path.hashToSelector( path.parseUrl( $link.attr( "href" ) ).hash ) ).first();

    if ( popup.length > 0 && popup.data( "mobile-popup" ) ) {
        offset = $link.offset();
        popup.popup( "open", {
            x: offset.left + $link.outerWidth() / 2,
            y: offset.top + $link.outerHeight() / 2,
            transition: $link.jqmData( "transition" ),
            positionTo: $link.jqmData( "position-to" )
        });
    }

    //remove after delay
    setTimeout( function() {
        $link.removeClass( $.mobile.activeBtnClass );
    }, 300 );
};

// TODO move inside _create
$.mobile.document.on( "pagebeforechange", function( theEvent, data ) {
    if ( data.options.role === "popup" ) {
        $.mobile.popup.handleLink( data.options.link );
        theEvent.preventDefault();
    }
});

})( jQuery );

/*
* custom "selectmenu" plugin
*/

(function( $, undefined ) {

var unfocusableItemSelector = ".ui-disabled,.ui-state-disabled,.ui-li-divider,.ui-screen-hidden,:jqmData(role='placeholder')",
    goToAdjacentItem = function( item, target, direction ) {
        var adjacent = item[ direction + "All" ]()
            .not( unfocusableItemSelector )
            .first();

        // if there's a previous option, focus it
        if ( adjacent.length ) {
            target
                .blur()
                .attr( "tabindex", "-1" );

            adjacent.find( "a" ).first().focus();
        }
    };

$.widget( "mobile.selectmenu", $.mobile.selectmenu, {
    _create: function() {
        var o = this.options;

        // Custom selects cannot exist inside popups, so revert the "nativeMenu"
        // option to true if a parent is a popup
        o.nativeMenu = o.nativeMenu || ( this.element.parents( ":jqmData(role='popup'),:mobile-popup" ).length > 0 );

        return this._super();
    },

    _handleSelectFocus: function() {
        this.element.blur();
        this.button.focus();
    },

    _handleKeydown: function( event ) {
        this._super( event );
        this._handleButtonVclickKeydown( event );
    },

    _handleButtonVclickKeydown: function( event ) {
        if ( this.options.disabled || this.isOpen || this.options.nativeMenu ) {
            return;
        }

        if (event.type === "vclick" ||
                event.keyCode && (event.keyCode === $.mobile.keyCode.ENTER || event.keyCode === $.mobile.keyCode.SPACE)) {

            this._decideFormat();
            if ( this.menuType === "overlay" ) {
                this.button.attr( "href", "#" + this.popupId ).attr( "data-" + ( $.mobile.ns || "" ) + "rel", "popup" );
            } else {
                this.button.attr( "href", "#" + this.dialogId ).attr( "data-" + ( $.mobile.ns || "" ) + "rel", "dialog" );
            }
            this.isOpen = true;
            // Do not prevent default, so the navigation may have a chance to actually open the chosen format
        }
    },

    _handleListFocus: function( e ) {
        var params = ( e.type === "focusin" ) ?
            { tabindex: "0", event: "vmouseover" }:
            { tabindex: "-1", event: "vmouseout" };

        $( e.target )
            .attr( "tabindex", params.tabindex )
            .trigger( params.event );
    },

    _handleListKeydown: function( event ) {
        var target = $( event.target ),
            li = target.closest( "li" );

        // switch logic based on which key was pressed
        switch ( event.keyCode ) {
            // up or left arrow keys
        case 38:
            goToAdjacentItem( li, target, "prev" );
            return false;
            // down or right arrow keys
        case 40:
            goToAdjacentItem( li, target, "next" );
            return false;
            // If enter or space is pressed, trigger click
        case 13:
        case 32:
            target.trigger( "click" );
            return false;
        }
    },

    _handleMenuPageHide: function() {

        // After the dialog's done, we may want to trigger change if the value has actually changed
        this._delayedTrigger();

        // TODO centralize page removal binding / handling in the page plugin.
        // Suggestion from @jblas to do refcounting
        //
        // TODO extremely confusing dependency on the open method where the pagehide.remove
        // bindings are stripped to prevent the parent page from disappearing. The way
        // we're keeping pages in the DOM right now sucks
        //
        // rebind the page remove that was unbound in the open function
        // to allow for the parent page removal from actions other than the use
        // of a dialog sized custom select
        //
        // doing this here provides for the back button on the custom select dialog
        this.thisPage.page( "bindRemove" );
    },

    _handleHeaderCloseClick: function() {
        if ( this.menuType === "overlay" ) {
            this.close();
            return false;
        }
    },

    _handleListItemClick: function( event ) {
        var listItem = $( event.target ).closest( "li" ),

            // Index of option tag to be selected
            oldIndex = this.select[ 0 ].selectedIndex,
            newIndex = $.mobile.getAttribute( listItem, "option-index" ),
            option = this._selectOptions().eq( newIndex )[ 0 ];

        // Toggle selected status on the tag for multi selects
        option.selected = this.isMultiple ? !option.selected : true;

        // Toggle checkbox class for multiple selects
        if ( this.isMultiple ) {
            listItem.find( "a" )
                .toggleClass( "ui-checkbox-on", option.selected )
                .toggleClass( "ui-checkbox-off", !option.selected );
        }

        // If it's not a multiple select, trigger change after it has finished closing
        if ( !this.isMultiple && oldIndex !== newIndex ) {
            this._triggerChange = true;
        }

        // Trigger change if it's a multiple select
        // Hide custom select for single selects only - otherwise focus clicked item
        // We need to grab the clicked item the hard way, because the list may have been rebuilt
        if ( this.isMultiple ) {
            this.select.trigger( "change" );
            this.list.find( "li:not(.ui-li-divider)" ).eq( newIndex )
                .find( "a" ).first().focus();
        }
        else {
            this.close();
        }

        event.preventDefault();
    },

    build: function() {
        var selectId, popupId, dialogId, label, thisPage, isMultiple, menuId,
            themeAttr, overlayTheme, overlayThemeAttr, dividerThemeAttr,
            menuPage, listbox, list, header, headerTitle, menuPageContent,
            menuPageClose, headerClose,
            o = this.options;

        if ( o.nativeMenu ) {
            return this._super();
        }

        selectId = this.selectId;
        popupId = selectId + "-listbox";
        dialogId = selectId + "-dialog";
        label = this.label;
        thisPage = this.element.closest( ".ui-page" );
        isMultiple = this.element[ 0 ].multiple;
        menuId = selectId + "-menu";
        themeAttr = o.theme ? ( " data-" + $.mobile.ns + "theme='" + o.theme + "'" ) : "";
        overlayTheme = o.overlayTheme || o.theme || null;
        overlayThemeAttr = overlayTheme ? ( " data-" + $.mobile.ns +
            "overlay-theme='" + overlayTheme + "'" ) : "";
        dividerThemeAttr = ( o.dividerTheme && isMultiple ) ? ( " data-" + $.mobile.ns + "divider-theme='" + o.dividerTheme + "'" ) : "";
        menuPage = $( "<div data-" + $.mobile.ns + "role='dialog' class='ui-selectmenu' id='" + dialogId + "'" + themeAttr + overlayThemeAttr + ">" +
            "<div data-" + $.mobile.ns + "role='header'>" +
            "<div class='ui-title'></div>"+
            "</div>"+
            "<div data-" + $.mobile.ns + "role='content'></div>"+
            "</div>" );
        listbox = $( "<div" + themeAttr + overlayThemeAttr + " id='" + popupId +
                "' class='ui-selectmenu'></div>" )
            .insertAfter( this.select )
            .popup();
        list = $( "<ul class='ui-selectmenu-list' id='" + menuId + "' role='listbox' aria-labelledby='" + this.buttonId + "'" + themeAttr + dividerThemeAttr + "></ul>" ).appendTo( listbox );
        header = $( "<div class='ui-header ui-bar-" + ( o.theme ? o.theme : "inherit" ) + "'></div>" ).prependTo( listbox );
        headerTitle = $( "<h1 class='ui-title'></h1>" ).appendTo( header );

        if ( this.isMultiple ) {
            headerClose = $( "<a>", {
                "role": "button",
                "text": o.closeText,
                "href": "#",
                "class": "ui-btn ui-corner-all ui-btn-left ui-btn-icon-notext ui-icon-delete"
            }).appendTo( header );
        }

        $.extend( this, {
            selectId: selectId,
            menuId: menuId,
            popupId: popupId,
            dialogId: dialogId,
            thisPage: thisPage,
            menuPage: menuPage,
            label: label,
            isMultiple: isMultiple,
            theme: o.theme,
            listbox: listbox,
            list: list,
            header: header,
            headerTitle: headerTitle,
            headerClose: headerClose,
            menuPageContent: menuPageContent,
            menuPageClose: menuPageClose,
            placeholder: ""
        });

        // Create list from select, update state
        this.refresh();

        if ( this._origTabIndex === undefined ) {
            // Map undefined to false, because this._origTabIndex === undefined
            // indicates that we have not yet checked whether the select has
            // originally had a tabindex attribute, whereas false indicates that
            // we have checked the select for such an attribute, and have found
            // none present.
            this._origTabIndex = ( this.select[ 0 ].getAttribute( "tabindex" ) === null ) ? false : this.select.attr( "tabindex" );
        }
        this.select.attr( "tabindex", "-1" );
        this._on( this.select, { focus : "_handleSelectFocus" } );

        // Button events
        this._on( this.button, {
            vclick: "_handleButtonVclickKeydown"
        });

        // Events for list items
        this.list.attr( "role", "listbox" );
        this._on( this.list, {
            "focusin": "_handleListFocus",
            "focusout": "_handleListFocus",
            "keydown": "_handleListKeydown",
            "click li:not(.ui-disabled,.ui-state-disabled,.ui-li-divider)": "_handleListItemClick"
        });

        // button refocus ensures proper height calculation
        // by removing the inline style and ensuring page inclusion
        this._on( this.menuPage, { pagehide: "_handleMenuPageHide" } );

        // Events on the popup
        this._on( this.listbox, { popupafterclose: "_popupClosed" } );

        // Close button on small overlays
        if ( this.isMultiple ) {
            this._on( this.headerClose, { click: "_handleHeaderCloseClick" } );
        }

        return this;
    },

    _popupClosed: function() {
        this.close();
        this._delayedTrigger();
    },

    _delayedTrigger: function() {
        if ( this._triggerChange ) {
            this.element.trigger( "change" );
        }
        this._triggerChange = false;
    },

    _isRebuildRequired: function() {
        var list = this.list.find( "li" ),
            options = this._selectOptions().not( ".ui-screen-hidden" );

        // TODO exceedingly naive method to determine difference
        // ignores value changes etc in favor of a forcedRebuild
        // from the user in the refresh method
        return options.text() !== list.text();
    },

    selected: function() {
        return this._selectOptions().filter( ":selected:not( :jqmData(placeholder='true') )" );
    },

    refresh: function( force ) {
        var self, indices;

        if ( this.options.nativeMenu ) {
            return this._super( force );
        }

        self = this;
        if ( force || this._isRebuildRequired() ) {
            self._buildList();
        }

        indices = this.selectedIndices();

        self.setButtonText();
        self.setButtonCount();

        self.list.find( "li:not(.ui-li-divider)" )
            .find( "a" ).removeClass( $.mobile.activeBtnClass ).end()
            .attr( "aria-selected", false )
            .each(function( i ) {
                var item = $( this );
                if ( $.inArray( i, indices ) > -1 ) {

                    // Aria selected attr
                    item.attr( "aria-selected", true );

                    // Multiple selects: add the "on" checkbox state to the icon
                    if ( self.isMultiple ) {
                        item.find( "a" ).removeClass( "ui-checkbox-off" ).addClass( "ui-checkbox-on" );
                    } else {
                        if ( item.hasClass( "ui-screen-hidden" ) ) {
                            item.next().find( "a" ).addClass( $.mobile.activeBtnClass );
                        } else {
                            item.find( "a" ).addClass( $.mobile.activeBtnClass );
                        }
                    }
                } else if ( self.isMultiple ) {
                    item.find( "a" ).removeClass( "ui-checkbox-on" ).addClass( "ui-checkbox-off" );
                }
            });
    },

    close: function() {
        if ( this.options.disabled || !this.isOpen ) {
            return;
        }

        var self = this;

        if ( self.menuType === "page" ) {
            self.menuPage.dialog( "close" );
            self.list.appendTo( self.listbox );
        } else {
            self.listbox.popup( "close" );
        }

        self._focusButton();
        // allow the dialog to be closed again
        self.isOpen = false;
    },

    open: function() {
        this.button.click();
    },

    _focusMenuItem: function() {
        var selector = this.list.find( "a." + $.mobile.activeBtnClass );
        if ( selector.length === 0 ) {
            selector = this.list.find( "li:not(" + unfocusableItemSelector + ") a.ui-btn" );
        }
        selector.first().focus();
    },

    _decideFormat: function() {
        var self = this,
            $window = this.window,
            selfListParent = self.list.parent(),
            menuHeight = selfListParent.outerHeight(),
            scrollTop = $window.scrollTop(),
            btnOffset = self.button.offset().top,
            screenHeight = $window.height();

        if ( menuHeight > screenHeight - 80 || !$.support.scrollTop ) {

            self.menuPage.appendTo( $.mobile.pageContainer ).page();
            self.menuPageContent = self.menuPage.find( ".ui-content" );
            self.menuPageClose = self.menuPage.find( ".ui-header a" );

            // prevent the parent page from being removed from the DOM,
            // otherwise the results of selecting a list item in the dialog
            // fall into a black hole
            self.thisPage.unbind( "pagehide.remove" );

            //for WebOS/Opera Mini (set lastscroll using button offset)
            if ( scrollTop === 0 && btnOffset > screenHeight ) {
                self.thisPage.one( "pagehide", function() {
                    $( this ).jqmData( "lastScroll", btnOffset );
                });
            }

            self.menuPage.one( {
                pageshow: $.proxy( this, "_focusMenuItem" ),
                pagehide: $.proxy( this, "close" )
            });

            self.menuType = "page";
            self.menuPageContent.append( self.list );
            self.menuPage
                .find( "div .ui-title" )
                    .text( self.label.getEncodedText() || self.placeholder );
        } else {
            self.menuType = "overlay";

            self.listbox.one( { popupafteropen: $.proxy( this, "_focusMenuItem" ) } );
        }
    },

    _buildList: function() {
        var self = this,
            o = this.options,
            placeholder = this.placeholder,
            needPlaceholder = true,
            dataIcon = "false",
            $options, numOptions, select,
            dataPrefix = "data-" + $.mobile.ns,
            dataIndexAttr = dataPrefix + "option-index",
            dataIconAttr = dataPrefix + "icon",
            dataRoleAttr = dataPrefix + "role",
            dataPlaceholderAttr = dataPrefix + "placeholder",
            fragment = document.createDocumentFragment(),
            isPlaceholderItem = false,
            optGroup,
            i,
            option, $option, parent, text, anchor, classes,
            optLabel, divider, item;

        self.list.empty().filter( ".ui-listview" ).listview( "destroy" );
        $options = this._selectOptions();
        numOptions = $options.length;
        select = this.select[ 0 ];

        for ( i = 0; i < numOptions;i++, isPlaceholderItem = false) {
            option = $options[i];
            $option = $( option );

            // Do not create options based on ui-screen-hidden select options
            if ( $option.hasClass( "ui-screen-hidden" ) ) {
                continue;
            }

            parent = option.parentNode;
            classes = [];

            // Although using .text() here raises the risk that, when we later paste this into the
            // list item we end up pasting possibly malicious things like <script> tags, that risk
            // only arises if we do something like $( "<li><a href='#'>" + text + "</a></li>" ). We
            // don't do that. We do document.createTextNode( text ) instead, which guarantees that
            // whatever we paste in will end up as text, with characters like <, > and & escaped.
            text = $option.text();
            anchor = document.createElement( "a" );
            anchor.setAttribute( "href", "#" );
            anchor.appendChild( document.createTextNode( text ) );

            // Are we inside an optgroup?
            if ( parent !== select && parent.nodeName.toLowerCase() === "optgroup" ) {
                optLabel = parent.getAttribute( "label" );
                if ( optLabel !== optGroup ) {
                    divider = document.createElement( "li" );
                    divider.setAttribute( dataRoleAttr, "list-divider" );
                    divider.setAttribute( "role", "option" );
                    divider.setAttribute( "tabindex", "-1" );
                    divider.appendChild( document.createTextNode( optLabel ) );
                    fragment.appendChild( divider );
                    optGroup = optLabel;
                }
            }

            if ( needPlaceholder && ( !option.getAttribute( "value" ) || text.length === 0 || $option.jqmData( "placeholder" ) ) ) {
                needPlaceholder = false;
                isPlaceholderItem = true;

                // If we have identified a placeholder, record the fact that it was
                // us who have added the placeholder to the option and mark it
                // retroactively in the select as well
                if ( null === option.getAttribute( dataPlaceholderAttr ) ) {
                    this._removePlaceholderAttr = true;
                }
                option.setAttribute( dataPlaceholderAttr, true );
                if ( o.hidePlaceholderMenuItems ) {
                    classes.push( "ui-screen-hidden" );
                }
                if ( placeholder !== text ) {
                    placeholder = self.placeholder = text;
                }
            }

            item = document.createElement( "li" );
            if ( option.disabled ) {
                classes.push( "ui-state-disabled" );
                item.setAttribute( "aria-disabled", true );
            }
            item.setAttribute( dataIndexAttr, i );
            item.setAttribute( dataIconAttr, dataIcon );
            if ( isPlaceholderItem ) {
                item.setAttribute( dataPlaceholderAttr, true );
            }
            item.className = classes.join( " " );
            item.setAttribute( "role", "option" );
            anchor.setAttribute( "tabindex", "-1" );
            if ( this.isMultiple ) {
                $( anchor ).addClass( "ui-btn ui-checkbox-off ui-btn-icon-right" );
            }

            item.appendChild( anchor );
            fragment.appendChild( item );
        }

        self.list[0].appendChild( fragment );

        // Hide header if it's not a multiselect and there's no placeholder
        if ( !this.isMultiple && !placeholder.length ) {
            this.header.addClass( "ui-screen-hidden" );
        } else {
            this.headerTitle.text( this.placeholder );
        }

        // Now populated, create listview
        self.list.listview();
    },

    _button: function() {
        return this.options.nativeMenu ?
            this._super() :
            $( "<a>", {
                "href": "#",
                "role": "button",
                // TODO value is undefined at creation
                "id": this.buttonId,
                "aria-haspopup": "true",

                // TODO value is undefined at creation
                "aria-owns": this.menuId
            });
    },

    _destroy: function() {

        if ( !this.options.nativeMenu ) {
            this.close();

            // Restore the tabindex attribute to its original value
            if ( this._origTabIndex !== undefined ) {
                if ( this._origTabIndex !== false ) {
                    this.select.attr( "tabindex", this._origTabIndex );
                } else {
                    this.select.removeAttr( "tabindex" );
                }
            }

            // Remove the placeholder attribute if we were the ones to add it
            if ( this._removePlaceholderAttr ) {
                this._selectOptions().removeAttr( "data-" + $.mobile.ns + "placeholder" );
            }

            // Remove the popup
            this.listbox.remove();

            // Remove the dialog
            this.menuPage.remove();
        }

        // Chain up
        this._super();
    }
});

})( jQuery );


// buttonMarkup is deprecated as of 1.4.0 and will be removed in 1.5.0.

(function( $, undefined ) {

// General policy: Do not access data-* attributes except during enhancement.
// In all other cases we determine the state of the button exclusively from its
// className. That's why optionsToClasses expects a full complement of options,
// and the jQuery plugin completes the set of options from the default values.

// Map classes to buttonMarkup boolean options - used in classNameToOptions()
var reverseBoolOptionMap = {
        "ui-shadow" : "shadow",
        "ui-corner-all" : "corners",
        "ui-btn-inline" : "inline",
        "ui-shadow-icon" : "iconshadow", /* TODO: Remove in 1.5 */
        "ui-mini" : "mini"
    },
    getAttrFixed = function() {
        var ret = $.mobile.getAttribute.apply( this, arguments );

        return ( ret == null ? undefined : ret );
    },
    capitalLettersRE = /[A-Z]/g;

// optionsToClasses:
// @options: A complete set of options to convert to class names.
// @existingClasses: extra classes to add to the result
//
// Converts @options to buttonMarkup classes and returns the result as an array
// that can be converted to an element's className with .join( " " ). All
// possible options must be set inside @options. Use $.fn.buttonMarkup.defaults
// to get a complete set and use $.extend to override your choice of options
// from that set.
function optionsToClasses( options, existingClasses ) {
    var classes = existingClasses ? existingClasses : [];

    // Add classes to the array - first ui-btn
    classes.push( "ui-btn" );

    // If there is a theme
    if ( options.theme ) {
        classes.push( "ui-btn-" + options.theme );
    }

    // If there's an icon, add the icon-related classes
    if ( options.icon ) {
        classes = classes.concat([
            "ui-icon-" + options.icon,
            "ui-btn-icon-" + options.iconpos
        ]);
        if ( options.iconshadow ) {
            classes.push( "ui-shadow-icon" ); /* TODO: Remove in 1.5 */
        }
    }

    // Add the appropriate class for each boolean option
    if ( options.inline ) {
        classes.push( "ui-btn-inline" );
    }
    if ( options.shadow ) {
        classes.push( "ui-shadow" );
    }
    if ( options.corners ) {
        classes.push( "ui-corner-all" );
    }
    if ( options.mini ) {
        classes.push( "ui-mini" );
    }

    // Create a string from the array and return it
    return classes;
}

// classNameToOptions:
// @classes: A string containing a .className-style space-separated class list
//
// Loops over @classes and calculates an options object based on the
// buttonMarkup-related classes it finds. It records unrecognized classes in an
// array.
//
// Returns: An object containing the following items:
//
// "options": buttonMarkup options found to be present because of the
// presence/absence of corresponding classes
//
// "unknownClasses": a string containing all the non-buttonMarkup-related
// classes found in @classes
//
// "alreadyEnhanced": A boolean indicating whether the ui-btn class was among
// those found to be present
function classNameToOptions( classes ) {
    var idx, map, unknownClass,
        alreadyEnhanced = false,
        noIcon = true,
        o = {
            icon: "",
            inline: false,
            shadow: false,
            corners: false,
            iconshadow: false,
            mini: false
        },
        unknownClasses = [];

    classes = classes.split( " " );

    // Loop over the classes
    for ( idx = 0 ; idx < classes.length ; idx++ ) {

        // Assume it's an unrecognized class
        unknownClass = true;

        // Recognize boolean options from the presence of classes
        map = reverseBoolOptionMap[ classes[ idx ] ];
        if ( map !== undefined ) {
            unknownClass = false;
            o[ map ] = true;

        // Recognize the presence of an icon and establish the icon position
        } else if ( classes[ idx ].indexOf( "ui-btn-icon-" ) === 0 ) {
            unknownClass = false;
            noIcon = false;
            o.iconpos = classes[ idx ].substring( 12 );

        // Establish which icon is present
        } else if ( classes[ idx ].indexOf( "ui-icon-" ) === 0 ) {
            unknownClass = false;
            o.icon = classes[ idx ].substring( 8 );

        // Establish the theme - this recognizes one-letter theme swatch names
        } else if ( classes[ idx ].indexOf( "ui-btn-" ) === 0 && classes[ idx ].length === 8 ) {
            unknownClass = false;
            o.theme = classes[ idx ].substring( 7 );

        // Recognize that this element has already been buttonMarkup-enhanced
        } else if ( classes[ idx ] === "ui-btn" ) {
            unknownClass = false;
            alreadyEnhanced = true;
        }

        // If this class has not been recognized, add it to the list
        if ( unknownClass ) {
            unknownClasses.push( classes[ idx ] );
        }
    }

    // If a "ui-btn-icon-*" icon position class is absent there cannot be an icon
    if ( noIcon ) {
        o.icon = "";
    }

    return {
        options: o,
        unknownClasses: unknownClasses,
        alreadyEnhanced: alreadyEnhanced
    };
}

function camelCase2Hyphenated( c ) {
    return "-" + c.toLowerCase();
}

// $.fn.buttonMarkup:
// DOM: gets/sets .className
//
// @options: options to apply to the elements in the jQuery object
// @overwriteClasses: boolean indicating whether to honour existing classes
//
// Calculates the classes to apply to the elements in the jQuery object based on
// the options passed in. If @overwriteClasses is true, it sets the className
// property of each element in the jQuery object to the buttonMarkup classes
// it calculates based on the options passed in.
//
// If you wish to preserve any classes that are already present on the elements
// inside the jQuery object, including buttonMarkup-related classes that were
// added by a previous call to $.fn.buttonMarkup() or during page enhancement
// then you should omit @overwriteClasses or set it to false.
$.fn.buttonMarkup = function( options, overwriteClasses ) {
    var idx, data, el, retrievedOptions, optionKey,
        defaults = $.fn.buttonMarkup.defaults;

    for ( idx = 0 ; idx < this.length ; idx++ ) {
        el = this[ idx ];
        data = overwriteClasses ?

            // Assume this element is not enhanced and ignore its classes
            { alreadyEnhanced: false, unknownClasses: [] } :

            // Otherwise analyze existing classes to establish existing options and
            // classes
            classNameToOptions( el.className );

        retrievedOptions = $.extend( {},

            // If the element already has the class ui-btn, then we assume that
            // it has passed through buttonMarkup before - otherwise, the options
            // returned by classNameToOptions do not correctly reflect the state of
            // the element
            ( data.alreadyEnhanced ? data.options : {} ),

            // Finally, apply the options passed in
            options );

        // If this is the first call on this element, retrieve remaining options
        // from the data-attributes
        if ( !data.alreadyEnhanced ) {
            for ( optionKey in defaults ) {
                if ( retrievedOptions[ optionKey ] === undefined ) {
                    retrievedOptions[ optionKey ] = getAttrFixed( el,
                        optionKey.replace( capitalLettersRE, camelCase2Hyphenated )
                    );
                }
            }
        }

        el.className = optionsToClasses(

            // Merge all the options and apply them as classes
            $.extend( {},

                // The defaults form the basis
                defaults,

                // Add the computed options
                retrievedOptions
            ),

            // ... and re-apply any unrecognized classes that were found
            data.unknownClasses ).join( " " );
        if ( el.tagName.toLowerCase() !== "button" ) {
            el.setAttribute( "role", "button" );
        }
    }

    return this;
};

// buttonMarkup defaults. This must be a complete set, i.e., a value must be
// given here for all recognized options
$.fn.buttonMarkup.defaults = {
    icon: "",
    iconpos: "left",
    theme: null,
    inline: false,
    shadow: true,
    corners: true,
    iconshadow: false, /* TODO: Remove in 1.5. Option deprecated in 1.4. */
    mini: false
};

$.extend( $.fn.buttonMarkup, {
    initSelector: "a:jqmData(role='button'), .ui-bar > a, .ui-bar > :jqmData(role='controlgroup') > a, button:not(:jqmData(role='navbar') button)"
});

})( jQuery );


(function( $, undefined ) {

$.widget( "mobile.controlgroup", $.extend( {
    options: {
        enhanced: false,
        theme: null,
        shadow: false,
        corners: true,
        excludeInvisible: true,
        type: "vertical",
        mini: false
    },

    _create: function() {
        var elem = this.element,
            opts = this.options,
            keepNative = $.mobile.page.prototype.keepNativeSelector();

        // Run buttonmarkup
        if ( $.fn.buttonMarkup ) {
            this.element
                .find( $.fn.buttonMarkup.initSelector )
                .not( keepNative )
                .buttonMarkup();
        }
        // Enhance child widgets
        $.each( this._childWidgets, $.proxy( function( number, widgetName ) {
            if ( $.mobile[ widgetName ] ) {
                this.element
                    .find( $.mobile[ widgetName ].initSelector )
                    .not( keepNative )[ widgetName ]();
            }
        }, this ));

        $.extend( this, {
            _ui: null,
            _initialRefresh: true
        });

        if ( opts.enhanced ) {
            this._ui = {
                groupLegend: elem.children( ".ui-controlgroup-label" ).children(),
                childWrapper: elem.children( ".ui-controlgroup-controls" )
            };
        } else {
            this._ui = this._enhance();
        }

    },

    _childWidgets: [ "checkboxradio", "selectmenu", "button" ],

    _themeClassFromOption: function( value ) {
        return ( value ? ( value === "none" ? "" : "ui-group-theme-" + value ) : "" );
    },

    _enhance: function() {
        var elem = this.element,
            opts = this.options,
            ui = {
                groupLegend: elem.children( "legend" ),
                childWrapper: elem
                    .addClass( "ui-controlgroup " +
                        "ui-controlgroup-" +
                            ( opts.type === "horizontal" ? "horizontal" : "vertical" ) + " " +
                        this._themeClassFromOption( opts.theme ) + " " +
                        ( opts.corners ? "ui-corner-all " : "" ) +
                        ( opts.mini ? "ui-mini " : "" ) )
                    .wrapInner( "<div " +
                        "class='ui-controlgroup-controls " +
                            ( opts.shadow === true ? "ui-shadow" : "" ) + "'></div>" )
                    .children()
            };

        if ( ui.groupLegend.length > 0 ) {
            $( "<div role='heading' class='ui-controlgroup-label'></div>" )
                .append( ui.groupLegend )
                .prependTo( elem );
        }

        return ui;
    },

    _init: function() {
        this.refresh();
    },

    _setOptions: function( options ) {
        var callRefresh, returnValue,
            elem = this.element;

        // Must have one of horizontal or vertical
        if ( options.type !== undefined ) {
            elem
                .removeClass( "ui-controlgroup-horizontal ui-controlgroup-vertical" )
                .addClass( "ui-controlgroup-" + ( options.type === "horizontal" ? "horizontal" : "vertical" ) );
            callRefresh = true;
        }

        if ( options.theme !== undefined ) {
            elem
                .removeClass( this._themeClassFromOption( this.options.theme ) )
                .addClass( this._themeClassFromOption( options.theme ) );
        }

        if ( options.corners !== undefined ) {
            elem.toggleClass( "ui-corner-all", options.corners );
        }

        if ( options.mini !== undefined ) {
            elem.toggleClass( "ui-mini", options.mini );
        }

        if ( options.shadow !== undefined ) {
            this._ui.childWrapper.toggleClass( "ui-shadow", options.shadow );
        }

        if ( options.excludeInvisible !== undefined ) {
            this.options.excludeInvisible = options.excludeInvisible;
            callRefresh = true;
        }

        returnValue = this._super( options );

        if ( callRefresh ) {
            this.refresh();
        }

        return returnValue;
    },

    container: function() {
        return this._ui.childWrapper;
    },

    refresh: function() {
        var $el = this.container(),
            els = $el.find( ".ui-btn" ).not( ".ui-slider-handle" ),
            create = this._initialRefresh;
        if ( $.mobile.checkboxradio ) {
            $el.find( ":mobile-checkboxradio" ).checkboxradio( "refresh" );
        }
        this._addFirstLastClasses( els,
            this.options.excludeInvisible ? this._getVisibles( els, create ) : els,
            create );
        this._initialRefresh = false;
    },

    // Caveat: If the legend is not the first child of the controlgroup at enhance
    // time, it will be after _destroy().
    _destroy: function() {
        var ui, buttons,
            opts = this.options;

        if ( opts.enhanced ) {
            return this;
        }

        ui = this._ui;
        buttons = this.element
            .removeClass( "ui-controlgroup " +
                "ui-controlgroup-horizontal ui-controlgroup-vertical ui-corner-all ui-mini " +
                this._themeClassFromOption( opts.theme ) )
            .find( ".ui-btn" )
            .not( ".ui-slider-handle" );

        this._removeFirstLastClasses( buttons );

        ui.groupLegend.unwrap();
        ui.childWrapper.children().unwrap();
    }
}, $.mobile.behaviors.addFirstLastClasses ) );

})(jQuery);

(function( $, undefined ) {

    $.widget( "mobile.toolbar", {
        initSelector: ":jqmData(role='footer'), :jqmData(role='header')",

        options: {
            theme: null,
            addBackBtn: false,
            backBtnTheme: null,
            backBtnText: "Back"
        },

        _create: function() {
            var leftbtn, rightbtn,
                role =  this.element.is( ":jqmData(role='header')" ) ? "header" : "footer",
                page = this.element.closest( ".ui-page" );
            if ( page.length === 0 ) {
                page = false;
                this._on( this.document, {
                    "pageshow": "refresh"
                });
            }
            $.extend( this, {
                role: role,
                page: page,
                leftbtn: leftbtn,
                rightbtn: rightbtn
            });
            this.element.attr( "role", role === "header" ? "banner" : "contentinfo" ).addClass( "ui-" + role );
            this.refresh();
            this._setOptions( this.options );
        },
        _setOptions: function( o ) {
            if ( o.addBackBtn !== undefined ) {
                this._updateBackButton();
            }
            if ( o.backBtnTheme != null ) {
                this.element
                    .find( ".ui-toolbar-back-btn" )
                    .addClass( "ui-btn ui-btn-" + o.backBtnTheme );
            }
            if ( o.backBtnText !== undefined ) {
                this.element.find( ".ui-toolbar-back-btn .ui-btn-text" ).text( o.backBtnText );
            }
            if ( o.theme !== undefined ) {
                var currentTheme = this.options.theme ? this.options.theme : "inherit",
                    newTheme = o.theme ? o.theme : "inherit";

                this.element.removeClass( "ui-bar-" + currentTheme ).addClass( "ui-bar-" + newTheme );
            }

            this._super( o );
        },
        refresh: function() {
            if ( this.role === "header" ) {
                this._addHeaderButtonClasses();
            }
            if ( !this.page ) {
                this._setRelative();
                if ( this.role === "footer" ) {
                    this.element.appendTo( "body" );
                } else if ( this.role === "header" ) {
                    this._updateBackButton();
                }
            }
            this._addHeadingClasses();
            this._btnMarkup();
        },

        //we only want this to run on non fixed toolbars so make it easy to override
        _setRelative: function() {
            $( "[data-"+ $.mobile.ns + "role='page']" ).css({ "position": "relative" });
        },

        // Deprecated in 1.4. As from 1.5 button classes have to be present in the markup.
        _btnMarkup: function() {
            this.element
                .children( "a" )
                .filter( ":not([data-" + $.mobile.ns + "role='none'])" )
                .attr( "data-" + $.mobile.ns + "role", "button" );
            this.element.trigger( "create" );
        },
        // Deprecated in 1.4. As from 1.5 ui-btn-left/right classes have to be present in the markup.
        _addHeaderButtonClasses: function() {
            var headerAnchors = this.element.children( "a, button" );

            // Do not mistake a back button for a left toolbar button
            this.leftbtn = headerAnchors.hasClass( "ui-btn-left" ) &&
                !headerAnchors.hasClass( "ui-toolbar-back-btn" );

            this.rightbtn = headerAnchors.hasClass( "ui-btn-right" );

            // Filter out right buttons and back buttons
            this.leftbtn = this.leftbtn ||
                headerAnchors.eq( 0 )
                    .not( ".ui-btn-right,.ui-toolbar-back-btn" )
                    .addClass( "ui-btn-left" )
                    .length;

            this.rightbtn = this.rightbtn || headerAnchors.eq( 1 ).addClass( "ui-btn-right" ).length;
        },
        _updateBackButton: function() {
            var backButton,
                options = this.options,
                theme = options.backBtnTheme || options.theme;

            // Retrieve the back button or create a new, empty one
            backButton = this._backButton = ( this._backButton || {} );

            // We add a back button only if the option to do so is on
            if ( this.options.addBackBtn &&

                    // This must also be a header toolbar
                    this.role === "header" &&

                    // There must be multiple pages in the DOM
                    $( ".ui-page" ).length > 1 &&
                    ( this.page ?

                        // If the toolbar is internal the page's URL must differ from the hash
                        ( this.page[ 0 ].getAttribute( "data-" + $.mobile.ns + "url" ) !==
                            $.mobile.path.stripHash( location.hash ) ) :

                        // Otherwise, if the toolbar is external there must be at least one
                        // history item to which one can go back
                        ( $.mobile.navigate && $.mobile.navigate.history &&
                            $.mobile.navigate.history.activeIndex > 0 ) ) &&

                    // The toolbar does not have a left button
                    !this.leftbtn ) {

                // Skip back button creation if one is already present
                if ( !backButton.attached ) {
                    this.backButton = backButton.element = ( backButton.element ||
                        $( "<a role='button' href='javascript:void(0);' " +
                            "class='ui-btn ui-corner-all ui-shadow ui-btn-left " +
                                ( theme ? "ui-btn-" + theme + " " : "" ) +
                                "ui-toolbar-back-btn ui-icon-carat-l ui-btn-icon-left' " +
                            "data-" + $.mobile.ns + "rel='back'>" + options.backBtnText +
                            "</a>" ) )
                            .prependTo( this.element );
                    backButton.attached = true;
                }

            // If we are not adding a back button, then remove the one present, if any
            } else if ( backButton.element ) {
                backButton.element.detach();
                backButton.attached = false;
            }
        },
        _addHeadingClasses: function() {
            this.element.children( "h1, h2, h3, h4, h5, h6" )
                .addClass( "ui-title" )
                // Regardless of h element number in src, it becomes h1 for the enhanced page
                .attr({
                    "role": "heading",
                    "aria-level": "1"
                });
        },
        _destroy: function() {
            var currentTheme;

            this.element.children( "h1, h2, h3, h4, h5, h6" )
                .removeClass( "ui-title" )
                .removeAttr( "role" )
                .removeAttr( "aria-level" );

            if ( this.role === "header" ) {
                this.element.children( "a, button" )
                    .removeClass( "ui-btn-left ui-btn-right ui-btn ui-shadow ui-corner-all" );
                if ( this.backButton) {
                    this.backButton.remove();
                }
            }

            currentTheme = this.options.theme ? this.options.theme : "inherit";
            this.element.removeClass( "ui-bar-" + currentTheme );

            this.element.removeClass( "ui-" + this.role ).removeAttr( "role" );
        }
    });

})( jQuery );

(function( $, undefined ) {

    $.widget( "mobile.toolbar", $.mobile.toolbar, {
        options: {
            position:null,
            visibleOnPageShow: true,
            disablePageZoom: true,
            transition: "slide", //can be none, fade, slide (slide maps to slideup or slidedown)
            fullscreen: false,
            tapToggle: true,
            tapToggleBlacklist: "a, button, input, select, textarea, .ui-header-fixed, .ui-footer-fixed, .ui-flipswitch, .ui-popup, .ui-panel, .ui-panel-dismiss-open",
            hideDuringFocus: "input, textarea, select",
            updatePagePadding: true,
            trackPersistentToolbars: true,

            // Browser detection! Weeee, here we go...
            // Unfortunately, position:fixed is costly, not to mention probably impossible, to feature-detect accurately.
            // Some tests exist, but they currently return false results in critical devices and browsers, which could lead to a broken experience.
            // Testing fixed positioning is also pretty obtrusive to page load, requiring injected elements and scrolling the window
            // The following function serves to rule out some popular browsers with known fixed-positioning issues
            // This is a plugin option like any other, so feel free to improve or overwrite it
            supportBlacklist: function() {
                return !$.support.fixedPosition;
            }
        },

        _create: function() {
            this._super();
            this.pagecontainer = $( ":mobile-pagecontainer" );
            if ( this.options.position === "fixed" && !this.options.supportBlacklist() ) {
                this._makeFixed();
            }
        },

        _makeFixed: function() {
            this.element.addClass( "ui-"+ this.role +"-fixed" );
            this.updatePagePadding();
            this._addTransitionClass();
            this._bindPageEvents();
            this._bindToggleHandlers();
        },

        _setOptions: function( o ) {
            if ( o.position === "fixed" && this.options.position !== "fixed" ) {
                this._makeFixed();
            }
            if ( this.options.position === "fixed" && !this.options.supportBlacklist() ) {
                var $page = ( !!this.page )? this.page: ( $(".ui-page-active").length > 0 )? $(".ui-page-active"): $(".ui-page").eq(0);

                if ( o.fullscreen !== undefined) {
                    if ( o.fullscreen ) {
                        this.element.addClass( "ui-"+ this.role +"-fullscreen" );
                        $page.addClass( "ui-page-" + this.role + "-fullscreen" );
                    }
                    // If not fullscreen, add class to page to set top or bottom padding
                    else {
                        this.element.removeClass( "ui-"+ this.role +"-fullscreen" );
                        $page.removeClass( "ui-page-" + this.role + "-fullscreen" ).addClass( "ui-page-" + this.role+ "-fixed" );
                    }
                }
            }
            this._super(o);
        },

        _addTransitionClass: function() {
            var tclass = this.options.transition;

            if ( tclass && tclass !== "none" ) {
                // use appropriate slide for header or footer
                if ( tclass === "slide" ) {
                    tclass = this.element.hasClass( "ui-header" ) ? "slidedown" : "slideup";
                }

                this.element.addClass( tclass );
            }
        },

        _bindPageEvents: function() {
            var page = ( !!this.page )? this.element.closest( ".ui-page" ): this.document;
            //page event bindings
            // Fixed toolbars require page zoom to be disabled, otherwise usability issues crop up
            // This method is meant to disable zoom while a fixed-positioned toolbar page is visible
            this._on( page , {
                "pagebeforeshow": "_handlePageBeforeShow",
                "webkitAnimationStart":"_handleAnimationStart",
                "animationstart":"_handleAnimationStart",
                "updatelayout": "_handleAnimationStart",
                "pageshow": "_handlePageShow",
                "pagebeforehide": "_handlePageBeforeHide"
            });
        },

        _handlePageBeforeShow: function( ) {
            var o = this.options;
            if ( o.disablePageZoom ) {
                $.mobile.zoom.disable( true );
            }
            if ( !o.visibleOnPageShow ) {
                this.hide( true );
            }
        },

        _handleAnimationStart: function() {
            if ( this.options.updatePagePadding ) {
                this.updatePagePadding( ( !!this.page )? this.page: ".ui-page-active" );
            }
        },

        _handlePageShow: function() {
            this.updatePagePadding( ( !!this.page )? this.page: ".ui-page-active" );
            if ( this.options.updatePagePadding ) {
                this._on( this.window, { "throttledresize": "updatePagePadding" } );
            }
        },

        _handlePageBeforeHide: function( e, ui ) {
            var o = this.options,
                thisFooter, thisHeader, nextFooter, nextHeader;

            if ( o.disablePageZoom ) {
                $.mobile.zoom.enable( true );
            }
            if ( o.updatePagePadding ) {
                this._off( this.window, "throttledresize" );
            }

            if ( o.trackPersistentToolbars ) {
                thisFooter = $( ".ui-footer-fixed:jqmData(id)", this.page );
                thisHeader = $( ".ui-header-fixed:jqmData(id)", this.page );
                nextFooter = thisFooter.length && ui.nextPage && $( ".ui-footer-fixed:jqmData(id='" + thisFooter.jqmData( "id" ) + "')", ui.nextPage ) || $();
                nextHeader = thisHeader.length && ui.nextPage && $( ".ui-header-fixed:jqmData(id='" + thisHeader.jqmData( "id" ) + "')", ui.nextPage ) || $();

                if ( nextFooter.length || nextHeader.length ) {

                    nextFooter.add( nextHeader ).appendTo( $.mobile.pageContainer );

                    ui.nextPage.one( "pageshow", function() {
                        nextHeader.prependTo( this );
                        nextFooter.appendTo( this );
                    });
                }
            }
        },

        _visible: true,

        // This will set the content element's top or bottom padding equal to the toolbar's height
        updatePagePadding: function( tbPage ) {
            var $el = this.element,
                header = ( this.role ==="header" ),
                pos = parseFloat( $el.css( header ? "top" : "bottom" ) );

            // This behavior only applies to "fixed", not "fullscreen"
            if ( this.options.fullscreen ) { return; }
            // tbPage argument can be a Page object or an event, if coming from throttled resize.
            tbPage = ( tbPage && tbPage.type === undefined && tbPage ) || this.page || $el.closest( ".ui-page" );
            tbPage = ( !!this.page )? this.page: ".ui-page-active";
            $( tbPage ).css( "padding-" + ( header ? "top" : "bottom" ), $el.outerHeight() + pos );
        },

        _useTransition: function( notransition ) {
            var $win = this.window,
                $el = this.element,
                scroll = $win.scrollTop(),
                elHeight = $el.height(),
                pHeight = ( !!this.page )? $el.closest( ".ui-page" ).height():$(".ui-page-active").height(),
                viewportHeight = $.mobile.getScreenHeight();

            return !notransition &&
                ( this.options.transition && this.options.transition !== "none" &&
                (
                    ( this.role === "header" && !this.options.fullscreen && scroll > elHeight ) ||
                    ( this.role === "footer" && !this.options.fullscreen && scroll + viewportHeight < pHeight - elHeight )
                ) || this.options.fullscreen
                );
        },

        show: function( notransition ) {
            var hideClass = "ui-fixed-hidden",
                $el = this.element;

            if ( this._useTransition( notransition ) ) {
                $el
                    .removeClass( "out " + hideClass )
                    .addClass( "in" )
                    .animationComplete(function () {
                        $el.removeClass( "in" );
                    });
            }
            else {
                $el.removeClass( hideClass );
            }
            this._visible = true;
        },

        hide: function( notransition ) {
            var hideClass = "ui-fixed-hidden",
                $el = this.element,
                // if it's a slide transition, our new transitions need the reverse class as well to slide outward
                outclass = "out" + ( this.options.transition === "slide" ? " reverse" : "" );

            if ( this._useTransition( notransition ) ) {
                $el
                    .addClass( outclass )
                    .removeClass( "in" )
                    .animationComplete(function() {
                        $el.addClass( hideClass ).removeClass( outclass );
                    });
            }
            else {
                $el.addClass( hideClass ).removeClass( outclass );
            }
            this._visible = false;
        },

        toggle: function() {
            this[ this._visible ? "hide" : "show" ]();
        },

        _bindToggleHandlers: function() {
            var self = this,
                o = self.options,
                delayShow, delayHide,
                isVisible = true,
                page = ( !!this.page )? this.page: $(".ui-page");

            // tap toggle
            page
                .bind( "vclick", function( e ) {
                    if ( o.tapToggle && !$( e.target ).closest( o.tapToggleBlacklist ).length ) {
                        self.toggle();
                    }
                })
                .bind( "focusin focusout", function( e ) {
                    //this hides the toolbars on a keyboard pop to give more screen room and prevent ios bug which
                    //positions fixed toolbars in the middle of the screen on pop if the input is near the top or
                    //bottom of the screen addresses issues #4410 Footer navbar moves up when clicking on a textbox in an Android environment
                    //and issue #4113 Header and footer change their position after keyboard popup - iOS
                    //and issue #4410 Footer navbar moves up when clicking on a textbox in an Android environment
                    if ( screen.width < 1025 && $( e.target ).is( o.hideDuringFocus ) && !$( e.target ).closest( ".ui-header-fixed, .ui-footer-fixed" ).length ) {
                        //Fix for issue #4724 Moving through form in Mobile Safari with "Next" and "Previous" system
                        //controls causes fixed position, tap-toggle false Header to reveal itself
                        // isVisible instead of self._visible because the focusin and focusout events fire twice at the same time
                        // Also use a delay for hiding the toolbars because on Android native browser focusin is direclty followed
                        // by a focusout when a native selects opens and the other way around when it closes.
                        if ( e.type === "focusout" && !isVisible ) {
                            isVisible = true;
                            //wait for the stack to unwind and see if we have jumped to another input
                            clearTimeout( delayHide );
                            delayShow = setTimeout( function() {
                                self.show();
                            }, 0 );
                        } else if ( e.type === "focusin" && !!isVisible ) {
                            //if we have jumped to another input clear the time out to cancel the show.
                            clearTimeout( delayShow );
                            isVisible = false;
                            delayHide = setTimeout( function() {
                                self.hide();
                            }, 0 );
                        }
                    }
                });
        },

        _setRelative: function() {
            if( this.options.position !== "fixed" ){
                $( "[data-"+ $.mobile.ns + "role='page']" ).css({ "position": "relative" });
            }
        },

        _destroy: function() {
            var pageClasses, toolbarClasses, hasFixed, header, hasFullscreen,
                page = this.pagecontainer.pagecontainer( "getActivePage" );

            this._super();
            if ( this.options.position === "fixed" ) {
                hasFixed = $(  "body>.ui-" + this.role + "-fixed" )
                            .add( page.find( ".ui-" + this.options.role + "-fixed" ) )
                            .not( this.element ).length > 0;
                hasFullscreen = $(  "body>.ui-" + this.role + "-fixed" )
                            .add( page.find( ".ui-" + this.options.role + "-fullscreen" ) )
                            .not( this.element ).length > 0;
                toolbarClasses =  "ui-header-fixed ui-footer-fixed ui-header-fullscreen in out" +
                    " ui-footer-fullscreen fade slidedown slideup ui-fixed-hidden";
                this.element.removeClass( toolbarClasses );
                if ( !hasFullscreen ) {
                    pageClasses = "ui-page-" + this.role + "-fullscreen";
                }
                if ( !hasFixed ) {
                    header = this.role === "header";
                    pageClasses += " ui-page-" + this.role + "-fixed";
                    page.css( "padding-" + ( header ? "top" : "bottom" ), "" );
                }
                page.removeClass( pageClasses );
            }
        }

    });
})( jQuery );

(function( $, undefined ) {
    $.widget( "mobile.toolbar", $.mobile.toolbar, {

        _makeFixed: function() {
            this._super();
            this._workarounds();
        },

        //check the browser and version and run needed workarounds
        _workarounds: function() {
            var ua = navigator.userAgent,
            platform = navigator.platform,
            // Rendering engine is Webkit, and capture major version
            wkmatch = ua.match( /AppleWebKit\/([0-9]+)/ ),
            wkversion = !!wkmatch && wkmatch[ 1 ],
            os = null,
            self = this;
            //set the os we are working in if it dosent match one with workarounds return
            if ( platform.indexOf( "iPhone" ) > -1 || platform.indexOf( "iPad" ) > -1  || platform.indexOf( "iPod" ) > -1 ) {
                os = "ios";
            } else if ( ua.indexOf( "Android" ) > -1 ) {
                os = "android";
            } else {
                return;
            }
            //check os version if it dosent match one with workarounds return
            if ( os === "ios" ) {
                //iOS  workarounds
                self._bindScrollWorkaround();
            } else if ( os === "android" && wkversion && wkversion < 534 ) {
                //Android 2.3 run all Android 2.3 workaround
                self._bindScrollWorkaround();
                self._bindListThumbWorkaround();
            } else {
                return;
            }
        },

        //Utility class for checking header and footer positions relative to viewport
        _viewportOffset: function() {
            var $el = this.element,
                header = $el.hasClass( "ui-header" ),
                offset = Math.abs( $el.offset().top - this.window.scrollTop() );
            if ( !header ) {
                offset = Math.round( offset - this.window.height() + $el.outerHeight() ) - 60;
            }
            return offset;
        },

        //bind events for _triggerRedraw() function
        _bindScrollWorkaround: function() {
            var self = this;
            //bind to scrollstop and check if the toolbars are correctly positioned
            this._on( this.window, { scrollstop: function() {
                var viewportOffset = self._viewportOffset();
                //check if the header is visible and if its in the right place
                if ( viewportOffset > 2 && self._visible ) {
                    self._triggerRedraw();
                }
            }});
        },

        //this addresses issue #4250 Persistent footer instability in v1.1 with long select lists in Android 2.3.3
        //and issue #3748 Android 2.x: Page transitions broken when fixed toolbars used
        //the absolutely positioned thumbnail in a list view causes problems with fixed position buttons above in a nav bar
        //setting the li's to -webkit-transform:translate3d(0,0,0); solves this problem to avoide potential issues in other
        //platforms we scope this with the class ui-android-2x-fix
        _bindListThumbWorkaround: function() {
            this.element.closest( ".ui-page" ).addClass( "ui-android-2x-fixed" );
        },
        //this addresses issues #4337 Fixed header problem after scrolling content on iOS and Android
        //and device bugs project issue #1 Form elements can lose click hit area in position: fixed containers.
        //this also addresses not on fixed toolbars page in docs
        //adding 1px of padding to the bottom then removing it causes a "redraw"
        //which positions the toolbars correctly (they will always be visually correct)
        _triggerRedraw: function() {
            var paddingBottom = parseFloat( $( ".ui-page-active" ).css( "padding-bottom" ) );
            //trigger page redraw to fix incorrectly positioned fixed elements
            $( ".ui-page-active" ).css( "padding-bottom", ( paddingBottom + 1 ) + "px" );
            //if the padding is reset with out a timeout the reposition will not occure.
            //this is independant of JQM the browser seems to need the time to react.
            setTimeout( function() {
                $( ".ui-page-active" ).css( "padding-bottom", paddingBottom + "px" );
            }, 0 );
        },

        destroy: function() {
            this._super();
            //Remove the class we added to the page previously in android 2.x
            this.element.closest( ".ui-page-active" ).removeClass( "ui-android-2x-fix" );
        }
    });

})( jQuery );


( function( $, undefined ) {

var ieHack = ( $.mobile.browser.oldIE && $.mobile.browser.oldIE <= 8 ),
    uiTemplate = $(
        "<div class='ui-popup-arrow-guide'></div>" +
        "<div class='ui-popup-arrow-container" + ( ieHack ? " ie" : "" ) + "'>" +
            "<div class='ui-popup-arrow'></div>" +
        "</div>"
    );

function getArrow() {
    var clone = uiTemplate.clone(),
        gd = clone.eq( 0 ),
        ct = clone.eq( 1 ),
        ar = ct.children();

    return { arEls: ct.add( gd ), gd: gd, ct: ct, ar: ar };
}

$.widget( "mobile.popup", $.mobile.popup, {
    options: {

        arrow: ""
    },

    _create: function() {
        var ar,
            ret = this._super();

        if ( this.options.arrow ) {
            this._ui.arrow = ar = this._addArrow();
        }

        return ret;
    },

    _addArrow: function() {
        var theme,
            opts = this.options,
            ar = getArrow();

        theme = this._themeClassFromOption( "ui-body-", opts.theme );
        ar.ar.addClass( theme + ( opts.shadow ? " ui-overlay-shadow" : "" ) );
        ar.arEls.hide().appendTo( this.element );

        return ar;
    },

    _unenhance: function() {
        var ar = this._ui.arrow;

        if ( ar ) {
            ar.arEls.remove();
        }

        return this._super();
    },

    // Pretend to show an arrow described by @p and @dir and calculate the
    // distance from the desired point. If a best-distance is passed in, return
    // the minimum of the one passed in and the one calculated.
    _tryAnArrow: function( p, dir, desired, s, best ) {
        var result, r, diff, desiredForArrow = {}, tip = {};

        // If the arrow has no wiggle room along the edge of the popup, it cannot
        // be displayed along the requested edge without it sticking out.
        if ( s.arFull[ p.dimKey ] > s.guideDims[ p.dimKey ] ) {
            return best;
        }

        desiredForArrow[ p.fst ] = desired[ p.fst ] +
            ( s.arHalf[ p.oDimKey ] + s.menuHalf[ p.oDimKey ] ) * p.offsetFactor -
            s.contentBox[ p.fst ] + ( s.clampInfo.menuSize[ p.oDimKey ] - s.contentBox[ p.oDimKey ] ) * p.arrowOffsetFactor;
        desiredForArrow[ p.snd ] = desired[ p.snd ];

        result = s.result || this._calculateFinalLocation( desiredForArrow, s.clampInfo );
        r = { x: result.left, y: result.top };

        tip[ p.fst ] = r[ p.fst ] + s.contentBox[ p.fst ] + p.tipOffset;
        tip[ p.snd ] = Math.max( result[ p.prop ] + s.guideOffset[ p.prop ] + s.arHalf[ p.dimKey ],
            Math.min( result[ p.prop ] + s.guideOffset[ p.prop ] + s.guideDims[ p.dimKey ] - s.arHalf[ p.dimKey ],
                desired[ p.snd ] ) );

        diff = Math.abs( desired.x - tip.x ) + Math.abs( desired.y - tip.y );
        if ( !best || diff < best.diff ) {
            // Convert tip offset to coordinates inside the popup
            tip[ p.snd ] -= s.arHalf[ p.dimKey ] + result[ p.prop ] + s.contentBox[ p.snd ];
            best = { dir: dir, diff: diff, result: result, posProp: p.prop, posVal: tip[ p.snd ] };
        }

        return best;
    },

    _getPlacementState: function( clamp ) {
        var offset, gdOffset,
            ar = this._ui.arrow,
            state = {
                clampInfo: this._clampPopupWidth( !clamp ),
                arFull: { cx: ar.ct.width(), cy: ar.ct.height() },
                guideDims: { cx: ar.gd.width(), cy: ar.gd.height() },
                guideOffset: ar.gd.offset()
            };

        offset = this.element.offset();

        ar.gd.css( { left: 0, top: 0, right: 0, bottom: 0 } );
        gdOffset = ar.gd.offset();
        state.contentBox = {
            x: gdOffset.left - offset.left,
            y: gdOffset.top - offset.top,
            cx: ar.gd.width(),
            cy: ar.gd.height()
        };
        ar.gd.removeAttr( "style" );

        // The arrow box moves between guideOffset and guideOffset + guideDims - arFull
        state.guideOffset = { left: state.guideOffset.left - offset.left, top: state.guideOffset.top - offset.top };
        state.arHalf = { cx: state.arFull.cx / 2, cy: state.arFull.cy / 2 };
        state.menuHalf = { cx: state.clampInfo.menuSize.cx / 2, cy: state.clampInfo.menuSize.cy / 2 };

        return state;
    },

    _placementCoords: function( desired ) {
        var state, best, params, elOffset, bgRef,
            optionValue = this.options.arrow,
            ar = this._ui.arrow;

        if ( !ar ) {
            return this._super( desired );
        }

        ar.arEls.show();

        bgRef = {};
        state = this._getPlacementState( true );
        params = {
            "l": { fst: "x", snd: "y", prop: "top", dimKey: "cy", oDimKey: "cx", offsetFactor: 1, tipOffset:  -state.arHalf.cx, arrowOffsetFactor: 0 },
            "r": { fst: "x", snd: "y", prop: "top", dimKey: "cy", oDimKey: "cx", offsetFactor: -1, tipOffset: state.arHalf.cx + state.contentBox.cx, arrowOffsetFactor: 1 },
            "b": { fst: "y", snd: "x", prop: "left", dimKey: "cx", oDimKey: "cy", offsetFactor: -1, tipOffset: state.arHalf.cy + state.contentBox.cy, arrowOffsetFactor: 1 },
            "t": { fst: "y", snd: "x", prop: "left", dimKey: "cx", oDimKey: "cy", offsetFactor: 1, tipOffset: -state.arHalf.cy, arrowOffsetFactor: 0 }
        };

        // Try each side specified in the options to see on which one the arrow
        // should be placed such that the distance between the tip of the arrow and
        // the desired coordinates is the shortest.
        $.each( ( optionValue === true ? "l,t,r,b" : optionValue ).split( "," ),
            $.proxy( function( key, value ) {
                best = this._tryAnArrow( params[ value ], value, desired, state, best );
            }, this ) );

        // Could not place the arrow along any of the edges - behave as if showing
        // the arrow was turned off.
        if ( !best ) {
            ar.arEls.hide();
            return this._super( desired );
        }

        // Move the arrow into place
        ar.ct
            .removeClass( "ui-popup-arrow-l ui-popup-arrow-t ui-popup-arrow-r ui-popup-arrow-b" )
            .addClass( "ui-popup-arrow-" + best.dir )
            .removeAttr( "style" ).css( best.posProp, best.posVal )
            .show();

        // Do not move/size the background div on IE, because we use the arrow div for background as well.
        if ( !ieHack ) {
            elOffset = this.element.offset();
            bgRef[ params[ best.dir ].fst ] = ar.ct.offset();
            bgRef[ params[ best.dir ].snd ] = {
                left: elOffset.left + state.contentBox.x,
                top: elOffset.top + state.contentBox.y
            };
        }

        return best.result;
    },

    _setOptions: function( opts ) {
        var newTheme,
            oldTheme = this.options.theme,
            ar = this._ui.arrow,
            ret = this._super( opts );

        if ( opts.arrow !== undefined ) {
            if ( !ar && opts.arrow ) {
                this._ui.arrow = this._addArrow();

                // Important to return here so we don't set the same options all over
                // again below.
                return;
            } else if ( ar && !opts.arrow ) {
                ar.arEls.remove();
                this._ui.arrow = null;
            }
        }

        // Reassign with potentially new arrow
        ar = this._ui.arrow;

        if ( ar ) {
            if ( opts.theme !== undefined ) {
                oldTheme = this._themeClassFromOption( "ui-body-", oldTheme );
                newTheme = this._themeClassFromOption( "ui-body-", opts.theme );
                ar.ar.removeClass( oldTheme ).addClass( newTheme );
            }

            if ( opts.shadow !== undefined ) {
                ar.ar.toggleClass( "ui-overlay-shadow", opts.shadow );
            }
        }

        return ret;
    },

    _destroy: function() {
        var ar = this._ui.arrow;

        if ( ar ) {
            ar.arEls.remove();
        }

        return this._super();
    }
});

})( jQuery );


(function( $, undefined ) {

$.widget( "mobile.panel", {
    options: {
        classes: {
            panel: "ui-panel",
            panelOpen: "ui-panel-open",
            panelClosed: "ui-panel-closed",
            panelFixed: "ui-panel-fixed",
            panelInner: "ui-panel-inner",
            modal: "ui-panel-dismiss",
            modalOpen: "ui-panel-dismiss-open",
            pageContainer: "ui-panel-page-container",
            pageWrapper: "ui-panel-wrapper",
            pageFixedToolbar: "ui-panel-fixed-toolbar",
            pageContentPrefix: "ui-panel-page-content", /* Used for wrapper and fixed toolbars position, display and open classes. */
            animate: "ui-panel-animate"
        },
        animate: true,
        theme: null,
        position: "left",
        dismissible: true,
        display: "reveal", //accepts reveal, push, overlay
        swipeClose: true,
        positionFixed: false
    },

    _closeLink: null,
    _parentPage: null,
    _page: null,
    _modal: null,
    _panelInner: null,
    _wrapper: null,
    _fixedToolbars: null,

    _create: function() {
        var el = this.element,
            parentPage = el.closest( ".ui-page, :jqmData(role='page')" );

        // expose some private props to other methods
        $.extend( this, {
            _closeLink: el.find( ":jqmData(rel='close')" ),
            _parentPage: ( parentPage.length > 0 ) ? parentPage : false,
            _openedPage: null,
            _page: this._getPage,
            _panelInner: this._getPanelInner(),
            _fixedToolbars: this._getFixedToolbars
        });
        if ( this.options.display !== "overlay" ){
            this._getWrapper();
        }
        this._addPanelClasses();

        // if animating, add the class to do so
        if ( $.support.cssTransform3d && !!this.options.animate ) {
            this.element.addClass( this.options.classes.animate );
        }

        this._bindUpdateLayout();
        this._bindCloseEvents();
        this._bindLinkListeners();
        this._bindPageEvents();

        if ( !!this.options.dismissible ) {
            this._createModal();
        }

        this._bindSwipeEvents();
    },

    _getPanelInner: function() {
        var panelInner = this.element.find( "." + this.options.classes.panelInner );

        if ( panelInner.length === 0 ) {
            panelInner = this.element.children().wrapAll( "<div class='" + this.options.classes.panelInner + "' />" ).parent();
        }

        return panelInner;
    },

    _createModal: function() {
        var self = this,
            target = self._parentPage ? self._parentPage.parent() : self.element.parent();

        self._modal = $( "<div class='" + self.options.classes.modal + "'></div>" )
            .on( "mousedown", function() {
                self.close();
            })
            .appendTo( target );
    },

    _getPage: function() {
        var page = this._openedPage || this._parentPage || $( "." + $.mobile.activePageClass );

        return page;
    },

    _getWrapper: function() {
        var wrapper = this._page().find( "." + this.options.classes.pageWrapper );
        if ( wrapper.length === 0 ) {
            wrapper = this._page().children( ".ui-header:not(.ui-header-fixed), .ui-content:not(.ui-popup), .ui-footer:not(.ui-footer-fixed)" )
                .wrapAll( "<div class='" + this.options.classes.pageWrapper + "'></div>" )
                .parent();
        }

        this._wrapper = wrapper;
    },

    _getFixedToolbars: function() {
        var extFixedToolbars = $( "body" ).children( ".ui-header-fixed, .ui-footer-fixed" ),
            intFixedToolbars = this._page().find( ".ui-header-fixed, .ui-footer-fixed" ),
            fixedToolbars = extFixedToolbars.add( intFixedToolbars ).addClass( this.options.classes.pageFixedToolbar );

        return fixedToolbars;
    },

    _getPosDisplayClasses: function( prefix ) {
        return prefix + "-position-" + this.options.position + " " + prefix + "-display-" + this.options.display;
    },

    _getPanelClasses: function() {
        var panelClasses = this.options.classes.panel +
            " " + this._getPosDisplayClasses( this.options.classes.panel ) +
            " " + this.options.classes.panelClosed +
            " " + "ui-body-" + ( this.options.theme ? this.options.theme : "inherit" );

        if ( !!this.options.positionFixed ) {
            panelClasses += " " + this.options.classes.panelFixed;
        }

        return panelClasses;
    },

    _addPanelClasses: function() {
        this.element.addClass( this._getPanelClasses() );
    },

    _handleCloseClick: function( event ) {
        if ( !event.isDefaultPrevented() ) {
            this.close();
        }
    },

    _bindCloseEvents: function() {
        this._on( this._closeLink, {
            "click": "_handleCloseClick"
        });

        this._on({
            "click a:jqmData(ajax='false')": "_handleCloseClick"
        });
    },

    _positionPanel: function( scrollToTop ) {
        var self = this,
            panelInnerHeight = self._panelInner.outerHeight(),
            expand = panelInnerHeight > $.mobile.getScreenHeight();

        if ( expand || !self.options.positionFixed ) {
            if ( expand ) {
                self._unfixPanel();
                $.mobile.resetActivePageHeight( panelInnerHeight );
            }
            if ( scrollToTop ) {
                this.window[ 0 ].scrollTo( 0, $.mobile.defaultHomeScroll );
            }
        } else {
            self._fixPanel();
        }
    },

    _bindFixListener: function() {
        this._on( $( window ), { "throttledresize": "_positionPanel" });
    },

    _unbindFixListener: function() {
        this._off( $( window ), "throttledresize" );
    },

    _unfixPanel: function() {
        if ( !!this.options.positionFixed && $.support.fixedPosition ) {
            this.element.removeClass( this.options.classes.panelFixed );
        }
    },

    _fixPanel: function() {
        if ( !!this.options.positionFixed && $.support.fixedPosition ) {
            this.element.addClass( this.options.classes.panelFixed );
        }
    },

    _bindUpdateLayout: function() {
        var self = this;

        self.element.on( "updatelayout", function(/* e */) {
            if ( self._open ) {
                self._positionPanel();
            }
        });
    },

    _bindLinkListeners: function() {
        this._on( "body", {
            "click a": "_handleClick"
        });

    },

    _handleClick: function( e ) {
        var link,
            panelId = this.element.attr( "id" );

        if ( e.currentTarget.href.split( "#" )[ 1 ] === panelId && panelId !== undefined ) {

            e.preventDefault();
            link = $( e.target );
            if ( link.hasClass( "ui-btn" ) ) {
                link.addClass( $.mobile.activeBtnClass );
                this.element.one( "panelopen panelclose", function() {
                    link.removeClass( $.mobile.activeBtnClass );
                });
            }
            this.toggle();
        }
    },

    _bindSwipeEvents: function() {
        var self = this,
            area = self._modal ? self.element.add( self._modal ) : self.element;

        // on swipe, close the panel
        if ( !!self.options.swipeClose ) {
            if ( self.options.position === "left" ) {
                area.on( "swipeleft.panel", function(/* e */) {
                    self.close();
                });
            } else {
                area.on( "swiperight.panel", function(/* e */) {
                    self.close();
                });
            }
        }
    },

    _bindPageEvents: function() {
        var self = this;

        this.document
            // Close the panel if another panel on the page opens
            .on( "panelbeforeopen", function( e ) {
                if ( self._open && e.target !== self.element[ 0 ] ) {
                    self.close();
                }
            })
            // On escape, close? might need to have a target check too...
            .on( "keyup.panel", function( e ) {
                if ( e.keyCode === 27 && self._open ) {
                    self.close();
                }
            });
        if ( !this._parentPage && this.options.display !== "overlay" ) {
            this._on( this.document, {
                "pageshow": function() {
                    this._openedPage = null;
                    this._getWrapper();
                }
            });
        }
        // Clean up open panels after page hide
        if ( self._parentPage ) {
            this.document.on( "pagehide", ":jqmData(role='page')", function() {
                if ( self._open ) {
                    self.close( true );
                }
            });
        } else {
            this.document.on( "pagebeforehide", function() {
                if ( self._open ) {
                    self.close( true );
                }
            });
        }
    },

    // state storage of open or closed
    _open: false,
    _pageContentOpenClasses: null,
    _modalOpenClasses: null,

    open: function( immediate ) {
        if ( !this._open ) {
            var self = this,
                o = self.options,

                _openPanel = function() {
                    self._off( self.document , "panelclose" );
                    self._page().jqmData( "panel", "open" );

                    if ( $.support.cssTransform3d && !!o.animate && o.display !== "overlay" ) {
                        self._wrapper.addClass( o.classes.animate );
                        self._fixedToolbars().addClass( o.classes.animate );
                    }

                    if ( !immediate && $.support.cssTransform3d && !!o.animate ) {
                        ( self._wrapper || self.element )
                            .animationComplete( complete, "transition" );
                    } else {
                        setTimeout( complete, 0 );
                    }

                    if ( o.theme && o.display !== "overlay" ) {
                        self._page().parent()
                            .addClass( o.classes.pageContainer + "-themed " + o.classes.pageContainer + "-" + o.theme );
                    }

                    self.element
                        .removeClass( o.classes.panelClosed )
                        .addClass( o.classes.panelOpen );

                    self._positionPanel( true );

                    self._pageContentOpenClasses = self._getPosDisplayClasses( o.classes.pageContentPrefix );

                    if ( o.display !== "overlay" ) {
                        self._page().parent().addClass( o.classes.pageContainer );
                        self._wrapper.addClass( self._pageContentOpenClasses );
                        self._fixedToolbars().addClass( self._pageContentOpenClasses );
                    }

                    self._modalOpenClasses = self._getPosDisplayClasses( o.classes.modal ) + " " + o.classes.modalOpen;
                    if ( self._modal ) {
                        self._modal
                            .addClass( self._modalOpenClasses )
                            .height( Math.max( self._modal.height(), self.document.height() ) );
                    }
                },
                complete = function() {

                    // Bail if the panel was closed before the opening animation has completed
                    if ( !self._open ) {
                        return;
                    }

                    if ( o.display !== "overlay" ) {
                        self._wrapper.addClass( o.classes.pageContentPrefix + "-open" );
                        self._fixedToolbars().addClass( o.classes.pageContentPrefix + "-open" );
                    }

                    self._bindFixListener();

                    self._trigger( "open" );

                    self._openedPage = self._page();
                };

            self._trigger( "beforeopen" );

            if ( self._page().jqmData( "panel" ) === "open" ) {
                self._on( self.document, {
                    "panelclose": _openPanel
                });
            } else {
                _openPanel();
            }

            self._open = true;
        }
    },

    close: function( immediate ) {
        if ( this._open ) {
            var self = this,
                o = this.options,

                _closePanel = function() {

                    self.element.removeClass( o.classes.panelOpen );

                    if ( o.display !== "overlay" ) {
                        self._wrapper.removeClass( self._pageContentOpenClasses );
                        self._fixedToolbars().removeClass( self._pageContentOpenClasses );
                    }

                    if ( !immediate && $.support.cssTransform3d && !!o.animate ) {
                        ( self._wrapper || self.element )
                            .animationComplete( complete, "transition" );
                    } else {
                        setTimeout( complete, 0 );
                    }

                    if ( self._modal ) {
                        self._modal
                            .removeClass( self._modalOpenClasses )
                            .height( "" );
                    }
                },
                complete = function() {
                    if ( o.theme && o.display !== "overlay" ) {
                        self._page().parent().removeClass( o.classes.pageContainer + "-themed " + o.classes.pageContainer + "-" + o.theme );
                    }

                    self.element.addClass( o.classes.panelClosed );

                    if ( o.display !== "overlay" ) {
                        self._page().parent().removeClass( o.classes.pageContainer );
                        self._wrapper.removeClass( o.classes.pageContentPrefix + "-open" );
                        self._fixedToolbars().removeClass( o.classes.pageContentPrefix + "-open" );
                    }

                    if ( $.support.cssTransform3d && !!o.animate && o.display !== "overlay" ) {
                        self._wrapper.removeClass( o.classes.animate );
                        self._fixedToolbars().removeClass( o.classes.animate );
                    }

                    self._fixPanel();
                    self._unbindFixListener();
                    $.mobile.resetActivePageHeight();

                    self._page().jqmRemoveData( "panel" );

                    self._trigger( "close" );

                    self._openedPage = null;
                };

            self._trigger( "beforeclose" );

            _closePanel();

            self._open = false;
        }
    },

    toggle: function() {
        this[ this._open ? "close" : "open" ]();
    },

    _destroy: function() {
        var otherPanels,
        o = this.options,
        multiplePanels = ( $( "body > :mobile-panel" ).length + $.mobile.activePage.find( ":mobile-panel" ).length ) > 1;

        if ( o.display !== "overlay" ) {

            //  remove the wrapper if not in use by another panel
            otherPanels = $( "body > :mobile-panel" ).add( $.mobile.activePage.find( ":mobile-panel" ) );
            if ( otherPanels.not( ".ui-panel-display-overlay" ).not( this.element ).length === 0 ) {
                this._wrapper.children().unwrap();
            }

            if ( this._open ) {

                this._fixedToolbars().removeClass( o.classes.pageContentPrefix + "-open" );

                if ( $.support.cssTransform3d && !!o.animate ) {
                    this._fixedToolbars().removeClass( o.classes.animate );
                }

                this._page().parent().removeClass( o.classes.pageContainer );

                if ( o.theme ) {
                    this._page().parent().removeClass( o.classes.pageContainer + "-themed " + o.classes.pageContainer + "-" + o.theme );
                }
            }
        }

        if ( !multiplePanels ) {

            this.document.off( "panelopen panelclose" );

        }

        if ( this._open ) {
            this._page().jqmRemoveData( "panel" );
        }

        this._panelInner.children().unwrap();

        this.element
            .removeClass( [ this._getPanelClasses(), o.classes.panelOpen, o.classes.animate ].join( " " ) )
            .off( "swipeleft.panel swiperight.panel" )
            .off( "panelbeforeopen" )
            .off( "panelhide" )
            .off( "keyup.panel" )
            .off( "updatelayout" );

        if ( this._modal ) {
            this._modal.remove();
        }
    }
});

})( jQuery );

(function( $, undefined ) {

$.widget( "mobile.table", {
    options: {
        classes: {
            table: "ui-table"
        },
        enhanced: false
    },

    _create: function() {
        if ( !this.options.enhanced ) {
            this.element.addClass( this.options.classes.table );
        }

        // extend here, assign on refresh > _setHeaders
        $.extend( this, {

            // Expose headers and allHeaders properties on the widget
            // headers references the THs within the first TR in the table
            headers: undefined,

            // allHeaders references headers, plus all THs in the thead, which may
            // include several rows, or not
            allHeaders: undefined
        });

        this._refresh( true );
    },

    _setHeaders: function() {
        var trs = this.element.find( "thead tr" );

        this.headers = this.element.find( "tr:eq(0)" ).children();
        this.allHeaders = this.headers.add( trs.children() );
    },

    refresh: function() {
        this._refresh();
    },

    rebuild: $.noop,

    _refresh: function( /* create */ ) {
        var table = this.element,
            trs = table.find( "thead tr" );

        // updating headers on refresh (fixes #5880)
        this._setHeaders();

        // Iterate over the trs
        trs.each( function() {
            var columnCount = 0;

            // Iterate over the children of the tr
            $( this ).children().each( function() {
                var span = parseInt( this.getAttribute( "colspan" ), 10 ),
                    selector = ":nth-child(" + ( columnCount + 1 ) + ")",
                    j;

                this.setAttribute( "data-" + $.mobile.ns + "colstart", columnCount + 1 );

                if ( span ) {
                    for( j = 0; j < span - 1; j++ ) {
                        columnCount++;
                        selector += ", :nth-child(" + ( columnCount + 1 ) + ")";
                    }
                }

                // Store "cells" data on header as a reference to all cells in the
                // same column as this TH
                $( this ).jqmData( "cells", table.find( "tr" ).not( trs.eq( 0 ) ).not( this ).children( selector ) );

                columnCount++;
            });
        });
    }
});

})( jQuery );


(function( $, undefined ) {

$.widget( "mobile.table", $.mobile.table, {
    options: {
        mode: "columntoggle",
        columnBtnTheme: null,
        columnPopupTheme: null,
        columnBtnText: "Columns...",
        classes: $.extend( $.mobile.table.prototype.options.classes, {
            popup: "ui-table-columntoggle-popup",
            columnBtn: "ui-table-columntoggle-btn",
            priorityPrefix: "ui-table-priority-",
            columnToggleTable: "ui-table-columntoggle"
        })
    },

    _create: function() {
        this._super();

        if ( this.options.mode !== "columntoggle" ) {
            return;
        }

        $.extend( this, {
            _menu: null
        });

        if ( this.options.enhanced ) {
            this._menu = $( this.document[ 0 ].getElementById( this._id() + "-popup" ) ).children().first();
            this._addToggles( this._menu, true );
        } else {
            this._menu = this._enhanceColToggle();
            this.element.addClass( this.options.classes.columnToggleTable );
        }

        this._setupEvents();

        this._setToggleState();
    },

    _id: function() {
        return ( this.element.attr( "id" ) || ( this.widgetName + this.uuid ) );
    },

    _setupEvents: function() {
        //NOTE: inputs are bound in bindToggles,
        // so it can be called on refresh, too

        // update column toggles on resize
        this._on( this.window, {
            throttledresize: "_setToggleState"
        });
        this._on( this._menu, {
            "change input": "_menuInputChange"
        });
    },

    _addToggles: function( menu, keep ) {
        var inputs,
            checkboxIndex = 0,
            opts = this.options,
            container = menu.controlgroup( "container" );

        // allow update of menu on refresh (fixes #5880)
        if ( keep ) {
            inputs = menu.find( "input" );
        } else {
            container.empty();
        }

        // create the hide/show toggles
        this.headers.not( "td" ).each( function() {
            var input, cells,
                header = $( this ),
                priority = $.mobile.getAttribute( this, "priority" );

            if ( priority ) {
                cells = header.add( header.jqmData( "cells" ) );
                cells.addClass( opts.classes.priorityPrefix + priority );

                // Make sure the (new?) checkbox is associated with its header via .jqmData() and
                // that, vice versa, the header is also associated with the checkbox
                input = ( keep ? inputs.eq( checkboxIndex++ ) :
                    $("<label><input type='checkbox' checked />" +
                        ( header.children( "abbr" ).first().attr( "title" ) ||
                            header.text() ) +
                        "</label>" )
                        .appendTo( container )
                        .children( 0 )
                        .checkboxradio( {
                            theme: opts.columnPopupTheme
                        }) )

                        // Associate the header with the checkbox
                        .jqmData( "header", header )
                        .jqmData( "cells", cells );

                // Associate the checkbox with the header
                header.jqmData( "input", input );
            }
        });

        // set bindings here
        if ( !keep ) {
            menu.controlgroup( "refresh" );
        }
    },

    _menuInputChange: function( evt ) {
        var input = $( evt.target ),
            checked = input[ 0 ].checked;

        input.jqmData( "cells" )
            .toggleClass( "ui-table-cell-hidden", !checked )
            .toggleClass( "ui-table-cell-visible", checked );
    },

    _unlockCells: function( cells ) {
        // allow hide/show via CSS only = remove all toggle-locks
        cells.removeClass( "ui-table-cell-hidden ui-table-cell-visible");
    },

    _enhanceColToggle: function() {
        var id , menuButton, popup, menu,
            table = this.element,
            opts = this.options,
            ns = $.mobile.ns,
            fragment = this.document[ 0 ].createDocumentFragment();

        id = this._id() + "-popup";
        menuButton = $( "<a href='#" + id + "' " +
            "class='" + opts.classes.columnBtn + " ui-btn " +
            "ui-btn-" + ( opts.columnBtnTheme || "a" ) +
            " ui-corner-all ui-shadow ui-mini' " +
            "data-" + ns + "rel='popup'>" + opts.columnBtnText + "</a>" );
        popup = $( "<div class='" + opts.classes.popup + "' id='" + id + "'></div>" );
        menu = $( "<fieldset></fieldset>" ).controlgroup();

        // set extension here, send "false" to trigger build/rebuild
        this._addToggles( menu, false );

        menu.appendTo( popup );

        fragment.appendChild( popup[ 0 ] );
        fragment.appendChild( menuButton[ 0 ] );
        table.before( fragment );

        popup.popup();

        return menu;
    },

    rebuild: function() {
        this._super();

        if ( this.options.mode === "columntoggle" ) {
            // NOTE: rebuild passes "false", while refresh passes "undefined"
            // both refresh the table, but inside addToggles, !false will be true,
            // so a rebuild call can be indentified
            this._refresh( false );
        }
    },

    _refresh: function( create ) {
        var headers, hiddenColumns, index;

        // Calling _super() here updates this.headers
        this._super( create );

        if ( !create && this.options.mode === "columntoggle" ) {
            headers = this.headers;
            hiddenColumns = [];

            // Find the index of the column header associated with each old checkbox among the
            // post-refresh headers and, if the header is still there, make sure the corresponding
            // column will be hidden if the pre-refresh checkbox indicates that the column is
            // hidden by recording its index in the array of hidden columns.
            this._menu.find( "input" ).each( function() {
                var input = $( this ),
                    header = input.jqmData( "header" ),
                    index = headers.index( header[ 0 ] );

                if ( index > -1 && !input.prop( "checked" ) ) {

                    // The column header associated with /this/ checkbox is still present in the
                    // post-refresh table and the checkbox is not checked, so the column associated
                    // with this column header is currently hidden. Let's record that.
                    hiddenColumns.push( index );
                }
            });

            // columns not being replaced must be cleared from input toggle-locks
            this._unlockCells( this.element.find( ".ui-table-cell-hidden, " +
                ".ui-table-cell-visible" ) );

            // update columntoggles and cells
            this._addToggles( this._menu, create );

            // At this point all columns are visible, so uncheck the checkboxes that correspond to
            // those columns we've found to be hidden
            for ( index = hiddenColumns.length - 1 ; index > -1 ; index-- ) {
                headers.eq( hiddenColumns[ index ] ).jqmData( "input" )
                    .prop( "checked", false )
                    .checkboxradio( "refresh" )
                    .trigger( "change" );
            }
        }
    },

    _setToggleState: function() {
        this._menu.find( "input" ).each( function() {
            var checkbox = $( this );

            this.checked = checkbox.jqmData( "cells" ).eq( 0 ).css( "display" ) === "table-cell";
            checkbox.checkboxradio( "refresh" );
        });
    },

    _destroy: function() {
        this._super();
    }
});

})( jQuery );

(function( $, undefined ) {

$.widget( "mobile.table", $.mobile.table, {
    options: {
        mode: "reflow",
        classes: $.extend( $.mobile.table.prototype.options.classes, {
            reflowTable: "ui-table-reflow",
            cellLabels: "ui-table-cell-label"
        })
    },

    _create: function() {
        this._super();

        // If it's not reflow mode, return here.
        if ( this.options.mode !== "reflow" ) {
            return;
        }

        if ( !this.options.enhanced ) {
            this.element.addClass( this.options.classes.reflowTable );

            this._updateReflow();
        }
    },

    rebuild: function() {
        this._super();

        if ( this.options.mode === "reflow" ) {
            this._refresh( false );
        }
    },

    _refresh: function( create ) {
        this._super( create );
        if ( !create && this.options.mode === "reflow" ) {
            this._updateReflow( );
        }
    },

    _updateReflow: function() {
        var table = this,
            opts = this.options;

        // get headers in reverse order so that top-level headers are appended last
        $( table.allHeaders.get().reverse() ).each( function() {
            var cells = $( this ).jqmData( "cells" ),
                colstart = $.mobile.getAttribute( this, "colstart" ),
                hierarchyClass = cells.not( this ).filter( "thead th" ).length && " ui-table-cell-label-top",
                contents = $( this ).clone().contents(),
                iteration, filter;

                if ( contents.length > 0  ) {

                    if ( hierarchyClass ) {
                        iteration = parseInt( this.getAttribute( "colspan" ), 10 );
                        filter = "";

                        if ( iteration ) {
                            filter = "td:nth-child("+ iteration +"n + " + ( colstart ) +")";
                        }

                        table._addLabels( cells.filter( filter ),
                            opts.classes.cellLabels + hierarchyClass, contents );
                    } else {
                        table._addLabels( cells, opts.classes.cellLabels, contents );
                    }

                }
        });
    },

    _addLabels: function( cells, label, contents ) {
        if ( contents.length === 1 && contents[ 0 ].nodeName.toLowerCase() === "abbr" ) {
            contents = contents.eq( 0 ).attr( "title" );
        }
        // .not fixes #6006
        cells
            .not( ":has(b." + label + ")" )
                .prepend( $( "<b class='" + label + "'></b>" ).append( contents ) );
    }
});

})( jQuery );

(function( $, undefined ) {

// TODO rename filterCallback/deprecate and default to the item itself as the first argument
var defaultFilterCallback = function( index, searchValue ) {
    return ( ( "" + ( $.mobile.getAttribute( this, "filtertext" ) || $( this ).text() ) )
        .toLowerCase().indexOf( searchValue ) === -1 );
};

$.widget( "mobile.filterable", {

    initSelector: ":jqmData(filter='true')",

    options: {
        filterReveal: false,
        filterCallback: defaultFilterCallback,
        enhanced: false,
        input: null,
        children: "> li, > option, > optgroup option, > tbody tr, > .ui-controlgroup-controls > .ui-btn, > .ui-controlgroup-controls > .ui-checkbox, > .ui-controlgroup-controls > .ui-radio"
    },

    _create: function() {
        var opts = this.options;

        $.extend( this, {
            _search: null,
            _timer: 0
        });

        this._setInput( opts.input );
        if ( !opts.enhanced ) {
            this._filterItems( ( ( this._search && this._search.val() ) || "" ).toLowerCase() );
        }
    },

    _onKeyUp: function() {
        var val, lastval,
            search = this._search;

        if ( search ) {
            val = search.val().toLowerCase(),
            lastval = $.mobile.getAttribute( search[ 0 ], "lastval" ) + "";

            if ( lastval && lastval === val ) {
                // Execute the handler only once per value change
                return;
            }

            if ( this._timer ) {
                window.clearTimeout( this._timer );
                this._timer = 0;
            }

            this._timer = this._delay( function() {
                if ( this._trigger( "beforefilter", null, { input: search } ) === false ) {
                    return false;
                }

                // Change val as lastval for next execution
                search[ 0 ].setAttribute( "data-" + $.mobile.ns + "lastval", val );

                this._filterItems( val );
                this._timer = 0;
            }, 250 );
        }
    },

    _getFilterableItems: function() {
        var elem = this.element,
            children = this.options.children,
            items = !children ? { length: 0 }:
                $.isFunction( children ) ? children():
                children.nodeName ? $( children ):
                children.jquery ? children:
                this.element.find( children );

        if ( items.length === 0 ) {
            items = elem.children();
        }

        return items;
    },

    _filterItems: function( val ) {
        var idx, callback, length, dst,
            show = [],
            hide = [],
            opts = this.options,
            filterItems = this._getFilterableItems();

        if ( val != null ) {
            callback = opts.filterCallback || defaultFilterCallback;
            length = filterItems.length;

            // Partition the items into those to be hidden and those to be shown
            for ( idx = 0 ; idx < length ; idx++ ) {
                dst = ( callback.call( filterItems[ idx ], idx, val ) ) ? hide : show;
                dst.push( filterItems[ idx ] );
            }
        }

        // If nothing is hidden, then the decision whether to hide or show the items
        // is based on the "filterReveal" option.
        if ( hide.length === 0 ) {
            filterItems[ ( opts.filterReveal && val.length === 0 ) ?
                "addClass" : "removeClass" ]( "ui-screen-hidden" );
        } else {
            $( hide ).addClass( "ui-screen-hidden" );
            $( show ).removeClass( "ui-screen-hidden" );
        }

        this._refreshChildWidget();

        this._trigger( "filter", null, {
            items: filterItems
        });
    },

    // The Default implementation of _refreshChildWidget attempts to call
    // refresh on collapsibleset, controlgroup, selectmenu, or listview
    _refreshChildWidget: function() {
        var widget, idx,
            recognizedWidgets = [ "collapsibleset", "selectmenu", "controlgroup", "listview" ];

        for ( idx = recognizedWidgets.length - 1 ; idx > -1 ; idx-- ) {
            widget = recognizedWidgets[ idx ];
            if ( $.mobile[ widget ] ) {
                widget = this.element.data( "mobile-" + widget );
                if ( widget && $.isFunction( widget.refresh ) ) {
                    widget.refresh();
                }
            }
        }
    },

    // TODO: When the input is not internal, do not even store it in this._search
    _setInput: function ( selector ) {
        var search = this._search;

        // Stop a pending filter operation
        if ( this._timer ) {
            window.clearTimeout( this._timer );
            this._timer = 0;
        }

        if ( search ) {
            this._off( search, "keyup change input" );
            search = null;
        }

        if ( selector ) {
            search = selector.jquery ? selector:
                selector.nodeName ? $( selector ):
                this.document.find( selector );

            this._on( search, {
                keydown: "_onKeyDown",
                keypress: "_onKeyPress",
                keyup: "_onKeyUp",
                change: "_onKeyUp",
                input: "_onKeyUp"
            });
        }

        this._search = search;
    },

    // Prevent form submission
    _onKeyDown: function( event ) {
        if ( event.keyCode === $.ui.keyCode.ENTER ) {
            event.preventDefault();
            this._preventKeyPress = true;
        }
    },

    _onKeyPress: function( event ) {
        if ( this._preventKeyPress ) {
            event.preventDefault();
            this._preventKeyPress = false;
        }
    },

    _setOptions: function( options ) {
        var refilter = !( ( options.filterReveal === undefined ) &&
                ( options.filterCallback === undefined ) &&
                ( options.children === undefined ) );

        this._super( options );

        if ( options.input !== undefined ) {
            this._setInput( options.input );
            refilter = true;
        }

        if ( refilter ) {
            this.refresh();
        }
    },

    _destroy: function() {
        var opts = this.options,
            items = this._getFilterableItems();

        if ( opts.enhanced ) {
            items.toggleClass( "ui-screen-hidden", opts.filterReveal );
        } else {
            items.removeClass( "ui-screen-hidden" );
        }
    },

    refresh: function() {
        if ( this._timer ) {
            window.clearTimeout( this._timer );
            this._timer = 0;
        }
        this._filterItems( ( ( this._search && this._search.val() ) || "" ).toLowerCase() );
    }
});

})( jQuery );

(function( $, undefined ) {

// Create a function that will replace the _setOptions function of a widget,
// and will pass the options on to the input of the filterable.
var replaceSetOptions = function( self, orig ) {
        return function( options ) {
            orig.call( this, options );
            self._syncTextInputOptions( options );
        };
    },
    rDividerListItem = /(^|\s)ui-li-divider(\s|$)/,
    origDefaultFilterCallback = $.mobile.filterable.prototype.options.filterCallback;

// Override the default filter callback with one that does not hide list dividers
$.mobile.filterable.prototype.options.filterCallback = function( index, searchValue ) {
    return !this.className.match( rDividerListItem ) &&
        origDefaultFilterCallback.call( this, index, searchValue );
};

$.widget( "mobile.filterable", $.mobile.filterable, {
    options: {
        filterPlaceholder: "Filter items...",
        filterTheme: null
    },

    _create: function() {
        var idx, widgetName,
            elem = this.element,
            recognizedWidgets = [ "collapsibleset", "selectmenu", "controlgroup", "listview" ],
            createHandlers = {};

        this._super();

        $.extend( this, {
            _widget: null
        });

        for ( idx = recognizedWidgets.length - 1 ; idx > -1 ; idx-- ) {
            widgetName = recognizedWidgets[ idx ];
            if ( $.mobile[ widgetName ] ) {
                if ( this._setWidget( elem.data( "mobile-" + widgetName ) ) ) {
                    break;
                } else {
                    createHandlers[ widgetName + "create" ] = "_handleCreate";
                }
            }
        }

        if ( !this._widget ) {
            this._on( elem, createHandlers );
        }
    },

    _handleCreate: function( evt ) {
        this._setWidget( this.element.data( "mobile-" + evt.type.substring( 0, evt.type.length - 6 ) ) );
    },

    _trigger: function( type, event, data ) {
        if ( this._widget && this._widget.widgetFullName === "mobile-listview" &&
            type === "beforefilter" ) {

            // Also trigger listviewbeforefilter if this widget is also a listview
            this._widget._trigger( "beforefilter", event, data );
        }

        // Passing back the response enables calling preventDefault()
        return this._super( type, event, data );
    },

    _setWidget: function( widget ) {
        if ( !this._widget && widget ) {
            this._widget = widget;
            this._widget._setOptions = replaceSetOptions( this, this._widget._setOptions );
        }

        if ( !!this._widget ) {
            this._syncTextInputOptions( this._widget.options );
            if ( this._widget.widgetName === "listview" ) {
                this._widget.options.hideDividers = true;
                this._widget.element.listview( "refresh" );
            }
        }

        return !!this._widget;
    },

    _isSearchInternal: function() {
        return ( this._search && this._search.jqmData( "ui-filterable-" + this.uuid + "-internal" ) );
    },

    _setInput: function( selector ) {
        var opts = this.options,
            updatePlaceholder = true,
            textinputOpts = {};

        if ( !selector ) {
            if ( this._isSearchInternal() ) {

                // Ignore the call to set a new input if the selector goes to falsy and
                // the current textinput is already of the internally generated variety.
                return;
            } else {

                // Generating a new textinput widget. No need to set the placeholder
                // further down the function.
                updatePlaceholder = false;
                selector = $( "<input " +
                    "data-" + $.mobile.ns + "type='search' " +
                    "placeholder='" + opts.filterPlaceholder + "'></input>" )
                    .jqmData( "ui-filterable-" + this.uuid + "-internal", true );
                $( "<form class='ui-filterable'></form>" )
                    .append( selector )
                    .submit( function( evt ) {
                        evt.preventDefault();
                        selector.blur();
                    })
                    .insertBefore( this.element );
                if ( $.mobile.textinput ) {
                    if ( this.options.filterTheme != null ) {
                        textinputOpts[ "theme" ] = opts.filterTheme;
                    }

                    selector.textinput( textinputOpts );
                }
            }
        }

        this._super( selector );

        if ( this._isSearchInternal() && updatePlaceholder ) {
            this._search.attr( "placeholder", this.options.filterPlaceholder );
        }
    },

    _setOptions: function( options ) {
        var ret = this._super( options );

        // Need to set the filterPlaceholder after having established the search input
        if ( options.filterPlaceholder !== undefined ) {
            if ( this._isSearchInternal() ) {
                this._search.attr( "placeholder", options.filterPlaceholder );
            }
        }

        if ( options.filterTheme !== undefined && this._search && $.mobile.textinput ) {
            this._search.textinput( "option", "theme", options.filterTheme );
        }

        return ret;
    },

    // The listview implementation accompanying this filterable backcompat layer will call
    // filterable.refresh() after it's done refreshing the listview to make sure the filterable
    // filters out any new items added. However, when the listview refresh has been initiated by
    // the filterable itself, then such filtering has already taken place, and calling the
    // filterable's refresh() method will cause an infinite recursion. We stop this by setting a
    // flag that will cause the filterable's refresh() method to short-circuit.
    _refreshChildWidget: function() {
        this._refreshingChildWidget = true;
        this._superApply( arguments );
        this._refreshingChildWidget = false;
    },

    refresh: function() {
        if ( !this._refreshingChildWidget ) {
            this._superApply( arguments );
        }
    },

    _destroy: function() {
        if ( this._isSearchInternal() ) {
            this._search.remove();
        }
        this._super();
    },

    _syncTextInputOptions: function( options ) {
        var idx,
            textinputOptions = {};

        // We only sync options if the filterable's textinput is of the internally
        // generated variety, rather than one specified by the user.
        if ( this._isSearchInternal() && $.mobile.textinput ) {

            // Apply only the options understood by textinput
            for ( idx in $.mobile.textinput.prototype.options ) {
                if ( options[ idx ] !== undefined ) {
                    if ( idx === "theme" && this.options.filterTheme != null ) {
                        textinputOptions[ idx ] = this.options.filterTheme;
                    } else {
                        textinputOptions[ idx ] = options[ idx ];
                    }
                }
            }
            this._search.textinput( "option", textinputOptions );
        }
    }
});

// Instantiate a filterable on a listview that has the data-filter="true" attribute
// This is not necessary for static content, because the auto-enhance takes care of instantiating
// the filterable upon encountering data-filter="true". However, because of 1.3.x it is expected
// that a listview with data-filter="true" will be filterable even if you just instantiate a
// listview on it. The extension below ensures that this continues to happen in 1.4.x.
$.widget( "mobile.listview", $.mobile.listview, {
    options: {
        filter: false
    },
    _create: function() {
        if ( this.options.filter === true &&
                !this.element.data( "mobile-filterable" ) ) {
            this.element.filterable();
        }
        return this._super();
    },

    refresh: function() {
        var filterable;

        this._superApply( arguments );

        if ( this.options.filter === true ) {
            filterable = this.element.data( "mobile-filterable" );

            if ( filterable ) {
                filterable.refresh();
            }
        }
    }
});

})( jQuery );

/*!
 * jQuery UI Tabs fadf2b312a05040436451c64bbfaf4814bc62c56
 * http://jqueryui.com
 *
 * Copyright 2013 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/tabs/
 *
 * Depends:
 *    jquery.ui.core.js
 *    jquery.ui.widget.js
 */
(function( $, undefined ) {

var tabId = 0,
    rhash = /#.*$/;

function getNextTabId() {
    return ++tabId;
}

function isLocal( anchor ) {
    return anchor.hash.length > 1 &&
        decodeURIComponent( anchor.href.replace( rhash, "" ) ) ===
            decodeURIComponent( location.href.replace( rhash, "" ) );
}

$.widget( "ui.tabs", {
    version: "fadf2b312a05040436451c64bbfaf4814bc62c56",
    delay: 300,
    options: {
        active: null,
        collapsible: false,
        event: "click",
        heightStyle: "content",
        hide: null,
        show: null,

        // callbacks
        activate: null,
        beforeActivate: null,
        beforeLoad: null,
        load: null
    },

    _create: function() {
        var that = this,
            options = this.options;

        this.running = false;

        this.element
            .addClass( "ui-tabs ui-widget ui-widget-content ui-corner-all" )
            .toggleClass( "ui-tabs-collapsible", options.collapsible )
            // Prevent users from focusing disabled tabs via click
            .delegate( ".ui-tabs-nav > li", "mousedown" + this.eventNamespace, function( event ) {
                if ( $( this ).is( ".ui-state-disabled" ) ) {
                    event.preventDefault();
                }
            })
            // support: IE <9
            // Preventing the default action in mousedown doesn't prevent IE
            // from focusing the element, so if the anchor gets focused, blur.
            // We don't have to worry about focusing the previously focused
            // element since clicking on a non-focusable element should focus
            // the body anyway.
            .delegate( ".ui-tabs-anchor", "focus" + this.eventNamespace, function() {
                if ( $( this ).closest( "li" ).is( ".ui-state-disabled" ) ) {
                    this.blur();
                }
            });

        this._processTabs();
        options.active = this._initialActive();

        // Take disabling tabs via class attribute from HTML
        // into account and update option properly.
        if ( $.isArray( options.disabled ) ) {
            options.disabled = $.unique( options.disabled.concat(
                $.map( this.tabs.filter( ".ui-state-disabled" ), function( li ) {
                    return that.tabs.index( li );
                })
            ) ).sort();
        }

        // check for length avoids error when initializing empty list
        if ( this.options.active !== false && this.anchors.length ) {
            this.active = this._findActive( options.active );
        } else {
            this.active = $();
        }

        this._refresh();

        if ( this.active.length ) {
            this.load( options.active );
        }
    },

    _initialActive: function() {
        var active = this.options.active,
            collapsible = this.options.collapsible,
            locationHash = location.hash.substring( 1 );

        if ( active === null ) {
            // check the fragment identifier in the URL
            if ( locationHash ) {
                this.tabs.each(function( i, tab ) {
                    if ( $( tab ).attr( "aria-controls" ) === locationHash ) {
                        active = i;
                        return false;
                    }
                });
            }

            // check for a tab marked active via a class
            if ( active === null ) {
                active = this.tabs.index( this.tabs.filter( ".ui-tabs-active" ) );
            }

            // no active tab, set to false
            if ( active === null || active === -1 ) {
                active = this.tabs.length ? 0 : false;
            }
        }

        // handle numbers: negative, out of range
        if ( active !== false ) {
            active = this.tabs.index( this.tabs.eq( active ) );
            if ( active === -1 ) {
                active = collapsible ? false : 0;
            }
        }

        // don't allow collapsible: false and active: false
        if ( !collapsible && active === false && this.anchors.length ) {
            active = 0;
        }

        return active;
    },

    _getCreateEventData: function() {
        return {
            tab: this.active,
            panel: !this.active.length ? $() : this._getPanelForTab( this.active )
        };
    },

    _tabKeydown: function( event ) {
        var focusedTab = $( this.document[0].activeElement ).closest( "li" ),
            selectedIndex = this.tabs.index( focusedTab ),
            goingForward = true;

        if ( this._handlePageNav( event ) ) {
            return;
        }

        switch ( event.keyCode ) {
            case $.ui.keyCode.RIGHT:
            case $.ui.keyCode.DOWN:
                selectedIndex++;
                break;
            case $.ui.keyCode.UP:
            case $.ui.keyCode.LEFT:
                goingForward = false;
                selectedIndex--;
                break;
            case $.ui.keyCode.END:
                selectedIndex = this.anchors.length - 1;
                break;
            case $.ui.keyCode.HOME:
                selectedIndex = 0;
                break;
            case $.ui.keyCode.SPACE:
                // Activate only, no collapsing
                event.preventDefault();
                clearTimeout( this.activating );
                this._activate( selectedIndex );
                return;
            case $.ui.keyCode.ENTER:
                // Toggle (cancel delayed activation, allow collapsing)
                event.preventDefault();
                clearTimeout( this.activating );
                // Determine if we should collapse or activate
                this._activate( selectedIndex === this.options.active ? false : selectedIndex );
                return;
            default:
                return;
        }

        // Focus the appropriate tab, based on which key was pressed
        event.preventDefault();
        clearTimeout( this.activating );
        selectedIndex = this._focusNextTab( selectedIndex, goingForward );

        // Navigating with control key will prevent automatic activation
        if ( !event.ctrlKey ) {
            // Update aria-selected immediately so that AT think the tab is already selected.
            // Otherwise AT may confuse the user by stating that they need to activate the tab,
            // but the tab will already be activated by the time the announcement finishes.
            focusedTab.attr( "aria-selected", "false" );
            this.tabs.eq( selectedIndex ).attr( "aria-selected", "true" );

            this.activating = this._delay(function() {
                this.option( "active", selectedIndex );
            }, this.delay );
        }
    },

    _panelKeydown: function( event ) {
        if ( this._handlePageNav( event ) ) {
            return;
        }

        // Ctrl+up moves focus to the current tab
        if ( event.ctrlKey && event.keyCode === $.ui.keyCode.UP ) {
            event.preventDefault();
            this.active.focus();
        }
    },

    // Alt+page up/down moves focus to the previous/next tab (and activates)
    _handlePageNav: function( event ) {
        if ( event.altKey && event.keyCode === $.ui.keyCode.PAGE_UP ) {
            this._activate( this._focusNextTab( this.options.active - 1, false ) );
            return true;
        }
        if ( event.altKey && event.keyCode === $.ui.keyCode.PAGE_DOWN ) {
            this._activate( this._focusNextTab( this.options.active + 1, true ) );
            return true;
        }
    },

    _findNextTab: function( index, goingForward ) {
        var lastTabIndex = this.tabs.length - 1;

        function constrain() {
            if ( index > lastTabIndex ) {
                index = 0;
            }
            if ( index < 0 ) {
                index = lastTabIndex;
            }
            return index;
        }

        while ( $.inArray( constrain(), this.options.disabled ) !== -1 ) {
            index = goingForward ? index + 1 : index - 1;
        }

        return index;
    },

    _focusNextTab: function( index, goingForward ) {
        index = this._findNextTab( index, goingForward );
        this.tabs.eq( index ).focus();
        return index;
    },

    _setOption: function( key, value ) {
        if ( key === "active" ) {
            // _activate() will handle invalid values and update this.options
            this._activate( value );
            return;
        }

        if ( key === "disabled" ) {
            // don't use the widget factory's disabled handling
            this._setupDisabled( value );
            return;
        }

        this._super( key, value);

        if ( key === "collapsible" ) {
            this.element.toggleClass( "ui-tabs-collapsible", value );
            // Setting collapsible: false while collapsed; open first panel
            if ( !value && this.options.active === false ) {
                this._activate( 0 );
            }
        }

        if ( key === "event" ) {
            this._setupEvents( value );
        }

        if ( key === "heightStyle" ) {
            this._setupHeightStyle( value );
        }
    },

    _tabId: function( tab ) {
        return tab.attr( "aria-controls" ) || "ui-tabs-" + getNextTabId();
    },

    _sanitizeSelector: function( hash ) {
        return hash ? hash.replace( /[!"$%&'()*+,.\/:;<=>?@\[\]\^`{|}~]/g, "\\$&" ) : "";
    },

    refresh: function() {
        var options = this.options,
            lis = this.tablist.children( ":has(a[href])" );

        // get disabled tabs from class attribute from HTML
        // this will get converted to a boolean if needed in _refresh()
        options.disabled = $.map( lis.filter( ".ui-state-disabled" ), function( tab ) {
            return lis.index( tab );
        });

        this._processTabs();

        // was collapsed or no tabs
        if ( options.active === false || !this.anchors.length ) {
            options.active = false;
            this.active = $();
        // was active, but active tab is gone
        } else if ( this.active.length && !$.contains( this.tablist[ 0 ], this.active[ 0 ] ) ) {
            // all remaining tabs are disabled
            if ( this.tabs.length === options.disabled.length ) {
                options.active = false;
                this.active = $();
            // activate previous tab
            } else {
                this._activate( this._findNextTab( Math.max( 0, options.active - 1 ), false ) );
            }
        // was active, active tab still exists
        } else {
            // make sure active index is correct
            options.active = this.tabs.index( this.active );
        }

        this._refresh();
    },

    _refresh: function() {
        this._setupDisabled( this.options.disabled );
        this._setupEvents( this.options.event );
        this._setupHeightStyle( this.options.heightStyle );

        this.tabs.not( this.active ).attr({
            "aria-selected": "false",
            tabIndex: -1
        });
        this.panels.not( this._getPanelForTab( this.active ) )
            .hide()
            .attr({
                "aria-expanded": "false",
                "aria-hidden": "true"
            });

        // Make sure one tab is in the tab order
        if ( !this.active.length ) {
            this.tabs.eq( 0 ).attr( "tabIndex", 0 );
        } else {
            this.active
                .addClass( "ui-tabs-active ui-state-active" )
                .attr({
                    "aria-selected": "true",
                    tabIndex: 0
                });
            this._getPanelForTab( this.active )
                .show()
                .attr({
                    "aria-expanded": "true",
                    "aria-hidden": "false"
                });
        }
    },

    _processTabs: function() {
        var that = this;

        this.tablist = this._getList()
            .addClass( "ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all" )
            .attr( "role", "tablist" );

        this.tabs = this.tablist.find( "> li:has(a[href])" )
            .addClass( "ui-state-default ui-corner-top" )
            .attr({
                role: "tab",
                tabIndex: -1
            });

        this.anchors = this.tabs.map(function() {
                return $( "a", this )[ 0 ];
            })
            .addClass( "ui-tabs-anchor" )
            .attr({
                role: "presentation",
                tabIndex: -1
            });

        this.panels = $();

        this.anchors.each(function( i, anchor ) {
            var selector, panel, panelId,
                anchorId = $( anchor ).uniqueId().attr( "id" ),
                tab = $( anchor ).closest( "li" ),
                originalAriaControls = tab.attr( "aria-controls" );

            // inline tab
            if ( isLocal( anchor ) ) {
                selector = anchor.hash;
                panel = that.element.find( that._sanitizeSelector( selector ) );
            // remote tab
            } else {
                panelId = that._tabId( tab );
                selector = "#" + panelId;
                panel = that.element.find( selector );
                if ( !panel.length ) {
                    panel = that._createPanel( panelId );
                    panel.insertAfter( that.panels[ i - 1 ] || that.tablist );
                }
                panel.attr( "aria-live", "polite" );
            }

            if ( panel.length) {
                that.panels = that.panels.add( panel );
            }
            if ( originalAriaControls ) {
                tab.data( "ui-tabs-aria-controls", originalAriaControls );
            }
            tab.attr({
                "aria-controls": selector.substring( 1 ),
                "aria-labelledby": anchorId
            });
            panel.attr( "aria-labelledby", anchorId );
        });

        this.panels
            .addClass( "ui-tabs-panel ui-widget-content ui-corner-bottom" )
            .attr( "role", "tabpanel" );
    },

    // allow overriding how to find the list for rare usage scenarios (#7715)
    _getList: function() {
        return this.element.find( "ol,ul" ).eq( 0 );
    },

    _createPanel: function( id ) {
        return $( "<div>" )
            .attr( "id", id )
            .addClass( "ui-tabs-panel ui-widget-content ui-corner-bottom" )
            .data( "ui-tabs-destroy", true );
    },

    _setupDisabled: function( disabled ) {
        if ( $.isArray( disabled ) ) {
            if ( !disabled.length ) {
                disabled = false;
            } else if ( disabled.length === this.anchors.length ) {
                disabled = true;
            }
        }

        // disable tabs
        for ( var i = 0, li; ( li = this.tabs[ i ] ); i++ ) {
            if ( disabled === true || $.inArray( i, disabled ) !== -1 ) {
                $( li )
                    .addClass( "ui-state-disabled" )
                    .attr( "aria-disabled", "true" );
            } else {
                $( li )
                    .removeClass( "ui-state-disabled" )
                    .removeAttr( "aria-disabled" );
            }
        }

        this.options.disabled = disabled;
    },

    _setupEvents: function( event ) {
        var events = {
            click: function( event ) {
                event.preventDefault();
            }
        };
        if ( event ) {
            $.each( event.split(" "), function( index, eventName ) {
                events[ eventName ] = "_eventHandler";
            });
        }

        this._off( this.anchors.add( this.tabs ).add( this.panels ) );
        this._on( this.anchors, events );
        this._on( this.tabs, { keydown: "_tabKeydown" } );
        this._on( this.panels, { keydown: "_panelKeydown" } );

        this._focusable( this.tabs );
        this._hoverable( this.tabs );
    },

    _setupHeightStyle: function( heightStyle ) {
        var maxHeight,
            parent = this.element.parent();

        if ( heightStyle === "fill" ) {
            maxHeight = parent.height();
            maxHeight -= this.element.outerHeight() - this.element.height();

            this.element.siblings( ":visible" ).each(function() {
                var elem = $( this ),
                    position = elem.css( "position" );

                if ( position === "absolute" || position === "fixed" ) {
                    return;
                }
                maxHeight -= elem.outerHeight( true );
            });

            this.element.children().not( this.panels ).each(function() {
                maxHeight -= $( this ).outerHeight( true );
            });

            this.panels.each(function() {
                $( this ).height( Math.max( 0, maxHeight -
                    $( this ).innerHeight() + $( this ).height() ) );
            })
            .css( "overflow", "auto" );
        } else if ( heightStyle === "auto" ) {
            maxHeight = 0;
            this.panels.each(function() {
                maxHeight = Math.max( maxHeight, $( this ).height( "" ).height() );
            }).height( maxHeight );
        }
    },

    _eventHandler: function( event ) {
        var options = this.options,
            active = this.active,
            anchor = $( event.currentTarget ),
            tab = anchor.closest( "li" ),
            clickedIsActive = tab[ 0 ] === active[ 0 ],
            collapsing = clickedIsActive && options.collapsible,
            toShow = collapsing ? $() : this._getPanelForTab( tab ),
            toHide = !active.length ? $() : this._getPanelForTab( active ),
            eventData = {
                oldTab: active,
                oldPanel: toHide,
                newTab: collapsing ? $() : tab,
                newPanel: toShow
            };

        event.preventDefault();

        if ( tab.hasClass( "ui-state-disabled" ) ||
                // tab is already loading
                tab.hasClass( "ui-tabs-loading" ) ||
                // can't switch durning an animation
                this.running ||
                // click on active header, but not collapsible
                ( clickedIsActive && !options.collapsible ) ||
                // allow canceling activation
                ( this._trigger( "beforeActivate", event, eventData ) === false ) ) {
            return;
        }

        options.active = collapsing ? false : this.tabs.index( tab );

        this.active = clickedIsActive ? $() : tab;
        if ( this.xhr ) {
            this.xhr.abort();
        }

        if ( !toHide.length && !toShow.length ) {
            $.error( "jQuery UI Tabs: Mismatching fragment identifier." );
        }

        if ( toShow.length ) {
            this.load( this.tabs.index( tab ), event );
        }
        this._toggle( event, eventData );
    },

    // handles show/hide for selecting tabs
    _toggle: function( event, eventData ) {
        var that = this,
            toShow = eventData.newPanel,
            toHide = eventData.oldPanel;

        this.running = true;

        function complete() {
            that.running = false;
            that._trigger( "activate", event, eventData );
        }

        function show() {
            eventData.newTab.closest( "li" ).addClass( "ui-tabs-active ui-state-active" );

            if ( toShow.length && that.options.show ) {
                that._show( toShow, that.options.show, complete );
            } else {
                toShow.show();
                complete();
            }
        }

        // start out by hiding, then showing, then completing
        if ( toHide.length && this.options.hide ) {
            this._hide( toHide, this.options.hide, function() {
                eventData.oldTab.closest( "li" ).removeClass( "ui-tabs-active ui-state-active" );
                show();
            });
        } else {
            eventData.oldTab.closest( "li" ).removeClass( "ui-tabs-active ui-state-active" );
            toHide.hide();
            show();
        }

        toHide.attr({
            "aria-expanded": "false",
            "aria-hidden": "true"
        });
        eventData.oldTab.attr( "aria-selected", "false" );
        // If we're switching tabs, remove the old tab from the tab order.
        // If we're opening from collapsed state, remove the previous tab from the tab order.
        // If we're collapsing, then keep the collapsing tab in the tab order.
        if ( toShow.length && toHide.length ) {
            eventData.oldTab.attr( "tabIndex", -1 );
        } else if ( toShow.length ) {
            this.tabs.filter(function() {
                return $( this ).attr( "tabIndex" ) === 0;
            })
            .attr( "tabIndex", -1 );
        }

        toShow.attr({
            "aria-expanded": "true",
            "aria-hidden": "false"
        });
        eventData.newTab.attr({
            "aria-selected": "true",
            tabIndex: 0
        });
    },

    _activate: function( index ) {
        var anchor,
            active = this._findActive( index );

        // trying to activate the already active panel
        if ( active[ 0 ] === this.active[ 0 ] ) {
            return;
        }

        // trying to collapse, simulate a click on the current active header
        if ( !active.length ) {
            active = this.active;
        }

        anchor = active.find( ".ui-tabs-anchor" )[ 0 ];
        this._eventHandler({
            target: anchor,
            currentTarget: anchor,
            preventDefault: $.noop
        });
    },

    _findActive: function( index ) {
        return index === false ? $() : this.tabs.eq( index );
    },

    _getIndex: function( index ) {
        // meta-function to give users option to provide a href string instead of a numerical index.
        if ( typeof index === "string" ) {
            index = this.anchors.index( this.anchors.filter( "[href$='" + index + "']" ) );
        }

        return index;
    },

    _destroy: function() {
        if ( this.xhr ) {
            this.xhr.abort();
        }

        this.element.removeClass( "ui-tabs ui-widget ui-widget-content ui-corner-all ui-tabs-collapsible" );

        this.tablist
            .removeClass( "ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all" )
            .removeAttr( "role" );

        this.anchors
            .removeClass( "ui-tabs-anchor" )
            .removeAttr( "role" )
            .removeAttr( "tabIndex" )
            .removeUniqueId();

        this.tabs.add( this.panels ).each(function() {
            if ( $.data( this, "ui-tabs-destroy" ) ) {
                $( this ).remove();
            } else {
                $( this )
                    .removeClass( "ui-state-default ui-state-active ui-state-disabled " +
                        "ui-corner-top ui-corner-bottom ui-widget-content ui-tabs-active ui-tabs-panel" )
                    .removeAttr( "tabIndex" )
                    .removeAttr( "aria-live" )
                    .removeAttr( "aria-busy" )
                    .removeAttr( "aria-selected" )
                    .removeAttr( "aria-labelledby" )
                    .removeAttr( "aria-hidden" )
                    .removeAttr( "aria-expanded" )
                    .removeAttr( "role" );
            }
        });

        this.tabs.each(function() {
            var li = $( this ),
                prev = li.data( "ui-tabs-aria-controls" );
            if ( prev ) {
                li
                    .attr( "aria-controls", prev )
                    .removeData( "ui-tabs-aria-controls" );
            } else {
                li.removeAttr( "aria-controls" );
            }
        });

        this.panels.show();

        if ( this.options.heightStyle !== "content" ) {
            this.panels.css( "height", "" );
        }
    },

    enable: function( index ) {
        var disabled = this.options.disabled;
        if ( disabled === false ) {
            return;
        }

        if ( index === undefined ) {
            disabled = false;
        } else {
            index = this._getIndex( index );
            if ( $.isArray( disabled ) ) {
                disabled = $.map( disabled, function( num ) {
                    return num !== index ? num : null;
                });
            } else {
                disabled = $.map( this.tabs, function( li, num ) {
                    return num !== index ? num : null;
                });
            }
        }
        this._setupDisabled( disabled );
    },

    disable: function( index ) {
        var disabled = this.options.disabled;
        if ( disabled === true ) {
            return;
        }

        if ( index === undefined ) {
            disabled = true;
        } else {
            index = this._getIndex( index );
            if ( $.inArray( index, disabled ) !== -1 ) {
                return;
            }
            if ( $.isArray( disabled ) ) {
                disabled = $.merge( [ index ], disabled ).sort();
            } else {
                disabled = [ index ];
            }
        }
        this._setupDisabled( disabled );
    },

    load: function( index, event ) {
        index = this._getIndex( index );
        var that = this,
            tab = this.tabs.eq( index ),
            anchor = tab.find( ".ui-tabs-anchor" ),
            panel = this._getPanelForTab( tab ),
            eventData = {
                tab: tab,
                panel: panel
            };

        // not remote
        if ( isLocal( anchor[ 0 ] ) ) {
            return;
        }

        this.xhr = $.ajax( this._ajaxSettings( anchor, event, eventData ) );

        // support: jQuery <1.8
        // jQuery <1.8 returns false if the request is canceled in beforeSend,
        // but as of 1.8, $.ajax() always returns a jqXHR object.
        if ( this.xhr && this.xhr.statusText !== "canceled" ) {
            tab.addClass( "ui-tabs-loading" );
            panel.attr( "aria-busy", "true" );

            this.xhr
                .success(function( response ) {
                    // support: jQuery <1.8
                    // http://bugs.jquery.com/ticket/11778
                    setTimeout(function() {
                        panel.html( response );
                        that._trigger( "load", event, eventData );
                    }, 1 );
                })
                .complete(function( jqXHR, status ) {
                    // support: jQuery <1.8
                    // http://bugs.jquery.com/ticket/11778
                    setTimeout(function() {
                        if ( status === "abort" ) {
                            that.panels.stop( false, true );
                        }

                        tab.removeClass( "ui-tabs-loading" );
                        panel.removeAttr( "aria-busy" );

                        if ( jqXHR === that.xhr ) {
                            delete that.xhr;
                        }
                    }, 1 );
                });
        }
    },

    _ajaxSettings: function( anchor, event, eventData ) {
        var that = this;
        return {
            url: anchor.attr( "href" ),
            beforeSend: function( jqXHR, settings ) {
                return that._trigger( "beforeLoad", event,
                    $.extend( { jqXHR : jqXHR, ajaxSettings: settings }, eventData ) );
            }
        };
    },

    _getPanelForTab: function( tab ) {
        var id = $( tab ).attr( "aria-controls" );
        return this.element.find( this._sanitizeSelector( "#" + id ) );
    }
});

})( jQuery );

(function( $, undefined ) {

})( jQuery );

(function( $, window ) {

    $.mobile.iosorientationfixEnabled = true;

    // This fix addresses an iOS bug, so return early if the UA claims it's something else.
    var ua = navigator.userAgent,
        zoom,
        evt, x, y, z, aig;
    if ( !( /iPhone|iPad|iPod/.test( navigator.platform ) && /OS [1-5]_[0-9_]* like Mac OS X/i.test( ua ) && ua.indexOf( "AppleWebKit" ) > -1 ) ) {
        $.mobile.iosorientationfixEnabled = false;
        return;
    }

    zoom = $.mobile.zoom;

    function checkTilt( e ) {
        evt = e.originalEvent;
        aig = evt.accelerationIncludingGravity;

        x = Math.abs( aig.x );
        y = Math.abs( aig.y );
        z = Math.abs( aig.z );

        // If portrait orientation and in one of the danger zones
        if ( !window.orientation && ( x > 7 || ( ( z > 6 && y < 8 || z < 8 && y > 6 ) && x > 5 ) ) ) {
                if ( zoom.enabled ) {
                    zoom.disable();
                }
        }    else if ( !zoom.enabled ) {
                zoom.enable();
        }
    }

    $.mobile.document.on( "mobileinit", function() {
        if ( $.mobile.iosorientationfixEnabled ) {
            $.mobile.window
                .bind( "orientationchange.iosorientationfix", zoom.enable )
                .bind( "devicemotion.iosorientationfix", checkTilt );
        }
    });

}( jQuery, this ));

(function( $, window, undefined ) {
    var    $html = $( "html" ),
        $window = $.mobile.window;

    //remove initial build class (only present on first pageshow)
    function hideRenderingClass() {
        $html.removeClass( "ui-mobile-rendering" );
    }

    // trigger mobileinit event - useful hook for configuring $.mobile settings before they're used
    $( window.document ).trigger( "mobileinit" );

    // support conditions
    // if device support condition(s) aren't met, leave things as they are -> a basic, usable experience,
    // otherwise, proceed with the enhancements
    if ( !$.mobile.gradeA() ) {
        return;
    }

    // override ajaxEnabled on platforms that have known conflicts with hash history updates
    // or generally work better browsing in regular http for full page refreshes (BB5, Opera Mini)
    if ( $.mobile.ajaxBlacklist ) {
        $.mobile.ajaxEnabled = false;
    }

    // Add mobile, initial load "rendering" classes to docEl
    $html.addClass( "ui-mobile ui-mobile-rendering" );

    // This is a fallback. If anything goes wrong (JS errors, etc), or events don't fire,
    // this ensures the rendering class is removed after 5 seconds, so content is visible and accessible
    setTimeout( hideRenderingClass, 5000 );

    $.extend( $.mobile, {
        // find and enhance the pages in the dom and transition to the first page.
        initializePage: function() {
            // find present pages
            var path = $.mobile.path,
                $pages = $( ":jqmData(role='page'), :jqmData(role='dialog')" ),
                hash = path.stripHash( path.stripQueryParams(path.parseLocation().hash) ),
                theLocation = $.mobile.path.parseLocation(),
                hashPage = hash ? document.getElementById( hash ) : undefined;

            // if no pages are found, create one with body's inner html
            if ( !$pages.length ) {
                $pages = $( "body" ).wrapInner( "<div data-" + $.mobile.ns + "role='page'></div>" ).children( 0 );
            }

            // add dialogs, set data-url attrs
            $pages.each(function() {
                var $this = $( this );

                // unless the data url is already set set it to the pathname
                if ( !$this[ 0 ].getAttribute( "data-" + $.mobile.ns + "url" ) ) {
                    $this.attr( "data-" + $.mobile.ns + "url", $this.attr( "id" ) ||
                        path.convertUrlToDataUrl( theLocation.pathname + theLocation.search ) );
                }
            });

            // define first page in dom case one backs out to the directory root (not always the first page visited, but defined as fallback)
            $.mobile.firstPage = $pages.first();

            // define page container
            $.mobile.pageContainer = $.mobile.firstPage
                .parent()
                .addClass( "ui-mobile-viewport" )
                .pagecontainer();

            // initialize navigation events now, after mobileinit has occurred and the page container
            // has been created but before the rest of the library is alerted to that fact
            $.mobile.navreadyDeferred.resolve();

            // alert listeners that the pagecontainer has been determined for binding
            // to events triggered on it
            $window.trigger( "pagecontainercreate" );

            // cue page loading message
            $.mobile.loading( "show" );

            //remove initial build class (only present on first pageshow)
            hideRenderingClass();

            // if hashchange listening is disabled, there's no hash deeplink,
            // the hash is not valid (contains more than one # or does not start with #)
            // or there is no page with that hash, change to the first page in the DOM
            // Remember, however, that the hash can also be a path!
            if ( ! ( $.mobile.hashListeningEnabled &&
                $.mobile.path.isHashValid( location.hash ) &&
                ( $( hashPage ).is( ":jqmData(role='page')" ) ||
                    $.mobile.path.isPath( hash ) ||
                    hash === $.mobile.dialogHashKey ) ) ) {

                // make sure to set initial popstate state if it exists
                // so that navigation back to the initial page works properly
                if ( $.event.special.navigate.isPushStateEnabled() ) {
                    $.mobile.navigate.navigator.squash( path.parseLocation().href );
                }

                $.mobile.changePage( $.mobile.firstPage, {
                    transition: "none",
                    reverse: true,
                    changeHash: false,
                    fromHashChange: true
                });
            } else {
                // trigger hashchange or navigate to squash and record the correct
                // history entry for an initial hash path
                if ( !$.event.special.navigate.isPushStateEnabled() ) {
                    $window.trigger( "hashchange", [true] );
                } else {
                    // TODO figure out how to simplify this interaction with the initial history entry
                    // at the bottom js/navigate/navigate.js
                    $.mobile.navigate.history.stack = [];
                    $.mobile.navigate( $.mobile.path.isPath( location.hash ) ? location.hash : location.href );
                }
            }
        }
    });

    $(function() {
        //Run inlineSVG support test
        $.support.inlineSVG();

        // check which scrollTop value should be used by scrolling to 1 immediately at domready
        // then check what the scroll top is. Android will report 0... others 1
        // note that this initial scroll won't hide the address bar. It's just for the check.

        // hide iOS browser chrome on load if hideUrlBar is true this is to try and do it as soon as possible
        if ( $.mobile.hideUrlBar ) {
            window.scrollTo( 0, 1 );
        }

        // if defaultHomeScroll hasn't been set yet, see if scrollTop is 1
        // it should be 1 in most browsers, but android treats 1 as 0 (for hiding addr bar)
        // so if it's 1, use 0 from now on
        $.mobile.defaultHomeScroll = ( !$.support.scrollTop || $.mobile.window.scrollTop() === 1 ) ? 0 : 1;

        //dom-ready inits
        if ( $.mobile.autoInitializePage ) {
            $.mobile.initializePage();
        }

        // window load event
        // hide iOS browser chrome on load if hideUrlBar is true this is as fall back incase we were too early before
        if ( $.mobile.hideUrlBar ) {
            $window.load( $.mobile.silentScroll );
        }

        if ( !$.support.cssPointerEvents ) {
            // IE and Opera don't support CSS pointer-events: none that we use to disable link-based buttons
            // by adding the 'ui-disabled' class to them. Using a JavaScript workaround for those browser.
            // https://github.com/jquery/jquery-mobile/issues/3558

            // DEPRECATED as of 1.4.0 - remove ui-disabled after 1.4.0 release
            // only ui-state-disabled should be present thereafter
            $.mobile.document.delegate( ".ui-state-disabled,.ui-disabled", "vclick",
                function( e ) {
                    e.preventDefault();
                    e.stopImmediatePropagation();
                }
            );
        }
    });
}( jQuery, this ));


}));

}.call(window));

/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*** IMPORTS FROM imports-loader ***/
(function() {

(function (root, factory) { if (true) { !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(3), __webpack_require__(4)], __WEBPACK_AMD_DEFINE_RESULT__ = function () { return factory(root.CDP || (root.CDP = {})); }.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
                __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__)); } else { factory(root.CDP || (root.CDP = {})); } }(this, function (CDP) { CDP.Framework = CDP.Framework || {};
/// <reference types="backbone" />
var CDP;
(function (CDP) {
    var Framework;
    (function (Framework) {
        Framework.Model = Backbone.Model;
        Framework.Collection = Backbone.Collection;
        Framework.View = Backbone.View;
        Framework.Events = Backbone.Events;
    })(Framework = CDP.Framework || (CDP.Framework = {}));
})(CDP || (CDP = {}));
var CDP;
(function (CDP) {
    // @internal Error code offset definition of `cdp-framework-jqm`.
    var RESULT_CODE_BASE;
    (function (RESULT_CODE_BASE) {
        RESULT_CODE_BASE[RESULT_CODE_BASE["CDP_FRAMEWORK_DECLARERATION"] = 0] = "CDP_FRAMEWORK_DECLARERATION";
        RESULT_CODE_BASE[RESULT_CODE_BASE["CDP_FRAMEWORK"] = 4 * CDP._MODULE_RESULT_CODE_RANGE_CDP] = "CDP_FRAMEWORK";
    })(RESULT_CODE_BASE = CDP.RESULT_CODE_BASE || (CDP.RESULT_CODE_BASE = {}));
    ///////////////////////////////////////////////////////////////////////
    // module error declaration:
    var FUNCTION_CODE_RANGE = 10;
    // @internal cdp.framework.jqm 内のローカルコードオフセット値
    var LOCAL_CODE_BASE;
    (function (LOCAL_CODE_BASE) {
        LOCAL_CODE_BASE[LOCAL_CODE_BASE["CORE_API"] = 0] = "CORE_API";
        LOCAL_CODE_BASE[LOCAL_CODE_BASE["ROUTER"] = 1 * FUNCTION_CODE_RANGE] = "ROUTER";
        LOCAL_CODE_BASE[LOCAL_CODE_BASE["PAGE"] = 2 * FUNCTION_CODE_RANGE] = "PAGE";
    })(LOCAL_CODE_BASE || (LOCAL_CODE_BASE = {}));
    /* tslint:disable:max-line-length */
    // Error code definition of `cdp-framework-jqm`.
    var RESULT_CODE;
    (function (RESULT_CODE) {
        RESULT_CODE[RESULT_CODE["ERROR_CDP_FRAMEWORK_DECLARATION"] = 0] = "ERROR_CDP_FRAMEWORK_DECLARATION";
        /** `en` [[CDP.Framework.initialize]]() failer code. <br> `ja` [[CDP.Framework.initialize]]() のエラーコード */
        RESULT_CODE[RESULT_CODE["ERROR_CDP_FRAMEWORK_INITIALIZE_FAILED"] = CDP.DECLARE_ERROR_CODE(RESULT_CODE_BASE.CDP_FRAMEWORK, LOCAL_CODE_BASE.CORE_API + 1, "framework initialize failed.")] = "ERROR_CDP_FRAMEWORK_INITIALIZE_FAILED";
        /** `en` [[CDP.Router._initialize]]() failer code. <br> `ja` [[CDP.Router._initialize]]() のエラーコード */
        RESULT_CODE[RESULT_CODE["ERROR_CDP_FRAMEWORK_ROUTER_INITIALIZE_FAILED"] = CDP.DECLARE_ERROR_CODE(RESULT_CODE_BASE.CDP_FRAMEWORK, LOCAL_CODE_BASE.ROUTER + 1, "router initialize failed.")] = "ERROR_CDP_FRAMEWORK_ROUTER_INITIALIZE_FAILED";
    })(RESULT_CODE = CDP.RESULT_CODE || (CDP.RESULT_CODE = {}));
    /* tslint:enable:max-line-length */
})(CDP || (CDP = {}));
/* tslint:disable:max-line-length */
var CDP;
(function (CDP) {
    var Framework;
    (function (Framework) {
        /**
         * @en platform judgement utility
         * @ja platform 判定オブジェクト
         *
         * @seehttps://w3g.jp/blog/tools/js_browser_sniffing
         */
        Framework.Platform = (function () {
            var ua = navigator.userAgent.toLowerCase();
            var majorVersion = function (browser) {
                var version = ua.match(new RegExp("(" + browser + ")( |/)([0-9]+)"));
                if (!version || version.length < 4) {
                    return 0;
                }
                return parseInt(version[3], 10);
            };
            return {
                ltIE6: typeof window.addEventListener === "undefined" && typeof document.documentElement.style.maxHeight === "undefined",
                ltIE7: typeof window.addEventListener === "undefined" && typeof document.querySelectorAll === "undefined",
                ltIE8: typeof window.addEventListener === "undefined" && typeof document.getElementsByClassName === "undefined",
                ltIE9: document.uniqueID && typeof window.matchMedia === "undefined",
                gtIE10: document.uniqueID && window.matchMedia,
                Trident: document.uniqueID,
                Gecko: "MozAppearance" in document.documentElement.style,
                Presto: CDP.global.opera,
                Blink: CDP.global.chrome,
                Webkit: typeof CDP.global.chrome === "undefined" && "WebkitAppearance" in document.documentElement.style,
                Touch: typeof CDP.global.ontouchstart !== "undefined",
                Mobile: (typeof CDP.global.orientation !== "undefined") || (ua.indexOf("Windows Phone") !== -1),
                ltAd4_4: typeof CDP.global.orientation !== "undefined" && (typeof CDP.global.EventSource === "undefined" || 30 > majorVersion("chrome")),
                Pointer: CDP.global.navigator.pointerEnabled,
                MSPoniter: CDP.global.navigator.msPointerEnabled,
                Android: (ua.indexOf("android") !== -1),
                iOS: (ua.indexOf("iphone") !== -1 || ua.indexOf("ipad") !== -1 || ua.indexOf("ipod") !== -1),
            };
        })();
    })(Framework = CDP.Framework || (CDP.Framework = {}));
})(CDP || (CDP = {}));
/* tslint:disable:typedef no-bitwise */
var CDP;
(function (CDP) {
    var Framework;
    (function (Framework) {
        /**
         * vclick patch
         */
        var _vclickPatch = function () {
            var jquery_on = $.fn.on, jquery_off = $.fn.off;
            var custom_on = function (types, selector, data, fn, /*INTERNAL*/ one) {
                if (typeof types === "string") {
                    types = types.replace(/vclick/g, "click");
                }
                return _.bind(jquery_on, this)(types, selector, data, fn, one);
            };
            var custom_off = function (types, selector, fn) {
                if (typeof types === "string") {
                    types = types.replace(/vclick/g, "click");
                }
                return _.bind(jquery_off, this)(types, selector, fn);
            };
            // replace functions.
            $.fn.on = custom_on;
            $.fn.off = custom_off;
        };
        /**
         * $.mobile.widget.popup patch for "_createPrerequisites"
         *
         * patch code from jqm 1.5
         * https://github.com/jquery/jquery-mobile/commit/d34c86ae14d4ea603357be5e326de1fb8c31dbf9
         */
        var _apply_jqm_popup_createPrerequisites = function () {
            var _safeCreatePrerequisites = function (screenPrerequisite, containerPrerequisite, whenDone) {
                var prerequisites;
                var self = this;
                prerequisites = {
                    screen: $.Deferred(),
                    container: $.Deferred()
                };
                prerequisites.screen.done(function () {
                    if (prerequisites === self._prerequisites) {
                        screenPrerequisite();
                    }
                });
                prerequisites.container.done(function () {
                    if (prerequisites === self._prerequisites) {
                        containerPrerequisite();
                    }
                });
                $.when(prerequisites.screen, prerequisites.container).done(function () {
                    if (prerequisites === self._prerequisites) {
                        self._prerequisites = null;
                        whenDone();
                    }
                });
                self._prerequisites = prerequisites;
            };
            var $mobile = $.mobile;
            if ($mobile.widgets && $mobile.widgets.popup) {
                $mobile.widgets.popup.prototype._createPrerequisites = _safeCreatePrerequisites;
            }
        };
        /**
         * $.mobile.widget.popup patch for "_handleWindowResize"
         *
         * patch code from stack overflow
         * https://stackoverflow.com/questions/27090445/jqmobile-re-positions-popup-window-every-time-when-android-opens-own-virtual-key
         */
        var _apply_jqm_popup_handleWindowResize = function () {
            var _safeHandleWindowResize = function () {
                if (this._isOpen && this._ignoreResizeTo === 0) {
                    if ((this._expectResizeEvent() || this._orientationchangeInProgress) &&
                        !this._ui.container.hasClass("ui-popup-hidden")) {
                        // effectively rapid-close the popup while leaving the screen intact
                        //judge user is in input mode or not.
                        if (!($(":focus").is("input") || $(":focus").is("textarea"))) {
                            this._ui.container
                                .addClass("ui-popup-hidden ui-popup-truncate")
                                .removeAttr("style");
                        }
                    }
                }
            };
            var $mobile = $.mobile;
            if ($mobile.widgets && $mobile.widgets.popup) {
                $mobile.widgets.popup.prototype._handleWindowResize = _safeHandleWindowResize;
            }
        };
        /**
         * $.mobile.widget.popup patch
         */
        var _mobilePopupPatch = function () {
            var jqueryMajor = ~~$.fn.jquery.split(".")[0];
            var jqmVersion = $.mobile.version.split(".");
            var jqmMajor = ~~jqmVersion[0];
            var jqmMiner = ~~jqmVersion[1];
            if (3 <= jqueryMajor && jqmMajor < 2 && jqmMiner < 5) {
                _apply_jqm_popup_createPrerequisites();
                _apply_jqm_popup_handleWindowResize();
            }
        };
        //___________________________________________________________________________________________________________________//
        /**
         * @en patch class for jqm framework.
         * @ja jqm framework 用パッチ適用クラス
         *
         * @internal
         */
        var Patch = /** @class */ (function () {
            function Patch() {
            }
            ///////////////////////////////////////////////////////////////////////
            // public static methods
            /**
             * @en Apply patch before initialize.
             * @ja 初期化前のパッチの適用
             */
            Patch.applyBeforeInit = function () {
                if (!Patch.isSupportedVclick()) {
                    _vclickPatch();
                    Patch.s_vclickEvent = "click";
                }
            };
            /**
             * @en Apply patch after initialize.
             * @ja 初期化後のパッチの適用
             */
            Patch.applyAfterInit = function () {
                _mobilePopupPatch();
            };
            /**
             * @en if "vclick" event is unsupported, returns false. ex: Android 4.4 (Kitkat)
             * @ja "vclick" event が非サポートである platform (KitKat) は false を返す。 <br>
             *      jQM の version up により、解決される場合は無効かする。
             */
            Patch.isSupportedVclick = function () {
                // for Android 4.4+ (Kitkat ～)
                if (Framework.Platform.Android && !Framework.Platform.ltAd4_4) {
                    return false;
                }
                return true;
            };
            Patch.s_vclickEvent = "vclick";
            return Patch;
        }());
        Framework.Patch = Patch;
    })(Framework = CDP.Framework || (CDP.Framework = {}));
})(CDP || (CDP = {}));
var CDP;
(function (CDP) {
    var Framework;
    (function (Framework) {
        /**
         * @en Orientation code
         * @ja orientation 識別子
         */
        var Orientation;
        (function (Orientation) {
            Orientation[Orientation["PORTRAIT"] = 0] = "PORTRAIT";
            Orientation[Orientation["LANDSCAPE"] = 1] = "LANDSCAPE";
        })(Orientation = Framework.Orientation || (Framework.Orientation = {}));
        /**
         * @en Get Orientation enum code
         * @ja Orientation の取得
         */
        function getOrientation() {
            var $window = $(window);
            return ($window.width() < $window.height()) ? Orientation.PORTRAIT : Orientation.LANDSCAPE;
        }
        Framework.getOrientation = getOrientation;
    })(Framework = CDP.Framework || (CDP.Framework = {}));
})(CDP || (CDP = {}));

/* tslint:disable:max-line-length forin no-bitwise */
var CDP;
(function (CDP) {
    var Promise = CDP.Promise;
    /**
     * @en The function returned Promise waits until `cordova` is ready. <br>
     *     [Note] emulate when PC enviroment.
     *
     * @ja `cordova` が有効になるまで待機 <br>
     *     PC 環境ではエミュレートされる。
     */
    function waitForDeviceReady() {
        return new Promise(function (resolve) {
            if (!CDP.Framework.Platform.Mobile) {
                setTimeout(function () {
                    resolve();
                }, 100);
            }
            else {
                if (null == CDP.global.cordova || null == CDP.global.cordova.exec) {
                    $(document).one("deviceready", function () {
                        resolve();
                    });
                }
                else {
                    resolve();
                }
            }
        });
    }
    CDP.waitForDeviceReady = waitForDeviceReady;
    var _defaultBackButtonHandler = null;
    /**
     * @en Setup H/W Back key handler.
     * @ja H/W Back key ハンドラの設定関数
     *
     * @param
     * - `en` handler function.
     * - `ja` handler 指定.
     * @returns
     * - `en` old handler function.
     * - `ja` 以前の handler.
     */
    function setBackButtonHandler(handler) {
        var oldHandler = _defaultBackButtonHandler;
        _defaultBackButtonHandler = handler;
        return oldHandler;
    }
    CDP.setBackButtonHandler = setBackButtonHandler;
    // back key handler implement.
    (function () {
        waitForDeviceReady()
            .then(function () {
            $(document).on("backbutton", function (event) {
                if (_defaultBackButtonHandler) {
                    _defaultBackButtonHandler(event);
                }
            });
        });
    })();
    //___________________________________________________________________________________________________________________//
    var Framework;
    (function (Framework) {
        var TAG = "[CDP.Framework] ";
        var _dfInitialize = $.Deferred();
        /**
         * @en Initialization function of Framework.
         * @ja Framework の初期化関数
         */
        function initialize(options) {
            if ("pending" !== _dfInitialize.state()) {
                return _dfInitialize.promise();
            }
            // CDP 環境の初期化
            // 現状は、console オブジェクトの保証と jQuery の WinRT 対応。
            CDP.initialize({
                success: function () {
                    var config = getConfig(options);
                    // Framework 用の Patch 適用 (Framework 初期化前)
                    if (config.applyPatch) {
                        Framework.Patch.applyBeforeInit();
                    }
                    // config の反映: jquery
                    config.applyJQueryConfig();
                    // jQuery Mobile の初期化
                    $(document).on("mobileinit", function () {
                        // config の反映: jquery mobile
                        config.applyJQueryMobileConfig();
                        // cdp.i18n の初期化
                        CDP.initializeI18N(config.i18n)
                            .always(function (info) {
                            // i18next の初期化時のエラーは無視する. info が array の場合、エラー情報が格納されている.
                            $(document)
                                .one("pagebeforechange", function (event, data) {
                                data.options.showLoadMsg = false;
                            })
                                .on("pagebeforecreate", function (event) {
                                // i18nextライブラリによるhtml fragmentの翻訳処理
                                $(event.target).localize();
                            });
                            // Router の初期化
                            if (Framework.Router._initialize({
                                anchorVclick: config.anchorVclick,
                                firstPageTransition: config.firstPageTransition,
                            })) {
                                // Framework 用の Patch 適用 (Framework 初期化後)
                                if (config.applyPatch) {
                                    Framework.Patch.applyAfterInit();
                                }
                                _dfInitialize.resolve();
                            }
                            else {
                                _dfInitialize.reject(CDP.makeErrorInfo(CDP.RESULT_CODE.ERROR_CDP_FRAMEWORK_ROUTER_INITIALIZE_FAILED, TAG, "error. CDP.Framework.Router.initialize() failed."));
                                _dfInitialize = $.Deferred();
                            }
                        });
                    });
                    {
                        // jquery 3+
                        var jqueryMajor = ~~$.fn.jquery.split(".")[0];
                        if (3 <= jqueryMajor) {
                            if (4 <= jqueryMajor) {
                                console.warn(TAG + "jquery-migrate for 3.0.0+ in use.");
                            }
                            new Promise(function(resolve) { resolve(); }).then(function() { var __WEBPACK_AMD_REQUIRE_ARRAY__ = [__webpack_require__(5)]; (function () {
                                new Promise(function(resolve) { resolve(); }).then(function() {[__webpack_require__(1)];}).catch(__webpack_require__.oe);
                            }.apply(null, __WEBPACK_AMD_REQUIRE_ARRAY__));}).catch(__webpack_require__.oe);
                        }
                        else {
                            new Promise(function(resolve) { resolve(); }).then(function() {[__webpack_require__(1)];}).catch(__webpack_require__.oe);
                        }
                    }
                },
                fail: function (error) {
                    _dfInitialize.reject(CDP.makeErrorInfo(CDP.RESULT_CODE.ERROR_CDP_FRAMEWORK_INITIALIZE_FAILED, TAG, "error. CDP.initialize() failed.", error));
                    _dfInitialize = $.Deferred();
                },
            });
            return _dfInitialize.promise();
        }
        Framework.initialize = initialize;
        /**
         * @en Check for initialization status.
         * @ja 初期化済みか判定
         *
         * @returns
         * - `en` true: initialized / false: uninitialized
         * - `ja` true: 初期化済み / false: 未初期化
         */
        function isInitialized() {
            return "resolved" === _dfInitialize.state();
        }
        Framework.isInitialized = isInitialized;
        /**
         * @en Wait for initialization status.
         * @ja 初期化待ち
         */
        function waitForInitialize() {
            return _dfInitialize.promise();
        }
        Framework.waitForInitialize = waitForInitialize;
        var _orientationListenerHolder = {};
        /**
         * @en Register IOrientationChangedListener to framework.
         * @ja IOrientationChangedListener を Framework に登録
         *
         * @param key
         *  - `en` ID key
         *  - `ja` クライアントで管理可能な ID
         * @param listener
         *  - `en` IOrientationChangedListener instance
         *  - `ja` IOrientationChangedListener インスタンス
         */
        function registerOrientationChangedListener(key, listener) {
            _orientationListenerHolder[key] = listener;
        }
        Framework.registerOrientationChangedListener = registerOrientationChangedListener;
        /**
         * @en Unregister IOrientationChangedListener from framework.
         * @ja IOrientationChangedListener を Framework から登録解除
         *
         * @param key
         *  - `en` ID key by using register
         *  - `ja` 登録時に使用した ID
         */
        function unregisterOrientationChangedListener(key) {
            delete _orientationListenerHolder[key];
        }
        Framework.unregisterOrientationChangedListener = unregisterOrientationChangedListener;
        var _activePage = null;
        /**
         * @en Setup event handlers when after router initialized.
         * @ja イベントハンドラの設定. Router 初期化後に Framework がコールする.
         *
         * @internal
         */
        function _setupEventHandlers() {
            (function () {
                var oldBackButtonHandler = CDP.setBackButtonHandler(null);
                var baseBackButtonHandler = function (event) {
                    if (_activePage && _activePage.onHardwareBackButton(event)) {
                        // クライアント側でハンドリング済みと指定された場合、既定の処理を行わない
                        return;
                    }
                    else {
                        oldBackButtonHandler(event);
                    }
                };
                CDP.setBackButtonHandler(baseBackButtonHandler);
            })();
            (function () {
                var oldRouteChangeHandler = CDP.Framework.setBeforeRouteChangeHandler(null);
                var baseRouteChangeHandler = function () {
                    if (_activePage) {
                        return _activePage.onBeforeRouteChange();
                    }
                    else {
                        return oldRouteChangeHandler();
                    }
                };
                CDP.Framework.setBeforeRouteChangeHandler(baseRouteChangeHandler);
            })();
        }
        Framework._setupEventHandlers = _setupEventHandlers;
        var _lastOrientation = null;
        /**
         * @en Setup active IPage instance.
         * @ja active Page の設定. Framework がコールする.
         *
         * @internal
         */
        function _setActivePage(page) {
            _activePage = page;
            if (_activePage) {
                _lastOrientation = Framework.getOrientation();
            }
        }
        Framework._setActivePage = _setActivePage;
        /**
         * @en Reterns framework default click event string.
         * @ja Framework が既定に使用するクリックイベント文字列を取得
         *
         * @returns "vclick" / "click"
         */
        function getDefaultClickEvent() {
            return Framework.Patch.s_vclickEvent;
        }
        Framework.getDefaultClickEvent = getDefaultClickEvent;
        var _pageConstructors = [];
        var _pageInstances = [];
        /**
         * @en Register Concrete IPage class. <br>
         *     If constructor needs arguments, use bind() function.
         * @ja Page の登録 <br>
         *     constructor を指定する. 引数がある場合は、bind を行うこと
         *
         * @param ctor
         *  - `en` Concrete IPage class constructor
         *  - `ja` コンストラクタを指定
         */
        function registerPage(ctor) {
            _pageConstructors.push(ctor);
        }
        Framework.registerPage = registerPage;
        /**
         * @en Page instances are generated from the reserved constructor.
         * @ja 予約されたコンストラクタからPage インスタンスを生成
         */
        function constructPages() {
            _pageConstructors.forEach(function (ctor) {
                _pageInstances.push(new ctor());
            });
            _pageConstructors = [];
        }
        Framework.constructPages = constructPages;
        /**
         * @en Release Page instance reference
         * @ja Page インスタンスの参照を破棄
         */
        function disposePages() {
            _pageInstances = [];
        }
        Framework.disposePages = disposePages;
        /**
         * @en Get Config object.
         * @ja Config object の取得
         *
         * @internal
         */
        function getConfig(options) {
            var defConfig = {
                // for fail safe, default settings.
                jquery: {
                    ajaxSetup: { cache: false },
                    migrateMute: true,
                },
                jquerymobile: {
                    allowCrossDomainPages: true,
                    defaultPageTransition: "platform-default",
                    defaultDialogTransition: "platform-default",
                    hashListeningEnabled: false,
                    pushStateEnabled: false,
                    // @see jquery.mobile.js LINE 6394
                    transitionHandler: {
                        defaultHandler: "simultaneous",
                        sequential: ["fade", "flip", "flow"],
                        simultaneous: [],
                    },
                },
                i18n: {
                    fallbackResources: {},
                    options: {},
                },
                applyPatch: true,
                anchorVclick: true,
                firstPageTransition: false,
                applyJQueryConfig: function () {
                    var _this = this;
                    Object.keys(this.jquery).forEach(function (key) {
                        if ("ajaxSetup" === key) {
                            $.ajaxSetup(_this.jquery.ajaxSetup);
                        }
                        else {
                            $[key] = _this.jquery[key];
                        }
                    });
                },
                applyJQueryMobileConfig: function () {
                    var _this = this;
                    $.mobile.loader.prototype.options.text = undefined;
                    Object.keys(this.jquerymobile).forEach(function (key) {
                        if ("transitionHandler" === key) {
                            var $mobile_1 = $.mobile;
                            // default handler
                            $mobile_1.defaultTransitionHandler
                                = $mobile_1.transitionHandlers[_this.jquerymobile.transitionHandler.defaultHandler];
                            // simultaneous handler
                            _this.jquerymobile.transitionHandler.simultaneous.forEach(function (transition) {
                                $mobile_1.transitionHandlers[transition] = $mobile_1.transitionHandlers.simultaneous;
                            });
                            // sequential handler
                            _this.jquerymobile.transitionHandler.sequential.forEach(function (transition) {
                                $mobile_1.transitionHandlers[transition] = $mobile_1.transitionHandlers.sequential;
                            });
                        }
                        else {
                            $.mobile[key] = _this.jquerymobile[key];
                        }
                    });
                },
            };
            return $.extend(true, {}, defConfig, CDP.Config, options);
        }
        ///////////////////////////////////////////////////////////////////////
        // closure methods
        // resize handler
        $(window).on("resize", function (event) {
            var newOrientation = Framework.getOrientation();
            if (_lastOrientation !== newOrientation) {
                for (var key in _orientationListenerHolder) {
                    _orientationListenerHolder[key].onOrientationChanged(newOrientation);
                }
                if (_activePage) {
                    _activePage.onOrientationChanged(newOrientation);
                }
                _lastOrientation = newOrientation;
            }
        });
    })(Framework = CDP.Framework || (CDP.Framework = {}));
})(CDP || (CDP = {}));

/* tslint:disable:max-line-length no-string-literal */
var CDP;
(function (CDP) {
    var Framework;
    (function (Framework) {
        var Promise = CDP.Promise;
        var TAG = "[CDP.Framework.Router] ";
        ///////////////////////////////////////////////////////////////////////
        // closure methods
        /**
         * @en Convert path to URL. <br>
         *     If the path starts from "/", the function translate the path as child folder of "web root". <br>
         *     Otherwise, it interprets as relative path from current page. <br>
         *     [Note] This behavior go along with jQM, NOT with require.toUrl().
         *
         * @ja path を URL に変換 <br>
         *     "/" から始まるものは web root から、それ以外は現在のページから絶対パスURLに変換する。 <br>
         *     jQM の挙動にあわせており、require.toUrl() と異なるので注意。
         *
         * @param path
         *  - `en` set relative path from [[webRoot]], or relative path from current scirpt owner html (It doesn't start from "/").
         *  - `ja` [[webRoot]] からの相対パス, もしくはカレントスクリプトを走らせている HTML からの相対パス ("/" なし).
         */
        function toUrl(path) {
            if (null != path[0] && "/" === path[0]) {
                return CDP.toUrl(path);
            }
            else {
                return $.mobile.path.makeUrlAbsolute(path, getCurrentDocumentUrl());
            }
        }
        Framework.toUrl = toUrl;
        /**
         * @en Get current document url.
         * @ja 現在表示しているドキュメントの URL を取得
         *
         * @internal
         */
        function getCurrentDocumentUrl() {
            var $activePage = $("body").pagecontainer("getActivePage");
            if (null == $activePage) {
                return $.mobile.path.documentBase.hrefNoHash;
            }
            var base = $.mobile.path.documentBase.hrefNoHash;
            var url = $.mobile.activePage.closest(".ui-page").jqmData("url");
            if (!url || !$.mobile.path.isPath(url)) {
                url = base;
            }
            return $.mobile.path.makeUrlAbsolute(url, base);
        }
        /**
         * @en Default "before route change" handler.
         * @ja 既定の "before route change" ハンドラ
         *
         * @internal
         */
        var _beforeRouteChange = function () {
            return Promise.resolve();
        };
        // default "before route change" hanndler
        var _defaultBeforeRouteChange = _beforeRouteChange;
        /**
         * @en Setup "before route change" handler.
         * @ja "before route change" ハンドラ設定
         *
         * @internal
         *
         * @param
         *  - `en` handler function.
         *  - `ja` handler 指定.
         * @returns
         *  - `en` old handler function.
         *  - `ja` 以前の handler.
         */
        function setBeforeRouteChangeHandler(handler) {
            if (null == handler) {
                return _beforeRouteChange;
            }
            else {
                var oldHandler = _beforeRouteChange;
                _beforeRouteChange = handler;
                return oldHandler;
            }
        }
        Framework.setBeforeRouteChangeHandler = setBeforeRouteChangeHandler;
        //___________________________________________________________________________________________________________________//
        /**
         * @en Router class for adjusting jQueryMobile functions and Backbone.Router functions. <br>
         *     Even if Backbone.Router does not start routing, natigate() method works good with jQM framework.
         *
         * @ja jQueryMobile と Backbone.Router を調停する Router クラス <br>
         *     ルーティングを開始していない場合にも、navigate() は jQM フレームワークを使用して機能する。
         */
        var Router = /** @class */ (function () {
            function Router() {
            }
            ///////////////////////////////////////////////////////////////////////
            // public static methods
            /**
             * @en for initialize Router. this function is called in framework.
             * @ja この関数はフレームワーク内部で使用される。
             *
             * @internal
             *
             * @param  options
             *  - `en` init options
             *  - `ja` 初期化オプション
             * @returns
             *  - `en` true: succeeded / false: failed.
             *  - `ja` true: 成功 / 失敗
             */
            Router._initialize = function (options) {
                var $body = $("body");
                if (!!Router.s_router) {
                    console.warn(TAG + "logic error. initialize call twice.");
                    return false;
                }
                Router.s_initOptions = $.extend({}, Router.s_defaultInitOptions, options);
                if (Router.s_initOptions.firstPageTransition) {
                    Router.s_firstChangePage = false;
                }
                // Backbone.Router が、route を解決できなかった場合にも通知を捕捉するためのコールバックを設定
                Router.s_loadUrl = _.bind(Backbone.history.loadUrl, Backbone.history);
                Backbone.history.loadUrl = Router.customLoadUrl;
                Router.s_router = new Backbone.Router();
                Router.s_router.on("route", Router.onRouteSucceeded);
                // Backbone.Router を使用している場合、$.mobile.back() の挙動をブラウザの[戻る]に統一
                if (!$.mobile.hashListeningEnabled) {
                    Router.s_back = _.bind($.mobile.back, $.mobile);
                    $.mobile.back = Router.customJqmBack;
                }
                // changePage をサポート
                if (null == $.mobile.changePage) {
                    $.mobile.changePage = function (to, opt) {
                        $body.pagecontainer("change", to, opt);
                    };
                }
                Router.bindEvents();
                // Framework のイベントハンドラを更新
                Framework._setupEventHandlers();
                return true;
            };
            /**
             * @en Register to Router.
             * @ja Router への登録.
             *
             * @param route
             *  - `en` route string, it can be regular expression.
             *  - `ja` ルーティング文字列 / 正規表現
             * @param page
             *  - `en` page template path.
             *  - `ja` page template path. イベント名にも使用される
             * @param top
             *  - `en` set "true" if application's top view. (optional)
             *  - `ja` Top ページの場合は true を指定 (任意)
             * @param callback
             *  - `en` callback for custom page transition. If you don't want to trigger jQM.changePage(), return true by this callback. (optional)
             *  - `ja` 遷移を自身で管理する場合に指定し、戻り値を true に設定すると changePage をコールしない (任意)
             * @returns
             *  - `en` Router instance.
             *  - `ja` インスタンス。ただし method chain をしたい場合は、any cast が必要。
             */
            Router.register = function (route, page, top, callback) {
                if (top === void 0) { top = false; }
                // Backbone.Router への登録は history の停止が必要
                var restart = Router.stop();
                var name = route + page;
                var context = {
                    route: route,
                    regexp: Router.s_router._routeToRegExp(route),
                    page: page,
                    top: top,
                    callback: callback || function () { return false; }
                };
                if (Router.pushContext(name, context)) {
                    Router.s_router.route(route, name, function () { });
                }
                if (restart) {
                    // 再開時は再読み込みしない。
                    Router.start({ silent: true, pageConstruct: false });
                }
                return Router;
            };
            /**
             * @en Start listening hash change. <br>
             *     It should be called after register().
             *
             * @ja 履歴監視の開始 <br>
             *     登録完了後にクライアントが呼ぶことでページ遷移が開始される。
             *
             * @param options
             *  - `en` options object for Backbone.History.
             *  - `ja` Backbone.History にわたるオプション
             */
            Router.start = function (options) {
                var opt = $.extend({ pageConstruct: true }, options);
                if (opt.pageConstruct) {
                    Framework.constructPages();
                }
                if ($.mobile.hashListeningEnabled) {
                    console.error(TAG + "setting error. confict: $.mobile.hashListeningEnabled = true, cannot start.");
                    return;
                }
                Backbone.history.start(opt);
            };
            /**
             * @en Stop listening hash change.
             * @ja 履歴監視の停止
             *
             * @returns
             *  - `en` previous status.
             *  - `ja` 以前の開始状態を返却
             */
            Router.stop = function () {
                var prevState = Backbone.History.started;
                Backbone.history.stop();
                return prevState;
            };
            /**
             * @en Check routing status.
             * @ja ルーティングを開始しているか判定
             *
             * @returns
             *  - `en` true: routing / false: not routing
             *  - `en` true: 有効 / false: 無効
             */
            Router.isRouting = function () {
                return Backbone.History.started;
            };
            /**
             * @en URL navigation.
             * @ja URL遷移
             *
             * @param url
             *  - `en` set a navigate URL. (relative path / absolute path / fragment)
             *  - `ja` 遷移 URL を指定 (相対パス/絶対パス/フラグメント)
             * @param transition
             *  - `en` set a transition string.
             *  - `ja` transition に使用する effect を指定
             * @param reverse
             *  - `en` set a direction string for transition. true:reverse / false:nomal
             *  - `ja` transition に使用する direction を指定 true:reverse/false:通常
             * @param options
             *  - `en` set a options object for Backbone.Router.navigate().
             *  - `ja` Backbone.Router.navigate() に渡されるオプション
             */
            Router.navigate = function (url, transition, reverse, options) {
                if (!!Router.s_lastNavigateInfo.inNavigation) {
                    // すでに Navigation 中であれば抑止
                    console.warn(TAG + "Router.navigate() called in navigation proc.");
                    return;
                }
                else if (Router.initFirstPageIfNeeded(url)) {
                    return;
                }
                var navOptions = $.extend({}, Router.s_defaultNavigateOptions, options);
                // ページ遷移開始通知. Sub Flow にてすでにコールされている場合は既定の何もしないコールバックを使用する.
                var notifyBeforeRouteChange = Router.s_lastNavigateInfo.calledBeforeRouteChange ? _defaultBeforeRouteChange : _beforeRouteChange;
                Router.s_lastNavigateInfo = {
                    url: url,
                    transition: transition,
                    reverse: reverse,
                    backDestination: navOptions.backDestination,
                    noHashChange: navOptions.noHashChange,
                    intent: navOptions.intent || {},
                    positiveNavigate: true,
                    calledBeforeRouteChange: true,
                    inNavigation: true,
                };
                // ページ遷移開始通知
                notifyBeforeRouteChange()
                    .fail(function () {
                    // beforeRouteChange() が失敗した場合、致命的な不具合となるため、error 記録のみにして先に進む。
                    console.error(TAG + "before route change call, failed.");
                })
                    .always(function () {
                    if (Router.isRouting() && !Router.s_lastNavigateInfo.noHashChange) {
                        if (navOptions.subFlow) {
                            switch (navOptions.subFlow.operation) {
                                case "begin":
                                    Router.startSubFlow(navOptions.subFlow);
                                    break;
                                case "end":
                                    Router.finishSubFlow(navOptions);
                                    return; // navigation は呼ばない
                                default:
                                    console.warn(TAG + "unknown subFlow.operation. operation: " + navOptions.subFlow.operation);
                                    break;
                            }
                        }
                        var result = Backbone.history.navigate(url, navOptions);
                        // Backbone.history.loadUrl() がコールされなかった場合, navigation 終了
                        if (!result || "string" === typeof result) {
                            Router.s_lastNavigateInfo.inNavigation = false;
                        }
                    }
                    else {
                        if (navOptions.subFlow) {
                            console.warn(TAG + "subFlow only supported under routing and hash change condition.");
                        }
                        var fragment_1 = Backbone.history.getFragment(url);
                        var context = void 0;
                        if (Router.s_lastNavigateInfo.noHashChange) {
                            // noHashChange が指定されたとき
                            context = _.find(Router.s_rootContexts, function (ctx) {
                                return ctx.regexp.test(fragment_1);
                            });
                        }
                        else {
                            // Backbone.Router が有効でないとき
                            context = _.findWhere(Router.s_rootContexts, { route: fragment_1 });
                        }
                        if (context) {
                            url = context.page;
                        }
                        Router.changePage(url);
                    }
                });
            };
            /**
             * @en Navigate from Top Page. <br>
             *     If SubFlow set up, the param is cleared.
             *
             * @ja トップページからの画面遷移 <br>
             *     SubFlow が指定されていた場合はクリアされる
             * @param to
             *  - `en` set a navigate URL or PageStackOptions object or array.
             *  - `ja` 遷移 URL / PageStackOptions オブジェクト/配列
             * @param transition
             *  - `en` set a transition string
             *  - `ja` transition に使用する effect を指定
             * @param reverse
             *  - `en` set a direction string for transition. true:reverse / false:nomal
             *  - `ja` transition に使用する direction を指定 true:reverse/false:通常
             * @param options
             *  - `en` set a options object for Backbone.Router.navigate().
             *  - `ja` Backbone.Router.navigate() に渡されるオプション
             */
            Router.navigateFromTop = function (to, transition, reverse, options) {
                var stack = Router._getJqmHistory().stack;
                var currentPage = stack[Router._getJqmHistory().activeIndex];
                var _transition = transition || currentPage.transition;
                var _reverse = (null != reverse) ? reverse : true;
                var destStacks = (function () {
                    if (!to) {
                        return null;
                    }
                    else if ("string" === typeof to) {
                        return [{ route: to }];
                    }
                    else if (to instanceof Array) {
                        return to;
                    }
                    else {
                        return [to];
                    }
                })();
                // 指定された SubFlow を削除
                stack.forEach(function (value) {
                    delete value[Router.SUBFLOW_PARAM];
                });
                // 初期ページに SubFlow パラメータを指定
                stack[0][Router.SUBFLOW_PARAM] = {
                    operation: "begin",
                    destBase: stack[0].hash,
                    destStacks: destStacks,
                    additionalDistance: 0,
                };
                Router.navigate(null, _transition, _reverse, $.extend({}, options, {
                    subFlow: {
                        operation: "end",
                    }
                }));
            };
            /**
             * @ en Back to previous history. <br>
             *      It's same as browser back button's behaviour. <br>
             *      [Note] If set the jQM: data-rel="back", work as well.
             *
             * @ja 履歴を戻る <br>
             *     ブラウザの戻るボタンと同じ挙動。 <br>
             *     jQM: data-rel="back" を指定しても同じであることに注意。
             */
            Router.back = function () {
                if (!!Router.s_lastNavigateInfo.inNavigation) {
                    // すでに Navigation 中であれば抑止
                    console.warn(TAG + "Router.back() called in navigation proc.");
                    return;
                }
                else if (Router.isTopPage()) {
                    // Top ページに指定されていれば終了
                    var app = navigator.app || {};
                    if (!!app.exitApp) {
                        app.exitApp(); // note: never exit on iOS
                        return;
                    }
                }
                Router.s_lastNavigateInfo = {
                    inNavigation: true,
                    calledBeforeRouteChange: true,
                };
                // ページ遷移開始通知
                _beforeRouteChange()
                    .then(function () {
                    $.mobile.back();
                })
                    .fail(function () {
                    console.error("before route change call, failed.");
                    Router.s_lastNavigateInfo = {};
                });
            };
            /**
             * @en Store Intent object by framwork.
             * @ja Intent を格納。 フレームワークが使用する。
             *
             * @internal
             */
            Router._pushIntent = function (intent) {
                Router.s_lastIntent = $.extend(true, Router.s_lastIntent, intent);
            };
            /**
             * @en Get Intent object by framework.
             * @ja Intent を取得。フレームワークが使用する。
             *
             * @internal
             */
            Router._popIntent = function () {
                var intent = Router.s_lastIntent;
                Router.s_lastIntent = {};
                return intent;
            };
            /**
             * @en Get query parameters. <br>
             *     It can be accessed during "pagebeforecreate" to "pagechange".
             * @ja query parameter に指定された引数の取得 <br>
             *     ページ遷移中にのみアクセス可能 (pagebeforecreate ～ pagechange)
             */
            Router.getQueryParameters = function () {
                if (Router.s_lastNavigateInfo.intent && Router.s_lastNavigateInfo.intent.params) {
                    return Router.s_lastNavigateInfo.intent.params["queryParams"];
                }
                else {
                    return null;
                }
            };
            /**
             * @en Begin sub flow transaction.
             * @ja sub flow トランザクションの開始
             *
             * @param url
             *  - `en` set a navigate URL. (relative path / absolute path / fragment)
             *  - `ja` 遷移 URL を指定 (相対パス/絶対パス/フラグメント)
             * @param options
             *  - `en` set a options object for Backbone.Router.navigate().
             *  - `ja` Backbone.Router.navigate() に渡されるオプション
             * @param transition
             *  - `en` set a transition string
             *  - `ja` transition に使用する effect を指定
             * @param reverse
             *  - `en` set a direction string for transition. true:reverse / false:nomal
             *  - `ja` transition に使用する direction を指定 true:reverse/false:通常
             */
            Router.beginSubFlow = function (url, options, transition, reverse) {
                var opt = $.extend({}, options);
                opt.subFlow = opt.subFlow || { operation: "begin" };
                if ("begin" !== opt.subFlow.operation) {
                    console.error(TAG + "logic error. invalid subflow operation. [operation: " + opt.subFlow.operation + "]");
                    return;
                }
                Router.navigate(url, transition, reverse, opt);
            };
            /**
             * @en Commit sub flow transaction.
             * @ja sub flow トランザクションの終了
             *
             * @param transition
             * - `en` set a transition string
             * - `ja` transition に使用する effect を指定
             * @param reverse
             * - `en` set a direction string for transition. true:reverse / false:nomal
             * - `ja` transition に使用する direction を指定 true:reverse/false:通常
             */
            Router.commitSubFlow = function (transition, reverse) {
                Router.navigate(null, transition, reverse, {
                    subFlow: {
                        operation: "end",
                    }
                });
            };
            /**
             * @en Cancel sub flow transaction.
             * @ja sub flow トランザクションのキャンセル
             *
             * @param transition
             *  - `en` set a transition string
             *  - `ja` transition に使用する effect を指定
             * @param reverse
             *  - `en` set a direction string for transition. true:reverse[default] / false:nomal
             *  - `ja` transition に使用する direction を指定 true:reverse[既定]/false:通常
             */
            Router.cancelSubFlow = function (transition, reverse) {
                // 起点のページに戻る
                var baseInfo = Router.detectSubFlowBaseInfo();
                baseInfo.subFlowParam.additionalDistance = 0;
                Router.navigate(null, transition, (null != reverse) ? reverse : true, {
                    subFlow: {
                        operation: "end",
                        destStacks: null,
                    }
                });
            };
            /**
             * @en Check in sub flow.
             * @ja sub flow 内であるか判定
             */
            Router.isInSubFlow = function () {
                var stack = Router._getJqmHistory().stack;
                var has = _.some(stack, function (value) {
                    return !!value[Router.SUBFLOW_PARAM];
                });
                return has;
            };
            /**
             * @en Check from hash changed navigation.
             * @ja Hash 変更によって Navigate が起こったか判定. "pagechange" が発生するまでに判定可能
             */
            Router.fromHashChanged = function () {
                // positiveNavigate = false は含めない
                return Router.s_lastNavigateInfo.inNavigation && (null == Router.s_lastNavigateInfo.positiveNavigate);
            };
            Router.registerPageStack = function (pageStack, withNavigate, options) {
                var newStacks = [];
                var failed = false;
                pageStack = (pageStack instanceof Array) ? pageStack : [pageStack];
                withNavigate = (null == withNavigate) ? false : withNavigate;
                (function () {
                    var makeStack = function (info) {
                        var url;
                        var fragment = Backbone.history.getFragment(info.route);
                        var context = _.find(Router.s_rootContexts, function (ctx) {
                            return ctx.regexp.test(fragment);
                        });
                        if (!context) {
                            console.warn(TAG + "route is not registered. route: " + info.route);
                            return null;
                        }
                        else {
                            url = Router.pathToJqmDataUrl(context.page);
                        }
                        var stack = {
                            route: info.route,
                            pageUrl: url,
                            title: info.title,
                            transition: info.transition,
                            url: url,
                        };
                        return stack;
                    };
                    for (var i = 0, n = pageStack.length; i < n; i++) {
                        var stack = makeStack(pageStack[i]);
                        if (!stack) {
                            failed = true;
                            break;
                        }
                        else {
                            newStacks.push(stack);
                        }
                    }
                })();
                if (failed) {
                    return false;
                }
                (function () {
                    // Router の停止
                    var restart = Router.stop();
                    var silentLength = newStacks.length - 1;
                    var finalIndex = newStacks.length - 1;
                    Router._getJqmHistory().clearForward();
                    for (var i = 0, n = silentLength; i < n; i++) {
                        location.hash = newStacks[i].route;
                        Router._getJqmHistory().stack.push(newStacks[i]);
                        Router._getJqmHistory().activeIndex = Router._getJqmHistory().stack.length - 1;
                    }
                    // final stack with navigate
                    if (withNavigate) {
                        var transition = (function () {
                            if (null != Router.s_lastNavigateInfo.transition) {
                                return Router.s_lastNavigateInfo.transition;
                            }
                            else {
                                return newStacks[finalIndex].transition;
                            }
                        })();
                        var reverse = (function () {
                            if (null != Router.s_lastNavigateInfo.reverse) {
                                return Router.s_lastNavigateInfo.reverse;
                            }
                            else {
                                return false;
                            }
                        })();
                        restart = false;
                        Router.start({ silent: true });
                        Router.navigate(newStacks[finalIndex].route, transition, reverse, options);
                    }
                    else {
                        location.hash = newStacks[finalIndex].route;
                        Router._getJqmHistory().stack.push(newStacks[finalIndex]);
                        Router._getJqmHistory().activeIndex = Router._getJqmHistory().stack.length - 1;
                    }
                    // Router の再開
                    if (restart) {
                        Router.start({ silent: true });
                    }
                })();
                return true;
            };
            /**
             * @en Get jQM's history object
             * @ja jQM の History オブジェクトの取得
             *
             * @internal
             */
            Router._getJqmHistory = function () {
                return $.mobile.navigate.history;
            };
            ///////////////////////////////////////////////////////////////////////
            // private static methods
            /**
             * @en Override: Backbone.History.loadUrl().
             * @ja Backbone.History.loadUrl() のオーバーライド
             */
            Router.customLoadUrl = function (fragment) {
                var handled = Router.s_loadUrl(fragment);
                if (!handled) {
                    Router.onRouteFailed(fragment);
                }
                return true;
            };
            /**
             * @en Override: $.mobile.back().
             *  - fail safe processing. <br>
             *    If using Backbone's Router, <br>
             *    this class unuses history object of jQuery Mobile 1.4, <br>
             *    and standardize as browser back button's behaviour. (jQM 1.3 comparable)
             *
             * @ja $.mobile.back() のオーバーライド
             *  - [TBD] fail safe 処理 <br>
             *    Backbone の Router を使用している場合、 <br>
             *    jQuery Mobile 1.4 以降の内部の History 管理は使用せずに <br>
             *    1.3 相当のブラウザの[戻る]の挙動に統一する。
             */
            Router.customJqmBack = function () {
                if (Router.isRouting()) {
                    history.back();
                }
                else {
                    // jQM 既定処理
                    Router.s_back();
                }
            };
            /**
             * \~english
             * Bind events.
             *
             * @private
             *
             * \~japanese
             * イベントバインド
             *
             * @private
             */
            Router.bindEvents = function () {
                $(document)
                    .one("pagechange", function () {
                    if (Router.s_initOptions.anchorVclick) {
                        // anchor vclick
                        $(document).on("vclick", "[href]", function (event) {
                            Router.onAnchorVclicked(event);
                        });
                    }
                })
                    .on("pagebeforeshow", function (event) {
                    // "data-back-dst" を page に設定
                    if (null != Router.s_lastNavigateInfo.backDestination) {
                        var active = Router._getJqmHistory().getActive();
                        active[Router.BACK_DESTINATION_URL] = Router.s_lastNavigateInfo.backDestination;
                    }
                })
                    .on("pageshow", function (event) {
                    var active = Router._getJqmHistory().getActive();
                    if (active[Router.SUBFLOW_PARAM]) {
                        delete active[Router.SUBFLOW_PARAM];
                    }
                })
                    .on("pagechange pagecontainerloadfailed", function (event) {
                    Router.s_lastNavigateInfo = {};
                });
                // back key assign
                CDP.setBackButtonHandler(Router.back);
            };
            /**
             * @en Store the RootContext.
             * @ja RootContext の格納
             *
             * @param name
             *  - `en` name of route
             *  - `ja` route 名
             * @param context
             *  - `en` context object
             *  - `ja` context オブジェクト
             * @returns
             *  - `en` true: succeeded / false: already registered
             *  - `ja` true: 登録成功 / false: すでに登録されている
             */
            Router.pushContext = function (name, context) {
                if (!!Router.s_rootContexts[name]) {
                    console.error(TAG + "logic error. route is already registered. name: " + name);
                    return false;
                }
                Router.s_rootContexts[name] = context;
                return true;
            };
            /**
             * @en Check if $.mobile.initializePage() is called or not, and call it if needed.
             * @ja  $.mobile.initializePage() が呼ばれているか確認し、必要なら初期化する。
             *
             * @param url
             *  - `en` set a navigate URL. (relative path / absolute path / fragment)
             *  - `ja` 遷移 URL を指定 (相対パス/絶対パス/フラグメント)
             */
            Router.initFirstPageIfNeeded = function (url) {
                if (!$.mobile.autoInitializePage) {
                    $(document).one("pagebeforechange", function (event, data) {
                        data.toPage = Framework.toUrl(url);
                    });
                    $.mobile.initializePage();
                    $.mobile.autoInitializePage = true;
                    return true;
                }
                return false;
            };
            /**
             * @en Check for current page is top.
             * @ja 現在のページが top に指定されているか判定
             *
             * @returns
             *  - `en` true: top page / false: not top page
             *  - `ja` true: top 指定 / false: top ではない
             */
            Router.isTopPage = function () {
                var fragment = Backbone.history.getFragment($.mobile.path.parseUrl(location.href).hash);
                var context = _.find(Router.s_rootContexts, function (ctx) {
                    return ctx.regexp.test(fragment);
                });
                return (null == context) ? false : context.top;
            };
            /**
             * @en Called when anchor received "vclick" event.
             * @ja anchor が vclick されたときにコールされる
             *
             * @returns
             *  - `en` true: need default processing / false: need custom processing
             *  - `ja` true: default 処理 / false: カスタム処理
             */
            Router.onAnchorVclicked = function (event) {
                if (Router.isJustBeforeVclicked()) {
                    event.preventDefault();
                    return false;
                }
                return Router.followAnchor(event);
            };
            /**
             * @en Anchor processing.
             * @ja anchor 処理
             */
            Router.followAnchor = function (event) {
                var $target = $(event.currentTarget);
                var url = $target.jqmData("href") || $target.attr("href");
                var transition = $target.jqmData("transition");
                var direction = $target.jqmData("direction");
                var backDst = $target.attr(Router.DATA_BACK_DESTINATION);
                var noHashChange = $target.attr(Router.DATA_NO_HASH_CHANGE) ?
                    $target.attr(Router.DATA_NO_HASH_CHANGE) === "true" : false;
                var noHrefHandle = $target.attr(Router.DATA_NO_VCLICK_HANDLE) ?
                    $target.attr(Router.DATA_NO_VCLICK_HANDLE) === "true" : false;
                /*
                 * - 明示的にハンドルしない指定がある場合
                 * - jQM のフラグメントの場合
                 * 既定の処理を行う
                 */
                if (noHrefHandle || Router.needDefaultOperation(url)) {
                    return true;
                }
                // custom behavier
                event.preventDefault();
                if (Router.isBackButtonClicked(event)) {
                    Router.back();
                }
                else {
                    Router.navigate(url, transition, !!direction, { noHashChange: noHashChange, backDestination: backDst });
                }
                return false;
            };
            /**
             * @en Check default processing needed.
             * @ja 既定の処理を行わせるか判定
             *
             * @param  url
             *  - `en` url string
             *  - `ja` url 文字列
             * @returns
             *  - `en` true: need default processing / false: need not
             *  - `ja` true: 既定の処理が必要 / false: 不要
             */
            Router.needDefaultOperation = function (url) {
                if (!url || ("#" === url)) {
                    return true;
                }
                else if ("#" === url[0]) {
                    return !Router.canResolveRoute(url);
                }
                else {
                    return false;
                }
            };
            /**
             * @en Check status of Backbone.Router if they can resolve route.
             * @ja Backbone.Router が route を解決可能か判定
             *
             * @param  url
             *  - `en` url string
             *  - `ja` url 文字列
             * @returns
             *  - `en` true: can resolve / false: can not
             *  - `ja` true: 解決可能 / false: 解決不可
             */
            Router.canResolveRoute = function (url) {
                var fragment = Backbone.history.getFragment(url);
                return _.any(Backbone.history.handlers, function (handler) {
                    if (handler.route.test(fragment)) {
                        return true;
                    }
                });
            };
            /**
             * @en Check "vclick" fired at the last minute.
             * @ja 直前に vclick が呼ばれたか判定
             */
            Router.isJustBeforeVclicked = function () {
                var isBefore = (Date.now() - Router.s_lastClickedTime) < Router.DELAY_TIME * 2;
                Router.s_lastClickedTime = Date.now();
                return isBefore;
            };
            /**
             * @en Check back button clicked.
             * @ja Back Button がクリックされたか判定
             */
            Router.isBackButtonClicked = function (event) {
                if ($(event.currentTarget).jqmData("rel") === "back") {
                    return true;
                }
                else {
                    return false;
                }
            };
            /**
             * @en It called on succeed routing triggered by changing hash.
             * @ja ハッシュ値が変更され、ルーティングが成功したときにコールされる
             *
             * @param name
             *  - `en` name of route
             *  - `ja` route 名。page の値が渡る。
             * @param args
             *  - `en` array of paramter
             *  - `ja` パラメータ配列。
             */
            Router.onRouteSucceeded = function (name) {
                var args = [];
                for (var _i = 1; _i < arguments.length; _i++) {
                    args[_i - 1] = arguments[_i];
                }
                var context = Router.s_rootContexts[name];
                if (!!context) {
                    var intent = { params: { queryParams: args } };
                    Router.s_lastNavigateInfo.inNavigation = true;
                    if (null != Router.s_lastNavigateInfo.intent) {
                        intent.params = $.extend({}, intent.params, Router.s_lastNavigateInfo.intent.params || {});
                    }
                    Router.s_lastNavigateInfo.intent = $.extend({}, Router.s_lastNavigateInfo.intent, intent);
                    var handled = context.callback(args);
                    if (!handled) {
                        Router.changePage(context.page);
                    }
                }
            };
            /**
             * @en It called on failed routing triggered by changing hash.
             * @ja ハッシュ値が変更され、ルーティングが失敗したときにコールされる
             *
             * @param name
             *  - `en` name of route
             *  - `ja` route 名。page の値が渡る。
             * @param args
             *  - `en` array of paramters
             *  - `ja` パラメータ配列。
             */
            Router.onRouteFailed = function (fragment) {
                Router.s_lastNavigateInfo.inNavigation = true;
                if (null == fragment) {
                    fragment = Backbone.history.getFragment();
                }
                // route が解決できなかったものを管理下に
                if (Router.s_lastNavigateInfo.positiveNavigate) {
                    var context = Router.s_rootContexts[fragment];
                    if (null == context) {
                        context = {
                            route: fragment,
                            regexp: Router.s_router._routeToRegExp(fragment),
                            page: Router.s_lastNavigateInfo.url,
                            top: false,
                            callback: null,
                        };
                        Router.pushContext(fragment, context);
                    }
                }
                // fragment から path を解決
                var path = fragment;
                if (null != Router.s_rootContexts[fragment]) {
                    path = Router.s_rootContexts[fragment].page;
                }
                Router.changePage(path);
            };
            /**
             * @en This function just calls jQuery Mobile's navigation method.
             * @ja jQuery Mobile によるページ遷移指定
             *
             * @param path
             *  - `en` to page path
             *  - `ja` 遷移先パスを指定
             */
            Router.changePage = function (path) {
                var notifyBeforeRouteChange;
                // data-rel="back", ブラウザボタン, H/W Back Key が押下されたとき
                if (!Router.s_lastNavigateInfo.positiveNavigate) {
                    if (Router.s_lastNavigateInfo.inAdditionalBack) {
                        Router.s_lastNavigateInfo.inAdditionalBack = false;
                    }
                    else {
                        Router.decideDirection(path);
                        // 指定先に戻るか判定
                        var additional = Router.detectAdditionalBackDistance();
                        if (0 < additional) {
                            // 2回目以降の hash change には反応させない.
                            Router.s_lastNavigateInfo.inAdditionalBack = true;
                            Router._getJqmHistory().activeIndex -= additional;
                            history.go(-additional);
                            return;
                        }
                    }
                    // 遷移先が subflow 開始点である場合、param を削除
                    var subFlowInfo = Router.detectSubFlowBaseInfo();
                    if (subFlowInfo.isCurrent) {
                        delete subFlowInfo.stack[Router.SUBFLOW_PARAM];
                    }
                }
                else {
                    // 能動的遷移の場合 previousIndex を更新
                    Router._getJqmHistory().previousIndex = Router._getJqmHistory().activeIndex;
                }
                // ページ遷移開始通知. すでにコールされている場合は既定の何もしないコールバックを使用する.
                notifyBeforeRouteChange = Router.s_lastNavigateInfo.calledBeforeRouteChange ? _defaultBeforeRouteChange : _beforeRouteChange;
                notifyBeforeRouteChange()
                    .then(function () {
                    // 付加情報
                    if (Router.s_lastNavigateInfo.intent) {
                        Router._pushIntent(Router.s_lastNavigateInfo.intent);
                    }
                    Router.treatUrlHistory();
                    var pageTransition = (function () {
                        if (Router.s_lastNavigateInfo.transition) {
                            return Router.s_lastNavigateInfo.transition;
                        }
                        else if (Router.s_firstChangePage) {
                            Router.s_firstChangePage = false;
                            return "none"; // splash からの遷移
                        }
                        else {
                            return $.mobile.defaultPageTransition;
                        }
                    })();
                    $.mobile.changePage(Framework.toUrl(path), {
                        showLoadMsg: false,
                        allowSamePageTransition: true,
                        transition: pageTransition,
                        reverse: Router.s_lastNavigateInfo.reverse,
                        fromHashChange: !Router.s_lastNavigateInfo.positiveNavigate,
                        changeHash: !Router.s_lastNavigateInfo.noHashChange,
                    });
                })
                    .fail(function () {
                    console.error(TAG + "before route change call, failed.");
                    Router.s_lastNavigateInfo = {};
                });
            };
            /**
             * @en Decide direction parameter. <br>
             *     It's as same as jQM internal implement. (imperfection)
             *
             * @ja direction の判定 <br>
             *     jQM の内部実装と等価 (不完全)
             *
             * @param path
             *  - `en` to page path
             *  - `ja` 遷移先パスを指定
             */
            Router.decideDirection = function (path) {
                var url = $.mobile.path.convertUrlToDataUrl(Framework.toUrl(path));
                if (null == Router.s_lastNavigateInfo.transition) {
                    Router.s_lastNavigateInfo.transition = Router._getJqmHistory().getActive().transition;
                }
                Router._getJqmHistory().direct({
                    url: url,
                    present: function (newPage, direction) {
                        switch (direction) {
                            case "back":
                                if (null == Router.s_lastNavigateInfo.reverse) {
                                    Router.s_lastNavigateInfo.reverse = true;
                                }
                                break;
                            case "forward":
                                if (null == Router.s_lastNavigateInfo.transition) {
                                    Router.s_lastNavigateInfo.transition = newPage.transition;
                                }
                                break;
                            default:
                                console.warn(TAG + "unknown direction: " + direction);
                                break;
                        }
                    },
                    missing: function () {
                        // 初期ページ URL は判定できない。正常系。
                        if (1 === Router._getJqmHistory().activeIndex) {
                            Router._getJqmHistory().previousIndex = 1;
                            Router._getJqmHistory().activeIndex = 0;
                            if (null == Router.s_lastNavigateInfo.reverse) {
                                Router.s_lastNavigateInfo.reverse = true;
                            }
                        }
                        else if (0 !== Router._getJqmHistory().activeIndex) {
                            console.warn(TAG + "unknown direction.");
                        }
                    }
                });
            };
            /**
             * @en Return additional back distance count when back destination set. (const function)
             * @ja 戻り先が指定されているとき、追加の Back 数を返す。(この関数は Router の状態を変更しない。)
             *
             * @returns
             *  - `en` count of additiona back distance.
             *  - `ja`追加で Back に必要な距離.
             */
            Router.detectAdditionalBackDistance = function () {
                var stack = Router._getJqmHistory().stack;
                var historyActiveIndex = Router._getJqmHistory().activeIndex; // decideDirection() の Router._getJqmHistory().direct() によって、history の activeIndex はすでに変わっている
                var previousIndex = Router._getJqmHistory().previousIndex; // [戻る]が押下された場合に値が入る
                var i, backDst, distance, fragment, context, jqmDataUrl;
                // check "operation". [戻る]および clearForward() されていない状況をチェック
                if (!Router.s_lastNavigateInfo.reverse || null == previousIndex || !stack[previousIndex]) {
                    return 0;
                }
                // "backDst exists". [戻り先]が指定されているかチェック
                backDst = stack[previousIndex][Router.BACK_DESTINATION_URL];
                if ((null == backDst)) {
                    return 0;
                }
                fragment = Backbone.history.getFragment(backDst);
                // 初期ページ
                if ("" === fragment) {
                    return historyActiveIndex;
                }
                // rootContext から path を逆引き
                context = _.find(Router.s_rootContexts, function (ctx) {
                    return ctx.regexp.test(fragment);
                });
                if (null == context) {
                    console.warn(TAG + "back destination is not registered. back-dst: " + backDst);
                    return 0;
                }
                // dataUrl を元に jQM History を検索
                jqmDataUrl = Router.pathToJqmDataUrl(context.page);
                for (i = historyActiveIndex, distance = 0; 0 <= i; i--, distance++) {
                    if (jqmDataUrl === stack[i].pageUrl) {
                        break;
                    }
                }
                if (i < 0) {
                    console.warn(TAG + "back destination does not exist in history. back-dst: " + backDst);
                    return 0;
                }
                return distance;
            };
            /**
             * @en Start sub flow. <br>
             *     Attach SubFlowParam to jqm history stack object.
             *
             * @ja Sub Flow の開始 <br>
             *     SubFlowParam を jqm history stack にアタッチ
             *
             * @param subFlowParam
             *  - `en` Sub Flow parameter.
             *  - `ja` Sub Flow パラメータ
             */
            Router.startSubFlow = function (subFlowParam) {
                var active = Router._getJqmHistory().getActive();
                var param = subFlowParam;
                if (subFlowParam.destBase) {
                    var distance = 0;
                    var fragment_2 = Backbone.history.getFragment(subFlowParam.destBase);
                    var context = _.find(Router.s_rootContexts, function (ctx) {
                        return ctx.regexp.test(fragment_2);
                    });
                    if (null == context) {
                        console.warn(TAG + "base destination is not registered. destBase: " + subFlowParam.destBase);
                        return;
                    }
                    // dataUrl を元に jQM History を検索
                    var jqmDataUrl = Router.pathToJqmDataUrl(context.page);
                    var stack = Router._getJqmHistory().stack;
                    for (var i = Router._getJqmHistory().activeIndex; 0 <= i; i--, distance++) {
                        if (jqmDataUrl === stack[i].pageUrl) {
                            param.additionalDistance = distance;
                            break;
                        }
                    }
                }
                else {
                    param.destBase = location.hash;
                    param.additionalDistance = 0;
                }
                active[Router.SUBFLOW_PARAM] = param;
            };
            /**
             * @en End sub flow <br>
             *     navigate and delete SubFlowParam from jqm history stack object.
             *
             * @ja Sub Flow の終了 <br>
             *     遷移と SubFlowParam を jqm history stack から削除
             *
             * @param navOptions
             *  - `en` Sub Flow parameter.
             *  - `ja` Sub Flow パラメータ
             */
            Router.finishSubFlow = function (options) {
                var navOptions = $.extend(true, {}, options);
                var baseInfo = Router.detectSubFlowBaseInfo();
                // "end" 時に更新されたものを上書き
                var param = $.extend({}, baseInfo.subFlowParam, navOptions.subFlow);
                var distance = baseInfo.distance;
                var stack = baseInfo.stack;
                var retry = 0;
                var NAVIGATE_INTERVAL = 100;
                var MAX_RETRY_COUNT = 10;
                // hash 変更が完了した後に navigate を実行
                var _navigate = function () {
                    if (MAX_RETRY_COUNT <= retry) {
                        console.error(TAG + "reached navigate max retry count.");
                        Router.s_lastNavigateInfo = {};
                    }
                    else if (param.destBase !== location.hash) {
                        retry++;
                        setTimeout(_navigate, NAVIGATE_INTERVAL);
                    }
                    else {
                        Router.s_lastNavigateInfo.inNavigation = false;
                        Router.registerPageStack(param.destStacks, true, navOptions);
                    }
                };
                if (stack) {
                    delete stack[Router.SUBFLOW_PARAM];
                    Router._getJqmHistory().activeIndex -= distance;
                    Router._getJqmHistory().clearForward();
                    if (param.destStacks) {
                        Router.stop();
                        // iOS 環境において index.html より history.go(0) が発生するとリロードが発生する.
                        // その後画面遷移を控えるため, 履歴を戻る必要があるときにのみ限定する.
                        if (0 !== distance) {
                            history.go(-distance);
                        }
                        delete navOptions.subFlow; // subFlow プロパティの破棄
                        setTimeout(_navigate, 0);
                    }
                    else {
                        Router.s_lastNavigateInfo.positiveNavigate = false;
                        history.go(-distance);
                    }
                }
                else {
                    console.warn(TAG + "subFlow begin status does not exist in history.");
                    Router.s_lastNavigateInfo = {};
                }
            };
            /**
             * @en Return destination Sub Flow information. (const function)
             * @ja Sub Flow 情報を返却 (この関数は Router の状態を変更しない。)
             *
             * @returns
             *  - `en` sub flow info.
             *  - `ja` Sub Flow 情報.
             */
            Router.detectSubFlowBaseInfo = function () {
                var stack = Router._getJqmHistory().stack;
                var historyActiveIndex = Router._getJqmHistory().activeIndex;
                var i, distance;
                var param = {};
                var target;
                for (i = historyActiveIndex, distance = 0; 0 <= i; i--, distance++) {
                    if (stack[i][Router.SUBFLOW_PARAM]) {
                        target = stack[i];
                        param = stack[i][Router.SUBFLOW_PARAM];
                        break;
                    }
                }
                if (null == param.additionalDistance) {
                    param.additionalDistance = 0;
                }
                return {
                    stack: target,
                    subFlowParam: param,
                    distance: distance + param.additionalDistance,
                    isCurrent: (function () {
                        if (target && 0 === distance) {
                            return true;
                        }
                        else {
                            return false;
                        }
                    })(),
                };
            };
            /**
             * @en Convert path to jQM dataUrl.
             * @ja パスを jQM dataUrl に変換
             *
             * @returns jQM data url.
             */
            Router.pathToJqmDataUrl = function (path) {
                var url = Framework.toUrl(path);
                var dataUrl = $.mobile.path.convertUrlToDataUrl(url);
                return dataUrl;
            };
            /**
             * @en Update jQM urlHistory by window.history object. <br>
             *     To be natural browsing history behavior, application needs to update jQM urlHistory <br>
             *     when clicking back or next button of browser. (imperfection for decideDirection())
             *
             * @ja ブラウザの履歴に基づき jQM urlHistory を更新 <br>
             *     [戻る]/[進む]が押下された後、ページ遷移されるとき、jQM urlHistory を更新する。(decideDirection() により不完全)
             */
            Router.treatUrlHistory = function () {
                if (Router.s_lastNavigateInfo.positiveNavigate || history.length < Router._getJqmHistory().stack.length) {
                    Router._getJqmHistory().clearForward();
                }
            };
            Router.s_initOptions = {};
            Router.s_router = null;
            Router.s_rootContexts = {};
            Router.s_lastNavigateInfo = {};
            Router.s_lastClickedTime = null;
            Router.s_lastIntent = {};
            Router.s_firstChangePage = true;
            Router.s_loadUrl = null;
            Router.s_back = null;
            Router.DELAY_TIME = 200; // TBD: 暫定値
            Router.DATA_BACK_DESTINATION = "data-back-dst";
            Router.DATA_NO_HASH_CHANGE = "data-no-hash-change";
            Router.DATA_NO_VCLICK_HANDLE = "data-no-vclick-handle";
            Router.BACK_DESTINATION_URL = "backDstUrl";
            Router.SUBFLOW_PARAM = "subFlowParam";
            Router.s_defaultInitOptions = {
                anchorVclick: true,
                firstPageTransition: false,
            };
            Router.s_defaultNavigateOptions = {
                trigger: true,
                replace: false,
                intent: null,
            };
            return Router;
        }());
        Framework.Router = Router;
    })(Framework = CDP.Framework || (CDP.Framework = {}));
})(CDP || (CDP = {}));
var CDP;
(function (CDP) {
    var Framework;
    (function (Framework) {
        var Promise = CDP.Promise;
        var TAG = "[CDP.Framework.Page] ";
        /**
         * @en Base class of all page unit.
         * @ja すべてのページの基本となる既定クラス
         */
        var Page = /** @class */ (function () {
            //////////////////////////////////////////
            // public methods
            /**
             * @param _url
             *  - `en` page's URL
             *  - `ja` ページ URL
             * @param _id
             *  - `en` page's ID
             *  - `ja` ページ ID
             * @param options
             *  - `en` construction options
             *  - `ja` 構築オプション
             */
            function Page(_url, _id, options) {
                this._url = _url;
                this._id = _id;
                this.setup(options);
            }
            Object.defineProperty(Page.prototype, "active", {
                //////////////////////////////////////////
                // public accessor
                get: function () { return !!this._$page && this._$page.hasClass("ui-page-active"); },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(Page.prototype, "url", {
                get: function () { return this._url; },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(Page.prototype, "id", {
                get: function () { return this._id; },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(Page.prototype, "$page", {
                get: function () { return this._$page; },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(Page.prototype, "$header", {
                get: function () { return this._$header; },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(Page.prototype, "$footer", {
                get: function () { return this._$footer; },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(Page.prototype, "intent", {
                get: function () { return this._intent; },
                set: function (newIntent) { this._intent = newIntent; this._intent._update = true; },
                enumerable: true,
                configurable: true
            });
            //////////////////////////////////////////
            // Implemtents: IPage
            // Orientation の変更を受信
            Page.prototype.onOrientationChanged = function (newOrientation) {
                if (this._owner) {
                    this._owner.onOrientationChanged(newOrientation);
                }
            };
            // H/W Back Button ハンドラ
            Page.prototype.onHardwareBackButton = function (event) {
                if (this._owner) {
                    return this._owner.onHardwareBackButton(event);
                }
                else {
                    return false;
                }
            };
            // Router "before route change" ハンドラ
            Page.prototype.onBeforeRouteChange = function () {
                if (this._owner) {
                    return this._owner.onBeforeRouteChange();
                }
                else {
                    return Promise.resolve();
                }
            };
            // 汎用コマンドを受信
            Page.prototype.onCommand = function (event, kind) {
                if (this._owner) {
                    return this._owner.onCommand(event, kind);
                }
                else {
                    return false;
                }
            };
            // 最初の OnPageInit() のときにのみコールされる
            Page.prototype.onInitialize = function (event) {
                if (this._owner) {
                    this._owner.onInitialize(event);
                }
            };
            // jQM event: "pagebeforecreate" に対応
            Page.prototype.onPageBeforeCreate = function (event) {
                if (this._owner) {
                    this._owner.onPageBeforeCreate(event);
                }
            };
            // jQM event: "pagecreate" (旧:"pageinit") に対応
            Page.prototype.onPageInit = function (event) {
                if (this._owner) {
                    this._owner.onPageInit(event);
                }
            };
            // jQM event: "pagebeforeshow" に対応
            Page.prototype.onPageBeforeShow = function (event, data) {
                if (this._owner) {
                    this._owner.onPageBeforeShow(event, data);
                }
            };
            // jQM event: "pagecontainershow" (旧:"pageshow") に対応
            Page.prototype.onPageShow = function (event, data) {
                if (this._owner) {
                    this._owner.onPageShow(event, data);
                }
            };
            // jQM event: "pagebeforehide" に対応
            Page.prototype.onPageBeforeHide = function (event, data) {
                if (this._owner) {
                    this._owner.onPageBeforeHide(event, data);
                }
            };
            // jQM event: "pagecontainerhide" (旧:"pagehide") に対応
            Page.prototype.onPageHide = function (event, data) {
                if (this._owner) {
                    this._owner.onPageHide(event, data);
                }
            };
            // jQM event: "pageremove" に対応
            Page.prototype.onPageRemove = function (event) {
                if (this._owner) {
                    this._owner.onPageRemove(event);
                }
            };
            //////////////////////////////////////////
            // private methods
            // mixin 用疑似コンストラクタ
            Page.prototype.setup = function (options) {
                var _this = this;
                // mixin destination 用の再初期化
                this._initialized = false;
                this._intent = null;
                // イベントバインド
                var selector = "#" + this._id;
                $(document)
                    .off("pagebeforecreate", selector)
                    .on("pagebeforecreate", selector, function (event) {
                    _this._$page = $(selector).first();
                    _this._$header = _this._$page.children(":jqmData(role=header)").first();
                    _this._$footer = _this._$page.children(":jqmData(role=footer)").first();
                    _this._$page
                        .on("pagecreate", function (ev) {
                        _this.pageInit(ev);
                    })
                        .on("pagebeforeshow", function (ev, data) {
                        _this.pageBeforeShow(ev, data);
                    })
                        .on("pageshow", function (ev, data) {
                        _this.pageShow(ev, data);
                    })
                        .on("pagebeforehide", function (ev, data) {
                        _this.pageBeforeHide(ev, data);
                    })
                        .on("pagehide", function (ev, data) {
                        _this.pageHide(ev, data);
                    })
                        .on("pageremove", function (ev) {
                        _this.pageRemove(ev);
                    });
                    _this.pageBeforeCreate(event);
                });
                options = options || {};
                // owner 設定
                this._owner = options.owner;
                // intent 設定
                this._keepIntent = options.keepIntent;
                // Router へ登録
                if (null == options.route) {
                    options.route = this._id;
                }
                Framework.Router.register(options.route, this._url, options.top, options.callback);
            };
            // PageTransitionDirection の判定
            Page.prototype.getDirection = function () {
                var activeIndex = Framework.Router._getJqmHistory().activeIndex;
                var prevIndex = Framework.Router._getJqmHistory().previousIndex;
                if (null == activeIndex || null == prevIndex) {
                    return "unknown";
                }
                else if (prevIndex === activeIndex) {
                    return "same";
                }
                else if (activeIndex < prevIndex) {
                    return "back";
                }
                else {
                    return "forward";
                }
            };
            Page.prototype.pageBeforeCreate = function (event) {
                this.onPageBeforeCreate(event);
            };
            Page.prototype.pageInit = function (event) {
                if (!this._initialized) {
                    this.onInitialize(event);
                    this._initialized = true;
                }
                this.onPageInit(event);
            };
            Page.prototype.pageBeforeShow = function (event, data) {
                Framework._setActivePage(this);
                this._intent = Framework.Router._popIntent();
                this.onPageBeforeShow(event, $.extend(data, { direction: this.getDirection() }));
            };
            Page.prototype.pageShow = function (event, data) {
                this.onPageShow(event, $.extend(data, { direction: this.getDirection() }));
            };
            Page.prototype.pageBeforeHide = function (event, data) {
                this.onPageBeforeHide(event, $.extend(data, { direction: this.getDirection() }));
                if (null != this._intent && (this._keepIntent || this._intent._update)) {
                    delete this._intent._update;
                    Framework.Router._pushIntent(this._intent);
                }
                else if (Framework.Router.fromHashChanged() && Framework.Router.isInSubFlow()) {
                    Framework.Router._pushIntent(this._intent);
                }
                this._intent = null;
                Framework._setActivePage(null);
            };
            Page.prototype.pageHide = function (event, data) {
                this.onPageHide(event, $.extend(data, { direction: this.getDirection() }));
            };
            Page.prototype.pageRemove = function (event) {
                this.onPageRemove(event);
                this._$page.off();
                this._$page = null;
                this._$header.off();
                this._$header = null;
                this._$footer.off();
                this._$footer = null;
            };
            return Page;
        }());
        Framework.Page = Page;
        ///////////////////////////////////////////////////////////////////////
        // closure methods
        /*
         * jQM1.4 にて、duplicate とされている "pageshow", "pagehide" はまだ据え置き。
         * http://jquerymobile.com/upgrade-guide/1.4/#navigation
         *
         * 特定ページに対して、イベントを取得できないため。
         * Forum でも議論中なので、決着がついてから対応を考慮する。
         * https://github.com/jquery/jquery-mobile/issues/6865
         *
         * [参考] よくわかるイベントチートシート
         *  - 本家(1.4+) http://jqmtricks.wordpress.com/2014/03/26/jquery-mobile-page-events/
         *  - 有志(~1.3) http://dev.screw-axis.com/doc/jquery_mobile/resources/cheatsheet/
         *
         * 以下は不完全な対応予定コード
         *
         * 特に振る舞いが変わるのは、"pagehide" で、検討されている仕様では
         * DOM を特定できないため、onPageHide() をインスタンスに伝えることができない。
         *
         * 仕様が変わらない場合は
         * onPageBeforeHide() の中で post して onPageHide() を発行する予定(過去互換保証)
         *
         * 2015/03/25 追記:
         * 仕様は確定. jQM1.6 より削除される予定
         *  jQM1.4 相当の参考実装 plugin があり、この実装相当の機能を cdp.framework.jqm で抱える予定
         *  https://github.com/arschmitz/jquery-mobile-onpage
         *
         * 公式見解
         * https://github.com/jquery/jquery-mobile/issues/7283#issuecomment-40746622
         */
        /*
            // bind "pagecontainershow", and "pagecontainerhide".
            (() => {
                let $body: any = $("body");
                $(document)
                    .on("pagecontainershow", (event: JQuery.Event, data: ShowEventData) => {
                        if (0 < data.prevPage.length) {
                            // "pagecontainershow" は "pagecontainerhide" よりも遅いので、やはり DOM にはアクセスできない
                            let $prevpage = $("#" + data.prevPage[0].id);
                            $prevpage.trigger("_pagehide", data);
                        }
                        // 以下の対応で、"pagecontainershow" は "pageshow" 同等の振る舞いにすることが可能
                        let pageId = $body.pagecontainer("getActivePage").prop("id");
                        let $page = $("#" + pageId);
                        $page.trigger("_pageshow", data);
                    })
                    .on("pagecontainerhide", (event: JQuery.Event, data: HideEventData) => {
                        // "pagecontainerhide" を受けたときは既に DOM から消えているため、page は特定できない。
                        //let pageId = $body.pagecontainer('getActivePage').prop("id");
                        //let $page = $("#" + pageId);
                        //$page.trigger("_pagehide", data);
                    })
                    .on("pagecontainertransition", (event: JQuery.Event, data: any) => {
                        // "pagecontainertransition" には toPage にしかアクセスはできない
                    })
                ;
            })();
        */
    })(Framework = CDP.Framework || (CDP.Framework = {}));
})(CDP || (CDP = {}));

return CDP.Framework; }));

}.call(window));

/***/ }),
/* 3 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_3__;

/***/ }),
/* 4 */
/***/ (function(module, exports) {

module.exports = __WEBPACK_EXTERNAL_MODULE_4__;

/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_ARRAY__, __WEBPACK_AMD_DEFINE_RESULT__;/*** IMPORTS FROM imports-loader ***/
(function() {

/*!
 * jQuery Migrate - v3.0.1-hotfix - 2017-01-11
 * Copyright jQuery Foundation and other contributors
 */
; (function (factory) {
    if (true) {
        // AMD. Register as an anonymous module.
        !(__WEBPACK_AMD_DEFINE_ARRAY__ = [__webpack_require__(0)], __WEBPACK_AMD_DEFINE_RESULT__ = function ($) {
            return factory($, window);
        }.apply(exports, __WEBPACK_AMD_DEFINE_ARRAY__),
                __WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else if (typeof module === "object" && module.exports) {
        // Node/CommonJS
        // eslint-disable-next-line no-undef
        module.exports = factory(require("jquery"), window);
    } else {
        // Browser globals
        factory(jQuery, window);
    }
})(function (jQuery, window) {
    "use strict";

    jQuery.migrateVersion = "3.0.1-hotfix"; // with hotfix

    /* exported migrateWarn, migrateWarnFunc, migrateWarnProp */

    (function () {

        // Support: IE9 only
        // IE9 only creates console object when dev tools are first opened
        // Also, avoid Function#bind here to simplify PhantomJS usage
        var log = window.console && window.console.log &&
            function () {
                window.console.log.apply(window.console, arguments);
            },
            rbadVersions = /^[12]\./;

        if (!log) {
            return;
        }

        // Need jQuery 3.0.0+ and no older Migrate loaded
        if (!jQuery || rbadVersions.test(jQuery.fn.jquery)) {
            log("JQMIGRATE: jQuery 3.0.0+ REQUIRED");
        }
        if (jQuery.migrateWarnings) {
            log("JQMIGRATE: Migrate plugin loaded multiple times");
        }

        // Show a message on the console so devs know we're active
        if (!jQuery.migrateMute) {
            log("JQMIGRATE: Migrate is installed" +
                (jQuery.migrateMute ? "" : " with logging active") +
                ", version " + jQuery.migrateVersion);
        }
    })();

    var warnedAbout = {};

    // List of warnings already given; public read only
    jQuery.migrateWarnings = [];

    // Set to false to disable traces that appear with warnings
    if (jQuery.migrateTrace === undefined) {
        jQuery.migrateTrace = true;
    }

    // Forget any warnings we've already given; public
    jQuery.migrateReset = function () {
        warnedAbout = {};
        jQuery.migrateWarnings.length = 0;
    };

    function migrateWarn(msg) {
        var console = window.console;
        if (!warnedAbout[msg]) {
            warnedAbout[msg] = true;
            jQuery.migrateWarnings.push(msg);
            if (console && console.warn && !jQuery.migrateMute) {
                console.warn("JQMIGRATE: " + msg);
                if (jQuery.migrateTrace && console.trace) {
                    console.trace();
                }
            }
        }
    }

    function migrateWarnProp(obj, prop, value, msg) {
        Object.defineProperty(obj, prop, {
            configurable: true,
            enumerable: true,
            get: function () {
                migrateWarn(msg);
                return value;
            },
            set: function (newValue) {
                migrateWarn(msg);
                value = newValue;
            }
        });
    }

    function migrateWarnFunc(obj, prop, newFunc, msg) {
        obj[prop] = function () {
            migrateWarn(msg);
            return newFunc.apply(this, arguments);
        };
    }

    if (window.document.compatMode === "BackCompat") {
        // JQuery has never supported or tested Quirks Mode
        migrateWarn("jQuery is not compatible with Quirks Mode");
    }


    var oldInit = jQuery.fn.init,
        oldIsNumeric = jQuery.isNumeric,
        oldFind = jQuery.find,
        rattrHashTest = /\[(\s*[-\w]+\s*)([~|^$*]?=)\s*([-\w#]*?#[-\w#]*)\s*\]/,
        rattrHashGlob = /\[(\s*[-\w]+\s*)([~|^$*]?=)\s*([-\w#]*?#[-\w#]*)\s*\]/g;

    jQuery.fn.init = function (arg1) {
        var args = Array.prototype.slice.call(arguments);

        if (typeof arg1 === "string" && arg1 === "#") {
            // JQuery( "#" ) is a bogus ID selector, but it returned an empty set before jQuery 3.0
            migrateWarn("jQuery( '#' ) is not a valid selector");
            args[0] = [];
        }

        return oldInit.apply(this, args);
    };
    jQuery.fn.init.prototype = jQuery.fn;

    jQuery.find = function (selector) {
        var args = Array.prototype.slice.call(arguments);

        // Support: PhantomJS 1.x
        // String#match fails to match when used with a //g RegExp, only on some strings
        if (typeof selector === "string" && rattrHashTest.test(selector)) {
            // The nonstandard and undocumented unquoted-hash was removed in jQuery 1.12.0
            // First see if qS thinks it's a valid selector, if so avoid a false positive
            try {
                window.document.querySelector(selector);
            } catch (err1) {
                // Didn't *look* valid to qSA, warn and try quoting what we think is the value
                selector = selector.replace(rattrHashGlob, function (_, attr, op, value) {
                    return "[" + attr + op + "\"" + value + "\"]";
                });

                // If the regexp *may* have created an invalid selector, don't update it
                // Note that there may be false alarms if selector uses jQuery extensions
                try {
                    window.document.querySelector(selector);
                    migrateWarn("Attribute selector with '#' must be quoted: " + args[0]);
                    args[0] = selector;
                } catch (err2) {
                    migrateWarn("Attribute selector with '#' was not fixed: " + args[0]);
                }
            }
        }

        return oldFind.apply(this, args);
    };

    // Copy properties attached to original jQuery.find method (e.g. .attr, .isXML)
    var findProp;
    for (findProp in oldFind) {
        if (Object.prototype.hasOwnProperty.call(oldFind, findProp)) {
            jQuery.find[findProp] = oldFind[findProp];
        }
    }

    // The number of elements contained in the matched element set
    jQuery.fn.size = function () {
        migrateWarn("jQuery.fn.size() is deprecated and removed; use the .length property");
        return this.length;
    };

    jQuery.parseJSON = function () {
        migrateWarn("jQuery.parseJSON is deprecated; use JSON.parse");
        return JSON.parse.apply(null, arguments);
    };

    jQuery.isNumeric = function (val) {
        // The jQuery 2.2.3 implementation of isNumeric
        function isNumeric2(obj) {
            var realStringObj = obj && obj.toString();
            return !jQuery.isArray(obj) && (realStringObj - parseFloat(realStringObj) + 1) >= 0;
        }

        var newValue = oldIsNumeric(val),
            oldValue = isNumeric2(val);

        if (newValue !== oldValue) {
            migrateWarn("jQuery.isNumeric() should not be called on constructed objects");
        }

        return oldValue;
    };

    migrateWarnFunc(jQuery, "unique", jQuery.uniqueSort,
        "jQuery.unique is deprecated; use jQuery.uniqueSort");

    // Now jQuery.expr.pseudos is the standard incantation
    migrateWarnProp(jQuery.expr, "filters", jQuery.expr.pseudos,
        "jQuery.expr.filters is deprecated; use jQuery.expr.pseudos");
    migrateWarnProp(jQuery.expr, ":", jQuery.expr.pseudos,
        "jQuery.expr[':'] is deprecated; use jQuery.expr.pseudos");


    var oldAjax = jQuery.ajax;

    jQuery.ajax = function () {
        var jQXHR = oldAjax.apply(this, arguments);

        // Be sure we got a jQXHR (e.g., not sync)
        if (jQXHR.promise) {
            migrateWarnFunc(jQXHR, "success", jQXHR.done,
                "jQXHR.success is deprecated and removed");
            migrateWarnFunc(jQXHR, "error", jQXHR.fail,
                "jQXHR.error is deprecated and removed");
            migrateWarnFunc(jQXHR, "complete", jQXHR.always,
                "jQXHR.complete is deprecated and removed");
        }

        return jQXHR;
    };


    var oldRemoveAttr = jQuery.fn.removeAttr,
        oldToggleClass = jQuery.fn.toggleClass,
        rmatchNonSpace = /\S+/g;

    jQuery.fn.removeAttr = function (name) {
        var self = this;

        jQuery.each(name.match(rmatchNonSpace), function (i, attr) {
            if (jQuery.expr.match.bool.test(attr)) {
                migrateWarn("jQuery.fn.removeAttr no longer sets boolean properties: " + attr);
                self.prop(attr, false);
            }
        });

        return oldRemoveAttr.apply(this, arguments);
    };

    jQuery.fn.toggleClass = function (state) {
        // Only deprecating no-args or single boolean arg
        if (state !== undefined && typeof state !== "boolean") {
            return oldToggleClass.apply(this, arguments);
        }

        migrateWarn("jQuery.fn.toggleClass( boolean ) is deprecated");

        // Toggle entire class name of each element
        return this.each(function () {
            var className = this.getAttribute && this.getAttribute("class") || "";

            if (className) {
                jQuery.data(this, "__className__", className);
            }

            // If the element has a class name or if we're passed `false`,
            // then remove the whole classname (if there was one, the above saved it).
            // Otherwise bring back whatever was previously saved (if anything),
            // falling back to the empty string if nothing was stored.
            if (this.setAttribute) {
                this.setAttribute("class",
                    className || state === false ?
                    "" :
                    jQuery.data(this, "__className__") || ""
                );
            }
        });
    };


    var internalSwapCall = false;

    // If this version of jQuery has .swap(), don't false-alarm on internal uses
    if (jQuery.swap) {
        jQuery.each(["height", "width", "reliableMarginRight"], function (_, name) {
            var oldHook = jQuery.cssHooks[name] && jQuery.cssHooks[name].get;

            if (oldHook) {
                jQuery.cssHooks[name].get = function () {
                    var ret;

                    internalSwapCall = true;
                    ret = oldHook.apply(this, arguments);
                    internalSwapCall = false;
                    return ret;
                };
            }
        });
    }

    jQuery.swap = function (elem, options, callback, args) {
        var ret, name,
            old = {};

        if (!internalSwapCall) {
            migrateWarn("jQuery.swap() is undocumented and deprecated");
        }

        // Remember the old values, and insert the new ones
        for (name in options) {
            old[name] = elem.style[name];
            elem.style[name] = options[name];
        }

        ret = callback.apply(elem, args || []);

        // Revert the old values
        for (name in options) {
            elem.style[name] = old[name];
        }

        return ret;
    };

    var oldData = jQuery.data;

    jQuery.data = function (elem, name, value) {
        var curData;

        // Name can be an object, and each entry in the object is meant to be set as data
        if (name && typeof name === "object" && arguments.length === 2) {
            curData = jQuery.hasData(elem) && oldData.call(this, elem);
            var sameKeys = {};
            for (var key in name) {
                if (key !== jQuery.camelCase(key)) {
                    migrateWarn("jQuery.data() always sets/gets camelCased names: " + key);
                    curData[key] = name[key];
                } else {
                    sameKeys[key] = name[key];
                }
            }

            oldData.call(this, elem, sameKeys);

            return name;
        }

        // If the name is transformed, look for the un-transformed name in the data object
        if (name && typeof name === "string" && name !== jQuery.camelCase(name)) {
            curData = jQuery.hasData(elem) && oldData.call(this, elem);
            if (curData && name in curData) {
                migrateWarn("jQuery.data() always sets/gets camelCased names: " + name);
                if (arguments.length > 2) {
                    curData[name] = value;
                }
                return curData[name];
            }
        }

        return oldData.apply(this, arguments);
    };

    var oldTweenRun = jQuery.Tween.prototype.run;

    jQuery.Tween.prototype.run = function () {
        if (jQuery.easing[this.easing].length > 1) {
            migrateWarn(
                "easing function " +
                "\"jQuery.easing." + this.easing.toString() +
                "\" should use only first argument"
            );

            var oldEasing = jQuery.easing[this.easing];
            jQuery.easing[this.easing] = function (percent) {
                return oldEasing.call(jQuery.easing, percent, percent, 0, 1, 1);
            }.bind(this);
        }

        oldTweenRun.apply(this, arguments);
    };

    jQuery.fx.interval = jQuery.fx.interval || 13;

    // Support: IE9, Android <=4.4
    // Avoid false positives on browsers that lack rAF
    if (window.requestAnimationFrame) {
        migrateWarnProp(jQuery.fx, "interval", jQuery.fx.interval,
            "jQuery.fx.interval is deprecated");
    }

    var oldLoad = jQuery.fn.load,
        oldEventAdd = jQuery.event.add,
        originalFix = jQuery.event.fix;

    jQuery.event.props = [];
    jQuery.event.fixHooks = {};

    migrateWarnProp(jQuery.event.props, "concat", jQuery.event.props.concat,
        "jQuery.event.props.concat() is deprecated and removed");

    jQuery.event.fix = function (originalEvent) {
        var event,
            type = originalEvent.type,
            fixHook = this.fixHooks[type],
            props = jQuery.event.props;

        if (props.length) {
            migrateWarn("jQuery.event.props are deprecated and removed: " + props.join());
            while (props.length) {
                jQuery.event.addProp(props.pop());
            }
        }

        if (fixHook && !fixHook._migrated_) {
            fixHook._migrated_ = true;
            migrateWarn("jQuery.event.fixHooks are deprecated and removed: " + type);
            if ((props = fixHook.props) && props.length) {
                while (props.length) {
                    jQuery.event.addProp(props.pop());
                }
            }
        }

        event = originalFix.call(this, originalEvent);

        return fixHook && fixHook.filter ? fixHook.filter(event, originalEvent) : event;
    };

    jQuery.event.add = function (elem, types) {
        // This misses the multiple-types case but that seems awfully rare
        if (elem === window && types === "load" && window.document.readyState === "complete") {
            migrateWarn("jQuery(window).on('load'...) called after load event occurred");
        }
        return oldEventAdd.apply(this, arguments);
    };

    jQuery.each(["load", "unload", "error"], function (_, name) {

        jQuery.fn[name] = function () {
            var args = Array.prototype.slice.call(arguments, 0);

            // If this is an ajax load() the first arg should be the string URL;
            // technically this could also be the "Anything" arg of the event .load()
            // which just goes to show why this dumb signature has been deprecated!
            // jQuery custom builds that exclude the Ajax module justifiably die here.
            if (name === "load" && typeof args[0] === "string") {
                return oldLoad.apply(this, args);
            }

            migrateWarn("jQuery.fn." + name + "() is deprecated");

            args.splice(0, 0, name);
            if (arguments.length) {
                return this.on.apply(this, args);
            }

            // Use .triggerHandler here because:
            // - load and unload events don't need to bubble, only applied to window or image
            // - error event should not bubble to window, although it does pre-1.7
            // See http://bugs.jquery.com/ticket/11820
            this.triggerHandler.apply(this, args);
            return this;
        };

    });

    // Trigger "ready" event only once, on document ready
    jQuery(function () {
        jQuery(window.document).triggerHandler("ready");
    });

    jQuery.event.special.ready = {
        setup: function () {
            if (this === window.document) {
                migrateWarn("'ready' event is deprecated");
            }
        }
    };

    jQuery.fn.extend({
        bind: function (types, data, fn) {
            migrateWarn("jQuery.fn.bind() is deprecated");
            return this.on(types, null, data, fn);
        },
        unbind: function (types, fn) {
            migrateWarn("jQuery.fn.unbind() is deprecated");
            return this.off(types, null, fn);
        },
        delegate: function (selector, types, data, fn) {
            migrateWarn("jQuery.fn.delegate() is deprecated");
            return this.on(types, selector, data, fn);
        },
        undelegate: function (selector, types, fn) {
            migrateWarn("jQuery.fn.undelegate() is deprecated");
            return arguments.length === 1 ?
                this.off(selector, "**") :
                this.off(types, selector || "**", fn);
        }
    });


    var oldOffset = jQuery.fn.offset;

    jQuery.fn.offset = function () {
        var docElem,
            elem = this[0],
            origin = { top: 0, left: 0 };

        if (!elem || !elem.nodeType) {
            migrateWarn("jQuery.fn.offset() requires a valid DOM element");
            return origin;
        }

        docElem = (elem.ownerDocument || window.document).documentElement;
        if (!jQuery.contains(docElem, elem)) {
            migrateWarn("jQuery.fn.offset() requires an element connected to a document");
            return origin;
        }

        return oldOffset.apply(this, arguments);
    };


    var oldParam = jQuery.param;

    jQuery.param = function (data, traditional) {
        var ajaxTraditional = jQuery.ajaxSettings && jQuery.ajaxSettings.traditional;

        if (traditional === undefined && ajaxTraditional) {
            migrateWarn("jQuery.param() no longer uses jQuery.ajaxSettings.traditional");
            traditional = ajaxTraditional;
        }

        return oldParam.call(this, data, traditional);
    };

    var oldSelf = jQuery.fn.andSelf || jQuery.fn.addBack;

    jQuery.fn.andSelf = function () {
        migrateWarn("jQuery.fn.andSelf() is deprecated and removed, use jQuery.fn.addBack()");
        return oldSelf.apply(this, arguments);
    };


    var oldDeferred = jQuery.Deferred,
        tuples = [
            // Action, add listener, callbacks, .then handlers, final state
            ["resolve", "done", jQuery.Callbacks("once memory"),
                jQuery.Callbacks("once memory"), "resolved"],
            ["reject", "fail", jQuery.Callbacks("once memory"),
                jQuery.Callbacks("once memory"), "rejected"],
            ["notify", "progress", jQuery.Callbacks("memory"),
                jQuery.Callbacks("memory")]
        ];

    jQuery.Deferred = function (func) {
        var deferred = oldDeferred(),
            promise = deferred.promise();

        deferred.pipe = promise.pipe = function ( /* fnDone, fnFail, fnProgress */) {
            var fns = arguments;

            migrateWarn("deferred.pipe() is deprecated");

            return jQuery.Deferred(function (newDefer) {
                jQuery.each(tuples, function (i, tuple) {
                    var fn = jQuery.isFunction(fns[i]) && fns[i];

                    // Deferred.done(function() { bind to newDefer or newDefer.resolve })
                    // deferred.fail(function() { bind to newDefer or newDefer.reject })
                    // deferred.progress(function() { bind to newDefer or newDefer.notify })
                    deferred[tuple[1]](function () {
                        var returned = fn && fn.apply(this, arguments);
                        if (returned && jQuery.isFunction(returned.promise)) {
                            returned.promise()
                                .done(newDefer.resolve)
                                .fail(newDefer.reject)
                                .progress(newDefer.notify);
                        } else {
                            newDefer[tuple[0] + "With"](
                                this === promise ? newDefer.promise() : this,
                                fn ? [returned] : arguments
                            );
                        }
                    });
                });
                fns = null;
            }).promise();

        };

        if (func) {
            func.call(deferred, deferred);
        }

        return deferred;
    };


    return jQuery;
});

}.call(window));

/***/ })
/******/ ]);
});
/*!
 * cdp.tools.js 2.1.0
 *
 * Date: 2017-11-06T05:36:54.176Z
 */
(function (root, factory) { if (typeof define === "function" && define.amd) { define("cdp.tools",["cdp.core", "cdp.promise"], function () { return factory(root.CDP || (root.CDP = {}), root.jQuery || root.$); }); } else { factory(root.CDP || (root.CDP = {}), root.jQuery || root.$); } }(((this || 0).self || global), function (CDP, $) { CDP.Tools = CDP.Tools || {};
var CDP;
(function (CDP) {
    /**
     * @enum  RESULT_CODE_BASE
     * @brief リザルトコードのオフセット値
     */
    var RESULT_CODE_BASE;
    (function (RESULT_CODE_BASE) {
        RESULT_CODE_BASE[RESULT_CODE_BASE["CDP_TOOLS_DECLARERATION"] = 0] = "CDP_TOOLS_DECLARERATION";
        RESULT_CODE_BASE[RESULT_CODE_BASE["CDP_TOOLS"] = 4 * CDP._MODULE_RESULT_CODE_RANGE_CDP] = "CDP_TOOLS";
    })(RESULT_CODE_BASE = CDP.RESULT_CODE_BASE || (CDP.RESULT_CODE_BASE = {}));
    ///////////////////////////////////////////////////////////////////////
    // module error declaration:
    var FUNCTION_CODE_RANGE = 10;
    /**
     * @enum  LOCAL_CODE_BASE
     * @brief cdp.tools 内のローカルコードオフセット値
     */
    var LOCAL_CODE_BASE;
    (function (LOCAL_CODE_BASE) {
        LOCAL_CODE_BASE[LOCAL_CODE_BASE["FUNCTIONS"] = 0] = "FUNCTIONS";
        LOCAL_CODE_BASE[LOCAL_CODE_BASE["BLOB"] = 1 * FUNCTION_CODE_RANGE] = "BLOB";
    })(LOCAL_CODE_BASE || (LOCAL_CODE_BASE = {}));
    /* tslint:disable:max-line-length */
    /**
     * @enum  RESULT_CODE
     * @brief cdp.tools のエラーコード定義
     */
    var RESULT_CODE;
    (function (RESULT_CODE) {
        RESULT_CODE[RESULT_CODE["ERROR_CDP_TOOLS_DECLARATION"] = 0] = "ERROR_CDP_TOOLS_DECLARATION";
        RESULT_CODE[RESULT_CODE["ERROR_CDP_TOOLS_IMAGE_LOAD_FAILED"] = CDP.DECLARE_ERROR_CODE(RESULT_CODE_BASE.CDP_TOOLS, LOCAL_CODE_BASE.FUNCTIONS + 1, "image load failed.")] = "ERROR_CDP_TOOLS_IMAGE_LOAD_FAILED";
        RESULT_CODE[RESULT_CODE["ERROR_CDP_TOOLS_INVALID_IMAGE"] = CDP.DECLARE_ERROR_CODE(RESULT_CODE_BASE.CDP_TOOLS, LOCAL_CODE_BASE.FUNCTIONS + 2, "invalid image.")] = "ERROR_CDP_TOOLS_INVALID_IMAGE";
        RESULT_CODE[RESULT_CODE["ERROR_CDP_TOOLS_FILE_READER_ERROR"] = CDP.DECLARE_ERROR_CODE(RESULT_CODE_BASE.CDP_TOOLS, LOCAL_CODE_BASE.BLOB + 1, "FileReader method failed.")] = "ERROR_CDP_TOOLS_FILE_READER_ERROR";
    })(RESULT_CODE = CDP.RESULT_CODE || (CDP.RESULT_CODE = {}));
    /* tslint:enable:max-line-length */
})(CDP || (CDP = {}));
var CDP;
(function (CDP) {
    var Tools;
    (function (Tools) {
        var Promise = CDP.Promise;
        var TAG = "[CDP.Tools.Binary] ";
        /**
         * @class Binary
         * @brief バイナリユーティリティ
         */
        var Binary = /** @class */ (function () {
            // private constructor
            function Binary() {
                // noop
            }
            /**
             * Get BlobBuilder
             *
             * @obsolete
             * @return {any} BlobBuilder
             */
            Binary.getBlobBuilder = function () {
                return CDP.global.BlobBuilder || CDP.global.WebKitBlobBuilder || CDP.global.MozBlobBuilder || CDP.global.MSBlobBuilder;
            };
            /**
             * エラー情報生成 from DOMError
             *
             * @param resultCode [in] RESULT_CODE を指定
             * @param cause      [in] 下位の DOM エラーを指定
             * @param [tag]      [in] TAG を指定
             * @param [message]  [in] メッセージを指定
             * @returns エラーオブジェクト
             */
            Binary.makeErrorInfoFromDOMError = function (resultCode, cause, tag, message) {
                var _cause;
                if (cause) {
                    _cause = {
                        name: cause.name,
                        message: cause.name,
                    };
                }
                return CDP.makeErrorInfo(resultCode, tag, message, _cause);
            };
            /**
             * Get BlobBuilder
             *
             * @obsolete
             * @return 構築済み Blob オブジェクト
             */
            Binary.newBlob = function (blobParts, options) {
                if (CDP.global.Blob) {
                    return new CDP.global.Blob(blobParts, options);
                }
                else {
                    // under Android 4.4 KitKat
                    options = options || {};
                    var blobBuilderObject = Binary.getBlobBuilder();
                    var blobBuilder = new blobBuilderObject();
                    var parts = (blobParts instanceof Array) ? blobParts[0] : blobParts;
                    blobBuilder.append(parts);
                    return blobBuilder.getBlob(options.type);
                }
            };
            /**
             * ArrayBuffer to Blob
             *
             * @param buf [in] ArrayBuffer data
             * @param mimeType [in] MimeType of data
             * @returns Blob data
             */
            Binary.arrayBufferToBlob = function (buf, mimeType) {
                return Binary.newBlob([buf], { type: mimeType });
            };
            /**
             * Base64 string to Blob
             *
             * @param base64 {string} [in] Base64 string data
             * @param mimeType {string} [in] MimeType of data
             * @return {Blob} Blob data
             */
            Binary.base64ToBlob = function (base64, mimeType) {
                return Binary.newBlob([Binary.base64ToArrayBuffer(base64)], { type: mimeType });
            };
            /**
             * data-url 形式画像から Blob オブジェクトへ変換
             *
             * @param  {String} dataUrl    [in] data url
             * @param  {String} [mimeType] [in] mime type を指定. 既定では "image/png"
             * @return {Blob} Blob インスタンス
             */
            Binary.dataUrlToBlob = function (dataUrl, mimeType) {
                if (mimeType === void 0) { mimeType = "image/png"; }
                var base64 = dataUrl.split(",")[1];
                return Binary.base64ToBlob(base64, mimeType);
            };
            /**
             * Base64 string to ArrayBuffer
             *
             * @param base64 {string} [in] Base64 string data
             * @return {ArrayBuffer} ArrayBuffer data
             */
            Binary.base64ToArrayBuffer = function (base64) {
                var bytes = window.atob(base64);
                var arrayBuffer = new ArrayBuffer(bytes.length);
                var data = new Uint8Array(arrayBuffer);
                for (var i = 0, len = bytes.length; i < len; ++i) {
                    data[i] = bytes.charCodeAt(i);
                }
                return arrayBuffer;
            };
            /**
             * Base64 string to Uint8Array
             *
             * @param base64 {string} [in] Base64 string data
             * @return {Uint8Array} Uint8Array data
             */
            Binary.base64ToUint8Array = function (encoded) {
                var bytes = window.atob(encoded);
                var data = new Uint8Array(bytes.length);
                for (var i = 0, len = bytes.length; i < len; ++i) {
                    data[i] = bytes.charCodeAt(i);
                }
                return data;
            };
            /**
             * ArrayBuffer to base64 string
             *
             * @param arrayBuffer {ArrayBuffer} [in] ArrayBuffer data
             * @return {string} base64 data
             */
            Binary.arrayBufferToBase64 = function (arrayBuffer) {
                var bytes = new Uint8Array(arrayBuffer);
                return Binary.uint8ArrayToBase64(bytes);
            };
            /**
             * Uint8Array to base64 string
             *
             * @param bytes {Uint8Array} [in] Uint8Array data
             * @return {string} base64 data
             */
            Binary.uint8ArrayToBase64 = function (bytes) {
                var data = "";
                for (var i = 0, len = bytes.byteLength; i < len; ++i) {
                    data += String.fromCharCode(bytes[i]);
                }
                return window.btoa(data);
            };
            /**
             * read Blob as ArrayBuffer
             *
             * @param  {Blob} blob [in] blob data
             * @return {CDP.IPromise<ArrayBuffer>} promise object
             */
            Binary.readBlobAsArrayBuffer = function (blob) {
                var reader = new FileReader();
                var cancel = function () { return reader.abort(); };
                return new Promise(function (resolve, reject) {
                    reader.onload = function () {
                        resolve(reader.result);
                    };
                    reader.onerror = function () {
                        reject(Binary.makeErrorInfoFromDOMError(CDP.RESULT_CODE.ERROR_CDP_TOOLS_FILE_READER_ERROR, reader.error, TAG, "FileReader.readAsArrayBuffer() failed."));
                    };
                    reader.readAsArrayBuffer(blob);
                }, cancel);
            };
            /**
             * read Blob as Uint8Array
             *
             * @param  {Blob} blob [in] blob data
             * @return {CDP.IPromise<Uint8Array>} promise object
             */
            Binary.readBlobAsUint8Array = function (blob) {
                return new Promise(function (resolve, reject, dependOn) {
                    dependOn(Binary.readBlobAsArrayBuffer(blob))
                        .then(function (result) {
                        resolve(new Uint8Array(result));
                    })
                        .catch(function (error) {
                        reject(error);
                    });
                });
            };
            /**
             * read Blob as text string
             *
             * @param  {Blob} blob [in] blob data
             * @return {CDP.IPromise<Uint8Array>} promise object
             */
            Binary.readBlobAsText = function (blob, encode) {
                if (encode === void 0) { encode = "utf-8"; }
                var reader = new FileReader();
                var cancel = function () { return reader.abort(); };
                return new Promise(function (resolve, reject) {
                    reader.onload = function () {
                        resolve(reader.result);
                    };
                    reader.onerror = function () {
                        reject(Binary.makeErrorInfoFromDOMError(CDP.RESULT_CODE.ERROR_CDP_TOOLS_FILE_READER_ERROR, reader.error, TAG, "FileReader.readAsText() failed."));
                    };
                    reader.readAsText(blob, encode);
                }, cancel);
            };
            /**
             * read Blob as Data URL
             *
             * @param  {Blob} blob [in] blob data
             * @return {CDP.IPromise<string>} promise object
             */
            Binary.readBlobAsDataURL = function (blob) {
                var reader = new FileReader();
                var cancel = function () { return reader.abort(); };
                return new Promise(function (resolve, reject) {
                    reader.onload = function () {
                        resolve(reader.result);
                    };
                    reader.onerror = function () {
                        reject(Binary.makeErrorInfoFromDOMError(CDP.RESULT_CODE.ERROR_CDP_TOOLS_FILE_READER_ERROR, reader.error, TAG, "FileReader.readAsDataURL() failed."));
                    };
                    reader.readAsDataURL(blob);
                }, cancel);
            };
            /**
             * URL Object
             *
             * @obsolete
             * @return {any} URL Object
             */
            Binary.blobURL = (function () {
                return CDP.global.URL || CDP.global.webkitURL;
            })();
            return Binary;
        }());
        Tools.Binary = Binary;
    })(Tools = CDP.Tools || (CDP.Tools = {}));
})(CDP || (CDP = {}));
/**
 * @file  BinaryTransport.ts
 * @brief jQuery ajax transport for making binary data type requests.
 *
 *        original: https://github.com/henrya/js-jquery/blob/master/BinaryTransport/jquery.binarytransport.js
 *        author:   Henry Algus <henryalgus@gmail.com>
 */
var CDP;
(function (CDP) {
    var Tools;
    (function (Tools) {
        // Support file protocol. (as same as official way)
        var xhrSuccessStatus = {
            0: 200,
            1223: 204
        };
        $.ajaxTransport("+binary", function (options, originalOptions, jqXHR) {
            if (CDP.global.FormData &&
                ((options.dataType && (options.dataType === "binary")) ||
                    (options.data && ((CDP.global.ArrayBuffer && options.data instanceof ArrayBuffer) ||
                        (CDP.global.Blob && options.data instanceof CDP.global.Blob))))) {
                var abortCallback_1;
                return {
                    send: function (headers, callback) {
                        // setup all variables
                        var xhr = new XMLHttpRequest();
                        var url = options.url;
                        var type = options.type;
                        var async = options.async || true;
                        // blob or arraybuffer. Default is blob
                        var dataType = options.responseType || "blob";
                        var data = options.data || null;
                        var username = options.username || null;
                        var password = options.password || null;
                        var _callback = callback || (function () { });
                        // succeeded handler
                        xhr.addEventListener("load", function () {
                            var _data = {};
                            _data[options.dataType] = xhr.response;
                            _callback(xhrSuccessStatus[xhr.status] || xhr.status, xhr.statusText, _data, xhr.getAllResponseHeaders());
                        });
                        // error handler
                        xhr.addEventListener("error", function () {
                            var _data = {};
                            _data[options.dataType] = xhr.response;
                            // make callback and send data
                            _callback(xhr.status, xhr.statusText, _data, xhr.getAllResponseHeaders());
                        });
                        // abort handler
                        xhr.addEventListener("abort", function () {
                            var _data = {};
                            _data[options.dataType] = xhr.response;
                            // make callback and send data
                            _callback(xhr.status, xhr.statusText, _data, xhr.getAllResponseHeaders());
                        });
                        // abort callback
                        abortCallback_1 = function () {
                            xhr.abort();
                        };
                        xhr.open(type, url, async, username, password);
                        // setup custom headers
                        for (var i in headers) {
                            if (headers.hasOwnProperty(i)) {
                                xhr.setRequestHeader(i, headers[i]);
                            }
                        }
                        xhr.responseType = dataType;
                        xhr.send(data);
                    },
                    abort: function () {
                        if (abortCallback_1) {
                            abortCallback_1();
                        }
                    }
                };
            }
        });
    })(Tools = CDP.Tools || (CDP.Tools = {}));
})(CDP || (CDP = {}));
/// <reference types="jquery" />
var CDP;
(function (CDP) {
    var Tools;
    (function (Tools) {
        var Promise = CDP.Promise;
        var TAG = "[CDP.Tools.Functions] ";
        /**
         * Math.abs よりも高速な abs
         */
        function abs(x) {
            return x >= 0 ? x : -x;
        }
        Tools.abs = abs;
        /**
         * Math.max よりも高速な max
         */
        function max(lhs, rhs) {
            return lhs >= rhs ? lhs : rhs;
        }
        Tools.max = max;
        /**
         * Math.min よりも高速な min
         */
        function min(lhs, rhs) {
            return lhs <= rhs ? lhs : rhs;
        }
        Tools.min = min;
        /**
         * 数値を 0 詰めして文字列を生成
         */
        function toZeroPadding(no, limit) {
            var signed = "";
            no = Number(no);
            if (isNaN(no) || isNaN(limit) || limit <= 0) {
                return null;
            }
            if (no < 0) {
                no = Tools.abs(no);
                signed = "-";
            }
            return signed + (Array(limit).join("0") + no).slice(-limit);
        }
        Tools.toZeroPadding = toZeroPadding;
        /**
         * 文字列のバイト数をカウント
         */
        function getStringSize(src) {
            return (Tools.Binary.newBlob([src], { type: "text/plain" })).size;
        }
        Tools.getStringSize = getStringSize;
        /**
         * 文字列をバイト制限して分割
         */
        function toStringChunks(src, limit) {
            var chunks = [];
            var setChunk = function (input) {
                if (limit < getStringSize(input)) {
                    var half = Math.floor(input.length / 2);
                    var lhs = input.slice(0, half);
                    var rhs = input.slice(half);
                    return [lhs, rhs];
                }
                else {
                    chunks.push(input);
                    return [];
                }
            };
            var makeChunk = function (work) {
                var failures = setChunk(work);
                while (0 < failures.length) {
                    makeChunk(failures.shift());
                }
            };
            makeChunk(src);
            return chunks;
        }
        Tools.toStringChunks = toStringChunks;
        /**
         * 多重継承のための実行時継承関数
         *
         * Sub Class 候補オブジェクトに対して Super Class 候補オブジェクトを直前の Super Class として挿入する。
         * prototype のみコピーする。
         * インスタンスメンバをコピーしたい場合、Super Class が疑似コンストラクタを提供する必要がある。
         * 詳細は cdp.tools.Functions.spec.ts を参照。
         *
         * @param subClass   {constructor} [in] オブジェクトの constructor を指定
         * @param superClass {constructor} [in] オブジェクトの constructor を指定
         */
        function inherit(subClass, superClass) {
            var _prototype = subClass.prototype;
            function _inherit() {
                this.constructor = subClass;
            }
            _inherit.prototype = superClass.prototype;
            subClass.prototype = new _inherit();
            $.extend(subClass.prototype, _prototype);
        }
        Tools.inherit = inherit;
        /**
         * mixin 関数
         *
         * TypeScript Official Site に載っている mixin 関数
         * http://www.typescriptlang.org/Handbook#mixins
         * 既に定義されているオブジェクトから、新規にオブジェクトを合成する。
         *
         * @param derived {constructor}    [in] 合成されるオブジェクトの constructor を指定
         * @param bases   {constructor...} [in] 合成元オブジェクトの constructor を指定 (可変引数)
         */
        function mixin(derived) {
            var bases = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                bases[_i - 1] = arguments[_i];
            }
            bases.forEach(function (base) {
                Object.getOwnPropertyNames(base.prototype).forEach(function (name) {
                    derived.prototype[name] = base.prototype[name];
                });
            });
        }
        Tools.mixin = mixin;
        /**
         * \~english
         * Helper function to correctly set up the prototype chain, for subclasses.
         * The function behavior is same as extend() function of Backbone.js.
         *
         * @param protoProps  {Object} [in] set prototype properties as object.
         * @param staticProps {Object} [in] set static properties as object.
         * @return {Object} subclass constructor.
         *
         * \~japanese
         * クラス継承のためのヘルパー関数
         * Backbone.js extend() 関数と同等
         *
         * @param protoProps  {Object} [in] prototype properties をオブジェクトで指定
         * @param staticProps {Object} [in] static properties をオブジェクトで指定
         * @return {Object} サブクラスのコンストラクタ
         */
        function extend(protoProps, staticProps) {
            var parent = this;
            var child;
            if (protoProps && protoProps.hasOwnProperty("constructor")) {
                child = protoProps.constructor;
            }
            else {
                child = function () {
                    return parent.apply(this, arguments);
                };
            }
            $.extend(child, parent, staticProps);
            var Surrogate = function () {
                this.constructor = child;
            };
            Surrogate.prototype = parent.prototype;
            child.prototype = new Surrogate;
            if (protoProps) {
                $.extend(child.prototype, protoProps);
            }
            child.__super__ = parent.prototype;
            return child;
        }
        Tools.extend = extend;
        /**
         * DPI 取得
         */
        function getDevicePixcelRatio() {
            var mediaQuery;
            var is_firefox = navigator.userAgent.toLowerCase().indexOf("firefox") > -1;
            if (null != window.devicePixelRatio && !is_firefox) {
                return window.devicePixelRatio;
            }
            else if (window.matchMedia) {
                mediaQuery =
                    "(-webkit-min-device-pixel-ratio: 1.5),\
                    (min--moz-device-pixel-ratio: 1.5),\
                    (-o-min-device-pixel-ratio: 3/2),\
                    (min-resolution: 1.5dppx)";
                if (window.matchMedia(mediaQuery).matches) {
                    return 1.5;
                }
                mediaQuery =
                    "(-webkit-min-device-pixel-ratio: 2),\
                    (min--moz-device-pixel-ratio: 2),\
                    (-o-min-device-pixel-ratio: 2/1),\
                    (min-resolution: 2dppx)";
                if (window.matchMedia(mediaQuery).matches) {
                    return 2;
                }
                mediaQuery =
                    "(-webkit-min-device-pixel-ratio: 0.75),\
                    (min--moz-device-pixel-ratio: 0.75),\
                    (-o-min-device-pixel-ratio: 3/4),\
                    (min-resolution: 0.75dppx)";
                if (window.matchMedia(mediaQuery).matches) {
                    return 0.7;
                }
            }
            else {
                return 1;
            }
        }
        Tools.getDevicePixcelRatio = getDevicePixcelRatio;
        // Canvas element のキャッシュ
        var s_canvasFactory;
        // キャッシュ済みの Canvas を取得する
        function getCanvas() {
            s_canvasFactory = s_canvasFactory || document.createElement("canvas");
            return s_canvasFactory.cloneNode(false);
        }
        Tools.getCanvas = getCanvas;
        /**
         * 画像リソースのロード完了を保証
         * ブラウザ既定のプログレッシブロードを走らせないため.
         *
         * @param  {String} url [in] url (data-url)
         * @return {IPromise<string>} 表示可能な url
         */
        function ensureImageLoaded(url) {
            var img = new Image();
            var destroy = function () {
                if (img) {
                    img.src = ""; // 読み込み停止
                    img = null;
                }
            };
            return new Promise(function (resolve, reject) {
                img.onload = function (event) {
                    destroy();
                    resolve(url);
                };
                img.onerror = function (event) {
                    destroy();
                    reject(CDP.makeErrorInfo(CDP.RESULT_CODE.ERROR_CDP_TOOLS_IMAGE_LOAD_FAILED, TAG, "image load failed. [url: " + url + "]"));
                };
                img.src = url;
            }, destroy);
        }
        Tools.ensureImageLoaded = ensureImageLoaded;
        /**
         * 画像のリサイズ
         * 指定した長辺の長さにアスペクト比を維持してリサイズを行う
         * longSideLength より小さな場合はオリジナルサイズで data-url を返却する
         *
         * @param  {String} src            [in] image に指定するソース
         * @param  {Number} longSideLength [in] リサイズに使用する長辺の最大値を指定
         * @return {IPromise<string>} base64 data url を返却
         */
        function resizeImage(src, longSideLength) {
            var img = new Image();
            var destroy = function () {
                if (img) {
                    img.src = ""; // 読み込み停止
                    img = null;
                }
            };
            return new Promise(function (resolve, reject) {
                img.onload = function (event) {
                    var canvas = getCanvas();
                    var ih = img.height, iw = img.width, ia = ih / iw;
                    var cw, ch;
                    if (iw === 0 || 0 === ia) {
                        reject(CDP.makeErrorInfo(CDP.RESULT_CODE.ERROR_CDP_TOOLS_INVALID_IMAGE, TAG, "invalid image. [src: " + src + "]"));
                    }
                    else {
                        if (longSideLength <= 0) {
                            longSideLength = (ia < 1) ? iw : ih;
                        }
                        if (ia < 1) {
                            cw = (longSideLength < iw) ? longSideLength : iw;
                            ch = Math.round(cw * ia);
                        }
                        else {
                            ch = (longSideLength < ih) ? longSideLength : ih;
                            cw = Math.round(ch / ia);
                        }
                        canvas.width = cw;
                        canvas.height = ch;
                        canvas.getContext("2d").drawImage(img, 0, 0, cw, ch);
                        resolve(canvas.toDataURL());
                    }
                    destroy();
                };
                img.onerror = function (event) {
                    destroy();
                    reject(CDP.makeErrorInfo(CDP.RESULT_CODE.ERROR_CDP_TOOLS_IMAGE_LOAD_FAILED, TAG, "image load failed. [src: " + src + "]"));
                };
                img.src = src;
            });
        }
        Tools.resizeImage = resizeImage;
    })(Tools = CDP.Tools || (CDP.Tools = {}));
})(CDP || (CDP = {}));
/* tslint:disable:max-line-length */
var CDP;
(function (CDP) {
    var Tools;
    (function (Tools) {
        var TAG = "[CDP.Tools.DateTime] ";
        /**
         * @class DateTime
         * @brief 時刻操作のユーティリティクラス
         */
        var DateTime = /** @class */ (function () {
            function DateTime() {
            }
            ///////////////////////////////////////////////////////////////////////
            // public static method
            /**
             * 基点となる日付から、n日後、n日前を算出
             *
             * @param base    {Date}   [in] 基準日
             * @param addDays {Number} [in] 加算日. マイナス指定でn日前も設定可能
             * @return {Date} 日付オブジェクト
             */
            DateTime.computeDate = function (base, addDays) {
                var dt = new Date(base.getTime());
                var baseSec = dt.getTime();
                var addSec = addDays * 86400000; //日数 * 1日のミリ秒数
                var targetSec = baseSec + addSec;
                dt.setTime(targetSec);
                return dt;
            };
            /**
             * Convert string to date object
             *
             * @param {String} date string ex) YYYY-MM-DDTHH:mm:SS.SSS
             * @return {Object} date object
             */
            DateTime.convertISOStringToDate = function (dateString) {
                var dateTime = dateString.split("T"), dateArray = dateTime[0].split("-");
                var timeArray, secArray, dateObject;
                if (dateTime[1]) {
                    timeArray = dateTime[1].split(":");
                    secArray = timeArray[2].split(".");
                }
                if (timeArray) {
                    dateObject = new Date(dateArray[0], dateArray[1] - 1, dateArray[2], timeArray[0], timeArray[1], secArray[0], secArray[1]);
                }
                else {
                    if (dateArray[2]) {
                        dateObject = new Date(dateArray[0], dateArray[1] - 1, dateArray[2]);
                    }
                    else if (dateArray[1]) {
                        dateObject = new Date(dateArray[0], dateArray[1] - 1);
                    }
                    else {
                        dateObject = new Date(dateArray[0]);
                    }
                }
                return dateObject;
            };
            /**
             *  Convert a date object into a string in PMOAPI recorded_date format(the ISO 8601 Extended Format)
             *
             * @param date   {Date}   [in] date object
             * @param target {String} [in] {year | month | date | hour | min | sec | msec }
             * @return {String}
             */
            DateTime.convertDateToISOString = function (date, target) {
                if (target === void 0) { target = "msec"; }
                var isoDateString;
                switch (target) {
                    case "year":
                    case "month":
                    case "date":
                    case "hour":
                    case "min":
                    case "sec":
                    case "msec":
                        break;
                    default:
                        console.warn(TAG + "unknown target: " + target);
                        target = "msec";
                }
                isoDateString = date.getFullYear();
                if ("year" === target) {
                    return isoDateString;
                }
                isoDateString += ("-" + DateTime.numberToDoubleDigitsString(date.getMonth() + 1));
                if ("month" === target) {
                    return isoDateString;
                }
                isoDateString += ("-" + DateTime.numberToDoubleDigitsString(date.getDate()));
                if ("date" === target) {
                    return isoDateString;
                }
                isoDateString += ("T" + DateTime.numberToDoubleDigitsString(date.getHours()));
                if ("hour" === target) {
                    return isoDateString;
                }
                isoDateString += (":" + DateTime.numberToDoubleDigitsString(date.getMinutes()));
                if ("min" === target) {
                    return isoDateString;
                }
                isoDateString += (":" + DateTime.numberToDoubleDigitsString(date.getSeconds()));
                if ("sec" === target) {
                    return isoDateString;
                }
                isoDateString += ("." + String((date.getMilliseconds() / 1000).toFixed(3)).slice(2, 5));
                return isoDateString;
            };
            /**
             * Convert file system compatible string to date object
             *
             * @param {String} date string ex) yyyy_MM_ddTHH_mm_ss_SSS
             * @return {Object} date object
             */
            DateTime.convertFileSystemStringToDate = function (dateString) {
                var dateTime = dateString.split("T"), dateArray = dateTime[0].split("_");
                var timeArray, dateObject;
                if (dateTime[1]) {
                    timeArray = dateTime[1].split("_");
                }
                if (timeArray) {
                    dateObject = new Date(dateArray[0], dateArray[1] - 1, dateArray[2], timeArray[0], timeArray[1], timeArray[2], timeArray[3]);
                }
                else {
                    if (dateArray[2]) {
                        dateObject = new Date(dateArray[0], dateArray[1] - 1, dateArray[2]);
                    }
                    else if (dateArray[1]) {
                        dateObject = new Date(dateArray[0], dateArray[1] - 1);
                    }
                    else {
                        dateObject = new Date(dateArray[0]);
                    }
                }
                return dateObject;
            };
            /**
             *  Convert a date object into a string in file system compatible format(yyyy_MM_ddTHH_mm_ss_SSS)
             *
             * @param date   {Date}   [in] date object
             * @param target {String} [in] {year | month | date | hour | min | sec | msec }
             * @return {String}
             */
            DateTime.convertDateToFileSystemString = function (date, target) {
                if (target === void 0) { target = "msec"; }
                var fileSystemString;
                switch (target) {
                    case "year":
                    case "month":
                    case "date":
                    case "hour":
                    case "min":
                    case "sec":
                    case "msec":
                        break;
                    default:
                        console.warn(TAG + "unknown target: " + target);
                        target = "msec";
                }
                fileSystemString = date.getFullYear();
                if ("year" === target) {
                    return fileSystemString;
                }
                fileSystemString += ("_" + DateTime.numberToDoubleDigitsString(date.getMonth() + 1));
                if ("month" === target) {
                    return fileSystemString;
                }
                fileSystemString += ("_" + DateTime.numberToDoubleDigitsString(date.getDate()));
                if ("date" === target) {
                    return fileSystemString;
                }
                fileSystemString += ("T" + DateTime.numberToDoubleDigitsString(date.getHours()));
                if ("hour" === target) {
                    return fileSystemString;
                }
                fileSystemString += ("_" + DateTime.numberToDoubleDigitsString(date.getMinutes()));
                if ("min" === target) {
                    return fileSystemString;
                }
                fileSystemString += ("_" + DateTime.numberToDoubleDigitsString(date.getSeconds()));
                if ("sec" === target) {
                    return fileSystemString;
                }
                fileSystemString += ("_" + String((date.getMilliseconds() / 1000).toFixed(3)).slice(2, 5));
                return fileSystemString;
            };
            ///////////////////////////////////////////////////////////////////////
            // private static method
            /**
             * Convert num to string(double digits)
             *
             * @param  {Number} number (0 <number < 100)
             * @return {String} double digits string
             */
            DateTime.numberToDoubleDigitsString = function (num) {
                if (num < 0 || num > 100) {
                    return null;
                }
                if (num < 10) {
                    return "0" + num;
                }
                return "" + num;
            };
            return DateTime;
        }());
        Tools.DateTime = DateTime;
    })(Tools = CDP.Tools || (CDP.Tools = {}));
})(CDP || (CDP = {}));
/// <reference types="jquery" />
var CDP;
(function (CDP) {
    var Tools;
    (function (Tools) {
        var TAG = "[CDP.Tools.Template] ";
        //___________________________________________________________________________________________________________________//
        /**
         * @class Template
         * @brief template script を管理するユーティリティクラス
         */
        var Template = /** @class */ (function () {
            function Template() {
            }
            ///////////////////////////////////////////////////////////////////////
            // 公開メソッド
            /**
             * 指定した id, class 名, Tag 名をキーにテンプレートの JQuery Element を取得する。
             *
             * @param {String}  key     [in] id, class, tag を表す文字列
             * @param {String}  [src]   [in] 外部 html を指定する場合は url を設定
             * @param {Boolean} [cache] [in] src html をキャッシュする場合は true. src が指定されているときのみ有効
             * @return template が格納されている JQuery Element
             */
            Template.getTemplateElement = function (key, src, cache) {
                if (src === void 0) { src = null; }
                if (cache === void 0) { cache = true; }
                var mapElement = Template.getElementMap();
                var $element = mapElement[key];
                try {
                    if (!$element) {
                        if (src) {
                            var html = Template.findHtmlFromSource(src);
                            $element = $(html).find(key);
                        }
                        else {
                            $element = $(key);
                        }
                        // 要素の検証
                        if ($element <= 0) {
                            throw ("invalid [key, src] = [" + key + ", " + src + "]");
                        }
                        if (src && cache) {
                            mapElement[key] = $element;
                        }
                    }
                }
                catch (exception) {
                    console.error(TAG + exception);
                    return null;
                }
                return $element;
            };
            /**
             * Map オブジェクトの削除
             * 明示的にキャッシュを開放する場合は本メソッドをコールする
             */
            Template.empty = function () {
                Template._mapElement = null;
                Template._mapSource = null;
            };
            Template.getJST = function (key, src, cache) {
                var template = null;
                var jst;
                var $element;
                if (key instanceof jQuery) {
                    $element = key;
                }
                else {
                    $element = Template.getTemplateElement(key, src, cache);
                }
                if (null != CDP.global.Hogan) {
                    template = Hogan.compile($element.text());
                    jst = function (data) {
                        return template.render(data);
                    };
                }
                else if (null != CDP.global._) {
                    template = _.template($element.html());
                    jst = function (data) {
                        // 改行とタブは削除する
                        return template(data).replace(/\n|\t/g, "");
                    };
                }
                else {
                    console.warn(TAG + "cannot find template engine module.");
                    console.warn("    'hogan' or 'underscore' is required.");
                }
                return jst;
            };
            ///////////////////////////////////////////////////////////////////////
            // 内部メソッド
            //! Element Map オブジェクトの取得
            Template.getElementMap = function () {
                if (!Template._mapElement) {
                    Template._mapElement = {};
                }
                return Template._mapElement;
            };
            //! URL Map オブジェクトの取得
            Template.getSourceMap = function () {
                if (!Template._mapSource) {
                    Template._mapSource = {};
                }
                return Template._mapSource;
            };
            //! URL Map から HTML を検索. 失敗した場合は undefined が返る
            Template.findHtmlFromSource = function (src) {
                var mapSource = Template.getSourceMap();
                var html = mapSource[src];
                if (!html) {
                    $.ajax({
                        url: src,
                        method: "GET",
                        async: false,
                        dataType: "html",
                        success: function (data) {
                            html = data;
                        },
                        error: function (data, status) {
                            throw ("ajax request failed. status: " + status);
                        }
                    });
                    // キャッシュに格納
                    mapSource[src] = html;
                }
                return html;
            };
            return Template;
        }());
        Tools.Template = Template;
    })(Tools = CDP.Tools || (CDP.Tools = {}));
})(CDP || (CDP = {}));
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var CDP;
(function (CDP) {
    var Tools;
    (function (Tools) {
        var TAG = "[CDP.Tools.ProgressCounter] ";
        /**
         * @class ProgressCounter
         * @brief 進捗の時間を扱うユーティリティクラス
         */
        var ProgressCounter = /** @class */ (function () {
            /**
             * constructor
             *
             * @param [options] オプション
             */
            function ProgressCounter(options) {
                this.reset(options);
            }
            /**
             * 開始時間を初期化
             */
            ProgressCounter.prototype.reset = function (options) {
                this._settings = __assign({
                    max: 100,
                    beginTime: Date.now(),
                    allowIncrementeRemain: false,
                    lastRemainTime: Infinity,
                }, options);
            };
            /**
             * 経過時間と推定残り時間を取得する
             * 進捗値が 0 の場合は、推定残り時間に Infinity を返す
             *
             * @param   progress [in] 進捗値
             * @returns 経過時間と推定残り時間 [msec]
             */
            ProgressCounter.prototype.compute = function (progress) {
                var passTime = Date.now() - this._settings.beginTime;
                var remainTime = Infinity;
                if (null != progress && 0 !== progress) {
                    remainTime = passTime * this._settings.max / progress - passTime;
                }
                if (this._settings.allowIncrementeRemain || (remainTime < this._settings.lastRemainTime)) {
                    this._settings.lastRemainTime = remainTime;
                }
                else {
                    remainTime = this._settings.lastRemainTime;
                }
                return { passTime: passTime, remainTime: remainTime };
            };
            return ProgressCounter;
        }());
        Tools.ProgressCounter = ProgressCounter;
    })(Tools = CDP.Tools || (CDP.Tools = {}));
})(CDP || (CDP = {}));

return CDP.Tools; }));
/*!
 * cdp.ui.listview.js 2.1.0
 *
 * Date: 2017-11-06T05:37:50.869Z
 */
(function (root, factory) { if (typeof define === "function" && define.amd) { define("cdp.ui.listview",["jquery", "underscore", "backbone"], function ($, _, Backbone) { return factory(root.CDP || (root.CDP = {}), $, _, Backbone); }); } else if (typeof exports === "object") { module.exports = factory(root.CDP || (root.CDP = {}), require("jquery"), require("underscore"), require("backbone")); } else { factory(root.CDP || (root.CDP = {}), root.$, root._, root.Backbone); } }(((this || 0).self || global), function (CDP, $, _, Backbone) { CDP.UI = CDP.UI || {};
/// <reference types="jquery" />
/// <reference types="backbone" />
var CDP;
(function (CDP) {
    var UI;
    (function (UI) {
        /**
         * @class ListViewGlobalConfig
         * @brief cdp.ui.listview の global confing
         */
        var ListViewGlobalConfig;
        (function (ListViewGlobalConfig) {
            ListViewGlobalConfig.WRAPPER_CLASS = "ui-listview-wrapper";
            ListViewGlobalConfig.WRAPPER_SELECTOR = "." + ListViewGlobalConfig.WRAPPER_CLASS;
            ListViewGlobalConfig.SCROLL_MAP_CLASS = "ui-listview-scroll-map";
            ListViewGlobalConfig.SCROLL_MAP_SELECTOR = "." + ListViewGlobalConfig.SCROLL_MAP_CLASS;
            ListViewGlobalConfig.INACTIVE_CLASS = "inactive";
            ListViewGlobalConfig.INACTIVE_CLASS_SELECTOR = "." + ListViewGlobalConfig.INACTIVE_CLASS;
            ListViewGlobalConfig.RECYCLE_CLASS = "ui-listview-recycle";
            ListViewGlobalConfig.RECYCLE_CLASS_SELECTOR = "." + ListViewGlobalConfig.RECYCLE_CLASS;
            ListViewGlobalConfig.LISTITEM_BASE_CLASS = "ui-listview-item-base";
            ListViewGlobalConfig.LISTITEM_BASE_CLASS_SELECTOR = "." + ListViewGlobalConfig.LISTITEM_BASE_CLASS;
            ListViewGlobalConfig.DATA_PAGE_INDEX = "data-page-index";
            ListViewGlobalConfig.DATA_CONTAINER_INDEX = "data-container-index";
        })(ListViewGlobalConfig = UI.ListViewGlobalConfig || (UI.ListViewGlobalConfig = {}));
    })(UI = CDP.UI || (CDP.UI = {}));
})(CDP || (CDP = {}));
var CDP;
(function (CDP) {
    var UI;
    (function (UI) {
        // cdp.ui.listview は cdp.core に依存しないため、独自にglobal を提供する
        /*jshint evil:true */
        UI.global = CDP.global || Function("return this")();
        /*jshint evil:false */
        /**
         * Backbone.View の新規合成
         *
         * @param base    {Backbone.View}                 [in] prototype chain 最下位の View クラス
         * @param derives {Backbone.View|Backbone.View[]} [in] 派生されるの View クラス
         * @return {Backbone.View|Backbone.View[]} 新規に生成された View のコンストラクタ
         */
        function composeViews(base, derives) {
            var _composed = base;
            var _derives = (derives instanceof Array ? derives : [derives]);
            _derives.forEach(function (derive) {
                var seed = {};
                _.extendOwn(seed, derive.prototype);
                delete seed.constructor;
                _composed = _composed.extend(seed);
            });
            return _composed;
        }
        UI.composeViews = composeViews;
        /**
         * Backbone.View の合成
         * prototype chain を作る合成
         *
         * @param derived {Backbone.View}                 [in] prototype chain 最上位の View クラス
         * @param bases   {Backbone.View|Backbone.View[]} [in] 合成元のView クラス
         */
        function deriveViews(derived, bases) {
            var _composed;
            var _bases = (bases instanceof Array ? bases : [bases]);
            if (2 <= _bases.length) {
                _composed = composeViews(_bases[0], _bases.slice(1));
            }
            else {
                _composed = _bases[0];
            }
            derived = composeViews(_composed, derived);
        }
        UI.deriveViews = deriveViews;
        /**
         * Backbone.View の合成
         * prototype chain を作らない合成
         *
         * @param derived {Backbone.View}                 [in] 元となる View クラス
         * @param bases   {Backbone.View|Backbone.View[]} [in] 合成元のView クラス
         */
        function mixinViews(derived, bases) {
            var _bases = (bases instanceof Array ? bases : [bases]);
            _bases.forEach(function (base) {
                Object.getOwnPropertyNames(base.prototype).forEach(function (name) {
                    derived.prototype[name] = base.prototype[name];
                });
            });
        }
        UI.mixinViews = mixinViews;
        //___________________________________________________________________________________________________________________//
        /**
         * @class _ListViewUtils
         * @brief 内部で使用する便利関数
         *        Tools からの最低限の流用
         */
        var _ListViewUtils;
        (function (_ListViewUtils) {
            /**
             * css の vender 拡張 prefix を返す
             *
             * @return {Array} prefix
             */
            _ListViewUtils.cssPrefixes = ["-webkit-", "-moz-", "-ms-", "-o-", ""];
            /**
             * css の matrix の値を取得.
             *
             * @param element {jQuery} [in] 対象の jQuery オブジェクト
             * @param type    {String} [in] matrix type string [translateX | translateY | scaleX | scaleY]
             * @return {Number} value
             */
            _ListViewUtils.getCssMatrixValue = function (element, type) {
                var transX = 0;
                var transY = 0;
                var scaleX = 0;
                var scaleY = 0;
                for (var i = 0; i < _ListViewUtils.cssPrefixes.length; i++) {
                    var matrix = $(element).css(_ListViewUtils.cssPrefixes[i] + "transform");
                    if (matrix) {
                        var is3dMatrix = matrix.indexOf("3d") !== -1 ? true : false;
                        matrix = matrix.replace("matrix3d", "").replace("matrix", "").replace(/[^\d.,-]/g, "");
                        var arr = matrix.split(",");
                        transX = Number(arr[is3dMatrix ? 12 : 4]);
                        transY = Number(arr[is3dMatrix ? 13 : 5]);
                        scaleX = Number(arr[0]);
                        scaleY = Number(arr[is3dMatrix ? 5 : 3]);
                        break;
                    }
                }
                switch (type) {
                    case "translateX":
                        return isNaN(transX) ? 0 : transX;
                    case "translateY":
                        return isNaN(transY) ? 0 : transY;
                    case "scaleX":
                        return isNaN(scaleX) ? 1 : scaleX;
                    case "scaleY":
                        return isNaN(scaleY) ? 1 : scaleY;
                    default:
                        return 0;
                }
            };
            /**
             * "transitionend" のイベント名配列を返す
             *
             * @return {Array} transitionend イベント名
             */
            _ListViewUtils.transitionEnd = "transitionend webkitTransitionEnd oTransitionEnd MSTransitionEnd";
            /**
             * transition 設定
             *
             * @private
             * @param {Object} element
             */
            _ListViewUtils.setTransformsTransitions = function (element, prop, msec, timingFunction) {
                var $element = $(element);
                var transitions = {};
                var second = (msec / 1000) + "s";
                var animation = " " + second + " " + timingFunction;
                var transform = ", transform" + animation;
                for (var i = 0; i < _ListViewUtils.cssPrefixes.length; i++) {
                    transitions[_ListViewUtils.cssPrefixes[i] + "transition"] = prop + animation + transform;
                }
                $element.css(transitions);
            };
            /**
             * transition 設定の削除
             *
             * @private
             * @param {Object} element
             */
            _ListViewUtils.clearTransitions = function (element) {
                var $element = $(element);
                $element.off(_ListViewUtils.transitionEnd);
                var transitions = {};
                for (var i = 0; i < _ListViewUtils.cssPrefixes.length; i++) {
                    transitions[_ListViewUtils.cssPrefixes[i] + "transition"] = "";
                }
                $element.css(transitions);
            };
            /**
             * Math.abs よりも高速な abs
             */
            _ListViewUtils.abs = function (x) {
                return x >= 0 ? x : -x;
            };
            /**
             * Math.max よりも高速な max
             */
            _ListViewUtils.max = function (lhs, rhs) {
                return lhs >= rhs ? lhs : rhs;
            };
        })(_ListViewUtils = UI._ListViewUtils || (UI._ListViewUtils = {}));
    })(UI = CDP.UI || (CDP.UI = {}));
})(CDP || (CDP = {}));
var CDP;
(function (CDP) {
    var UI;
    (function (UI) {
        var TAG = "[CDP.UI.StatusManager] ";
        /**
         * @class StatusManager
         * @brief UI 用状態管理クラス
         *        StatusManager のインスタンスごとに任意の状態管理ができる
         *
         */
        var StatusManager = /** @class */ (function () {
            function StatusManager() {
                this._status = {}; //!< statusScope() に使用される状態管理オブジェクト
            }
            ///////////////////////////////////////////////////////////////////////
            // Implements: IStatusManager
            //! 状態変数の参照カウントのインクリメント
            StatusManager.prototype.statusAddRef = function (status) {
                if (!this._status[status]) {
                    this._status[status] = 1;
                }
                else {
                    this._status[status]++;
                }
                return this._status[status];
            };
            //! 状態変数の参照カウントのデクリメント
            StatusManager.prototype.statusRelease = function (status) {
                var retval;
                if (!this._status[status]) {
                    retval = 0;
                }
                else {
                    this._status[status]--;
                    retval = this._status[status];
                    if (0 === retval) {
                        delete this._status[status];
                    }
                }
                return retval;
            };
            //! 処理スコープ毎に状態変数を設定
            StatusManager.prototype.statusScope = function (status, callback) {
                var _this = this;
                this.statusAddRef(status);
                var promise = callback();
                if (!promise) {
                    this.statusRelease(status);
                }
                else {
                    promise.then(function () {
                        _this.statusRelease(status);
                    }, function () {
                        _this.statusRelease(status);
                    });
                }
            };
            //! 指定した状態中であるか確認
            StatusManager.prototype.isStatusIn = function (status) {
                return !!this._status[status];
            };
            return StatusManager;
        }());
        UI.StatusManager = StatusManager;
    })(UI = CDP.UI || (CDP.UI = {}));
})(CDP || (CDP = {}));
var CDP;
(function (CDP) {
    var UI;
    (function (UI) {
        var _Config = CDP.UI.ListViewGlobalConfig;
        var _ToolCSS = CDP.UI._ListViewUtils;
        var TAG = "[CDP.UI.LineProfile] ";
        /**
         * @class LineProfile
         * @brief 1 ラインに関するプロファイルクラス
         *        framework が使用する
         */
        var LineProfile = /** @class */ (function () {
            /**
             * constructor
             *
             * @param _owner       {IListViewFramework} [in] 管理者である IListViewFramework インスタンス
             * @param _height      {Number}             [in] 初期の高さ
             * @param _initializer {Function}           [in] ListItemView 派生クラスのコンストラクタ
             * @param _info        {Object}             [in] ListItemView コンストラクタに渡されるオプション
             */
            function LineProfile(_owner, _height, _initializer, _info) {
                this._owner = _owner;
                this._height = _height;
                this._initializer = _initializer;
                this._info = _info;
                this._index = null; //!< global index
                this._pageIndex = null; //!< 所属する page index
                this._offset = null; //!< global offset
                this._$base = null; //!< 土台となる DOM インスタンスを格納
                this._instance = null; //!< ListItemView インスタンスを格納
            }
            ///////////////////////////////////////////////////////////////////////
            // public methods
            //! 有効化
            LineProfile.prototype.activate = function () {
                if (null == this._instance) {
                    var options = void 0;
                    this._$base = this.prepareBaseElement();
                    options = $.extend({}, {
                        el: this._$base,
                        owner: this._owner,
                        lineProfile: this,
                    }, this._info);
                    this._instance = new this._initializer(options);
                    if ("none" === this._$base.css("display")) {
                        this._$base.css("display", "block");
                    }
                }
                this.updatePageIndex(this._$base);
                if ("visible" !== this._$base.css("visibility")) {
                    this._$base.css("visibility", "visible");
                }
            };
            //! 不可視化
            LineProfile.prototype.hide = function () {
                if (null == this._instance) {
                    this.activate();
                }
                if ("hidden" !== this._$base.css("visibility")) {
                    this._$base.css("visibility", "hidden");
                }
            };
            //! 無効化
            LineProfile.prototype.inactivate = function () {
                if (null != this._instance) {
                    // xperia AX Jelly Bean (4.1.2)にて、 hidden element の削除でメモリーリークするため可視化する。
                    if ("visible" !== this._$base.css("visibility")) {
                        this._$base.css("visibility", "visible");
                    }
                    this._instance.remove();
                    this._instance = null;
                    this._$base.addClass(_Config.RECYCLE_CLASS);
                    this._$base.css("display", "none");
                    this._$base = null;
                }
            };
            //! 更新
            LineProfile.prototype.refresh = function () {
                if (null != this._instance) {
                    this._instance.render();
                }
            };
            //! 有効無効判定
            LineProfile.prototype.isActive = function () {
                return null != this._instance;
            };
            //! 高さ情報の更新. ListItemView からコールされる。
            LineProfile.prototype.updateHeight = function (newHeight, options) {
                var delta = newHeight - this._height;
                this._height = newHeight;
                this._owner.updateScrollMapHeight(delta);
                if (null != options && options.reflectAll) {
                    this._owner.updateProfiles(this._index);
                }
            };
            //! z-index のリセット. ScrollManager.removeItem() からコールされる。
            LineProfile.prototype.resetDepth = function () {
                if (null != this._instance) {
                    this._$base.css("z-index", this._owner.getListViewOptions().baseDepth);
                }
            };
            Object.defineProperty(LineProfile.prototype, "height", {
                ///////////////////////////////////////////////////////////////////////
                // getter/setter methods
                //! getter: ラインの高さ
                get: function () {
                    return this._height;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(LineProfile.prototype, "index", {
                //! getter: global index
                get: function () {
                    return this._index;
                },
                //! setter: global index
                set: function (index) {
                    this._index = index;
                    if (null != this._$base) {
                        this.updateIndex(this._$base);
                    }
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(LineProfile.prototype, "pageIndex", {
                //! getter: 所属ページ index
                get: function () {
                    return this._pageIndex;
                },
                //! setter: 所属ページ index
                set: function (index) {
                    this._pageIndex = index;
                    if (null != this._$base) {
                        this.updatePageIndex(this._$base);
                    }
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(LineProfile.prototype, "offset", {
                //! getter: line offset
                get: function () {
                    return this._offset;
                },
                //! setter: line offset
                set: function (offset) {
                    this._offset = offset;
                    if (null != this._$base) {
                        this.updateOffset(this._$base);
                    }
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(LineProfile.prototype, "info", {
                //! getter: info
                get: function () {
                    return this._info;
                },
                enumerable: true,
                configurable: true
            });
            ///////////////////////////////////////////////////////////////////////
            // private methods
            //! Base jQuery オブジェクトの生成
            LineProfile.prototype.prepareBaseElement = function () {
                var $base;
                var $map = this._owner.getScrollMapElement();
                var $recycle = this._owner.findRecycleElements().first();
                var itemTagName = this._owner.getListViewOptions().itemTagName;
                if (null != this._$base) {
                    console.warn(TAG + "this._$base is not null.");
                    return this._$base;
                }
                if (0 < $recycle.length) {
                    $base = $recycle;
                    $base.removeAttr("z-index");
                    $base.removeClass(_Config.RECYCLE_CLASS);
                }
                else {
                    $base = $("<" + itemTagName + " class='" + _Config.LISTITEM_BASE_CLASS + "'></" + itemTagName + ">");
                    $base.css("display", "none");
                    $map.append($base);
                }
                // 高さの更新
                if ($base.height() !== this._height) {
                    $base.height(this._height);
                }
                // index の設定
                this.updateIndex($base);
                // offset の更新
                this.updateOffset($base);
                return $base;
            };
            //! global index の更新
            LineProfile.prototype.updateIndex = function ($base) {
                if ($base.attr(_Config.DATA_CONTAINER_INDEX) !== this._index.toString()) {
                    $base.attr(_Config.DATA_CONTAINER_INDEX, this._index.toString());
                }
            };
            //! page index の更新
            LineProfile.prototype.updatePageIndex = function ($base) {
                if ($base.attr(_Config.DATA_PAGE_INDEX) !== this._pageIndex.toString()) {
                    $base.attr(_Config.DATA_PAGE_INDEX, this._pageIndex.toString());
                }
            };
            //! offset の更新
            LineProfile.prototype.updateOffset = function ($base) {
                var transform = {};
                if (this._owner.getListViewOptions().enableTransformOffset) {
                    if (_ToolCSS.getCssMatrixValue($base, "translateY") !== this._offset) {
                        for (var i = 0; i < _ToolCSS.cssPrefixes.length; i++) {
                            transform[_ToolCSS.cssPrefixes[i] + "transform"] = "translate3d(0px," + this._offset + "px,0px)";
                        }
                        $base.css(transform);
                    }
                }
                else {
                    if (parseInt($base.css("top"), 10) !== this._offset) {
                        $base.css("top", this._offset + "px");
                    }
                }
            };
            return LineProfile;
        }());
        UI.LineProfile = LineProfile;
    })(UI = CDP.UI || (CDP.UI = {}));
})(CDP || (CDP = {}));
var CDP;
(function (CDP) {
    var UI;
    (function (UI) {
        var TAG = "[CDP.UI.PageProfile] ";
        /**
         * @class PageProfile
         * @brief 1 ページに関するプロファイルクラス
         *        framework が使用する
         *        本クラスでは直接 DOM を操作してはいけない
         */
        var PageProfile = /** @class */ (function () {
            function PageProfile() {
                this._index = 0; //!< page index
                this._offset = 0; //!< page の Top からのオフセット
                this._height = 0; //!< page の高さ
                this._lines = []; //!< page 内で管理される LineProfile
                this._status = "inactive"; //!< page の状態 [ inactive | hidden | active ]
            }
            ///////////////////////////////////////////////////////////////////////
            // public methods
            //! 有効化
            PageProfile.prototype.activate = function () {
                if ("active" !== this._status) {
                    this._lines.forEach(function (line) {
                        line.activate();
                    });
                }
                this._status = "active";
            };
            //! 無可視化
            PageProfile.prototype.hide = function () {
                if ("hidden" !== this._status) {
                    this._lines.forEach(function (line) {
                        line.hide();
                    });
                }
                this._status = "hidden";
            };
            //! 無効化
            PageProfile.prototype.inactivate = function () {
                if ("inactive" !== this._status) {
                    this._lines.forEach(function (line) {
                        line.inactivate();
                    });
                }
                this._status = "inactive";
            };
            //! LineProfile を設定
            PageProfile.prototype.push = function (line) {
                this._lines.push(line);
                this._height += line.height;
            };
            //! 配下の LineProfile すべてが有効でない場合、Page ステータスを無効にする
            PageProfile.prototype.normalize = function () {
                var enableAll = _.every(this._lines, function (line) {
                    return line.isActive();
                });
                if (!enableAll) {
                    this._status = "inactive";
                }
            };
            //! LineProfile を取得
            PageProfile.prototype.getLineProfile = function (index) {
                if (0 <= index && index < this._lines.length) {
                    return this._lines[index];
                }
                else {
                    return null;
                }
            };
            //! 最初の LineProfile を取得
            PageProfile.prototype.getLineProfileFirst = function () {
                return this.getLineProfile(0);
            };
            //! 最後の LineProfile を取得
            PageProfile.prototype.getLineProfileLast = function () {
                return this.getLineProfile(this._lines.length - 1);
            };
            Object.defineProperty(PageProfile.prototype, "index", {
                ///////////////////////////////////////////////////////////////////////
                // getter/setter methods
                //! getter: page index
                get: function () {
                    return this._index;
                },
                //! setter: page index
                set: function (index) {
                    this._index = index;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(PageProfile.prototype, "offset", {
                //! getter: page offset
                get: function () {
                    return this._offset;
                },
                //! setter: page offset
                set: function (offset) {
                    this._offset = offset;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(PageProfile.prototype, "height", {
                //! getter: 実際にページに割り当てられている高さ
                get: function () {
                    return this._height;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(PageProfile.prototype, "status", {
                //! getter: 状態取得
                get: function () {
                    return this._status;
                },
                enumerable: true,
                configurable: true
            });
            return PageProfile;
        }());
        UI.PageProfile = PageProfile;
    })(UI = CDP.UI || (CDP.UI = {}));
})(CDP || (CDP = {}));
var CDP;
(function (CDP) {
    var UI;
    (function (UI) {
        var TAG = "[CDP.UI.GroupProfile] ";
        /**
         * @class GroupProfile
         * @brief ラインをグループ管理するプロファイルクラス
         *        本クラスでは直接 DOM を操作してはいけない
         */
        var GroupProfile = /** @class */ (function () {
            /**
             * constructor
             *
             * @param _id    {String}             [in] GroupProfile の ID
             * @param _owner {ExpandableListView} [in] 管理者である ExpandableListView インスタンス
             */
            function GroupProfile(_id, _owner) {
                this._id = _id;
                this._owner = _owner;
                this._parent = null; //!< 親 GroupProfile インスタンス
                this._children = []; //!< 子 GroupProfile インスタンス
                this._expanded = false; //!< 開閉情報
                this._status = "unregistered"; //!< _owner への登録状態 [ unregistered | registered ]
                this._mapLines = {}; //!< 自身が管轄する LineProfile を key とともに格納
            }
            ///////////////////////////////////////////////////////////////////////
            // public method
            /**
             * 本 GroupProfile が管理する List を作成して登録
             *
             * @param height      {Number}   [in] ラインの高さ
             * @param initializer {Function} [in] ListItemView 派生クラスのコンストラクタ
             * @param info        {Object}   [in] initializer に渡されるオプション引数
             * @param layoutKey   {String}   [in] layout 毎に使用する識別子 (オプショナル)
             * @return {GroupProfile} 本インスタンス
             */
            GroupProfile.prototype.addItem = function (height, initializer, info, layoutKey) {
                var line;
                var options = $.extend({}, { groupProfile: this }, info);
                if (null == layoutKey) {
                    layoutKey = GroupProfile.LAYOUT_KEY_DEFAULT;
                }
                if (null == this._mapLines[layoutKey]) {
                    this._mapLines[layoutKey] = [];
                }
                line = new UI.LineProfile(this._owner.core, Math.floor(height), initializer, options);
                // _owner の管理下にあるときは速やかに追加
                if (("registered" === this._status) &&
                    (null == this._owner.layoutKey || layoutKey === this._owner.layoutKey)) {
                    this._owner._addLine(line, this.getLastLineIndex() + 1);
                    this._owner.update();
                }
                this._mapLines[layoutKey].push(line);
                return this;
            };
            GroupProfile.prototype.addChildren = function (target) {
                var _this = this;
                var children = (target instanceof Array) ? target : [target];
                children.forEach(function (child) {
                    child.setParent(_this);
                });
                this._children = this._children.concat(children);
                return this;
            };
            /**
             * 親 GroupProfile を取得
             *
             * @return {GroupProfile} GroupProfile 親 インスタンス
             */
            GroupProfile.prototype.getParent = function () {
                return this._parent;
            };
            /**
             * 子 GroupProfile を取得
             *
             * @return {GroupProfile[]} GroupProfile 子 インスタンス配列
             */
            GroupProfile.prototype.getChildren = function () {
                return this._children;
            };
            /**
             * 子 Group を持っているか判定
             * layoutKey が指定されれば、layout の状態まで判定
             *
             * @param layoutKey {String} [in] layout 毎に使用する識別子 (オプショナル)
             * @return {Boolean} true: 有, false: 無
             */
            GroupProfile.prototype.hasChildren = function (layoutKey) {
                if (this._children.length <= 0) {
                    return false;
                }
                else if (null != layoutKey) {
                    return this._children[0].hasLayoutKeyOf(layoutKey);
                }
                else {
                    return true;
                }
            };
            /**
             * layout の状態を判定
             *
             * @param layoutKey {String} [in] layout 毎に使用する識別子
             * @return {Boolean} true: 有, false: 無
             */
            GroupProfile.prototype.hasLayoutKeyOf = function (layoutKey) {
                if (null == layoutKey) {
                    layoutKey = GroupProfile.LAYOUT_KEY_DEFAULT;
                }
                return (null != this._mapLines[layoutKey]);
            };
            /**
             * グループ展開
             */
            GroupProfile.prototype.expand = function () {
                var _this = this;
                var lines = [];
                if (this._lines.length < 0) {
                    console.warn(TAG + "this group has no lines.");
                }
                else if (!this.hasChildren()) {
                    console.warn(TAG + "this group has no children.");
                }
                else if (!this.isExpanded()) {
                    lines = this.queryOperationTarget("registered");
                    this._expanded = true;
                    if (0 < lines.length) {
                        this._owner.statusScope("expanding", function () {
                            // 自身を更新
                            _this._lines.forEach(function (line) {
                                line.refresh();
                            });
                            // 配下を更新
                            _this._owner._addLine(lines, _this.getLastLineIndex() + 1);
                            _this._owner.update();
                        });
                    }
                }
            };
            /**
             * グループ収束
             *
             * @param delay {Number} [in] 要素削除に費やす遅延時間. 既定: animationDuration 値
             */
            GroupProfile.prototype.collapse = function (delay) {
                var _this = this;
                var lines = [];
                if (!this.hasChildren()) {
                    console.warn(TAG + "this group has no children.");
                }
                else if (this.isExpanded()) {
                    lines = this.queryOperationTarget("unregistered");
                    this._expanded = false;
                    if (0 < lines.length) {
                        delay = (null != delay) ? delay : this._owner.core.getListViewOptions().animationDuration;
                        this._owner.statusScope("collapsing", function () {
                            // 自身を更新
                            _this._lines.forEach(function (line) {
                                line.refresh();
                            });
                            // 配下を更新
                            _this._owner.removeItem(lines[0].index, lines.length, delay);
                            _this._owner.update();
                        });
                    }
                }
            };
            /**
             * 自身をリストの可視領域に表示
             *
             * @param options {EnsureVisibleOptions} [in] オプション
             */
            GroupProfile.prototype.ensureVisible = function (options) {
                if (0 < this._lines.length) {
                    this._owner.ensureVisible(this._lines[0].index, options);
                }
                else if (null != options.callback) {
                    options.callback();
                }
            };
            /**
             * 開閉のトグル
             *
             * @param delay {Number} [in] collapse の要素削除に費やす遅延時間. 既定: animationDuration 値
             */
            GroupProfile.prototype.toggle = function (delay) {
                if (this._expanded) {
                    this.collapse(delay);
                }
                else {
                    this.expand();
                }
            };
            /**
             * 展開状態を判定
             *
             * @return {Boolean} true: 展開, false:収束
             */
            GroupProfile.prototype.isExpanded = function () {
                return this._expanded;
            };
            /**
             * list view へ登録
             * Top Group のみ登録可能
             *
             * @param insertTo {Number} 挿入位置を index で指定
             * @return {GroupProfile} 本インスタンス
             */
            GroupProfile.prototype.register = function (insertTo) {
                if (this._parent) {
                    console.error(TAG + "logic error: 'register' method is acceptable only top group.");
                }
                else {
                    this._owner._addLine(this.preprocess("registered"), insertTo);
                }
                return this;
            };
            /**
             * list view へ復元
             * Top Group のみ登録可能
             *
             * @return {GroupProfile} 本インスタンス
             */
            GroupProfile.prototype.restore = function () {
                var lines = [];
                if (this._parent) {
                    console.error(TAG + "logic error: 'restore' method is acceptable only top group.");
                }
                else if (this._lines) {
                    if (this._expanded) {
                        lines = this._lines.concat(this.queryOperationTarget("active"));
                    }
                    else {
                        lines = this._lines;
                    }
                    this._owner._addLine(lines);
                }
                return this;
            };
            /**
             * 配下の最後の line index を取得
             *
             * @param withActiveChildren {Boolean} [in] 登録済みの子 GroupProfile を含めて検索する場合は true を指定
             * @return {Number} index. エラーの場合は null.
             */
            GroupProfile.prototype.getLastLineIndex = function (withActiveChildren) {
                var _this = this;
                if (withActiveChildren === void 0) { withActiveChildren = false; }
                var lines = (function () {
                    var _lines;
                    if (withActiveChildren) {
                        _lines = _this.queryOperationTarget("active");
                    }
                    if (null == lines || lines.length <= 0) {
                        _lines = _this._lines;
                    }
                    return _lines;
                })();
                if (lines.length <= 0) {
                    console.error(TAG + "logic error: this group is stil not registered.");
                    return null;
                }
                else {
                    return lines[lines.length - 1].index;
                }
            };
            Object.defineProperty(GroupProfile.prototype, "id", {
                /**
                 * ID を取得
                 *
                 * @return {String} 割り振られた ID
                 */
                get: function () {
                    return this._id;
                },
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(GroupProfile.prototype, "status", {
                /**
                 * ステータスを取得
                 *
                 * @return {String} ステータス文字列
                 */
                get: function () {
                    return this._status;
                },
                enumerable: true,
                configurable: true
            });
            ///////////////////////////////////////////////////////////////////////
            // private method
            /* tslint:disable:no-unused-variable */
            /**
             * 親 Group 指定
             *
             * @param parent {GroupProfile} [in] 親 GroupProfile インスタンス
             */
            GroupProfile.prototype.setParent = function (parent) {
                this._parent = parent;
            };
            /* tslint:enable:no-unused-variable */
            /**
             * register / unregister の前処理
             *
             * @param newStatus {String} [in] 新ステータス文字列
             * @return {LineProfile[]} 更新すべき LineProfile の配列
             */
            GroupProfile.prototype.preprocess = function (newStatus) {
                var lines = [];
                if (newStatus !== this._status && null != this._lines) {
                    lines = this._lines;
                }
                this._status = newStatus;
                return lines;
            };
            /**
             * 操作対象の LineProfile 配列を取得
             *
             * @param newStatus {String} [in] 新ステータス文字列
             * @return {LineProfile[]} 操作対象の LineProfile の配列
             */
            GroupProfile.prototype.queryOperationTarget = function (operation) {
                var findTargets = function (group) {
                    var lines = [];
                    group._children.forEach(function (child) {
                        switch (operation) {
                            case "registered":
                                lines = lines.concat(child.preprocess(operation));
                                break;
                            case "unregistered":
                                lines = lines.concat(child.preprocess(operation));
                                break;
                            case "active":
                                if (null != child._lines) {
                                    lines = lines.concat(child._lines);
                                }
                                break;
                            default:
                                console.warn(TAG + "unknown operation: " + operation);
                                return;
                        }
                        if (child.isExpanded()) {
                            lines = lines.concat(findTargets(child));
                        }
                    });
                    return lines;
                };
                return findTargets(this);
            };
            Object.defineProperty(GroupProfile.prototype, "_lines", {
                /**
                 * 自身の管理するアクティブな LineProfie を取得
                 *
                 * @return {LineProfile[]} LineProfie 配列
                 */
                get: function () {
                    var key = this._owner.layoutKey;
                    if (null != key) {
                        return this._mapLines[key];
                    }
                    else {
                        return this._mapLines[GroupProfile.LAYOUT_KEY_DEFAULT];
                    }
                },
                enumerable: true,
                configurable: true
            });
            GroupProfile.LAYOUT_KEY_DEFAULT = "-layout-default";
            return GroupProfile;
        }());
        UI.GroupProfile = GroupProfile;
    })(UI = CDP.UI || (CDP.UI = {}));
})(CDP || (CDP = {}));
var CDP;
(function (CDP) {
    var UI;
    (function (UI) {
        var _Utils = CDP.UI._ListViewUtils;
        var TAG = "[CDP.UI.ScrollerElement] ";
        /**
         * @class ScrollerElement
         * @brief HTMLElement の Scroller クラス
         */
        var ScrollerElement = /** @class */ (function () {
            function ScrollerElement(element, options) {
                this._$target = null;
                this._$scrollMap = null;
                this._listviewOptions = null;
                this._$target = $(element);
                this._listviewOptions = options;
            }
            //! Scroller の型を取得
            ScrollerElement.prototype.getType = function () {
                return ScrollerElement.TYPE;
            };
            //! position 取得
            ScrollerElement.prototype.getPos = function () {
                return this._$target.scrollTop();
            };
            //! position の最大値を取得
            ScrollerElement.prototype.getPosMax = function () {
                if (null == this._$scrollMap) {
                    this._$scrollMap = this._$target.children().first();
                }
                return _Utils.max(this._$scrollMap.height() - this._$target.height(), 0);
            };
            //! イベント登録
            ScrollerElement.prototype.on = function (type, func) {
                switch (type) {
                    case "scroll":
                        this._$target.on("scroll", func);
                        break;
                    case "scrollstop":
                        this._$target.on("scrollstop", func);
                        break;
                    default:
                        console.warn(TAG + "unsupported type: " + type);
                        break;
                }
            };
            //! イベント登録解除
            ScrollerElement.prototype.off = function (type, func) {
                switch (type) {
                    case "scroll":
                        this._$target.off("scroll", func);
                        break;
                    case "scrollstop":
                        this._$target.off("scrollstop", func);
                        break;
                    default:
                        console.warn(TAG + "unsupported type: " + type);
                        break;
                }
            };
            //! スクロール位置を指定
            ScrollerElement.prototype.scrollTo = function (pos, animate, time) {
                if (!this._listviewOptions.enableAnimation || !animate) {
                    this._$target.scrollTop(pos);
                }
                else {
                    if (null == time) {
                        time = this._listviewOptions.animationDuration;
                    }
                    this._$target.animate({
                        scrollTop: pos
                    }, time);
                }
            };
            //! Scroller の状態更新
            ScrollerElement.prototype.update = function () {
                // noop.
            };
            //! Scroller の破棄
            ScrollerElement.prototype.destroy = function () {
                this._$scrollMap = null;
                if (this._$target) {
                    this._$target.off();
                    this._$target = null;
                }
            };
            Object.defineProperty(ScrollerElement, "TYPE", {
                //! タイプ定義
                get: function () {
                    return "element-overflow";
                },
                enumerable: true,
                configurable: true
            });
            //! factory 取得
            ScrollerElement.getFactory = function () {
                var factory = function (element, options) {
                    return new ScrollerElement(element, options);
                };
                // set type signature.
                factory.type = ScrollerElement.TYPE;
                return factory;
            };
            return ScrollerElement;
        }());
        UI.ScrollerElement = ScrollerElement;
    })(UI = CDP.UI || (CDP.UI = {}));
})(CDP || (CDP = {}));
var CDP;
(function (CDP) {
    var UI;
    (function (UI) {
        var _Utils = CDP.UI._ListViewUtils;
        var TAG = "[CDP.UI.ScrollerNative] ";
        /**
         * @class ScrollerNative
         * @brief Browser Native の Scroller クラス
         */
        var ScrollerNative = /** @class */ (function () {
            //! constructor
            function ScrollerNative(options) {
                this._$body = null;
                this._$target = null;
                this._listviewOptions = null;
                this._$target = $(document);
                this._$body = $("body");
                this._listviewOptions = options;
            }
            //! Scroller の型を取得
            ScrollerNative.prototype.getType = function () {
                return ScrollerNative.TYPE;
            };
            //! position 取得
            ScrollerNative.prototype.getPos = function () {
                return this._$target.scrollTop();
            };
            //! position の最大値を取得
            ScrollerNative.prototype.getPosMax = function () {
                return _Utils.max(this._$target.height() - window.innerHeight, 0);
            };
            //! イベント登録
            ScrollerNative.prototype.on = function (type, func) {
                switch (type) {
                    case "scroll":
                        this._$target.on("scroll", func);
                        break;
                    case "scrollstop":
                        $(window).on("scrollstop", func);
                        break;
                    default:
                        console.warn(TAG + "unsupported type: " + type);
                        break;
                }
            };
            //! イベント登録解除
            ScrollerNative.prototype.off = function (type, func) {
                switch (type) {
                    case "scroll":
                        this._$target.off("scroll", func);
                        break;
                    case "scrollstop":
                        $(window).off("scrollstop", func);
                        break;
                    default:
                        console.warn(TAG + "unsupported type: " + type);
                        break;
                }
            };
            //! スクロール位置を指定
            ScrollerNative.prototype.scrollTo = function (pos, animate, time) {
                if (!this._listviewOptions.enableAnimation || !animate) {
                    this._$body.scrollTop(pos);
                }
                else {
                    if (null == time) {
                        time = this._listviewOptions.animationDuration;
                    }
                    this._$body.animate({
                        scrollTop: pos
                    }, time);
                }
            };
            //! Scroller の状態更新
            ScrollerNative.prototype.update = function () {
                // noop.
            };
            //! Scroller の破棄
            ScrollerNative.prototype.destroy = function () {
                this._$target = null;
            };
            Object.defineProperty(ScrollerNative, "TYPE", {
                //! タイプ定義
                get: function () {
                    return "native-scroll";
                },
                enumerable: true,
                configurable: true
            });
            //! factory 取得
            ScrollerNative.getFactory = function () {
                var factory = function (element, options) {
                    return new ScrollerNative(options);
                };
                // set type signature.
                factory.type = ScrollerNative.TYPE;
                return factory;
            };
            return ScrollerNative;
        }());
        UI.ScrollerNative = ScrollerNative;
    })(UI = CDP.UI || (CDP.UI = {}));
})(CDP || (CDP = {}));
var CDP;
(function (CDP) {
    var UI;
    (function (UI) {
        var _Config = CDP.UI.ListViewGlobalConfig;
        var _Utils = CDP.UI._ListViewUtils;
        var TAG = "[CDP.UI.ScrollerIScroll] ";
        /**
         * @class ScrollerIScroll
         * @brief iScroll を使用した Scroller クラス
         */
        var ScrollerIScroll = /** @class */ (function () {
            function ScrollerIScroll($owner, element, iscrollOptions, listviewOptions) {
                this._$owner = null;
                this._iscroll = null;
                this._refreshTimerId = null;
                this._$wrapper = null;
                this._$scroller = null;
                this._listviewOptions = null;
                if (null != UI.global.IScroll) {
                    this._$owner = $owner;
                    this._iscroll = new IScroll(element, iscrollOptions);
                    this._$wrapper = $(this._iscroll.wrapper);
                    this._$scroller = $(this._iscroll.scroller);
                    this._listviewOptions = listviewOptions;
                }
                else {
                    console.error(TAG + "iscroll module doesn't load.");
                }
            }
            //! Scroller の型を取得
            ScrollerIScroll.prototype.getType = function () {
                return ScrollerIScroll.TYPE;
            };
            //! position 取得
            ScrollerIScroll.prototype.getPos = function () {
                var pos = this._iscroll.getComputedPosition().y;
                if (_.isNaN(pos)) {
                    pos = 0;
                }
                else {
                    pos = -pos;
                }
                return pos;
            };
            //! position の最大値を取得
            ScrollerIScroll.prototype.getPosMax = function () {
                return _Utils.max(-this._iscroll.maxScrollY, 0);
            };
            //! イベント登録
            ScrollerIScroll.prototype.on = function (type, func) {
                switch (type) {
                    case "scroll":
                        this._iscroll.on("scroll", func);
                        break;
                    case "scrollstop":
                        this._iscroll.on("scrollEnd", func);
                        break;
                    default:
                        console.warn(TAG + "unsupported type: " + type);
                        break;
                }
            };
            //! イベント登録解除
            ScrollerIScroll.prototype.off = function (type, func) {
                switch (type) {
                    case "scroll":
                        this._iscroll.off("scroll", func);
                        break;
                    case "scrollstop":
                        this._iscroll.on("scrollEnd", func);
                        break;
                    default:
                        console.warn(TAG + "unsupported type: " + type);
                        break;
                }
            };
            //! スクロール位置を指定
            ScrollerIScroll.prototype.scrollTo = function (pos, animate, time) {
                time = 0;
                if (this._listviewOptions.enableAnimation && animate) {
                    time = time || this._listviewOptions.animationDuration;
                }
                this._iscroll.scrollTo(0, -pos, time);
            };
            //! Scroller の状態更新
            ScrollerIScroll.prototype.update = function () {
                var _this = this;
                if (this._$owner) {
                    // update wrapper
                    (function () {
                        var ownerHeight = _this._$owner.height();
                        if (ownerHeight !== _this._$wrapper.height()) {
                            _this._$wrapper.height(ownerHeight);
                        }
                    })();
                    if (null != this._refreshTimerId) {
                        clearTimeout(this._refreshTimerId);
                    }
                    var proc_1 = function () {
                        if (_this._$scroller && _this._$scroller.height() !== _this._iscroll.scrollerHeight) {
                            _this._iscroll.refresh();
                            _this._refreshTimerId = setTimeout(proc_1, _this._listviewOptions.scrollMapRefreshInterval);
                        }
                        else {
                            _this._refreshTimerId = null;
                        }
                    };
                    this._iscroll.refresh();
                    this._refreshTimerId = setTimeout(proc_1, this._listviewOptions.scrollMapRefreshInterval);
                }
            };
            //! Scroller の破棄
            ScrollerIScroll.prototype.destroy = function () {
                this._$scroller = null;
                this._$wrapper = null;
                this._iscroll.destroy();
                this._$owner = null;
            };
            Object.defineProperty(ScrollerIScroll, "TYPE", {
                //! タイプ定義
                get: function () {
                    return "iscroll";
                },
                enumerable: true,
                configurable: true
            });
            //! factory 取得
            ScrollerIScroll.getFactory = function (options) {
                var defaultOpt = {
                    scrollX: false,
                    bounce: false,
                    tap: true,
                    click: true,
                    mouseWheel: true,
                    scrollbars: true,
                    interactiveScrollbars: true,
                    shrinkScrollbars: "scale",
                    fadeScrollbars: true,
                    preventDefault: false,
                    disablePointer: true,
                    disableMouse: false,
                    disableTouch: false,
                    probeType: 2,
                };
                var iscrollOptions = $.extend({}, defaultOpt, options);
                var factory = function (element, listviewOptions) {
                    var $owner = $(element);
                    var $map = $owner.find(_Config.SCROLL_MAP_SELECTOR);
                    var $wrapper = $("<div class='" + _Config.WRAPPER_CLASS + "'></div>")
                        .css({
                        position: "absolute",
                        width: "100%",
                        height: "100%",
                        overflow: "hidden",
                    });
                    $map.wrap($wrapper);
                    return new ScrollerIScroll($owner, _Config.WRAPPER_SELECTOR, iscrollOptions, listviewOptions);
                };
                // set type signature.
                factory.type = ScrollerIScroll.TYPE;
                return factory;
            };
            return ScrollerIScroll;
        }());
        UI.ScrollerIScroll = ScrollerIScroll;
    })(UI = CDP.UI || (CDP.UI = {}));
})(CDP || (CDP = {}));
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var CDP;
(function (CDP) {
    var UI;
    (function (UI) {
        var TAG = "[CDP.UI.ListItemView] ";
        /**
         * @class ListItemView
         * @brief ListView が扱う ListItem コンテナクラス
         */
        var ListItemView = /** @class */ (function (_super) {
            __extends(ListItemView, _super);
            /**
             * constructor
             */
            function ListItemView(options) {
                var _this = _super.call(this, options) || this;
                _this._owner = null;
                _this._lineProfile = null;
                _this._owner = options.owner;
                if (options.$el) {
                    var delegates = _this.events ? true : false;
                    _this.setElement(options.$el, delegates);
                }
                _this._lineProfile = options.lineProfile;
                return _this;
            }
            ///////////////////////////////////////////////////////////////////////
            // Implements: ListItemView
            //! 描画: framework から呼び出されるため、オーバーライド必須
            ListItemView.prototype.render = function () {
                console.warn(TAG + "need override 'render()' method.");
                return this;
            };
            //! 自身の Line インデックスを取得
            ListItemView.prototype.getIndex = function () {
                return this._lineProfile.index;
            };
            //! 自身に指定された高さを取得
            ListItemView.prototype.getSpecifiedHeight = function () {
                return this._lineProfile.height;
            };
            //! child node が存在するか判定
            ListItemView.prototype.hasChildNode = function () {
                if (!this.$el) {
                    return false;
                }
                else {
                    return 0 < this.$el.children().length;
                }
            };
            /**
             * 高さを更新
             *
             * @param newHeight {Number}              [in] 新しい高さ
             * @param options   {UpdateHeightOptions} [in] line の高さ更新時に影響するすべての LineProfile の再計算を行う場合は { reflectAll: true }
             * @return {ListItemView} インスタンス
             */
            ListItemView.prototype.updateHeight = function (newHeight, options) {
                if (this.$el) {
                    if (this.getSpecifiedHeight() !== newHeight) {
                        this._lineProfile.updateHeight(newHeight, options);
                        this.$el.height(newHeight);
                    }
                }
                return this;
            };
            ///////////////////////////////////////////////////////////////////////
            // Implements: IComposableView
            /**
             * すでに定義された Backbone.View を基底クラスに設定し、extend を実行する。
             *
             * @param derives         {Backbone.View|Backbone.View[]} [in] 合成元の View クラス
             * @param properties      {Object}                        [in] prototype プロパティ
             * @param classProperties {Object}                        [in] static プロパティ
             * @return {Backbone.View|Backbone.View[]} 新規に生成された View のコンストラクタ
             */
            ListItemView.compose = function (derives, properties, classProperties) {
                var composed = UI.composeViews(ListItemView, derives);
                return composed.extend(properties, classProperties);
            };
            ///////////////////////////////////////////////////////////////////////
            // Override: Backbone.View
            //! 開放
            ListItemView.prototype.remove = function () {
                // xperia AX Jelly Bean (4.1.2)にて、メモリーリークを軽減させる効果
                this.$el.find("figure").css("background-image", "none");
                // this.$el は再利用するため破棄しない
                this.$el.children().remove();
                this.$el.off();
                this.$el = null;
                this.stopListening();
                this._lineProfile = null;
                return this;
            };
            Object.defineProperty(ListItemView.prototype, "owner", {
                ///////////////////////////////////////////////////////////////////////
                // short cut methods
                //! Owner 取得
                get: function () {
                    return this._owner;
                },
                enumerable: true,
                configurable: true
            });
            return ListItemView;
        }(Backbone.View));
        UI.ListItemView = ListItemView;
    })(UI = CDP.UI || (CDP.UI = {}));
})(CDP || (CDP = {}));
/* tslint:disable:no-bitwise no-unused-expression */
/* jshint -W030 */ // for "Expected an assignment or function call and instead saw an expression"
var CDP;
(function (CDP) {
    var UI;
    (function (UI) {
        var _Config = CDP.UI.ListViewGlobalConfig;
        var _Utils = CDP.UI._ListViewUtils;
        var TAG = "[CDP.UI.ScrollManager] ";
        /**
         * @class ScrollManager
         * @brief メモリ管理を行うスクロール処理のコアロジック実装クラス
         *        本クラスは IListView インターフェイスを持ち DOM にアクセスするが、Backbone.View を継承しない
         */
        var ScrollManager = /** @class */ (function () {
            /**
             * constructor
             *
             * @param _$root  {JQuery} [in] 管理対象のルートエレメント
             * @param options {ListViewOptions} [in] オプション
             */
            function ScrollManager(options) {
                var _this = this;
                this._$root = null; //!< Scroll 対象のルートオブジェクト
                this._$map = null; //!< Scroll Map element を格納
                this._mapHeight = 0; //!< Scroll Map の高さを格納 (_$map の状態に依存させない)
                this._scroller = null; //!< Scroll に使用する IScroller インスタンス
                this._settings = null; //!< ScrollManager オプションを格納
                this._active = true; //!< UI 表示中は true に指定
                this._scrollEventHandler = null; //!< Scroll Event Handler
                this._scrollStopEventHandler = null; //!< Scroll Stop Event Handler
                this._baseHeight = 0; //!< 高さの基準値
                this._lines = []; //!< 管理下にある LineProfile 配列
                this._pages = []; //!< 管理下にある PageProfile 配列
                //! 最新の表示領域情報を格納 (Scroll 中の更新処理に使用)
                this._lastActivePageContext = {
                    index: 0,
                    from: 0,
                    to: 0,
                    pos: 0,
                };
                this._backup = {}; //!< データの backup 領域. key と _lines を格納。派生クラスで拡張可能。
                // ListViewOptions 既定値
                var defOptions = {
                    scrollerFactory: UI.ScrollerElement.getFactory(),
                    enableHiddenPage: false,
                    enableTransformOffset: false,
                    scrollMapRefreshInterval: 200,
                    scrollRefreshDistance: 200,
                    pagePrepareCount: 3,
                    pagePreloadCount: 1,
                    enableAnimation: true,
                    animationDuration: 0,
                    baseDepth: "auto",
                    itemTagName: "li",
                    removeItemWithTransition: true,
                    useDummyInactiveScrollMap: false,
                };
                // 設定格納
                this._settings = $.extend({}, defOptions, options);
                // スクロールイベント
                this._scrollEventHandler = function (event) {
                    _this.onScroll(_this._scroller.getPos());
                };
                // スクロール停止イベント
                this._scrollStopEventHandler = function (event) {
                    _this.onScrollStop(_this._scroller.getPos());
                };
            }
            ///////////////////////////////////////////////////////////////////////
            // public method
            //! 内部オブジェクトの初期化
            ScrollManager.prototype.initialize = function ($root, height) {
                // 既に構築されていた場合は破棄
                if (this._$root) {
                    this.destroy();
                }
                this._$root = $root;
                this._$map = $root.hasClass(_Config.SCROLL_MAP_CLASS) ? $root : $root.find(_Config.SCROLL_MAP_SELECTOR);
                // _$map が無い場合は初期化しない
                if (this._$map.length <= 0) {
                    this._$root = null;
                    return false;
                }
                this._scroller = this.createScroller();
                this.setBaseHeight(height);
                this.setScrollerCondition();
                return true;
            };
            //! 内部オブジェクトの破棄
            ScrollManager.prototype.destroy = function () {
                if (this._scroller) {
                    this.resetScrollerCondition();
                    this._scroller.destroy();
                    this._scroller = null;
                }
                this.release();
                this._$map = null;
                this._$root = null;
            };
            //! ページの基準値を取得
            ScrollManager.prototype.setBaseHeight = function (height) {
                this._baseHeight = height;
                if (this._baseHeight <= 0) {
                    console.warn(TAG + "invalid base height: " + this._baseHeight);
                }
                if (this._scroller) {
                    this._scroller.update();
                }
            };
            //! active 状態設定
            ScrollManager.prototype.setActiveState = function (active) {
                this._active = active;
                this.treatScrollPosition();
            };
            //! active 状態判定
            ScrollManager.prototype.isActive = function () {
                return this._active;
            };
            //! scroller の種類を取得
            ScrollManager.prototype.getScrollerType = function () {
                return this._settings.scrollerFactory.type;
            };
            /**
             * 状態に応じたスクロール位置の保存/復元
             * cdp.ui.fs.js: PageTabListView が実験的に使用
             * TODO: ※iscroll は未対応
             */
            ScrollManager.prototype.treatScrollPosition = function () {
                var _this = this;
                var i;
                var transform = {};
                var updateOffset = function ($target) {
                    var offset = (_this._scroller.getPos() - _this._lastActivePageContext.pos);
                    if (_Utils.getCssMatrixValue($target, "translateY") !== offset) {
                        for (i = 0; i < _Utils.cssPrefixes.length; i++) {
                            transform[_Utils.cssPrefixes[i] + "transform"] = "translate3d(0px," + offset + "px,0px)";
                        }
                        $target.css(transform);
                        return $target;
                    }
                };
                var clearOffset = function ($target) {
                    for (i = 0; i < _Utils.cssPrefixes.length; i++) {
                        transform[_Utils.cssPrefixes[i] + "transform"] = "";
                    }
                    $target.css(transform);
                    return $target;
                };
                if (this._active) {
                    // 以下のスコープの処理に対して画面更新を1回にできないため、JB, ICS ではちらつきが発生する。Kitkat 以降は良好。
                    (function () {
                        if (_this._scroller) {
                            _this._scroller.scrollTo(_this._lastActivePageContext.pos, false, 0);
                        }
                        clearOffset(_this._$map).css("display", "block");
                    })();
                    if (this._settings.useDummyInactiveScrollMap) {
                        this.prepareInactiveMap().remove();
                    }
                }
                else if (this._scroller) {
                    if (this._settings.useDummyInactiveScrollMap) {
                        updateOffset(this.prepareInactiveMap());
                    }
                    else {
                        updateOffset(this._$map);
                    }
                }
            };
            //! inactive 用 Map の生成
            ScrollManager.prototype.prepareInactiveMap = function () {
                var $parent = this._$map.parent();
                var $inactiveMap = $parent.find(_Config.INACTIVE_CLASS_SELECTOR);
                if ($inactiveMap.length <= 0) {
                    var currentPageIndex_1 = this.getPageIndex();
                    var $listItemViews = this._$map.clone().children().filter(function (index, element) {
                        var pageIndex = ~~$(element).attr(_Config.DATA_PAGE_INDEX);
                        if (currentPageIndex_1 - 1 <= pageIndex || pageIndex <= currentPageIndex_1 + 1) {
                            return true;
                        }
                        else {
                            return false;
                        }
                    });
                    $inactiveMap = $("<section class='" + _Config.SCROLL_MAP_CLASS + " " + _Config.INACTIVE_CLASS + "'></section>")
                        .append($listItemViews)
                        .height(this._mapHeight);
                    $parent.append($inactiveMap);
                    this._$map.css("display", "none");
                }
                return $inactiveMap;
            };
            ///////////////////////////////////////////////////////////////////////
            // Implements: IListView プロファイル管理
            //! 初期化済みか判定
            ScrollManager.prototype.isInitialized = function () {
                return !!this._$root;
            };
            //! プロパティを指定して、LineProfile を管理
            ScrollManager.prototype.addItem = function (height, initializer, info, insertTo) {
                this._addLine(new UI.LineProfile(this, Math.floor(height), initializer, info), insertTo);
            };
            //! プロパティを指定して、LineProfile を管理. 登録 framework が使用する
            ScrollManager.prototype._addLine = function (_line, insertTo) {
                var lines = (_line instanceof Array) ? _line : [_line];
                var i, n;
                var deltaHeight = 0;
                var addTail = false;
                if (null == insertTo) {
                    insertTo = this._lines.length;
                }
                if (insertTo === this._lines.length) {
                    addTail = true;
                }
                // scroll map の更新
                for (i = 0, n = lines.length; i < n; i++) {
                    deltaHeight += lines[i].height;
                }
                this.updateScrollMapHeight(deltaHeight);
                // 挿入
                for (i = lines.length - 1; i >= 0; i--) {
                    this._lines.splice(insertTo, 0, lines[i]);
                }
                // page 設定の解除
                if (!addTail) {
                    if (0 === insertTo) {
                        this.clearPage();
                    }
                    else if (null != this._lines[insertTo - 1].pageIndex) {
                        this.clearPage(this._lines[insertTo - 1].pageIndex);
                    }
                }
                // offset の再計算
                this.updateProfiles(insertTo);
            };
            ScrollManager.prototype.removeItem = function (index, arg2, arg3) {
                if (index instanceof Array) {
                    this._removeLines(index, arg2);
                }
                else {
                    this._removeLine(index, arg2, arg3);
                }
            };
            //! 指定した LineProfile を削除: 連続 index 版
            ScrollManager.prototype._removeLine = function (index, size, delay) {
                var _this = this;
                if (null == size) {
                    size = 1;
                }
                if (index < 0 || this._lines.length < index + size) {
                    console.error(TAG + "logic error. removeItem(), invalid index: " + index);
                    return;
                }
                delay = (null != delay) ? delay : 0;
                var removed = [];
                var delta = 0;
                var mapTransition = false;
                // 削除候補と変化量の算出
                (function () {
                    var line;
                    for (var i = 0; i < size; i++) {
                        line = _this._lines[index + i];
                        delta += line.height;
                        // 削除要素の z-index の初期化
                        line.resetDepth();
                        removed.push(line);
                    }
                    // 自動設定・削除遅延時間が設定されかつ、スクロールポジションに変更がある場合は transition 設定
                    if (_this._settings.removeItemWithTransition && (0 < delay)) {
                        var current = _this.getScrollPos();
                        var posMax = _this.getScrollPosMax() - delta;
                        mapTransition = (posMax < current);
                    }
                })();
                // 更新
                (function () {
                    // transition 設定
                    if (mapTransition) {
                        _this.setupScrollMapTransition(_this._$map, delay);
                    }
                    // page 設定の解除
                    if (null != _this._lines[index].pageIndex) {
                        _this.clearPage(_this._lines[index].pageIndex);
                    }
                    // スクロール領域の更新
                    _this.updateScrollMapHeight(-delta);
                    // 配列から削除
                    _this._lines.splice(index, size);
                    // offset の再計算
                    _this.updateProfiles(index);
                    // 遅延削除
                    setTimeout(function () {
                        removed.forEach(function (line) {
                            line.inactivate();
                        });
                    }, delay);
                })();
            };
            //! 指定した LineProfile を削除: random access 版
            ScrollManager.prototype._removeLines = function (indexes, delay) {
                var _this = this;
                delay = (null != delay) ? delay : 0;
                for (var i = 0, n = indexes.length; i < n; i++) {
                    if (i < 0 || this._lines.length < i) {
                        console.error(TAG + "logic error. removeItem(), invalid index: " + i);
                        return;
                    }
                }
                var removed = [];
                var delta = 0;
                var mapTransition = false;
                // 削除候補と変化量の算出
                (function () {
                    var line;
                    indexes.forEach(function (index) {
                        line = _this._lines[index];
                        delta += line.height;
                        // 削除要素の z-index の初期化
                        line.resetDepth();
                        removed.push(line);
                    });
                    // 自動設定・削除遅延時間が設定されかつ、スクロールポジションに変更がある場合は transition 設定
                    if (_this._settings.removeItemWithTransition && (0 < delay)) {
                        var current = _this.getScrollPos();
                        var posMax = _this.getScrollPosMax() - delta;
                        mapTransition = (posMax < current);
                    }
                })();
                // 更新
                (function () {
                    // transition 設定
                    if (mapTransition) {
                        _this.setupScrollMapTransition(_this._$map, delay);
                    }
                    indexes.forEach(function (index) {
                        // page 設定の解除
                        if (null != _this._lines[index].pageIndex) {
                            _this.clearPage(_this._lines[index].pageIndex);
                        }
                        // 配列から削除
                        _this._lines.splice(index, 1);
                        // offset の再計算
                        _this.updateProfiles(index);
                    });
                    // スクロール領域の更新
                    _this.updateScrollMapHeight(-delta);
                    // 遅延削除
                    setTimeout(function () {
                        removed.forEach(function (line) {
                            line.inactivate();
                        });
                    }, delay);
                })();
            };
            //! scroll map のトランジション設定
            ScrollManager.prototype.setupScrollMapTransition = function ($map, delay) {
                var transitionEndHandler = function (event) {
                    $map.off(_Utils.transitionEnd);
                    _Utils.clearTransitions($map);
                };
                this._$map.on(_Utils.transitionEnd, transitionEndHandler);
                _Utils.setTransformsTransitions($map, "height", delay, "ease");
            };
            ScrollManager.prototype.getItemInfo = function (target) {
                var index;
                var parser = function ($target) {
                    if ($target.hasClass(_Config.LISTITEM_BASE_CLASS)) {
                        return ~~$target.attr(_Config.DATA_CONTAINER_INDEX);
                    }
                    else if ($target.hasClass(_Config.SCROLL_MAP_CLASS) || $target.length <= 0) {
                        console.warn(TAG + "cannot ditect line from event object.");
                        return null;
                    }
                    else {
                        return parser($target.parent());
                    }
                };
                if (target instanceof $.Event) {
                    index = parser($(target.currentTarget));
                }
                else if (typeof target === "number") {
                    index = target;
                }
                if (null == index) {
                    console.error(TAG + "logic error. unsupported arg type. type: " + typeof target);
                    return null;
                }
                else if (index < 0 || this._lines.length <= index) {
                    console.error(TAG + "logic error. invalid range. index: " + index);
                    return null;
                }
                return this._lines[index].info;
            };
            //! アクティブページを更新
            ScrollManager.prototype.refresh = function () {
                var _this = this;
                var targets = {};
                var searchCount = this._settings.pagePrepareCount + this._settings.pagePreloadCount;
                var currentPageIndex = this.getPageIndex();
                var highPriorityIndex = [];
                var oldExsistPage = _.filter(this._pages, function (page) {
                    return "inactive" !== page.status;
                });
                var changeState = function (index) {
                    if (index === currentPageIndex) {
                        targets[index] = "activate";
                        highPriorityIndex.push(index);
                    }
                    else if (_Utils.abs(currentPageIndex - index) <= _this._settings.pagePrepareCount) {
                        targets[index] = "activate";
                    }
                    else {
                        if (_this._settings.enableHiddenPage) {
                            targets[index] = "hide";
                        }
                        else {
                            targets[index] = "activate";
                        }
                    }
                    // current page の 前後は high priority にする
                    if (currentPageIndex + 1 === index || currentPageIndex - 1 === index) {
                        highPriorityIndex.push(index);
                    }
                };
                // 対象無し
                if (this._lines.length <= 0) {
                    return;
                }
                (function () {
                    var i = 0;
                    var pageIndex = 0;
                    var overflowPrev = 0, overflowNext = 0;
                    var beginIndex = currentPageIndex - searchCount;
                    var endIndex = currentPageIndex + searchCount;
                    for (pageIndex = beginIndex; pageIndex <= endIndex; pageIndex++) {
                        if (pageIndex < 0) {
                            overflowPrev++;
                            continue;
                        }
                        if (_this._pages.length <= pageIndex) {
                            overflowNext++;
                            continue;
                        }
                        changeState(pageIndex);
                    }
                    if (0 < overflowPrev) {
                        for (i = 0, pageIndex = currentPageIndex + searchCount + 1; i < overflowPrev; i++, pageIndex++) {
                            if (_this._pages.length <= pageIndex) {
                                break;
                            }
                            changeState(pageIndex);
                        }
                    }
                    if (0 < overflowNext) {
                        for (i = 0, pageIndex = currentPageIndex - searchCount - 1; i < overflowNext; i++, pageIndex--) {
                            if (pageIndex < 0) {
                                break;
                            }
                            changeState(pageIndex);
                        }
                    }
                })();
                // 不要になった page の inactivate
                oldExsistPage.forEach(function (page) {
                    var index = page.index;
                    if (null == targets[index]) {
                        page.inactivate();
                    }
                });
                // 優先 page の activate
                highPriorityIndex
                    .sort(function (lhs, rhs) {
                    if (lhs < rhs) {
                        return -1;
                    }
                    else if (lhs > rhs) {
                        return 1;
                    }
                    else {
                        return 0;
                    }
                })
                    .forEach(function (index) {
                    setTimeout(function () {
                        if (_this.isInitialized()) {
                            _this._pages[index] && _this._pages[index].activate();
                        }
                    }, 0);
                });
                // そのほかの page の 状態変更
                _.each(targets, function (action, key) {
                    setTimeout(function () {
                        if (_this.isInitialized()) {
                            var index = ~~key;
                            switch (action) {
                                case "activate":
                                    _this._pages[index] && _this._pages[index].activate();
                                    break;
                                case "hide":
                                    _this._pages[index] && _this._pages[index].hide();
                                    break;
                                case "inactivate":
                                    console.warn(TAG + "unexpected operation: inactivate");
                                    break;
                                default:
                                    console.warn(TAG + "unknown operation: " + targets[key]);
                                    break;
                            }
                        }
                    }, 0);
                });
                // 更新後に使用しなかった DOM を削除
                this.findRecycleElements().remove();
                this._lastActivePageContext.from = this._pages[currentPageIndex].getLineProfileFirst() ?
                    this._pages[currentPageIndex].getLineProfileFirst().index : 0;
                this._lastActivePageContext.to = this._pages[currentPageIndex].getLineProfileLast() ?
                    this._pages[currentPageIndex].getLineProfileLast().index : 0;
                this._lastActivePageContext.index = currentPageIndex;
            };
            //! 未アサインページを構築
            ScrollManager.prototype.update = function () {
                var index = this._pages.length;
                this.assignPage(index);
                this.refresh();
            };
            //! ページアサインを再構成
            ScrollManager.prototype.rebuild = function () {
                this.clearPage();
                this.assignPage();
                this.refresh();
            };
            //! 管轄データを破棄
            ScrollManager.prototype.release = function () {
                this._lines.forEach(function (line) {
                    line.inactivate();
                });
                this._pages = [];
                this._lines = [];
                if (this._$map) {
                    this._mapHeight = 0;
                    this._$map.height(0);
                }
            };
            ///////////////////////////////////////////////////////////////////////
            // Implements: IListView Backup / Restore
            //! 内部データをバックアップ
            ScrollManager.prototype.backup = function (key) {
                if (null == this._backup[key]) {
                    this._backup[key] = {
                        lines: this._lines,
                    };
                }
                return true;
            };
            //! 内部データをリストア
            ScrollManager.prototype.restore = function (key, rebuild) {
                if (rebuild === void 0) { rebuild = true; }
                if (null == this._backup[key]) {
                    return false;
                }
                if (0 < this._lines.length) {
                    this.release();
                }
                this._addLine(this._backup[key].lines);
                if (rebuild) {
                    this.rebuild();
                }
                return true;
            };
            //! バックアップデータの有無
            ScrollManager.prototype.hasBackup = function (key) {
                if (null != this._backup[key]) {
                    return true;
                }
                else {
                    return false;
                }
            };
            //! バックアップデータの破棄
            ScrollManager.prototype.clearBackup = function (key) {
                if (null == key) {
                    this._backup = {};
                    return true;
                }
                else if (null != this._backup[key]) {
                    delete this._backup[key];
                    return true;
                }
                else {
                    return false;
                }
            };
            Object.defineProperty(ScrollManager.prototype, "backupData", {
                //! バックアップデータにアクセス
                get: function () {
                    return this._backup;
                },
                enumerable: true,
                configurable: true
            });
            ///////////////////////////////////////////////////////////////////////
            // Implements: IListView Scroll
            //! スクロールイベントハンドラ設定/解除
            ScrollManager.prototype.setScrollHandler = function (handler, on) {
                if (this._scroller) {
                    if (on) {
                        this._scroller.on("scroll", handler);
                    }
                    else {
                        this._scroller.off("scroll", handler);
                    }
                }
            };
            //! スクロール終了イベントハンドラ設定/解除
            ScrollManager.prototype.setScrollStopHandler = function (handler, on) {
                if (this._scroller) {
                    if (on) {
                        this._scroller.on("scrollstop", handler);
                    }
                    else {
                        this._scroller.off("scrollstop", handler);
                    }
                }
            };
            //! スクロール位置を取得
            ScrollManager.prototype.getScrollPos = function () {
                return this._scroller ? this._scroller.getPos() : 0;
            };
            //! スクロール位置の最大値を取得
            ScrollManager.prototype.getScrollPosMax = function () {
                return this._scroller ? this._scroller.getPosMax() : 0;
            };
            //! スクロール位置を指定
            ScrollManager.prototype.scrollTo = function (pos, animate, time) {
                if (this._scroller) {
                    if (pos < 0) {
                        console.warn(TAG + "invalid position, too small. [pos: " + pos + "]");
                        pos = 0;
                    }
                    else if (this._scroller.getPosMax() < pos) {
                        console.warn(TAG + "invalid position, too big. [pos: " + pos + "]");
                        pos = this._scroller.getPosMax();
                    }
                    // pos のみ先駆けて更新
                    this._lastActivePageContext.pos = pos;
                    if (pos !== this._scroller.getPos()) {
                        this._scroller.scrollTo(pos, animate, time);
                    }
                }
            };
            //! 指定された ListItemView の表示を保証
            ScrollManager.prototype.ensureVisible = function (index, options) {
                var _this = this;
                if (index < 0 || this._lines.length <= index) {
                    console.warn(TAG + "ensureVisible(), invalid index, noop. [index: " + index + "]");
                    return;
                }
                else if (!this._scroller) {
                    console.warn(TAG + "scroller is not ready.");
                    return;
                }
                (function () {
                    var target = _this._lines[index];
                    var defaultOptions = {
                        partialOK: true,
                        setTop: false,
                        animate: _this._settings.enableAnimation,
                        time: _this._settings.animationDuration,
                        callback: function () { },
                    };
                    var operation = $.extend({}, defaultOptions, options);
                    var currentScope = {
                        from: _this._scroller.getPos(),
                        to: _this._scroller.getPos() + _this._baseHeight,
                    };
                    var targetScope = {
                        from: target.offset,
                        to: target.offset + target.height,
                    };
                    var isInScope = function () {
                        if (operation.partialOK) {
                            if (targetScope.from <= currentScope.from) {
                                if (currentScope.from <= targetScope.to) {
                                    return true;
                                }
                                else {
                                    return false;
                                }
                            }
                            else {
                                if (targetScope.from <= currentScope.to) {
                                    return true;
                                }
                                else {
                                    return false;
                                }
                            }
                        }
                        else {
                            if (currentScope.from <= targetScope.from && targetScope.to <= currentScope.to) {
                                return true;
                            }
                            else {
                                return false;
                            }
                        }
                    };
                    var detectPosition = function () {
                        if (targetScope.from < currentScope.from) {
                            return targetScope.from;
                        }
                        else if (currentScope.from < targetScope.from) {
                            return target.offset - target.height; // bottom 合わせは情報不足により不可
                        }
                        else {
                            console.warn(TAG + "logic error.");
                            return 0;
                        }
                    };
                    var pos;
                    if (operation.setTop) {
                        pos = targetScope.from;
                    }
                    else if (isInScope()) {
                        // noop.
                        operation.callback();
                        return;
                    }
                    else {
                        pos = detectPosition();
                    }
                    // 補正
                    if (pos < 0) {
                        pos = 0;
                    }
                    else if (_this._scroller.getPosMax() < pos) {
                        pos = _this._scroller.getPosMax();
                    }
                    setTimeout(operation.callback, operation.time);
                    _this.scrollTo(pos, operation.animate, operation.time);
                })();
            };
            ///////////////////////////////////////////////////////////////////////
            // implements: IListViewFramework:
            //! Scroll Map の高さを取得
            ScrollManager.prototype.getScrollMapHeight = function () {
                return this._$map ? this._mapHeight : 0;
            };
            //! Scroll Map の高さを更新. framework が使用する.
            ScrollManager.prototype.updateScrollMapHeight = function (delta) {
                if (this._$map) {
                    this._mapHeight += delta;
                    // for fail safe.
                    if (this._mapHeight < 0) {
                        this._mapHeight = 0;
                    }
                    this._$map.height(this._mapHeight);
                }
            };
            //! 内部 Profile の更新. framework が使用する.
            ScrollManager.prototype.updateProfiles = function (from) {
                var i, n;
                var last;
                for (i = from, n = this._lines.length; i < n; i++) {
                    if (0 < i) {
                        last = this._lines[i - 1];
                        this._lines[i].index = last.index + 1;
                        this._lines[i].offset = last.offset + last.height;
                    }
                    else {
                        this._lines[i].index = 0;
                        this._lines[i].offset = 0;
                    }
                }
            };
            //! Scroll Map Element を取得. framework が使用する.
            ScrollManager.prototype.getScrollMapElement = function () {
                return this._$map || $("");
            };
            //! リサイクル可能な Element を取得. framework が使用する.
            ScrollManager.prototype.findRecycleElements = function () {
                return this._$map ? this._$map.find(_Config.RECYCLE_CLASS_SELECTOR) : $("");
            };
            //! ListViewOptions を取得. framework が使用する.
            ScrollManager.prototype.getListViewOptions = function () {
                return this._settings;
            };
            ///////////////////////////////////////////////////////////////////////
            // private method:
            //! Scroller 用環境設定
            ScrollManager.prototype.setScrollerCondition = function () {
                this._scroller.on("scroll", this._scrollEventHandler);
                this._scroller.on("scrollstop", this._scrollStopEventHandler);
            };
            //! Scroller 用環境破棄
            ScrollManager.prototype.resetScrollerCondition = function () {
                this._scroller.off("scrollstop", this._scrollStopEventHandler);
                this._scroller.off("scroll", this._scrollEventHandler);
            };
            //! 既定の Scroller オブジェクトの作成
            ScrollManager.prototype.createScroller = function () {
                return this._settings.scrollerFactory(this._$root[0], this._settings);
            };
            //! 現在の Page Index を取得
            ScrollManager.prototype.getPageIndex = function () {
                var _this = this;
                var i, n;
                var page;
                var candidate;
                var scrollPos = this._scroller ? this._scroller.getPos() : 0;
                var scrollPosMax = this._scroller ? this._scroller.getPosMax() : 0;
                var scrollMapSize = (function () {
                    var lastPage = _this.getLastPage();
                    if (null != lastPage) {
                        return lastPage.offset + lastPage.height;
                    }
                    else {
                        return _this._baseHeight;
                    }
                })();
                var pos = (function () {
                    if (0 === scrollPosMax || scrollPosMax <= _this._baseHeight) {
                        return 0;
                    }
                    else {
                        return scrollPos * scrollMapSize / scrollPosMax;
                    }
                })();
                var validRange = function (_page) {
                    if (null == _page) {
                        return false;
                    }
                    else if (_page.offset <= pos && pos <= _page.offset + _page.height) {
                        return true;
                    }
                    else {
                        return false;
                    }
                };
                if (this._baseHeight <= 0) {
                    console.error(TAG + "invalid base height: " + this._baseHeight);
                    return 0;
                }
                candidate = Math.floor(pos / this._baseHeight);
                if (this._pages.length <= candidate) {
                    candidate = this._pages.length - 1;
                }
                page = this._pages[candidate];
                if (validRange(page)) {
                    return page.index;
                }
                else if (pos < page.offset) {
                    for (i = candidate - 1; i >= 0; i--) {
                        page = this._pages[i];
                        if (validRange(page)) {
                            return page.index;
                        }
                    }
                    console.warn(TAG + "unknown page index.");
                    return 0;
                }
                else {
                    for (i = candidate + 1, n = this._pages.length; i < n; i++) {
                        page = this._pages[i];
                        if (validRange(page)) {
                            return page.index;
                        }
                    }
                    console.warn(TAG + "unknown page index.");
                    return this._pages.length - 1;
                }
            };
            /**
             * スクロールイベント
             *
             * @param pos {Number} [in] スクロールポジション
             */
            ScrollManager.prototype.onScroll = function (pos) {
                if (this._active && 0 < this._pages.length) {
                    var currentPageIndex = this.getPageIndex();
                    // TODO: 調整
                    if (_Utils.abs(pos - this._lastActivePageContext.pos) < this._settings.scrollRefreshDistance) {
                        if (this._lastActivePageContext.index !== currentPageIndex) {
                            this.refresh();
                        }
                    }
                    this._lastActivePageContext.pos = pos;
                }
            };
            /**
             * スクロール停止イベント
             *
             * @param pos {Number} [in] スクロールポジション
             */
            ScrollManager.prototype.onScrollStop = function (pos) {
                if (this._active && 0 < this._pages.length) {
                    var currentPageIndex = this.getPageIndex();
                    if (this._lastActivePageContext.index !== currentPageIndex) {
                        this.refresh();
                    }
                    this._lastActivePageContext.pos = pos;
                }
            };
            //! 最後のページを取得
            ScrollManager.prototype.getLastPage = function () {
                if (0 < this._pages.length) {
                    return this._pages[this._pages.length - 1];
                }
                else {
                    return null;
                }
            };
            /**
             * ページ区分のアサイン
             *
             * @param from {Number} [in] page index を指定
             */
            ScrollManager.prototype.assignPage = function (from) {
                var _this = this;
                var i, n;
                if (null == from) {
                    from = 0;
                }
                else {
                    this.clearPage(from);
                }
                (function () {
                    var lineIndex = 0;
                    var lastPage = _this.getLastPage();
                    var lastLine;
                    var tempPage;
                    if (null == lastPage) {
                        lastPage = new UI.PageProfile();
                        _this._pages.push(lastPage);
                    }
                    else {
                        lastLine = lastPage.getLineProfileLast();
                        if (null != lastLine) {
                            lineIndex = lastLine.index + 1;
                        }
                    }
                    var asignee = _this._lines.slice(lineIndex);
                    for (i = 0, n = asignee.length; i < n; i++) {
                        if (_this._baseHeight <= lastPage.height) {
                            lastPage.normalize();
                            tempPage = lastPage;
                            tempPage = new UI.PageProfile();
                            tempPage.index = lastPage.index + 1;
                            tempPage.offset = lastPage.offset + lastPage.height;
                            lastPage = tempPage;
                            _this._pages.push(lastPage);
                        }
                        asignee[i].pageIndex = lastPage.index;
                        lastPage.push(asignee[i]);
                    }
                    lastPage.normalize();
                })();
                if (this._scroller) {
                    this._scroller.update();
                }
            };
            /**
             * ページ区分の解除
             *
             * @param from {Number} [in] page index を指定
             */
            ScrollManager.prototype.clearPage = function (from) {
                if (null == from) {
                    from = 0;
                }
                this._pages = this._pages.slice(0, from);
            };
            return ScrollManager;
        }());
        UI.ScrollManager = ScrollManager;
    })(UI = CDP.UI || (CDP.UI = {}));
})(CDP || (CDP = {}));
var CDP;
(function (CDP) {
    var UI;
    (function (UI) {
        var TAG = "[CDP.UI.ListView] ";
        /**
         * @class ListView
         * @brief メモリ管理機能を提供する仮想リストビュークラス
         */
        var ListView = /** @class */ (function (_super) {
            __extends(ListView, _super);
            /**
             * constructor
             *
             * @param options {ListViewConstructOptions} [in] オプション
             */
            function ListView(options) {
                var _this = _super.call(this, options) || this;
                _this._scrollMgr = null; //!< scroll コアロジック
                var opt = options || {};
                _this._scrollMgr = new UI.ScrollManager(options);
                if (opt.$el) {
                    var delegates = _this.events ? true : false;
                    _this.setElement(opt.$el, delegates);
                }
                else {
                    var height = opt.initialHeight || _this.$el.height();
                    _this._scrollMgr.initialize(_this.$el, height);
                }
                return _this;
            }
            ListView.prototype.setElement = function (element, delegate) {
                if (this._scrollMgr) {
                    var $el = $(element);
                    this._scrollMgr.destroy();
                    this._scrollMgr.initialize($el, $el.height());
                }
                return _super.prototype.setElement.call(this, element, delegate);
            };
            //! 破棄
            ListView.prototype.remove = function () {
                this._scrollMgr.destroy();
                return _super.prototype.remove.call(this);
            };
            ///////////////////////////////////////////////////////////////////////
            // Implements: IListView Profile 管理
            //! 初期化済みか判定
            ListView.prototype.isInitialized = function () {
                return this._scrollMgr.isInitialized();
            };
            //! プロパティを指定して、LineProfile を管理
            ListView.prototype.addItem = function (height, initializer, info, insertTo) {
                this._addLine(new UI.LineProfile(this._scrollMgr, Math.floor(height), initializer, info), insertTo);
            };
            ListView.prototype.removeItem = function (index, arg2, arg3) {
                this._scrollMgr.removeItem(index, arg2, arg3);
            };
            ListView.prototype.getItemInfo = function (target) {
                return this._scrollMgr.getItemInfo(target);
            };
            //! アクティブページを更新
            ListView.prototype.refresh = function () {
                this._scrollMgr.refresh();
            };
            //! 未アサインページを構築
            ListView.prototype.update = function () {
                this._scrollMgr.update();
            };
            //! ページアサインを再構成
            ListView.prototype.rebuild = function () {
                this._scrollMgr.rebuild();
            };
            //! 管轄データを破棄
            ListView.prototype.release = function () {
                this._scrollMgr.release();
            };
            ///////////////////////////////////////////////////////////////////////
            // Implements: IListView Profile Backup / Restore
            //! 内部データをバックアップ
            ListView.prototype.backup = function (key) {
                return this._scrollMgr.backup(key);
            };
            //! 内部データをリストア
            ListView.prototype.restore = function (key, rebuild) {
                if (rebuild === void 0) { rebuild = true; }
                return this._scrollMgr.restore(key, rebuild);
            };
            //! バックアップデータの有無
            ListView.prototype.hasBackup = function (key) {
                return this._scrollMgr.hasBackup(key);
            };
            //! バックアップデータの破棄
            ListView.prototype.clearBackup = function (key) {
                return this._scrollMgr.clearBackup(key);
            };
            Object.defineProperty(ListView.prototype, "backupData", {
                //! バックアップデータにアクセス
                get: function () {
                    return this._scrollMgr ? this._scrollMgr.backupData : null;
                },
                enumerable: true,
                configurable: true
            });
            ///////////////////////////////////////////////////////////////////////
            // Implements: IListView Scroll
            //! スクロールイベントハンドラ設定/解除
            ListView.prototype.setScrollHandler = function (handler, on) {
                this._scrollMgr.setScrollHandler(handler, on);
            };
            //! スクロール終了イベントハンドラ設定/解除
            ListView.prototype.setScrollStopHandler = function (handler, on) {
                this._scrollMgr.setScrollStopHandler(handler, on);
            };
            //! スクロール位置を取得
            ListView.prototype.getScrollPos = function () {
                return this._scrollMgr.getScrollPos();
            };
            //! スクロール位置の最大値を取得
            ListView.prototype.getScrollPosMax = function () {
                return this._scrollMgr.getScrollPosMax();
            };
            //! スクロール位置を指定
            ListView.prototype.scrollTo = function (pos, animate, time) {
                this._scrollMgr.scrollTo(pos, animate, time);
            };
            //! 指定された ListItemView の表示を保証
            ListView.prototype.ensureVisible = function (index, options) {
                this._scrollMgr.ensureVisible(index, options);
            };
            Object.defineProperty(ListView.prototype, "core", {
                ///////////////////////////////////////////////////////////////////////
                // Implements: IListView Properties
                //! core framework access
                get: function () {
                    return this._scrollMgr;
                },
                enumerable: true,
                configurable: true
            });
            ///////////////////////////////////////////////////////////////////////
            // Implements: IListView Internal I/F
            //! 登録 framework が使用する
            ListView.prototype._addLine = function (_line, insertTo) {
                this._scrollMgr._addLine(_line, insertTo);
            };
            ///////////////////////////////////////////////////////////////////////
            // Implements: IComposableView
            /**
             * すでに定義された Backbone.View を基底クラスに設定し、extend を実行する。
             *
             * @param derives         {Backbone.View|Backbone.View[]} [in] 合成元の View クラス
             * @param properties      {Object}                        [in] prototype プロパティ
             * @param classProperties {Object}                        [in] static プロパティ
             * @return {Backbone.View|Backbone.View[]} 新規に生成された View のコンストラクタ
             */
            ListView.compose = function (derives, properties, classProperties) {
                var composed = UI.composeViews(ListView, derives);
                return composed.extend(properties, classProperties);
            };
            return ListView;
        }(Backbone.View));
        UI.ListView = ListView;
    })(UI = CDP.UI || (CDP.UI = {}));
})(CDP || (CDP = {}));
var CDP;
(function (CDP) {
    var UI;
    (function (UI) {
        var TAG = "[CDP.UI.GroupListItemView] ";
        /**
         * @class GroupListItemView
         * @brief ExpandableListView が扱う ListItem コンテナクラス
         */
        var GroupListItemView = /** @class */ (function (_super) {
            __extends(GroupListItemView, _super);
            /**
             * constructor
             *
             * @param options {GroupLineViewOptions} [in] オプション
             */
            function GroupListItemView(options) {
                var _this = _super.call(this, options) || this;
                _this._groupProfile = null; //!< 管轄の GroupProfile
                _this._groupProfile = options.groupProfile;
                return _this;
            }
            ///////////////////////////////////////////////////////////////////////
            // protected methods
            /**
             * 展開状態を判定
             *
             * @return {Boolean} true: 展開, false:収束
             */
            GroupListItemView.prototype.isExpanded = function () {
                return this._groupProfile.isExpanded();
            };
            //! 展開中か判定
            GroupListItemView.prototype.isExpanding = function () {
                return this.owner.isExpanding();
            };
            //! 収束中か判定
            GroupListItemView.prototype.isCollapsing = function () {
                return this.owner.isCollapsing();
            };
            //! 開閉中か判定
            GroupListItemView.prototype.isSwitching = function () {
                return this.owner.isSwitching();
            };
            //! 子 Group を持っているか判定
            GroupListItemView.prototype.hasChildren = function (layoutKey) {
                return this._groupProfile.hasChildren(layoutKey);
            };
            return GroupListItemView;
        }(UI.ListItemView));
        UI.GroupListItemView = GroupListItemView;
    })(UI = CDP.UI || (CDP.UI = {}));
})(CDP || (CDP = {}));
/* tslint:disable:no-bitwise */
var CDP;
(function (CDP) {
    var UI;
    (function (UI) {
        var TAG = "[CDP.UI.ExpandManager] ";
        /**
         * @class ExpandManager
         * @brief 開閉状態管理クラス
         */
        var ExpandManager = /** @class */ (function () {
            /**
             * constructor
             *
             * @param owner {BaseExpandableListView} [in] 親View のインスタンス
             */
            function ExpandManager(owner) {
                this._owner = null;
                this._mapGroups = {}; //!< {id, GroupProfile} の map
                this._aryTopGroups = []; //!< 第1階層 GroupProfile を格納
                this._layoutKey = null;
                this._owner = owner;
            }
            ///////////////////////////////////////////////////////////////////////
            // Implements: IExpandManager
            /**
             * 新規 GroupProfile を作成
             * 登録済みの場合はそのオブジェクトを返却
             *
             * @parma id {String} [in] 新規に作成する Group ID を指定. 指定しない場合は自動割り振り
             * @return {GroupProfile} GroupProfile インスタンス
             */
            ExpandManager.prototype.newGroup = function (id) {
                var group;
                if (null == id) {
                    id = "group-id:" + ("0000" + (Math.random() * Math.pow(36, 4) << 0).toString(36)).slice(-4);
                }
                if (null != this._mapGroups[id]) {
                    return this._mapGroups[id];
                }
                group = new UI.GroupProfile(id, this._owner);
                this._mapGroups[id] = group;
                return group;
            };
            /**
             * 登録済み Group を取得
             *
             * @parma id {String} [in] 取得する Group ID を指定
             * @return {GroupProfile} GroupProfile インスタンス / null
             */
            ExpandManager.prototype.getGroup = function (id) {
                if (null == this._mapGroups[id]) {
                    console.warn(TAG + "group id: " + id + " is not registered.");
                    return null;
                }
                return this._mapGroups[id];
            };
            /**
             * 第1階層の Group 登録
             *
             * @param topGroup {GroupProfile} [in] 構築済み GroupProfile インスタンス
             */
            ExpandManager.prototype.registerTopGroup = function (topGroup) {
                var lastGroup;
                var insertTo;
                // すでに登録済みの場合は restore して layout キーごとに復元する。
                if ("registered" === topGroup.status) {
                    // TODO: orientation changed 時の layout キー変更対応だが、キーに変更が無いときは不具合となる。
                    // この API に実装が必要かも含めて見直しが必要
                    topGroup.restore();
                    return;
                }
                lastGroup = (0 < this._aryTopGroups.length) ? this._aryTopGroups[this._aryTopGroups.length - 1] : null;
                insertTo = (null != lastGroup) ? lastGroup.getLastLineIndex(true) + 1 : 0;
                if (_.isNaN(insertTo)) {
                    console.error(TAG + "logic error, 'insertTo' is NaN.");
                    return;
                }
                this._aryTopGroups.push(topGroup);
                topGroup.register(insertTo);
            };
            /**
             * 第1階層の Group を取得
             * コピー配列が返されるため、クライアントはキャッシュ不可
             *
             * @return {GroupProfile[]} GroupProfile 配列
             */
            ExpandManager.prototype.getTopGroups = function () {
                return this._aryTopGroups.slice(0);
            };
            //! すべてのグループを展開 (1階層)
            ExpandManager.prototype.expandAll = function () {
                this._aryTopGroups.forEach(function (group) {
                    if (group.hasChildren()) {
                        group.expand();
                    }
                });
            };
            //! すべてのグループを収束 (1階層)
            ExpandManager.prototype.collapseAll = function (delay) {
                this._aryTopGroups.forEach(function (group) {
                    if (group.hasChildren()) {
                        group.collapse(delay);
                    }
                });
            };
            //! 展開中か判定
            ExpandManager.prototype.isExpanding = function () {
                return this._owner.isStatusIn("expanding");
            };
            //! 収束中か判定
            ExpandManager.prototype.isCollapsing = function () {
                return this._owner.isStatusIn("collapsing");
            };
            //! 開閉中か判定
            ExpandManager.prototype.isSwitching = function () {
                return this.isExpanding() || this.isCollapsing();
            };
            //! 状態変数の参照カウントのインクリメント
            ExpandManager.prototype.statusAddRef = function (status) {
                return this._owner.statusAddRef(status);
            };
            //! 状態変数の参照カウントのデクリメント
            ExpandManager.prototype.statusRelease = function (status) {
                return this._owner.statusRelease(status);
            };
            //! 処理スコープ毎に状態変数を設定
            ExpandManager.prototype.statusScope = function (status, callback) {
                this._owner.statusScope(status, callback);
            };
            //! 指定した状態中であるか確認
            ExpandManager.prototype.isStatusIn = function (status) {
                return this._owner.isStatusIn(status);
            };
            Object.defineProperty(ExpandManager.prototype, "layoutKey", {
                //! layout key を取得
                get: function () {
                    return this._layoutKey;
                },
                //! layout key を設定
                set: function (key) {
                    this._layoutKey = key;
                },
                enumerable: true,
                configurable: true
            });
            //! データを破棄
            ExpandManager.prototype.release = function () {
                this._mapGroups = {};
                this._aryTopGroups = [];
            };
            ///////////////////////////////////////////////////////////////////////
            // Implementes: IBackupRestore
            /**
             * 内部データをバックアップ
             *
             * @param key {String} [in] バックアップキーを指定
             * @return {Boolean} true: 成功 / false: 失敗
             */
            ExpandManager.prototype.backup = function (key) {
                var _backup = this.backupData;
                if (null == _backup[key]) {
                    _backup[key] = {
                        map: this._mapGroups,
                        tops: this._aryTopGroups,
                    };
                }
                return true;
            };
            /**
             * 内部データをリストア
             *
             * @param key     {String}  [in] バックアップキーを指定
             * @param rebuild {Boolean} [in] rebuild を実行する場合は true を指定
             * @return {Boolean} true: 成功 / false: 失敗
             */
            ExpandManager.prototype.restore = function (key, rebuild) {
                if (rebuild === void 0) { rebuild = true; }
                var _backup = this.backupData;
                if (null == _backup[key]) {
                    return false;
                }
                if (0 < this._aryTopGroups.length) {
                    this.release();
                }
                this._mapGroups = _backup[key].map;
                this._aryTopGroups = _backup[key].tops;
                // layout 情報の確認
                if (this._aryTopGroups.length <= 0 || !this._aryTopGroups[0].hasLayoutKeyOf(this.layoutKey)) {
                    return false;
                }
                // 展開しているものを登録
                this._aryTopGroups.forEach(function (group) {
                    group.restore();
                });
                // 再構築の予約
                if (rebuild) {
                    this._owner.rebuild();
                }
                return true;
            };
            //! バックアップデータの有無
            ExpandManager.prototype.hasBackup = function (key) {
                return this._owner.hasBackup(key);
            };
            //! バックアップデータの破棄
            ExpandManager.prototype.clearBackup = function (key) {
                return this._owner.clearBackup(key);
            };
            Object.defineProperty(ExpandManager.prototype, "backupData", {
                //! バックアップデータにアクセス
                get: function () {
                    return this._owner.backupData;
                },
                enumerable: true,
                configurable: true
            });
            return ExpandManager;
        }());
        UI.ExpandManager = ExpandManager;
    })(UI = CDP.UI || (CDP.UI = {}));
})(CDP || (CDP = {}));
var CDP;
(function (CDP) {
    var UI;
    (function (UI) {
        var TAG = "[CDP.UI.ExpandableListView] ";
        /**
         * @class ExpandableListView
         * @brief 開閉機能を備えた仮想リストビュークラス
         */
        var ExpandableListView = /** @class */ (function (_super) {
            __extends(ExpandableListView, _super);
            /**
             * constructor
             *
             * @param options {ListViewConstructOptions} [in] オプション
             */
            function ExpandableListView(options) {
                var _this = _super.call(this, options) || this;
                _this._statusMgr = null;
                _this._expandManager = null;
                _this._statusMgr = new UI.StatusManager();
                _this._expandManager = new UI.ExpandManager(_this);
                return _this;
            }
            ///////////////////////////////////////////////////////////////////////
            // Implements: IExpandableListView
            //! 新規 GroupProfile を作成
            ExpandableListView.prototype.newGroup = function (id) {
                return this._expandManager.newGroup(id);
            };
            //! 登録済み Group を取得
            ExpandableListView.prototype.getGroup = function (id) {
                return this._expandManager.getGroup(id);
            };
            //! 第1階層の Group 登録
            ExpandableListView.prototype.registerTopGroup = function (topGroup) {
                this._expandManager.registerTopGroup(topGroup);
            };
            //! 第1階層の Group を取得
            ExpandableListView.prototype.getTopGroups = function () {
                return this._expandManager.getTopGroups();
            };
            //! すべてのグループを展開 (1階層)
            ExpandableListView.prototype.expandAll = function () {
                this._expandManager.expandAll();
            };
            //! すべてのグループを収束 (1階層)
            ExpandableListView.prototype.collapseAll = function (delay) {
                this._expandManager.collapseAll(delay);
            };
            //! 展開中か判定
            ExpandableListView.prototype.isExpanding = function () {
                return this._expandManager.isExpanding();
            };
            //! 収束中か判定
            ExpandableListView.prototype.isCollapsing = function () {
                return this._expandManager.isCollapsing();
            };
            //! 開閉中か判定
            ExpandableListView.prototype.isSwitching = function () {
                return this._expandManager.isSwitching();
            };
            //! 状態変数の参照カウントのインクリメント
            ExpandableListView.prototype.statusAddRef = function (status) {
                return this._statusMgr.statusAddRef(status);
            };
            //! 状態変数の参照カウントのデクリメント
            ExpandableListView.prototype.statusRelease = function (status) {
                return this._statusMgr.statusRelease(status);
            };
            //! 処理スコープ毎に状態変数を設定
            ExpandableListView.prototype.statusScope = function (status, callback) {
                this._statusMgr.statusScope(status, callback);
            };
            //! 指定した状態中であるか確認
            ExpandableListView.prototype.isStatusIn = function (status) {
                return this._statusMgr.isStatusIn(status);
            };
            Object.defineProperty(ExpandableListView.prototype, "layoutKey", {
                //! layout key を取得
                get: function () {
                    return this._expandManager.layoutKey;
                },
                //! layout key を設定
                set: function (key) {
                    this._expandManager.layoutKey = key;
                },
                enumerable: true,
                configurable: true
            });
            ///////////////////////////////////////////////////////////////////////
            // Override: ListView
            //! データを破棄
            ExpandableListView.prototype.release = function () {
                _super.prototype.release.call(this);
                this._expandManager.release();
            };
            //! 内部データをバックアップ
            ExpandableListView.prototype.backup = function (key) {
                return this._expandManager.backup(key);
            };
            //! 内部データをリ