/*global describe, it, after */
'use strict';

var assert = require('assert');
var execFile = require('child_process').execFile;
var fs = require('fs');
var path = require('path');

describe('jpegtran()', function () {
	after(function () {
		fs.unlinkSync('test/minified.jpg');
	});

	it('should return path to jpegtran binary', function (cb) {
		var binPath = require('../lib/jpegtran').path;

		execFile(binPath, ['-v', '-'], function (err, stdout, stderr) {
			assert(stderr.toString().indexOf('libjpeg-turbo') !== -1);
			cb();
		});
	});

	it('should successfully proxy jpegtran', function (cb) {
		var binPath = path.join(__dirname, '../bin/jpegtran.js');

		execFile('node', [binPath, '-v', '-'], function (err, stdout, stderr) {
			assert(stderr.toString().indexOf('libjpeg-turbo') !== -1);
			cb();
		});
	});

	it('should minify a .jpg', function (cb) {
		var binPath = path.join(__dirname, '../bin/jpegtran.js');
		var args = [
			'-copy', 'none',
			'-optimize',
			'-outfile', path.join(__dirname, 'minified.jpg'),
			path.join(__dirname, 'fixtures', 'test.jpg')
		];

		execFile('node', [binPath].concat(args), function () {
			var actual = fs.statSync('test/minified.jpg').size;
			var original = fs.statSync('test/fixtures/test.jpg').size;

			assert(actual < original);
			cb();
		});
	});
});
